error_chain! {
    foreign_links {
        Io(::std::io::Error);
        Utf8(std::str::Utf8Error);
        Regex(regex::Error);
        Json(serde_json::Error);
        Log(log::SetLoggerError);
        CargoBin(assert_cmd::cargo::CargoError);
    }

    errors {
        PathExists(p: std::path::PathBuf) {
            display("path exists: '{}'",p.display())
        }
        PathDoesNotExist(p: std::path::PathBuf) {
            display("path does not exist: '{}'",p.display())
        }
        UnrecognizedCommand(command: String) {
            description("an unrecognized command"),
            display("unrecognized command '{}'",command)
        }
        ShebangNotFound(p: std::path::PathBuf) {
            display("shebang not found for '{}'",p.display())
        }
        IncorrectExitCode(expected_exit_code: i32, message: String) {
            display("expected exit code {} for command\n{}",expected_exit_code,&message)
        }
    }
}
