use indicatif::{ProgressBar, ProgressStyle};
use std::io::{self, Read};
fn main() {
    println!("loop start");
    let spinner = ProgressBar::new_spinner();
    spinner.enable_steady_tick(120);
    spinner.set_style(
        ProgressStyle::default_spinner()
            .tick_strings(&[
                "▰▱▱▱▱▱▱",
                "▰▰▱▱▱▱▱",
                "▰▰▰▱▱▱▱",
                "▰▰▰▰▱▱▱",
                "▰▰▰▰▰▱▱",
                "▰▰▰▰▰▰▱",
                "▰▰▰▰▰▰▰",
                "▰▱▱▱▱▱▱",
            ])
            .template("{spinner:.green} {msg}"),
    );
    spinner.set_message("infinite loop, press ENTER to stop...");
    let mut buffer = Vec::new();
    //io::stdin().read(&mut buffer).unwrap();
    loop {
        std::thread::sleep(std::time::Duration::new(0, 1000));
        io::stdin().read(&mut buffer).unwrap();
        if buffer.len() > 0 {
            break;
        }
    }
    spinner.finish_with_message("done");
    println!("loop finish");
}
