use reef::{Command, Paths};

fn main() {
    let path = Paths::docs().join("cache-test");
    if path.exists() {
        Paths::clobber(&path).unwrap();
    }
    std::fs::create_dir_all(&path).unwrap();

    let url = "https://gitlab.com/gems-rb/raykit.git";
    println!("url: {}", url);

    let clone = Command::new(&format!("git clone {} raykit.git", url))
        .directory(&path)
        .exec();
    println!("{:#?}", &clone);

    let raykit = path.join("raykit.git");
    assert!(raykit.exists(), "{} does not exist", raykit.display());

    let pull = Command::new("git pull").directory(&raykit).exec();
    println!("{:#?}", &pull);

    let log = Command::new("git log -1 --oneline")
        .directory(&raykit)
        .exec();
    println!("{:#?}", &log);

    Paths::clobber(&path).unwrap();
}
