use reef::duration;
use std::time::Duration;

fn main() {
    println!("37.5 seconds: {:?}", &Duration::new(37, 500000000));
    println!("1.5 minutes: {:?}", &Duration::new(90, 0));
    println!("custom formatting");
    println!("{}", duration::format(&Duration::new(0, 1000))); //   1µs
    println!("{}", duration::format(&Duration::new(0, 5000))); //   5µs
    println!("{}", duration::format(&Duration::new(0, 10000))); //  10µs
    println!("{}", duration::format(&Duration::new(0, 50000))); //  50µs
    println!("{}", duration::format(&Duration::new(0, 100000))); // 100µs
    println!("{}", duration::format(&Duration::new(0, 500000))); // 100µs
    println!("{}", duration::format(&Duration::new(0, 1000000))); //   1ms
    println!("{}", duration::format(&Duration::new(0, 5000000))); //   5ms
    println!("{}", duration::format(&Duration::new(0, 10000000))); //  10ms
    println!("{}", duration::format(&Duration::new(0, 50000000))); //  50ms
    println!("{}", duration::format(&Duration::new(0, 100000000))); // 100ms
    println!("{}", duration::format(&Duration::new(0, 500000000))); // 500ms
    println!("{}", duration::format(&Duration::new(1, 0))); //    1s
    println!("{}", duration::format(&Duration::new(5, 0))); //    5s
    println!("{}", duration::format(&Duration::new(10, 0))); //   10s
    println!("{}", duration::format(&Duration::new(50, 0))); //   50s
    println!("{}", duration::format(&Duration::new(60, 0))); //    1.0m
    println!("{}", duration::format(&Duration::new(90, 0))); //    1.5m
    println!("{}", duration::format(&Duration::new(210, 0))); //    3.5m
    println!("{}", duration::format(&Duration::new(300, 0))); //    5m
    println!("{}", duration::format(&Duration::new(3000, 0))); //    50m
    println!("{}", duration::format(&Duration::new(6000, 0))); //    1h
    println!("{}", duration::format(&Duration::new(12000, 0))); //    3h
    println!("{}", duration::format(&Duration::new(86400, 0))); //    1d
    println!("{}", duration::format(&Duration::new(432000, 0))); //    5d
    println!("{}", duration::format(&Duration::new(1728000, 0))); //    20d
    println!("{}", duration::format(&Duration::new(3728000, 0))); //    20d
                                                                  //pub fn format(duration: &std::time::Duration) -> String {
}
