use reef::{Command, Paths};

fn main() {
    let rakefile_path = std::env::temp_dir().join("rakefile.rb");
    std::fs::write(&rakefile_path, "task :default do\n puts 'hello rake'\nend").unwrap();

    let which_ruby = Paths::which("ruby").unwrap();
    println!("which ruby: {}", which_ruby.display());

    let which_rake = Paths::which("rake").unwrap();
    println!("which rake: {}", which_rake.display());

    let rake = Command::new("rake default")
        .directory(&std::env::temp_dir())
        .exec()
        //.exec_in(&std::env::temp_dir())
        .unwrap();

    println!("{}", rake);
}
