ix!();

use crate::{
    RedzoneKick,
    RedzoneClap,
    RedzoneBass,
};

///---------------------
#[derive(Default)]
pub struct Redzone {
    pub kick: RedzoneKick,
    pub clap: RedzoneClap,
    pub bass: RedzoneBass,
}

pub enum RedzoneMarker {
    WashIntro,
    TightIntro,
    BassIntro,
    WashOutro,
    TightOutro,
    BassOutro,
    FirstBassMain,
    SecondBassMain,
    FirstBuild,
    SecondBuild,
}

impl Play for Redzone {
    fn play(&mut self) {
        self.kick.play();
        self.clap.play();
        self.bass.play();
    }
}

impl PlayAt for Redzone {

    type Marker = RedzoneMarker;

    fn play_at(&mut self, marker: Self::Marker) {
        match marker {
            RedzoneMarker::WashIntro      => self.wash_intro(),
            RedzoneMarker::TightIntro     => self.tight_intro(),
            RedzoneMarker::BassIntro      => self.bass_intro(),
            RedzoneMarker::WashOutro      => self.wash_outro(),
            RedzoneMarker::TightOutro     => self.tight_outro(),
            RedzoneMarker::BassOutro      => self.bass_outro(),
            RedzoneMarker::FirstBassMain  => self.first_bass_main(),
            RedzoneMarker::SecondBassMain => self.second_bass_main(),
            RedzoneMarker::FirstBuild     => self.first_build(),
            RedzoneMarker::SecondBuild    => self.second_build(),
        }
    }
}

pub fn intro() {
    let mut rz = Redzone::default();
    rz.play_at(RedzoneMarker::WashIntro);
}

pub fn second_build() {
    let mut rz = Redzone::default();
    rz.play_at(RedzoneMarker::SecondBuild);
}

pub fn wash_outro() {
    let mut rz = Redzone::default();
    rz.play_at(RedzoneMarker::WashOutro);
}

