ix!();

use crate::{
    SequencerEvent,
};

#[derive(Default)]
pub struct Sequencer {
    pending_events: Vec<Box<SequencerEvent>>,
}

impl Sequencer {
    pub fn schedule_event(&mut self, ev: SequencerEvent) {
        self.pending_events.push(Box::new(ev))
    }
    pub fn run(&mut self) {

        let mut bar = 0;

        for ev in self.pending_events.iter_mut() {
            match &**ev {
                SequencerEvent::RunLambda{ routine } => {
                    (routine)()
                },
                SequencerEvent::PlayEvent{ 
                    routine, start, bars
                } => {
                    while bar < *bars {
                        if bar == 0 {
                            if let Some(start) = start {
                                (start)();
                            }
                        }
                        (routine)();
                        bar += 1;
                    }
                    bar = 0;
                }
            }
        }

        self.pending_events.clear();
    }
}

