#![allow(unused_imports)]
#![allow(dead_code)]
#![feature(box_syntax)]

mod imports;
mod traits;

macro_rules! x { ($x:ident) => { mod $x; pub use $x::*; } }
macro_rules! ix { 
    () => { 
        use crate::{ 
            imports::* , 
            traits::* , 
        };

    } 
}

x!{kick}
x!{clap}
x!{bass}
x!{song}
x!{arrangement}
x!{wash_intro}
x!{wash_outro}
x!{tight_intro}
x!{tight_outro}
x!{bass_intro}
x!{bass_outro}
x!{first_build}
x!{second_build}
x!{first_bass_main}
x!{second_bass_main}
x!{sequencer}
x!{sequencer_event}

pub fn play_redzone() {
    use soloud::*;
    let sl = Soloud::default().unwrap();
    let mut wav = audio::Wav::default();
    wav.load_mem(include_bytes!("../redzone_v8.mp3")).unwrap();
    sl.play(&wav);
    while sl.voice_count() > 0 {
        std::thread::sleep(std::time::Duration::from_millis(100));
    }
}
