ix!();

use crate::{
    Sequencer,
    SequencerEvent,
    intro,
    second_build,
    wash_outro,
};

pub struct Arrangement {
    name:     &'static str,
    schedule: Vec<SequencerEvent>,
}

impl Sequencer {

    fn schedule_arrangement(&mut self, x: Arrangement) {

        let name = x.name.clone();

        println!("scheduling: {:?}",name);

        self.schedule_event(SequencerEvent::RunLambda{ 
            routine: Arc::new(move || {
                println!("activate arrangement {:?}", name);
            })
        });

        for ev in x.schedule.iter() {
            self.schedule_event(ev.clone());
        }
    }
}

fn arr0() -> Arrangement {
    Arrangement {
        name: "first take",
        schedule: vec!{
            SequencerEvent::PlayEvent {
                start:   Some(|| {
                    println!("--------------------------[Scene Change: intro]");
                }),
                routine: intro,
                bars: 4,
            },
            SequencerEvent::PlayEvent {
                start:   Some(|| {
                    println!("--------------------------[Scene Change: second_build]");
                }),
                routine: second_build,
                bars: 2,
            },
            SequencerEvent::PlayEvent {
                start:   Some(|| {
                    println!("--------------------------[Scene Change: wash_outro]");
                }),
                routine: wash_outro,
                bars: 4,
            },
        }
    }
}

fn arr1() -> Arrangement {
    Arrangement {
        name: "take two",
        schedule: vec!{
            SequencerEvent::PlayEvent {
                start:   Some(|| {
                    println!("--------------------------[Scene Change: wash_outro]");
                }),
                routine: wash_outro,
                bars: 8,
            },
        }
    }
}

#[test] fn basic_arrangements() {

    let mut sq = Sequencer::default();
    sq.schedule_arrangement(arr1());
    sq.schedule_arrangement(arr0());
    sq.run();
}

