#![warn(clippy::all, clippy::pedantic, rust_2018_idioms, missing_docs)]
#![allow(clippy::expl_impl_clone_on_copy)]

//! Wrapper types for secret data that should not show up in logs.
//!
//! These types deref to, and pass through many standard library traits of, the underlying type, but
//! have unconditional [`Debug`](std::fmt::Debug) and [`Display`](std::fmt::Display) implementations
//! that redact their contents.

mod array;
mod basic;
mod bytes;

#[doc(inline)]
pub use array::RedactedArray;
#[doc(inline)]
pub use basic::Redacted;
#[doc(inline)]
pub use bytes::RedactedBytes;
