#![cfg(feature = "impl_chachapoly")]

mod types;

use types::{ Key, ByteRecordId, ByteRecord, Ciphertext };
use recordbox::{ RecordboxChachaPoly, traits::FastRecordbox };


#[test]
fn test() {
    // The test vectors
    let test_vectors: Vec<(Key, ByteRecordId, ByteRecord, Ciphertext)> = vec![
        (
            Key::from_hex("9a97f65b9b4c721b960a672145fca8d4e32e67f9111ea979ce9c4826806aeee6"),
            ByteRecordId::from_hex("000000003de9c0da2bd7f91e"),
            ByteRecord::from_hex(""),
            Ciphertext::from_hex("5a6e21f4ba6dbee57380e79e79c30def")
        ),
        (
            Key::from_hex("79474fbd2ec3982c5cf51bff4240619d27186f2c22ca972ef04f1d6330ea0277"),
            ByteRecordId::from_hex("b72ddd761b791eb14a17a57a"),
            ByteRecord::from_hex("ff54b84133a004988f2300bcb91bdf907bdb14547ea0eb407686ff1bfeb1ec5bca763ab3620f53d9af35ca347a2e493ad3095a5eefe5c500f06b46a5c6855df1fb0c95471fdc2de9d291752941774c89f841610bd804d20152bb062856a437033c4dab8251cebf7f9ec1fbb6009ed3d74ed62af82ac3ce6b3eca4a5cb17880e3687e1790166ed5e9280e10926b090dad5c7aced1e5131db1c4236352721094fcd52b5b21ad8d8e67e4c6d595ec6c46cb397760ec05db75a5b49f9100cdd6c3c7578fa6fed9b3a80998d9248f7d12e69b888196ff4b6fe4ba09156c0edd24036fed87fcc716b806ea52"),
            Ciphertext::from_hex("e1e9c436cbfaa4a979e1875394860db9f716b4f7997a46769113a6bda9dd594016d66ff539e24238ca1e17feddbf67ab6ad9edce909d4b840a7f63504170ddc41d018295f8491df8c4a304ed5a6a9a47f51b46b1a02b4b9f02d767794da79ee32b55d7a4507c6bdf8ac49f441b70166e287a816b085eff67b42ee23e56a1158e0fd6e612a92b489b7574fab22a8ae029c439487f9fedbbea214ccd039be16c3402942cf6b2fc9233459ee2d33b324c4a01fd0fbf66ce292f7cee82b11060caa708dcb49383ea541d725b2ff4fb94255a232781d56936ca49252fe5e61c6e3ae534e3e3902d2adf52501d0da526ed974e68bd31eb219d8a998f")
        )
    ];

    // Test the test vectors
    for (key, nonce, plaintext_org, ciphertext_org) in test_vectors {
        // Seal the plaintext
        let recordbox = RecordboxChachaPoly::new(key).expect("Failed to generate `recordbox` instance");
        let ciphertext = recordbox.seal(plaintext_org.clone(), nonce.clone()).expect("Failed to seal plaintext");
        assert_eq!(ciphertext.as_slice(), ciphertext_org.as_slice(), "Invalid ciphertext");

        // Open the ciphertext
        let plaintext: ByteRecord = recordbox.open(ciphertext, nonce).expect("Failed to open ciphertext");
        assert_eq!(plaintext.as_slice(), plaintext_org.as_slice(), "Invalid plaintext");
    }
}
