#![cfg(feature = "random")]

/// A simple function to test the uniform distribution of byte values to catch an all-zero array or similar results of an
/// API misuse.
///
/// _Important: This function *does not* attempt to test the randomness of the OS' CSPRNG_
fn test_uniform_dist(buf: &[u8]) {
    // Count the occurrences of each byte
	let mut occurrences = vec![0f64; 256];
	buf.iter().for_each(|b| occurrences[*b as usize] += 1.0);
	
    // Validate that the occurrences are uniformly distributed
	let expected_occurrences = (buf.len() as f64) / 256.0;
	occurrences.iter().for_each(|o| {
		assert!(*o > expected_occurrences * 0.9);
		assert!(*o < expected_occurrences * 1.1);
	});
}


#[test]
fn test() {
    // The amount of random bytes to collect
    let test_sizes = [
        1 * 1024 * 1024,
        4 * 1024 * 1024,
        4 * 1024 * 1024 + 15
    ];

    // Perform eight iterations for each size
	for _ in 0..8 {
		for size in test_sizes.iter() {
			let buf = recordbox::random::get(*size);
			test_uniform_dist(&buf)
		}
	}
}


#[test]
#[should_panic]
fn test_test_uniform_dist() {
    let all_zero = vec![0; 1 * 1024 * 1024];
	test_uniform_dist(&all_zero);
}