//! Implements an API to gather cryptographically secure random bytes

#![cfg(feature = "random")]

use crypto_api_osrandom::{ OsRandom, crypto_api::rng::SecureRng };


/// Copies `buf.len()`  bytes of cryptographically secure data into `buf` 
pub fn copy(buf: &mut[u8]) {
    OsRandom.random(buf).expect("Failed to collect cryptographically secure random bytes");
}


/// Gets `len` bytes of cryptographically secure data
pub fn get(len: usize) -> Vec<u8> {
    let mut buf = vec![0; len];
    copy(&mut buf);
    buf
}