use wasm_bindgen::closure::Closure;
use wasm_bindgen::JsCast;
use wasm_bindgen::convert::FromWasmAbi;

pub mod js;
pub mod console;

#[doc = "Helper function for creating an element"]
pub fn element(name: &str, content: &str, attributes: &[(&str, &str)]) -> String {
    let attrs: Vec<String> = attributes.into_iter()
        .map(|x| format!("{}=\"{}\"", x.0, x.1.replace("\"", "\\\""))).collect();
    format!(
        "<{} {}>{}</{}>",
        name, attrs.join(","), content, name)
}

#[doc = "Helper function for setting the innerHTML for an element"]
pub fn set_from_id(id: &str, content: &str) {
    get_from_id(id)
        .expect(&format!("No element named {} found", id)).set_inner_html(content);
}

#[doc = "Helper function for getting an element"]
pub fn get_from_id(id: &str) -> Option<js::Element> {
    js::window().document().expect("No document found").get_element_by_id(id)
}
