/* automatically generated by rust-bindgen 0.57.0 */

pub const RS2_PRODUCT_LINE_ANY: u32 = 255;
pub const RS2_PRODUCT_LINE_ANY_INTEL: u32 = 254;
pub const RS2_PRODUCT_LINE_NON_INTEL: u32 = 1;
pub const RS2_PRODUCT_LINE_D400: u32 = 2;
pub const RS2_PRODUCT_LINE_SR300: u32 = 4;
pub const RS2_PRODUCT_LINE_L500: u32 = 8;
pub const RS2_PRODUCT_LINE_T200: u32 = 16;
pub const RS2_PRODUCT_LINE_DEPTH: u32 = 14;
pub const RS2_PRODUCT_LINE_TRACKING: u32 = 16;
pub const RS2_UNSIGNED_UPDATE_MODE_UPDATE: u32 = 0;
pub const RS2_UNSIGNED_UPDATE_MODE_READ_ONLY: u32 = 1;
pub const RS2_UNSIGNED_UPDATE_MODE_FULL: u32 = 2;
pub const RS2_API_MAJOR_VERSION: u32 = 2;
pub const RS2_API_MINOR_VERSION: u32 = 47;
pub const RS2_API_PATCH_VERSION: u32 = 0;
pub const RS2_API_BUILD_VERSION: u32 = 0;
pub const RS2_API_VERSION: u32 = 24700;
pub const RS2_DEFAULT_TIMEOUT: u32 = 15000;
#[doc = "< Frames didn't arrived within 5 seconds"]
pub const rs2_notification_category_RS2_NOTIFICATION_CATEGORY_FRAMES_TIMEOUT:
    rs2_notification_category = 0;
#[doc = "< Received partial/incomplete frame"]
pub const rs2_notification_category_RS2_NOTIFICATION_CATEGORY_FRAME_CORRUPTED:
    rs2_notification_category = 1;
#[doc = "< Error reported from the device"]
pub const rs2_notification_category_RS2_NOTIFICATION_CATEGORY_HARDWARE_ERROR:
    rs2_notification_category = 2;
#[doc = "< General Hardeware notification that is not an error"]
pub const rs2_notification_category_RS2_NOTIFICATION_CATEGORY_HARDWARE_EVENT:
    rs2_notification_category = 3;
#[doc = "< Received unknown error from the device"]
pub const rs2_notification_category_RS2_NOTIFICATION_CATEGORY_UNKNOWN_ERROR:
    rs2_notification_category = 4;
#[doc = "< Current firmware version installed is not the latest available"]
pub const rs2_notification_category_RS2_NOTIFICATION_CATEGORY_FIRMWARE_UPDATE_RECOMMENDED:
    rs2_notification_category = 5;
#[doc = "< A relocalization event has updated the pose provided by a pose sensor"]
pub const rs2_notification_category_RS2_NOTIFICATION_CATEGORY_POSE_RELOCALIZATION:
    rs2_notification_category = 6;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_notification_category_RS2_NOTIFICATION_CATEGORY_COUNT: rs2_notification_category = 7;
#[doc = " \\brief Category of the librealsense notification."]
pub type rs2_notification_category = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_notification_category_to_string(
        category: rs2_notification_category,
    ) -> *const ::std::os::raw::c_char;
}
pub const rs2_exception_type_RS2_EXCEPTION_TYPE_UNKNOWN: rs2_exception_type = 0;
#[doc = "< Device was disconnected, this can be caused by outside intervention, by internal firmware error or due to insufficient power"]
pub const rs2_exception_type_RS2_EXCEPTION_TYPE_CAMERA_DISCONNECTED: rs2_exception_type = 1;
#[doc = "< Error was returned from the underlying OS-specific layer"]
pub const rs2_exception_type_RS2_EXCEPTION_TYPE_BACKEND: rs2_exception_type = 2;
#[doc = "< Invalid value was passed to the API"]
pub const rs2_exception_type_RS2_EXCEPTION_TYPE_INVALID_VALUE: rs2_exception_type = 3;
#[doc = "< Function precondition was violated"]
pub const rs2_exception_type_RS2_EXCEPTION_TYPE_WRONG_API_CALL_SEQUENCE: rs2_exception_type = 4;
#[doc = "< The method is not implemented at this point"]
pub const rs2_exception_type_RS2_EXCEPTION_TYPE_NOT_IMPLEMENTED: rs2_exception_type = 5;
#[doc = "< Device is in recovery mode and might require firmware update"]
pub const rs2_exception_type_RS2_EXCEPTION_TYPE_DEVICE_IN_RECOVERY_MODE: rs2_exception_type = 6;
#[doc = "< IO Device failure"]
pub const rs2_exception_type_RS2_EXCEPTION_TYPE_IO: rs2_exception_type = 7;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_exception_type_RS2_EXCEPTION_TYPE_COUNT: rs2_exception_type = 8;
#[doc = " \\brief Exception types are the different categories of errors that RealSense API might return."]
pub type rs2_exception_type = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_exception_type_to_string(type_: rs2_exception_type)
        -> *const ::std::os::raw::c_char;
}
#[doc = "< Rectilinear images. No distortion compensation required."]
pub const rs2_distortion_RS2_DISTORTION_NONE: rs2_distortion = 0;
#[doc = "< Equivalent to Brown-Conrady distortion, except that tangential distortion is applied to radially distorted points"]
pub const rs2_distortion_RS2_DISTORTION_MODIFIED_BROWN_CONRADY: rs2_distortion = 1;
#[doc = "< Equivalent to Brown-Conrady distortion, except undistorts image instead of distorting it"]
pub const rs2_distortion_RS2_DISTORTION_INVERSE_BROWN_CONRADY: rs2_distortion = 2;
#[doc = "< F-Theta fish-eye distortion model"]
pub const rs2_distortion_RS2_DISTORTION_FTHETA: rs2_distortion = 3;
#[doc = "< Unmodified Brown-Conrady distortion model"]
pub const rs2_distortion_RS2_DISTORTION_BROWN_CONRADY: rs2_distortion = 4;
#[doc = "< Four parameter Kannala Brandt distortion model"]
pub const rs2_distortion_RS2_DISTORTION_KANNALA_BRANDT4: rs2_distortion = 5;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_distortion_RS2_DISTORTION_COUNT: rs2_distortion = 6;
#[doc = " \\brief Distortion model: defines how pixel coordinates should be mapped to sensor coordinates."]
pub type rs2_distortion = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_distortion_to_string(distortion: rs2_distortion) -> *const ::std::os::raw::c_char;
}
#[doc = " \\brief Video stream intrinsics."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_intrinsics {
    #[doc = "< Width of the image in pixels"]
    pub width: ::std::os::raw::c_int,
    #[doc = "< Height of the image in pixels"]
    pub height: ::std::os::raw::c_int,
    #[doc = "< Horizontal coordinate of the principal point of the image, as a pixel offset from the left edge"]
    pub ppx: f32,
    #[doc = "< Vertical coordinate of the principal point of the image, as a pixel offset from the top edge"]
    pub ppy: f32,
    #[doc = "< Focal length of the image plane, as a multiple of pixel width"]
    pub fx: f32,
    #[doc = "< Focal length of the image plane, as a multiple of pixel height"]
    pub fy: f32,
    #[doc = "< Distortion model of the image"]
    pub model: rs2_distortion,
    #[doc = "< Distortion coefficients. Order for Brown-Conrady: [k1, k2, p1, p2, k3]. Order for F-Theta Fish-eye: [k1, k2, k3, k4, 0]. Other models are subject to their own interpretations"]
    pub coeffs: [f32; 5usize],
}
#[test]
fn bindgen_test_layout_rs2_intrinsics() {
    assert_eq!(
        ::std::mem::size_of::<rs2_intrinsics>(),
        48usize,
        concat!("Size of: ", stringify!(rs2_intrinsics))
    );
    assert_eq!(
        ::std::mem::align_of::<rs2_intrinsics>(),
        4usize,
        concat!("Alignment of ", stringify!(rs2_intrinsics))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_intrinsics>())).width as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_intrinsics),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_intrinsics>())).height as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_intrinsics),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_intrinsics>())).ppx as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_intrinsics),
            "::",
            stringify!(ppx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_intrinsics>())).ppy as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_intrinsics),
            "::",
            stringify!(ppy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_intrinsics>())).fx as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_intrinsics),
            "::",
            stringify!(fx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_intrinsics>())).fy as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_intrinsics),
            "::",
            stringify!(fy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_intrinsics>())).model as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_intrinsics),
            "::",
            stringify!(model)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_intrinsics>())).coeffs as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_intrinsics),
            "::",
            stringify!(coeffs)
        )
    );
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_dsm_params {
    #[doc = "< system_clock::time_point::time_since_epoch().count()"]
    pub timestamp: ::std::os::raw::c_ulonglong,
    #[doc = "< MAJOR<<12 | MINOR<<4 | PATCH"]
    pub version: ::std::os::raw::c_ushort,
    #[doc = "< rs2_dsm_correction_model"]
    pub model: ::std::os::raw::c_uchar,
    #[doc = "< TBD, now 0s"]
    pub flags: [::std::os::raw::c_uchar; 5usize],
    #[doc = "< the scale factor to horizontal DSM scale thermal results"]
    pub h_scale: f32,
    #[doc = "< the scale factor to vertical DSM scale thermal results"]
    pub v_scale: f32,
    #[doc = "< the offset to horizontal DSM offset thermal results"]
    pub h_offset: f32,
    #[doc = "< the offset to vertical DSM offset thermal results"]
    pub v_offset: f32,
    #[doc = "< the offset to the Round-Trip-Distance delay thermal results"]
    pub rtd_offset: f32,
    #[doc = "< the temperature recorded times 2 (ldd for depth; hum for rgb)"]
    pub temp_x2: ::std::os::raw::c_uchar,
    #[doc = "< the scale factor to horizontal LOS coefficients in MC"]
    pub mc_h_scale: f32,
    #[doc = "< the scale factor to vertical LOS coefficients in MC"]
    pub mc_v_scale: f32,
    #[doc = "< time (in weeks) since factory calibration"]
    pub weeks_since_calibration: ::std::os::raw::c_uchar,
    #[doc = "< time (in weeks) between factory calibration and last AC event"]
    pub ac_weeks_since_calibaration: ::std::os::raw::c_uchar,
    pub reserved: [::std::os::raw::c_uchar; 1usize],
}
#[test]
fn bindgen_test_layout_rs2_dsm_params() {
    assert_eq!(
        ::std::mem::size_of::<rs2_dsm_params>(),
        48usize,
        concat!("Size of: ", stringify!(rs2_dsm_params))
    );
    assert_eq!(
        ::std::mem::align_of::<rs2_dsm_params>(),
        1usize,
        concat!("Alignment of ", stringify!(rs2_dsm_params))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).timestamp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).version as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).model as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(model)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).flags as *const _ as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).h_scale as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(h_scale)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).v_scale as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(v_scale)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).h_offset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(h_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).v_offset as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(v_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).rtd_offset as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(rtd_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).temp_x2 as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(temp_x2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).mc_h_scale as *const _ as usize },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(mc_h_scale)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).mc_v_scale as *const _ as usize },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(mc_v_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rs2_dsm_params>())).weeks_since_calibration as *const _ as usize
        },
        45usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(weeks_since_calibration)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rs2_dsm_params>())).ac_weeks_since_calibaration as *const _
                as usize
        },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(ac_weeks_since_calibaration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_dsm_params>())).reserved as *const _ as usize },
        47usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_dsm_params),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = "< hFactor and hOffset are not used, and no artificial error is induced"]
pub const rs2_dsm_correction_model_RS2_DSM_CORRECTION_NONE: rs2_dsm_correction_model = 0;
#[doc = "< Aging-over-thermal (default); aging-induced error is uniform across temperature"]
pub const rs2_dsm_correction_model_RS2_DSM_CORRECTION_AOT: rs2_dsm_correction_model = 1;
#[doc = "< Thermal-over-aging; aging-induced error changes alongside temperature"]
pub const rs2_dsm_correction_model_RS2_DSM_CORRECTION_TOA: rs2_dsm_correction_model = 2;
pub const rs2_dsm_correction_model_RS2_DSM_CORRECTION_COUNT: rs2_dsm_correction_model = 3;
pub type rs2_dsm_correction_model = ::std::os::raw::c_uint;
#[doc = " \\brief Motion device intrinsics: scale, bias, and variances."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_motion_device_intrinsic {
    #[doc = "< Interpret data array values"]
    pub data: [[f32; 4usize]; 3usize],
    #[doc = "< Variance of noise for X, Y, and Z axis"]
    pub noise_variances: [f32; 3usize],
    #[doc = "< Variance of bias for X, Y, and Z axis"]
    pub bias_variances: [f32; 3usize],
}
#[test]
fn bindgen_test_layout_rs2_motion_device_intrinsic() {
    assert_eq!(
        ::std::mem::size_of::<rs2_motion_device_intrinsic>(),
        72usize,
        concat!("Size of: ", stringify!(rs2_motion_device_intrinsic))
    );
    assert_eq!(
        ::std::mem::align_of::<rs2_motion_device_intrinsic>(),
        4usize,
        concat!("Alignment of ", stringify!(rs2_motion_device_intrinsic))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rs2_motion_device_intrinsic>())).data as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_motion_device_intrinsic),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rs2_motion_device_intrinsic>())).noise_variances as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_motion_device_intrinsic),
            "::",
            stringify!(noise_variances)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rs2_motion_device_intrinsic>())).bias_variances as *const _
                as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_motion_device_intrinsic),
            "::",
            stringify!(bias_variances)
        )
    );
}
#[doc = " \\brief 3D coordinates with origin at topmost left corner of the lense,"]
#[doc = "with positive Z pointing away from the camera, positive X pointing camera right and positive Y pointing camera down"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_vertex {
    pub xyz: [f32; 3usize],
}
#[test]
fn bindgen_test_layout_rs2_vertex() {
    assert_eq!(
        ::std::mem::size_of::<rs2_vertex>(),
        12usize,
        concat!("Size of: ", stringify!(rs2_vertex))
    );
    assert_eq!(
        ::std::mem::align_of::<rs2_vertex>(),
        4usize,
        concat!("Alignment of ", stringify!(rs2_vertex))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_vertex>())).xyz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_vertex),
            "::",
            stringify!(xyz)
        )
    );
}
#[doc = " \\brief Pixel location within 2D image. (0,0) is the topmost, left corner. Positive X is right, positive Y is down"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_pixel {
    pub ij: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout_rs2_pixel() {
    assert_eq!(
        ::std::mem::size_of::<rs2_pixel>(),
        8usize,
        concat!("Size of: ", stringify!(rs2_pixel))
    );
    assert_eq!(
        ::std::mem::align_of::<rs2_pixel>(),
        4usize,
        concat!("Alignment of ", stringify!(rs2_pixel))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_pixel>())).ij as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_pixel),
            "::",
            stringify!(ij)
        )
    );
}
#[doc = " \\brief 3D vector in Euclidean coordinate space"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_vector {
    pub x: f32,
    pub y: f32,
    pub z: f32,
}
#[test]
fn bindgen_test_layout_rs2_vector() {
    assert_eq!(
        ::std::mem::size_of::<rs2_vector>(),
        12usize,
        concat!("Size of: ", stringify!(rs2_vector))
    );
    assert_eq!(
        ::std::mem::align_of::<rs2_vector>(),
        4usize,
        concat!("Alignment of ", stringify!(rs2_vector))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_vector>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_vector),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_vector>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_vector),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_vector>())).z as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_vector),
            "::",
            stringify!(z)
        )
    );
}
#[doc = " \\brief Quaternion used to represent rotation"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_quaternion {
    pub x: f32,
    pub y: f32,
    pub z: f32,
    pub w: f32,
}
#[test]
fn bindgen_test_layout_rs2_quaternion() {
    assert_eq!(
        ::std::mem::size_of::<rs2_quaternion>(),
        16usize,
        concat!("Size of: ", stringify!(rs2_quaternion))
    );
    assert_eq!(
        ::std::mem::align_of::<rs2_quaternion>(),
        4usize,
        concat!("Alignment of ", stringify!(rs2_quaternion))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_quaternion>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_quaternion),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_quaternion>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_quaternion),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_quaternion>())).z as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_quaternion),
            "::",
            stringify!(z)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_quaternion>())).w as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_quaternion),
            "::",
            stringify!(w)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_pose {
    #[doc = "< X, Y, Z values of translation, in meters (relative to initial position)"]
    pub translation: rs2_vector,
    #[doc = "< X, Y, Z values of velocity, in meters/sec"]
    pub velocity: rs2_vector,
    #[doc = "< X, Y, Z values of acceleration, in meters/sec^2"]
    pub acceleration: rs2_vector,
    #[doc = "< Qi, Qj, Qk, Qr components of rotation as represented in quaternion rotation (relative to initial position)"]
    pub rotation: rs2_quaternion,
    #[doc = "< X, Y, Z values of angular velocity, in radians/sec"]
    pub angular_velocity: rs2_vector,
    #[doc = "< X, Y, Z values of angular acceleration, in radians/sec^2"]
    pub angular_acceleration: rs2_vector,
    #[doc = "< Pose confidence 0x0 - Failed, 0x1 - Low, 0x2 - Medium, 0x3 - High"]
    pub tracker_confidence: ::std::os::raw::c_uint,
    #[doc = "< Pose map confidence 0x0 - Failed, 0x1 - Low, 0x2 - Medium, 0x3 - High"]
    pub mapper_confidence: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_rs2_pose() {
    assert_eq!(
        ::std::mem::size_of::<rs2_pose>(),
        84usize,
        concat!("Size of: ", stringify!(rs2_pose))
    );
    assert_eq!(
        ::std::mem::align_of::<rs2_pose>(),
        4usize,
        concat!("Alignment of ", stringify!(rs2_pose))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_pose>())).translation as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_pose),
            "::",
            stringify!(translation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_pose>())).velocity as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_pose),
            "::",
            stringify!(velocity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_pose>())).acceleration as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_pose),
            "::",
            stringify!(acceleration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_pose>())).rotation as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_pose),
            "::",
            stringify!(rotation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_pose>())).angular_velocity as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_pose),
            "::",
            stringify!(angular_velocity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_pose>())).angular_acceleration as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_pose),
            "::",
            stringify!(angular_acceleration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_pose>())).tracker_confidence as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_pose),
            "::",
            stringify!(tracker_confidence)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_pose>())).mapper_confidence as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_pose),
            "::",
            stringify!(mapper_confidence)
        )
    );
}
#[doc = "< Detailed information about ordinary operations"]
pub const rs2_log_severity_RS2_LOG_SEVERITY_DEBUG: rs2_log_severity = 0;
#[doc = "< Terse information about ordinary operations"]
pub const rs2_log_severity_RS2_LOG_SEVERITY_INFO: rs2_log_severity = 1;
#[doc = "< Indication of possible failure"]
pub const rs2_log_severity_RS2_LOG_SEVERITY_WARN: rs2_log_severity = 2;
#[doc = "< Indication of definite failure"]
pub const rs2_log_severity_RS2_LOG_SEVERITY_ERROR: rs2_log_severity = 3;
#[doc = "< Indication of unrecoverable failure"]
pub const rs2_log_severity_RS2_LOG_SEVERITY_FATAL: rs2_log_severity = 4;
#[doc = "< No logging will occur"]
pub const rs2_log_severity_RS2_LOG_SEVERITY_NONE: rs2_log_severity = 5;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_log_severity_RS2_LOG_SEVERITY_COUNT: rs2_log_severity = 6;
#[doc = "< Include any/all log messages"]
pub const rs2_log_severity_RS2_LOG_SEVERITY_ALL: rs2_log_severity = 0;
#[doc = " \\brief Severity of the librealsense logger."]
pub type rs2_log_severity = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_log_severity_to_string(info: rs2_log_severity) -> *const ::std::os::raw::c_char;
}
pub const rs2_extension_RS2_EXTENSION_UNKNOWN: rs2_extension = 0;
pub const rs2_extension_RS2_EXTENSION_DEBUG: rs2_extension = 1;
pub const rs2_extension_RS2_EXTENSION_INFO: rs2_extension = 2;
pub const rs2_extension_RS2_EXTENSION_MOTION: rs2_extension = 3;
pub const rs2_extension_RS2_EXTENSION_OPTIONS: rs2_extension = 4;
pub const rs2_extension_RS2_EXTENSION_VIDEO: rs2_extension = 5;
pub const rs2_extension_RS2_EXTENSION_ROI: rs2_extension = 6;
pub const rs2_extension_RS2_EXTENSION_DEPTH_SENSOR: rs2_extension = 7;
pub const rs2_extension_RS2_EXTENSION_VIDEO_FRAME: rs2_extension = 8;
pub const rs2_extension_RS2_EXTENSION_MOTION_FRAME: rs2_extension = 9;
pub const rs2_extension_RS2_EXTENSION_COMPOSITE_FRAME: rs2_extension = 10;
pub const rs2_extension_RS2_EXTENSION_POINTS: rs2_extension = 11;
pub const rs2_extension_RS2_EXTENSION_DEPTH_FRAME: rs2_extension = 12;
pub const rs2_extension_RS2_EXTENSION_ADVANCED_MODE: rs2_extension = 13;
pub const rs2_extension_RS2_EXTENSION_RECORD: rs2_extension = 14;
pub const rs2_extension_RS2_EXTENSION_VIDEO_PROFILE: rs2_extension = 15;
pub const rs2_extension_RS2_EXTENSION_PLAYBACK: rs2_extension = 16;
pub const rs2_extension_RS2_EXTENSION_DEPTH_STEREO_SENSOR: rs2_extension = 17;
pub const rs2_extension_RS2_EXTENSION_DISPARITY_FRAME: rs2_extension = 18;
pub const rs2_extension_RS2_EXTENSION_MOTION_PROFILE: rs2_extension = 19;
pub const rs2_extension_RS2_EXTENSION_POSE_FRAME: rs2_extension = 20;
pub const rs2_extension_RS2_EXTENSION_POSE_PROFILE: rs2_extension = 21;
pub const rs2_extension_RS2_EXTENSION_TM2: rs2_extension = 22;
pub const rs2_extension_RS2_EXTENSION_SOFTWARE_DEVICE: rs2_extension = 23;
pub const rs2_extension_RS2_EXTENSION_SOFTWARE_SENSOR: rs2_extension = 24;
pub const rs2_extension_RS2_EXTENSION_DECIMATION_FILTER: rs2_extension = 25;
pub const rs2_extension_RS2_EXTENSION_THRESHOLD_FILTER: rs2_extension = 26;
pub const rs2_extension_RS2_EXTENSION_DISPARITY_FILTER: rs2_extension = 27;
pub const rs2_extension_RS2_EXTENSION_SPATIAL_FILTER: rs2_extension = 28;
pub const rs2_extension_RS2_EXTENSION_TEMPORAL_FILTER: rs2_extension = 29;
pub const rs2_extension_RS2_EXTENSION_HOLE_FILLING_FILTER: rs2_extension = 30;
pub const rs2_extension_RS2_EXTENSION_ZERO_ORDER_FILTER: rs2_extension = 31;
pub const rs2_extension_RS2_EXTENSION_RECOMMENDED_FILTERS: rs2_extension = 32;
pub const rs2_extension_RS2_EXTENSION_POSE: rs2_extension = 33;
pub const rs2_extension_RS2_EXTENSION_POSE_SENSOR: rs2_extension = 34;
pub const rs2_extension_RS2_EXTENSION_WHEEL_ODOMETER: rs2_extension = 35;
pub const rs2_extension_RS2_EXTENSION_GLOBAL_TIMER: rs2_extension = 36;
pub const rs2_extension_RS2_EXTENSION_UPDATABLE: rs2_extension = 37;
pub const rs2_extension_RS2_EXTENSION_UPDATE_DEVICE: rs2_extension = 38;
pub const rs2_extension_RS2_EXTENSION_L500_DEPTH_SENSOR: rs2_extension = 39;
pub const rs2_extension_RS2_EXTENSION_TM2_SENSOR: rs2_extension = 40;
pub const rs2_extension_RS2_EXTENSION_AUTO_CALIBRATED_DEVICE: rs2_extension = 41;
pub const rs2_extension_RS2_EXTENSION_COLOR_SENSOR: rs2_extension = 42;
pub const rs2_extension_RS2_EXTENSION_MOTION_SENSOR: rs2_extension = 43;
pub const rs2_extension_RS2_EXTENSION_FISHEYE_SENSOR: rs2_extension = 44;
pub const rs2_extension_RS2_EXTENSION_DEPTH_HUFFMAN_DECODER: rs2_extension = 45;
pub const rs2_extension_RS2_EXTENSION_SERIALIZABLE: rs2_extension = 46;
pub const rs2_extension_RS2_EXTENSION_FW_LOGGER: rs2_extension = 47;
pub const rs2_extension_RS2_EXTENSION_AUTO_CALIBRATION_FILTER: rs2_extension = 48;
pub const rs2_extension_RS2_EXTENSION_DEVICE_CALIBRATION: rs2_extension = 49;
pub const rs2_extension_RS2_EXTENSION_CALIBRATED_SENSOR: rs2_extension = 50;
pub const rs2_extension_RS2_EXTENSION_HDR_MERGE: rs2_extension = 51;
pub const rs2_extension_RS2_EXTENSION_SEQUENCE_ID_FILTER: rs2_extension = 52;
pub const rs2_extension_RS2_EXTENSION_MAX_USABLE_RANGE_SENSOR: rs2_extension = 53;
pub const rs2_extension_RS2_EXTENSION_DEBUG_STREAM_SENSOR: rs2_extension = 54;
pub const rs2_extension_RS2_EXTENSION_CALIBRATION_CHANGE_DEVICE: rs2_extension = 55;
pub const rs2_extension_RS2_EXTENSION_COUNT: rs2_extension = 56;
#[doc = " \\brief Specifies advanced interfaces (capabilities) objects may implement."]
pub type rs2_extension = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_extension_type_to_string(type_: rs2_extension) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rs2_extension_to_string(type_: rs2_extension) -> *const ::std::os::raw::c_char;
}
pub const rs2_matchers_RS2_MATCHER_DI: rs2_matchers = 0;
pub const rs2_matchers_RS2_MATCHER_DI_C: rs2_matchers = 1;
pub const rs2_matchers_RS2_MATCHER_DLR_C: rs2_matchers = 2;
pub const rs2_matchers_RS2_MATCHER_DLR: rs2_matchers = 3;
pub const rs2_matchers_RS2_MATCHER_DIC: rs2_matchers = 4;
pub const rs2_matchers_RS2_MATCHER_DIC_C: rs2_matchers = 5;
pub const rs2_matchers_RS2_MATCHER_DEFAULT: rs2_matchers = 6;
pub const rs2_matchers_RS2_MATCHER_COUNT: rs2_matchers = 7;
#[doc = " \\brief Specifies types of different matchers"]
pub type rs2_matchers = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_device_info {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_device {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_error {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_log_message {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_raw_data_buffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_frame {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_frame_queue {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_pipeline {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_pipeline_profile {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_config {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_device_list {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_stream_profile_list {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_processing_block_list {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_stream_profile {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_frame_callback {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_log_callback {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_syncer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_device_serializer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_source {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_processing_block {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_frame_processor_callback {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_playback_status_changed_callback {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_update_progress_callback {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_context {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_device_hub {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_sensor_list {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_sensor {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_options {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_options_list {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_devices_changed_callback {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_notification {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_notifications_callback {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_firmware_log_message {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_firmware_log_parsed_message {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_firmware_log_parser {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_terminal_parser {
    _unused: [u8; 0],
}
pub type rs2_log_callback_ptr = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: rs2_log_severity,
        arg2: *const rs2_log_message,
        arg: *mut ::std::os::raw::c_void,
    ),
>;
pub type rs2_notification_callback_ptr = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut rs2_notification, arg2: *mut ::std::os::raw::c_void),
>;
pub type rs2_software_device_destruction_callback_ptr =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
pub type rs2_devices_changed_callback_ptr = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut rs2_device_list,
        arg2: *mut rs2_device_list,
        arg3: *mut ::std::os::raw::c_void,
    ),
>;
pub type rs2_frame_callback_ptr = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut rs2_frame, arg2: *mut ::std::os::raw::c_void),
>;
pub type rs2_frame_processor_callback_ptr = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut rs2_frame,
        arg2: *mut rs2_source,
        arg3: *mut ::std::os::raw::c_void,
    ),
>;
pub type rs2_update_progress_callback_ptr =
    ::std::option::Option<unsafe extern "C" fn(arg1: f32, arg2: *mut ::std::os::raw::c_void)>;
pub type rs2_time_t = f64;
pub type rs2_metadata_type = ::std::os::raw::c_longlong;
extern "C" {
    pub fn rs2_create_error(
        what: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        args: *const ::std::os::raw::c_char,
        type_: rs2_exception_type,
    ) -> *mut rs2_error;
}
extern "C" {
    pub fn rs2_get_librealsense_exception_type(error: *const rs2_error) -> rs2_exception_type;
}
extern "C" {
    pub fn rs2_get_failed_function(error: *const rs2_error) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rs2_get_failed_args(error: *const rs2_error) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rs2_get_error_message(error: *const rs2_error) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rs2_free_error(error: *mut rs2_error);
}
extern "C" {
    #[doc = " \\brief Creates RealSense context that is required for the rest of the API."]
    #[doc = " \\param[in] api_version Users are expected to pass their version of \\c RS2_API_VERSION to make sure they are running the correct librealsense version."]
    #[doc = " \\param[out] error  If non-null, receives any error that occurs during this call, otherwise, errors are ignored."]
    #[doc = " \\return            Context object"]
    pub fn rs2_create_context(
        api_version: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_context;
}
extern "C" {
    #[doc = " \\brief Frees the relevant context object."]
    #[doc = " \\param[in] context Object that is no longer needed"]
    pub fn rs2_delete_context(context: *mut rs2_context);
}
extern "C" {
    #[doc = " set callback to get devices changed events"]
    #[doc = " these events will be raised by the context whenever new RealSense device is connected or existing device gets disconnected"]
    #[doc = " \\param context     Object representing librealsense session"]
    #[doc = " \\param[in] callback callback object created from c++ application. ownership over the callback object is moved into the context"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_set_devices_changed_callback_cpp(
        context: *mut rs2_context,
        callback: *mut rs2_devices_changed_callback,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " set callback to get devices changed events"]
    #[doc = " these events will be raised by the context whenever new RealSense device is connected or existing device gets disconnected"]
    #[doc = " \\param context     Object representing librealsense session"]
    #[doc = " \\param[in] callback function pointer to register as per-notifications callback"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_set_devices_changed_callback(
        context: *const rs2_context,
        callback: rs2_devices_changed_callback_ptr,
        user: *mut ::std::os::raw::c_void,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Create a new device and add it to the context"]
    #[doc = " \\param ctx   The context to which the new device will be added"]
    #[doc = " \\param file  The file from which the device should be created"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " @return  A pointer to a device that plays data from the file, or null in case of failure"]
    pub fn rs2_context_add_device(
        ctx: *mut rs2_context,
        file: *const ::std::os::raw::c_char,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_device;
}
extern "C" {
    #[doc = " Add an instance of software device to the context"]
    #[doc = " \\param ctx   The context to which the new device will be added"]
    #[doc = " \\param dev   Instance of software device to register into the context"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_context_add_software_device(
        ctx: *mut rs2_context,
        dev: *mut rs2_device,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Removes a playback device from the context, if exists"]
    #[doc = " \\param[in]  ctx       The context from which the device should be removed"]
    #[doc = " \\param[in]  file      The file name that was used to add the device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_context_remove_device(
        ctx: *mut rs2_context,
        file: *const ::std::os::raw::c_char,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Removes tracking module."]
    #[doc = " function query_devices() locks the tracking module in the tm_context object."]
    #[doc = " If the tracking module device is not used it should be removed using this function, so that other applications could find it."]
    #[doc = " This function can be used both before the call to query_device() to prevent enabling tracking modules or afterwards to"]
    #[doc = " release them."]
    pub fn rs2_context_unload_tracking_module(ctx: *mut rs2_context, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " create a static snapshot of all connected devices at the time of the call"]
    #[doc = " \\param context     Object representing librealsense session"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            the list of devices, should be released by rs2_delete_device_list"]
    pub fn rs2_query_devices(
        context: *const rs2_context,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_device_list;
}
extern "C" {
    #[doc = " create a static snapshot of all connected devices at the time of the call"]
    #[doc = " \\param context     Object representing librealsense session"]
    #[doc = " \\param product_mask Controls what kind of devices will be returned"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            the list of devices, should be released by rs2_delete_device_list"]
    pub fn rs2_query_devices_ex(
        context: *const rs2_context,
        product_mask: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_device_list;
}
extern "C" {
    #[doc = " \\brief Creates RealSense device_hub ."]
    #[doc = " \\param[in] context The context for the device hub"]
    #[doc = " \\param[out] error  If non-null, receives any error that occurs during this call, otherwise, errors are ignored."]
    #[doc = " \\return            Device hub object"]
    pub fn rs2_create_device_hub(
        context: *const rs2_context,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_device_hub;
}
extern "C" {
    #[doc = " \\brief Frees the relevant device hub object."]
    #[doc = " \\param[in] hub Object that is no longer needed"]
    pub fn rs2_delete_device_hub(hub: *const rs2_device_hub);
}
extern "C" {
    #[doc = " If any device is connected return it, otherwise wait until next RealSense device connects."]
    #[doc = " Calling this method multiple times will cycle through connected devices"]
    #[doc = " \\param[in] ctx The context to creat the device"]
    #[doc = " \\param[in] hub The device hub object"]
    #[doc = " \\param[out] error  If non-null, receives any error that occurs during this call, otherwise, errors are ignored."]
    #[doc = " \\return            device object"]
    pub fn rs2_device_hub_wait_for_device(
        hub: *const rs2_device_hub,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_device;
}
extern "C" {
    #[doc = " Checks if device is still connected"]
    #[doc = " \\param[in] hub The device hub object"]
    #[doc = " \\param[in] device The device"]
    #[doc = " \\param[out] error  If non-null, receives any error that occurs during this call, otherwise, errors are ignored."]
    #[doc = " \\return            1 if the device is connected, 0 otherwise"]
    pub fn rs2_device_hub_is_device_connected(
        hub: *const rs2_device_hub,
        device: *const rs2_device,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
#[doc = "< Friendly name"]
pub const rs2_camera_info_RS2_CAMERA_INFO_NAME: rs2_camera_info = 0;
#[doc = "< Device serial number"]
pub const rs2_camera_info_RS2_CAMERA_INFO_SERIAL_NUMBER: rs2_camera_info = 1;
#[doc = "< Primary firmware version"]
pub const rs2_camera_info_RS2_CAMERA_INFO_FIRMWARE_VERSION: rs2_camera_info = 2;
#[doc = "< Recommended firmware version"]
pub const rs2_camera_info_RS2_CAMERA_INFO_RECOMMENDED_FIRMWARE_VERSION: rs2_camera_info = 3;
#[doc = "< Unique identifier of the port the device is connected to (platform specific)"]
pub const rs2_camera_info_RS2_CAMERA_INFO_PHYSICAL_PORT: rs2_camera_info = 4;
#[doc = "< If device supports firmware logging, this is the command to send to get logs from firmware"]
pub const rs2_camera_info_RS2_CAMERA_INFO_DEBUG_OP_CODE: rs2_camera_info = 5;
#[doc = "< True iff the device is in advanced mode"]
pub const rs2_camera_info_RS2_CAMERA_INFO_ADVANCED_MODE: rs2_camera_info = 6;
#[doc = "< Product ID as reported in the USB descriptor"]
pub const rs2_camera_info_RS2_CAMERA_INFO_PRODUCT_ID: rs2_camera_info = 7;
#[doc = "< True iff EEPROM is locked"]
pub const rs2_camera_info_RS2_CAMERA_INFO_CAMERA_LOCKED: rs2_camera_info = 8;
#[doc = "< Designated USB specification: USB2/USB3"]
pub const rs2_camera_info_RS2_CAMERA_INFO_USB_TYPE_DESCRIPTOR: rs2_camera_info = 9;
#[doc = "< Device product line D400/SR300/L500/T200"]
pub const rs2_camera_info_RS2_CAMERA_INFO_PRODUCT_LINE: rs2_camera_info = 10;
#[doc = "< ASIC serial number"]
pub const rs2_camera_info_RS2_CAMERA_INFO_ASIC_SERIAL_NUMBER: rs2_camera_info = 11;
#[doc = "< Firmware update ID"]
pub const rs2_camera_info_RS2_CAMERA_INFO_FIRMWARE_UPDATE_ID: rs2_camera_info = 12;
#[doc = "< IP address for remote camera."]
pub const rs2_camera_info_RS2_CAMERA_INFO_IP_ADDRESS: rs2_camera_info = 13;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_camera_info_RS2_CAMERA_INFO_COUNT: rs2_camera_info = 14;
#[doc = " \\brief Read-only strings that can be queried from the device."]
#[doc = "Not all information attributes are available on all camera types."]
#[doc = "This information is mainly available for camera debug and troubleshooting and should not be used in applications."]
pub type rs2_camera_info = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_camera_info_to_string(info: rs2_camera_info) -> *const ::std::os::raw::c_char;
}
pub const rs2_stream_RS2_STREAM_ANY: rs2_stream = 0;
#[doc = "< Native stream of depth data produced by RealSense device"]
pub const rs2_stream_RS2_STREAM_DEPTH: rs2_stream = 1;
#[doc = "< Native stream of color data captured by RealSense device"]
pub const rs2_stream_RS2_STREAM_COLOR: rs2_stream = 2;
#[doc = "< Native stream of infrared data captured by RealSense device"]
pub const rs2_stream_RS2_STREAM_INFRARED: rs2_stream = 3;
#[doc = "< Native stream of fish-eye (wide) data captured from the dedicate motion camera"]
pub const rs2_stream_RS2_STREAM_FISHEYE: rs2_stream = 4;
#[doc = "< Native stream of gyroscope motion data produced by RealSense device"]
pub const rs2_stream_RS2_STREAM_GYRO: rs2_stream = 5;
#[doc = "< Native stream of accelerometer motion data produced by RealSense device"]
pub const rs2_stream_RS2_STREAM_ACCEL: rs2_stream = 6;
#[doc = "< Signals from external device connected through GPIO"]
pub const rs2_stream_RS2_STREAM_GPIO: rs2_stream = 7;
#[doc = "< 6 Degrees of Freedom pose data, calculated by RealSense device"]
pub const rs2_stream_RS2_STREAM_POSE: rs2_stream = 8;
#[doc = "< 4 bit per-pixel depth confidence level"]
pub const rs2_stream_RS2_STREAM_CONFIDENCE: rs2_stream = 9;
pub const rs2_stream_RS2_STREAM_COUNT: rs2_stream = 10;
#[doc = " \\brief Streams are different types of data provided by RealSense devices."]
pub type rs2_stream = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_stream_to_string(stream: rs2_stream) -> *const ::std::os::raw::c_char;
}
#[doc = "< When passed to enable stream, librealsense will try to provide best suited format"]
pub const rs2_format_RS2_FORMAT_ANY: rs2_format = 0;
#[doc = "< 16-bit linear depth values. The depth is meters is equal to depth scale * pixel value."]
pub const rs2_format_RS2_FORMAT_Z16: rs2_format = 1;
#[doc = "< 16-bit float-point disparity values. Depth->Disparity conversion : Disparity = Baseline*FocalLength/Depth."]
pub const rs2_format_RS2_FORMAT_DISPARITY16: rs2_format = 2;
#[doc = "< 32-bit floating point 3D coordinates."]
pub const rs2_format_RS2_FORMAT_XYZ32F: rs2_format = 3;
#[doc = "< 32-bit y0, u, y1, v data for every two pixels. Similar to YUV422 but packed in a different order - https://en.wikipedia.org/wiki/YUV"]
pub const rs2_format_RS2_FORMAT_YUYV: rs2_format = 4;
#[doc = "< 8-bit red, green and blue channels"]
pub const rs2_format_RS2_FORMAT_RGB8: rs2_format = 5;
#[doc = "< 8-bit blue, green, and red channels -- suitable for OpenCV"]
pub const rs2_format_RS2_FORMAT_BGR8: rs2_format = 6;
#[doc = "< 8-bit red, green and blue channels + constant alpha channel equal to FF"]
pub const rs2_format_RS2_FORMAT_RGBA8: rs2_format = 7;
#[doc = "< 8-bit blue, green, and red channels + constant alpha channel equal to FF"]
pub const rs2_format_RS2_FORMAT_BGRA8: rs2_format = 8;
#[doc = "< 8-bit per-pixel grayscale image"]
pub const rs2_format_RS2_FORMAT_Y8: rs2_format = 9;
#[doc = "< 16-bit per-pixel grayscale image"]
pub const rs2_format_RS2_FORMAT_Y16: rs2_format = 10;
#[doc = "< Four 10 bits per pixel luminance values packed into a 5-byte macropixel"]
pub const rs2_format_RS2_FORMAT_RAW10: rs2_format = 11;
#[doc = "< 16-bit raw image"]
pub const rs2_format_RS2_FORMAT_RAW16: rs2_format = 12;
#[doc = "< 8-bit raw image"]
pub const rs2_format_RS2_FORMAT_RAW8: rs2_format = 13;
#[doc = "< Similar to the standard YUYV pixel format, but packed in a different order"]
pub const rs2_format_RS2_FORMAT_UYVY: rs2_format = 14;
#[doc = "< Raw data from the motion sensor"]
pub const rs2_format_RS2_FORMAT_MOTION_RAW: rs2_format = 15;
#[doc = "< Motion data packed as 3 32-bit float values, for X, Y, and Z axis"]
pub const rs2_format_RS2_FORMAT_MOTION_XYZ32F: rs2_format = 16;
#[doc = "< Raw data from the external sensors hooked to one of the GPIO's"]
pub const rs2_format_RS2_FORMAT_GPIO_RAW: rs2_format = 17;
#[doc = "< Pose data packed as floats array, containing translation vector, rotation quaternion and prediction velocities and accelerations vectors"]
pub const rs2_format_RS2_FORMAT_6DOF: rs2_format = 18;
#[doc = "< 32-bit float-point disparity values. Depth->Disparity conversion : Disparity = Baseline*FocalLength/Depth"]
pub const rs2_format_RS2_FORMAT_DISPARITY32: rs2_format = 19;
#[doc = "< 16-bit per-pixel grayscale image unpacked from 10 bits per pixel packed ([8:8:8:8:2222]) grey-scale image. The data is unpacked to LSB and padded with 6 zero bits"]
pub const rs2_format_RS2_FORMAT_Y10BPACK: rs2_format = 20;
#[doc = "< 32-bit float-point depth distance value."]
pub const rs2_format_RS2_FORMAT_DISTANCE: rs2_format = 21;
#[doc = "< Bitstream encoding for video in which an image of each frame is encoded as JPEG-DIB"]
pub const rs2_format_RS2_FORMAT_MJPEG: rs2_format = 22;
#[doc = "< 8-bit per pixel interleaved. 8-bit left, 8-bit right."]
pub const rs2_format_RS2_FORMAT_Y8I: rs2_format = 23;
#[doc = "< 12-bit per pixel interleaved. 12-bit left, 12-bit right. Each pixel is stored in a 24-bit word in little-endian order."]
pub const rs2_format_RS2_FORMAT_Y12I: rs2_format = 24;
#[doc = "< multi-planar Depth 16bit + IR 10bit."]
pub const rs2_format_RS2_FORMAT_INZI: rs2_format = 25;
#[doc = "< 8-bit IR stream."]
pub const rs2_format_RS2_FORMAT_INVI: rs2_format = 26;
#[doc = "< Grey-scale image as a bit-packed array. 4 pixel data stream taking 5 bytes"]
pub const rs2_format_RS2_FORMAT_W10: rs2_format = 27;
#[doc = "< Variable-length Huffman-compressed 16-bit depth values."]
pub const rs2_format_RS2_FORMAT_Z16H: rs2_format = 28;
#[doc = "< 16-bit per-pixel frame grabber format."]
pub const rs2_format_RS2_FORMAT_FG: rs2_format = 29;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_format_RS2_FORMAT_COUNT: rs2_format = 30;
#[doc = " \\brief A stream's format identifies how binary data is encoded within a frame."]
pub type rs2_format = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_format_to_string(format: rs2_format) -> *const ::std::os::raw::c_char;
}
#[doc = " \\brief Cross-stream extrinsics: encodes the topology describing how the different devices are oriented."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_extrinsics {
    #[doc = "< Column-major 3x3 rotation matrix"]
    pub rotation: [f32; 9usize],
    #[doc = "< Three-element translation vector, in meters"]
    pub translation: [f32; 3usize],
}
#[test]
fn bindgen_test_layout_rs2_extrinsics() {
    assert_eq!(
        ::std::mem::size_of::<rs2_extrinsics>(),
        48usize,
        concat!("Size of: ", stringify!(rs2_extrinsics))
    );
    assert_eq!(
        ::std::mem::align_of::<rs2_extrinsics>(),
        4usize,
        concat!("Alignment of ", stringify!(rs2_extrinsics))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_extrinsics>())).rotation as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_extrinsics),
            "::",
            stringify!(rotation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rs2_extrinsics>())).translation as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(rs2_extrinsics),
            "::",
            stringify!(translation)
        )
    );
}
extern "C" {
    #[doc = " Deletes sensors list, any sensors created from this list will remain unaffected"]
    #[doc = " \\param[in] info_list list to delete"]
    pub fn rs2_delete_sensor_list(info_list: *mut rs2_sensor_list);
}
extern "C" {
    #[doc = " Determines number of sensors in a list"]
    #[doc = " \\param[in] info_list The list of connected sensors captured using rs2_query_sensors"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            Sensors count"]
    pub fn rs2_get_sensors_count(
        info_list: *const rs2_sensor_list,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " delete relasense sensor"]
    #[doc = " \\param[in] sensor realsense sensor to delete"]
    pub fn rs2_delete_sensor(sensor: *mut rs2_sensor);
}
extern "C" {
    #[doc = " create sensor by index"]
    #[doc = " \\param[in] index   the zero based index of sensor to retrieve"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            the requested sensor, should be released by rs2_delete_sensor"]
    pub fn rs2_create_sensor(
        list: *const rs2_sensor_list,
        index: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_sensor;
}
extern "C" {
    #[doc = " This is a helper function allowing the user to discover the device from one of its sensors"]
    #[doc = " \\param[in] sensor     Pointer to a sensor"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               new device wrapper for the device of the sensor. Needs to be released by delete_device"]
    pub fn rs2_create_device_from_sensor(
        sensor: *const rs2_sensor,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_device;
}
extern "C" {
    #[doc = " retrieve sensor specific information, like versions of various internal components"]
    #[doc = " \\param[in] sensor     the RealSense sensor"]
    #[doc = " \\param[in] info       camera info type to retrieve"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               the requested camera info string, in a format specific to the device model"]
    pub fn rs2_get_sensor_info(
        sensor: *const rs2_sensor,
        info: rs2_camera_info,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " check if specific sensor info is supported"]
    #[doc = " \\param[in] info    the parameter to check for support"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                true if the parameter both exist and well-defined for the specific device"]
    pub fn rs2_supports_sensor_info(
        sensor: *const rs2_sensor,
        info: rs2_camera_info,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Test if the given sensor can be extended to the requested extension"]
    #[doc = " \\param[in] sensor  Realsense sensor"]
    #[doc = " \\param[in] extension The extension to which the sensor should be tested if it is extendable"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return non-zero value iff the sensor can be extended to the given extension"]
    pub fn rs2_is_sensor_extendable_to(
        sensor: *const rs2_sensor,
        extension: rs2_extension,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " When called on a depth sensor, this method will return the number of meters represented by a single depth unit"]
    #[doc = " \\param[in] sensor      depth sensor"]
    #[doc = " \\param[out] error      if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                the number of meters represented by a single depth unit"]
    pub fn rs2_get_depth_scale(sensor: *mut rs2_sensor, error: *mut *mut rs2_error) -> f32;
}
extern "C" {
    #[doc = " Retrieve the stereoscopic baseline value from frame. Applicable to stereo-based depth modules"]
    #[doc = " \\param[out] float  Stereoscopic baseline in millimeters"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_depth_stereo_frame_get_baseline(
        frame_ref: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> f32;
}
extern "C" {
    #[doc = " Retrieve the stereoscopic baseline value from sensor. Applicable to stereo-based depth modules"]
    #[doc = " \\param[out] float  Stereoscopic baseline in millimeters"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_stereo_baseline(sensor: *mut rs2_sensor, error: *mut *mut rs2_error) -> f32;
}
extern "C" {
    #[doc = " \\brief sets the active region of interest to be used by auto-exposure algorithm"]
    #[doc = " \\param[in] sensor     the RealSense sensor"]
    #[doc = " \\param[in] min_x      lower horizontal bound in pixels"]
    #[doc = " \\param[in] min_y      lower vertical bound in pixels"]
    #[doc = " \\param[in] max_x      upper horizontal bound in pixels"]
    #[doc = " \\param[in] max_y      upper vertical bound in pixels"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_set_region_of_interest(
        sensor: *const rs2_sensor,
        min_x: ::std::os::raw::c_int,
        min_y: ::std::os::raw::c_int,
        max_x: ::std::os::raw::c_int,
        max_y: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " \\brief gets the active region of interest to be used by auto-exposure algorithm"]
    #[doc = " \\param[in] sensor     the RealSense sensor"]
    #[doc = " \\param[out] min_x     lower horizontal bound in pixels"]
    #[doc = " \\param[out] min_y     lower vertical bound in pixels"]
    #[doc = " \\param[out] max_x     upper horizontal bound in pixels"]
    #[doc = " \\param[out] max_y     upper vertical bound in pixels"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_region_of_interest(
        sensor: *const rs2_sensor,
        min_x: *mut ::std::os::raw::c_int,
        min_y: *mut ::std::os::raw::c_int,
        max_x: *mut ::std::os::raw::c_int,
        max_y: *mut ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " open subdevice for exclusive access, by committing to a configuration"]
    #[doc = " \\param[in] device relevant RealSense device"]
    #[doc = " \\param[in] profile    stream profile that defines single stream configuration"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_open(
        device: *mut rs2_sensor,
        profile: *const rs2_stream_profile,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " open subdevice for exclusive access, by committing to composite configuration, specifying one or more stream profiles"]
    #[doc = " this method should be used for interdependent  streams, such as depth and infrared, that have to be configured together"]
    #[doc = " \\param[in] device relevant RealSense device"]
    #[doc = " \\param[in] profiles  list of stream profiles discovered by get_stream_profiles"]
    #[doc = " \\param[in] count      number of simultaneous  stream profiles to configure"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_open_multiple(
        device: *mut rs2_sensor,
        profiles: *mut *const rs2_stream_profile,
        count: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " stop any streaming from specified subdevice"]
    #[doc = " \\param[in] sensor     RealSense device"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_close(sensor: *const rs2_sensor, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " start streaming from specified configured sensor"]
    #[doc = " \\param[in] sensor  RealSense device"]
    #[doc = " \\param[in] on_frame function pointer to register as per-frame callback"]
    #[doc = " \\param[in] user auxiliary  data the user wishes to receive together with every frame callback"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_start(
        sensor: *const rs2_sensor,
        on_frame: rs2_frame_callback_ptr,
        user: *mut ::std::os::raw::c_void,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " start streaming from specified configured sensor"]
    #[doc = " \\param[in] sensor  RealSense device"]
    #[doc = " \\param[in] callback callback object created from c++ application. ownership over the callback object is moved into the relevant streaming lock"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_start_cpp(
        sensor: *const rs2_sensor,
        callback: *mut rs2_frame_callback,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " start streaming from specified configured sensor of specific stream to frame queue"]
    #[doc = " \\param[in] sensor  RealSense Sensor"]
    #[doc = " \\param[in] queue   frame-queue to store new frames into"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_start_queue(
        sensor: *const rs2_sensor,
        queue: *mut rs2_frame_queue,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " stops streaming from specified configured device"]
    #[doc = " \\param[in] sensor  RealSense sensor"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_stop(sensor: *const rs2_sensor, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " set callback to get notifications from specified sensor"]
    #[doc = " \\param[in] sensor          RealSense device"]
    #[doc = " \\param[in] on_notification function pointer to register as per-notifications callback"]
    #[doc = " \\param[out] error          if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_set_notifications_callback(
        sensor: *const rs2_sensor,
        on_notification: rs2_notification_callback_ptr,
        user: *mut ::std::os::raw::c_void,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " set callback to get notifications from specified device"]
    #[doc = " \\param[in] sensor  RealSense sensor"]
    #[doc = " \\param[in] callback callback object created from c++ application. ownership over the callback object is moved into the relevant subdevice lock"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_set_notifications_callback_cpp(
        sensor: *const rs2_sensor,
        callback: *mut rs2_notifications_callback,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " retrieve description from notification handle"]
    #[doc = " \\param[in] notification      handle returned from a callback"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            the notification description"]
    pub fn rs2_get_notification_description(
        notification: *mut rs2_notification,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " retrieve timestamp from notification handle"]
    #[doc = " \\param[in] notification      handle returned from a callback"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            the notification timestamp"]
    pub fn rs2_get_notification_timestamp(
        notification: *mut rs2_notification,
        error: *mut *mut rs2_error,
    ) -> rs2_time_t;
}
extern "C" {
    #[doc = " retrieve severity from notification handle"]
    #[doc = " \\param[in] notification      handle returned from a callback"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            the notification severity"]
    pub fn rs2_get_notification_severity(
        notification: *mut rs2_notification,
        error: *mut *mut rs2_error,
    ) -> rs2_log_severity;
}
extern "C" {
    #[doc = " retrieve category from notification handle"]
    #[doc = " \\param[in] notification      handle returned from a callback"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            the notification category"]
    pub fn rs2_get_notification_category(
        notification: *mut rs2_notification,
        error: *mut *mut rs2_error,
    ) -> rs2_notification_category;
}
extern "C" {
    #[doc = " retrieve serialized data from notification handle"]
    #[doc = " \\param[in] notification      handle returned from a callback"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            the serialized data (in JSON format)"]
    pub fn rs2_get_notification_serialized_data(
        notification: *mut rs2_notification,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " check if physical subdevice is supported"]
    #[doc = " \\param[in] sensor  input RealSense subdevice"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            list of stream profiles that given subdevice can provide, should be released by rs2_delete_profiles_list"]
    pub fn rs2_get_stream_profiles(
        sensor: *mut rs2_sensor,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_stream_profile_list;
}
extern "C" {
    #[doc = " retrieve list of debug stream profiles that given subdevice can provide"]
    #[doc = " \\param[in] sensor  input RealSense subdevice"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            list of debug stream profiles that given subdevice can provide, should be released by rs2_delete_profiles_list"]
    pub fn rs2_get_debug_stream_profiles(
        sensor: *mut rs2_sensor,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_stream_profile_list;
}
extern "C" {
    #[doc = " check how subdevice is streaming"]
    #[doc = " \\param[in] sensor  input RealSense subdevice"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            list of stream profiles that given subdevice is currently streaming, should be released by rs2_delete_profiles_list"]
    pub fn rs2_get_active_streams(
        sensor: *mut rs2_sensor,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_stream_profile_list;
}
extern "C" {
    #[doc = " Get pointer to specific stream profile"]
    #[doc = " \\param[in] list        the list of supported profiles returned by rs2_get_supported_profiles"]
    #[doc = " \\param[in] index       the zero based index of the streaming mode"]
    #[doc = " \\param[out] error      if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_stream_profile(
        list: *const rs2_stream_profile_list,
        index: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *const rs2_stream_profile;
}
extern "C" {
    #[doc = " Extract common parameters of a stream profiles"]
    #[doc = " \\param[in] mode        input stream profile"]
    #[doc = " \\param[out] stream     stream type of the input profile"]
    #[doc = " \\param[out] format     binary data format of the input profile"]
    #[doc = " \\param[out] index      stream index the input profile in case there are multiple streams of the same type"]
    #[doc = " \\param[out] unique_id  identifier for the stream profile, unique within the application"]
    #[doc = " \\param[out] framerate  expected rate for data frames to arrive, meaning expected number of frames per second"]
    #[doc = " \\param[out] error      if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_stream_profile_data(
        mode: *const rs2_stream_profile,
        stream: *mut rs2_stream,
        format: *mut rs2_format,
        index: *mut ::std::os::raw::c_int,
        unique_id: *mut ::std::os::raw::c_int,
        framerate: *mut ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Override some of the parameters of the stream profile"]
    #[doc = " \\param[in] mode        input stream profile"]
    #[doc = " \\param[in] stream      stream type for the profile"]
    #[doc = " \\param[in] format      binary data format of the profile"]
    #[doc = " \\param[in] index       stream index the profile in case there are multiple streams of the same type"]
    #[doc = " \\param[out] error      if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_set_stream_profile_data(
        mode: *mut rs2_stream_profile,
        stream: rs2_stream,
        index: ::std::os::raw::c_int,
        format: rs2_format,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Creates a copy of stream profile, assigning new values to some of the fields"]
    #[doc = " \\param[in] mode        input stream profile"]
    #[doc = " \\param[in] stream      stream type for the profile"]
    #[doc = " \\param[in] format      binary data format of the profile"]
    #[doc = " \\param[in] index       stream index the profile in case there are multiple streams of the same type"]
    #[doc = " \\param[out] error      if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                new stream profile, must be deleted by rs2_delete_stream_profile"]
    pub fn rs2_clone_stream_profile(
        mode: *const rs2_stream_profile,
        stream: rs2_stream,
        index: ::std::os::raw::c_int,
        format: rs2_format,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_stream_profile;
}
extern "C" {
    #[doc = " Creates a copy of stream profile, assigning new values to some of the fields"]
    #[doc = " \\param[in] mode        input stream profile"]
    #[doc = " \\param[in] stream      stream type for the profile"]
    #[doc = " \\param[in] format      binary data format of the profile"]
    #[doc = " \\param[in] width       new width for the profile"]
    #[doc = " \\param[in] height      new height for the profile"]
    #[doc = " \\param[in] intr        new intrinsics for the profile"]
    #[doc = " \\param[in] index       stream index the profile in case there are multiple streams of the same type"]
    #[doc = " \\param[out] error      if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                new stream profile, must be deleted by rs2_delete_stream_profile"]
    pub fn rs2_clone_video_stream_profile(
        mode: *const rs2_stream_profile,
        stream: rs2_stream,
        index: ::std::os::raw::c_int,
        format: rs2_format,
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        intr: *const rs2_intrinsics,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_stream_profile;
}
extern "C" {
    #[doc = " Delete stream profile allocated by rs2_clone_stream_profile"]
    #[doc = " Should not be called on stream profiles returned by the device"]
    #[doc = " \\param[in] mode        input stream profile"]
    pub fn rs2_delete_stream_profile(mode: *mut rs2_stream_profile);
}
extern "C" {
    #[doc = " Try to extend stream profile to an extension type"]
    #[doc = " \\param[in] mode        input stream profile"]
    #[doc = " \\param[in] type        extension type, for example RS2_EXTENSION_VIDEO_STREAM_PROFILE"]
    #[doc = " \\param[out] error      if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                non-zero if profile is extendable to specified extension, zero otherwise"]
    pub fn rs2_stream_profile_is(
        mode: *const rs2_stream_profile,
        type_: rs2_extension,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " When called on a video stream profile, will return the width and the height of the stream"]
    #[doc = " \\param[in] mode        input stream profile"]
    #[doc = " \\param[out] width      width in pixels of the video stream"]
    #[doc = " \\param[out] height     height in pixels of the video stream"]
    #[doc = " \\param[out] error      if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_video_stream_resolution(
        mode: *const rs2_stream_profile,
        width: *mut ::std::os::raw::c_int,
        height: *mut ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Obtain the intrinsics of a specific stream configuration from the device."]
    #[doc = " \\param[in] mode          input stream profile"]
    #[doc = " \\param[out] intrinsics   Pointer to the struct to store the data in"]
    #[doc = " \\param[out] error        If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_motion_intrinsics(
        mode: *const rs2_stream_profile,
        intrinsics: *mut rs2_motion_device_intrinsic,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Returns non-zero if selected profile is recommended for the sensor"]
    #[doc = " This is an optional hint we offer to suggest profiles with best performance-quality tradeof"]
    #[doc = " \\param[in] mode        input stream profile"]
    #[doc = " \\param[out] error      if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                non-zero if selected profile is recommended for the sensor"]
    pub fn rs2_is_stream_profile_default(
        mode: *const rs2_stream_profile,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " get the number of supported stream profiles"]
    #[doc = " \\param[in] list        the list of supported profiles returned by rs2_get_supported_profiles"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return number of supported subdevice profiles"]
    pub fn rs2_get_stream_profiles_count(
        list: *const rs2_stream_profile_list,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " delete stream profiles list"]
    #[doc = " \\param[in] list        the list of supported profiles returned by rs2_get_supported_profiles"]
    pub fn rs2_delete_stream_profiles_list(list: *mut rs2_stream_profile_list);
}
extern "C" {
    #[doc = " \\param[in] from          origin stream profile"]
    #[doc = " \\param[in] to            target stream profile"]
    #[doc = " \\param[out] extrin       extrinsics from origin to target"]
    #[doc = " \\param[out] error        if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_extrinsics(
        from: *const rs2_stream_profile,
        to: *const rs2_stream_profile,
        extrin: *mut rs2_extrinsics,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " \\param[in] from          origin stream profile"]
    #[doc = " \\param[in] to            target stream profile"]
    #[doc = " \\param[out] extrin       extrinsics from origin to target"]
    #[doc = " \\param[out] error        if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_register_extrinsics(
        from: *const rs2_stream_profile,
        to: *const rs2_stream_profile,
        extrin: rs2_extrinsics,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " \\brief Override extrinsics of a given sensor that supports calibrated_sensor."]
    #[doc = ""]
    #[doc = " This will affect extrinsics at the source device and may affect multiple profiles. Used for DEPTH_TO_RGB calibration."]
    #[doc = ""]
    #[doc = " \\param[in] sensor       The sensor"]
    #[doc = " \\param[in] extrinsics   Extrinsics from Depth to the named sensor"]
    #[doc = " \\param[out] error       If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_override_extrinsics(
        sensor: *const rs2_sensor,
        extrinsics: *const rs2_extrinsics,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " When called on a video profile, returns the intrinsics of specific stream configuration"]
    #[doc = " \\param[in] mode          input stream profile"]
    #[doc = " \\param[out] intrinsics   resulting intrinsics for the video profile"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_video_stream_intrinsics(
        mode: *const rs2_stream_profile,
        intrinsics: *mut rs2_intrinsics,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Returns the list of recommended processing blocks for a specific sensor."]
    #[doc = " Order and configuration of the blocks are decided by the sensor"]
    #[doc = " \\param[in] sensor          input sensor"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return list of supported sensor recommended processing blocks"]
    pub fn rs2_get_recommended_processing_blocks(
        sensor: *mut rs2_sensor,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block_list;
}
extern "C" {
    #[doc = " Returns specific processing blocks from processing blocks list"]
    #[doc = " \\param[in] list           the processing blocks list"]
    #[doc = " \\param[in] index          the requested processing block"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return processing block"]
    pub fn rs2_get_processing_block(
        list: *const rs2_processing_block_list,
        index: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Returns the processing blocks list size"]
    #[doc = " \\param[in] list           the processing blocks list"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return the processing block list size"]
    pub fn rs2_get_recommended_processing_blocks_count(
        list: *const rs2_processing_block_list,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Deletes processing blocks list"]
    #[doc = " \\param[in] list list to delete"]
    pub fn rs2_delete_recommended_processing_blocks(list: *mut rs2_processing_block_list);
}
extern "C" {
    #[doc = " Imports a localization map from file to tm2 tracking device"]
    #[doc = " \\param[in]  sensor        TM2 position-tracking sensor"]
    #[doc = " \\param[in]  lmap_blob     Localization map raw buffer, serialized"]
    #[doc = " \\param[in]  blob_size     The buffer's size in bytes"]
    #[doc = " \\param[out] error         If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                   Non-zero if succeeded, otherwise 0"]
    pub fn rs2_import_localization_map(
        sensor: *const rs2_sensor,
        lmap_blob: *const ::std::os::raw::c_uchar,
        blob_size: ::std::os::raw::c_uint,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rs2_export_localization_map(
        sensor: *const rs2_sensor,
        error: *mut *mut rs2_error,
    ) -> *const rs2_raw_data_buffer;
}
extern "C" {
    #[doc = " Create a named location tag"]
    #[doc = " \\param[in]  sensor    T2xx position-tracking sensor"]
    #[doc = " \\param[in]  guid      Null-terminated string of up to 127 characters"]
    #[doc = " \\param[in]  pos       Position in meters, relative to the current tracking session"]
    #[doc = " \\param[in]  orient    Quaternion orientation, expressed the the coordinate system of the current tracking session"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               Non-zero if succeeded, otherwise 0"]
    pub fn rs2_set_static_node(
        sensor: *const rs2_sensor,
        guid: *const ::std::os::raw::c_char,
        pos: rs2_vector,
        orient: rs2_quaternion,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Retrieve a named location tag"]
    #[doc = " \\param[in]  sensor    T2xx position-tracking sensor"]
    #[doc = " \\param[in]  guid      Null-terminated string of up to 127 characters"]
    #[doc = " \\param[out] pos       Position in meters of the tagged (stored) location"]
    #[doc = " \\param[out] orient    Quaternion orientation of the tagged (stored) location"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               Non-zero if succeeded, otherwise 0"]
    pub fn rs2_get_static_node(
        sensor: *const rs2_sensor,
        guid: *const ::std::os::raw::c_char,
        pos: *mut rs2_vector,
        orient: *mut rs2_quaternion,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Remove a named location tag"]
    #[doc = " \\param[in]  sensor    T2xx position-tracking sensor"]
    #[doc = " \\param[in]  guid      Null-terminated string of up to 127 characters"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               Non-zero if succeeded, otherwise 0"]
    pub fn rs2_remove_static_node(
        sensor: *const rs2_sensor,
        guid: *const ::std::os::raw::c_char,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Load Wheel odometer settings from host to device"]
    #[doc = " \\param[in] odometry_config_buf   odometer configuration/calibration blob serialized from jsom file"]
    #[doc = " \\return true on success"]
    pub fn rs2_load_wheel_odometry_config(
        sensor: *const rs2_sensor,
        odometry_config_buf: *const ::std::os::raw::c_uchar,
        blob_size: ::std::os::raw::c_uint,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Send wheel odometry data for each individual sensor (wheel)"]
    #[doc = " \\param[in] wo_sensor_id       - Zero-based index of (wheel) sensor with the same type within device"]
    #[doc = " \\param[in] frame_num          - Monotonocally increasing frame number, managed per sensor."]
    #[doc = " \\param[in] translational_velocity   - Translational velocity of the wheel sensor [meter/sec]"]
    #[doc = " \\return true on success"]
    pub fn rs2_send_wheel_odometry(
        sensor: *const rs2_sensor,
        wo_sensor_id: ::std::os::raw::c_char,
        frame_num: ::std::os::raw::c_uint,
        translational_velocity: rs2_vector,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Set intrinsics of a given sensor"]
    #[doc = " \\param[in] sensor       The RealSense device"]
    #[doc = " \\param[in] profile      Target stream profile"]
    #[doc = " \\param[in] intrinsics   Intrinsics value to be written to the device"]
    #[doc = " \\param[out] error       If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_set_intrinsics(
        sensor: *const rs2_sensor,
        profile: *const rs2_stream_profile,
        intrinsics: *const rs2_intrinsics,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " \\brief Override intrinsics of a given sensor that supports calibrated_sensor."]
    #[doc = ""]
    #[doc = " This will affect intrinsics at the source and may affect multiple profiles. Used for DEPTH_TO_RGB calibration."]
    #[doc = ""]
    #[doc = " \\param[in] sensor       The RealSense device"]
    #[doc = " \\param[in] intrinsics   Intrinsics value to be written to the sensor"]
    #[doc = " \\param[out] error       If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_override_intrinsics(
        sensor: *const rs2_sensor,
        intrinsics: *const rs2_intrinsics,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Set extrinsics between two sensors"]
    #[doc = " \\param[in]  from_sensor  Origin sensor"]
    #[doc = " \\param[in]  from_profile Origin profile"]
    #[doc = " \\param[in]  to_sensor    Target sensor"]
    #[doc = " \\param[in]  to_profile   Target profile"]
    #[doc = " \\param[out] extrinsics   Extrinsics from origin to target"]
    #[doc = " \\param[out] error        If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_set_extrinsics(
        from_sensor: *const rs2_sensor,
        from_profile: *const rs2_stream_profile,
        to_sensor: *mut rs2_sensor,
        to_profile: *const rs2_stream_profile,
        extrinsics: *const rs2_extrinsics,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Get the DSM parameters for a sensor"]
    #[doc = " \\param[in]  sensor        Sensor that supports the CALIBRATED_SENSOR extension"]
    #[doc = " \\param[out] p_params_out  Pointer to the structure that will get the DSM parameters"]
    #[doc = " \\param[out] error         If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_dsm_params(
        sensor: *const rs2_sensor,
        p_params_out: *mut rs2_dsm_params,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Set the sensor DSM parameters"]
    #[doc = " This should ideally be done when the stream is NOT running. If it is, the"]
    #[doc = " parameters may not take effect immediately."]
    #[doc = " \\param[in]  sensor        Sensor that supports the CALIBRATED_SENSOR extension"]
    #[doc = " \\param[out] p_params      Pointer to the structure that contains the DSM parameters"]
    #[doc = " \\param[out] error         If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_override_dsm_params(
        sensor: *const rs2_sensor,
        p_params: *const rs2_dsm_params,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Reset the sensor DSM parameters"]
    #[doc = " This should ideally be done when the stream is NOT running. May not take effect immediately."]
    #[doc = " \\param[in]  sensor        Sensor that supports the CALIBRATED_SENSOR extension"]
    #[doc = " \\param[out] error         If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_reset_sensor_calibration(sensor: *const rs2_sensor, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Set motion device intrinsics"]
    #[doc = " \\param[in]  sensor       Motion sensor"]
    #[doc = " \\param[in]  profile      Motion stream profile"]
    #[doc = " \\param[out] intrinsics   Pointer to the struct to store the data in"]
    #[doc = " \\param[out] error        If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_set_motion_device_intrinsics(
        sensor: *const rs2_sensor,
        profile: *const rs2_stream_profile,
        intrinsics: *const rs2_motion_device_intrinsic,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " When called on a depth sensor, this method will return the maximum range of the camera given the amount of ambient light in the scene"]
    #[doc = " \\param[in] sensor      depth sensor"]
    #[doc = " \\param[out] error      if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                the max usable range in meters"]
    pub fn rs2_get_max_usable_depth_range(
        sensor: *const rs2_sensor,
        error: *mut *mut rs2_error,
    ) -> f32;
}
extern "C" {
    #[doc = " Determines number of devices in a list."]
    #[doc = " \\param[in]  info_list The list of connected devices captured using rs2_query_devices"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               Device count"]
    pub fn rs2_get_device_count(
        info_list: *const rs2_device_list,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Deletes device list, any devices created using this list will remain unaffected."]
    #[doc = " \\param[in]  info_list List to delete"]
    pub fn rs2_delete_device_list(info_list: *mut rs2_device_list);
}
extern "C" {
    #[doc = " Checks if a specific device is contained inside a device list."]
    #[doc = " \\param[in]  info_list The list of devices to check in"]
    #[doc = " \\param[in]  device    RealSense device to check for"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               True if the device is in the list and false otherwise"]
    pub fn rs2_device_list_contains(
        info_list: *const rs2_device_list,
        device: *const rs2_device,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Creates a device by index. The device object represents a physical camera and provides the means to manipulate it."]
    #[doc = " \\param[in]  info_list the list containing the device to retrieve"]
    #[doc = " \\param[in]  index     The zero based index of device to retrieve"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               The requested device, should be released by rs2_delete_device"]
    pub fn rs2_create_device(
        info_list: *const rs2_device_list,
        index: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_device;
}
extern "C" {
    #[doc = " Delete RealSense device"]
    #[doc = " \\param[in]  device    Realsense device to delete"]
    pub fn rs2_delete_device(device: *mut rs2_device);
}
extern "C" {
    #[doc = " Retrieve camera specific information, like versions of various internal components."]
    #[doc = " \\param[in]  device    The RealSense device"]
    #[doc = " \\param[in]  info      Camera info type to retrieve"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               The requested camera info string, in a format specific to the device model"]
    pub fn rs2_get_device_info(
        device: *const rs2_device,
        info: rs2_camera_info,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Check if a camera supports a specific camera info type."]
    #[doc = " \\param[in]  device    The RealSense device to check"]
    #[doc = " \\param[in]  info      The parameter to check for support"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               True if the parameter both exist and well-defined for the specific device"]
    pub fn rs2_supports_device_info(
        device: *const rs2_device,
        info: rs2_camera_info,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Send hardware reset request to the device. The actual reset is asynchronous."]
    #[doc = " Note: Invalidates all handles to this device."]
    #[doc = " \\param[in]  device   The RealSense device to reset"]
    #[doc = " \\param[out] error    If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_hardware_reset(device: *const rs2_device, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Send raw data to device"]
    #[doc = " \\param[in]  device                    RealSense device to send data to"]
    #[doc = " \\param[in]  raw_data_to_send          Raw data to be sent to device"]
    #[doc = " \\param[in]  size_of_raw_data_to_send  Size of raw_data_to_send in bytes"]
    #[doc = " \\param[out] error                     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                               Device's response in a rs2_raw_data_buffer, which should be released by rs2_delete_raw_data"]
    pub fn rs2_send_and_receive_raw_data(
        device: *mut rs2_device,
        raw_data_to_send: *mut ::std::os::raw::c_void,
        size_of_raw_data_to_send: ::std::os::raw::c_uint,
        error: *mut *mut rs2_error,
    ) -> *const rs2_raw_data_buffer;
}
extern "C" {
    #[doc = " Test if the given device can be extended to the requested extension."]
    #[doc = " \\param[in]  device    Realsense device"]
    #[doc = " \\param[in]  extension The extension to which the device should be tested if it is extendable"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               Non-zero value iff the device can be extended to the given extension"]
    pub fn rs2_is_device_extendable_to(
        device: *const rs2_device,
        extension: rs2_extension,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create a static snapshot of all connected sensors within a specific device."]
    #[doc = " \\param[in]  device    Specific RealSense device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               The list of sensors, should be released by rs2_delete_sensor_list"]
    pub fn rs2_query_sensors(
        device: *const rs2_device,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_sensor_list;
}
extern "C" {
    #[doc = " Enter the given device into loopback operation mode that uses the given file as input for raw data"]
    #[doc = " \\param[in]  device     Device to enter into loopback operation mode"]
    #[doc = " \\param[in]  from_file  Path to bag file with raw data for loopback"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_loopback_enable(
        device: *const rs2_device,
        from_file: *const ::std::os::raw::c_char,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Restores the given device into normal operation mode"]
    #[doc = " \\param[in]  device     Device to restore to normal operation mode"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_loopback_disable(device: *const rs2_device, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Checks if the device is in loopback mode or not"]
    #[doc = " \\param[in]  device     Device to check for operation mode"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return true if the device is in loopback operation mode"]
    pub fn rs2_loopback_is_enabled(
        device: *const rs2_device,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Connects to a given tm2 controller"]
    #[doc = " \\param[in]  device     Device to connect to the controller"]
    #[doc = " \\param[in]  mac_addr   The MAC address of the desired controller"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_connect_tm2_controller(
        device: *const rs2_device,
        mac_addr: *const ::std::os::raw::c_uchar,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Disconnects a given tm2 controller"]
    #[doc = " \\param[in]  device     Device to disconnect the controller from"]
    #[doc = " \\param[in]  id         The ID of the desired controller"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_disconnect_tm2_controller(
        device: *const rs2_device,
        id: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Reset device to factory calibration"]
    #[doc = " \\param[in] device       The RealSense device"]
    #[doc = " \\param[out] error       If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_reset_to_factory_calibration(device: *const rs2_device, e: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Write calibration to device's EEPROM"]
    #[doc = " \\param[in] device       The RealSense device"]
    #[doc = " \\param[out] error       If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_write_calibration(device: *const rs2_device, e: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Update device to the provided firmware, the device must be extendable to RS2_EXTENSION_UPDATABLE."]
    #[doc = " This call is executed on the caller's thread and it supports progress notifications via the optional callback."]
    #[doc = " \\param[in]  device        Device to update"]
    #[doc = " \\param[in]  fw_image      Firmware image buffer"]
    #[doc = " \\param[in]  fw_image_size Firmware image buffer size"]
    #[doc = " \\param[in]  callback      Optional callback for update progress notifications, the progress value is normailzed to 1"]
    #[doc = " \\param[out] error         If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_update_firmware_cpp(
        device: *const rs2_device,
        fw_image: *const ::std::os::raw::c_void,
        fw_image_size: ::std::os::raw::c_int,
        callback: *mut rs2_update_progress_callback,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Update device to the provided firmware, the device must be extendable to RS2_EXTENSION_UPDATABLE."]
    #[doc = " This call is executed on the caller's thread and it supports progress notifications via the optional callback."]
    #[doc = " \\param[in]  device        Device to update"]
    #[doc = " \\param[in]  fw_image      Firmware image buffer"]
    #[doc = " \\param[in]  fw_image_size Firmware image buffer size"]
    #[doc = " \\param[in]  callback      Optional callback for update progress notifications, the progress value is normailzed to 1"]
    #[doc = " \\param[in]  client_data   Optional client data for the callback"]
    #[doc = " \\param[out] error         If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_update_firmware(
        device: *const rs2_device,
        fw_image: *const ::std::os::raw::c_void,
        fw_image_size: ::std::os::raw::c_int,
        callback: rs2_update_progress_callback_ptr,
        client_data: *mut ::std::os::raw::c_void,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Create backup of camera flash memory. Such backup does not constitute valid firmware image, and cannot be"]
    #[doc = " loaded back to the device, but it does contain all calibration and device information."]
    #[doc = " \\param[in]  device        Device to update"]
    #[doc = " \\param[in]  callback      Optional callback for update progress notifications, the progress value is normailzed to 1"]
    #[doc = " \\param[out] error         If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_flash_backup_cpp(
        device: *const rs2_device,
        callback: *mut rs2_update_progress_callback,
        error: *mut *mut rs2_error,
    ) -> *const rs2_raw_data_buffer;
}
extern "C" {
    #[doc = " Create backup of camera flash memory. Such backup does not constitute valid firmware image, and cannot be"]
    #[doc = " loaded back to the device, but it does contain all calibration and device information."]
    #[doc = " \\param[in]  device        Device to update"]
    #[doc = " \\param[in]  callback      Optional callback for update progress notifications, the progress value is normailzed to 1"]
    #[doc = " \\param[in]  client_data   Optional client data for the callback"]
    #[doc = " \\param[out] error         If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_flash_backup(
        device: *const rs2_device,
        callback: rs2_update_progress_callback_ptr,
        client_data: *mut ::std::os::raw::c_void,
        error: *mut *mut rs2_error,
    ) -> *const rs2_raw_data_buffer;
}
extern "C" {
    #[doc = " Update device to the provided firmware by writing raw data directly to the flash, this command can be executed only on unlocked camera."]
    #[doc = " The device must be extendable to RS2_EXTENSION_UPDATABLE."]
    #[doc = " This call is executed on the caller's thread and it supports progress notifications via the optional callback."]
    #[doc = " \\param[in]  device        Device to update"]
    #[doc = " \\param[in]  fw_image      Firmware image buffer"]
    #[doc = " \\param[in]  fw_image_size Firmware image buffer size"]
    #[doc = " \\param[in]  callback      Optional callback for update progress notifications, the progress value is normailzed to 1"]
    #[doc = " \\param[in]  update_mode   Select one of RS2_UNSIGNED_UPDATE_MODE, WARNING!!! setting to any option other than RS2_UNSIGNED_UPDATE_MODE_UPDATE will make this call unsafe and might damage the camera"]
    #[doc = " \\param[out] error         If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_update_firmware_unsigned_cpp(
        device: *const rs2_device,
        fw_image: *const ::std::os::raw::c_void,
        fw_image_size: ::std::os::raw::c_int,
        callback: *mut rs2_update_progress_callback,
        update_mode: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Checks if the device and the provided firmware image are compatible"]
    #[doc = " \\param[in]  device        Device to update"]
    #[doc = " \\param[in]  fw_image      Firmware image buffer"]
    #[doc = " \\param[in]  fw_image_size Firmware image buffer size in bytes"]
    #[doc = " \\param[out] error         If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                   Non-zero if the firmware is compatible with the device and 0 otherwise"]
    pub fn rs2_check_firmware_compatibility(
        device: *const rs2_device,
        fw_image: *const ::std::os::raw::c_void,
        fw_image_size: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Update device to the provided firmware by writing raw data directly to the flash, this command can be executed only on unlocked camera."]
    #[doc = " The device must be extendable to RS2_EXTENSION_UPDATABLE."]
    #[doc = " This call is executed on the caller's thread and it supports progress notifications via the optional callback."]
    #[doc = " \\param[in]  device        Device to update"]
    #[doc = " \\param[in]  fw_image      Firmware image buffer"]
    #[doc = " \\param[in]  fw_image_size Firmware image buffer size"]
    #[doc = " \\param[in]  callback      Optional callback for update progress notifications, the progress value is normailzed to 1"]
    #[doc = " \\param[in]  client_data   Optional client data for the callback"]
    #[doc = " \\param[in]  update_mode   Select one of RS2_UNSIGNED_UPDATE_MODE, WARNING!!! setting to any option other than RS2_UNSIGNED_UPDATE_MODE_UPDATE will make this call unsafe and might damage the camera"]
    #[doc = " \\param[out] error         If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_update_firmware_unsigned(
        device: *const rs2_device,
        fw_image: *const ::std::os::raw::c_void,
        fw_image_size: ::std::os::raw::c_int,
        callback: rs2_update_progress_callback_ptr,
        client_data: *mut ::std::os::raw::c_void,
        update_mode: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Enter the device to update state, this will cause the updatable device to disconnect and reconnect as update device."]
    #[doc = " \\param[in]  device     Device to update"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_enter_update_state(device: *const rs2_device, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " This will improve the depth noise."]
    #[doc = " \\param[in] json_content       Json string to configure regular speed on chip calibration parameters:"]
    #[doc = "{"]
    #[doc = "\"calib type\" : 0,"]
    #[doc = "\"speed\": 3,"]
    #[doc = "\"scan parameter\": 0,"]
    #[doc = "\"adjust both sides\": 0,"]
    #[doc = "\"white wall mode\": 0"]
    #[doc = "}"]
    #[doc = "calib_type - calibraton type: 0 = regular, 1 = focal length, 2 = both regular and focal length in order"]
    #[doc = "speed - for regular calibration. value can be one of: Very fast = 0, Fast = 1, Medium = 2, Slow = 3, White wall = 4, default is Slow for type 0 and Fast for type 2"]
    #[doc = "scan_parameter - for regular calibration. value can be one of: Py scan (default) = 0, Rx scan = 1"]
    #[doc = "adjust_both_sides - for focal length calibration. value can be one of: 0 = adjust right only, 1 = adjust both sides"]
    #[doc = "white_wall_mode - white wall mode: 0 for normal mode and 1 for white wall mode"]
    #[doc = "if json is nullptr it will be ignored and calibration will use the default parameters"]
    #[doc = " \\param[out] health            The absolute value of regular calibration Health-Check captures how far camera calibration is from the optimal one"]
    #[doc = "[0, 0.25) - Good"]
    #[doc = "[0.25, 0.75) - Can be Improved"]
    #[doc = "[0.75, ) - Requires Calibration"]
    #[doc = "The absolute value of focal length calibration Health-Check captures how far camera calibration is from the optimal one"]
    #[doc = "[0, 0.15) - Good"]
    #[doc = "[0.15, 0.75) - Can be Improved"]
    #[doc = "[0.75, ) - Requires Calibration"]
    #[doc = "The two health numbers are encoded in one integer as follows for calib_type 2:"]
    #[doc = "Regular health number times 1000 are bits 0 to 11"]
    #[doc = "Regular health number is negative if bit 24 is 1"]
    #[doc = "Focal length health number times 1000 are bits 12 to 23"]
    #[doc = "Focal length health number is negative if bit 25 is 1"]
    #[doc = " \\param[in] callback           Optional callback to get progress notifications"]
    #[doc = " \\param[in] timeout_ms         Timeout in ms (use 5000 msec unless instructed otherwise)"]
    #[doc = " \\return                       New calibration table"]
    pub fn rs2_run_on_chip_calibration_cpp(
        device: *mut rs2_device,
        json_content: *const ::std::os::raw::c_void,
        content_size: ::std::os::raw::c_int,
        health: *mut f32,
        progress_callback: *mut rs2_update_progress_callback,
        timeout_ms: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *const rs2_raw_data_buffer;
}
extern "C" {
    #[doc = " This will improve the depth noise."]
    #[doc = " \\param[in] json_content       Json string to configure regular speed on chip calibration parameters:"]
    #[doc = "{"]
    #[doc = "\"calib type\" : 0,"]
    #[doc = "\"speed\": 3,"]
    #[doc = "\"scan parameter\": 0,"]
    #[doc = "\"adjust both sides\": 0,"]
    #[doc = "\"white wall mode\": 0"]
    #[doc = "}"]
    #[doc = "calib_type - calibraton type: 0 = regular, 1 = focal length, 2 = both regular and focal length in order"]
    #[doc = "speed - for regular calibration, value can be one of: Very fast = 0, Fast = 1, Medium = 2, Slow = 3, White wall = 4, default is Slow for type 0 and Fast for type 2"]
    #[doc = "scan_parameter - for regular calibration. value can be one of: Py scan (default) = 0, Rx scan = 1"]
    #[doc = "adjust_both_sides - for focal length calibration. value can be one of: 0 = adjust right only, 1 = adjust both sides"]
    #[doc = "white_wall_mode - white wall mode: 0 for normal mode and 1 for white wall mode"]
    #[doc = "if json is nullptr it will be ignored and calibration will use the default parameters"]
    #[doc = " \\param[out] health            The absolute value of regular calibration Health-Check captures how far camera calibration is from the optimal one"]
    #[doc = "[0, 0.25) - Good"]
    #[doc = "[0.25, 0.75) - Can be Improved"]
    #[doc = "[0.75, ) - Requires Calibration"]
    #[doc = "The absolute value of focal length calibration Health-Check captures how far camera calibration is from the optimal one"]
    #[doc = "[0, 0.15) - Good"]
    #[doc = "[0.15, 0.75) - Can be Improved"]
    #[doc = "[0.75, ) - Requires Calibration"]
    #[doc = "The two health numbers are encoded in one integer as follows for calib_type 2:"]
    #[doc = "Regular health number times 1000 are bits 0 to 11"]
    #[doc = "Regular health number is negative if bit 24 is 1"]
    #[doc = "Focal length health number times 1000 are bits 12 to 23"]
    #[doc = "Focal length health number is negative if bit 25 is 1"]
    #[doc = " \\param[in] callback           Optional callback for update progress notifications, the progress value is normailzed to 1"]
    #[doc = " \\param[in] client_data        Optional client data for the callback"]
    #[doc = " \\param[in] timeout_ms         Timeout in ms (use 5000 msec unless instructed otherwise)"]
    #[doc = " \\return                       New calibration table"]
    pub fn rs2_run_on_chip_calibration(
        device: *mut rs2_device,
        json_content: *const ::std::os::raw::c_void,
        content_size: ::std::os::raw::c_int,
        health: *mut f32,
        callback: rs2_update_progress_callback_ptr,
        client_data: *mut ::std::os::raw::c_void,
        timeout_ms: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *const rs2_raw_data_buffer;
}
extern "C" {
    #[doc = " This will adjust camera absolute distance to flat target. User needs to enter the known ground truth."]
    #[doc = " \\param[in] ground_truth_mm     Ground truth in mm must be between 60 and 10000"]
    #[doc = " \\param[in] json_content        Json string to configure tare calibration parameters:"]
    #[doc = "{"]
    #[doc = "\"average step count\": 20,"]
    #[doc = "\"step count\": 20,"]
    #[doc = "\"accuracy\": 2,"]
    #[doc = "\"scan parameter\": 0,"]
    #[doc = "\"data sampling\": 0"]
    #[doc = "}"]
    #[doc = "average step count - number of frames to average, must be between 1 - 30, default = 20"]
    #[doc = "step count - max iteration steps, must be between 5 - 30, default = 10"]
    #[doc = "accuracy - Subpixel accuracy level, value can be one of: Very high = 0 (0.025%), High = 1 (0.05%), Medium = 2 (0.1%), Low = 3 (0.2%), Default = Very high (0.025%), default is very high (0.025%)"]
    #[doc = "scan_parameter - value can be one of: Py scan (default) = 0, Rx scan = 1"]
    #[doc = "data_sampling - value can be one of:polling data sampling = 0, interrupt data sampling = 1"]
    #[doc = "if json is nullptr it will be ignored and calibration will use the default parameters"]
    #[doc = " \\param[in]  content_size        Json string size if its 0 the json will be ignored and calibration will use the default parameters"]
    #[doc = " \\param[in]  callback            Optional callback to get progress notifications"]
    #[doc = " \\param[in] timeout_ms          Timeout in ms (use 5000 msec unless instructed otherwise)"]
    #[doc = " \\return                         New calibration table"]
    pub fn rs2_run_tare_calibration_cpp(
        dev: *mut rs2_device,
        ground_truth_mm: f32,
        json_content: *const ::std::os::raw::c_void,
        content_size: ::std::os::raw::c_int,
        progress_callback: *mut rs2_update_progress_callback,
        timeout_ms: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *const rs2_raw_data_buffer;
}
pub const rs2_calibration_type_RS2_CALIBRATION_AUTO_DEPTH_TO_RGB: rs2_calibration_type = 0;
pub const rs2_calibration_type_RS2_CALIBRATION_MANUAL_DEPTH_TO_RGB: rs2_calibration_type = 1;
pub const rs2_calibration_type_RS2_CALIBRATION_THERMAL: rs2_calibration_type = 2;
pub const rs2_calibration_type_RS2_CALIBRATION_TYPE_COUNT: rs2_calibration_type = 3;
#[doc = " Used in device_calibration; enumerates the different calibration types"]
#[doc = " available for that extension."]
pub type rs2_calibration_type = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_calibration_type_to_string(
        arg1: rs2_calibration_type,
    ) -> *const ::std::os::raw::c_char;
}
pub const rs2_calibration_status_RS2_CALIBRATION_TRIGGERED: rs2_calibration_status = 0;
pub const rs2_calibration_status_RS2_CALIBRATION_SPECIAL_FRAME: rs2_calibration_status = 1;
pub const rs2_calibration_status_RS2_CALIBRATION_STARTED: rs2_calibration_status = 2;
pub const rs2_calibration_status_RS2_CALIBRATION_NOT_NEEDED: rs2_calibration_status = 3;
pub const rs2_calibration_status_RS2_CALIBRATION_SUCCESSFUL: rs2_calibration_status = 4;
pub const rs2_calibration_status_RS2_CALIBRATION_RETRY: rs2_calibration_status = -1;
pub const rs2_calibration_status_RS2_CALIBRATION_FAILED: rs2_calibration_status = -2;
pub const rs2_calibration_status_RS2_CALIBRATION_SCENE_INVALID: rs2_calibration_status = -3;
pub const rs2_calibration_status_RS2_CALIBRATION_BAD_RESULT: rs2_calibration_status = -4;
pub const rs2_calibration_status_RS2_CALIBRATION_BAD_CONDITIONS: rs2_calibration_status = -5;
pub const rs2_calibration_status_RS2_CALIBRATION_STATUS_FIRST: rs2_calibration_status = -5;
pub const rs2_calibration_status_RS2_CALIBRATION_STATUS_LAST: rs2_calibration_status = 4;
pub const rs2_calibration_status_RS2_CALIBRATION_STATUS_COUNT: rs2_calibration_status = 10;
#[doc = " Used in device_calibration with rs2_calibration_change_callback"]
pub type rs2_calibration_status = ::std::os::raw::c_int;
extern "C" {
    pub fn rs2_calibration_status_to_string(
        arg1: rs2_calibration_status,
    ) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rs2_calibration_change_callback {
    _unused: [u8; 0],
}
pub type rs2_calibration_change_callback_ptr = ::std::option::Option<
    unsafe extern "C" fn(arg1: rs2_calibration_status, arg: *mut ::std::os::raw::c_void),
>;
extern "C" {
    #[doc = " Adds a callback for a sensor that gets called when calibration (intrinsics) changes, e.g. due to auto-calibration"]
    #[doc = " \\param[in] sensor        the sensor"]
    #[doc = " \\param[in] callback      the C callback function that gets called"]
    #[doc = " \\param[in] user          user argument that gets passed to the callback function"]
    #[doc = " \\param[out] error        if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_register_calibration_change_callback(
        dev: *mut rs2_device,
        callback: rs2_calibration_change_callback_ptr,
        user: *mut ::std::os::raw::c_void,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Adds a callback for a sensor that gets called when calibration (intrinsics) changes, e.g. due to auto-calibration"]
    #[doc = " \\param[in] sensor        the sensor"]
    #[doc = " \\param[in] callback      the C++ callback interface that gets called"]
    #[doc = " \\param[out] error        if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_register_calibration_change_callback_cpp(
        dev: *mut rs2_device,
        callback: *mut rs2_calibration_change_callback,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Triggers calibration of the given type"]
    #[doc = " \\param[in] dev           the device"]
    #[doc = " \\param[in] type          the type of calibration requested"]
    #[doc = " \\param[out] error        if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_trigger_device_calibration(
        dev: *mut rs2_device,
        type_: rs2_calibration_type,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " This will adjust camera absolute distance to flat target. User needs to enter the known ground truth."]
    #[doc = " \\param[in] ground_truth_mm     Ground truth in mm must be between 60 and 10000"]
    #[doc = " \\param[in] json_content        Json string to configure tare calibration parameters:"]
    #[doc = "{"]
    #[doc = "\"average_step_count\": 20,"]
    #[doc = "\"step count\": 20,"]
    #[doc = "\"accuracy\": 2,"]
    #[doc = "\"scan parameter\": 0,"]
    #[doc = "\"data sampling\": 0"]
    #[doc = "}"]
    #[doc = "average step count - number of frames to average, must be between 1 - 30, default = 20"]
    #[doc = "step count - max iteration steps, must be between 5 - 30, default = 10"]
    #[doc = "accuracy - Subpixel accuracy level, value can be one of: Very high = 0 (0.025%), High = 1 (0.05%), Medium = 2 (0.1%), Low = 3 (0.2%), Default = Very high (0.025%), default is very high (0.025%)"]
    #[doc = "scan_parameter - value can be one of: Py scan (default) = 0, Rx scan = 1"]
    #[doc = "data_sampling - value can be one of:polling data sampling = 0, interrupt data sampling = 1"]
    #[doc = "if json is nullptr it will be ignored and calibration will use the default parameters"]
    #[doc = " \\param[in]  content_size       Json string size if its 0 the json will be ignored and calibration will use the default parameters"]
    #[doc = " \\param[in]  callback           Optional callback for update progress notifications, the progress value is normailzed to 1"]
    #[doc = " \\param[in]  client_data        Optional client data for the callback"]
    #[doc = " \\param[in] timeout_ms          Timeout in ms (use 5000 msec unless instructed otherwise)"]
    #[doc = " \\return                        New calibration table"]
    pub fn rs2_run_tare_calibration(
        dev: *mut rs2_device,
        ground_truth_mm: f32,
        json_content: *const ::std::os::raw::c_void,
        content_size: ::std::os::raw::c_int,
        callback: rs2_update_progress_callback_ptr,
        client_data: *mut ::std::os::raw::c_void,
        timeout_ms: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *const rs2_raw_data_buffer;
}
extern "C" {
    #[doc = "  Read current calibration table from flash."]
    #[doc = " \\return    Calibration table"]
    pub fn rs2_get_calibration_table(
        dev: *const rs2_device,
        error: *mut *mut rs2_error,
    ) -> *const rs2_raw_data_buffer;
}
extern "C" {
    #[doc = "  Set current table to dynamic area."]
    #[doc = " \\param[in]     Calibration table"]
    pub fn rs2_set_calibration_table(
        device: *const rs2_device,
        calibration: *const ::std::os::raw::c_void,
        calibration_size: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    pub fn rs2_serialize_json(
        dev: *mut rs2_device,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_raw_data_buffer;
}
extern "C" {
    pub fn rs2_load_json(
        dev: *mut rs2_device,
        json_content: *const ::std::os::raw::c_void,
        content_size: ::std::os::raw::c_uint,
        error: *mut *mut rs2_error,
    );
}
#[doc = "< Frame timestamp was measured in relation to the camera clock"]
pub const rs2_timestamp_domain_RS2_TIMESTAMP_DOMAIN_HARDWARE_CLOCK: rs2_timestamp_domain = 0;
#[doc = "< Frame timestamp was measured in relation to the OS system clock"]
pub const rs2_timestamp_domain_RS2_TIMESTAMP_DOMAIN_SYSTEM_TIME: rs2_timestamp_domain = 1;
#[doc = "< Frame timestamp was measured in relation to the camera clock and converted to OS system clock by constantly measure the difference"]
pub const rs2_timestamp_domain_RS2_TIMESTAMP_DOMAIN_GLOBAL_TIME: rs2_timestamp_domain = 2;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_timestamp_domain_RS2_TIMESTAMP_DOMAIN_COUNT: rs2_timestamp_domain = 3;
#[doc = " \\brief Specifies the clock in relation to which the frame timestamp was measured."]
pub type rs2_timestamp_domain = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_timestamp_domain_to_string(
        info: rs2_timestamp_domain,
    ) -> *const ::std::os::raw::c_char;
}
#[doc = "< A sequential index managed per-stream. Integer value"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_FRAME_COUNTER: rs2_frame_metadata_value = 0;
#[doc = "< Timestamp set by device clock when data readout and transmit commence. usec"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_FRAME_TIMESTAMP: rs2_frame_metadata_value = 1;
#[doc = "< Timestamp of the middle of sensor's exposure calculated by device. usec"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_SENSOR_TIMESTAMP: rs2_frame_metadata_value =
    2;
#[doc = "< Sensor's exposure width. When Auto Exposure (AE) is on the value is controlled by firmware. usec"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_ACTUAL_EXPOSURE: rs2_frame_metadata_value = 3;
#[doc = "< A relative value increasing which will increase the Sensor's gain factor. \\"]
#[doc = "When AE is set On, the value is controlled by firmware. Integer value"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_GAIN_LEVEL: rs2_frame_metadata_value = 4;
#[doc = "< Auto Exposure Mode indicator. Zero corresponds to AE switched off."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_AUTO_EXPOSURE: rs2_frame_metadata_value = 5;
#[doc = "< White Balance setting as a color temperature. Kelvin degrees"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_WHITE_BALANCE: rs2_frame_metadata_value = 6;
#[doc = "< Time of arrival in system clock"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_TIME_OF_ARRIVAL: rs2_frame_metadata_value = 7;
#[doc = "< Temperature of the device, measured at the time of the frame capture. Celsius degrees"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_TEMPERATURE: rs2_frame_metadata_value = 8;
#[doc = "< Timestamp get from uvc driver. usec"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_BACKEND_TIMESTAMP: rs2_frame_metadata_value =
    9;
#[doc = "< Actual fps"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_ACTUAL_FPS: rs2_frame_metadata_value = 10;
#[doc = "< Laser power value 0-360."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_FRAME_LASER_POWER: rs2_frame_metadata_value =
    11;
#[doc = "< Laser power mode. Zero corresponds to Laser power switched off and one for switched on. deprecated, replaced by RS2_FRAME_METADATA_FRAME_EMITTER_MODE"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_FRAME_LASER_POWER_MODE:
    rs2_frame_metadata_value = 12;
#[doc = "< Exposure priority."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_EXPOSURE_PRIORITY: rs2_frame_metadata_value =
    13;
#[doc = "< Left region of interest for the auto exposure Algorithm."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_EXPOSURE_ROI_LEFT: rs2_frame_metadata_value =
    14;
#[doc = "< Right region of interest for the auto exposure Algorithm."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_EXPOSURE_ROI_RIGHT: rs2_frame_metadata_value =
    15;
#[doc = "< Top region of interest for the auto exposure Algorithm."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_EXPOSURE_ROI_TOP: rs2_frame_metadata_value =
    16;
#[doc = "< Bottom region of interest for the auto exposure Algorithm."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_EXPOSURE_ROI_BOTTOM:
    rs2_frame_metadata_value = 17;
#[doc = "< Color image brightness."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_BRIGHTNESS: rs2_frame_metadata_value = 18;
#[doc = "< Color image contrast."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_CONTRAST: rs2_frame_metadata_value = 19;
#[doc = "< Color image saturation."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_SATURATION: rs2_frame_metadata_value = 20;
#[doc = "< Color image sharpness."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_SHARPNESS: rs2_frame_metadata_value = 21;
#[doc = "< Auto white balance temperature Mode indicator. Zero corresponds to automatic mode switched off."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_AUTO_WHITE_BALANCE_TEMPERATURE:
    rs2_frame_metadata_value = 22;
#[doc = "< Color backlight compensation. Zero corresponds to switched off."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_BACKLIGHT_COMPENSATION:
    rs2_frame_metadata_value = 23;
#[doc = "< Color image hue."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_HUE: rs2_frame_metadata_value = 24;
#[doc = "< Color image gamma."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_GAMMA: rs2_frame_metadata_value = 25;
#[doc = "< Color image white balance."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_MANUAL_WHITE_BALANCE:
    rs2_frame_metadata_value = 26;
#[doc = "< Power Line Frequency for anti-flickering Off/50Hz/60Hz/Auto."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_POWER_LINE_FREQUENCY:
    rs2_frame_metadata_value = 27;
#[doc = "< Color lowlight compensation. Zero corresponds to switched off."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_LOW_LIGHT_COMPENSATION:
    rs2_frame_metadata_value = 28;
#[doc = "< Emitter mode: 0 - all emitters disabled. 1 - laser enabled. 2 - auto laser enabled (opt). 3 - LED enabled (opt)."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_FRAME_EMITTER_MODE: rs2_frame_metadata_value =
    29;
#[doc = "< Led power value 0-360."]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_FRAME_LED_POWER: rs2_frame_metadata_value =
    30;
#[doc = "< The number of transmitted payload bytes, not including metadata"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_RAW_FRAME_SIZE: rs2_frame_metadata_value = 31;
#[doc = "< GPIO input data"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_GPIO_INPUT_DATA: rs2_frame_metadata_value =
    32;
#[doc = "< sub-preset id"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_SEQUENCE_NAME: rs2_frame_metadata_value = 33;
#[doc = "< sub-preset sequence id"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_SEQUENCE_ID: rs2_frame_metadata_value = 34;
#[doc = "< sub-preset sequence size"]
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_SEQUENCE_SIZE: rs2_frame_metadata_value = 35;
pub const rs2_frame_metadata_value_RS2_FRAME_METADATA_COUNT: rs2_frame_metadata_value = 36;
#[doc = " \\brief Per-Frame-Metadata is the set of read-only properties that might be exposed for each individual frame."]
pub type rs2_frame_metadata_value = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_frame_metadata_to_string(
        metadata: rs2_frame_metadata_value,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rs2_frame_metadata_value_to_string(
        metadata: rs2_frame_metadata_value,
    ) -> *const ::std::os::raw::c_char;
}
#[doc = "< Flat rectangle with vertices as the centers of Gaussian dots"]
pub const rs2_calib_target_type_RS2_CALIB_TARGET_RECT_GAUSSIAN_DOT_VERTICES: rs2_calib_target_type =
    0;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_calib_target_type_RS2_CALIB_TARGET_COUNT: rs2_calib_target_type = 1;
#[doc = " \\brief Calibration target type."]
pub type rs2_calib_target_type = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_calib_target_type_to_string(
        type_: rs2_calib_target_type,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " retrieve metadata from frame handle"]
    #[doc = " \\param[in] frame      handle returned from a callback"]
    #[doc = " \\param[in] frame_metadata  the rs2_frame_metadata whose latest frame we are interested in"]
    #[doc = " \\param[out] error         if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            the metadata value"]
    pub fn rs2_get_frame_metadata(
        frame: *const rs2_frame,
        frame_metadata: rs2_frame_metadata_value,
        error: *mut *mut rs2_error,
    ) -> rs2_metadata_type;
}
extern "C" {
    #[doc = " determine device metadata"]
    #[doc = " \\param[in] frame             handle returned from a callback"]
    #[doc = " \\param[in] frame_metadata    the metadata to check for support"]
    #[doc = " \\param[out] error         if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                true if device has this metadata"]
    pub fn rs2_supports_frame_metadata(
        frame: *const rs2_frame,
        frame_metadata: rs2_frame_metadata_value,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " retrieve timestamp domain from frame handle. timestamps can only be comparable if they are in common domain"]
    #[doc = " (for example, depth timestamp might come from system time while color timestamp might come from the device)"]
    #[doc = " this method is used to check if two timestamp values are comparable (generated from the same clock)"]
    #[doc = " \\param[in] frameset   handle returned from a callback"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               the timestamp domain of the frame (camera / microcontroller / system time)"]
    pub fn rs2_get_frame_timestamp_domain(
        frameset: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> rs2_timestamp_domain;
}
extern "C" {
    #[doc = " retrieve timestamp from frame handle in milliseconds"]
    #[doc = " \\param[in] frame      handle returned from a callback"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               the timestamp of the frame in milliseconds"]
    pub fn rs2_get_frame_timestamp(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> rs2_time_t;
}
extern "C" {
    #[doc = " retrieve frame parent sensor from frame handle"]
    #[doc = " \\param[in] frame      handle returned from a callback"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               the parent sensor of the frame"]
    pub fn rs2_get_frame_sensor(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_sensor;
}
extern "C" {
    #[doc = " retrieve frame number from frame handle"]
    #[doc = " \\param[in] frame      handle returned from a callback"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               the frame nubmer of the frame, in milliseconds since the device was started"]
    pub fn rs2_get_frame_number(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    #[doc = " retrieve data size from frame handle"]
    #[doc = " \\param[in] frame      handle returned from a callback"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               the size of the frame data"]
    pub fn rs2_get_frame_data_size(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " retrieve data from frame handle"]
    #[doc = " \\param[in] frame      handle returned from a callback"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               the pointer to the start of the frame data"]
    pub fn rs2_get_frame_data(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " retrieve frame width in pixels"]
    #[doc = " \\param[in] frame      handle returned from a callback"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               frame width in pixels"]
    pub fn rs2_get_frame_width(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " retrieve frame height in pixels"]
    #[doc = " \\param[in] frame      handle returned from a callback"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               frame height in pixels"]
    pub fn rs2_get_frame_height(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " retrieve the scaling factor to use when converting a depth frame's get_data() units to meters"]
    #[doc = " \\return float - depth, in meters, per 1 unit stored in the frame data"]
    pub fn rs2_depth_frame_get_units(frame: *const rs2_frame, error: *mut *mut rs2_error) -> f32;
}
extern "C" {
    #[doc = " retrieve frame stride in bytes (number of bytes from start of line N to start of line N+1)"]
    #[doc = " \\param[in] frame      handle returned from a callback"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               stride in bytes"]
    pub fn rs2_get_frame_stride_in_bytes(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " retrieve bits per pixels in the frame image"]
    #[doc = " (note that bits per pixel is not necessarily divided by 8, as in 12bpp)"]
    #[doc = " \\param[in] frame      handle returned from a callback"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               bits per pixel"]
    pub fn rs2_get_frame_bits_per_pixel(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " create additional reference to a frame without duplicating frame data"]
    #[doc = " \\param[in] frame      handle returned from a callback"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               new frame reference, has to be released by rs2_release_frame"]
    pub fn rs2_frame_add_ref(frame: *mut rs2_frame, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " relases the frame handle"]
    #[doc = " \\param[in] frame handle returned from a callback"]
    pub fn rs2_release_frame(frame: *mut rs2_frame);
}
extern "C" {
    #[doc = " communicate to the library you intend to keep the frame alive for a while"]
    #[doc = " this will remove the frame from the regular count of the frame pool"]
    #[doc = " once this function is called, the SDK can no longer guarantee 0-allocations during frame cycling"]
    #[doc = " \\param[in] frame handle returned from a callback"]
    pub fn rs2_keep_frame(frame: *mut rs2_frame);
}
extern "C" {
    #[doc = " When called on Points frame type, this method returns a pointer to an array of 3D vertices of the model"]
    #[doc = " The coordinate system is: X right, Y up, Z away from the camera. Units: Meters"]
    #[doc = " \\param[in] frame       Points frame"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                Pointer to an array of vertices, lifetime is managed by the frame"]
    pub fn rs2_get_frame_vertices(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_vertex;
}
extern "C" {
    #[doc = " When called on Points frame type, this method creates a ply file of the model with the given file name."]
    #[doc = " \\param[in] frame       Points frame"]
    #[doc = " \\param[in] fname       The name for the ply file"]
    #[doc = " \\param[in] texture     Texture frame"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_export_to_ply(
        frame: *const rs2_frame,
        fname: *const ::std::os::raw::c_char,
        texture: *mut rs2_frame,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " When called on Points frame type, this method returns a pointer to an array of texture coordinates per vertex"]
    #[doc = " Each coordinate represent a (u,v) pair within [0,1] range, to be mapped to texture image"]
    #[doc = " \\param[in] frame       Points frame"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                Pointer to an array of texture coordinates, lifetime is managed by the frame"]
    pub fn rs2_get_frame_texture_coordinates(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_pixel;
}
extern "C" {
    #[doc = " When called on Points frame type, this method returns the number of vertices in the frame"]
    #[doc = " \\param[in] frame       Points frame"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                Number of vertices"]
    pub fn rs2_get_frame_points_count(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the stream profile that was used to start the stream of this frame"]
    #[doc = " \\param[in] frame       frame reference, owned by the user"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                Pointer to the stream profile object, lifetime is managed elsewhere"]
    pub fn rs2_get_frame_stream_profile(
        frame: *const rs2_frame,
        error: *mut *mut rs2_error,
    ) -> *const rs2_stream_profile;
}
extern "C" {
    #[doc = " Test if the given frame can be extended to the requested extension"]
    #[doc = " \\param[in]  frame             Realsense frame"]
    #[doc = " \\param[in]  extension_type    The extension to which the frame should be tested if it is extendable"]
    #[doc = " \\param[out] error             If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return non-zero value iff the frame can be extended to the given extension"]
    pub fn rs2_is_frame_extendable_to(
        frame: *const rs2_frame,
        extension_type: rs2_extension,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate new video frame using a frame-source provided form a processing block"]
    #[doc = " \\param[in] source      Frame pool to allocate the frame from"]
    #[doc = " \\param[in] new_stream  New stream profile to assign to newly created frame"]
    #[doc = " \\param[in] original    A reference frame that can be used to fill in auxilary information like format, width, height, bpp, stride (if applicable)"]
    #[doc = " \\param[in] new_bpp     New value for bits per pixel for the allocated frame"]
    #[doc = " \\param[in] new_width   New value for width for the allocated frame"]
    #[doc = " \\param[in] new_height  New value for height for the allocated frame"]
    #[doc = " \\param[in] new_stride  New value for stride in bytes for the allocated frame"]
    #[doc = " \\param[in] frame_type  New value for frame type for the allocated frame"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                reference to a newly allocated frame, must be released with release_frame"]
    #[doc = "                        memory for the frame is likely to be re-used from previous frame, but in lack of available frames in the pool will be allocated from the free store"]
    pub fn rs2_allocate_synthetic_video_frame(
        source: *mut rs2_source,
        new_stream: *const rs2_stream_profile,
        original: *mut rs2_frame,
        new_bpp: ::std::os::raw::c_int,
        new_width: ::std::os::raw::c_int,
        new_height: ::std::os::raw::c_int,
        new_stride: ::std::os::raw::c_int,
        frame_type: rs2_extension,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_frame;
}
extern "C" {
    #[doc = " Allocate new motion frame using a frame-source provided form a processing block"]
    #[doc = " \\param[in] source      Frame pool to allocate the frame from"]
    #[doc = " \\param[in] new_stream  New stream profile to assign to newly created frame"]
    #[doc = " \\param[in] original    A reference frame that can be used to fill in auxilary information like format, width, height, bpp, stride (if applicable)"]
    #[doc = " \\param[in] frame_type  New value for frame type for the allocated frame"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                reference to a newly allocated frame, must be released with release_frame"]
    #[doc = "                        memory for the frame is likely to be re-used from previous frame, but in lack of available frames in the pool will be allocated from the free store"]
    pub fn rs2_allocate_synthetic_motion_frame(
        source: *mut rs2_source,
        new_stream: *const rs2_stream_profile,
        original: *mut rs2_frame,
        frame_type: rs2_extension,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_frame;
}
extern "C" {
    #[doc = " Allocate new points frame using a frame-source provided from a processing block"]
    #[doc = " \\param[in] source      Frame pool to allocate the frame from"]
    #[doc = " \\param[in] new_stream  New stream profile to assign to newly created frame"]
    #[doc = " \\param[in] original    A reference frame that can be used to fill in auxilary information like format, width, height, bpp, stride (if applicable)"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                reference to a newly allocated frame, must be released with release_frame"]
    #[doc = "                        memory for the frame is likely to be re-used from previous frame, but in lack of available frames in the pool will be allocated from the free store"]
    pub fn rs2_allocate_points(
        source: *mut rs2_source,
        new_stream: *const rs2_stream_profile,
        original: *mut rs2_frame,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_frame;
}
extern "C" {
    #[doc = " Allocate new composite frame, aggregating a set of existing frames"]
    #[doc = " \\param[in] source      Frame pool to allocate the frame from"]
    #[doc = " \\param[in] frames      Array of existing frames"]
    #[doc = " \\param[in] count       Number of input frames"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                reference to a newly allocated frame, must be released with release_frame"]
    #[doc = "                        when composite frame gets released it will automatically release all of the input frames"]
    pub fn rs2_allocate_composite_frame(
        source: *mut rs2_source,
        frames: *mut *mut rs2_frame,
        count: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_frame;
}
extern "C" {
    #[doc = " Extract frame from within a composite frame"]
    #[doc = " \\param[in] composite   Composite frame"]
    #[doc = " \\param[in] index       Index of the frame to extract within the composite frame"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                returns reference to a frame existing within the composite frame"]
    #[doc = "                        If you wish to keep this frame after the composite is released, you need to call acquire_ref"]
    #[doc = "                        Otherwise the resulting frame lifetime is bound by owning composite frame"]
    pub fn rs2_extract_frame(
        composite: *mut rs2_frame,
        index: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_frame;
}
extern "C" {
    #[doc = " Get number of frames embedded within a composite frame"]
    #[doc = " \\param[in] composite   Composite input frame"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return                Number of embedded frames"]
    pub fn rs2_embedded_frames_count(
        composite: *mut rs2_frame,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " This method will dispatch frame callback on a frame"]
    #[doc = " \\param[in] source      Frame pool provided by the processing block"]
    #[doc = " \\param[in] frame       Frame to dispatch, frame ownership is passed to this function, so you don't have to call release_frame after it"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_synthetic_frame_ready(
        source: *mut rs2_source,
        frame: *mut rs2_frame,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " When called on Pose frame type, this method returns the transformation represented by the pose data"]
    #[doc = " \\param[in] frame       Pose frame"]
    #[doc = " \\param[out] pose       Pointer to a user allocated struct, which contains the pose info after a successful return"]
    #[doc = " \\param[out] error      If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_pose_frame_get_pose_data(
        frame: *const rs2_frame,
        pose: *mut rs2_pose,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Extract the target dimensions on the specific target"]
    #[doc = " \\param[in] frame            Left or right camera frame of specified size based on the target type"]
    #[doc = " \\param[in] calib_type       Calibration target type"]
    #[doc = " \\param[in] target_dims_size Target dimension array size"]
    #[doc = " \\param[out] target_dims     The array to hold the result target dimensions calculated. For type RS2_CALIB_TARGET_RECT_GAUSSIAN_DOT_VERTICES, the four rectangle side sizes in pixels with the order of top, bottom, left, and right"]
    #[doc = " \\param[out] error           If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_extract_target_dimensions(
        frame: *const rs2_frame,
        calib_type: rs2_calib_target_type,
        target_dims: *mut f32,
        target_dims_size: ::std::os::raw::c_uint,
        error: *mut *mut rs2_error,
    );
}
#[doc = "< Enable / disable color backlight compensation"]
pub const rs2_option_RS2_OPTION_BACKLIGHT_COMPENSATION: rs2_option = 0;
#[doc = "< Color image brightness"]
pub const rs2_option_RS2_OPTION_BRIGHTNESS: rs2_option = 1;
#[doc = "< Color image contrast"]
pub const rs2_option_RS2_OPTION_CONTRAST: rs2_option = 2;
#[doc = "< Controls exposure time of color camera. Setting any value will disable auto exposure"]
pub const rs2_option_RS2_OPTION_EXPOSURE: rs2_option = 3;
#[doc = "< Color image gain"]
pub const rs2_option_RS2_OPTION_GAIN: rs2_option = 4;
#[doc = "< Color image gamma setting"]
pub const rs2_option_RS2_OPTION_GAMMA: rs2_option = 5;
#[doc = "< Color image hue"]
pub const rs2_option_RS2_OPTION_HUE: rs2_option = 6;
#[doc = "< Color image saturation setting"]
pub const rs2_option_RS2_OPTION_SATURATION: rs2_option = 7;
#[doc = "< Color image sharpness setting"]
pub const rs2_option_RS2_OPTION_SHARPNESS: rs2_option = 8;
#[doc = "< Controls white balance of color image. Setting any value will disable auto white balance"]
pub const rs2_option_RS2_OPTION_WHITE_BALANCE: rs2_option = 9;
#[doc = "< Enable / disable color image auto-exposure"]
pub const rs2_option_RS2_OPTION_ENABLE_AUTO_EXPOSURE: rs2_option = 10;
#[doc = "< Enable / disable color image auto-white-balance"]
pub const rs2_option_RS2_OPTION_ENABLE_AUTO_WHITE_BALANCE: rs2_option = 11;
#[doc = "< Provide access to several recommend sets of option presets for the depth camera"]
pub const rs2_option_RS2_OPTION_VISUAL_PRESET: rs2_option = 12;
#[doc = "< Power of the laser emitter, with 0 meaning projector off"]
pub const rs2_option_RS2_OPTION_LASER_POWER: rs2_option = 13;
#[doc = "< Set the number of patterns projected per frame. The higher the accuracy value the more patterns projected. Increasing the number of patterns help to achieve better accuracy. Note that this control is affecting the Depth FPS"]
pub const rs2_option_RS2_OPTION_ACCURACY: rs2_option = 14;
#[doc = "< Motion vs. Range trade-off, with lower values allowing for better motion sensitivity and higher values allowing for better depth range"]
pub const rs2_option_RS2_OPTION_MOTION_RANGE: rs2_option = 15;
#[doc = "< Set the filter to apply to each depth frame. Each one of the filter is optimized per the application requirements"]
pub const rs2_option_RS2_OPTION_FILTER_OPTION: rs2_option = 16;
#[doc = "< The confidence level threshold used by the Depth algorithm pipe to set whether a pixel will get a valid range or will be marked with invalid range"]
pub const rs2_option_RS2_OPTION_CONFIDENCE_THRESHOLD: rs2_option = 17;
#[doc = "< Emitter select: 0 – disable all emitters. 1 – enable laser. 2 – enable auto laser. 3 – enable LED."]
pub const rs2_option_RS2_OPTION_EMITTER_ENABLED: rs2_option = 18;
#[doc = "< Number of frames the user is allowed to keep per stream. Trying to hold-on to more frames will cause frame-drops."]
pub const rs2_option_RS2_OPTION_FRAMES_QUEUE_SIZE: rs2_option = 19;
#[doc = "< Total number of detected frame drops from all streams"]
pub const rs2_option_RS2_OPTION_TOTAL_FRAME_DROPS: rs2_option = 20;
#[doc = "< Auto-Exposure modes: Static, Anti-Flicker and Hybrid"]
pub const rs2_option_RS2_OPTION_AUTO_EXPOSURE_MODE: rs2_option = 21;
#[doc = "< Power Line Frequency control for anti-flickering Off/50Hz/60Hz/Auto"]
pub const rs2_option_RS2_OPTION_POWER_LINE_FREQUENCY: rs2_option = 22;
#[doc = "< Current Asic Temperature"]
pub const rs2_option_RS2_OPTION_ASIC_TEMPERATURE: rs2_option = 23;
#[doc = "< disable error handling"]
pub const rs2_option_RS2_OPTION_ERROR_POLLING_ENABLED: rs2_option = 24;
#[doc = "< Current Projector Temperature"]
pub const rs2_option_RS2_OPTION_PROJECTOR_TEMPERATURE: rs2_option = 25;
#[doc = "< Enable / disable trigger to be outputed from the camera to any external device on every depth frame"]
pub const rs2_option_RS2_OPTION_OUTPUT_TRIGGER_ENABLED: rs2_option = 26;
#[doc = "< Current Motion-Module Temperature"]
pub const rs2_option_RS2_OPTION_MOTION_MODULE_TEMPERATURE: rs2_option = 27;
#[doc = "< Number of meters represented by a single depth unit"]
pub const rs2_option_RS2_OPTION_DEPTH_UNITS: rs2_option = 28;
#[doc = "< Enable/Disable automatic correction of the motion data"]
pub const rs2_option_RS2_OPTION_ENABLE_MOTION_CORRECTION: rs2_option = 29;
#[doc = "< Allows sensor to dynamically ajust the frame rate depending on lighting conditions"]
pub const rs2_option_RS2_OPTION_AUTO_EXPOSURE_PRIORITY: rs2_option = 30;
#[doc = "< Color scheme for data visualization"]
pub const rs2_option_RS2_OPTION_COLOR_SCHEME: rs2_option = 31;
#[doc = "< Perform histogram equalization post-processing on the depth data"]
pub const rs2_option_RS2_OPTION_HISTOGRAM_EQUALIZATION_ENABLED: rs2_option = 32;
#[doc = "< Minimal distance to the target"]
pub const rs2_option_RS2_OPTION_MIN_DISTANCE: rs2_option = 33;
#[doc = "< Maximum distance to the target"]
pub const rs2_option_RS2_OPTION_MAX_DISTANCE: rs2_option = 34;
#[doc = "< Texture mapping stream unique ID"]
pub const rs2_option_RS2_OPTION_TEXTURE_SOURCE: rs2_option = 35;
#[doc = "< The 2D-filter effect. The specific interpretation is given within the context of the filter"]
pub const rs2_option_RS2_OPTION_FILTER_MAGNITUDE: rs2_option = 36;
#[doc = "< 2D-filter parameter controls the weight/radius for smoothing."]
pub const rs2_option_RS2_OPTION_FILTER_SMOOTH_ALPHA: rs2_option = 37;
#[doc = "< 2D-filter range/validity threshold"]
pub const rs2_option_RS2_OPTION_FILTER_SMOOTH_DELTA: rs2_option = 38;
#[doc = "< Enhance depth data post-processing with holes filling where appropriate"]
pub const rs2_option_RS2_OPTION_HOLES_FILL: rs2_option = 39;
#[doc = "< The distance in mm between the first and the second imagers in stereo-based depth cameras"]
pub const rs2_option_RS2_OPTION_STEREO_BASELINE: rs2_option = 40;
#[doc = "< Allows dynamically ajust the converge step value of the target exposure in Auto-Exposure algorithm"]
pub const rs2_option_RS2_OPTION_AUTO_EXPOSURE_CONVERGE_STEP: rs2_option = 41;
#[doc = "< Impose Inter-camera HW synchronization mode. Applicable for D400/L500/Rolling Shutter SKUs"]
pub const rs2_option_RS2_OPTION_INTER_CAM_SYNC_MODE: rs2_option = 42;
#[doc = "< Select a stream to process"]
pub const rs2_option_RS2_OPTION_STREAM_FILTER: rs2_option = 43;
#[doc = "< Select a stream format to process"]
pub const rs2_option_RS2_OPTION_STREAM_FORMAT_FILTER: rs2_option = 44;
#[doc = "< Select a stream index to process"]
pub const rs2_option_RS2_OPTION_STREAM_INDEX_FILTER: rs2_option = 45;
#[doc = "< When supported, this option make the camera to switch the emitter state every frame. 0 for disabled, 1 for enabled"]
pub const rs2_option_RS2_OPTION_EMITTER_ON_OFF: rs2_option = 46;
#[doc = "< Deprecated!!! - Zero order point x"]
pub const rs2_option_RS2_OPTION_ZERO_ORDER_POINT_X: rs2_option = 47;
#[doc = "< Deprecated!!! - Zero order point y"]
pub const rs2_option_RS2_OPTION_ZERO_ORDER_POINT_Y: rs2_option = 48;
#[doc = "< LDD temperature"]
pub const rs2_option_RS2_OPTION_LLD_TEMPERATURE: rs2_option = 49;
#[doc = "< MC temperature"]
pub const rs2_option_RS2_OPTION_MC_TEMPERATURE: rs2_option = 50;
#[doc = "< MA temperature"]
pub const rs2_option_RS2_OPTION_MA_TEMPERATURE: rs2_option = 51;
#[doc = "< Hardware stream configuration"]
pub const rs2_option_RS2_OPTION_HARDWARE_PRESET: rs2_option = 52;
#[doc = "< disable global time"]
pub const rs2_option_RS2_OPTION_GLOBAL_TIME_ENABLED: rs2_option = 53;
#[doc = "< APD temperature"]
pub const rs2_option_RS2_OPTION_APD_TEMPERATURE: rs2_option = 54;
#[doc = "< Enable an internal map"]
pub const rs2_option_RS2_OPTION_ENABLE_MAPPING: rs2_option = 55;
#[doc = "< Enable appearance based relocalization"]
pub const rs2_option_RS2_OPTION_ENABLE_RELOCALIZATION: rs2_option = 56;
#[doc = "< Enable position jumping"]
pub const rs2_option_RS2_OPTION_ENABLE_POSE_JUMPING: rs2_option = 57;
#[doc = "< Enable dynamic calibration"]
pub const rs2_option_RS2_OPTION_ENABLE_DYNAMIC_CALIBRATION: rs2_option = 58;
#[doc = "< Offset from sensor to depth origin in millimetrers"]
pub const rs2_option_RS2_OPTION_DEPTH_OFFSET: rs2_option = 59;
#[doc = "< Power of the LED (light emitting diode), with 0 meaning LED off"]
pub const rs2_option_RS2_OPTION_LED_POWER: rs2_option = 60;
#[doc = "< DEPRECATED! - Toggle Zero-Order mode"]
pub const rs2_option_RS2_OPTION_ZERO_ORDER_ENABLED: rs2_option = 61;
#[doc = "< Preserve previous map when starting"]
pub const rs2_option_RS2_OPTION_ENABLE_MAP_PRESERVATION: rs2_option = 62;
#[doc = "< Enable/disable sensor shutdown when a free-fall is detected (on by default)"]
pub const rs2_option_RS2_OPTION_FREEFALL_DETECTION_ENABLED: rs2_option = 63;
#[doc = "< Changes the exposure time of Avalanche Photo Diode in the receiver"]
pub const rs2_option_RS2_OPTION_AVALANCHE_PHOTO_DIODE: rs2_option = 64;
#[doc = "< Changes the amount of sharpening in the post-processed image"]
pub const rs2_option_RS2_OPTION_POST_PROCESSING_SHARPENING: rs2_option = 65;
#[doc = "< Changes the amount of sharpening in the pre-processed image"]
pub const rs2_option_RS2_OPTION_PRE_PROCESSING_SHARPENING: rs2_option = 66;
#[doc = "< Control edges and background noise"]
pub const rs2_option_RS2_OPTION_NOISE_FILTERING: rs2_option = 67;
#[doc = "< Enable\\disable pixel invalidation"]
pub const rs2_option_RS2_OPTION_INVALIDATION_BYPASS: rs2_option = 68;
#[doc = "< DEPRECATED! - Use RS2_OPTION_DIGITAL_GAIN instead."]
pub const rs2_option_RS2_OPTION_AMBIENT_LIGHT: rs2_option = 69;
#[doc = "< Change the depth digital gain see rs2_digital_gain for values"]
pub const rs2_option_RS2_OPTION_DIGITAL_GAIN: rs2_option = 69;
#[doc = "< The resolution mode: see rs2_sensor_mode for values"]
pub const rs2_option_RS2_OPTION_SENSOR_MODE: rs2_option = 70;
#[doc = "< Enable Laser On constantly (GS SKU Only)"]
pub const rs2_option_RS2_OPTION_EMITTER_ALWAYS_ON: rs2_option = 71;
#[doc = "< Depth Thermal Compensation for selected D400 SKUs"]
pub const rs2_option_RS2_OPTION_THERMAL_COMPENSATION: rs2_option = 72;
#[doc = "< DEPRECATED as of 2.46!"]
pub const rs2_option_RS2_OPTION_TRIGGER_CAMERA_ACCURACY_HEALTH: rs2_option = 73;
#[doc = "< DEPRECATED as of 2.46!"]
pub const rs2_option_RS2_OPTION_RESET_CAMERA_ACCURACY_HEALTH: rs2_option = 74;
#[doc = "< Set host performance mode to optimize device settings so host can keep up with workload, for example, USB transaction granularity, setting option to low performance host leads to larger USB transaction size and reduced number of transactions which improves performance and stability if host is relatively weak as compared to workload"]
pub const rs2_option_RS2_OPTION_HOST_PERFORMANCE: rs2_option = 75;
#[doc = "< Enable / disable HDR"]
pub const rs2_option_RS2_OPTION_HDR_ENABLED: rs2_option = 76;
#[doc = "< HDR Sequence name"]
pub const rs2_option_RS2_OPTION_SEQUENCE_NAME: rs2_option = 77;
#[doc = "< HDR Sequence size"]
pub const rs2_option_RS2_OPTION_SEQUENCE_SIZE: rs2_option = 78;
#[doc = "< HDR Sequence ID - 0 is not HDR; sequence ID for HDR configuration starts from 1"]
pub const rs2_option_RS2_OPTION_SEQUENCE_ID: rs2_option = 79;
#[doc = "< Humidity temperature [Deg Celsius]"]
pub const rs2_option_RS2_OPTION_HUMIDITY_TEMPERATURE: rs2_option = 80;
#[doc = "< Turn on/off the maximum usable depth sensor range given the amount of ambient light in the scene"]
pub const rs2_option_RS2_OPTION_ENABLE_MAX_USABLE_RANGE: rs2_option = 81;
#[doc = "< Turn on/off the alternate IR, When enabling alternate IR, the IR image is holding the amplitude of the depth correlation."]
pub const rs2_option_RS2_OPTION_ALTERNATE_IR: rs2_option = 82;
#[doc = "< Noise estimation - indicates the noise on the IR image"]
pub const rs2_option_RS2_OPTION_NOISE_ESTIMATION: rs2_option = 83;
#[doc = "< Enables data collection for calculating IR pixel reflectivity"]
pub const rs2_option_RS2_OPTION_ENABLE_IR_REFLECTIVITY: rs2_option = 84;
#[doc = "< Set and get auto exposure limit in microseconds. Default is 0 which means full exposure range. If the requested exposure limit is greater than frame time, it will be set to frame time at runtime. Setting will not take effect until next streaming session."]
pub const rs2_option_RS2_OPTION_AUTO_EXPOSURE_LIMIT: rs2_option = 85;
#[doc = "< Set and get auto gain limits ranging from 16 to 248. Default is 0 which means full gain. If the requested gain limit is less than 16, it will be set to 16. If the requested gain limit is greater than 248, it will be set to 248. Setting will not take effect until next streaming session."]
pub const rs2_option_RS2_OPTION_AUTO_GAIN_LIMIT: rs2_option = 86;
#[doc = "< Enable receiver sensitivity according to ambient light, bounded by the Receiver Gain control."]
pub const rs2_option_RS2_OPTION_AUTO_RX_SENSITIVITY: rs2_option = 87;
#[doc = "<changes the transmitter frequencies increasing effective range over sharpness."]
pub const rs2_option_RS2_OPTION_TRANSMITTER_FREQUENCY: rs2_option = 88;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_option_RS2_OPTION_COUNT: rs2_option = 89;
#[doc = " \\brief Defines general configuration controls."]
#[doc = "These can generally be mapped to camera UVC controls, and can be set / queried at any time unless stated otherwise."]
pub type rs2_option = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_option_to_string(option: rs2_option) -> *const ::std::os::raw::c_char;
}
#[doc = "< Preset for short range"]
pub const rs2_sr300_visual_preset_RS2_SR300_VISUAL_PRESET_SHORT_RANGE: rs2_sr300_visual_preset = 0;
#[doc = "< Preset for long range"]
pub const rs2_sr300_visual_preset_RS2_SR300_VISUAL_PRESET_LONG_RANGE: rs2_sr300_visual_preset = 1;
#[doc = "< Preset for background segmentation"]
pub const rs2_sr300_visual_preset_RS2_SR300_VISUAL_PRESET_BACKGROUND_SEGMENTATION:
    rs2_sr300_visual_preset = 2;
#[doc = "< Preset for gesture recognition"]
pub const rs2_sr300_visual_preset_RS2_SR300_VISUAL_PRESET_GESTURE_RECOGNITION:
    rs2_sr300_visual_preset = 3;
#[doc = "< Preset for object scanning"]
pub const rs2_sr300_visual_preset_RS2_SR300_VISUAL_PRESET_OBJECT_SCANNING: rs2_sr300_visual_preset =
    4;
#[doc = "< Preset for face analytics"]
pub const rs2_sr300_visual_preset_RS2_SR300_VISUAL_PRESET_FACE_ANALYTICS: rs2_sr300_visual_preset =
    5;
#[doc = "< Preset for face login"]
pub const rs2_sr300_visual_preset_RS2_SR300_VISUAL_PRESET_FACE_LOGIN: rs2_sr300_visual_preset = 6;
#[doc = "< Preset for GR cursor"]
pub const rs2_sr300_visual_preset_RS2_SR300_VISUAL_PRESET_GR_CURSOR: rs2_sr300_visual_preset = 7;
#[doc = "< Camera default settings"]
pub const rs2_sr300_visual_preset_RS2_SR300_VISUAL_PRESET_DEFAULT: rs2_sr300_visual_preset = 8;
#[doc = "< Preset for mid-range"]
pub const rs2_sr300_visual_preset_RS2_SR300_VISUAL_PRESET_MID_RANGE: rs2_sr300_visual_preset = 9;
#[doc = "< Preset for IR only"]
pub const rs2_sr300_visual_preset_RS2_SR300_VISUAL_PRESET_IR_ONLY: rs2_sr300_visual_preset = 10;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_sr300_visual_preset_RS2_SR300_VISUAL_PRESET_COUNT: rs2_sr300_visual_preset = 11;
#[doc = " \\brief For SR300 devices: provides optimized settings (presets) for specific types of usage."]
pub type rs2_sr300_visual_preset = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_sr300_visual_preset_to_string(
        preset: rs2_sr300_visual_preset,
    ) -> *const ::std::os::raw::c_char;
}
pub const rs2_rs400_visual_preset_RS2_RS400_VISUAL_PRESET_CUSTOM: rs2_rs400_visual_preset = 0;
pub const rs2_rs400_visual_preset_RS2_RS400_VISUAL_PRESET_DEFAULT: rs2_rs400_visual_preset = 1;
pub const rs2_rs400_visual_preset_RS2_RS400_VISUAL_PRESET_HAND: rs2_rs400_visual_preset = 2;
pub const rs2_rs400_visual_preset_RS2_RS400_VISUAL_PRESET_HIGH_ACCURACY: rs2_rs400_visual_preset =
    3;
pub const rs2_rs400_visual_preset_RS2_RS400_VISUAL_PRESET_HIGH_DENSITY: rs2_rs400_visual_preset = 4;
pub const rs2_rs400_visual_preset_RS2_RS400_VISUAL_PRESET_MEDIUM_DENSITY: rs2_rs400_visual_preset =
    5;
pub const rs2_rs400_visual_preset_RS2_RS400_VISUAL_PRESET_REMOVE_IR_PATTERN:
    rs2_rs400_visual_preset = 6;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_rs400_visual_preset_RS2_RS400_VISUAL_PRESET_COUNT: rs2_rs400_visual_preset = 7;
#[doc = " \\brief For RS400 devices: provides optimized settings (presets) for specific types of usage."]
pub type rs2_rs400_visual_preset = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_rs400_visual_preset_to_string(
        preset: rs2_rs400_visual_preset,
    ) -> *const ::std::os::raw::c_char;
}
pub const rs2_l500_visual_preset_RS2_L500_VISUAL_PRESET_CUSTOM: rs2_l500_visual_preset = 0;
pub const rs2_l500_visual_preset_RS2_L500_VISUAL_PRESET_DEFAULT: rs2_l500_visual_preset = 1;
pub const rs2_l500_visual_preset_RS2_L500_VISUAL_PRESET_NO_AMBIENT: rs2_l500_visual_preset = 2;
pub const rs2_l500_visual_preset_RS2_L500_VISUAL_PRESET_LOW_AMBIENT: rs2_l500_visual_preset = 3;
pub const rs2_l500_visual_preset_RS2_L500_VISUAL_PRESET_MAX_RANGE: rs2_l500_visual_preset = 4;
pub const rs2_l500_visual_preset_RS2_L500_VISUAL_PRESET_SHORT_RANGE: rs2_l500_visual_preset = 5;
pub const rs2_l500_visual_preset_RS2_L500_VISUAL_PRESET_AUTOMATIC: rs2_l500_visual_preset = 6;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_l500_visual_preset_RS2_L500_VISUAL_PRESET_COUNT: rs2_l500_visual_preset = 7;
#[doc = " \\brief For L500 devices: provides optimized settings (presets) for specific types of usage."]
pub type rs2_l500_visual_preset = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_l500_visual_preset_to_string(
        preset: rs2_l500_visual_preset,
    ) -> *const ::std::os::raw::c_char;
}
pub const rs2_sensor_mode_RS2_SENSOR_MODE_VGA: rs2_sensor_mode = 0;
pub const rs2_sensor_mode_RS2_SENSOR_MODE_XGA: rs2_sensor_mode = 1;
pub const rs2_sensor_mode_RS2_SENSOR_MODE_QVGA: rs2_sensor_mode = 2;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_sensor_mode_RS2_SENSOR_MODE_COUNT: rs2_sensor_mode = 3;
#[doc = " \\brief For setting the camera_mode option"]
pub type rs2_sensor_mode = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_sensor_mode_to_string(preset: rs2_sensor_mode) -> *const ::std::os::raw::c_char;
}
pub const rs2_ambient_light_RS2_AMBIENT_LIGHT_NO_AMBIENT: rs2_ambient_light = 1;
pub const rs2_ambient_light_RS2_AMBIENT_LIGHT_LOW_AMBIENT: rs2_ambient_light = 2;
#[doc = " \\brief  DEPRECATED! - Use RS2_OPTION_DIGITAL_GAIN instead."]
pub type rs2_ambient_light = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_ambient_light_to_string(preset: rs2_ambient_light) -> *const ::std::os::raw::c_char;
}
pub const rs2_digital_gain_RS2_DIGITAL_GAIN_AUTO: rs2_digital_gain = 0;
pub const rs2_digital_gain_RS2_DIGITAL_GAIN_HIGH: rs2_digital_gain = 1;
pub const rs2_digital_gain_RS2_DIGITAL_GAIN_LOW: rs2_digital_gain = 2;
#[doc = " \\brief digital gain for RS2_OPTION_DIGITAL_GAIN option."]
pub type rs2_digital_gain = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_digital_gain_to_string(preset: rs2_digital_gain) -> *const ::std::os::raw::c_char;
}
#[doc = "< no change in settings, use device defaults"]
pub const rs2_host_perf_mode_RS2_HOST_PERF_DEFAULT: rs2_host_perf_mode = 0;
#[doc = "< low performance host mode, if host cannot keep up with workload, this option may improve stability, for example, it sets larger USB transaction granularity, reduces number of transactions and improve performance and stability on relatively weak hosts as compared to the workload"]
pub const rs2_host_perf_mode_RS2_HOST_PERF_LOW: rs2_host_perf_mode = 1;
#[doc = "< high performance host mode, if host is strong as compared to the work and can handle workload without delay, this option sets smaller USB transactions granularity and as result larger number of transactions and workload on host, but reduces chance in device frame drops"]
pub const rs2_host_perf_mode_RS2_HOST_PERF_HIGH: rs2_host_perf_mode = 2;
#[doc = "< Number of enumeration values. Not a valid input: intended to be used in for-loops."]
pub const rs2_host_perf_mode_RS2_HOST_PERF_COUNT: rs2_host_perf_mode = 3;
#[doc = " \\brief values for RS2_OPTION_HOST_PERFORMANCE option."]
pub type rs2_host_perf_mode = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_host_perf_mode_to_string(perf: rs2_host_perf_mode) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " check if an option is read-only"]
    #[doc = " \\param[in] options  the options container"]
    #[doc = " \\param[in] option   option id to be checked"]
    #[doc = " \\param[out] error   if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return true if option is read-only"]
    pub fn rs2_is_option_read_only(
        options: *const rs2_options,
        option: rs2_option,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " read option value from the sensor"]
    #[doc = " \\param[in] options  the options container"]
    #[doc = " \\param[in] option   option id to be queried"]
    #[doc = " \\param[out] error   if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return value of the option"]
    pub fn rs2_get_option(
        options: *const rs2_options,
        option: rs2_option,
        error: *mut *mut rs2_error,
    ) -> f32;
}
extern "C" {
    #[doc = " write new value to sensor option"]
    #[doc = " \\param[in] options    the options container"]
    #[doc = " \\param[in] option     option id to be queried"]
    #[doc = " \\param[in] value      new value for the option"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_set_option(
        options: *const rs2_options,
        option: rs2_option,
        value: f32,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " get the list of supported options of options container"]
    #[doc = " \\param[in] options    the options container"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_options_list(
        options: *const rs2_options,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_options_list;
}
extern "C" {
    #[doc = " get the size of options list"]
    #[doc = " \\param[in] options    the option list"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_options_list_size(
        options: *const rs2_options_list,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " get option name"]
    #[doc = " \\param[in] options    the options container"]
    #[doc = " \\param[in] option     option id to be checked"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return human-readable option name"]
    pub fn rs2_get_option_name(
        options: *const rs2_options,
        option: rs2_option,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " get the specific option from options list"]
    #[doc = " \\param[in] i    the index of the option"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_option_from_list(
        options: *const rs2_options_list,
        i: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> rs2_option;
}
extern "C" {
    #[doc = " Deletes options list"]
    #[doc = " \\param[in] list list to delete"]
    pub fn rs2_delete_options_list(list: *mut rs2_options_list);
}
extern "C" {
    #[doc = " check if particular option is supported by a subdevice"]
    #[doc = " \\param[in] options    the options container"]
    #[doc = " \\param[in] option     option id to be checked"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return true if option is supported"]
    pub fn rs2_supports_option(
        options: *const rs2_options,
        option: rs2_option,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " retrieve the available range of values of a supported option"]
    #[doc = " \\param[in] sensor  the RealSense device"]
    #[doc = " \\param[in] option  the option whose range should be queried"]
    #[doc = " \\param[out] min    the minimum value which will be accepted for this option"]
    #[doc = " \\param[out] max    the maximum value which will be accepted for this option"]
    #[doc = " \\param[out] step   the granularity of options which accept discrete values, or zero if the option accepts continuous values"]
    #[doc = " \\param[out] def    the default value of the option"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_get_option_range(
        sensor: *const rs2_options,
        option: rs2_option,
        min: *mut f32,
        max: *mut f32,
        step: *mut f32,
        def: *mut f32,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " get option description"]
    #[doc = " \\param[in] options    the options container"]
    #[doc = " \\param[in] option     option id to be checked"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return human-readable option description"]
    pub fn rs2_get_option_description(
        options: *const rs2_options,
        option: rs2_option,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " get option value description (in case specific option value hold special meaning)"]
    #[doc = " \\param[in] options    the options container"]
    #[doc = " \\param[in] option     option id to be checked"]
    #[doc = " \\param[in] value      value of the option"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return human-readable description of a specific value of an option or null if no special meaning"]
    pub fn rs2_get_option_value_description(
        options: *const rs2_options,
        option: rs2_option,
        value: f32,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Creates Depth-Colorizer processing block that can be used to quickly visualize the depth data"]
    #[doc = " This block will accept depth frames as input and replace them by depth frames with format RGB8"]
    #[doc = " Non-depth frames are passed through"]
    #[doc = " Further customization will be added soon (format, color-map, histogram equalization control)"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_colorizer(error: *mut *mut rs2_error) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates Sync processing block. This block accepts arbitrary frames and output composite frames of best matches"]
    #[doc = " Some frames may be released within the syncer if they are waiting for match for too long"]
    #[doc = " Syncronization is done (mostly) based on timestamps so good hardware timestamps are a pre-condition"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_sync_processing_block(
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates Point-Cloud processing block. This block accepts depth frames and outputs Points frames"]
    #[doc = " In addition, given non-depth frame, the block will align texture coordinate to the non-depth stream"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_pointcloud(error: *mut *mut rs2_error) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates YUY decoder processing block. This block accepts raw YUY frames and outputs frames of other formats."]
    #[doc = " YUY is a common video format used by a variety of web-cams. It benefits from packing pixels into 2 bytes per pixel"]
    #[doc = " without signficant quality drop. YUY representation can be converted back to more usable RGB form,"]
    #[doc = " but this requires somewhat costly conversion."]
    #[doc = " The SDK will automatically try to use SSE2 and AVX instructions and CUDA where available to get"]
    #[doc = " best performance. Other implementations (using GLSL, OpenCL, Neon and NCS) should follow."]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_yuy_decoder(error: *mut *mut rs2_error) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates depth thresholding processing block"]
    #[doc = " By controlling min and max options on the block, one could filter out depth values"]
    #[doc = " that are either too large or too small, as a software post-processing step"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_threshold(error: *mut *mut rs2_error) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates depth units transformation processing block"]
    #[doc = " All of the pixels are transformed from depth units into meters."]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_units_transform(error: *mut *mut rs2_error) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " This method creates new custom processing block. This lets the users pass frames between module boundaries for processing"]
    #[doc = " This is an infrastructure function aimed at middleware developers, and also used by provided blocks such as sync, colorizer, etc.."]
    #[doc = " \\param proc       Processing function to be applied to every frame entering the block"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return           new processing block, to be released by rs2_delete_processing_block"]
    pub fn rs2_create_processing_block(
        proc_: *mut rs2_frame_processor_callback,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " This method creates new custom processing block from function pointer. This lets the users pass frames between module boundaries for processing"]
    #[doc = " This is an infrastructure function aimed at middleware developers, and also used by provided blocks such as sync, colorizer, etc.."]
    #[doc = " \\param proc       Processing function pointer to be applied to every frame entering the block"]
    #[doc = " \\param context    User context (can be anything or null) to be passed later as ctx param of the callback"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return           new processing block, to be released by rs2_delete_processing_block"]
    pub fn rs2_create_processing_block_fptr(
        proc_: rs2_frame_processor_callback_ptr,
        context: *mut ::std::os::raw::c_void,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " This method adds a custom option to a custom processing block. This is a simple float that can be accessed via rs2_set_option and rs2_get_option"]
    #[doc = " This is an infrastructure function aimed at middleware developers, and also used by provided blocks such as save_to_ply, etc.."]
    #[doc = " \\param[in] block      Processing block"]
    #[doc = " \\param[in] option_id  an int ID for referencing the option"]
    #[doc = " \\param[in] min     the minimum value which will be accepted for this option"]
    #[doc = " \\param[in] max     the maximum value which will be accepted for this option"]
    #[doc = " \\param[in] step    the granularity of options which accept discrete values, or zero if the option accepts continuous values"]
    #[doc = " \\param[in] def     the default value of the option. This will be the initial value."]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            true if adding the option succeeds. false if it fails e.g. an option with this id is already registered"]
    pub fn rs2_processing_block_register_simple_option(
        block: *mut rs2_processing_block,
        option_id: rs2_option,
        min: f32,
        max: f32,
        step: f32,
        def: f32,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " This method is used to direct the output from the processing block to some callback or sink object"]
    #[doc = " \\param[in] block          Processing block"]
    #[doc = " \\param[in] on_frame       Callback to be invoked every time the processing block calls frame_ready"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_start_processing(
        block: *mut rs2_processing_block,
        on_frame: *mut rs2_frame_callback,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " This method is used to direct the output from the processing block to some callback or sink object"]
    #[doc = " \\param[in] block          Processing block"]
    #[doc = " \\param[in] on_frame       Callback function to be invoked every time the processing block calls frame_ready"]
    #[doc = " \\param[in] user           User context for the callback (can be anything or null)"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_start_processing_fptr(
        block: *mut rs2_processing_block,
        on_frame: rs2_frame_callback_ptr,
        user: *mut ::std::os::raw::c_void,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " This method is used to direct the output from the processing block to a dedicated queue object"]
    #[doc = " \\param[in] block          Processing block"]
    #[doc = " \\param[in] queue          Queue to place the processed frames to"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_start_processing_queue(
        block: *mut rs2_processing_block,
        queue: *mut rs2_frame_queue,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " This method is used to pass frame into a processing block"]
    #[doc = " \\param[in] block          Processing block"]
    #[doc = " \\param[in] frame          Frame to process, ownership is moved to the block object"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_process_frame(
        block: *mut rs2_processing_block,
        frame: *mut rs2_frame,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Deletes the processing block"]
    #[doc = " \\param[in] block          Processing block"]
    pub fn rs2_delete_processing_block(block: *mut rs2_processing_block);
}
extern "C" {
    #[doc = " create frame queue. frame queues are the simplest x-platform synchronization primitive provided by librealsense"]
    #[doc = " to help developers who are not using async APIs"]
    #[doc = " \\param[in] capacity max number of frames to allow to be stored in the queue before older frames will start to get dropped"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return handle to the frame queue, must be released using rs2_delete_frame_queue"]
    pub fn rs2_create_frame_queue(
        capacity: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_frame_queue;
}
extern "C" {
    #[doc = " deletes frame queue and releases all frames inside it"]
    #[doc = " \\param[in] queue queue to delete"]
    pub fn rs2_delete_frame_queue(queue: *mut rs2_frame_queue);
}
extern "C" {
    #[doc = " wait until new frame becomes available in the queue and dequeue it"]
    #[doc = " \\param[in] queue the frame queue data structure"]
    #[doc = " \\param[in] timeout_ms   max time in milliseconds to wait until an exception will be thrown"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return frame handle to be released using rs2_release_frame"]
    pub fn rs2_wait_for_frame(
        queue: *mut rs2_frame_queue,
        timeout_ms: ::std::os::raw::c_uint,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_frame;
}
extern "C" {
    #[doc = " poll if a new frame is available and dequeue if it is"]
    #[doc = " \\param[in] queue the frame queue data structure"]
    #[doc = " \\param[out] output_frame frame handle to be released using rs2_release_frame"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return true if new frame was stored to output_frame"]
    pub fn rs2_poll_for_frame(
        queue: *mut rs2_frame_queue,
        output_frame: *mut *mut rs2_frame,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " wait until new frame becomes available in the queue and dequeue it"]
    #[doc = " \\param[in] queue          the frame queue data structure"]
    #[doc = " \\param[in] timeout_ms     max time in milliseconds to wait until a frame becomes available"]
    #[doc = " \\param[out] output_frame  frame handle to be released using rs2_release_frame"]
    #[doc = " \\param[out] error         if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return true if new frame was stored to output_frame"]
    pub fn rs2_try_wait_for_frame(
        queue: *mut rs2_frame_queue,
        timeout_ms: ::std::os::raw::c_uint,
        output_frame: *mut *mut rs2_frame,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " enqueue new frame into a queue"]
    #[doc = " \\param[in] frame frame handle to enqueue (this operation passed ownership to the queue)"]
    #[doc = " \\param[in] queue the frame queue data structure"]
    pub fn rs2_enqueue_frame(frame: *mut rs2_frame, queue: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " Creates Align processing block."]
    #[doc = " \\param[in] align_to   stream type to be used as the target of frameset alignment"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_align(
        align_to: rs2_stream,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates Depth post-processing filter block. This block accepts depth frames, applies decimation filter and plots modified prames"]
    #[doc = " Note that due to the modifiedframe size, the decimated frame repaces the original one"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_decimation_filter_block(
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates Depth post-processing filter block. This block accepts depth frames, applies temporal filter"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_temporal_filter_block(
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates Depth post-processing spatial filter block. This block accepts depth frames, applies spatial filters and plots modified prames"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_spatial_filter_block(error: *mut *mut rs2_error)
        -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates a post processing block that provides for depth<->disparity domain transformation for stereo-based depth modules"]
    #[doc = " \\param[in] transform_to_disparity flag select the transform direction:  true = depth->disparity, and vice versa"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_disparity_transform_block(
        transform_to_disparity: ::std::os::raw::c_uchar,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates Depth post-processing hole filling block. The filter replaces empty pixels with data from adjacent pixels based on the method selected"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_hole_filling_filter_block(
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates a rates printer block. The printer prints the actual FPS of the invoked frame stream."]
    #[doc = " The block ignores reapiting frames and calculats the FPS only if the frame number of the relevant frame was changed."]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_rates_printer_block(error: *mut *mut rs2_error) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates Depth post-processing zero order fix block. The filter invalidates pixels that has a wrong value due to zero order effect"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               zero order fix processing block"]
    pub fn rs2_create_zero_order_invalidation_block(
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates Depth frame decompression module. Decoded frames compressed and transmitted with Z16H variable-lenght Huffman code to"]
    #[doc = " standartized Z16 Depth data format. Using the compression allows to reduce the Depth frames bandwidth by more than 50 percent"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               Huffman-code decompression processing block"]
    pub fn rs2_create_huffman_depth_decompress_block(
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates a hdr_merge processing block."]
    #[doc = " The block merges between two depth frames with different exposure values"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_hdr_merge_processing_block(
        error: *mut *mut rs2_error,
    ) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Creates a sequence_id_filter processing block."]
    #[doc = " The block lets frames with the selected sequence id pass and blocks frames with other values"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_sequence_id_filter(error: *mut *mut rs2_error) -> *mut rs2_processing_block;
}
extern "C" {
    #[doc = " Retrieve processing block specific information, like name."]
    #[doc = " \\param[in]  block     The processing block"]
    #[doc = " \\param[in]  info      processing block info type to retrieve"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               The requested processing block info string, in a format specific to the device model"]
    pub fn rs2_get_processing_block_info(
        block: *const rs2_processing_block,
        info: rs2_camera_info,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Check if a processing block supports a specific info type."]
    #[doc = " \\param[in]  block     The processing block to check"]
    #[doc = " \\param[in]  info      The parameter to check for support"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return               True if the parameter both exist and well-defined for the specific device"]
    pub fn rs2_supports_processing_block_info(
        block: *const rs2_processing_block,
        info: rs2_camera_info,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Test if the given processing block can be extended to the requested extension"]
    #[doc = " \\param[in] block processing block"]
    #[doc = " \\param[in] extension The extension to which the sensor should be tested if it is extendable"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return non-zero value iff the processing block can be extended to the given extension"]
    pub fn rs2_is_processing_block_extendable_to(
        block: *const rs2_processing_block,
        extension_type: rs2_extension,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
#[doc = "< Unknown state"]
pub const rs2_playback_status_RS2_PLAYBACK_STATUS_UNKNOWN: rs2_playback_status = 0;
#[doc = "< One or more sensors were started, playback is reading and raising data"]
pub const rs2_playback_status_RS2_PLAYBACK_STATUS_PLAYING: rs2_playback_status = 1;
#[doc = "< One or more sensors were started, but playback paused reading and paused raising data"]
pub const rs2_playback_status_RS2_PLAYBACK_STATUS_PAUSED: rs2_playback_status = 2;
#[doc = "< All sensors were stopped, or playback has ended (all data was read). This is the initial playback status"]
pub const rs2_playback_status_RS2_PLAYBACK_STATUS_STOPPED: rs2_playback_status = 3;
pub const rs2_playback_status_RS2_PLAYBACK_STATUS_COUNT: rs2_playback_status = 4;
pub type rs2_playback_status = ::std::os::raw::c_uint;
extern "C" {
    pub fn rs2_playback_status_to_string(
        status: rs2_playback_status,
    ) -> *const ::std::os::raw::c_char;
}
pub type rs2_playback_status_changed_callback_ptr =
    ::std::option::Option<unsafe extern "C" fn(arg1: rs2_playback_status)>;
extern "C" {
    #[doc = " Creates a recording device to record the given device and save it to the given file"]
    #[doc = " \\param[in]  device    The device to record"]
    #[doc = " \\param[in]  file      The desired path to which the recorder should save the data"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return A pointer to a device that records its data to file, or null in case of failure"]
    pub fn rs2_create_record_device(
        device: *const rs2_device,
        file: *const ::std::os::raw::c_char,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_device;
}
extern "C" {
    #[doc = " Creates a recording device to record the given device and save it to the given file"]
    #[doc = " \\param[in]  device                The device to record"]
    #[doc = " \\param[in]  file                  The desired path to which the recorder should save the data"]
    #[doc = " \\param[in]  compression_enabled   Indicates if compression is enabled, 0 means false, otherwise true"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return A pointer to a device that records its data to file, or null in case of failure"]
    pub fn rs2_create_record_device_ex(
        device: *const rs2_device,
        file: *const ::std::os::raw::c_char,
        compression_enabled: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_device;
}
extern "C" {
    #[doc = " Pause the recording device without stopping the actual device from streaming."]
    #[doc = " Pausing will cause the device to stop writing new data to the file, in particular, frames and changes to extensions"]
    #[doc = " \\param[in]  device    A recording device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_record_device_pause(device: *const rs2_device, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Unpause the recording device. Resume will cause the device to continue writing new data to the file, in particular, frames and changes to extensions"]
    #[doc = " \\param[in]  device    A recording device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_record_device_resume(device: *const rs2_device, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Gets the name of the file to which the recorder is writing"]
    #[doc = " \\param[in]  device    A recording device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return The  name of the file to which the recorder is writing"]
    pub fn rs2_record_device_filename(
        device: *const rs2_device,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Creates a playback device to play the content of the given file"]
    #[doc = " \\param[in]  file      Path to the file to play"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return A pointer to a device that plays data from the file, or null in case of failure"]
    pub fn rs2_create_playback_device(
        file: *const ::std::os::raw::c_char,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_device;
}
extern "C" {
    #[doc = " Gets the path of the file used by the playback device"]
    #[doc = " \\param[in] device A playback device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return Path to the file used by the playback device"]
    pub fn rs2_playback_device_get_file_path(
        device: *const rs2_device,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Gets the total duration of the file in units of nanoseconds"]
    #[doc = " \\param[in] device     A playback device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return Total duration of the file in units of nanoseconds"]
    pub fn rs2_playback_get_duration(
        device: *const rs2_device,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    #[doc = " Set the playback to a specified time point of the played data"]
    #[doc = " \\param[in] device     A playback device."]
    #[doc = " \\param[in] time       The time point to which playback should seek, expressed in units of nanoseconds (zero value = start)"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_playback_seek(
        device: *const rs2_device,
        time: ::std::os::raw::c_longlong,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Gets the current position of the playback in the file in terms of time. Units are expressed in nanoseconds"]
    #[doc = " \\param[in] device     A playback device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return Current position of the playback in the file in terms of time. Units are expressed in nanoseconds"]
    pub fn rs2_playback_get_position(
        device: *const rs2_device,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    #[doc = " Pauses the playback"]
    #[doc = " Calling pause() in \"Paused\" status does nothing"]
    #[doc = " If pause() is called while playback status is \"Playing\" or \"Stopped\", the playback will not play until resume() is called"]
    #[doc = " \\param[in] device A playback device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_playback_device_resume(device: *const rs2_device, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Un-pauses the playback"]
    #[doc = " Calling resume() while playback status is \"Playing\" or \"Stopped\" does nothing"]
    #[doc = " \\param[in] device A playback device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_playback_device_pause(device: *const rs2_device, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Set the playback to work in real time or non real time"]
    #[doc = ""]
    #[doc = " In real time mode, playback will play the same way the file was recorded."]
    #[doc = " In real time mode if the application takes too long to handle the callback, frames may be dropped."]
    #[doc = " In non real time mode, playback will wait for each callback to finish handling the data before"]
    #[doc = " reading the next frame. In this mode no frames will be dropped, and the application controls the"]
    #[doc = " frame rate of the playback (according to the callback handler duration)."]
    #[doc = " \\param[in] device A playback device"]
    #[doc = " \\param[in] real_time  Indicates if real time is requested, 0 means false, otherwise true"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_playback_device_set_real_time(
        device: *const rs2_device,
        real_time: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Indicates if playback is in real time mode or non real time"]
    #[doc = " \\param[in] device A playback device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return True iff playback is in real time mode. 0 means false, otherwise true"]
    pub fn rs2_playback_device_is_real_time(
        device: *const rs2_device,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Register to receive callback from playback device upon its status changes"]
    #[doc = ""]
    #[doc = " Callbacks are invoked from the reading thread, any heavy processing in the callback handler will affect"]
    #[doc = " the reading thread and may cause frame drops\\ high latency"]
    #[doc = " \\param[in] device     A playback device"]
    #[doc = " \\param[in] callback   A callback handler that will be invoked when the playback status changes"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_playback_device_set_status_changed_callback(
        device: *const rs2_device,
        callback: *mut rs2_playback_status_changed_callback,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Returns the current state of the playback device"]
    #[doc = " \\param[in] device     A playback device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return Current state of the playback"]
    pub fn rs2_playback_device_get_current_status(
        device: *const rs2_device,
        error: *mut *mut rs2_error,
    ) -> rs2_playback_status;
}
extern "C" {
    #[doc = " Set the playing speed"]
    #[doc = ""]
    #[doc = " \\param[in] device A playback device"]
    #[doc = " \\param[in] speed  Indicates a multiplication of the speed to play (e.g: 1 = normal, 0.5 twice as slow)"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_playback_device_set_playback_speed(
        device: *const rs2_device,
        speed: f32,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Stops the playback"]
    #[doc = " Calling stop() will stop all streaming playbakc sensors and will reset the playback (returning to beginning of file)"]
    #[doc = " \\param[in] device A playback device"]
    #[doc = " \\param[out] error     If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_playback_device_stop(device: *const rs2_device, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " get the size of rs2_raw_data_buffer"]
    #[doc = " \\param[in] buffer  pointer to rs2_raw_data_buffer returned by rs2_send_and_receive_raw_data"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return size of rs2_raw_data_buffer"]
    pub fn rs2_get_raw_data_size(
        buffer: *const rs2_raw_data_buffer,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Delete rs2_raw_data_buffer"]
    #[doc = " \\param[in] buffer        rs2_raw_data_buffer returned by rs2_send_and_receive_raw_data"]
    pub fn rs2_delete_raw_data(buffer: *const rs2_raw_data_buffer);
}
extern "C" {
    #[doc = " Retrieve char array from rs2_raw_data_buffer"]
    #[doc = " \\param[in] buffer   rs2_raw_data_buffer returned by rs2_send_and_receive_raw_data"]
    #[doc = " \\param[out] error   if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return raw data"]
    pub fn rs2_get_raw_data(
        buffer: *const rs2_raw_data_buffer,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_uchar;
}
extern "C" {
    #[doc = " Retrieve the API version from the source code. Evaluate that the value is conformant to the established policies"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            the version API encoded into integer value \"1.9.3\" -> 10903"]
    pub fn rs2_get_api_version(error: *mut *mut rs2_error) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rs2_log_to_console(min_severity: rs2_log_severity, error: *mut *mut rs2_error);
}
extern "C" {
    pub fn rs2_log_to_file(
        min_severity: rs2_log_severity,
        file_path: *const ::std::os::raw::c_char,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    pub fn rs2_log_to_callback_cpp(
        min_severity: rs2_log_severity,
        callback: *mut rs2_log_callback,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    pub fn rs2_log_to_callback(
        min_severity: rs2_log_severity,
        callback: rs2_log_callback_ptr,
        arg: *mut ::std::os::raw::c_void,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    pub fn rs2_reset_logger(error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Enable rolling log file when used with rs2_log_to_file:"]
    #[doc = " Upon reaching (max_size/2) bytes, the log will be renamed with an \".old\" suffix and a new log created. Any"]
    #[doc = " previous .old file will be erased."]
    #[doc = " Must have permissions to remove/rename files in log file directory."]
    #[doc = " \\param[in] max_size   max file size in megabytes"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_enable_rolling_log_file(
        max_size: ::std::os::raw::c_uint,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    pub fn rs2_get_log_message_line_number(
        msg: *const rs2_log_message,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn rs2_get_log_message_filename(
        msg: *const rs2_log_message,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rs2_get_raw_log_message(
        msg: *const rs2_log_message,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rs2_get_full_log_message(
        msg: *const rs2_log_message,
        error: *mut *mut rs2_error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Add custom message into librealsense log"]
    #[doc = " \\param[in] severity  The log level for the message to be written under"]
    #[doc = " \\param[in] message   Message to be logged"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_log(
        severity: rs2_log_severity,
        message: *const ::std::os::raw::c_char,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Given the 2D depth coordinate (x,y) provide the corresponding depth in metric units"]
    #[doc = " \\param[in] frame_ref  2D depth pixel coordinates (Left-Upper corner origin)"]
    #[doc = " \\param[in] x,y  2D depth pixel coordinates (Left-Upper corner origin)"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_depth_frame_get_distance(
        frame_ref: *const rs2_frame,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    ) -> f32;
}
extern "C" {
    #[doc = " return the time at specific time point"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return            the time at specific time point, in live and record mode it will return the system time and in playback mode it will return the recorded time"]
    pub fn rs2_get_time(error: *mut *mut rs2_error) -> rs2_time_t;
}
extern "C" {
    #[doc = " Create a config instance"]
    #[doc = " The config allows pipeline users to request filters for the pipeline streams and device selection and configuration."]
    #[doc = " This is an optional step in pipeline creation, as the pipeline resolves its streaming device internally."]
    #[doc = " Config provides its users a way to set the filters and test if there is no conflict with the pipeline requirements"]
    #[doc = " from the device. It also allows the user to find a matching device for the config filters and the pipeline, in order to"]
    #[doc = " select a device explicitly, and modify its controls before streaming starts."]
    #[doc = ""]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return rs2_config*  A pointer to a new config instance"]
    pub fn rs2_create_config(error: *mut *mut rs2_error) -> *mut rs2_config;
}
extern "C" {
    #[doc = " Deletes an instance of a config"]
    #[doc = ""]
    #[doc = " \\param[in] config    A pointer to an instance of a config"]
    pub fn rs2_delete_config(config: *mut rs2_config);
}
extern "C" {
    #[doc = " Enable a device stream explicitly, with selected stream parameters."]
    #[doc = " The method allows the application to request a stream with specific configuration. If no stream is explicitly enabled, the pipeline"]
    #[doc = " configures the device and its streams according to the attached computer vision modules and processing blocks requirements, or"]
    #[doc = " default configuration for the first available device."]
    #[doc = " The application can configure any of the input stream parameters according to its requirement, or set to 0 for don't care value."]
    #[doc = " The config accumulates the application calls for enable configuration methods, until the configuration is applied. Multiple enable"]
    #[doc = " stream calls for the same stream with conflicting parameters override each other, and the last call is maintained."]
    #[doc = " Upon calling \\c resolve(), the config checks for conflicts between the application configuration requests and the attached computer"]
    #[doc = " vision modules and processing blocks requirements, and fails if conflicts are found. Before \\c resolve() is called, no conflict"]
    #[doc = " check is done."]
    #[doc = ""]
    #[doc = " \\param[in] config    A pointer to an instance of a config"]
    #[doc = " \\param[in] stream    Stream type to be enabled"]
    #[doc = " \\param[in] index     Stream index, used for multiple streams of the same type. -1 indicates any."]
    #[doc = " \\param[in] width     Stream image width - for images streams. 0 indicates any."]
    #[doc = " \\param[in] height    Stream image height - for images streams. 0 indicates any."]
    #[doc = " \\param[in] format    Stream data format - pixel format for images streams, of data type for other streams. RS2_FORMAT_ANY indicates any."]
    #[doc = " \\param[in] framerate Stream frames per second. 0 indicates any."]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_config_enable_stream(
        config: *mut rs2_config,
        stream: rs2_stream,
        index: ::std::os::raw::c_int,
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        format: rs2_format,
        framerate: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Enable all device streams explicitly."]
    #[doc = " The conditions and behavior of this method are similar to those of \\c enable_stream()."]
    #[doc = " This filter enables all raw streams of the selected device. The device is either selected explicitly by the application,"]
    #[doc = " or by the pipeline requirements or default. The list of streams is device dependent."]
    #[doc = ""]
    #[doc = " \\param[in] config    A pointer to an instance of a config"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_config_enable_all_stream(config: *mut rs2_config, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Select a specific device explicitly by its serial number, to be used by the pipeline."]
    #[doc = " The conditions and behavior of this method are similar to those of \\c enable_stream()."]
    #[doc = " This method is required if the application needs to set device or sensor settings prior to pipeline streaming, to enforce"]
    #[doc = " the pipeline to use the configured device."]
    #[doc = ""]
    #[doc = " \\param[in] config    A pointer to an instance of a config"]
    #[doc = " \\param[in] serial device serial number, as returned by RS2_CAMERA_INFO_SERIAL_NUMBER"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_config_enable_device(
        config: *mut rs2_config,
        serial: *const ::std::os::raw::c_char,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Select a recorded device from a file, to be used by the pipeline through playback."]
    #[doc = " The device available streams are as recorded to the file, and \\c resolve() considers only this device and configuration"]
    #[doc = " as available."]
    #[doc = " This request cannot be used if enable_record_to_file() is called for the current config, and vise versa"]
    #[doc = " By default, playback is repeated once the file ends. To control this, see 'rs2_config_enable_device_from_file_repeat_option'."]
    #[doc = ""]
    #[doc = " \\param[in] config    A pointer to an instance of a config"]
    #[doc = " \\param[in] file      The playback file of the device"]
    #[doc = " \\param[out] error    if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_config_enable_device_from_file(
        config: *mut rs2_config,
        file: *const ::std::os::raw::c_char,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Select a recorded device from a file, to be used by the pipeline through playback."]
    #[doc = " The device available streams are as recorded to the file, and \\c resolve() considers only this device and configuration"]
    #[doc = " as available."]
    #[doc = " This request cannot be used if enable_record_to_file() is called for the current config, and vise versa"]
    #[doc = ""]
    #[doc = " \\param[in] config           A pointer to an instance of a config"]
    #[doc = " \\param[in] file             The playback file of the device"]
    #[doc = " \\param[in] repeat_playback  if true, when file ends the playback starts again, in an infinite loop;"]
    #[doc = "if false, when file ends playback does not start again, and should by stopped manually by the user."]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_config_enable_device_from_file_repeat_option(
        config: *mut rs2_config,
        file: *const ::std::os::raw::c_char,
        repeat_playback: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Requires that the resolved device would be recorded to file"]
    #[doc = " This request cannot be used if enable_device_from_file() is called for the current config, and vise versa"]
    #[doc = ""]
    #[doc = " \\param[in] config    A pointer to an instance of a config"]
    #[doc = " \\param[in] file      The desired file for the output record"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_config_enable_record_to_file(
        config: *mut rs2_config,
        file: *const ::std::os::raw::c_char,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Disable a device stream explicitly, to remove any requests on this stream type."]
    #[doc = " The stream can still be enabled due to pipeline computer vision module request. This call removes any filter on the"]
    #[doc = " stream configuration."]
    #[doc = ""]
    #[doc = " \\param[in] config    A pointer to an instance of a config"]
    #[doc = " \\param[in] stream    Stream type, for which the filters are cleared"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_config_disable_stream(
        config: *mut rs2_config,
        stream: rs2_stream,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Disable a device stream explicitly, to remove any requests on this stream profile."]
    #[doc = " The stream can still be enabled due to pipeline computer vision module request. This call removes any filter on the"]
    #[doc = " stream configuration."]
    #[doc = ""]
    #[doc = " \\param[in] config    A pointer to an instance of a config"]
    #[doc = " \\param[in] stream    Stream type, for which the filters are cleared"]
    #[doc = " \\param[in] index     Stream index, for which the filters are cleared"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_config_disable_indexed_stream(
        config: *mut rs2_config,
        stream: rs2_stream,
        index: ::std::os::raw::c_int,
        error: *mut *mut rs2_error,
    );
}
extern "C" {
    #[doc = " Disable all device stream explicitly, to remove any requests on the streams profiles."]
    #[doc = " The streams can still be enabled due to pipeline computer vision module request. This call removes any filter on the"]
    #[doc = " streams configuration."]
    #[doc = ""]
    #[doc = " \\param[in] config    A pointer to an instance of a config"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_config_disable_all_streams(config: *mut rs2_config, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Resolve the configuration filters, to find a matching device and streams profiles."]
    #[doc = " The method resolves the user configuration filters for the device and streams, and combines them with the requirements of"]
    #[doc = " the computer vision modules and processing blocks attached to the pipeline. If there are no conflicts of requests, it looks"]
    #[doc = " for an available device, which can satisfy all requests, and selects the first matching streams configuration. In the absence"]
    #[doc = " of any request, the rs2::config selects the first available device and the first color and depth streams configuration."]
    #[doc = " The pipeline profile selection during \\c start() follows the same method. Thus, the selected profile is the same, if no"]
    #[doc = " change occurs to the available devices occurs."]
    #[doc = " Resolving the pipeline configuration provides the application access to the pipeline selected device for advanced control."]
    #[doc = " The returned configuration is not applied to the device, so the application doesn't own the device sensors. However, the"]
    #[doc = " application can call \\c enable_device(), to enforce the device returned by this method is selected by pipeline \\c start(),"]
    #[doc = " and configure the device and sensors options or extensions before streaming starts."]
    #[doc = ""]
    #[doc = " \\param[in] config    A pointer to an instance of a config"]
    #[doc = " \\param[in] pipe  The pipeline for which the selected filters are applied"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return       A matching device and streams profile, which satisfies the filters and pipeline requests."]
    pub fn rs2_config_resolve(
        config: *mut rs2_config,
        pipe: *mut rs2_pipeline,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_pipeline_profile;
}
extern "C" {
    #[doc = " Check if the config can resolve the configuration filters, to find a matching device and streams profiles."]
    #[doc = " The resolution conditions are as described in \\c resolve()."]
    #[doc = ""]
    #[doc = " \\param[in] config    A pointer to an instance of a config"]
    #[doc = " \\param[in] pipe  The pipeline for which the selected filters are applied"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return       True if a valid profile selection exists, false if no selection can be found under the config filters and the available devices."]
    pub fn rs2_config_can_resolve(
        config: *mut rs2_config,
        pipe: *mut rs2_pipeline,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create a pipeline instance"]
    #[doc = " The pipeline simplifies the user interaction with the device and computer vision processing modules."]
    #[doc = " The class abstracts the camera configuration and streaming, and the vision modules triggering and threading."]
    #[doc = " It lets the application focus on the computer vision output of the modules, or the device output data."]
    #[doc = " The pipeline can manage computer vision modules, which are implemented as a processing blocks."]
    #[doc = " The pipeline is the consumer of the processing block interface, while the application consumes the"]
    #[doc = " computer vision interface."]
    #[doc = " \\param[in]  ctx    context"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_create_pipeline(
        ctx: *mut rs2_context,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_pipeline;
}
extern "C" {
    #[doc = " Stop the pipeline streaming."]
    #[doc = " The pipeline stops delivering samples to the attached computer vision modules and processing blocks, stops the device streaming"]
    #[doc = " and releases the device resources used by the pipeline. It is the application's responsibility to release any frame reference it owns."]
    #[doc = " The method takes effect only after \\c start() was called, otherwise an exception is raised."]
    #[doc = " \\param[in] pipe  pipeline"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    pub fn rs2_pipeline_stop(pipe: *mut rs2_pipeline, error: *mut *mut rs2_error);
}
extern "C" {
    #[doc = " Wait until a new set of frames becomes available."]
    #[doc = " The frames set includes time-synchronized frames of each enabled stream in the pipeline."]
    #[doc = " The method blocks the calling thread, and fetches the latest unread frames set."]
    #[doc = " Device frames, which were produced while the function wasn't called, are dropped. To avoid frame drops, this method should be called"]
    #[doc = " as fast as the device frame rate."]
    #[doc = " The application can maintain the frames handles to defer processing. However, if the application maintains too long history, the device"]
    #[doc = " may lack memory resources to produce new frames, and the following call to this method shall fail to retrieve new frames, until resources"]
    #[doc = " are retained."]
    #[doc = " \\param[in] pipe the pipeline"]
    #[doc = " \\param[in] timeout_ms   Max time in milliseconds to wait until an exception will be thrown"]
    #[doc = " \\param[out] error         if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return Set of coherent frames"]
    pub fn rs2_pipeline_wait_for_frames(
        pipe: *mut rs2_pipeline,
        timeout_ms: ::std::os::raw::c_uint,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_frame;
}
extern "C" {
    #[doc = " Check if a new set of frames is available and retrieve the latest undelivered set."]
    #[doc = " The frames set includes time-synchronized frames of each enabled stream in the pipeline."]
    #[doc = " The method returns without blocking the calling thread, with status of new frames available or not. If available, it fetches the"]
    #[doc = " latest frames set."]
    #[doc = " Device frames, which were produced while the function wasn't called, are dropped. To avoid frame drops, this method should be called"]
    #[doc = " as fast as the device frame rate."]
    #[doc = " The application can maintain the frames handles to defer processing. However, if the application maintains too long history, the device"]
    #[doc = " may lack memory resources to produce new frames, and the following calls to this method shall return no new frames, until resources are"]
    #[doc = " retained."]
    #[doc = " \\param[in] pipe the pipeline"]
    #[doc = " \\param[out] output_frame frame handle to be released using rs2_release_frame"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return true if new frame was stored to output_frame"]
    pub fn rs2_pipeline_poll_for_frames(
        pipe: *mut rs2_pipeline,
        output_frame: *mut *mut rs2_frame,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Wait until a new set of frames becomes available."]
    #[doc = " The frames set includes time-synchronized frames of each enabled stream in the pipeline."]
    #[doc = " The method blocks the calling thread, and fetches the latest unread frames set."]
    #[doc = " Device frames, which were produced while the function wasn't called, are dropped. To avoid frame drops, this method should be called"]
    #[doc = " as fast as the device frame rate."]
    #[doc = " The application can maintain the frames handles to defer processing. However, if the application maintains too long history, the device"]
    #[doc = " may lack memory resources to produce new frames, and the following call to this method shall fail to retrieve new frames, until resources"]
    #[doc = " are retained."]
    #[doc = " \\param[in] pipe           the pipeline"]
    #[doc = " \\param[in] timeout_ms     max time in milliseconds to wait until a frame becomes available"]
    #[doc = " \\param[out] output_frame  frame handle to be released using rs2_release_frame"]
    #[doc = " \\param[out] error         if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return true if new frame was stored to output_frame"]
    pub fn rs2_pipeline_try_wait_for_frames(
        pipe: *mut rs2_pipeline,
        output_frame: *mut *mut rs2_frame,
        timeout_ms: ::std::os::raw::c_uint,
        error: *mut *mut rs2_error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Delete a pipeline instance."]
    #[doc = " Upon destruction, the pipeline will implicitly stop itself"]
    #[doc = " \\param[in] pipe to delete"]
    pub fn rs2_delete_pipeline(pipe: *mut rs2_pipeline);
}
extern "C" {
    #[doc = " Start the pipeline streaming with its default configuration."]
    #[doc = " The pipeline streaming loop captures samples from the device, and delivers them to the attached computer vision modules"]
    #[doc = " and processing blocks, according to each module requirements and threading model."]
    #[doc = " During the loop execution, the application can access the camera streams by calling \\c wait_for_frames() or \\c poll_for_frames()."]
    #[doc = " The streaming loop runs until the pipeline is stopped."]
    #[doc = " Starting the pipeline is possible only when it is not started. If the pipeline was started, an exception is raised."]
    #[doc = ""]
    #[doc = " \\param[in] pipe    a pointer to an instance of the pipeline"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return             The actual pipeline device and streams profile, which was successfully configured to the streaming device."]
    pub fn rs2_pipeline_start(
        pipe: *mut rs2_pipeline,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_pipeline_profile;
}
extern "C" {
    #[doc = " Start the pipeline streaming according to the configuraion."]
    #[doc = " The pipeline streaming loop captures samples from the device, and delivers them to the attached computer vision modules"]
    #[doc = " and processing blocks, according to each module requirements and threading model."]
    #[doc = " During the loop execution, the application can access the camera streams by calling \\c wait_for_frames() or \\c poll_for_frames()."]
    #[doc = " The streaming loop runs until the pipeline is stopped."]
    #[doc = " Starting the pipeline is possible only when it is not started. If the pipeline was started, an exception is raised."]
    #[doc = " The pipeline selects and activates the device upon start, according to configuration or a default configuration."]
    #[doc = " When the rs2::config is provided to the method, the pipeline tries to activate the config \\c resolve() result. If the application"]
    #[doc = " requests are conflicting with pipeline computer vision modules or no matching device is available on the platform, the method fails."]
    #[doc = " Available configurations and devices may change between config \\c resolve() call and pipeline start, in case devices are connected"]
    #[doc = " or disconnected, or another application acquires ownership of a device."]
    #[doc = ""]
    #[doc = " \\param[in] pipe    a pointer to an instance of the pipeline"]
    #[doc = " \\param[in] config   A rs2::config with requested filters on the pipeline configuration. By default no filters are applied."]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return             The actual pipeline device and streams profile, which was successfully configured to the streaming device."]
    pub fn rs2_pipeline_start_with_config(
        pipe: *mut rs2_pipeline,
        config: *mut rs2_config,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_pipeline_profile;
}
extern "C" {
    #[doc = " Start the pipeline streaming with its default configuration."]
    #[doc = " The pipeline captures samples from the device, and delivers them to the through the provided frame callback."]
    #[doc = " Starting the pipeline is possible only when it is not started. If the pipeline was started, an exception is raised."]
    #[doc = " When starting the pipeline with a callback both \\c wait_for_frames() or \\c poll_for_frames() will throw exception."]
    #[doc = ""]
    #[doc = " \\param[in] pipe     A pointer to an instance of the pipeline"]
    #[doc = " \\param[in] on_frame function pointer to register as per-frame callback"]
    #[doc = " \\param[in] user auxiliary  data the user wishes to receive together with every frame callback"]
    #[doc = " \\param[out] error   If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return             The actual pipeline device and streams profile, which was successfully configured to the streaming device."]
    pub fn rs2_pipeline_start_with_callback(
        pipe: *mut rs2_pipeline,
        on_frame: rs2_frame_callback_ptr,
        user: *mut ::std::os::raw::c_void,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_pipeline_profile;
}
extern "C" {
    #[doc = " Start the pipeline streaming with its default configuration."]
    #[doc = " The pipeline captures samples from the device, and delivers them to the through the provided frame callback."]
    #[doc = " Starting the pipeline is possible only when it is not started. If the pipeline was started, an exception is raised."]
    #[doc = " When starting the pipeline with a callback both \\c wait_for_frames() or \\c poll_for_frames() will throw exception."]
    #[doc = ""]
    #[doc = " \\param[in] pipe     A pointer to an instance of the pipeline"]
    #[doc = " \\param[in] callback callback object created from c++ application. ownership over the callback object is moved into the relevant streaming lock"]
    #[doc = " \\param[out] error   If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return             The actual pipeline device and streams profile, which was successfully configured to the streaming device."]
    pub fn rs2_pipeline_start_with_callback_cpp(
        pipe: *mut rs2_pipeline,
        callback: *mut rs2_frame_callback,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_pipeline_profile;
}
extern "C" {
    #[doc = " Start the pipeline streaming according to the configuraion."]
    #[doc = " The pipeline captures samples from the device, and delivers them to the through the provided frame callback."]
    #[doc = " Starting the pipeline is possible only when it is not started. If the pipeline was started, an exception is raised."]
    #[doc = " When starting the pipeline with a callback both \\c wait_for_frames() or \\c poll_for_frames() will throw exception."]
    #[doc = " The pipeline selects and activates the device upon start, according to configuration or a default configuration."]
    #[doc = " When the rs2::config is provided to the method, the pipeline tries to activate the config \\c resolve() result. If the application"]
    #[doc = " requests are conflicting with pipeline computer vision modules or no matching device is available on the platform, the method fails."]
    #[doc = " Available configurations and devices may change between config \\c resolve() call and pipeline start, in case devices are connected"]
    #[doc = " or disconnected, or another application acquires ownership of a device."]
    #[doc = ""]
    #[doc = " \\param[in] pipe     A pointer to an instance of the pipeline"]
    #[doc = " \\param[in] config   A rs2::config with requested filters on the pipeline configuration. By default no filters are applied."]
    #[doc = " \\param[in] on_frame function pointer to register as per-frame callback"]
    #[doc = " \\param[in] user auxiliary  data the user wishes to receive together with every frame callback"]
    #[doc = " \\param[out] error   If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return             The actual pipeline device and streams profile, which was successfully configured to the streaming device."]
    pub fn rs2_pipeline_start_with_config_and_callback(
        pipe: *mut rs2_pipeline,
        config: *mut rs2_config,
        on_frame: rs2_frame_callback_ptr,
        user: *mut ::std::os::raw::c_void,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_pipeline_profile;
}
extern "C" {
    #[doc = " Start the pipeline streaming according to the configuraion."]
    #[doc = " The pipeline captures samples from the device, and delivers them to the through the provided frame callback."]
    #[doc = " Starting the pipeline is possible only when it is not started. If the pipeline was started, an exception is raised."]
    #[doc = " When starting the pipeline with a callback both \\c wait_for_frames() or \\c poll_for_frames() will throw exception."]
    #[doc = " The pipeline selects and activates the device upon start, according to configuration or a default configuration."]
    #[doc = " When the rs2::config is provided to the method, the pipeline tries to activate the config \\c resolve() result. If the application"]
    #[doc = " requests are conflicting with pipeline computer vision modules or no matching device is available on the platform, the method fails."]
    #[doc = " Available configurations and devices may change between config \\c resolve() call and pipeline start, in case devices are connected"]
    #[doc = " or disconnected, or another application acquires ownership of a device."]
    #[doc = ""]
    #[doc = " \\param[in] pipe     A pointer to an instance of the pipeline"]
    #[doc = " \\param[in] config   A rs2::config with requested filters on the pipeline configuration. By default no filters are applied."]
    #[doc = " \\param[in] callback callback object created from c++ application. ownership over the callback object is moved into the relevant streaming lock"]
    #[doc = " \\param[out] error   If non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return             The actual pipeline device and streams profile, which was successfully configured to the streaming device."]
    pub fn rs2_pipeline_start_with_config_and_callback_cpp(
        pipe: *mut rs2_pipeline,
        config: *mut rs2_config,
        callback: *mut rs2_frame_callback,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_pipeline_profile;
}
extern "C" {
    #[doc = " Return the active device and streams profiles, used by the pipeline."]
    #[doc = " The pipeline streams profiles are selected during \\c start(). The method returns a valid result only when the pipeline is active -"]
    #[doc = " between calls to \\c start() and \\c stop()."]
    #[doc = " After \\c stop() is called, the pipeline doesn't own the device, thus, the pipeline selected device may change in subsequent activations."]
    #[doc = ""]
    #[doc = " \\param[in] pipe    a pointer to an instance of the pipeline"]
    #[doc = " \\param[out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return  The actual pipeline device and streams profile, which was successfully configured to the streaming device on start."]
    pub fn rs2_pipeline_get_active_profile(
        pipe: *mut rs2_pipeline,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_pipeline_profile;
}
extern "C" {
    #[doc = " Retrieve the device used by the pipeline."]
    #[doc = " The device class provides the application access to control camera additional settings -"]
    #[doc = " get device information, sensor options information, options value query and set, sensor specific extensions."]
    #[doc = " Since the pipeline controls the device streams configuration, activation state and frames reading, calling"]
    #[doc = " the device API functions, which execute those operations, results in unexpected behavior."]
    #[doc = " The pipeline streaming device is selected during pipeline \\c start(). Devices of profiles, which are not returned by"]
    #[doc = " pipeline \\c start() or \\c get_active_profile(), are not guaranteed to be used by the pipeline."]
    #[doc = ""]
    #[doc = " \\param[in] profile    A pointer to an instance of a pipeline profile"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return rs2_device* The pipeline selected device"]
    pub fn rs2_pipeline_profile_get_device(
        profile: *mut rs2_pipeline_profile,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_device;
}
extern "C" {
    #[doc = " Return the selected streams profiles, which are enabled in this profile."]
    #[doc = ""]
    #[doc = " \\param[in] profile    A pointer to an instance of a pipeline profile"]
    #[doc = " \\param[out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored"]
    #[doc = " \\return   list of stream profiles"]
    pub fn rs2_pipeline_profile_get_streams(
        profile: *mut rs2_pipeline_profile,
        error: *mut *mut rs2_error,
    ) -> *mut rs2_stream_profile_list;
}
extern "C" {
    #[doc = " Deletes an instance of a pipeline profile"]
    #[doc = ""]
    #[doc = " \\param[in] profile    A pointer to an instance of a pipeline profile"]
    pub fn rs2_delete_pipeline_profile(profile: *mut rs2_pipeline_profile);
}
