## readable_byte
[![crates.io](https://img.shields.io/crates/v/systemstat.svg)](https://crates.io/crates/readable_byte)
[![API Docs](https://docs.rs/systemstat/badge.svg)](https://docs.rs/readable_byte/)
[![unlicense](https://img.shields.io/badge/un-license-green.svg?style=flat)](https://unlicense.org)


readable_byte is an implmentation of human-readable bytesize


## Usage

Add this to your Cargo.toml:

```toml
[dependencies]
readable_byte="0.1.0"
```

and this to your crate root:
```rust
extern crate readable_byte;
```

## Example
### Human readable representations
```rust

  #[test]
  fn test_to_string() {
    assert_to_string("215 B", readable_byte(215), true);
    assert_to_string("215 B", readable_byte(215), false);

    assert_to_string("215 B", readable_byte::b(215), true);
    assert_to_string("215 B", readable_byte::b(215), false);

    assert_to_string("1.0 kiB", readable_byte::kib(1), true);
    assert_to_string("1.0 KB", readable_byte::kib(1), false);

    assert_to_string("293.9 kiB", readable_byte::kb(301), true);
    assert_to_string("301.0 KB", readable_byte::kb(301), false);

    assert_to_string("1.0 MiB", readable_byte::mib(1), true);
    assert_to_string("1048.6 KB", readable_byte::mib(1), false);

    assert_to_string("399.6 MiB", readable_byte::mb(419), true);
    assert_to_string("419.0 MB", readable_byte::mb(419), false);

    assert_to_string("482.4 GiB", readable_byte::gb(518), true);
    assert_to_string("518.0 GB", readable_byte::gb(518), false);

    assert_to_string("741.2 TiB", readable_byte::tb(815), true);
    assert_to_string("815.0 TB", readable_byte::tb(815), false);

    assert_to_string("540.9 PiB", readable_byte::pb(609), true);
    assert_to_string("609.0 PB", readable_byte::pb(609), false);
  }

  #[test]
  fn test_parsing_from_str() {
      // shortcut for writing test cases
      fn parse(s: &str) -> u64 {
          s.parse::<readable_byte>().unwrap().0
      }

      assert_eq!("0".parse::<readable_byte>().unwrap().0, 0);
      assert_eq!(parse("0"), 0);
      assert_eq!(parse("500"), 500);
      assert_eq!(parse("1K"), Unit::KiloByte * 1);
      assert_eq!(parse("1Ki"), Unit::KibiByte * 1);
      assert_eq!(parse("1.5Ki"), (1.5 * Unit::KibiByte) as u64);
      assert_eq!(parse("1KiB"), 1 * Unit::KibiByte);
      assert_eq!(parse("1.5KiB"), (1.5 * Unit::KibiByte) as u64);
      assert_eq!(parse("3 MB"), Unit::MegaByte * 3);
      assert_eq!(parse("4 MiB"), Unit::MebiByte * 4);
      assert_eq!(parse("6 GB"), 6 * Unit::GigaByte);
      assert_eq!(parse("4 GiB"), 4 * Unit::GibiByte);
      assert_eq!(parse("88TB"), 88 * Unit::TeraByte);
      assert_eq!(parse("521TiB"), 521 * Unit::TebiByte);
      assert_eq!(parse("8 PB"), 8 * Unit::PetaByte);
      assert_eq!(parse("8P"), 8 * Unit::PetaByte);
      assert_eq!(parse("12 PiB"), 12 * Unit::PebiByte);
  }
```

