// Copyright 2022 tison <wander4096@gmail.com>.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

use crate::{publisher::Publisher, subscriber::Subscriber, subscription::ScalarSubscription};

pub fn just<T>(t: T) -> FlowableJust<T> {
    FlowableJust { t }
}

pub struct FlowableJust<T> {
    t: T,
}

impl<T> Publisher for FlowableJust<T> {
    type Item = T;

    fn subscribe<E, S: Subscriber<Item = Self::Item, Error = E>>(self, subscriber: S) {
        ScalarSubscription::new(self.t, subscriber).on_subscribe();
    }
}

#[cfg(test)]
mod tests {
    use crate::{flowable::just, publisher::Publisher, subscriber::MockSubscriber};

    #[test]
    fn it_works() {
        let flowable = just(1);
        flowable.subscribe(MockSubscriber::default());
    }
}
