/*!
Functions that create IRIs for the [XML Schema Data Types](https://www.w3.org/TR/xmlschema-2/) namespace.
*/

namespace! {
    "xsd",
    "http://www.w3.org/2001/XMLSchema#",
    {
        any_uri, "anyURI",
        base64_binary, "base64Binary",
        date_time, "dateTime",
        date_time_stamp, "dateTimeStamp",
        day_time_duration, "dayTimeDuration",
        decimal, "decimal",
        duration, "duration",
        entity, "entity",
        g_day, "gDay",
        g_month, "gMonth",
        g_month_day, "gMonthDay",
        g_year, "gYear",
        g_year_month, "gYearMonth",
        id, "ID",
        id_ref, "IDREF",
        id_refs, "IDREFS",
        integer, "integer",
        language, "language",
        name, "Name",
        nc_name, "NCName",
        nm_token, "NMTOKEN",
        nm_tokens, "NMTOKENS",
        non_negative_integer, "nonNegativeInteger",
        non_positive_integer, "nonPositiveInteger",
        normalized_string, "normalizedString",
        notation, "NOTATION",
        ns, "NS",
        positive_integer, "positiveInteger",
        q_name, "QName",
        time, "time",
        token, "token",
        unsigned_byte, "unsignedByte",
        unsigned_int, "unsignedInt",
        unsigned_long, "unsignedLong",
        unsigned_short, "unsignedShort",
        boolean, "boolean",
        byte, "byte",
        double, "double",
        float, "float",
        int, "int",
        long, "long",
        short, "short",
        string, "string",
        year_month_duration, "yearMonthDuration"
    }
}
