// THIS FILE IS GENERATED. ONE SHOULD NOT MODIFY IT
#![cfg_attr(docsrs, feature(doc_cfg))]
#![cfg_attr(docsrs, doc(cfg(feature = "ns-gs1")))]
//! This module provides terms for `GS1 Vocabulary` vocabulary
//!
//! ## Vocabulary:
//!
//! |||
//! |-----|-----|
//! |**Title**|GS1 Vocabulary|
//! |**Prefix**|gs1|
//! |**Namespace base IRI**|<https://gs1.org/voc/>|
//! |**Description**||
//! |**Is defined by**|<https://raw.githubusercontent.com/gs1/WebVoc/master/gs1Voc_v1_3.ttl>|
//!

use crate::namespace;

namespace!(
    "https://gs1.org/voc/",;
    /// ``: 
    NAMESPACE_BASE, "",
    /// `Application identifier`: A Data Type that corresponds to GS1 Application Identifiers defined in the GS1 General Specifications
    AI, "AI",
    /// `Additional Product Classification Details`: A product classification for the product other than the Global Product Classification(GPC brick value).
    AdditionalProductClassificationDetails, "AdditionalProductClassificationDetails",
    /// `Additive Details`: A set of details about one of the additives within the product.
    AdditiveDetails, "AdditiveDetails",
    /// `Allergen Details`: Details of an allergen for a product.
    AllergenDetails, "AllergenDetails",
    /// `Allergen Type Code`: 
    AllergenTypeCode, "AllergenTypeCode",
    /// `Almond and Almond Products`: Refers to the presence of almond and almond products as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_ALMONDS, "AllergenTypeCode-ALMONDS",
    /// `Alpha-Isomethyl Ionone`: Refers to the presence of Alpha-Isomethyl Ionone as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_ALPHA_ISOMETHYL_IONONE, "AllergenTypeCode-ALPHA_ISOMETHYL_IONONE",
    /// `Amylcinnamyl Alcohol`: Refers to the presence of Amylcinnamyl Alcohol as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_AMYLCINNAMYL_ALCOHOL, "AllergenTypeCode-AMYLCINNAMYL_ALCOHOL",
    /// `Amyl Cinnamal`: Refers to the presence of Amyl Cinnamal as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_AMYL_CINNAMAL, "AllergenTypeCode-AMYL_CINNAMAL",
    /// `Anise Alcohol`: Refers to the presence of Anise Alcohol as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_ANISE_ALCOHOL, "AllergenTypeCode-ANISE_ALCOHOL",
    /// `Barley and Barley Products`: Refers to the presence of Barley and barley products (glutencontaining grain) as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_BARLEY, "AllergenTypeCode-BARLEY",
    /// `Benzyl Alcohol`: Refers to the presence of Benzyl Alcohol as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_BENZYL_ALCOHOL, "AllergenTypeCode-BENZYL_ALCOHOL",
    /// `Benzyl Benzoate`: Refers to the presence of Benzyl Benzoate as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_BENZYL_BENZOATE, "AllergenTypeCode-BENZYL_BENZOATE",
    /// `Benzyl Cinnamate.`: Refers to the presence of Benzyl Cinnamate as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_BENZYL_CINNAMATE, "AllergenTypeCode-BENZYL_CINNAMATE",
    /// `Benzyl Salicylate`: Refers to the presence of Benzyl Salicylate as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_BENZYL_SALICYLATE, "AllergenTypeCode-BENZYL_SALICYLATE",
    /// `Brazil Nut and Brazil Nut Products`: Refers to the presence of brazil nut and brazil nut products as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_BRAZIL_NUTS, "AllergenTypeCode-BRAZIL_NUTS",
    /// `Butylphenyl Methylpropionate.`: Refers to the presence of Butylphenyl Methylpropionate as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_BUTYLPHENYL_METHYLPROPIONATE, "AllergenTypeCode-BUTYLPHENYL_METHYLPROPIONATE",
    /// `Carrot and Derivatives`: Refers to the presence of carrot and their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_CARROTS, "AllergenTypeCode-CARROTS",
    /// `Cashew and Cashew Products`: Refers to the presence of cashew and cashew products as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_CASHEW_NUTS, "AllergenTypeCode-CASHEW_NUTS",
    /// `Celery or Derivatives`: Refers to the presence of celery or their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_CELERY, "AllergenTypeCode-CELERY",
    /// `Cereals Containing Gluten and Their Derivatives`: Refers to the presence of Cereals containing gluten and their derivatives in the product, as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_CEREALS_CONTAINING_GLUTEN, "AllergenTypeCode-CEREALS_CONTAINING_GLUTEN",
    /// `Cinnamal`: Refers to the presence of Cinnamal as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_CINNAMAL, "AllergenTypeCode-CINNAMAL",
    /// `Cinnamyl Alcohol`: Refers to the presence of Cinnamyl Alcohol as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_CINNAMYL_ALCOHOL, "AllergenTypeCode-CINNAMYL_ALCOHOL",
    /// `Citral`: Refers to the presence of Citral as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_CITRAL, "AllergenTypeCode-CITRAL",
    /// `Citronellol`: Refers to the presence of Citronellol as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_CITRONELLOL, "AllergenTypeCode-CITRONELLOL",
    /// `Cocoa and Derivatives`: Refers to the presence of cocoa and their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_COCOA, "AllergenTypeCode-COCOA",
    /// `Coriander Derivatives`: Refers to the presence of coriander and their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_CORIANDER, "AllergenTypeCode-CORIANDER",
    /// `Corn and Derivatives`: Refers to the presence of corn and their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_CORN, "AllergenTypeCode-CORN",
    /// `Coumarin`: Refers to the presence of Coumarin as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_COUMARIN, "AllergenTypeCode-COUMARIN",
    /// `Crustaceans and Their Derivatives`: Refers to the presence of Crustaceans and their derivatives in the product, as listed as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_CRUSTACEANS, "AllergenTypeCode-CRUSTACEANS",
    /// `Eggs and Their Derivatives`: Refers to the presence of eggs and their derivatives in the product, as listed as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_EGGS, "AllergenTypeCode-EGGS",
    /// `Eugenol`: Refers to the presence of Eugenol as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_EUGENOL, "AllergenTypeCode-EUGENOL",
    /// `Evernia Furfuracea`: Refers to the presence of Evernia Furfuracea as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_EVERNIA_FURFURACEA, "AllergenTypeCode-EVERNIA_FURFURACEA",
    /// `Evernia Prunastri`: Refers to the presence of Evernia Prunastri as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_EVERNIA_PRUNASTRI, "AllergenTypeCode-EVERNIA_PRUNASTRI",
    /// `Farnesol`: Refers to the presence of Farnesol as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_FARNESOL, "AllergenTypeCode-FARNESOL",
    /// `Fish and Their Derivatives`: Refers to the presence of Fish and their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_FISH, "AllergenTypeCode-FISH",
    /// `Geraniol`: Refers to the presence of Geraniol as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_GERANIOL, "AllergenTypeCode-GERANIOL",
    /// `Gluten`: Refers to the presense of other gluten containing grain and gluten containing grain products as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_GLUTEN, "AllergenTypeCode-GLUTEN",
    /// `Hazelnut and Hazelnut Products`: Refers to the presence of hazelnut and hazelnut products as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_HAZELNUTS, "AllergenTypeCode-HAZELNUTS",
    /// `Hexyl Cinnamal`: Refers to the presence of Hexyl Cinnamal as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_HEXYL_CINNAMAL, "AllergenTypeCode-HEXYL_CINNAMAL",
    /// `Hydroxycitronellal`: Refers to the presence of Hydroxycitronellal as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_HYDROXYCITRONELLAL, "AllergenTypeCode-HYDROXYCITRONELLAL",
    /// `Hydroxyisohexyl 3-Cyclohexene Carboxaldehyde Isoeugenol Limonene Linal`: Refers to the presence of Hydroxyisohexyl 3-Cyclohexene Carboxaldehyde Isoeugenol Limonene Linal as listed in the regulations specified in AllergenSpecificationAgency and llergenSpecificationName.
    AllergenTypeCode_HYDROXYISOHEXYL_3_CYCLOHEXENE_CARBOXALDEHYDE_ISOEUGENOL_LIMONENE_LINAL, "AllergenTypeCode-HYDROXYISOHEXYL_3-CYCLOHEXENE_CARBOXALDEHYDE_ISOEUGENOL_LIMONENE_LINAL",
    /// `Kamut and Kamut Products`: Refers to the presence of kamut and kamut products (glutencontaining grain) as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_KAMUT, "AllergenTypeCode-KAMUT",
    /// `Lactose`: Refers to the presence of lactose as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_LACTOSE, "AllergenTypeCode-LACTOSE",
    /// `Lupine and Derivatives`: Refers to the presence of Lupine and their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_LUPINE, "AllergenTypeCode-LUPINE",
    /// `Macadamia Nut and Macadamia Nut Products`: Refers to the presence of macadamia nut and macadamia nut products as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_MACADAMIA_NUTS, "AllergenTypeCode-MACADAMIA_NUTS",
    /// `Methyl 2-Octynoate`: Refers to the presence of Methyl 2-Octynoate as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_METHYL_2_OCTYNOATE, "AllergenTypeCode-METHYL_2_OCTYNOATE",
    /// `Milk and Derivatives`: Refers to the presence of milk and their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_MILK, "AllergenTypeCode-MILK",
    /// `Molluscs and Their Derivatives`: Refers to the presence of molluscs and their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_MOLLUSCS, "AllergenTypeCode-MOLLUSCS",
    /// `Mustard and Derivatives`: Refers to the presence of mustard or their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_MUSTARD, "AllergenTypeCode-MUSTARD",
    /// `No Declaration Obligatory Allergens`: Does not contain declaration obligatory allergens as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_NO_DECLARED_ALLERGENS, "AllergenTypeCode-NO_DECLARED_ALLERGENS",
    /// `Oat and Oat Products`: Refers to the presence of oat and oat products (gluten containing grain) as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_OAT, "AllergenTypeCode-OAT",
    /// `Peanuts and Their Derivatives`: Refers to the presence of peanuts and their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_PEANUTS, "AllergenTypeCode-PEANUTS",
    /// `Peas and Pea Products`: Refers to the presence of peas and pea products as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_PEAS, "AllergenTypeCode-PEAS",
    /// `Pecan Nut and Pecan Nut`: Refers to the presence of pecan nut and pecan nut products as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_PECAN_NUTS, "AllergenTypeCode-PECAN_NUTS",
    /// `Pistachio and Pistachio Products`: Refers to the presence of pistachio and pistachio products as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_PISTACHIOS, "AllergenTypeCode-PISTACHIOS",
    /// `Pod Fruits Derivatives`: Refers to the presence of pod fruits and their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_POD_FRUITS, "AllergenTypeCode-POD_FRUITS",
    /// `Queensland Nut and Queensland Nut Products`: Refers to the presence of queensland nut and queensland nut products as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_QUEENSLAND_NUTS, "AllergenTypeCode-QUEENSLAND_NUTS",
    /// `Rye and Derivatives`: Refers to the presence of rye and their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_RYE, "AllergenTypeCode-RYE",
    /// `Sesame Seeds or Their Derivatives`: Refers to the presence of sesame seeds or their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_SESAME_SEEDS, "AllergenTypeCode-SESAME_SEEDS",
    /// `Soybeans and Their Derivatives`: Refers to the presence of soybeans and their derivatives in the product, as listed in as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_SOYBEANS, "AllergenTypeCode-SOYBEANS",
    /// `Spelt and Spelt Products`: Refers to the presence of spelt and spelt products (gluten containing grain) as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_SPELT, "AllergenTypeCode-SPELT",
    /// `Sulphur Dioxide and Sulphites`: Refers to the presence of sulphur dioxide and sulphites as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName.
    AllergenTypeCode_SULPHUR_DIOXIDE, "AllergenTypeCode-SULPHUR_DIOXIDE",
    /// `Tree Nuts and Their Derivatives`: Refers to the presence of tree nuts and their derivatives in the product, as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName. Tree nuts can include almonds, hazelnut, walnut, cashews, etc.
    AllergenTypeCode_TREE_NUTS, "AllergenTypeCode-TREE_NUTS",
    /// `Traces of Tree Nuts`: Contains Traces of Tree Nuts, i.e. almonds, various kinds of tree nuts.
    AllergenTypeCode_TREE_NUT_TRACES, "AllergenTypeCode-TREE_NUT_TRACES",
    /// `Walnut and Walnut Products`: Refers to the presence of walnut and walnut products as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_WALNUTS, "AllergenTypeCode-WALNUTS",
    /// `Wheat and Their Derivatives`: Refers to the presence of wheat and their derivatives in the product, as listed in the regulations specified in AllergenSpecificationAgency and AllergenSpecificationName
    AllergenTypeCode_WHEAT, "AllergenTypeCode-WHEAT",
    /// `Anatomical Form Code`: 
    AnatomicalFormCode, "AnatomicalFormCode",
    /// `Belly`: 
    AnatomicalFormCode_BELLY, "AnatomicalFormCode-BELLY",
    /// `Blood`: 
    AnatomicalFormCode_BLOOD, "AnatomicalFormCode-BLOOD",
    /// `Bone`: 
    AnatomicalFormCode_BONE, "AnatomicalFormCode-BONE",
    /// `Brain`: 
    AnatomicalFormCode_BRAIN, "AnatomicalFormCode-BRAIN",
    /// `Carcass Nonpoultry`: 
    AnatomicalFormCode_CARCASS_NONPOULTRY, "AnatomicalFormCode-CARCASS_NONPOULTRY",
    /// `Diaphram`: 
    AnatomicalFormCode_DIAPHRAM, "AnatomicalFormCode-DIAPHRAM",
    /// `Esophagus`: 
    AnatomicalFormCode_ESOPHAGUS, "AnatomicalFormCode-ESOPHAGUS",
    /// `Fat`: 
    AnatomicalFormCode_FAT, "AnatomicalFormCode-FAT",
    /// `Feet`: 
    AnatomicalFormCode_FEET, "AnatomicalFormCode-FEET",
    /// `Forequarter`: 
    AnatomicalFormCode_FOREQUARTER, "AnatomicalFormCode-FOREQUARTER",
    /// `Gizzard`: 
    AnatomicalFormCode_GIZZARD, "AnatomicalFormCode-GIZZARD",
    /// `Head`: 
    AnatomicalFormCode_HEAD, "AnatomicalFormCode-HEAD",
    /// `Headmeat Cheekmeat`: 
    AnatomicalFormCode_HEADMEAT_CHEEKMEAT, "AnatomicalFormCode-HEADMEAT_CHEEKMEAT",
    /// `Heart`: 
    AnatomicalFormCode_HEART, "AnatomicalFormCode-HEART",
    /// `Hindquarter`: 
    AnatomicalFormCode_HINDQUARTER, "AnatomicalFormCode-HINDQUARTER",
    /// `Horn`: 
    AnatomicalFormCode_HORN, "AnatomicalFormCode-HORN",
    /// `Intestine Large`: 
    AnatomicalFormCode_INTESTINE_LARGE, "AnatomicalFormCode-INTESTINE_LARGE",
    /// `Intenstine Small`: 
    AnatomicalFormCode_INTESTINE_SMALL, "AnatomicalFormCode-INTESTINE_SMALL",
    /// `Kidney`: 
    AnatomicalFormCode_KIDNEY, "AnatomicalFormCode-KIDNEY",
    /// `Lips`: 
    AnatomicalFormCode_LIPS, "AnatomicalFormCode-LIPS",
    /// `Liver`: 
    AnatomicalFormCode_LIVER, "AnatomicalFormCode-LIVER",
    /// `Lungs`: 
    AnatomicalFormCode_LUNGS, "AnatomicalFormCode-LUNGS",
    /// `Mixed Offal`: 
    AnatomicalFormCode_MIXED_OFFAL, "AnatomicalFormCode-MIXED_OFFAL",
    /// `Mixed Parts For Grounding or Mincing`: 
    AnatomicalFormCode_MIXED_PARTS_FOR_GROUNDING_MINCING, "AnatomicalFormCode-MIXED_PARTS_FOR_GROUNDING_MINCING",
    /// `Neck`: 
    AnatomicalFormCode_NECK, "AnatomicalFormCode-NECK",
    /// `Pancreas`: 
    AnatomicalFormCode_PANCREAS, "AnatomicalFormCode-PANCREAS",
    /// `Skin`: 
    AnatomicalFormCode_SKIN, "AnatomicalFormCode-SKIN",
    /// `Stomach`: 
    AnatomicalFormCode_STOMACH, "AnatomicalFormCode-STOMACH",
    /// `Tail`: 
    AnatomicalFormCode_TAIL, "AnatomicalFormCode-TAIL",
    /// `Tendons`: 
    AnatomicalFormCode_TENDONS, "AnatomicalFormCode-TENDONS",
    /// `Testicles`: 
    AnatomicalFormCode_TESTICLES, "AnatomicalFormCode-TESTICLES",
    /// `Thymus`: 
    AnatomicalFormCode_THYMUS, "AnatomicalFormCode-THYMUS",
    /// `Tongue`: 
    AnatomicalFormCode_TONGUE, "AnatomicalFormCode-TONGUE",
    /// `Tripe`: 
    AnatomicalFormCode_TRIPE, "AnatomicalFormCode-TRIPE",
    /// `Unclassified`: 
    AnatomicalFormCode_UNCLASSIFIED, "AnatomicalFormCode-UNCLASSIFIED",
    /// `Unidentified`: 
    AnatomicalFormCode_UNIDENTIFIED, "AnatomicalFormCode-UNIDENTIFIED",
    /// `Whole Bird`: 
    AnatomicalFormCode_WHOLE_BIRD, "AnatomicalFormCode-WHOLE_BIRD",
    /// `Whole Muscle Nonpoultry Meatpart Piece`: 
    AnatomicalFormCode_WHOLE_MUSCLE_NONPOULTRY_MEATPART_PIECE, "AnatomicalFormCode-WHOLE_MUSCLE_NONPOULTRY_MEATPART_PIECE",
    /// `Whole Muscle Poultry Part`: 
    AnatomicalFormCode_WHOLE_MUSCLE_POULTRY_PART, "AnatomicalFormCode-WHOLE_MUSCLE_POULTRY_PART",
    /// `Whole Muscle Primal`: 
    AnatomicalFormCode_WHOLE_MUSCLE_PRIMAL, "AnatomicalFormCode-WHOLE_MUSCLE_PRIMAL",
    /// `Whole Muscle Ribcut`: 
    AnatomicalFormCode_WHOLE_MUSCLE_RIBCUT, "AnatomicalFormCode-WHOLE_MUSCLE_RIBCUT",
    /// `Whole Muscle Roast Cut`: 
    AnatomicalFormCode_WHOLE_MUSCLE_ROASTCUT, "AnatomicalFormCode-WHOLE_MUSCLE_ROASTCUT",
    /// `Whole Muscle Slice Chopcut`: 
    AnatomicalFormCode_WHOLE_MUSCLE_SLICE_CHOPCUT, "AnatomicalFormCode-WHOLE_MUSCLE_SLICE_CHOPCUT",
    /// `Whole Muscle Slice Cutlet`: 
    AnatomicalFormCode_WHOLE_MUSCLE_SLICE_CUTLET, "AnatomicalFormCode-WHOLE_MUSCLE_SLICE_CUTLET",
    /// `Whole Muscle Steak Chop-cut`: 
    AnatomicalFormCode_WHOLE_MUSCLE_STEAK_CHOPCUT, "AnatomicalFormCode-WHOLE_MUSCLE_STEAK_CHOPCUT",
    /// `Whole Muscle Subprimal`: 
    AnatomicalFormCode_WHOLE_MUSCLE_SUBPRIMAL, "AnatomicalFormCode-WHOLE_MUSCLE_SUBPRIMAL",
    /// `Award Prize`: Describes a prize or award won by a product or organization.
    AwardPrizeDetails, "AwardPrizeDetails",
    /// `Beverage`: Any potable liquid.
    Beverage, "Beverage",
    /// `Brand`: Information on brands and sub-brands for a product.
    Brand, "Brand",
    /// `Certification`: Information about the type of certification issued by a certifying body.
    CertificationDetails, "CertificationDetails",
    /// `Cheese Firmness Code`: 
    CheeseFirmnessCode, "CheeseFirmnessCode",
    /// `Extra Hard`: 
    CheeseFirmnessCode_EXTRA_HARD, "CheeseFirmnessCode-EXTRA_HARD",
    /// `Firm Semi Hard`: 
    CheeseFirmnessCode_FIRM_SEMIHARD, "CheeseFirmnessCode-FIRM_SEMIHARD",
    /// `Hard`: 
    CheeseFirmnessCode_HARD, "CheeseFirmnessCode-HARD",
    /// `Soft`: 
    CheeseFirmnessCode_SOFT, "CheeseFirmnessCode-SOFT",
    /// `Unidentified`: 
    CheeseFirmnessCode_UNIDENTIFIED, "CheeseFirmnessCode-UNIDENTIFIED",
    /// `Clothing`:  A product that is worn on the body.
    Clothing, "Clothing",
    /// `Colour Code Details`: A set of colour code details (colour code, party controlling the code list) for the product.
    ColourCodeDetails, "ColourCodeDetails",
    /// `Assigned by Buyer`: Assigned by buyer.
    ColourCodeList_BUYER, "ColourCodeList-BUYER",
    /// `International Federation for Produce Standards`: International Federation for Produce Standards.
    ColourCodeList_IFPS, "ColourCodeList-IFPS",
    /// `Natural Colour System`: Natural Colour System.
    ColourCodeList_NCS, "ColourCodeList-NCS",
    /// `National Retail Federation.`: National Retail Federation.
    ColourCodeList_NRF, "ColourCodeList-NRF",
    /// `Pantone Hexachrome`: Pantone Hexachrome.
    ColourCodeList_PANTONE_HEXACHROME, "ColourCodeList-PANTONE_HEXACHROME",
    /// `Pantone Matching System`: Pantone Matching System.
    ColourCodeList_PANTONE_MATCHING, "ColourCodeList-PANTONE_MATCHING",
    /// `Pantone Process Colour System`: Pantone Process Colour System.
    ColourCodeList_PANTONE_PROCESS_COLOUR, "ColourCodeList-PANTONE_PROCESS_COLOUR",
    /// `Pantone Textile`: Pantone Textile. Same as GS1 ColourCodeList Code 5
    ColourCodeList_PANTONE_TEXTILE, "ColourCodeList-PANTONE_TEXTILE",
    /// `Farbsystem RAL Colour System`: Farbsystem RAL Colour System.
    ColourCodeList_RAL, "ColourCodeList-RAL",
    /// `Assigned by Seller`: Assigned by seller.
    ColourCodeList_SELLER, "ColourCodeList-SELLER",
    /// `Waren Wirtschafts System`: Waren Wirtschafts System.
    ColourCodeList_WWS, "ColourCodeList-WWS",
    /// `Colour Code List Code`: 
    ColourCodeListCode, "ColourCodeListCode",
    /// `Consumer Lifestage Code`: 
    ConsumerLifestageCode, "ConsumerLifestageCode",
    /// `Suitable for Adults`: 
    ConsumerLifestageCode_ADULT, "ConsumerLifestageCode-ADULT",
    /// `Suitable for All Ages`: 
    ConsumerLifestageCode_ALL_AGES, "ConsumerLifestageCode-ALL_AGES",
    /// `Suitable for Babies/Infants`: 
    ConsumerLifestageCode_BABY_INFANT, "ConsumerLifestageCode-BABY_INFANT",
    /// `Suitable for Children One to Two Years Old`: 
    ConsumerLifestageCode_CHILD_1_To_2_YEARS, "ConsumerLifestageCode-CHILD_1_To_2_YEARS",
    /// `Suitable for Children 2 Plus Years of Age`: 
    ConsumerLifestageCode_CHILD_2_YEARS_ONWARDS, "ConsumerLifestageCode-CHILD_2_YEARS_ONWARDS",
    /// `Unclassified`: 
    ConsumerLifestageCode_UNCLASSIFIED, "ConsumerLifestageCode-UNCLASSIFIED",
    /// `Unidentified`: 
    ConsumerLifestageCode_UNIDENTIFIED, "ConsumerLifestageCode-UNIDENTIFIED",
    /// `Consumer Sales Conditions Code`: 
    ConsumerSalesConditionsCode, "ConsumerSalesConditionsCode",
    /// `Behind the Counter`: Products that are sold without a prescription but must be distributed through a pharmacy.
    ConsumerSalesConditionsCode_BTC, "ConsumerSalesConditionsCode-BTC",
    /// `Over the Counter`: Products that may be sold without a prescription. These products are generally available without restrictions.
    ConsumerSalesConditionsCode_OTC, "ConsumerSalesConditionsCode-OTC",
    /// `Prescription Required`: Product may only be sold or dispensed under the direction of a prescription.
    ConsumerSalesConditionsCode_PRESCRIPTION_REQUIRED, "ConsumerSalesConditionsCode-PRESCRIPTION_REQUIRED",
    /// `Restricted To Sell 16`: Based upon legal regulatory restrictions it is illegal to sell the product to anyone under the age of 16 years old.
    ConsumerSalesConditionsCode_RESTRICTED_TO_SELL_16, "ConsumerSalesConditionsCode-RESTRICTED_TO_SELL_16",
    /// `Restricted To Sell 18`: Based upon legal regulatory restrictions it is illegal to sell the product to anyone under the age of 18 years old.
    ConsumerSalesConditionsCode_RESTRICTED_TO_SELL_18, "ConsumerSalesConditionsCode-RESTRICTED_TO_SELL_18",
    /// `Restricted To Sell 21`: Based upon legal regulatory restrictions it is illegal to sell the product to anyone under the age of 21 years old.
    ConsumerSalesConditionsCode_RESTRICTED_TO_SELL_21, "ConsumerSalesConditionsCode-RESTRICTED_TO_SELL_21",
    /// `Contact`: Information on an individual or department acting as point of contact for an organiation.
    ContactPoint, "ContactPoint",
    /// `Country`: Country is a complex data type that indicates a country and a country subdivision.
    Country, "Country",
    /// `Diet Type Code`: 
    DietTypeCode, "DietTypeCode",
    /// `Coeliac`: Denotes a product that can be safely consumed by a person with coeliac disease. Coeliac disease is caused by a reaction to gladin (a gluten protein found in wheat) and similar proteins found in other crops.
    DietTypeCode_COELIAC, "DietTypeCode-COELIAC",
    /// `Dietetic`: Denotes a product that is specially prepared or processed for people on restrictive diets.
    DietTypeCode_DIETETIC, "DietTypeCode-DIETETIC",
    /// `Free From Gluten`: Denotes a product that can be used in a gluten free diet, as specified by the appropriate authority within a target market.
    DietTypeCode_FREE_FROM_GLUTEN, "DietTypeCode-FREE_FROM_GLUTEN",
    /// `Halal`: Denotes selling or serving food ritually fit according to Islamic dietary laws.
    DietTypeCode_HALAL, "DietTypeCode-HALAL",
    /// `Kosher`: Denotes selling or serving food ritually fit according to Jewish dietary laws.
    DietTypeCode_KOSHER, "DietTypeCode-KOSHER",
    /// `Organic`: Denotes a food product that was produced with the use of feed or fertiliser of plant or animal origin, without employment of chemically formulated fertilisers, growth stimulants, antibiotics or pesticides.
    DietTypeCode_ORGANIC, "DietTypeCode-ORGANIC",
    /// `Vegan`: Denotes a food product which contains no animal food or dairy products.
    DietTypeCode_VEGAN, "DietTypeCode-VEGAN",
    /// `Vegetarian`: Denotes a product that contains no meat, fish or other animal products.
    DietTypeCode_VEGETARIAN, "DietTypeCode-VEGETARIAN",
    /// `Without Beef`: Denotes a product that contains no beef or beef-products. Beef is considered to be a taboo food product by some religions most notable Hinduism, Buddhism and Jainism.
    DietTypeCode_WITHOUT_BEEF, "DietTypeCode-WITHOUT_BEEF",
    /// `Without Pork`: Denotes a product that contains no pork meat.
    DietTypeCode_WITHOUT_PORK, "DietTypeCode-WITHOUT_PORK",
    /// `Diet Type Code Details`: A set of diet type code details (diet type code and diet type sub code) for the product.
    DietTypeCodeDetails, "DietTypeCodeDetails",
    /// `Discount`: Provides information on a discount applicable to an offer for example 2 percent.
    Discount, "Discount",
    /// `Discount Type Code`: 
    DiscountTypeCode, "DiscountTypeCode",
    /// `BOGO`: Buy one item and get the second item free of charge
    DiscountTypeCode_BOGO, "DiscountTypeCode-BOGO",
    /// `Discounted Item`: A discount on the item expressed as an amount (value and currency)
    DiscountTypeCode_DISCOUNTED_ITEM, "DiscountTypeCode-DISCOUNTED_ITEM",
    /// `Free Gift`: A gift given to a consumer as part of a promotional contingent on the consumer making a purchase of another item or items.
    DiscountTypeCode_FREE_GIFT, "DiscountTypeCode-FREE_GIFT",
    /// `Free Shipping`: No charge for shipping.
    DiscountTypeCode_FREE_SHIPPING, "DiscountTypeCode-FREE_SHIPPING",
    /// `Other`: A discount other than the ones on this list.
    DiscountTypeCode_OTHER, "DiscountTypeCode-OTHER",
    /// `Percentage Off`: A percentage off the product price.
    DiscountTypeCode_PERCENTAGE_OFF, "DiscountTypeCode-PERCENTAGE_OFF",
    /// `Food and Beverage Preparation Information`: Food and Beverage Preparation Information is a complex data type that indicates a preparation state code and preparation instructions.
    FoodAndBeveragePreparationInformation, "FoodAndBeveragePreparationInformation",
    /// `Food Beverage Refrigeration Claim Code`: 
    FoodBeverageRefrigerationClaimCode, "FoodBeverageRefrigerationClaimCode",
    /// `Can Be Refrigerated.`: 
    FoodBeverageRefrigerationClaimCode_CAN_BE_REFRIGERATED, "FoodBeverageRefrigerationClaimCode-CAN_BE_REFRIGERATED",
    /// `Must Be Refrigerated.`: 
    FoodBeverageRefrigerationClaimCode_MUST_BE_REFRIGERATED, "FoodBeverageRefrigerationClaimCode-MUST_BE_REFRIGERATED",
    /// `Shelf Stable.`: 
    FoodBeverageRefrigerationClaimCode_SHELF_STABLE, "FoodBeverageRefrigerationClaimCode-SHELF_STABLE",
    /// `Unidentified.`: 
    FoodBeverageRefrigerationClaimCode_UNIDENTIFIED, "FoodBeverageRefrigerationClaimCode-UNIDENTIFIED",
    /// `Food Beverage Target Use Code`: 
    FoodBeverageTargetUseCode, "FoodBeverageTargetUseCode",
    /// `Any Meal`: 
    FoodBeverageTargetUseCode_ANY_MEAL, "FoodBeverageTargetUseCode-ANY_MEAL",
    /// `Breakfast`: 
    FoodBeverageTargetUseCode_BREAKFAST, "FoodBeverageTargetUseCode-BREAKFAST",
    /// `Main Meal`: 
    FoodBeverageTargetUseCode_MAIN_MEAL, "FoodBeverageTargetUseCode-MAIN_MEAL",
    /// `Portable Meal`: 
    FoodBeverageTargetUseCode_PORTABLE_MEAL, "FoodBeverageTargetUseCode-PORTABLE_MEAL",
    /// `Snack`: 
    FoodBeverageTargetUseCode_SNACK, "FoodBeverageTargetUseCode-SNACK",
    /// `Unclassified`: 
    FoodBeverageTargetUseCode_UNCLASSIFIED, "FoodBeverageTargetUseCode-UNCLASSIFIED",
    /// `Food Beverage Tobacco Ingredient`: Food Beverage Tobacco Ingredient is a complex data type that includes an ingredient statement and details.
    FoodBeverageTobaccoIngredientDetails, "FoodBeverageTobaccoIngredientDetails",
    /// `Food Beverage Tobacco Product`: A food, beverage or tobacco product.
    FoodBeverageTobaccoProduct, "FoodBeverageTobaccoProduct",
    /// `Footwear`:  Outerwear that is worn on the feet such as shoes or boots.
    Footwear, "Footwear",
    /// `Footwear Fastening Type Code`: 
    FootwearFasteningTypeCode, "FootwearFasteningTypeCode",
    /// `Multiple Fastenings`: 
    FootwearFasteningTypeCode_MULTIPLE_FASTENING, "FootwearFasteningTypeCode-MULTIPLE_FASTENING",
    /// `Shoe Lace`: 
    FootwearFasteningTypeCode_SHOE_LACE, "FootwearFasteningTypeCode-SHOE_LACE",
    /// `Slip On Without Elastic`: 
    FootwearFasteningTypeCode_SLIP_ON_WITHOUT_ELASTIC, "FootwearFasteningTypeCode-SLIP_ON_WITHOUT_ELASTIC",
    /// `Slip On With Elastic`: 
    FootwearFasteningTypeCode_SLIP_ON_WITH_ELASTIC, "FootwearFasteningTypeCode-SLIP_ON_WITH_ELASTIC",
    /// `Strap`: 
    FootwearFasteningTypeCode_STRAP, "FootwearFasteningTypeCode-STRAP",
    /// `Unclassified`: 
    FootwearFasteningTypeCode_UNCLASSIFIED, "FootwearFasteningTypeCode-UNCLASSIFIED",
    /// `Unidentified`: 
    FootwearFasteningTypeCode_UNIDENTIFIED, "FootwearFasteningTypeCode-UNIDENTIFIED",
    /// `Velcro`: 
    FootwearFasteningTypeCode_VELCRO, "FootwearFasteningTypeCode-VELCRO",
    /// `Fresh Or Seawater Farmed Code`: 
    FreshOrSeawaterFarmedCode, "FreshOrSeawaterFarmedCode",
    /// `Freshwater Farmed`: 
    FreshOrSeawaterFarmedCode_FRESHWATER_FARMED, "FreshOrSeawaterFarmedCode-FRESHWATER_FARMED",
    /// `Seawater Farmed`: 
    FreshOrSeawaterFarmedCode_SEAWATER_FARMED, "FreshOrSeawaterFarmedCode-SEAWATER_FARMED",
    /// `Unclassified`: 
    FreshOrSeawaterFarmedCode_UNCLASSIFIED, "FreshOrSeawaterFarmedCode-UNCLASSIFIED",
    /// `Unidentified`: 
    FreshOrSeawaterFarmedCode_UNIDENTIFIED, "FreshOrSeawaterFarmedCode-UNIDENTIFIED",
    /// `Fruits and Vegetables`: Contains properties related specifically to fruit and vegetable products.
    FruitsVegetables, "FruitsVegetables",
    /// `GeoCoordinates`: The geographic coordinates of a place or event.
    GeoCoordinates, "GeoCoordinates",
    /// `Growing Method Code`: 
    GrowingMethodCode, "GrowingMethodCode",
    /// `Cage Free`: Animal is not confined to a cage.
    GrowingMethodCode_CAGE_FREE, "GrowingMethodCode-CAGE_FREE",
    /// `Cloned Food`: Product is a result of genetic engineering.
    GrowingMethodCode_CLONED_FOODS, "GrowingMethodCode-CLONED_FOODS",
    /// `Conventional`: Foods grown non-organically, either indoors or outdoors without any special processes.
    GrowingMethodCode_CONVENTIONAL, "GrowingMethodCode-CONVENTIONAL",
    /// `Farm Raised`: Animal is raised on a farm.
    GrowingMethodCode_FARM_RAISED, "GrowingMethodCode-FARM_RAISED",
    /// `Field Grown`: Plants Grown Outdoors
    GrowingMethodCode_FIELD_GROWN, "GrowingMethodCode-FIELD_GROWN",
    /// `Fly Free`: Citrus Grown in an area certified to be free of all Caribbean Fruit Flies based on trappings
    GrowingMethodCode_FLY_FREE, "GrowingMethodCode-FLY_FREE",
    /// `Free Range`: A method that animals are allowed to roam with little restriction to their movements.
    GrowingMethodCode_FREE_RANGE, "GrowingMethodCode-FREE_RANGE",
    /// `Grass Fed`: Animal is predominately fed grass or forage.
    GrowingMethodCode_GRASS_FED, "GrowingMethodCode-GRASS_FED",
    /// `Greenhouse`: Plants that are grown and cultivated in an indoor covered place.
    GrowingMethodCode_GREENHOUSE, "GrowingMethodCode-GREENHOUSE",
    /// `Humanely Raised`: A process where animals are raised such that the welfare of the animal is a foremost concern.
    GrowingMethodCode_HUMANELY_RAISED, "GrowingMethodCode-HUMANELY_RAISED",
    /// `Hydroponic`: Plants grown using mineral nutrient solutions instead of soil.
    GrowingMethodCode_HYDROPONIC, "GrowingMethodCode-HYDROPONIC",
    /// `Integrated Pest Management`: (IPM) Plants grown using a pest control strategy that uses an array of complimentary methods: mechanical devices, physical devices, genetic, biological, legal, cultural management and chemical management. These methods are done in three stages: prevention, observation, and intervention. It is an ecological approach with a main goal of significantly reducing or eliminating the use of pesticides.
    GrowingMethodCode_INTEGRATED_PEST_MANAGEMENT, "GrowingMethodCode-INTEGRATED_PEST_MANAGEMENT",
    /// `Organic`: Foods grown organically, either indoors or outdoors.
    GrowingMethodCode_ORGANIC, "GrowingMethodCode-ORGANIC",
    /// `Shade Grown`: Produce which has been grown under shade or grown under cloth.
    GrowingMethodCode_SHADE_GROWN, "GrowingMethodCode-SHADE_GROWN",
    /// `Sustainable`: 
    GrowingMethodCode_SUSTAINABLE, "GrowingMethodCode-SUSTAINABLE",
    /// `Wild`: The animal or plant was not inhibited or prohibited from roving, wandering, and not tamed or domesticated.
    GrowingMethodCode_WILD, "GrowingMethodCode-WILD",
    /// `Level Of Containment Code`: 
    LevelOfContainmentCode, "LevelOfContainmentCode",
    /// `Contains`: Intentionally included in the product.
    LevelOfContainmentCode_CONTAINS, "LevelOfContainmentCode-CONTAINS",
    /// `Free From`: The product is free from the indicated substance.
    LevelOfContainmentCode_FREE_FROM, "LevelOfContainmentCode-FREE_FROM",
    /// `May Contain`: The substance is not intentionally included, but due to shared production facilities or other reasons, the product may contain the substance.
    LevelOfContainmentCode_MAY_CONTAIN, "LevelOfContainmentCode-MAY_CONTAIN",
    /// `Maturation Method Code`: 
    MaturationMethodCode, "MaturationMethodCode",
    /// `Jet Fresh`: Freshly picked and immediately packed and shipped at mature stage and flown to destination for adequate distribution (i.e. imports from South America, Africa or Europe). Flown by jet to market; the carton will be labelled Jet Fresh, when applicable, stickered Jet Fresh. For the produce industry, most common with berries, stone fruits and pineapples.
    MaturationMethodCode_JET_FRESH, "MaturationMethodCode-JET_FRESH",
    /// `Preconditioned`: Product stored at proper temperature prior to shipment to allow ripening and/or colouring, adequate for distribution and/or consumption. Pre-conditioned product is matured to a specific maturity level as a result of ripening through either temperature, gas treatment, humidity or any combination thereof.
    MaturationMethodCode_PRECONDITIONED, "MaturationMethodCode-PRECONDITIONED",
    /// `Tree Vine Ripe`: Product that is picked at optimum maturity or just shy of. It is almost ripe or ready to eat. This fruit will be shipped immediately (imported = flown) from the pack-house and stickered as Tree or Vine Ripe.
    MaturationMethodCode_TREE_VINE_RIPE, "MaturationMethodCode-TREE_VINE_RIPE",
    /// `Measurement Precision Code`: 
    MeasurementPrecisionCode, "MeasurementPrecisionCode",
    /// `Approximately`: The method used to analyse the products resulted in approximate value of the nutritional content.
    MeasurementPrecisionCode_APPROXIMATELY, "MeasurementPrecisionCode-APPROXIMATELY",
    /// `Exact`: The method used to analyse the products resulted in exact value of the nutritional content.
    MeasurementPrecisionCode_EXACT, "MeasurementPrecisionCode-EXACT",
    /// `Less Than`: To indicate presence when the measurement value is too small to be measured precisely (rule states less than 0.5).
    MeasurementPrecisionCode_LESS_THAN, "MeasurementPrecisionCode-LESS_THAN",
    /// `MeasurementPrecisionTypeCode`: 
    MeasurementPrecisionTypeCode, "MeasurementPrecisionTypeCode",
    /// `Meat Poultry`: Meat and poultry products.
    MeatPoultry, "MeatPoultry",
    /// `Milk Butter Cream Yogurt Cheese Eggs Substitutes`: Milk butter cream yogurts cheese eggs and any substitutes for these products.
    MilkButterCreamYogurtCheeseEggsSubstitutes, "MilkButterCreamYogurtCheeseEggsSubstitutes",
    /// `Nonbinary Logic Code`: 
    NonbinaryLogicCode, "NonbinaryLogicCode",
    /// `False`: 
    NonbinaryLogicCode_FALSE, "NonbinaryLogicCode-FALSE",
    /// `Not Applicable`: 
    NonbinaryLogicCode_NOT_APPLICABLE, "NonbinaryLogicCode-NOT_APPLICABLE",
    /// `True`: 
    NonbinaryLogicCode_TRUE, "NonbinaryLogicCode-TRUE",
    /// `Unspecified`: 
    NonbinaryLogicCode_UNSPECIFIED, "NonbinaryLogicCode-UNSPECIFIED",
    /// `Nutrient Basis Quantity Code`: 
    NutrientBasisQuantityCode, "NutrientBasisQuantityCode",
    /// `By Measure`: Nutrient measurement is based on a measurement value for example grams or ounces.
    NutrientBasisQuantityCode_BY_MEASURE, "NutrientBasisQuantityCode-BY_MEASURE",
    /// `By Serving`: Nutrient measurement is based on a specified serving amount.
    NutrientBasisQuantityCode_BY_SERVING, "NutrientBasisQuantityCode-BY_SERVING",
    /// `Nutrition Measurement Type`: A class providing nutritional value and intake percent.
    NutritionMeasurementType, "NutritionMeasurementType",
    /// `Nutritional Claim Type Code`: 
    NutritionalClaimTypeCode, "NutritionalClaimTypeCode",
    /// `Additive Free`: A claim that a food is free from additives. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_ADDITIVE_FREE, "NutritionalClaimTypeCode-ADDITIVE_FREE",
    /// `Artificially Sweetened`: A claim that a food contains artificial sweeteners. Artificial sweeteners are sugar substitutes that are synthetic.
    NutritionalClaimTypeCode_ARTIFICIALLY_SWEETENED, "NutritionalClaimTypeCode-ARTIFICIALLY_SWEETENED",
    /// `Cholesterol Free`: A claim that a food is free from Cholesterol. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_CHOLESTEROL_FREE, "NutritionalClaimTypeCode-CHOLESTEROL_FREE",
    /// `Colouring Agent Free`: A claim that a food is free from colouring agents. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_COLOURING_AGENT_FREE, "NutritionalClaimTypeCode-COLOURING_AGENT_FREE",
    /// `Contains Glyzyrrhizin`: A claim that a food contains glyzyrrhizin. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_CONTAINS_GLYZYRRHIZIN, "NutritionalClaimTypeCode-CONTAINS_GLYZYRRHIZIN",
    /// `Contains Liquorice`: A claim that a food is contains liquorice. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_CONTAINS_LIQUORICE, "NutritionalClaimTypeCode-CONTAINS_LIQUORICE",
    /// `Contains Soy`: A claim that a food contains soy. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_CONTAINS_SOY, "NutritionalClaimTypeCode-CONTAINS_SOY",
    /// `Egg Free`: A claim that a food is free from egg. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_EGG_FREE, "NutritionalClaimTypeCode-EGG_FREE",
    /// `Energy Free`: A claim that a food is energy-free, and any claim likely to have the same meaning for the consumer, may only be made where the product contains less than 4kcal (17kj)/100ml. In the case of energy-free foods, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_ENERGY_FREE, "NutritionalClaimTypeCode-ENERGY_FREE",
    /// `Energy Reduced`: A claim that a food is energy-reduced, and any claim likely to have the same meaning for the consumer, may only be made where the energy value is reduced by at least 30%, with an indication of the characteristic(s), which make(s) the food reduced in its total energy value.
    NutritionalClaimTypeCode_ENERGY_REDUCED, "NutritionalClaimTypeCode-ENERGY_REDUCED",
    /// `Enriched or Fortified in Vitamins Minerals`: A claim that a food is enriched or fortified in vitamins and/or minerals, and any claim likely to have the same meaning for the consumer, may only be made where the product contains the vitamins and/or minerals in at least a significant amount as defined in the Annex of Directive 90/496/EEC.
    NutritionalClaimTypeCode_ENRICHED_OR_FORTIFIED_IN_VITAMINS_AND_OR_MINERALS, "NutritionalClaimTypeCode-ENRICHED_OR_FORTIFIED_IN_VITAMINS_AND_OR_MINERALS",
    /// `Fat Free`: A claim that a food is fat-free, and any claim likely to have the same meaning for the consumer, may only be made where the product contains no more than 0.5g of fat per 100g or 100ml. However, claims expressed as X% fat-free shall be prohibited. In the case of foods naturally fat-free, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_FAT_FREE, "NutritionalClaimTypeCode-FAT_FREE",
    /// `Free From Gluten`: A claim that a food is free from Gluten. Any claim likely to have the same meaning for the consumer, may only be made where the product contains an amount less than or equal to 20 mg/kg gluten according to the Commission Regulation (EC) No 41/2009
    NutritionalClaimTypeCode_FREE_FROM_GLUTEN, "NutritionalClaimTypeCode-FREE_FROM_GLUTEN",
    /// `Guarantee Lactose Free`: A claim that a food is regularly analysed to guarantee that the product is free from lactose.
    NutritionalClaimTypeCode_GUARANTEED_LACTOSE_FREE, "NutritionalClaimTypeCode-GUARANTEED_LACTOSE_FREE",
    /// `High Fibre`: A claim that a food is high in fibre, and any claim likely to have the same meaning for the consumer, may only be made where the product contains at least 6g of fibre per 100g or at least 3g of fibre per 100 kcal. In the case of foods naturally high in fibre, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_HIGH_FIBRE, "NutritionalClaimTypeCode-HIGH_FIBRE",
    /// `High Protein`: A claim that a food is high in protein, and any claim likely to have the same meaning for the consumer, may only be made where at least 20% of the energy value of the food is provided by protein. In the case of foods naturally high in protein, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_HIGH_PROTEIN, "NutritionalClaimTypeCode-HIGH_PROTEIN",
    /// `High in Vitamins Minerals`: A claim that a food is high in vitamins and or minerals, and any claim likely to have the same meaning for the consumer, may only be made where the product contains at least twice the value of source of vitamins and minerals. In case of foods naturally high in vitamins and/or minerals, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_HIGH_VITAMINS_AND_OR_MINERALS, "NutritionalClaimTypeCode-HIGH_VITAMINS_AND_OR_MINERALS",
    /// `Lactose Free`: A claim that a food is free of lactose. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_LACTOSE_FREE, "NutritionalClaimTypeCode-LACTOSE_FREE",
    /// `Light or Lite`: A claim stating that a product is light or lite, and any claim likely to have the same meaning for the consumer, shall follow the same conditions as those set for the term reduced; the claim shall also be accompanied by an indication of the characteristic(s) which make the food light or lite.
    NutritionalClaimTypeCode_LIGHT_LITE, "NutritionalClaimTypeCode-LIGHT_LITE",
    /// `Low Energy`: A claim that a food is low in energy, and any claim likely to have the same meaning for the consumer, may only be made where the product contains less than 40 kcal (170 kj)/100g and less than 20kcal (80kj)/100ml. In the case of foods naturally low in energy, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_LOW_ENERGY, "NutritionalClaimTypeCode-LOW_ENERGY",
    /// `Low in Fat`: A claim that a food is low in fat, and any claim likely to have the same meaning for the consumer, may only be made where the product contains no more than 3g of fat per 100g or 1.5g of fat per 100ml. In the case of foods naturally low in fat, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_LOW_FAT, "NutritionalClaimTypeCode-LOW_FAT",
    /// `Low in Lactose`: A claim that a food is low in lactose. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_LOW_LACTOSE, "NutritionalClaimTypeCode-LOW_LACTOSE",
    /// `Low Protein`: A claim that a food contains low levels of protein. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_LOW_PROTEIN, "NutritionalClaimTypeCode-LOW_PROTEIN",
    /// `Low in Saturated Fat`: A claim that a food is low in saturated fat, and any claim likely to have the same meaning for the consumer, may only be made where the product contains no more than 1.5g of saturates per 100g for solids or, 0.75g of saturates per 100ml for liquids and in either case saturated fat must not provide more than 10% of energy. In the case of foods naturally low in saturated fat, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_LOW_SATURATED_FAT, "NutritionalClaimTypeCode-LOW_SATURATED_FAT",
    /// `Low in Sodium`: A claim that a food is low in sodium, and any claim likely to have the same meaning for the consumer, may only be made where the product contains no more than 0.12g of sodium, or the equivalent value for salt, per 100g or per 100ml. In the case of foods naturally low in sodium, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_LOW_SODIUM_SALT, "NutritionalClaimTypeCode-LOW_SODIUM_SALT",
    /// `Low in sugars`: A claim that a food is low in sugars, and any claim likely to have the same meaning for the consumer, may only be made where the product contains no more than 5g of sugars per 100g or 100ml. In the case of foods naturally low in sugars, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_LOW_SUGARS, "NutritionalClaimTypeCode-LOW_SUGARS",
    /// `Milk Free`: A claim that a food is free from milk. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_MILK_FREE, "NutritionalClaimTypeCode-MILK_FREE",
    /// `Milk Protein Free`: A claim that a food is free from milk proteins. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_MILK_PROTEIN_FREE, "NutritionalClaimTypeCode-MILK_PROTEIN_FREE",
    /// `Natural Source of Vitamins Minerals`: A claim that a food is a natural source of vitamins and/or minerals, and any claim likely to have the same meaning for the consumer, may only be made where the product contains at least 15% of the recommended daily allowance specified in the Annex of Council Directive 90/496/EEC per 100 g or 100 ml.
    NutritionalClaimTypeCode_NATURAL_SOURCE_OF_VITAMINS_AND_OR_MINERALS, "NutritionalClaimTypeCode-NATURAL_SOURCE_OF_VITAMINS_AND_OR_MINERALS",
    /// `Non-alcoholic`: A claim that a food contains no alcohol. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_NON_ALCOHOLIC, "NutritionalClaimTypeCode-NON_ALCOHOLIC",
    /// `Nut Free`: A claim that a food is free from nuts. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_NUT_FREE, "NutritionalClaimTypeCode-NUT_FREE",
    /// `Peanut Free`: A claim that a food is free from peanuts. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_PEANUT_FREE, "NutritionalClaimTypeCode-PEANUT_FREE",
    /// `Preservative Free`: A claim that a food is free from preservatives. A preservative is a natural or synthetic substance or chemical that is added to products to prevent decomposition by microbial growth or by undesirable chemical changes. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_PRESERVATIVE_FREE, "NutritionalClaimTypeCode-PRESERVATIVE_FREE",
    /// `Saturated Fat Free`: A claim that a food does not contain saturated fat, and any claim likely to have the same meaning for the consumer, may only be made where the product contains no more than 0.1g of saturated fat per 100g or 100ml. In the case of foods naturally saturated fat-free, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_SATURATED_FAT_FREE, "NutritionalClaimTypeCode-SATURATED_FAT_FREE",
    /// `Sodium of Salt Free`: A claim that a food is sodium-free, and any claim likely to have the same meaning for the consumer, may only be made where the product contains no more than 0.005g of sodium, or the equivalent value for salt, per 100g. In the case of foods naturally sodium-free, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_SODIUM_FREE_OR_SALT_FREE, "NutritionalClaimTypeCode-SODIUM_FREE_OR_SALT_FREE",
    /// `Source of Fibre`: A claim that a food is a source of fibre, and any claim likely to have the same meaning for the consumer, may only be made where the product contains at least 3g of fibre per 100g or at least 1.5g of fibre per 100kcal. In the case of foods that are naturally sources of fibre, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_SOURCE_OF_FIBRE, "NutritionalClaimTypeCode-SOURCE_OF_FIBRE",
    /// `Source of Protein`: A claim that a food is a source of protein, and any claim likely to have the same meaning for the consumer, may only be made where at least 12% of the energy value of the food is provided by protein. In the case of foods that are naturally sources of protein, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_SOURCE_OF_PROTEIN, "NutritionalClaimTypeCode-SOURCE_OF_PROTEIN",
    /// `Soy Free`: A claim that a food is free from Soy. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_SOY_FREE, "NutritionalClaimTypeCode-SOY_FREE",
    /// `Strongly Salted`: A claim that a food has a high sodium content. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_STRONGLY_SALTED, "NutritionalClaimTypeCode-STRONGLY_SALTED",
    /// `Sugar Free`: A claim that a food is sugars-free, and any claim likely to have the same meaning for the consumer, may only be made where the product contains no more than 0.5g of sugars per 100g or 100ml. In the case of foods naturally sugars-free, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_SUGARS_FREE, "NutritionalClaimTypeCode-SUGARS_FREE",
    /// `Sweetened With Agave Syrup`: A claim that a food is sweetened with syrup from the Agave plant.
    NutritionalClaimTypeCode_SWEETENED_WITH_AGAVE_SYRUP, "NutritionalClaimTypeCode-SWEETENED_WITH_AGAVE_SYRUP",
    /// `Sweetened With Came Sugar`: A claim that a food is sweetened with sugar from sugar cane.
    NutritionalClaimTypeCode_SWEETENED_WITH_CANE_SUGAR, "NutritionalClaimTypeCode-SWEETENED_WITH_CANE_SUGAR",
    /// `Sweetened With Corn Syrup`: A claim that a food is sweetened with corn syrup.
    NutritionalClaimTypeCode_SWEETENED_WITH_CORN_SYRUP, "NutritionalClaimTypeCode-SWEETENED_WITH_CORN_SYRUP",
    /// `Sweetened With Fructose`: A claim that a food is sweetened with fructose.
    NutritionalClaimTypeCode_SWEETENED_WITH_FRUCTOSE, "NutritionalClaimTypeCode-SWEETENED_WITH_FRUCTOSE",
    /// `Sweetened With Fruit Juice`: A claim that a food is sweetened with fruit juice.
    NutritionalClaimTypeCode_SWEETENED_WITH_FRUIT_JUICE, "NutritionalClaimTypeCode-SWEETENED_WITH_FRUIT_JUICE",
    /// `Sweetened With Fruit Syrup`: A claim that a food is sweetened with fruit syrup. Fruit syrup is made from fruit and other ingredients such as sugar, corn syrup and water.
    NutritionalClaimTypeCode_SWEETENED_WITH_FRUIT_SYRUP, "NutritionalClaimTypeCode-SWEETENED_WITH_FRUIT_SYRUP",
    /// `Sweetened With Honey`: A claim that a food is sweetened with honey.
    NutritionalClaimTypeCode_SWEETENED_WITH_HONEY, "NutritionalClaimTypeCode-SWEETENED_WITH_HONEY",
    /// `Sweetened With Malt`: A claim that a food is sweetened with malt.
    NutritionalClaimTypeCode_SWEETENED_WITH_MALT, "NutritionalClaimTypeCode-SWEETENED_WITH_MALT",
    /// `Sweetened With Raw Beet Sugar`: A claim that a food is sweetened with raw sugar derived from the sugar beet.
    NutritionalClaimTypeCode_SWEETENED_WITH_RAW_BEET_SUGAR, "NutritionalClaimTypeCode-SWEETENED_WITH_RAW_BEET_SUGAR",
    /// `Sweetened With White Sugar`: A claim that a food is sweetened with white sugar. White or granulated sugar is refined sugar (pure white crystalline sucrose) ground to granules or grains.
    NutritionalClaimTypeCode_SWEETENED_WITH_WHITE_SUGAR, "NutritionalClaimTypeCode-SWEETENED_WITH_WHITE_SUGAR",
    /// `Very Low Gluten`: A claim that a food contains a low level of gluten which is defined as 21 - 100 mg/kg gluten according to the Commission Regulation (EC) No 41/2009
    NutritionalClaimTypeCode_VERY_LOW_GLUTEN, "NutritionalClaimTypeCode-VERY_LOW_GLUTEN",
    /// `Very Low in Sodium Salt`: A claim that a food is very low in sodium, and any claim likely to have the same meaning for the consumer, may only be made where the product contains no more than 0.04g of sodium, or the equivalent value for salt, per 100g or per 100 ml. In the case of foods naturally very low in sodium, the term naturally may be used as a prefix to this claim.
    NutritionalClaimTypeCode_VERY_LOW_SODIUM_SALT, "NutritionalClaimTypeCode-VERY_LOW_SODIUM_SALT",
    /// `Wheat Free`: A claim that a food is free from wheat. Note the amount that determines containment or lack of containment is based on target market regulations.
    NutritionalClaimTypeCode_WHEAT_FREE, "NutritionalClaimTypeCode-WHEAT_FREE",
    /// `No Added Sugar`: A claim stating that sugar has not been added to a food, and any claim likely to have the same meaning for the consumer, may only be made where the product does not contain any added mono- or disaccharides or any other food used for its sweetening properties.
    NutritionalClaimTypeCode_WITH_NO_ADDED_SUGARS, "NutritionalClaimTypeCode-WITH_NO_ADDED_SUGARS",
    /// `Offer`: An offer to transfer some rights to an item or to provide a service,for example, an offer to sell tickets to an event, to rent the DVD of a movie, to stream a TV show over the internet, to repair a motorcycle, or to loan a book.
    Offer, "Offer",
    /// `Offer Redemption Type Code`: 
    OfferRedemptionTypeCode, "OfferRedemptionTypeCode",
    /// `Coupon Code`: Offer available as a code that can be entered to redeem the coupon or voucher.
    OfferRedemptionTypeCode_COUPON_CODE, "OfferRedemptionTypeCode-COUPON_CODE",
    /// `Gift Card`: A prepaid stored-value money card.
    OfferRedemptionTypeCode_GIFT_CARD, "OfferRedemptionTypeCode-GIFT_CARD",
    /// `Rebate`: A partial refund upon purchase of a product.
    OfferRedemptionTypeCode_REBATE, "OfferRedemptionTypeCode-REBATE",
    /// `Sale`: Offer available as a reduced sales price on a product.
    OfferRedemptionTypeCode_SALE, "OfferRedemptionTypeCode-SALE",
    /// `Single Use Code`: Offer available as a code that can be entered once to redeem the coupon.
    OfferRedemptionTypeCode_SINGLE_USE_CODE, "OfferRedemptionTypeCode-SINGLE_USE_CODE",
    /// `Organic Claim Agency Code`: 
    OrganicClaimAgencyCode, "OrganicClaimAgencyCode",
    /// `Biological Farmers of Australia`: Biological Farmers of Australia
    OrganicClaimAgencyCode_BFA, "OrganicClaimAgencyCode-BFA",
    /// `Bioland`: Bioland: The leading organic farmers' association in Germany for the economy of organic-based businesses without synthetic pesticides and synthetic chemical nitrogen fertilizer. The animals are kept humanely and processed food carefully. This provides an environmentally sound and sustainable food production. http://www.bioland.de.
    OrganicClaimAgencyCode_BIOLAND, "OrganicClaimAgencyCode-BIOLAND",
    /// `Demeter-Bund`: The Demeter movement as an entrepreneurial network promotes the development of bio-dynamic economy, to secure the livelihoods of the world and to strengthen the positive people in his ministry. In cooperation contribute producers, processors, traders and consumers in partnership to shape the market.
    OrganicClaimAgencyCode_DEMETER_BUND, "OrganicClaimAgencyCode-DEMETER_BUND",
    /// `Demeter International`: Demeter International Demeter-International e. V. is a non profit organisation and its member organisations work together in the spirit of an international confederation with democratic principles. Membership requires a functioning Demeter certification programme. Same as GS1 Code 16
    OrganicClaimAgencyCode_DEMETER_INTERNATIONAL, "OrganicClaimAgencyCode-DEMETER_INTERNATIONAL",
    /// `Ecoland`: Ecoland is a membership organisation whose members elect a governing Board which is responsible for the design and implementation of the organic certification system.
    OrganicClaimAgencyCode_ECOLAND, "OrganicClaimAgencyCode-ECOLAND",
    /// `Ecovin`: ECOVIN Federation Organic Viticulture Association: ECOVIN largest merger in 1985 as ecologically-working wine estates in Germany was founded. Approximately 220 member companies currently manage 1,600 hectares of vineyards in 11 German wine-growing areas. Same as GS1 code 14
    OrganicClaimAgencyCode_ECOVIN, "OrganicClaimAgencyCode-ECOVIN",
    /// `US Environmental Protection Agency`: US Environmental Protection Agency. Same as GS1 Code 1
    OrganicClaimAgencyCode_EPA, "OrganicClaimAgencyCode-EPA",
    /// `FDA US Food and Drug Agency`: FDA US Food and Drug Agency
    OrganicClaimAgencyCode_FDA, "OrganicClaimAgencyCode-FDA",
    /// `FSA`: UK Food Standards Agency
    OrganicClaimAgencyCode_FSA, "OrganicClaimAgencyCode-FSA",
    /// `GAA`: GAA is a diverse farming association for farmers, processors and traders inside.Focal point is Germany. GAA is a special design for the structure of the organic farming. Biokreis- The Biokreis is an association for organic farming. Currently more than 800 farms, 80 and 200 processors, consumers are members of Biokreis, committed to working together on more than 33,000 for organic and sustainable farming.
    OrganicClaimAgencyCode_GAA, "OrganicClaimAgencyCode-GAA",
    /// `International Foundation for Organic Agriculture`: International Foundation for Organic Agriculture
    OrganicClaimAgencyCode_IFOA, "OrganicClaimAgencyCode-IFOA",
    /// `International Federation of Organic Agriculture Movements.`: The International Federation of Organic Agriculture Movements (IFOAM) is a grassroots and democratic organization that currently unites 750 member organizations in 116 countries. Same as GS1 code 15
    OrganicClaimAgencyCode_IFOAM, "OrganicClaimAgencyCode-IFOAM",
    /// `Naturland`: Naturland - Naturland is active the world over in promoting organic agriculture. Its members are farmers who produce a wide range of valuable products: coffee from Mexico and Peru, olive oil from Greece, tea from the slopes of India's mountains, pineapple and other tropical fruit from Uganda, spices from Sri Lanka. Organic agriculture safeguards the existence of smallholders and helps with the sustainable management of what are often fragile ecosystems. On a global scale, over 50,000 Naturland farmers are cultivating an area of over 142,000 hectares.Same as GS1 Code 12
    OrganicClaimAgencyCode_NATURLAND, "OrganicClaimAgencyCode-NATURLAND",
    /// `Quality Assurance International`: Quality Assurance International. QAI is a leading USDA-accredited organic product certifying agency.
    OrganicClaimAgencyCode_QAI, "OrganicClaimAgencyCode-QAI",
    /// `Sudtirol Bioland`: Bioland Association of South Tyrol The Association of South Tyrol is the largest organic association for organic farmers having to farmers in South Tyrol and the only active in association with a national association office Terlan.
    OrganicClaimAgencyCode_SUDITIROL, "OrganicClaimAgencyCode-SUDITIROL",
    /// `US Department of Agriculture`: US Department of Agriculture.
    OrganicClaimAgencyCode_USDA, "OrganicClaimAgencyCode-USDA",
    /// `Organic Claim Details`: A set of organic claim details for the product.
    OrganicClaimDetails, "OrganicClaimDetails",
    /// `Organization`: An Organization is any legal or physical entity involved at any point in any supply chain and upon which there is a need to retrieve predefined information. An Organization is uniquely identified by a Global Location Number (GLN).
    Organization, "Organization",
    /// `Organization Role Code`: 
    OrganizationRoleType, "OrganizationRoleType",
    /// `Accepting Organization`: Organization accepting goods, products, services etc.
    OrganizationRoleType_ACCEPTING_PARTY, "OrganizationRoleType-ACCEPTING_PARTY",
    /// `Bill of Lading Recipient`: Organization to receive Bill of Lading.
    OrganizationRoleType_BILL_OF_LADING_RECIPIENT, "OrganizationRoleType-BILL_OF_LADING_RECIPIENT",
    /// `Bill To`: Organization which receives goods and invoice.
    OrganizationRoleType_BILL_TO, "OrganizationRoleType-BILL_TO",
    /// `Brand Owner`: The organisation that owns the specifications of the Organization regardless of where and by whom it is manufactured is normally responsible for the allocation of the Global Trade Item Number (GTIN).
    OrganizationRoleType_BRAND_OWNER, "OrganizationRoleType-BRAND_OWNER",
    /// `Breeder`: The organization which breeds the animal.
    OrganizationRoleType_BREEDER, "OrganizationRoleType-BREEDER",
    /// `Broker Agent`: A person who buys or sells for another entity without having title to the property.
    OrganizationRoleType_BROKER_AGENT, "OrganizationRoleType-BROKER_AGENT",
    /// `Buyer`: Organization to which merchandise are sold.
    OrganizationRoleType_BUYER, "OrganizationRoleType-BUYER",
    /// `Buyers Agent Representative`: Third party who arranged the purchase of merchandise on behalf of the actual buyer.
    OrganizationRoleType_BUYERS_AGENT_REPRESENTATIVE, "OrganizationRoleType-BUYERS_AGENT_REPRESENTATIVE",
    /// `Carrier`: A company, which physically transports goods from one place to another.
    OrganizationRoleType_CARRIER, "OrganizationRoleType-CARRIER",
    /// `Central Payment Service`: Master of the conveyance. An organization providing central (or consolidated payment) services.
    OrganizationRoleType_CENTRAL_PAYMENT_SERVICE, "OrganizationRoleType-CENTRAL_PAYMENT_SERVICE",
    /// `Checking Organization`: Organization or contact designated on behalf of carrier or his agent to establish the actual figures for quantities, weight, volume and/or (cube) measurements of goods or containers which are to appear in the transport contract and on which charges will be based
    OrganizationRoleType_CHECKING_PARTY, "OrganizationRoleType-CHECKING_PARTY",
    /// `Cheque Order`: Organization to which the cheque will be ordered, when different from the beneficiary.
    OrganizationRoleType_CHEQUE_ORDER, "OrganizationRoleType-CHEQUE_ORDER",
    /// `Consignee.`: Organization to which goods are consigned.
    OrganizationRoleType_CONSIGNEE, "OrganizationRoleType-CONSIGNEE",
    /// `Consolidator`: Organization consolidating various consignments, payments etc.
    OrganizationRoleType_CONSOLIDATOR, "OrganizationRoleType-CONSOLIDATOR",
    /// `Consumer`: The end user of a product or a service.
    OrganizationRoleType_CONSUMER, "OrganizationRoleType-CONSUMER",
    /// `Corporate Identity`: Identity of the organization to whom all other parties of the same commercial organization are linked.
    OrganizationRoleType_CORPORATE_IDENTITY, "OrganizationRoleType-CORPORATE_IDENTITY",
    /// `Customs`: Identification of customs authority relevant to the transaction or shipment.
    OrganizationRoleType_CUSTOMS, "OrganizationRoleType-CUSTOMS",
    /// `Customs Broker`: Organization responsible for the preparation of documents and/or electronic submissions, the calculation on behalf of the client of taxes, duties and excises, and facilitating communication between the importer/exporter and governmental authorities.
    OrganizationRoleType_CUSTOMS_BROKER, "OrganizationRoleType-CUSTOMS_BROKER",
    /// `Cutter`: One engaged in carving meat (In EANCOM as Meat Cutter).
    OrganizationRoleType_CUTTER, "OrganizationRoleType-CUTTER",
    /// `Declarants Agent Representative`: Any natural or legal person who makes a declaration to an official body on behalf of another natural or legal person, where legally permitted (CCC).
    OrganizationRoleType_DECLARANTS_AGENT_REPRESENTATIVE, "OrganizationRoleType-DECLARANTS_AGENT_REPRESENTATIVE",
    /// `Delivery Organization`: Organization to which goods are delivered.
    OrganizationRoleType_DELIVERY_PARTY, "OrganizationRoleType-DELIVERY_PARTY",
    /// `Designer`: A Organization who designs.
    OrganizationRoleType_DESIGNER, "OrganizationRoleType-DESIGNER",
    /// `Despatch Organization`: Organization where goods are collected or taken over by the carrier.
    OrganizationRoleType_DESPATCH_PARTY, "OrganizationRoleType-DESPATCH_PARTY",
    /// `Distributor`: Organization distributing goods, financial payments or documents.
    OrganizationRoleType_DISTRIBUTOR, "OrganizationRoleType-DISTRIBUTOR",
    /// `Dock Door`: A door or collection of doors where trucks or rail cars are loaded (shipping) or unloaded (receiving). Used to load or unload products for logistics.
    OrganizationRoleType_DOCK_DOOR, "OrganizationRoleType-DOCK_DOOR",
    /// `Empty Equipment Despatch Organization`: Organization from whose premises empty equipment will be or has been despatched.
    OrganizationRoleType_EMPTY_EQUIPMENT_DESPATCH_PARTY, "OrganizationRoleType-EMPTY_EQUIPMENT_DESPATCH_PARTY",
    /// `Empty Equipment Return Organization`: Organization from whose premises empty equipment will be or has been returned.
    OrganizationRoleType_EMPTY_EQUIPMENT_RETURN_PARTY, "OrganizationRoleType-EMPTY_EQUIPMENT_RETURN_PARTY",
    /// `Equipment Owner`: Owner of equipment (container, etc.).
    OrganizationRoleType_EQUIPMENT_OWNER, "OrganizationRoleType-EQUIPMENT_OWNER",
    /// `Exporter`: Organization who makes - or on whose behalf a Customs clearing agent or other authorized person makes - an export declaration. This may include a manufacturer, seller or other person. Within a Customs union, consignor may have the same meaning as exporter
    OrganizationRoleType_EXPORTER, "OrganizationRoleType-EXPORTER",
    /// `Factor`: An organization that purchases financial receiving instruments e.g. invoices
    OrganizationRoleType_FACTOR, "OrganizationRoleType-FACTOR",
    /// `Fattener`: The Organization which fattens the animal.
    OrganizationRoleType_FATTENER, "OrganizationRoleType-FATTENER",
    /// `Freight Forwarder`: A person or firm that arranges for a pick up or deliver goods by a carrier on instructions of a shipper or consignee from or to a point by various necessary conveyances and common carriers.
    OrganizationRoleType_FREIGHT_FORWARDER, "OrganizationRoleType-FREIGHT_FORWARDER",
    /// `Goods Owner`: The organization which owns the goods.
    OrganizationRoleType_GOODS_OWNER, "OrganizationRoleType-GOODS_OWNER",
    /// `Grower`: An organization which is responsible for the growth or production of the unit specifically refers to vegetation. This organization may or may not be a producer or packer.
    OrganizationRoleType_GROWER, "OrganizationRoleType-GROWER",
    /// `Head Office`: The executive or main office of an enterprise.
    OrganizationRoleType_HEAD_OFFICE, "OrganizationRoleType-HEAD_OFFICE",
    /// `Importer`: Organization who makes - or on whose behalf a Customs clearing agent or other authorized person makes - an import declaration. This may include a person who has possession of the goods or to whom the goods are consigned.
    OrganizationRoleType_IMPORTER, "OrganizationRoleType-IMPORTER",
    /// `Information Provider`: The Organization providing the information contained in the document.
    OrganizationRoleType_INFORMATION_PROVIDER, "OrganizationRoleType-INFORMATION_PROVIDER",
    /// `Insurer`: A person or company offering insurance policies for premiums.
    OrganizationRoleType_INSURER, "OrganizationRoleType-INSURER",
    /// `Intermediary Bank 1`: A financial institution between the ordered bank and the beneficiary's bank.
    OrganizationRoleType_INTERMEDIARY_BANK_1, "OrganizationRoleType-INTERMEDIARY_BANK_1",
    /// `Intermediary Bank 2`: A financial institution between the ordered bank and the beneficiary's bank.
    OrganizationRoleType_INTERMEDIARY_BANK_2, "OrganizationRoleType-INTERMEDIARY_BANK_2",
    /// `Inventory Controller`: To specifically identify the organisation in charge of inventory control.
    OrganizationRoleType_INVENTORY_CONTROLLER, "OrganizationRoleType-INVENTORY_CONTROLLER",
    /// `Inventory Reporting Organization`: Organization reporting inventory information.
    OrganizationRoleType_INVENTORY_REPORTING_PARTY, "OrganizationRoleType-INVENTORY_REPORTING_PARTY",
    /// `Invoicee`: Organization issuing an invoice.
    OrganizationRoleType_INVOICEE, "OrganizationRoleType-INVOICEE",
    /// `Issuer of Invoice`: Organization which issues an invoice.
    OrganizationRoleType_ISSUER_OF_INVOICE, "OrganizationRoleType-ISSUER_OF_INVOICE",
    /// `Logistics Service Provider`: An umbrella term for an entity, which provides a combination of many different logistics services for another entity.
    OrganizationRoleType_LOGISTICS_SERVICE_PROVIDER, "OrganizationRoleType-LOGISTICS_SERVICE_PROVIDER",
    /// `Manufacturer of Goods`: Organization who manufactures the goods.
    OrganizationRoleType_MANUFACTURER_OF_GOODS, "OrganizationRoleType-MANUFACTURER_OF_GOODS",
    /// `Manufacturing Plant`: A physical location consisting of one or more buildings with facilities for manufacturing.
    OrganizationRoleType_MANUFACTURING_PLANT, "OrganizationRoleType-MANUFACTURING_PLANT",
    /// `Mark For`: The ultimate destination of a unit load or transport package of goods where the Ship-To is a different location.
    OrganizationRoleType_MARK_FOR, "OrganizationRoleType-MARK_FOR",
    /// `Message From.`: Organization where the message comes from.
    OrganizationRoleType_MESSAGE_FROM, "OrganizationRoleType-MESSAGE_FROM",
    /// `Message Recipient`: Organization receiving the message.
    OrganizationRoleType_MESSAGE_RECIPIENT, "OrganizationRoleType-MESSAGE_RECIPIENT",
    /// `Mincer`: One engaged in the cutting or chopping of meat into very small pieces
    OrganizationRoleType_MINCER, "OrganizationRoleType-MINCER",
    /// `Operating Division`: An entity that is part of another entity. For example, a Regional Marketing Office. Operating Divisions may have multiple days and times of operation.
    OrganizationRoleType_OPERATING_DIVISION, "OrganizationRoleType-OPERATING_DIVISION",
    /// `Operator`: A person or persons who own or operate a business establishment, which services consumers directly. For example a restaurant owner as part of a chain or an independent operation.
    OrganizationRoleType_OPERATOR, "OrganizationRoleType-OPERATOR",
    /// `Ordering Organization`: To be used only if ordering organization and buyer are not identical.
    OrganizationRoleType_ORDERING_PARTY, "OrganizationRoleType-ORDERING_PARTY",
    /// `Owner of equipment`: Organization who owns equipment.
    OrganizationRoleType_OWNER_OF_EQUIPMENT, "OrganizationRoleType-OWNER_OF_EQUIPMENT",
    /// `Owner of Means of Transport`: Organization owning the means of transport. Not a synonym of carrier
    OrganizationRoleType_OWNER_OF_MEANS_OF_TRANSPORT, "OrganizationRoleType-OWNER_OF_MEANS_OF_TRANSPORT",
    /// `Organization Declaring the Value Added Tax`: A code to identify the organization who is responsible for declaring the Value Added Tax (VAT) on the sale of goods or services.
    OrganizationRoleType_PARTY_DECLARING_THE_VALUE_ADDED_TAX, "OrganizationRoleType-PARTY_DECLARING_THE_VALUE_ADDED_TAX",
    /// `Organization For Whom Item is Ultimately Intended`: 
    OrganizationRoleType_PARTY_FOR_WHOM_ITEM_IS_ULTIMATELY_INTENDED, "OrganizationRoleType-PARTY_FOR_WHOM_ITEM_IS_ULTIMATELY_INTENDED",
    /// `Organization Receiving Private Data`: The organization who is allowed access to master data information by the data owner when the data is viewed as private.
    OrganizationRoleType_PARTY_RECEIVING_PRIVATE_DATA, "OrganizationRoleType-PARTY_RECEIVING_PRIVATE_DATA",
    /// `Organization Recovering the Value Added Tax`: A code to identify the organization who is eligible to recover the Value Added Tax (VAT) on the sale of goods or services.
    OrganizationRoleType_PARTY_RECOVERING_THE_VALUE_ADDED_TAX, "OrganizationRoleType-PARTY_RECOVERING_THE_VALUE_ADDED_TAX",
    /// `Organization to Receive All Documents`: An organization which is named to be the recipient of all documents.
    OrganizationRoleType_PARTY_TO_RECEIVE_ALL_DOCUMENTS, "OrganizationRoleType-PARTY_TO_RECEIVE_ALL_DOCUMENTS",
    /// `Organization to Receive Commercial Invoice`: Organization to whom payment for a commercial invoice or bill should be remitted.
    OrganizationRoleType_PARTY_TO_RECEIVE_COMMERCIAL_INVOICE, "OrganizationRoleType-PARTY_TO_RECEIVE_COMMERCIAL_INVOICE",
    /// `Organization to Receive Electronic Memo of Invoice`: Organization being informed about invoice issue (via EDI).
    OrganizationRoleType_PARTY_TO_RECEIVE_ELECTRONIC_MEMO_OF_INVOICE, "OrganizationRoleType-PARTY_TO_RECEIVE_ELECTRONIC_MEMO_OF_INVOICE",
    /// `Organization to Receive Freight Bill`: Organization to whom the freight bill should be sent.
    OrganizationRoleType_PARTY_TO_RECEIVE_FREIGHT_BILL, "OrganizationRoleType-PARTY_TO_RECEIVE_FREIGHT_BILL",
    /// `Organization to Receive Refund`: Organization to whom a refund is given.
    OrganizationRoleType_PARTY_TO_RECEIVE_REFUND, "OrganizationRoleType-PARTY_TO_RECEIVE_REFUND",
    /// `Payee`: Organization, which receives payment.
    OrganizationRoleType_PAYEE, "OrganizationRoleType-PAYEE",
    /// `Payer`: Organization which initiates payment.
    OrganizationRoleType_PAYER, "OrganizationRoleType-PAYER",
    /// `Point Of Sale`: Refers to the retail type checkout where bar code symbols are normally scanned.
    OrganizationRoleType_POINT_OF_SALE, "OrganizationRoleType-POINT_OF_SALE",
    /// `Price Location Organization`: An organization to which a price for a product is applicable. Within the context of GDSN Price Synchronization, it is also known as the 'Price Location' which is a GLN.
    OrganizationRoleType_PRICE_LOCATION_PARTY, "OrganizationRoleType-PRICE_LOCATION_PARTY",
    /// `Proxy`: A company that is selected by the Brand Owner to maintain their baseline attributes and Administrative Records in the GDSN.
    OrganizationRoleType_PROXY, "OrganizationRoleType-PROXY",
    /// `Public Warehouse`: A building, or a part of one, where storage space is offered to other companies for compensation (fee), for the storage of their goods, merchandise, etc.
    OrganizationRoleType_PUBLIC_WAREHOUSE, "OrganizationRoleType-PUBLIC_WAREHOUSE",
    /// `Purchase Order Receiver`: The organization that receives the purchase order for the goods or services.
    OrganizationRoleType_PURCHASE_ORDER_RECEIVER, "OrganizationRoleType-PURCHASE_ORDER_RECEIVER",
    /// `Registered Agent`: The organization having legal responsibility for the product in the target market for example a company to which market authorization has been issued.
    OrganizationRoleType_REGISTERED_AGENT, "OrganizationRoleType-REGISTERED_AGENT",
    /// `Remit To`: Organization to whom funds are directed for payment of a commercial invoice.
    OrganizationRoleType_REMIT_TO, "OrganizationRoleType-REMIT_TO",
    /// `Returnable Asset Service Centre`: The location where a returnable asset is serviced.
    OrganizationRoleType_RETURNABLE_ASSET_SERVICE_CENTRE, "OrganizationRoleType-RETURNABLE_ASSET_SERVICE_CENTRE",
    /// `Seller`: Organization which sells products or services to a buyer.
    OrganizationRoleType_SELLER, "OrganizationRoleType-SELLER",
    /// `Service Provider`: An organization providing services for another organization (e.g. re-packing supplier's products).
    OrganizationRoleType_SERVICE_PROVIDER, "OrganizationRoleType-SERVICE_PROVIDER",
    /// `Ship From`: Organization from where goods will be or have been shipped.
    OrganizationRoleType_SHIP_FROM, "OrganizationRoleType-SHIP_FROM",
    /// `Ship To`: Organization which receives goods and invoices.
    OrganizationRoleType_SHIP_TO, "OrganizationRoleType-SHIP_TO",
    /// `Slaughterer`: The Organization who has undertaken or will undertake a slaughter.
    OrganizationRoleType_SLAUGHTERER, "OrganizationRoleType-SLAUGHTERER",
    /// `Store`: A physical entity that sells products to a consumer.
    OrganizationRoleType_STORE, "OrganizationRoleType-STORE",
    /// `Substitute Supplier`: Organization which may be in a position to supply products or services should the main usual supplier be unable to do so.
    OrganizationRoleType_SUBSTITUTE_SUPPLIER, "OrganizationRoleType-SUBSTITUTE_SUPPLIER",
    /// `Supplier`: An organization that provides goods or services.
    OrganizationRoleType_SUPPLIER, "OrganizationRoleType-SUPPLIER",
    /// `Transportation Carrier`: Organization undertaking or arranging transport of goods between named points.
    OrganizationRoleType_TRANSPORTATION_CARRIER, "OrganizationRoleType-TRANSPORTATION_CARRIER",
    /// `Visiting Address`: An enterprise's physical location where guests are received during set working hours
    OrganizationRoleType_VISITING_ADDRESS, "OrganizationRoleType-VISITING_ADDRESS",
    /// `Warehouse and or Depot`: Industrial department of a company equipped with appropriate equipment and fittings in which goods are stored in appropriate conditions.
    OrganizationRoleType_WAREHOUSE_AND_OR_DEPOT, "OrganizationRoleType-WAREHOUSE_AND_OR_DEPOT",
    /// `Warehouse Keeper`: Organization taking responsibility for goods entered into a warehouse.
    OrganizationRoleType_WAREHOUSE_KEEPER, "OrganizationRoleType-WAREHOUSE_KEEPER",
    /// `WholeSaler`: Seller of articles, often in large quantities, to be retailed by others.
    OrganizationRoleType_WHOLESALER, "OrganizationRoleType-WHOLESALER",
    /// `Packaging`: Details on packaging for a product for example packaging type (bottle), materials, features, recycling, etc..
    PackagingDetails, "PackagingDetails",
    /// `Packaging Feature Code`: 
    PackagingFeatureCode, "PackagingFeatureCode",
    /// `Base`: A general term applied to the support or pedestal of an object.
    PackagingFeatureCode_BASE, "PackagingFeatureCode-BASE",
    /// `Beam`: Long sturdy piece of squared timber or metal used in house-building etc.
    PackagingFeatureCode_BEAM, "PackagingFeatureCode-BEAM",
    /// `Bung Seal`: A bung is an apparatus used to seal a container, such as a bottle, barrel or tubes. A bung is partially inserted inside the container to act as a seal. The most common every-day example of a bung is the stopper of a wine bottle.
    PackagingFeatureCode_BUNG_SEAL, "PackagingFeatureCode-BUNG_SEAL",
    /// `Cap`: A cap that seals a bottle or other form of packaging.
    PackagingFeatureCode_CAP, "PackagingFeatureCode-CAP",
    /// `Carrier`: A device of various types attached to or hung from trolleys to support the load.
    PackagingFeatureCode_CARRIER, "PackagingFeatureCode-CARRIER",
    /// `Consumption Utensil`: An item which allows the user to extract and/or consume the content of a container.
    PackagingFeatureCode_CONSUMPTION_UTENSIL, "PackagingFeatureCode-CONSUMPTION_UTENSIL",
    /// `Core`: A tubular shape around which flexible material such as plastic film or paper are wound for purposes of transport and handling.
    PackagingFeatureCode_CORE, "PackagingFeatureCode-CORE",
    /// `Creel`: A creel is a device for holding the required number of roving spools or other supply packages of reinforcement fibers for Fiber Reinforced Plastics manufacturing. This device holds the rovings in the desired position for unwinding in continuous processes like Pultrusion and Filament Winding.
    PackagingFeatureCode_CREEL, "PackagingFeatureCode-CREEL",
    /// `Edge Protection`: A right-angle piece placed over the outermost perimeter edges of a container to distribute pressure and prevent collapse or cutting from banding, strapping, or handling.
    PackagingFeatureCode_EDGE_PROTECTION, "PackagingFeatureCode-EDGE_PROTECTION",
    /// `Handle`: A grip attached to an object for using or moving the object, usually with the hands.
    PackagingFeatureCode_HANDLE, "PackagingFeatureCode-HANDLE",
    /// `Inner Container`: Inner Container
    PackagingFeatureCode_INNER_CONTAINER, "PackagingFeatureCode-INNER_CONTAINER",
    /// `Internal Divider`: An internal divider is an object, either flat or custom-shaped, used to separate the content of a container or to prevent the content from mixing.
    PackagingFeatureCode_INTERNAL_DIVIDER, "PackagingFeatureCode-INTERNAL_DIVIDER",
    /// `Label`: A label is a piece of paper, polymer, cloth, metal, or other material affixed to a container or article (or printed directly upon it), which usually carries information about the article to.which it has been attached.
    PackagingFeatureCode_LABEL, "PackagingFeatureCode-LABEL",
    /// `Lid`: In packaging, the top or bottom of a container, usually the part that closes the opening; may also be known as cap, over, or top
    PackagingFeatureCode_LID, "PackagingFeatureCode-LID",
    /// `Liner`: An internal chamber within a container which separates the content of the container from the walls. Inner liners provide additional isolation and protection to the content of a container. Sometimes coatings of certain materials may be applied as an alternative to inner liners.
    PackagingFeatureCode_LINER, "PackagingFeatureCode-LINER",
    /// `Lug`: A small indentation or raised portion on the surface of a bottle, provided as an indexing means for operations such as multi-pass decoration or labeling.
    PackagingFeatureCode_LUG, "PackagingFeatureCode-LUG",
    /// `Nesting Edge`: Edges which allow items of the same size to be partially stacked within one another in any direction thus reducing the space required in order to stack them.
    PackagingFeatureCode_NESTING_EDGE, "PackagingFeatureCode-NESTING_EDGE",
    /// `Peg`: A fastener which allows a product to be hanged.
    PackagingFeatureCode_PEG, "PackagingFeatureCode-PEG",
    /// `Pull Off Tab`: A flexible cover which can be easily removed in order to open a container.
    PackagingFeatureCode_PULL_OFF_TAB, "PackagingFeatureCode-PULL_OFF_TAB",
    /// `Ring Holder`: A hollow circular band of material wound around itself.
    PackagingFeatureCode_RING_HOLDER, "PackagingFeatureCode-RING_HOLDER",
    /// `Rivet`: A permanent fastener which consists of a cylindrical shaft with a head on one end and tail which is deformed to fixate the rivet in place.
    PackagingFeatureCode_RIVET, "PackagingFeatureCode-RIVET",
    /// `Sleeve`: A tubular form, open at both ends, that is slipped over an item or package.
    PackagingFeatureCode_SLEEVE, "PackagingFeatureCode-SLEEVE",
    /// `Spout`: A spout is a protruding edge which allows the lifting and pouring of liquids contained within a container.
    PackagingFeatureCode_SPOUT, "PackagingFeatureCode-SPOUT",
    /// `Tag`: A hanging card made of any material which is used to identify or provide additional information of a product.
    PackagingFeatureCode_TAG, "PackagingFeatureCode-TAG",
    /// `Wicker Outer Container`: An outer container made of wicker which is fitted to the bottle usually a little less than half way up from the bottom of the bottle and is used to hold, hang or support the bottle.
    PackagingFeatureCode_WICKER_OUTER_CONTAINER, "PackagingFeatureCode-WICKER_OUTER_CONTAINER",
    /// `Wrap`: A layer of any material which completely enclose a product. A wrap can have many purposes, from providing additional protection to an item to serving as a gift-wrap.
    PackagingFeatureCode_WRAP, "PackagingFeatureCode-WRAP",
    /// `Packaging Function Code`: 
    PackagingFunctionCode, "PackagingFunctionCode",
    /// `Antiseptic`: The process by which a sterile (aseptic) product (typically food or pharmaceutical) is packaged in a sterile container in a way which maintains sterility.
    PackagingFunctionCode_ANTISEPTIC, "PackagingFunctionCode-ANTISEPTIC",
    /// `Anti-tampering`: A methodology used to hinder, or deter unauthorized access to a device.
    PackagingFunctionCode_ANTI_TAMPERING, "PackagingFunctionCode-ANTI_TAMPERING",
    /// `Coated`: Covered with a material (paraffin, wax) that protects the product or packaging.
    PackagingFunctionCode_COATED, "PackagingFunctionCode-COATED",
    /// `Compressed`: Content has been pressed together to the maximum possible way.
    PackagingFunctionCode_COMPRESSED, "PackagingFunctionCode-COMPRESSED",
    /// `Dispenser`: A device or mechanism to supply or extract contents.
    PackagingFunctionCode_DISPENSER, "PackagingFunctionCode-DISPENSER",
    /// `Gift Wrapped`: Packaging is wrapped in a decorative way for the purposes of the consumer giving it as a gift.
    PackagingFunctionCode_GIFT_WRAPPED, "PackagingFunctionCode-GIFT_WRAPPED",
    /// `Isothermic`: Thermal carry container designed for the carriage of temperature controlled goods such as vaccines, pharmaceuticals, and medicines.
    PackagingFunctionCode_ISOTHERMIC, "PackagingFunctionCode-ISOTHERMIC",
    /// `Modified Atmosphere`: The practice of modifying the composition of the internal atmosphere of a package, (commonly food packages, and drugs) in order to improve the shelf life.
    PackagingFunctionCode_MODIFIED_ATMOSPHERE, "PackagingFunctionCode-MODIFIED_ATMOSPHERE",
    /// `Oxygen Infused`: A barrier packaging material for an infusion solution, i.e., oxygen.
    PackagingFunctionCode_OXYGEN_INFUSED, "PackagingFunctionCode-OXYGEN_INFUSED",
    /// `Peel Off`: A section of the packaging can be detached with ease in order to have access to the content or product, e.g. peel-off Lids used for packing Milk, Coffee and Cacao Powder.
    PackagingFunctionCode_PEEL_OFF, "PackagingFunctionCode-PEEL_OFF",
    /// `Pinpack`: The package is equipped to be hung up on a hook.
    PackagingFunctionCode_PINPACK, "PackagingFunctionCode-PINPACK",
    /// `Protected`: Functionality to keep from being damaged, attacked, stolen, or injured; guard.
    PackagingFunctionCode_PROTECTED, "PackagingFunctionCode-PROTECTED",
    /// `Reinforced`: A component is added to a container for a particular application to lend additional support under severe applications.
    PackagingFunctionCode_REINFORCED, "PackagingFunctionCode-REINFORCED",
    /// `Sift Proof`: Packaging is designed to prevent leaking of the content specially when it is on powdered or liquid state.
    PackagingFunctionCode_SIFT_PROOF, "PackagingFunctionCode-SIFT_PROOF",
    /// `Tamper Evident`: The packaging is designed to show when there has been some interference with the original sealing or configuration of the packaging.
    PackagingFunctionCode_TAMPER_EVIDENT, "PackagingFunctionCode-TAMPER_EVIDENT",
    /// `Water Resistant`: Coated with materials that make the packaging impervious to the effects of water.
    PackagingFunctionCode_WATER_RESISTANT, "PackagingFunctionCode-WATER_RESISTANT",
    /// `Packaging Marked Diet Allergen Code`: 
    PackagingMarkedDietAllergenCode, "PackagingMarkedDietAllergenCode",
    /// `Asthma and Allergist Association`: Definitions made by the asthma and allergist association.
    PackagingMarkedDietAllergenCode_APPROVED_BY_ASTHMA_AND_ALLERGY_ASSOC, "PackagingMarkedDietAllergenCode-APPROVED_BY_ASTHMA_AND_ALLERGY_ASSOC",
    /// `Approved for Tube Feeding`: The item is physically marked that it is approved for tube feeding by the appropriate authority of the target market.
    PackagingMarkedDietAllergenCode_APPROVED_FOR_TUBE_FEEDING, "PackagingMarkedDietAllergenCode-APPROVED_FOR_TUBE_FEEDING",
    /// `Biological`: Indicates the product has been marked as a biological item which indicates a food product that was produced with the use of feed or fertilizer of plant or animal origin, without employment of chemically formulated fertilizers, growth stimulants, antibiotics or pesticides.
    PackagingMarkedDietAllergenCode_BIOLOGICAL, "PackagingMarkedDietAllergenCode-BIOLOGICAL",
    /// `Calories Per Portion`: Indicates the product has a marking with the calories per portion contained in the product.
    PackagingMarkedDietAllergenCode_CALORIES_PER_PORTION, "PackagingMarkedDietAllergenCode-CALORIES_PER_PORTION",
    /// `Contains Latex`: The item is physically marked as containing Latex (rubber).
    PackagingMarkedDietAllergenCode_CONTAINS_LATEX, "PackagingMarkedDietAllergenCode-CONTAINS_LATEX",
    /// `Contains PVC`: The item is physically marked as containing PVC (Polyvinyl chloride). Phthalate content is unspecified.
    PackagingMarkedDietAllergenCode_CONTAINS_PVC, "PackagingMarkedDietAllergenCode-CONTAINS_PVC",
    /// `Contains PVC Without Phthalates`: The item is physically marked as containing PVC (Polyvinyl chloride) without phthalates.
    PackagingMarkedDietAllergenCode_CONTAINS_PVC_WITHOUT_PHTHALATES, "PackagingMarkedDietAllergenCode-CONTAINS_PVC_WITHOUT_PHTHALATES",
    /// `Contains PVC With Phthalates`: The item is physically marked as containing PVC (Polyvinyl chloride) with phthalates.
    PackagingMarkedDietAllergenCode_CONTAINS_PVC_WITH_PHTHALATES, "PackagingMarkedDietAllergenCode-CONTAINS_PVC_WITH_PHTHALATES",
    /// `450-800 Kilocalorie Per Day Diet`: The item is physically marked that it is approved for a 450-800 kilocalorie/day diet by the appropriate authority of the target market.
    PackagingMarkedDietAllergenCode_DIET_PRODUCT_450_800_KCAL_PER_DAY, "PackagingMarkedDietAllergenCode-DIET_PRODUCT_450_800_KCAL_PER_DAY",
    /// `800-1200 Kilocalorie Per Day Diet`: The item is physically marked that it is approved for a 800-1200 kilocalorie/day diet by the appropriate authority of the target market.
    PackagingMarkedDietAllergenCode_DIET_PRODUCT_800_1200_KCAL_PER_DAY, "PackagingMarkedDietAllergenCode-DIET_PRODUCT_800_1200_KCAL_PER_DAY",
    /// `Gezonde Keuze Klavertje`: Health symbol used in the Netherlands Target Market which indicates that the item is a cholesterol-reducing product.
    PackagingMarkedDietAllergenCode_GEZONDE_KEUZE_KLAVERTJE, "PackagingMarkedDietAllergenCode-GEZONDE_KEUZE_KLAVERTJE",
    /// `Halal`: Indicates the product has been marked as Halal which denotes selling or serving food ritually fit according to Islamic dietary laws.
    PackagingMarkedDietAllergenCode_HALAL, "PackagingMarkedDietAllergenCode-HALAL",
    /// `Ik Kies Bewust`: Conscious choice symbol used in the Netherlands Target Market which may be used for products low in saturated fat, trans fatty acids, sugar and salt.
    PackagingMarkedDietAllergenCode_IK_KIES_BEWUST, "PackagingMarkedDietAllergenCode-IK_KIES_BEWUST",
    /// `Kosher`: Indicates the product has been marked as Kosher which denotes selling or serving food ritually fit according to Jewish dietary laws.
    PackagingMarkedDietAllergenCode_KOSHER, "PackagingMarkedDietAllergenCode-KOSHER",
    /// `Lactase Enzyme`: The item is physically marked that it is approved as lactase enzyme by the appropriate authority of the target market.
    PackagingMarkedDietAllergenCode_LACTASE_ENZYME, "PackagingMarkedDietAllergenCode-LACTASE_ENZYME",
    /// `Low in Phenylalanine`: The item is physically marked as containing a low level of phenylalanine as approved by the appropriate authority of the target market.
    PackagingMarkedDietAllergenCode_LOW_ON_PHENYLALANINE, "PackagingMarkedDietAllergenCode-LOW_ON_PHENYLALANINE",
    /// `Low Sugar`: The item is physically marked as containing a low level of sugar as approved by the appropriate authority of the target market.
    PackagingMarkedDietAllergenCode_LOW_ON_SUGAR, "PackagingMarkedDietAllergenCode-LOW_ON_SUGAR",
    /// `Mother's Milk Substitute`: The item is physically marked that it is approved as substitute mother's milk the appropriate authority of the target market.
    PackagingMarkedDietAllergenCode_MOTHERS_MILK_SUBSTITUTE, "PackagingMarkedDietAllergenCode-MOTHERS_MILK_SUBSTITUTE",
    /// `Nutrition Supplement`: The item is physically marked that it is approved as nutrition supplement by the appropriate authority of the target market.
    PackagingMarkedDietAllergenCode_NUTRITION_SUPPLEMENT, "PackagingMarkedDietAllergenCode-NUTRITION_SUPPLEMENT",
    /// `Nyckelhal Mark`: Lean product.
    PackagingMarkedDietAllergenCode_NYCKELHAL_MARK, "PackagingMarkedDietAllergenCode-NYCKELHAL_MARK",
    /// `Vegetarian`: Indicates the product has been marked as vegetarian which denotes a product that contains no meat, fish or other animal products.
    PackagingMarkedDietAllergenCode_VEGETARIAN, "PackagingMarkedDietAllergenCode-VEGETARIAN",
    /// `Packaging Marked Free From Code`: 
    PackagingMarkedFreeFromCode, "PackagingMarkedFreeFromCode",
    /// `Free From Artificial Colouring`: The item is physically marked as having no artificial colouring.
    PackagingMarkedFreeFromCode_FREE_FROM_ARTIFICIAL_COLOURING, "PackagingMarkedFreeFromCode-FREE_FROM_ARTIFICIAL_COLOURING",
    /// `Free From Artificial Flavouring`: The item is physically marked as having no artificial flavouring.
    PackagingMarkedFreeFromCode_FREE_FROM_ARTIFICIAL_FLAVOURING, "PackagingMarkedFreeFromCode-FREE_FROM_ARTIFICIAL_FLAVOURING",
    /// `Free From Artificial Preservatives`: The item is physically marked as having no artificial preservatives.
    PackagingMarkedFreeFromCode_FREE_FROM_ARTIFICIAL_PRESERVATIVES, "PackagingMarkedFreeFromCode-FREE_FROM_ARTIFICIAL_PRESERVATIVES",
    /// `Free From Cholesterol`: The item is physically marked as having no Cholesterol.
    PackagingMarkedFreeFromCode_FREE_FROM_CHOLESTEROL, "PackagingMarkedFreeFromCode-FREE_FROM_CHOLESTEROL",
    /// `Free From Cloned Food`: The item is physically marked as being free from cloned food.
    PackagingMarkedFreeFromCode_FREE_FROM_CLONED_FOOD, "PackagingMarkedFreeFromCode-FREE_FROM_CLONED_FOOD",
    /// `Free From Dairy and Dairy Products`: The item is physically marked as being free from dairy and dairy products, as approved by the appropriate authority of the target market.
    PackagingMarkedFreeFromCode_FREE_FROM_DAIRY, "PackagingMarkedFreeFromCode-FREE_FROM_DAIRY",
    /// `Free From Egg`: The item is physically marked as free from egg.
    PackagingMarkedFreeFromCode_FREE_FROM_EGG, "PackagingMarkedFreeFromCode-FREE_FROM_EGG",
    /// `Free From Fish`: The item is physically marked as being free from fish.
    PackagingMarkedFreeFromCode_FREE_FROM_FISH, "PackagingMarkedFreeFromCode-FREE_FROM_FISH",
    /// `Free From Gluten`: The item is physically marked as free from gluten. This level of containment is frequently determined through regulation.
    PackagingMarkedFreeFromCode_FREE_FROM_GLUTEN, "PackagingMarkedFreeFromCode-FREE_FROM_GLUTEN",
    /// `Free Of Lactose`: The item is physically marked as being free of lactose.
    PackagingMarkedFreeFromCode_FREE_FROM_LACTOSE, "PackagingMarkedFreeFromCode-FREE_FROM_LACTOSE",
    /// `Free From Latex`: The item is physically marked being free from Latex (rubber).
    PackagingMarkedFreeFromCode_FREE_FROM_LATEX, "PackagingMarkedFreeFromCode-FREE_FROM_LATEX",
    /// `Free From Legume Protein`: The item is physically marked as being free from legume protein.
    PackagingMarkedFreeFromCode_FREE_FROM_LEGUME_PROTEIN, "PackagingMarkedFreeFromCode-FREE_FROM_LEGUME_PROTEIN",
    /// `Free From Milk`: The item is physically marked as being free from milk and any of its derivatives.
    PackagingMarkedFreeFromCode_FREE_FROM_MILK, "PackagingMarkedFreeFromCode-FREE_FROM_MILK",
    /// `Free From Milk Protein`: The item is physically marked as being free from milk protein.
    PackagingMarkedFreeFromCode_FREE_FROM_MILK_PROTEIN, "PackagingMarkedFreeFromCode-FREE_FROM_MILK_PROTEIN",
    /// `Naturally Free From Gluten`: The item is physically marked as being naturally free from gluten and not extracted as part of the manufacturing process.
    PackagingMarkedFreeFromCode_FREE_FROM_NATURAL_GLUTEN, "PackagingMarkedFreeFromCode-FREE_FROM_NATURAL_GLUTEN",
    /// `Free From Peanuts`: The item is physically marked as being free from peanuts.
    PackagingMarkedFreeFromCode_FREE_FROM_PEANUTS, "PackagingMarkedFreeFromCode-FREE_FROM_PEANUTS",
    /// `Free from Protein`: The item is physically marked as being free from protein.
    PackagingMarkedFreeFromCode_FREE_FROM_PROTEIN, "PackagingMarkedFreeFromCode-FREE_FROM_PROTEIN",
    /// `Free from PVC`: The item is physically marked as being free from PVC (Polyvinyl chloride).
    PackagingMarkedFreeFromCode_FREE_FROM_PVC, "PackagingMarkedFreeFromCode-FREE_FROM_PVC",
    /// `Free From Soya`: The item is physically marked as being free from soya.
    PackagingMarkedFreeFromCode_FREE_FROM_SOYA, "PackagingMarkedFreeFromCode-FREE_FROM_SOYA",
    /// `Free From Sugar`: The item is physically marked as being free from sugar.
    PackagingMarkedFreeFromCode_FREE_FROM_SUGAR, "PackagingMarkedFreeFromCode-FREE_FROM_SUGAR",
    /// `Free from Trans Fatty Acids`: The item is physically marked being free from Trans Fatty Acids (Trans Fat)
    PackagingMarkedFreeFromCode_FREE_FROM_TRANSFAT, "PackagingMarkedFreeFromCode-FREE_FROM_TRANSFAT",
    /// `Reduced Amount of Lactose`: The item is physically marked as having a reduced amount of lactose
    PackagingMarkedFreeFromCode_REDUCED_LACTOSE, "PackagingMarkedFreeFromCode-REDUCED_LACTOSE",
    /// `Low Level of Protein`: The item is physically marked as containing a low level of protein.
    PackagingMarkedFreeFromCode_REDUCED_PROTEIN, "PackagingMarkedFreeFromCode-REDUCED_PROTEIN",
    /// `Reduced Amount of Transfats`: The item is physically marked as having a reduced amount of transfats (unsaturated).
    PackagingMarkedFreeFromCode_REDUCED_TRANSFAT, "PackagingMarkedFreeFromCode-REDUCED_TRANSFAT",
    /// `Very Low Amount of Gluten`: The item is physically marked as a very low amount of gluten. Very low is frequently determined through regulation for example, per EU Regulation (EC) No 41/2009 [of 20 January 2009], this is defined as containing between 20 and 100 mg/kg).
    PackagingMarkedFreeFromCode_VERY_LOW_GLUTEN, "PackagingMarkedFreeFromCode-VERY_LOW_GLUTEN",
    /// `Without Added Salt`: The item is physically marked that no salt has been added when manufacturing the product but it still can contain salt that is naturally part of the ingredients, as approved by the appropriate authority of the target market.
    PackagingMarkedFreeFromCode_WITHOUT_ADDED_SALT, "PackagingMarkedFreeFromCode-WITHOUT_ADDED_SALT",
    /// `Without Added Sugar`: The item is physically marked that no sugar has been added when manufacturing the product but it still can contain sugars that are naturally part of the ingredients, as approved by the appropriate authority of the target market.
    PackagingMarkedFreeFromCode_WITHOUT_ADDED_SUGAR, "PackagingMarkedFreeFromCode-WITHOUT_ADDED_SUGAR",
    /// `Without Added Sweetener`: The item is physically marked that no sweetener has been added when manufacturing the product.
    PackagingMarkedFreeFromCode_WITHOUT_ADDED_SWEETENER, "PackagingMarkedFreeFromCode-WITHOUT_ADDED_SWEETENER",
    /// `Packaging Marked Label Accreditation Code`: 
    PackagingMarkedLabelAccreditationCode, "PackagingMarkedLabelAccreditationCode",
    /// `Austria Ministry of Agriculture Organic Label`: Austria Ministry of Agriculture Organic Label, AMA Marketing licenses the AMA organic logo. Red, white and black indicates the majority of ingredients are of Austrian origin.
    PackagingMarkedLabelAccreditationCode_AMA_ORGANIC_SEAL, "PackagingMarkedLabelAccreditationCode-AMA_ORGANIC_SEAL",
    /// `Aus Kaup Estonia`: Used to specify Estonia Meat in their product.
    PackagingMarkedLabelAccreditationCode_AUS_KAUP_ESTONIA, "PackagingMarkedLabelAccreditationCode-AUS_KAUP_ESTONIA",
    /// `BDIH Germany guidelines for Certified Natural Cosmetics`: 
    PackagingMarkedLabelAccreditationCode_BDIH_LOGO, "PackagingMarkedLabelAccreditationCode-BDIH_LOGO",
    /// `Beter Leven One Star Mark`: The one-star Beter Leven (better life) mark indicates that the product comes from a company that cares that animals are kept according to the minimal requirements for sanitation and well-being for the cattle industry.
    PackagingMarkedLabelAccreditationCode_BETER_LEVEN_1_STER, "PackagingMarkedLabelAccreditationCode-BETER_LEVEN_1_STER",
    /// `Beter Leven Two Star Mark`: The two-star Beter Leven (better life) mark indicates that the product comes from a company that provides for a higher well-being of animals than that established by the minimal requirements for sanitation and well-being for the cattle industry, yet the conditions are inferior to those of Biological-class products.
    PackagingMarkedLabelAccreditationCode_BETER_LEVEN_2_STER, "PackagingMarkedLabelAccreditationCode-BETER_LEVEN_2_STER",
    /// `Beter Leven Three Star Mark`: The three-star Beter Leven (better life) mark is awarded to products that come from companies that excel in keeping animals according to top guidelines for Biological-class products. In some cases this mark is accompanied by an EKO indication.
    PackagingMarkedLabelAccreditationCode_BETER_LEVEN_3_STER, "PackagingMarkedLabelAccreditationCode-BETER_LEVEN_3_STER",
    /// `Bio Austria`: 
    PackagingMarkedLabelAccreditationCode_BIO_AUSTRIA_LABEL, "PackagingMarkedLabelAccreditationCode-BIO_AUSTRIA_LABEL",
    /// `German national organic certification label (Bio-Siegel)`: 
    PackagingMarkedLabelAccreditationCode_BIO_LABEL_GERMAN, "PackagingMarkedLabelAccreditationCode-BIO_LABEL_GERMAN",
    /// `Represents interests of Swiss organic farmers`: 
    PackagingMarkedLabelAccreditationCode_BIO_SUISSE_BUD_SEAL, "PackagingMarkedLabelAccreditationCode-BIO_SUISSE_BUD_SEAL",
    /// `Blue Angel`: The Blue Angel is awarded to companies as kind of a reward for their commitment to environmental protection. They use it to professionally promote their eco-friendly products in the market. The Blue Angel is an ecological beacon showing the consumer the way to the ecologically superior product and promotes environmentally conscious consumption.
    PackagingMarkedLabelAccreditationCode_BLUE_ANGEL, "PackagingMarkedLabelAccreditationCode-BLUE_ANGEL",
    /// `Bord Bia Approved Logo`: The Bord Bia Approved logo is awarded to a company which has been audited by Bord Bia to verify that processes, from farm to fork, comply with the highest Quality Assurance Standards. These standards include animal welfare, traceability, environment, safety, feed, water, testing, inspection, hygiene and good manufacturing practice. Bord Bia Approved is awarded to a company where all the ingredients including meat content satisfy the Bord Bia requirements.
    PackagingMarkedLabelAccreditationCode_BORD_BIA_APPROVED, "PackagingMarkedLabelAccreditationCode-BORD_BIA_APPROVED",
    /// `Bord Bia Approved - Meat Content Only`: Bord Bia Approved - Meat Content Only applies to companies where only the meat content satisfies certain conditions detailed in the Bord Bia requirements document.
    PackagingMarkedLabelAccreditationCode_BORD_BIA_APPROVED_MEAT, "PackagingMarkedLabelAccreditationCode-BORD_BIA_APPROVED_MEAT",
    /// `Bra Miljoval`: Bra Miljoval Bra is the ecolabel of SSNC. It is referred to as Good Environmental Choice in English. SSNC started ecolabelling.
    PackagingMarkedLabelAccreditationCode_BRA_MILJOVAL_LABEL_SWEDISH, "PackagingMarkedLabelAccreditationCode-BRA_MILJOVAL_LABEL_SWEDISH",
    /// `Crossed grain logo`: Crossed grain logo is a trademark owned and administered by Coeliac. It is a worldwide symbol for safe gluten-free foods. Each country has their own Coeliac
    PackagingMarkedLabelAccreditationCode_CROSSED_GRAIN_SYMBOL, "PackagingMarkedLabelAccreditationCode-CROSSED_GRAIN_SYMBOL",
    /// `Demeter International Trademark`: Demeter International trademark for products of certified biodynamic production.
    PackagingMarkedLabelAccreditationCode_DEMETER_LABEL, "PackagingMarkedLabelAccreditationCode-DEMETER_LABEL",
    /// `ECOCERT Certification`: ECOCERT is a certification body for sustainable development.
    PackagingMarkedLabelAccreditationCode_ECOCERT_CERTIFICATE, "PackagingMarkedLabelAccreditationCode-ECOCERT_CERTIFICATE",
    /// `Eco Label Ladybug`: This is a Finnish label used by the Organic union, which represents the entire Finnish organic industry, consumers and producers in a common interest group. They work as a neutral voice in various working groups and consultations, and prepare position papers and presentations. The Federation also organizes training events and professional seminars. The Organic Federation also publishes the magazine Organic.
    PackagingMarkedLabelAccreditationCode_ECO_LABEL_LADYBUG, "PackagingMarkedLabelAccreditationCode-ECO_LABEL_LADYBUG",
    /// `EC National Health Mark`: The package is physically marked with EC National Health Mark. The EC National Health Mark is the health mark for specific hygiene regulations for food of animal origin. The regulation (EC) Nr. 853/2004 of 29. April 2004 of the European Parliament on hygiene rules for food of animal origin demands that companies handling products of animal origin are authorised according to this regulation. The official body responsible for this authorisation assigns a health mark to the food producing company
    PackagingMarkedLabelAccreditationCode_EC_NATIONAL_HEALTH_MARK, "PackagingMarkedLabelAccreditationCode-EC_NATIONAL_HEALTH_MARK",
    /// `EESTI OKOMARK (Label of Organic Food)`: Estonian Eco Label: Ministry of Agriculture Okomark (Label of Organic Food).
    PackagingMarkedLabelAccreditationCode_EESTI_OKOMARK, "PackagingMarkedLabelAccreditationCode-EESTI_OKOMARK",
    /// `Best Food Association of Estonia Food Industry`: Best Food Association of Estonia Food Industry http://www.toiduliit.ee/. An organisation that supports and promote Estonian food industry and economy, and contribute to a balanced and appropriate ethics to members of a favourable business environment for development.
    PackagingMarkedLabelAccreditationCode_EESTI_PARIM_TOIDUAINE, "PackagingMarkedLabelAccreditationCode-EESTI_PARIM_TOIDUAINE",
    /// `Skal EKO Label`: This symbol stands for organic production certified by Skal that meets the requirements of the EU-regulation for organic production. Skal is the inspection body for the organic production in the Netherlands.
    PackagingMarkedLabelAccreditationCode_EKO, "PackagingMarkedLabelAccreditationCode-EKO",
    /// `European Union Eco Label`: The item is physically marked with the European Union Eco label a European environmental initiative supported by the European Commission.
    PackagingMarkedLabelAccreditationCode_EU_ECO_LABEL, "PackagingMarkedLabelAccreditationCode-EU_ECO_LABEL",
    /// `EU Organic Farming Logo`: New EU organic logo the EU introduced a new organic logo to ensure consumer protection and common standards.
    PackagingMarkedLabelAccreditationCode_EU_ORGANIC_FARMING, "PackagingMarkedLabelAccreditationCode-EU_ORGANIC_FARMING",
    /// `The Fair Trade Mark`: The Fair Trade Mark certifies that products meet the social, economic and environmental International Fair trade Standards. The Fair Trade Mark is usually supported by a local Fair Trade Labelling Organization and certifies products not companies. It does not cover the companies or organizations selling the product
    PackagingMarkedLabelAccreditationCode_FAIR_TRADE_MARK, "PackagingMarkedLabelAccreditationCode-FAIR_TRADE_MARK",
    /// `Falken`: 
    PackagingMarkedLabelAccreditationCode_FALKEN, "PackagingMarkedLabelAccreditationCode-FALKEN",
    /// `Finnish Heart Symbol`: The heart symbol to inform the consumer at one glance that the product marked with this symbol is a preferred choice in its product group with regard to fat and sodium. Finnish Heart Association.
    PackagingMarkedLabelAccreditationCode_FINNISH_HEART_SYMBOL, "PackagingMarkedLabelAccreditationCode-FINNISH_HEART_SYMBOL",
    /// `Forest Stewardship Council Label`: The item is physically marked with the Forest Stewardship Council label.
    PackagingMarkedLabelAccreditationCode_FOREST_STEWARDSHIP_COUNCIL_LABEL, "PackagingMarkedLabelAccreditationCode-FOREST_STEWARDSHIP_COUNCIL_LABEL",
    /// `GMO Marked`: The item is physically marked as of genetically modified origin.
    PackagingMarkedLabelAccreditationCode_GMO_MARKED, "PackagingMarkedLabelAccreditationCode-GMO_MARKED",
    /// `Finfood Suomen Ruokatieto Ry`: 
    PackagingMarkedLabelAccreditationCode_GOODS_FROM_FINLAND_BLUE_SWAN, "PackagingMarkedLabelAccreditationCode-GOODS_FROM_FINLAND_BLUE_SWAN",
    /// `Green Dot`: 
    PackagingMarkedLabelAccreditationCode_GREEN_DOT, "PackagingMarkedLabelAccreditationCode-GREEN_DOT",
    /// `Green Restaurant Association Endorsed symbol`: The item is physically marked with the Green Restaurant Association Endorsed symbol.
    PackagingMarkedLabelAccreditationCode_GREEN_RESTAURANT_ASSOCIATION_ENDORSED, "PackagingMarkedLabelAccreditationCode-GREEN_RESTAURANT_ASSOCIATION_ENDORSED",
    /// `Green Seal Certified Symbol`: The item is physically marked with the Green Seal Certified symbol.
    PackagingMarkedLabelAccreditationCode_GREEN_SEAL_CERTIFIED, "PackagingMarkedLabelAccreditationCode-GREEN_SEAL_CERTIFIED",
    /// `Guaranteed Irish Symbol`: Ireland: The Guaranteed Irish symbol makes shopping for Irish products and services a lot easier. Shoppers know that when they buy a product or service featuring the guaranteed Irish logo they are supporting Irish companies and safeguarding Irish jobs.
    PackagingMarkedLabelAccreditationCode_GUARANTEED_IRISH, "PackagingMarkedLabelAccreditationCode-GUARANTEED_IRISH",
    /// `KRAV Mark`: 
    PackagingMarkedLabelAccreditationCode_KRAV_MARK, "PackagingMarkedLabelAccreditationCode-KRAV_MARK",
    /// `Allergy and Asthma Federation`: Allergy and Asthma Federation is a non-profit public health organisation. Our aim is to improve quality of life of the allergy and asthma patients.
    PackagingMarkedLabelAccreditationCode_LABEL_OF_THE_ALLERGY_AND_ASTHMA_FEDERATION, "PackagingMarkedLabelAccreditationCode-LABEL_OF_THE_ALLERGY_AND_ASTHMA_FEDERATION",
    /// `Leaping Bunny Program`: The Coalition for Consumer Information on Cosmetics (CCIC) Leaping Bunny Program administers a cruelty-free standard and the internationally recognized Leaping Bunny Logo for companies producing cosmetic, personal care, and household products. The Leaping Bunny Program provides the best assurance that no new animal testing is used in any phase of product development by the company, its laboratories, or suppliers.
    PackagingMarkedLabelAccreditationCode_LEAPING_BUNNY, "PackagingMarkedLabelAccreditationCode-LEAPING_BUNNY",
    /// `Loodussobralik Toode Estonia`: Eco-friendly product The sign eco-friendly product is designed to make environmentally friendly products on store shelves more as significant. When it comes to food shall be used for agriculture, natural farming methods. No use of mineral fertilizers, insect control and plant poisons.
    PackagingMarkedLabelAccreditationCode_LOODUSSOBRALIK_TOODE_ESTONIA, "PackagingMarkedLabelAccreditationCode-LOODUSSOBRALIK_TOODE_ESTONIA",
    /// `Love Irish Food`: Love Irish Food - a promotional label printed on the product packaging to indicate to the consumer that the food is manufactured in Ireland using Irish ingredients.
    PackagingMarkedLabelAccreditationCode_LOVE_IRISH_FOOD, "PackagingMarkedLabelAccreditationCode-LOVE_IRISH_FOOD",
    /// `Made in Finland`: Made in Finland Products that are made in Finland Avainlippu (Key Flag) Suomalaisen Tyon
    PackagingMarkedLabelAccreditationCode_MADE_IN_FINLAND_FLAG_WITH_KEY, "PackagingMarkedLabelAccreditationCode-MADE_IN_FINLAND_FLAG_WITH_KEY",
    /// `Marine Stewardship Council label`: 
    PackagingMarkedLabelAccreditationCode_MARINE_STEWARDSHIP_COUNCIL_LABEL, "PackagingMarkedLabelAccreditationCode-MARINE_STEWARDSHIP_COUNCIL_LABEL",
    /// `Max Havelaar`: Fair trade symbol used in the Netherlands Target Market awarded to manufacturers which contribute to improving the living and working conditions of small farmers and agricultural workers in disadvantaged regions.
    PackagingMarkedLabelAccreditationCode_MAX_HAVELAAR, "PackagingMarkedLabelAccreditationCode-MAX_HAVELAAR",
    /// `NATRUE Label`: The NATRUE Label guarantees that the products that carry it are made only with natural and organic ingredients, through soft manufacturing processes and environmentally friendly practices. The NATRUE Label is awarded by NATRUE, a non-profit organisation committed to promote and protect high standards of quality and environmental integrity.
    PackagingMarkedLabelAccreditationCode_NATRUE_LABEL, "PackagingMarkedLabelAccreditationCode-NATRUE_LABEL",
    /// `Green Key Hole`: The green key hole is to be put on the healthy foods in Sweden, Denmark, and Norway within certain product groups in order to make it easier for the customers to make a healthy choice. http://www.norden.org/
    PackagingMarkedLabelAccreditationCode_NYCKELHALET, "PackagingMarkedLabelAccreditationCode-NYCKELHALET",
    /// `Confidence in Textiles Oeko-Tex`: Confidence in textiles. This has been the motto of the independent test institutes of the International Oeko-Tex Association since 1992, with their tests for harmful substances according to Oeko-Tex Standard 100 for textile products of all types which pose no risk whatsoever to health.
    PackagingMarkedLabelAccreditationCode_OEKO_TEX_LABEL, "PackagingMarkedLabelAccreditationCode-OEKO_TEX_LABEL",
    /// `Luomo Sun Sign`: Luomo Sun Sign Denotes controlled organic production. The official label of the Finnish inspection authorities; owned by the Ministry of Agriculture and Forestry.
    PackagingMarkedLabelAccreditationCode_OFFICIAL_ECO_LABEL_SUN, "PackagingMarkedLabelAccreditationCode-OFFICIAL_ECO_LABEL_SUN",
    /// `Programme for Endorsement of Forest Certification`: Programme for Endorsement of Forest Certification (PEFCC_ is an international non-profit, non-governmental organisation dedicated to promoting Sustainable Forest Management (SFM) through independent third-party certification
    PackagingMarkedLabelAccreditationCode_PEFC, "PackagingMarkedLabelAccreditationCode-PEFC",
    /// `Protected Designation of Origin`: The Protected designation of origin is the name of an area, a specific place or, in exceptional cases, the name of a country, used as a designation for an agricultural product or a foodstuff, the entire product must be traditionally and ENTIRELY manufactured (prepared, processed AND produced) within the specific region and thus acquire unique properties. Protected Geographical Status (PGS) is a legal framework defined in European Union law to protect the names of regional foods.
    PackagingMarkedLabelAccreditationCode_PROTECTED_DESIGNATION_OF_ORIGIN, "PackagingMarkedLabelAccreditationCode-PROTECTED_DESIGNATION_OF_ORIGIN",
    /// `Protected Geographical Indication`: The Protected geographical indication is the name of an area, a specific place or, in exceptional cases, the name of a country, used as a description of an agricultural product or a foodstuff, the entire product must be traditionally and at least PARTIALLY manufactured (prepared, processed OR produced) within the specific region and thus acquire unique properties. Protected Geographical Status (PGS) is a legal framework[1] defined in European Union law to protect the names of regional foods.
    PackagingMarkedLabelAccreditationCode_PROTECTED_GEOGRAPHICAL_INDICATION, "PackagingMarkedLabelAccreditationCode-PROTECTED_GEOGRAPHICAL_INDICATION",
    /// `Protected Harvest Certified Symbol`: The item is physically marked with the Protected Harvest Certified symbol.
    PackagingMarkedLabelAccreditationCode_PROTECTED_HARVEST_CERTIFIED, "PackagingMarkedLabelAccreditationCode-PROTECTED_HARVEST_CERTIFIED",
    /// `Quality Mark Ireland`: Control IMO Organic farming is an alternative, environmentally friendly method of food production. It forbids the use of chemicals and requires production methods that respect animal welfare and do not damage the environment. The term organic can only be used on food labels in Ireland if the food product meets strict Irish and EU organic standards and is licensed by an approved certification body.
    PackagingMarkedLabelAccreditationCode_QUALITY_MARK_IRELAND, "PackagingMarkedLabelAccreditationCode-QUALITY_MARK_IRELAND",
    /// `Rainforest Alliance Certified Symbol`: The item is physically marked with the Rainforest Alliance Certified symbol.
    PackagingMarkedLabelAccreditationCode_RAINFOREST_ALLIANCE, "PackagingMarkedLabelAccreditationCode-RAINFOREST_ALLIANCE",
    /// `Scharrelvlees`: A symbol used in the Netherlands Target Market intended for meat based products which guarantees that the animals has been growth without the use of antibiotics.
    PackagingMarkedLabelAccreditationCode_SCHARRELVLEES, "PackagingMarkedLabelAccreditationCode-SCHARRELVLEES",
    /// `Soil Association Organic Symbol`: The Soil Association Organic Symbol is a symbol used in the UK to show that products meet a strict set of organic standards that protect health, sustainability and the environment.
    PackagingMarkedLabelAccreditationCode_SOIL_ASSOCIATION_ORGANIC_SYMBOL, "PackagingMarkedLabelAccreditationCode-SOIL_ASSOCIATION_ORGANIC_SYMBOL",
    /// `Sustainably Produced Palm Oil`: In response to the urgent and pressing global call for sustainably produced palm oil, the Roundtable on Sustainable Palm Oil (RSPO) was formed in 2004 with the objective of promoting the growth and use of sustainable oil palm products through credible global standards and engagement of stakeholders.
    PackagingMarkedLabelAccreditationCode_SUSTAINABLE_PALM_OIL_RSPO, "PackagingMarkedLabelAccreditationCode-SUSTAINABLE_PALM_OIL_RSPO",
    /// `Svanen`: The Swan is the Nordic environmental label. It was established by the Nordic Council of Ministers in 1989 and Denmark joined in 1997. The Swan is used in all Nordic countries, i.e. Denmark, Norway, Sweden, Finland and Iceland.
    PackagingMarkedLabelAccreditationCode_SVANEN, "PackagingMarkedLabelAccreditationCode-SVANEN",
    /// `Swedish Seal of Quality Label`: The item is physically marked with the Swedish Seal of Quality label which intends to guarantee the responsibility for the environment of the product.
    PackagingMarkedLabelAccreditationCode_SWEDISH_SEAL_OF_QUALITY, "PackagingMarkedLabelAccreditationCode-SWEDISH_SEAL_OF_QUALITY",
    /// `Traditional Specialty Guaranteed`: The Traditional specialty guaranteed is a trademark for an agricultural product or a foodstuff, which has a certain feature or a set of features, setting it clearly apart from other similar products or foodstuffs belonging to the same category. The product or foodstuff must be manufactured using traditional ingredients or must be characteristic for its traditional composition, production process, or processing reflecting a traditional type of manufacturing or processing.
    PackagingMarkedLabelAccreditationCode_TRADITIONAL_SPECIALTY_GUARANTEED, "PackagingMarkedLabelAccreditationCode-TRADITIONAL_SPECIALTY_GUARANTEED",
    /// `Approved Estonian Taste`: Approved Estonian Taste - Quality/Tradition/Origin/Traceability for Estonian products. All raw materials must be 100% Estonian. Estonian Chamber of Agriculture and Commerce.
    PackagingMarkedLabelAccreditationCode_TUNNUSTATUD_EESTI_MAITSE, "PackagingMarkedLabelAccreditationCode-TUNNUSTATUD_EESTI_MAITSE",
    /// `Tunnustatud Maitse`: Approved Taste label (designed as a barn swallow) denoting Estonian origin and high quality was introduced. This label has been given to products for Food quality and safety. Estonian Chamber of Agriculture and Commerce (ECAC).
    PackagingMarkedLabelAccreditationCode_TUNNUSTATUD_MAITSE, "PackagingMarkedLabelAccreditationCode-TUNNUSTATUD_MAITSE",
    /// `Uniquely Finnish`: Uniquely Finnish http://www.maakuntienparhaat.fi/en/ The Uniquely Finnish label is a national quality label for small entrepreneurs. ProAgria Association of Rural Advisory Centres grants the label to qualified foodstuff, handicraft and rural tourism companies based on applications.
    PackagingMarkedLabelAccreditationCode_UNIQUELY_FINNISH, "PackagingMarkedLabelAccreditationCode-UNIQUELY_FINNISH",
    /// `US Department of Agriculture`: 
    PackagingMarkedLabelAccreditationCode_USDA, "PackagingMarkedLabelAccreditationCode-USDA",
    /// `UTZ Certified`: A certification which is intended to assure the social and environmental quality in coffee production. Coffee based products may be marked with this certification.
    PackagingMarkedLabelAccreditationCode_UTZ_CERTIFIED, "PackagingMarkedLabelAccreditationCode-UTZ_CERTIFIED",
    /// `Vaelg Fuldkorn forst`: Grain based foods (bread, breakfast products, baking articles etc.) which have got a high content of whole grain will be puffed with a nutritional puff from the beginning of 2009: Please choose whole grain first.
    PackagingMarkedLabelAccreditationCode_VAELG_FULDKORN_FORST, "PackagingMarkedLabelAccreditationCode-VAELG_FULDKORN_FORST",
    /// `World Wildlife Federation Panda`: Products that support the World Wildlife Federation.
    PackagingMarkedLabelAccreditationCode_WWF_PANDA_LABEL, "PackagingMarkedLabelAccreditationCode-WWF_PANDA_LABEL",
    /// `Packaging Material Details`: Information on any material used for packaging.
    PackagingMaterialDetails, "PackagingMaterialDetails",
    /// `Packaging Material Type Code`: 
    PackagingMaterialTypeCode, "PackagingMaterialTypeCode",
    /// `Ceramic`: 
    PackagingMaterialTypeCode_CERAMIC, "PackagingMaterialTypeCode-CERAMIC",
    /// `Cloth of Fabric`: 
    PackagingMaterialTypeCode_CLOTH_OR_FABRIC, "PackagingMaterialTypeCode-CLOTH_OR_FABRIC",
    /// `Composite`: 
    PackagingMaterialTypeCode_COMPOSITE, "PackagingMaterialTypeCode-COMPOSITE",
    /// `Corrugated Board Double Wall`: 
    PackagingMaterialTypeCode_CORRUGATED_BOARD_DOUBLE_WALL, "PackagingMaterialTypeCode-CORRUGATED_BOARD_DOUBLE_WALL",
    /// `Corrugated Board Other`: 
    PackagingMaterialTypeCode_CORRUGATED_BOARD_OTHER, "PackagingMaterialTypeCode-CORRUGATED_BOARD_OTHER",
    /// `Corrugated Board Single Wall`: 
    PackagingMaterialTypeCode_CORRUGATED_BOARD_SINGLE_WALL, "PackagingMaterialTypeCode-CORRUGATED_BOARD_SINGLE_WALL",
    /// `Corrugated Board Triple Wall`: 
    PackagingMaterialTypeCode_CORRUGATED_BOARD_TRIPLE_WALL, "PackagingMaterialTypeCode-CORRUGATED_BOARD_TRIPLE_WALL",
    /// `Fibre Burlap`: 
    PackagingMaterialTypeCode_FIBRE_BURLAP, "PackagingMaterialTypeCode-FIBRE_BURLAP",
    /// `Fibre Cotton`: 
    PackagingMaterialTypeCode_FIBRE_COTTON, "PackagingMaterialTypeCode-FIBRE_COTTON",
    /// `Fibre Flax`: 
    PackagingMaterialTypeCode_FIBRE_FLAX, "PackagingMaterialTypeCode-FIBRE_FLAX",
    /// `Fibre Hemp`: 
    PackagingMaterialTypeCode_FIBRE_HEMP, "PackagingMaterialTypeCode-FIBRE_HEMP",
    /// `Fibre Jute`: 
    PackagingMaterialTypeCode_FIBRE_JUTE, "PackagingMaterialTypeCode-FIBRE_JUTE",
    /// `Fibre Other`: 
    PackagingMaterialTypeCode_FIBRE_OTHER, "PackagingMaterialTypeCode-FIBRE_OTHER",
    /// `Foam`: 
    PackagingMaterialTypeCode_FOAM, "PackagingMaterialTypeCode-FOAM",
    /// `Glass`: 
    PackagingMaterialTypeCode_GLASS, "PackagingMaterialTypeCode-GLASS",
    /// `Glass Coloured`: 
    PackagingMaterialTypeCode_GLASS_COLOURED, "PackagingMaterialTypeCode-GLASS_COLOURED",
    /// `Laminated Carton`: 
    PackagingMaterialTypeCode_LAMINATED_CARTON, "PackagingMaterialTypeCode-LAMINATED_CARTON",
    /// `Metal Aluminum`: 
    PackagingMaterialTypeCode_METAL_ALUMINUM, "PackagingMaterialTypeCode-METAL_ALUMINUM",
    /// `Metal Brass`: 
    PackagingMaterialTypeCode_METAL_BRASS, "PackagingMaterialTypeCode-METAL_BRASS",
    /// `Metal Iron`: 
    PackagingMaterialTypeCode_METAL_IRON, "PackagingMaterialTypeCode-METAL_IRON",
    /// `Metal Lead`: 
    PackagingMaterialTypeCode_METAL_LEAD, "PackagingMaterialTypeCode-METAL_LEAD",
    /// `Metal Other`: 
    PackagingMaterialTypeCode_METAL_OTHER, "PackagingMaterialTypeCode-METAL_OTHER",
    /// `Metal Stainless Steel`: 
    PackagingMaterialTypeCode_METAL_STAINLESS_STEEL, "PackagingMaterialTypeCode-METAL_STAINLESS_STEEL",
    /// `Metal Steel`: 
    PackagingMaterialTypeCode_METAL_STEEL, "PackagingMaterialTypeCode-METAL_STEEL",
    /// `Metal Tin`: 
    PackagingMaterialTypeCode_METAL_TIN, "PackagingMaterialTypeCode-METAL_TIN",
    /// `Mineral Calcium Carbonate`: 
    PackagingMaterialTypeCode_MINERAL_CALCIUM_CARBONATE, "PackagingMaterialTypeCode-MINERAL_CALCIUM_CARBONATE",
    /// `Mineral Other`: 
    PackagingMaterialTypeCode_MINERAL_OTHER, "PackagingMaterialTypeCode-MINERAL_OTHER",
    /// `Mineral Talc`: 
    PackagingMaterialTypeCode_MINERAL_TALC, "PackagingMaterialTypeCode-MINERAL_TALC",
    /// `Natural Rubber`: 
    PackagingMaterialTypeCode_NATURAL_RUBBER, "PackagingMaterialTypeCode-NATURAL_RUBBER",
    /// `Other`: 
    PackagingMaterialTypeCode_OTHER, "PackagingMaterialTypeCode-OTHER",
    /// `Paper Corrugated`: 
    PackagingMaterialTypeCode_PAPER_CORRUGATED, "PackagingMaterialTypeCode-PAPER_CORRUGATED",
    /// `Paper Molded Pulp`: 
    PackagingMaterialTypeCode_PAPER_MOLDED_PULP, "PackagingMaterialTypeCode-PAPER_MOLDED_PULP",
    /// `Paper Other`: 
    PackagingMaterialTypeCode_PAPER_OTHER, "PackagingMaterialTypeCode-PAPER_OTHER",
    /// `Paper`: 
    PackagingMaterialTypeCode_PAPER_PAPER, "PackagingMaterialTypeCode-PAPER_PAPER",
    /// `Paper Paperboard`: 
    PackagingMaterialTypeCode_PAPER_PAPERBOARD, "PackagingMaterialTypeCode-PAPER_PAPERBOARD",
    /// `Paper Rayon`: 
    PackagingMaterialTypeCode_PAPER_RAYON, "PackagingMaterialTypeCode-PAPER_RAYON",
    /// `Plastic Bioplastic`: 
    PackagingMaterialTypeCode_PLASTIC_BIOPLASTIC, "PackagingMaterialTypeCode-PLASTIC_BIOPLASTIC",
    /// `Plastic Other`: 
    PackagingMaterialTypeCode_PLASTIC_OTHER, "PackagingMaterialTypeCode-PLASTIC_OTHER",
    /// `Plastic Thermoplastics`: 
    PackagingMaterialTypeCode_PLASTIC_THERMOPLASTICS, "PackagingMaterialTypeCode-PLASTIC_THERMOPLASTICS",
    /// `Polymer Cellulose Acetate`: 
    PackagingMaterialTypeCode_POLYMER_CELLULOSE_ACETATE, "PackagingMaterialTypeCode-POLYMER_CELLULOSE_ACETATE",
    /// `Polymer Epoxy`: 
    PackagingMaterialTypeCode_POLYMER_EPOXY, "PackagingMaterialTypeCode-POLYMER_EPOXY",
    /// `Polymer Eva`: 
    PackagingMaterialTypeCode_POLYMER_EVA, "PackagingMaterialTypeCode-POLYMER_EVA",
    /// `Polymer EVOH`: 
    PackagingMaterialTypeCode_POLYMER_EVOH, "PackagingMaterialTypeCode-POLYMER_EVOH",
    /// `Polymer HDPE`: 
    PackagingMaterialTypeCode_POLYMER_HDPE, "PackagingMaterialTypeCode-POLYMER_HDPE",
    /// `Polymer LDPE`: 
    PackagingMaterialTypeCode_POLYMER_LDPE, "PackagingMaterialTypeCode-POLYMER_LDPE",
    /// `Polymer LLDPE`: 
    PackagingMaterialTypeCode_POLYMER_LLDPE, "PackagingMaterialTypeCode-POLYMER_LLDPE",
    /// `Polymer MDPE`: 
    PackagingMaterialTypeCode_POLYMER_MDPE, "PackagingMaterialTypeCode-POLYMER_MDPE",
    /// `Polymer Nylon`: 
    PackagingMaterialTypeCode_POLYMER_NYLON, "PackagingMaterialTypeCode-POLYMER_NYLON",
    /// `Polymer Other`: 
    PackagingMaterialTypeCode_POLYMER_OTHER, "PackagingMaterialTypeCode-POLYMER_OTHER",
    /// `Polymer PAN`: 
    PackagingMaterialTypeCode_POLYMER_PAN, "PackagingMaterialTypeCode-POLYMER_PAN",
    /// `Polymer PC`: 
    PackagingMaterialTypeCode_POLYMER_PC, "PackagingMaterialTypeCode-POLYMER_PC",
    /// `Polymer PCL`: 
    PackagingMaterialTypeCode_POLYMER_PCL, "PackagingMaterialTypeCode-POLYMER_PCL",
    /// `Polymer PE`: 
    PackagingMaterialTypeCode_POLYMER_PE, "PackagingMaterialTypeCode-POLYMER_PE",
    /// `Polymer PEN`: 
    PackagingMaterialTypeCode_POLYMER_PEN, "PackagingMaterialTypeCode-POLYMER_PEN",
    /// `Polymer PET`: 
    PackagingMaterialTypeCode_POLYMER_PET, "PackagingMaterialTypeCode-POLYMER_PET",
    /// `Polymer PHA`: 
    PackagingMaterialTypeCode_POLYMER_PHA, "PackagingMaterialTypeCode-POLYMER_PHA",
    /// `Polymer PLA`: 
    PackagingMaterialTypeCode_POLYMER_PLA, "PackagingMaterialTypeCode-POLYMER_PLA",
    /// `Polymer PP`: 
    PackagingMaterialTypeCode_POLYMER_PP, "PackagingMaterialTypeCode-POLYMER_PP",
    /// `Polymer PS`: 
    PackagingMaterialTypeCode_POLYMER_PS, "PackagingMaterialTypeCode-POLYMER_PS",
    /// `Polymer PU`: 
    PackagingMaterialTypeCode_POLYMER_PU, "PackagingMaterialTypeCode-POLYMER_PU",
    /// `Polymer PVA`: 
    PackagingMaterialTypeCode_POLYMER_PVA, "PackagingMaterialTypeCode-POLYMER_PVA",
    /// `Polymer PVC`: 
    PackagingMaterialTypeCode_POLYMER_PVC, "PackagingMaterialTypeCode-POLYMER_PVC",
    /// `Polymer PVDC`: 
    PackagingMaterialTypeCode_POLYMER_PVDC, "PackagingMaterialTypeCode-POLYMER_PVDC",
    /// `Polymer TPS`: 
    PackagingMaterialTypeCode_POLYMER_TPS, "PackagingMaterialTypeCode-POLYMER_TPS",
    /// `Packaging Recycling Process Type Code`: 
    PackagingRecyclingProcessTypeCode, "PackagingRecyclingProcessTypeCode",
    /// `Compostable`: Packaging that can biodegrade generating a relatively homogeneous and stable humus-like substance.
    PackagingRecyclingProcessTypeCode_COMPOSTABLE, "PackagingRecyclingProcessTypeCode-COMPOSTABLE",
    /// `Energy Recoverable`: Packaging which allows for a net calorific gain in energy recovery operations.
    PackagingRecyclingProcessTypeCode_ENERGY_RECOVERABLE, "PackagingRecyclingProcessTypeCode-ENERGY_RECOVERABLE",
    /// `Recyclable`: Packaging material and format which can be diverted from the waste stream through available processes and programmes and can be collected, processed and returned to use in the form of raw materials or products.
    PackagingRecyclingProcessTypeCode_RECYCLABLE, "PackagingRecyclingProcessTypeCode-RECYCLABLE",
    /// `Reusable`: Packaging that has been conceived and designed to accomplished within its life cycle a certain number of trips, rotations or uses for the same purpose for which it was conceived.
    PackagingRecyclingProcessTypeCode_REUSABLE, "PackagingRecyclingProcessTypeCode-REUSABLE",
    /// `Packaging Recycling Scheme Code`: 
    PackagingRecyclingSchemeCode, "PackagingRecyclingSchemeCode",
    /// `Alko Inc`: Alko inc. is an independent, entirely State-owned company. Alko is administered and supervised by the Ministry of Social Affairs and Health. They have own recycling system for alcohol products bottles called Alko. This is a recycling system used in Finland
    PackagingRecyclingSchemeCode_ALKO, "PackagingRecyclingSchemeCode-ALKO",
    /// `A Pullo`: PALPA stands for Suomen Palautuspakkaus Oy. PALPA administers the recycling of beverage containers and promotes recycling in Finland. A-pullo is one of the recycling systems. PALPA is the administrator. This is a recycling system used in Finland.
    PackagingRecyclingSchemeCode_A_PULLO, "PackagingRecyclingSchemeCode-A_PULLO",
    /// `EKO Pullo`: PALPA Standas for Suomen Palautuspakkaus Oy. PALPA administers the recycling of beverage containers and promotes recycling in Finland. EKO-pullo is one of the recycling systems PALPA is administer. This is a recycling system used in Finland.
    PackagingRecyclingSchemeCode_EKO_PULLO, "PackagingRecyclingSchemeCode-EKO_PULLO",
    /// `PALPA`: PALPA stands for Suomen Palautuspakkaus Oy. PALPA administers the recycling of beverage containers and promotes recycling in Finland. PALPA is on of the recycling systems PALPA is administer. This is a recycling system used in Finland.
    PackagingRecyclingSchemeCode_PALPA, "PackagingRecyclingSchemeCode-PALPA",
    /// `Packaging Shape Code`: 
    PackagingShapeCode, "PackagingShapeCode",
    /// `Bar`: A relatively long, evenly shaped piece of some solid substance
    PackagingShapeCode_BAR, "PackagingShapeCode-BAR",
    /// `Coil`: A spiral structure made by winding a material into a series of loops. A coil may or may not have a spindle around which the loops are formed.
    PackagingShapeCode_COIL, "PackagingShapeCode-COIL",
    /// `Cone`: A cone is a three-dimensional geometric shape that tapers smoothly from a flat, round base to a point.
    PackagingShapeCode_CONE, "PackagingShapeCode-CONE",
    /// `Cylindrical`: A long shape that has a circular base and an equally-sized circular top.
    PackagingShapeCode_CYLINDRICAL, "PackagingShapeCode-CYLINDRICAL",
    /// `Polygon`: A plane figure that is bounded by a closed path or circuit composed of a finite sequence of equally-sized straight line segments. A polygon may have a varying number of segments or faces resulting in different configurations, for example a 5-faced polygon: pentagon, 6-faced: hexagon, 8-faced: octagon, 12-faced: dodecahedron, etc.
    PackagingShapeCode_POLYGON, "PackagingShapeCode-POLYGON",
    /// `Rectangular`: A closed planar quadrilateral with four right angles.
    PackagingShapeCode_RECTANGULAR, "PackagingShapeCode-RECTANGULAR",
    /// `Spherical`: A perfectly round geometrical object in three-dimensional space, such as the shape of a round ball. Like a circle in two dimensions, a perfect sphere is completely symmetrical around its centre, with all points on the surface lying the same distance from the centre point.
    PackagingShapeCode_SPHERICAL, "PackagingShapeCode-SPHERICAL",
    /// `Tablet`: The result of different materials being compressed into a solid block usually of small dimensions.
    PackagingShapeCode_TABLET, "PackagingShapeCode-TABLET",
    /// `Unspecified`: Shape is not currently specified in the list. To be used as a temporary means until a specific missing value is added to the list.
    PackagingShapeCode_UNSPECIFIED, "PackagingShapeCode-UNSPECIFIED",
    /// `Payment Method Code`: A code indicating an accepted method of payment
    PaymentMethod, "PaymentMethod",
    /// `Bankers Draft`: Issue of a banker's draft in payment of the funds.
    PaymentMethod_BANKERS_DRAFT, "PaymentMethod-BANKERS_DRAFT",
    /// `Bank Cheque`: Payment by a pre-printed form, which has been completed by a financial institution, on which instructions are given to an account holder (a bank or building society) to pay a stated sum to a named recipient.
    PaymentMethod_BANK_CHEQUE, "PaymentMethod-BANK_CHEQUE",
    /// `Bank Giro`: The payment was originally made by bankgiro.
    PaymentMethod_BANK_GIRO, "PaymentMethod-BANK_GIRO",
    /// `Book Entry Credit`: House Credit.
    PaymentMethod_BOOKENTRY_CREDIT, "PaymentMethod-BOOKENTRY_CREDIT",
    /// `Book Entry Debit`: House Debit.
    PaymentMethod_BOOKENTRY_DEBIT, "PaymentMethod-BOOKENTRY_DEBIT",
    /// `BOP`: 
    PaymentMethod_BOP, "PaymentMethod-BOP",
    /// `Cash`: Payment by currency (including bills and coins) in circulation, including checking account deposits.
    PaymentMethod_CASH, "PaymentMethod-CASH",
    /// `Certified Cheque`: Payment by a pre-printed form stamped with the paying bank's certification on which instructions are given to an account holder (a bank or building society) to pay a stated sum to a named recipient .
    PaymentMethod_CERTIFIED_CHEQUE, "PaymentMethod-CERTIFIED_CHEQUE",
    /// `Cheque`: Payment by a pre-printed form on which instructions are given to an account holder (a bank or building society) to pay a stated sum to a named recipient.
    PaymentMethod_CHEQUE, "PaymentMethod-CHEQUE",
    /// `Credit Card`: Payment by means of a card issued by a bank or other financial institution.
    PaymentMethod_CREDIT_CARD, "PaymentMethod-CREDIT_CARD",
    /// `American Express Credit Card`: Payment by American Express credit card
    PaymentMethod_CREDIT_CARD_AMEX, "PaymentMethod-CREDIT_CARD_AMEX",
    /// `Diners Club Credit Card`: Payment by Diners Club credit card
    PaymentMethod_CREDIT_CARD_DINERS_CLUB, "PaymentMethod-CREDIT_CARD_DINERS_CLUB",
    /// `Discover Credit Card`: Payment by Discover credit card
    PaymentMethod_CREDIT_CARD_DISCOVER, "PaymentMethod-CREDIT_CARD_DISCOVER",
    /// `Mastercard Credit Card`: Payment by Mastercard credit card
    PaymentMethod_CREDIT_CARD_MASTERCARD, "PaymentMethod-CREDIT_CARD_MASTERCARD",
    /// `Visa Credit Card`: Payment by Visa credit card
    PaymentMethod_CREDIT_CARD_VISA, "PaymentMethod-CREDIT_CARD_VISA",
    /// `Debit Card`: The amount is to be, or has been, directly debited to the customer's bank account through a bank card.
    PaymentMethod_DEBIT_CARD, "PaymentMethod-DEBIT_CARD",
    /// `Maestro Debit Card`: Payment by Maestro debit card
    PaymentMethod_DEBIT_CARD_MAESTRO, "PaymentMethod-DEBIT_CARD_MAESTRO",
    /// `Mastercard Debit Card`: Payment by Mastercard debit card
    PaymentMethod_DEBIT_CARD_MASTERCARD, "PaymentMethod-DEBIT_CARD_MASTERCARD",
    /// `Visa Debit Card`: Payment by Visa debit card
    PaymentMethod_DEBIT_CARD_VISA, "PaymentMethod-DEBIT_CARD_VISA",
    /// `Visa Electron Debit Card`: Payment by Visa Electron debit card
    PaymentMethod_DEBIT_CARD_VISA_ELECTRON, "PaymentMethod-DEBIT_CARD_VISA_ELECTRON",
    /// `Electronic Credit ACH`: A credit transaction made through the automated clearing house system
    PaymentMethod_ELECTRONIC_CREDIT_ACH, "PaymentMethod-ELECTRONIC_CREDIT_ACH",
    /// `Electronic Debit ACH`: A debit transaction made through the automated clearing house system.
    PaymentMethod_ELECTRONIC_DEBIT_ACH, "PaymentMethod-ELECTRONIC_DEBIT_ACH",
    /// `Fedwire Non-repetitive`: Fedwire is a real time gross settlement funds transfer system operated by the Federal Reserve Banks that enables financial institutions to electronically transfer funds between its participants.
    PaymentMethod_FED_WIRE_NON_REPETITIVE, "PaymentMethod-FED_WIRE_NON_REPETITIVE",
    /// `Fedwire Repetitive`: Repetitive Fedwire is a real time gross settlement funds transfer system operated by the Federal Reserve Banks that enables financial institutions to electronically transfer funds between its participants. Repetitive wire transfers are sent by the same party to the same recipient through the same financial institution with the same wiring instructions
    PaymentMethod_FED_WIRE_REPETITIVE, "PaymentMethod-FED_WIRE_REPETITIVE",
    /// `International Wire`: Payment by international wire transfer
    PaymentMethod_INTERNATIONAL_WIRE, "PaymentMethod-INTERNATIONAL_WIRE",
    /// `Letter of Credit`: The financial operation is a letter of credit.
    PaymentMethod_LETTER_OF_CREDIT, "PaymentMethod-LETTER_OF_CREDIT",
    /// `Online Payment`: Payment by online payment mechanisms
    PaymentMethod_ONLINE_PAYMENT, "PaymentMethod-ONLINE_PAYMENT",
    /// `Apple Pay`: Online payment via Apple Pay
    PaymentMethod_ONLINE_PAYMENT_APPLE_PAY, "PaymentMethod-ONLINE_PAYMENT_APPLE_PAY",
    /// `Google Wallet`: Online payment via Google Wallet
    PaymentMethod_ONLINE_PAYMENT_GOOGLE_WALLET, "PaymentMethod-ONLINE_PAYMENT_GOOGLE_WALLET",
    /// `PayPal`: Online payment via PayPal
    PaymentMethod_ONLINE_PAYMENT_PAYPAL, "PaymentMethod-ONLINE_PAYMENT_PAYPAL",
    /// `Postgiro`: The financial operation has been done by postgiro.
    PaymentMethod_POSTGIRO, "PaymentMethod-POSTGIRO",
    /// `Wire Transfer Credit`: Payment by wire transfer credit
    PaymentMethod_WIRE_TRANSFER_CREDIT, "PaymentMethod-WIRE_TRANSFER_CREDIT",
    /// `Wire Transfer Debit`: Payment by wire transfer debit
    PaymentMethod_WIRE_TRANSFER_DEBIT, "PaymentMethod-WIRE_TRANSFER_DEBIT",
    /// `Place`: Entities that have a somewhat fixed, physical location.
    Place, "Place",
    /// `Address`: The location at which a particular organization or person may be found or reached.
    PostalAddress, "PostalAddress",
    /// `Preparation Type Code`: A code indicating a method of preparation of a food or beverage product
    PreparationTypeCode, "PreparationTypeCode",
    /// `As Drained`: The state of the product after it has been separated from any liquid within the package. For example, a can of apricots in syrup would have a different nutritional composition if the apricots are consumed with the syrup rather than if the syrup is drained before consuming the apricots (because of the high sugar and energy content of the syrup).
    PreparationTypeCode_AS_DRAINED, "PreparationTypeCode-AS_DRAINED",
    /// `Bake`: Cooking food in an oven by dry heat applied evenly throughout the oven
    PreparationTypeCode_BAKE, "PreparationTypeCode-BAKE",
    /// `Barbecue`: Method of cooking meat with the heat and hot gasses of a fire
    PreparationTypeCode_BARBECUE, "PreparationTypeCode-BARBECUE",
    /// `Blanch`: Food preparation wherein the food substance is rapidly plunged into boiling water and then removed after a brief, timed interval and then plunged into iced water or placed under cold running water
    PreparationTypeCode_BLANCH, "PreparationTypeCode-BLANCH",
    /// `Blind Bake`: Baking a pie crust or other pastry without the filling
    PreparationTypeCode_BLIND_BAKE, "PreparationTypeCode-BLIND_BAKE",
    /// `Boil`: Cooking food in boiling water, or other water-based liquid such as stock or milk
    PreparationTypeCode_BOIL, "PreparationTypeCode-BOIL",
    /// `Braise`: Cooking with moist heat, typically in a covered pot with a small amount of liquid
    PreparationTypeCode_BRAISE, "PreparationTypeCode-BRAISE",
    /// `Broil`: Cooking food with high heat with the heat applied directly to the food, most commonly from above. Heat transfer to the food is primarily via radiant heat
    PreparationTypeCode_BROIL, "PreparationTypeCode-BROIL",
    /// `Deep Fry`: Cooking method whereby food is submerged in hot oil or fat.
    PreparationTypeCode_DEEP_FRY, "PreparationTypeCode-DEEP_FRY",
    /// `Double Steam`: Cooking technique to prepare delicate food such as bird nests, shark fins etc. The food is covered with water and put in a covered ceramic jar
    PreparationTypeCode_DOUBLE_STEAM, "PreparationTypeCode-DOUBLE_STEAM",
    /// `Freeze`: Convert the product from room temperature to a frozen state.Simple
    PreparationTypeCode_FREEZE, "PreparationTypeCode-FREEZE",
    /// `Fry`: Cooking of food in fat.
    PreparationTypeCode_FRY, "PreparationTypeCode-FRY",
    /// `Griddle Fry`: Form of cooking where the food is fried with its own fat.
    PreparationTypeCode_GRIDDLE_FRY, "PreparationTypeCode-GRIDDLE_FRY",
    /// `Grill`: Form of cooking that involves direct heat. The definition varies widely by region and culture
    PreparationTypeCode_GRILL, "PreparationTypeCode-GRILL",
    /// `Heat and Serve`: Prepare the item by simply heating or warming to a desired temperature or visual state prior to serving
    PreparationTypeCode_HEAT_AND_SERVE, "PreparationTypeCode-HEAT_AND_SERVE",
    /// `Microwave`: Cooking food by employing microwave radiation
    PreparationTypeCode_MICROWAVE, "PreparationTypeCode-MICROWAVE",
    /// `Pan Fry`: Form of frying characterised by the use of less cooking oil than deep frying
    PreparationTypeCode_PAN_FRY, "PreparationTypeCode-PAN_FRY",
    /// `Poach`: Cooking food by gently simmering food in liquid, generally water, stock or wine
    PreparationTypeCode_POACH, "PreparationTypeCode-POACH",
    /// `Prepared`: The state of the product after preparation (e.g. after adding milk or water).
    PreparationTypeCode_PREPARED, "PreparationTypeCode-PREPARED",
    /// `Pressure Cook`: Method of cooking in a sealed vessel that does not permit air or liquids to escape below a preset pressure
    PreparationTypeCode_PRESSURE_COOK, "PreparationTypeCode-PRESSURE_COOK",
    /// `Pressure Fry`: Meat and cooking oil are brought to high temperatures while pressure is held high enough that the water within is prevented from boiling off
    PreparationTypeCode_PRESSURE_FRY, "PreparationTypeCode-PRESSURE_FRY",
    /// `Ready To Drink`: No Preparation. The product is ready for use after being taken out of the packaging (if packaging exists) without the need of any further action prior to consumption or use
    PreparationTypeCode_READY_TO_DRINK, "PreparationTypeCode-READY_TO_DRINK",
    /// `Ready To Eat`: Besides unpacking no additional preparation required.
    PreparationTypeCode_READY_TO_EAT, "PreparationTypeCode-READY_TO_EAT",
    /// `Reconstitute`: Restore a dry or concentrated food to its original strength or consistency by adding water.
    PreparationTypeCode_RECONSTITUTE, "PreparationTypeCode-RECONSTITUTE",
    /// `Refrigerate`: Convert the product from room temperature to a chilled state.
    PreparationTypeCode_REFRIGERATE, "PreparationTypeCode-REFRIGERATE",
    /// `Roast.`: Cooking method that uses dry heat, whether an open flame, oven, or other heat source.
    PreparationTypeCode_ROAST, "PreparationTypeCode-ROAST",
    /// `Rotisserie`: Style of roasting where meat is skewered on a spit and revolves over a flame
    PreparationTypeCode_ROTISSERIE, "PreparationTypeCode-ROTISSERIE",
    /// `Saute`: Cooking food using a small amount of fat in a shallow pan over relatively high heat
    PreparationTypeCode_SAUTE, "PreparationTypeCode-SAUTE",
    /// `Sear`: Technique used in grilling, roasting, braising, sauteing, etc. That cooks the surface of the food (usually meat, poultry or fish) at high temperature so that a caramelised crust forms
    PreparationTypeCode_SEAR, "PreparationTypeCode-SEAR",
    /// `Simmer`: Cook food by heating it in water kept just below the boiling point (same as coddling)
    PreparationTypeCode_SIMMER, "PreparationTypeCode-SIMMER",
    /// `Smoke`: Process of curing, cooking, or seasoning food by exposing it for long periods of time to the smoke from a wood fire
    PreparationTypeCode_SMOKE, "PreparationTypeCode-SMOKE",
    /// `Steam`: Cooking by first boiling the water so it will evaporate into steam, then the steam will carry heat to the food, thus achieving heating the food
    PreparationTypeCode_STEAM, "PreparationTypeCode-STEAM",
    /// `Stew`: Preparing meat cut into smaller pieces or cubes by simmering it in liquid, usually together with vegetables
    PreparationTypeCode_STEW, "PreparationTypeCode-STEW",
    /// `Stir Fry`: Chinese cooking technique used because of its fast cooking speed
    PreparationTypeCode_STIR_FRY, "PreparationTypeCode-STIR_FRY",
    /// `Thaw`: Convert the product from a frozen state to a chilled or room temperature state.
    PreparationTypeCode_THAW, "PreparationTypeCode-THAW",
    /// `Unprepared`: The initial state of the product.
    PreparationTypeCode_UNPREPARED, "PreparationTypeCode-UNPREPARED",
    /// `Unknown`: Unknown, not applicable
    PreparationTypeCode_UNSPECIFIED, "PreparationTypeCode-UNSPECIFIED",
    /// `Preservation Technique Code`: 
    PreservationTechniqueCode, "PreservationTechniqueCode",
    /// `Acidification`: Dropping pH of food
    PreservationTechniqueCode_ACIDIFICATION, "PreservationTechniqueCode-ACIDIFICATION",
    /// `Alcohol Curing`: Treatment of food by adding alcohol in order to preserve the product
    PreservationTechniqueCode_ALCOHOL_CURING, "PreservationTechniqueCode-ALCOHOL_CURING",
    /// `Attested Milk`: Raw Milk (without heat treatment)
    PreservationTechniqueCode_ATTESTED_MILK, "PreservationTechniqueCode-ATTESTED_MILK",
    /// `Cooking`: Cooking
    PreservationTechniqueCode_BOILING, "PreservationTechniqueCode-BOILING",
    /// `Brining`: Water saturating or strongly impregnating with salt
    PreservationTechniqueCode_BRINING, "PreservationTechniqueCode-BRINING",
    /// `Canning`: Preserved in a sealed airtight container, usually made of tin-coated iron
    PreservationTechniqueCode_CANNING, "PreservationTechniqueCode-CANNING",
    /// `Cold Smoke Curing`: To smoke the food at between 70 degrees to 90 degrees F.
    PreservationTechniqueCode_COLD_SMOKE_CURING, "PreservationTechniqueCode-COLD_SMOKE_CURING",
    /// `Conserve`: Keep from harm or damage
    PreservationTechniqueCode_CONSERVE, "PreservationTechniqueCode-CONSERVE",
    /// `Dehydration`: To remove water from food
    PreservationTechniqueCode_DEHYDRATION, "PreservationTechniqueCode-DEHYDRATION",
    /// `Drying`: Making with moisture having evaporated, drained away
    PreservationTechniqueCode_DRYING, "PreservationTechniqueCode-DRYING",
    /// `Fermentation`: Any of a group of chemical reactions induced by living or nonliving ferments that split complex organic compounds into relatively simple substance
    PreservationTechniqueCode_FERMENTATION, "PreservationTechniqueCode-FERMENTATION",
    /// `Freeze Drying`: Preserving food by freezing and then drying in a vacuum
    PreservationTechniqueCode_FREEZE_DRYING, "PreservationTechniqueCode-FREEZE_DRYING",
    /// `Freezing`: Turning into ice or another solid by cold
    PreservationTechniqueCode_FREEZING, "PreservationTechniqueCode-FREEZING",
    /// `High Temperature Treated Milk`: Legally also pasteurisation, MHD for longer (about 2 to 3 weeks), ESL-milk
    PreservationTechniqueCode_HIGH_TEMPERATURE_TREATED_MILK, "PreservationTechniqueCode-HIGH_TEMPERATURE_TREATED_MILK",
    /// `Hot Smoke Curing`: Hot-smoking partially or totally cooks the food by treating it at temperatures ranging from 100 degrees to 190 degrees F.
    PreservationTechniqueCode_HOT_SMOKE_CURING, "PreservationTechniqueCode-HOT_SMOKE_CURING",
    /// `Ionisation`: To convert into an ion or ions
    PreservationTechniqueCode_IONISATION, "PreservationTechniqueCode-IONISATION",
    /// `Irradiation`: Food irradiation is the process of exposing food to ionising radiation in order to disinfest, sterilise, or preserve food.
    PreservationTechniqueCode_IRRADIATION, "PreservationTechniqueCode-IRRADIATION",
    /// `Pasteurisation`: Partially sterilisation by heating
    PreservationTechniqueCode_PASTEURISATION, "PreservationTechniqueCode-PASTEURISATION",
    /// `Quick Freezing`: Freezing (food) rapidly so as to preserve its qualities
    PreservationTechniqueCode_QUICK_FREEZING, "PreservationTechniqueCode-QUICK_FREEZING",
    /// `Salt Curing`: Preserving by using a salt brine
    PreservationTechniqueCode_SALT_CURING, "PreservationTechniqueCode-SALT_CURING",
    /// `Sous Vide`: Low temperature long time cooking under vacuum
    PreservationTechniqueCode_SOUS_VIDE, "PreservationTechniqueCode-SOUS_VIDE",
    /// `Sterilisation`: A process that effectively kills or eliminates transmissibleagents (such as fungi, bacteria, viruses, spore forms, etc.).
    PreservationTechniqueCode_STERILISATION, "PreservationTechniqueCode-STERILISATION",
    /// `Sugar Curing`: Treatment of food by adding sugar in order to preserve the product
    PreservationTechniqueCode_SUGAR_CURING, "PreservationTechniqueCode-SUGAR_CURING",
    /// `Ultra High Temperature`: Ultra heat treated (especially for milk)
    PreservationTechniqueCode_ULTRA_HIGH_TEMPERATURE, "PreservationTechniqueCode-ULTRA_HIGH_TEMPERATURE",
    /// `Under Modified Atmosphere`: Packed with a gas with protective proprieties
    PreservationTechniqueCode_UNDER_MODIFIED_ATMOSPHERE, "PreservationTechniqueCode-UNDER_MODIFIED_ATMOSPHERE",
    /// `Vacuum Packed`: Sealed after the partial removal of air
    PreservationTechniqueCode_VACUUM_PACKED, "PreservationTechniqueCode-VACUUM_PACKED",
    /// `PreservationTechniqueTypeCode`: 
    PreservationTechniqueTypeCode, "PreservationTechniqueTypeCode",
    /// `Price Specification`: A structured value representing a monetary amount, consisting of a value and currency code.
    PriceSpecification, "PriceSpecification",
    /// `Product`: Any item (product or service) upon which there is a need to retrieve pre-defined information and that may be priced, or ordered, or invoiced at any point in any supply chain.
    Product, "Product",
    /// `Product Yield Details`: A grouping of properties related to the yield of a food or beverage product according to a specified type of preparation.
    ProductYieldDetails, "ProductYieldDetails",
    /// `Product Yield Type Code`: 
    ProductYieldTypeCode, "ProductYieldTypeCode",
    /// `After Cooking`: Weight or volume of food product after it has been prepared.
    ProductYieldTypeCode_AFTER_COOKING, "ProductYieldTypeCode-AFTER_COOKING",
    /// `After Dilution`: Volume of food product after a fluid has been added.
    ProductYieldTypeCode_AFTER_DILUTION, "ProductYieldTypeCode-AFTER_DILUTION",
    /// `Drained Weight`: Weight of food product after the fluid in which the food product was preserved has been removed.
    ProductYieldTypeCode_DRAINED_WEIGHT, "ProductYieldTypeCode-DRAINED_WEIGHT",
    /// `Unspecified`: Product yield type is unknown or irrelevant
    ProductYieldTypeCode_UNSPECIFIED, "ProductYieldTypeCode-UNSPECIFIED",
    /// `Measurement Type`: A point value or interval for product characteristics and other purposes. A unit of measurement is also specified.
    QuantitativeValue, "QuantitativeValue",
    /// `Referenced File`: Provides URL and other information on a referenced electronic file.
    ReferencedFileDetails, "ReferencedFileDetails",
    /// `Referenced File Type Code`: 
    ReferencedFileTypeCode, "ReferencedFileTypeCode",
    /// `Diet Certificate`: Link to a website or file containing a diet certificate granted to the product.
    ReferencedFileTypeCode_DIET_CERTIFICATE, "ReferencedFileTypeCode-DIET_CERTIFICATE",
    /// `Document`: Link to a document or text file containing product information. Examples of this type could be an instruction manual, assembly guide, or warranty document.
    ReferencedFileTypeCode_DOCUMENT, "ReferencedFileTypeCode-DOCUMENT",
    /// `Group Characteristics Sheet`: 
    ReferencedFileTypeCode_GROUP_CHARACTERISTIC_SHEET, "ReferencedFileTypeCode-GROUP_CHARACTERISTIC_SHEET",
    /// `Logo`: Link to a file containing the Manufacturer or Brand Logo(s) associated with the product.
    ReferencedFileTypeCode_LOGO, "ReferencedFileTypeCode-LOGO",
    /// `Marketing Information`: Link to a file with product information associated with selling a product or service.
    ReferencedFileTypeCode_MARKETING_INFORMATION, "ReferencedFileTypeCode-MARKETING_INFORMATION",
    /// `Out of Package Image`: Link to an image of an item out of its packaging and, if necessary, assembled ready for use by the end user. This type of file is subject the current version of the GDSN Product Image Specification Standard.
    ReferencedFileTypeCode_OUT_OF_PACKAGE_IMAGE, "ReferencedFileTypeCode-OUT_OF_PACKAGE_IMAGE",
    /// `Planogram`: Link to a file illustrating how and where retail products should be displayed.
    ReferencedFileTypeCode_PLANOGRAM, "ReferencedFileTypeCode-PLANOGRAM",
    /// `Product Label Image`: Link to a file containing a visual representation of the product label.
    ReferencedFileTypeCode_PRODUCT_LABEL_IMAGE, "ReferencedFileTypeCode-PRODUCT_LABEL_IMAGE",
    /// `Safety Data Sheet`: Link to a file containing the product's Safety Data Sheet (SDS). This file can be either an image or a document
    ReferencedFileTypeCode_SAFETY_DATA_SHEET, "ReferencedFileTypeCode-SAFETY_DATA_SHEET",
    /// `Safety Summary Sheet`: A link to a summary sheet document that is available to workers to understand how to deal with chemicals in an emergency situation.
    ReferencedFileTypeCode_SAFETY_SUMMARY_SHEET, "ReferencedFileTypeCode-SAFETY_SUMMARY_SHEET",
    /// `Trade Item Description`: Identifies the reference to an external description of a product. The link (e.g. URL) to the external description. will be in the appropriate attribute
    ReferencedFileTypeCode_TRADE_ITEM_DESCRIPTION, "ReferencedFileTypeCode-TRADE_ITEM_DESCRIPTION",
    /// `Video`: Link to a file containing a video clip which is relevant to the product. Examples are commercials, trailers, or instructional/ how to use video files.
    ReferencedFileTypeCode_VIDEO, "ReferencedFileTypeCode-VIDEO",
    /// `Warranty Information`: Link to a file with information associated with any guarantee given by a company stating that a product is reliable and free from known defects and that the seller will, without charge, repair or replace defective parts within a given time limit and under certain conditions.
    ReferencedFileTypeCode_WARRANTY_INFORMATION, "ReferencedFileTypeCode-WARRANTY_INFORMATION",
    /// `Website`: Link to a website containing product or manufacturer information.
    ReferencedFileTypeCode_WEBSITE, "ReferencedFileTypeCode-WEBSITE",
    /// `Returnable Package Deposit Details`: Details of the deposit for returnable packaging for a product.
    ReturnablePackageDepositDetails, "ReturnablePackageDepositDetails",
    /// `Seafood`: Seafood Products including fish and shellfish.
    Seafood, "Seafood",
    /// `Season Parameter Code`: 
    SeasonParameterCode, "SeasonParameterCode",
    /// `All Year`: All Year
    SeasonParameterCode_ALL_YEAR, "SeasonParameterCode-ALL_YEAR",
    /// `Autumn`: For products that are seasonal in nature and apply to the Autumn selling season only
    SeasonParameterCode_AUTUMN, "SeasonParameterCode-AUTUMN",
    /// `Autumn and Winter`: For products that are seasonal in nature and apply to both the Autumn and Winter selling seasons
    SeasonParameterCode_AUTUMN_WINTER, "SeasonParameterCode-AUTUMN_WINTER",
    /// `Spring`: For products that are seasonal in nature and apply to the Spring selling season only
    SeasonParameterCode_SPRING, "SeasonParameterCode-SPRING",
    /// `Spring and Summer`: For products that are seasonal in nature and apply to both the Spring and Summer selling seasons
    SeasonParameterCode_SPRING_SUMMER, "SeasonParameterCode-SPRING_SUMMER",
    /// `Summer`: For products that are seasonal in nature and apply to the Summer selling season only
    SeasonParameterCode_SUMMER, "SeasonParameterCode-SUMMER",
    /// `Winter`: For products that are seasonal in nature and apply to the Winter selling season only
    SeasonParameterCode_WINTER, "SeasonParameterCode-WINTER",
    /// `Sharpness of Cheese Code`: 
    SharpnessOfCheeseCode, "SharpnessOfCheeseCode",
    /// `Extra Extra Sharp`: 
    SharpnessOfCheeseCode_EXTRA_EXTRA_SHARP, "SharpnessOfCheeseCode-EXTRA_EXTRA_SHARP",
    /// `Extra Sharp`: 
    SharpnessOfCheeseCode_EXTRA_SHARP, "SharpnessOfCheeseCode-EXTRA_SHARP",
    /// `Mild`: 
    SharpnessOfCheeseCode_MILD, "SharpnessOfCheeseCode-MILD",
    /// `Regular`: 
    SharpnessOfCheeseCode_REGULAR, "SharpnessOfCheeseCode-REGULAR",
    /// `Sharp`: 
    SharpnessOfCheeseCode_SHARP, "SharpnessOfCheeseCode-SHARP",
    /// `Unclassified`: 
    SharpnessOfCheeseCode_UNCLASSIFIED, "SharpnessOfCheeseCode-UNCLASSIFIED",
    /// `Size Code Details`: A grouping of properties related to the representing the size of a product, by specifying a value from a specified code list.
    SizeCodeDetails, "SizeCodeDetails",
    /// `Size Details`: A grouping of properties related to the size of a wearable product
    SizeDetails, "SizeDetails",
    /// `Size Group Code`: 
    SizeGroupCode, "SizeGroupCode",
    /// `Boys`: 
    SizeGroupCode_BOYS, "SizeGroupCode-BOYS",
    /// `Girls`: 
    SizeGroupCode_GIRLS, "SizeGroupCode-GIRLS",
    /// `Infants`: 
    SizeGroupCode_INFANTS, "SizeGroupCode-INFANTS",
    /// `Juniors`: 
    SizeGroupCode_JUNIORS, "SizeGroupCode-JUNIORS",
    /// `Maternity`: 
    SizeGroupCode_MATERNITY, "SizeGroupCode-MATERNITY",
    /// `Mens`: 
    SizeGroupCode_MENS, "SizeGroupCode-MENS",
    /// `Mens Tall`: 
    SizeGroupCode_MENS_TALL, "SizeGroupCode-MENS_TALL",
    /// `Misses`: 
    SizeGroupCode_MISSES, "SizeGroupCode-MISSES",
    /// `Petite`: 
    SizeGroupCode_PETITE, "SizeGroupCode-PETITE",
    /// `Womens`: 
    SizeGroupCode_WOMENS, "SizeGroupCode-WOMENS",
    /// `Womens Tall`: 
    SizeGroupCode_WOMENS_TALL, "SizeGroupCode-WOMENS_TALL",
    /// `Size System Code`: 
    SizeSystemCode, "SizeSystemCode",
    /// `Australia`: 
    SizeSystemCode_AUSTRALIA, "SizeSystemCode-AUSTRALIA",
    /// `Continental`: 
    SizeSystemCode_CONTINENTAL, "SizeSystemCode-CONTINENTAL",
    /// `Europe`: 
    SizeSystemCode_EUROPE, "SizeSystemCode-EUROPE",
    /// `Japan`: 
    SizeSystemCode_JAPAN, "SizeSystemCode-JAPAN",
    /// `Mexico`: 
    SizeSystemCode_MEXICO, "SizeSystemCode-MEXICO",
    /// `UK`: 
    SizeSystemCode_UK, "SizeSystemCode-UK",
    /// `US`: 
    SizeSystemCode_US, "SizeSystemCode-US",
    /// `Size Type Code`: 
    SizeTypeCode, "SizeTypeCode",
    /// `Back`: 
    SizeTypeCode_BACK, "SizeTypeCode-BACK",
    /// `Chest or Bust`: The measurement around the widest part of the chest/bust.
    SizeTypeCode_CHEST_BUST, "SizeTypeCode-CHEST_BUST",
    /// `Collar`: 
    SizeTypeCode_COLLAR, "SizeTypeCode-COLLAR",
    /// `Cup`: 
    SizeTypeCode_CUP, "SizeTypeCode-CUP",
    /// `Hips`: The measurement around the fullest part of the hips.
    SizeTypeCode_HIPS, "SizeTypeCode-HIPS",
    /// `Inseam`: 
    SizeTypeCode_INSEAM, "SizeTypeCode-INSEAM",
    /// `Length`: 
    SizeTypeCode_LENGTH, "SizeTypeCode-LENGTH",
    /// `One Dimension`: 
    SizeTypeCode_ONE_DIMENSION, "SizeTypeCode-ONE_DIMENSION",
    /// `Outside Leg`: The measurement of the outside leg seam. This is the distance from the waist to the bottom of the trousers.
    SizeTypeCode_OUTSIDE_LEG, "SizeTypeCode-OUTSIDE_LEG",
    /// `Sleeve`: 
    SizeTypeCode_SLEEVE, "SizeTypeCode-SLEEVE",
    /// `Waist`: 
    SizeTypeCode_WAIST, "SizeTypeCode-WAIST",
    /// `Width`: 
    SizeTypeCode_WIDTH, "SizeTypeCode-WIDTH",
    /// `Source Animal Code`: 
    SourceAnimalCode, "SourceAnimalCode",
    /// `Alligator`: A crocodilian in the genus Alligator of the family Alligatoridae.
    SourceAnimalCode_ALLIGATOR, "SourceAnimalCode-ALLIGATOR",
    /// `Ass`: A domesticated member of the horse family.
    SourceAnimalCode_ASS, "SourceAnimalCode-ASS",
    /// `Bear`: Mammals of the family Ursidae.
    SourceAnimalCode_BEAR, "SourceAnimalCode-BEAR",
    /// `Beef Cow`: Cattle raised principally for meat production, other uses include leather and products used in shampoo and cosmetics.
    SourceAnimalCode_BEEF_COW, "SourceAnimalCode-BEEF_COW",
    /// `Boar`: A wild relative of the domestic pig.
    SourceAnimalCode_BOAR, "SourceAnimalCode-BOAR",
    /// `Buffalo`: A large bovine animal, frequently used as livestock.
    SourceAnimalCode_BUFFALO, "SourceAnimalCode-BUFFALO",
    /// `Calf`: A general term for a juvenile member of any species of domestic cattle which is intentionally raised to be processed at a young age.
    SourceAnimalCode_CALF, "SourceAnimalCode-CALF",
    /// `Camel`: Even-toed ungulates within the genus Camelus.
    SourceAnimalCode_CAMEL, "SourceAnimalCode-CAMEL",
    /// `Chicken`: A domesticated fowl.
    SourceAnimalCode_CHICKEN, "SourceAnimalCode-CHICKEN",
    /// `Cockerel`: A male chicken.
    SourceAnimalCode_COCKEREL, "SourceAnimalCode-COCKEREL",
    /// `Cow`: A domesticated member of the subfamily Bovinae.
    SourceAnimalCode_COW, "SourceAnimalCode-COW",
    /// `Crocodile`: Any species belonging to the family Crocodylidae.
    SourceAnimalCode_CROCODILE, "SourceAnimalCode-CROCODILE",
    /// `Deer`: Ruminant mammals forming the family Cervidae.
    SourceAnimalCode_DEER, "SourceAnimalCode-DEER",
    /// `Dog`: A domesticated form of the Wolf, a member of the Canidae family of the order Carnivora.
    SourceAnimalCode_DOG, "SourceAnimalCode-DOG",
    /// `Duck`: Aquatic birds, mostly smaller than the swans and geese, and may be found in both fresh water and sea water.
    SourceAnimalCode_DUCK, "SourceAnimalCode-DUCK",
    /// `Duckling`: A young duck.
    SourceAnimalCode_DUCKLING, "SourceAnimalCode-DUCKLING",
    /// `Fish`: Fresh or sea water fish.
    SourceAnimalCode_FISH, "SourceAnimalCode-FISH",
    /// `Fowl`: Non-domesticated birds in general but usually refers to birds belonging to one of two biological orders, namely the gamefowl or landfowl and the waterfowl.
    SourceAnimalCode_FOWL, "SourceAnimalCode-FOWL",
    /// `Frog`: Amphibians in the order Anura.
    SourceAnimalCode_FROG, "SourceAnimalCode-FROG",
    /// `Goat`: A member of the Bovidae family and is closely related to the sheep.
    SourceAnimalCode_GOAT, "SourceAnimalCode-GOAT",
    /// `Goose`: A bird belonging to the family Anatidae
    SourceAnimalCode_GOOSE, "SourceAnimalCode-GOOSE",
    /// `Grouse`: A group of birds from the order Galliformes.
    SourceAnimalCode_GROUSE, "SourceAnimalCode-GROUSE",
    /// `Guinea Fowl`: A family of birds in the Galliformes order
    SourceAnimalCode_GUINEAFOWL, "SourceAnimalCode-GUINEAFOWL",
    /// `Hare`: Leporidaes belonging to the genus Lepus.
    SourceAnimalCode_HARE, "SourceAnimalCode-HARE",
    /// `Horse`: a hoofed (ungulate) mammal, a subspecies of one of seven extant species of the family Equidae.
    SourceAnimalCode_HORSE, "SourceAnimalCode-HORSE",
    /// `Invertebrate`: Fresh or sea water invertebrate.
    SourceAnimalCode_INVERTEBRATE, "SourceAnimalCode-INVERTEBRATE",
    /// `Lamb`: A young domestic sheep.
    SourceAnimalCode_LAMB, "SourceAnimalCode-LAMB",
    /// `Land Snail`: A member of the molluscan class Gastropoda that have coiled shells in the adult stage and live on land.
    SourceAnimalCode_LAND_SNAIL, "SourceAnimalCode-LAND_SNAIL",
    /// `Milk Cow`: Also referred to Milk Cattle, this cow is bred to produce large quantities of Milk, from which dairy products are made.
    SourceAnimalCode_MILK_COW, "SourceAnimalCode-MILK_COW",
    /// `Moose`: The largest extant species in the deer family.
    SourceAnimalCode_MOOSE, "SourceAnimalCode-MOOSE",
    /// `Ostrich`: Large flightless bird native to Africa.
    SourceAnimalCode_OSTRICH, "SourceAnimalCode-OSTRICH",
    /// `Other`: Other animal not specified on this list.
    SourceAnimalCode_OTHER, "SourceAnimalCode-OTHER",
    /// `Partridge`: Medium-sized birds, intermediate between the larger pheasants and the smaller quails.
    SourceAnimalCode_PARTRIDGE, "SourceAnimalCode-PARTRIDGE",
    /// `Pheasant`: A bird in the subfamily of Phasianidae in the order Galliformes.
    SourceAnimalCode_PHEASANT, "SourceAnimalCode-PHEASANT",
    /// `Pigeon`: A bird in the family Columbidae.
    SourceAnimalCode_PIGEON, "SourceAnimalCode-PIGEON",
    /// `Pork`: Meat from the domestic pig
    SourceAnimalCode_PORK, "SourceAnimalCode-PORK",
    /// `Poussin`: A young chicken, less than 28 days old at slaughter
    SourceAnimalCode_POUSSIN, "SourceAnimalCode-POUSSIN",
    /// `Quail`: Several genus of mid-sized birds in the pheasant family.
    SourceAnimalCode_QUAIL, "SourceAnimalCode-QUAIL",
    /// `Rabbit`: Small mammals in the family Leporidae of the order Lagomorpha
    SourceAnimalCode_RABBIT, "SourceAnimalCode-RABBIT",
    /// `Rat`: Rats are various medium-sized, long-tailed rodents of the superfamily Muroidea.
    SourceAnimalCode_RAT, "SourceAnimalCode-RAT",
    /// `Reindeer`: An Arctic and Subarctic-dwelling deer, widespread and numerous across the Arctic and Subarctic.
    SourceAnimalCode_REINDEER, "SourceAnimalCode-REINDEER",
    /// `Roe Deer`: A deer species of Europe, Asia Minor, and Caspian coastal regions.
    SourceAnimalCode_ROE_DEER, "SourceAnimalCode-ROE_DEER",
    /// `Sheep`: Small ruminants, usually with a crimped hair called wool and often with horns forming a lateral spiral.
    SourceAnimalCode_SHEEP, "SourceAnimalCode-SHEEP",
    /// `Shellfish`: A fresh or sea water animal, such as a mollusk or crustacean, that has a shell or shell-like exoskeleton.
    SourceAnimalCode_SHELLFISH, "SourceAnimalCode-SHELLFISH",
    /// `Snake`: Elongate legless carnivorous reptiles of the suborder Serpentes.
    SourceAnimalCode_SNAKE, "SourceAnimalCode-SNAKE",
    /// `Snipe`: Any of nearly 20 wading bird species in three genera in the family Scolopacidae.
    SourceAnimalCode_SNIPE, "SourceAnimalCode-SNIPE",
    /// `Sparrow`: Small passerine birds in the family Passeridae.
    SourceAnimalCode_SPARROW, "SourceAnimalCode-SPARROW",
    /// `Thrush`: Plump, soft-plumaged, small to medium-sized passerine birds.
    SourceAnimalCode_THRUSH, "SourceAnimalCode-THRUSH",
    /// `Turkey`: A large bird in the genus Meleagris.
    SourceAnimalCode_TURKEY, "SourceAnimalCode-TURKEY",
    /// `Turtle`: Reptiles characterised by a special bony or cartilaginous shell developed from their ribs that acts as a shield.
    SourceAnimalCode_TURTLE, "SourceAnimalCode-TURTLE",
    /// `Woodcock`: The woodcocks are a group of seven or eight very similar living species of wading birds in the genus Scolopax.
    SourceAnimalCode_WOODCOCK, "SourceAnimalCode-WOODCOCK",
    /// `Yak`: A long-haired bovine found throughout the Himalayan region of south Central Asia, the Tibetan Plateau and as far north as Mongolia.
    SourceAnimalCode_YAK, "SourceAnimalCode-YAK",
    /// `Sporting Activity Type Code`: 
    SportingActivityTypeCode, "SportingActivityTypeCode",
    /// `American Football`: 
    SportingActivityTypeCode_AMERICAN_FOOTBALL, "SportingActivityTypeCode-AMERICAN_FOOTBALL",
    /// `Archery`: 
    SportingActivityTypeCode_ARCHERY, "SportingActivityTypeCode-ARCHERY",
    /// `Badminton`: 
    SportingActivityTypeCode_BADMINTON, "SportingActivityTypeCode-BADMINTON",
    /// `Baseball`: 
    SportingActivityTypeCode_BASEBALL, "SportingActivityTypeCode-BASEBALL",
    /// `Basketball`: 
    SportingActivityTypeCode_BASKETBALL, "SportingActivityTypeCode-BASKETBALL",
    /// `Boxing`: 
    SportingActivityTypeCode_BOXING, "SportingActivityTypeCode-BOXING",
    /// `Climbing`: 
    SportingActivityTypeCode_CLIMBING, "SportingActivityTypeCode-CLIMBING",
    /// `Cricket`: 
    SportingActivityTypeCode_CRICKET, "SportingActivityTypeCode-CRICKET",
    /// `Cycling`: 
    SportingActivityTypeCode_CYCLING, "SportingActivityTypeCode-CYCLING",
    /// `Diving`: 
    SportingActivityTypeCode_DIVING, "SportingActivityTypeCode-DIVING",
    /// `Equestrian`: 
    SportingActivityTypeCode_EQUESTRIAN, "SportingActivityTypeCode-EQUESTRIAN",
    /// `Fencing`: 
    SportingActivityTypeCode_FENCING, "SportingActivityTypeCode-FENCING",
    /// `Fishing`: 
    SportingActivityTypeCode_FISHING, "SportingActivityTypeCode-FISHING",
    /// `Football`: 
    SportingActivityTypeCode_FOOTBALL, "SportingActivityTypeCode-FOOTBALL",
    /// `Golf`: 
    SportingActivityTypeCode_GOLF, "SportingActivityTypeCode-GOLF",
    /// `Gymnastics`: 
    SportingActivityTypeCode_GYMNASTICS, "SportingActivityTypeCode-GYMNASTICS",
    /// `Hockey`: 
    SportingActivityTypeCode_HOCKEY, "SportingActivityTypeCode-HOCKEY",
    /// `Ice Hockey`: 
    SportingActivityTypeCode_ICE_HOCKEY, "SportingActivityTypeCode-ICE_HOCKEY",
    /// `Ice Skating`: 
    SportingActivityTypeCode_ICE_SKATING, "SportingActivityTypeCode-ICE_SKATING",
    /// `Motor Cycling`: 
    SportingActivityTypeCode_MOTOR_CYCLING, "SportingActivityTypeCode-MOTOR_CYCLING",
    /// `Rugby`: 
    SportingActivityTypeCode_RUGBY, "SportingActivityTypeCode-RUGBY",
    /// `Running`: 
    SportingActivityTypeCode_RUNNING, "SportingActivityTypeCode-RUNNING",
    /// `Skiing`: 
    SportingActivityTypeCode_SKIING, "SportingActivityTypeCode-SKIING",
    /// `Squash`: 
    SportingActivityTypeCode_SQUASH, "SportingActivityTypeCode-SQUASH",
    /// `Surfing`: 
    SportingActivityTypeCode_SURFING, "SportingActivityTypeCode-SURFING",
    /// `Swimming`: 
    SportingActivityTypeCode_SWIMMING, "SportingActivityTypeCode-SWIMMING",
    /// `Tennis`: 
    SportingActivityTypeCode_TENNIS, "SportingActivityTypeCode-TENNIS",
    /// `Unclassified`: 
    SportingActivityTypeCode_UNCLASSIFIED, "SportingActivityTypeCode-UNCLASSIFIED",
    /// `Unidentified`: 
    SportingActivityTypeCode_UNIDENTIFIED, "SportingActivityTypeCode-UNIDENTIFIED",
    /// `Target Consumer Gender Code`: 
    TargetConsumerGenderCode, "TargetConsumerGenderCode",
    /// `Female`: 
    TargetConsumerGenderCode_FEMALE, "TargetConsumerGenderCode-FEMALE",
    /// `Male`: 
    TargetConsumerGenderCode_MALE, "TargetConsumerGenderCode-MALE",
    /// `Unisex`: 
    TargetConsumerGenderCode_UNISEX, "TargetConsumerGenderCode-UNISEX",
    /// `Target Market Details`: A set of target market details (product release date and associated countries) for the product.
    TargetMarketDetails, "TargetMarketDetails",
    /// `Textile Material`: Details on the composition of any materials used to make a product using textiles.
    TextileMaterialDetails, "TextileMaterialDetails",
    /// `Trade Channel Code`: 
    TradeChannelCode, "TradeChannelCode",
    /// `Instore Only`: Offer avalilable only in stores.
    TradeChannelCode_INSTORE_ONLY, "TradeChannelCode-INSTORE_ONLY",
    /// `Omni-channel`: Offer avalilable both in stores and online.
    TradeChannelCode_OMNICHANNEL, "TradeChannelCode-OMNICHANNEL",
    /// `Online Only`: Offer avalilable online only.
    TradeChannelCode_ONLINE_ONLY, "TradeChannelCode-ONLINE_ONLY",
    /// `Type Code`: A code list.
    TypeCode, "TypeCode",
    /// `Upper Type Code`: 
    UpperTypeCode, "UpperTypeCode",
    /// `Closed Toe Closed Back Open Instep`: 
    UpperTypeCode_CLOSED_TOE_CLOSED_BACK_OPEN_INSTEP, "UpperTypeCode-CLOSED_TOE_CLOSED_BACK_OPEN_INSTEP",
    /// `Closed Toe Open Back`: 
    UpperTypeCode_CLOSED_TOE_OPEN_BACK, "UpperTypeCode-CLOSED_TOE_OPEN_BACK",
    /// `Closed Toe Strap Back`: 
    UpperTypeCode_CLOSED_TOE_STRAP_BACK, "UpperTypeCode-CLOSED_TOE_STRAP_BACK",
    /// `Fully Closed`: 
    UpperTypeCode_FULLY_CLOSED, "UpperTypeCode-FULLY_CLOSED",
    /// `Open Toe Fully Closed Back`: 
    UpperTypeCode_OPEN_TOE_FULLY_CLOSED_BACK, "UpperTypeCode-OPEN_TOE_FULLY_CLOSED_BACK",
    /// `Open Toe Open Back`: 
    UpperTypeCode_OPEN_TOE_OPEN_BACK, "UpperTypeCode-OPEN_TOE_OPEN_BACK",
    /// `Open Toe Strap Back`: 
    UpperTypeCode_OPEN_TOE_STRAP_BACK, "UpperTypeCode-OPEN_TOE_STRAP_BACK",
    /// `Unclassified`: 
    UpperTypeCode_UNCLASSIFIED, "UpperTypeCode-UNCLASSIFIED",
    /// `Warranty`: An assurance that the product is reliable and that repairs or replacement will be done free of charge within a given time limit and under certain conditions in the event of a defect.
    WarrantyPromise, "WarrantyPromise",
    /// `Wearable Product`: Products that are worn on the body.
    WearableProduct, "WearableProduct",
    /// `Accepted Payment Method`: Code indicating a means of payment, for example, BANK_CHEQUE, CASH, etc.
    acceptedPaymentMethod, "acceptedPaymentMethod",
    /// `Activity Ideas`: A link to ideas for using the product, particularly with children.
    activityIdeas, "activityIdeas",
    /// `Additional Organization Identification Type Value`: The value associated with the Additional Organization Identification Type Value.
    additionalOrganizationIdentificationTypeValue, "additionalOrganizationIdentificationTypeValue",
    /// `Has Additional Product Classification`: Relates to a set of additional product classification details
    additionalProductClassification, "additionalProductClassification",
    /// `Additional Product Classification Code`: Code specifying the applied additional product classification scheme.
    additionalProductClassificationCode, "additionalProductClassificationCode",
    /// `Additional Product Classification Code Description`: A description related to  the additional product classification code value.
    additionalProductClassificationCodeDescription, "additionalProductClassificationCodeDescription",
    /// `Additional Product Classification Value`: Code specifying an additional product classification other than the GS1 Global Product Classification. The applied classification scheme is specified as additional information together with the classification value.
    additionalProductClassificationValue, "additionalProductClassificationValue",
    /// `Additional Product Description`: Additional variants necessary to communicate to the industry to help define the product. Multiple variants can be established for each GTIN for e.g. Style, Colour, and Fragrance .
    additionalProductDescription, "additionalProductDescription",
    /// `Has Additive`: Relates to details about any additives that a product may contain.
    additive, "additive",
    /// `Additive Level Of Containment`: Code indicating the level of presence of the additive.
    additiveLevelOfContainment, "additiveLevelOfContainment",
    /// `Additive Name`: The name of any additive or genetic modification contained or not contained in the product .
    additiveName, "additiveName",
    /// `Has Postal Address`: The postal address for an organization or place.
    address, "address",
    /// `Address Country`: Code specifying the country (and country subdivision) for the address using ISO 3166-1.
    addressCountry, "addressCountry",
    /// `Address Locality`: Text specifying the name of the locality, for example a city.
    addressLocality, "addressLocality",
    /// `Province State Code`: Text specifying a province or state in abbreviated format for example NJ.
    addressRegion, "addressRegion",
    /// `Has After Hours Contact`: Links to afterhours contact information for an organization.
    afterHoursContact, "afterHoursContact",
    /// `Alcoholic Beverage Sub-region`: A legally defined geographical region where the grapes for a wine were grown also known as an appellation. It is recommended to populate this property with an ISO 3166-2 code to indicate country and subdivision.
    alcoholicBeverageSubregion, "alcoholicBeverageSubregion",
    /// `Allergen information`: A link to a description of the allergens in the product.
    allergenInfo, "allergenInfo",
    /// `Allergen Level Of Containment`: Code specifying the level of presence of the allergen.
    allergenLevelOfContainmentCode, "allergenLevelOfContainmentCode",
    /// `Allergen Specification Agency`: The agency or other organization that defines or manages the criteria for allergen containment.
    allergenSpecificationAgency, "allergenSpecificationAgency",
    /// `Allergen Specification Name`: Free text field containing the name and version of the regulation or standard that defines the criteria of allergen containment.
    allergenSpecificationName, "allergenSpecificationName",
    /// `Allergen Statement`: Textual description of the presence or absence of allergens as governed by local rules and regulations, specified as one string.
    allergenStatement, "allergenStatement",
    /// `Allergen Type Code`: Code specifying the type of allergen.
    allergenType, "allergenType",
    /// `Anatomical Form`: Describes the meat product in terms of whether it is the whole animal or part of the animal which has been cut such as the muscle, bone, organ, or fat.
    anatomicalForm, "anatomicalForm",
    /// `Applicable to`: A property linking a gs1:linkType to the primary GS1 key(s) for which it can be used. Similar to rdfs:Domain but the value space is a GS1 Application Identifier, not a class.
    applicableTo, "applicableTo",
    /// `Has Audio File`: Link to a file containing an audio clip which is relevant to the product. Examples are commercials, or instructional/ how to use audio files.
    audioFile, "audioFile",
    /// `Availability Ends`: The date from which the product is no longer available from the information provider, including seasonal or temporary product and services .
    availabilityEnds, "availabilityEnds",
    /// `Availability Starts`: The date from which the product is available from the information provider, including seasonal or temporary product and services.
    availabilityStarts, "availabilityStarts",
    /// `Available At/From`: The location the offered product or service is available from.
    availableAtOrFrom, "availableAtOrFrom",
    /// `Available Language`: ISO 639-1 code specifying the language of a specified contact point.
    availableLanguage, "availableLanguage",
    /// `Has Award Prize`: An award or prize given to the product.
    awardPrize, "awardPrize",
    /// `Award Prize Code`: Indicates the achievement of the product in relation to a prize or award, e.g. winner, runner-up, shortlisted.
    awardPrizeCode, "awardPrizeCode",
    /// `Award Prize Country Code`: An ISO standard code identifying the country in which a prize or award is given. It is recommended to populate this property with an ISO 3166-1 country code.
    awardPrizeCountryCode, "awardPrizeCountryCode",
    /// `Award Prize Description`: Text that describes the awards won.
    awardPrizeDescription, "awardPrizeDescription",
    /// `Award Prize Jury`: Free text listing members of the jury that awarded the prize.
    awardPrizeJury, "awardPrizeJury",
    /// `Award Prize Name`: The name of a prize or award which the product has received.
    awardPrizeName, "awardPrizeName",
    /// `Award Prize Year`: The year in which a prize or award was given.
    awardPrizeYear, "awardPrizeYear",
    /// `Best Before Date`: Best before date on the label or package signifies the end of the period under which the product will retain specific quality attributes or claims even though the product may continue to retain positive quality attributes after this date. Best before date is primarily used for consumer information and may be a regulatory requirement.
    bestBeforeDate, "bestBeforeDate",
    /// `Beverage Vintage`: The year in which the majority of ingredients are harvested and/or the alcoholic beverage is produced. Determination as to whether the vintage year is the harvest date or production date is according to requirements in the Target Market.
    beverageVintage, "beverageVintage",
    /// `Biotin Per Nutrient Basis Quantity`: Biotin Acid per specified nutrient basis quantity.
    biotinPerNutrientBasis, "biotinPerNutrientBasis",
    /// `Boneless Claim`: The descriptive term that is used by the product manufacturer to identify whether the product makes a specific claim to contain no bones.
    bonelessClaim, "bonelessClaim",
    /// `Has Brand`: The brand of the product that appears on the consumer package.
    brand, "brand",
    /// `Information for professionals about this brand`: A link to a brand presence aimed at clinical professionals.
    brandHomepageClinical, "brandHomepageClinical",
    /// `Information for patients about this brand`: A link to a brand presence aimed at patients.
    brandHomepagePatient, "brandHomepagePatient",
    /// `Brand Name`: The brand name of the product that appears on the consumer package.
    brandName, "brandName",
    /// `Has Brand Owner`: The brand owner of the product. The organization that is responsible for allocating the GTIN to the product.
    brandOwner, "brandOwner",
    /// `Calcium Per Nutrient Basis Quantity`: Calcium per specified nutrient basis quantity.
    calciumPerNutrientBasis, "calciumPerNutrientBasis",
    /// `Carbohydrates Per Nutrient Basis Quantity`: Carbohydrates per specified nutrient basis quantity.
    carbohydratesPerNutrientBasis, "carbohydratesPerNutrientBasis",
    /// `Catch Zone`: Free text field describing the sea zone from which the product was caught in.
    catchZone, "catchZone",
    /// `Has Certification`: Information on certification to which the product complies.
    certification, "certification",
    /// `Certification Agency`: Name of the organization issuing the certification standard or other requirement being met .
    certificationAgency, "certificationAgency",
    /// `Certification Information`: A link to certification information about the product.
    certificationInfo, "certificationInfo",
    /// `Certification Standard`: Name of the certification standard. Free text. Example: Egg classification .
    certificationStandard, "certificationStandard",
    /// `Certification Value`: The product's certification standard value. Example:4.
    certificationValue, "certificationValue",
    /// `Cheese Firmness`: The firmness of the cheese product for example EXTRA_HARD.
    cheeseFirmness, "cheeseFirmness",
    /// `Cheese Maturation Period Description`: A descriptive way to specify a date range as some cheeses are matured over a period of time, but not an exact period. For example 3 to 4 weeks, over 1 year etc. The term maturation is also known in other markets as Aged.
    cheeseMaturationPeriodDescription, "cheeseMaturationPeriodDescription",
    /// `Chloride Per Nutrient Basis Quantity`: Chloride per specified nutrient basis quantity.
    chloridePerNutrientBasis, "chloridePerNutrientBasis",
    /// `Cholesterol Per Nutrient Basis Quantity`: Cholesterol per specified nutrient basis quantity.
    cholesterolPerNutrientBasis, "cholesterolPerNutrientBasis",
    /// `Chromium Per Nutrient Basis Quantity`: Chromium per specified nutrient basis quantity.
    chromiumPerNutrientBasis, "chromiumPerNutrientBasis",
    /// `Clothing Cut`: Supplemental information to indicate the clothing cut or silhouette make of the garment. For example, silhouette details for a pair of jeans such as boot cut, or loose fit, comfort fit.
    clothingCut, "clothingCut",
    /// `Collar Type`: A free text description of the type of collar on the garment.
    collarType, "collarType",
    /// `Has Colour Code`: Relates to a set of details about the colour code for a product
    colourCode, "colourCode",
    /// `Colour Code List`: The parties controlling the colour code lists. Dependent on colour code value.
    colourCodeList, "colourCodeList",
    /// `Colour Code`: A code indicating the colour of an object according to a specific code list. The applied code list is specified as additional information together with the colour code.
    colourCodeValue, "colourCodeValue",
    /// `Colour Description`: A description of the colour of an object.
    colourDescription, "colourDescription",
    /// `Consumer First Availability Date Time`: The first date/time that the buyer is allowed to sell the product to consumers. Usually related to a specific geography. ISO 8601 date format CCYY-MM-DDTHH:MM:SS.
    consumerFirstAvailabilityDateTime, "consumerFirstAvailabilityDateTime",
    /// `Has Consumer Handling Storage`: Link to a website, file, or image containing the manufacturer's recommendations for how the consumer or end user should store and handle the product.
    consumerHandlingStorage, "consumerHandlingStorage",
    /// `Consumer handling and storage information`: A link to information about safe handling and storage of the product.
    consumerHandlingStorageInfo, "consumerHandlingStorageInfo",
    /// `Consumer Lifestage`: Indicates, with reference to the product branding, labelling or packaging, the descriptive term that is used by the product manufacturer to identify the period or stage in the consumer's life during which the product is considered to be suitable.
    consumerLifestage, "consumerLifestage",
    /// `Consumer Package Disclaimer`: Additional information that should be used in advertising and in displaying.
    consumerPackageDisclaimer, "consumerPackageDisclaimer",
    /// `Consumer Product Variant`: The consumer product variant may be used to distinguish one variant of a retail consumer trade item from another if the change does not require the allocation of a different Global Trade Item Number (per the GTIN Management Standard), but communication between trading partners is required to support consumers. The brand owner is responsible for assigning the consumer product variant.
    consumerProductVariant, "consumerProductVariant",
    /// `Consumer Safety Information`: Information on consumer safety regarding the product.
    consumerSafetyInformation, "consumerSafetyInformation",
    /// `Consumer Sales Condition Code`: A code indicating restrictions imposed on the product regarding how it can be sold to the consumer for example Prescription Required.
    consumerSalesCondition, "consumerSalesCondition",
    /// `Consumer Storage Instructions`: Expresses in text the consumer storage instructions of a product which are normally held on the label or accompanying the product. This information may or may not be labelled on the pack.
    consumerStorageInstructions, "consumerStorageInstructions",
    /// `Consumer Usage Instructions`: Free text containing the usage instructions of a product, which are normally held on the label or accompanying the product. This information may or may not be labelled on the pack.
    consumerUsageInstructions, "consumerUsageInstructions",
    /// `Has Business Contact`: Links to information about a business location for an organization.
    contactPoint, "contactPoint",
    /// `Contact Title`: The job title of the person that can be contacted for example Manager.
    contactTitle, "contactTitle",
    /// `Contact Type`: The function or role of a contact for example Customer Support.
    contactType, "contactType",
    /// `Convenience Level Percent`: An indication of the ease of preparation for semi-prepared products. The convenience level indicates the level of preparation in percentage required to prepare and helps the consumer to assess how long it will take to prepare the meal.
    convenienceLevelPercent, "convenienceLevelPercent",
    /// `Copper Per Nutrient Basis Quantity`: Copper per specified nutrient basis quantity.
    copperPerNutrientBasis, "copperPerNutrientBasis",
    /// `Country Code`: A short text string code (see values defined in ISO 3166) specifying the country in which a processing or other activity is performed, for example processing, bottling, manufacturing.
    countryCode, "countryCode",
    /// `Has Country Of Assembly`: The place where product is assembled.
    countryOfAssembly, "countryOfAssembly",
    /// `Has Country Of Last Processing`: The place where the product or ingredient was last processed and tested before importation.
    countryOfLastProcessing, "countryOfLastProcessing",
    /// `Has Country Of Origin`: Code indicating the country of origin of the product.
    countryOfOrigin, "countryOfOrigin",
    /// `Country Of Origin Statement`: A description of the geographic area the item may have originated from or has been processed.
    countryOfOriginStatement, "countryOfOriginStatement",
    /// `Country Subdivision Code`: A short text string code (see values defined in ISO 3166_2) specifying the country subdivision in which an activity is performed, for example processing, bottling, manufacturing.
    countrySubdivisionCode, "countrySubdivisionCode",
    /// `County Code`: A code that identifies a county. A county is a territorial division in some countries, forming the chief unit of local administration. In the US, a county is a political and administrative division of a state.
    countyCode, "countyCode",
    /// `Cross Street`: A street intersecting a main street (usually at right angles) and continuing on both sides of it.
    crossStreet, "crossStreet",
    /// `Has Customer Support Centre`: The organization which provides product support to the trading partner organization to which merchandise is sold.
    customerSupportCentre, "customerSupportCentre",
    /// `Daily Value Intake Percent`: The percentage of the recommended daily intake of a nutrient as recommended by authorities of the target market. Is expressed relative to the serving size and base daily value intake.
    dailyValueIntakePercent, "dailyValueIntakePercent",
    /// `Default link`: The default link for a given identified item to which a resolver will redirect unless there is information in the request that is a better match.
    defaultLink, "defaultLink",
    /// `Default link*`: Originally proposed as the term for defaultLinkMulti. Do not use.
    defaultLink_2A, "defaultLink%2A",
    /// `Default linkMulti`: A set of 'default links' that may be differentiated by information in the HTTP request headers sent to a resolver to enable a better match than the single default link.
    defaultLinkMulti, "defaultLinkMulti",
    /// `Department`: The name of a division of an organization dealing with a specific activity
    department, "department",
    /// `Has Dependent Proprietary Product`: Dependent products are products which are required to make the current product functional.
    dependentProprietaryProduct, "dependentProprietaryProduct",
    /// `Descriptive Size`: An alphanumeric size factor the brand owner wishes to communicate to the consumer. IE Jumbo, Capri, Full Length, Maxi.
    descriptiveSize, "descriptiveSize",
    /// `Diet Code`: Links to multiple pairs of gs1:DietTypeCode and diet type sub code (free-form text string).
    dietCode, "dietCode",
    /// `Diet Type Code`: Code indicating the diet the product is suitable for example Kosher.
    dietType, "dietType",
    /// `Diet Type Description`: Free text for indication of diet not stated in the list of diets.
    dietTypeDescription, "dietTypeDescription",
    /// `Diet Type Sub-code`: Indicates a set of agreements or a certificate name that guarantees the product is permitted in a particular diet. A diet type subcode is a subclassification of a specific diet type. For example, Pareve is a diet type subcode of Kosher.
    dietTypeSubcode, "dietTypeSubcode",
    /// `Product disassembly`: A link to the instructions for dismantling/disassembly.
    disassemblyInfo, "disassemblyInfo",
    /// `Discount Repeats Per Multiple Minimum`: If specified and set to true, the discount is available for each time the minimum qualifying criteria are met.  This can be used to express '$10 off each $50 spend', which is distinct from a 20% discount because it is quantized in units of spending.
    discountRepeatsPerMultipleMinimum, "discountRepeatsPerMultipleMinimum",
    /// `Discount Type`: A code that specifies the type of payment discount applicable to an offer, for example BOGO.
    discountType, "discountType",
    /// `Drained Weight`: The weight of the product when drained of its liquid. For example 225 GRM, Jar of pickles in vinegar.
    drainedWeight, "drainedWeight",
    /// `Due Date`: The date by which an invoice should be paid. This data element represents an attribute of a payment slip reference number, AI (8020), and a Global Location Number (GLN) of the invoicing party.
    dueDate, "dueDate",
    /// `Duration Of Warranty`: The time period that the warranty is valid within.
    durationOfWarranty, "durationOfWarranty",
    /// `Duty Fee Tax Amount`: The current tax or duty or fee amount applicable to the product, expressed as a floating-point numeric value that is qualified by the corresponding currency. See also gs1:priceCurrency.
    dutyFeeTaxAmount, "dutyFeeTaxAmount",
    /// `Duty Fee Tax Description`: A description of tax type for example Taxes sure les supports audio.
    dutyFeeTaxDescription, "dutyFeeTaxDescription",
    /// `Duty Fee Tax Rate`: The current tax or duty rate percentage applicable to the product.
    dutyFeeTaxRate, "dutyFeeTaxRate",
    /// `Eligible Quantity`: The quantity including unit of measure for which the offer for good or service is valid.  If this is not specified, an eligible quantity of 1 should be assumed.
    eligibleQuantity, "eligibleQuantity",
    /// `Eligible Quantity Maximum`: The maximum quantity including unit of measure for which the offer for good or service is valid.
    eligibleQuantityMaximum, "eligibleQuantityMaximum",
    /// `Eligible Quantity Minimum`: The minimum quantity including unit of measure for which the offer for good or service is valid.
    eligibleQuantityMinimum, "eligibleQuantityMinimum",
    /// `Eligible Trade Channel`: A code determining the location where a user can redeem the offer, for example ONLINE_ONLY. 
    eligibleTradeChannel, "eligibleTradeChannel",
    /// `E-mail`: Creating/sending/receiving of unstructured free text messages or documents using computer network, a mini-computer or an attached modem and regular telephone line or other electronic transmission media.
    email, "email",
    /// `Energy from Fat Per Nutrient Basis Quantity`: Energy from Fat per specified nutrient basis quantity.
    energyFromFatPerNutrientBasis, "energyFromFatPerNutrientBasis",
    /// `Energy Per Nutrient Basis Quantity`: Energy Per specified nutrient basis quantity.
    energyPerNutrientBasis, "energyPerNutrientBasis",
    /// `EPC Information Services (EPCIS) repository`: A link to an EPCIS repository of visibility event data.
    epcis, "epcis",
    /// `Electronic Patient Information Leaflet`: A link to an electronic patient information leaflet.
    epil, "epil",
    /// `Has Equivalent Product`: A product which can be substituted for the product based on supplier-defined functional equivalence to the product.
    equivalentProduct, "equivalentProduct",
    /// `Exact Discount Amount`: Links to a gs1:PriceSpecification that indicates in terms of an amount and specified currency, the exact discount on the sales price associated with a particular gs1:Discount. This property can be used to express '$10 off'.
    exactDiscountAmount, "exactDiscountAmount",
    /// `Exact Discount Percentage`: A floating-point value indicating an exact percentage discount on the sales price associated with a particular gs1:Discount.  This property can be used to express '15% discount'.
    exactDiscountPercentage, "exactDiscountPercentage",
    /// `Exclusion Description`:  A text description of any products, brands, or categories that cannot be used with the offer
    exclusionDescription, "exclusionDescription",
    /// `Expiration Date`: The expiration date is the date that determines the limit of consumption or use of a product/coupon. Its meaning is determined based on the trade item context (e.g., for food, the date will indicate the possibility of a direct health risk resulting from use of the product after the date, for pharmaceutical products, it will indicate the possibility of an indirect health risk resulting from the ineffectiveness of the product after the date). It is often referred to as 'use by date' or 'maximum durability date'.
    expirationDate, "expirationDate",
    /// `Expiration Date and Time`: The manufacturer determines the expiration date and time, which is relevant only for short duration and for items that will not be sent on long distances and not outside of the time zone. A typical application of AI (7003) is in hospitals or public pharmacies for special, customised, products which may have a 'life duration' shorter than one single day. The life duration varies according the pharmaceutical substances used in the treatment. The precise expiration date and time is defined at the end of the manufacturing process, and can be barcoded on the product label as an attribute to the item’s GTIN. Where there is no business requirement to express the expiration date to the nearest hour (or less), AI (17) Expiration date should be used.
    expirationDateTime, "expirationDateTime",
    /// `Frequently Asked Questions`: A link to a set of frequently asked questions.
    faqs, "faqs",
    /// `Fat In Milk Content`: The percentage of fat contained in milk content of the product.
    fatInMilkContent, "fatInMilkContent",
    /// `Fat Per Nutrient Basis Quantity`: Fat per specified nutrient basis quantity.
    fatPerNutrientBasis, "fatPerNutrientBasis",
    /// `Fat In Dry Matter`: The amount of fat contained in the base product expressed in percentage.
    fatpercentageInDryMatter, "fatpercentageInDryMatter",
    /// `Telefax`: A fax number used for transmitting and reproducing fixed graphic material over telephone lines or other electronic transmission media.
    faxNumber, "faxNumber",
    /// `Fibre Per Nutrient Basis Quantity`: Fibre per specified nutrient basis quantity.
    fibrePerNutrientBasis, "fibrePerNutrientBasis",
    /// `File Language Code`: The specified language to which the digital asset is targeted. It is recommended to use the ISO 639-1 language code.
    fileLanguageCode, "fileLanguageCode",
    /// `File Pixel Height`: The number of pixels along the vertical axis of the image.
    filePixelHeight, "filePixelHeight",
    /// `File Pixel Width`: The number of pixels along the horizontal axis of the image.
    filePixelWidth, "filePixelWidth",
    /// `First Freeze Date`: The first freeze date is applicable to products that are frozen directly after slaughtering, harvesting, catching or after initial processing of the product. Examples include fresh meat, meat products or fishery products. The first freeze date is determined by the organisation conducting the freezing.
    firstFreezeDate, "firstFreezeDate",
    /// `Fish Type`: The type of fish for example Sea bass.
    fishType, "fishType",
    /// `Fluoride Per Nutrient Basis Quantity`: Fluoride per specified nutrient basis quantity.
    fluoridePerNutrientBasis, "fluoridePerNutrientBasis",
    /// `Folic Acid Per Nutrient Basis Quantity`: Folic Acid per specified nutrient basis quantity.
    folicAcidPerNutrientBasis, "folicAcidPerNutrientBasis",
    /// `Food Beverage Refrigeration Claim`: Identifies whether or not the product requires refrigeration.
    foodBeverageRefrigerationClaim, "foodBeverageRefrigerationClaim",
    /// `Food Beverage Target Use`: The type of meal the food or beverage product is targeted to for example Breakfast.
    foodBeverageTargetUse, "foodBeverageTargetUse",
    /// `Fastening Type`: Something that mechanically joins or affixes two or more parts together in a footwear product for example a shoe lace.
    footwearFasteningType, "footwearFasteningType",
    /// `Footwear Upper Type`: The descriptive term that is used by the product manufacturer to identify whether the footwear upper is open or closed. Otherwise known as Open or Closed Upper.
    footwearUpperType, "footwearUpperType",
    /// `Fresh or Seawater Farmed`: A code determining whether the fish originated from the sea or was farmed.
    freshOrSeawaterFarmed, "freshOrSeawaterFarmed",
    /// `Functional Name`: Describes use of the product or service by the consumer. Should help clarify the product classification associated with the GTIN.
    functionalName, "functionalName",
    /// `Genetically Modified Declaration Code`: A statement of the presence or absence of genetically modified protein or DNA.
    geneticallyModifiedDeclaration, "geneticallyModifiedDeclaration",
    /// `Has Geocoordinates`: Links to information about geocoordinates for a place.
    geo, "geo",
    /// `Global Location Number (GLN)`: A Global Location Number (GLN) is the GS1 Identification Key used to identify physical locations or parties. The key comprises a GS1 Company Prefix, Location Reference and Check Digit. For more information see http://www.gs1.org/gln.
    globalLocationNumber, "globalLocationNumber",
    /// `GPC Category Code`: 8-digit code (GPC Brick Value) specifying a product category according to the GS1 Global Product Classification (GPC) standard. For more information see http://www.gs1.org/gpc
    gpcCategoryCode, "gpcCategoryCode",
    /// `GPC Category Description`: A description of the code specifying a product category according to the GS1 Global Product Classification (GPC) standard.
    gpcCategoryDescription, "gpcCategoryDescription",
    /// `Gross Area`: The gross area of a product (including its packaging)
    grossArea, "grossArea",
    /// `Gross volume`: The overall volume of the item including packaging. This can be given using a number of different AI ranges that depend on the units in which the volume is measured.
    grossVolume, "grossVolume",
    /// `Gross Weight`: Used to identify the gross weight of the product. The gross weight includes all packaging materials of the product. At pallet level the productGrossWeight includes the weight of the pallet itself. For example, 200 GRM, value - total pounds, total grams, etc.
    grossWeight, "grossWeight",
    /// `Growing Method`: The process through which fresh produce is grown and cultivated.
    growingMethod, "growingMethod",
    /// `GTIN`: A Global Trade Item Number (GTIN) is the 14 digit GS1 Identification Key used to identify products. The key comprises a GS1 Company Prefix followed by an Item Reference Number and a Check Digit. See http://www.gs1.org/gtin  for more details.
    gtin, "gtin",
    /// `Handled by`: Used when one resolver redirects all request URIs that match a given pattern without further processing, such as from GS1 to a brand-operated service. See section 8.7.1 of the Digital Link standard, version 1.1. 
    handledBy, "handledBy",
    /// `Product EOL handling`: A link to the instructions for end-of-life handling as required by a product passport. The information will include instructions for reuse, repair, disassembly and recycling.
    handlingEndOfLife, "handlingEndOfLife",
    /// `Harvest Date.`: The harvest date. For example, the harvest date can be the date when an animal was slaughtered or killed, a fish has been harvested, or a crop was harvested. This date  is determined by the organisation conducting the harvesting. Different organisations may use more specific terminology when referring to their specific needs and use terms such as: Date of catch or slaughter date. 
    harvestDate, "harvestDate",
    /// `Harvest Date End`: The harvest end date. For example, the harvest end date can be the date when an animal was slaughtered or killed, a fish has been harvested, or a crop was harvested. This end date is determined by the organisation conducting the harvesting. Different organisations may use more specific terminology when referring to their specific needs and use terms such as: Date of catch or slaughter date. When referring to animals the date range refers to the whole animal and all meat or fish cuts derived from this animal.
    harvestDateEnd, "harvestDateEnd",
    /// `Harvest Date Start`: The harvest start date. For example, the harvest start date can be the date when an animal was slaughtered or killed, a fish has been harvested, or a crop was harvested. This start date is determined by the organisation conducting the harvesting. Different organisations may use more specific terminology when referring to their specific needs and use terms such as: Date of catch or slaughter date. When referring to animals the date range refers to the whole animal and all meat or fish cuts derived from this animal.
    harvestDateStart, "harvestDateStart",
    /// `Has Allergen`: Relates to details about allergens
    hasAllergen, "hasAllergen",
    /// `Batch/Lot Identifier`: The batch or lot number associates an item with information the manufacturer considers relevant for traceability of the trade item to which the element string is applied. The data may refer to the trade item itself or to items contained. The number may be, for example, a production lot number, a shift number, a machine number, a time, or an internal production code. In cases where the same product is manufactured in different locations the brand owner and the manufacturer are responsible for ensuring the non-duplication of batch/lot numbers for a GTIN. For the re-use of batch/lot numbers with a GTIN, sector-specific constraints need to be considered. 
    hasBatchLotNumber, "hasBatchLotNumber",
    /// `Has Retailers`: A link to a list of retailers for this item
    hasRetailers, "hasRetailers",
    /// `Has Returnable Package Deposit Details`: links to details of amounts refunded for returnable package in a specified region.
    hasReturnablePackageDeposit, "hasReturnablePackageDeposit",
    /// `Serial Number`: A serial number is assigned to an entity for its lifetime. When combined with a GTIN, a serial number uniquely identifies an individual item. The serial number field is alphanumeric and may include all characters contained in figure 7.11-1. The brand owner and the manufacturer are responsible for ensuring the non-duplication of serial numbers for a GTIN. For the re-use of serial numbers with a GTIN, sector-specific constraints need to be considered. 
    hasSerialNumber, "hasSerialNumber",
    /// `Third-Party Controlled Serial Number`: This identifier is assigned to an entity for its lifetime. When combined with a GTIN, a TPX uniquely identifies an individual item and forms a unit pack Unique Identifier (upUI) for tobacco traceability per EU 2018/574. The serial number field is alphanumeric and may include all characters contained in figure 7.11-1. The Third Party determines the TPX, but the TPX shall begin with the ID Issuer Unique Identification Code (UIC), followed by GS1 UIC Extension 1, and GS1 UIC Extension 2.
    hasThirdPartyControlledSerialNumber, "hasThirdPartyControlledSerialNumber",
    /// `Health Claim`: A description of health claims according to regulations of the target market.
    healthClaimDescription, "healthClaimDescription",
    /// `Has Product Image`: Link to a file containing a visual representation of the product.
    image, "image",
    /// `In Package Depth`: The depth of the product in its packaging, as measured according to the GS1 Package Measurement Rules. See http://www.gs1.org/package-measurement-rules-implementation-guide for more details.
    inPackageDepth, "inPackageDepth",
    /// `In Package Diameter`: The measurement of the diameter of the product in its package at its largest point. For example, 165 MMT.
    inPackageDiameter, "inPackageDiameter",
    /// `In Package Height`: The height of the product in the package, as measured according to the GS1 Package Measurement Rules. See http://www.gs1.org/package-measurement-rules-implementation-guide for more details.
    inPackageHeight, "inPackageHeight",
    /// `In Package Width`: The width of the product in the package, as measured according to the GS1 Package Measurement Rules. See http://www.gs1.org/package-measurement-rules-implementation-guide for more details.
    inPackageWidth, "inPackageWidth",
    /// `Included Accessories`: Any included object or device not part of the core product itself but which adds to its functionality or use.
    includedAccessories, "includedAccessories",
    /// `Has Food And Beverage Ingredient Information`: Links to information about ingredients of a specific Food/Beverage/Tobacco product.
    ingredient, "ingredient",
    /// `Ingredient Content Percentage`: Quantity of the ingredient contained in the product as a percentage of the total product ingredients. This is used in conjunction with ingredientName.
    ingredientContentPercentage, "ingredientContentPercentage",
    /// `Ingredient Name`: Free text field describing an ingredient or ingredient group. Ingredients include any additives (colourings, preservatives, e-numbers, etc.) that are encompassed.
    ingredientName, "ingredientName",
    /// `Ingredient of Concern`: Indicates a claim to an ingredient, considered to be a concern for regulatory or other reasons, and which is 'contained' within the product but may not need to specify the amount whether approximate, or an accurate measurement be given.
    ingredientOfConcern, "ingredientOfConcern",
    /// `Ingredient Sequence`: Integer (1, 2, 3...) indicating the ingredient order by content percentage of the product. (major ingredient = 1, second ingredient = 2) etc.
    ingredientSequence, "ingredientSequence",
    /// `Ingredient Statement`: Information on the constituent ingredient make up of the product specified as one string.
    ingredientStatement, "ingredientStatement",
    /// `Ingredients information`: A link to facts about the product's ingredients.
    ingredientsInfo, "ingredientsInfo",
    /// `Instructions`: A link to instructions related to the item, such as assembly instructions, usage tips etc.
    instructions, "instructions",
    /// `Has Instructions For Use`: Link to a file containing the Instructions For Use.
    instructionsForUse, "instructionsForUse",
    /// `Iodine Per Nutrient Basis Quantity`: Iodine per specified nutrient basis quantity.
    iodinePerNutrientBasis, "iodinePerNutrientBasis",
    /// `Iron Per Nutrient Basis Quantity`: Iron per specified nutrient basis quantity.
    ironPerNutrientBasis, "ironPerNutrientBasis",
    /// `Irradiated Code`: Indicates if radiation has been applied to the product.
    irradiatedCode, "irradiatedCode",
    /// `Is Carbonated`: Used to identify whether or not a beverage product is naturally effervescent or has been made effervescent by the addition of carbon dioxide gas.
    isCarbonated, "isCarbonated",
    /// `Is Decaffeinated`: The descriptive term that is used by the product manufacturer to identify whether or not the product contains caffeine.
    isDecaffeinated, "isDecaffeinated",
    /// `Is From Concentrate`: Used to identify whether or not the product claims to be made from a concentrated formulation.
    isFromConcentrate, "isFromConcentrate",
    /// `Is Homogenised`: A The indication whether or not the milk used was actively homogenised. The homogenisation of milk is a technical process in the dairy. The milk fat is milled to such an extent that further creaming is prevented.
    isHomogenised, "isHomogenised",
    /// `Is Instant`: Determines whether the product is instant.
    isInstant, "isInstant",
    /// `Is Maternity`: Indicates, with reference to the product branding, labelling or packaging, the descriptive term that is used by the product manufacturer to identify if the product is intended as maternity wear.
    isMaternity, "isMaternity",
    /// `Only Available Through Retailer`: If specified and set to true, the discount is only available through the retailer making the offer.
    isOnlyAvailableThroughRetailer, "isOnlyAvailableThroughRetailer",
    /// `Only For Retailer Mailing List Members`: If specified and set to true, the discount is only available for customers who have signed up to the retailer's mailing list.
    isOnlyWithMailingListSignup, "isOnlyWithMailingListSignup",
    /// `Only With Payment Card`: If specified, the discount is only available when purchasing using one of the specified payment card types.
    isOnlyWithPaymentCard, "isOnlyWithPaymentCard",
    /// `Only For Retailer Loyalty Cardholders`: If specified and set to true, the discount is only available for holders of the retailer's own loyalty card.
    isOnlyWithRetailerLoyaltyCard, "isOnlyWithRetailerLoyaltyCard",
    /// `Only For Retailer Payment Cardholders`: If specified and set to true, the discount is only available for holders of the retailer's own store payment card.
    isOnlyWithRetailerPaymentCard, "isOnlyWithRetailerPaymentCard",
    /// `Is Patterned`: The descriptive term that is used by the product manufacturer to identify whether or not the product has a patterned design.
    isPatterned, "isPatterned",
    /// `Is Pitted Stoned`: The descriptive term that is used by the product manufacturer to identify whether or not a fruit or vegetable product has been de-stoned or pitted prior to being offered for sale.
    isPittedStoned, "isPittedStoned",
    /// `Is Product Recalled`: An indicator for the product to determine if the Manufacturer or Supplier has recalled the product.
    isProductRecalled, "isProductRecalled",
    /// `Is Promoter Exclusive Offer`: Determines whether the offer is only provided by the promoter
    isPromoterExclusiveOffer, "isPromoterExclusiveOffer",
    /// `Is Rind Edible`: An indicator whether or not the cheese rind is edible. Some cheeses are coated in plastic or their surface is treated with other traditional substances to increase their shelf life. This can result in the rind no longer being edible.
    isRindEdible, "isRindEdible",
    /// `Is Seedless`: Determines whether the product is seedless as grown.
    isSeedless, "isSeedless",
    /// `Is Shelled or Peeled`: The descriptive term that is used by the product manufacturer to identify whether or not the product or its contents have been shelled/peeled prior to being offered for sale.
    isShelledPeeled, "isShelledPeeled",
    /// `Is Sliced`: Determines whether the product comes pre-sliced.
    isSliced, "isSliced",
    /// `Is Thermal`: The descriptive term that is used to identify whether the product is thermal.
    isThermal, "isThermal",
    /// `Is Vintage`: Identifies whether the product makes claim to being vintage.
    isVintage, "isVintage",
    /// `Is Washed Ready To Eat`: Determines whether product has been prewashed and is ready to eat.
    isWashedReadyToEat, "isWashedReadyToEat",
    /// `Is Waterproof`: The descriptive term that is used to identify whether or not the product claims to provide waterproofing to the applied surface.
    isWaterproof, "isWaterproof",
    /// `Is Wearable Item Disposable`: Identifies whether or not the product is intended to be disposed of after single use or a limited period of use.
    isWearableItemDisposable, "isWearableItemDisposable",
    /// `Item Offered`: The product included in the offer.
    itemOffered, "itemOffered",
    /// `Juice Content Percent`: The fruit juice content of the product expressed as a percentage.
    juiceContentPercent, "juiceContentPercent",
    /// `Latitude`: Angular distance North or South from the earth's equator measured through 90 degrees.
    latitude, "latitude",
    /// `Leave a review`: A link through which a review can be added.
    leaveReview, "leaveReview",
    /// `Link Type`: A property representing a link to an online resource that is directly related to the identified item.  More specific link types are defined as subproperties of gs1:linkType
    linkType, "linkType",
    /// `Has Location`: The place associated with an organization.
    location, "location",
    /// `Longitude`: The arc or portion of the earth's equator intersected between the meridian of a given place and the prime meridian and expressed in degrees
    longitude, "longitude",
    /// `Magnesium Per Nutrient Basis Quantity`: Magnesium per specified nutrient basis quantity.
    magnesiumPerNutrientBasis, "magnesiumPerNutrientBasis",
    /// `Makes Offer`: An offer made by an organization.
    makesOffer, "makesOffer",
    /// `Manganese Per Nutrient Basis Quantity`: Manganese per specified nutrient basis quantity.
    manganesePerNutrientBasis, "manganesePerNutrientBasis",
    /// `Has Manufacturer`: The organization that produces the item.
    manufacturer, "manufacturer",
    /// `Manufacturer Preparation Code`: Code indicating the preparation methods that a manufacturer has used in the manufacturing of a product for example DEEP_FRY.
    manufacturerPreparationCode, "manufacturerPreparationCode",
    /// `Has Manufacturer's Warranty`: The warranty associated with the product.
    manufacturersWarranty, "manufacturersWarranty",
    /// `Has Manufacturing Plant`: A physical location consisting of one or more buildings with facilities for manufacturing.
    manufacturingPlant, "manufacturingPlant",
    /// `Mass Per Unit Area`: The mass per unit area of a particular product
    massPerUnitArea, "massPerUnitArea",
    /// `Master data`: A link to a source of structured master data for the entity. This is typically for B2B applications.
    masterData, "masterData",
    /// `Maturation Method Code`: The method of maturity for the item for example tree ripened or jet fresh.
    maturationMethod, "maturationMethod",
    /// `Maximum Price`: Provides a maximum price value as a floating-point numeric value that is qualified by the corresponding currency. See also gs1:priceCurrency
    maxPrice, "maxPrice",
    /// `Maximum Discount Amount`: Links to a gs1:PriceSpecification that indicates in terms of an amount and specified currency, the maximum discount on the sales price associated with a particular gs1:Discount. This property can be used to express 'up to $10 off'.
    maximumDiscountAmount, "maximumDiscountAmount",
    /// `Maximum Discount Percentage`: A floating-point value indicating a maximum percentage discount on the sales price associated with a particular gs1:Discount.  This property can be used to express 'up to 15% discount'.
    maximumDiscountPercentage, "maximumDiscountPercentage",
    /// `Maximum Optimum Consumption Temperature`: The upper limit drinking temperature of the optimum range of the drinking temperature. The optimum range of the drinking temperature is a recommendation and is based on the experience of the individual producer. Allows for the representation of the same value in different units of measure but not multiple values.
    maximumOptimumConsumptionTemperature, "maximumOptimumConsumptionTemperature",
    /// `Maximum Qualifying Items`: Specifies the maximum number of items that qualify for a particular gs1:Discount. This property can be used to express 'maximum N items per customer'.
    maximumQualifyingItems, "maximumQualifyingItems",
    /// `Maximum Qualifying Spend`: Links to a gs1:PriceSpecification that indicates in terms of an amount and specified currency, the maximum spend that qualifies for a particular gs1:Discount. This property can be used to express 'for purchases of up to $100'.
    maximumQualifyingSpend, "maximumQualifyingSpend",
    /// `Meat Poultry Type Code`: The fish, meat, or poultry type for this food and beverage item.
    meatPoultryType, "meatPoultryType",
    /// `Minimum Price`: Provides a minimum price value as a floating-point numeric value that is qualified by the corresponding currency. See also gs1:priceCurrency
    minPrice, "minPrice",
    /// `Minimum Discount Amount`: Links to a gs1:PriceSpecification that indicates in terms of an amount and specified currency, the minimum discount on the sales price associated with a particular gs1:Discount. This property can be used to express 'at least $10 off'.
    minimumDiscountAmount, "minimumDiscountAmount",
    /// `Minimum Discount Percentage`: A floating-point value indicating a minimum percentage discount on the sales price associated with a particular gs1:Discount.  This property can be used to express 'at least 15% discount'.
    minimumDiscountPercentage, "minimumDiscountPercentage",
    /// `Minimum Fish Content`: The minimum amount of fish contained in a food and beverage product expressed as a measurement.
    minimumFishContent, "minimumFishContent",
    /// `Minimum Meat Poultry Content`: The minimum amount of fish, meat or poultry contained in a food and beverage product expressed as a measurement.
    minimumMeatPoultryContent, "minimumMeatPoultryContent",
    /// `Minimum Optimum Consumption Temperature`: The lower limit drinking temperature of the optimum range of the drinking temperature. The optimum range of the drinking temperature is a recommendation and is based on the experience of the individual producer. Allows for the representation of the same value in different units of measure but not multiple values.
    minimumOptimumConsumptionTemperature, "minimumOptimumConsumptionTemperature",
    /// `Minimum Qualifying Items`: Specifies the minimum number of items that must be purchased to qualify for a particular gs1:Discount. This property can be used to express 'if you buy at least N items'.
    minimumQualifyingItems, "minimumQualifyingItems",
    /// `Minimum Qualifying Spend`: Links to a gs1:PriceSpecification that indicates in terms of an amount and specified currency, the minimum spend required to qualify for a particular gs1:Discount. This property can be used to express 'if you spend at least $100'.
    minimumQualifyingSpend, "minimumQualifyingSpend",
    /// `Molybdenum Per Nutrient Basis Quantity`: Molybdenum per specified nutrient basis quantity.
    molybdenumPerNutrientBasis, "molybdenumPerNutrientBasis",
    /// `Monounsaturated Fat Per Nutrient Basis Quantity`: Monounsaturated fat per specified nutrient basis quantity.
    monounsaturatedFatPerNutrientBasis, "monounsaturatedFatPerNutrientBasis",
    /// `Net Area`: The net area of a product (excluding its packaging)
    netArea, "netArea",
    /// `Net content`: The quantity of the product contained by a package, usually as claimed on the label. Indicates the net content of the total product. For fixed value products use the value claimed on the package, to avoid variable fill rate issue that arises with some product which are sold by volume or weight, and whose actual content may vary slightly from batch to batch.
    netContent, "netContent",
    /// `Net weight`: Used to identify the net weight of the product. Net Weight excludes all packaging material, including the packaging material of all lower-level GTINs. Example:11.5 kgm.
    netWeight, "netWeight",
    /// `Niacin Per Nutrient Basis Quantity`: Niacin per specified nutrient basis quantity.
    niacinPerNutrientBasis, "niacinPerNutrientBasis",
    /// `Number of Servings Per Package`: The total number of servings contained in the package.
    numberOfServingsPerPackage, "numberOfServingsPerPackage",
    /// `Number of Servings Per Package Measurement Precision`: Code indicating whether the number of servings per package is exact or approximate.
    numberOfServingsPerPackageMeasurementPrecision, "numberOfServingsPerPackageMeasurementPrecision",
    /// `Number of Servings Range Description`: A free text field specifying a range for the number of servings contained in the package.
    numberOfServingsRangeDescription, "numberOfServingsRangeDescription",
    /// `Nutrient Basis Quantity`: Quantity on which the nutrient information has been based; for example, per 100 grams. When specified, nutrientBasisQuantity establishes the basis for all contained nutrient records.
    nutrientBasisQuantity, "nutrientBasisQuantity",
    /// `Nutrient Basis Quantity Type Code`: The type of quantity specified in the nutrientBasisQuantity for example measurement, serving size, or container. This is used in conjunction with the nutrientBasisQuantity.
    nutrientBasisQuantityType, "nutrientBasisQuantityType",
    /// `Nutrient Measurement Precision`: The Code indicating whether the specified nutrient content is exact or approximate.
    nutrientMeasurementPrecision, "nutrientMeasurementPrecision",
    /// `Nutritional Claim Code`: Code indicating a nutritional claim applicable to the product, for example FAT_FREE.
    nutritionalClaim, "nutritionalClaim",
    /// `Nutritional Claim Statement`: Free text field for any additional nutritional claims.
    nutritionalClaimStatement, "nutritionalClaimStatement",
    /// `Nutritional Information`: A link to nutritional facts about the product.
    nutritionalInfo, "nutritionalInfo",
    /// `Offer Description`: A description of the offer including goods or services offered for sale or use.
    offerDescription, "offerDescription",
    /// `Offer Discount`: A discount associated with an offer.
    offerDiscount, "offerDiscount",
    /// `Offer Redemption Type`: A code indicating the type of redemptions that apply to the offer, for example single use.
    offerRedemptionType, "offerRedemptionType",
    /// `Offer Redemption URL`: The URL where the offer seeker will need to go in order to redeem the offer for an online redemption.
    offerRedemptionURL, "offerRedemptionURL",
    /// `Offer Restriction Description`: A description of what the offer is restricted to, relative to all other offerings by the issuer, for example payment restrictions, subscription required, new customers only.
    offerRestrictionDescription, "offerRestrictionDescription",
    /// `Has Organic Claim`: Relates to an organic claim about the product
    organicClaim, "organicClaim",
    /// `Organic Claim Agency Code`: A governing body that creates and maintains standards related to organic products.
    organicClaimAgency, "organicClaimAgency",
    /// `Organic Percent Claim`: The percent of actual organic materials per weight of the product. This is usually claimed on the product.
    organicPercentClaim, "organicPercentClaim",
    /// `Organization Name`: The name of the organization expressed in text.
    organizationName, "organizationName",
    /// `Organization Role`: Code indicating an organization role. Allowed code values are specified in OrganizationalRole code list.
    organizationRole, "organizationRole",
    /// `originalCodeValue`: 
    originalCodeValue, "originalCodeValue",
    /// `Out of Package Depth`: The depth of the product out of its packaging, as measured according to the GS1 Package Measurement Rules. See http://www.gs1.org/package-measurement-rules-implementation-guide for more details.
    outOfPackageDepth, "outOfPackageDepth",
    /// `Out of Package Diameter`: The measurement of the diameter of the product out of its package at its largest point. For example, 165 MMT.
    outOfPackageDiameter, "outOfPackageDiameter",
    /// `Out of Package Height`: The height of the product out of the package, as measured according to the GS1 Package Measurement Rules. See http://www.gs1.org/package-measurement-rules-implementation-guide for more details.
    outOfPackageHeight, "outOfPackageHeight",
    /// `Out of Package Width`: The width of the product out of the package, as measured according to the GS1 Package Measurement Rules. See http://www.gs1.org/package-measurement-rules-implementation-guide for more details.
    outOfPackageWidth, "outOfPackageWidth",
    /// `Has Packaging`: Details on the packaging for a product including type, weight and materials.
    packaging, "packaging",
    /// `Date of packaging`: The packaging date is the date when the goods were packed as determined by the packager. The date may refer to the trade item itself or to items contained.
    packagingDate, "packagingDate",
    /// `Packaging Feature`: Code indicating a feature that facilitates the usage of the product by the consumer, for example a handle. Packaging features do not affect the core composition of the packaging type nor modify its usage.
    packagingFeature, "packagingFeature",
    /// `Packaging Function`: Code indicating specific functionality for packaging resulting from specific processes or features present in the packaging type,for example, ANTI_TAMPERING.
    packagingFunction, "packagingFunction",
    /// `Packaging Marked Diet Allergen Type Code`: Indication of which dietary or allergen marks are on the package.
    packagingMarkedDietAllergenType, "packagingMarkedDietAllergenType",
    /// `Packaging Marked Free From Code`: Indication of the food ingredients that the package is marked free from.
    packagingMarkedFreeFrom, "packagingMarkedFreeFrom",
    /// `Accreditation Code`: A marking that the product received recognition, endorsement, certification by following guidelines by the label issuing agency. This does not represent claims for regulatory purposes on products such as free from markings.
    packagingMarkedLabelAccreditation, "packagingMarkedLabelAccreditation",
    /// `Has Packaging Material Details`: links to details about packaging material type, quantity and thickness
    packagingMaterial, "packagingMaterial",
    /// `Packaging Material Composition Quantity`: The quantity of the packaging material of the product. Can be weight, volume or surface, can vary by country.
    packagingMaterialCompositionQuantity, "packagingMaterialCompositionQuantity",
    /// `Packaging Material Thickness`: The thickness of a packaging material.
    packagingMaterialThickness, "packagingMaterialThickness",
    /// `Packaging Material Type`: The materials used for the packaging of the product for example glass or plastic.
    packagingMaterialType, "packagingMaterialType",
    /// `Packaging Recycling Process Type`: The process the packaging could undertake for recyclable & sustainability programs. Examples COMPOSTABLE, ENERGY_RECOVERABLE, REUSABLE.
    packagingRecyclingProcessType, "packagingRecyclingProcessType",
    /// `Packaging Recycling Scheme`: A code indicating the recycling scheme the packaging of this product will fall within when recycled. Applies to recyclable packaging with or without deposit.
    packagingRecyclingScheme, "packagingRecyclingScheme",
    /// `Packaging Shape`: A code depicting the shape of a package for example CONE.
    packagingShape, "packagingShape",
    /// `Packaging Type`: The dominant means used to transport, store, handle or display the product as defined by the data source. This packaging is not used to describe any manufacturing process.Recommend to use UNECE Rec 21 codes.
    packagingType, "packagingType",
    /// `Pantothenic Acid Per Nutrient Basis Quantity`: Pantothenic Acid per specified nutrient basis quantity.
    pantothenicAcidPerNutrientBasis, "pantothenicAcidPerNutrientBasis",
    /// `Payment Terms`: The type of payment term expressed as a code, for example Discount.
    paymentTerms, "paymentTerms",
    /// `Percentage of Alcohol Per Volume`: The percentage of alcohol contained in product.
    percentageOfAlcoholByVolume, "percentageOfAlcoholByVolume",
    /// `Phosphorus Per Nutrient Basis Quantity`: Phosphorus per specified nutrient basis quantity.
    phosphorusPerNutrientBasis, "phosphorusPerNutrientBasis",
    /// `Product Information Page`: A link to information specifically about the identified item, typically operated by the brand owner or a retailer of the product and aimed at consumers. It may include links to further information, product description, specifications etc.
    pip, "pip",
    /// `Polyols Per Nutrient Basis Quantity`: Polyols per specified nutrient basis quantity.
    polyolsPerNutrientBasis, "polyolsPerNutrientBasis",
    /// `Polyunsaturated Fat Per Nutrient Basis Quantity`: Polyunsaturated fat per specified nutrient basis quantity.
    polyunsaturatedFatPerNutrientBasis, "polyunsaturatedFatPerNutrientBasis",
    /// `PO Box Number`: The number that identifies a PO box. A PO box is a box in a post office or other postal service location assigned to an organization where postal items may be kept.
    postOfficeBoxNumber, "postOfficeBoxNumber",
    /// `Postal Code`: Text specifying the postal code for an address.
    postalCode, "postalCode",
    /// `Potassium Per Nutrient Basis Quantity`: Potassium per specified nutrient basis quantity.
    potassiumPerNutrientBasis, "potassiumPerNutrientBasis",
    /// `Preparation Type Code`: Code specifying the preparation state of the product for which the nutrient information is valid. PREPARED, UNPREPARED.
    preparationCode, "preparationCode",
    /// `Preparation Consumption Precautions`: Specifies additional precautions to be taken before preparation or consumption of the product.
    preparationConsumptionPrecautions, "preparationConsumptionPrecautions",
    /// `Has Food And Beverage Preparation Information`: Links to information about how to prepare a specific Food/Beverage/Tobacco product.
    preparationInformation, "preparationInformation",
    /// `Preparation Instructions`: Free text providing instructions on how to prepare the product before serving.
    preparationInstructions, "preparationInstructions",
    /// `Preservation Technique`: Code indicating the preservation technique used to preserve the product from deterioration, for example, BRINING.
    preservationTechnique, "preservationTechnique",
    /// `Price Value`: Provides a price value as a floating-point numeric value that is qualified by the corresponding currency. See also gs1:priceCurrency. The price value indicates the unit price unless the property gs1:eligibleQuantity is specified and indicates multiple units
    price, "price",
    /// `Price Currency`: A string value indicating a currency from ISO 4217 for example USD .
    priceCurrency, "priceCurrency",
    /// `Price Specification`: The price related to an offer. If the offer is a multi-buy offer for a quantity of product greater than one unit, this should be indicated using the property gs1:eligibleQuantity
    priceSpecification, "priceSpecification",
    /// `Has Primary Alternate Product`: A product that is similar to the current product but is not exact match. Same form fit function, e.g. same product different colour, different package size, better quality.
    primaryAlternateProduct, "primaryAlternateProduct",
    /// `Product Description`: An understandable and useable description of a product using brand and other descriptors. This attribute is filled with as little abbreviation as possible, while keeping to a reasonable length.  This should be a meaningful description of the product with full spelling to facilitate message processing. Retailers can use this description as the base to fully understand the brand, flavour, scent etc. of the specific product, in order to accurately create a product description as needed for their internal systems. Examples: XYZ Brand Base Invisible Solid Deodorant AP Stick Spring Breeze.
    productDescription, "productDescription",
    /// `Product Feature Benefit`: Element for consumer facing marketing content to describe the key features or benefits of the style suitable for display purposes.
    productFeatureBenefit, "productFeatureBenefit",
    /// `Product Form Description`: The physical form or shape of the product. Used, for example, in pharmaceutical industry to indicate the formulation of the product. Defines the form the product takes and is distinct from the form of the packaging.
    productFormDescription, "productFormDescription",
    /// `Product ID`: Additional means to the Global Trade Item Number to identify a product.
    productID, "productID",
    /// `Product Marketing Message`: Marketing message associated with the product. Consumer-friendly marketing detailed description of the product.
    productMarketingMessage, "productMarketingMessage",
    /// `Product Name`: Consumer friendly short description of the product suitable for compact presentation.
    productName, "productName",
    /// `Product Passport`: A link to the product passport which provides information on a product’s origin, durability, composition, reuse, repair and dismantling possibilities, and end-of-life handling.
    productPassport, "productPassport",
    /// `Product Range`: A name, used by a Brand Owner, that span multiple consumer categories or uses. E.g. (Waist Watchers).
    productRange, "productRange",
    /// `Sustainability and recycling`: A link to information about the product's sustainability of manufacture, recycling information etc.
    productSustainabilityInfo, "productSustainabilityInfo",
    /// `Product Yield`: Product quantity after preparation. This can differ based on productYieldType
    productYield, "productYield",
    /// `Product Yield Type Code`: Code indicating the type of yield measurement specified in productYield. Examples: AFTER_DILUTION, DRAINED_WEIGHT.
    productYieldType, "productYieldType",
    /// `Product Yield Variation Percentage`: Indication of range in percent of the given cooking / roasting loss. Percentage that the actual weight of the product differs upward or downward from the average or estimated product yield.
    productYieldVariationPercentage, "productYieldVariationPercentage",
    /// `Date of production`: The production date is the production or assembly date determined by the manufacturer. The date may refer to the trade item itself or to items contained.
    productionDate, "productionDate",
    /// `Date and time of production`: The date and time of production (or assembly). The date and time of production is determined by the manufacturer. The date and time may refer to the trade item itself or to the items contained.
    productionDateTime, "productionDateTime",
    /// `Production Variant Description`: Free text assigned by the manufacturer to describe the production variant. Examples are: package series X, package series Y.
    productionVariantDescription, "productionVariantDescription",
    /// `Production Variant Effective Date Time`: The start date of a production variant. The variant applies to products having a date mark (a best before date or expiration date) on the package that comes on or after the effective date.
    productionVariantEffectiveDateTime, "productionVariantEffectiveDateTime",
    /// `Promotion`: A link to a promotion for the product.
    promotion, "promotion",
    /// `Protein Per Nutrient Basis Quantity`: Protein per specified nutrient basis quantity.
    proteinPerNutrientBasis, "proteinPerNutrientBasis",
    /// `Provenance Statement`: Free text description of the region or place the product originates from. This is to be specifically used to specify areas such as cities, mountain ranges, regions. Examples: Made in the Thuringen Mountains, Made in Paris, From the Napa Valley.
    provenanceStatement, "provenanceStatement",
    /// `Purchase supplies or accessories`: A link to information about where supplies or accessories for the item can be purchased or ordered.
    purchaseSuppliesOrAccessories, "purchaseSuppliesOrAccessories",
    /// `Qualifying Brand Name`: If specified, the discount is only available when purchasing a product from one of the brand names specified via this property.
    qualifyingBrandName, "qualifyingBrandName",
    /// `Qualifying Product GPC codes`: If specified, the discount is only available when purchasing a product whose Global Product Classification (GPC) brick value appears in the list specified via this property.
    qualifyingGPCs, "qualifyingGPCs",
    /// `Qualifying Product Category Description`: If specified, the discount is only available when purchasing a product from categories specified in this free-form text field.
    qualifyingProductCategoryDescription, "qualifyingProductCategoryDescription",
    /// `Qualifying Product Classification Code`: If specified, the discount is only available when purchasing a product whose product classification (other than GPC) appears in the list specified via this property. This property specifies a product classification other than GPC.
    qualifyingProductClassificationCode, "qualifyingProductClassificationCode",
    /// `Qualifying Product GTINs`: If specified, the discount is only available when purchasing a product whose GTIN appears in the list specified via this property.
    qualifyingProductGTINs, "qualifyingProductGTINs",
    /// `Qualifying Sub-brand Name`: If specified, the discount is only available when purchasing a product from one of the sub-brand names (specified product ranges for a given brand) specified via this property.
    qualifyingSubBrandName, "qualifyingSubBrandName",
    /// `Quick start guide`: A link to a description of the key features needed to be understood to begin using the item.
    quickStartGuide, "quickStartGuide",
    /// `Recall status`: A link to information about whether the product has been recalled or not, typically an API.
    recallStatus, "recallStatus",
    /// `Recipe website`: A link to a recipe website for the product.
    recipeInfo, "recipeInfo",
    /// `Product recyling`: A link to the instructions for recycling a product.
    recyclingInfo, "recyclingInfo",
    /// `Has Referenced File`: Link to a file or website containing additional information on product.
    referencedFile, "referencedFile",
    /// `Referenced File Effective End Date`: The date upon which the target of this external link ceases to be effective for use.
    referencedFileEffectiveEndDateTime, "referencedFileEffectiveEndDateTime",
    /// `Referenced File Effective Start Date`: The date upon which the target of this external link begins to be effective for use.
    referencedFileEffectiveStartDateTime, "referencedFileEffectiveStartDateTime",
    /// `Referenced File Size`: The size of the file as it is stored in an uncompressed format.
    referencedFileSize, "referencedFileSize",
    /// `Referenced File Type`: A code indicating the purpose or role of file (not a MIME type) that is being referenced, for example PRODUCT_LABEL_IMAGE. This code is used when the purpose of a file is not specified in the property.
    referencedFileType, "referencedFileType",
    /// `Website`: Simple text string that refers to a resource on the internet, URLs may refer to documents, resources, people, etc.
    referencedFileURL, "referencedFileURL",
    /// `Register purchase`: A link to an entry point for registering ownership of a product including for warranty purposes.
    registerProduct, "registerProduct",
    /// `Regulated Product Name`: The prescribed, regulated or generic product name or denomination that describes the true nature of the product. For example for a food product in order to distinguish it from other foods according to country specific regulations.
    regulatedProductName, "regulatedProductName",
    /// `Reheating Claim`: Indicates, with reference to the product branding, labelling or packaging whether a food product which is ready to eat can be reheated if required prior to consumption.
    reheatingClaim, "reheatingClaim",
    /// `Related  video`: A link to any video, or document that has an embedded video, that describes or relates to the identified item in some way.
    relatedVideo, "relatedVideo",
    /// `Product repair`: A link to the instructions for the repair of a product.
    repairInfo, "repairInfo",
    /// `Has Replaced By Product`: The product which permanently replaces the current product. This product is sent in the record for the original item that is being replaced.
    replacedByProduct, "replacedByProduct",
    /// `Has Replaced Product`: Indicates the product identification of an item that is being permanently replaced by this product.
    replacedProduct, "replacedProduct",
    /// `Responsibility`: Text further specifying the area of responsibility of the trade contact.
    responsibility, "responsibility",
    /// `Returnable Package Deposit Amount`: The monetary amount for the individual returnable package.
    returnablePackageDepositAmount, "returnablePackageDepositAmount",
    /// `Returnable Package Deposit Region`: The geographic region associated with the returnable package deposit amount.
    returnablePackageDepositRegion, "returnablePackageDepositRegion",
    /// `Product re-use`: A link to the information on how to re-use a product when it changes from one user to the other (like how to deal with exiting certifications or warrantees, quality control instructions)
    reuseInfo, "reuseInfo",
    /// `Reviews`: A link to reviews of the product or service.
    review, "review",
    /// `Riboflavin Per Nutrient Basis Quantity`: Riboflavin per specified nutrient basis quantity.
    riboflavinPerNutrientBasis, "riboflavinPerNutrientBasis",
    /// `Safety information`: A link to safety information about the item
    safetyInfo, "safetyInfo",
    /// `Salt Per Nutrient Basis Quantity`: Salt per specified nutrient basis quantity.
    saltPerNutrientBasis, "saltPerNutrientBasis",
    /// `Saturated Fat Per Nutrient Basis Quantity`: Saturated fat per specified nutrient basis quantity.
    saturatedFatPerNutrientBasis, "saturatedFatPerNutrientBasis",
    /// `Season Calendar Year`: The calendar year in which the product is seasonally available.
    seasonCalendarYear, "seasonCalendarYear",
    /// `Season Name`: Element defines the season applicable to the item for example Winter.
    seasonName, "seasonName",
    /// `Season Parameter`: Code indicating the season in which the product is available, e.g. SPRING, WINTER
    seasonParameter, "seasonParameter",
    /// `Seeker`: The organization seeking an offer.
    seeker, "seeker",
    /// `Selected Products Only`: If specified and set to true, the discount only applies to specific products selected by the retailer or offer promoter - not to all items in that product category.  This property should be asserted and set to true for offers that say 'on selected products'.
    selectedProductsOnly, "selectedProductsOnly",
    /// `Selenium Per Nutrient Basis Quantity`: Selenium per specified nutrient basis quantity.
    seleniumPerNutrientBasis, "seleniumPerNutrientBasis",
    /// `Sell By Date`: The date specified by the manufacturer as the last date the retailer is to offer the product for sale to the consumer. The product should not be merchandised after this date.
    sellByDate, "sellByDate",
    /// `Seller`: The organization seeking to sell a product or service.
    seller, "seller",
    /// `Service information`: A link to service or maintenance instructions for the item.
    serviceInfo, "serviceInfo",
    /// `Serving Size`: Measurement value specifying the serving size in which the information per nutrient has been stated. Example: Per 100 GRM.
    servingSize, "servingSize",
    /// `Serving Size Description`: A free text field specifying the serving size for which the nutrient information has been stated for example: per 1/3 cup (42 g).
    servingSizeDescription, "servingSizeDescription",
    /// `Serving Suggestion`: Free text field for serving suggestion.
    servingSuggestion, "servingSuggestion",
    /// `Sharpness Of Cheese`: The descriptive term that is used by the product manufacturer to identify the sharpness of the taste of the product for example EXTRA_SHARP. Usually the longer the aging of the product, the sharper the taste.
    sharpnessOfCheese, "sharpnessOfCheese",
    /// `Size`: Links a wearable product to one or more groupings of gs1:SizeDetails representing size systems, size groups, size type and size dimensions.
    size, "size",
    /// `Size Code`: Links a product to one or more groupings of gs1:SizeCodeDetails representing the size value from a specified code list.
    sizeCode, "sizeCode",
    /// `Size Code List Code`: Code specifying a size code list. Allowed code values are specified in GS1 Code List SizeCodeListCode .
    sizeCodeListCode, "sizeCodeListCode",
    /// `Size Code`: A code indicating the size of an object according to a specific code list. The applied code list is specified as additional information together with the size code.
    sizeCodeValue, "sizeCodeValue",
    /// `Size Dimension`: The numerical size measurement relating to the size type.
    sizeDimension, "sizeDimension",
    /// `Size Group`: Code indicating the type of size that is necessary to uniquely specify the size of the item, for example, BOYS.
    sizeGroup, "sizeGroup",
    /// `Size System`: The system that is being used to define the size for example EUROPE. Size system is used in conjunction with size group to define the size dimension.
    sizeSystem, "sizeSystem",
    /// `Size Type`: The type of size dimension being specified for example SLEEVE.
    sizeType, "sizeType",
    /// `SmartLabel`: A link to the product's SmartLabel page.
    smartLabel, "smartLabel",
    /// `Summary Product Characteristics (SmPC)`: A link to Summary Product Characteristics. To be used specifically when linking to information for healthcare professionals.
    smpc, "smpc",
    /// `Social media`: A link to a social media channel. The title will typically be replaced by the name of the channel.
    socialMedia, "socialMedia",
    /// `Sodium Per Nutrient Basis Quantity`: Sodium per specified nutrient basis quantity.
    sodiumPerNutrientBasis, "sodiumPerNutrientBasis",
    /// `Source Animal Code`: Code indicating the source of raw material used to produce the food product, for example a GOAT for milk.
    sourceAnimal, "sourceAnimal",
    /// `Sporting Activity Type`: Code indicating the type of sporting activity for which the product is intended to be worn, for example FOOTBALL.
    sportingActivityType, "sportingActivityType",
    /// `Starch Per Nutrient Basis Quantity`: Starch per specified nutrient basis quantity.
    starchPerNutrientBasis, "starchPerNutrientBasis",
    /// `Street Address`: The street address expressed as free form text. The street address is printed on paper as the first lines below the name. For example, the name of the street and the number in the street or the name of a building.
    streetAddress, "streetAddress",
    /// `Style Description`: An attribute that classifies products that share many of the same characteristics (attribute values) that does NOT vary by GTIN, and are presented by the supplier as a single merchandise selection for the buyer.
    styleDescription, "styleDescription",
    /// `Sub-brand Name`: Second level of brand. Can be a trademark. It is the primary differentiating factor that a brand owner wants to communicate to the consumer or buyer. E.g. Yummy-Cola Classic. In this example Yummy-Cola is the brand and Classic is the sub-brand.
    subBrandName, "subBrandName",
    /// `Sugars Per Nutrient Basis Quantity`: Sugars per specified nutrient basis quantity.
    sugarsPerNutrientBasis, "sugarsPerNutrientBasis",
    /// `Supplier Specified Minimum Consumer Storage Days`: Represents the number of days between a product's sell by date and its use by date.
    supplierSpecifiedMinimumConsumerStorageDays, "supplierSpecifiedMinimumConsumerStorageDays",
    /// `Support`: A link to a source of support such as a helpdesk, chat support, email etc.
    support, "support",
    /// `Target Consumer Age`: Identifies the target consumer age range for which a product has been designed.
    targetConsumerAge, "targetConsumerAge",
    /// `Target Consumer Gender`: Identifies the target consumer gender for which a product has been designed for example MALE
    targetConsumerGender, "targetConsumerGender",
    /// `Has Target Market`: Relates to a set of target market details (product release date and associated countries)
    targetMarket, "targetMarket",
    /// `Target Market Countries`: List of countries representing the target market for a particular release date indicated by gs1:consumerFirstAvailabilityDateTime
    targetMarketCountries, "targetMarketCountries",
    /// `Telephone`: A telephone number for example +44 217 992 9999.
    telephone, "telephone",
    /// `Has Textile Material`: One or more links to information about the materials used in a wearable product.
    textileMaterial, "textileMaterial",
    /// `Textile Material Content`: A description of the material composition used in conjunction with the material percentage.
    textileMaterialContent, "textileMaterialContent",
    /// `Textile Description`: This provides a name or brief description of one material contained within the product, for example Rayon.
    textileMaterialDescription, "textileMaterialDescription",
    /// `Textile Material Percentage`: Corresponding net weight percentage of the product material specified via gs1:textileMaterialDescription, e.g. 70.
    textileMaterialPercentage, "textileMaterialPercentage",
    /// `Textile Material Thread Count`: The quality of material (fabric) of a product based on the total number of vertical and horizontal threads in one square inch.
    textileMaterialThreadCount, "textileMaterialThreadCount",
    /// `Textile Material Weight`: The measured weight of the material expressed in ounces per square yard or grams per square meter.
    textileMaterialWeight, "textileMaterialWeight",
    /// `Thiamin Per Nutrient Basis Quantity`: Thiamin per specified nutrient basis quantity.
    thiaminPerNutrientBasis, "thiaminPerNutrientBasis",
    /// `Traceability information`: A link to traceability information about the product (includes track & trace).
    traceability, "traceability",
    /// `Trans Fat Per Nutrient Basis Quantity`: Trans Fat per specified nutrient basis quantity.
    transFatPerNutrientBasis, "transFatPerNutrientBasis",
    /// `Tutorial`: A link to a tutorial or set of tutorials, such as online classes, how-to videos etc.
    tutorial, "tutorial",
    /// `Measurement Unit`: A string value indicating a Measurement Unit from UN/ECE Recommendation 20, Units of Measure used in International Trade e.g. GRM = gram - see http://www.unece.org/fileadmin/DAM/cefact/recommendations/rec20/rec20_rev3_Annex3e.pdf
    unitCode, "unitCode",
    /// `Has Upper Material`: The material(s) used for the upper part of the footwear product. The upper is the part of a shoe, boot, slipper or other item of footwear that is above the sole.
    upperMaterialType, "upperMaterialType",
    /// `Valid From`: The effective start date of the price .
    validFrom, "validFrom",
    /// `Valid Through`: The effective end date of the price .
    validThrough, "validThrough",
    /// `Measurement Value`: A floating-point numeric value that is qualified by the corresponding measurement unit code - see gs1:unitCode
    value, "value",
    /// `Variant Description`: Free text field used to identify the variant of the product. Variants are the distinguishing characteristics that differentiate products with the same brand and size including such things as the particular flavour, fragrance, taste.
    variantDescription, "variantDescription",
    /// `Verification Service`: A link to a GS1 Lightweight Messaging Service for verifying the status of a product and its identifier . 
    verificationService, "verificationService",
    /// `Vintner`: The person hired by a winery or wine company who is responsible for many of the processes in the preparation, taste and quality of the wine produced. The science of wine making is referred to as oenology. The vintner is the oenologist.
    vintner, "vintner",
    /// `Vitamin A Per Nutrient Basis Quantity`: Vitamin A per specified nutrient basis quantity.
    vitaminAPerNutrientBasis, "vitaminAPerNutrientBasis",
    /// `Vitamin B12 Per Nutrient Basis Quantity`: Vitamin B12 per specified nutrient basis quantity.
    vitaminB12PerNutrientBasis, "vitaminB12PerNutrientBasis",
    /// `Vitamin B6 Per Nutrient Basis Quantity`: Vitamin B6 per specified nutrient basis quantity.
    vitaminB6PerNutrientBasis, "vitaminB6PerNutrientBasis",
    /// `Vitamin C Per Nutrient Basis Quantity`: Vitamin C per specified nutrient basis quantity.
    vitaminCPerNutrientBasis, "vitaminCPerNutrientBasis",
    /// `Vitamin D Per Nutrient Basis Quantity`: Vitamin D per specified nutrient basis quantity.
    vitaminDPerNutrientBasis, "vitaminDPerNutrientBasis",
    /// `Vitamin E Per Nutrient Basis Quantity`: Vitamin E per specified nutrient basis quantity.
    vitaminEPerNutrientBasis, "vitaminEPerNutrientBasis",
    /// `Vitamin K Per Nutrient Basis Quantity`: Vitamin K per specified nutrient basis quantity.
    vitaminKPerNutrientBasis, "vitaminKPerNutrientBasis",
    /// `Warning Copy Description`: Warning information is additional information that outlines special requirements, warning and caution information printed on the package.
    warningCopyDescription, "warningCopyDescription",
    /// `Has Offer Warranty`: The warranty associated with the product, as provided by the manufacturer.
    warranty, "warranty",
    /// `Warranty Scope`: The description of warranty available for the product. Allows for the representation of the same value in different languages but not for multiple values.
    warrantyScopeDescription, "warrantyScopeDescription",
    /// `What's in the box?`: A link to a description of all the individual items in a packaged item.
    whatsInTheBox, "whatsInTheBox",
    /// `Yield`: Product quantity after preparation.
    yield_, "yield",
    /// `Zinc Per Nutrient Basis Quantity`: Zinc per specified nutrient basis quantity.
    zincPerNutrientBasis, "zincPerNutrientBasis"
);
