use serde::{Deserialize, Serialize};

#[derive(Debug, Serialize, Deserialize)]
pub struct DeployConfig {
    pub(crate) listen_address: String,
    pub(crate) listen_port: u32,
    #[serde(rename = "security-key")]
    pub(crate) security_key: Option<String>,
    pub(crate) on_push: Option<Vec<String>>,
}

impl Default for DeployConfig {
    fn default() -> Self {
        Self {
            listen_address: "127.0.0.1".into(),
            listen_port: 4200,
            on_push: None,
            security_key: None,
        }
    }
}
