/* automatically generated by rust-bindgen 0.58.1 */

//! Defines the FFI for CUDA cuDNN.
//!
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]

pub const CUDNN_MAJOR: u32 = 8;
pub const CUDNN_MINOR: u32 = 2;
pub const CUDNN_PATCHLEVEL: u32 = 2;
pub const CUDNN_VERSION: u32 = 8202;
pub const CUDNN_OPS_INFER_MAJOR: u32 = 8;
pub const CUDNN_OPS_INFER_MINOR: u32 = 2;
pub const CUDNN_OPS_INFER_PATCH: u32 = 2;
pub const CUDNN_DIM_MAX: u32 = 8;
pub const CUDNN_LRN_MIN_N: u32 = 1;
pub const CUDNN_LRN_MAX_N: u32 = 16;
pub const CUDNN_LRN_MIN_K: f64 = 0.00001;
pub const CUDNN_LRN_MIN_BETA: f64 = 0.01;
pub const CUDNN_BN_MIN_EPSILON: f64 = 0.0;
pub const CUDNN_OPS_TRAIN_MAJOR: u32 = 8;
pub const CUDNN_OPS_TRAIN_MINOR: u32 = 2;
pub const CUDNN_OPS_TRAIN_PATCH: u32 = 2;
pub const CUDNN_ADV_INFER_MAJOR: u32 = 8;
pub const CUDNN_ADV_INFER_MINOR: u32 = 2;
pub const CUDNN_ADV_INFER_PATCH: u32 = 2;
pub const CUDNN_RNN_PADDED_IO_DISABLED: u32 = 0;
pub const CUDNN_RNN_PADDED_IO_ENABLED: u32 = 1;
pub const CUDNN_SEQDATA_DIM_COUNT: u32 = 4;
pub const CUDNN_ATTN_QUERYMAP_ALL_TO_ONE: u32 = 0;
pub const CUDNN_ATTN_QUERYMAP_ONE_TO_ONE: u32 = 1;
pub const CUDNN_ATTN_DISABLE_PROJ_BIASES: u32 = 0;
pub const CUDNN_ATTN_ENABLE_PROJ_BIASES: u32 = 2;
pub const CUDNN_ATTN_WKIND_COUNT: u32 = 8;
pub const CUDNN_ADV_TRAIN_MAJOR: u32 = 8;
pub const CUDNN_ADV_TRAIN_MINOR: u32 = 2;
pub const CUDNN_ADV_TRAIN_PATCH: u32 = 2;
pub const CUDNN_CNN_INFER_MAJOR: u32 = 8;
pub const CUDNN_CNN_INFER_MINOR: u32 = 2;
pub const CUDNN_CNN_INFER_PATCH: u32 = 2;
pub const CUDNN_CNN_TRAIN_MAJOR: u32 = 8;
pub const CUDNN_CNN_TRAIN_MINOR: u32 = 2;
pub const CUDNN_CNN_TRAIN_PATCH: u32 = 2;
#[repr(u32)]
#[non_exhaustive]
#[doc = "                                                                              *"]
#[doc = "                                                                              *"]
#[doc = "                                                                              *"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaRoundMode {
    cudaRoundNearest = 0,
    cudaRoundZero = 1,
    cudaRoundPosInf = 2,
    cudaRoundMinInf = 3,
}
#[doc = "                                                                              *"]
#[doc = "                                                                              *"]
#[doc = "                                                                              *"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dim3 {
    pub x: ::libc::c_uint,
    pub y: ::libc::c_uint,
    pub z: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout_dim3() {
    assert_eq!(
        ::std::mem::size_of::<dim3>(),
        12usize,
        concat!("Size of: ", stringify!(dim3))
    );
    assert_eq!(
        ::std::mem::align_of::<dim3>(),
        4usize,
        concat!("Alignment of ", stringify!(dim3))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dim3>())).x as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(dim3), "::", stringify!(x))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dim3>())).y as *const _ as usize },
        4usize,
        concat!("Offset of field: ", stringify!(dim3), "::", stringify!(y))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dim3>())).z as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(dim3), "::", stringify!(z))
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA error types"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaError {
    #[doc = " The API call returned with no errors. In the case of query calls, this"]
    #[doc = " also means that the operation being queried is complete (see"]
    #[doc = " ::cudaEventQuery() and ::cudaStreamQuery())."]
    cudaSuccess = 0,
    #[doc = " This indicates that one or more of the parameters passed to the API call"]
    #[doc = " is not within an acceptable range of values."]
    cudaErrorInvalidValue = 1,
    #[doc = " The API call failed because it was unable to allocate enough memory to"]
    #[doc = " perform the requested operation."]
    cudaErrorMemoryAllocation = 2,
    #[doc = " The API call failed because the CUDA driver and runtime could not be"]
    #[doc = " initialized."]
    cudaErrorInitializationError = 3,
    #[doc = " This indicates that a CUDA Runtime API call cannot be executed because"]
    #[doc = " it is being called during process shut down, at a point in time after"]
    #[doc = " CUDA driver has been unloaded."]
    cudaErrorCudartUnloading = 4,
    #[doc = " This indicates profiler is not initialized for this run. This can"]
    #[doc = " happen when the application is running with external profiling tools"]
    #[doc = " like visual profiler."]
    cudaErrorProfilerDisabled = 5,
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 5.0. It is no longer an error"]
    #[doc = " to attempt to enable/disable the profiling via ::cudaProfilerStart or"]
    #[doc = " ::cudaProfilerStop without initialization."]
    cudaErrorProfilerNotInitialized = 6,
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 5.0. It is no longer an error"]
    #[doc = " to call cudaProfilerStart() when profiling is already enabled."]
    cudaErrorProfilerAlreadyStarted = 7,
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 5.0. It is no longer an error"]
    #[doc = " to call cudaProfilerStop() when profiling is already disabled."]
    cudaErrorProfilerAlreadyStopped = 8,
    #[doc = " This indicates that a kernel launch is requesting resources that can"]
    #[doc = " never be satisfied by the current device. Requesting more shared memory"]
    #[doc = " per block than the device supports will trigger this error, as will"]
    #[doc = " requesting too many threads or blocks. See ::cudaDeviceProp for more"]
    #[doc = " device limitations."]
    cudaErrorInvalidConfiguration = 9,
    #[doc = " This indicates that one or more of the pitch-related parameters passed"]
    #[doc = " to the API call is not within the acceptable range for pitch."]
    cudaErrorInvalidPitchValue = 12,
    #[doc = " This indicates that the symbol name/identifier passed to the API call"]
    #[doc = " is not a valid name or identifier."]
    cudaErrorInvalidSymbol = 13,
    #[doc = " This indicates that at least one host pointer passed to the API call is"]
    #[doc = " not a valid host pointer."]
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 10.1."]
    cudaErrorInvalidHostPointer = 16,
    #[doc = " This indicates that at least one device pointer passed to the API call is"]
    #[doc = " not a valid device pointer."]
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 10.1."]
    cudaErrorInvalidDevicePointer = 17,
    #[doc = " This indicates that the texture passed to the API call is not a valid"]
    #[doc = " texture."]
    cudaErrorInvalidTexture = 18,
    #[doc = " This indicates that the texture binding is not valid. This occurs if you"]
    #[doc = " call ::cudaGetTextureAlignmentOffset() with an unbound texture."]
    cudaErrorInvalidTextureBinding = 19,
    #[doc = " This indicates that the channel descriptor passed to the API call is not"]
    #[doc = " valid. This occurs if the format is not one of the formats specified by"]
    #[doc = " ::cudaChannelFormatKind, or if one of the dimensions is invalid."]
    cudaErrorInvalidChannelDescriptor = 20,
    #[doc = " This indicates that the direction of the memcpy passed to the API call is"]
    #[doc = " not one of the types specified by ::cudaMemcpyKind."]
    cudaErrorInvalidMemcpyDirection = 21,
    #[doc = " This indicated that the user has taken the address of a constant variable,"]
    #[doc = " which was forbidden up until the CUDA 3.1 release."]
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 3.1. Variables in constant"]
    #[doc = " memory may now have their address taken by the runtime via"]
    #[doc = " ::cudaGetSymbolAddress()."]
    cudaErrorAddressOfConstant = 22,
    #[doc = " This indicated that a texture fetch was not able to be performed."]
    #[doc = " This was previously used for device emulation of texture operations."]
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 3.1. Device emulation mode was"]
    #[doc = " removed with the CUDA 3.1 release."]
    cudaErrorTextureFetchFailed = 23,
    #[doc = " This indicated that a texture was not bound for access."]
    #[doc = " This was previously used for device emulation of texture operations."]
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 3.1. Device emulation mode was"]
    #[doc = " removed with the CUDA 3.1 release."]
    cudaErrorTextureNotBound = 24,
    #[doc = " This indicated that a synchronization operation had failed."]
    #[doc = " This was previously used for some device emulation functions."]
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 3.1. Device emulation mode was"]
    #[doc = " removed with the CUDA 3.1 release."]
    cudaErrorSynchronizationError = 25,
    #[doc = " This indicates that a non-float texture was being accessed with linear"]
    #[doc = " filtering. This is not supported by CUDA."]
    cudaErrorInvalidFilterSetting = 26,
    #[doc = " This indicates that an attempt was made to read a non-float texture as a"]
    #[doc = " normalized float. This is not supported by CUDA."]
    cudaErrorInvalidNormSetting = 27,
    #[doc = " Mixing of device and device emulation code was not allowed."]
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 3.1. Device emulation mode was"]
    #[doc = " removed with the CUDA 3.1 release."]
    cudaErrorMixedDeviceExecution = 28,
    #[doc = " This indicates that the API call is not yet implemented. Production"]
    #[doc = " releases of CUDA will never return this error."]
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 4.1."]
    cudaErrorNotYetImplemented = 31,
    #[doc = " This indicated that an emulated device pointer exceeded the 32-bit address"]
    #[doc = " range."]
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 3.1. Device emulation mode was"]
    #[doc = " removed with the CUDA 3.1 release."]
    cudaErrorMemoryValueTooLarge = 32,
    #[doc = " This indicates that the CUDA driver that the application has loaded is a"]
    #[doc = " stub library. Applications that run with the stub rather than a real"]
    #[doc = " driver loaded will result in CUDA API returning this error."]
    cudaErrorStubLibrary = 34,
    #[doc = " This indicates that the installed NVIDIA CUDA driver is older than the"]
    #[doc = " CUDA runtime library. This is not a supported configuration. Users should"]
    #[doc = " install an updated NVIDIA display driver to allow the application to run."]
    cudaErrorInsufficientDriver = 35,
    #[doc = " This indicates that the API call requires a newer CUDA driver than the one"]
    #[doc = " currently installed. Users should install an updated NVIDIA CUDA driver"]
    #[doc = " to allow the API call to succeed."]
    cudaErrorCallRequiresNewerDriver = 36,
    #[doc = " This indicates that the surface passed to the API call is not a valid"]
    #[doc = " surface."]
    cudaErrorInvalidSurface = 37,
    #[doc = " This indicates that multiple global or constant variables (across separate"]
    #[doc = " CUDA source files in the application) share the same string name."]
    cudaErrorDuplicateVariableName = 43,
    #[doc = " This indicates that multiple textures (across separate CUDA source"]
    #[doc = " files in the application) share the same string name."]
    cudaErrorDuplicateTextureName = 44,
    #[doc = " This indicates that multiple surfaces (across separate CUDA source"]
    #[doc = " files in the application) share the same string name."]
    cudaErrorDuplicateSurfaceName = 45,
    #[doc = " This indicates that all CUDA devices are busy or unavailable at the current"]
    #[doc = " time. Devices are often busy/unavailable due to use of"]
    #[doc = " ::cudaComputeModeExclusive, ::cudaComputeModeProhibited or when long"]
    #[doc = " running CUDA kernels have filled up the GPU and are blocking new work"]
    #[doc = " from starting. They can also be unavailable due to memory constraints"]
    #[doc = " on a device that already has active CUDA work being performed."]
    cudaErrorDevicesUnavailable = 46,
    #[doc = " This indicates that the current context is not compatible with this"]
    #[doc = " the CUDA Runtime. This can only occur if you are using CUDA"]
    #[doc = " Runtime/Driver interoperability and have created an existing Driver"]
    #[doc = " context using the driver API. The Driver context may be incompatible"]
    #[doc = " either because the Driver context was created using an older version"]
    #[doc = " of the API, because the Runtime API call expects a primary driver"]
    #[doc = " context and the Driver context is not primary, or because the Driver"]
    #[doc = " context has been destroyed. Please see \\ref CUDART_DRIVER \"Interactions"]
    #[doc = " with the CUDA Driver API\" for more information."]
    cudaErrorIncompatibleDriverContext = 49,
    #[doc = " The device function being invoked (usually via ::cudaLaunchKernel()) was not"]
    #[doc = " previously configured via the ::cudaConfigureCall() function."]
    cudaErrorMissingConfiguration = 52,
    #[doc = " This indicated that a previous kernel launch failed. This was previously"]
    #[doc = " used for device emulation of kernel launches."]
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 3.1. Device emulation mode was"]
    #[doc = " removed with the CUDA 3.1 release."]
    cudaErrorPriorLaunchFailure = 53,
    #[doc = " This error indicates that a device runtime grid launch did not occur"]
    #[doc = " because the depth of the child grid would exceed the maximum supported"]
    #[doc = " number of nested grid launches."]
    cudaErrorLaunchMaxDepthExceeded = 65,
    #[doc = " This error indicates that a grid launch did not occur because the kernel"]
    #[doc = " uses file-scoped textures which are unsupported by the device runtime."]
    #[doc = " Kernels launched via the device runtime only support textures created with"]
    #[doc = " the Texture Object API's."]
    cudaErrorLaunchFileScopedTex = 66,
    #[doc = " This error indicates that a grid launch did not occur because the kernel"]
    #[doc = " uses file-scoped surfaces which are unsupported by the device runtime."]
    #[doc = " Kernels launched via the device runtime only support surfaces created with"]
    #[doc = " the Surface Object API's."]
    cudaErrorLaunchFileScopedSurf = 67,
    #[doc = " This error indicates that a call to ::cudaDeviceSynchronize made from"]
    #[doc = " the device runtime failed because the call was made at grid depth greater"]
    #[doc = " than than either the default (2 levels of grids) or user specified device"]
    #[doc = " limit ::cudaLimitDevRuntimeSyncDepth. To be able to synchronize on"]
    #[doc = " launched grids at a greater depth successfully, the maximum nested"]
    #[doc = " depth at which ::cudaDeviceSynchronize will be called must be specified"]
    #[doc = " with the ::cudaLimitDevRuntimeSyncDepth limit to the ::cudaDeviceSetLimit"]
    #[doc = " api before the host-side launch of a kernel using the device runtime."]
    #[doc = " Keep in mind that additional levels of sync depth require the runtime"]
    #[doc = " to reserve large amounts of device memory that cannot be used for"]
    #[doc = " user allocations."]
    cudaErrorSyncDepthExceeded = 68,
    #[doc = " This error indicates that a device runtime grid launch failed because"]
    #[doc = " the launch would exceed the limit ::cudaLimitDevRuntimePendingLaunchCount."]
    #[doc = " For this launch to proceed successfully, ::cudaDeviceSetLimit must be"]
    #[doc = " called to set the ::cudaLimitDevRuntimePendingLaunchCount to be higher"]
    #[doc = " than the upper bound of outstanding launches that can be issued to the"]
    #[doc = " device runtime. Keep in mind that raising the limit of pending device"]
    #[doc = " runtime launches will require the runtime to reserve device memory that"]
    #[doc = " cannot be used for user allocations."]
    cudaErrorLaunchPendingCountExceeded = 69,
    #[doc = " The requested device function does not exist or is not compiled for the"]
    #[doc = " proper device architecture."]
    cudaErrorInvalidDeviceFunction = 98,
    #[doc = " This indicates that no CUDA-capable devices were detected by the installed"]
    #[doc = " CUDA driver."]
    cudaErrorNoDevice = 100,
    #[doc = " This indicates that the device ordinal supplied by the user does not"]
    #[doc = " correspond to a valid CUDA device or that the action requested is"]
    #[doc = " invalid for the specified device."]
    cudaErrorInvalidDevice = 101,
    #[doc = " This indicates that the device doesn't have a valid Grid License."]
    cudaErrorDeviceNotLicensed = 102,
    #[doc = " By default, the CUDA runtime may perform a minimal set of self-tests,"]
    #[doc = " as well as CUDA driver tests, to establish the validity of both."]
    #[doc = " Introduced in CUDA 11.2, this error return indicates that at least one"]
    #[doc = " of these tests has failed and the validity of either the runtime"]
    #[doc = " or the driver could not be established."]
    cudaErrorSoftwareValidityNotEstablished = 103,
    #[doc = " This indicates an internal startup failure in the CUDA runtime."]
    cudaErrorStartupFailure = 127,
    #[doc = " This indicates that the device kernel image is invalid."]
    cudaErrorInvalidKernelImage = 200,
    #[doc = " This most frequently indicates that there is no context bound to the"]
    #[doc = " current thread. This can also be returned if the context passed to an"]
    #[doc = " API call is not a valid handle (such as a context that has had"]
    #[doc = " ::cuCtxDestroy() invoked on it). This can also be returned if a user"]
    #[doc = " mixes different API versions (i.e. 3010 context with 3020 API calls)."]
    #[doc = " See ::cuCtxGetApiVersion() for more details."]
    cudaErrorDeviceUninitialized = 201,
    #[doc = " This indicates that the buffer object could not be mapped."]
    cudaErrorMapBufferObjectFailed = 205,
    #[doc = " This indicates that the buffer object could not be unmapped."]
    cudaErrorUnmapBufferObjectFailed = 206,
    #[doc = " This indicates that the specified array is currently mapped and thus"]
    #[doc = " cannot be destroyed."]
    cudaErrorArrayIsMapped = 207,
    #[doc = " This indicates that the resource is already mapped."]
    cudaErrorAlreadyMapped = 208,
    #[doc = " This indicates that there is no kernel image available that is suitable"]
    #[doc = " for the device. This can occur when a user specifies code generation"]
    #[doc = " options for a particular CUDA source file that do not include the"]
    #[doc = " corresponding device configuration."]
    cudaErrorNoKernelImageForDevice = 209,
    #[doc = " This indicates that a resource has already been acquired."]
    cudaErrorAlreadyAcquired = 210,
    #[doc = " This indicates that a resource is not mapped."]
    cudaErrorNotMapped = 211,
    #[doc = " This indicates that a mapped resource is not available for access as an"]
    #[doc = " array."]
    cudaErrorNotMappedAsArray = 212,
    #[doc = " This indicates that a mapped resource is not available for access as a"]
    #[doc = " pointer."]
    cudaErrorNotMappedAsPointer = 213,
    #[doc = " This indicates that an uncorrectable ECC error was detected during"]
    #[doc = " execution."]
    cudaErrorECCUncorrectable = 214,
    #[doc = " This indicates that the ::cudaLimit passed to the API call is not"]
    #[doc = " supported by the active device."]
    cudaErrorUnsupportedLimit = 215,
    #[doc = " This indicates that a call tried to access an exclusive-thread device that"]
    #[doc = " is already in use by a different thread."]
    cudaErrorDeviceAlreadyInUse = 216,
    #[doc = " This error indicates that P2P access is not supported across the given"]
    #[doc = " devices."]
    cudaErrorPeerAccessUnsupported = 217,
    #[doc = " A PTX compilation failed. The runtime may fall back to compiling PTX if"]
    #[doc = " an application does not contain a suitable binary for the current device."]
    cudaErrorInvalidPtx = 218,
    #[doc = " This indicates an error with the OpenGL or DirectX context."]
    cudaErrorInvalidGraphicsContext = 219,
    #[doc = " This indicates that an uncorrectable NVLink error was detected during the"]
    #[doc = " execution."]
    cudaErrorNvlinkUncorrectable = 220,
    #[doc = " This indicates that the PTX JIT compiler library was not found. The JIT Compiler"]
    #[doc = " library is used for PTX compilation. The runtime may fall back to compiling PTX"]
    #[doc = " if an application does not contain a suitable binary for the current device."]
    cudaErrorJitCompilerNotFound = 221,
    #[doc = " This indicates that the provided PTX was compiled with an unsupported toolchain."]
    #[doc = " The most common reason for this, is the PTX was generated by a compiler newer"]
    #[doc = " than what is supported by the CUDA driver and PTX JIT compiler."]
    cudaErrorUnsupportedPtxVersion = 222,
    #[doc = " This indicates that the JIT compilation was disabled. The JIT compilation compiles"]
    #[doc = " PTX. The runtime may fall back to compiling PTX if an application does not contain"]
    #[doc = " a suitable binary for the current device."]
    cudaErrorJitCompilationDisabled = 223,
    #[doc = " This indicates that the provided execution affinity is not supported by the device."]
    cudaErrorUnsupportedExecAffinity = 224,
    #[doc = " This indicates that the device kernel source is invalid."]
    cudaErrorInvalidSource = 300,
    #[doc = " This indicates that the file specified was not found."]
    cudaErrorFileNotFound = 301,
    #[doc = " This indicates that a link to a shared object failed to resolve."]
    cudaErrorSharedObjectSymbolNotFound = 302,
    #[doc = " This indicates that initialization of a shared object failed."]
    cudaErrorSharedObjectInitFailed = 303,
    #[doc = " This error indicates that an OS call failed."]
    cudaErrorOperatingSystem = 304,
    #[doc = " This indicates that a resource handle passed to the API call was not"]
    #[doc = " valid. Resource handles are opaque types like ::cudaStream_t and"]
    #[doc = " ::cudaEvent_t."]
    cudaErrorInvalidResourceHandle = 400,
    #[doc = " This indicates that a resource required by the API call is not in a"]
    #[doc = " valid state to perform the requested operation."]
    cudaErrorIllegalState = 401,
    #[doc = " This indicates that a named symbol was not found. Examples of symbols"]
    #[doc = " are global/constant variable names, driver function names, texture names,"]
    #[doc = " and surface names."]
    cudaErrorSymbolNotFound = 500,
    #[doc = " This indicates that asynchronous operations issued previously have not"]
    #[doc = " completed yet. This result is not actually an error, but must be indicated"]
    #[doc = " differently than ::cudaSuccess (which indicates completion). Calls that"]
    #[doc = " may return this value include ::cudaEventQuery() and ::cudaStreamQuery()."]
    cudaErrorNotReady = 600,
    #[doc = " The device encountered a load or store instruction on an invalid memory address."]
    #[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
    #[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
    #[doc = " and relaunched."]
    cudaErrorIllegalAddress = 700,
    #[doc = " This indicates that a launch did not occur because it did not have"]
    #[doc = " appropriate resources. Although this error is similar to"]
    #[doc = " ::cudaErrorInvalidConfiguration, this error usually indicates that the"]
    #[doc = " user has attempted to pass too many arguments to the device kernel, or the"]
    #[doc = " kernel launch specifies too many threads for the kernel's register count."]
    cudaErrorLaunchOutOfResources = 701,
    #[doc = " This indicates that the device kernel took too long to execute. This can"]
    #[doc = " only occur if timeouts are enabled - see the device property"]
    #[doc = " \\ref ::cudaDeviceProp::kernelExecTimeoutEnabled \"kernelExecTimeoutEnabled\""]
    #[doc = " for more information."]
    #[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
    #[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
    #[doc = " and relaunched."]
    cudaErrorLaunchTimeout = 702,
    #[doc = " This error indicates a kernel launch that uses an incompatible texturing"]
    #[doc = " mode."]
    cudaErrorLaunchIncompatibleTexturing = 703,
    #[doc = " This error indicates that a call to ::cudaDeviceEnablePeerAccess() is"]
    #[doc = " trying to re-enable peer addressing on from a context which has already"]
    #[doc = " had peer addressing enabled."]
    cudaErrorPeerAccessAlreadyEnabled = 704,
    #[doc = " This error indicates that ::cudaDeviceDisablePeerAccess() is trying to"]
    #[doc = " disable peer addressing which has not been enabled yet via"]
    #[doc = " ::cudaDeviceEnablePeerAccess()."]
    cudaErrorPeerAccessNotEnabled = 705,
    #[doc = " This indicates that the user has called ::cudaSetValidDevices(),"]
    #[doc = " ::cudaSetDeviceFlags(), ::cudaD3D9SetDirect3DDevice(),"]
    #[doc = " ::cudaD3D10SetDirect3DDevice, ::cudaD3D11SetDirect3DDevice(), or"]
    #[doc = " ::cudaVDPAUSetVDPAUDevice() after initializing the CUDA runtime by"]
    #[doc = " calling non-device management operations (allocating memory and"]
    #[doc = " launching kernels are examples of non-device management operations)."]
    #[doc = " This error can also be returned if using runtime/driver"]
    #[doc = " interoperability and there is an existing ::CUcontext active on the"]
    #[doc = " host thread."]
    cudaErrorSetOnActiveProcess = 708,
    #[doc = " This error indicates that the context current to the calling thread"]
    #[doc = " has been destroyed using ::cuCtxDestroy, or is a primary context which"]
    #[doc = " has not yet been initialized."]
    cudaErrorContextIsDestroyed = 709,
    #[doc = " An assert triggered in device code during kernel execution. The device"]
    #[doc = " cannot be used again. All existing allocations are invalid. To continue"]
    #[doc = " using CUDA, the process must be terminated and relaunched."]
    cudaErrorAssert = 710,
    #[doc = " This error indicates that the hardware resources required to enable"]
    #[doc = " peer access have been exhausted for one or more of the devices"]
    #[doc = " passed to ::cudaEnablePeerAccess()."]
    cudaErrorTooManyPeers = 711,
    #[doc = " This error indicates that the memory range passed to ::cudaHostRegister()"]
    #[doc = " has already been registered."]
    cudaErrorHostMemoryAlreadyRegistered = 712,
    #[doc = " This error indicates that the pointer passed to ::cudaHostUnregister()"]
    #[doc = " does not correspond to any currently registered memory region."]
    cudaErrorHostMemoryNotRegistered = 713,
    #[doc = " Device encountered an error in the call stack during kernel execution,"]
    #[doc = " possibly due to stack corruption or exceeding the stack size limit."]
    #[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
    #[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
    #[doc = " and relaunched."]
    cudaErrorHardwareStackError = 714,
    #[doc = " The device encountered an illegal instruction during kernel execution"]
    #[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
    #[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
    #[doc = " and relaunched."]
    cudaErrorIllegalInstruction = 715,
    #[doc = " The device encountered a load or store instruction"]
    #[doc = " on a memory address which is not aligned."]
    #[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
    #[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
    #[doc = " and relaunched."]
    cudaErrorMisalignedAddress = 716,
    #[doc = " While executing a kernel, the device encountered an instruction"]
    #[doc = " which can only operate on memory locations in certain address spaces"]
    #[doc = " (global, shared, or local), but was supplied a memory address not"]
    #[doc = " belonging to an allowed address space."]
    #[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
    #[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
    #[doc = " and relaunched."]
    cudaErrorInvalidAddressSpace = 717,
    #[doc = " The device encountered an invalid program counter."]
    #[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
    #[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
    #[doc = " and relaunched."]
    cudaErrorInvalidPc = 718,
    #[doc = " An exception occurred on the device while executing a kernel. Common"]
    #[doc = " causes include dereferencing an invalid device pointer and accessing"]
    #[doc = " out of bounds shared memory. Less common cases can be system specific - more"]
    #[doc = " information about these cases can be found in the system specific user guide."]
    #[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
    #[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
    #[doc = " and relaunched."]
    cudaErrorLaunchFailure = 719,
    #[doc = " This error indicates that the number of blocks launched per grid for a kernel that was"]
    #[doc = " launched via either ::cudaLaunchCooperativeKernel or ::cudaLaunchCooperativeKernelMultiDevice"]
    #[doc = " exceeds the maximum number of blocks as allowed by ::cudaOccupancyMaxActiveBlocksPerMultiprocessor"]
    #[doc = " or ::cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags times the number of multiprocessors"]
    #[doc = " as specified by the device attribute ::cudaDevAttrMultiProcessorCount."]
    cudaErrorCooperativeLaunchTooLarge = 720,
    #[doc = " This error indicates the attempted operation is not permitted."]
    cudaErrorNotPermitted = 800,
    #[doc = " This error indicates the attempted operation is not supported"]
    #[doc = " on the current system or device."]
    cudaErrorNotSupported = 801,
    #[doc = " This error indicates that the system is not yet ready to start any CUDA"]
    #[doc = " work.  To continue using CUDA, verify the system configuration is in a"]
    #[doc = " valid state and all required driver daemons are actively running."]
    #[doc = " More information about this error can be found in the system specific"]
    #[doc = " user guide."]
    cudaErrorSystemNotReady = 802,
    #[doc = " This error indicates that there is a mismatch between the versions of"]
    #[doc = " the display driver and the CUDA driver. Refer to the compatibility documentation"]
    #[doc = " for supported versions."]
    cudaErrorSystemDriverMismatch = 803,
    #[doc = " This error indicates that the system was upgraded to run with forward compatibility"]
    #[doc = " but the visible hardware detected by CUDA does not support this configuration."]
    #[doc = " Refer to the compatibility documentation for the supported hardware matrix or ensure"]
    #[doc = " that only supported hardware is visible during initialization via the CUDA_VISIBLE_DEVICES"]
    #[doc = " environment variable."]
    cudaErrorCompatNotSupportedOnDevice = 804,
    #[doc = " This error indicates that the MPS client failed to connect to the MPS control daemon or the MPS server."]
    cudaErrorMpsConnectionFailed = 805,
    #[doc = " This error indicates that the remote procedural call between the MPS server and the MPS client failed."]
    cudaErrorMpsRpcFailure = 806,
    #[doc = " This error indicates that the MPS server is not ready to accept new MPS client requests."]
    #[doc = " This error can be returned when the MPS server is in the process of recovering from a fatal failure."]
    cudaErrorMpsServerNotReady = 807,
    #[doc = " This error indicates that the hardware resources required to create MPS client have been exhausted."]
    cudaErrorMpsMaxClientsReached = 808,
    #[doc = " This error indicates the the hardware resources required to device connections have been exhausted."]
    cudaErrorMpsMaxConnectionsReached = 809,
    #[doc = " The operation is not permitted when the stream is capturing."]
    cudaErrorStreamCaptureUnsupported = 900,
    #[doc = " The current capture sequence on the stream has been invalidated due to"]
    #[doc = " a previous error."]
    cudaErrorStreamCaptureInvalidated = 901,
    #[doc = " The operation would have resulted in a merge of two independent capture"]
    #[doc = " sequences."]
    cudaErrorStreamCaptureMerge = 902,
    #[doc = " The capture was not initiated in this stream."]
    cudaErrorStreamCaptureUnmatched = 903,
    #[doc = " The capture sequence contains a fork that was not joined to the primary"]
    #[doc = " stream."]
    cudaErrorStreamCaptureUnjoined = 904,
    #[doc = " A dependency would have been created which crosses the capture sequence"]
    #[doc = " boundary. Only implicit in-stream ordering dependencies are allowed to"]
    #[doc = " cross the boundary."]
    cudaErrorStreamCaptureIsolation = 905,
    #[doc = " The operation would have resulted in a disallowed implicit dependency on"]
    #[doc = " a current capture sequence from cudaStreamLegacy."]
    cudaErrorStreamCaptureImplicit = 906,
    #[doc = " The operation is not permitted on an event which was last recorded in a"]
    #[doc = " capturing stream."]
    cudaErrorCapturedEvent = 907,
    #[doc = " A stream capture sequence not initiated with the ::cudaStreamCaptureModeRelaxed"]
    #[doc = " argument to ::cudaStreamBeginCapture was passed to ::cudaStreamEndCapture in a"]
    #[doc = " different thread."]
    cudaErrorStreamCaptureWrongThread = 908,
    #[doc = " This indicates that the wait operation has timed out."]
    cudaErrorTimeout = 909,
    #[doc = " This error indicates that the graph update was not performed because it included"]
    #[doc = " changes which violated constraints specific to instantiated graph update."]
    cudaErrorGraphExecUpdateFailure = 910,
    #[doc = " This indicates that an unknown internal error has occurred."]
    cudaErrorUnknown = 999,
    #[doc = " Any unhandled CUDA driver error is added to this value and returned via"]
    #[doc = " the runtime. Production releases of CUDA should not return such errors."]
    #[doc = " \\deprecated"]
    #[doc = " This error return is deprecated as of CUDA 4.1."]
    cudaErrorApiFailureBase = 10000,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Channel format kind"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaChannelFormatKind {
    #[doc = "< Signed channel format"]
    cudaChannelFormatKindSigned = 0,
    #[doc = "< Unsigned channel format"]
    cudaChannelFormatKindUnsigned = 1,
    #[doc = "< Float channel format"]
    cudaChannelFormatKindFloat = 2,
    #[doc = "< No channel format"]
    cudaChannelFormatKindNone = 3,
    cudaChannelFormatKindNV12 = 4,
}
#[doc = " CUDA Channel format descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaChannelFormatDesc {
    #[doc = "< x"]
    pub x: ::libc::c_int,
    #[doc = "< y"]
    pub y: ::libc::c_int,
    #[doc = "< z"]
    pub z: ::libc::c_int,
    #[doc = "< w"]
    pub w: ::libc::c_int,
    #[doc = "< Channel format kind"]
    pub f: cudaChannelFormatKind,
}
#[test]
fn bindgen_test_layout_cudaChannelFormatDesc() {
    assert_eq!(
        ::std::mem::size_of::<cudaChannelFormatDesc>(),
        20usize,
        concat!("Size of: ", stringify!(cudaChannelFormatDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaChannelFormatDesc>(),
        4usize,
        concat!("Alignment of ", stringify!(cudaChannelFormatDesc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaChannelFormatDesc>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaChannelFormatDesc),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaChannelFormatDesc>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaChannelFormatDesc),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaChannelFormatDesc>())).z as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaChannelFormatDesc),
            "::",
            stringify!(z)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaChannelFormatDesc>())).w as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaChannelFormatDesc),
            "::",
            stringify!(w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaChannelFormatDesc>())).f as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaChannelFormatDesc),
            "::",
            stringify!(f)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaArray {
    _unused: [u8; 0],
}
#[doc = " CUDA array"]
pub type cudaArray_t = *mut cudaArray;
#[doc = " CUDA array (as source copy argument)"]
pub type cudaArray_const_t = *const cudaArray;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaMipmappedArray {
    _unused: [u8; 0],
}
#[doc = " CUDA mipmapped array"]
pub type cudaMipmappedArray_t = *mut cudaMipmappedArray;
#[doc = " CUDA mipmapped array (as source argument)"]
pub type cudaMipmappedArray_const_t = *const cudaMipmappedArray;
#[doc = " Sparse CUDA array and CUDA mipmapped array properties"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaArraySparseProperties {
    pub tileExtent: cudaArraySparseProperties__bindgen_ty_1,
    #[doc = "< First mip level at which the mip tail begins"]
    pub miptailFirstLevel: ::libc::c_uint,
    #[doc = "< Total size of the mip tail."]
    pub miptailSize: ::libc::c_ulonglong,
    #[doc = "< Flags will either be zero or ::cudaArraySparsePropertiesSingleMipTail"]
    pub flags: ::libc::c_uint,
    pub reserved: [::libc::c_uint; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaArraySparseProperties__bindgen_ty_1 {
    #[doc = "< Tile width in elements"]
    pub width: ::libc::c_uint,
    #[doc = "< Tile height in elements"]
    pub height: ::libc::c_uint,
    #[doc = "< Tile depth in elements"]
    pub depth: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout_cudaArraySparseProperties__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cudaArraySparseProperties__bindgen_ty_1>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(cudaArraySparseProperties__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaArraySparseProperties__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(cudaArraySparseProperties__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaArraySparseProperties__bindgen_ty_1>())).width as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaArraySparseProperties__bindgen_ty_1),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaArraySparseProperties__bindgen_ty_1>())).height as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaArraySparseProperties__bindgen_ty_1),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaArraySparseProperties__bindgen_ty_1>())).depth as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaArraySparseProperties__bindgen_ty_1),
            "::",
            stringify!(depth)
        )
    );
}
#[test]
fn bindgen_test_layout_cudaArraySparseProperties() {
    assert_eq!(
        ::std::mem::size_of::<cudaArraySparseProperties>(),
        48usize,
        concat!("Size of: ", stringify!(cudaArraySparseProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaArraySparseProperties>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaArraySparseProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaArraySparseProperties>())).tileExtent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaArraySparseProperties),
            "::",
            stringify!(tileExtent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaArraySparseProperties>())).miptailFirstLevel as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaArraySparseProperties),
            "::",
            stringify!(miptailFirstLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaArraySparseProperties>())).miptailSize as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaArraySparseProperties),
            "::",
            stringify!(miptailSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaArraySparseProperties>())).flags as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaArraySparseProperties),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaArraySparseProperties>())).reserved as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaArraySparseProperties),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA memory types"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaMemoryType {
    #[doc = "< Unregistered memory"]
    cudaMemoryTypeUnregistered = 0,
    #[doc = "< Host memory"]
    cudaMemoryTypeHost = 1,
    #[doc = "< Device memory"]
    cudaMemoryTypeDevice = 2,
    #[doc = "< Managed memory"]
    cudaMemoryTypeManaged = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA memory copy types"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaMemcpyKind {
    #[doc = "< Host   -> Host"]
    cudaMemcpyHostToHost = 0,
    #[doc = "< Host   -> Device"]
    cudaMemcpyHostToDevice = 1,
    #[doc = "< Device -> Host"]
    cudaMemcpyDeviceToHost = 2,
    #[doc = "< Device -> Device"]
    cudaMemcpyDeviceToDevice = 3,
    #[doc = "< Direction of the transfer is inferred from the pointer values. Requires unified virtual addressing"]
    cudaMemcpyDefault = 4,
}
#[doc = " CUDA Pitched memory pointer"]
#[doc = ""]
#[doc = " \\sa ::make_cudaPitchedPtr"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaPitchedPtr {
    #[doc = "< Pointer to allocated memory"]
    pub ptr: *mut ::libc::c_void,
    #[doc = "< Pitch of allocated memory in bytes"]
    pub pitch: usize,
    #[doc = "< Logical width of allocation in elements"]
    pub xsize: usize,
    #[doc = "< Logical height of allocation in elements"]
    pub ysize: usize,
}
#[test]
fn bindgen_test_layout_cudaPitchedPtr() {
    assert_eq!(
        ::std::mem::size_of::<cudaPitchedPtr>(),
        32usize,
        concat!("Size of: ", stringify!(cudaPitchedPtr))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaPitchedPtr>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaPitchedPtr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaPitchedPtr>())).ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaPitchedPtr),
            "::",
            stringify!(ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaPitchedPtr>())).pitch as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaPitchedPtr),
            "::",
            stringify!(pitch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaPitchedPtr>())).xsize as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaPitchedPtr),
            "::",
            stringify!(xsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaPitchedPtr>())).ysize as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaPitchedPtr),
            "::",
            stringify!(ysize)
        )
    );
}
#[doc = " CUDA extent"]
#[doc = ""]
#[doc = " \\sa ::make_cudaExtent"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaExtent {
    #[doc = "< Width in elements when referring to array memory, in bytes when referring to linear memory"]
    pub width: usize,
    #[doc = "< Height in elements"]
    pub height: usize,
    #[doc = "< Depth in elements"]
    pub depth: usize,
}
#[test]
fn bindgen_test_layout_cudaExtent() {
    assert_eq!(
        ::std::mem::size_of::<cudaExtent>(),
        24usize,
        concat!("Size of: ", stringify!(cudaExtent))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExtent>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaExtent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaExtent>())).width as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExtent),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaExtent>())).height as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExtent),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaExtent>())).depth as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExtent),
            "::",
            stringify!(depth)
        )
    );
}
#[doc = " CUDA 3D position"]
#[doc = ""]
#[doc = " \\sa ::make_cudaPos"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaPos {
    #[doc = "< x"]
    pub x: usize,
    #[doc = "< y"]
    pub y: usize,
    #[doc = "< z"]
    pub z: usize,
}
#[test]
fn bindgen_test_layout_cudaPos() {
    assert_eq!(
        ::std::mem::size_of::<cudaPos>(),
        24usize,
        concat!("Size of: ", stringify!(cudaPos))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaPos>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaPos))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaPos>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaPos),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaPos>())).y as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaPos),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaPos>())).z as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaPos),
            "::",
            stringify!(z)
        )
    );
}
#[doc = " CUDA 3D memory copying parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaMemcpy3DParms {
    #[doc = "< Source memory address"]
    pub srcArray: cudaArray_t,
    #[doc = "< Source position offset"]
    pub srcPos: cudaPos,
    #[doc = "< Pitched source memory address"]
    pub srcPtr: cudaPitchedPtr,
    #[doc = "< Destination memory address"]
    pub dstArray: cudaArray_t,
    #[doc = "< Destination position offset"]
    pub dstPos: cudaPos,
    #[doc = "< Pitched destination memory address"]
    pub dstPtr: cudaPitchedPtr,
    #[doc = "< Requested memory copy size"]
    pub extent: cudaExtent,
    #[doc = "< Type of transfer"]
    pub kind: cudaMemcpyKind,
}
#[test]
fn bindgen_test_layout_cudaMemcpy3DParms() {
    assert_eq!(
        ::std::mem::size_of::<cudaMemcpy3DParms>(),
        160usize,
        concat!("Size of: ", stringify!(cudaMemcpy3DParms))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaMemcpy3DParms>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaMemcpy3DParms))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DParms>())).srcArray as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DParms),
            "::",
            stringify!(srcArray)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DParms>())).srcPos as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DParms),
            "::",
            stringify!(srcPos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DParms>())).srcPtr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DParms),
            "::",
            stringify!(srcPtr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DParms>())).dstArray as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DParms),
            "::",
            stringify!(dstArray)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DParms>())).dstPos as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DParms),
            "::",
            stringify!(dstPos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DParms>())).dstPtr as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DParms),
            "::",
            stringify!(dstPtr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DParms>())).extent as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DParms),
            "::",
            stringify!(extent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DParms>())).kind as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DParms),
            "::",
            stringify!(kind)
        )
    );
}
#[doc = " CUDA 3D cross-device memory copying parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaMemcpy3DPeerParms {
    #[doc = "< Source memory address"]
    pub srcArray: cudaArray_t,
    #[doc = "< Source position offset"]
    pub srcPos: cudaPos,
    #[doc = "< Pitched source memory address"]
    pub srcPtr: cudaPitchedPtr,
    #[doc = "< Source device"]
    pub srcDevice: ::libc::c_int,
    #[doc = "< Destination memory address"]
    pub dstArray: cudaArray_t,
    #[doc = "< Destination position offset"]
    pub dstPos: cudaPos,
    #[doc = "< Pitched destination memory address"]
    pub dstPtr: cudaPitchedPtr,
    #[doc = "< Destination device"]
    pub dstDevice: ::libc::c_int,
    #[doc = "< Requested memory copy size"]
    pub extent: cudaExtent,
}
#[test]
fn bindgen_test_layout_cudaMemcpy3DPeerParms() {
    assert_eq!(
        ::std::mem::size_of::<cudaMemcpy3DPeerParms>(),
        168usize,
        concat!("Size of: ", stringify!(cudaMemcpy3DPeerParms))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaMemcpy3DPeerParms>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaMemcpy3DPeerParms))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DPeerParms>())).srcArray as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DPeerParms),
            "::",
            stringify!(srcArray)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DPeerParms>())).srcPos as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DPeerParms),
            "::",
            stringify!(srcPos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DPeerParms>())).srcPtr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DPeerParms),
            "::",
            stringify!(srcPtr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DPeerParms>())).srcDevice as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DPeerParms),
            "::",
            stringify!(srcDevice)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DPeerParms>())).dstArray as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DPeerParms),
            "::",
            stringify!(dstArray)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DPeerParms>())).dstPos as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DPeerParms),
            "::",
            stringify!(dstPos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DPeerParms>())).dstPtr as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DPeerParms),
            "::",
            stringify!(dstPtr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DPeerParms>())).dstDevice as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DPeerParms),
            "::",
            stringify!(dstDevice)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemcpy3DPeerParms>())).extent as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemcpy3DPeerParms),
            "::",
            stringify!(extent)
        )
    );
}
#[doc = " CUDA Memset node parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaMemsetParams {
    #[doc = "< Destination device pointer"]
    pub dst: *mut ::libc::c_void,
    #[doc = "< Pitch of destination device pointer. Unused if height is 1"]
    pub pitch: usize,
    #[doc = "< Value to be set"]
    pub value: ::libc::c_uint,
    #[doc = "< Size of each element in bytes. Must be 1, 2, or 4."]
    pub elementSize: ::libc::c_uint,
    #[doc = "< Width of the row in elements"]
    pub width: usize,
    #[doc = "< Number of rows"]
    pub height: usize,
}
#[test]
fn bindgen_test_layout_cudaMemsetParams() {
    assert_eq!(
        ::std::mem::size_of::<cudaMemsetParams>(),
        40usize,
        concat!("Size of: ", stringify!(cudaMemsetParams))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaMemsetParams>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaMemsetParams))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemsetParams>())).dst as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemsetParams),
            "::",
            stringify!(dst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemsetParams>())).pitch as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemsetParams),
            "::",
            stringify!(pitch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemsetParams>())).value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemsetParams),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemsetParams>())).elementSize as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemsetParams),
            "::",
            stringify!(elementSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemsetParams>())).width as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemsetParams),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemsetParams>())).height as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemsetParams),
            "::",
            stringify!(height)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Specifies performance hint with ::cudaAccessPolicyWindow for hitProp and missProp members."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaAccessProperty {
    #[doc = "< Normal cache persistence."]
    cudaAccessPropertyNormal = 0,
    #[doc = "< Streaming access is less likely to persit from cache."]
    cudaAccessPropertyStreaming = 1,
    #[doc = "< Persisting access is more likely to persist in cache."]
    cudaAccessPropertyPersisting = 2,
}
#[doc = " Specifies an access policy for a window, a contiguous extent of memory"]
#[doc = " beginning at base_ptr and ending at base_ptr + num_bytes."]
#[doc = " Partition into many segments and assign segments such that."]
#[doc = " sum of \"hit segments\" / window == approx. ratio."]
#[doc = " sum of \"miss segments\" / window == approx 1-ratio."]
#[doc = " Segments and ratio specifications are fitted to the capabilities of"]
#[doc = " the architecture."]
#[doc = " Accesses in a hit segment apply the hitProp access policy."]
#[doc = " Accesses in a miss segment apply the missProp access policy."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaAccessPolicyWindow {
    #[doc = "< Starting address of the access policy window. CUDA driver may align it."]
    pub base_ptr: *mut ::libc::c_void,
    #[doc = "< Size in bytes of the window policy. CUDA driver may restrict the maximum size and alignment."]
    pub num_bytes: usize,
    #[doc = "< hitRatio specifies percentage of lines assigned hitProp, rest are assigned missProp."]
    pub hitRatio: f32,
    #[doc = "< ::CUaccessProperty set for hit."]
    pub hitProp: cudaAccessProperty,
    #[doc = "< ::CUaccessProperty set for miss. Must be either NORMAL or STREAMING."]
    pub missProp: cudaAccessProperty,
}
#[test]
fn bindgen_test_layout_cudaAccessPolicyWindow() {
    assert_eq!(
        ::std::mem::size_of::<cudaAccessPolicyWindow>(),
        32usize,
        concat!("Size of: ", stringify!(cudaAccessPolicyWindow))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaAccessPolicyWindow>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaAccessPolicyWindow))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaAccessPolicyWindow>())).base_ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaAccessPolicyWindow),
            "::",
            stringify!(base_ptr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaAccessPolicyWindow>())).num_bytes as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaAccessPolicyWindow),
            "::",
            stringify!(num_bytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaAccessPolicyWindow>())).hitRatio as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaAccessPolicyWindow),
            "::",
            stringify!(hitRatio)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaAccessPolicyWindow>())).hitProp as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaAccessPolicyWindow),
            "::",
            stringify!(hitProp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaAccessPolicyWindow>())).missProp as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaAccessPolicyWindow),
            "::",
            stringify!(missProp)
        )
    );
}
#[doc = " CUDA host function"]
#[doc = " \\param userData Argument value passed to the function"]
pub type cudaHostFn_t = ::std::option::Option<unsafe extern "C" fn(userData: *mut ::libc::c_void)>;
#[doc = " CUDA host node parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaHostNodeParams {
    #[doc = "< The function to call when the node executes"]
    pub fn_: cudaHostFn_t,
    #[doc = "< Argument to pass to the function"]
    pub userData: *mut ::libc::c_void,
}
#[test]
fn bindgen_test_layout_cudaHostNodeParams() {
    assert_eq!(
        ::std::mem::size_of::<cudaHostNodeParams>(),
        16usize,
        concat!("Size of: ", stringify!(cudaHostNodeParams))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaHostNodeParams>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaHostNodeParams))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaHostNodeParams>())).fn_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaHostNodeParams),
            "::",
            stringify!(fn_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaHostNodeParams>())).userData as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaHostNodeParams),
            "::",
            stringify!(userData)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Possible stream capture statuses returned by ::cudaStreamIsCapturing"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaStreamCaptureStatus {
    #[doc = "< Stream is not capturing"]
    cudaStreamCaptureStatusNone = 0,
    #[doc = "< Stream is actively capturing"]
    cudaStreamCaptureStatusActive = 1,
    #[doc = "< Stream is part of a capture sequence that"]
    #[doc = "has been invalidated, but not terminated"]
    cudaStreamCaptureStatusInvalidated = 2,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Possible modes for stream capture thread interactions. For more details see"]
#[doc = " ::cudaStreamBeginCapture and ::cudaThreadExchangeStreamCaptureMode"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaStreamCaptureMode {
    cudaStreamCaptureModeGlobal = 0,
    cudaStreamCaptureModeThreadLocal = 1,
    cudaStreamCaptureModeRelaxed = 2,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaSynchronizationPolicy {
    cudaSyncPolicyAuto = 1,
    cudaSyncPolicySpin = 2,
    cudaSyncPolicyYield = 3,
    cudaSyncPolicyBlockingSync = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Stream Attributes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaStreamAttrID {
    #[doc = "< Identifier for ::cudaStreamAttrValue::accessPolicyWindow."]
    cudaStreamAttributeAccessPolicyWindow = 1,
    #[doc = "< ::cudaSynchronizationPolicy for work queued up in this stream"]
    cudaStreamAttributeSynchronizationPolicy = 3,
}
#[doc = " Stream attributes union used with ::cudaStreamSetAttribute/::cudaStreamGetAttribute"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union cudaStreamAttrValue {
    pub accessPolicyWindow: cudaAccessPolicyWindow,
    pub syncPolicy: cudaSynchronizationPolicy,
}
#[test]
fn bindgen_test_layout_cudaStreamAttrValue() {
    assert_eq!(
        ::std::mem::size_of::<cudaStreamAttrValue>(),
        32usize,
        concat!("Size of: ", stringify!(cudaStreamAttrValue))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaStreamAttrValue>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaStreamAttrValue))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaStreamAttrValue>())).accessPolicyWindow as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaStreamAttrValue),
            "::",
            stringify!(accessPolicyWindow)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaStreamAttrValue>())).syncPolicy as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaStreamAttrValue),
            "::",
            stringify!(syncPolicy)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Flags for ::cudaStreamUpdateCaptureDependencies"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaStreamUpdateCaptureDependenciesFlags {
    #[doc = "< Add new nodes to the dependency set"]
    cudaStreamAddCaptureDependencies = 0,
    #[doc = "< Replace the dependency set with the new nodes"]
    cudaStreamSetCaptureDependencies = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Flags for user objects for graphs"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaUserObjectFlags {
    #[doc = "< Indicates the destructor execution is not synchronized by any CUDA handle."]
    cudaUserObjectNoDestructorSync = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Flags for retaining user object references for graphs"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaUserObjectRetainFlags {
    #[doc = "< Transfer references from the caller rather than creating new references."]
    cudaGraphUserObjectMove = 1,
}
#[doc = " CUDA graphics interop resource"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaGraphicsResource {
    _unused: [u8; 0],
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA graphics interop register flags"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaGraphicsRegisterFlags {
    #[doc = "< Default"]
    cudaGraphicsRegisterFlagsNone = 0,
    #[doc = "< CUDA will not write to this resource"]
    cudaGraphicsRegisterFlagsReadOnly = 1,
    #[doc = "< CUDA will only write to and will not read from this resource"]
    cudaGraphicsRegisterFlagsWriteDiscard = 2,
    #[doc = "< CUDA will bind this resource to a surface reference"]
    cudaGraphicsRegisterFlagsSurfaceLoadStore = 4,
    #[doc = "< CUDA will perform texture gather operations on this resource"]
    cudaGraphicsRegisterFlagsTextureGather = 8,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA graphics interop map flags"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaGraphicsMapFlags {
    #[doc = "< Default; Assume resource can be read/written"]
    cudaGraphicsMapFlagsNone = 0,
    #[doc = "< CUDA will not write to this resource"]
    cudaGraphicsMapFlagsReadOnly = 1,
    #[doc = "< CUDA will only write to and will not read from this resource"]
    cudaGraphicsMapFlagsWriteDiscard = 2,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA graphics interop array indices for cube maps"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaGraphicsCubeFace {
    #[doc = "< Positive X face of cubemap"]
    cudaGraphicsCubeFacePositiveX = 0,
    #[doc = "< Negative X face of cubemap"]
    cudaGraphicsCubeFaceNegativeX = 1,
    #[doc = "< Positive Y face of cubemap"]
    cudaGraphicsCubeFacePositiveY = 2,
    #[doc = "< Negative Y face of cubemap"]
    cudaGraphicsCubeFaceNegativeY = 3,
    #[doc = "< Positive Z face of cubemap"]
    cudaGraphicsCubeFacePositiveZ = 4,
    #[doc = "< Negative Z face of cubemap"]
    cudaGraphicsCubeFaceNegativeZ = 5,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Graph kernel node Attributes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaKernelNodeAttrID {
    #[doc = "< Identifier for ::cudaKernelNodeAttrValue::accessPolicyWindow."]
    cudaKernelNodeAttributeAccessPolicyWindow = 1,
    #[doc = "< Allows a kernel node to be cooperative (see ::cudaLaunchCooperativeKernel)."]
    cudaKernelNodeAttributeCooperative = 2,
}
#[doc = " Graph kernel node attributes union, used with ::cudaGraphKernelNodeSetAttribute/::cudaGraphKernelNodeGetAttribute"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union cudaKernelNodeAttrValue {
    #[doc = "< Attribute ::CUaccessPolicyWindow."]
    pub accessPolicyWindow: cudaAccessPolicyWindow,
    pub cooperative: ::libc::c_int,
}
#[test]
fn bindgen_test_layout_cudaKernelNodeAttrValue() {
    assert_eq!(
        ::std::mem::size_of::<cudaKernelNodeAttrValue>(),
        32usize,
        concat!("Size of: ", stringify!(cudaKernelNodeAttrValue))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaKernelNodeAttrValue>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaKernelNodeAttrValue))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaKernelNodeAttrValue>())).accessPolicyWindow as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaKernelNodeAttrValue),
            "::",
            stringify!(accessPolicyWindow)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaKernelNodeAttrValue>())).cooperative as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaKernelNodeAttrValue),
            "::",
            stringify!(cooperative)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA resource types"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaResourceType {
    #[doc = "< Array resource"]
    cudaResourceTypeArray = 0,
    #[doc = "< Mipmapped array resource"]
    cudaResourceTypeMipmappedArray = 1,
    #[doc = "< Linear resource"]
    cudaResourceTypeLinear = 2,
    #[doc = "< Pitch 2D resource"]
    cudaResourceTypePitch2D = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA texture resource view formats"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaResourceViewFormat {
    #[doc = "< No resource view format (use underlying resource format)"]
    cudaResViewFormatNone = 0,
    #[doc = "< 1 channel unsigned 8-bit integers"]
    cudaResViewFormatUnsignedChar1 = 1,
    #[doc = "< 2 channel unsigned 8-bit integers"]
    cudaResViewFormatUnsignedChar2 = 2,
    #[doc = "< 4 channel unsigned 8-bit integers"]
    cudaResViewFormatUnsignedChar4 = 3,
    #[doc = "< 1 channel signed 8-bit integers"]
    cudaResViewFormatSignedChar1 = 4,
    #[doc = "< 2 channel signed 8-bit integers"]
    cudaResViewFormatSignedChar2 = 5,
    #[doc = "< 4 channel signed 8-bit integers"]
    cudaResViewFormatSignedChar4 = 6,
    #[doc = "< 1 channel unsigned 16-bit integers"]
    cudaResViewFormatUnsignedShort1 = 7,
    #[doc = "< 2 channel unsigned 16-bit integers"]
    cudaResViewFormatUnsignedShort2 = 8,
    #[doc = "< 4 channel unsigned 16-bit integers"]
    cudaResViewFormatUnsignedShort4 = 9,
    #[doc = "< 1 channel signed 16-bit integers"]
    cudaResViewFormatSignedShort1 = 10,
    #[doc = "< 2 channel signed 16-bit integers"]
    cudaResViewFormatSignedShort2 = 11,
    #[doc = "< 4 channel signed 16-bit integers"]
    cudaResViewFormatSignedShort4 = 12,
    #[doc = "< 1 channel unsigned 32-bit integers"]
    cudaResViewFormatUnsignedInt1 = 13,
    #[doc = "< 2 channel unsigned 32-bit integers"]
    cudaResViewFormatUnsignedInt2 = 14,
    #[doc = "< 4 channel unsigned 32-bit integers"]
    cudaResViewFormatUnsignedInt4 = 15,
    #[doc = "< 1 channel signed 32-bit integers"]
    cudaResViewFormatSignedInt1 = 16,
    #[doc = "< 2 channel signed 32-bit integers"]
    cudaResViewFormatSignedInt2 = 17,
    #[doc = "< 4 channel signed 32-bit integers"]
    cudaResViewFormatSignedInt4 = 18,
    #[doc = "< 1 channel 16-bit floating point"]
    cudaResViewFormatHalf1 = 19,
    #[doc = "< 2 channel 16-bit floating point"]
    cudaResViewFormatHalf2 = 20,
    #[doc = "< 4 channel 16-bit floating point"]
    cudaResViewFormatHalf4 = 21,
    #[doc = "< 1 channel 32-bit floating point"]
    cudaResViewFormatFloat1 = 22,
    #[doc = "< 2 channel 32-bit floating point"]
    cudaResViewFormatFloat2 = 23,
    #[doc = "< 4 channel 32-bit floating point"]
    cudaResViewFormatFloat4 = 24,
    #[doc = "< Block compressed 1"]
    cudaResViewFormatUnsignedBlockCompressed1 = 25,
    #[doc = "< Block compressed 2"]
    cudaResViewFormatUnsignedBlockCompressed2 = 26,
    #[doc = "< Block compressed 3"]
    cudaResViewFormatUnsignedBlockCompressed3 = 27,
    #[doc = "< Block compressed 4 unsigned"]
    cudaResViewFormatUnsignedBlockCompressed4 = 28,
    #[doc = "< Block compressed 4 signed"]
    cudaResViewFormatSignedBlockCompressed4 = 29,
    #[doc = "< Block compressed 5 unsigned"]
    cudaResViewFormatUnsignedBlockCompressed5 = 30,
    #[doc = "< Block compressed 5 signed"]
    cudaResViewFormatSignedBlockCompressed5 = 31,
    #[doc = "< Block compressed 6 unsigned half-float"]
    cudaResViewFormatUnsignedBlockCompressed6H = 32,
    #[doc = "< Block compressed 6 signed half-float"]
    cudaResViewFormatSignedBlockCompressed6H = 33,
    #[doc = "< Block compressed 7"]
    cudaResViewFormatUnsignedBlockCompressed7 = 34,
}
#[doc = " CUDA resource descriptor"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaResourceDesc {
    #[doc = "< Resource type"]
    pub resType: cudaResourceType,
    pub res: cudaResourceDesc__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cudaResourceDesc__bindgen_ty_1 {
    pub array: cudaResourceDesc__bindgen_ty_1__bindgen_ty_1,
    pub mipmap: cudaResourceDesc__bindgen_ty_1__bindgen_ty_2,
    pub linear: cudaResourceDesc__bindgen_ty_1__bindgen_ty_3,
    pub pitch2D: cudaResourceDesc__bindgen_ty_1__bindgen_ty_4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaResourceDesc__bindgen_ty_1__bindgen_ty_1 {
    #[doc = "< CUDA array"]
    pub array: cudaArray_t,
}
#[test]
fn bindgen_test_layout_cudaResourceDesc__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_1>())).array
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(array)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaResourceDesc__bindgen_ty_1__bindgen_ty_2 {
    #[doc = "< CUDA mipmapped array"]
    pub mipmap: cudaMipmappedArray_t,
}
#[test]
fn bindgen_test_layout_cudaResourceDesc__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_2>())).mipmap
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(mipmap)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaResourceDesc__bindgen_ty_1__bindgen_ty_3 {
    #[doc = "< Device pointer"]
    pub devPtr: *mut ::libc::c_void,
    #[doc = "< Channel descriptor"]
    pub desc: cudaChannelFormatDesc,
    #[doc = "< Size in bytes"]
    pub sizeInBytes: usize,
}
#[test]
fn bindgen_test_layout_cudaResourceDesc__bindgen_ty_1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_3>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_3>())).devPtr
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(devPtr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_3>())).desc
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_3>())).sizeInBytes
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(sizeInBytes)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaResourceDesc__bindgen_ty_1__bindgen_ty_4 {
    #[doc = "< Device pointer"]
    pub devPtr: *mut ::libc::c_void,
    #[doc = "< Channel descriptor"]
    pub desc: cudaChannelFormatDesc,
    #[doc = "< Width of the array in elements"]
    pub width: usize,
    #[doc = "< Height of the array in elements"]
    pub height: usize,
    #[doc = "< Pitch between two rows in bytes"]
    pub pitchInBytes: usize,
}
#[test]
fn bindgen_test_layout_cudaResourceDesc__bindgen_ty_1__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_4>(),
        56usize,
        concat!(
            "Size of: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_4>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_4>())).devPtr
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(devPtr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_4>())).desc
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_4>())).width
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_4>())).height
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1__bindgen_ty_4>())).pitchInBytes
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(pitchInBytes)
        )
    );
}
#[test]
fn bindgen_test_layout_cudaResourceDesc__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cudaResourceDesc__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(cudaResourceDesc__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaResourceDesc__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaResourceDesc__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1>())).array as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1),
            "::",
            stringify!(array)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1>())).mipmap as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1),
            "::",
            stringify!(mipmap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1>())).linear as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1),
            "::",
            stringify!(linear)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceDesc__bindgen_ty_1>())).pitch2D as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc__bindgen_ty_1),
            "::",
            stringify!(pitch2D)
        )
    );
}
#[test]
fn bindgen_test_layout_cudaResourceDesc() {
    assert_eq!(
        ::std::mem::size_of::<cudaResourceDesc>(),
        64usize,
        concat!("Size of: ", stringify!(cudaResourceDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaResourceDesc>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaResourceDesc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaResourceDesc>())).resType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc),
            "::",
            stringify!(resType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaResourceDesc>())).res as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceDesc),
            "::",
            stringify!(res)
        )
    );
}
#[doc = " CUDA resource view descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaResourceViewDesc {
    #[doc = "< Resource view format"]
    pub format: cudaResourceViewFormat,
    #[doc = "< Width of the resource view"]
    pub width: usize,
    #[doc = "< Height of the resource view"]
    pub height: usize,
    #[doc = "< Depth of the resource view"]
    pub depth: usize,
    #[doc = "< First defined mipmap level"]
    pub firstMipmapLevel: ::libc::c_uint,
    #[doc = "< Last defined mipmap level"]
    pub lastMipmapLevel: ::libc::c_uint,
    #[doc = "< First layer index"]
    pub firstLayer: ::libc::c_uint,
    #[doc = "< Last layer index"]
    pub lastLayer: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout_cudaResourceViewDesc() {
    assert_eq!(
        ::std::mem::size_of::<cudaResourceViewDesc>(),
        48usize,
        concat!("Size of: ", stringify!(cudaResourceViewDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaResourceViewDesc>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaResourceViewDesc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaResourceViewDesc>())).format as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceViewDesc),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaResourceViewDesc>())).width as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceViewDesc),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaResourceViewDesc>())).height as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceViewDesc),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaResourceViewDesc>())).depth as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceViewDesc),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceViewDesc>())).firstMipmapLevel as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceViewDesc),
            "::",
            stringify!(firstMipmapLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaResourceViewDesc>())).lastMipmapLevel as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceViewDesc),
            "::",
            stringify!(lastMipmapLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaResourceViewDesc>())).firstLayer as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceViewDesc),
            "::",
            stringify!(firstLayer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaResourceViewDesc>())).lastLayer as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaResourceViewDesc),
            "::",
            stringify!(lastLayer)
        )
    );
}
#[doc = " CUDA pointer attributes"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaPointerAttributes {
    #[doc = " The type of memory - ::cudaMemoryTypeUnregistered, ::cudaMemoryTypeHost,"]
    #[doc = " ::cudaMemoryTypeDevice or ::cudaMemoryTypeManaged."]
    pub type_: cudaMemoryType,
    #[doc = " The device against which the memory was allocated or registered."]
    #[doc = " If the memory type is ::cudaMemoryTypeDevice then this identifies"]
    #[doc = " the device on which the memory referred physically resides.  If"]
    #[doc = " the memory type is ::cudaMemoryTypeHost or::cudaMemoryTypeManaged then"]
    #[doc = " this identifies the device which was current when the memory was allocated"]
    #[doc = " or registered (and if that device is deinitialized then this allocation"]
    #[doc = " will vanish with that device's state)."]
    pub device: ::libc::c_int,
    #[doc = " The address which may be dereferenced on the current device to access"]
    #[doc = " the memory or NULL if no such address exists."]
    pub devicePointer: *mut ::libc::c_void,
    #[doc = " The address which may be dereferenced on the host to access the"]
    #[doc = " memory or NULL if no such address exists."]
    #[doc = ""]
    #[doc = " \\note CUDA doesn't check if unregistered memory is allocated so this field"]
    #[doc = " may contain invalid pointer if an invalid pointer has been passed to CUDA."]
    pub hostPointer: *mut ::libc::c_void,
}
#[test]
fn bindgen_test_layout_cudaPointerAttributes() {
    assert_eq!(
        ::std::mem::size_of::<cudaPointerAttributes>(),
        24usize,
        concat!("Size of: ", stringify!(cudaPointerAttributes))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaPointerAttributes>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaPointerAttributes))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaPointerAttributes>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaPointerAttributes),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaPointerAttributes>())).device as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaPointerAttributes),
            "::",
            stringify!(device)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaPointerAttributes>())).devicePointer as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaPointerAttributes),
            "::",
            stringify!(devicePointer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaPointerAttributes>())).hostPointer as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaPointerAttributes),
            "::",
            stringify!(hostPointer)
        )
    );
}
#[doc = " CUDA function attributes"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaFuncAttributes {
    #[doc = " The size in bytes of statically-allocated shared memory per block"]
    #[doc = " required by this function. This does not include dynamically-allocated"]
    #[doc = " shared memory requested by the user at runtime."]
    pub sharedSizeBytes: usize,
    #[doc = " The size in bytes of user-allocated constant memory required by this"]
    #[doc = " function."]
    pub constSizeBytes: usize,
    #[doc = " The size in bytes of local memory used by each thread of this function."]
    pub localSizeBytes: usize,
    #[doc = " The maximum number of threads per block, beyond which a launch of the"]
    #[doc = " function would fail. This number depends on both the function and the"]
    #[doc = " device on which the function is currently loaded."]
    pub maxThreadsPerBlock: ::libc::c_int,
    #[doc = " The number of registers used by each thread of this function."]
    pub numRegs: ::libc::c_int,
    #[doc = " The PTX virtual architecture version for which the function was"]
    #[doc = " compiled. This value is the major PTX version * 10 + the minor PTX"]
    #[doc = " version, so a PTX version 1.3 function would return the value 13."]
    pub ptxVersion: ::libc::c_int,
    #[doc = " The binary architecture version for which the function was compiled."]
    #[doc = " This value is the major binary version * 10 + the minor binary version,"]
    #[doc = " so a binary version 1.3 function would return the value 13."]
    pub binaryVersion: ::libc::c_int,
    #[doc = " The attribute to indicate whether the function has been compiled with"]
    #[doc = " user specified option \"-Xptxas --dlcm=ca\" set."]
    pub cacheModeCA: ::libc::c_int,
    #[doc = " The maximum size in bytes of dynamic shared memory per block for"]
    #[doc = " this function. Any launch must have a dynamic shared memory size"]
    #[doc = " smaller than this value."]
    pub maxDynamicSharedSizeBytes: ::libc::c_int,
    #[doc = " On devices where the L1 cache and shared memory use the same hardware resources,"]
    #[doc = " this sets the shared memory carveout preference, in percent of the maximum shared memory."]
    #[doc = " Refer to ::cudaDevAttrMaxSharedMemoryPerMultiprocessor."]
    #[doc = " This is only a hint, and the driver can choose a different ratio if required to execute the function."]
    #[doc = " See ::cudaFuncSetAttribute"]
    pub preferredShmemCarveout: ::libc::c_int,
}
#[test]
fn bindgen_test_layout_cudaFuncAttributes() {
    assert_eq!(
        ::std::mem::size_of::<cudaFuncAttributes>(),
        56usize,
        concat!("Size of: ", stringify!(cudaFuncAttributes))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaFuncAttributes>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaFuncAttributes))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaFuncAttributes>())).sharedSizeBytes as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaFuncAttributes),
            "::",
            stringify!(sharedSizeBytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaFuncAttributes>())).constSizeBytes as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaFuncAttributes),
            "::",
            stringify!(constSizeBytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaFuncAttributes>())).localSizeBytes as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaFuncAttributes),
            "::",
            stringify!(localSizeBytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaFuncAttributes>())).maxThreadsPerBlock as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaFuncAttributes),
            "::",
            stringify!(maxThreadsPerBlock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaFuncAttributes>())).numRegs as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaFuncAttributes),
            "::",
            stringify!(numRegs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaFuncAttributes>())).ptxVersion as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaFuncAttributes),
            "::",
            stringify!(ptxVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaFuncAttributes>())).binaryVersion as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaFuncAttributes),
            "::",
            stringify!(binaryVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaFuncAttributes>())).cacheModeCA as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaFuncAttributes),
            "::",
            stringify!(cacheModeCA)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaFuncAttributes>())).maxDynamicSharedSizeBytes as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaFuncAttributes),
            "::",
            stringify!(maxDynamicSharedSizeBytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaFuncAttributes>())).preferredShmemCarveout as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaFuncAttributes),
            "::",
            stringify!(preferredShmemCarveout)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA function attributes that can be set using ::cudaFuncSetAttribute"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaFuncAttribute {
    #[doc = "< Maximum dynamic shared memory size"]
    cudaFuncAttributeMaxDynamicSharedMemorySize = 8,
    #[doc = "< Preferred shared memory-L1 cache split"]
    cudaFuncAttributePreferredSharedMemoryCarveout = 9,
    cudaFuncAttributeMax = 10,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA function cache configurations"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaFuncCache {
    #[doc = "< Default function cache configuration, no preference"]
    cudaFuncCachePreferNone = 0,
    #[doc = "< Prefer larger shared memory and smaller L1 cache"]
    cudaFuncCachePreferShared = 1,
    #[doc = "< Prefer larger L1 cache and smaller shared memory"]
    cudaFuncCachePreferL1 = 2,
    #[doc = "< Prefer equal size L1 cache and shared memory"]
    cudaFuncCachePreferEqual = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA shared memory configuration"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaSharedMemConfig {
    cudaSharedMemBankSizeDefault = 0,
    cudaSharedMemBankSizeFourByte = 1,
    cudaSharedMemBankSizeEightByte = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = " Shared memory carveout configurations. These may be passed to cudaFuncSetAttribute"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaSharedCarveout {
    #[doc = "< No preference for shared memory or L1 (default)"]
    cudaSharedmemCarveoutDefault = -1,
    #[doc = "< Prefer maximum available shared memory, minimum L1 cache"]
    cudaSharedmemCarveoutMaxShared = 100,
    #[doc = "< Prefer maximum available L1 cache, minimum shared memory"]
    cudaSharedmemCarveoutMaxL1 = 0,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA device compute modes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaComputeMode {
    #[doc = "< Default compute mode (Multiple threads can use ::cudaSetDevice() with this device)"]
    cudaComputeModeDefault = 0,
    #[doc = "< Compute-exclusive-thread mode (Only one thread in one process will be able to use ::cudaSetDevice() with this device)"]
    cudaComputeModeExclusive = 1,
    #[doc = "< Compute-prohibited mode (No threads can use ::cudaSetDevice() with this device)"]
    cudaComputeModeProhibited = 2,
    #[doc = "< Compute-exclusive-process mode (Many threads in one process will be able to use ::cudaSetDevice() with this device)"]
    cudaComputeModeExclusiveProcess = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA Limits"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaLimit {
    #[doc = "< GPU thread stack size"]
    cudaLimitStackSize = 0,
    #[doc = "< GPU printf FIFO size"]
    cudaLimitPrintfFifoSize = 1,
    #[doc = "< GPU malloc heap size"]
    cudaLimitMallocHeapSize = 2,
    #[doc = "< GPU device runtime synchronize depth"]
    cudaLimitDevRuntimeSyncDepth = 3,
    #[doc = "< GPU device runtime pending launch count"]
    cudaLimitDevRuntimePendingLaunchCount = 4,
    #[doc = "< A value between 0 and 128 that indicates the maximum fetch granularity of L2 (in Bytes). This is a hint"]
    cudaLimitMaxL2FetchGranularity = 5,
    #[doc = "< A size in bytes for L2 persisting lines cache size"]
    cudaLimitPersistingL2CacheSize = 6,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA Memory Advise values"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaMemoryAdvise {
    #[doc = "< Data will mostly be read and only occassionally be written to"]
    cudaMemAdviseSetReadMostly = 1,
    #[doc = "< Undo the effect of ::cudaMemAdviseSetReadMostly"]
    cudaMemAdviseUnsetReadMostly = 2,
    #[doc = "< Set the preferred location for the data as the specified device"]
    cudaMemAdviseSetPreferredLocation = 3,
    #[doc = "< Clear the preferred location for the data"]
    cudaMemAdviseUnsetPreferredLocation = 4,
    #[doc = "< Data will be accessed by the specified device, so prevent page faults as much as possible"]
    cudaMemAdviseSetAccessedBy = 5,
    #[doc = "< Let the Unified Memory subsystem decide on the page faulting policy for the specified device"]
    cudaMemAdviseUnsetAccessedBy = 6,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA range attributes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaMemRangeAttribute {
    #[doc = "< Whether the range will mostly be read and only occassionally be written to"]
    cudaMemRangeAttributeReadMostly = 1,
    #[doc = "< The preferred location of the range"]
    cudaMemRangeAttributePreferredLocation = 2,
    #[doc = "< Memory range has ::cudaMemAdviseSetAccessedBy set for specified device"]
    cudaMemRangeAttributeAccessedBy = 3,
    #[doc = "< The last location to which the range was prefetched"]
    cudaMemRangeAttributeLastPrefetchLocation = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA Profiler Output modes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaOutputMode {
    #[doc = "< Output mode Key-Value pair format."]
    cudaKeyValuePair = 0,
    #[doc = "< Output mode Comma separated values format."]
    cudaCSV = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA GPUDirect RDMA flush writes APIs supported on the device"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaFlushGPUDirectRDMAWritesOptions {
    #[doc = "< ::cudaDeviceFlushGPUDirectRDMAWrites() and its CUDA Driver API counterpart are supported on the device."]
    cudaFlushGPUDirectRDMAWritesOptionHost = 1,
    #[doc = "< The ::CU_STREAM_WAIT_VALUE_FLUSH flag and the ::CU_STREAM_MEM_OP_FLUSH_REMOTE_WRITES MemOp are supported on the CUDA device."]
    cudaFlushGPUDirectRDMAWritesOptionMemOps = 2,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA GPUDirect RDMA flush writes ordering features of the device"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaGPUDirectRDMAWritesOrdering {
    #[doc = "< The device does not natively support ordering of GPUDirect RDMA writes. ::cudaFlushGPUDirectRDMAWrites() can be leveraged if supported."]
    cudaGPUDirectRDMAWritesOrderingNone = 0,
    #[doc = "< Natively, the device can consistently consume GPUDirect RDMA writes, although other CUDA devices may not."]
    cudaGPUDirectRDMAWritesOrderingOwner = 100,
    #[doc = "< Any CUDA device in the system can consistently consume GPUDirect RDMA writes to this device."]
    cudaGPUDirectRDMAWritesOrderingAllDevices = 200,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA GPUDirect RDMA flush writes scopes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaFlushGPUDirectRDMAWritesScope {
    #[doc = "< Blocks until remote writes are visible to the CUDA device context owning the data."]
    cudaFlushGPUDirectRDMAWritesToOwner = 100,
    #[doc = "< Blocks until remote writes are visible to all CUDA device contexts."]
    cudaFlushGPUDirectRDMAWritesToAllDevices = 200,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA GPUDirect RDMA flush writes targets"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaFlushGPUDirectRDMAWritesTarget {
    #[doc = "< Sets the target for ::cudaDeviceFlushGPUDirectRDMAWrites() to the currently active CUDA device context."]
    cudaFlushGPUDirectRDMAWritesTargetCurrentDevice = 0,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA device attributes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaDeviceAttr {
    #[doc = "< Maximum number of threads per block"]
    cudaDevAttrMaxThreadsPerBlock = 1,
    #[doc = "< Maximum block dimension X"]
    cudaDevAttrMaxBlockDimX = 2,
    #[doc = "< Maximum block dimension Y"]
    cudaDevAttrMaxBlockDimY = 3,
    #[doc = "< Maximum block dimension Z"]
    cudaDevAttrMaxBlockDimZ = 4,
    #[doc = "< Maximum grid dimension X"]
    cudaDevAttrMaxGridDimX = 5,
    #[doc = "< Maximum grid dimension Y"]
    cudaDevAttrMaxGridDimY = 6,
    #[doc = "< Maximum grid dimension Z"]
    cudaDevAttrMaxGridDimZ = 7,
    #[doc = "< Maximum shared memory available per block in bytes"]
    cudaDevAttrMaxSharedMemoryPerBlock = 8,
    #[doc = "< Memory available on device for __constant__ variables in a CUDA C kernel in bytes"]
    cudaDevAttrTotalConstantMemory = 9,
    #[doc = "< Warp size in threads"]
    cudaDevAttrWarpSize = 10,
    #[doc = "< Maximum pitch in bytes allowed by memory copies"]
    cudaDevAttrMaxPitch = 11,
    #[doc = "< Maximum number of 32-bit registers available per block"]
    cudaDevAttrMaxRegistersPerBlock = 12,
    #[doc = "< Peak clock frequency in kilohertz"]
    cudaDevAttrClockRate = 13,
    #[doc = "< Alignment requirement for textures"]
    cudaDevAttrTextureAlignment = 14,
    #[doc = "< Device can possibly copy memory and execute a kernel concurrently"]
    cudaDevAttrGpuOverlap = 15,
    #[doc = "< Number of multiprocessors on device"]
    cudaDevAttrMultiProcessorCount = 16,
    #[doc = "< Specifies whether there is a run time limit on kernels"]
    cudaDevAttrKernelExecTimeout = 17,
    #[doc = "< Device is integrated with host memory"]
    cudaDevAttrIntegrated = 18,
    #[doc = "< Device can map host memory into CUDA address space"]
    cudaDevAttrCanMapHostMemory = 19,
    #[doc = "< Compute mode (See ::cudaComputeMode for details)"]
    cudaDevAttrComputeMode = 20,
    #[doc = "< Maximum 1D texture width"]
    cudaDevAttrMaxTexture1DWidth = 21,
    #[doc = "< Maximum 2D texture width"]
    cudaDevAttrMaxTexture2DWidth = 22,
    #[doc = "< Maximum 2D texture height"]
    cudaDevAttrMaxTexture2DHeight = 23,
    #[doc = "< Maximum 3D texture width"]
    cudaDevAttrMaxTexture3DWidth = 24,
    #[doc = "< Maximum 3D texture height"]
    cudaDevAttrMaxTexture3DHeight = 25,
    #[doc = "< Maximum 3D texture depth"]
    cudaDevAttrMaxTexture3DDepth = 26,
    #[doc = "< Maximum 2D layered texture width"]
    cudaDevAttrMaxTexture2DLayeredWidth = 27,
    #[doc = "< Maximum 2D layered texture height"]
    cudaDevAttrMaxTexture2DLayeredHeight = 28,
    #[doc = "< Maximum layers in a 2D layered texture"]
    cudaDevAttrMaxTexture2DLayeredLayers = 29,
    #[doc = "< Alignment requirement for surfaces"]
    cudaDevAttrSurfaceAlignment = 30,
    #[doc = "< Device can possibly execute multiple kernels concurrently"]
    cudaDevAttrConcurrentKernels = 31,
    #[doc = "< Device has ECC support enabled"]
    cudaDevAttrEccEnabled = 32,
    #[doc = "< PCI bus ID of the device"]
    cudaDevAttrPciBusId = 33,
    #[doc = "< PCI device ID of the device"]
    cudaDevAttrPciDeviceId = 34,
    #[doc = "< Device is using TCC driver model"]
    cudaDevAttrTccDriver = 35,
    #[doc = "< Peak memory clock frequency in kilohertz"]
    cudaDevAttrMemoryClockRate = 36,
    #[doc = "< Global memory bus width in bits"]
    cudaDevAttrGlobalMemoryBusWidth = 37,
    #[doc = "< Size of L2 cache in bytes"]
    cudaDevAttrL2CacheSize = 38,
    #[doc = "< Maximum resident threads per multiprocessor"]
    cudaDevAttrMaxThreadsPerMultiProcessor = 39,
    #[doc = "< Number of asynchronous engines"]
    cudaDevAttrAsyncEngineCount = 40,
    #[doc = "< Device shares a unified address space with the host"]
    cudaDevAttrUnifiedAddressing = 41,
    #[doc = "< Maximum 1D layered texture width"]
    cudaDevAttrMaxTexture1DLayeredWidth = 42,
    #[doc = "< Maximum layers in a 1D layered texture"]
    cudaDevAttrMaxTexture1DLayeredLayers = 43,
    #[doc = "< Maximum 2D texture width if cudaArrayTextureGather is set"]
    cudaDevAttrMaxTexture2DGatherWidth = 45,
    #[doc = "< Maximum 2D texture height if cudaArrayTextureGather is set"]
    cudaDevAttrMaxTexture2DGatherHeight = 46,
    #[doc = "< Alternate maximum 3D texture width"]
    cudaDevAttrMaxTexture3DWidthAlt = 47,
    #[doc = "< Alternate maximum 3D texture height"]
    cudaDevAttrMaxTexture3DHeightAlt = 48,
    #[doc = "< Alternate maximum 3D texture depth"]
    cudaDevAttrMaxTexture3DDepthAlt = 49,
    #[doc = "< PCI domain ID of the device"]
    cudaDevAttrPciDomainId = 50,
    #[doc = "< Pitch alignment requirement for textures"]
    cudaDevAttrTexturePitchAlignment = 51,
    #[doc = "< Maximum cubemap texture width/height"]
    cudaDevAttrMaxTextureCubemapWidth = 52,
    #[doc = "< Maximum cubemap layered texture width/height"]
    cudaDevAttrMaxTextureCubemapLayeredWidth = 53,
    #[doc = "< Maximum layers in a cubemap layered texture"]
    cudaDevAttrMaxTextureCubemapLayeredLayers = 54,
    #[doc = "< Maximum 1D surface width"]
    cudaDevAttrMaxSurface1DWidth = 55,
    #[doc = "< Maximum 2D surface width"]
    cudaDevAttrMaxSurface2DWidth = 56,
    #[doc = "< Maximum 2D surface height"]
    cudaDevAttrMaxSurface2DHeight = 57,
    #[doc = "< Maximum 3D surface width"]
    cudaDevAttrMaxSurface3DWidth = 58,
    #[doc = "< Maximum 3D surface height"]
    cudaDevAttrMaxSurface3DHeight = 59,
    #[doc = "< Maximum 3D surface depth"]
    cudaDevAttrMaxSurface3DDepth = 60,
    #[doc = "< Maximum 1D layered surface width"]
    cudaDevAttrMaxSurface1DLayeredWidth = 61,
    #[doc = "< Maximum layers in a 1D layered surface"]
    cudaDevAttrMaxSurface1DLayeredLayers = 62,
    #[doc = "< Maximum 2D layered surface width"]
    cudaDevAttrMaxSurface2DLayeredWidth = 63,
    #[doc = "< Maximum 2D layered surface height"]
    cudaDevAttrMaxSurface2DLayeredHeight = 64,
    #[doc = "< Maximum layers in a 2D layered surface"]
    cudaDevAttrMaxSurface2DLayeredLayers = 65,
    #[doc = "< Maximum cubemap surface width"]
    cudaDevAttrMaxSurfaceCubemapWidth = 66,
    #[doc = "< Maximum cubemap layered surface width"]
    cudaDevAttrMaxSurfaceCubemapLayeredWidth = 67,
    #[doc = "< Maximum layers in a cubemap layered surface"]
    cudaDevAttrMaxSurfaceCubemapLayeredLayers = 68,
    #[doc = "< Maximum 1D linear texture width"]
    cudaDevAttrMaxTexture1DLinearWidth = 69,
    #[doc = "< Maximum 2D linear texture width"]
    cudaDevAttrMaxTexture2DLinearWidth = 70,
    #[doc = "< Maximum 2D linear texture height"]
    cudaDevAttrMaxTexture2DLinearHeight = 71,
    #[doc = "< Maximum 2D linear texture pitch in bytes"]
    cudaDevAttrMaxTexture2DLinearPitch = 72,
    #[doc = "< Maximum mipmapped 2D texture width"]
    cudaDevAttrMaxTexture2DMipmappedWidth = 73,
    #[doc = "< Maximum mipmapped 2D texture height"]
    cudaDevAttrMaxTexture2DMipmappedHeight = 74,
    #[doc = "< Major compute capability version number"]
    cudaDevAttrComputeCapabilityMajor = 75,
    #[doc = "< Minor compute capability version number"]
    cudaDevAttrComputeCapabilityMinor = 76,
    #[doc = "< Maximum mipmapped 1D texture width"]
    cudaDevAttrMaxTexture1DMipmappedWidth = 77,
    #[doc = "< Device supports stream priorities"]
    cudaDevAttrStreamPrioritiesSupported = 78,
    #[doc = "< Device supports caching globals in L1"]
    cudaDevAttrGlobalL1CacheSupported = 79,
    #[doc = "< Device supports caching locals in L1"]
    cudaDevAttrLocalL1CacheSupported = 80,
    #[doc = "< Maximum shared memory available per multiprocessor in bytes"]
    cudaDevAttrMaxSharedMemoryPerMultiprocessor = 81,
    #[doc = "< Maximum number of 32-bit registers available per multiprocessor"]
    cudaDevAttrMaxRegistersPerMultiprocessor = 82,
    #[doc = "< Device can allocate managed memory on this system"]
    cudaDevAttrManagedMemory = 83,
    #[doc = "< Device is on a multi-GPU board"]
    cudaDevAttrIsMultiGpuBoard = 84,
    #[doc = "< Unique identifier for a group of devices on the same multi-GPU board"]
    cudaDevAttrMultiGpuBoardGroupID = 85,
    #[doc = "< Link between the device and the host supports native atomic operations"]
    cudaDevAttrHostNativeAtomicSupported = 86,
    #[doc = "< Ratio of single precision performance (in floating-point operations per second) to double precision performance"]
    cudaDevAttrSingleToDoublePrecisionPerfRatio = 87,
    #[doc = "< Device supports coherently accessing pageable memory without calling cudaHostRegister on it"]
    cudaDevAttrPageableMemoryAccess = 88,
    #[doc = "< Device can coherently access managed memory concurrently with the CPU"]
    cudaDevAttrConcurrentManagedAccess = 89,
    #[doc = "< Device supports Compute Preemption"]
    cudaDevAttrComputePreemptionSupported = 90,
    #[doc = "< Device can access host registered memory at the same virtual address as the CPU"]
    cudaDevAttrCanUseHostPointerForRegisteredMem = 91,
    cudaDevAttrReserved92 = 92,
    cudaDevAttrReserved93 = 93,
    cudaDevAttrReserved94 = 94,
    #[doc = "< Device supports launching cooperative kernels via ::cudaLaunchCooperativeKernel"]
    cudaDevAttrCooperativeLaunch = 95,
    #[doc = "< Deprecated, cudaLaunchCooperativeKernelMultiDevice is deprecated."]
    cudaDevAttrCooperativeMultiDeviceLaunch = 96,
    #[doc = "< The maximum optin shared memory per block. This value may vary by chip. See ::cudaFuncSetAttribute"]
    cudaDevAttrMaxSharedMemoryPerBlockOptin = 97,
    #[doc = "< Device supports flushing of outstanding remote writes."]
    cudaDevAttrCanFlushRemoteWrites = 98,
    #[doc = "< Device supports host memory registration via ::cudaHostRegister."]
    cudaDevAttrHostRegisterSupported = 99,
    #[doc = "< Device accesses pageable memory via the host's page tables."]
    cudaDevAttrPageableMemoryAccessUsesHostPageTables = 100,
    #[doc = "< Host can directly access managed memory on the device without migration."]
    cudaDevAttrDirectManagedMemAccessFromHost = 101,
    #[doc = "< Maximum number of blocks per multiprocessor"]
    cudaDevAttrMaxBlocksPerMultiprocessor = 106,
    #[doc = "< Maximum L2 persisting lines capacity setting in bytes."]
    cudaDevAttrMaxPersistingL2CacheSize = 108,
    #[doc = "< Maximum value of cudaAccessPolicyWindow::num_bytes."]
    cudaDevAttrMaxAccessPolicyWindowSize = 109,
    #[doc = "< Shared memory reserved by CUDA driver per block in bytes"]
    cudaDevAttrReservedSharedMemoryPerBlock = 111,
    #[doc = "< Device supports sparse CUDA arrays and sparse CUDA mipmapped arrays"]
    cudaDevAttrSparseCudaArraySupported = 112,
    #[doc = "< Device supports using the ::cudaHostRegister flag cudaHostRegisterReadOnly to register memory that must be mapped as read-only to the GPU"]
    cudaDevAttrHostRegisterReadOnlySupported = 113,
    #[doc = "< External timeline semaphore interop is supported on the device"]
    cudaDevAttrMaxTimelineSemaphoreInteropSupported = 114,
    #[doc = "< Device supports using the ::cudaMallocAsync and ::cudaMemPool family of APIs"]
    cudaDevAttrMemoryPoolsSupported = 115,
    #[doc = "< Device supports GPUDirect RDMA APIs, like nvidia_p2p_get_pages (see https://docs.nvidia.com/cuda/gpudirect-rdma for more information)"]
    cudaDevAttrGPUDirectRDMASupported = 116,
    #[doc = "< The returned attribute shall be interpreted as a bitmask, where the individual bits are listed in the ::cudaFlushGPUDirectRDMAWritesOptions enum"]
    cudaDevAttrGPUDirectRDMAFlushWritesOptions = 117,
    #[doc = "< GPUDirect RDMA writes to the device do not need to be flushed for consumers within the scope indicated by the returned attribute. See ::cudaGPUDirectRDMAWritesOrdering for the numerical values returned here."]
    cudaDevAttrGPUDirectRDMAWritesOrdering = 118,
    #[doc = "< Handle types supported with mempool based IPC"]
    cudaDevAttrMemoryPoolSupportedHandleTypes = 119,
    cudaDevAttrMax = 120,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA memory pool attributes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaMemPoolAttr {
    #[doc = " (value type = int)"]
    #[doc = " Allow cuMemAllocAsync to use memory asynchronously freed"]
    #[doc = " in another streams as long as a stream ordering dependency"]
    #[doc = " of the allocating stream on the free action exists."]
    #[doc = " Cuda events and null stream interactions can create the required"]
    #[doc = " stream ordered dependencies. (default enabled)"]
    cudaMemPoolReuseFollowEventDependencies = 1,
    #[doc = " (value type = int)"]
    #[doc = " Allow reuse of already completed frees when there is no dependency"]
    #[doc = " between the free and allocation. (default enabled)"]
    cudaMemPoolReuseAllowOpportunistic = 2,
    #[doc = " (value type = int)"]
    #[doc = " Allow cuMemAllocAsync to insert new stream dependencies"]
    #[doc = " in order to establish the stream ordering required to reuse"]
    #[doc = " a piece of memory released by cuFreeAsync (default enabled)."]
    cudaMemPoolReuseAllowInternalDependencies = 3,
    #[doc = " (value type = cuuint64_t)"]
    #[doc = " Amount of reserved memory in bytes to hold onto before trying"]
    #[doc = " to release memory back to the OS. When more than the release"]
    #[doc = " threshold bytes of memory are held by the memory pool, the"]
    #[doc = " allocator will try to release memory back to the OS on the"]
    #[doc = " next call to stream, event or context synchronize. (default 0)"]
    cudaMemPoolAttrReleaseThreshold = 4,
    #[doc = " (value type = cuuint64_t)"]
    #[doc = " Amount of backing memory currently allocated for the mempool."]
    cudaMemPoolAttrReservedMemCurrent = 5,
    #[doc = " (value type = cuuint64_t)"]
    #[doc = " High watermark of backing memory allocated for the mempool since the"]
    #[doc = " last time it was reset. High watermark can only be reset to zero."]
    cudaMemPoolAttrReservedMemHigh = 6,
    #[doc = " (value type = cuuint64_t)"]
    #[doc = " Amount of memory from the pool that is currently in use by the application."]
    cudaMemPoolAttrUsedMemCurrent = 7,
    #[doc = " (value type = cuuint64_t)"]
    #[doc = " High watermark of the amount of memory from the pool that was in use by the application since"]
    #[doc = " the last time it was reset. High watermark can only be reset to zero."]
    cudaMemPoolAttrUsedMemHigh = 8,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Specifies the type of location"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaMemLocationType {
    cudaMemLocationTypeInvalid = 0,
    #[doc = "< Location is a device location, thus id is a device ordinal"]
    cudaMemLocationTypeDevice = 1,
}
#[doc = " Specifies a memory location."]
#[doc = ""]
#[doc = " To specify a gpu, set type = ::cudaMemLocationTypeDevice and set id = the gpu's device ordinal."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaMemLocation {
    #[doc = "< Specifies the location type, which modifies the meaning of id."]
    pub type_: cudaMemLocationType,
    #[doc = "< identifier for a given this location's ::CUmemLocationType."]
    pub id: ::libc::c_int,
}
#[test]
fn bindgen_test_layout_cudaMemLocation() {
    assert_eq!(
        ::std::mem::size_of::<cudaMemLocation>(),
        8usize,
        concat!("Size of: ", stringify!(cudaMemLocation))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaMemLocation>(),
        4usize,
        concat!("Alignment of ", stringify!(cudaMemLocation))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemLocation>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemLocation),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemLocation>())).id as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemLocation),
            "::",
            stringify!(id)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Specifies the memory protection flags for mapping."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaMemAccessFlags {
    #[doc = "< Default, make the address range not accessible"]
    cudaMemAccessFlagsProtNone = 0,
    #[doc = "< Make the address range read accessible"]
    cudaMemAccessFlagsProtRead = 1,
    #[doc = "< Make the address range read-write accessible"]
    cudaMemAccessFlagsProtReadWrite = 3,
}
#[doc = " Memory access descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaMemAccessDesc {
    #[doc = "< Location on which the request is to change it's accessibility"]
    pub location: cudaMemLocation,
    #[doc = "< ::CUmemProt accessibility flags to set on the request"]
    pub flags: cudaMemAccessFlags,
}
#[test]
fn bindgen_test_layout_cudaMemAccessDesc() {
    assert_eq!(
        ::std::mem::size_of::<cudaMemAccessDesc>(),
        12usize,
        concat!("Size of: ", stringify!(cudaMemAccessDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaMemAccessDesc>(),
        4usize,
        concat!("Alignment of ", stringify!(cudaMemAccessDesc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemAccessDesc>())).location as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemAccessDesc),
            "::",
            stringify!(location)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemAccessDesc>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemAccessDesc),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Defines the allocation types available"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaMemAllocationType {
    cudaMemAllocationTypeInvalid = 0,
    #[doc = " This allocation type is 'pinned', i.e. cannot migrate from its current"]
    #[doc = " location while the application is actively using it"]
    cudaMemAllocationTypePinned = 1,
    #[doc = " This allocation type is 'pinned', i.e. cannot migrate from its current"]
    #[doc = " location while the application is actively using it"]
    cudaMemAllocationTypeMax = 2147483647,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Flags for specifying particular handle types"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaMemAllocationHandleType {
    #[doc = "< Does not allow any export mechanism. >"]
    cudaMemHandleTypeNone = 0,
    #[doc = "< Allows a file descriptor to be used for exporting. Permitted only on POSIX systems. (int)"]
    cudaMemHandleTypePosixFileDescriptor = 1,
    #[doc = "< Allows a Win32 NT handle to be used for exporting. (HANDLE)"]
    cudaMemHandleTypeWin32 = 2,
    #[doc = "< Allows a Win32 KMT handle to be used for exporting. (D3DKMT_HANDLE)"]
    cudaMemHandleTypeWin32Kmt = 4,
}
#[doc = " Specifies the properties of allocations made from the pool."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaMemPoolProps {
    #[doc = "< Allocation type. Currently must be specified as cudaMemAllocationTypePinned"]
    pub allocType: cudaMemAllocationType,
    #[doc = "< Handle types that will be supported by allocations from the pool."]
    pub handleTypes: cudaMemAllocationHandleType,
    #[doc = "< Location allocations should reside."]
    pub location: cudaMemLocation,
    #[doc = " Windows-specific LPSECURITYATTRIBUTES required when"]
    #[doc = " ::cudaMemHandleTypeWin32 is specified.  This security attribute defines"]
    #[doc = " the scope of which exported allocations may be tranferred to other"]
    #[doc = " processes.  In all other cases, this field is required to be zero."]
    pub win32SecurityAttributes: *mut ::libc::c_void,
    #[doc = "< reserved for future use, must be 0"]
    pub reserved: [::libc::c_uchar; 64usize],
}
#[test]
fn bindgen_test_layout_cudaMemPoolProps() {
    assert_eq!(
        ::std::mem::size_of::<cudaMemPoolProps>(),
        88usize,
        concat!("Size of: ", stringify!(cudaMemPoolProps))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaMemPoolProps>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaMemPoolProps))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemPoolProps>())).allocType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemPoolProps),
            "::",
            stringify!(allocType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemPoolProps>())).handleTypes as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemPoolProps),
            "::",
            stringify!(handleTypes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemPoolProps>())).location as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemPoolProps),
            "::",
            stringify!(location)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaMemPoolProps>())).win32SecurityAttributes as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemPoolProps),
            "::",
            stringify!(win32SecurityAttributes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemPoolProps>())).reserved as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemPoolProps),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Opaque data for exporting a pool allocation"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaMemPoolPtrExportData {
    pub reserved: [::libc::c_uchar; 64usize],
}
#[test]
fn bindgen_test_layout_cudaMemPoolPtrExportData() {
    assert_eq!(
        ::std::mem::size_of::<cudaMemPoolPtrExportData>(),
        64usize,
        concat!("Size of: ", stringify!(cudaMemPoolPtrExportData))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaMemPoolPtrExportData>(),
        1usize,
        concat!("Alignment of ", stringify!(cudaMemPoolPtrExportData))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaMemPoolPtrExportData>())).reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemPoolPtrExportData),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Memory allocation node parameters"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaMemAllocNodeParams {
    #[doc = "< in: array of memory access descriptors. Used to describe peer GPU access"]
    pub poolProps: cudaMemPoolProps,
    #[doc = "< in: number of memory access descriptors.  Must not exceed the number of GPUs."]
    pub accessDescs: *const cudaMemAccessDesc,
    #[doc = "< in: Number of `accessDescs`s"]
    pub accessDescCount: usize,
    #[doc = "< in: size in bytes of the requested allocation"]
    pub bytesize: usize,
    #[doc = "< out: address of the allocation returned by CUDA"]
    pub dptr: *mut ::libc::c_void,
}
#[test]
fn bindgen_test_layout_cudaMemAllocNodeParams() {
    assert_eq!(
        ::std::mem::size_of::<cudaMemAllocNodeParams>(),
        120usize,
        concat!("Size of: ", stringify!(cudaMemAllocNodeParams))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaMemAllocNodeParams>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaMemAllocNodeParams))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaMemAllocNodeParams>())).poolProps as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemAllocNodeParams),
            "::",
            stringify!(poolProps)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaMemAllocNodeParams>())).accessDescs as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemAllocNodeParams),
            "::",
            stringify!(accessDescs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaMemAllocNodeParams>())).accessDescCount as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemAllocNodeParams),
            "::",
            stringify!(accessDescCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemAllocNodeParams>())).bytesize as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemAllocNodeParams),
            "::",
            stringify!(bytesize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaMemAllocNodeParams>())).dptr as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaMemAllocNodeParams),
            "::",
            stringify!(dptr)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Graph memory attributes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaGraphMemAttributeType {
    #[doc = " (value type = cuuint64_t)"]
    #[doc = " Amount of memory, in bytes, currently associated with graphs."]
    cudaGraphMemAttrUsedMemCurrent = 1,
    #[doc = " (value type = cuuint64_t)"]
    #[doc = " High watermark of memory, in bytes, associated with graphs since the"]
    #[doc = " last time it was reset.  High watermark can only be reset to zero."]
    cudaGraphMemAttrUsedMemHigh = 2,
    #[doc = " (value type = cuuint64_t)"]
    #[doc = " Amount of memory, in bytes, currently allocated for use by"]
    #[doc = " the CUDA graphs asynchronous allocator."]
    cudaGraphMemAttrReservedMemCurrent = 3,
    #[doc = " (value type = cuuint64_t)"]
    #[doc = " High watermark of memory, in bytes, currently allocated for use by"]
    #[doc = " the CUDA graphs asynchronous allocator."]
    cudaGraphMemAttrReservedMemHigh = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA device P2P attributes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaDeviceP2PAttr {
    #[doc = "< A relative value indicating the performance of the link between two devices"]
    cudaDevP2PAttrPerformanceRank = 1,
    #[doc = "< Peer access is enabled"]
    cudaDevP2PAttrAccessSupported = 2,
    #[doc = "< Native atomic operation over the link supported"]
    cudaDevP2PAttrNativeAtomicSupported = 3,
    #[doc = "< Accessing CUDA arrays over the link supported"]
    cudaDevP2PAttrCudaArrayAccessSupported = 4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUuuid_st {
    pub bytes: [::libc::c_char; 16usize],
}
#[test]
fn bindgen_test_layout_CUuuid_st() {
    assert_eq!(
        ::std::mem::size_of::<CUuuid_st>(),
        16usize,
        concat!("Size of: ", stringify!(CUuuid_st))
    );
    assert_eq!(
        ::std::mem::align_of::<CUuuid_st>(),
        1usize,
        concat!("Alignment of ", stringify!(CUuuid_st))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CUuuid_st>())).bytes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CUuuid_st),
            "::",
            stringify!(bytes)
        )
    );
}
pub type CUuuid = CUuuid_st;
pub type cudaUUID_t = CUuuid_st;
#[doc = " CUDA device properties"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaDeviceProp {
    #[doc = "< ASCII string identifying device"]
    pub name: [::libc::c_char; 256usize],
    #[doc = "< 16-byte unique identifier"]
    pub uuid: cudaUUID_t,
    #[doc = "< 8-byte locally unique identifier. Value is undefined on TCC and non-Windows platforms"]
    pub luid: [::libc::c_char; 8usize],
    #[doc = "< LUID device node mask. Value is undefined on TCC and non-Windows platforms"]
    pub luidDeviceNodeMask: ::libc::c_uint,
    #[doc = "< Global memory available on device in bytes"]
    pub totalGlobalMem: usize,
    #[doc = "< Shared memory available per block in bytes"]
    pub sharedMemPerBlock: usize,
    #[doc = "< 32-bit registers available per block"]
    pub regsPerBlock: ::libc::c_int,
    #[doc = "< Warp size in threads"]
    pub warpSize: ::libc::c_int,
    #[doc = "< Maximum pitch in bytes allowed by memory copies"]
    pub memPitch: usize,
    #[doc = "< Maximum number of threads per block"]
    pub maxThreadsPerBlock: ::libc::c_int,
    #[doc = "< Maximum size of each dimension of a block"]
    pub maxThreadsDim: [::libc::c_int; 3usize],
    #[doc = "< Maximum size of each dimension of a grid"]
    pub maxGridSize: [::libc::c_int; 3usize],
    #[doc = "< Clock frequency in kilohertz"]
    pub clockRate: ::libc::c_int,
    #[doc = "< Constant memory available on device in bytes"]
    pub totalConstMem: usize,
    #[doc = "< Major compute capability"]
    pub major: ::libc::c_int,
    #[doc = "< Minor compute capability"]
    pub minor: ::libc::c_int,
    #[doc = "< Alignment requirement for textures"]
    pub textureAlignment: usize,
    #[doc = "< Pitch alignment requirement for texture references bound to pitched memory"]
    pub texturePitchAlignment: usize,
    #[doc = "< Device can concurrently copy memory and execute a kernel. Deprecated. Use instead asyncEngineCount."]
    pub deviceOverlap: ::libc::c_int,
    #[doc = "< Number of multiprocessors on device"]
    pub multiProcessorCount: ::libc::c_int,
    #[doc = "< Specified whether there is a run time limit on kernels"]
    pub kernelExecTimeoutEnabled: ::libc::c_int,
    #[doc = "< Device is integrated as opposed to discrete"]
    pub integrated: ::libc::c_int,
    #[doc = "< Device can map host memory with cudaHostAlloc/cudaHostGetDevicePointer"]
    pub canMapHostMemory: ::libc::c_int,
    #[doc = "< Compute mode (See ::cudaComputeMode)"]
    pub computeMode: ::libc::c_int,
    #[doc = "< Maximum 1D texture size"]
    pub maxTexture1D: ::libc::c_int,
    #[doc = "< Maximum 1D mipmapped texture size"]
    pub maxTexture1DMipmap: ::libc::c_int,
    #[doc = "< Deprecated, do not use. Use cudaDeviceGetTexture1DLinearMaxWidth() or cuDeviceGetTexture1DLinearMaxWidth() instead."]
    pub maxTexture1DLinear: ::libc::c_int,
    #[doc = "< Maximum 2D texture dimensions"]
    pub maxTexture2D: [::libc::c_int; 2usize],
    #[doc = "< Maximum 2D mipmapped texture dimensions"]
    pub maxTexture2DMipmap: [::libc::c_int; 2usize],
    #[doc = "< Maximum dimensions (width, height, pitch) for 2D textures bound to pitched memory"]
    pub maxTexture2DLinear: [::libc::c_int; 3usize],
    #[doc = "< Maximum 2D texture dimensions if texture gather operations have to be performed"]
    pub maxTexture2DGather: [::libc::c_int; 2usize],
    #[doc = "< Maximum 3D texture dimensions"]
    pub maxTexture3D: [::libc::c_int; 3usize],
    #[doc = "< Maximum alternate 3D texture dimensions"]
    pub maxTexture3DAlt: [::libc::c_int; 3usize],
    #[doc = "< Maximum Cubemap texture dimensions"]
    pub maxTextureCubemap: ::libc::c_int,
    #[doc = "< Maximum 1D layered texture dimensions"]
    pub maxTexture1DLayered: [::libc::c_int; 2usize],
    #[doc = "< Maximum 2D layered texture dimensions"]
    pub maxTexture2DLayered: [::libc::c_int; 3usize],
    #[doc = "< Maximum Cubemap layered texture dimensions"]
    pub maxTextureCubemapLayered: [::libc::c_int; 2usize],
    #[doc = "< Maximum 1D surface size"]
    pub maxSurface1D: ::libc::c_int,
    #[doc = "< Maximum 2D surface dimensions"]
    pub maxSurface2D: [::libc::c_int; 2usize],
    #[doc = "< Maximum 3D surface dimensions"]
    pub maxSurface3D: [::libc::c_int; 3usize],
    #[doc = "< Maximum 1D layered surface dimensions"]
    pub maxSurface1DLayered: [::libc::c_int; 2usize],
    #[doc = "< Maximum 2D layered surface dimensions"]
    pub maxSurface2DLayered: [::libc::c_int; 3usize],
    #[doc = "< Maximum Cubemap surface dimensions"]
    pub maxSurfaceCubemap: ::libc::c_int,
    #[doc = "< Maximum Cubemap layered surface dimensions"]
    pub maxSurfaceCubemapLayered: [::libc::c_int; 2usize],
    #[doc = "< Alignment requirements for surfaces"]
    pub surfaceAlignment: usize,
    #[doc = "< Device can possibly execute multiple kernels concurrently"]
    pub concurrentKernels: ::libc::c_int,
    #[doc = "< Device has ECC support enabled"]
    pub ECCEnabled: ::libc::c_int,
    #[doc = "< PCI bus ID of the device"]
    pub pciBusID: ::libc::c_int,
    #[doc = "< PCI device ID of the device"]
    pub pciDeviceID: ::libc::c_int,
    #[doc = "< PCI domain ID of the device"]
    pub pciDomainID: ::libc::c_int,
    #[doc = "< 1 if device is a Tesla device using TCC driver, 0 otherwise"]
    pub tccDriver: ::libc::c_int,
    #[doc = "< Number of asynchronous engines"]
    pub asyncEngineCount: ::libc::c_int,
    #[doc = "< Device shares a unified address space with the host"]
    pub unifiedAddressing: ::libc::c_int,
    #[doc = "< Peak memory clock frequency in kilohertz"]
    pub memoryClockRate: ::libc::c_int,
    #[doc = "< Global memory bus width in bits"]
    pub memoryBusWidth: ::libc::c_int,
    #[doc = "< Size of L2 cache in bytes"]
    pub l2CacheSize: ::libc::c_int,
    #[doc = "< Device's maximum l2 persisting lines capacity setting in bytes"]
    pub persistingL2CacheMaxSize: ::libc::c_int,
    #[doc = "< Maximum resident threads per multiprocessor"]
    pub maxThreadsPerMultiProcessor: ::libc::c_int,
    #[doc = "< Device supports stream priorities"]
    pub streamPrioritiesSupported: ::libc::c_int,
    #[doc = "< Device supports caching globals in L1"]
    pub globalL1CacheSupported: ::libc::c_int,
    #[doc = "< Device supports caching locals in L1"]
    pub localL1CacheSupported: ::libc::c_int,
    #[doc = "< Shared memory available per multiprocessor in bytes"]
    pub sharedMemPerMultiprocessor: usize,
    #[doc = "< 32-bit registers available per multiprocessor"]
    pub regsPerMultiprocessor: ::libc::c_int,
    #[doc = "< Device supports allocating managed memory on this system"]
    pub managedMemory: ::libc::c_int,
    #[doc = "< Device is on a multi-GPU board"]
    pub isMultiGpuBoard: ::libc::c_int,
    #[doc = "< Unique identifier for a group of devices on the same multi-GPU board"]
    pub multiGpuBoardGroupID: ::libc::c_int,
    #[doc = "< Link between the device and the host supports native atomic operations"]
    pub hostNativeAtomicSupported: ::libc::c_int,
    #[doc = "< Ratio of single precision performance (in floating-point operations per second) to double precision performance"]
    pub singleToDoublePrecisionPerfRatio: ::libc::c_int,
    #[doc = "< Device supports coherently accessing pageable memory without calling cudaHostRegister on it"]
    pub pageableMemoryAccess: ::libc::c_int,
    #[doc = "< Device can coherently access managed memory concurrently with the CPU"]
    pub concurrentManagedAccess: ::libc::c_int,
    #[doc = "< Device supports Compute Preemption"]
    pub computePreemptionSupported: ::libc::c_int,
    #[doc = "< Device can access host registered memory at the same virtual address as the CPU"]
    pub canUseHostPointerForRegisteredMem: ::libc::c_int,
    #[doc = "< Device supports launching cooperative kernels via ::cudaLaunchCooperativeKernel"]
    pub cooperativeLaunch: ::libc::c_int,
    #[doc = "< Deprecated, cudaLaunchCooperativeKernelMultiDevice is deprecated."]
    pub cooperativeMultiDeviceLaunch: ::libc::c_int,
    #[doc = "< Per device maximum shared memory per block usable by special opt in"]
    pub sharedMemPerBlockOptin: usize,
    #[doc = "< Device accesses pageable memory via the host's page tables"]
    pub pageableMemoryAccessUsesHostPageTables: ::libc::c_int,
    #[doc = "< Host can directly access managed memory on the device without migration."]
    pub directManagedMemAccessFromHost: ::libc::c_int,
    #[doc = "< Maximum number of resident blocks per multiprocessor"]
    pub maxBlocksPerMultiProcessor: ::libc::c_int,
    #[doc = "< The maximum value of ::cudaAccessPolicyWindow::num_bytes."]
    pub accessPolicyMaxWindowSize: ::libc::c_int,
    #[doc = "< Shared memory reserved by CUDA driver per block in bytes"]
    pub reservedSharedMemPerBlock: usize,
}
#[test]
fn bindgen_test_layout_cudaDeviceProp() {
    assert_eq!(
        ::std::mem::size_of::<cudaDeviceProp>(),
        728usize,
        concat!("Size of: ", stringify!(cudaDeviceProp))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaDeviceProp>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaDeviceProp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).uuid as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).luid as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(luid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).luidDeviceNodeMask as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(luidDeviceNodeMask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).totalGlobalMem as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(totalGlobalMem)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).sharedMemPerBlock as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(sharedMemPerBlock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).regsPerBlock as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(regsPerBlock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).warpSize as *const _ as usize },
        308usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(warpSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).memPitch as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(memPitch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxThreadsPerBlock as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxThreadsPerBlock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).maxThreadsDim as *const _ as usize },
        324usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxThreadsDim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).maxGridSize as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxGridSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).clockRate as *const _ as usize },
        348usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(clockRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).totalConstMem as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(totalConstMem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).major as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(major)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).minor as *const _ as usize },
        364usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(minor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).textureAlignment as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(textureAlignment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).texturePitchAlignment as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(texturePitchAlignment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).deviceOverlap as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(deviceOverlap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).multiProcessorCount as *const _ as usize
        },
        388usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(multiProcessorCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).kernelExecTimeoutEnabled as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(kernelExecTimeoutEnabled)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).integrated as *const _ as usize },
        396usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(integrated)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).canMapHostMemory as *const _ as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(canMapHostMemory)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).computeMode as *const _ as usize },
        404usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(computeMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).maxTexture1D as *const _ as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTexture1D)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxTexture1DMipmap as *const _ as usize
        },
        412usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTexture1DMipmap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxTexture1DLinear as *const _ as usize
        },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTexture1DLinear)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).maxTexture2D as *const _ as usize },
        420usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTexture2D)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxTexture2DMipmap as *const _ as usize
        },
        428usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTexture2DMipmap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxTexture2DLinear as *const _ as usize
        },
        436usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTexture2DLinear)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxTexture2DGather as *const _ as usize
        },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTexture2DGather)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).maxTexture3D as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTexture3D)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).maxTexture3DAlt as *const _ as usize },
        468usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTexture3DAlt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxTextureCubemap as *const _ as usize
        },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTextureCubemap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxTexture1DLayered as *const _ as usize
        },
        484usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTexture1DLayered)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxTexture2DLayered as *const _ as usize
        },
        492usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTexture2DLayered)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxTextureCubemapLayered as *const _ as usize
        },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxTextureCubemapLayered)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).maxSurface1D as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxSurface1D)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).maxSurface2D as *const _ as usize },
        516usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxSurface2D)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).maxSurface3D as *const _ as usize },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxSurface3D)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxSurface1DLayered as *const _ as usize
        },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxSurface1DLayered)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxSurface2DLayered as *const _ as usize
        },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxSurface2DLayered)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxSurfaceCubemap as *const _ as usize
        },
        556usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxSurfaceCubemap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxSurfaceCubemapLayered as *const _ as usize
        },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxSurfaceCubemapLayered)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).surfaceAlignment as *const _ as usize },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(surfaceAlignment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).concurrentKernels as *const _ as usize
        },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(concurrentKernels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).ECCEnabled as *const _ as usize },
        580usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(ECCEnabled)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).pciBusID as *const _ as usize },
        584usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(pciBusID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).pciDeviceID as *const _ as usize },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(pciDeviceID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).pciDomainID as *const _ as usize },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(pciDomainID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).tccDriver as *const _ as usize },
        596usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(tccDriver)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).asyncEngineCount as *const _ as usize },
        600usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(asyncEngineCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).unifiedAddressing as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(unifiedAddressing)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).memoryClockRate as *const _ as usize },
        608usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(memoryClockRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).memoryBusWidth as *const _ as usize },
        612usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(memoryBusWidth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).l2CacheSize as *const _ as usize },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(l2CacheSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).persistingL2CacheMaxSize as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(persistingL2CacheMaxSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxThreadsPerMultiProcessor as *const _
                as usize
        },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxThreadsPerMultiProcessor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).streamPrioritiesSupported as *const _
                as usize
        },
        628usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(streamPrioritiesSupported)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).globalL1CacheSupported as *const _ as usize
        },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(globalL1CacheSupported)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).localL1CacheSupported as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(localL1CacheSupported)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).sharedMemPerMultiprocessor as *const _
                as usize
        },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(sharedMemPerMultiprocessor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).regsPerMultiprocessor as *const _ as usize
        },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(regsPerMultiprocessor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).managedMemory as *const _ as usize },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(managedMemory)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaDeviceProp>())).isMultiGpuBoard as *const _ as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(isMultiGpuBoard)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).multiGpuBoardGroupID as *const _ as usize
        },
        660usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(multiGpuBoardGroupID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).hostNativeAtomicSupported as *const _
                as usize
        },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(hostNativeAtomicSupported)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).singleToDoublePrecisionPerfRatio as *const _
                as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(singleToDoublePrecisionPerfRatio)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).pageableMemoryAccess as *const _ as usize
        },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(pageableMemoryAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).concurrentManagedAccess as *const _ as usize
        },
        676usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(concurrentManagedAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).computePreemptionSupported as *const _
                as usize
        },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(computePreemptionSupported)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).canUseHostPointerForRegisteredMem as *const _
                as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(canUseHostPointerForRegisteredMem)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).cooperativeLaunch as *const _ as usize
        },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(cooperativeLaunch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).cooperativeMultiDeviceLaunch as *const _
                as usize
        },
        692usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(cooperativeMultiDeviceLaunch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).sharedMemPerBlockOptin as *const _ as usize
        },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(sharedMemPerBlockOptin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).pageableMemoryAccessUsesHostPageTables
                as *const _ as usize
        },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(pageableMemoryAccessUsesHostPageTables)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).directManagedMemAccessFromHost as *const _
                as usize
        },
        708usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(directManagedMemAccessFromHost)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).maxBlocksPerMultiProcessor as *const _
                as usize
        },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(maxBlocksPerMultiProcessor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).accessPolicyMaxWindowSize as *const _
                as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(accessPolicyMaxWindowSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaDeviceProp>())).reservedSharedMemPerBlock as *const _
                as usize
        },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaDeviceProp),
            "::",
            stringify!(reservedSharedMemPerBlock)
        )
    );
}
#[doc = " CUDA IPC event handle"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaIpcEventHandle_st {
    pub reserved: [::libc::c_char; 64usize],
}
#[test]
fn bindgen_test_layout_cudaIpcEventHandle_st() {
    assert_eq!(
        ::std::mem::size_of::<cudaIpcEventHandle_st>(),
        64usize,
        concat!("Size of: ", stringify!(cudaIpcEventHandle_st))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaIpcEventHandle_st>(),
        1usize,
        concat!("Alignment of ", stringify!(cudaIpcEventHandle_st))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaIpcEventHandle_st>())).reserved as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaIpcEventHandle_st),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " CUDA IPC event handle"]
pub type cudaIpcEventHandle_t = cudaIpcEventHandle_st;
#[doc = " CUDA IPC memory handle"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaIpcMemHandle_st {
    pub reserved: [::libc::c_char; 64usize],
}
#[test]
fn bindgen_test_layout_cudaIpcMemHandle_st() {
    assert_eq!(
        ::std::mem::size_of::<cudaIpcMemHandle_st>(),
        64usize,
        concat!("Size of: ", stringify!(cudaIpcMemHandle_st))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaIpcMemHandle_st>(),
        1usize,
        concat!("Alignment of ", stringify!(cudaIpcMemHandle_st))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaIpcMemHandle_st>())).reserved as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaIpcMemHandle_st),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " CUDA IPC memory handle"]
pub type cudaIpcMemHandle_t = cudaIpcMemHandle_st;
#[repr(u32)]
#[non_exhaustive]
#[doc = " External memory handle types"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaExternalMemoryHandleType {
    #[doc = " Handle is an opaque file descriptor"]
    cudaExternalMemoryHandleTypeOpaqueFd = 1,
    #[doc = " Handle is an opaque shared NT handle"]
    cudaExternalMemoryHandleTypeOpaqueWin32 = 2,
    #[doc = " Handle is an opaque, globally shared handle"]
    cudaExternalMemoryHandleTypeOpaqueWin32Kmt = 3,
    #[doc = " Handle is a D3D12 heap object"]
    cudaExternalMemoryHandleTypeD3D12Heap = 4,
    #[doc = " Handle is a D3D12 committed resource"]
    cudaExternalMemoryHandleTypeD3D12Resource = 5,
    #[doc = "  Handle is a shared NT handle to a D3D11 resource"]
    cudaExternalMemoryHandleTypeD3D11Resource = 6,
    #[doc = "  Handle is a globally shared handle to a D3D11 resource"]
    cudaExternalMemoryHandleTypeD3D11ResourceKmt = 7,
    #[doc = "  Handle is an NvSciBuf object"]
    cudaExternalMemoryHandleTypeNvSciBuf = 8,
}
#[doc = " External memory handle descriptor"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaExternalMemoryHandleDesc {
    #[doc = " Type of the handle"]
    pub type_: cudaExternalMemoryHandleType,
    pub handle: cudaExternalMemoryHandleDesc__bindgen_ty_1,
    #[doc = " Size of the memory allocation"]
    pub size: ::libc::c_ulonglong,
    #[doc = " Flags must either be zero or ::cudaExternalMemoryDedicated"]
    pub flags: ::libc::c_uint,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cudaExternalMemoryHandleDesc__bindgen_ty_1 {
    #[doc = " File descriptor referencing the memory object. Valid"]
    #[doc = " when type is"]
    #[doc = " ::cudaExternalMemoryHandleTypeOpaqueFd"]
    pub fd: ::libc::c_int,
    pub win32: cudaExternalMemoryHandleDesc__bindgen_ty_1__bindgen_ty_1,
    #[doc = " A handle representing NvSciBuf Object. Valid when type"]
    #[doc = " is ::cudaExternalMemoryHandleTypeNvSciBuf"]
    pub nvSciBufObject: *const ::libc::c_void,
}
#[doc = " Win32 handle referencing the semaphore object. Valid when"]
#[doc = " type is one of the following:"]
#[doc = " - ::cudaExternalMemoryHandleTypeOpaqueWin32"]
#[doc = " - ::cudaExternalMemoryHandleTypeOpaqueWin32Kmt"]
#[doc = " - ::cudaExternalMemoryHandleTypeD3D12Heap"]
#[doc = " - ::cudaExternalMemoryHandleTypeD3D12Resource"]
#[doc = " - ::cudaExternalMemoryHandleTypeD3D11Resource"]
#[doc = " - ::cudaExternalMemoryHandleTypeD3D11ResourceKmt"]
#[doc = " Exactly one of 'handle' and 'name' must be non-NULL. If"]
#[doc = " type is one of the following:"]
#[doc = " ::cudaExternalMemoryHandleTypeOpaqueWin32Kmt"]
#[doc = " ::cudaExternalMemoryHandleTypeD3D11ResourceKmt"]
#[doc = " then 'name' must be NULL."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaExternalMemoryHandleDesc__bindgen_ty_1__bindgen_ty_1 {
    #[doc = " Valid NT handle. Must be NULL if 'name' is non-NULL"]
    pub handle: *mut ::libc::c_void,
    #[doc = " Name of a valid memory object."]
    #[doc = " Must be NULL if 'handle' is non-NULL."]
    pub name: *const ::libc::c_void,
}
#[test]
fn bindgen_test_layout_cudaExternalMemoryHandleDesc__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalMemoryHandleDesc__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalMemoryHandleDesc__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalMemoryHandleDesc__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalMemoryHandleDesc__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryHandleDesc__bindgen_ty_1__bindgen_ty_1>()))
                .handle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryHandleDesc__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryHandleDesc__bindgen_ty_1__bindgen_ty_1>()))
                .name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryHandleDesc__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
}
#[test]
fn bindgen_test_layout_cudaExternalMemoryHandleDesc__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalMemoryHandleDesc__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalMemoryHandleDesc__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalMemoryHandleDesc__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalMemoryHandleDesc__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryHandleDesc__bindgen_ty_1>())).fd as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryHandleDesc__bindgen_ty_1),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryHandleDesc__bindgen_ty_1>())).win32 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryHandleDesc__bindgen_ty_1),
            "::",
            stringify!(win32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryHandleDesc__bindgen_ty_1>())).nvSciBufObject
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryHandleDesc__bindgen_ty_1),
            "::",
            stringify!(nvSciBufObject)
        )
    );
}
#[test]
fn bindgen_test_layout_cudaExternalMemoryHandleDesc() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalMemoryHandleDesc>(),
        40usize,
        concat!("Size of: ", stringify!(cudaExternalMemoryHandleDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalMemoryHandleDesc>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaExternalMemoryHandleDesc))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryHandleDesc>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryHandleDesc),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryHandleDesc>())).handle as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryHandleDesc),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryHandleDesc>())).size as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryHandleDesc),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryHandleDesc>())).flags as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryHandleDesc),
            "::",
            stringify!(flags)
        )
    );
}
#[doc = " External memory buffer descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaExternalMemoryBufferDesc {
    #[doc = " Offset into the memory object where the buffer's base is"]
    pub offset: ::libc::c_ulonglong,
    #[doc = " Size of the buffer"]
    pub size: ::libc::c_ulonglong,
    #[doc = " Flags reserved for future use. Must be zero."]
    pub flags: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout_cudaExternalMemoryBufferDesc() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalMemoryBufferDesc>(),
        24usize,
        concat!("Size of: ", stringify!(cudaExternalMemoryBufferDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalMemoryBufferDesc>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaExternalMemoryBufferDesc))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryBufferDesc>())).offset as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryBufferDesc),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryBufferDesc>())).size as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryBufferDesc),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryBufferDesc>())).flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryBufferDesc),
            "::",
            stringify!(flags)
        )
    );
}
#[doc = " External memory mipmap descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaExternalMemoryMipmappedArrayDesc {
    #[doc = " Offset into the memory object where the base level of the"]
    #[doc = " mipmap chain is."]
    pub offset: ::libc::c_ulonglong,
    #[doc = " Format of base level of the mipmap chain"]
    pub formatDesc: cudaChannelFormatDesc,
    #[doc = " Dimensions of base level of the mipmap chain"]
    pub extent: cudaExtent,
    #[doc = " Flags associated with CUDA mipmapped arrays."]
    #[doc = " See ::cudaMallocMipmappedArray"]
    pub flags: ::libc::c_uint,
    #[doc = " Total number of levels in the mipmap chain"]
    pub numLevels: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout_cudaExternalMemoryMipmappedArrayDesc() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalMemoryMipmappedArrayDesc>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalMemoryMipmappedArrayDesc)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalMemoryMipmappedArrayDesc>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalMemoryMipmappedArrayDesc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryMipmappedArrayDesc>())).offset as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryMipmappedArrayDesc),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryMipmappedArrayDesc>())).formatDesc as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryMipmappedArrayDesc),
            "::",
            stringify!(formatDesc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryMipmappedArrayDesc>())).extent as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryMipmappedArrayDesc),
            "::",
            stringify!(extent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryMipmappedArrayDesc>())).flags as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryMipmappedArrayDesc),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalMemoryMipmappedArrayDesc>())).numLevels as *const _
                as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalMemoryMipmappedArrayDesc),
            "::",
            stringify!(numLevels)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " External semaphore handle types"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaExternalSemaphoreHandleType {
    #[doc = " Handle is an opaque file descriptor"]
    cudaExternalSemaphoreHandleTypeOpaqueFd = 1,
    #[doc = " Handle is an opaque shared NT handle"]
    cudaExternalSemaphoreHandleTypeOpaqueWin32 = 2,
    #[doc = " Handle is an opaque, globally shared handle"]
    cudaExternalSemaphoreHandleTypeOpaqueWin32Kmt = 3,
    #[doc = " Handle is a shared NT handle referencing a D3D12 fence object"]
    cudaExternalSemaphoreHandleTypeD3D12Fence = 4,
    #[doc = " Handle is a shared NT handle referencing a D3D11 fence object"]
    cudaExternalSemaphoreHandleTypeD3D11Fence = 5,
    #[doc = " Opaque handle to NvSciSync Object"]
    cudaExternalSemaphoreHandleTypeNvSciSync = 6,
    #[doc = " Handle is a shared NT handle referencing a D3D11 keyed mutex object"]
    cudaExternalSemaphoreHandleTypeKeyedMutex = 7,
    #[doc = " Handle is a shared KMT handle referencing a D3D11 keyed mutex object"]
    cudaExternalSemaphoreHandleTypeKeyedMutexKmt = 8,
    #[doc = " Handle is an opaque handle file descriptor referencing a timeline semaphore"]
    cudaExternalSemaphoreHandleTypeTimelineSemaphoreFd = 9,
    #[doc = " Handle is an opaque handle file descriptor referencing a timeline semaphore"]
    cudaExternalSemaphoreHandleTypeTimelineSemaphoreWin32 = 10,
}
#[doc = " External semaphore handle descriptor"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaExternalSemaphoreHandleDesc {
    #[doc = " Type of the handle"]
    pub type_: cudaExternalSemaphoreHandleType,
    pub handle: cudaExternalSemaphoreHandleDesc__bindgen_ty_1,
    #[doc = " Flags reserved for the future. Must be zero."]
    pub flags: ::libc::c_uint,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cudaExternalSemaphoreHandleDesc__bindgen_ty_1 {
    #[doc = " File descriptor referencing the semaphore object. Valid when"]
    #[doc = " type is one of the following:"]
    #[doc = " - ::cudaExternalSemaphoreHandleTypeOpaqueFd"]
    #[doc = " - ::cudaExternalSemaphoreHandleTypeTimelineSemaphoreFd"]
    pub fd: ::libc::c_int,
    pub win32: cudaExternalSemaphoreHandleDesc__bindgen_ty_1__bindgen_ty_1,
    #[doc = " Valid NvSciSyncObj. Must be non NULL"]
    pub nvSciSyncObj: *const ::libc::c_void,
}
#[doc = " Win32 handle referencing the semaphore object. Valid when"]
#[doc = " type is one of the following:"]
#[doc = " - ::cudaExternalSemaphoreHandleTypeOpaqueWin32"]
#[doc = " - ::cudaExternalSemaphoreHandleTypeOpaqueWin32Kmt"]
#[doc = " - ::cudaExternalSemaphoreHandleTypeD3D12Fence"]
#[doc = " - ::cudaExternalSemaphoreHandleTypeD3D11Fence"]
#[doc = " - ::cudaExternalSemaphoreHandleTypeKeyedMutex"]
#[doc = " - ::cudaExternalSemaphoreHandleTypeTimelineSemaphoreWin32"]
#[doc = " Exactly one of 'handle' and 'name' must be non-NULL. If"]
#[doc = " type is one of the following:"]
#[doc = " ::cudaExternalSemaphoreHandleTypeOpaqueWin32Kmt"]
#[doc = " ::cudaExternalSemaphoreHandleTypeKeyedMutexKmt"]
#[doc = " then 'name' must be NULL."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaExternalSemaphoreHandleDesc__bindgen_ty_1__bindgen_ty_1 {
    #[doc = " Valid NT handle. Must be NULL if 'name' is non-NULL"]
    pub handle: *mut ::libc::c_void,
    #[doc = " Name of a valid synchronization primitive."]
    #[doc = " Must be NULL if 'handle' is non-NULL."]
    pub name: *const ::libc::c_void,
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreHandleDesc__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreHandleDesc__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalSemaphoreHandleDesc__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreHandleDesc__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreHandleDesc__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreHandleDesc__bindgen_ty_1__bindgen_ty_1>()))
                .handle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreHandleDesc__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreHandleDesc__bindgen_ty_1__bindgen_ty_1>()))
                .name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreHandleDesc__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreHandleDesc__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreHandleDesc__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalSemaphoreHandleDesc__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreHandleDesc__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreHandleDesc__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreHandleDesc__bindgen_ty_1>())).fd as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreHandleDesc__bindgen_ty_1),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreHandleDesc__bindgen_ty_1>())).win32
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreHandleDesc__bindgen_ty_1),
            "::",
            stringify!(win32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreHandleDesc__bindgen_ty_1>())).nvSciSyncObj
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreHandleDesc__bindgen_ty_1),
            "::",
            stringify!(nvSciSyncObj)
        )
    );
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreHandleDesc() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreHandleDesc>(),
        32usize,
        concat!("Size of: ", stringify!(cudaExternalSemaphoreHandleDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreHandleDesc>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaExternalSemaphoreHandleDesc))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreHandleDesc>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreHandleDesc),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreHandleDesc>())).handle as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreHandleDesc),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreHandleDesc>())).flags as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreHandleDesc),
            "::",
            stringify!(flags)
        )
    );
}
#[doc = " External semaphore signal parameters, compatible with driver type"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaExternalSemaphoreSignalParams {
    pub params: cudaExternalSemaphoreSignalParams__bindgen_ty_1,
    #[doc = " Only when ::cudaExternalSemaphoreSignalParams is used to"]
    #[doc = " signal a ::cudaExternalSemaphore_t of type"]
    #[doc = " ::cudaExternalSemaphoreHandleTypeNvSciSync, the valid flag is"]
    #[doc = " ::cudaExternalSemaphoreSignalSkipNvSciBufMemSync: which indicates"]
    #[doc = " that while signaling the ::cudaExternalSemaphore_t, no memory"]
    #[doc = " synchronization operations should be performed for any external memory"]
    #[doc = " object imported as ::cudaExternalMemoryHandleTypeNvSciBuf."]
    #[doc = " For all other types of ::cudaExternalSemaphore_t, flags must be zero."]
    pub flags: ::libc::c_uint,
    pub reserved: [::libc::c_uint; 16usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaExternalSemaphoreSignalParams__bindgen_ty_1 {
    pub fence: cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_1,
    pub nvSciSync: cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_2,
    pub keyedMutex: cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_3,
    pub reserved: [::libc::c_uint; 12usize],
}
#[doc = " Parameters for fence objects"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_1 {
    #[doc = " Value of fence to be signaled"]
    pub value: ::libc::c_ulonglong,
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_1>(
            )))
            .value as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_2 {
    #[doc = " Pointer to NvSciSyncFence. Valid if ::cudaExternalSemaphoreHandleType"]
    #[doc = " is of type ::cudaExternalSemaphoreHandleTypeNvSciSync."]
    pub fence: *mut ::libc::c_void,
    pub reserved: ::libc::c_ulonglong,
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_2>(
            )))
            .fence as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(fence)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_2>(
            )))
            .reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Parameters for keyed mutex objects"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_3 {
    pub key: ::libc::c_ulonglong,
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_3>(
            )))
            .key as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(key)
        )
    );
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreSignalParams__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreSignalParams__bindgen_ty_1>(),
        72usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreSignalParams__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalParams__bindgen_ty_1>())).fence
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1),
            "::",
            stringify!(fence)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalParams__bindgen_ty_1>())).nvSciSync
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1),
            "::",
            stringify!(nvSciSync)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalParams__bindgen_ty_1>())).keyedMutex
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1),
            "::",
            stringify!(keyedMutex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalParams__bindgen_ty_1>())).reserved
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalParams__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreSignalParams() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreSignalParams>(),
        144usize,
        concat!("Size of: ", stringify!(cudaExternalSemaphoreSignalParams))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreSignalParams>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreSignalParams)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalParams>())).params as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalParams),
            "::",
            stringify!(params)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalParams>())).flags as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalParams),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalParams>())).reserved as *const _
                as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalParams),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " External semaphore wait parameters, compatible with driver type"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaExternalSemaphoreWaitParams {
    pub params: cudaExternalSemaphoreWaitParams__bindgen_ty_1,
    #[doc = " Only when ::cudaExternalSemaphoreSignalParams is used to"]
    #[doc = " signal a ::cudaExternalSemaphore_t of type"]
    #[doc = " ::cudaExternalSemaphoreHandleTypeNvSciSync, the valid flag is"]
    #[doc = " ::cudaExternalSemaphoreSignalSkipNvSciBufMemSync: which indicates"]
    #[doc = " that while waiting for the ::cudaExternalSemaphore_t, no memory"]
    #[doc = " synchronization operations should be performed for any external memory"]
    #[doc = " object imported as ::cudaExternalMemoryHandleTypeNvSciBuf."]
    #[doc = " For all other types of ::cudaExternalSemaphore_t, flags must be zero."]
    pub flags: ::libc::c_uint,
    pub reserved: [::libc::c_uint; 16usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudaExternalSemaphoreWaitParams__bindgen_ty_1 {
    pub fence: cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_1,
    pub nvSciSync: cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_2,
    pub keyedMutex: cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_3,
    pub reserved: [::libc::c_uint; 10usize],
}
#[doc = " Parameters for fence objects"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_1 {
    #[doc = " Value of fence to be waited on"]
    pub value: ::libc::c_ulonglong,
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_1>()))
                .value as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_2 {
    #[doc = " Pointer to NvSciSyncFence. Valid if ::cudaExternalSemaphoreHandleType"]
    #[doc = " is of type ::cudaExternalSemaphoreHandleTypeNvSciSync."]
    pub fence: *mut ::libc::c_void,
    pub reserved: ::libc::c_ulonglong,
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_2>()))
                .fence as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(fence)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_2>()))
                .reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Parameters for keyed mutex objects"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_3 {
    #[doc = " Value of key to acquire the mutex with"]
    pub key: ::libc::c_ulonglong,
    #[doc = " Timeout in milliseconds to wait to acquire the mutex"]
    pub timeoutMs: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_3>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_3>()))
                .key as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_3>()))
                .timeoutMs as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(timeoutMs)
        )
    );
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreWaitParams__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreWaitParams__bindgen_ty_1>(),
        72usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreWaitParams__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitParams__bindgen_ty_1>())).fence
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1),
            "::",
            stringify!(fence)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitParams__bindgen_ty_1>())).nvSciSync
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1),
            "::",
            stringify!(nvSciSync)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitParams__bindgen_ty_1>())).keyedMutex
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1),
            "::",
            stringify!(keyedMutex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitParams__bindgen_ty_1>())).reserved
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitParams__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreWaitParams() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreWaitParams>(),
        144usize,
        concat!("Size of: ", stringify!(cudaExternalSemaphoreWaitParams))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreWaitParams>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaExternalSemaphoreWaitParams))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitParams>())).params as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitParams),
            "::",
            stringify!(params)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitParams>())).flags as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitParams),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitParams>())).reserved as *const _
                as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitParams),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " CUDA Error types"]
pub use self::cudaError as cudaError_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUstream_st {
    _unused: [u8; 0],
}
#[doc = " CUDA stream"]
pub type cudaStream_t = *mut CUstream_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUevent_st {
    _unused: [u8; 0],
}
#[doc = " CUDA event types"]
pub type cudaEvent_t = *mut CUevent_st;
#[doc = " CUDA graphics resource types"]
pub type cudaGraphicsResource_t = *mut cudaGraphicsResource;
#[doc = " CUDA output file modes"]
pub use self::cudaOutputMode as cudaOutputMode_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUexternalMemory_st {
    _unused: [u8; 0],
}
#[doc = " CUDA external memory"]
pub type cudaExternalMemory_t = *mut CUexternalMemory_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUexternalSemaphore_st {
    _unused: [u8; 0],
}
#[doc = " CUDA external semaphore"]
pub type cudaExternalSemaphore_t = *mut CUexternalSemaphore_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUgraph_st {
    _unused: [u8; 0],
}
#[doc = " CUDA graph"]
pub type cudaGraph_t = *mut CUgraph_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUgraphNode_st {
    _unused: [u8; 0],
}
#[doc = " CUDA graph node."]
pub type cudaGraphNode_t = *mut CUgraphNode_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUuserObject_st {
    _unused: [u8; 0],
}
#[doc = " CUDA user object for graphs"]
pub type cudaUserObject_t = *mut CUuserObject_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUfunc_st {
    _unused: [u8; 0],
}
#[doc = " CUDA function"]
pub type cudaFunction_t = *mut CUfunc_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUmemPoolHandle_st {
    _unused: [u8; 0],
}
#[doc = " CUDA memory pool"]
pub type cudaMemPool_t = *mut CUmemPoolHandle_st;
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA cooperative group scope"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaCGScope {
    #[doc = "< Invalid cooperative group scope"]
    cudaCGScopeInvalid = 0,
    #[doc = "< Scope represented by a grid_group"]
    cudaCGScopeGrid = 1,
    #[doc = "< Scope represented by a multi_grid_group"]
    cudaCGScopeMultiGrid = 2,
}
#[doc = " CUDA launch parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaLaunchParams {
    #[doc = "< Device function symbol"]
    pub func: *mut ::libc::c_void,
    #[doc = "< Grid dimentions"]
    pub gridDim: dim3,
    #[doc = "< Block dimentions"]
    pub blockDim: dim3,
    #[doc = "< Arguments"]
    pub args: *mut *mut ::libc::c_void,
    #[doc = "< Shared memory"]
    pub sharedMem: usize,
    #[doc = "< Stream identifier"]
    pub stream: cudaStream_t,
}
#[test]
fn bindgen_test_layout_cudaLaunchParams() {
    assert_eq!(
        ::std::mem::size_of::<cudaLaunchParams>(),
        56usize,
        concat!("Size of: ", stringify!(cudaLaunchParams))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaLaunchParams>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaLaunchParams))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaLaunchParams>())).func as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaLaunchParams),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaLaunchParams>())).gridDim as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaLaunchParams),
            "::",
            stringify!(gridDim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaLaunchParams>())).blockDim as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaLaunchParams),
            "::",
            stringify!(blockDim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaLaunchParams>())).args as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaLaunchParams),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaLaunchParams>())).sharedMem as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaLaunchParams),
            "::",
            stringify!(sharedMem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaLaunchParams>())).stream as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaLaunchParams),
            "::",
            stringify!(stream)
        )
    );
}
#[doc = " CUDA GPU kernel node parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaKernelNodeParams {
    #[doc = "< Kernel to launch"]
    pub func: *mut ::libc::c_void,
    #[doc = "< Grid dimensions"]
    pub gridDim: dim3,
    #[doc = "< Block dimensions"]
    pub blockDim: dim3,
    #[doc = "< Dynamic shared-memory size per thread block in bytes"]
    pub sharedMemBytes: ::libc::c_uint,
    #[doc = "< Array of pointers to individual kernel arguments"]
    pub kernelParams: *mut *mut ::libc::c_void,
    #[doc = "< Pointer to kernel arguments in the \"extra\" format"]
    pub extra: *mut *mut ::libc::c_void,
}
#[test]
fn bindgen_test_layout_cudaKernelNodeParams() {
    assert_eq!(
        ::std::mem::size_of::<cudaKernelNodeParams>(),
        56usize,
        concat!("Size of: ", stringify!(cudaKernelNodeParams))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaKernelNodeParams>(),
        8usize,
        concat!("Alignment of ", stringify!(cudaKernelNodeParams))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaKernelNodeParams>())).func as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaKernelNodeParams),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaKernelNodeParams>())).gridDim as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaKernelNodeParams),
            "::",
            stringify!(gridDim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaKernelNodeParams>())).blockDim as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaKernelNodeParams),
            "::",
            stringify!(blockDim)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaKernelNodeParams>())).sharedMemBytes as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaKernelNodeParams),
            "::",
            stringify!(sharedMemBytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaKernelNodeParams>())).kernelParams as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaKernelNodeParams),
            "::",
            stringify!(kernelParams)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaKernelNodeParams>())).extra as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaKernelNodeParams),
            "::",
            stringify!(extra)
        )
    );
}
#[doc = " External semaphore signal node parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaExternalSemaphoreSignalNodeParams {
    #[doc = "< Array of external semaphore handles."]
    pub extSemArray: *mut cudaExternalSemaphore_t,
    #[doc = "< Array of external semaphore signal parameters."]
    pub paramsArray: *const cudaExternalSemaphoreSignalParams,
    #[doc = "< Number of handles and parameters supplied in extSemArray and paramsArray."]
    pub numExtSems: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreSignalNodeParams() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreSignalNodeParams>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(cudaExternalSemaphoreSignalNodeParams)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreSignalNodeParams>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreSignalNodeParams)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalNodeParams>())).extSemArray
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalNodeParams),
            "::",
            stringify!(extSemArray)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalNodeParams>())).paramsArray
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalNodeParams),
            "::",
            stringify!(paramsArray)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreSignalNodeParams>())).numExtSems as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreSignalNodeParams),
            "::",
            stringify!(numExtSems)
        )
    );
}
#[doc = " External semaphore wait node parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaExternalSemaphoreWaitNodeParams {
    #[doc = "< Array of external semaphore handles."]
    pub extSemArray: *mut cudaExternalSemaphore_t,
    #[doc = "< Array of external semaphore wait parameters."]
    pub paramsArray: *const cudaExternalSemaphoreWaitParams,
    #[doc = "< Number of handles and parameters supplied in extSemArray and paramsArray."]
    pub numExtSems: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout_cudaExternalSemaphoreWaitNodeParams() {
    assert_eq!(
        ::std::mem::size_of::<cudaExternalSemaphoreWaitNodeParams>(),
        24usize,
        concat!("Size of: ", stringify!(cudaExternalSemaphoreWaitNodeParams))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaExternalSemaphoreWaitNodeParams>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudaExternalSemaphoreWaitNodeParams)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitNodeParams>())).extSemArray as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitNodeParams),
            "::",
            stringify!(extSemArray)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitNodeParams>())).paramsArray as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitNodeParams),
            "::",
            stringify!(paramsArray)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaExternalSemaphoreWaitNodeParams>())).numExtSems as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaExternalSemaphoreWaitNodeParams),
            "::",
            stringify!(numExtSems)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA Graph node types"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaGraphNodeType {
    #[doc = "< GPU kernel node"]
    cudaGraphNodeTypeKernel = 0,
    #[doc = "< Memcpy node"]
    cudaGraphNodeTypeMemcpy = 1,
    #[doc = "< Memset node"]
    cudaGraphNodeTypeMemset = 2,
    #[doc = "< Host (executable) node"]
    cudaGraphNodeTypeHost = 3,
    #[doc = "< Node which executes an embedded graph"]
    cudaGraphNodeTypeGraph = 4,
    #[doc = "< Empty (no-op) node"]
    cudaGraphNodeTypeEmpty = 5,
    #[doc = "< External event wait node"]
    cudaGraphNodeTypeWaitEvent = 6,
    #[doc = "< External event record node"]
    cudaGraphNodeTypeEventRecord = 7,
    #[doc = "< External semaphore signal node"]
    cudaGraphNodeTypeExtSemaphoreSignal = 8,
    #[doc = "< External semaphore wait node"]
    cudaGraphNodeTypeExtSemaphoreWait = 9,
    #[doc = "< Memory allocation node"]
    cudaGraphNodeTypeMemAlloc = 10,
    #[doc = "< Memory free node"]
    cudaGraphNodeTypeMemFree = 11,
    cudaGraphNodeTypeCount = 12,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUgraphExec_st {
    _unused: [u8; 0],
}
#[doc = " CUDA executable (launchable) graph"]
pub type cudaGraphExec_t = *mut CUgraphExec_st;
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA Graph Update error types"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaGraphExecUpdateResult {
    #[doc = "< The update succeeded"]
    cudaGraphExecUpdateSuccess = 0,
    #[doc = "< The update failed for an unexpected reason which is described in the return value of the function"]
    cudaGraphExecUpdateError = 1,
    #[doc = "< The update failed because the topology changed"]
    cudaGraphExecUpdateErrorTopologyChanged = 2,
    #[doc = "< The update failed because a node type changed"]
    cudaGraphExecUpdateErrorNodeTypeChanged = 3,
    #[doc = "< The update failed because the function of a kernel node changed (CUDA driver < 11.2)"]
    cudaGraphExecUpdateErrorFunctionChanged = 4,
    #[doc = "< The update failed because the parameters changed in a way that is not supported"]
    cudaGraphExecUpdateErrorParametersChanged = 5,
    #[doc = "< The update failed because something about the node is not supported"]
    cudaGraphExecUpdateErrorNotSupported = 6,
    #[doc = "< The update failed because the function of a kernel node changed in an unsupported way"]
    cudaGraphExecUpdateErrorUnsupportedFunctionChange = 7,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Flags to specify search options to be used with ::cudaGetDriverEntryPoint"]
#[doc = " For more details see ::cuGetProcAddress"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaGetDriverEntryPointFlags {
    #[doc = "< Default search mode for driver symbols."]
    cudaEnableDefault = 0,
    #[doc = "< Search for legacy versions of driver symbols."]
    cudaEnableLegacyStream = 1,
    #[doc = "< Search for per-thread versions of driver symbols."]
    cudaEnablePerThreadDefaultStream = 2,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA Graph debug write options"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaGraphDebugDotFlags {
    cudaGraphDebugDotFlagsVerbose = 1,
    #[doc = " Output all debug data as if every debug flag is enabled"]
    cudaGraphDebugDotFlagsKernelNodeParams = 4,
    #[doc = " Adds cudaKernelNodeParams to output"]
    cudaGraphDebugDotFlagsMemcpyNodeParams = 8,
    #[doc = " Adds cudaMemcpy3DParms to output"]
    cudaGraphDebugDotFlagsMemsetNodeParams = 16,
    #[doc = " Adds cudaMemsetParams to output"]
    cudaGraphDebugDotFlagsHostNodeParams = 32,
    #[doc = " Adds cudaHostNodeParams to output"]
    cudaGraphDebugDotFlagsEventNodeParams = 64,
    #[doc = " Adds cudaEvent_t handle from record and wait nodes to output"]
    cudaGraphDebugDotFlagsExtSemasSignalNodeParams = 128,
    #[doc = " Adds cudaExternalSemaphoreSignalNodeParams values to output"]
    cudaGraphDebugDotFlagsExtSemasWaitNodeParams = 256,
    #[doc = " Adds cudaExternalSemaphoreWaitNodeParams to output"]
    cudaGraphDebugDotFlagsKernelNodeAttributes = 512,
    #[doc = " Adds cudaKernelNodeAttrID values to output"]
    cudaGraphDebugDotFlagsHandles = 1024,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " Flags for instantiating a graph"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaGraphInstantiateFlags {
    #[doc = "< Automatically free memory allocated in a graph before relaunching."]
    cudaGraphInstantiateFlagAutoFreeOnLaunch = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA Surface boundary modes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaSurfaceBoundaryMode {
    #[doc = "< Zero boundary mode"]
    cudaBoundaryModeZero = 0,
    #[doc = "< Clamp boundary mode"]
    cudaBoundaryModeClamp = 1,
    #[doc = "< Trap boundary mode"]
    cudaBoundaryModeTrap = 2,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA Surface format modes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaSurfaceFormatMode {
    #[doc = "< Forced format mode"]
    cudaFormatModeForced = 0,
    #[doc = "< Auto format mode"]
    cudaFormatModeAuto = 1,
}
#[doc = " CUDA Surface reference"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct surfaceReference {
    #[doc = " Channel descriptor for surface reference"]
    pub channelDesc: cudaChannelFormatDesc,
}
#[test]
fn bindgen_test_layout_surfaceReference() {
    assert_eq!(
        ::std::mem::size_of::<surfaceReference>(),
        20usize,
        concat!("Size of: ", stringify!(surfaceReference))
    );
    assert_eq!(
        ::std::mem::align_of::<surfaceReference>(),
        4usize,
        concat!("Alignment of ", stringify!(surfaceReference))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<surfaceReference>())).channelDesc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(surfaceReference),
            "::",
            stringify!(channelDesc)
        )
    );
}
#[doc = " An opaque value that represents a CUDA Surface object"]
pub type cudaSurfaceObject_t = ::libc::c_ulonglong;
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA texture address modes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaTextureAddressMode {
    #[doc = "< Wrapping address mode"]
    cudaAddressModeWrap = 0,
    #[doc = "< Clamp to edge address mode"]
    cudaAddressModeClamp = 1,
    #[doc = "< Mirror address mode"]
    cudaAddressModeMirror = 2,
    #[doc = "< Border address mode"]
    cudaAddressModeBorder = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA texture filter modes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaTextureFilterMode {
    #[doc = "< Point filter mode"]
    cudaFilterModePoint = 0,
    #[doc = "< Linear filter mode"]
    cudaFilterModeLinear = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " CUDA texture read modes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaTextureReadMode {
    #[doc = "< Read texture as specified element type"]
    cudaReadModeElementType = 0,
    #[doc = "< Read texture as normalized float"]
    cudaReadModeNormalizedFloat = 1,
}
#[doc = " CUDA texture reference"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct textureReference {
    #[doc = " Indicates whether texture reads are normalized or not"]
    pub normalized: ::libc::c_int,
    #[doc = " Texture filter mode"]
    pub filterMode: cudaTextureFilterMode,
    #[doc = " Texture address mode for up to 3 dimensions"]
    pub addressMode: [cudaTextureAddressMode; 3usize],
    #[doc = " Channel descriptor for the texture reference"]
    pub channelDesc: cudaChannelFormatDesc,
    #[doc = " Perform sRGB->linear conversion during texture read"]
    pub sRGB: ::libc::c_int,
    #[doc = " Limit to the anisotropy ratio"]
    pub maxAnisotropy: ::libc::c_uint,
    #[doc = " Mipmap filter mode"]
    pub mipmapFilterMode: cudaTextureFilterMode,
    #[doc = " Offset applied to the supplied mipmap level"]
    pub mipmapLevelBias: f32,
    #[doc = " Lower end of the mipmap level range to clamp access to"]
    pub minMipmapLevelClamp: f32,
    #[doc = " Upper end of the mipmap level range to clamp access to"]
    pub maxMipmapLevelClamp: f32,
    #[doc = " Disable any trilinear filtering optimizations."]
    pub disableTrilinearOptimization: ::libc::c_int,
    pub __cudaReserved: [::libc::c_int; 14usize],
}
#[test]
fn bindgen_test_layout_textureReference() {
    assert_eq!(
        ::std::mem::size_of::<textureReference>(),
        124usize,
        concat!("Size of: ", stringify!(textureReference))
    );
    assert_eq!(
        ::std::mem::align_of::<textureReference>(),
        4usize,
        concat!("Alignment of ", stringify!(textureReference))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<textureReference>())).normalized as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(textureReference),
            "::",
            stringify!(normalized)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<textureReference>())).filterMode as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(textureReference),
            "::",
            stringify!(filterMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<textureReference>())).addressMode as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(textureReference),
            "::",
            stringify!(addressMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<textureReference>())).channelDesc as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(textureReference),
            "::",
            stringify!(channelDesc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<textureReference>())).sRGB as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(textureReference),
            "::",
            stringify!(sRGB)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<textureReference>())).maxAnisotropy as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(textureReference),
            "::",
            stringify!(maxAnisotropy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<textureReference>())).mipmapFilterMode as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(textureReference),
            "::",
            stringify!(mipmapFilterMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<textureReference>())).mipmapLevelBias as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(textureReference),
            "::",
            stringify!(mipmapLevelBias)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<textureReference>())).minMipmapLevelClamp as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(textureReference),
            "::",
            stringify!(minMipmapLevelClamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<textureReference>())).maxMipmapLevelClamp as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(textureReference),
            "::",
            stringify!(maxMipmapLevelClamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<textureReference>())).disableTrilinearOptimization as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(textureReference),
            "::",
            stringify!(disableTrilinearOptimization)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<textureReference>())).__cudaReserved as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(textureReference),
            "::",
            stringify!(__cudaReserved)
        )
    );
}
#[doc = " CUDA texture descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudaTextureDesc {
    #[doc = " Texture address mode for up to 3 dimensions"]
    pub addressMode: [cudaTextureAddressMode; 3usize],
    #[doc = " Texture filter mode"]
    pub filterMode: cudaTextureFilterMode,
    #[doc = " Texture read mode"]
    pub readMode: cudaTextureReadMode,
    #[doc = " Perform sRGB->linear conversion during texture read"]
    pub sRGB: ::libc::c_int,
    #[doc = " Texture Border Color"]
    pub borderColor: [f32; 4usize],
    #[doc = " Indicates whether texture reads are normalized or not"]
    pub normalizedCoords: ::libc::c_int,
    #[doc = " Limit to the anisotropy ratio"]
    pub maxAnisotropy: ::libc::c_uint,
    #[doc = " Mipmap filter mode"]
    pub mipmapFilterMode: cudaTextureFilterMode,
    #[doc = " Offset applied to the supplied mipmap level"]
    pub mipmapLevelBias: f32,
    #[doc = " Lower end of the mipmap level range to clamp access to"]
    pub minMipmapLevelClamp: f32,
    #[doc = " Upper end of the mipmap level range to clamp access to"]
    pub maxMipmapLevelClamp: f32,
    #[doc = " Disable any trilinear filtering optimizations."]
    pub disableTrilinearOptimization: ::libc::c_int,
}
#[test]
fn bindgen_test_layout_cudaTextureDesc() {
    assert_eq!(
        ::std::mem::size_of::<cudaTextureDesc>(),
        68usize,
        concat!("Size of: ", stringify!(cudaTextureDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<cudaTextureDesc>(),
        4usize,
        concat!("Alignment of ", stringify!(cudaTextureDesc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaTextureDesc>())).addressMode as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaTextureDesc),
            "::",
            stringify!(addressMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaTextureDesc>())).filterMode as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaTextureDesc),
            "::",
            stringify!(filterMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaTextureDesc>())).readMode as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaTextureDesc),
            "::",
            stringify!(readMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaTextureDesc>())).sRGB as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaTextureDesc),
            "::",
            stringify!(sRGB)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaTextureDesc>())).borderColor as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaTextureDesc),
            "::",
            stringify!(borderColor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaTextureDesc>())).normalizedCoords as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaTextureDesc),
            "::",
            stringify!(normalizedCoords)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaTextureDesc>())).maxAnisotropy as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaTextureDesc),
            "::",
            stringify!(maxAnisotropy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaTextureDesc>())).mipmapFilterMode as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaTextureDesc),
            "::",
            stringify!(mipmapFilterMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudaTextureDesc>())).mipmapLevelBias as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaTextureDesc),
            "::",
            stringify!(mipmapLevelBias)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaTextureDesc>())).minMipmapLevelClamp as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaTextureDesc),
            "::",
            stringify!(minMipmapLevelClamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaTextureDesc>())).maxMipmapLevelClamp as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaTextureDesc),
            "::",
            stringify!(maxMipmapLevelClamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudaTextureDesc>())).disableTrilinearOptimization as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(cudaTextureDesc),
            "::",
            stringify!(disableTrilinearOptimization)
        )
    );
}
#[doc = " An opaque value that represents a CUDA texture object"]
pub type cudaTextureObject_t = ::libc::c_ulonglong;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudaDataType_t {
    CUDA_R_16F = 2,
    CUDA_C_16F = 6,
    CUDA_R_16BF = 14,
    CUDA_C_16BF = 15,
    CUDA_R_32F = 0,
    CUDA_C_32F = 4,
    CUDA_R_64F = 1,
    CUDA_C_64F = 5,
    CUDA_R_4I = 16,
    CUDA_C_4I = 17,
    CUDA_R_4U = 18,
    CUDA_C_4U = 19,
    CUDA_R_8I = 3,
    CUDA_C_8I = 7,
    CUDA_R_8U = 8,
    CUDA_C_8U = 9,
    CUDA_R_16I = 20,
    CUDA_C_16I = 21,
    CUDA_R_16U = 22,
    CUDA_C_16U = 23,
    CUDA_R_32I = 10,
    CUDA_C_32I = 11,
    CUDA_R_32U = 12,
    CUDA_C_32U = 13,
    CUDA_R_64I = 24,
    CUDA_C_64I = 25,
    CUDA_R_64U = 26,
    CUDA_C_64U = 27,
}
pub use self::cudaDataType_t as cudaDataType;
pub const libraryPropertyType_t_MAJOR_VERSION: libraryPropertyType_t = 0;
pub const libraryPropertyType_t_MINOR_VERSION: libraryPropertyType_t = 1;
pub const libraryPropertyType_t_PATCH_LEVEL: libraryPropertyType_t = 2;
pub type libraryPropertyType_t = ::libc::c_uint;
pub use self::libraryPropertyType_t as libraryPropertyType;
extern "C" {
    #[doc = " \\brief Destroy all allocations and reset all state on the current device"]
    #[doc = " in the current process."]
    #[doc = ""]
    #[doc = " Explicitly destroys and cleans up all resources associated with the current"]
    #[doc = " device in the current process.  Any subsequent API call to this device will"]
    #[doc = " reinitialize the device."]
    #[doc = ""]
    #[doc = " Note that this function will reset the device immediately.  It is the caller's"]
    #[doc = " responsibility to ensure that the device is not being accessed by any"]
    #[doc = " other host threads from the process when this function is called."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceSynchronize"]
    pub fn cudaDeviceReset() -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Wait for compute device to finish"]
    #[doc = ""]
    #[doc = " Blocks until the device has completed all preceding requested tasks."]
    #[doc = " ::cudaDeviceSynchronize() returns an error if one of the preceding tasks"]
    #[doc = " has failed. If the ::cudaDeviceScheduleBlockingSync flag was set for"]
    #[doc = " this device, the host thread will block until the device has finished"]
    #[doc = " its work."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaDeviceReset,"]
    #[doc = " ::cuCtxSynchronize"]
    pub fn cudaDeviceSynchronize() -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Set resource limits"]
    #[doc = ""]
    #[doc = " Setting \\p limit to \\p value is a request by the application to update"]
    #[doc = " the current limit maintained by the device.  The driver is free to"]
    #[doc = " modify the requested value to meet h/w requirements (this could be"]
    #[doc = " clamping to minimum or maximum values, rounding up to nearest element"]
    #[doc = " size, etc).  The application can use ::cudaDeviceGetLimit() to find out"]
    #[doc = " exactly what the limit has been set to."]
    #[doc = ""]
    #[doc = " Setting each ::cudaLimit has its own specific restrictions, so each is"]
    #[doc = " discussed here."]
    #[doc = ""]
    #[doc = " - ::cudaLimitStackSize controls the stack size in bytes of each GPU thread."]
    #[doc = ""]
    #[doc = " - ::cudaLimitPrintfFifoSize controls the size in bytes of the shared FIFO"]
    #[doc = "   used by the ::printf() device system call. Setting"]
    #[doc = "   ::cudaLimitPrintfFifoSize must not be performed after launching any kernel"]
    #[doc = "   that uses the ::printf() device system call - in such case"]
    #[doc = "   ::cudaErrorInvalidValue will be returned."]
    #[doc = ""]
    #[doc = " - ::cudaLimitMallocHeapSize controls the size in bytes of the heap used by"]
    #[doc = "   the ::malloc() and ::free() device system calls. Setting"]
    #[doc = "   ::cudaLimitMallocHeapSize must not be performed after launching any kernel"]
    #[doc = "   that uses the ::malloc() or ::free() device system calls - in such case"]
    #[doc = "   ::cudaErrorInvalidValue will be returned."]
    #[doc = ""]
    #[doc = " - ::cudaLimitDevRuntimeSyncDepth controls the maximum nesting depth of a"]
    #[doc = "   grid at which a thread can safely call ::cudaDeviceSynchronize(). Setting"]
    #[doc = "   this limit must be performed before any launch of a kernel that uses the"]
    #[doc = "   device runtime and calls ::cudaDeviceSynchronize() above the default sync"]
    #[doc = "   depth, two levels of grids. Calls to ::cudaDeviceSynchronize() will fail"]
    #[doc = "   with error code ::cudaErrorSyncDepthExceeded if the limitation is"]
    #[doc = "   violated. This limit can be set smaller than the default or up the maximum"]
    #[doc = "   launch depth of 24. When setting this limit, keep in mind that additional"]
    #[doc = "   levels of sync depth require the runtime to reserve large amounts of"]
    #[doc = "   device memory which can no longer be used for user allocations. If these"]
    #[doc = "   reservations of device memory fail, ::cudaDeviceSetLimit will return"]
    #[doc = "   ::cudaErrorMemoryAllocation, and the limit can be reset to a lower value."]
    #[doc = "   This limit is only applicable to devices of compute capability 3.5 and"]
    #[doc = "   higher. Attempting to set this limit on devices of compute capability less"]
    #[doc = "   than 3.5 will result in the error ::cudaErrorUnsupportedLimit being"]
    #[doc = "   returned."]
    #[doc = ""]
    #[doc = " - ::cudaLimitDevRuntimePendingLaunchCount controls the maximum number of"]
    #[doc = "   outstanding device runtime launches that can be made from the current"]
    #[doc = "   device. A grid is outstanding from the point of launch up until the grid"]
    #[doc = "   is known to have been completed. Device runtime launches which violate"]
    #[doc = "   this limitation fail and return ::cudaErrorLaunchPendingCountExceeded when"]
    #[doc = "   ::cudaGetLastError() is called after launch. If more pending launches than"]
    #[doc = "   the default (2048 launches) are needed for a module using the device"]
    #[doc = "   runtime, this limit can be increased. Keep in mind that being able to"]
    #[doc = "   sustain additional pending launches will require the runtime to reserve"]
    #[doc = "   larger amounts of device memory upfront which can no longer be used for"]
    #[doc = "   allocations. If these reservations fail, ::cudaDeviceSetLimit will return"]
    #[doc = "   ::cudaErrorMemoryAllocation, and the limit can be reset to a lower value."]
    #[doc = "   This limit is only applicable to devices of compute capability 3.5 and"]
    #[doc = "   higher. Attempting to set this limit on devices of compute capability less"]
    #[doc = "   than 3.5 will result in the error ::cudaErrorUnsupportedLimit being"]
    #[doc = "   returned."]
    #[doc = ""]
    #[doc = " - ::cudaLimitMaxL2FetchGranularity controls the L2 cache fetch granularity."]
    #[doc = "   Values can range from 0B to 128B. This is purely a performance hint and"]
    #[doc = "   it can be ignored or clamped depending on the platform."]
    #[doc = ""]
    #[doc = " - ::cudaLimitPersistingL2CacheSize controls size in bytes available"]
    #[doc = "   for persisting L2 cache. This is purely a performance hint and it"]
    #[doc = "   can be ignored or clamped depending on the platform."]
    #[doc = ""]
    #[doc = " \\param limit - Limit to set"]
    #[doc = " \\param value - Size of limit"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorUnsupportedLimit,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaDeviceGetLimit,"]
    #[doc = " ::cuCtxSetLimit"]
    pub fn cudaDeviceSetLimit(limit: cudaLimit, value: usize) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns resource limits"]
    #[doc = ""]
    #[doc = " Returns in \\p *pValue the current size of \\p limit.  The supported"]
    #[doc = " ::cudaLimit values are:"]
    #[doc = " - ::cudaLimitStackSize: stack size in bytes of each GPU thread;"]
    #[doc = " - ::cudaLimitPrintfFifoSize: size in bytes of the shared FIFO used by the"]
    #[doc = "   ::printf() device system call."]
    #[doc = " - ::cudaLimitMallocHeapSize: size in bytes of the heap used by the"]
    #[doc = "   ::malloc() and ::free() device system calls;"]
    #[doc = " - ::cudaLimitDevRuntimeSyncDepth: maximum grid depth at which a"]
    #[doc = "   thread can isssue the device runtime call ::cudaDeviceSynchronize()"]
    #[doc = "   to wait on child grid launches to complete."]
    #[doc = " - ::cudaLimitDevRuntimePendingLaunchCount: maximum number of outstanding"]
    #[doc = "   device runtime launches."]
    #[doc = " - ::cudaLimitMaxL2FetchGranularity: L2 cache fetch granularity."]
    #[doc = " - ::cudaLimitPersistingL2CacheSize: Persisting L2 cache size in bytes"]
    #[doc = ""]
    #[doc = " \\param limit  - Limit to query"]
    #[doc = " \\param pValue - Returned size of the limit"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorUnsupportedLimit,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaDeviceSetLimit,"]
    #[doc = " ::cuCtxGetLimit"]
    pub fn cudaDeviceGetLimit(pValue: *mut usize, limit: cudaLimit) -> cudaError_t;
}
extern "C" {
    pub fn cudaDeviceGetTexture1DLinearMaxWidth(
        maxWidthInElements: *mut usize,
        fmtDesc: *const cudaChannelFormatDesc,
        device: ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns the preferred cache configuration for the current device."]
    #[doc = ""]
    #[doc = " On devices where the L1 cache and shared memory use the same hardware"]
    #[doc = " resources, this returns through \\p pCacheConfig the preferred cache"]
    #[doc = " configuration for the current device. This is only a preference. The"]
    #[doc = " runtime will use the requested configuration if possible, but it is free to"]
    #[doc = " choose a different configuration if required to execute functions."]
    #[doc = ""]
    #[doc = " This will return a \\p pCacheConfig of ::cudaFuncCachePreferNone on devices"]
    #[doc = " where the size of the L1 cache and shared memory are fixed."]
    #[doc = ""]
    #[doc = " The supported cache configurations are:"]
    #[doc = " - ::cudaFuncCachePreferNone: no preference for shared memory or L1 (default)"]
    #[doc = " - ::cudaFuncCachePreferShared: prefer larger shared memory and smaller L1 cache"]
    #[doc = " - ::cudaFuncCachePreferL1: prefer larger L1 cache and smaller shared memory"]
    #[doc = " - ::cudaFuncCachePreferEqual: prefer equal size L1 cache and shared memory"]
    #[doc = ""]
    #[doc = " \\param pCacheConfig - Returned cache configuration"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceSetCacheConfig,"]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(const void*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C API)\","]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(T*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C++ API)\","]
    #[doc = " ::cuCtxGetCacheConfig"]
    pub fn cudaDeviceGetCacheConfig(pCacheConfig: *mut cudaFuncCache) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns numerical values that correspond to the least and"]
    #[doc = " greatest stream priorities."]
    #[doc = ""]
    #[doc = " Returns in \\p *leastPriority and \\p *greatestPriority the numerical values that correspond"]
    #[doc = " to the least and greatest stream priorities respectively. Stream priorities"]
    #[doc = " follow a convention where lower numbers imply greater priorities. The range of"]
    #[doc = " meaningful stream priorities is given by [\\p *greatestPriority, \\p *leastPriority]."]
    #[doc = " If the user attempts to create a stream with a priority value that is"]
    #[doc = " outside the the meaningful range as specified by this API, the priority is"]
    #[doc = " automatically clamped down or up to either \\p *leastPriority or \\p *greatestPriority"]
    #[doc = " respectively. See ::cudaStreamCreateWithPriority for details on creating a"]
    #[doc = " priority stream."]
    #[doc = " A NULL may be passed in for \\p *leastPriority or \\p *greatestPriority if the value"]
    #[doc = " is not desired."]
    #[doc = ""]
    #[doc = " This function will return '0' in both \\p *leastPriority and \\p *greatestPriority if"]
    #[doc = " the current context's device does not support stream priorities"]
    #[doc = " (see ::cudaDeviceGetAttribute)."]
    #[doc = ""]
    #[doc = " \\param leastPriority    - Pointer to an int in which the numerical value for least"]
    #[doc = "                           stream priority is returned"]
    #[doc = " \\param greatestPriority - Pointer to an int in which the numerical value for greatest"]
    #[doc = "                           stream priority is returned"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaStreamCreateWithPriority,"]
    #[doc = " ::cudaStreamGetPriority,"]
    #[doc = " ::cuCtxGetStreamPriorityRange"]
    pub fn cudaDeviceGetStreamPriorityRange(
        leastPriority: *mut ::libc::c_int,
        greatestPriority: *mut ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets the preferred cache configuration for the current device."]
    #[doc = ""]
    #[doc = " On devices where the L1 cache and shared memory use the same hardware"]
    #[doc = " resources, this sets through \\p cacheConfig the preferred cache"]
    #[doc = " configuration for the current device. This is only a preference. The"]
    #[doc = " runtime will use the requested configuration if possible, but it is free to"]
    #[doc = " choose a different configuration if required to execute the function. Any"]
    #[doc = " function preference set via"]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(const void*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C API)\""]
    #[doc = " or"]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(T*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C++ API)\""]
    #[doc = " will be preferred over this device-wide setting. Setting the device-wide"]
    #[doc = " cache configuration to ::cudaFuncCachePreferNone will cause subsequent"]
    #[doc = " kernel launches to prefer to not change the cache configuration unless"]
    #[doc = " required to launch the kernel."]
    #[doc = ""]
    #[doc = " This setting does nothing on devices where the size of the L1 cache and"]
    #[doc = " shared memory are fixed."]
    #[doc = ""]
    #[doc = " Launching a kernel with a different preference than the most recent"]
    #[doc = " preference setting may insert a device-side synchronization point."]
    #[doc = ""]
    #[doc = " The supported cache configurations are:"]
    #[doc = " - ::cudaFuncCachePreferNone: no preference for shared memory or L1 (default)"]
    #[doc = " - ::cudaFuncCachePreferShared: prefer larger shared memory and smaller L1 cache"]
    #[doc = " - ::cudaFuncCachePreferL1: prefer larger L1 cache and smaller shared memory"]
    #[doc = " - ::cudaFuncCachePreferEqual: prefer equal size L1 cache and shared memory"]
    #[doc = ""]
    #[doc = " \\param cacheConfig - Requested cache configuration"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceGetCacheConfig,"]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(const void*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C API)\","]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(T*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C++ API)\","]
    #[doc = " ::cuCtxSetCacheConfig"]
    pub fn cudaDeviceSetCacheConfig(cacheConfig: cudaFuncCache) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns the shared memory configuration for the current device."]
    #[doc = ""]
    #[doc = " This function will return in \\p pConfig the current size of shared memory banks"]
    #[doc = " on the current device. On devices with configurable shared memory banks,"]
    #[doc = " ::cudaDeviceSetSharedMemConfig can be used to change this setting, so that all"]
    #[doc = " subsequent kernel launches will by default use the new bank size. When"]
    #[doc = " ::cudaDeviceGetSharedMemConfig is called on devices without configurable shared"]
    #[doc = " memory, it will return the fixed bank size of the hardware."]
    #[doc = ""]
    #[doc = " The returned bank configurations can be either:"]
    #[doc = " - ::cudaSharedMemBankSizeFourByte - shared memory bank width is four bytes."]
    #[doc = " - ::cudaSharedMemBankSizeEightByte - shared memory bank width is eight bytes."]
    #[doc = ""]
    #[doc = " \\param pConfig - Returned cache configuration"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceSetCacheConfig,"]
    #[doc = " ::cudaDeviceGetCacheConfig,"]
    #[doc = " ::cudaDeviceSetSharedMemConfig,"]
    #[doc = " ::cudaFuncSetCacheConfig,"]
    #[doc = " ::cuCtxGetSharedMemConfig"]
    pub fn cudaDeviceGetSharedMemConfig(pConfig: *mut cudaSharedMemConfig) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets the shared memory configuration for the current device."]
    #[doc = ""]
    #[doc = " On devices with configurable shared memory banks, this function will set"]
    #[doc = " the shared memory bank size which is used for all subsequent kernel launches."]
    #[doc = " Any per-function setting of shared memory set via ::cudaFuncSetSharedMemConfig"]
    #[doc = " will override the device wide setting."]
    #[doc = ""]
    #[doc = " Changing the shared memory configuration between launches may introduce"]
    #[doc = " a device side synchronization point."]
    #[doc = ""]
    #[doc = " Changing the shared memory bank size will not increase shared memory usage"]
    #[doc = " or affect occupancy of kernels, but may have major effects on performance."]
    #[doc = " Larger bank sizes will allow for greater potential bandwidth to shared memory,"]
    #[doc = " but will change what kinds of accesses to shared memory will result in bank"]
    #[doc = " conflicts."]
    #[doc = ""]
    #[doc = " This function will do nothing on devices with fixed shared memory bank size."]
    #[doc = ""]
    #[doc = " The supported bank configurations are:"]
    #[doc = " - ::cudaSharedMemBankSizeDefault: set bank width the device default (currently,"]
    #[doc = "   four bytes)"]
    #[doc = " - ::cudaSharedMemBankSizeFourByte: set shared memory bank width to be four bytes"]
    #[doc = "   natively."]
    #[doc = " - ::cudaSharedMemBankSizeEightByte: set shared memory bank width to be eight"]
    #[doc = "   bytes natively."]
    #[doc = ""]
    #[doc = " \\param config - Requested cache configuration"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceSetCacheConfig,"]
    #[doc = " ::cudaDeviceGetCacheConfig,"]
    #[doc = " ::cudaDeviceGetSharedMemConfig,"]
    #[doc = " ::cudaFuncSetCacheConfig,"]
    #[doc = " ::cuCtxSetSharedMemConfig"]
    pub fn cudaDeviceSetSharedMemConfig(config: cudaSharedMemConfig) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a handle to a compute device"]
    #[doc = ""]
    #[doc = " Returns in \\p *device a device ordinal given a PCI bus ID string."]
    #[doc = ""]
    #[doc = " \\param device   - Returned device ordinal"]
    #[doc = ""]
    #[doc = " \\param pciBusId - String in one of the following forms:"]
    #[doc = " [domain]:[bus]:[device].[function]"]
    #[doc = " [domain]:[bus]:[device]"]
    #[doc = " [bus]:[device].[function]"]
    #[doc = " where \\p domain, \\p bus, \\p device, and \\p function are all hexadecimal values"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaDeviceGetPCIBusId,"]
    #[doc = " ::cuDeviceGetByPCIBusId"]
    pub fn cudaDeviceGetByPCIBusId(
        device: *mut ::libc::c_int,
        pciBusId: *const ::libc::c_char,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a PCI Bus Id string for the device"]
    #[doc = ""]
    #[doc = " Returns an ASCII string identifying the device \\p dev in the NULL-terminated"]
    #[doc = " string pointed to by \\p pciBusId. \\p len specifies the maximum length of the"]
    #[doc = " string that may be returned."]
    #[doc = ""]
    #[doc = " \\param pciBusId - Returned identifier string for the device in the following format"]
    #[doc = " [domain]:[bus]:[device].[function]"]
    #[doc = " where \\p domain, \\p bus, \\p device, and \\p function are all hexadecimal values."]
    #[doc = " pciBusId should be large enough to store 13 characters including the NULL-terminator."]
    #[doc = ""]
    #[doc = " \\param len      - Maximum length of string to store in \\p name"]
    #[doc = ""]
    #[doc = " \\param device   - Device to get identifier string for"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaDeviceGetByPCIBusId,"]
    #[doc = " ::cuDeviceGetPCIBusId"]
    pub fn cudaDeviceGetPCIBusId(
        pciBusId: *mut ::libc::c_char,
        len: ::libc::c_int,
        device: ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Gets an interprocess handle for a previously allocated event"]
    #[doc = ""]
    #[doc = " Takes as input a previously allocated event. This event must have been"]
    #[doc = " created with the ::cudaEventInterprocess and ::cudaEventDisableTiming"]
    #[doc = " flags set. This opaque handle may be copied into other processes and"]
    #[doc = " opened with ::cudaIpcOpenEventHandle to allow efficient hardware"]
    #[doc = " synchronization between GPU work in different processes."]
    #[doc = ""]
    #[doc = " After the event has been been opened in the importing process,"]
    #[doc = " ::cudaEventRecord, ::cudaEventSynchronize, ::cudaStreamWaitEvent and"]
    #[doc = " ::cudaEventQuery may be used in either process. Performing operations"]
    #[doc = " on the imported event after the exported event has been freed"]
    #[doc = " with ::cudaEventDestroy will result in undefined behavior."]
    #[doc = ""]
    #[doc = " IPC functionality is restricted to devices with support for unified"]
    #[doc = " addressing on Linux operating systems. IPC functionality is not supported"]
    #[doc = " on Tegra platforms."]
    #[doc = ""]
    #[doc = " \\param handle - Pointer to a user allocated cudaIpcEventHandle"]
    #[doc = "                    in which to return the opaque event handle"]
    #[doc = " \\param event   - Event allocated with ::cudaEventInterprocess and"]
    #[doc = "                    ::cudaEventDisableTiming flags."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorMemoryAllocation,"]
    #[doc = " ::cudaErrorMapBufferObjectFailed,"]
    #[doc = " ::cudaErrorNotSupported,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaEventCreate,"]
    #[doc = " ::cudaEventDestroy,"]
    #[doc = " ::cudaEventSynchronize,"]
    #[doc = " ::cudaEventQuery,"]
    #[doc = " ::cudaStreamWaitEvent,"]
    #[doc = " ::cudaIpcOpenEventHandle,"]
    #[doc = " ::cudaIpcGetMemHandle,"]
    #[doc = " ::cudaIpcOpenMemHandle,"]
    #[doc = " ::cudaIpcCloseMemHandle,"]
    #[doc = " ::cuIpcGetEventHandle"]
    pub fn cudaIpcGetEventHandle(
        handle: *mut cudaIpcEventHandle_t,
        event: cudaEvent_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Opens an interprocess event handle for use in the current process"]
    #[doc = ""]
    #[doc = " Opens an interprocess event handle exported from another process with"]
    #[doc = " ::cudaIpcGetEventHandle. This function returns a ::cudaEvent_t that behaves like"]
    #[doc = " a locally created event with the ::cudaEventDisableTiming flag specified."]
    #[doc = " This event must be freed with ::cudaEventDestroy."]
    #[doc = ""]
    #[doc = " Performing operations on the imported event after the exported event has"]
    #[doc = " been freed with ::cudaEventDestroy will result in undefined behavior."]
    #[doc = ""]
    #[doc = " IPC functionality is restricted to devices with support for unified"]
    #[doc = " addressing on Linux operating systems. IPC functionality is not supported"]
    #[doc = " on Tegra platforms."]
    #[doc = ""]
    #[doc = " \\param event - Returns the imported event"]
    #[doc = " \\param handle  - Interprocess handle to open"]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorMapBufferObjectFailed,"]
    #[doc = " ::cudaErrorNotSupported,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorDeviceUninitialized"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaEventCreate,"]
    #[doc = " ::cudaEventDestroy,"]
    #[doc = " ::cudaEventSynchronize,"]
    #[doc = " ::cudaEventQuery,"]
    #[doc = " ::cudaStreamWaitEvent,"]
    #[doc = " ::cudaIpcGetEventHandle,"]
    #[doc = " ::cudaIpcGetMemHandle,"]
    #[doc = " ::cudaIpcOpenMemHandle,"]
    #[doc = " ::cudaIpcCloseMemHandle,"]
    #[doc = " ::cuIpcOpenEventHandle"]
    pub fn cudaIpcOpenEventHandle(
        event: *mut cudaEvent_t,
        handle: cudaIpcEventHandle_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Gets an interprocess memory handle for an existing device memory"]
    #[doc = "          allocation"]
    #[doc = ""]
    #[doc = " Takes a pointer to the base of an existing device memory allocation created"]
    #[doc = " with ::cudaMalloc and exports it for use in another process. This is a"]
    #[doc = " lightweight operation and may be called multiple times on an allocation"]
    #[doc = " without adverse effects."]
    #[doc = ""]
    #[doc = " If a region of memory is freed with ::cudaFree and a subsequent call"]
    #[doc = " to ::cudaMalloc returns memory with the same device address,"]
    #[doc = " ::cudaIpcGetMemHandle will return a unique handle for the"]
    #[doc = " new memory."]
    #[doc = ""]
    #[doc = " IPC functionality is restricted to devices with support for unified"]
    #[doc = " addressing on Linux operating systems. IPC functionality is not supported"]
    #[doc = " on Tegra platforms."]
    #[doc = ""]
    #[doc = " \\param handle - Pointer to user allocated ::cudaIpcMemHandle to return"]
    #[doc = "                    the handle in."]
    #[doc = " \\param devPtr - Base pointer to previously allocated device memory"]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorMemoryAllocation,"]
    #[doc = " ::cudaErrorMapBufferObjectFailed,"]
    #[doc = " ::cudaErrorNotSupported,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaMalloc,"]
    #[doc = " ::cudaFree,"]
    #[doc = " ::cudaIpcGetEventHandle,"]
    #[doc = " ::cudaIpcOpenEventHandle,"]
    #[doc = " ::cudaIpcOpenMemHandle,"]
    #[doc = " ::cudaIpcCloseMemHandle,"]
    #[doc = " ::cuIpcGetMemHandle"]
    pub fn cudaIpcGetMemHandle(
        handle: *mut cudaIpcMemHandle_t,
        devPtr: *mut ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Opens an interprocess memory handle exported from another process"]
    #[doc = "          and returns a device pointer usable in the local process."]
    #[doc = ""]
    #[doc = " Maps memory exported from another process with ::cudaIpcGetMemHandle into"]
    #[doc = " the current device address space. For contexts on different devices"]
    #[doc = " ::cudaIpcOpenMemHandle can attempt to enable peer access between the"]
    #[doc = " devices as if the user called ::cudaDeviceEnablePeerAccess. This behavior is"]
    #[doc = " controlled by the ::cudaIpcMemLazyEnablePeerAccess flag."]
    #[doc = " ::cudaDeviceCanAccessPeer can determine if a mapping is possible."]
    #[doc = ""]
    #[doc = " ::cudaIpcOpenMemHandle can open handles to devices that may not be visible"]
    #[doc = " in the process calling the API."]
    #[doc = ""]
    #[doc = " Contexts that may open ::cudaIpcMemHandles are restricted in the following way."]
    #[doc = " ::cudaIpcMemHandles from each device in a given process may only be opened"]
    #[doc = " by one context per device per other process."]
    #[doc = ""]
    #[doc = " If the memory handle has already been opened by the current context, the"]
    #[doc = " reference count on the handle is incremented by 1 and the existing device pointer"]
    #[doc = " is returned."]
    #[doc = ""]
    #[doc = " Memory returned from ::cudaIpcOpenMemHandle must be freed with"]
    #[doc = " ::cudaIpcCloseMemHandle."]
    #[doc = ""]
    #[doc = " Calling ::cudaFree on an exported memory region before calling"]
    #[doc = " ::cudaIpcCloseMemHandle in the importing context will result in undefined"]
    #[doc = " behavior."]
    #[doc = ""]
    #[doc = " IPC functionality is restricted to devices with support for unified"]
    #[doc = " addressing on Linux operating systems. IPC functionality is not supported"]
    #[doc = " on Tegra platforms."]
    #[doc = ""]
    #[doc = " \\param devPtr - Returned device pointer"]
    #[doc = " \\param handle - ::cudaIpcMemHandle to open"]
    #[doc = " \\param flags  - Flags for this operation. Must be specified as ::cudaIpcMemLazyEnablePeerAccess"]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorMapBufferObjectFailed,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorDeviceUninitialized,"]
    #[doc = " ::cudaErrorTooManyPeers,"]
    #[doc = " ::cudaErrorNotSupported,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\note No guarantees are made about the address returned in \\p *devPtr."]
    #[doc = " In particular, multiple processes may not receive the same address for the same \\p handle."]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaMalloc,"]
    #[doc = " ::cudaFree,"]
    #[doc = " ::cudaIpcGetEventHandle,"]
    #[doc = " ::cudaIpcOpenEventHandle,"]
    #[doc = " ::cudaIpcGetMemHandle,"]
    #[doc = " ::cudaIpcCloseMemHandle,"]
    #[doc = " ::cudaDeviceEnablePeerAccess,"]
    #[doc = " ::cudaDeviceCanAccessPeer,"]
    #[doc = " ::cuIpcOpenMemHandle"]
    pub fn cudaIpcOpenMemHandle(
        devPtr: *mut *mut ::libc::c_void,
        handle: cudaIpcMemHandle_t,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Attempts to close memory mapped with cudaIpcOpenMemHandle"]
    #[doc = ""]
    #[doc = " Decrements the reference count of the memory returnd by ::cudaIpcOpenMemHandle by 1."]
    #[doc = " When the reference count reaches 0, this API unmaps the memory. The original allocation"]
    #[doc = " in the exporting process as well as imported mappings in other processes"]
    #[doc = " will be unaffected."]
    #[doc = ""]
    #[doc = " Any resources used to enable peer access will be freed if this is the"]
    #[doc = " last mapping using them."]
    #[doc = ""]
    #[doc = " IPC functionality is restricted to devices with support for unified"]
    #[doc = " addressing on Linux operating systems. IPC functionality is not supported"]
    #[doc = " on Tegra platforms."]
    #[doc = ""]
    #[doc = " \\param devPtr - Device pointer returned by ::cudaIpcOpenMemHandle"]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorMapBufferObjectFailed,"]
    #[doc = " ::cudaErrorNotSupported,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaMalloc,"]
    #[doc = " ::cudaFree,"]
    #[doc = " ::cudaIpcGetEventHandle,"]
    #[doc = " ::cudaIpcOpenEventHandle,"]
    #[doc = " ::cudaIpcGetMemHandle,"]
    #[doc = " ::cudaIpcOpenMemHandle,"]
    #[doc = " ::cuIpcCloseMemHandle"]
    pub fn cudaIpcCloseMemHandle(devPtr: *mut ::libc::c_void) -> cudaError_t;
}
extern "C" {
    pub fn cudaDeviceFlushGPUDirectRDMAWrites(
        target: cudaFlushGPUDirectRDMAWritesTarget,
        scope: cudaFlushGPUDirectRDMAWritesScope,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Exit and clean up from CUDA launches"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Note that this function is deprecated because its name does not"]
    #[doc = " reflect its behavior.  Its functionality is identical to the"]
    #[doc = " non-deprecated function ::cudaDeviceReset(), which should be used"]
    #[doc = " instead."]
    #[doc = ""]
    #[doc = " Explicitly destroys all cleans up all resources associated with the current"]
    #[doc = " device in the current process.  Any subsequent API call to this device will"]
    #[doc = " reinitialize the device."]
    #[doc = ""]
    #[doc = " Note that this function will reset the device immediately.  It is the caller's"]
    #[doc = " responsibility to ensure that the device is not being accessed by any"]
    #[doc = " other host threads from the process when this function is called."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceReset"]
    pub fn cudaThreadExit() -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Wait for compute device to finish"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Note that this function is deprecated because its name does not"]
    #[doc = " reflect its behavior.  Its functionality is similar to the"]
    #[doc = " non-deprecated function ::cudaDeviceSynchronize(), which should be used"]
    #[doc = " instead."]
    #[doc = ""]
    #[doc = " Blocks until the device has completed all preceding requested tasks."]
    #[doc = " ::cudaThreadSynchronize() returns an error if one of the preceding tasks"]
    #[doc = " has failed. If the ::cudaDeviceScheduleBlockingSync flag was set for"]
    #[doc = " this device, the host thread will block until the device has finished"]
    #[doc = " its work."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceSynchronize"]
    pub fn cudaThreadSynchronize() -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Set resource limits"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Note that this function is deprecated because its name does not"]
    #[doc = " reflect its behavior.  Its functionality is identical to the"]
    #[doc = " non-deprecated function ::cudaDeviceSetLimit(), which should be used"]
    #[doc = " instead."]
    #[doc = ""]
    #[doc = " Setting \\p limit to \\p value is a request by the application to update"]
    #[doc = " the current limit maintained by the device.  The driver is free to"]
    #[doc = " modify the requested value to meet h/w requirements (this could be"]
    #[doc = " clamping to minimum or maximum values, rounding up to nearest element"]
    #[doc = " size, etc).  The application can use ::cudaThreadGetLimit() to find out"]
    #[doc = " exactly what the limit has been set to."]
    #[doc = ""]
    #[doc = " Setting each ::cudaLimit has its own specific restrictions, so each is"]
    #[doc = " discussed here."]
    #[doc = ""]
    #[doc = " - ::cudaLimitStackSize controls the stack size of each GPU thread."]
    #[doc = ""]
    #[doc = " - ::cudaLimitPrintfFifoSize controls the size of the shared FIFO"]
    #[doc = "   used by the ::printf() device system call."]
    #[doc = "   Setting ::cudaLimitPrintfFifoSize must be performed before"]
    #[doc = "   launching any kernel that uses the ::printf() device"]
    #[doc = "   system call, otherwise ::cudaErrorInvalidValue will be returned."]
    #[doc = ""]
    #[doc = " - ::cudaLimitMallocHeapSize controls the size of the heap used"]
    #[doc = "   by the ::malloc() and ::free() device system calls.  Setting"]
    #[doc = "   ::cudaLimitMallocHeapSize must be performed before launching"]
    #[doc = "   any kernel that uses the ::malloc() or ::free() device system calls,"]
    #[doc = "   otherwise ::cudaErrorInvalidValue will be returned."]
    #[doc = ""]
    #[doc = " \\param limit - Limit to set"]
    #[doc = " \\param value - Size in bytes of limit"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorUnsupportedLimit,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceSetLimit"]
    pub fn cudaThreadSetLimit(limit: cudaLimit, value: usize) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns resource limits"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Note that this function is deprecated because its name does not"]
    #[doc = " reflect its behavior.  Its functionality is identical to the"]
    #[doc = " non-deprecated function ::cudaDeviceGetLimit(), which should be used"]
    #[doc = " instead."]
    #[doc = ""]
    #[doc = " Returns in \\p *pValue the current size of \\p limit.  The supported"]
    #[doc = " ::cudaLimit values are:"]
    #[doc = " - ::cudaLimitStackSize: stack size of each GPU thread;"]
    #[doc = " - ::cudaLimitPrintfFifoSize: size of the shared FIFO used by the"]
    #[doc = "   ::printf() device system call."]
    #[doc = " - ::cudaLimitMallocHeapSize: size of the heap used by the"]
    #[doc = "   ::malloc() and ::free() device system calls;"]
    #[doc = ""]
    #[doc = " \\param limit  - Limit to query"]
    #[doc = " \\param pValue - Returned size in bytes of limit"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorUnsupportedLimit,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceGetLimit"]
    pub fn cudaThreadGetLimit(pValue: *mut usize, limit: cudaLimit) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns the preferred cache configuration for the current device."]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Note that this function is deprecated because its name does not"]
    #[doc = " reflect its behavior.  Its functionality is identical to the"]
    #[doc = " non-deprecated function ::cudaDeviceGetCacheConfig(), which should be"]
    #[doc = " used instead."]
    #[doc = ""]
    #[doc = " On devices where the L1 cache and shared memory use the same hardware"]
    #[doc = " resources, this returns through \\p pCacheConfig the preferred cache"]
    #[doc = " configuration for the current device. This is only a preference. The"]
    #[doc = " runtime will use the requested configuration if possible, but it is free to"]
    #[doc = " choose a different configuration if required to execute functions."]
    #[doc = ""]
    #[doc = " This will return a \\p pCacheConfig of ::cudaFuncCachePreferNone on devices"]
    #[doc = " where the size of the L1 cache and shared memory are fixed."]
    #[doc = ""]
    #[doc = " The supported cache configurations are:"]
    #[doc = " - ::cudaFuncCachePreferNone: no preference for shared memory or L1 (default)"]
    #[doc = " - ::cudaFuncCachePreferShared: prefer larger shared memory and smaller L1 cache"]
    #[doc = " - ::cudaFuncCachePreferL1: prefer larger L1 cache and smaller shared memory"]
    #[doc = ""]
    #[doc = " \\param pCacheConfig - Returned cache configuration"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceGetCacheConfig"]
    pub fn cudaThreadGetCacheConfig(pCacheConfig: *mut cudaFuncCache) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets the preferred cache configuration for the current device."]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Note that this function is deprecated because its name does not"]
    #[doc = " reflect its behavior.  Its functionality is identical to the"]
    #[doc = " non-deprecated function ::cudaDeviceSetCacheConfig(), which should be"]
    #[doc = " used instead."]
    #[doc = ""]
    #[doc = " On devices where the L1 cache and shared memory use the same hardware"]
    #[doc = " resources, this sets through \\p cacheConfig the preferred cache"]
    #[doc = " configuration for the current device. This is only a preference. The"]
    #[doc = " runtime will use the requested configuration if possible, but it is free to"]
    #[doc = " choose a different configuration if required to execute the function. Any"]
    #[doc = " function preference set via"]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(const void*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C API)\""]
    #[doc = " or"]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(T*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C++ API)\""]
    #[doc = " will be preferred over this device-wide setting. Setting the device-wide"]
    #[doc = " cache configuration to ::cudaFuncCachePreferNone will cause subsequent"]
    #[doc = " kernel launches to prefer to not change the cache configuration unless"]
    #[doc = " required to launch the kernel."]
    #[doc = ""]
    #[doc = " This setting does nothing on devices where the size of the L1 cache and"]
    #[doc = " shared memory are fixed."]
    #[doc = ""]
    #[doc = " Launching a kernel with a different preference than the most recent"]
    #[doc = " preference setting may insert a device-side synchronization point."]
    #[doc = ""]
    #[doc = " The supported cache configurations are:"]
    #[doc = " - ::cudaFuncCachePreferNone: no preference for shared memory or L1 (default)"]
    #[doc = " - ::cudaFuncCachePreferShared: prefer larger shared memory and smaller L1 cache"]
    #[doc = " - ::cudaFuncCachePreferL1: prefer larger L1 cache and smaller shared memory"]
    #[doc = ""]
    #[doc = " \\param cacheConfig - Requested cache configuration"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceSetCacheConfig"]
    pub fn cudaThreadSetCacheConfig(cacheConfig: cudaFuncCache) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns the last error from a runtime call"]
    #[doc = ""]
    #[doc = " Returns the last error that has been produced by any of the runtime calls"]
    #[doc = " in the same host thread and resets it to ::cudaSuccess."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorMissingConfiguration,"]
    #[doc = " ::cudaErrorMemoryAllocation,"]
    #[doc = " ::cudaErrorInitializationError,"]
    #[doc = " ::cudaErrorLaunchFailure,"]
    #[doc = " ::cudaErrorLaunchTimeout,"]
    #[doc = " ::cudaErrorLaunchOutOfResources,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction,"]
    #[doc = " ::cudaErrorInvalidConfiguration,"]
    #[doc = " ::cudaErrorInvalidDevice,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidPitchValue,"]
    #[doc = " ::cudaErrorInvalidSymbol,"]
    #[doc = " ::cudaErrorUnmapBufferObjectFailed,"]
    #[doc = " ::cudaErrorInvalidDevicePointer,"]
    #[doc = " ::cudaErrorInvalidTexture,"]
    #[doc = " ::cudaErrorInvalidTextureBinding,"]
    #[doc = " ::cudaErrorInvalidChannelDescriptor,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection,"]
    #[doc = " ::cudaErrorInvalidFilterSetting,"]
    #[doc = " ::cudaErrorInvalidNormSetting,"]
    #[doc = " ::cudaErrorUnknown,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorInsufficientDriver,"]
    #[doc = " ::cudaErrorNoDevice,"]
    #[doc = " ::cudaErrorSetOnActiveProcess,"]
    #[doc = " ::cudaErrorStartupFailure,"]
    #[doc = " ::cudaErrorInvalidPtx,"]
    #[doc = " ::cudaErrorUnsupportedPtxVersion,"]
    #[doc = " ::cudaErrorNoKernelImageForDevice,"]
    #[doc = " ::cudaErrorJitCompilerNotFound,"]
    #[doc = " ::cudaErrorJitCompilationDisabled"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaPeekAtLastError, ::cudaGetErrorName, ::cudaGetErrorString, ::cudaError"]
    pub fn cudaGetLastError() -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns the last error from a runtime call"]
    #[doc = ""]
    #[doc = " Returns the last error that has been produced by any of the runtime calls"]
    #[doc = " in the same host thread. Note that this call does not reset the error to"]
    #[doc = " ::cudaSuccess like ::cudaGetLastError()."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorMissingConfiguration,"]
    #[doc = " ::cudaErrorMemoryAllocation,"]
    #[doc = " ::cudaErrorInitializationError,"]
    #[doc = " ::cudaErrorLaunchFailure,"]
    #[doc = " ::cudaErrorLaunchTimeout,"]
    #[doc = " ::cudaErrorLaunchOutOfResources,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction,"]
    #[doc = " ::cudaErrorInvalidConfiguration,"]
    #[doc = " ::cudaErrorInvalidDevice,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidPitchValue,"]
    #[doc = " ::cudaErrorInvalidSymbol,"]
    #[doc = " ::cudaErrorUnmapBufferObjectFailed,"]
    #[doc = " ::cudaErrorInvalidDevicePointer,"]
    #[doc = " ::cudaErrorInvalidTexture,"]
    #[doc = " ::cudaErrorInvalidTextureBinding,"]
    #[doc = " ::cudaErrorInvalidChannelDescriptor,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection,"]
    #[doc = " ::cudaErrorInvalidFilterSetting,"]
    #[doc = " ::cudaErrorInvalidNormSetting,"]
    #[doc = " ::cudaErrorUnknown,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorInsufficientDriver,"]
    #[doc = " ::cudaErrorNoDevice,"]
    #[doc = " ::cudaErrorSetOnActiveProcess,"]
    #[doc = " ::cudaErrorStartupFailure,"]
    #[doc = " ::cudaErrorInvalidPtx,"]
    #[doc = " ::cudaErrorUnsupportedPtxVersion,"]
    #[doc = " ::cudaErrorNoKernelImageForDevice,"]
    #[doc = " ::cudaErrorJitCompilerNotFound,"]
    #[doc = " ::cudaErrorJitCompilationDisabled"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetLastError, ::cudaGetErrorName, ::cudaGetErrorString, ::cudaError"]
    pub fn cudaPeekAtLastError() -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns the string representation of an error code enum name"]
    #[doc = ""]
    #[doc = " Returns a string containing the name of an error code in the enum.  If the error"]
    #[doc = " code is not recognized, \"unrecognized error code\" is returned."]
    #[doc = ""]
    #[doc = " \\param error - Error code to convert to string"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " \\p char* pointer to a NULL-terminated string"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetErrorString, ::cudaGetLastError, ::cudaPeekAtLastError, ::cudaError,"]
    #[doc = " ::cuGetErrorName"]
    pub fn cudaGetErrorName(error: cudaError_t) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " \\brief Returns the description string for an error code"]
    #[doc = ""]
    #[doc = " Returns the description string for an error code.  If the error"]
    #[doc = " code is not recognized, \"unrecognized error code\" is returned."]
    #[doc = ""]
    #[doc = " \\param error - Error code to convert to string"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " \\p char* pointer to a NULL-terminated string"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetErrorName, ::cudaGetLastError, ::cudaPeekAtLastError, ::cudaError,"]
    #[doc = " ::cuGetErrorString"]
    pub fn cudaGetErrorString(error: cudaError_t) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " \\brief Returns the number of compute-capable devices"]
    #[doc = ""]
    #[doc = " Returns in \\p *count the number of devices with compute capability greater"]
    #[doc = " or equal to 2.0 that are available for execution."]
    #[doc = ""]
    #[doc = " \\param count - Returns the number of devices with compute capability"]
    #[doc = " greater or equal to 2.0"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetDevice, ::cudaSetDevice, ::cudaGetDeviceProperties,"]
    #[doc = " ::cudaChooseDevice,"]
    #[doc = " ::cuDeviceGetCount"]
    pub fn cudaGetDeviceCount(count: *mut ::libc::c_int) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns information about the compute-device"]
    #[doc = ""]
    #[doc = " Returns in \\p *prop the properties of device \\p dev. The ::cudaDeviceProp"]
    #[doc = " structure is defined as:"]
    #[doc = " \\code"]
    #[doc = "struct cudaDeviceProp {"]
    #[doc = "char name[256];"]
    #[doc = "cudaUUID_t uuid;"]
    #[doc = "size_t totalGlobalMem;"]
    #[doc = "size_t sharedMemPerBlock;"]
    #[doc = "int regsPerBlock;"]
    #[doc = "int warpSize;"]
    #[doc = "size_t memPitch;"]
    #[doc = "int maxThreadsPerBlock;"]
    #[doc = "int maxThreadsDim[3];"]
    #[doc = "int maxGridSize[3];"]
    #[doc = "int clockRate;"]
    #[doc = "size_t totalConstMem;"]
    #[doc = "int major;"]
    #[doc = "int minor;"]
    #[doc = "size_t textureAlignment;"]
    #[doc = "size_t texturePitchAlignment;"]
    #[doc = "int deviceOverlap;"]
    #[doc = "int multiProcessorCount;"]
    #[doc = "int kernelExecTimeoutEnabled;"]
    #[doc = "int integrated;"]
    #[doc = "int canMapHostMemory;"]
    #[doc = "int computeMode;"]
    #[doc = "int maxTexture1D;"]
    #[doc = "int maxTexture1DMipmap;"]
    #[doc = "int maxTexture1DLinear;"]
    #[doc = "int maxTexture2D[2];"]
    #[doc = "int maxTexture2DMipmap[2];"]
    #[doc = "int maxTexture2DLinear[3];"]
    #[doc = "int maxTexture2DGather[2];"]
    #[doc = "int maxTexture3D[3];"]
    #[doc = "int maxTexture3DAlt[3];"]
    #[doc = "int maxTextureCubemap;"]
    #[doc = "int maxTexture1DLayered[2];"]
    #[doc = "int maxTexture2DLayered[3];"]
    #[doc = "int maxTextureCubemapLayered[2];"]
    #[doc = "int maxSurface1D;"]
    #[doc = "int maxSurface2D[2];"]
    #[doc = "int maxSurface3D[3];"]
    #[doc = "int maxSurface1DLayered[2];"]
    #[doc = "int maxSurface2DLayered[3];"]
    #[doc = "int maxSurfaceCubemap;"]
    #[doc = "int maxSurfaceCubemapLayered[2];"]
    #[doc = "size_t surfaceAlignment;"]
    #[doc = "int concurrentKernels;"]
    #[doc = "int ECCEnabled;"]
    #[doc = "int pciBusID;"]
    #[doc = "int pciDeviceID;"]
    #[doc = "int pciDomainID;"]
    #[doc = "int tccDriver;"]
    #[doc = "int asyncEngineCount;"]
    #[doc = "int unifiedAddressing;"]
    #[doc = "int memoryClockRate;"]
    #[doc = "int memoryBusWidth;"]
    #[doc = "int l2CacheSize;"]
    #[doc = "int persistingL2CacheMaxSize;"]
    #[doc = "int maxThreadsPerMultiProcessor;"]
    #[doc = "int streamPrioritiesSupported;"]
    #[doc = "int globalL1CacheSupported;"]
    #[doc = "int localL1CacheSupported;"]
    #[doc = "size_t sharedMemPerMultiprocessor;"]
    #[doc = "int regsPerMultiprocessor;"]
    #[doc = "int managedMemory;"]
    #[doc = "int isMultiGpuBoard;"]
    #[doc = "int multiGpuBoardGroupID;"]
    #[doc = "int singleToDoublePrecisionPerfRatio;"]
    #[doc = "int pageableMemoryAccess;"]
    #[doc = "int concurrentManagedAccess;"]
    #[doc = "int computePreemptionSupported;"]
    #[doc = "int canUseHostPointerForRegisteredMem;"]
    #[doc = "int cooperativeLaunch;"]
    #[doc = "int cooperativeMultiDeviceLaunch;"]
    #[doc = "int pageableMemoryAccessUsesHostPageTables;"]
    #[doc = "int directManagedMemAccessFromHost;"]
    #[doc = "int accessPolicyMaxWindowSize;"]
    #[doc = "}"]
    #[doc = "\\endcode"]
    #[doc = " where:"]
    #[doc = " - \\ref ::cudaDeviceProp::name \"name[256]\" is an ASCII string identifying"]
    #[doc = "   the device;"]
    #[doc = " - \\ref ::cudaDeviceProp::uuid \"uuid\" is a 16-byte unique identifier."]
    #[doc = " - \\ref ::cudaDeviceProp::totalGlobalMem \"totalGlobalMem\" is the total"]
    #[doc = "   amount of global memory available on the device in bytes;"]
    #[doc = " - \\ref ::cudaDeviceProp::sharedMemPerBlock \"sharedMemPerBlock\" is the"]
    #[doc = "   maximum amount of shared memory available to a thread block in bytes;"]
    #[doc = " - \\ref ::cudaDeviceProp::regsPerBlock \"regsPerBlock\" is the maximum number"]
    #[doc = "   of 32-bit registers available to a thread block;"]
    #[doc = " - \\ref ::cudaDeviceProp::warpSize \"warpSize\" is the warp size in threads;"]
    #[doc = " - \\ref ::cudaDeviceProp::memPitch \"memPitch\" is the maximum pitch in"]
    #[doc = "   bytes allowed by the memory copy functions that involve memory regions"]
    #[doc = "   allocated through ::cudaMallocPitch();"]
    #[doc = " - \\ref ::cudaDeviceProp::maxThreadsPerBlock \"maxThreadsPerBlock\" is the"]
    #[doc = "   maximum number of threads per block;"]
    #[doc = " - \\ref ::cudaDeviceProp::maxThreadsDim \"maxThreadsDim[3]\" contains the"]
    #[doc = "   maximum size of each dimension of a block;"]
    #[doc = " - \\ref ::cudaDeviceProp::maxGridSize \"maxGridSize[3]\" contains the"]
    #[doc = "   maximum size of each dimension of a grid;"]
    #[doc = " - \\ref ::cudaDeviceProp::clockRate \"clockRate\" is the clock frequency in"]
    #[doc = "   kilohertz;"]
    #[doc = " - \\ref ::cudaDeviceProp::totalConstMem \"totalConstMem\" is the total amount"]
    #[doc = "   of constant memory available on the device in bytes;"]
    #[doc = " - \\ref ::cudaDeviceProp::major \"major\","]
    #[doc = "   \\ref ::cudaDeviceProp::minor \"minor\" are the major and minor revision"]
    #[doc = "   numbers defining the device's compute capability;"]
    #[doc = " - \\ref ::cudaDeviceProp::textureAlignment \"textureAlignment\" is the"]
    #[doc = "   alignment requirement; texture base addresses that are aligned to"]
    #[doc = "   \\ref ::cudaDeviceProp::textureAlignment \"textureAlignment\" bytes do not"]
    #[doc = "   need an offset applied to texture fetches;"]
    #[doc = " - \\ref ::cudaDeviceProp::texturePitchAlignment \"texturePitchAlignment\" is the"]
    #[doc = "   pitch alignment requirement for 2D texture references that are bound to"]
    #[doc = "   pitched memory;"]
    #[doc = " - \\ref ::cudaDeviceProp::deviceOverlap \"deviceOverlap\" is 1 if the device"]
    #[doc = "   can concurrently copy memory between host and device while executing a"]
    #[doc = "   kernel, or 0 if not.  Deprecated, use instead asyncEngineCount."]
    #[doc = " - \\ref ::cudaDeviceProp::multiProcessorCount \"multiProcessorCount\" is the"]
    #[doc = "   number of multiprocessors on the device;"]
    #[doc = " - \\ref ::cudaDeviceProp::kernelExecTimeoutEnabled \"kernelExecTimeoutEnabled\""]
    #[doc = "   is 1 if there is a run time limit for kernels executed on the device, or"]
    #[doc = "   0 if not."]
    #[doc = " - \\ref ::cudaDeviceProp::integrated \"integrated\" is 1 if the device is an"]
    #[doc = "   integrated (motherboard) GPU and 0 if it is a discrete (card) component."]
    #[doc = " - \\ref ::cudaDeviceProp::canMapHostMemory \"canMapHostMemory\" is 1 if the"]
    #[doc = "   device can map host memory into the CUDA address space for use with"]
    #[doc = "   ::cudaHostAlloc()/::cudaHostGetDevicePointer(), or 0 if not;"]
    #[doc = " - \\ref ::cudaDeviceProp::computeMode \"computeMode\" is the compute mode"]
    #[doc = "   that the device is currently in. Available modes are as follows:"]
    #[doc = "   - cudaComputeModeDefault: Default mode - Device is not restricted and"]
    #[doc = "     multiple threads can use ::cudaSetDevice() with this device."]
    #[doc = "   - cudaComputeModeExclusive: Compute-exclusive mode - Only one thread will"]
    #[doc = "     be able to use ::cudaSetDevice() with this device."]
    #[doc = "   - cudaComputeModeProhibited: Compute-prohibited mode - No threads can use"]
    #[doc = "     ::cudaSetDevice() with this device."]
    #[doc = "   - cudaComputeModeExclusiveProcess: Compute-exclusive-process mode - Many"]
    #[doc = "     threads in one process will be able to use ::cudaSetDevice() with this device."]
    #[doc = "   <br> If ::cudaSetDevice() is called on an already occupied \\p device with"]
    #[doc = "   computeMode ::cudaComputeModeExclusive, ::cudaErrorDeviceAlreadyInUse"]
    #[doc = "   will be immediately returned indicating the device cannot be used."]
    #[doc = "   When an occupied exclusive mode device is chosen with ::cudaSetDevice,"]
    #[doc = "   all subsequent non-device management runtime functions will return"]
    #[doc = "   ::cudaErrorDevicesUnavailable."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTexture1D \"maxTexture1D\" is the maximum 1D"]
    #[doc = "   texture size."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTexture1DMipmap \"maxTexture1DMipmap\" is the maximum"]
    #[doc = "   1D mipmapped texture texture size."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTexture1DLinear \"maxTexture1DLinear\" is the maximum"]
    #[doc = "   1D texture size for textures bound to linear memory."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTexture2D \"maxTexture2D[2]\" contains the maximum"]
    #[doc = "   2D texture dimensions."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTexture2DMipmap \"maxTexture2DMipmap[2]\" contains the"]
    #[doc = "   maximum 2D mipmapped texture dimensions."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTexture2DLinear \"maxTexture2DLinear[3]\" contains the"]
    #[doc = "   maximum 2D texture dimensions for 2D textures bound to pitch linear memory."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTexture2DGather \"maxTexture2DGather[2]\" contains the"]
    #[doc = "   maximum 2D texture dimensions if texture gather operations have to be performed."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTexture3D \"maxTexture3D[3]\" contains the maximum"]
    #[doc = "   3D texture dimensions."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTexture3DAlt \"maxTexture3DAlt[3]\""]
    #[doc = "   contains the maximum alternate 3D texture dimensions."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTextureCubemap \"maxTextureCubemap\" is the"]
    #[doc = "   maximum cubemap texture width or height."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTexture1DLayered \"maxTexture1DLayered[2]\" contains"]
    #[doc = "   the maximum 1D layered texture dimensions."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTexture2DLayered \"maxTexture2DLayered[3]\" contains"]
    #[doc = "   the maximum 2D layered texture dimensions."]
    #[doc = " - \\ref ::cudaDeviceProp::maxTextureCubemapLayered \"maxTextureCubemapLayered[2]\""]
    #[doc = "   contains the maximum cubemap layered texture dimensions."]
    #[doc = " - \\ref ::cudaDeviceProp::maxSurface1D \"maxSurface1D\" is the maximum 1D"]
    #[doc = "   surface size."]
    #[doc = " - \\ref ::cudaDeviceProp::maxSurface2D \"maxSurface2D[2]\" contains the maximum"]
    #[doc = "   2D surface dimensions."]
    #[doc = " - \\ref ::cudaDeviceProp::maxSurface3D \"maxSurface3D[3]\" contains the maximum"]
    #[doc = "   3D surface dimensions."]
    #[doc = " - \\ref ::cudaDeviceProp::maxSurface1DLayered \"maxSurface1DLayered[2]\" contains"]
    #[doc = "   the maximum 1D layered surface dimensions."]
    #[doc = " - \\ref ::cudaDeviceProp::maxSurface2DLayered \"maxSurface2DLayered[3]\" contains"]
    #[doc = "   the maximum 2D layered surface dimensions."]
    #[doc = " - \\ref ::cudaDeviceProp::maxSurfaceCubemap \"maxSurfaceCubemap\" is the maximum"]
    #[doc = "   cubemap surface width or height."]
    #[doc = " - \\ref ::cudaDeviceProp::maxSurfaceCubemapLayered \"maxSurfaceCubemapLayered[2]\""]
    #[doc = "   contains the maximum cubemap layered surface dimensions."]
    #[doc = " - \\ref ::cudaDeviceProp::surfaceAlignment \"surfaceAlignment\" specifies the"]
    #[doc = "   alignment requirements for surfaces."]
    #[doc = " - \\ref ::cudaDeviceProp::concurrentKernels \"concurrentKernels\" is 1 if the"]
    #[doc = "   device supports executing multiple kernels within the same context"]
    #[doc = "   simultaneously, or 0 if not. It is not guaranteed that multiple kernels"]
    #[doc = "   will be resident on the device concurrently so this feature should not be"]
    #[doc = "   relied upon for correctness;"]
    #[doc = " - \\ref ::cudaDeviceProp::ECCEnabled \"ECCEnabled\" is 1 if the device has ECC"]
    #[doc = "   support turned on, or 0 if not."]
    #[doc = " - \\ref ::cudaDeviceProp::pciBusID \"pciBusID\" is the PCI bus identifier of"]
    #[doc = "   the device."]
    #[doc = " - \\ref ::cudaDeviceProp::pciDeviceID \"pciDeviceID\" is the PCI device"]
    #[doc = "   (sometimes called slot) identifier of the device."]
    #[doc = " - \\ref ::cudaDeviceProp::pciDomainID \"pciDomainID\" is the PCI domain identifier"]
    #[doc = "   of the device."]
    #[doc = " - \\ref ::cudaDeviceProp::tccDriver \"tccDriver\" is 1 if the device is using a"]
    #[doc = "   TCC driver or 0 if not."]
    #[doc = " - \\ref ::cudaDeviceProp::asyncEngineCount \"asyncEngineCount\" is 1 when the"]
    #[doc = "   device can concurrently copy memory between host and device while executing"]
    #[doc = "   a kernel. It is 2 when the device can concurrently copy memory between host"]
    #[doc = "   and device in both directions and execute a kernel at the same time. It is"]
    #[doc = "   0 if neither of these is supported."]
    #[doc = " - \\ref ::cudaDeviceProp::unifiedAddressing \"unifiedAddressing\" is 1 if the device"]
    #[doc = "   shares a unified address space with the host and 0 otherwise."]
    #[doc = " - \\ref ::cudaDeviceProp::memoryClockRate \"memoryClockRate\" is the peak memory"]
    #[doc = "   clock frequency in kilohertz."]
    #[doc = " - \\ref ::cudaDeviceProp::memoryBusWidth \"memoryBusWidth\" is the memory bus width"]
    #[doc = "   in bits."]
    #[doc = " - \\ref ::cudaDeviceProp::l2CacheSize \"l2CacheSize\" is L2 cache size in bytes."]
    #[doc = " - \\ref ::cudaDeviceProp::persistingL2CacheMaxSize \"persistingL2CacheMaxSize\" is L2 cache's maximum persisting lines size in bytes."]
    #[doc = " - \\ref ::cudaDeviceProp::maxThreadsPerMultiProcessor \"maxThreadsPerMultiProcessor\""]
    #[doc = "   is the number of maximum resident threads per multiprocessor."]
    #[doc = " - \\ref ::cudaDeviceProp::streamPrioritiesSupported \"streamPrioritiesSupported\""]
    #[doc = "   is 1 if the device supports stream priorities, or 0 if it is not supported."]
    #[doc = " - \\ref ::cudaDeviceProp::globalL1CacheSupported \"globalL1CacheSupported\""]
    #[doc = "   is 1 if the device supports caching of globals in L1 cache, or 0 if it is not supported."]
    #[doc = " - \\ref ::cudaDeviceProp::localL1CacheSupported \"localL1CacheSupported\""]
    #[doc = "   is 1 if the device supports caching of locals in L1 cache, or 0 if it is not supported."]
    #[doc = " - \\ref ::cudaDeviceProp::sharedMemPerMultiprocessor \"sharedMemPerMultiprocessor\" is the"]
    #[doc = "   maximum amount of shared memory available to a multiprocessor in bytes; this amount is"]
    #[doc = "   shared by all thread blocks simultaneously resident on a multiprocessor;"]
    #[doc = " - \\ref ::cudaDeviceProp::regsPerMultiprocessor \"regsPerMultiprocessor\" is the maximum number"]
    #[doc = "   of 32-bit registers available to a multiprocessor; this number is shared"]
    #[doc = "   by all thread blocks simultaneously resident on a multiprocessor;"]
    #[doc = " - \\ref ::cudaDeviceProp::managedMemory \"managedMemory\""]
    #[doc = "   is 1 if the device supports allocating managed memory on this system, or 0 if it is not supported."]
    #[doc = " - \\ref ::cudaDeviceProp::isMultiGpuBoard \"isMultiGpuBoard\""]
    #[doc = "   is 1 if the device is on a multi-GPU board (e.g. Gemini cards), and 0 if not;"]
    #[doc = " - \\ref ::cudaDeviceProp::multiGpuBoardGroupID \"multiGpuBoardGroupID\" is a unique identifier"]
    #[doc = "   for a group of devices associated with the same board."]
    #[doc = "   Devices on the same multi-GPU board will share the same identifier;"]
    #[doc = " - \\ref ::cudaDeviceProp::singleToDoublePrecisionPerfRatio \"singleToDoublePrecisionPerfRatio\""]
    #[doc = "   is the ratio of single precision performance (in floating-point operations per second)"]
    #[doc = "   to double precision performance."]
    #[doc = " - \\ref ::cudaDeviceProp::pageableMemoryAccess \"pageableMemoryAccess\" is 1 if the device supports"]
    #[doc = "   coherently accessing pageable memory without calling cudaHostRegister on it, and 0 otherwise."]
    #[doc = " - \\ref ::cudaDeviceProp::concurrentManagedAccess \"concurrentManagedAccess\" is 1 if the device can"]
    #[doc = "   coherently access managed memory concurrently with the CPU, and 0 otherwise."]
    #[doc = " - \\ref ::cudaDeviceProp::computePreemptionSupported \"computePreemptionSupported\" is 1 if the device"]
    #[doc = "   supports Compute Preemption, and 0 otherwise."]
    #[doc = " - \\ref ::cudaDeviceProp::canUseHostPointerForRegisteredMem \"canUseHostPointerForRegisteredMem\" is 1 if"]
    #[doc = "   the device can access host registered memory at the same virtual address as the CPU, and 0 otherwise."]
    #[doc = " - \\ref ::cudaDeviceProp::cooperativeLaunch \"cooperativeLaunch\" is 1 if the device supports launching"]
    #[doc = "   cooperative kernels via ::cudaLaunchCooperativeKernel, and 0 otherwise."]
    #[doc = " - \\ref ::cudaDeviceProp::cooperativeMultiDeviceLaunch \"cooperativeMultiDeviceLaunch\" is 1 if the device"]
    #[doc = "   supports launching cooperative kernels via ::cudaLaunchCooperativeKernelMultiDevice, and 0 otherwise."]
    #[doc = " - \\ref ::cudaDeviceProp::pageableMemoryAccessUsesHostPageTables \"pageableMemoryAccessUsesHostPageTables\" is 1 if the device accesses"]
    #[doc = "   pageable memory via the host's page tables, and 0 otherwise."]
    #[doc = " - \\ref ::cudaDeviceProp::directManagedMemAccessFromHost \"directManagedMemAccessFromHost\" is 1 if the host can directly access managed"]
    #[doc = "   memory on the device without migration, and 0 otherwise."]
    #[doc = " - \\ref ::cudaDeviceProp::maxBlocksPerMultiProcessor \"maxBlocksPerMultiProcessor\" is the maximum number of thread blocks"]
    #[doc = "   that can reside on a multiprocessor."]
    #[doc = " - \\ref ::cudaDeviceProp::accessPolicyMaxWindowSize \"accessPolicyMaxWindowSize\" is"]
    #[doc = "   the maximum value of ::cudaAccessPolicyWindow::num_bytes."]
    #[doc = ""]
    #[doc = " \\param prop   - Properties for the specified device"]
    #[doc = " \\param device - Device number to get properties for"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetDeviceCount, ::cudaGetDevice, ::cudaSetDevice, ::cudaChooseDevice,"]
    #[doc = " ::cudaDeviceGetAttribute,"]
    #[doc = " ::cuDeviceGetAttribute,"]
    #[doc = " ::cuDeviceGetName"]
    pub fn cudaGetDeviceProperties(prop: *mut cudaDeviceProp, device: ::libc::c_int)
        -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns information about the device"]
    #[doc = ""]
    #[doc = " Returns in \\p *value the integer value of the attribute \\p attr on device"]
    #[doc = " \\p device. The supported attributes are:"]
    #[doc = " - ::cudaDevAttrMaxThreadsPerBlock: Maximum number of threads per block;"]
    #[doc = " - ::cudaDevAttrMaxBlockDimX: Maximum x-dimension of a block;"]
    #[doc = " - ::cudaDevAttrMaxBlockDimY: Maximum y-dimension of a block;"]
    #[doc = " - ::cudaDevAttrMaxBlockDimZ: Maximum z-dimension of a block;"]
    #[doc = " - ::cudaDevAttrMaxGridDimX: Maximum x-dimension of a grid;"]
    #[doc = " - ::cudaDevAttrMaxGridDimY: Maximum y-dimension of a grid;"]
    #[doc = " - ::cudaDevAttrMaxGridDimZ: Maximum z-dimension of a grid;"]
    #[doc = " - ::cudaDevAttrMaxSharedMemoryPerBlock: Maximum amount of shared memory"]
    #[doc = "   available to a thread block in bytes;"]
    #[doc = " - ::cudaDevAttrTotalConstantMemory: Memory available on device for"]
    #[doc = "   __constant__ variables in a CUDA C kernel in bytes;"]
    #[doc = " - ::cudaDevAttrWarpSize: Warp size in threads;"]
    #[doc = " - ::cudaDevAttrMaxPitch: Maximum pitch in bytes allowed by the memory copy"]
    #[doc = "   functions that involve memory regions allocated through ::cudaMallocPitch();"]
    #[doc = " - ::cudaDevAttrMaxTexture1DWidth: Maximum 1D texture width;"]
    #[doc = " - ::cudaDevAttrMaxTexture1DLinearWidth: Maximum width for a 1D texture bound"]
    #[doc = "   to linear memory;"]
    #[doc = " - ::cudaDevAttrMaxTexture1DMipmappedWidth: Maximum mipmapped 1D texture width;"]
    #[doc = " - ::cudaDevAttrMaxTexture2DWidth: Maximum 2D texture width;"]
    #[doc = " - ::cudaDevAttrMaxTexture2DHeight: Maximum 2D texture height;"]
    #[doc = " - ::cudaDevAttrMaxTexture2DLinearWidth: Maximum width for a 2D texture"]
    #[doc = "   bound to linear memory;"]
    #[doc = " - ::cudaDevAttrMaxTexture2DLinearHeight: Maximum height for a 2D texture"]
    #[doc = "   bound to linear memory;"]
    #[doc = " - ::cudaDevAttrMaxTexture2DLinearPitch: Maximum pitch in bytes for a 2D"]
    #[doc = "   texture bound to linear memory;"]
    #[doc = " - ::cudaDevAttrMaxTexture2DMipmappedWidth: Maximum mipmapped 2D texture"]
    #[doc = "   width;"]
    #[doc = " - ::cudaDevAttrMaxTexture2DMipmappedHeight: Maximum mipmapped 2D texture"]
    #[doc = "   height;"]
    #[doc = " - ::cudaDevAttrMaxTexture3DWidth: Maximum 3D texture width;"]
    #[doc = " - ::cudaDevAttrMaxTexture3DHeight: Maximum 3D texture height;"]
    #[doc = " - ::cudaDevAttrMaxTexture3DDepth: Maximum 3D texture depth;"]
    #[doc = " - ::cudaDevAttrMaxTexture3DWidthAlt: Alternate maximum 3D texture width,"]
    #[doc = "   0 if no alternate maximum 3D texture size is supported;"]
    #[doc = " - ::cudaDevAttrMaxTexture3DHeightAlt: Alternate maximum 3D texture height,"]
    #[doc = "   0 if no alternate maximum 3D texture size is supported;"]
    #[doc = " - ::cudaDevAttrMaxTexture3DDepthAlt: Alternate maximum 3D texture depth,"]
    #[doc = "   0 if no alternate maximum 3D texture size is supported;"]
    #[doc = " - ::cudaDevAttrMaxTextureCubemapWidth: Maximum cubemap texture width or"]
    #[doc = "   height;"]
    #[doc = " - ::cudaDevAttrMaxTexture1DLayeredWidth: Maximum 1D layered texture width;"]
    #[doc = " - ::cudaDevAttrMaxTexture1DLayeredLayers: Maximum layers in a 1D layered"]
    #[doc = "   texture;"]
    #[doc = " - ::cudaDevAttrMaxTexture2DLayeredWidth: Maximum 2D layered texture width;"]
    #[doc = " - ::cudaDevAttrMaxTexture2DLayeredHeight: Maximum 2D layered texture height;"]
    #[doc = " - ::cudaDevAttrMaxTexture2DLayeredLayers: Maximum layers in a 2D layered"]
    #[doc = "   texture;"]
    #[doc = " - ::cudaDevAttrMaxTextureCubemapLayeredWidth: Maximum cubemap layered"]
    #[doc = "   texture width or height;"]
    #[doc = " - ::cudaDevAttrMaxTextureCubemapLayeredLayers: Maximum layers in a cubemap"]
    #[doc = "   layered texture;"]
    #[doc = " - ::cudaDevAttrMaxSurface1DWidth: Maximum 1D surface width;"]
    #[doc = " - ::cudaDevAttrMaxSurface2DWidth: Maximum 2D surface width;"]
    #[doc = " - ::cudaDevAttrMaxSurface2DHeight: Maximum 2D surface height;"]
    #[doc = " - ::cudaDevAttrMaxSurface3DWidth: Maximum 3D surface width;"]
    #[doc = " - ::cudaDevAttrMaxSurface3DHeight: Maximum 3D surface height;"]
    #[doc = " - ::cudaDevAttrMaxSurface3DDepth: Maximum 3D surface depth;"]
    #[doc = " - ::cudaDevAttrMaxSurface1DLayeredWidth: Maximum 1D layered surface width;"]
    #[doc = " - ::cudaDevAttrMaxSurface1DLayeredLayers: Maximum layers in a 1D layered"]
    #[doc = "   surface;"]
    #[doc = " - ::cudaDevAttrMaxSurface2DLayeredWidth: Maximum 2D layered surface width;"]
    #[doc = " - ::cudaDevAttrMaxSurface2DLayeredHeight: Maximum 2D layered surface height;"]
    #[doc = " - ::cudaDevAttrMaxSurface2DLayeredLayers: Maximum layers in a 2D layered"]
    #[doc = "   surface;"]
    #[doc = " - ::cudaDevAttrMaxSurfaceCubemapWidth: Maximum cubemap surface width;"]
    #[doc = " - ::cudaDevAttrMaxSurfaceCubemapLayeredWidth: Maximum cubemap layered"]
    #[doc = "   surface width;"]
    #[doc = " - ::cudaDevAttrMaxSurfaceCubemapLayeredLayers: Maximum layers in a cubemap"]
    #[doc = "   layered surface;"]
    #[doc = " - ::cudaDevAttrMaxRegistersPerBlock: Maximum number of 32-bit registers"]
    #[doc = "   available to a thread block;"]
    #[doc = " - ::cudaDevAttrClockRate: Peak clock frequency in kilohertz;"]
    #[doc = " - ::cudaDevAttrTextureAlignment: Alignment requirement; texture base"]
    #[doc = "   addresses aligned to ::textureAlign bytes do not need an offset applied"]
    #[doc = "   to texture fetches;"]
    #[doc = " - ::cudaDevAttrTexturePitchAlignment: Pitch alignment requirement for 2D"]
    #[doc = "   texture references bound to pitched memory;"]
    #[doc = " - ::cudaDevAttrGpuOverlap: 1 if the device can concurrently copy memory"]
    #[doc = "   between host and device while executing a kernel, or 0 if not;"]
    #[doc = " - ::cudaDevAttrMultiProcessorCount: Number of multiprocessors on the device;"]
    #[doc = " - ::cudaDevAttrKernelExecTimeout: 1 if there is a run time limit for kernels"]
    #[doc = "   executed on the device, or 0 if not;"]
    #[doc = " - ::cudaDevAttrIntegrated: 1 if the device is integrated with the memory"]
    #[doc = "   subsystem, or 0 if not;"]
    #[doc = " - ::cudaDevAttrCanMapHostMemory: 1 if the device can map host memory into"]
    #[doc = "   the CUDA address space, or 0 if not;"]
    #[doc = " - ::cudaDevAttrComputeMode: Compute mode is the compute mode that the device"]
    #[doc = "   is currently in. Available modes are as follows:"]
    #[doc = "   - ::cudaComputeModeDefault: Default mode - Device is not restricted and"]
    #[doc = "     multiple threads can use ::cudaSetDevice() with this device."]
    #[doc = "   - ::cudaComputeModeExclusive: Compute-exclusive mode - Only one thread will"]
    #[doc = "     be able to use ::cudaSetDevice() with this device."]
    #[doc = "   - ::cudaComputeModeProhibited: Compute-prohibited mode - No threads can use"]
    #[doc = "     ::cudaSetDevice() with this device."]
    #[doc = "   - ::cudaComputeModeExclusiveProcess: Compute-exclusive-process mode - Many"]
    #[doc = "     threads in one process will be able to use ::cudaSetDevice() with this"]
    #[doc = "     device."]
    #[doc = " - ::cudaDevAttrConcurrentKernels: 1 if the device supports executing"]
    #[doc = "   multiple kernels within the same context simultaneously, or 0 if"]
    #[doc = "   not. It is not guaranteed that multiple kernels will be resident on the"]
    #[doc = "   device concurrently so this feature should not be relied upon for"]
    #[doc = "   correctness;"]
    #[doc = " - ::cudaDevAttrEccEnabled: 1 if error correction is enabled on the device,"]
    #[doc = "   0 if error correction is disabled or not supported by the device;"]
    #[doc = " - ::cudaDevAttrPciBusId: PCI bus identifier of the device;"]
    #[doc = " - ::cudaDevAttrPciDeviceId: PCI device (also known as slot) identifier of"]
    #[doc = "   the device;"]
    #[doc = " - ::cudaDevAttrTccDriver: 1 if the device is using a TCC driver. TCC is only"]
    #[doc = "   available on Tesla hardware running Windows Vista or later;"]
    #[doc = " - ::cudaDevAttrMemoryClockRate: Peak memory clock frequency in kilohertz;"]
    #[doc = " - ::cudaDevAttrGlobalMemoryBusWidth: Global memory bus width in bits;"]
    #[doc = " - ::cudaDevAttrL2CacheSize: Size of L2 cache in bytes. 0 if the device"]
    #[doc = "   doesn't have L2 cache;"]
    #[doc = " - ::cudaDevAttrMaxThreadsPerMultiProcessor: Maximum resident threads per"]
    #[doc = "   multiprocessor;"]
    #[doc = " - ::cudaDevAttrUnifiedAddressing: 1 if the device shares a unified address"]
    #[doc = "   space with the host, or 0 if not;"]
    #[doc = " - ::cudaDevAttrComputeCapabilityMajor: Major compute capability version"]
    #[doc = "   number;"]
    #[doc = " - ::cudaDevAttrComputeCapabilityMinor: Minor compute capability version"]
    #[doc = "   number;"]
    #[doc = " - ::cudaDevAttrStreamPrioritiesSupported: 1 if the device supports stream"]
    #[doc = "   priorities, or 0 if not;"]
    #[doc = " - ::cudaDevAttrGlobalL1CacheSupported: 1 if device supports caching globals"]
    #[doc = "    in L1 cache, 0 if not;"]
    #[doc = " - ::cudaDevAttrLocalL1CacheSupported: 1 if device supports caching locals"]
    #[doc = "    in L1 cache, 0 if not;"]
    #[doc = " - ::cudaDevAttrMaxSharedMemoryPerMultiprocessor: Maximum amount of shared memory"]
    #[doc = "   available to a multiprocessor in bytes; this amount is shared by all"]
    #[doc = "   thread blocks simultaneously resident on a multiprocessor;"]
    #[doc = " - ::cudaDevAttrMaxRegistersPerMultiprocessor: Maximum number of 32-bit registers"]
    #[doc = "   available to a multiprocessor; this number is shared by all thread blocks"]
    #[doc = "   simultaneously resident on a multiprocessor;"]
    #[doc = " - ::cudaDevAttrManagedMemory: 1 if device supports allocating"]
    #[doc = "   managed memory, 0 if not;"]
    #[doc = " - ::cudaDevAttrIsMultiGpuBoard: 1 if device is on a multi-GPU board, 0 if not;"]
    #[doc = " - ::cudaDevAttrMultiGpuBoardGroupID: Unique identifier for a group of devices on the"]
    #[doc = "   same multi-GPU board;"]
    #[doc = " - ::cudaDevAttrHostNativeAtomicSupported: 1 if the link between the device and the"]
    #[doc = "   host supports native atomic operations;"]
    #[doc = " - ::cudaDevAttrSingleToDoublePrecisionPerfRatio: Ratio of single precision performance"]
    #[doc = "   (in floating-point operations per second) to double precision performance;"]
    #[doc = " - ::cudaDevAttrPageableMemoryAccess: 1 if the device supports coherently accessing"]
    #[doc = "   pageable memory without calling cudaHostRegister on it, and 0 otherwise."]
    #[doc = " - ::cudaDevAttrConcurrentManagedAccess: 1 if the device can coherently access managed"]
    #[doc = "   memory concurrently with the CPU, and 0 otherwise."]
    #[doc = " - ::cudaDevAttrComputePreemptionSupported: 1 if the device supports"]
    #[doc = "   Compute Preemption, 0 if not."]
    #[doc = " - ::cudaDevAttrCanUseHostPointerForRegisteredMem: 1 if the device can access host"]
    #[doc = "   registered memory at the same virtual address as the CPU, and 0 otherwise."]
    #[doc = " - ::cudaDevAttrCooperativeLaunch: 1 if the device supports launching cooperative kernels"]
    #[doc = "   via ::cudaLaunchCooperativeKernel, and 0 otherwise."]
    #[doc = " - ::cudaDevAttrCooperativeMultiDeviceLaunch: 1 if the device supports launching cooperative"]
    #[doc = "   kernels via ::cudaLaunchCooperativeKernelMultiDevice, and 0 otherwise."]
    #[doc = " - ::cudaDevAttrCanFlushRemoteWrites: 1 if the device supports flushing of outstanding"]
    #[doc = "   remote writes, and 0 otherwise."]
    #[doc = " - ::cudaDevAttrHostRegisterSupported: 1 if the device supports host memory registration"]
    #[doc = "   via ::cudaHostRegister, and 0 otherwise."]
    #[doc = " - ::cudaDevAttrPageableMemoryAccessUsesHostPageTables: 1 if the device accesses pageable memory via the"]
    #[doc = "   host's page tables, and 0 otherwise."]
    #[doc = " - ::cudaDevAttrDirectManagedMemAccessFromHost: 1 if the host can directly access managed memory on the device"]
    #[doc = "   without migration, and 0 otherwise."]
    #[doc = " - ::cudaDevAttrMaxSharedMemoryPerBlockOptin: Maximum per block shared memory size on the device. This value can"]
    #[doc = "   be opted into when using ::cudaFuncSetAttribute"]
    #[doc = " - ::cudaDevAttrMaxBlocksPerMultiprocessor: Maximum number of thread blocks that can reside on a multiprocessor."]
    #[doc = " - ::cudaDevAttrMaxPersistingL2CacheSize: Maximum L2 persisting lines capacity setting in bytes."]
    #[doc = " - ::cudaDevAttrMaxAccessPolicyWindowSize: Maximum value of cudaAccessPolicyWindow::num_bytes."]
    #[doc = " - ::cudaDevAttrHostRegisterReadOnly: Device supports using the ::cudaHostRegister flag cudaHostRegisterReadOnly"]
    #[doc = "   to register memory that must be mapped as read-only to the GPU"]
    #[doc = " - ::cudaDevAttrSparseCudaArraySupported: 1 if the device supports sparse CUDA arrays and sparse CUDA mipmapped arrays."]
    #[doc = ""]
    #[doc = " \\param value  - Returned device attribute value"]
    #[doc = " \\param attr   - Device attribute to query"]
    #[doc = " \\param device - Device number to query"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDevice,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetDeviceCount, ::cudaGetDevice, ::cudaSetDevice, ::cudaChooseDevice,"]
    #[doc = " ::cudaGetDeviceProperties,"]
    #[doc = " ::cuDeviceGetAttribute"]
    pub fn cudaDeviceGetAttribute(
        value: *mut ::libc::c_int,
        attr: cudaDeviceAttr,
        device: ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns the default mempool of a device"]
    #[doc = ""]
    #[doc = " The default mempool of a device contains device memory from that device."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDevice,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " ::cudaErrorNotSupported"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cuDeviceGetDefaultMemPool, ::cudaMallocAsync, ::cudaMemPoolTrimTo, ::cudaMemPoolGetAttribute, ::cudaDeviceSetMemPool, ::cudaMemPoolSetAttribute, ::cudaMemPoolSetAccess"]
    pub fn cudaDeviceGetDefaultMemPool(
        memPool: *mut cudaMemPool_t,
        device: ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets the current memory pool of a device"]
    #[doc = ""]
    #[doc = " The memory pool must be local to the specified device."]
    #[doc = " Unless a mempool is specified in the ::cudaMallocAsync call,"]
    #[doc = " ::cudaMallocAsync allocates from the current mempool of the provided stream's device."]
    #[doc = " By default, a device's current memory pool is its default memory pool."]
    #[doc = ""]
    #[doc = " \\note Use ::cudaMallocFromPoolAsync to specify asynchronous allocations from a device different"]
    #[doc = " than the one the stream runs on."]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " ::cudaErrorNotSupported"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cuDeviceSetDefaultMemPool, ::cudaDeviceGetMemPool, ::cudaDeviceGetDefaultMemPool, ::cudaMemPoolCreate, ::cudaMemPoolDestroy, ::cudaMallocFromPoolAsync"]
    pub fn cudaDeviceSetMemPool(device: ::libc::c_int, memPool: cudaMemPool_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Gets the current mempool for a device"]
    #[doc = ""]
    #[doc = " Returns the last pool provided to ::cudaDeviceSetMemPool for this device"]
    #[doc = " or the device's default memory pool if ::cudaDeviceSetMemPool has never been called."]
    #[doc = " By default the current mempool is the default mempool for a device,"]
    #[doc = " otherwise the returned pool must have been set with ::cuDeviceSetMemPool or ::cudaDeviceSetMemPool."]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " ::cudaErrorNotSupported"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cuDeviceGetMemPool, ::cudaDeviceGetDefaultMemPool, ::cudaDeviceSetMemPool"]
    pub fn cudaDeviceGetMemPool(memPool: *mut cudaMemPool_t, device: ::libc::c_int) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Return NvSciSync attributes that this device can support."]
    #[doc = ""]
    #[doc = " Returns in \\p nvSciSyncAttrList, the properties of NvSciSync that"]
    #[doc = " this CUDA device, \\p dev can support. The returned \\p nvSciSyncAttrList"]
    #[doc = " can be used to create an NvSciSync that matches this device's capabilities."]
    #[doc = ""]
    #[doc = " If NvSciSyncAttrKey_RequiredPerm field in \\p nvSciSyncAttrList is"]
    #[doc = " already set this API will return ::cudaErrorInvalidValue."]
    #[doc = ""]
    #[doc = " The applications should set \\p nvSciSyncAttrList to a valid"]
    #[doc = " NvSciSyncAttrList failing which this API will return"]
    #[doc = " ::cudaErrorInvalidHandle."]
    #[doc = ""]
    #[doc = " The \\p flags controls how applications intends to use"]
    #[doc = " the NvSciSync created from the \\p nvSciSyncAttrList. The valid flags are:"]
    #[doc = " - ::cudaNvSciSyncAttrSignal, specifies that the applications intends to"]
    #[doc = " signal an NvSciSync on this CUDA device."]
    #[doc = " - ::cudaNvSciSyncAttrWait, specifies that the applications intends to"]
    #[doc = " wait on an NvSciSync on this CUDA device."]
    #[doc = ""]
    #[doc = " At least one of these flags must be set, failing which the API"]
    #[doc = " returns ::cudaErrorInvalidValue. Both the flags are orthogonal"]
    #[doc = " to one another: a developer may set both these flags that allows to"]
    #[doc = " set both wait and signal specific attributes in the same \\p nvSciSyncAttrList."]
    #[doc = ""]
    #[doc = " \\param nvSciSyncAttrList     - Return NvSciSync attributes supported."]
    #[doc = " \\param device                - Valid Cuda Device to get NvSciSync attributes for."]
    #[doc = " \\param flags                 - flags describing NvSciSync usage."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = ""]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorDeviceUninitialized,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidHandle,"]
    #[doc = " ::cudaErrorInvalidDevice,"]
    #[doc = " ::cudaErrorNotSupported,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaImportExternalSemaphore,"]
    #[doc = " ::cudaDestroyExternalSemaphore,"]
    #[doc = " ::cudaSignalExternalSemaphoresAsync,"]
    #[doc = " ::cudaWaitExternalSemaphoresAsync"]
    pub fn cudaDeviceGetNvSciSyncAttributes(
        nvSciSyncAttrList: *mut ::libc::c_void,
        device: ::libc::c_int,
        flags: ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Queries attributes of the link between two devices."]
    #[doc = ""]
    #[doc = " Returns in \\p *value the value of the requested attribute \\p attrib of the"]
    #[doc = " link between \\p srcDevice and \\p dstDevice. The supported attributes are:"]
    #[doc = " - ::cudaDevP2PAttrPerformanceRank: A relative value indicating the"]
    #[doc = "   performance of the link between two devices. Lower value means better"]
    #[doc = "   performance (0 being the value used for most performant link)."]
    #[doc = " - ::cudaDevP2PAttrAccessSupported: 1 if peer access is enabled."]
    #[doc = " - ::cudaDevP2PAttrNativeAtomicSupported: 1 if native atomic operations over"]
    #[doc = "   the link are supported."]
    #[doc = " - ::cudaDevP2PAttrCudaArrayAccessSupported: 1 if accessing CUDA arrays over"]
    #[doc = "   the link is supported."]
    #[doc = ""]
    #[doc = " Returns ::cudaErrorInvalidDevice if \\p srcDevice or \\p dstDevice are not valid"]
    #[doc = " or if they represent the same device."]
    #[doc = ""]
    #[doc = " Returns ::cudaErrorInvalidValue if \\p attrib is not valid or if \\p value is"]
    #[doc = " a null pointer."]
    #[doc = ""]
    #[doc = " \\param value         - Returned value of the requested attribute"]
    #[doc = " \\param attrib        - The requested attribute of the link between \\p srcDevice and \\p dstDevice."]
    #[doc = " \\param srcDevice     - The source device of the target link."]
    #[doc = " \\param dstDevice     - The destination device of the target link."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDevice,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaCtxEnablePeerAccess,"]
    #[doc = " ::cudaCtxDisablePeerAccess,"]
    #[doc = " ::cudaCtxCanAccessPeer,"]
    #[doc = " ::cuDeviceGetP2PAttribute"]
    pub fn cudaDeviceGetP2PAttribute(
        value: *mut ::libc::c_int,
        attr: cudaDeviceP2PAttr,
        srcDevice: ::libc::c_int,
        dstDevice: ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Select compute-device which best matches criteria"]
    #[doc = ""]
    #[doc = " Returns in \\p *device the device which has properties that best match"]
    #[doc = " \\p *prop."]
    #[doc = ""]
    #[doc = " \\param device - Device with best match"]
    #[doc = " \\param prop   - Desired device properties"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetDeviceCount, ::cudaGetDevice, ::cudaSetDevice,"]
    #[doc = " ::cudaGetDeviceProperties"]
    pub fn cudaChooseDevice(device: *mut ::libc::c_int, prop: *const cudaDeviceProp)
        -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Set device to be used for GPU executions"]
    #[doc = ""]
    #[doc = " Sets \\p device as the current device for the calling host thread."]
    #[doc = " Valid device id's are 0 to (::cudaGetDeviceCount() - 1)."]
    #[doc = ""]
    #[doc = " Any device memory subsequently allocated from this host thread"]
    #[doc = " using ::cudaMalloc(), ::cudaMallocPitch() or ::cudaMallocArray()"]
    #[doc = " will be physically resident on \\p device.  Any host memory allocated"]
    #[doc = " from this host thread using ::cudaMallocHost() or ::cudaHostAlloc()"]
    #[doc = " or ::cudaHostRegister() will have its lifetime associated  with"]
    #[doc = " \\p device.  Any streams or events created from this host thread will"]
    #[doc = " be associated with \\p device.  Any kernels launched from this host"]
    #[doc = " thread using the <<<>>> operator or ::cudaLaunchKernel() will be executed"]
    #[doc = " on \\p device."]
    #[doc = ""]
    #[doc = " This call may be made from any host thread, to any device, and at"]
    #[doc = " any time.  This function will do no synchronization with the previous"]
    #[doc = " or new device, and should be considered a very low overhead call."]
    #[doc = ""]
    #[doc = " \\param device - Device on which the active host thread should execute the"]
    #[doc = " device code."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDevice,"]
    #[doc = " ::cudaErrorDeviceAlreadyInUse"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetDeviceCount, ::cudaGetDevice, ::cudaGetDeviceProperties,"]
    #[doc = " ::cudaChooseDevice,"]
    #[doc = " ::cuCtxSetCurrent"]
    pub fn cudaSetDevice(device: ::libc::c_int) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns which device is currently being used"]
    #[doc = ""]
    #[doc = " Returns in \\p *device the current device for the calling host thread."]
    #[doc = ""]
    #[doc = " \\param device - Returns the device on which the active host thread"]
    #[doc = " executes the device code."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetDeviceCount, ::cudaSetDevice, ::cudaGetDeviceProperties,"]
    #[doc = " ::cudaChooseDevice,"]
    #[doc = " ::cuCtxGetCurrent"]
    pub fn cudaGetDevice(device: *mut ::libc::c_int) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Set a list of devices that can be used for CUDA"]
    #[doc = ""]
    #[doc = " Sets a list of devices for CUDA execution in priority order using"]
    #[doc = " \\p device_arr. The parameter \\p len specifies the number of elements in the"]
    #[doc = " list.  CUDA will try devices from the list sequentially until it finds one"]
    #[doc = " that works.  If this function is not called, or if it is called with a \\p len"]
    #[doc = " of 0, then CUDA will go back to its default behavior of trying devices"]
    #[doc = " sequentially from a default list containing all of the available CUDA"]
    #[doc = " devices in the system. If a specified device ID in the list does not exist,"]
    #[doc = " this function will return ::cudaErrorInvalidDevice. If \\p len is not 0 and"]
    #[doc = " \\p device_arr is NULL or if \\p len exceeds the number of devices in"]
    #[doc = " the system, then ::cudaErrorInvalidValue is returned."]
    #[doc = ""]
    #[doc = " \\param device_arr - List of devices to try"]
    #[doc = " \\param len        - Number of devices in specified list"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetDeviceCount, ::cudaSetDevice, ::cudaGetDeviceProperties,"]
    #[doc = " ::cudaSetDeviceFlags,"]
    #[doc = " ::cudaChooseDevice"]
    pub fn cudaSetValidDevices(device_arr: *mut ::libc::c_int, len: ::libc::c_int) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets flags to be used for device executions"]
    #[doc = ""]
    #[doc = " Records \\p flags as the flags for the current device. If the current device"]
    #[doc = " has been set and that device has already been initialized, the previous flags"]
    #[doc = " are overwritten. If the current device has not been initialized, it is"]
    #[doc = " initialized with the provided flags. If no device has been made current to"]
    #[doc = " the calling thread, a default device is selected and initialized with the"]
    #[doc = " provided flags."]
    #[doc = ""]
    #[doc = " The two LSBs of the \\p flags parameter can be used to control how the CPU"]
    #[doc = " thread interacts with the OS scheduler when waiting for results from the"]
    #[doc = " device."]
    #[doc = ""]
    #[doc = " - ::cudaDeviceScheduleAuto: The default value if the \\p flags parameter is"]
    #[doc = " zero, uses a heuristic based on the number of active CUDA contexts in the"]
    #[doc = " process \\p C and the number of logical processors in the system \\p P. If"]
    #[doc = " \\p C \\> \\p P, then CUDA will yield to other OS threads when waiting for the"]
    #[doc = " device, otherwise CUDA will not yield while waiting for results and"]
    #[doc = " actively spin on the processor. Additionally, on Tegra devices,"]
    #[doc = " ::cudaDeviceScheduleAuto uses a heuristic based on the power profile of"]
    #[doc = " the platform and may choose ::cudaDeviceScheduleBlockingSync for low-powered"]
    #[doc = " devices."]
    #[doc = " - ::cudaDeviceScheduleSpin: Instruct CUDA to actively spin when waiting for"]
    #[doc = " results from the device. This can decrease latency when waiting for the"]
    #[doc = " device, but may lower the performance of CPU threads if they are performing"]
    #[doc = " work in parallel with the CUDA thread."]
    #[doc = " - ::cudaDeviceScheduleYield: Instruct CUDA to yield its thread when waiting"]
    #[doc = " for results from the device. This can increase latency when waiting for the"]
    #[doc = " device, but can increase the performance of CPU threads performing work in"]
    #[doc = " parallel with the device."]
    #[doc = " - ::cudaDeviceScheduleBlockingSync: Instruct CUDA to block the CPU thread"]
    #[doc = " on a synchronization primitive when waiting for the device to finish work."]
    #[doc = " - ::cudaDeviceBlockingSync: Instruct CUDA to block the CPU thread on a"]
    #[doc = " synchronization primitive when waiting for the device to finish work. <br>"]
    #[doc = " \\ref deprecated \"Deprecated:\" This flag was deprecated as of CUDA 4.0 and"]
    #[doc = " replaced with ::cudaDeviceScheduleBlockingSync."]
    #[doc = " - ::cudaDeviceMapHost: This flag enables allocating pinned"]
    #[doc = " host memory that is accessible to the device. It is implicit for the"]
    #[doc = " runtime but may be absent if a context is created using the driver API."]
    #[doc = " If this flag is not set, ::cudaHostGetDevicePointer() will always return"]
    #[doc = " a failure code."]
    #[doc = " - ::cudaDeviceLmemResizeToMax: Instruct CUDA to not reduce local memory"]
    #[doc = " after resizing local memory for a kernel. This can prevent thrashing by"]
    #[doc = " local memory allocations when launching many kernels with high local"]
    #[doc = " memory usage at the cost of potentially increased memory usage. <br>"]
    #[doc = " \\ref deprecated \"Deprecated:\" This flag is deprecated and the behavior enabled"]
    #[doc = " by this flag is now the default and cannot be disabled."]
    #[doc = ""]
    #[doc = " \\param flags - Parameters for device operation"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetDeviceFlags, ::cudaGetDeviceCount, ::cudaGetDevice, ::cudaGetDeviceProperties,"]
    #[doc = " ::cudaSetDevice, ::cudaSetValidDevices,"]
    #[doc = " ::cudaChooseDevice,"]
    #[doc = " ::cuDevicePrimaryCtxSetFlags"]
    pub fn cudaSetDeviceFlags(flags: ::libc::c_uint) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Gets the flags for the current device"]
    #[doc = ""]
    #[doc = ""]
    #[doc = " Returns in \\p flags the flags for the current device. If there is a current"]
    #[doc = " device for the calling thread, the flags for the device are returned. If"]
    #[doc = " there is no current device, the flags for the first device are returned,"]
    #[doc = " which may be the default flags.  Compare to the behavior of"]
    #[doc = " ::cudaSetDeviceFlags."]
    #[doc = ""]
    #[doc = " Typically, the flags returned should match the behavior that will be seen"]
    #[doc = " if the calling thread uses a device after this call, without any change to"]
    #[doc = " the flags or current device inbetween by this or another thread.  Note that"]
    #[doc = " if the device is not initialized, it is possible for another thread to"]
    #[doc = " change the flags for the current device before it is initialized."]
    #[doc = " Additionally, when using exclusive mode, if this thread has not requested a"]
    #[doc = " specific device, it may use a device other than the first device, contrary"]
    #[doc = " to the assumption made by this function."]
    #[doc = ""]
    #[doc = " If a context has been created via the driver API and is current to the"]
    #[doc = " calling thread, the flags for that context are always returned."]
    #[doc = ""]
    #[doc = " Flags returned by this function may specifically include ::cudaDeviceMapHost"]
    #[doc = " even though it is not accepted by ::cudaSetDeviceFlags because it is"]
    #[doc = " implicit in runtime API flags.  The reason for this is that the current"]
    #[doc = " context may have been created via the driver API in which case the flag is"]
    #[doc = " not implicit and may be unset."]
    #[doc = ""]
    #[doc = " \\param flags - Pointer to store the device flags"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetDevice, ::cudaGetDeviceProperties,"]
    #[doc = " ::cudaSetDevice, ::cudaSetDeviceFlags,"]
    #[doc = " ::cuCtxGetFlags,"]
    #[doc = " ::cuDevicePrimaryCtxGetState"]
    pub fn cudaGetDeviceFlags(flags: *mut ::libc::c_uint) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Create an asynchronous stream"]
    #[doc = ""]
    #[doc = " Creates a new asynchronous stream."]
    #[doc = ""]
    #[doc = " \\param pStream - Pointer to new stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaStreamCreateWithPriority,"]
    #[doc = " ::cudaStreamCreateWithFlags,"]
    #[doc = " ::cudaStreamGetPriority,"]
    #[doc = " ::cudaStreamGetFlags,"]
    #[doc = " ::cudaStreamQuery,"]
    #[doc = " ::cudaStreamSynchronize,"]
    #[doc = " ::cudaStreamWaitEvent,"]
    #[doc = " ::cudaStreamAddCallback,"]
    #[doc = " ::cudaStreamDestroy,"]
    #[doc = " ::cuStreamCreate"]
    pub fn cudaStreamCreate(pStream: *mut cudaStream_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Create an asynchronous stream"]
    #[doc = ""]
    #[doc = " Creates a new asynchronous stream.  The \\p flags argument determines the"]
    #[doc = " behaviors of the stream.  Valid values for \\p flags are"]
    #[doc = " - ::cudaStreamDefault: Default stream creation flag."]
    #[doc = " - ::cudaStreamNonBlocking: Specifies that work running in the created"]
    #[doc = "   stream may run concurrently with work in stream 0 (the NULL stream), and that"]
    #[doc = "   the created stream should perform no implicit synchronization with stream 0."]
    #[doc = ""]
    #[doc = " \\param pStream - Pointer to new stream identifier"]
    #[doc = " \\param flags   - Parameters for stream creation"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaStreamCreate,"]
    #[doc = " ::cudaStreamCreateWithPriority,"]
    #[doc = " ::cudaStreamGetFlags,"]
    #[doc = " ::cudaStreamQuery,"]
    #[doc = " ::cudaStreamSynchronize,"]
    #[doc = " ::cudaStreamWaitEvent,"]
    #[doc = " ::cudaStreamAddCallback,"]
    #[doc = " ::cudaStreamDestroy,"]
    #[doc = " ::cuStreamCreate"]
    pub fn cudaStreamCreateWithFlags(
        pStream: *mut cudaStream_t,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Create an asynchronous stream with the specified priority"]
    #[doc = ""]
    #[doc = " Creates a stream with the specified priority and returns a handle in \\p pStream."]
    #[doc = " This API alters the scheduler priority of work in the stream. Work in a higher"]
    #[doc = " priority stream may preempt work already executing in a low priority stream."]
    #[doc = ""]
    #[doc = " \\p priority follows a convention where lower numbers represent higher priorities."]
    #[doc = " '0' represents default priority. The range of meaningful numerical priorities can"]
    #[doc = " be queried using ::cudaDeviceGetStreamPriorityRange. If the specified priority is"]
    #[doc = " outside the numerical range returned by ::cudaDeviceGetStreamPriorityRange,"]
    #[doc = " it will automatically be clamped to the lowest or the highest number in the range."]
    #[doc = ""]
    #[doc = " \\param pStream  - Pointer to new stream identifier"]
    #[doc = " \\param flags    - Flags for stream creation. See ::cudaStreamCreateWithFlags for a list of valid flags that can be passed"]
    #[doc = " \\param priority - Priority of the stream. Lower numbers represent higher priorities."]
    #[doc = "                   See ::cudaDeviceGetStreamPriorityRange for more information about"]
    #[doc = "                   the meaningful stream priorities that can be passed."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\note Stream priorities are supported only on GPUs"]
    #[doc = " with compute capability 3.5 or higher."]
    #[doc = ""]
    #[doc = " \\note In the current implementation, only compute kernels launched in"]
    #[doc = " priority streams are affected by the stream's priority. Stream priorities have"]
    #[doc = " no effect on host-to-device and device-to-host memory operations."]
    #[doc = ""]
    #[doc = " \\sa ::cudaStreamCreate,"]
    #[doc = " ::cudaStreamCreateWithFlags,"]
    #[doc = " ::cudaDeviceGetStreamPriorityRange,"]
    #[doc = " ::cudaStreamGetPriority,"]
    #[doc = " ::cudaStreamQuery,"]
    #[doc = " ::cudaStreamWaitEvent,"]
    #[doc = " ::cudaStreamAddCallback,"]
    #[doc = " ::cudaStreamSynchronize,"]
    #[doc = " ::cudaStreamDestroy,"]
    #[doc = " ::cuStreamCreateWithPriority"]
    pub fn cudaStreamCreateWithPriority(
        pStream: *mut cudaStream_t,
        flags: ::libc::c_uint,
        priority: ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Query the priority of a stream"]
    #[doc = ""]
    #[doc = " Query the priority of a stream. The priority is returned in in \\p priority."]
    #[doc = " Note that if the stream was created with a priority outside the meaningful"]
    #[doc = " numerical range returned by ::cudaDeviceGetStreamPriorityRange,"]
    #[doc = " this function returns the clamped priority."]
    #[doc = " See ::cudaStreamCreateWithPriority for details about priority clamping."]
    #[doc = ""]
    #[doc = " \\param hStream    - Handle to the stream to be queried"]
    #[doc = " \\param priority   - Pointer to a signed integer in which the stream's priority is returned"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaStreamCreateWithPriority,"]
    #[doc = " ::cudaDeviceGetStreamPriorityRange,"]
    #[doc = " ::cudaStreamGetFlags,"]
    #[doc = " ::cuStreamGetPriority"]
    pub fn cudaStreamGetPriority(
        hStream: cudaStream_t,
        priority: *mut ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Query the flags of a stream"]
    #[doc = ""]
    #[doc = " Query the flags of a stream. The flags are returned in \\p flags."]
    #[doc = " See ::cudaStreamCreateWithFlags for a list of valid flags."]
    #[doc = ""]
    #[doc = " \\param hStream - Handle to the stream to be queried"]
    #[doc = " \\param flags   - Pointer to an unsigned integer in which the stream's flags are returned"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaStreamCreateWithPriority,"]
    #[doc = " ::cudaStreamCreateWithFlags,"]
    #[doc = " ::cudaStreamGetPriority,"]
    #[doc = " ::cuStreamGetFlags"]
    pub fn cudaStreamGetFlags(hStream: cudaStream_t, flags: *mut ::libc::c_uint) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Resets all persisting lines in cache to normal status."]
    #[doc = ""]
    #[doc = " Resets all persisting lines in cache to normal status."]
    #[doc = " Takes effect on function return."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaAccessPolicyWindow"]
    pub fn cudaCtxResetPersistingL2Cache() -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies attributes from source stream to destination stream."]
    #[doc = ""]
    #[doc = " Copies attributes from source stream \\p src to destination stream \\p dst."]
    #[doc = " Both streams must have the same context."]
    #[doc = ""]
    #[doc = " \\param[out] dst Destination stream"]
    #[doc = " \\param[in] src Source stream"]
    #[doc = " For attributes see ::cudaStreamAttrID"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorNotSupported"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaAccessPolicyWindow"]
    pub fn cudaStreamCopyAttributes(dst: cudaStream_t, src: cudaStream_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Queries stream attribute."]
    #[doc = ""]
    #[doc = " Queries attribute \\p attr from \\p hStream and stores it in corresponding"]
    #[doc = " member of \\p value_out."]
    #[doc = ""]
    #[doc = " \\param[in] hStream"]
    #[doc = " \\param[in] attr"]
    #[doc = " \\param[out] value_out"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaAccessPolicyWindow"]
    pub fn cudaStreamGetAttribute(
        hStream: cudaStream_t,
        attr: cudaStreamAttrID,
        value_out: *mut cudaStreamAttrValue,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets stream attribute."]
    #[doc = ""]
    #[doc = " Sets attribute \\p attr on \\p hStream from corresponding attribute of"]
    #[doc = " \\p value. The updated attribute will be applied to subsequent work"]
    #[doc = " submitted to the stream. It will not affect previously submitted work."]
    #[doc = ""]
    #[doc = " \\param[out] hStream"]
    #[doc = " \\param[in] attr"]
    #[doc = " \\param[in] value"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaAccessPolicyWindow"]
    pub fn cudaStreamSetAttribute(
        hStream: cudaStream_t,
        attr: cudaStreamAttrID,
        value: *const cudaStreamAttrValue,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Destroys and cleans up an asynchronous stream"]
    #[doc = ""]
    #[doc = " Destroys and cleans up the asynchronous stream specified by \\p stream."]
    #[doc = ""]
    #[doc = " In case the device is still doing work in the stream \\p stream"]
    #[doc = " when ::cudaStreamDestroy() is called, the function will return immediately"]
    #[doc = " and the resources associated with \\p stream will be released automatically"]
    #[doc = " once the device has completed all work in \\p stream."]
    #[doc = ""]
    #[doc = " \\param stream - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_destroy_ub"]
    #[doc = ""]
    #[doc = " \\sa ::cudaStreamCreate,"]
    #[doc = " ::cudaStreamCreateWithFlags,"]
    #[doc = " ::cudaStreamQuery,"]
    #[doc = " ::cudaStreamWaitEvent,"]
    #[doc = " ::cudaStreamSynchronize,"]
    #[doc = " ::cudaStreamAddCallback,"]
    #[doc = " ::cuStreamDestroy"]
    pub fn cudaStreamDestroy(stream: cudaStream_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Make a compute stream wait on an event"]
    #[doc = ""]
    #[doc = " Makes all future work submitted to \\p stream wait for all work captured in"]
    #[doc = " \\p event.  See ::cudaEventRecord() for details on what is captured by an event."]
    #[doc = " The synchronization will be performed efficiently on the device when applicable."]
    #[doc = " \\p event may be from a different device than \\p stream."]
    #[doc = ""]
    #[doc = " flags include:"]
    #[doc = " - ::cudaEventWaitDefault: Default event creation flag."]
    #[doc = " - ::cudaEventWaitExternal: Event is captured in the graph as an external"]
    #[doc = "   event node when performing stream capture."]
    #[doc = ""]
    #[doc = " \\param stream - Stream to wait"]
    #[doc = " \\param event  - Event to wait on"]
    #[doc = " \\param flags  - Parameters for the operation(See above)"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaStreamCreate, ::cudaStreamCreateWithFlags, ::cudaStreamQuery, ::cudaStreamSynchronize, ::cudaStreamAddCallback, ::cudaStreamDestroy,"]
    #[doc = " ::cuStreamWaitEvent"]
    pub fn cudaStreamWaitEvent(
        stream: cudaStream_t,
        event: cudaEvent_t,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
#[doc = " Type of stream callback functions."]
#[doc = " \\param stream The stream as passed to ::cudaStreamAddCallback, may be NULL."]
#[doc = " \\param status ::cudaSuccess or any persistent error on the stream."]
#[doc = " \\param userData User parameter provided at registration."]
pub type cudaStreamCallback_t = ::std::option::Option<
    unsafe extern "C" fn(stream: cudaStream_t, status: cudaError_t, userData: *mut ::libc::c_void),
>;
extern "C" {
    #[doc = " \\brief Add a callback to a compute stream"]
    #[doc = ""]
    #[doc = " \\note This function is slated for eventual deprecation and removal. If"]
    #[doc = " you do not require the callback to execute in case of a device error,"]
    #[doc = " consider using ::cudaLaunchHostFunc. Additionally, this function is not"]
    #[doc = " supported with ::cudaStreamBeginCapture and ::cudaStreamEndCapture, unlike"]
    #[doc = " ::cudaLaunchHostFunc."]
    #[doc = ""]
    #[doc = " Adds a callback to be called on the host after all currently enqueued"]
    #[doc = " items in the stream have completed.  For each"]
    #[doc = " cudaStreamAddCallback call, a callback will be executed exactly once."]
    #[doc = " The callback will block later work in the stream until it is finished."]
    #[doc = ""]
    #[doc = " The callback may be passed ::cudaSuccess or an error code.  In the event"]
    #[doc = " of a device error, all subsequently executed callbacks will receive an"]
    #[doc = " appropriate ::cudaError_t."]
    #[doc = ""]
    #[doc = " Callbacks must not make any CUDA API calls.  Attempting to use CUDA APIs"]
    #[doc = " may result in ::cudaErrorNotPermitted.  Callbacks must not perform any"]
    #[doc = " synchronization that may depend on outstanding device work or other callbacks"]
    #[doc = " that are not mandated to run earlier.  Callbacks without a mandated order"]
    #[doc = " (in independent streams) execute in undefined order and may be serialized."]
    #[doc = ""]
    #[doc = " For the purposes of Unified Memory, callback execution makes a number of"]
    #[doc = " guarantees:"]
    #[doc = " <ul>"]
    #[doc = "   <li>The callback stream is considered idle for the duration of the"]
    #[doc = "   callback.  Thus, for example, a callback may always use memory attached"]
    #[doc = "   to the callback stream.</li>"]
    #[doc = "   <li>The start of execution of a callback has the same effect as"]
    #[doc = "   synchronizing an event recorded in the same stream immediately prior to"]
    #[doc = "   the callback.  It thus synchronizes streams which have been \"joined\""]
    #[doc = "   prior to the callback.</li>"]
    #[doc = "   <li>Adding device work to any stream does not have the effect of making"]
    #[doc = "   the stream active until all preceding callbacks have executed.  Thus, for"]
    #[doc = "   example, a callback might use global attached memory even if work has"]
    #[doc = "   been added to another stream, if it has been properly ordered with an"]
    #[doc = "   event.</li>"]
    #[doc = "   <li>Completion of a callback does not cause a stream to become"]
    #[doc = "   active except as described above.  The callback stream will remain idle"]
    #[doc = "   if no device work follows the callback, and will remain idle across"]
    #[doc = "   consecutive callbacks without device work in between.  Thus, for example,"]
    #[doc = "   stream synchronization can be done by signaling from a callback at the"]
    #[doc = "   end of the stream.</li>"]
    #[doc = " </ul>"]
    #[doc = ""]
    #[doc = " \\param stream   - Stream to add callback to"]
    #[doc = " \\param callback - The function to call once preceding stream operations are complete"]
    #[doc = " \\param userData - User specified data to be passed to the callback function"]
    #[doc = " \\param flags    - Reserved for future use, must be 0"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorNotSupported"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaStreamCreate, ::cudaStreamCreateWithFlags, ::cudaStreamQuery, ::cudaStreamSynchronize, ::cudaStreamWaitEvent, ::cudaStreamDestroy, ::cudaMallocManaged, ::cudaStreamAttachMemAsync,"]
    #[doc = " ::cudaLaunchHostFunc, ::cuStreamAddCallback"]
    pub fn cudaStreamAddCallback(
        stream: cudaStream_t,
        callback: cudaStreamCallback_t,
        userData: *mut ::libc::c_void,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Waits for stream tasks to complete"]
    #[doc = ""]
    #[doc = " Blocks until \\p stream has completed all operations. If the"]
    #[doc = " ::cudaDeviceScheduleBlockingSync flag was set for this device,"]
    #[doc = " the host thread will block until the stream is finished with"]
    #[doc = " all of its tasks."]
    #[doc = ""]
    #[doc = " \\param stream - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaStreamCreate, ::cudaStreamCreateWithFlags, ::cudaStreamQuery, ::cudaStreamWaitEvent, ::cudaStreamAddCallback, ::cudaStreamDestroy,"]
    #[doc = " ::cuStreamSynchronize"]
    pub fn cudaStreamSynchronize(stream: cudaStream_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Queries an asynchronous stream for completion status"]
    #[doc = ""]
    #[doc = " Returns ::cudaSuccess if all operations in \\p stream have"]
    #[doc = " completed, or ::cudaErrorNotReady if not."]
    #[doc = ""]
    #[doc = " For the purposes of Unified Memory, a return value of ::cudaSuccess"]
    #[doc = " is equivalent to having called ::cudaStreamSynchronize()."]
    #[doc = ""]
    #[doc = " \\param stream - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorNotReady,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaStreamCreate, ::cudaStreamCreateWithFlags, ::cudaStreamWaitEvent, ::cudaStreamSynchronize, ::cudaStreamAddCallback, ::cudaStreamDestroy,"]
    #[doc = " ::cuStreamQuery"]
    pub fn cudaStreamQuery(stream: cudaStream_t) -> cudaError_t;
}
extern "C" {
    pub fn cudaStreamAttachMemAsync(
        stream: cudaStream_t,
        devPtr: *mut ::libc::c_void,
        length: usize,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Begins graph capture on a stream"]
    #[doc = ""]
    #[doc = " Begin graph capture on \\p stream. When a stream is in capture mode, all operations"]
    #[doc = " pushed into the stream will not be executed, but will instead be captured into"]
    #[doc = " a graph, which will be returned via ::cudaStreamEndCapture. Capture may not be initiated"]
    #[doc = " if \\p stream is ::cudaStreamLegacy. Capture must be ended on the same stream in which"]
    #[doc = " it was initiated, and it may only be initiated if the stream is not already in capture"]
    #[doc = " mode. The capture mode may be queried via ::cudaStreamIsCapturing. A unique id"]
    #[doc = " representing the capture sequence may be queried via ::cudaStreamGetCaptureInfo."]
    #[doc = ""]
    #[doc = " If \\p mode is not ::cudaStreamCaptureModeRelaxed, ::cudaStreamEndCapture must be"]
    #[doc = " called on this stream from the same thread."]
    #[doc = ""]
    #[doc = " \\note Kernels captured using this API must not use texture and surface references."]
    #[doc = "       Reading or writing through any texture or surface reference is undefined"]
    #[doc = "       behavior. This restriction does not apply to texture and surface objects."]
    #[doc = ""]
    #[doc = " \\param stream - Stream in which to initiate capture"]
    #[doc = " \\param mode    - Controls the interaction of this capture sequence with other API"]
    #[doc = "                  calls that are potentially unsafe. For more details see"]
    #[doc = "                  ::cudaThreadExchangeStreamCaptureMode."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaStreamCreate,"]
    #[doc = " ::cudaStreamIsCapturing,"]
    #[doc = " ::cudaStreamEndCapture,"]
    #[doc = " ::cudaThreadExchangeStreamCaptureMode"]
    pub fn cudaStreamBeginCapture(stream: cudaStream_t, mode: cudaStreamCaptureMode)
        -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Swaps the stream capture interaction mode for a thread"]
    #[doc = ""]
    #[doc = " Sets the calling thread's stream capture interaction mode to the value contained"]
    #[doc = " in \\p *mode, and overwrites \\p *mode with the previous mode for the thread. To"]
    #[doc = " facilitate deterministic behavior across function or module boundaries, callers"]
    #[doc = " are encouraged to use this API in a push-pop fashion: \\code"]
    #[doc = "cudaStreamCaptureMode mode = desiredMode;"]
    #[doc = "cudaThreadExchangeStreamCaptureMode(&mode);"]
    #[doc = "..."]
    #[doc = "cudaThreadExchangeStreamCaptureMode(&mode); // restore previous mode"]
    #[doc = " \\endcode"]
    #[doc = ""]
    #[doc = " During stream capture (see ::cudaStreamBeginCapture), some actions, such as a call"]
    #[doc = " to ::cudaMalloc, may be unsafe. In the case of ::cudaMalloc, the operation is"]
    #[doc = " not enqueued asynchronously to a stream, and is not observed by stream capture."]
    #[doc = " Therefore, if the sequence of operations captured via ::cudaStreamBeginCapture"]
    #[doc = " depended on the allocation being replayed whenever the graph is launched, the"]
    #[doc = " captured graph would be invalid."]
    #[doc = ""]
    #[doc = " Therefore, stream capture places restrictions on API calls that can be made within"]
    #[doc = " or concurrently to a ::cudaStreamBeginCapture-::cudaStreamEndCapture sequence. This"]
    #[doc = " behavior can be controlled via this API and flags to ::cudaStreamBeginCapture."]
    #[doc = ""]
    #[doc = " A thread's mode is one of the following:"]
    #[doc = " - \\p cudaStreamCaptureModeGlobal: This is the default mode. If the local thread has"]
    #[doc = "   an ongoing capture sequence that was not initiated with"]
    #[doc = "   \\p cudaStreamCaptureModeRelaxed at \\p cuStreamBeginCapture, or if any other thread"]
    #[doc = "   has a concurrent capture sequence initiated with \\p cudaStreamCaptureModeGlobal,"]
    #[doc = "   this thread is prohibited from potentially unsafe API calls."]
    #[doc = " - \\p cudaStreamCaptureModeThreadLocal: If the local thread has an ongoing capture"]
    #[doc = "   sequence not initiated with \\p cudaStreamCaptureModeRelaxed, it is prohibited"]
    #[doc = "   from potentially unsafe API calls. Concurrent capture sequences in other threads"]
    #[doc = "   are ignored."]
    #[doc = " - \\p cudaStreamCaptureModeRelaxed: The local thread is not prohibited from potentially"]
    #[doc = "   unsafe API calls. Note that the thread is still prohibited from API calls which"]
    #[doc = "   necessarily conflict with stream capture, for example, attempting ::cudaEventQuery"]
    #[doc = "   on an event that was last recorded inside a capture sequence."]
    #[doc = ""]
    #[doc = " \\param mode - Pointer to mode value to swap with the current mode"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaStreamBeginCapture"]
    pub fn cudaThreadExchangeStreamCaptureMode(mode: *mut cudaStreamCaptureMode) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Ends capture on a stream, returning the captured graph"]
    #[doc = ""]
    #[doc = " End capture on \\p stream, returning the captured graph via \\p pGraph."]
    #[doc = " Capture must have been initiated on \\p stream via a call to ::cudaStreamBeginCapture."]
    #[doc = " If capture was invalidated, due to a violation of the rules of stream capture, then"]
    #[doc = " a NULL graph will be returned."]
    #[doc = ""]
    #[doc = " If the \\p mode argument to ::cudaStreamBeginCapture was not"]
    #[doc = " ::cudaStreamCaptureModeRelaxed, this call must be from the same thread as"]
    #[doc = " ::cudaStreamBeginCapture."]
    #[doc = ""]
    #[doc = " \\param stream - Stream to query"]
    #[doc = " \\param pGraph - The captured graph"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorStreamCaptureWrongThread"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaStreamCreate,"]
    #[doc = " ::cudaStreamBeginCapture,"]
    #[doc = " ::cudaStreamIsCapturing"]
    pub fn cudaStreamEndCapture(stream: cudaStream_t, pGraph: *mut cudaGraph_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a stream's capture status"]
    #[doc = ""]
    #[doc = " Return the capture status of \\p stream via \\p pCaptureStatus. After a successful"]
    #[doc = " call, \\p *pCaptureStatus will contain one of the following:"]
    #[doc = " - ::cudaStreamCaptureStatusNone: The stream is not capturing."]
    #[doc = " - ::cudaStreamCaptureStatusActive: The stream is capturing."]
    #[doc = " - ::cudaStreamCaptureStatusInvalidated: The stream was capturing but an error"]
    #[doc = "   has invalidated the capture sequence. The capture sequence must be terminated"]
    #[doc = "   with ::cudaStreamEndCapture on the stream where it was initiated in order to"]
    #[doc = "   continue using \\p stream."]
    #[doc = ""]
    #[doc = " Note that, if this is called on ::cudaStreamLegacy (the \"null stream\") while"]
    #[doc = " a blocking stream on the same device is capturing, it will return"]
    #[doc = " ::cudaErrorStreamCaptureImplicit and \\p *pCaptureStatus is unspecified"]
    #[doc = " after the call. The blocking stream capture is not invalidated."]
    #[doc = ""]
    #[doc = " When a blocking stream is capturing, the legacy stream is in an"]
    #[doc = " unusable state until the blocking stream capture is terminated. The legacy"]
    #[doc = " stream is not supported for stream capture, but attempted use would have an"]
    #[doc = " implicit dependency on the capturing stream(s)."]
    #[doc = ""]
    #[doc = " \\param stream         - Stream to query"]
    #[doc = " \\param pCaptureStatus - Returns the stream's capture status"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorStreamCaptureImplicit"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaStreamCreate,"]
    #[doc = " ::cudaStreamBeginCapture,"]
    #[doc = " ::cudaStreamEndCapture"]
    pub fn cudaStreamIsCapturing(
        stream: cudaStream_t,
        pCaptureStatus: *mut cudaStreamCaptureStatus,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Query capture status of a stream"]
    #[doc = ""]
    #[doc = " Note there is a later version of this API, ::cudaStreamGetCaptureInfo_v2. It will"]
    #[doc = " supplant this version in 12.0, which is retained for minor version compatibility."]
    #[doc = ""]
    #[doc = " Query the capture status of a stream and get a unique id representing"]
    #[doc = " the capture sequence over the lifetime of the process."]
    #[doc = ""]
    #[doc = " If called on ::cudaStreamLegacy (the \"null stream\") while a stream not created"]
    #[doc = " with ::cudaStreamNonBlocking is capturing, returns ::cudaErrorStreamCaptureImplicit."]
    #[doc = ""]
    #[doc = " A valid id is returned only if both of the following are true:"]
    #[doc = " - the call returns ::cudaSuccess"]
    #[doc = " - captureStatus is set to ::cudaStreamCaptureStatusActive"]
    #[doc = ""]
    #[doc = " \\param stream         - Stream to query"]
    #[doc = " \\param pCaptureStatus - Returns the stream's capture status"]
    #[doc = " \\param pId            - Returns the unique id of the capture sequence"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorStreamCaptureImplicit"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaStreamGetCaptureInfo_v2,"]
    #[doc = " ::cudaStreamBeginCapture,"]
    #[doc = " ::cudaStreamIsCapturing"]
    pub fn cudaStreamGetCaptureInfo(
        stream: cudaStream_t,
        pCaptureStatus: *mut cudaStreamCaptureStatus,
        pId: *mut ::libc::c_ulonglong,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Query a stream's capture state (11.3+)"]
    #[doc = ""]
    #[doc = " Query stream state related to stream capture."]
    #[doc = ""]
    #[doc = " If called on ::cudaStreamLegacy (the \"null stream\") while a stream not created"]
    #[doc = " with ::cudaStreamNonBlocking is capturing, returns ::cudaErrorStreamCaptureImplicit."]
    #[doc = ""]
    #[doc = " Valid data (other than capture status) is returned only if both of the following are true:"]
    #[doc = " - the call returns cudaSuccess"]
    #[doc = " - the returned capture status is ::cudaStreamCaptureStatusActive"]
    #[doc = ""]
    #[doc = " This version of cudaStreamGetCaptureInfo is introduced in CUDA 11.3 and will supplant the"]
    #[doc = " previous version ::cudaStreamGetCaptureInfo in 12.0. Developers requiring compatibility"]
    #[doc = " across minor versions to CUDA 11.0 (driver version 445) can do one of the following:"]
    #[doc = " - Use the older version of the API, ::cudaStreamGetCaptureInfo"]
    #[doc = " - Pass null for all of \\p graph_out, \\p dependencies_out, and \\p numDependencies_out."]
    #[doc = ""]
    #[doc = " \\param stream - The stream to query"]
    #[doc = " \\param captureStatus_out - Location to return the capture status of the stream; required"]
    #[doc = " \\param id_out - Optional location to return an id for the capture sequence, which is"]
    #[doc = "           unique over the lifetime of the process"]
    #[doc = " \\param graph_out - Optional location to return the graph being captured into. All"]
    #[doc = "           operations other than destroy and node removal are permitted on the graph"]
    #[doc = "           while the capture sequence is in progress. This API does not transfer"]
    #[doc = "           ownership of the graph, which is transferred or destroyed at"]
    #[doc = "           ::cudaStreamEndCapture. Note that the graph handle may be invalidated before"]
    #[doc = "           end of capture for certain errors. Nodes that are or become"]
    #[doc = "           unreachable from the original stream at ::cudaStreamEndCapture due to direct"]
    #[doc = "           actions on the graph do not trigger ::cudaErrorStreamCaptureUnjoined."]
    #[doc = " \\param dependencies_out - Optional location to store a pointer to an array of nodes."]
    #[doc = "           The next node to be captured in the stream will depend on this set of nodes,"]
    #[doc = "           absent operations such as event wait which modify this set. The array pointer"]
    #[doc = "           is valid until the next API call which operates on the stream or until end of"]
    #[doc = "           capture. The node handles may be copied out and are valid until they or the"]
    #[doc = "           graph is destroyed. The driver-owned array may also be passed directly to"]
    #[doc = "           APIs that operate on the graph (not the stream) without copying."]
    #[doc = " \\param numDependencies_out - Optional location to store the size of the array"]
    #[doc = "           returned in dependencies_out."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorStreamCaptureImplicit"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaStreamGetCaptureInfo,"]
    #[doc = " ::cudaStreamBeginCapture,"]
    #[doc = " ::cudaStreamIsCapturing,"]
    #[doc = " ::cudaStreamUpdateCaptureDependencies"]
    pub fn cudaStreamGetCaptureInfo_v2(
        stream: cudaStream_t,
        captureStatus_out: *mut cudaStreamCaptureStatus,
        id_out: *mut ::libc::c_ulonglong,
        graph_out: *mut cudaGraph_t,
        dependencies_out: *mut *const cudaGraphNode_t,
        numDependencies_out: *mut usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Update the set of dependencies in a capturing stream (11.3+)"]
    #[doc = ""]
    #[doc = " Modifies the dependency set of a capturing stream. The dependency set is the set"]
    #[doc = " of nodes that the next captured node in the stream will depend on."]
    #[doc = ""]
    #[doc = " Valid flags are ::cudaStreamAddCaptureDependencies and"]
    #[doc = " ::cudaStreamSetCaptureDependencies. These control whether the set passed to"]
    #[doc = " the API is added to the existing set or replaces it. A flags value of 0 defaults"]
    #[doc = " to ::cudaStreamAddCaptureDependencies."]
    #[doc = ""]
    #[doc = " Nodes that are removed from the dependency set via this API do not result in"]
    #[doc = " ::cudaErrorStreamCaptureUnjoined if they are unreachable from the stream at"]
    #[doc = " ::cudaStreamEndCapture."]
    #[doc = ""]
    #[doc = " Returns ::cudaErrorIllegalState if the stream is not capturing."]
    #[doc = ""]
    #[doc = " This API is new in CUDA 11.3. Developers requiring compatibility across minor"]
    #[doc = " versions of the CUDA driver to 11.0 should not use this API or provide a fallback."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorIllegalState"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaStreamBeginCapture,"]
    #[doc = " ::cudaStreamGetCaptureInfo,"]
    #[doc = " ::cudaStreamGetCaptureInfo_v2"]
    pub fn cudaStreamUpdateCaptureDependencies(
        stream: cudaStream_t,
        dependencies: *mut cudaGraphNode_t,
        numDependencies: usize,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Creates an event object"]
    #[doc = ""]
    #[doc = " Creates an event object for the current device using ::cudaEventDefault."]
    #[doc = ""]
    #[doc = " \\param event - Newly created event"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorLaunchFailure,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaEventCreate(cudaEvent_t*, unsigned int) \"cudaEventCreate (C++ API)\","]
    #[doc = " ::cudaEventCreateWithFlags, ::cudaEventRecord, ::cudaEventQuery,"]
    #[doc = " ::cudaEventSynchronize, ::cudaEventDestroy, ::cudaEventElapsedTime,"]
    #[doc = " ::cudaStreamWaitEvent,"]
    #[doc = " ::cuEventCreate"]
    pub fn cudaEventCreate(event: *mut cudaEvent_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Creates an event object with the specified flags"]
    #[doc = ""]
    #[doc = " Creates an event object for the current device with the specified flags. Valid"]
    #[doc = " flags include:"]
    #[doc = " - ::cudaEventDefault: Default event creation flag."]
    #[doc = " - ::cudaEventBlockingSync: Specifies that event should use blocking"]
    #[doc = "   synchronization. A host thread that uses ::cudaEventSynchronize() to wait"]
    #[doc = "   on an event created with this flag will block until the event actually"]
    #[doc = "   completes."]
    #[doc = " - ::cudaEventDisableTiming: Specifies that the created event does not need"]
    #[doc = "   to record timing data.  Events created with this flag specified and"]
    #[doc = "   the ::cudaEventBlockingSync flag not specified will provide the best"]
    #[doc = "   performance when used with ::cudaStreamWaitEvent() and ::cudaEventQuery()."]
    #[doc = " - ::cudaEventInterprocess: Specifies that the created event may be used as an"]
    #[doc = "   interprocess event by ::cudaIpcGetEventHandle(). ::cudaEventInterprocess must"]
    #[doc = "   be specified along with ::cudaEventDisableTiming."]
    #[doc = ""]
    #[doc = " \\param event - Newly created event"]
    #[doc = " \\param flags - Flags for new event"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorLaunchFailure,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaEventCreate(cudaEvent_t*) \"cudaEventCreate (C API)\","]
    #[doc = " ::cudaEventSynchronize, ::cudaEventDestroy, ::cudaEventElapsedTime,"]
    #[doc = " ::cudaStreamWaitEvent,"]
    #[doc = " ::cuEventCreate"]
    pub fn cudaEventCreateWithFlags(event: *mut cudaEvent_t, flags: ::libc::c_uint) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Records an event"]
    #[doc = ""]
    #[doc = " Captures in \\p event the contents of \\p stream at the time of this call."]
    #[doc = " \\p event and \\p stream must be on the same device."]
    #[doc = " Calls such as ::cudaEventQuery() or ::cudaStreamWaitEvent() will then"]
    #[doc = " examine or wait for completion of the work that was captured. Uses of"]
    #[doc = " \\p stream after this call do not modify \\p event. See note on default"]
    #[doc = " stream behavior for what is captured in the default case."]
    #[doc = ""]
    #[doc = " ::cudaEventRecord() can be called multiple times on the same event and"]
    #[doc = " will overwrite the previously captured state. Other APIs such as"]
    #[doc = " ::cudaStreamWaitEvent() use the most recently captured state at the time"]
    #[doc = " of the API call, and are not affected by later calls to"]
    #[doc = " ::cudaEventRecord(). Before the first call to ::cudaEventRecord(), an"]
    #[doc = " event represents an empty set of work, so for example ::cudaEventQuery()"]
    #[doc = " would return ::cudaSuccess."]
    #[doc = ""]
    #[doc = " \\param event  - Event to record"]
    #[doc = " \\param stream - Stream in which to record event"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorLaunchFailure"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaEventCreate(cudaEvent_t*) \"cudaEventCreate (C API)\","]
    #[doc = " ::cudaEventCreateWithFlags, ::cudaEventQuery,"]
    #[doc = " ::cudaEventSynchronize, ::cudaEventDestroy, ::cudaEventElapsedTime,"]
    #[doc = " ::cudaStreamWaitEvent,"]
    #[doc = " ::cudaEventRecordWithFlags,"]
    #[doc = " ::cuEventRecord"]
    pub fn cudaEventRecord(event: cudaEvent_t, stream: cudaStream_t) -> cudaError_t;
}
extern "C" {
    pub fn cudaEventRecordWithFlags(
        event: cudaEvent_t,
        stream: cudaStream_t,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Queries an event's status"]
    #[doc = ""]
    #[doc = " Queries the status of all work currently captured by \\p event. See"]
    #[doc = " ::cudaEventRecord() for details on what is captured by an event."]
    #[doc = ""]
    #[doc = " Returns ::cudaSuccess if all captured work has been completed, or"]
    #[doc = " ::cudaErrorNotReady if any captured work is incomplete."]
    #[doc = ""]
    #[doc = " For the purposes of Unified Memory, a return value of ::cudaSuccess"]
    #[doc = " is equivalent to having called ::cudaEventSynchronize()."]
    #[doc = ""]
    #[doc = " \\param event - Event to query"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorNotReady,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorLaunchFailure"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaEventCreate(cudaEvent_t*) \"cudaEventCreate (C API)\","]
    #[doc = " ::cudaEventCreateWithFlags, ::cudaEventRecord,"]
    #[doc = " ::cudaEventSynchronize, ::cudaEventDestroy, ::cudaEventElapsedTime,"]
    #[doc = " ::cuEventQuery"]
    pub fn cudaEventQuery(event: cudaEvent_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Waits for an event to complete"]
    #[doc = ""]
    #[doc = " Waits until the completion of all work currently captured in \\p event."]
    #[doc = " See ::cudaEventRecord() for details on what is captured by an event."]
    #[doc = ""]
    #[doc = " Waiting for an event that was created with the ::cudaEventBlockingSync"]
    #[doc = " flag will cause the calling CPU thread to block until the event has"]
    #[doc = " been completed by the device.  If the ::cudaEventBlockingSync flag has"]
    #[doc = " not been set, then the CPU thread will busy-wait until the event has"]
    #[doc = " been completed by the device."]
    #[doc = ""]
    #[doc = " \\param event - Event to wait for"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorLaunchFailure"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaEventCreate(cudaEvent_t*) \"cudaEventCreate (C API)\","]
    #[doc = " ::cudaEventCreateWithFlags, ::cudaEventRecord,"]
    #[doc = " ::cudaEventQuery, ::cudaEventDestroy, ::cudaEventElapsedTime,"]
    #[doc = " ::cuEventSynchronize"]
    pub fn cudaEventSynchronize(event: cudaEvent_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Destroys an event object"]
    #[doc = ""]
    #[doc = " Destroys the event specified by \\p event."]
    #[doc = ""]
    #[doc = " An event may be destroyed before it is complete (i.e., while"]
    #[doc = " ::cudaEventQuery() would return ::cudaErrorNotReady). In this case, the"]
    #[doc = " call does not block on completion of the event, and any associated"]
    #[doc = " resources will automatically be released asynchronously at completion."]
    #[doc = ""]
    #[doc = " \\param event - Event to destroy"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorLaunchFailure"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_destroy_ub"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaEventCreate(cudaEvent_t*) \"cudaEventCreate (C API)\","]
    #[doc = " ::cudaEventCreateWithFlags, ::cudaEventQuery,"]
    #[doc = " ::cudaEventSynchronize, ::cudaEventRecord, ::cudaEventElapsedTime,"]
    #[doc = " ::cuEventDestroy"]
    pub fn cudaEventDestroy(event: cudaEvent_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Computes the elapsed time between events"]
    #[doc = ""]
    #[doc = " Computes the elapsed time between two events (in milliseconds with a"]
    #[doc = " resolution of around 0.5 microseconds)."]
    #[doc = ""]
    #[doc = " If either event was last recorded in a non-NULL stream, the resulting time"]
    #[doc = " may be greater than expected (even if both used the same stream handle). This"]
    #[doc = " happens because the ::cudaEventRecord() operation takes place asynchronously"]
    #[doc = " and there is no guarantee that the measured latency is actually just between"]
    #[doc = " the two events. Any number of other different stream operations could execute"]
    #[doc = " in between the two measured events, thus altering the timing in a significant"]
    #[doc = " way."]
    #[doc = ""]
    #[doc = " If ::cudaEventRecord() has not been called on either event, then"]
    #[doc = " ::cudaErrorInvalidResourceHandle is returned. If ::cudaEventRecord() has been"]
    #[doc = " called on both events but one or both of them has not yet been completed"]
    #[doc = " (that is, ::cudaEventQuery() would return ::cudaErrorNotReady on at least one"]
    #[doc = " of the events), ::cudaErrorNotReady is returned. If either event was created"]
    #[doc = " with the ::cudaEventDisableTiming flag, then this function will return"]
    #[doc = " ::cudaErrorInvalidResourceHandle."]
    #[doc = ""]
    #[doc = " \\param ms    - Time between \\p start and \\p end in ms"]
    #[doc = " \\param start - Starting event"]
    #[doc = " \\param end   - Ending event"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorNotReady,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorLaunchFailure"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaEventCreate(cudaEvent_t*) \"cudaEventCreate (C API)\","]
    #[doc = " ::cudaEventCreateWithFlags, ::cudaEventQuery,"]
    #[doc = " ::cudaEventSynchronize, ::cudaEventDestroy, ::cudaEventRecord,"]
    #[doc = " ::cuEventElapsedTime"]
    pub fn cudaEventElapsedTime(ms: *mut f32, start: cudaEvent_t, end: cudaEvent_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Imports an external memory object"]
    #[doc = ""]
    #[doc = " Imports an externally allocated memory object and returns"]
    #[doc = " a handle to that in \\p extMem_out."]
    #[doc = ""]
    #[doc = " The properties of the handle being imported must be described in"]
    #[doc = " \\p memHandleDesc. The ::cudaExternalMemoryHandleDesc structure"]
    #[doc = " is defined as follows:"]
    #[doc = ""]
    #[doc = " \\code"]
    #[doc = "typedef struct cudaExternalMemoryHandleDesc_st {"]
    #[doc = "cudaExternalMemoryHandleType type;"]
    #[doc = "union {"]
    #[doc = "int fd;"]
    #[doc = "struct {"]
    #[doc = "void *handle;"]
    #[doc = "const void *name;"]
    #[doc = "} win32;"]
    #[doc = "const void *nvSciBufObject;"]
    #[doc = "} handle;"]
    #[doc = "unsigned long long size;"]
    #[doc = "unsigned int flags;"]
    #[doc = "} cudaExternalMemoryHandleDesc;"]
    #[doc = " \\endcode"]
    #[doc = ""]
    #[doc = " where ::cudaExternalMemoryHandleDesc::type specifies the type"]
    #[doc = " of handle being imported. ::cudaExternalMemoryHandleType is"]
    #[doc = " defined as:"]
    #[doc = ""]
    #[doc = " \\code"]
    #[doc = "typedef enum cudaExternalMemoryHandleType_enum {"]
    #[doc = "cudaExternalMemoryHandleTypeOpaqueFd         = 1,"]
    #[doc = "cudaExternalMemoryHandleTypeOpaqueWin32      = 2,"]
    #[doc = "cudaExternalMemoryHandleTypeOpaqueWin32Kmt   = 3,"]
    #[doc = "cudaExternalMemoryHandleTypeD3D12Heap        = 4,"]
    #[doc = "cudaExternalMemoryHandleTypeD3D12Resource    = 5,"]
    #[doc = "cudaExternalMemoryHandleTypeD3D11Resource    = 6,"]
    #[doc = "cudaExternalMemoryHandleTypeD3D11ResourceKmt = 7,"]
    #[doc = "cudaExternalMemoryHandleTypeNvSciBuf         = 8"]
    #[doc = "} cudaExternalMemoryHandleType;"]
    #[doc = " \\endcode"]
    #[doc = ""]
    #[doc = " If ::cudaExternalMemoryHandleDesc::type is"]
    #[doc = " ::cudaExternalMemoryHandleTypeOpaqueFd, then"]
    #[doc = " ::cudaExternalMemoryHandleDesc::handle::fd must be a valid"]
    #[doc = " file descriptor referencing a memory object. Ownership of"]
    #[doc = " the file descriptor is transferred to the CUDA driver when the"]
    #[doc = " handle is imported successfully. Performing any operations on the"]
    #[doc = " file descriptor after it is imported results in undefined behavior."]
    #[doc = ""]
    #[doc = " If ::cudaExternalMemoryHandleDesc::type is"]
    #[doc = " ::cudaExternalMemoryHandleTypeOpaqueWin32, then exactly one"]
    #[doc = " of ::cudaExternalMemoryHandleDesc::handle::win32::handle and"]
    #[doc = " ::cudaExternalMemoryHandleDesc::handle::win32::name must not be"]
    #[doc = " NULL. If ::cudaExternalMemoryHandleDesc::handle::win32::handle"]
    #[doc = " is not NULL, then it must represent a valid shared NT handle that"]
    #[doc = " references a memory object. Ownership of this handle is"]
    #[doc = " not transferred to CUDA after the import operation, so the"]
    #[doc = " application must release the handle using the appropriate system"]
    #[doc = " call. If ::cudaExternalMemoryHandleDesc::handle::win32::name"]
    #[doc = " is not NULL, then it must point to a NULL-terminated array of"]
    #[doc = " UTF-16 characters that refers to a memory object."]
    #[doc = ""]
    #[doc = " If ::cudaExternalMemoryHandleDesc::type is"]
    #[doc = " ::cudaExternalMemoryHandleTypeOpaqueWin32Kmt, then"]
    #[doc = " ::cudaExternalMemoryHandleDesc::handle::win32::handle must"]
    #[doc = " be non-NULL and"]
    #[doc = " ::cudaExternalMemoryHandleDesc::handle::win32::name"]
    #[doc = " must be NULL. The handle specified must be a globally shared KMT"]
    #[doc = " handle. This handle does not hold a reference to the underlying"]
    #[doc = " object, and thus will be invalid when all references to the"]
    #[doc = " memory object are destroyed."]
    #[doc = ""]
    #[doc = " If ::cudaExternalMemoryHandleDesc::type is"]
    #[doc = " ::cudaExternalMemoryHandleTypeD3D12Heap, then exactly one"]
    #[doc = " of ::cudaExternalMemoryHandleDesc::handle::win32::handle and"]
    #[doc = " ::cudaExternalMemoryHandleDesc::handle::win32::name must not be"]
    #[doc = " NULL. If ::cudaExternalMemoryHandleDesc::handle::win32::handle"]
    #[doc = " is not NULL, then it must represent a valid shared NT handle that"]
    #[doc = " is returned by ID3D12Device::CreateSharedHandle when referring to a"]
    #[doc = " ID3D12Heap object. This handle holds a reference to the underlying"]
    #[doc = " object. If ::cudaExternalMemoryHandleDesc::handle::win32::name"]
    #[doc = " is not NULL, then it must point to a NULL-terminated array of"]
    #[doc = " UTF-16 characters that refers to a ID3D12Heap object."]
    #[doc = ""]
    #[doc = " If ::cudaExternalMemoryHandleDesc::type is"]
    #[doc = " ::cudaExternalMemoryHandleTypeD3D12Resource, then exactly one"]
    #[doc = " of ::cudaExternalMemoryHandleDesc::handle::win32::handle and"]
    #[doc = " ::cudaExternalMemoryHandleDesc::handle::win32::name must not be"]
    #[doc = " NULL. If ::cudaExternalMemoryHandleDesc::handle::win32::handle"]
    #[doc = " is not NULL, then it must represent a valid shared NT handle that"]
    #[doc = " is returned by ID3D12Device::CreateSharedHandle when referring to a"]
    #[doc = " ID3D12Resource object. This handle holds a reference to the"]
    #[doc = " underlying object. If"]
    #[doc = " ::cudaExternalMemoryHandleDesc::handle::win32::name"]
    #[doc = " is not NULL, then it must point to a NULL-terminated array of"]
    #[doc = " UTF-16 characters that refers to a ID3D12Resource object."]
    #[doc = ""]
    #[doc = " If ::cudaExternalMemoryHandleDesc::type is"]
    #[doc = " ::cudaExternalMemoryHandleTypeD3D11Resource,then exactly one"]
    #[doc = " of ::cudaExternalMemoryHandleDesc::handle::win32::handle and"]
    #[doc = " ::cudaExternalMemoryHandleDesc::handle::win32::name must not be"]
    #[doc = " NULL. If ::cudaExternalMemoryHandleDesc::handle::win32::handle is"]
    #[doc = " not NULL, then it must represent a valid shared NT handle that is"]
    #[doc = " returned by  IDXGIResource1::CreateSharedHandle when referring to a"]
    #[doc = " ID3D11Resource object. If"]
    #[doc = " ::cudaExternalMemoryHandleDesc::handle::win32::name"]
    #[doc = " is not NULL, then it must point to a NULL-terminated array of"]
    #[doc = " UTF-16 characters that refers to a ID3D11Resource object."]
    #[doc = ""]
    #[doc = " If ::cudaExternalMemoryHandleDesc::type is"]
    #[doc = " ::cudaExternalMemoryHandleTypeD3D11ResourceKmt, then"]
    #[doc = " ::cudaExternalMemoryHandleDesc::handle::win32::handle must"]
    #[doc = " be non-NULL and ::cudaExternalMemoryHandleDesc::handle::win32::name"]
    #[doc = " must be NULL. The handle specified must be a valid shared KMT"]
    #[doc = " handle that is returned by IDXGIResource::GetSharedHandle when"]
    #[doc = " referring to a ID3D11Resource object."]
    #[doc = ""]
    #[doc = " If ::cudaExternalMemoryHandleDesc::type is"]
    #[doc = " ::cudaExternalMemoryHandleTypeNvSciBuf, then"]
    #[doc = " ::cudaExternalMemoryHandleDesc::handle::nvSciBufObject must be NON-NULL"]
    #[doc = " and reference a valid NvSciBuf object."]
    #[doc = " If the NvSciBuf object imported into CUDA is also mapped by other drivers, then the"]
    #[doc = " application must use ::cudaWaitExternalSemaphoresAsync or ::cudaSignalExternalSemaphoresAsync"]
    #[doc = " as approprriate barriers to maintain coherence between CUDA and the other drivers."]
    #[doc = ""]
    #[doc = " The size of the memory object must be specified in"]
    #[doc = " ::cudaExternalMemoryHandleDesc::size."]
    #[doc = ""]
    #[doc = " Specifying the flag ::cudaExternalMemoryDedicated in"]
    #[doc = " ::cudaExternalMemoryHandleDesc::flags indicates that the"]
    #[doc = " resource is a dedicated resource. The definition of what a"]
    #[doc = " dedicated resource is outside the scope of this extension."]
    #[doc = " This flag must be set if ::cudaExternalMemoryHandleDesc::type"]
    #[doc = " is one of the following:"]
    #[doc = " ::cudaExternalMemoryHandleTypeD3D12Resource"]
    #[doc = " ::cudaExternalMemoryHandleTypeD3D11Resource"]
    #[doc = " ::cudaExternalMemoryHandleTypeD3D11ResourceKmt"]
    #[doc = ""]
    #[doc = " \\param extMem_out    - Returned handle to an external memory object"]
    #[doc = " \\param memHandleDesc - Memory import handle descriptor"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\note If the Vulkan memory imported into CUDA is mapped on the CPU then the"]
    #[doc = " application must use vkInvalidateMappedMemoryRanges/vkFlushMappedMemoryRanges"]
    #[doc = " as well as appropriate Vulkan pipeline barriers to maintain coherence between"]
    #[doc = " CPU and GPU. For more information on these APIs, please refer to \"Synchronization"]
    #[doc = " and Cache Control\" chapter from Vulkan specification."]
    #[doc = ""]
    #[doc = ""]
    #[doc = " \\sa ::cudaDestroyExternalMemory,"]
    #[doc = " ::cudaExternalMemoryGetMappedBuffer,"]
    #[doc = " ::cudaExternalMemoryGetMappedMipmappedArray"]
    pub fn cudaImportExternalMemory(
        extMem_out: *mut cudaExternalMemory_t,
        memHandleDesc: *const cudaExternalMemoryHandleDesc,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Maps a buffer onto an imported memory object"]
    #[doc = ""]
    #[doc = " Maps a buffer onto an imported memory object and returns a device"]
    #[doc = " pointer in \\p devPtr."]
    #[doc = ""]
    #[doc = " The properties of the buffer being mapped must be described in"]
    #[doc = " \\p bufferDesc. The ::cudaExternalMemoryBufferDesc structure is"]
    #[doc = " defined as follows:"]
    #[doc = ""]
    #[doc = " \\code"]
    #[doc = "typedef struct cudaExternalMemoryBufferDesc_st {"]
    #[doc = "unsigned long long offset;"]
    #[doc = "unsigned long long size;"]
    #[doc = "unsigned int flags;"]
    #[doc = "} cudaExternalMemoryBufferDesc;"]
    #[doc = " \\endcode"]
    #[doc = ""]
    #[doc = " where ::cudaExternalMemoryBufferDesc::offset is the offset in"]
    #[doc = " the memory object where the buffer's base address is."]
    #[doc = " ::cudaExternalMemoryBufferDesc::size is the size of the buffer."]
    #[doc = " ::cudaExternalMemoryBufferDesc::flags must be zero."]
    #[doc = ""]
    #[doc = " The offset and size have to be suitably aligned to match the"]
    #[doc = " requirements of the external API. Mapping two buffers whose ranges"]
    #[doc = " overlap may or may not result in the same virtual address being"]
    #[doc = " returned for the overlapped portion. In such cases, the application"]
    #[doc = " must ensure that all accesses to that region from the GPU are"]
    #[doc = " volatile. Otherwise writes made via one address are not guaranteed"]
    #[doc = " to be visible via the other address, even if they're issued by the"]
    #[doc = " same thread. It is recommended that applications map the combined"]
    #[doc = " range instead of mapping separate buffers and then apply the"]
    #[doc = " appropriate offsets to the returned pointer to derive the"]
    #[doc = " individual buffers."]
    #[doc = ""]
    #[doc = " The returned pointer \\p devPtr must be freed using ::cudaFree."]
    #[doc = ""]
    #[doc = " \\param devPtr     - Returned device pointer to buffer"]
    #[doc = " \\param extMem     - Handle to external memory object"]
    #[doc = " \\param bufferDesc - Buffer descriptor"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaImportExternalMemory,"]
    #[doc = " ::cudaDestroyExternalMemory,"]
    #[doc = " ::cudaExternalMemoryGetMappedMipmappedArray"]
    pub fn cudaExternalMemoryGetMappedBuffer(
        devPtr: *mut *mut ::libc::c_void,
        extMem: cudaExternalMemory_t,
        bufferDesc: *const cudaExternalMemoryBufferDesc,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Maps a CUDA mipmapped array onto an external memory object"]
    #[doc = ""]
    #[doc = " Maps a CUDA mipmapped array onto an external object and returns a"]
    #[doc = " handle to it in \\p mipmap."]
    #[doc = ""]
    #[doc = " The properties of the CUDA mipmapped array being mapped must be"]
    #[doc = " described in \\p mipmapDesc. The structure"]
    #[doc = " ::cudaExternalMemoryMipmappedArrayDesc is defined as follows:"]
    #[doc = ""]
    #[doc = " \\code"]
    #[doc = "typedef struct cudaExternalMemoryMipmappedArrayDesc_st {"]
    #[doc = "unsigned long long offset;"]
    #[doc = "cudaChannelFormatDesc formatDesc;"]
    #[doc = "cudaExtent extent;"]
    #[doc = "unsigned int flags;"]
    #[doc = "unsigned int numLevels;"]
    #[doc = "} cudaExternalMemoryMipmappedArrayDesc;"]
    #[doc = " \\endcode"]
    #[doc = ""]
    #[doc = " where ::cudaExternalMemoryMipmappedArrayDesc::offset is the"]
    #[doc = " offset in the memory object where the base level of the mipmap"]
    #[doc = " chain is."]
    #[doc = " ::cudaExternalMemoryMipmappedArrayDesc::formatDesc describes the"]
    #[doc = " format of the data."]
    #[doc = " ::cudaExternalMemoryMipmappedArrayDesc::extent specifies the"]
    #[doc = " dimensions of the base level of the mipmap chain."]
    #[doc = " ::cudaExternalMemoryMipmappedArrayDesc::flags are flags associated"]
    #[doc = " with CUDA mipmapped arrays. For further details, please refer to"]
    #[doc = " the documentation for ::cudaMalloc3DArray. Note that if the mipmapped"]
    #[doc = " array is bound as a color target in the graphics API, then the flag"]
    #[doc = " ::cudaArrayColorAttachment must be specified in"]
    #[doc = " ::cudaExternalMemoryMipmappedArrayDesc::flags."]
    #[doc = " ::cudaExternalMemoryMipmappedArrayDesc::numLevels specifies"]
    #[doc = " the total number of levels in the mipmap chain."]
    #[doc = ""]
    #[doc = " The returned CUDA mipmapped array must be freed using ::cudaFreeMipmappedArray."]
    #[doc = ""]
    #[doc = " \\param mipmap     - Returned CUDA mipmapped array"]
    #[doc = " \\param extMem     - Handle to external memory object"]
    #[doc = " \\param mipmapDesc - CUDA array descriptor"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaImportExternalMemory,"]
    #[doc = " ::cudaDestroyExternalMemory,"]
    #[doc = " ::cudaExternalMemoryGetMappedBuffer"]
    #[doc = ""]
    #[doc = " \\note If ::cudaExternalMemoryHandleDesc::type is"]
    #[doc = " ::cudaExternalMemoryHandleTypeNvSciBuf, then"]
    #[doc = " ::cudaExternalMemoryMipmappedArrayDesc::numLevels must not be greater than 1."]
    pub fn cudaExternalMemoryGetMappedMipmappedArray(
        mipmap: *mut cudaMipmappedArray_t,
        extMem: cudaExternalMemory_t,
        mipmapDesc: *const cudaExternalMemoryMipmappedArrayDesc,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Destroys an external memory object."]
    #[doc = ""]
    #[doc = " Destroys the specified external memory object. Any existing buffers"]
    #[doc = " and CUDA mipmapped arrays mapped onto this object must no longer be"]
    #[doc = " used and must be explicitly freed using ::cudaFree and"]
    #[doc = " ::cudaFreeMipmappedArray respectively."]
    #[doc = ""]
    #[doc = " \\param extMem - External memory object to be destroyed"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_destroy_ub"]
    #[doc = ""]
    #[doc = " \\sa ::cudaImportExternalMemory,"]
    #[doc = " ::cudaExternalMemoryGetMappedBuffer,"]
    #[doc = " ::cudaExternalMemoryGetMappedMipmappedArray"]
    pub fn cudaDestroyExternalMemory(extMem: cudaExternalMemory_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Imports an external semaphore"]
    #[doc = ""]
    #[doc = " Imports an externally allocated synchronization object and returns"]
    #[doc = " a handle to that in \\p extSem_out."]
    #[doc = ""]
    #[doc = " The properties of the handle being imported must be described in"]
    #[doc = " \\p semHandleDesc. The ::cudaExternalSemaphoreHandleDesc is defined"]
    #[doc = " as follows:"]
    #[doc = ""]
    #[doc = " \\code"]
    #[doc = "typedef struct cudaExternalSemaphoreHandleDesc_st {"]
    #[doc = "cudaExternalSemaphoreHandleType type;"]
    #[doc = "union {"]
    #[doc = "int fd;"]
    #[doc = "struct {"]
    #[doc = "void *handle;"]
    #[doc = "const void *name;"]
    #[doc = "} win32;"]
    #[doc = "const void* NvSciSyncObj;"]
    #[doc = "} handle;"]
    #[doc = "unsigned int flags;"]
    #[doc = "} cudaExternalSemaphoreHandleDesc;"]
    #[doc = " \\endcode"]
    #[doc = ""]
    #[doc = " where ::cudaExternalSemaphoreHandleDesc::type specifies the type of"]
    #[doc = " handle being imported. ::cudaExternalSemaphoreHandleType is defined"]
    #[doc = " as:"]
    #[doc = ""]
    #[doc = " \\code"]
    #[doc = "typedef enum cudaExternalSemaphoreHandleType_enum {"]
    #[doc = "cudaExternalSemaphoreHandleTypeOpaqueFd                = 1,"]
    #[doc = "cudaExternalSemaphoreHandleTypeOpaqueWin32             = 2,"]
    #[doc = "cudaExternalSemaphoreHandleTypeOpaqueWin32Kmt          = 3,"]
    #[doc = "cudaExternalSemaphoreHandleTypeD3D12Fence              = 4,"]
    #[doc = "cudaExternalSemaphoreHandleTypeD3D11Fence              = 5,"]
    #[doc = "cudaExternalSemaphoreHandleTypeNvSciSync               = 6,"]
    #[doc = "cudaExternalSemaphoreHandleTypeKeyedMutex              = 7,"]
    #[doc = "cudaExternalSemaphoreHandleTypeKeyedMutexKmt           = 8,"]
    #[doc = "cudaExternalSemaphoreHandleTypeTimelineSemaphoreFd     = 9,"]
    #[doc = "cudaExternalSemaphoreHandleTypeTimelineSemaphoreWin32  = 10"]
    #[doc = "} cudaExternalSemaphoreHandleType;"]
    #[doc = " \\endcode"]
    #[doc = ""]
    #[doc = " If ::cudaExternalSemaphoreHandleDesc::type is"]
    #[doc = " ::cudaExternalSemaphoreHandleTypeOpaqueFd, then"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::fd must be a valid file"]
    #[doc = " descriptor referencing a synchronization object. Ownership of the"]
    #[doc = " file descriptor is transferred to the CUDA driver when the handle"]
    #[doc = " is imported successfully. Performing any operations on the file"]
    #[doc = " descriptor after it is imported results in undefined behavior."]
    #[doc = ""]
    #[doc = " If ::cudaExternalSemaphoreHandleDesc::type is"]
    #[doc = " ::cudaExternalSemaphoreHandleTypeOpaqueWin32, then exactly one of"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::handle and"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::name must not be"]
    #[doc = " NULL. If ::cudaExternalSemaphoreHandleDesc::handle::win32::handle"]
    #[doc = " is not NULL, then it must represent a valid shared NT handle that"]
    #[doc = " references a synchronization object. Ownership of this handle is"]
    #[doc = " not transferred to CUDA after the import operation, so the"]
    #[doc = " application must release the handle using the appropriate system"]
    #[doc = " call. If ::cudaExternalSemaphoreHandleDesc::handle::win32::name is"]
    #[doc = " not NULL, then it must name a valid synchronization object."]
    #[doc = ""]
    #[doc = " If ::cudaExternalSemaphoreHandleDesc::type is"]
    #[doc = " ::cudaExternalSemaphoreHandleTypeOpaqueWin32Kmt, then"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::handle must be"]
    #[doc = " non-NULL and ::cudaExternalSemaphoreHandleDesc::handle::win32::name"]
    #[doc = " must be NULL. The handle specified must be a globally shared KMT"]
    #[doc = " handle. This handle does not hold a reference to the underlying"]
    #[doc = " object, and thus will be invalid when all references to the"]
    #[doc = " synchronization object are destroyed."]
    #[doc = ""]
    #[doc = " If ::cudaExternalSemaphoreHandleDesc::type is"]
    #[doc = " ::cudaExternalSemaphoreHandleTypeD3D12Fence, then exactly one of"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::handle and"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::name must not be"]
    #[doc = " NULL. If ::cudaExternalSemaphoreHandleDesc::handle::win32::handle"]
    #[doc = " is not NULL, then it must represent a valid shared NT handle that"]
    #[doc = " is returned by ID3D12Device::CreateSharedHandle when referring to a"]
    #[doc = " ID3D12Fence object. This handle holds a reference to the underlying"]
    #[doc = " object. If ::cudaExternalSemaphoreHandleDesc::handle::win32::name"]
    #[doc = " is not NULL, then it must name a valid synchronization object that"]
    #[doc = " refers to a valid ID3D12Fence object."]
    #[doc = ""]
    #[doc = " If ::cudaExternalSemaphoreHandleDesc::type is"]
    #[doc = " ::cudaExternalSemaphoreHandleTypeD3D11Fence, then exactly one of"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::handle and"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::name must not be"]
    #[doc = " NULL. If ::cudaExternalSemaphoreHandleDesc::handle::win32::handle"]
    #[doc = " is not NULL, then it must represent a valid shared NT handle that"]
    #[doc = " is returned by ID3D11Fence::CreateSharedHandle. If"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::name"]
    #[doc = " is not NULL, then it must name a valid synchronization object that"]
    #[doc = " refers to a valid ID3D11Fence object."]
    #[doc = ""]
    #[doc = " If ::cudaExternalSemaphoreHandleDesc::type is"]
    #[doc = " ::cudaExternalSemaphoreHandleTypeNvSciSync, then"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::nvSciSyncObj"]
    #[doc = " represents a valid NvSciSyncObj."]
    #[doc = ""]
    #[doc = " ::cudaExternalSemaphoreHandleTypeKeyedMutex, then exactly one of"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::handle and"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::name must not be"]
    #[doc = " NULL. If ::cudaExternalSemaphoreHandleDesc::handle::win32::handle"]
    #[doc = " is not NULL, then it represent a valid shared NT handle that"]
    #[doc = " is returned by IDXGIResource1::CreateSharedHandle when referring to"]
    #[doc = " a IDXGIKeyedMutex object."]
    #[doc = ""]
    #[doc = " If ::cudaExternalSemaphoreHandleDesc::type is"]
    #[doc = " ::cudaExternalSemaphoreHandleTypeKeyedMutexKmt, then"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::handle must be"]
    #[doc = " non-NULL and ::cudaExternalSemaphoreHandleDesc::handle::win32::name"]
    #[doc = " must be NULL. The handle specified must represent a valid KMT"]
    #[doc = " handle that is returned by IDXGIResource::GetSharedHandle when"]
    #[doc = " referring to a IDXGIKeyedMutex object."]
    #[doc = ""]
    #[doc = " If ::cudaExternalSemaphoreHandleDesc::type is"]
    #[doc = " ::cudaExternalSemaphoreHandleTypeTimelineSemaphoreFd, then"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::fd must be a valid file"]
    #[doc = " descriptor referencing a synchronization object. Ownership of the"]
    #[doc = " file descriptor is transferred to the CUDA driver when the handle"]
    #[doc = " is imported successfully. Performing any operations on the file"]
    #[doc = " descriptor after it is imported results in undefined behavior."]
    #[doc = ""]
    #[doc = " If ::cudaExternalSemaphoreHandleDesc::type is"]
    #[doc = " ::cudaExternalSemaphoreHandleTypeTimelineSemaphoreWin32, then exactly one of"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::handle and"]
    #[doc = " ::cudaExternalSemaphoreHandleDesc::handle::win32::name must not be"]
    #[doc = " NULL. If ::cudaExternalSemaphoreHandleDesc::handle::win32::handle"]
    #[doc = " is not NULL, then it must represent a valid shared NT handle that"]
    #[doc = " references a synchronization object. Ownership of this handle is"]
    #[doc = " not transferred to CUDA after the import operation, so the"]
    #[doc = " application must release the handle using the appropriate system"]
    #[doc = " call. If ::cudaExternalSemaphoreHandleDesc::handle::win32::name is"]
    #[doc = " not NULL, then it must name a valid synchronization object."]
    #[doc = ""]
    #[doc = " \\param extSem_out    - Returned handle to an external semaphore"]
    #[doc = " \\param semHandleDesc - Semaphore import handle descriptor"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDestroyExternalSemaphore,"]
    #[doc = " ::cudaSignalExternalSemaphoresAsync,"]
    #[doc = " ::cudaWaitExternalSemaphoresAsync"]
    pub fn cudaImportExternalSemaphore(
        extSem_out: *mut cudaExternalSemaphore_t,
        semHandleDesc: *const cudaExternalSemaphoreHandleDesc,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaSignalExternalSemaphoresAsync_v2(
        extSemArray: *const cudaExternalSemaphore_t,
        paramsArray: *const cudaExternalSemaphoreSignalParams,
        numExtSems: ::libc::c_uint,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaWaitExternalSemaphoresAsync_v2(
        extSemArray: *const cudaExternalSemaphore_t,
        paramsArray: *const cudaExternalSemaphoreWaitParams,
        numExtSems: ::libc::c_uint,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Destroys an external semaphore"]
    #[doc = ""]
    #[doc = " Destroys an external semaphore object and releases any references"]
    #[doc = " to the underlying resource. Any outstanding signals or waits must"]
    #[doc = " have completed before the semaphore is destroyed."]
    #[doc = ""]
    #[doc = " \\param extSem - External semaphore to be destroyed"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_destroy_ub"]
    #[doc = ""]
    #[doc = " \\sa ::cudaImportExternalSemaphore,"]
    #[doc = " ::cudaSignalExternalSemaphoresAsync,"]
    #[doc = " ::cudaWaitExternalSemaphoresAsync"]
    pub fn cudaDestroyExternalSemaphore(extSem: cudaExternalSemaphore_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Launches a device function"]
    #[doc = ""]
    #[doc = " The function invokes kernel \\p func on \\p gridDim (\\p gridDim.x &times; \\p gridDim.y"]
    #[doc = " &times; \\p gridDim.z) grid of blocks. Each block contains \\p blockDim (\\p blockDim.x &times;"]
    #[doc = " \\p blockDim.y &times; \\p blockDim.z) threads."]
    #[doc = ""]
    #[doc = " If the kernel has N parameters the \\p args should point to array of N pointers."]
    #[doc = " Each pointer, from <tt>args[0]</tt> to <tt>args[N - 1]</tt>, point to the region"]
    #[doc = " of memory from which the actual parameter will be copied."]
    #[doc = ""]
    #[doc = " For templated functions, pass the function symbol as follows:"]
    #[doc = " func_name<template_arg_0,...,template_arg_N>"]
    #[doc = ""]
    #[doc = " \\p sharedMem sets the amount of dynamic shared memory that will be available to"]
    #[doc = " each thread block."]
    #[doc = ""]
    #[doc = " \\p stream specifies a stream the invocation is associated to."]
    #[doc = ""]
    #[doc = " \\param func        - Device function symbol"]
    #[doc = " \\param gridDim     - Grid dimentions"]
    #[doc = " \\param blockDim    - Block dimentions"]
    #[doc = " \\param args        - Arguments"]
    #[doc = " \\param sharedMem   - Shared memory"]
    #[doc = " \\param stream      - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction,"]
    #[doc = " ::cudaErrorInvalidConfiguration,"]
    #[doc = " ::cudaErrorLaunchFailure,"]
    #[doc = " ::cudaErrorLaunchTimeout,"]
    #[doc = " ::cudaErrorLaunchOutOfResources,"]
    #[doc = " ::cudaErrorSharedObjectInitFailed,"]
    #[doc = " ::cudaErrorInvalidPtx,"]
    #[doc = " ::cudaErrorUnsupportedPtxVersion,"]
    #[doc = " ::cudaErrorNoKernelImageForDevice,"]
    #[doc = " ::cudaErrorJitCompilerNotFound,"]
    #[doc = " ::cudaErrorJitCompilationDisabled"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " \\ref ::cudaLaunchKernel(const T *func, dim3 gridDim, dim3 blockDim, void **args, size_t sharedMem, cudaStream_t stream) \"cudaLaunchKernel (C++ API)\","]
    #[doc = " ::cuLaunchKernel"]
    pub fn cudaLaunchKernel(
        func: *const ::libc::c_void,
        gridDim: dim3,
        blockDim: dim3,
        args: *mut *mut ::libc::c_void,
        sharedMem: usize,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Launches a device function where thread blocks can cooperate and synchronize as they execute"]
    #[doc = ""]
    #[doc = " The function invokes kernel \\p func on \\p gridDim (\\p gridDim.x &times; \\p gridDim.y"]
    #[doc = " &times; \\p gridDim.z) grid of blocks. Each block contains \\p blockDim (\\p blockDim.x &times;"]
    #[doc = " \\p blockDim.y &times; \\p blockDim.z) threads."]
    #[doc = ""]
    #[doc = " The device on which this kernel is invoked must have a non-zero value for"]
    #[doc = " the device attribute ::cudaDevAttrCooperativeLaunch."]
    #[doc = ""]
    #[doc = " The total number of blocks launched cannot exceed the maximum number of blocks per"]
    #[doc = " multiprocessor as returned by ::cudaOccupancyMaxActiveBlocksPerMultiprocessor (or"]
    #[doc = " ::cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags) times the number of multiprocessors"]
    #[doc = " as specified by the device attribute ::cudaDevAttrMultiProcessorCount."]
    #[doc = ""]
    #[doc = " The kernel cannot make use of CUDA dynamic parallelism."]
    #[doc = ""]
    #[doc = " If the kernel has N parameters the \\p args should point to array of N pointers."]
    #[doc = " Each pointer, from <tt>args[0]</tt> to <tt>args[N - 1]</tt>, point to the region"]
    #[doc = " of memory from which the actual parameter will be copied."]
    #[doc = ""]
    #[doc = " For templated functions, pass the function symbol as follows:"]
    #[doc = " func_name<template_arg_0,...,template_arg_N>"]
    #[doc = ""]
    #[doc = " \\p sharedMem sets the amount of dynamic shared memory that will be available to"]
    #[doc = " each thread block."]
    #[doc = ""]
    #[doc = " \\p stream specifies a stream the invocation is associated to."]
    #[doc = ""]
    #[doc = " \\param func        - Device function symbol"]
    #[doc = " \\param gridDim     - Grid dimentions"]
    #[doc = " \\param blockDim    - Block dimentions"]
    #[doc = " \\param args        - Arguments"]
    #[doc = " \\param sharedMem   - Shared memory"]
    #[doc = " \\param stream      - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction,"]
    #[doc = " ::cudaErrorInvalidConfiguration,"]
    #[doc = " ::cudaErrorLaunchFailure,"]
    #[doc = " ::cudaErrorLaunchTimeout,"]
    #[doc = " ::cudaErrorLaunchOutOfResources,"]
    #[doc = " ::cudaErrorCooperativeLaunchTooLarge,"]
    #[doc = " ::cudaErrorSharedObjectInitFailed"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " \\ref ::cudaLaunchCooperativeKernel(const T *func, dim3 gridDim, dim3 blockDim, void **args, size_t sharedMem, cudaStream_t stream) \"cudaLaunchCooperativeKernel (C++ API)\","]
    #[doc = " ::cudaLaunchCooperativeKernelMultiDevice,"]
    #[doc = " ::cuLaunchCooperativeKernel"]
    pub fn cudaLaunchCooperativeKernel(
        func: *const ::libc::c_void,
        gridDim: dim3,
        blockDim: dim3,
        args: *mut *mut ::libc::c_void,
        sharedMem: usize,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Launches device functions on multiple devices where thread blocks can cooperate and synchronize as they execute"]
    #[doc = ""]
    #[doc = " \\deprecated This function is deprecated as of CUDA 11.3."]
    #[doc = ""]
    #[doc = " Invokes kernels as specified in the \\p launchParamsList array where each element"]
    #[doc = " of the array specifies all the parameters required to perform a single kernel launch."]
    #[doc = " These kernels can cooperate and synchronize as they execute. The size of the array is"]
    #[doc = " specified by \\p numDevices."]
    #[doc = ""]
    #[doc = " No two kernels can be launched on the same device. All the devices targeted by this"]
    #[doc = " multi-device launch must be identical. All devices must have a non-zero value for the"]
    #[doc = " device attribute ::cudaDevAttrCooperativeMultiDeviceLaunch."]
    #[doc = ""]
    #[doc = " The same kernel must be launched on all devices. Note that any __device__ or __constant__"]
    #[doc = " variables are independently instantiated on every device. It is the application's"]
    #[doc = " responsiblity to ensure these variables are initialized and used appropriately."]
    #[doc = ""]
    #[doc = " The size of the grids as specified in blocks, the size of the blocks themselves and the"]
    #[doc = " amount of shared memory used by each thread block must also match across all launched kernels."]
    #[doc = ""]
    #[doc = " The streams used to launch these kernels must have been created via either ::cudaStreamCreate"]
    #[doc = " or ::cudaStreamCreateWithPriority or ::cudaStreamCreateWithPriority. The NULL stream or"]
    #[doc = " ::cudaStreamLegacy or ::cudaStreamPerThread cannot be used."]
    #[doc = ""]
    #[doc = " The total number of blocks launched per kernel cannot exceed the maximum number of blocks"]
    #[doc = " per multiprocessor as returned by ::cudaOccupancyMaxActiveBlocksPerMultiprocessor (or"]
    #[doc = " ::cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags) times the number of multiprocessors"]
    #[doc = " as specified by the device attribute ::cudaDevAttrMultiProcessorCount. Since the"]
    #[doc = " total number of blocks launched per device has to match across all devices, the maximum"]
    #[doc = " number of blocks that can be launched per device will be limited by the device with the"]
    #[doc = " least number of multiprocessors."]
    #[doc = ""]
    #[doc = " The kernel cannot make use of CUDA dynamic parallelism."]
    #[doc = ""]
    #[doc = " The ::cudaLaunchParams structure is defined as:"]
    #[doc = " \\code"]
    #[doc = "struct cudaLaunchParams"]
    #[doc = "{"]
    #[doc = "void *func;"]
    #[doc = "dim3 gridDim;"]
    #[doc = "dim3 blockDim;"]
    #[doc = "void **args;"]
    #[doc = "size_t sharedMem;"]
    #[doc = "cudaStream_t stream;"]
    #[doc = "};"]
    #[doc = " \\endcode"]
    #[doc = " where:"]
    #[doc = " - ::cudaLaunchParams::func specifies the kernel to be launched. This same functions must"]
    #[doc = "   be launched on all devices. For templated functions, pass the function symbol as follows:"]
    #[doc = "   func_name<template_arg_0,...,template_arg_N>"]
    #[doc = " - ::cudaLaunchParams::gridDim specifies the width, height and depth of the grid in blocks."]
    #[doc = "   This must match across all kernels launched."]
    #[doc = " - ::cudaLaunchParams::blockDim is the width, height and depth of each thread block. This"]
    #[doc = "   must match across all kernels launched."]
    #[doc = " - ::cudaLaunchParams::args specifies the arguments to the kernel. If the kernel has"]
    #[doc = "   N parameters then ::cudaLaunchParams::args should point to array of N pointers. Each"]
    #[doc = "   pointer, from <tt>::cudaLaunchParams::args[0]</tt> to <tt>::cudaLaunchParams::args[N - 1]</tt>,"]
    #[doc = "   point to the region of memory from which the actual parameter will be copied."]
    #[doc = " - ::cudaLaunchParams::sharedMem is the dynamic shared-memory size per thread block in bytes."]
    #[doc = "   This must match across all kernels launched."]
    #[doc = " - ::cudaLaunchParams::stream is the handle to the stream to perform the launch in. This cannot"]
    #[doc = "   be the NULL stream or ::cudaStreamLegacy or ::cudaStreamPerThread."]
    #[doc = ""]
    #[doc = " By default, the kernel won't begin execution on any GPU until all prior work in all the specified"]
    #[doc = " streams has completed. This behavior can be overridden by specifying the flag"]
    #[doc = " ::cudaCooperativeLaunchMultiDeviceNoPreSync. When this flag is specified, each kernel"]
    #[doc = " will only wait for prior work in the stream corresponding to that GPU to complete before it begins"]
    #[doc = " execution."]
    #[doc = ""]
    #[doc = " Similarly, by default, any subsequent work pushed in any of the specified streams will not begin"]
    #[doc = " execution until the kernels on all GPUs have completed. This behavior can be overridden by specifying"]
    #[doc = " the flag ::cudaCooperativeLaunchMultiDeviceNoPostSync. When this flag is specified,"]
    #[doc = " any subsequent work pushed in any of the specified streams will only wait for the kernel launched"]
    #[doc = " on the GPU corresponding to that stream to complete before it begins execution."]
    #[doc = ""]
    #[doc = " \\param launchParamsList - List of launch parameters, one per device"]
    #[doc = " \\param numDevices       - Size of the \\p launchParamsList array"]
    #[doc = " \\param flags            - Flags to control launch behavior"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction,"]
    #[doc = " ::cudaErrorInvalidConfiguration,"]
    #[doc = " ::cudaErrorLaunchFailure,"]
    #[doc = " ::cudaErrorLaunchTimeout,"]
    #[doc = " ::cudaErrorLaunchOutOfResources,"]
    #[doc = " ::cudaErrorCooperativeLaunchTooLarge,"]
    #[doc = " ::cudaErrorSharedObjectInitFailed"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " \\ref ::cudaLaunchCooperativeKernel(const T *func, dim3 gridDim, dim3 blockDim, void **args, size_t sharedMem, cudaStream_t stream) \"cudaLaunchCooperativeKernel (C++ API)\","]
    #[doc = " ::cudaLaunchCooperativeKernel,"]
    #[doc = " ::cuLaunchCooperativeKernelMultiDevice"]
    pub fn cudaLaunchCooperativeKernelMultiDevice(
        launchParamsList: *mut cudaLaunchParams,
        numDevices: ::libc::c_uint,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets the preferred cache configuration for a device function"]
    #[doc = ""]
    #[doc = " On devices where the L1 cache and shared memory use the same hardware"]
    #[doc = " resources, this sets through \\p cacheConfig the preferred cache configuration"]
    #[doc = " for the function specified via \\p func. This is only a preference. The"]
    #[doc = " runtime will use the requested configuration if possible, but it is free to"]
    #[doc = " choose a different configuration if required to execute \\p func."]
    #[doc = ""]
    #[doc = " \\p func is a device function symbol and must be declared as a"]
    #[doc = " \\c __global__ function. If the specified function does not exist,"]
    #[doc = " then ::cudaErrorInvalidDeviceFunction is returned. For templated functions,"]
    #[doc = " pass the function symbol as follows: func_name<template_arg_0,...,template_arg_N>"]
    #[doc = ""]
    #[doc = " This setting does nothing on devices where the size of the L1 cache and"]
    #[doc = " shared memory are fixed."]
    #[doc = ""]
    #[doc = " Launching a kernel with a different preference than the most recent"]
    #[doc = " preference setting may insert a device-side synchronization point."]
    #[doc = ""]
    #[doc = " The supported cache configurations are:"]
    #[doc = " - ::cudaFuncCachePreferNone: no preference for shared memory or L1 (default)"]
    #[doc = " - ::cudaFuncCachePreferShared: prefer larger shared memory and smaller L1 cache"]
    #[doc = " - ::cudaFuncCachePreferL1: prefer larger L1 cache and smaller shared memory"]
    #[doc = " - ::cudaFuncCachePreferEqual: prefer equal size L1 cache and shared memory"]
    #[doc = ""]
    #[doc = " \\param func        - Device function symbol"]
    #[doc = " \\param cacheConfig - Requested cache configuration"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_string_api_deprecation2"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(T*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C++ API)\","]
    #[doc = " \\ref ::cudaFuncGetAttributes(struct cudaFuncAttributes*, const void*) \"cudaFuncGetAttributes (C API)\","]
    #[doc = " \\ref ::cudaLaunchKernel(const void *func, dim3 gridDim, dim3 blockDim, void **args, size_t sharedMem, cudaStream_t stream) \"cudaLaunchKernel (C API)\","]
    #[doc = " ::cudaThreadGetCacheConfig,"]
    #[doc = " ::cudaThreadSetCacheConfig,"]
    #[doc = " ::cuFuncSetCacheConfig"]
    pub fn cudaFuncSetCacheConfig(
        func: *const ::libc::c_void,
        cacheConfig: cudaFuncCache,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets the shared memory configuration for a device function"]
    #[doc = ""]
    #[doc = " On devices with configurable shared memory banks, this function will"]
    #[doc = " force all subsequent launches of the specified device function to have"]
    #[doc = " the given shared memory bank size configuration. On any given launch of the"]
    #[doc = " function, the shared memory configuration of the device will be temporarily"]
    #[doc = " changed if needed to suit the function's preferred configuration. Changes in"]
    #[doc = " shared memory configuration between subsequent launches of functions,"]
    #[doc = " may introduce a device side synchronization point."]
    #[doc = ""]
    #[doc = " Any per-function setting of shared memory bank size set via"]
    #[doc = " ::cudaFuncSetSharedMemConfig will override the device wide setting set by"]
    #[doc = " ::cudaDeviceSetSharedMemConfig."]
    #[doc = ""]
    #[doc = " Changing the shared memory bank size will not increase shared memory usage"]
    #[doc = " or affect occupancy of kernels, but may have major effects on performance."]
    #[doc = " Larger bank sizes will allow for greater potential bandwidth to shared memory,"]
    #[doc = " but will change what kinds of accesses to shared memory will result in bank"]
    #[doc = " conflicts."]
    #[doc = ""]
    #[doc = " This function will do nothing on devices with fixed shared memory bank size."]
    #[doc = ""]
    #[doc = " For templated functions, pass the function symbol as follows:"]
    #[doc = " func_name<template_arg_0,...,template_arg_N>"]
    #[doc = ""]
    #[doc = " The supported bank configurations are:"]
    #[doc = " - ::cudaSharedMemBankSizeDefault: use the device's shared memory configuration"]
    #[doc = "   when launching this function."]
    #[doc = " - ::cudaSharedMemBankSizeFourByte: set shared memory bank width to be"]
    #[doc = "   four bytes natively when launching this function."]
    #[doc = " - ::cudaSharedMemBankSizeEightByte: set shared memory bank width to be eight"]
    #[doc = "   bytes natively when launching this function."]
    #[doc = ""]
    #[doc = " \\param func   - Device function symbol"]
    #[doc = " \\param config - Requested shared memory configuration"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_string_api_deprecation2"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceSetSharedMemConfig,"]
    #[doc = " ::cudaDeviceGetSharedMemConfig,"]
    #[doc = " ::cudaDeviceSetCacheConfig,"]
    #[doc = " ::cudaDeviceGetCacheConfig,"]
    #[doc = " ::cudaFuncSetCacheConfig,"]
    #[doc = " ::cuFuncSetSharedMemConfig"]
    pub fn cudaFuncSetSharedMemConfig(
        func: *const ::libc::c_void,
        config: cudaSharedMemConfig,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Find out attributes for a given function"]
    #[doc = ""]
    #[doc = " This function obtains the attributes of a function specified via \\p func."]
    #[doc = " \\p func is a device function symbol and must be declared as a"]
    #[doc = " \\c __global__ function. The fetched attributes are placed in \\p attr."]
    #[doc = " If the specified function does not exist, then"]
    #[doc = " ::cudaErrorInvalidDeviceFunction is returned. For templated functions, pass"]
    #[doc = " the function symbol as follows: func_name<template_arg_0,...,template_arg_N>"]
    #[doc = ""]
    #[doc = " Note that some function attributes such as"]
    #[doc = " \\ref ::cudaFuncAttributes::maxThreadsPerBlock \"maxThreadsPerBlock\""]
    #[doc = " may vary based on the device that is currently being used."]
    #[doc = ""]
    #[doc = " \\param attr - Return pointer to function's attributes"]
    #[doc = " \\param func - Device function symbol"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_string_api_deprecation2"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(const void*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C API)\","]
    #[doc = " \\ref ::cudaFuncGetAttributes(struct cudaFuncAttributes*, T*) \"cudaFuncGetAttributes (C++ API)\","]
    #[doc = " \\ref ::cudaLaunchKernel(const void *func, dim3 gridDim, dim3 blockDim, void **args, size_t sharedMem, cudaStream_t stream) \"cudaLaunchKernel (C API)\","]
    #[doc = " ::cuFuncGetAttribute"]
    pub fn cudaFuncGetAttributes(
        attr: *mut cudaFuncAttributes,
        func: *const ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Set attributes for a given function"]
    #[doc = ""]
    #[doc = " This function sets the attributes of a function specified via \\p func."]
    #[doc = " The parameter \\p func must be a pointer to a function that executes"]
    #[doc = " on the device. The parameter specified by \\p func must be declared as a \\p __global__"]
    #[doc = " function. The enumeration defined by \\p attr is set to the value defined by \\p value."]
    #[doc = " If the specified function does not exist, then ::cudaErrorInvalidDeviceFunction is returned."]
    #[doc = " If the specified attribute cannot be written, or if the value is incorrect,"]
    #[doc = " then ::cudaErrorInvalidValue is returned."]
    #[doc = ""]
    #[doc = " Valid values for \\p attr are:"]
    #[doc = " - ::cudaFuncAttributeMaxDynamicSharedMemorySize - The requested maximum size in bytes of dynamically-allocated shared memory. The sum of this value and the function attribute ::sharedSizeBytes"]
    #[doc = "   cannot exceed the device attribute ::cudaDevAttrMaxSharedMemoryPerBlockOptin. The maximal size of requestable dynamic shared memory may differ by GPU architecture."]
    #[doc = " - ::cudaFuncAttributePreferredSharedMemoryCarveout - On devices where the L1 cache and shared memory use the same hardware resources,"]
    #[doc = "   this sets the shared memory carveout preference, in percent of the total shared memory. See ::cudaDevAttrMaxSharedMemoryPerMultiprocessor."]
    #[doc = "   This is only a hint, and the driver can choose a different ratio if required to execute the function."]
    #[doc = ""]
    #[doc = " \\param func  - Function to get attributes of"]
    #[doc = " \\param attr  - Attribute to set"]
    #[doc = " \\param value - Value to set"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\ref ::cudaLaunchKernel(const T *func, dim3 gridDim, dim3 blockDim, void **args, size_t sharedMem, cudaStream_t stream) \"cudaLaunchKernel (C++ API)\","]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(T*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C++ API)\","]
    #[doc = " \\ref ::cudaFuncGetAttributes(struct cudaFuncAttributes*, const void*) \"cudaFuncGetAttributes (C API)\","]
    pub fn cudaFuncSetAttribute(
        func: *const ::libc::c_void,
        attr: cudaFuncAttribute,
        value: ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Converts a double argument to be executed on a device"]
    #[doc = ""]
    #[doc = " \\param d - Double to convert"]
    #[doc = ""]
    #[doc = " \\deprecated This function is deprecated as of CUDA 7.5"]
    #[doc = ""]
    #[doc = " Converts the double value of \\p d to an internal float representation if"]
    #[doc = " the device does not support double arithmetic. If the device does natively"]
    #[doc = " support doubles, then this function does nothing."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(const void*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C API)\","]
    #[doc = " \\ref ::cudaFuncGetAttributes(struct cudaFuncAttributes*, const void*) \"cudaFuncGetAttributes (C API)\","]
    #[doc = " ::cudaSetDoubleForHost"]
    pub fn cudaSetDoubleForDevice(d: *mut f64) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Converts a double argument after execution on a device"]
    #[doc = ""]
    #[doc = " \\deprecated This function is deprecated as of CUDA 7.5"]
    #[doc = ""]
    #[doc = " Converts the double value of \\p d from a potentially internal float"]
    #[doc = " representation if the device does not support double arithmetic. If the"]
    #[doc = " device does natively support doubles, then this function does nothing."]
    #[doc = ""]
    #[doc = " \\param d - Double to convert"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " \\ref ::cudaFuncSetCacheConfig(const void*, enum cudaFuncCache) \"cudaFuncSetCacheConfig (C API)\","]
    #[doc = " \\ref ::cudaFuncGetAttributes(struct cudaFuncAttributes*, const void*) \"cudaFuncGetAttributes (C API)\","]
    #[doc = " ::cudaSetDoubleForDevice"]
    pub fn cudaSetDoubleForHost(d: *mut f64) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Enqueues a host function call in a stream"]
    #[doc = ""]
    #[doc = " Enqueues a host function to run in a stream.  The function will be called"]
    #[doc = " after currently enqueued work and will block work added after it."]
    #[doc = ""]
    #[doc = " The host function must not make any CUDA API calls.  Attempting to use a"]
    #[doc = " CUDA API may result in ::cudaErrorNotPermitted, but this is not required."]
    #[doc = " The host function must not perform any synchronization that may depend on"]
    #[doc = " outstanding CUDA work not mandated to run earlier.  Host functions without a"]
    #[doc = " mandated order (such as in independent streams) execute in undefined order"]
    #[doc = " and may be serialized."]
    #[doc = ""]
    #[doc = " For the purposes of Unified Memory, execution makes a number of guarantees:"]
    #[doc = " <ul>"]
    #[doc = "   <li>The stream is considered idle for the duration of the function's"]
    #[doc = "   execution.  Thus, for example, the function may always use memory attached"]
    #[doc = "   to the stream it was enqueued in.</li>"]
    #[doc = "   <li>The start of execution of the function has the same effect as"]
    #[doc = "   synchronizing an event recorded in the same stream immediately prior to"]
    #[doc = "   the function.  It thus synchronizes streams which have been \"joined\""]
    #[doc = "   prior to the function.</li>"]
    #[doc = "   <li>Adding device work to any stream does not have the effect of making"]
    #[doc = "   the stream active until all preceding host functions and stream callbacks"]
    #[doc = "   have executed.  Thus, for"]
    #[doc = "   example, a function might use global attached memory even if work has"]
    #[doc = "   been added to another stream, if the work has been ordered behind the"]
    #[doc = "   function call with an event.</li>"]
    #[doc = "   <li>Completion of the function does not cause a stream to become"]
    #[doc = "   active except as described above.  The stream will remain idle"]
    #[doc = "   if no device work follows the function, and will remain idle across"]
    #[doc = "   consecutive host functions or stream callbacks without device work in"]
    #[doc = "   between.  Thus, for example,"]
    #[doc = "   stream synchronization can be done by signaling from a host function at the"]
    #[doc = "   end of the stream.</li>"]
    #[doc = " </ul>"]
    #[doc = ""]
    #[doc = " Note that, in constrast to ::cuStreamAddCallback, the function will not be"]
    #[doc = " called in the event of an error in the CUDA context."]
    #[doc = ""]
    #[doc = " \\param hStream  - Stream to enqueue function call in"]
    #[doc = " \\param fn       - The function to call once preceding stream operations are complete"]
    #[doc = " \\param userData - User-specified data to be passed to the function"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorNotSupported"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaStreamCreate,"]
    #[doc = " ::cudaStreamQuery,"]
    #[doc = " ::cudaStreamSynchronize,"]
    #[doc = " ::cudaStreamWaitEvent,"]
    #[doc = " ::cudaStreamDestroy,"]
    #[doc = " ::cudaMallocManaged,"]
    #[doc = " ::cudaStreamAttachMemAsync,"]
    #[doc = " ::cudaStreamAddCallback,"]
    #[doc = " ::cuLaunchHostFunc"]
    pub fn cudaLaunchHostFunc(
        stream: cudaStream_t,
        fn_: cudaHostFn_t,
        userData: *mut ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns occupancy for a device function"]
    #[doc = ""]
    #[doc = " Returns in \\p *numBlocks the maximum number of active blocks per"]
    #[doc = " streaming multiprocessor for the device function."]
    #[doc = ""]
    #[doc = " \\param numBlocks       - Returned occupancy"]
    #[doc = " \\param func            - Kernel function for which occupancy is calculated"]
    #[doc = " \\param blockSize       - Block size the kernel is intended to be launched with"]
    #[doc = " \\param dynamicSMemSize - Per-block dynamic shared memory usage intended, in bytes"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDevice,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorUnknown,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags,"]
    #[doc = " \\ref ::cudaOccupancyMaxPotentialBlockSize(int*, int*, T, size_t, int) \"cudaOccupancyMaxPotentialBlockSize (C++ API)\","]
    #[doc = " \\ref ::cudaOccupancyMaxPotentialBlockSizeWithFlags(int*, int*, T, size_t, int, unsigned int) \"cudaOccupancyMaxPotentialBlockSizeWithFlags (C++ API)\","]
    #[doc = " \\ref ::cudaOccupancyMaxPotentialBlockSizeVariableSMem(int*, int*, T, UnaryFunction, int) \"cudaOccupancyMaxPotentialBlockSizeVariableSMem (C++ API)\","]
    #[doc = " \\ref ::cudaOccupancyMaxPotentialBlockSizeVariableSMemWithFlags(int*, int*, T, UnaryFunction, int, unsigned int) \"cudaOccupancyMaxPotentialBlockSizeVariableSMemWithFlags (C++ API)\","]
    #[doc = " \\ref ::cudaOccupancyAvailableDynamicSMemPerBlock(size_t*, T, int, int) \"cudaOccupancyAvailableDynamicSMemPerBlock (C++ API)\","]
    #[doc = " ::cuOccupancyMaxActiveBlocksPerMultiprocessor"]
    pub fn cudaOccupancyMaxActiveBlocksPerMultiprocessor(
        numBlocks: *mut ::libc::c_int,
        func: *const ::libc::c_void,
        blockSize: ::libc::c_int,
        dynamicSMemSize: usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns dynamic shared memory available per block when launching \\p numBlocks blocks on SM."]
    #[doc = ""]
    #[doc = " Returns in \\p *dynamicSmemSize the maximum size of dynamic shared memory to allow \\p numBlocks blocks per SM."]
    #[doc = ""]
    #[doc = " \\param dynamicSmemSize - Returned maximum dynamic shared memory"]
    #[doc = " \\param func            - Kernel function for which occupancy is calculated"]
    #[doc = " \\param numBlocks       - Number of blocks to fit on SM"]
    #[doc = " \\param blockSize       - Size of the block"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDevice,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorUnknown,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags,"]
    #[doc = " \\ref ::cudaOccupancyMaxPotentialBlockSize(int*, int*, T, size_t, int) \"cudaOccupancyMaxPotentialBlockSize (C++ API)\","]
    #[doc = " \\ref ::cudaOccupancyMaxPotentialBlockSizeWithFlags(int*, int*, T, size_t, int, unsigned int) \"cudaOccupancyMaxPotentialBlockSizeWithFlags (C++ API)\","]
    #[doc = " \\ref ::cudaOccupancyMaxPotentialBlockSizeVariableSMem(int*, int*, T, UnaryFunction, int) \"cudaOccupancyMaxPotentialBlockSizeVariableSMem (C++ API)\","]
    #[doc = " \\ref ::cudaOccupancyMaxPotentialBlockSizeVariableSMemWithFlags(int*, int*, T, UnaryFunction, int, unsigned int) \"cudaOccupancyMaxPotentialBlockSizeVariableSMemWithFlags (C++ API)\","]
    #[doc = " ::cudaOccupancyAvailableDynamicSMemPerBlock"]
    pub fn cudaOccupancyAvailableDynamicSMemPerBlock(
        dynamicSmemSize: *mut usize,
        func: *const ::libc::c_void,
        numBlocks: ::libc::c_int,
        blockSize: ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns occupancy for a device function with the specified flags"]
    #[doc = ""]
    #[doc = " Returns in \\p *numBlocks the maximum number of active blocks per"]
    #[doc = " streaming multiprocessor for the device function."]
    #[doc = ""]
    #[doc = " The \\p flags parameter controls how special cases are handled. Valid flags include:"]
    #[doc = ""]
    #[doc = " - ::cudaOccupancyDefault: keeps the default behavior as"]
    #[doc = "   ::cudaOccupancyMaxActiveBlocksPerMultiprocessor"]
    #[doc = ""]
    #[doc = " - ::cudaOccupancyDisableCachingOverride: This flag suppresses the default behavior"]
    #[doc = "   on platform where global caching affects occupancy. On such platforms, if caching"]
    #[doc = "   is enabled, but per-block SM resource usage would result in zero occupancy, the"]
    #[doc = "   occupancy calculator will calculate the occupancy as if caching is disabled."]
    #[doc = "   Setting this flag makes the occupancy calculator to return 0 in such cases."]
    #[doc = "   More information can be found about this feature in the \"Unified L1/Texture Cache\""]
    #[doc = "   section of the Maxwell tuning guide."]
    #[doc = ""]
    #[doc = " \\param numBlocks       - Returned occupancy"]
    #[doc = " \\param func            - Kernel function for which occupancy is calculated"]
    #[doc = " \\param blockSize       - Block size the kernel is intended to be launched with"]
    #[doc = " \\param dynamicSMemSize - Per-block dynamic shared memory usage intended, in bytes"]
    #[doc = " \\param flags           - Requested behavior for the occupancy calculator"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDevice,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorUnknown,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaOccupancyMaxActiveBlocksPerMultiprocessor,"]
    #[doc = " \\ref ::cudaOccupancyMaxPotentialBlockSize(int*, int*, T, size_t, int) \"cudaOccupancyMaxPotentialBlockSize (C++ API)\","]
    #[doc = " \\ref ::cudaOccupancyMaxPotentialBlockSizeWithFlags(int*, int*, T, size_t, int, unsigned int) \"cudaOccupancyMaxPotentialBlockSizeWithFlags (C++ API)\","]
    #[doc = " \\ref ::cudaOccupancyMaxPotentialBlockSizeVariableSMem(int*, int*, T, UnaryFunction, int) \"cudaOccupancyMaxPotentialBlockSizeVariableSMem (C++ API)\","]
    #[doc = " \\ref ::cudaOccupancyMaxPotentialBlockSizeVariableSMemWithFlags(int*, int*, T, UnaryFunction, int, unsigned int) \"cudaOccupancyMaxPotentialBlockSizeVariableSMemWithFlags (C++ API)\","]
    #[doc = " \\ref ::cudaOccupancyAvailableDynamicSMemPerBlock(size_t*, T, int, int) \"cudaOccupancyAvailableDynamicSMemPerBlock (C++ API)\","]
    #[doc = " ::cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags"]
    pub fn cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags(
        numBlocks: *mut ::libc::c_int,
        func: *const ::libc::c_void,
        blockSize: ::libc::c_int,
        dynamicSMemSize: usize,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaMallocManaged(
        devPtr: *mut *mut ::libc::c_void,
        size: usize,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Allocate memory on the device"]
    #[doc = ""]
    #[doc = " Allocates \\p size bytes of linear memory on the device and returns in"]
    #[doc = " \\p *devPtr a pointer to the allocated memory. The allocated memory is"]
    #[doc = " suitably aligned for any kind of variable. The memory is not cleared."]
    #[doc = " ::cudaMalloc() returns ::cudaErrorMemoryAllocation in case of failure."]
    #[doc = ""]
    #[doc = " The device version of ::cudaFree cannot be used with a \\p *devPtr"]
    #[doc = " allocated using the host API, and vice versa."]
    #[doc = ""]
    #[doc = " \\param devPtr - Pointer to allocated device memory"]
    #[doc = " \\param size   - Requested allocation size in bytes"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMallocPitch, ::cudaFree, ::cudaMallocArray, ::cudaFreeArray,"]
    #[doc = " ::cudaMalloc3D, ::cudaMalloc3DArray,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t) \"cudaMallocHost (C API)\","]
    #[doc = " ::cudaFreeHost, ::cudaHostAlloc,"]
    #[doc = " ::cuMemAlloc"]
    pub fn cudaMalloc(devPtr: *mut *mut ::libc::c_void, size: usize) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Allocates page-locked memory on the host"]
    #[doc = ""]
    #[doc = " Allocates \\p size bytes of host memory that is page-locked and accessible"]
    #[doc = " to the device. The driver tracks the virtual memory ranges allocated with"]
    #[doc = " this function and automatically accelerates calls to functions such as"]
    #[doc = " ::cudaMemcpy*(). Since the memory can be accessed directly by the device,"]
    #[doc = " it can be read or written with much higher bandwidth than pageable memory"]
    #[doc = " obtained with functions such as ::malloc(). Allocating excessive amounts of"]
    #[doc = " memory with ::cudaMallocHost() may degrade system performance, since it"]
    #[doc = " reduces the amount of memory available to the system for paging. As a"]
    #[doc = " result, this function is best used sparingly to allocate staging areas for"]
    #[doc = " data exchange between host and device."]
    #[doc = ""]
    #[doc = " \\param ptr  - Pointer to allocated host memory"]
    #[doc = " \\param size - Requested allocation size in bytes"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMalloc, ::cudaMallocPitch, ::cudaMallocArray, ::cudaMalloc3D,"]
    #[doc = " ::cudaMalloc3DArray, ::cudaHostAlloc, ::cudaFree, ::cudaFreeArray,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t, unsigned int) \"cudaMallocHost (C++ API)\","]
    #[doc = " ::cudaFreeHost, ::cudaHostAlloc,"]
    #[doc = " ::cuMemAllocHost"]
    pub fn cudaMallocHost(ptr: *mut *mut ::libc::c_void, size: usize) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Allocates pitched memory on the device"]
    #[doc = ""]
    #[doc = " Allocates at least \\p width (in bytes) * \\p height bytes of linear memory"]
    #[doc = " on the device and returns in \\p *devPtr a pointer to the allocated memory."]
    #[doc = " The function may pad the allocation to ensure that corresponding pointers"]
    #[doc = " in any given row will continue to meet the alignment requirements for"]
    #[doc = " coalescing as the address is updated from row to row. The pitch returned in"]
    #[doc = " \\p *pitch by ::cudaMallocPitch() is the width in bytes of the allocation."]
    #[doc = " The intended usage of \\p pitch is as a separate parameter of the allocation,"]
    #[doc = " used to compute addresses within the 2D array. Given the row and column of"]
    #[doc = " an array element of type \\p T, the address is computed as:"]
    #[doc = " \\code"]
    #[doc = "T* pElement = (T*)((char*)BaseAddress + Row * pitch) + Column;"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = " For allocations of 2D arrays, it is recommended that programmers consider"]
    #[doc = " performing pitch allocations using ::cudaMallocPitch(). Due to pitch"]
    #[doc = " alignment restrictions in the hardware, this is especially true if the"]
    #[doc = " application will be performing 2D memory copies between different regions"]
    #[doc = " of device memory (whether linear memory or CUDA arrays)."]
    #[doc = ""]
    #[doc = " \\param devPtr - Pointer to allocated pitched device memory"]
    #[doc = " \\param pitch  - Pitch for allocation"]
    #[doc = " \\param width  - Requested pitched allocation width (in bytes)"]
    #[doc = " \\param height - Requested pitched allocation height"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMalloc, ::cudaFree, ::cudaMallocArray, ::cudaFreeArray,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t) \"cudaMallocHost (C API)\","]
    #[doc = " ::cudaFreeHost, ::cudaMalloc3D, ::cudaMalloc3DArray,"]
    #[doc = " ::cudaHostAlloc,"]
    #[doc = " ::cuMemAllocPitch"]
    pub fn cudaMallocPitch(
        devPtr: *mut *mut ::libc::c_void,
        pitch: *mut usize,
        width: usize,
        height: usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Allocate an array on the device"]
    #[doc = ""]
    #[doc = " Allocates a CUDA array according to the ::cudaChannelFormatDesc structure"]
    #[doc = " \\p desc and returns a handle to the new CUDA array in \\p *array."]
    #[doc = ""]
    #[doc = " The ::cudaChannelFormatDesc is defined as:"]
    #[doc = " \\code"]
    #[doc = "struct cudaChannelFormatDesc {"]
    #[doc = "int x, y, z, w;"]
    #[doc = "enum cudaChannelFormatKind f;"]
    #[doc = "};"]
    #[doc = "\\endcode"]
    #[doc = " where ::cudaChannelFormatKind is one of ::cudaChannelFormatKindSigned,"]
    #[doc = " ::cudaChannelFormatKindUnsigned, or ::cudaChannelFormatKindFloat."]
    #[doc = ""]
    #[doc = " The \\p flags parameter enables different options to be specified that affect"]
    #[doc = " the allocation, as follows."]
    #[doc = " - ::cudaArrayDefault: This flag's value is defined to be 0 and provides default array allocation"]
    #[doc = " - ::cudaArraySurfaceLoadStore: Allocates an array that can be read from or written to using a surface reference"]
    #[doc = " - ::cudaArrayTextureGather: This flag indicates that texture gather operations will be performed on the array."]
    #[doc = " - ::cudaArraySparse: Allocates a CUDA array without physical backing memory. The subregions within this sparse array"]
    #[doc = "   can later be mapped to physical memory by calling ::cuMemMapArrayAsync. The physical backing memory must be allocated"]
    #[doc = "   via ::cuMemCreate."]
    #[doc = ""]
    #[doc = " \\p width and \\p height must meet certain size requirements. See ::cudaMalloc3DArray() for more details."]
    #[doc = ""]
    #[doc = " \\param array  - Pointer to allocated array in device memory"]
    #[doc = " \\param desc   - Requested channel format"]
    #[doc = " \\param width  - Requested array allocation width"]
    #[doc = " \\param height - Requested array allocation height"]
    #[doc = " \\param flags  - Requested properties of allocated array"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMalloc, ::cudaMallocPitch, ::cudaFree, ::cudaFreeArray,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t) \"cudaMallocHost (C API)\","]
    #[doc = " ::cudaFreeHost, ::cudaMalloc3D, ::cudaMalloc3DArray,"]
    #[doc = " ::cudaHostAlloc,"]
    #[doc = " ::cuArrayCreate"]
    pub fn cudaMallocArray(
        array: *mut cudaArray_t,
        desc: *const cudaChannelFormatDesc,
        width: usize,
        height: usize,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Frees memory on the device"]
    #[doc = ""]
    #[doc = " Frees the memory space pointed to by \\p devPtr, which must have been"]
    #[doc = " returned by a previous call to ::cudaMalloc() or ::cudaMallocPitch()."]
    #[doc = " Otherwise, or if ::cudaFree(\\p devPtr) has already been called before,"]
    #[doc = " an error is returned. If \\p devPtr is 0, no operation is performed."]
    #[doc = " ::cudaFree() returns ::cudaErrorValue in case of failure."]
    #[doc = ""]
    #[doc = " The device version of ::cudaFree cannot be used with a \\p *devPtr"]
    #[doc = " allocated using the host API, and vice versa."]
    #[doc = ""]
    #[doc = " \\param devPtr - Device pointer to memory to free"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMalloc, ::cudaMallocPitch, ::cudaMallocArray, ::cudaFreeArray,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t) \"cudaMallocHost (C API)\","]
    #[doc = " ::cudaFreeHost, ::cudaMalloc3D, ::cudaMalloc3DArray,"]
    #[doc = " ::cudaHostAlloc,"]
    #[doc = " ::cuMemFree"]
    pub fn cudaFree(devPtr: *mut ::libc::c_void) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Frees page-locked memory"]
    #[doc = ""]
    #[doc = " Frees the memory space pointed to by \\p hostPtr, which must have been"]
    #[doc = " returned by a previous call to ::cudaMallocHost() or ::cudaHostAlloc()."]
    #[doc = ""]
    #[doc = " \\param ptr - Pointer to memory to free"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMalloc, ::cudaMallocPitch, ::cudaFree, ::cudaMallocArray,"]
    #[doc = " ::cudaFreeArray,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t) \"cudaMallocHost (C API)\","]
    #[doc = " ::cudaMalloc3D, ::cudaMalloc3DArray, ::cudaHostAlloc,"]
    #[doc = " ::cuMemFreeHost"]
    pub fn cudaFreeHost(ptr: *mut ::libc::c_void) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Frees an array on the device"]
    #[doc = ""]
    #[doc = " Frees the CUDA array \\p array, which must have been returned by a"]
    #[doc = " previous call to ::cudaMallocArray(). If \\p devPtr is 0,"]
    #[doc = " no operation is performed."]
    #[doc = ""]
    #[doc = " \\param array - Pointer to array to free"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMalloc, ::cudaMallocPitch, ::cudaFree, ::cudaMallocArray,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t) \"cudaMallocHost (C API)\","]
    #[doc = " ::cudaFreeHost, ::cudaHostAlloc,"]
    #[doc = " ::cuArrayDestroy"]
    pub fn cudaFreeArray(array: cudaArray_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Frees a mipmapped array on the device"]
    #[doc = ""]
    #[doc = " Frees the CUDA mipmapped array \\p mipmappedArray, which must have been"]
    #[doc = " returned by a previous call to ::cudaMallocMipmappedArray(). If \\p devPtr"]
    #[doc = " is 0, no operation is performed."]
    #[doc = ""]
    #[doc = " \\param mipmappedArray - Pointer to mipmapped array to free"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMalloc, ::cudaMallocPitch, ::cudaFree, ::cudaMallocArray,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t) \"cudaMallocHost (C API)\","]
    #[doc = " ::cudaFreeHost, ::cudaHostAlloc,"]
    #[doc = " ::cuMipmappedArrayDestroy"]
    pub fn cudaFreeMipmappedArray(mipmappedArray: cudaMipmappedArray_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Allocates page-locked memory on the host"]
    #[doc = ""]
    #[doc = " Allocates \\p size bytes of host memory that is page-locked and accessible"]
    #[doc = " to the device. The driver tracks the virtual memory ranges allocated with"]
    #[doc = " this function and automatically accelerates calls to functions such as"]
    #[doc = " ::cudaMemcpy(). Since the memory can be accessed directly by the device, it"]
    #[doc = " can be read or written with much higher bandwidth than pageable memory"]
    #[doc = " obtained with functions such as ::malloc(). Allocating excessive amounts of"]
    #[doc = " pinned memory may degrade system performance, since it reduces the amount"]
    #[doc = " of memory available to the system for paging. As a result, this function is"]
    #[doc = " best used sparingly to allocate staging areas for data exchange between host"]
    #[doc = " and device."]
    #[doc = ""]
    #[doc = " The \\p flags parameter enables different options to be specified that affect"]
    #[doc = " the allocation, as follows."]
    #[doc = " - ::cudaHostAllocDefault: This flag's value is defined to be 0 and causes"]
    #[doc = " ::cudaHostAlloc() to emulate ::cudaMallocHost()."]
    #[doc = " - ::cudaHostAllocPortable: The memory returned by this call will be"]
    #[doc = " considered as pinned memory by all CUDA contexts, not just the one that"]
    #[doc = " performed the allocation."]
    #[doc = " - ::cudaHostAllocMapped: Maps the allocation into the CUDA address space."]
    #[doc = " The device pointer to the memory may be obtained by calling"]
    #[doc = " ::cudaHostGetDevicePointer()."]
    #[doc = " - ::cudaHostAllocWriteCombined: Allocates the memory as write-combined (WC)."]
    #[doc = " WC memory can be transferred across the PCI Express bus more quickly on some"]
    #[doc = " system configurations, but cannot be read efficiently by most CPUs.  WC"]
    #[doc = " memory is a good option for buffers that will be written by the CPU and read"]
    #[doc = " by the device via mapped pinned memory or host->device transfers."]
    #[doc = ""]
    #[doc = " All of these flags are orthogonal to one another: a developer may allocate"]
    #[doc = " memory that is portable, mapped and/or write-combined with no restrictions."]
    #[doc = ""]
    #[doc = " In order for the ::cudaHostAllocMapped flag to have any effect, the CUDA context"]
    #[doc = " must support the ::cudaDeviceMapHost flag, which can be checked via"]
    #[doc = " ::cudaGetDeviceFlags(). The ::cudaDeviceMapHost flag is implicitly set for"]
    #[doc = " contexts created via the runtime API."]
    #[doc = ""]
    #[doc = " The ::cudaHostAllocMapped flag may be specified on CUDA contexts for devices"]
    #[doc = " that do not support mapped pinned memory. The failure is deferred to"]
    #[doc = " ::cudaHostGetDevicePointer() because the memory may be mapped into other"]
    #[doc = " CUDA contexts via the ::cudaHostAllocPortable flag."]
    #[doc = ""]
    #[doc = " Memory allocated by this function must be freed with ::cudaFreeHost()."]
    #[doc = ""]
    #[doc = " \\param pHost - Device pointer to allocated memory"]
    #[doc = " \\param size  - Requested allocation size in bytes"]
    #[doc = " \\param flags - Requested properties of allocated memory"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaSetDeviceFlags,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t) \"cudaMallocHost (C API)\","]
    #[doc = " ::cudaFreeHost,"]
    #[doc = " ::cudaGetDeviceFlags,"]
    #[doc = " ::cuMemHostAlloc"]
    pub fn cudaHostAlloc(
        pHost: *mut *mut ::libc::c_void,
        size: usize,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Registers an existing host memory range for use by CUDA"]
    #[doc = ""]
    #[doc = " Page-locks the memory range specified by \\p ptr and \\p size and maps it"]
    #[doc = " for the device(s) as specified by \\p flags. This memory range also is added"]
    #[doc = " to the same tracking mechanism as ::cudaHostAlloc() to automatically accelerate"]
    #[doc = " calls to functions such as ::cudaMemcpy(). Since the memory can be accessed"]
    #[doc = " directly by the device, it can be read or written with much higher bandwidth"]
    #[doc = " than pageable memory that has not been registered.  Page-locking excessive"]
    #[doc = " amounts of memory may degrade system performance, since it reduces the amount"]
    #[doc = " of memory available to the system for paging. As a result, this function is"]
    #[doc = " best used sparingly to register staging areas for data exchange between"]
    #[doc = " host and device."]
    #[doc = ""]
    #[doc = " ::cudaHostRegister is supported only on I/O coherent devices that have a non-zero"]
    #[doc = " value for the device attribute ::cudaDevAttrHostRegisterSupported."]
    #[doc = ""]
    #[doc = " The \\p flags parameter enables different options to be specified that"]
    #[doc = " affect the allocation, as follows."]
    #[doc = ""]
    #[doc = " - ::cudaHostRegisterDefault: On a system with unified virtual addressing,"]
    #[doc = "   the memory will be both mapped and portable.  On a system with no unified"]
    #[doc = "   virtual addressing, the memory will be neither mapped nor portable."]
    #[doc = ""]
    #[doc = " - ::cudaHostRegisterPortable: The memory returned by this call will be"]
    #[doc = "   considered as pinned memory by all CUDA contexts, not just the one that"]
    #[doc = "   performed the allocation."]
    #[doc = ""]
    #[doc = " - ::cudaHostRegisterMapped: Maps the allocation into the CUDA address"]
    #[doc = "   space. The device pointer to the memory may be obtained by calling"]
    #[doc = "   ::cudaHostGetDevicePointer()."]
    #[doc = ""]
    #[doc = " - ::cudaHostRegisterIoMemory: The passed memory pointer is treated as"]
    #[doc = "   pointing to some memory-mapped I/O space, e.g. belonging to a"]
    #[doc = "   third-party PCIe device, and it will marked as non cache-coherent and"]
    #[doc = "   contiguous."]
    #[doc = ""]
    #[doc = " - ::cudaHostRegisterReadOnly: The passed memory pointer is treated as"]
    #[doc = "   pointing to memory that is considered read-only by the device.  On"]
    #[doc = "   platforms without ::cudaDevAttrPageableMemoryAccessUsesHostPageTables, this"]
    #[doc = "   flag is required in order to register memory mapped to the CPU as"]
    #[doc = "   read-only.  Support for the use of this flag can be queried from the device"]
    #[doc = "   attribute cudaDeviceAttrReadOnlyHostRegisterSupported.  Using this flag with"]
    #[doc = "   a current context associated with a device that does not have this attribute"]
    #[doc = "   set will cause ::cudaHostRegister to error with cudaErrorNotSupported."]
    #[doc = ""]
    #[doc = " All of these flags are orthogonal to one another: a developer may page-lock"]
    #[doc = " memory that is portable or mapped with no restrictions."]
    #[doc = ""]
    #[doc = " The CUDA context must have been created with the ::cudaMapHost flag in"]
    #[doc = " order for the ::cudaHostRegisterMapped flag to have any effect."]
    #[doc = ""]
    #[doc = " The ::cudaHostRegisterMapped flag may be specified on CUDA contexts for"]
    #[doc = " devices that do not support mapped pinned memory. The failure is deferred"]
    #[doc = " to ::cudaHostGetDevicePointer() because the memory may be mapped into"]
    #[doc = " other CUDA contexts via the ::cudaHostRegisterPortable flag."]
    #[doc = ""]
    #[doc = " For devices that have a non-zero value for the device attribute"]
    #[doc = " ::cudaDevAttrCanUseHostPointerForRegisteredMem, the memory"]
    #[doc = " can also be accessed from the device using the host pointer \\p ptr."]
    #[doc = " The device pointer returned by ::cudaHostGetDevicePointer() may or may not"]
    #[doc = " match the original host pointer \\p ptr and depends on the devices visible to the"]
    #[doc = " application. If all devices visible to the application have a non-zero value for the"]
    #[doc = " device attribute, the device pointer returned by ::cudaHostGetDevicePointer()"]
    #[doc = " will match the original pointer \\p ptr. If any device visible to the application"]
    #[doc = " has a zero value for the device attribute, the device pointer returned by"]
    #[doc = " ::cudaHostGetDevicePointer() will not match the original host pointer \\p ptr,"]
    #[doc = " but it will be suitable for use on all devices provided Unified Virtual Addressing"]
    #[doc = " is enabled. In such systems, it is valid to access the memory using either pointer"]
    #[doc = " on devices that have a non-zero value for the device attribute. Note however that"]
    #[doc = " such devices should access the memory using only of the two pointers and not both."]
    #[doc = ""]
    #[doc = " The memory page-locked by this function must be unregistered with ::cudaHostUnregister()."]
    #[doc = ""]
    #[doc = " \\param ptr   - Host pointer to memory to page-lock"]
    #[doc = " \\param size  - Size in bytes of the address range to page-lock in bytes"]
    #[doc = " \\param flags - Flags for allocation request"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation,"]
    #[doc = " ::cudaErrorHostMemoryAlreadyRegistered,"]
    #[doc = " ::cudaErrorNotSupported"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaHostUnregister, ::cudaHostGetFlags, ::cudaHostGetDevicePointer,"]
    #[doc = " ::cuMemHostRegister"]
    pub fn cudaHostRegister(
        ptr: *mut ::libc::c_void,
        size: usize,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Unregisters a memory range that was registered with cudaHostRegister"]
    #[doc = ""]
    #[doc = " Unmaps the memory range whose base address is specified by \\p ptr, and makes"]
    #[doc = " it pageable again."]
    #[doc = ""]
    #[doc = " The base address must be the same one specified to ::cudaHostRegister()."]
    #[doc = ""]
    #[doc = " \\param ptr - Host pointer to memory to unregister"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorHostMemoryNotRegistered"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaHostUnregister,"]
    #[doc = " ::cuMemHostUnregister"]
    pub fn cudaHostUnregister(ptr: *mut ::libc::c_void) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Passes back device pointer of mapped host memory allocated by"]
    #[doc = " cudaHostAlloc or registered by cudaHostRegister"]
    #[doc = ""]
    #[doc = " Passes back the device pointer corresponding to the mapped, pinned host"]
    #[doc = " buffer allocated by ::cudaHostAlloc() or registered by ::cudaHostRegister()."]
    #[doc = ""]
    #[doc = " ::cudaHostGetDevicePointer() will fail if the ::cudaDeviceMapHost flag was"]
    #[doc = " not specified before deferred context creation occurred, or if called on a"]
    #[doc = " device that does not support mapped, pinned memory."]
    #[doc = ""]
    #[doc = " For devices that have a non-zero value for the device attribute"]
    #[doc = " ::cudaDevAttrCanUseHostPointerForRegisteredMem, the memory"]
    #[doc = " can also be accessed from the device using the host pointer \\p pHost."]
    #[doc = " The device pointer returned by ::cudaHostGetDevicePointer() may or may not"]
    #[doc = " match the original host pointer \\p pHost and depends on the devices visible to the"]
    #[doc = " application. If all devices visible to the application have a non-zero value for the"]
    #[doc = " device attribute, the device pointer returned by ::cudaHostGetDevicePointer()"]
    #[doc = " will match the original pointer \\p pHost. If any device visible to the application"]
    #[doc = " has a zero value for the device attribute, the device pointer returned by"]
    #[doc = " ::cudaHostGetDevicePointer() will not match the original host pointer \\p pHost,"]
    #[doc = " but it will be suitable for use on all devices provided Unified Virtual Addressing"]
    #[doc = " is enabled. In such systems, it is valid to access the memory using either pointer"]
    #[doc = " on devices that have a non-zero value for the device attribute. Note however that"]
    #[doc = " such devices should access the memory using only of the two pointers and not both."]
    #[doc = ""]
    #[doc = " \\p flags provides for future releases.  For now, it must be set to 0."]
    #[doc = ""]
    #[doc = " \\param pDevice - Returned device pointer for mapped memory"]
    #[doc = " \\param pHost   - Requested host pointer mapping"]
    #[doc = " \\param flags   - Flags for extensions (must be 0 for now)"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaSetDeviceFlags, ::cudaHostAlloc,"]
    #[doc = " ::cuMemHostGetDevicePointer"]
    pub fn cudaHostGetDevicePointer(
        pDevice: *mut *mut ::libc::c_void,
        pHost: *mut ::libc::c_void,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Passes back flags used to allocate pinned host memory allocated by"]
    #[doc = " cudaHostAlloc"]
    #[doc = ""]
    #[doc = " ::cudaHostGetFlags() will fail if the input pointer does not"]
    #[doc = " reside in an address range allocated by ::cudaHostAlloc()."]
    #[doc = ""]
    #[doc = " \\param pFlags - Returned flags word"]
    #[doc = " \\param pHost - Host pointer"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaHostAlloc,"]
    #[doc = " ::cuMemHostGetFlags"]
    pub fn cudaHostGetFlags(pFlags: *mut ::libc::c_uint, pHost: *mut ::libc::c_void)
        -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Allocates logical 1D, 2D, or 3D memory objects on the device"]
    #[doc = ""]
    #[doc = " Allocates at least \\p width * \\p height * \\p depth bytes of linear memory"]
    #[doc = " on the device and returns a ::cudaPitchedPtr in which \\p ptr is a pointer"]
    #[doc = " to the allocated memory. The function may pad the allocation to ensure"]
    #[doc = " hardware alignment requirements are met. The pitch returned in the \\p pitch"]
    #[doc = " field of \\p pitchedDevPtr is the width in bytes of the allocation."]
    #[doc = ""]
    #[doc = " The returned ::cudaPitchedPtr contains additional fields \\p xsize and"]
    #[doc = " \\p ysize, the logical width and height of the allocation, which are"]
    #[doc = " equivalent to the \\p width and \\p height \\p extent parameters provided by"]
    #[doc = " the programmer during allocation."]
    #[doc = ""]
    #[doc = " For allocations of 2D and 3D objects, it is highly recommended that"]
    #[doc = " programmers perform allocations using ::cudaMalloc3D() or"]
    #[doc = " ::cudaMallocPitch(). Due to alignment restrictions in the hardware, this is"]
    #[doc = " especially true if the application will be performing memory copies"]
    #[doc = " involving 2D or 3D objects (whether linear memory or CUDA arrays)."]
    #[doc = ""]
    #[doc = " \\param pitchedDevPtr  - Pointer to allocated pitched device memory"]
    #[doc = " \\param extent         - Requested allocation size (\\p width field in bytes)"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMallocPitch, ::cudaFree, ::cudaMemcpy3D, ::cudaMemset3D,"]
    #[doc = " ::cudaMalloc3DArray, ::cudaMallocArray, ::cudaFreeArray,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t) \"cudaMallocHost (C API)\","]
    #[doc = " ::cudaFreeHost, ::cudaHostAlloc, ::make_cudaPitchedPtr, ::make_cudaExtent,"]
    #[doc = " ::cuMemAllocPitch"]
    pub fn cudaMalloc3D(pitchedDevPtr: *mut cudaPitchedPtr, extent: cudaExtent) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Allocate an array on the device"]
    #[doc = ""]
    #[doc = " Allocates a CUDA array according to the ::cudaChannelFormatDesc structure"]
    #[doc = " \\p desc and returns a handle to the new CUDA array in \\p *array."]
    #[doc = ""]
    #[doc = " The ::cudaChannelFormatDesc is defined as:"]
    #[doc = " \\code"]
    #[doc = "struct cudaChannelFormatDesc {"]
    #[doc = "int x, y, z, w;"]
    #[doc = "enum cudaChannelFormatKind f;"]
    #[doc = "};"]
    #[doc = "\\endcode"]
    #[doc = " where ::cudaChannelFormatKind is one of ::cudaChannelFormatKindSigned,"]
    #[doc = " ::cudaChannelFormatKindUnsigned, or ::cudaChannelFormatKindFloat."]
    #[doc = ""]
    #[doc = " ::cudaMalloc3DArray() can allocate the following:"]
    #[doc = ""]
    #[doc = " - A 1D array is allocated if the height and depth extents are both zero."]
    #[doc = " - A 2D array is allocated if only the depth extent is zero."]
    #[doc = " - A 3D array is allocated if all three extents are non-zero."]
    #[doc = " - A 1D layered CUDA array is allocated if only the height extent is zero and"]
    #[doc = " the cudaArrayLayered flag is set. Each layer is a 1D array. The number of layers is"]
    #[doc = " determined by the depth extent."]
    #[doc = " - A 2D layered CUDA array is allocated if all three extents are non-zero and"]
    #[doc = " the cudaArrayLayered flag is set. Each layer is a 2D array. The number of layers is"]
    #[doc = " determined by the depth extent."]
    #[doc = " - A cubemap CUDA array is allocated if all three extents are non-zero and the"]
    #[doc = " cudaArrayCubemap flag is set. Width must be equal to height, and depth must be six. A cubemap is"]
    #[doc = " a special type of 2D layered CUDA array, where the six layers represent the six faces of a cube."]
    #[doc = " The order of the six layers in memory is the same as that listed in ::cudaGraphicsCubeFace."]
    #[doc = " - A cubemap layered CUDA array is allocated if all three extents are non-zero, and both,"]
    #[doc = " cudaArrayCubemap and cudaArrayLayered flags are set. Width must be equal to height, and depth must be"]
    #[doc = " a multiple of six. A cubemap layered CUDA array is a special type of 2D layered CUDA array that consists"]
    #[doc = " of a collection of cubemaps. The first six layers represent the first cubemap, the next six layers form"]
    #[doc = " the second cubemap, and so on."]
    #[doc = ""]
    #[doc = ""]
    #[doc = " The \\p flags parameter enables different options to be specified that affect"]
    #[doc = " the allocation, as follows."]
    #[doc = " - ::cudaArrayDefault: This flag's value is defined to be 0 and provides default array allocation"]
    #[doc = " - ::cudaArrayLayered: Allocates a layered CUDA array, with the depth extent indicating the number of layers"]
    #[doc = " - ::cudaArrayCubemap: Allocates a cubemap CUDA array. Width must be equal to height, and depth must be six."]
    #[doc = "   If the cudaArrayLayered flag is also set, depth must be a multiple of six."]
    #[doc = " - ::cudaArraySurfaceLoadStore: Allocates a CUDA array that could be read from or written to using a surface"]
    #[doc = "   reference."]
    #[doc = " - ::cudaArrayTextureGather: This flag indicates that texture gather operations will be performed on the CUDA"]
    #[doc = "   array. Texture gather can only be performed on 2D CUDA arrays."]
    #[doc = " - ::cudaArraySparse: Allocates a CUDA array without physical backing memory. The subregions within this sparse array"]
    #[doc = "   can later be mapped to physical memory by calling ::cuMemMapArrayAsync. This flag can only be used for"]
    #[doc = "   creating 2D, 3D or 2D layered sparse CUDA arrays. The physical backing memory must be  allocated via ::cuMemCreate."]
    #[doc = ""]
    #[doc = " The width, height and depth extents must meet certain size requirements as listed in the following table."]
    #[doc = " All values are specified in elements."]
    #[doc = ""]
    #[doc = " Note that 2D CUDA arrays have different size requirements if the ::cudaArrayTextureGather flag is set. In that"]
    #[doc = " case, the valid range for (width, height, depth) is ((1,maxTexture2DGather[0]), (1,maxTexture2DGather[1]), 0)."]
    #[doc = ""]
    #[doc = " \\xmlonly"]
    #[doc = " <table outputclass=\"xmlonly\">"]
    #[doc = " <tgroup cols=\"3\" colsep=\"1\" rowsep=\"1\">"]
    #[doc = " <colspec colname=\"c1\" colwidth=\"1.0*\"/>"]
    #[doc = " <colspec colname=\"c2\" colwidth=\"3.0*\"/>"]
    #[doc = " <colspec colname=\"c3\" colwidth=\"3.0*\"/>"]
    #[doc = " <thead>"]
    #[doc = " <row>"]
    #[doc = " <entry>CUDA array type</entry>"]
    #[doc = " <entry>Valid extents that must always be met {(width range in elements),"]
    #[doc = " (height range), (depth range)}</entry>"]
    #[doc = " <entry>Valid extents with cudaArraySurfaceLoadStore set {(width range in"]
    #[doc = " elements), (height range), (depth range)}</entry>"]
    #[doc = " </row>"]
    #[doc = " </thead>"]
    #[doc = " <tbody>"]
    #[doc = " <row>"]
    #[doc = " <entry>1D</entry>"]
    #[doc = " <entry>{ (1,maxTexture1D), 0, 0 }</entry>"]
    #[doc = " <entry>{ (1,maxSurface1D), 0, 0 }</entry>"]
    #[doc = " </row>"]
    #[doc = " <row>"]
    #[doc = " <entry>2D</entry>"]
    #[doc = " <entry>{ (1,maxTexture2D[0]), (1,maxTexture2D[1]), 0 }</entry>"]
    #[doc = " <entry>{ (1,maxSurface2D[0]), (1,maxSurface2D[1]), 0 }</entry>"]
    #[doc = " </row>"]
    #[doc = " <row>"]
    #[doc = " <entry>3D</entry>"]
    #[doc = " <entry>{ (1,maxTexture3D[0]), (1,maxTexture3D[1]), (1,maxTexture3D[2]) }"]
    #[doc = " OR { (1,maxTexture3DAlt[0]), (1,maxTexture3DAlt[1]),"]
    #[doc = " (1,maxTexture3DAlt[2]) }</entry>"]
    #[doc = " <entry>{ (1,maxSurface3D[0]), (1,maxSurface3D[1]), (1,maxSurface3D[2]) }</entry>"]
    #[doc = " </row>"]
    #[doc = " <row>"]
    #[doc = " <entry>1D Layered</entry>"]
    #[doc = " <entry>{ (1,maxTexture1DLayered[0]), 0, (1,maxTexture1DLayered[1]) }</entry>"]
    #[doc = " <entry>{ (1,maxSurface1DLayered[0]), 0, (1,maxSurface1DLayered[1]) }</entry>"]
    #[doc = " </row>"]
    #[doc = " <row>"]
    #[doc = " <entry>2D Layered</entry>"]
    #[doc = " <entry>{ (1,maxTexture2DLayered[0]), (1,maxTexture2DLayered[1]),"]
    #[doc = " (1,maxTexture2DLayered[2]) }</entry>"]
    #[doc = " <entry>{ (1,maxSurface2DLayered[0]), (1,maxSurface2DLayered[1]),"]
    #[doc = " (1,maxSurface2DLayered[2]) }</entry>"]
    #[doc = " </row>"]
    #[doc = " <row>"]
    #[doc = " <entry>Cubemap</entry>"]
    #[doc = " <entry>{ (1,maxTextureCubemap), (1,maxTextureCubemap), 6 }</entry>"]
    #[doc = " <entry>{ (1,maxSurfaceCubemap), (1,maxSurfaceCubemap), 6 }</entry>"]
    #[doc = " </row>"]
    #[doc = " <row>"]
    #[doc = " <entry>Cubemap Layered</entry>"]
    #[doc = " <entry>{ (1,maxTextureCubemapLayered[0]), (1,maxTextureCubemapLayered[0]),"]
    #[doc = " (1,maxTextureCubemapLayered[1]) }</entry>"]
    #[doc = " <entry>{ (1,maxSurfaceCubemapLayered[0]), (1,maxSurfaceCubemapLayered[0]),"]
    #[doc = " (1,maxSurfaceCubemapLayered[1]) }</entry>"]
    #[doc = " </row>"]
    #[doc = " </tbody>"]
    #[doc = " </tgroup>"]
    #[doc = " </table>"]
    #[doc = " \\endxmlonly"]
    #[doc = ""]
    #[doc = " \\param array  - Pointer to allocated array in device memory"]
    #[doc = " \\param desc   - Requested channel format"]
    #[doc = " \\param extent - Requested allocation size (\\p width field in elements)"]
    #[doc = " \\param flags  - Flags for extensions"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMalloc3D, ::cudaMalloc, ::cudaMallocPitch, ::cudaFree,"]
    #[doc = " ::cudaFreeArray,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t) \"cudaMallocHost (C API)\","]
    #[doc = " ::cudaFreeHost, ::cudaHostAlloc,"]
    #[doc = " ::make_cudaExtent,"]
    #[doc = " ::cuArray3DCreate"]
    pub fn cudaMalloc3DArray(
        array: *mut cudaArray_t,
        desc: *const cudaChannelFormatDesc,
        extent: cudaExtent,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Allocate a mipmapped array on the device"]
    #[doc = ""]
    #[doc = " Allocates a CUDA mipmapped array according to the ::cudaChannelFormatDesc structure"]
    #[doc = " \\p desc and returns a handle to the new CUDA mipmapped array in \\p *mipmappedArray."]
    #[doc = " \\p numLevels specifies the number of mipmap levels to be allocated. This value is"]
    #[doc = " clamped to the range [1, 1 + floor(log2(max(width, height, depth)))]."]
    #[doc = ""]
    #[doc = " The ::cudaChannelFormatDesc is defined as:"]
    #[doc = " \\code"]
    #[doc = "struct cudaChannelFormatDesc {"]
    #[doc = "int x, y, z, w;"]
    #[doc = "enum cudaChannelFormatKind f;"]
    #[doc = "};"]
    #[doc = "\\endcode"]
    #[doc = " where ::cudaChannelFormatKind is one of ::cudaChannelFormatKindSigned,"]
    #[doc = " ::cudaChannelFormatKindUnsigned, or ::cudaChannelFormatKindFloat."]
    #[doc = ""]
    #[doc = " ::cudaMallocMipmappedArray() can allocate the following:"]
    #[doc = ""]
    #[doc = " - A 1D mipmapped array is allocated if the height and depth extents are both zero."]
    #[doc = " - A 2D mipmapped array is allocated if only the depth extent is zero."]
    #[doc = " - A 3D mipmapped array is allocated if all three extents are non-zero."]
    #[doc = " - A 1D layered CUDA mipmapped array is allocated if only the height extent is zero and"]
    #[doc = " the cudaArrayLayered flag is set. Each layer is a 1D mipmapped array. The number of layers is"]
    #[doc = " determined by the depth extent."]
    #[doc = " - A 2D layered CUDA mipmapped array is allocated if all three extents are non-zero and"]
    #[doc = " the cudaArrayLayered flag is set. Each layer is a 2D mipmapped array. The number of layers is"]
    #[doc = " determined by the depth extent."]
    #[doc = " - A cubemap CUDA mipmapped array is allocated if all three extents are non-zero and the"]
    #[doc = " cudaArrayCubemap flag is set. Width must be equal to height, and depth must be six."]
    #[doc = " The order of the six layers in memory is the same as that listed in ::cudaGraphicsCubeFace."]
    #[doc = " - A cubemap layered CUDA mipmapped array is allocated if all three extents are non-zero, and both,"]
    #[doc = " cudaArrayCubemap and cudaArrayLayered flags are set. Width must be equal to height, and depth must be"]
    #[doc = " a multiple of six. A cubemap layered CUDA mipmapped array is a special type of 2D layered CUDA mipmapped"]
    #[doc = " array that consists of a collection of cubemap mipmapped arrays. The first six layers represent the"]
    #[doc = " first cubemap mipmapped array, the next six layers form the second cubemap mipmapped array, and so on."]
    #[doc = ""]
    #[doc = ""]
    #[doc = " The \\p flags parameter enables different options to be specified that affect"]
    #[doc = " the allocation, as follows."]
    #[doc = " - ::cudaArrayDefault: This flag's value is defined to be 0 and provides default mipmapped array allocation"]
    #[doc = " - ::cudaArrayLayered: Allocates a layered CUDA mipmapped array, with the depth extent indicating the number of layers"]
    #[doc = " - ::cudaArrayCubemap: Allocates a cubemap CUDA mipmapped array. Width must be equal to height, and depth must be six."]
    #[doc = "   If the cudaArrayLayered flag is also set, depth must be a multiple of six."]
    #[doc = " - ::cudaArraySurfaceLoadStore: This flag indicates that individual mipmap levels of the CUDA mipmapped array"]
    #[doc = "   will be read from or written to using a surface reference."]
    #[doc = " - ::cudaArrayTextureGather: This flag indicates that texture gather operations will be performed on the CUDA"]
    #[doc = "   array. Texture gather can only be performed on 2D CUDA mipmapped arrays, and the gather operations are"]
    #[doc = "   performed only on the most detailed mipmap level."]
    #[doc = " - ::cudaArraySparse: Allocates a CUDA array without physical backing memory. The subregions within this sparse array"]
    #[doc = "   can later be mapped to physical memory by calling ::cuMemMapArrayAsync. This flag can only be used for creating"]
    #[doc = "   2D, 3D or 2D layered sparse CUDA mipmapped arrays. The physical backing memory must be allocated via ::cuMemCreate."]
    #[doc = ""]
    #[doc = " The width, height and depth extents must meet certain size requirements as listed in the following table."]
    #[doc = " All values are specified in elements."]
    #[doc = ""]
    #[doc = " \\xmlonly"]
    #[doc = " <table outputclass=\"xmlonly\">"]
    #[doc = " <tgroup cols=\"3\" colsep=\"1\" rowsep=\"1\">"]
    #[doc = " <colspec colname=\"c1\" colwidth=\"1.0*\"/>"]
    #[doc = " <colspec colname=\"c2\" colwidth=\"3.0*\"/>"]
    #[doc = " <colspec colname=\"c3\" colwidth=\"3.0*\"/>"]
    #[doc = " <thead>"]
    #[doc = " <row>"]
    #[doc = " <entry>CUDA array type</entry>"]
    #[doc = " <entry>Valid extents that must always be met {(width range in elements),"]
    #[doc = " (height range), (depth range)}</entry>"]
    #[doc = " <entry>Valid extents with cudaArraySurfaceLoadStore set {(width range in"]
    #[doc = " elements), (height range), (depth range)}</entry>"]
    #[doc = " </row>"]
    #[doc = " </thead>"]
    #[doc = " <tbody>"]
    #[doc = " <row>"]
    #[doc = " <entry>1D</entry>"]
    #[doc = " <entry>{ (1,maxTexture1DMipmap), 0, 0 }</entry>"]
    #[doc = " <entry>{ (1,maxSurface1D), 0, 0 }</entry>"]
    #[doc = " </row>"]
    #[doc = " <row>"]
    #[doc = " <entry>2D</entry>"]
    #[doc = " <entry>{ (1,maxTexture2DMipmap[0]), (1,maxTexture2DMipmap[1]), 0 }</entry>"]
    #[doc = " <entry>{ (1,maxSurface2D[0]), (1,maxSurface2D[1]), 0 }</entry>"]
    #[doc = " </row>"]
    #[doc = " <row>"]
    #[doc = " <entry>3D</entry>"]
    #[doc = " <entry>{ (1,maxTexture3D[0]), (1,maxTexture3D[1]), (1,maxTexture3D[2]) }"]
    #[doc = " OR { (1,maxTexture3DAlt[0]), (1,maxTexture3DAlt[1]),"]
    #[doc = " (1,maxTexture3DAlt[2]) }</entry>"]
    #[doc = " <entry>{ (1,maxSurface3D[0]), (1,maxSurface3D[1]), (1,maxSurface3D[2]) }</entry>"]
    #[doc = " </row>"]
    #[doc = " <row>"]
    #[doc = " <entry>1D Layered</entry>"]
    #[doc = " <entry>{ (1,maxTexture1DLayered[0]), 0, (1,maxTexture1DLayered[1]) }</entry>"]
    #[doc = " <entry>{ (1,maxSurface1DLayered[0]), 0, (1,maxSurface1DLayered[1]) }</entry>"]
    #[doc = " </row>"]
    #[doc = " <row>"]
    #[doc = " <entry>2D Layered</entry>"]
    #[doc = " <entry>{ (1,maxTexture2DLayered[0]), (1,maxTexture2DLayered[1]),"]
    #[doc = " (1,maxTexture2DLayered[2]) }</entry>"]
    #[doc = " <entry>{ (1,maxSurface2DLayered[0]), (1,maxSurface2DLayered[1]),"]
    #[doc = " (1,maxSurface2DLayered[2]) }</entry>"]
    #[doc = " </row>"]
    #[doc = " <row>"]
    #[doc = " <entry>Cubemap</entry>"]
    #[doc = " <entry>{ (1,maxTextureCubemap), (1,maxTextureCubemap), 6 }</entry>"]
    #[doc = " <entry>{ (1,maxSurfaceCubemap), (1,maxSurfaceCubemap), 6 }</entry>"]
    #[doc = " </row>"]
    #[doc = " <row>"]
    #[doc = " <entry>Cubemap Layered</entry>"]
    #[doc = " <entry>{ (1,maxTextureCubemapLayered[0]), (1,maxTextureCubemapLayered[0]),"]
    #[doc = " (1,maxTextureCubemapLayered[1]) }</entry>"]
    #[doc = " <entry>{ (1,maxSurfaceCubemapLayered[0]), (1,maxSurfaceCubemapLayered[0]),"]
    #[doc = " (1,maxSurfaceCubemapLayered[1]) }</entry>"]
    #[doc = " </row>"]
    #[doc = " </tbody>"]
    #[doc = " </tgroup>"]
    #[doc = " </table>"]
    #[doc = " \\endxmlonly"]
    #[doc = ""]
    #[doc = " \\param mipmappedArray  - Pointer to allocated mipmapped array in device memory"]
    #[doc = " \\param desc            - Requested channel format"]
    #[doc = " \\param extent          - Requested allocation size (\\p width field in elements)"]
    #[doc = " \\param numLevels       - Number of mipmap levels to allocate"]
    #[doc = " \\param flags           - Flags for extensions"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMalloc3D, ::cudaMalloc, ::cudaMallocPitch, ::cudaFree,"]
    #[doc = " ::cudaFreeArray,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t) \"cudaMallocHost (C API)\","]
    #[doc = " ::cudaFreeHost, ::cudaHostAlloc,"]
    #[doc = " ::make_cudaExtent,"]
    #[doc = " ::cuMipmappedArrayCreate"]
    pub fn cudaMallocMipmappedArray(
        mipmappedArray: *mut cudaMipmappedArray_t,
        desc: *const cudaChannelFormatDesc,
        extent: cudaExtent,
        numLevels: ::libc::c_uint,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Gets a mipmap level of a CUDA mipmapped array"]
    #[doc = ""]
    #[doc = " Returns in \\p *levelArray a CUDA array that represents a single mipmap level"]
    #[doc = " of the CUDA mipmapped array \\p mipmappedArray."]
    #[doc = ""]
    #[doc = " If \\p level is greater than the maximum number of levels in this mipmapped array,"]
    #[doc = " ::cudaErrorInvalidValue is returned."]
    #[doc = ""]
    #[doc = " If \\p mipmappedArray is NULL,"]
    #[doc = " ::cudaErrorInvalidResourceHandle is returned."]
    #[doc = ""]
    #[doc = " \\param levelArray     - Returned mipmap level CUDA array"]
    #[doc = " \\param mipmappedArray - CUDA mipmapped array"]
    #[doc = " \\param level          - Mipmap level"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMalloc3D, ::cudaMalloc, ::cudaMallocPitch, ::cudaFree,"]
    #[doc = " ::cudaFreeArray,"]
    #[doc = " \\ref ::cudaMallocHost(void**, size_t) \"cudaMallocHost (C API)\","]
    #[doc = " ::cudaFreeHost, ::cudaHostAlloc,"]
    #[doc = " ::make_cudaExtent,"]
    #[doc = " ::cuMipmappedArrayGetLevel"]
    pub fn cudaGetMipmappedArrayLevel(
        levelArray: *mut cudaArray_t,
        mipmappedArray: cudaMipmappedArray_const_t,
        level: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between 3D objects"]
    #[doc = ""]
    #[doc = "\\code"]
    #[doc = "struct cudaExtent {"]
    #[doc = "size_t width;"]
    #[doc = "size_t height;"]
    #[doc = "size_t depth;"]
    #[doc = "};"]
    #[doc = "struct cudaExtent make_cudaExtent(size_t w, size_t h, size_t d);"]
    #[doc = ""]
    #[doc = "struct cudaPos {"]
    #[doc = "size_t x;"]
    #[doc = "size_t y;"]
    #[doc = "size_t z;"]
    #[doc = "};"]
    #[doc = "struct cudaPos make_cudaPos(size_t x, size_t y, size_t z);"]
    #[doc = ""]
    #[doc = "struct cudaMemcpy3DParms {"]
    #[doc = "cudaArray_t           srcArray;"]
    #[doc = "struct cudaPos        srcPos;"]
    #[doc = "struct cudaPitchedPtr srcPtr;"]
    #[doc = "cudaArray_t           dstArray;"]
    #[doc = "struct cudaPos        dstPos;"]
    #[doc = "struct cudaPitchedPtr dstPtr;"]
    #[doc = "struct cudaExtent     extent;"]
    #[doc = "enum cudaMemcpyKind   kind;"]
    #[doc = "};"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = " ::cudaMemcpy3D() copies data betwen two 3D objects. The source and"]
    #[doc = " destination objects may be in either host memory, device memory, or a CUDA"]
    #[doc = " array. The source, destination, extent, and kind of copy performed is"]
    #[doc = " specified by the ::cudaMemcpy3DParms struct which should be initialized to"]
    #[doc = " zero before use:"]
    #[doc = "\\code"]
    #[doc = "cudaMemcpy3DParms myParms = {0};"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = " The struct passed to ::cudaMemcpy3D() must specify one of \\p srcArray or"]
    #[doc = " \\p srcPtr and one of \\p dstArray or \\p dstPtr. Passing more than one"]
    #[doc = " non-zero source or destination will cause ::cudaMemcpy3D() to return an"]
    #[doc = " error."]
    #[doc = ""]
    #[doc = " The \\p srcPos and \\p dstPos fields are optional offsets into the source and"]
    #[doc = " destination objects and are defined in units of each object's elements. The"]
    #[doc = " element for a host or device pointer is assumed to be <b>unsigned char</b>."]
    #[doc = ""]
    #[doc = " The \\p extent field defines the dimensions of the transferred area in"]
    #[doc = " elements. If a CUDA array is participating in the copy, the extent is"]
    #[doc = " defined in terms of that array's elements. If no CUDA array is"]
    #[doc = " participating in the copy then the extents are defined in elements of"]
    #[doc = " <b>unsigned char</b>."]
    #[doc = ""]
    #[doc = " The \\p kind field defines the direction of the copy. It must be one of"]
    #[doc = " ::cudaMemcpyHostToHost, ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = " For ::cudaMemcpyHostToHost or ::cudaMemcpyHostToDevice or ::cudaMemcpyDeviceToHost"]
    #[doc = " passed as kind and cudaArray type passed as source or destination, if the kind"]
    #[doc = " implies cudaArray type to be present on the host, ::cudaMemcpy3D() will"]
    #[doc = " disregard that implication and silently correct the kind based on the fact that"]
    #[doc = " cudaArray type can only be present on the device."]
    #[doc = ""]
    #[doc = " If the source and destination are both arrays, ::cudaMemcpy3D() will return"]
    #[doc = " an error if they do not have the same element size."]
    #[doc = ""]
    #[doc = " The source and destination object may not overlap. If overlapping source"]
    #[doc = " and destination objects are specified, undefined behavior will result."]
    #[doc = ""]
    #[doc = " The source object must entirely contain the region defined by \\p srcPos"]
    #[doc = " and \\p extent. The destination object must entirely contain the region"]
    #[doc = " defined by \\p dstPos and \\p extent."]
    #[doc = ""]
    #[doc = " ::cudaMemcpy3D() returns an error if the pitch of \\p srcPtr or \\p dstPtr"]
    #[doc = " exceeds the maximum allowed. The pitch of a ::cudaPitchedPtr allocated"]
    #[doc = " with ::cudaMalloc3D() will always be valid."]
    #[doc = ""]
    #[doc = " \\param p - 3D memory copy parameters"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidPitchValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_sync"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMalloc3D, ::cudaMalloc3DArray, ::cudaMemset3D, ::cudaMemcpy3DAsync,"]
    #[doc = " ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::make_cudaExtent, ::make_cudaPos,"]
    #[doc = " ::cuMemcpy3D"]
    pub fn cudaMemcpy3D(p: *const cudaMemcpy3DParms) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies memory between devices"]
    #[doc = ""]
    #[doc = " Perform a 3D memory copy according to the parameters specified in"]
    #[doc = " \\p p.  See the definition of the ::cudaMemcpy3DPeerParms structure"]
    #[doc = " for documentation of its parameters."]
    #[doc = ""]
    #[doc = " Note that this function is synchronous with respect to the host only if"]
    #[doc = " the source or destination of the transfer is host memory.  Note also"]
    #[doc = " that this copy is serialized with respect to all pending and future"]
    #[doc = " asynchronous work in to the current device, the copy's source device,"]
    #[doc = " and the copy's destination device (use ::cudaMemcpy3DPeerAsync to avoid"]
    #[doc = " this synchronization)."]
    #[doc = ""]
    #[doc = " \\param p - Parameters for the memory copy"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_sync"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpyPeer, ::cudaMemcpyAsync, ::cudaMemcpyPeerAsync,"]
    #[doc = " ::cudaMemcpy3DPeerAsync,"]
    #[doc = " ::cuMemcpy3DPeer"]
    pub fn cudaMemcpy3DPeer(p: *const cudaMemcpy3DPeerParms) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between 3D objects"]
    #[doc = ""]
    #[doc = "\\code"]
    #[doc = "struct cudaExtent {"]
    #[doc = "size_t width;"]
    #[doc = "size_t height;"]
    #[doc = "size_t depth;"]
    #[doc = "};"]
    #[doc = "struct cudaExtent make_cudaExtent(size_t w, size_t h, size_t d);"]
    #[doc = ""]
    #[doc = "struct cudaPos {"]
    #[doc = "size_t x;"]
    #[doc = "size_t y;"]
    #[doc = "size_t z;"]
    #[doc = "};"]
    #[doc = "struct cudaPos make_cudaPos(size_t x, size_t y, size_t z);"]
    #[doc = ""]
    #[doc = "struct cudaMemcpy3DParms {"]
    #[doc = "cudaArray_t           srcArray;"]
    #[doc = "struct cudaPos        srcPos;"]
    #[doc = "struct cudaPitchedPtr srcPtr;"]
    #[doc = "cudaArray_t           dstArray;"]
    #[doc = "struct cudaPos        dstPos;"]
    #[doc = "struct cudaPitchedPtr dstPtr;"]
    #[doc = "struct cudaExtent     extent;"]
    #[doc = "enum cudaMemcpyKind   kind;"]
    #[doc = "};"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = " ::cudaMemcpy3DAsync() copies data betwen two 3D objects. The source and"]
    #[doc = " destination objects may be in either host memory, device memory, or a CUDA"]
    #[doc = " array. The source, destination, extent, and kind of copy performed is"]
    #[doc = " specified by the ::cudaMemcpy3DParms struct which should be initialized to"]
    #[doc = " zero before use:"]
    #[doc = "\\code"]
    #[doc = "cudaMemcpy3DParms myParms = {0};"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = " The struct passed to ::cudaMemcpy3DAsync() must specify one of \\p srcArray"]
    #[doc = " or \\p srcPtr and one of \\p dstArray or \\p dstPtr. Passing more than one"]
    #[doc = " non-zero source or destination will cause ::cudaMemcpy3DAsync() to return an"]
    #[doc = " error."]
    #[doc = ""]
    #[doc = " The \\p srcPos and \\p dstPos fields are optional offsets into the source and"]
    #[doc = " destination objects and are defined in units of each object's elements. The"]
    #[doc = " element for a host or device pointer is assumed to be <b>unsigned char</b>."]
    #[doc = " For CUDA arrays, positions must be in the range [0, 2048) for any"]
    #[doc = " dimension."]
    #[doc = ""]
    #[doc = " The \\p extent field defines the dimensions of the transferred area in"]
    #[doc = " elements. If a CUDA array is participating in the copy, the extent is"]
    #[doc = " defined in terms of that array's elements. If no CUDA array is"]
    #[doc = " participating in the copy then the extents are defined in elements of"]
    #[doc = " <b>unsigned char</b>."]
    #[doc = ""]
    #[doc = " The \\p kind field defines the direction of the copy. It must be one of"]
    #[doc = " ::cudaMemcpyHostToHost, ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = " For ::cudaMemcpyHostToHost or ::cudaMemcpyHostToDevice or ::cudaMemcpyDeviceToHost"]
    #[doc = " passed as kind and cudaArray type passed as source or destination, if the kind"]
    #[doc = " implies cudaArray type to be present on the host, ::cudaMemcpy3DAsync() will"]
    #[doc = " disregard that implication and silently correct the kind based on the fact that"]
    #[doc = " cudaArray type can only be present on the device."]
    #[doc = ""]
    #[doc = " If the source and destination are both arrays, ::cudaMemcpy3DAsync() will"]
    #[doc = " return an error if they do not have the same element size."]
    #[doc = ""]
    #[doc = " The source and destination object may not overlap. If overlapping source"]
    #[doc = " and destination objects are specified, undefined behavior will result."]
    #[doc = ""]
    #[doc = " The source object must lie entirely within the region defined by \\p srcPos"]
    #[doc = " and \\p extent. The destination object must lie entirely within the region"]
    #[doc = " defined by \\p dstPos and \\p extent."]
    #[doc = ""]
    #[doc = " ::cudaMemcpy3DAsync() returns an error if the pitch of \\p srcPtr or"]
    #[doc = " \\p dstPtr exceeds the maximum allowed. The pitch of a"]
    #[doc = " ::cudaPitchedPtr allocated with ::cudaMalloc3D() will always be valid."]
    #[doc = ""]
    #[doc = " ::cudaMemcpy3DAsync() is asynchronous with respect to the host, so"]
    #[doc = " the call may return before the copy is complete. The copy can optionally"]
    #[doc = " be associated to a stream by passing a non-zero \\p stream argument. If"]
    #[doc = " \\p kind is ::cudaMemcpyHostToDevice or ::cudaMemcpyDeviceToHost and \\p stream"]
    #[doc = " is non-zero, the copy may overlap with operations in other streams."]
    #[doc = ""]
    #[doc = " The device version of this function only handles device to device copies and"]
    #[doc = " cannot be given local or shared pointers."]
    #[doc = ""]
    #[doc = " \\param p      - 3D memory copy parameters"]
    #[doc = " \\param stream - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidPitchValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMalloc3D, ::cudaMalloc3DArray, ::cudaMemset3D, ::cudaMemcpy3D,"]
    #[doc = " ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray, :::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::make_cudaExtent, ::make_cudaPos,"]
    #[doc = " ::cuMemcpy3DAsync"]
    pub fn cudaMemcpy3DAsync(p: *const cudaMemcpy3DParms, stream: cudaStream_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies memory between devices asynchronously."]
    #[doc = ""]
    #[doc = " Perform a 3D memory copy according to the parameters specified in"]
    #[doc = " \\p p.  See the definition of the ::cudaMemcpy3DPeerParms structure"]
    #[doc = " for documentation of its parameters."]
    #[doc = ""]
    #[doc = " \\param p      - Parameters for the memory copy"]
    #[doc = " \\param stream - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpyPeer, ::cudaMemcpyAsync, ::cudaMemcpyPeerAsync,"]
    #[doc = " ::cudaMemcpy3DPeerAsync,"]
    #[doc = " ::cuMemcpy3DPeerAsync"]
    pub fn cudaMemcpy3DPeerAsync(
        p: *const cudaMemcpy3DPeerParms,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Gets free and total device memory"]
    #[doc = ""]
    #[doc = " Returns in \\p *free and \\p *total respectively, the free and total amount of"]
    #[doc = " memory available for allocation by the device in bytes."]
    #[doc = ""]
    #[doc = " \\param free  - Returned free memory in bytes"]
    #[doc = " \\param total - Returned total memory in bytes"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorLaunchFailure"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cuMemGetInfo"]
    pub fn cudaMemGetInfo(free: *mut usize, total: *mut usize) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Gets info about the specified cudaArray"]
    #[doc = ""]
    #[doc = " Returns in \\p *desc, \\p *extent and \\p *flags respectively, the type, shape"]
    #[doc = " and flags of \\p array."]
    #[doc = ""]
    #[doc = " Any of \\p *desc, \\p *extent and \\p *flags may be specified as NULL."]
    #[doc = ""]
    #[doc = " \\param desc   - Returned array type"]
    #[doc = " \\param extent - Returned array shape. 2D arrays will have depth of zero"]
    #[doc = " \\param flags  - Returned array flags"]
    #[doc = " \\param array  - The ::cudaArray to get info for"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cuArrayGetDescriptor,"]
    #[doc = " ::cuArray3DGetDescriptor"]
    pub fn cudaArrayGetInfo(
        desc: *mut cudaChannelFormatDesc,
        extent: *mut cudaExtent,
        flags: *mut ::libc::c_uint,
        array: cudaArray_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Gets a CUDA array plane from a CUDA array"]
    #[doc = ""]
    #[doc = " Returns in \\p pPlaneArray a CUDA array that represents a single format plane"]
    #[doc = " of the CUDA array \\p hArray."]
    #[doc = ""]
    #[doc = " If \\p planeIdx is greater than the maximum number of planes in this array or if the array does"]
    #[doc = " not have a multi-planar format e.g: ::cudaChannelFormatKindNV12, then ::cudaErrorInvalidValue is returned."]
    #[doc = ""]
    #[doc = " Note that if the \\p hArray has format ::cudaChannelFormatKindNV12, then passing in 0 for \\p planeIdx returns"]
    #[doc = " a CUDA array of the same size as \\p hArray but with one 8-bit channel and ::cudaChannelFormatKindUnsigned as its format kind."]
    #[doc = " If 1 is passed for \\p planeIdx, then the returned CUDA array has half the height and width"]
    #[doc = " of \\p hArray with two 8-bit channels and ::cudaChannelFormatKindUnsigned as its format kind."]
    #[doc = ""]
    #[doc = " \\param pPlaneArray   - Returned CUDA array referenced by the \\p planeIdx"]
    #[doc = " \\param hArray        - CUDA array"]
    #[doc = " \\param planeIdx      - Plane index"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cuArrayGetPlane"]
    pub fn cudaArrayGetPlane(
        pPlaneArray: *mut cudaArray_t,
        hArray: cudaArray_t,
        planeIdx: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaArrayGetSparseProperties(
        sparseProperties: *mut cudaArraySparseProperties,
        array: cudaArray_t,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaMipmappedArrayGetSparseProperties(
        sparseProperties: *mut cudaArraySparseProperties,
        mipmap: cudaMipmappedArray_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " Copies \\p count bytes from the memory area pointed to by \\p src to the"]
    #[doc = " memory area pointed to by \\p dst, where \\p kind specifies the direction"]
    #[doc = " of the copy, and must be one of ::cudaMemcpyHostToHost,"]
    #[doc = " ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing. Calling"]
    #[doc = " ::cudaMemcpy() with dst and src pointers that do not match the direction of"]
    #[doc = " the copy results in an undefined behavior."]
    #[doc = ""]
    #[doc = " \\param dst   - Destination memory address"]
    #[doc = " \\param src   - Source memory address"]
    #[doc = " \\param count - Size in bytes to copy"]
    #[doc = " \\param kind  - Type of transfer"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\note_sync"]
    #[doc = " \\note_memcpy"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpyDtoH,"]
    #[doc = " ::cuMemcpyHtoD,"]
    #[doc = " ::cuMemcpyDtoD,"]
    #[doc = " ::cuMemcpy"]
    pub fn cudaMemcpy(
        dst: *mut ::libc::c_void,
        src: *const ::libc::c_void,
        count: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies memory between two devices"]
    #[doc = ""]
    #[doc = " Copies memory from one device to memory on another device.  \\p dst is the"]
    #[doc = " base device pointer of the destination memory and \\p dstDevice is the"]
    #[doc = " destination device.  \\p src is the base device pointer of the source memory"]
    #[doc = " and \\p srcDevice is the source device.  \\p count specifies the number of bytes"]
    #[doc = " to copy."]
    #[doc = ""]
    #[doc = " Note that this function is asynchronous with respect to the host, but"]
    #[doc = " serialized with respect all pending and future asynchronous work in to the"]
    #[doc = " current device, \\p srcDevice, and \\p dstDevice (use ::cudaMemcpyPeerAsync"]
    #[doc = " to avoid this synchronization)."]
    #[doc = ""]
    #[doc = " \\param dst       - Destination device pointer"]
    #[doc = " \\param dstDevice - Destination device"]
    #[doc = " \\param src       - Source device pointer"]
    #[doc = " \\param srcDevice - Source device"]
    #[doc = " \\param count     - Size of memory copy in bytes"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_sync"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpyAsync, ::cudaMemcpyPeerAsync,"]
    #[doc = " ::cudaMemcpy3DPeerAsync,"]
    #[doc = " ::cuMemcpyPeer"]
    pub fn cudaMemcpyPeer(
        dst: *mut ::libc::c_void,
        dstDevice: ::libc::c_int,
        src: *const ::libc::c_void,
        srcDevice: ::libc::c_int,
        count: usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " Copies a matrix (\\p height rows of \\p width bytes each) from the memory"]
    #[doc = " area pointed to by \\p src to the memory area pointed to by \\p dst, where"]
    #[doc = " \\p kind specifies the direction of the copy, and must be one of"]
    #[doc = " ::cudaMemcpyHostToHost, ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing. \\p dpitch and"]
    #[doc = " \\p spitch are the widths in memory in bytes of the 2D arrays pointed to by"]
    #[doc = " \\p dst and \\p src, including any padding added to the end of each row. The"]
    #[doc = " memory areas may not overlap. \\p width must not exceed either \\p dpitch or"]
    #[doc = " \\p spitch. Calling ::cudaMemcpy2D() with \\p dst and \\p src pointers that do"]
    #[doc = " not match the direction of the copy results in an undefined behavior."]
    #[doc = " ::cudaMemcpy2D() returns an error if \\p dpitch or \\p spitch exceeds"]
    #[doc = " the maximum allowed."]
    #[doc = ""]
    #[doc = " \\param dst    - Destination memory address"]
    #[doc = " \\param dpitch - Pitch of destination memory"]
    #[doc = " \\param src    - Source memory address"]
    #[doc = " \\param spitch - Pitch of source memory"]
    #[doc = " \\param width  - Width of matrix transfer (columns in bytes)"]
    #[doc = " \\param height - Height of matrix transfer (rows)"]
    #[doc = " \\param kind   - Type of transfer"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidPitchValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_memcpy"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpy2D,"]
    #[doc = " ::cuMemcpy2DUnaligned"]
    pub fn cudaMemcpy2D(
        dst: *mut ::libc::c_void,
        dpitch: usize,
        src: *const ::libc::c_void,
        spitch: usize,
        width: usize,
        height: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " Copies a matrix (\\p height rows of \\p width bytes each) from the memory"]
    #[doc = " area pointed to by \\p src to the CUDA array \\p dst starting at"]
    #[doc = " \\p hOffset rows and \\p wOffset bytes from the upper left corner,"]
    #[doc = " where \\p kind specifies the direction of the copy, and must be one"]
    #[doc = " of ::cudaMemcpyHostToHost, ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = " \\p spitch is the width in memory in bytes of the 2D array pointed to by"]
    #[doc = " \\p src, including any padding added to the end of each row. \\p wOffset +"]
    #[doc = " \\p width must not exceed the width of the CUDA array \\p dst. \\p width must"]
    #[doc = " not exceed \\p spitch. ::cudaMemcpy2DToArray() returns an error if \\p spitch"]
    #[doc = " exceeds the maximum allowed."]
    #[doc = ""]
    #[doc = " \\param dst     - Destination memory address"]
    #[doc = " \\param wOffset - Destination starting X offset (columns in bytes)"]
    #[doc = " \\param hOffset - Destination starting Y offset (rows)"]
    #[doc = " \\param src     - Source memory address"]
    #[doc = " \\param spitch  - Pitch of source memory"]
    #[doc = " \\param width   - Width of matrix transfer (columns in bytes)"]
    #[doc = " \\param height  - Height of matrix transfer (rows)"]
    #[doc = " \\param kind    - Type of transfer"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidPitchValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_sync"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_memcpy"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpy2D,"]
    #[doc = " ::cuMemcpy2DUnaligned"]
    pub fn cudaMemcpy2DToArray(
        dst: cudaArray_t,
        wOffset: usize,
        hOffset: usize,
        src: *const ::libc::c_void,
        spitch: usize,
        width: usize,
        height: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " Copies a matrix (\\p height rows of \\p width bytes each) from the CUDA"]
    #[doc = " array \\p src starting at \\p hOffset rows and \\p wOffset bytes from the"]
    #[doc = " upper left corner to the memory area pointed to by \\p dst, where"]
    #[doc = " \\p kind specifies the direction of the copy, and must be one of"]
    #[doc = " ::cudaMemcpyHostToHost, ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing. \\p dpitch is the"]
    #[doc = " width in memory in bytes of the 2D array pointed to by \\p dst, including any"]
    #[doc = " padding added to the end of each row. \\p wOffset + \\p width must not exceed"]
    #[doc = " the width of the CUDA array \\p src. \\p width must not exceed \\p dpitch."]
    #[doc = " ::cudaMemcpy2DFromArray() returns an error if \\p dpitch exceeds the maximum"]
    #[doc = " allowed."]
    #[doc = ""]
    #[doc = " \\param dst     - Destination memory address"]
    #[doc = " \\param dpitch  - Pitch of destination memory"]
    #[doc = " \\param src     - Source memory address"]
    #[doc = " \\param wOffset - Source starting X offset (columns in bytes)"]
    #[doc = " \\param hOffset - Source starting Y offset (rows)"]
    #[doc = " \\param width   - Width of matrix transfer (columns in bytes)"]
    #[doc = " \\param height  - Height of matrix transfer (rows)"]
    #[doc = " \\param kind    - Type of transfer"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidPitchValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_sync"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_memcpy"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpy2D,"]
    #[doc = " ::cuMemcpy2DUnaligned"]
    pub fn cudaMemcpy2DFromArray(
        dst: *mut ::libc::c_void,
        dpitch: usize,
        src: cudaArray_const_t,
        wOffset: usize,
        hOffset: usize,
        width: usize,
        height: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " Copies a matrix (\\p height rows of \\p width bytes each) from the CUDA"]
    #[doc = " array \\p src starting at \\p hOffsetSrc rows and \\p wOffsetSrc bytes from the"]
    #[doc = " upper left corner to the CUDA array \\p dst starting at \\p hOffsetDst rows"]
    #[doc = " and \\p wOffsetDst bytes from the upper left corner, where \\p kind"]
    #[doc = " specifies the direction of the copy, and must be one of"]
    #[doc = " ::cudaMemcpyHostToHost, ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = " \\p wOffsetDst + \\p width must not exceed the width of the CUDA array \\p dst."]
    #[doc = " \\p wOffsetSrc + \\p width must not exceed the width of the CUDA array \\p src."]
    #[doc = ""]
    #[doc = " \\param dst        - Destination memory address"]
    #[doc = " \\param wOffsetDst - Destination starting X offset (columns in bytes)"]
    #[doc = " \\param hOffsetDst - Destination starting Y offset (rows)"]
    #[doc = " \\param src        - Source memory address"]
    #[doc = " \\param wOffsetSrc - Source starting X offset (columns in bytes)"]
    #[doc = " \\param hOffsetSrc - Source starting Y offset (rows)"]
    #[doc = " \\param width      - Width of matrix transfer (columns in bytes)"]
    #[doc = " \\param height     - Height of matrix transfer (rows)"]
    #[doc = " \\param kind       - Type of transfer"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_sync"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpy2D,"]
    #[doc = " ::cuMemcpy2DUnaligned"]
    pub fn cudaMemcpy2DArrayToArray(
        dst: cudaArray_t,
        wOffsetDst: usize,
        hOffsetDst: usize,
        src: cudaArray_const_t,
        wOffsetSrc: usize,
        hOffsetSrc: usize,
        width: usize,
        height: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data to the given symbol on the device"]
    #[doc = ""]
    #[doc = " Copies \\p count bytes from the memory area pointed to by \\p src"]
    #[doc = " to the memory area pointed to by \\p offset bytes from the start of symbol"]
    #[doc = " \\p symbol. The memory areas may not overlap. \\p symbol is a variable that"]
    #[doc = " resides in global or constant memory space. \\p kind can be either"]
    #[doc = " ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault."]
    #[doc = " Passing ::cudaMemcpyDefault is recommended, in which case the type of"]
    #[doc = " transfer is inferred from the pointer values. However, ::cudaMemcpyDefault"]
    #[doc = " is only allowed on systems that support unified virtual addressing."]
    #[doc = ""]
    #[doc = " \\param symbol - Device symbol address"]
    #[doc = " \\param src    - Source memory address"]
    #[doc = " \\param count  - Size in bytes to copy"]
    #[doc = " \\param offset - Offset from start of symbol in bytes"]
    #[doc = " \\param kind   - Type of transfer"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidSymbol,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection,"]
    #[doc = " ::cudaErrorNoKernelImageForDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_sync"]
    #[doc = " \\note_string_api_deprecation"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray,  ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpy,"]
    #[doc = " ::cuMemcpyHtoD,"]
    #[doc = " ::cuMemcpyDtoD"]
    pub fn cudaMemcpyToSymbol(
        symbol: *const ::libc::c_void,
        src: *const ::libc::c_void,
        count: usize,
        offset: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data from the given symbol on the device"]
    #[doc = ""]
    #[doc = " Copies \\p count bytes from the memory area pointed to by \\p offset bytes"]
    #[doc = " from the start of symbol \\p symbol to the memory area pointed to by \\p dst."]
    #[doc = " The memory areas may not overlap. \\p symbol is a variable that"]
    #[doc = " resides in global or constant memory space. \\p kind can be either"]
    #[doc = " ::cudaMemcpyDeviceToHost, ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault."]
    #[doc = " Passing ::cudaMemcpyDefault is recommended, in which case the type of"]
    #[doc = " transfer is inferred from the pointer values. However, ::cudaMemcpyDefault"]
    #[doc = " is only allowed on systems that support unified virtual addressing."]
    #[doc = ""]
    #[doc = " \\param dst    - Destination memory address"]
    #[doc = " \\param symbol - Device symbol address"]
    #[doc = " \\param count  - Size in bytes to copy"]
    #[doc = " \\param offset - Offset from start of symbol in bytes"]
    #[doc = " \\param kind   - Type of transfer"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidSymbol,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection,"]
    #[doc = " ::cudaErrorNoKernelImageForDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_sync"]
    #[doc = " \\note_string_api_deprecation"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpy,"]
    #[doc = " ::cuMemcpyDtoH,"]
    #[doc = " ::cuMemcpyDtoD"]
    pub fn cudaMemcpyFromSymbol(
        dst: *mut ::libc::c_void,
        symbol: *const ::libc::c_void,
        count: usize,
        offset: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " Copies \\p count bytes from the memory area pointed to by \\p src to the"]
    #[doc = " memory area pointed to by \\p dst, where \\p kind specifies the"]
    #[doc = " direction of the copy, and must be one of ::cudaMemcpyHostToHost,"]
    #[doc = " ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = ""]
    #[doc = " The memory areas may not overlap. Calling ::cudaMemcpyAsync() with \\p dst and"]
    #[doc = " \\p src pointers that do not match the direction of the copy results in an"]
    #[doc = " undefined behavior."]
    #[doc = ""]
    #[doc = " ::cudaMemcpyAsync() is asynchronous with respect to the host, so the call"]
    #[doc = " may return before the copy is complete. The copy can optionally be"]
    #[doc = " associated to a stream by passing a non-zero \\p stream argument. If \\p kind"]
    #[doc = " is ::cudaMemcpyHostToDevice or ::cudaMemcpyDeviceToHost and the \\p stream is"]
    #[doc = " non-zero, the copy may overlap with operations in other streams."]
    #[doc = ""]
    #[doc = " The device version of this function only handles device to device copies and"]
    #[doc = " cannot be given local or shared pointers."]
    #[doc = ""]
    #[doc = " \\param dst    - Destination memory address"]
    #[doc = " \\param src    - Source memory address"]
    #[doc = " \\param count  - Size in bytes to copy"]
    #[doc = " \\param kind   - Type of transfer"]
    #[doc = " \\param stream - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_memcpy"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpyAsync,"]
    #[doc = " ::cuMemcpyDtoHAsync,"]
    #[doc = " ::cuMemcpyHtoDAsync,"]
    #[doc = " ::cuMemcpyDtoDAsync"]
    pub fn cudaMemcpyAsync(
        dst: *mut ::libc::c_void,
        src: *const ::libc::c_void,
        count: usize,
        kind: cudaMemcpyKind,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies memory between two devices asynchronously."]
    #[doc = ""]
    #[doc = " Copies memory from one device to memory on another device.  \\p dst is the"]
    #[doc = " base device pointer of the destination memory and \\p dstDevice is the"]
    #[doc = " destination device.  \\p src is the base device pointer of the source memory"]
    #[doc = " and \\p srcDevice is the source device.  \\p count specifies the number of bytes"]
    #[doc = " to copy."]
    #[doc = ""]
    #[doc = " Note that this function is asynchronous with respect to the host and all work"]
    #[doc = " on other devices."]
    #[doc = ""]
    #[doc = " \\param dst       - Destination device pointer"]
    #[doc = " \\param dstDevice - Destination device"]
    #[doc = " \\param src       - Source device pointer"]
    #[doc = " \\param srcDevice - Source device"]
    #[doc = " \\param count     - Size of memory copy in bytes"]
    #[doc = " \\param stream    - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpyPeer, ::cudaMemcpyAsync,"]
    #[doc = " ::cudaMemcpy3DPeerAsync,"]
    #[doc = " ::cuMemcpyPeerAsync"]
    pub fn cudaMemcpyPeerAsync(
        dst: *mut ::libc::c_void,
        dstDevice: ::libc::c_int,
        src: *const ::libc::c_void,
        srcDevice: ::libc::c_int,
        count: usize,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " Copies a matrix (\\p height rows of \\p width bytes each) from the memory"]
    #[doc = " area pointed to by \\p src to the memory area pointed to by \\p dst, where"]
    #[doc = " \\p kind specifies the direction of the copy, and must be one of"]
    #[doc = " ::cudaMemcpyHostToHost, ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = " \\p dpitch and \\p spitch are the widths in memory in bytes of the 2D arrays"]
    #[doc = " pointed to by \\p dst and \\p src, including any padding added to the end of"]
    #[doc = " each row. The memory areas may not overlap. \\p width must not exceed either"]
    #[doc = " \\p dpitch or \\p spitch."]
    #[doc = ""]
    #[doc = " Calling ::cudaMemcpy2DAsync() with \\p dst and \\p src pointers that do not"]
    #[doc = " match the direction of the copy results in an undefined behavior."]
    #[doc = " ::cudaMemcpy2DAsync() returns an error if \\p dpitch or \\p spitch is greater"]
    #[doc = " than the maximum allowed."]
    #[doc = ""]
    #[doc = " ::cudaMemcpy2DAsync() is asynchronous with respect to the host, so"]
    #[doc = " the call may return before the copy is complete. The copy can optionally"]
    #[doc = " be associated to a stream by passing a non-zero \\p stream argument. If"]
    #[doc = " \\p kind is ::cudaMemcpyHostToDevice or ::cudaMemcpyDeviceToHost and"]
    #[doc = " \\p stream is non-zero, the copy may overlap with operations in other"]
    #[doc = " streams."]
    #[doc = ""]
    #[doc = " The device version of this function only handles device to device copies and"]
    #[doc = " cannot be given local or shared pointers."]
    #[doc = ""]
    #[doc = " \\param dst    - Destination memory address"]
    #[doc = " \\param dpitch - Pitch of destination memory"]
    #[doc = " \\param src    - Source memory address"]
    #[doc = " \\param spitch - Pitch of source memory"]
    #[doc = " \\param width  - Width of matrix transfer (columns in bytes)"]
    #[doc = " \\param height - Height of matrix transfer (rows)"]
    #[doc = " \\param kind   - Type of transfer"]
    #[doc = " \\param stream - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidPitchValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_memcpy"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpy2DAsync"]
    pub fn cudaMemcpy2DAsync(
        dst: *mut ::libc::c_void,
        dpitch: usize,
        src: *const ::libc::c_void,
        spitch: usize,
        width: usize,
        height: usize,
        kind: cudaMemcpyKind,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " Copies a matrix (\\p height rows of \\p width bytes each) from the memory"]
    #[doc = " area pointed to by \\p src to the CUDA array \\p dst starting at \\p hOffset"]
    #[doc = " rows and \\p wOffset bytes from the upper left corner, where \\p kind specifies"]
    #[doc = " the direction of the copy, and must be one of ::cudaMemcpyHostToHost,"]
    #[doc = " ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = " \\p spitch is the width in memory in bytes of the 2D array pointed to by"]
    #[doc = " \\p src, including any padding added to the end of each row. \\p wOffset +"]
    #[doc = " \\p width must not exceed the width of the CUDA array \\p dst. \\p width must"]
    #[doc = " not exceed \\p spitch. ::cudaMemcpy2DToArrayAsync() returns an error if"]
    #[doc = " \\p spitch exceeds the maximum allowed."]
    #[doc = ""]
    #[doc = " ::cudaMemcpy2DToArrayAsync() is asynchronous with respect to the host, so"]
    #[doc = " the call may return before the copy is complete. The copy can optionally"]
    #[doc = " be associated to a stream by passing a non-zero \\p stream argument. If"]
    #[doc = " \\p kind is ::cudaMemcpyHostToDevice or ::cudaMemcpyDeviceToHost and"]
    #[doc = " \\p stream is non-zero, the copy may overlap with operations in other"]
    #[doc = " streams."]
    #[doc = ""]
    #[doc = " \\param dst     - Destination memory address"]
    #[doc = " \\param wOffset - Destination starting X offset (columns in bytes)"]
    #[doc = " \\param hOffset - Destination starting Y offset (rows)"]
    #[doc = " \\param src     - Source memory address"]
    #[doc = " \\param spitch  - Pitch of source memory"]
    #[doc = " \\param width   - Width of matrix transfer (columns in bytes)"]
    #[doc = " \\param height  - Height of matrix transfer (rows)"]
    #[doc = " \\param kind    - Type of transfer"]
    #[doc = " \\param stream  - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidPitchValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_memcpy"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = ""]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpy2DAsync"]
    pub fn cudaMemcpy2DToArrayAsync(
        dst: cudaArray_t,
        wOffset: usize,
        hOffset: usize,
        src: *const ::libc::c_void,
        spitch: usize,
        width: usize,
        height: usize,
        kind: cudaMemcpyKind,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " Copies a matrix (\\p height rows of \\p width bytes each) from the CUDA"]
    #[doc = " array \\p src starting at \\p hOffset rows and \\p wOffset bytes from the"]
    #[doc = " upper left corner to the memory area pointed to by \\p dst,"]
    #[doc = " where \\p kind specifies the direction of the copy, and must be one of"]
    #[doc = " ::cudaMemcpyHostToHost, ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = " \\p dpitch is the width in memory in bytes of the 2D"]
    #[doc = " array pointed to by \\p dst, including any padding added to the end of each"]
    #[doc = " row. \\p wOffset + \\p width must not exceed the width of the CUDA array"]
    #[doc = " \\p src. \\p width must not exceed \\p dpitch. ::cudaMemcpy2DFromArrayAsync()"]
    #[doc = " returns an error if \\p dpitch exceeds the maximum allowed."]
    #[doc = ""]
    #[doc = " ::cudaMemcpy2DFromArrayAsync() is asynchronous with respect to the host, so"]
    #[doc = " the call may return before the copy is complete. The copy can optionally be"]
    #[doc = " associated to a stream by passing a non-zero \\p stream argument. If \\p kind"]
    #[doc = " is ::cudaMemcpyHostToDevice or ::cudaMemcpyDeviceToHost and \\p stream is"]
    #[doc = " non-zero, the copy may overlap with operations in other streams."]
    #[doc = ""]
    #[doc = " \\param dst     - Destination memory address"]
    #[doc = " \\param dpitch  - Pitch of destination memory"]
    #[doc = " \\param src     - Source memory address"]
    #[doc = " \\param wOffset - Source starting X offset (columns in bytes)"]
    #[doc = " \\param hOffset - Source starting Y offset (rows)"]
    #[doc = " \\param width   - Width of matrix transfer (columns in bytes)"]
    #[doc = " \\param height  - Height of matrix transfer (rows)"]
    #[doc = " \\param kind    - Type of transfer"]
    #[doc = " \\param stream  - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidPitchValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_memcpy"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = ""]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpy2DAsync"]
    pub fn cudaMemcpy2DFromArrayAsync(
        dst: *mut ::libc::c_void,
        dpitch: usize,
        src: cudaArray_const_t,
        wOffset: usize,
        hOffset: usize,
        width: usize,
        height: usize,
        kind: cudaMemcpyKind,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data to the given symbol on the device"]
    #[doc = ""]
    #[doc = " Copies \\p count bytes from the memory area pointed to by \\p src"]
    #[doc = " to the memory area pointed to by \\p offset bytes from the start of symbol"]
    #[doc = " \\p symbol. The memory areas may not overlap. \\p symbol is a variable that"]
    #[doc = " resides in global or constant memory space. \\p kind can be either"]
    #[doc = " ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault."]
    #[doc = " Passing ::cudaMemcpyDefault is recommended, in which case the type of transfer"]
    #[doc = " is inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = ""]
    #[doc = " ::cudaMemcpyToSymbolAsync() is asynchronous with respect to the host, so"]
    #[doc = " the call may return before the copy is complete. The copy can optionally"]
    #[doc = " be associated to a stream by passing a non-zero \\p stream argument. If"]
    #[doc = " \\p kind is ::cudaMemcpyHostToDevice and \\p stream is non-zero, the copy"]
    #[doc = " may overlap with operations in other streams."]
    #[doc = ""]
    #[doc = " \\param symbol - Device symbol address"]
    #[doc = " \\param src    - Source memory address"]
    #[doc = " \\param count  - Size in bytes to copy"]
    #[doc = " \\param offset - Offset from start of symbol in bytes"]
    #[doc = " \\param kind   - Type of transfer"]
    #[doc = " \\param stream - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidSymbol,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection,"]
    #[doc = " ::cudaErrorNoKernelImageForDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_string_api_deprecation"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpyAsync,"]
    #[doc = " ::cuMemcpyHtoDAsync,"]
    #[doc = " ::cuMemcpyDtoDAsync"]
    pub fn cudaMemcpyToSymbolAsync(
        symbol: *const ::libc::c_void,
        src: *const ::libc::c_void,
        count: usize,
        offset: usize,
        kind: cudaMemcpyKind,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data from the given symbol on the device"]
    #[doc = ""]
    #[doc = " Copies \\p count bytes from the memory area pointed to by \\p offset bytes"]
    #[doc = " from the start of symbol \\p symbol to the memory area pointed to by \\p dst."]
    #[doc = " The memory areas may not overlap. \\p symbol is a variable that resides in"]
    #[doc = " global or constant memory space. \\p kind can be either"]
    #[doc = " ::cudaMemcpyDeviceToHost, ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault."]
    #[doc = " Passing ::cudaMemcpyDefault is recommended, in which case the type of transfer"]
    #[doc = " is inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = ""]
    #[doc = " ::cudaMemcpyFromSymbolAsync() is asynchronous with respect to the host, so"]
    #[doc = " the call may return before the copy is complete. The copy can optionally be"]
    #[doc = " associated to a stream by passing a non-zero \\p stream argument. If \\p kind"]
    #[doc = " is ::cudaMemcpyDeviceToHost and \\p stream is non-zero, the copy may overlap"]
    #[doc = " with operations in other streams."]
    #[doc = ""]
    #[doc = " \\param dst    - Destination memory address"]
    #[doc = " \\param symbol - Device symbol address"]
    #[doc = " \\param count  - Size in bytes to copy"]
    #[doc = " \\param offset - Offset from start of symbol in bytes"]
    #[doc = " \\param kind   - Type of transfer"]
    #[doc = " \\param stream - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidSymbol,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection,"]
    #[doc = " ::cudaErrorNoKernelImageForDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_string_api_deprecation"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync,"]
    #[doc = " ::cuMemcpyAsync,"]
    #[doc = " ::cuMemcpyDtoHAsync,"]
    #[doc = " ::cuMemcpyDtoDAsync"]
    pub fn cudaMemcpyFromSymbolAsync(
        dst: *mut ::libc::c_void,
        symbol: *const ::libc::c_void,
        count: usize,
        offset: usize,
        kind: cudaMemcpyKind,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Initializes or sets device memory to a value"]
    #[doc = ""]
    #[doc = " Fills the first \\p count bytes of the memory area pointed to by \\p devPtr"]
    #[doc = " with the constant byte value \\p value."]
    #[doc = ""]
    #[doc = " Note that this function is asynchronous with respect to the host unless"]
    #[doc = " \\p devPtr refers to pinned host memory."]
    #[doc = ""]
    #[doc = " \\param devPtr - Pointer to device memory"]
    #[doc = " \\param value  - Value to set for each byte of specified memory"]
    #[doc = " \\param count  - Size in bytes to set"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_memset"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cuMemsetD8,"]
    #[doc = " ::cuMemsetD16,"]
    #[doc = " ::cuMemsetD32"]
    pub fn cudaMemset(
        devPtr: *mut ::libc::c_void,
        value: ::libc::c_int,
        count: usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Initializes or sets device memory to a value"]
    #[doc = ""]
    #[doc = " Sets to the specified value \\p value a matrix (\\p height rows of \\p width"]
    #[doc = " bytes each) pointed to by \\p dstPtr. \\p pitch is the width in bytes of the"]
    #[doc = " 2D array pointed to by \\p dstPtr, including any padding added to the end"]
    #[doc = " of each row. This function performs fastest when the pitch is one that has"]
    #[doc = " been passed back by ::cudaMallocPitch()."]
    #[doc = ""]
    #[doc = " Note that this function is asynchronous with respect to the host unless"]
    #[doc = " \\p devPtr refers to pinned host memory."]
    #[doc = ""]
    #[doc = " \\param devPtr - Pointer to 2D device memory"]
    #[doc = " \\param pitch  - Pitch in bytes of 2D device memory(Unused if \\p height is 1)"]
    #[doc = " \\param value  - Value to set for each byte of specified memory"]
    #[doc = " \\param width  - Width of matrix set (columns in bytes)"]
    #[doc = " \\param height - Height of matrix set (rows)"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_memset"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemset, ::cudaMemset3D, ::cudaMemsetAsync,"]
    #[doc = " ::cudaMemset2DAsync, ::cudaMemset3DAsync,"]
    #[doc = " ::cuMemsetD2D8,"]
    #[doc = " ::cuMemsetD2D16,"]
    #[doc = " ::cuMemsetD2D32"]
    pub fn cudaMemset2D(
        devPtr: *mut ::libc::c_void,
        pitch: usize,
        value: ::libc::c_int,
        width: usize,
        height: usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Initializes or sets device memory to a value"]
    #[doc = ""]
    #[doc = " Initializes each element of a 3D array to the specified value \\p value."]
    #[doc = " The object to initialize is defined by \\p pitchedDevPtr. The \\p pitch field"]
    #[doc = " of \\p pitchedDevPtr is the width in memory in bytes of the 3D array pointed"]
    #[doc = " to by \\p pitchedDevPtr, including any padding added to the end of each row."]
    #[doc = " The \\p xsize field specifies the logical width of each row in bytes, while"]
    #[doc = " the \\p ysize field specifies the height of each 2D slice in rows."]
    #[doc = " The \\p pitch field of \\p pitchedDevPtr is ignored when \\p height and \\p depth"]
    #[doc = " are both equal to 1."]
    #[doc = ""]
    #[doc = " The extents of the initialized region are specified as a \\p width in bytes,"]
    #[doc = " a \\p height in rows, and a \\p depth in slices."]
    #[doc = ""]
    #[doc = " Extents with \\p width greater than or equal to the \\p xsize of"]
    #[doc = " \\p pitchedDevPtr may perform significantly faster than extents narrower"]
    #[doc = " than the \\p xsize. Secondarily, extents with \\p height equal to the"]
    #[doc = " \\p ysize of \\p pitchedDevPtr will perform faster than when the \\p height is"]
    #[doc = " shorter than the \\p ysize."]
    #[doc = ""]
    #[doc = " This function performs fastest when the \\p pitchedDevPtr has been allocated"]
    #[doc = " by ::cudaMalloc3D()."]
    #[doc = ""]
    #[doc = " Note that this function is asynchronous with respect to the host unless"]
    #[doc = " \\p pitchedDevPtr refers to pinned host memory."]
    #[doc = ""]
    #[doc = " \\param pitchedDevPtr - Pointer to pitched device memory"]
    #[doc = " \\param value         - Value to set for each byte of specified memory"]
    #[doc = " \\param extent        - Size parameters for where to set device memory (\\p width field in bytes)"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_memset"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemset, ::cudaMemset2D,"]
    #[doc = " ::cudaMemsetAsync, ::cudaMemset2DAsync, ::cudaMemset3DAsync,"]
    #[doc = " ::cudaMalloc3D, ::make_cudaPitchedPtr,"]
    #[doc = " ::make_cudaExtent"]
    pub fn cudaMemset3D(
        pitchedDevPtr: cudaPitchedPtr,
        value: ::libc::c_int,
        extent: cudaExtent,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Initializes or sets device memory to a value"]
    #[doc = ""]
    #[doc = " Fills the first \\p count bytes of the memory area pointed to by \\p devPtr"]
    #[doc = " with the constant byte value \\p value."]
    #[doc = ""]
    #[doc = " ::cudaMemsetAsync() is asynchronous with respect to the host, so"]
    #[doc = " the call may return before the memset is complete. The operation can optionally"]
    #[doc = " be associated to a stream by passing a non-zero \\p stream argument."]
    #[doc = " If \\p stream is non-zero, the operation may overlap with operations in other streams."]
    #[doc = ""]
    #[doc = " The device version of this function only handles device to device copies and"]
    #[doc = " cannot be given local or shared pointers."]
    #[doc = ""]
    #[doc = " \\param devPtr - Pointer to device memory"]
    #[doc = " \\param value  - Value to set for each byte of specified memory"]
    #[doc = " \\param count  - Size in bytes to set"]
    #[doc = " \\param stream - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_memset"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemset, ::cudaMemset2D, ::cudaMemset3D,"]
    #[doc = " ::cudaMemset2DAsync, ::cudaMemset3DAsync,"]
    #[doc = " ::cuMemsetD8Async,"]
    #[doc = " ::cuMemsetD16Async,"]
    #[doc = " ::cuMemsetD32Async"]
    pub fn cudaMemsetAsync(
        devPtr: *mut ::libc::c_void,
        value: ::libc::c_int,
        count: usize,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Initializes or sets device memory to a value"]
    #[doc = ""]
    #[doc = " Sets to the specified value \\p value a matrix (\\p height rows of \\p width"]
    #[doc = " bytes each) pointed to by \\p dstPtr. \\p pitch is the width in bytes of the"]
    #[doc = " 2D array pointed to by \\p dstPtr, including any padding added to the end"]
    #[doc = " of each row. This function performs fastest when the pitch is one that has"]
    #[doc = " been passed back by ::cudaMallocPitch()."]
    #[doc = ""]
    #[doc = " ::cudaMemset2DAsync() is asynchronous with respect to the host, so"]
    #[doc = " the call may return before the memset is complete. The operation can optionally"]
    #[doc = " be associated to a stream by passing a non-zero \\p stream argument."]
    #[doc = " If \\p stream is non-zero, the operation may overlap with operations in other streams."]
    #[doc = ""]
    #[doc = " The device version of this function only handles device to device copies and"]
    #[doc = " cannot be given local or shared pointers."]
    #[doc = ""]
    #[doc = " \\param devPtr - Pointer to 2D device memory"]
    #[doc = " \\param pitch  - Pitch in bytes of 2D device memory(Unused if \\p height is 1)"]
    #[doc = " \\param value  - Value to set for each byte of specified memory"]
    #[doc = " \\param width  - Width of matrix set (columns in bytes)"]
    #[doc = " \\param height - Height of matrix set (rows)"]
    #[doc = " \\param stream - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_memset"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemset, ::cudaMemset2D, ::cudaMemset3D,"]
    #[doc = " ::cudaMemsetAsync, ::cudaMemset3DAsync,"]
    #[doc = " ::cuMemsetD2D8Async,"]
    #[doc = " ::cuMemsetD2D16Async,"]
    #[doc = " ::cuMemsetD2D32Async"]
    pub fn cudaMemset2DAsync(
        devPtr: *mut ::libc::c_void,
        pitch: usize,
        value: ::libc::c_int,
        width: usize,
        height: usize,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Initializes or sets device memory to a value"]
    #[doc = ""]
    #[doc = " Initializes each element of a 3D array to the specified value \\p value."]
    #[doc = " The object to initialize is defined by \\p pitchedDevPtr. The \\p pitch field"]
    #[doc = " of \\p pitchedDevPtr is the width in memory in bytes of the 3D array pointed"]
    #[doc = " to by \\p pitchedDevPtr, including any padding added to the end of each row."]
    #[doc = " The \\p xsize field specifies the logical width of each row in bytes, while"]
    #[doc = " the \\p ysize field specifies the height of each 2D slice in rows."]
    #[doc = " The \\p pitch field of \\p pitchedDevPtr is ignored when \\p height and \\p depth"]
    #[doc = " are both equal to 1."]
    #[doc = ""]
    #[doc = " The extents of the initialized region are specified as a \\p width in bytes,"]
    #[doc = " a \\p height in rows, and a \\p depth in slices."]
    #[doc = ""]
    #[doc = " Extents with \\p width greater than or equal to the \\p xsize of"]
    #[doc = " \\p pitchedDevPtr may perform significantly faster than extents narrower"]
    #[doc = " than the \\p xsize. Secondarily, extents with \\p height equal to the"]
    #[doc = " \\p ysize of \\p pitchedDevPtr will perform faster than when the \\p height is"]
    #[doc = " shorter than the \\p ysize."]
    #[doc = ""]
    #[doc = " This function performs fastest when the \\p pitchedDevPtr has been allocated"]
    #[doc = " by ::cudaMalloc3D()."]
    #[doc = ""]
    #[doc = " ::cudaMemset3DAsync() is asynchronous with respect to the host, so"]
    #[doc = " the call may return before the memset is complete. The operation can optionally"]
    #[doc = " be associated to a stream by passing a non-zero \\p stream argument."]
    #[doc = " If \\p stream is non-zero, the operation may overlap with operations in other streams."]
    #[doc = ""]
    #[doc = " The device version of this function only handles device to device copies and"]
    #[doc = " cannot be given local or shared pointers."]
    #[doc = ""]
    #[doc = " \\param pitchedDevPtr - Pointer to pitched device memory"]
    #[doc = " \\param value         - Value to set for each byte of specified memory"]
    #[doc = " \\param extent        - Size parameters for where to set device memory (\\p width field in bytes)"]
    #[doc = " \\param stream - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_memset"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemset, ::cudaMemset2D, ::cudaMemset3D,"]
    #[doc = " ::cudaMemsetAsync, ::cudaMemset2DAsync,"]
    #[doc = " ::cudaMalloc3D, ::make_cudaPitchedPtr,"]
    #[doc = " ::make_cudaExtent"]
    pub fn cudaMemset3DAsync(
        pitchedDevPtr: cudaPitchedPtr,
        value: ::libc::c_int,
        extent: cudaExtent,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Finds the address associated with a CUDA symbol"]
    #[doc = ""]
    #[doc = " Returns in \\p *devPtr the address of symbol \\p symbol on the device."]
    #[doc = " \\p symbol is a variable that resides in global or constant memory space."]
    #[doc = " If \\p symbol cannot be found, or if \\p symbol is not declared in the"]
    #[doc = " global or constant memory space, \\p *devPtr is unchanged and the error"]
    #[doc = " ::cudaErrorInvalidSymbol is returned."]
    #[doc = ""]
    #[doc = " \\param devPtr - Return device pointer associated with symbol"]
    #[doc = " \\param symbol - Device symbol address"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidSymbol,"]
    #[doc = " ::cudaErrorNoKernelImageForDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_string_api_deprecation"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " \\ref ::cudaGetSymbolAddress(void**, const T&) \"cudaGetSymbolAddress (C++ API)\","]
    #[doc = " \\ref ::cudaGetSymbolSize(size_t*, const void*) \"cudaGetSymbolSize (C API)\","]
    #[doc = " ::cuModuleGetGlobal"]
    pub fn cudaGetSymbolAddress(
        devPtr: *mut *mut ::libc::c_void,
        symbol: *const ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Finds the size of the object associated with a CUDA symbol"]
    #[doc = ""]
    #[doc = " Returns in \\p *size the size of symbol \\p symbol. \\p symbol is a variable that"]
    #[doc = " resides in global or constant memory space. If \\p symbol cannot be found, or"]
    #[doc = " if \\p symbol is not declared in global or constant memory space, \\p *size is"]
    #[doc = " unchanged and the error ::cudaErrorInvalidSymbol is returned."]
    #[doc = ""]
    #[doc = " \\param size   - Size of object associated with symbol"]
    #[doc = " \\param symbol - Device symbol address"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidSymbol,"]
    #[doc = " ::cudaErrorNoKernelImageForDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_string_api_deprecation"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " \\ref ::cudaGetSymbolAddress(void**, const void*) \"cudaGetSymbolAddress (C API)\","]
    #[doc = " \\ref ::cudaGetSymbolSize(size_t*, const T&) \"cudaGetSymbolSize (C++ API)\","]
    #[doc = " ::cuModuleGetGlobal"]
    pub fn cudaGetSymbolSize(size: *mut usize, symbol: *const ::libc::c_void) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Prefetches memory to the specified destination device"]
    #[doc = ""]
    #[doc = " Prefetches memory to the specified destination device.  \\p devPtr is the"]
    #[doc = " base device pointer of the memory to be prefetched and \\p dstDevice is the"]
    #[doc = " destination device. \\p count specifies the number of bytes to copy. \\p stream"]
    #[doc = " is the stream in which the operation is enqueued. The memory range must refer"]
    #[doc = " to managed memory allocated via ::cudaMallocManaged or declared via __managed__ variables."]
    #[doc = ""]
    #[doc = " Passing in cudaCpuDeviceId for \\p dstDevice will prefetch the data to host memory. If"]
    #[doc = " \\p dstDevice is a GPU, then the device attribute ::cudaDevAttrConcurrentManagedAccess"]
    #[doc = " must be non-zero. Additionally, \\p stream must be associated with a device that has a"]
    #[doc = " non-zero value for the device attribute ::cudaDevAttrConcurrentManagedAccess."]
    #[doc = ""]
    #[doc = " The start address and end address of the memory range will be rounded down and rounded up"]
    #[doc = " respectively to be aligned to CPU page size before the prefetch operation is enqueued"]
    #[doc = " in the stream."]
    #[doc = ""]
    #[doc = " If no physical memory has been allocated for this region, then this memory region"]
    #[doc = " will be populated and mapped on the destination device. If there's insufficient"]
    #[doc = " memory to prefetch the desired region, the Unified Memory driver may evict pages from other"]
    #[doc = " ::cudaMallocManaged allocations to host memory in order to make room. Device memory"]
    #[doc = " allocated using ::cudaMalloc or ::cudaMallocArray will not be evicted."]
    #[doc = ""]
    #[doc = " By default, any mappings to the previous location of the migrated pages are removed and"]
    #[doc = " mappings for the new location are only setup on \\p dstDevice. The exact behavior however"]
    #[doc = " also depends on the settings applied to this memory range via ::cudaMemAdvise as described"]
    #[doc = " below:"]
    #[doc = ""]
    #[doc = " If ::cudaMemAdviseSetReadMostly was set on any subset of this memory range,"]
    #[doc = " then that subset will create a read-only copy of the pages on \\p dstDevice."]
    #[doc = ""]
    #[doc = " If ::cudaMemAdviseSetPreferredLocation was called on any subset of this memory"]
    #[doc = " range, then the pages will be migrated to \\p dstDevice even if \\p dstDevice is not the"]
    #[doc = " preferred location of any pages in the memory range."]
    #[doc = ""]
    #[doc = " If ::cudaMemAdviseSetAccessedBy was called on any subset of this memory range,"]
    #[doc = " then mappings to those pages from all the appropriate processors are updated to"]
    #[doc = " refer to the new location if establishing such a mapping is possible. Otherwise,"]
    #[doc = " those mappings are cleared."]
    #[doc = ""]
    #[doc = " Note that this API is not required for functionality and only serves to improve performance"]
    #[doc = " by allowing the application to migrate data to a suitable location before it is accessed."]
    #[doc = " Memory accesses to this range are always coherent and are allowed even when the data is"]
    #[doc = " actively being migrated."]
    #[doc = ""]
    #[doc = " Note that this function is asynchronous with respect to the host and all work"]
    #[doc = " on other devices."]
    #[doc = ""]
    #[doc = " \\param devPtr    - Pointer to be prefetched"]
    #[doc = " \\param count     - Size in bytes"]
    #[doc = " \\param dstDevice - Destination device to prefetch to"]
    #[doc = " \\param stream    - Stream to enqueue prefetch operation"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpyPeer, ::cudaMemcpyAsync,"]
    #[doc = " ::cudaMemcpy3DPeerAsync, ::cudaMemAdvise,"]
    #[doc = " ::cuMemPrefetchAsync"]
    pub fn cudaMemPrefetchAsync(
        devPtr: *const ::libc::c_void,
        count: usize,
        dstDevice: ::libc::c_int,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Advise about the usage of a given memory range"]
    #[doc = ""]
    #[doc = " Advise the Unified Memory subsystem about the usage pattern for the memory range"]
    #[doc = " starting at \\p devPtr with a size of \\p count bytes. The start address and end address of the memory"]
    #[doc = " range will be rounded down and rounded up respectively to be aligned to CPU page size before the"]
    #[doc = " advice is applied. The memory range must refer to managed memory allocated via ::cudaMallocManaged"]
    #[doc = " or declared via __managed__ variables. The memory range could also refer to system-allocated pageable"]
    #[doc = " memory provided it represents a valid, host-accessible region of memory and all additional constraints"]
    #[doc = " imposed by \\p advice as outlined below are also satisfied. Specifying an invalid system-allocated pageable"]
    #[doc = " memory range results in an error being returned."]
    #[doc = ""]
    #[doc = " The \\p advice parameter can take the following values:"]
    #[doc = " - ::cudaMemAdviseSetReadMostly: This implies that the data is mostly going to be read"]
    #[doc = " from and only occasionally written to. Any read accesses from any processor to this region will create a"]
    #[doc = " read-only copy of at least the accessed pages in that processor's memory. Additionally, if ::cudaMemPrefetchAsync"]
    #[doc = " is called on this region, it will create a read-only copy of the data on the destination processor."]
    #[doc = " If any processor writes to this region, all copies of the corresponding page will be invalidated"]
    #[doc = " except for the one where the write occurred. The \\p device argument is ignored for this advice."]
    #[doc = " Note that for a page to be read-duplicated, the accessing processor must either be the CPU or a GPU"]
    #[doc = " that has a non-zero value for the device attribute ::cudaDevAttrConcurrentManagedAccess."]
    #[doc = " Also, if a context is created on a device that does not have the device attribute"]
    #[doc = " ::cudaDevAttrConcurrentManagedAccess set, then read-duplication will not occur until"]
    #[doc = " all such contexts are destroyed."]
    #[doc = " If the memory region refers to valid system-allocated pageable memory, then the accessing device must"]
    #[doc = " have a non-zero value for the device attribute ::cudaDevAttrPageableMemoryAccess for a read-only"]
    #[doc = " copy to be created on that device. Note however that if the accessing device also has a non-zero value for the"]
    #[doc = " device attribute ::cudaDevAttrPageableMemoryAccessUsesHostPageTables, then setting this advice"]
    #[doc = " will not create a read-only copy when that device accesses this memory region."]
    #[doc = ""]
    #[doc = " - ::cudaMemAdviceUnsetReadMostly: Undoes the effect of ::cudaMemAdviceReadMostly and also prevents the"]
    #[doc = " Unified Memory driver from attempting heuristic read-duplication on the memory range. Any read-duplicated"]
    #[doc = " copies of the data will be collapsed into a single copy. The location for the collapsed"]
    #[doc = " copy will be the preferred location if the page has a preferred location and one of the read-duplicated"]
    #[doc = " copies was resident at that location. Otherwise, the location chosen is arbitrary."]
    #[doc = ""]
    #[doc = " - ::cudaMemAdviseSetPreferredLocation: This advice sets the preferred location for the"]
    #[doc = " data to be the memory belonging to \\p device. Passing in cudaCpuDeviceId for \\p device sets the"]
    #[doc = " preferred location as host memory. If \\p device is a GPU, then it must have a non-zero value for the"]
    #[doc = " device attribute ::cudaDevAttrConcurrentManagedAccess. Setting the preferred location"]
    #[doc = " does not cause data to migrate to that location immediately. Instead, it guides the migration policy"]
    #[doc = " when a fault occurs on that memory region. If the data is already in its preferred location and the"]
    #[doc = " faulting processor can establish a mapping without requiring the data to be migrated, then"]
    #[doc = " data migration will be avoided. On the other hand, if the data is not in its preferred location"]
    #[doc = " or if a direct mapping cannot be established, then it will be migrated to the processor accessing"]
    #[doc = " it. It is important to note that setting the preferred location does not prevent data prefetching"]
    #[doc = " done using ::cudaMemPrefetchAsync."]
    #[doc = " Having a preferred location can override the page thrash detection and resolution logic in the Unified"]
    #[doc = " Memory driver. Normally, if a page is detected to be constantly thrashing between for example host and device"]
    #[doc = " memory, the page may eventually be pinned to host memory by the Unified Memory driver. But"]
    #[doc = " if the preferred location is set as device memory, then the page will continue to thrash indefinitely."]
    #[doc = " If ::cudaMemAdviseSetReadMostly is also set on this memory region or any subset of it, then the"]
    #[doc = " policies associated with that advice will override the policies of this advice, unless read accesses from"]
    #[doc = " \\p device will not result in a read-only copy being created on that device as outlined in description for"]
    #[doc = " the advice ::cudaMemAdviseSetReadMostly."]
    #[doc = " If the memory region refers to valid system-allocated pageable memory, then \\p device must have a non-zero"]
    #[doc = " value for the device attribute ::cudaDevAttrPageableMemoryAccess. Additionally, if \\p device has"]
    #[doc = " a non-zero value for the device attribute ::cudaDevAttrPageableMemoryAccessUsesHostPageTables,"]
    #[doc = " then this call has no effect. Note however that this behavior may change in the future."]
    #[doc = ""]
    #[doc = " - ::cudaMemAdviseUnsetPreferredLocation: Undoes the effect of ::cudaMemAdviseSetPreferredLocation"]
    #[doc = " and changes the preferred location to none."]
    #[doc = ""]
    #[doc = " - ::cudaMemAdviseSetAccessedBy: This advice implies that the data will be accessed by \\p device."]
    #[doc = " Passing in ::cudaCpuDeviceId for \\p device will set the advice for the CPU. If \\p device is a GPU, then"]
    #[doc = " the device attribute ::cudaDevAttrConcurrentManagedAccess must be non-zero."]
    #[doc = " This advice does not cause data migration and has no impact on the location of the data per se. Instead,"]
    #[doc = " it causes the data to always be mapped in the specified processor's page tables, as long as the"]
    #[doc = " location of the data permits a mapping to be established. If the data gets migrated for any reason,"]
    #[doc = " the mappings are updated accordingly."]
    #[doc = " This advice is recommended in scenarios where data locality is not important, but avoiding faults is."]
    #[doc = " Consider for example a system containing multiple GPUs with peer-to-peer access enabled, where the"]
    #[doc = " data located on one GPU is occasionally accessed by peer GPUs. In such scenarios, migrating data"]
    #[doc = " over to the other GPUs is not as important because the accesses are infrequent and the overhead of"]
    #[doc = " migration may be too high. But preventing faults can still help improve performance, and so having"]
    #[doc = " a mapping set up in advance is useful. Note that on CPU access of this data, the data may be migrated"]
    #[doc = " to host memory because the CPU typically cannot access device memory directly. Any GPU that had the"]
    #[doc = " ::cudaMemAdviceSetAccessedBy flag set for this data will now have its mapping updated to point to the"]
    #[doc = " page in host memory."]
    #[doc = " If ::cudaMemAdviseSetReadMostly is also set on this memory region or any subset of it, then the"]
    #[doc = " policies associated with that advice will override the policies of this advice. Additionally, if the"]
    #[doc = " preferred location of this memory region or any subset of it is also \\p device, then the policies"]
    #[doc = " associated with ::cudaMemAdviseSetPreferredLocation will override the policies of this advice."]
    #[doc = " If the memory region refers to valid system-allocated pageable memory, then \\p device must have a non-zero"]
    #[doc = " value for the device attribute ::cudaDevAttrPageableMemoryAccess. Additionally, if \\p device has"]
    #[doc = " a non-zero value for the device attribute ::cudaDevAttrPageableMemoryAccessUsesHostPageTables,"]
    #[doc = " then this call has no effect."]
    #[doc = ""]
    #[doc = " - ::cudaMemAdviseUnsetAccessedBy: Undoes the effect of ::cudaMemAdviseSetAccessedBy. Any mappings to"]
    #[doc = " the data from \\p device may be removed at any time causing accesses to result in non-fatal page faults."]
    #[doc = " If the memory region refers to valid system-allocated pageable memory, then \\p device must have a non-zero"]
    #[doc = " value for the device attribute ::cudaDevAttrPageableMemoryAccess. Additionally, if \\p device has"]
    #[doc = " a non-zero value for the device attribute ::cudaDevAttrPageableMemoryAccessUsesHostPageTables,"]
    #[doc = " then this call has no effect."]
    #[doc = ""]
    #[doc = " \\param devPtr - Pointer to memory to set the advice for"]
    #[doc = " \\param count  - Size in bytes of the memory range"]
    #[doc = " \\param advice - Advice to be applied for the specified memory range"]
    #[doc = " \\param device - Device to apply the advice for"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpyPeer, ::cudaMemcpyAsync,"]
    #[doc = " ::cudaMemcpy3DPeerAsync, ::cudaMemPrefetchAsync,"]
    #[doc = " ::cuMemAdvise"]
    pub fn cudaMemAdvise(
        devPtr: *const ::libc::c_void,
        count: usize,
        advice: cudaMemoryAdvise,
        device: ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Query an attribute of a given memory range"]
    #[doc = ""]
    #[doc = " Query an attribute about the memory range starting at \\p devPtr with a size of \\p count bytes. The"]
    #[doc = " memory range must refer to managed memory allocated via ::cudaMallocManaged or declared via"]
    #[doc = " __managed__ variables."]
    #[doc = ""]
    #[doc = " The \\p attribute parameter can take the following values:"]
    #[doc = " - ::cudaMemRangeAttributeReadMostly: If this attribute is specified, \\p data will be interpreted"]
    #[doc = " as a 32-bit integer, and \\p dataSize must be 4. The result returned will be 1 if all pages in the given"]
    #[doc = " memory range have read-duplication enabled, or 0 otherwise."]
    #[doc = " - ::cudaMemRangeAttributePreferredLocation: If this attribute is specified, \\p data will be"]
    #[doc = " interpreted as a 32-bit integer, and \\p dataSize must be 4. The result returned will be a GPU device"]
    #[doc = " id if all pages in the memory range have that GPU as their preferred location, or it will be cudaCpuDeviceId"]
    #[doc = " if all pages in the memory range have the CPU as their preferred location, or it will be cudaInvalidDeviceId"]
    #[doc = " if either all the pages don't have the same preferred location or some of the pages don't have a"]
    #[doc = " preferred location at all. Note that the actual location of the pages in the memory range at the time of"]
    #[doc = " the query may be different from the preferred location."]
    #[doc = " - ::cudaMemRangeAttributeAccessedBy: If this attribute is specified, \\p data will be interpreted"]
    #[doc = " as an array of 32-bit integers, and \\p dataSize must be a non-zero multiple of 4. The result returned"]
    #[doc = " will be a list of device ids that had ::cudaMemAdviceSetAccessedBy set for that entire memory range."]
    #[doc = " If any device does not have that advice set for the entire memory range, that device will not be included."]
    #[doc = " If \\p data is larger than the number of devices that have that advice set for that memory range,"]
    #[doc = " cudaInvalidDeviceId will be returned in all the extra space provided. For ex., if \\p dataSize is 12"]
    #[doc = " (i.e. \\p data has 3 elements) and only device 0 has the advice set, then the result returned will be"]
    #[doc = " { 0, cudaInvalidDeviceId, cudaInvalidDeviceId }. If \\p data is smaller than the number of devices that have"]
    #[doc = " that advice set, then only as many devices will be returned as can fit in the array. There is no"]
    #[doc = " guarantee on which specific devices will be returned, however."]
    #[doc = " - ::cudaMemRangeAttributeLastPrefetchLocation: If this attribute is specified, \\p data will be"]
    #[doc = " interpreted as a 32-bit integer, and \\p dataSize must be 4. The result returned will be the last location"]
    #[doc = " to which all pages in the memory range were prefetched explicitly via ::cudaMemPrefetchAsync. This will either be"]
    #[doc = " a GPU id or cudaCpuDeviceId depending on whether the last location for prefetch was a GPU or the CPU"]
    #[doc = " respectively. If any page in the memory range was never explicitly prefetched or if all pages were not"]
    #[doc = " prefetched to the same location, cudaInvalidDeviceId will be returned. Note that this simply returns the"]
    #[doc = " last location that the applicaton requested to prefetch the memory range to. It gives no indication as to"]
    #[doc = " whether the prefetch operation to that location has completed or even begun."]
    #[doc = ""]
    #[doc = " \\param data      - A pointers to a memory location where the result"]
    #[doc = "                    of each attribute query will be written to."]
    #[doc = " \\param dataSize  - Array containing the size of data"]
    #[doc = " \\param attribute - The attribute to query"]
    #[doc = " \\param devPtr    - Start of the range to query"]
    #[doc = " \\param count     - Size of the range to query"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemRangeGetAttributes, ::cudaMemPrefetchAsync,"]
    #[doc = " ::cudaMemAdvise,"]
    #[doc = " ::cuMemRangeGetAttribute"]
    pub fn cudaMemRangeGetAttribute(
        data: *mut ::libc::c_void,
        dataSize: usize,
        attribute: cudaMemRangeAttribute,
        devPtr: *const ::libc::c_void,
        count: usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Query attributes of a given memory range."]
    #[doc = ""]
    #[doc = " Query attributes of the memory range starting at \\p devPtr with a size of \\p count bytes. The"]
    #[doc = " memory range must refer to managed memory allocated via ::cudaMallocManaged or declared via"]
    #[doc = " __managed__ variables. The \\p attributes array will be interpreted to have \\p numAttributes"]
    #[doc = " entries. The \\p dataSizes array will also be interpreted to have \\p numAttributes entries."]
    #[doc = " The results of the query will be stored in \\p data."]
    #[doc = ""]
    #[doc = " The list of supported attributes are given below. Please refer to ::cudaMemRangeGetAttribute for"]
    #[doc = " attribute descriptions and restrictions."]
    #[doc = ""]
    #[doc = " - ::cudaMemRangeAttributeReadMostly"]
    #[doc = " - ::cudaMemRangeAttributePreferredLocation"]
    #[doc = " - ::cudaMemRangeAttributeAccessedBy"]
    #[doc = " - ::cudaMemRangeAttributeLastPrefetchLocation"]
    #[doc = ""]
    #[doc = " \\param data          - A two-dimensional array containing pointers to memory"]
    #[doc = "                        locations where the result of each attribute query will be written to."]
    #[doc = " \\param dataSizes     - Array containing the sizes of each result"]
    #[doc = " \\param attributes    - An array of attributes to query"]
    #[doc = "                        (numAttributes and the number of attributes in this array should match)"]
    #[doc = " \\param numAttributes - Number of attributes to query"]
    #[doc = " \\param devPtr        - Start of the range to query"]
    #[doc = " \\param count         - Size of the range to query"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemRangeGetAttribute, ::cudaMemAdvise,"]
    #[doc = " ::cudaMemPrefetchAsync,"]
    #[doc = " ::cuMemRangeGetAttributes"]
    pub fn cudaMemRangeGetAttributes(
        data: *mut *mut ::libc::c_void,
        dataSizes: *mut usize,
        attributes: *mut cudaMemRangeAttribute,
        numAttributes: usize,
        devPtr: *const ::libc::c_void,
        count: usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Copies \\p count bytes from the memory area pointed to by \\p src to the"]
    #[doc = " CUDA array \\p dst starting at \\p hOffset rows and \\p wOffset bytes from"]
    #[doc = " the upper left corner, where \\p kind specifies the direction"]
    #[doc = " of the copy, and must be one of ::cudaMemcpyHostToHost,"]
    #[doc = " ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = ""]
    #[doc = " \\param dst     - Destination memory address"]
    #[doc = " \\param wOffset - Destination starting X offset (columns in bytes)"]
    #[doc = " \\param hOffset - Destination starting Y offset (rows)"]
    #[doc = " \\param src     - Source memory address"]
    #[doc = " \\param count   - Size in bytes to copy"]
    #[doc = " \\param kind    - Type of transfer"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_sync"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpyFromArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpyArrayToArray, ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpyToArrayAsync, ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpyFromArrayAsync, ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpyHtoA,"]
    #[doc = " ::cuMemcpyDtoA"]
    pub fn cudaMemcpyToArray(
        dst: cudaArray_t,
        wOffset: usize,
        hOffset: usize,
        src: *const ::libc::c_void,
        count: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Copies \\p count bytes from the CUDA array \\p src starting at \\p hOffset rows"]
    #[doc = " and \\p wOffset bytes from the upper left corner to the memory area pointed to"]
    #[doc = " by \\p dst, where \\p kind specifies the direction of the copy, and must be one of"]
    #[doc = " ::cudaMemcpyHostToHost, ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = ""]
    #[doc = " \\param dst     - Destination memory address"]
    #[doc = " \\param src     - Source memory address"]
    #[doc = " \\param wOffset - Source starting X offset (columns in bytes)"]
    #[doc = " \\param hOffset - Source starting Y offset (rows)"]
    #[doc = " \\param count   - Size in bytes to copy"]
    #[doc = " \\param kind    - Type of transfer"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_sync"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D, ::cudaMemcpyToArray,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpyArrayToArray, ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpyToArrayAsync, ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpyFromArrayAsync, ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpyAtoH,"]
    #[doc = " ::cuMemcpyAtoD"]
    pub fn cudaMemcpyFromArray(
        dst: *mut ::libc::c_void,
        src: cudaArray_const_t,
        wOffset: usize,
        hOffset: usize,
        count: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Copies \\p count bytes from the CUDA array \\p src starting at \\p hOffsetSrc"]
    #[doc = " rows and \\p wOffsetSrc bytes from the upper left corner to the CUDA array"]
    #[doc = " \\p dst starting at \\p hOffsetDst rows and \\p wOffsetDst bytes from the upper"]
    #[doc = " left corner, where \\p kind specifies the direction of the copy, and must be one of"]
    #[doc = " ::cudaMemcpyHostToHost, ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = ""]
    #[doc = " \\param dst        - Destination memory address"]
    #[doc = " \\param wOffsetDst - Destination starting X offset (columns in bytes)"]
    #[doc = " \\param hOffsetDst - Destination starting Y offset (rows)"]
    #[doc = " \\param src        - Source memory address"]
    #[doc = " \\param wOffsetSrc - Source starting X offset (columns in bytes)"]
    #[doc = " \\param hOffsetSrc - Source starting Y offset (rows)"]
    #[doc = " \\param count      - Size in bytes to copy"]
    #[doc = " \\param kind       - Type of transfer"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D, ::cudaMemcpyToArray,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpyFromArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpyToArrayAsync, ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpyFromArrayAsync, ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpyAtoA"]
    pub fn cudaMemcpyArrayToArray(
        dst: cudaArray_t,
        wOffsetDst: usize,
        hOffsetDst: usize,
        src: cudaArray_const_t,
        wOffsetSrc: usize,
        hOffsetSrc: usize,
        count: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Copies \\p count bytes from the memory area pointed to by \\p src to the"]
    #[doc = " CUDA array \\p dst starting at \\p hOffset rows and \\p wOffset bytes from"]
    #[doc = " the upper left corner, where \\p kind specifies the"]
    #[doc = " direction of the copy, and must be one of ::cudaMemcpyHostToHost,"]
    #[doc = " ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = ""]
    #[doc = " ::cudaMemcpyToArrayAsync() is asynchronous with respect to the host, so"]
    #[doc = " the call may return before the copy is complete. The copy can optionally"]
    #[doc = " be associated to a stream by passing a non-zero \\p stream argument. If \\p"]
    #[doc = " kind is ::cudaMemcpyHostToDevice or ::cudaMemcpyDeviceToHost and \\p stream"]
    #[doc = " is non-zero, the copy may overlap with operations in other streams."]
    #[doc = ""]
    #[doc = " \\param dst     - Destination memory address"]
    #[doc = " \\param wOffset - Destination starting X offset (columns in bytes)"]
    #[doc = " \\param hOffset - Destination starting Y offset (rows)"]
    #[doc = " \\param src     - Source memory address"]
    #[doc = " \\param count   - Size in bytes to copy"]
    #[doc = " \\param kind    - Type of transfer"]
    #[doc = " \\param stream  - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D, ::cudaMemcpyToArray,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpyFromArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpyArrayToArray, ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpyFromArrayAsync, ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpyHtoAAsync,"]
    #[doc = " ::cuMemcpy2DAsync"]
    pub fn cudaMemcpyToArrayAsync(
        dst: cudaArray_t,
        wOffset: usize,
        hOffset: usize,
        src: *const ::libc::c_void,
        count: usize,
        kind: cudaMemcpyKind,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies data between host and device"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Copies \\p count bytes from the CUDA array \\p src starting at \\p hOffset rows"]
    #[doc = " and \\p wOffset bytes from the upper left corner to the memory area pointed to"]
    #[doc = " by \\p dst, where \\p kind specifies the direction of the copy, and must be one of"]
    #[doc = " ::cudaMemcpyHostToHost, ::cudaMemcpyHostToDevice, ::cudaMemcpyDeviceToHost,"]
    #[doc = " ::cudaMemcpyDeviceToDevice, or ::cudaMemcpyDefault. Passing"]
    #[doc = " ::cudaMemcpyDefault is recommended, in which case the type of transfer is"]
    #[doc = " inferred from the pointer values. However, ::cudaMemcpyDefault is only"]
    #[doc = " allowed on systems that support unified virtual addressing."]
    #[doc = ""]
    #[doc = " ::cudaMemcpyFromArrayAsync() is asynchronous with respect to the host, so"]
    #[doc = " the call may return before the copy is complete. The copy can optionally"]
    #[doc = " be associated to a stream by passing a non-zero \\p stream argument. If \\p"]
    #[doc = " kind is ::cudaMemcpyHostToDevice or ::cudaMemcpyDeviceToHost and \\p stream"]
    #[doc = " is non-zero, the copy may overlap with operations in other streams."]
    #[doc = ""]
    #[doc = " \\param dst     - Destination memory address"]
    #[doc = " \\param src     - Source memory address"]
    #[doc = " \\param wOffset - Source starting X offset (columns in bytes)"]
    #[doc = " \\param hOffset - Source starting Y offset (rows)"]
    #[doc = " \\param count   - Size in bytes to copy"]
    #[doc = " \\param kind    - Type of transfer"]
    #[doc = " \\param stream  - Stream identifier"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidMemcpyDirection"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_async"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaMemcpy, ::cudaMemcpy2D, ::cudaMemcpyToArray,"]
    #[doc = " ::cudaMemcpy2DToArray, ::cudaMemcpyFromArray, ::cudaMemcpy2DFromArray,"]
    #[doc = " ::cudaMemcpyArrayToArray, ::cudaMemcpy2DArrayToArray, ::cudaMemcpyToSymbol,"]
    #[doc = " ::cudaMemcpyFromSymbol, ::cudaMemcpyAsync, ::cudaMemcpy2DAsync,"]
    #[doc = " ::cudaMemcpyToArrayAsync, ::cudaMemcpy2DToArrayAsync,"]
    #[doc = " ::cudaMemcpy2DFromArrayAsync,"]
    #[doc = " ::cudaMemcpyToSymbolAsync, ::cudaMemcpyFromSymbolAsync,"]
    #[doc = " ::cuMemcpyAtoHAsync,"]
    #[doc = " ::cuMemcpy2DAsync"]
    pub fn cudaMemcpyFromArrayAsync(
        dst: *mut ::libc::c_void,
        src: cudaArray_const_t,
        wOffset: usize,
        hOffset: usize,
        count: usize,
        kind: cudaMemcpyKind,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Allocates memory with stream ordered semantics"]
    #[doc = ""]
    #[doc = " Inserts an allocation operation into \\p hStream."]
    #[doc = " A pointer to the allocated memory is returned immediately in *dptr."]
    #[doc = " The allocation must not be accessed until the the allocation operation completes."]
    #[doc = " The allocation comes from the memory pool associated with the stream's device."]
    #[doc = ""]
    #[doc = " \\note The default memory pool of a device contains device memory from that device."]
    #[doc = " \\note Basic stream ordering allows future work submitted into the same stream to use the allocation."]
    #[doc = "       Stream query, stream synchronize, and CUDA events can be used to guarantee that the allocation"]
    #[doc = "       operation completes before work submitted in a separate stream runs."]
    #[doc = " \\note During stream capture, this function results in the creation of an allocation node.  In this case,"]
    #[doc = "       the allocation is owned by the graph instead of the memory pool. The memory pool's properties"]
    #[doc = "       are used to set the node's creation parameters."]
    #[doc = ""]
    #[doc = " \\param[out] devPtr  - Returned device pointer"]
    #[doc = " \\param[in] size     - Number of bytes to allocate"]
    #[doc = " \\param[in] hStream  - The stream establishing the stream ordering contract and the memory pool to allocate from"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorNotSupported,"]
    #[doc = " ::cudaErrorOutOfMemory,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemAllocAsync,"]
    #[doc = " \\ref ::cudaMallocAsync(void** ptr, size_t size, cudaMemPool_t memPool, cudaStream_t stream)  \"cudaMallocAsync (C++ API)\","]
    #[doc = " ::cudaMallocFromPoolAsync, ::cudaFreeAsync, ::cudaDeviceSetMemPool, ::cudaDeviceGetDefaultMemPool, ::cudaDeviceGetMemPool, ::cudaMemPoolSetAccess, ::cudaMemPoolSetAttribute, ::cudaMemPoolGetAttribute"]
    pub fn cudaMallocAsync(
        devPtr: *mut *mut ::libc::c_void,
        size: usize,
        hStream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Frees memory with stream ordered semantics"]
    #[doc = ""]
    #[doc = " Inserts a free operation into \\p hStream."]
    #[doc = " The allocation must not be accessed after stream execution reaches the free."]
    #[doc = " After this API returns, accessing the memory from any subsequent work launched on the GPU"]
    #[doc = " or querying its pointer attributes results in undefined behavior."]
    #[doc = ""]
    #[doc = " \\note During stream capture, this function results in the creation of a free node and"]
    #[doc = "       must therefore be passed the address of a graph allocation."]
    #[doc = ""]
    #[doc = " \\param dptr - memory to free"]
    #[doc = " \\param hStream - The stream establishing the stream ordering promise"]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorNotSupported"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemFreeAsync, ::cudaMallocAsync"]
    pub fn cudaFreeAsync(devPtr: *mut ::libc::c_void, hStream: cudaStream_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Tries to release memory back to the OS"]
    #[doc = ""]
    #[doc = " Releases memory back to the OS until the pool contains fewer than minBytesToKeep"]
    #[doc = " reserved bytes, or there is no more memory that the allocator can safely release."]
    #[doc = " The allocator cannot release OS allocations that back outstanding asynchronous allocations."]
    #[doc = " The OS allocations may happen at different granularity from the user allocations."]
    #[doc = ""]
    #[doc = " \\note: Allocations that have not been freed count as outstanding."]
    #[doc = " \\note: Allocations that have been asynchronously freed but whose completion has"]
    #[doc = "        not been observed on the host (eg. by a synchronize) can count as outstanding."]
    #[doc = ""]
    #[doc = " \\param[in] pool           - The memory pool to trim"]
    #[doc = " \\param[in] minBytesToKeep - If the pool has less than minBytesToKeep reserved,"]
    #[doc = " the TrimTo operation is a no-op.  Otherwise the pool will be guaranteed to have"]
    #[doc = " at least minBytesToKeep bytes reserved after the operation."]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemPoolTrimTo, ::cudaMallocAsync, ::cudaFreeAsync, ::cudaDeviceGetDefaultMemPool, ::cudaDeviceGetMemPool, ::cudaMemPoolCreate"]
    pub fn cudaMemPoolTrimTo(memPool: cudaMemPool_t, minBytesToKeep: usize) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets attributes of a memory pool"]
    #[doc = ""]
    #[doc = " Supported attributes are:"]
    #[doc = " - ::cudaMemPoolAttrReleaseThreshold: (value type = cuuint64_t)"]
    #[doc = "                    Amount of reserved memory in bytes to hold onto before trying"]
    #[doc = "                    to release memory back to the OS. When more than the release"]
    #[doc = "                    threshold bytes of memory are held by the memory pool, the"]
    #[doc = "                    allocator will try to release memory back to the OS on the"]
    #[doc = "                    next call to stream, event or context synchronize. (default 0)"]
    #[doc = " - ::cudaMemPoolReuseFollowEventDependencies: (value type = int)"]
    #[doc = "                    Allow ::cudaMallocAsync to use memory asynchronously freed"]
    #[doc = "                    in another stream as long as a stream ordering dependency"]
    #[doc = "                    of the allocating stream on the free action exists."]
    #[doc = "                    Cuda events and null stream interactions can create the required"]
    #[doc = "                    stream ordered dependencies. (default enabled)"]
    #[doc = " - ::cudaMemPoolReuseAllowOpportunistic: (value type = int)"]
    #[doc = "                    Allow reuse of already completed frees when there is no dependency"]
    #[doc = "                    between the free and allocation. (default enabled)"]
    #[doc = " - ::cudaMemPoolReuseAllowInternalDependencies: (value type = int)"]
    #[doc = "                    Allow ::cudaMallocAsync to insert new stream dependencies"]
    #[doc = "                    in order to establish the stream ordering required to reuse"]
    #[doc = "                    a piece of memory released by ::cudaFreeAsync (default enabled)."]
    #[doc = ""]
    #[doc = " \\param[in] pool  - The memory pool to modify"]
    #[doc = " \\param[in] attr  - The attribute to modify"]
    #[doc = " \\param[in] value - Pointer to the value to assign"]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemPoolSetAttribute, ::cudaMallocAsync, ::cudaFreeAsync, ::cudaDeviceGetDefaultMemPool, ::cudaDeviceGetMemPool, ::cudaMemPoolCreate"]
    #[doc = ""]
    pub fn cudaMemPoolSetAttribute(
        memPool: cudaMemPool_t,
        attr: cudaMemPoolAttr,
        value: *mut ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Gets attributes of a memory pool"]
    #[doc = ""]
    #[doc = " Supported attributes are:"]
    #[doc = " - ::cudaMemPoolAttrReleaseThreshold: (value type = cuuint64_t)"]
    #[doc = "                    Amount of reserved memory in bytes to hold onto before trying"]
    #[doc = "                    to release memory back to the OS. When more than the release"]
    #[doc = "                    threshold bytes of memory are held by the memory pool, the"]
    #[doc = "                    allocator will try to release memory back to the OS on the"]
    #[doc = "                    next call to stream, event or context synchronize. (default 0)"]
    #[doc = " - ::cudaMemPoolReuseFollowEventDependencies: (value type = int)"]
    #[doc = "                    Allow ::cudaMallocAsync to use memory asynchronously freed"]
    #[doc = "                    in another stream as long as a stream ordering dependency"]
    #[doc = "                    of the allocating stream on the free action exists."]
    #[doc = "                    Cuda events and null stream interactions can create the required"]
    #[doc = "                    stream ordered dependencies. (default enabled)"]
    #[doc = " - ::cudaMemPoolReuseAllowOpportunistic: (value type = int)"]
    #[doc = "                    Allow reuse of already completed frees when there is no dependency"]
    #[doc = "                    between the free and allocation. (default enabled)"]
    #[doc = " - ::cudaMemPoolReuseAllowInternalDependencies: (value type = int)"]
    #[doc = "                    Allow ::cudaMallocAsync to insert new stream dependencies"]
    #[doc = "                    in order to establish the stream ordering required to reuse"]
    #[doc = "                    a piece of memory released by ::cudaFreeAsync (default enabled)."]
    #[doc = ""]
    #[doc = " \\param[in] pool  - The memory pool to get attributes of"]
    #[doc = " \\param[in] attr  - The attribute to get"]
    #[doc = " \\param[in] value - Retrieved value"]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemPoolGetAttribute, ::cudaMallocAsync, ::cudaFreeAsync, ::cudaDeviceGetDefaultMemPool, ::cudaDeviceGetMemPool, ::cudaMemPoolCreate"]
    #[doc = ""]
    pub fn cudaMemPoolGetAttribute(
        memPool: cudaMemPool_t,
        attr: cudaMemPoolAttr,
        value: *mut ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Controls visibility of pools between devices"]
    #[doc = ""]
    #[doc = " \\param[in] pool  - The pool being modified"]
    #[doc = " \\param[in] map   - Array of access descriptors. Each descriptor instructs the access to enable for a single gpu"]
    #[doc = " \\param[in] count - Number of descriptors in the map array."]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemPoolSetAccess, ::cudaMemPoolGetAccess, ::cudaMallocAsync, cudaFreeAsync"]
    pub fn cudaMemPoolSetAccess(
        memPool: cudaMemPool_t,
        descList: *const cudaMemAccessDesc,
        count: usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns the accessibility of a pool from a device"]
    #[doc = ""]
    #[doc = " Returns the accessibility of the pool's memory from the specified location."]
    #[doc = ""]
    #[doc = " \\param[out] flags   - the accessibility of the pool from the specified location"]
    #[doc = " \\param[in] memPool  - the pool being queried"]
    #[doc = " \\param[in] location - the location accessing the pool"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemPoolGetAccess, ::cudaMemPoolSetAccess"]
    pub fn cudaMemPoolGetAccess(
        flags: *mut cudaMemAccessFlags,
        memPool: cudaMemPool_t,
        location: *mut cudaMemLocation,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Creates a memory pool"]
    #[doc = ""]
    #[doc = " Creates a CUDA memory pool and returns the handle in \\p pool.  The \\p poolProps determines"]
    #[doc = " the properties of the pool such as the backing device and IPC capabilities."]
    #[doc = ""]
    #[doc = " By default, the pool's memory will be accessible from the device it is allocated on."]
    #[doc = ""]
    #[doc = " \\note Specifying cudaMemHandleTypeNone creates a memory pool that will not support IPC."]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorNotSupported"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemPoolCreate, ::cudaDeviceSetMemPool, ::cudaMallocFromPoolAsync, ::cudaMemPoolExportToShareableHandle, ::cudaDeviceGetDefaultMemPool, ::cudaDeviceGetMemPool"]
    #[doc = ""]
    pub fn cudaMemPoolCreate(
        memPool: *mut cudaMemPool_t,
        poolProps: *const cudaMemPoolProps,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Destroys the specified memory pool"]
    #[doc = ""]
    #[doc = " If any pointers obtained from this pool haven't been freed or"]
    #[doc = " the pool has free operations that haven't completed"]
    #[doc = " when ::cudaMemPoolDestroy is invoked, the function will return immediately and the"]
    #[doc = " resources associated with the pool will be released automatically"]
    #[doc = " once there are no more outstanding allocations."]
    #[doc = ""]
    #[doc = " Destroying the current mempool of a device sets the default mempool of"]
    #[doc = " that device as the current mempool for that device."]
    #[doc = ""]
    #[doc = " \\note A device's default memory pool cannot be destroyed."]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = ""]
    #[doc = " \\sa cuMemPoolDestroy, ::cudaFreeAsync, ::cudaDeviceSetMemPool, ::cudaDeviceGetDefaultMemPool, ::cudaDeviceGetMemPool, ::cudaMemPoolCreate"]
    pub fn cudaMemPoolDestroy(memPool: cudaMemPool_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Allocates memory from a specified pool with stream ordered semantics."]
    #[doc = ""]
    #[doc = " Inserts an allocation operation into \\p hStream."]
    #[doc = " A pointer to the allocated memory is returned immediately in *dptr."]
    #[doc = " The allocation must not be accessed until the the allocation operation completes."]
    #[doc = " The allocation comes from the specified memory pool."]
    #[doc = ""]
    #[doc = " \\note"]
    #[doc = "    -  The specified memory pool may be from a device different than that of the specified \\p hStream."]
    #[doc = ""]
    #[doc = "    -  Basic stream ordering allows future work submitted into the same stream to use the allocation."]
    #[doc = "       Stream query, stream synchronize, and CUDA events can be used to guarantee that the allocation"]
    #[doc = "       operation completes before work submitted in a separate stream runs."]
    #[doc = ""]
    #[doc = " \\note During stream capture, this function results in the creation of an allocation node.  In this case,"]
    #[doc = "       the allocation is owned by the graph instead of the memory pool. The memory pool's properties"]
    #[doc = "       are used to set the node's creation parameters."]
    #[doc = ""]
    #[doc = " \\param[out] ptr     - Returned device pointer"]
    #[doc = " \\param[in] bytesize - Number of bytes to allocate"]
    #[doc = " \\param[in] memPool  - The pool to allocate from"]
    #[doc = " \\param[in] stream   - The stream establishing the stream ordering semantic"]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorNotSupported,"]
    #[doc = " ::cudaErrorOutOfMemory"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemAllocFromPoolAsync,"]
    #[doc = " \\ref ::cudaMallocAsync(void** ptr, size_t size, cudaMemPool_t memPool, cudaStream_t stream)  \"cudaMallocAsync (C++ API)\","]
    #[doc = " ::cudaMallocAsync, ::cudaFreeAsync, ::cudaDeviceGetDefaultMemPool, ::cudaMemPoolCreate, ::cudaMemPoolSetAccess, ::cudaMemPoolSetAttribute"]
    pub fn cudaMallocFromPoolAsync(
        ptr: *mut *mut ::libc::c_void,
        size: usize,
        memPool: cudaMemPool_t,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Exports a memory pool to the requested handle type."]
    #[doc = ""]
    #[doc = " Given an IPC capable mempool, create an OS handle to share the pool with another process."]
    #[doc = " A recipient process can convert the shareable handle into a mempool with ::cudaMemPoolImportFromShareableHandle."]
    #[doc = " Individual pointers can then be shared with the ::cudaMemPoolExportPointer and ::cudaMemPoolImportPointer APIs."]
    #[doc = " The implementation of what the shareable handle is and how it can be transferred is defined by the requested"]
    #[doc = " handle type."]
    #[doc = ""]
    #[doc = " \\note: To create an IPC capable mempool, create a mempool with a CUmemAllocationHandleType other than cudaMemHandleTypeNone."]
    #[doc = ""]
    #[doc = " \\param[out] handle_out  - pointer to the location in which to store the requested handle"]
    #[doc = " \\param[in] pool         - pool to export"]
    #[doc = " \\param[in] handleType   - the type of handle to create"]
    #[doc = " \\param[in] flags        - must be 0"]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorOutOfMemory"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemPoolExportToShareableHandle, ::cudaMemPoolImportFromShareableHandle, ::cudaMemPoolExportPointer, ::cudaMemPoolImportPointer"]
    pub fn cudaMemPoolExportToShareableHandle(
        shareableHandle: *mut ::libc::c_void,
        memPool: cudaMemPool_t,
        handleType: cudaMemAllocationHandleType,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief imports a memory pool from a shared handle."]
    #[doc = ""]
    #[doc = " Specific allocations can be imported from the imported pool with ::cudaMemPoolImportPointer."]
    #[doc = ""]
    #[doc = " \\note Imported memory pools do not support creating new allocations."]
    #[doc = "       As such imported memory pools may not be used in ::cudaDeviceSetMemPool"]
    #[doc = "       or ::cudaMallocFromPoolAsync calls."]
    #[doc = ""]
    #[doc = " \\param[out] pool_out    - Returned memory pool"]
    #[doc = " \\param[in] handle       - OS handle of the pool to open"]
    #[doc = " \\param[in] handleType   - The type of handle being imported"]
    #[doc = " \\param[in] flags        - must be 0"]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorOutOfMemory"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemPoolImportFromShareableHandle, ::cudaMemPoolExportToShareableHandle, ::cudaMemPoolExportPointer, ::cudaMemPoolImportPointer"]
    pub fn cudaMemPoolImportFromShareableHandle(
        memPool: *mut cudaMemPool_t,
        shareableHandle: *mut ::libc::c_void,
        handleType: cudaMemAllocationHandleType,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Export data to share a memory pool allocation between processes."]
    #[doc = ""]
    #[doc = " Constructs \\p shareData_out for sharing a specific allocation from an already shared memory pool."]
    #[doc = " The recipient process can import the allocation with the ::cudaMemPoolImportPointer api."]
    #[doc = " The data is not a handle and may be shared through any IPC mechanism."]
    #[doc = ""]
    #[doc = " \\param[out] shareData_out - Returned export data"]
    #[doc = " \\param[in] ptr            - pointer to memory being exported"]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorOutOfMemory"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemPoolExportPointer, ::cudaMemPoolExportToShareableHandle, ::cudaMemPoolImportFromShareableHandle, ::cudaMemPoolImportPointer"]
    pub fn cudaMemPoolExportPointer(
        exportData: *mut cudaMemPoolPtrExportData,
        ptr: *mut ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Import a memory pool allocation from another process."]
    #[doc = ""]
    #[doc = " Returns in \\p ptr_out a pointer to the imported memory."]
    #[doc = " The imported memory must not be accessed before the allocation operation completes"]
    #[doc = " in the exporting process. The imported memory must be freed from all importing processes before"]
    #[doc = " being freed in the exporting process. The pointer may be freed with cudaFree"]
    #[doc = " or cudaFreeAsync.  If ::cudaFreeAsync is used, the free must be completed"]
    #[doc = " on the importing process before the free operation on the exporting process."]
    #[doc = ""]
    #[doc = " \\note The ::cudaFreeAsync api may be used in the exporting process before"]
    #[doc = "       the ::cudaFreeAsync operation completes in its stream as long as the"]
    #[doc = "       ::cudaFreeAsync in the exporting process specifies a stream with"]
    #[doc = "       a stream dependency on the importing process's ::cudaFreeAsync."]
    #[doc = ""]
    #[doc = " \\param[out] ptr_out  - pointer to imported memory"]
    #[doc = " \\param[in] pool      - pool from which to import"]
    #[doc = " \\param[in] shareData - data specifying the memory to import"]
    #[doc = ""]
    #[doc = " \\returns"]
    #[doc = " ::CUDA_SUCCESS,"]
    #[doc = " ::CUDA_ERROR_INVALID_VALUE,"]
    #[doc = " ::CUDA_ERROR_NOT_INITIALIZED,"]
    #[doc = " ::CUDA_ERROR_OUT_OF_MEMORY"]
    #[doc = ""]
    #[doc = " \\sa ::cuMemPoolImportPointer, ::cudaMemPoolExportToShareableHandle, ::cudaMemPoolImportFromShareableHandle, ::cudaMemPoolExportPointer"]
    pub fn cudaMemPoolImportPointer(
        ptr: *mut *mut ::libc::c_void,
        memPool: cudaMemPool_t,
        exportData: *mut cudaMemPoolPtrExportData,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns attributes about a specified pointer"]
    #[doc = ""]
    #[doc = " Returns in \\p *attributes the attributes of the pointer \\p ptr."]
    #[doc = " If pointer was not allocated in, mapped by or registered with context"]
    #[doc = " supporting unified addressing ::cudaErrorInvalidValue is returned."]
    #[doc = ""]
    #[doc = " \\note In CUDA 11.0 forward passing host pointer will return ::cudaMemoryTypeUnregistered"]
    #[doc = " in ::cudaPointerAttributes::type and call will return ::cudaSuccess."]
    #[doc = ""]
    #[doc = " The ::cudaPointerAttributes structure is defined as:"]
    #[doc = " \\code"]
    #[doc = "struct cudaPointerAttributes {"]
    #[doc = "enum cudaMemoryType type;"]
    #[doc = "int device;"]
    #[doc = "void *devicePointer;"]
    #[doc = "void *hostPointer;"]
    #[doc = "}"]
    #[doc = "\\endcode"]
    #[doc = " In this structure, the individual fields mean"]
    #[doc = ""]
    #[doc = " - \\ref ::cudaPointerAttributes::type identifies type of memory. It can be"]
    #[doc = "    ::cudaMemoryTypeUnregistered for unregistered host memory,"]
    #[doc = "    ::cudaMemoryTypeHost for registered host memory, ::cudaMemoryTypeDevice for device"]
    #[doc = "    memory or  ::cudaMemoryTypeManaged for managed memory."]
    #[doc = ""]
    #[doc = " - \\ref ::cudaPointerAttributes::device \"device\" is the device against which"]
    #[doc = "   \\p ptr was allocated.  If \\p ptr has memory type ::cudaMemoryTypeDevice"]
    #[doc = "   then this identifies the device on which the memory referred to by \\p ptr"]
    #[doc = "   physically resides.  If \\p ptr has memory type ::cudaMemoryTypeHost then this"]
    #[doc = "   identifies the device which was current when the allocation was made"]
    #[doc = "   (and if that device is deinitialized then this allocation will vanish"]
    #[doc = "   with that device's state)."]
    #[doc = ""]
    #[doc = " - \\ref ::cudaPointerAttributes::devicePointer \"devicePointer\" is"]
    #[doc = "   the device pointer alias through which the memory referred to by \\p ptr"]
    #[doc = "   may be accessed on the current device."]
    #[doc = "   If the memory referred to by \\p ptr cannot be accessed directly by the"]
    #[doc = "   current device then this is NULL."]
    #[doc = ""]
    #[doc = " - \\ref ::cudaPointerAttributes::hostPointer \"hostPointer\" is"]
    #[doc = "   the host pointer alias through which the memory referred to by \\p ptr"]
    #[doc = "   may be accessed on the host."]
    #[doc = "   If the memory referred to by \\p ptr cannot be accessed directly by the"]
    #[doc = "   host then this is NULL."]
    #[doc = ""]
    #[doc = " \\param attributes - Attributes for the specified pointer"]
    #[doc = " \\param ptr        - Pointer to get attributes for"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDevice,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaGetDeviceCount, ::cudaGetDevice, ::cudaSetDevice,"]
    #[doc = " ::cudaChooseDevice,"]
    #[doc = " ::cuPointerGetAttributes"]
    pub fn cudaPointerGetAttributes(
        attributes: *mut cudaPointerAttributes,
        ptr: *const ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Queries if a device may directly access a peer device's memory."]
    #[doc = ""]
    #[doc = " Returns in \\p *canAccessPeer a value of 1 if device \\p device is capable of"]
    #[doc = " directly accessing memory from \\p peerDevice and 0 otherwise.  If direct"]
    #[doc = " access of \\p peerDevice from \\p device is possible, then access may be"]
    #[doc = " enabled by calling ::cudaDeviceEnablePeerAccess()."]
    #[doc = ""]
    #[doc = " \\param canAccessPeer - Returned access capability"]
    #[doc = " \\param device        - Device from which allocations on \\p peerDevice are to"]
    #[doc = "                        be directly accessed."]
    #[doc = " \\param peerDevice    - Device on which the allocations to be directly accessed"]
    #[doc = "                        by \\p device reside."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceEnablePeerAccess,"]
    #[doc = " ::cudaDeviceDisablePeerAccess,"]
    #[doc = " ::cuDeviceCanAccessPeer"]
    pub fn cudaDeviceCanAccessPeer(
        canAccessPeer: *mut ::libc::c_int,
        device: ::libc::c_int,
        peerDevice: ::libc::c_int,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Enables direct access to memory allocations on a peer device."]
    #[doc = ""]
    #[doc = " On success, all allocations from \\p peerDevice will immediately be accessible by"]
    #[doc = " the current device.  They will remain accessible until access is explicitly"]
    #[doc = " disabled using ::cudaDeviceDisablePeerAccess() or either device is reset using"]
    #[doc = " ::cudaDeviceReset()."]
    #[doc = ""]
    #[doc = " Note that access granted by this call is unidirectional and that in order to access"]
    #[doc = " memory on the current device from \\p peerDevice, a separate symmetric call"]
    #[doc = " to ::cudaDeviceEnablePeerAccess() is required."]
    #[doc = ""]
    #[doc = " Note that there are both device-wide and system-wide limitations per system"]
    #[doc = " configuration, as noted in the CUDA Programming Guide under the section"]
    #[doc = " \"Peer-to-Peer Memory Access\"."]
    #[doc = ""]
    #[doc = " Returns ::cudaErrorInvalidDevice if ::cudaDeviceCanAccessPeer() indicates"]
    #[doc = " that the current device cannot directly access memory from \\p peerDevice."]
    #[doc = ""]
    #[doc = " Returns ::cudaErrorPeerAccessAlreadyEnabled if direct access of"]
    #[doc = " \\p peerDevice from the current device has already been enabled."]
    #[doc = ""]
    #[doc = " Returns ::cudaErrorInvalidValue if \\p flags is not 0."]
    #[doc = ""]
    #[doc = " \\param peerDevice  - Peer device to enable direct access to from the current device"]
    #[doc = " \\param flags       - Reserved for future use and must be set to 0"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidDevice,"]
    #[doc = " ::cudaErrorPeerAccessAlreadyEnabled,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceCanAccessPeer,"]
    #[doc = " ::cudaDeviceDisablePeerAccess,"]
    #[doc = " ::cuCtxEnablePeerAccess"]
    pub fn cudaDeviceEnablePeerAccess(
        peerDevice: ::libc::c_int,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Disables direct access to memory allocations on a peer device."]
    #[doc = ""]
    #[doc = " Returns ::cudaErrorPeerAccessNotEnabled if direct access to memory on"]
    #[doc = " \\p peerDevice has not yet been enabled from the current device."]
    #[doc = ""]
    #[doc = " \\param peerDevice - Peer device to disable direct access to"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorPeerAccessNotEnabled,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa ::cudaDeviceCanAccessPeer,"]
    #[doc = " ::cudaDeviceEnablePeerAccess,"]
    #[doc = " ::cuCtxDisablePeerAccess"]
    pub fn cudaDeviceDisablePeerAccess(peerDevice: ::libc::c_int) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Unregisters a graphics resource for access by CUDA"]
    #[doc = ""]
    #[doc = " Unregisters the graphics resource \\p resource so it is not accessible by"]
    #[doc = " CUDA unless registered again."]
    #[doc = ""]
    #[doc = " If \\p resource is invalid then ::cudaErrorInvalidResourceHandle is"]
    #[doc = " returned."]
    #[doc = ""]
    #[doc = " \\param resource - Resource to unregister"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorUnknown"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_destroy_ub"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphicsD3D9RegisterResource,"]
    #[doc = " ::cudaGraphicsD3D10RegisterResource,"]
    #[doc = " ::cudaGraphicsD3D11RegisterResource,"]
    #[doc = " ::cudaGraphicsGLRegisterBuffer,"]
    #[doc = " ::cudaGraphicsGLRegisterImage,"]
    #[doc = " ::cuGraphicsUnregisterResource"]
    pub fn cudaGraphicsUnregisterResource(resource: cudaGraphicsResource_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Set usage flags for mapping a graphics resource"]
    #[doc = ""]
    #[doc = " Set \\p flags for mapping the graphics resource \\p resource."]
    #[doc = ""]
    #[doc = " Changes to \\p flags will take effect the next time \\p resource is mapped."]
    #[doc = " The \\p flags argument may be any of the following:"]
    #[doc = " - ::cudaGraphicsMapFlagsNone: Specifies no hints about how \\p resource will"]
    #[doc = "     be used. It is therefore assumed that CUDA may read from or write to \\p resource."]
    #[doc = " - ::cudaGraphicsMapFlagsReadOnly: Specifies that CUDA will not write to \\p resource."]
    #[doc = " - ::cudaGraphicsMapFlagsWriteDiscard: Specifies CUDA will not read from \\p resource and will"]
    #[doc = "   write over the entire contents of \\p resource, so none of the data"]
    #[doc = "   previously stored in \\p resource will be preserved."]
    #[doc = ""]
    #[doc = " If \\p resource is presently mapped for access by CUDA then ::cudaErrorUnknown is returned."]
    #[doc = " If \\p flags is not one of the above values then ::cudaErrorInvalidValue is returned."]
    #[doc = ""]
    #[doc = " \\param resource - Registered resource to set flags for"]
    #[doc = " \\param flags    - Parameters for resource mapping"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorUnknown,"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphicsMapResources,"]
    #[doc = " ::cuGraphicsResourceSetMapFlags"]
    pub fn cudaGraphicsResourceSetMapFlags(
        resource: cudaGraphicsResource_t,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Map graphics resources for access by CUDA"]
    #[doc = ""]
    #[doc = " Maps the \\p count graphics resources in \\p resources for access by CUDA."]
    #[doc = ""]
    #[doc = " The resources in \\p resources may be accessed by CUDA until they"]
    #[doc = " are unmapped. The graphics API from which \\p resources were registered"]
    #[doc = " should not access any resources while they are mapped by CUDA. If an"]
    #[doc = " application does so, the results are undefined."]
    #[doc = ""]
    #[doc = " This function provides the synchronization guarantee that any graphics calls"]
    #[doc = " issued before ::cudaGraphicsMapResources() will complete before any subsequent CUDA"]
    #[doc = " work issued in \\p stream begins."]
    #[doc = ""]
    #[doc = " If \\p resources contains any duplicate entries then ::cudaErrorInvalidResourceHandle"]
    #[doc = " is returned. If any of \\p resources are presently mapped for access by"]
    #[doc = " CUDA then ::cudaErrorUnknown is returned."]
    #[doc = ""]
    #[doc = " \\param count     - Number of resources to map"]
    #[doc = " \\param resources - Resources to map for CUDA"]
    #[doc = " \\param stream    - Stream for synchronization"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorUnknown"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphicsResourceGetMappedPointer,"]
    #[doc = " ::cudaGraphicsSubResourceGetMappedArray,"]
    #[doc = " ::cudaGraphicsUnmapResources,"]
    #[doc = " ::cuGraphicsMapResources"]
    pub fn cudaGraphicsMapResources(
        count: ::libc::c_int,
        resources: *mut cudaGraphicsResource_t,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Unmap graphics resources."]
    #[doc = ""]
    #[doc = " Unmaps the \\p count graphics resources in \\p resources."]
    #[doc = ""]
    #[doc = " Once unmapped, the resources in \\p resources may not be accessed by CUDA"]
    #[doc = " until they are mapped again."]
    #[doc = ""]
    #[doc = " This function provides the synchronization guarantee that any CUDA work issued"]
    #[doc = " in \\p stream before ::cudaGraphicsUnmapResources() will complete before any"]
    #[doc = " subsequently issued graphics work begins."]
    #[doc = ""]
    #[doc = " If \\p resources contains any duplicate entries then ::cudaErrorInvalidResourceHandle"]
    #[doc = " is returned. If any of \\p resources are not presently mapped for access by"]
    #[doc = " CUDA then ::cudaErrorUnknown is returned."]
    #[doc = ""]
    #[doc = " \\param count     - Number of resources to unmap"]
    #[doc = " \\param resources - Resources to unmap"]
    #[doc = " \\param stream    - Stream for synchronization"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorUnknown"]
    #[doc = " \\note_null_stream"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphicsMapResources,"]
    #[doc = " ::cuGraphicsUnmapResources"]
    pub fn cudaGraphicsUnmapResources(
        count: ::libc::c_int,
        resources: *mut cudaGraphicsResource_t,
        stream: cudaStream_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Get an device pointer through which to access a mapped graphics resource."]
    #[doc = ""]
    #[doc = " Returns in \\p *devPtr a pointer through which the mapped graphics resource"]
    #[doc = " \\p resource may be accessed."]
    #[doc = " Returns in \\p *size the size of the memory in bytes which may be accessed from that pointer."]
    #[doc = " The value set in \\p devPtr may change every time that \\p resource is mapped."]
    #[doc = ""]
    #[doc = " If \\p resource is not a buffer then it cannot be accessed via a pointer and"]
    #[doc = " ::cudaErrorUnknown is returned."]
    #[doc = " If \\p resource is not mapped then ::cudaErrorUnknown is returned."]
    #[doc = " *"]
    #[doc = " \\param devPtr     - Returned pointer through which \\p resource may be accessed"]
    #[doc = " \\param size       - Returned size of the buffer accessible starting at \\p *devPtr"]
    #[doc = " \\param resource   - Mapped resource to access"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorUnknown"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphicsMapResources,"]
    #[doc = " ::cudaGraphicsSubResourceGetMappedArray,"]
    #[doc = " ::cuGraphicsResourceGetMappedPointer"]
    pub fn cudaGraphicsResourceGetMappedPointer(
        devPtr: *mut *mut ::libc::c_void,
        size: *mut usize,
        resource: cudaGraphicsResource_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Get an array through which to access a subresource of a mapped graphics resource."]
    #[doc = ""]
    #[doc = " Returns in \\p *array an array through which the subresource of the mapped"]
    #[doc = " graphics resource \\p resource which corresponds to array index \\p arrayIndex"]
    #[doc = " and mipmap level \\p mipLevel may be accessed.  The value set in \\p array may"]
    #[doc = " change every time that \\p resource is mapped."]
    #[doc = ""]
    #[doc = " If \\p resource is not a texture then it cannot be accessed via an array and"]
    #[doc = " ::cudaErrorUnknown is returned."]
    #[doc = " If \\p arrayIndex is not a valid array index for \\p resource then"]
    #[doc = " ::cudaErrorInvalidValue is returned."]
    #[doc = " If \\p mipLevel is not a valid mipmap level for \\p resource then"]
    #[doc = " ::cudaErrorInvalidValue is returned."]
    #[doc = " If \\p resource is not mapped then ::cudaErrorUnknown is returned."]
    #[doc = ""]
    #[doc = " \\param array       - Returned array through which a subresource of \\p resource may be accessed"]
    #[doc = " \\param resource    - Mapped resource to access"]
    #[doc = " \\param arrayIndex  - Array index for array textures or cubemap face"]
    #[doc = "                      index as defined by ::cudaGraphicsCubeFace for"]
    #[doc = "                      cubemap textures for the subresource to access"]
    #[doc = " \\param mipLevel    - Mipmap level for the subresource to access"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorUnknown"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphicsResourceGetMappedPointer,"]
    #[doc = " ::cuGraphicsSubResourceGetMappedArray"]
    pub fn cudaGraphicsSubResourceGetMappedArray(
        array: *mut cudaArray_t,
        resource: cudaGraphicsResource_t,
        arrayIndex: ::libc::c_uint,
        mipLevel: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Get a mipmapped array through which to access a mapped graphics resource."]
    #[doc = ""]
    #[doc = " Returns in \\p *mipmappedArray a mipmapped array through which the mapped"]
    #[doc = " graphics resource \\p resource may be accessed. The value set in \\p mipmappedArray may"]
    #[doc = " change every time that \\p resource is mapped."]
    #[doc = ""]
    #[doc = " If \\p resource is not a texture then it cannot be accessed via an array and"]
    #[doc = " ::cudaErrorUnknown is returned."]
    #[doc = " If \\p resource is not mapped then ::cudaErrorUnknown is returned."]
    #[doc = ""]
    #[doc = " \\param mipmappedArray - Returned mipmapped array through which \\p resource may be accessed"]
    #[doc = " \\param resource       - Mapped resource to access"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorUnknown"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphicsResourceGetMappedPointer,"]
    #[doc = " ::cuGraphicsResourceGetMappedMipmappedArray"]
    pub fn cudaGraphicsResourceGetMappedMipmappedArray(
        mipmappedArray: *mut cudaMipmappedArray_t,
        resource: cudaGraphicsResource_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Binds a memory area to a texture"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Binds \\p size bytes of the memory area pointed to by \\p devPtr to the"]
    #[doc = " texture reference \\p texref. \\p desc describes how the memory is interpreted"]
    #[doc = " when fetching values from the texture. Any memory previously bound to"]
    #[doc = " \\p texref is unbound."]
    #[doc = ""]
    #[doc = " Since the hardware enforces an alignment requirement on texture base"]
    #[doc = " addresses,"]
    #[doc = " \\ref ::cudaBindTexture(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t) \"cudaBindTexture()\""]
    #[doc = " returns in \\p *offset a byte offset that"]
    #[doc = " must be applied to texture fetches in order to read from the desired memory."]
    #[doc = " This offset must be divided by the texel size and passed to kernels that"]
    #[doc = " read from the texture so they can be applied to the ::tex1Dfetch() function."]
    #[doc = " If the device memory pointer was returned from ::cudaMalloc(), the offset is"]
    #[doc = " guaranteed to be 0 and NULL may be passed as the \\p offset parameter."]
    #[doc = ""]
    #[doc = " The total number of elements (or texels) in the linear address range"]
    #[doc = " cannot exceed ::cudaDeviceProp::maxTexture1DLinear[0]."]
    #[doc = " The number of elements is computed as (\\p size / elementSize),"]
    #[doc = " where elementSize is determined from \\p desc."]
    #[doc = ""]
    #[doc = " \\param offset - Offset in bytes"]
    #[doc = " \\param texref - Texture to bind"]
    #[doc = " \\param devPtr - Memory area on device"]
    #[doc = " \\param desc   - Channel format"]
    #[doc = " \\param size   - Size of the memory area pointed to by devPtr"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidTexture"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaCreateChannelDesc(int, int, int, int, cudaChannelFormatKind) \"cudaCreateChannelDesc (C API)\","]
    #[doc = " ::cudaGetChannelDesc, ::cudaGetTextureReference,"]
    #[doc = " \\ref ::cudaBindTexture(size_t*, const struct texture< T, dim, readMode>&, const void*, const struct cudaChannelFormatDesc&, size_t) \"cudaBindTexture (C++ API)\","]
    #[doc = " \\ref ::cudaBindTexture2D(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t, size_t, size_t) \"cudaBindTexture2D (C API)\","]
    #[doc = " \\ref ::cudaBindTextureToArray(const struct textureReference*, cudaArray_const_t, const struct cudaChannelFormatDesc*) \"cudaBindTextureToArray (C API)\","]
    #[doc = " \\ref ::cudaUnbindTexture(const struct textureReference*) \"cudaUnbindTexture (C API)\","]
    #[doc = " \\ref ::cudaGetTextureAlignmentOffset(size_t*, const struct textureReference*) \"cudaGetTextureAlignmentOffset (C API)\","]
    #[doc = " ::cuTexRefSetAddress,"]
    #[doc = " ::cuTexRefSetAddressMode,"]
    #[doc = " ::cuTexRefSetFormat,"]
    #[doc = " ::cuTexRefSetFlags,"]
    #[doc = " ::cuTexRefSetBorderColor"]
    pub fn cudaBindTexture(
        offset: *mut usize,
        texref: *const textureReference,
        devPtr: *const ::libc::c_void,
        desc: *const cudaChannelFormatDesc,
        size: usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Binds a 2D memory area to a texture"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Binds the 2D memory area pointed to by \\p devPtr to the"]
    #[doc = " texture reference \\p texref. The size of the area is constrained by"]
    #[doc = " \\p width in texel units, \\p height in texel units, and \\p pitch in byte"]
    #[doc = " units. \\p desc describes how the memory is interpreted when fetching values"]
    #[doc = " from the texture. Any memory previously bound to \\p texref is unbound."]
    #[doc = ""]
    #[doc = " Since the hardware enforces an alignment requirement on texture base"]
    #[doc = " addresses, ::cudaBindTexture2D() returns in \\p *offset a byte offset that"]
    #[doc = " must be applied to texture fetches in order to read from the desired memory."]
    #[doc = " This offset must be divided by the texel size and passed to kernels that"]
    #[doc = " read from the texture so they can be applied to the ::tex2D() function."]
    #[doc = " If the device memory pointer was returned from ::cudaMalloc(), the offset is"]
    #[doc = " guaranteed to be 0 and NULL may be passed as the \\p offset parameter."]
    #[doc = ""]
    #[doc = " \\p width and \\p height, which are specified in elements (or texels), cannot"]
    #[doc = " exceed ::cudaDeviceProp::maxTexture2DLinear[0] and ::cudaDeviceProp::maxTexture2DLinear[1]"]
    #[doc = " respectively. \\p pitch, which is specified in bytes, cannot exceed"]
    #[doc = " ::cudaDeviceProp::maxTexture2DLinear[2]."]
    #[doc = ""]
    #[doc = " The driver returns ::cudaErrorInvalidValue if \\p pitch is not a multiple of"]
    #[doc = " ::cudaDeviceProp::texturePitchAlignment."]
    #[doc = ""]
    #[doc = " \\param offset - Offset in bytes"]
    #[doc = " \\param texref - Texture reference to bind"]
    #[doc = " \\param devPtr - 2D memory area on device"]
    #[doc = " \\param desc   - Channel format"]
    #[doc = " \\param width  - Width in texel units"]
    #[doc = " \\param height - Height in texel units"]
    #[doc = " \\param pitch  - Pitch in bytes"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidTexture"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaCreateChannelDesc(int, int, int, int, cudaChannelFormatKind) \"cudaCreateChannelDesc (C API)\","]
    #[doc = " ::cudaGetChannelDesc, ::cudaGetTextureReference,"]
    #[doc = " \\ref ::cudaBindTexture(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t) \"cudaBindTexture (C API)\","]
    #[doc = " \\ref ::cudaBindTexture2D(size_t*, const struct texture< T, dim, readMode>&, const void*, const struct cudaChannelFormatDesc&, size_t, size_t, size_t) \"cudaBindTexture2D (C++ API)\","]
    #[doc = " \\ref ::cudaBindTexture2D(size_t*, const struct texture<T, dim, readMode>&, const void*, size_t, size_t, size_t) \"cudaBindTexture2D (C++ API, inherited channel descriptor)\","]
    #[doc = " \\ref ::cudaBindTextureToArray(const struct textureReference*, cudaArray_const_t, const struct cudaChannelFormatDesc*) \"cudaBindTextureToArray (C API)\","]
    #[doc = " \\ref ::cudaUnbindTexture(const struct textureReference*) \"cudaBindTextureToArray (C API)\","]
    #[doc = " \\ref ::cudaGetTextureAlignmentOffset(size_t*, const struct textureReference*) \"cudaGetTextureAlignmentOffset (C API)\","]
    #[doc = " ::cuTexRefSetAddress2D,"]
    #[doc = " ::cuTexRefSetFormat,"]
    #[doc = " ::cuTexRefSetFlags,"]
    #[doc = " ::cuTexRefSetAddressMode,"]
    #[doc = " ::cuTexRefSetBorderColor"]
    pub fn cudaBindTexture2D(
        offset: *mut usize,
        texref: *const textureReference,
        devPtr: *const ::libc::c_void,
        desc: *const cudaChannelFormatDesc,
        width: usize,
        height: usize,
        pitch: usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Binds an array to a texture"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Binds the CUDA array \\p array to the texture reference \\p texref."]
    #[doc = " \\p desc describes how the memory is interpreted when fetching values from"]
    #[doc = " the texture. Any CUDA array previously bound to \\p texref is unbound."]
    #[doc = ""]
    #[doc = " \\param texref - Texture to bind"]
    #[doc = " \\param array  - Memory array on device"]
    #[doc = " \\param desc   - Channel format"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidTexture"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaCreateChannelDesc(int, int, int, int, cudaChannelFormatKind) \"cudaCreateChannelDesc (C API)\","]
    #[doc = " ::cudaGetChannelDesc, ::cudaGetTextureReference,"]
    #[doc = " \\ref ::cudaBindTexture(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t) \"cudaBindTexture (C API)\","]
    #[doc = " \\ref ::cudaBindTexture2D(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t, size_t, size_t) \"cudaBindTexture2D (C API)\","]
    #[doc = " \\ref ::cudaBindTextureToArray(const struct texture< T, dim, readMode>&, cudaArray_const_t, const struct cudaChannelFormatDesc&) \"cudaBindTextureToArray (C++ API)\","]
    #[doc = " \\ref ::cudaUnbindTexture(const struct textureReference*) \"cudaUnbindTexture (C API)\","]
    #[doc = " \\ref ::cudaGetTextureAlignmentOffset(size_t*, const struct textureReference*) \"cudaGetTextureAlignmentOffset (C API)\","]
    #[doc = " ::cuTexRefSetArray,"]
    #[doc = " ::cuTexRefSetFormat,"]
    #[doc = " ::cuTexRefSetFlags,"]
    #[doc = " ::cuTexRefSetAddressMode,"]
    #[doc = " ::cuTexRefSetFilterMode,"]
    #[doc = " ::cuTexRefSetBorderColor,"]
    #[doc = " ::cuTexRefSetMaxAnisotropy"]
    pub fn cudaBindTextureToArray(
        texref: *const textureReference,
        array: cudaArray_const_t,
        desc: *const cudaChannelFormatDesc,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Binds a mipmapped array to a texture"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Binds the CUDA mipmapped array \\p mipmappedArray to the texture reference \\p texref."]
    #[doc = " \\p desc describes how the memory is interpreted when fetching values from"]
    #[doc = " the texture. Any CUDA mipmapped array previously bound to \\p texref is unbound."]
    #[doc = ""]
    #[doc = " \\param texref         - Texture to bind"]
    #[doc = " \\param mipmappedArray - Memory mipmapped array on device"]
    #[doc = " \\param desc           - Channel format"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidTexture"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaCreateChannelDesc(int, int, int, int, cudaChannelFormatKind) \"cudaCreateChannelDesc (C API)\","]
    #[doc = " ::cudaGetChannelDesc, ::cudaGetTextureReference,"]
    #[doc = " \\ref ::cudaBindTexture(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t) \"cudaBindTexture (C API)\","]
    #[doc = " \\ref ::cudaBindTexture2D(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t, size_t, size_t) \"cudaBindTexture2D (C API)\","]
    #[doc = " \\ref ::cudaBindTextureToArray(const struct texture< T, dim, readMode>&, cudaArray_const_t, const struct cudaChannelFormatDesc&) \"cudaBindTextureToArray (C++ API)\","]
    #[doc = " \\ref ::cudaUnbindTexture(const struct textureReference*) \"cudaUnbindTexture (C API)\","]
    #[doc = " \\ref ::cudaGetTextureAlignmentOffset(size_t*, const struct textureReference*) \"cudaGetTextureAlignmentOffset (C API)\","]
    #[doc = " ::cuTexRefSetMipmappedArray,"]
    #[doc = " ::cuTexRefSetMipmapFilterMode,"]
    #[doc = " ::cuTexRefSetMipmapLevelClamp,"]
    #[doc = " ::cuTexRefSetMipmapLevelBias,"]
    #[doc = " ::cuTexRefSetFormat,"]
    #[doc = " ::cuTexRefSetFlags,"]
    #[doc = " ::cuTexRefSetAddressMode,"]
    #[doc = " ::cuTexRefSetBorderColor,"]
    #[doc = " ::cuTexRefSetMaxAnisotropy"]
    pub fn cudaBindTextureToMipmappedArray(
        texref: *const textureReference,
        mipmappedArray: cudaMipmappedArray_const_t,
        desc: *const cudaChannelFormatDesc,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Unbinds a texture"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Unbinds the texture bound to \\p texref. If \\p texref is not currently bound, no operation is performed."]
    #[doc = ""]
    #[doc = " \\param texref - Texture to unbind"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidTexture"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaCreateChannelDesc(int, int, int, int, cudaChannelFormatKind) \"cudaCreateChannelDesc (C API)\","]
    #[doc = " ::cudaGetChannelDesc, ::cudaGetTextureReference,"]
    #[doc = " \\ref ::cudaBindTexture(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t) \"cudaBindTexture (C API)\","]
    #[doc = " \\ref ::cudaBindTexture2D(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t, size_t, size_t) \"cudaBindTexture2D (C API)\","]
    #[doc = " \\ref ::cudaBindTextureToArray(const struct textureReference*, cudaArray_const_t, const struct cudaChannelFormatDesc*) \"cudaBindTextureToArray (C API)\","]
    #[doc = " \\ref ::cudaUnbindTexture(const struct texture< T, dim, readMode>&) \"cudaUnbindTexture (C++ API)\","]
    #[doc = " \\ref ::cudaGetTextureAlignmentOffset(size_t*, const struct textureReference*) \"cudaGetTextureAlignmentOffset (C API)\""]
    pub fn cudaUnbindTexture(texref: *const textureReference) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Get the alignment offset of a texture"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Returns in \\p *offset the offset that was returned when texture reference"]
    #[doc = " \\p texref was bound."]
    #[doc = ""]
    #[doc = " \\param offset - Offset of texture reference in bytes"]
    #[doc = " \\param texref - Texture to get offset of"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidTexture,"]
    #[doc = " ::cudaErrorInvalidTextureBinding"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaCreateChannelDesc(int, int, int, int, cudaChannelFormatKind) \"cudaCreateChannelDesc (C API)\","]
    #[doc = " ::cudaGetChannelDesc, ::cudaGetTextureReference,"]
    #[doc = " \\ref ::cudaBindTexture(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t) \"cudaBindTexture (C API)\","]
    #[doc = " \\ref ::cudaBindTexture2D(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t, size_t, size_t) \"cudaBindTexture2D (C API)\","]
    #[doc = " \\ref ::cudaBindTextureToArray(const struct textureReference*, cudaArray_const_t, const struct cudaChannelFormatDesc*) \"cudaBindTextureToArray (C API)\","]
    #[doc = " \\ref ::cudaUnbindTexture(const struct textureReference*) \"cudaUnbindTexture (C API)\","]
    #[doc = " \\ref ::cudaGetTextureAlignmentOffset(size_t*, const struct texture< T, dim, readMode>&) \"cudaGetTextureAlignmentOffset (C++ API)\""]
    pub fn cudaGetTextureAlignmentOffset(
        offset: *mut usize,
        texref: *const textureReference,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Get the texture reference associated with a symbol"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Returns in \\p *texref the structure associated to the texture reference"]
    #[doc = " defined by symbol \\p symbol."]
    #[doc = ""]
    #[doc = " \\param texref - Texture reference associated with symbol"]
    #[doc = " \\param symbol - Texture to get reference for"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidTexture"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_string_api_deprecation_50"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaCreateChannelDesc(int, int, int, int, cudaChannelFormatKind) \"cudaCreateChannelDesc (C API)\","]
    #[doc = " ::cudaGetChannelDesc,"]
    #[doc = " \\ref ::cudaGetTextureAlignmentOffset(size_t*, const struct textureReference*) \"cudaGetTextureAlignmentOffset (C API)\","]
    #[doc = " \\ref ::cudaBindTexture(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t) \"cudaBindTexture (C API)\","]
    #[doc = " \\ref ::cudaBindTexture2D(size_t*, const struct textureReference*, const void*, const struct cudaChannelFormatDesc*, size_t, size_t, size_t) \"cudaBindTexture2D (C API)\","]
    #[doc = " \\ref ::cudaBindTextureToArray(const struct textureReference*, cudaArray_const_t, const struct cudaChannelFormatDesc*) \"cudaBindTextureToArray (C API)\","]
    #[doc = " \\ref ::cudaUnbindTexture(const struct textureReference*) \"cudaUnbindTexture (C API)\","]
    #[doc = " ::cuModuleGetTexRef"]
    pub fn cudaGetTextureReference(
        texref: *mut *const textureReference,
        symbol: *const ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Binds an array to a surface"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Binds the CUDA array \\p array to the surface reference \\p surfref."]
    #[doc = " \\p desc describes how the memory is interpreted when fetching values from"]
    #[doc = " the surface. Any CUDA array previously bound to \\p surfref is unbound."]
    #[doc = ""]
    #[doc = " \\param surfref - Surface to bind"]
    #[doc = " \\param array  - Memory array on device"]
    #[doc = " \\param desc   - Channel format"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidSurface"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaBindSurfaceToArray(const struct surface< T, dim>&, cudaArray_const_t, const struct cudaChannelFormatDesc&) \"cudaBindSurfaceToArray (C++ API)\","]
    #[doc = " \\ref ::cudaBindSurfaceToArray(const struct surface< T, dim>&, cudaArray_const_t) \"cudaBindSurfaceToArray (C++ API, inherited channel descriptor)\","]
    #[doc = " ::cudaGetSurfaceReference,"]
    #[doc = " ::cuSurfRefSetArray"]
    pub fn cudaBindSurfaceToArray(
        surfref: *const surfaceReference,
        array: cudaArray_const_t,
        desc: *const cudaChannelFormatDesc,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Get the surface reference associated with a symbol"]
    #[doc = ""]
    #[doc = " \\deprecated"]
    #[doc = ""]
    #[doc = " Returns in \\p *surfref the structure associated to the surface reference"]
    #[doc = " defined by symbol \\p symbol."]
    #[doc = ""]
    #[doc = " \\param surfref - Surface reference associated with symbol"]
    #[doc = " \\param symbol - Surface to get reference for"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidSurface"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_string_api_deprecation_50"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " \\ref ::cudaBindSurfaceToArray(const struct surfaceReference*, cudaArray_const_t, const struct cudaChannelFormatDesc*) \"cudaBindSurfaceToArray (C API)\","]
    #[doc = " ::cuModuleGetSurfRef"]
    pub fn cudaGetSurfaceReference(
        surfref: *mut *const surfaceReference,
        symbol: *const ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Get the channel descriptor of an array"]
    #[doc = ""]
    #[doc = " Returns in \\p *desc the channel descriptor of the CUDA array \\p array."]
    #[doc = ""]
    #[doc = " \\param desc  - Channel format"]
    #[doc = " \\param array - Memory array on device"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaCreateChannelDesc(int, int, int, int, cudaChannelFormatKind) \"cudaCreateChannelDesc (C API)\","]
    #[doc = " ::cudaCreateTextureObject, ::cudaCreateSurfaceObject"]
    pub fn cudaGetChannelDesc(
        desc: *mut cudaChannelFormatDesc,
        array: cudaArray_const_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a channel descriptor using the specified format"]
    #[doc = ""]
    #[doc = " Returns a channel descriptor with format \\p f and number of bits of each"]
    #[doc = " component \\p x, \\p y, \\p z, and \\p w.  The ::cudaChannelFormatDesc is"]
    #[doc = " defined as:"]
    #[doc = " \\code"]
    #[doc = "struct cudaChannelFormatDesc {"]
    #[doc = "int x, y, z, w;"]
    #[doc = "enum cudaChannelFormatKind f;"]
    #[doc = "};"]
    #[doc = " \\endcode"]
    #[doc = ""]
    #[doc = " where ::cudaChannelFormatKind is one of ::cudaChannelFormatKindSigned,"]
    #[doc = " ::cudaChannelFormatKindUnsigned, or ::cudaChannelFormatKindFloat."]
    #[doc = ""]
    #[doc = " \\param x - X component"]
    #[doc = " \\param y - Y component"]
    #[doc = " \\param z - Z component"]
    #[doc = " \\param w - W component"]
    #[doc = " \\param f - Channel format"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " Channel descriptor with format \\p f"]
    #[doc = ""]
    #[doc = " \\sa \\ref ::cudaCreateChannelDesc(void) \"cudaCreateChannelDesc (C++ API)\","]
    #[doc = " ::cudaGetChannelDesc, ::cudaCreateTextureObject, ::cudaCreateSurfaceObject"]
    pub fn cudaCreateChannelDesc(
        x: ::libc::c_int,
        y: ::libc::c_int,
        z: ::libc::c_int,
        w: ::libc::c_int,
        f: cudaChannelFormatKind,
    ) -> cudaChannelFormatDesc;
}
extern "C" {
    #[doc = " \\brief Creates a texture object"]
    #[doc = ""]
    #[doc = " Creates a texture object and returns it in \\p pTexObject. \\p pResDesc describes"]
    #[doc = " the data to texture from. \\p pTexDesc describes how the data should be sampled."]
    #[doc = " \\p pResViewDesc is an optional argument that specifies an alternate format for"]
    #[doc = " the data described by \\p pResDesc, and also describes the subresource region"]
    #[doc = " to restrict access to when texturing. \\p pResViewDesc can only be specified if"]
    #[doc = " the type of resource is a CUDA array or a CUDA mipmapped array."]
    #[doc = ""]
    #[doc = " Texture objects are only supported on devices of compute capability 3.0 or higher."]
    #[doc = " Additionally, a texture object is an opaque value, and, as such, should only be"]
    #[doc = " accessed through CUDA API calls."]
    #[doc = ""]
    #[doc = " The ::cudaResourceDesc structure is defined as:"]
    #[doc = " \\code"]
    #[doc = "struct cudaResourceDesc {"]
    #[doc = "enum cudaResourceType resType;"]
    #[doc = ""]
    #[doc = "union {"]
    #[doc = "struct {"]
    #[doc = "cudaArray_t array;"]
    #[doc = "} array;"]
    #[doc = "struct {"]
    #[doc = "cudaMipmappedArray_t mipmap;"]
    #[doc = "} mipmap;"]
    #[doc = "struct {"]
    #[doc = "void *devPtr;"]
    #[doc = "struct cudaChannelFormatDesc desc;"]
    #[doc = "size_t sizeInBytes;"]
    #[doc = "} linear;"]
    #[doc = "struct {"]
    #[doc = "void *devPtr;"]
    #[doc = "struct cudaChannelFormatDesc desc;"]
    #[doc = "size_t width;"]
    #[doc = "size_t height;"]
    #[doc = "size_t pitchInBytes;"]
    #[doc = "} pitch2D;"]
    #[doc = "} res;"]
    #[doc = "};"]
    #[doc = " \\endcode"]
    #[doc = " where:"]
    #[doc = " - ::cudaResourceDesc::resType specifies the type of resource to texture from."]
    #[doc = " CUresourceType is defined as:"]
    #[doc = " \\code"]
    #[doc = "enum cudaResourceType {"]
    #[doc = "cudaResourceTypeArray          = 0x00,"]
    #[doc = "cudaResourceTypeMipmappedArray = 0x01,"]
    #[doc = "cudaResourceTypeLinear         = 0x02,"]
    #[doc = "cudaResourceTypePitch2D        = 0x03"]
    #[doc = "};"]
    #[doc = " \\endcode"]
    #[doc = ""]
    #[doc = " \\par"]
    #[doc = " If ::cudaResourceDesc::resType is set to ::cudaResourceTypeArray, ::cudaResourceDesc::res::array::array"]
    #[doc = " must be set to a valid CUDA array handle."]
    #[doc = ""]
    #[doc = " \\par"]
    #[doc = " If ::cudaResourceDesc::resType is set to ::cudaResourceTypeMipmappedArray, ::cudaResourceDesc::res::mipmap::mipmap"]
    #[doc = " must be set to a valid CUDA mipmapped array handle and ::cudaTextureDesc::normalizedCoords must be set to true."]
    #[doc = ""]
    #[doc = " \\par"]
    #[doc = " If ::cudaResourceDesc::resType is set to ::cudaResourceTypeLinear, ::cudaResourceDesc::res::linear::devPtr"]
    #[doc = " must be set to a valid device pointer, that is aligned to ::cudaDeviceProp::textureAlignment."]
    #[doc = " ::cudaResourceDesc::res::linear::desc describes the format and the number of components per array element. ::cudaResourceDesc::res::linear::sizeInBytes"]
    #[doc = " specifies the size of the array in bytes. The total number of elements in the linear address range cannot exceed"]
    #[doc = " ::cudaDeviceProp::maxTexture1DLinear. The number of elements is computed as (sizeInBytes / sizeof(desc))."]
    #[doc = ""]
    #[doc = " \\par"]
    #[doc = " If ::cudaResourceDesc::resType is set to ::cudaResourceTypePitch2D, ::cudaResourceDesc::res::pitch2D::devPtr"]
    #[doc = " must be set to a valid device pointer, that is aligned to ::cudaDeviceProp::textureAlignment."]
    #[doc = " ::cudaResourceDesc::res::pitch2D::desc describes the format and the number of components per array element. ::cudaResourceDesc::res::pitch2D::width"]
    #[doc = " and ::cudaResourceDesc::res::pitch2D::height specify the width and height of the array in elements, and cannot exceed"]
    #[doc = " ::cudaDeviceProp::maxTexture2DLinear[0] and ::cudaDeviceProp::maxTexture2DLinear[1] respectively."]
    #[doc = " ::cudaResourceDesc::res::pitch2D::pitchInBytes specifies the pitch between two rows in bytes and has to be aligned to"]
    #[doc = " ::cudaDeviceProp::texturePitchAlignment. Pitch cannot exceed ::cudaDeviceProp::maxTexture2DLinear[2]."]
    #[doc = ""]
    #[doc = ""]
    #[doc = " The ::cudaTextureDesc struct is defined as"]
    #[doc = " \\code"]
    #[doc = "struct cudaTextureDesc {"]
    #[doc = "enum cudaTextureAddressMode addressMode[3];"]
    #[doc = "enum cudaTextureFilterMode  filterMode;"]
    #[doc = "enum cudaTextureReadMode    readMode;"]
    #[doc = "int                         sRGB;"]
    #[doc = "float                       borderColor[4];"]
    #[doc = "int                         normalizedCoords;"]
    #[doc = "unsigned int                maxAnisotropy;"]
    #[doc = "enum cudaTextureFilterMode  mipmapFilterMode;"]
    #[doc = "float                       mipmapLevelBias;"]
    #[doc = "float                       minMipmapLevelClamp;"]
    #[doc = "float                       maxMipmapLevelClamp;"]
    #[doc = "int                         disableTrilinearOptimization;"]
    #[doc = "};"]
    #[doc = " \\endcode"]
    #[doc = " where"]
    #[doc = " - ::cudaTextureDesc::addressMode specifies the addressing mode for each dimension of the texture data. ::cudaTextureAddressMode is defined as:"]
    #[doc = "   \\code"]
    #[doc = "enum cudaTextureAddressMode {"]
    #[doc = "cudaAddressModeWrap   = 0,"]
    #[doc = "cudaAddressModeClamp  = 1,"]
    #[doc = "cudaAddressModeMirror = 2,"]
    #[doc = "cudaAddressModeBorder = 3"]
    #[doc = "};"]
    #[doc = "   \\endcode"]
    #[doc = "   This is ignored if ::cudaResourceDesc::resType is ::cudaResourceTypeLinear. Also, if ::cudaTextureDesc::normalizedCoords"]
    #[doc = "   is set to zero, ::cudaAddressModeWrap and ::cudaAddressModeMirror won't be supported and will be switched to ::cudaAddressModeClamp."]
    #[doc = ""]
    #[doc = " - ::cudaTextureDesc::filterMode specifies the filtering mode to be used when fetching from the texture. ::cudaTextureFilterMode is defined as:"]
    #[doc = "   \\code"]
    #[doc = "enum cudaTextureFilterMode {"]
    #[doc = "cudaFilterModePoint  = 0,"]
    #[doc = "cudaFilterModeLinear = 1"]
    #[doc = "};"]
    #[doc = "   \\endcode"]
    #[doc = "   This is ignored if ::cudaResourceDesc::resType is ::cudaResourceTypeLinear."]
    #[doc = ""]
    #[doc = " - ::cudaTextureDesc::readMode specifies whether integer data should be converted to floating point or not. ::cudaTextureReadMode is defined as:"]
    #[doc = "   \\code"]
    #[doc = "enum cudaTextureReadMode {"]
    #[doc = "cudaReadModeElementType     = 0,"]
    #[doc = "cudaReadModeNormalizedFloat = 1"]
    #[doc = "};"]
    #[doc = "   \\endcode"]
    #[doc = "   Note that this applies only to 8-bit and 16-bit integer formats. 32-bit integer format would not be promoted, regardless of"]
    #[doc = "   whether or not this ::cudaTextureDesc::readMode is set ::cudaReadModeNormalizedFloat is specified."]
    #[doc = ""]
    #[doc = " - ::cudaTextureDesc::sRGB specifies whether sRGB to linear conversion should be performed during texture fetch."]
    #[doc = ""]
    #[doc = " - ::cudaTextureDesc::borderColor specifies the float values of color. where:"]
    #[doc = "   ::cudaTextureDesc::borderColor[0] contains value of 'R',"]
    #[doc = "   ::cudaTextureDesc::borderColor[1] contains value of 'G',"]
    #[doc = "   ::cudaTextureDesc::borderColor[2] contains value of 'B',"]
    #[doc = "   ::cudaTextureDesc::borderColor[3] contains value of 'A'"]
    #[doc = "   Note that application using integer border color values will need to <reinterpret_cast> these values to float."]
    #[doc = "   The values are set only when the addressing mode specified by ::cudaTextureDesc::addressMode is cudaAddressModeBorder."]
    #[doc = ""]
    #[doc = " - ::cudaTextureDesc::normalizedCoords specifies whether the texture coordinates will be normalized or not."]
    #[doc = ""]
    #[doc = " - ::cudaTextureDesc::maxAnisotropy specifies the maximum anistropy ratio to be used when doing anisotropic filtering. This value will be"]
    #[doc = "   clamped to the range [1,16]."]
    #[doc = ""]
    #[doc = " - ::cudaTextureDesc::mipmapFilterMode specifies the filter mode when the calculated mipmap level lies between two defined mipmap levels."]
    #[doc = ""]
    #[doc = " - ::cudaTextureDesc::mipmapLevelBias specifies the offset to be applied to the calculated mipmap level."]
    #[doc = ""]
    #[doc = " - ::cudaTextureDesc::minMipmapLevelClamp specifies the lower end of the mipmap level range to clamp access to."]
    #[doc = ""]
    #[doc = " - ::cudaTextureDesc::maxMipmapLevelClamp specifies the upper end of the mipmap level range to clamp access to."]
    #[doc = ""]
    #[doc = " - ::cudaTextureDesc::disableTrilinearOptimization specifies whether the trilinear filtering optimizations will be disabled."]
    #[doc = ""]
    #[doc = ""]
    #[doc = " The ::cudaResourceViewDesc struct is defined as"]
    #[doc = " \\code"]
    #[doc = "struct cudaResourceViewDesc {"]
    #[doc = "enum cudaResourceViewFormat format;"]
    #[doc = "size_t                      width;"]
    #[doc = "size_t                      height;"]
    #[doc = "size_t                      depth;"]
    #[doc = "unsigned int                firstMipmapLevel;"]
    #[doc = "unsigned int                lastMipmapLevel;"]
    #[doc = "unsigned int                firstLayer;"]
    #[doc = "unsigned int                lastLayer;"]
    #[doc = "};"]
    #[doc = " \\endcode"]
    #[doc = " where:"]
    #[doc = " - ::cudaResourceViewDesc::format specifies how the data contained in the CUDA array or CUDA mipmapped array should"]
    #[doc = "   be interpreted. Note that this can incur a change in size of the texture data. If the resource view format is a block"]
    #[doc = "   compressed format, then the underlying CUDA array or CUDA mipmapped array has to have a 32-bit unsigned integer format"]
    #[doc = "   with 2 or 4 channels, depending on the block compressed format. For ex., BC1 and BC4 require the underlying CUDA array to have"]
    #[doc = "   a 32-bit unsigned int with 2 channels. The other BC formats require the underlying resource to have the same 32-bit unsigned int"]
    #[doc = "   format but with 4 channels."]
    #[doc = ""]
    #[doc = " - ::cudaResourceViewDesc::width specifies the new width of the texture data. If the resource view format is a block"]
    #[doc = "   compressed format, this value has to be 4 times the original width of the resource. For non block compressed formats,"]
    #[doc = "   this value has to be equal to that of the original resource."]
    #[doc = ""]
    #[doc = " - ::cudaResourceViewDesc::height specifies the new height of the texture data. If the resource view format is a block"]
    #[doc = "   compressed format, this value has to be 4 times the original height of the resource. For non block compressed formats,"]
    #[doc = "   this value has to be equal to that of the original resource."]
    #[doc = ""]
    #[doc = " - ::cudaResourceViewDesc::depth specifies the new depth of the texture data. This value has to be equal to that of the"]
    #[doc = "   original resource."]
    #[doc = ""]
    #[doc = " - ::cudaResourceViewDesc::firstMipmapLevel specifies the most detailed mipmap level. This will be the new mipmap level zero."]
    #[doc = "   For non-mipmapped resources, this value has to be zero.::cudaTextureDesc::minMipmapLevelClamp and ::cudaTextureDesc::maxMipmapLevelClamp"]
    #[doc = "   will be relative to this value. For ex., if the firstMipmapLevel is set to 2, and a minMipmapLevelClamp of 1.2 is specified,"]
    #[doc = "   then the actual minimum mipmap level clamp will be 3.2."]
    #[doc = ""]
    #[doc = " - ::cudaResourceViewDesc::lastMipmapLevel specifies the least detailed mipmap level. For non-mipmapped resources, this value"]
    #[doc = "   has to be zero."]
    #[doc = ""]
    #[doc = " - ::cudaResourceViewDesc::firstLayer specifies the first layer index for layered textures. This will be the new layer zero."]
    #[doc = "   For non-layered resources, this value has to be zero."]
    #[doc = ""]
    #[doc = " - ::cudaResourceViewDesc::lastLayer specifies the last layer index for layered textures. For non-layered resources,"]
    #[doc = "   this value has to be zero."]
    #[doc = ""]
    #[doc = ""]
    #[doc = " \\param pTexObject   - Texture object to create"]
    #[doc = " \\param pResDesc     - Resource descriptor"]
    #[doc = " \\param pTexDesc     - Texture descriptor"]
    #[doc = " \\param pResViewDesc - Resource view descriptor"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaDestroyTextureObject,"]
    #[doc = " ::cuTexObjectCreate"]
    pub fn cudaCreateTextureObject(
        pTexObject: *mut cudaTextureObject_t,
        pResDesc: *const cudaResourceDesc,
        pTexDesc: *const cudaTextureDesc,
        pResViewDesc: *const cudaResourceViewDesc,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Destroys a texture object"]
    #[doc = ""]
    #[doc = " Destroys the texture object specified by \\p texObject."]
    #[doc = ""]
    #[doc = " \\param texObject - Texture object to destroy"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_destroy_ub"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaCreateTextureObject,"]
    #[doc = " ::cuTexObjectDestroy"]
    pub fn cudaDestroyTextureObject(texObject: cudaTextureObject_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a texture object's resource descriptor"]
    #[doc = ""]
    #[doc = " Returns the resource descriptor for the texture object specified by \\p texObject."]
    #[doc = ""]
    #[doc = " \\param pResDesc  - Resource descriptor"]
    #[doc = " \\param texObject - Texture object"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaCreateTextureObject,"]
    #[doc = " ::cuTexObjectGetResourceDesc"]
    pub fn cudaGetTextureObjectResourceDesc(
        pResDesc: *mut cudaResourceDesc,
        texObject: cudaTextureObject_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a texture object's texture descriptor"]
    #[doc = ""]
    #[doc = " Returns the texture descriptor for the texture object specified by \\p texObject."]
    #[doc = ""]
    #[doc = " \\param pTexDesc  - Texture descriptor"]
    #[doc = " \\param texObject - Texture object"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaCreateTextureObject,"]
    #[doc = " ::cuTexObjectGetTextureDesc"]
    pub fn cudaGetTextureObjectTextureDesc(
        pTexDesc: *mut cudaTextureDesc,
        texObject: cudaTextureObject_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a texture object's resource view descriptor"]
    #[doc = ""]
    #[doc = " Returns the resource view descriptor for the texture object specified by \\p texObject."]
    #[doc = " If no resource view was specified, ::cudaErrorInvalidValue is returned."]
    #[doc = ""]
    #[doc = " \\param pResViewDesc - Resource view descriptor"]
    #[doc = " \\param texObject    - Texture object"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaCreateTextureObject,"]
    #[doc = " ::cuTexObjectGetResourceViewDesc"]
    pub fn cudaGetTextureObjectResourceViewDesc(
        pResViewDesc: *mut cudaResourceViewDesc,
        texObject: cudaTextureObject_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Creates a surface object"]
    #[doc = ""]
    #[doc = " Creates a surface object and returns it in \\p pSurfObject. \\p pResDesc describes"]
    #[doc = " the data to perform surface load/stores on. ::cudaResourceDesc::resType must be"]
    #[doc = " ::cudaResourceTypeArray and  ::cudaResourceDesc::res::array::array"]
    #[doc = " must be set to a valid CUDA array handle."]
    #[doc = ""]
    #[doc = " Surface objects are only supported on devices of compute capability 3.0 or higher."]
    #[doc = " Additionally, a surface object is an opaque value, and, as such, should only be"]
    #[doc = " accessed through CUDA API calls."]
    #[doc = ""]
    #[doc = " \\param pSurfObject - Surface object to create"]
    #[doc = " \\param pResDesc    - Resource descriptor"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidChannelDescriptor,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaDestroySurfaceObject,"]
    #[doc = " ::cuSurfObjectCreate"]
    pub fn cudaCreateSurfaceObject(
        pSurfObject: *mut cudaSurfaceObject_t,
        pResDesc: *const cudaResourceDesc,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Destroys a surface object"]
    #[doc = ""]
    #[doc = " Destroys the surface object specified by \\p surfObject."]
    #[doc = ""]
    #[doc = " \\param surfObject - Surface object to destroy"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_destroy_ub"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaCreateSurfaceObject,"]
    #[doc = " ::cuSurfObjectDestroy"]
    pub fn cudaDestroySurfaceObject(surfObject: cudaSurfaceObject_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a surface object's resource descriptor"]
    #[doc = " Returns the resource descriptor for the surface object specified by \\p surfObject."]
    #[doc = ""]
    #[doc = " \\param pResDesc   - Resource descriptor"]
    #[doc = " \\param surfObject - Surface object"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaCreateSurfaceObject,"]
    #[doc = " ::cuSurfObjectGetResourceDesc"]
    pub fn cudaGetSurfaceObjectResourceDesc(
        pResDesc: *mut cudaResourceDesc,
        surfObject: cudaSurfaceObject_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns the latest version of CUDA supported by the driver"]
    #[doc = ""]
    #[doc = " Returns in \\p *driverVersion the latest version of CUDA supported by"]
    #[doc = " the driver. The version is returned as (1000 &times; major + 10 &times; minor)."]
    #[doc = " For example, CUDA 9.2 would be represented by 9020. If no driver is installed,"]
    #[doc = " then 0 is returned as the driver version."]
    #[doc = ""]
    #[doc = " This function automatically returns ::cudaErrorInvalidValue"]
    #[doc = " if \\p driverVersion is NULL."]
    #[doc = ""]
    #[doc = " \\param driverVersion - Returns the CUDA driver version."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaRuntimeGetVersion,"]
    #[doc = " ::cuDriverGetVersion"]
    pub fn cudaDriverGetVersion(driverVersion: *mut ::libc::c_int) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns the CUDA Runtime version"]
    #[doc = ""]
    #[doc = " Returns in \\p *runtimeVersion the version number of the current CUDA"]
    #[doc = " Runtime instance. The version is returned as"]
    #[doc = " (1000 &times; major + 10 &times; minor). For example,"]
    #[doc = " CUDA 9.2 would be represented by 9020."]
    #[doc = ""]
    #[doc = " This function automatically returns ::cudaErrorInvalidValue if"]
    #[doc = " the \\p runtimeVersion argument is NULL."]
    #[doc = ""]
    #[doc = " \\param runtimeVersion - Returns the CUDA Runtime version."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaDriverGetVersion,"]
    #[doc = " ::cuDriverGetVersion"]
    pub fn cudaRuntimeGetVersion(runtimeVersion: *mut ::libc::c_int) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Creates a graph"]
    #[doc = ""]
    #[doc = " Creates an empty graph, which is returned via \\p pGraph."]
    #[doc = ""]
    #[doc = " \\param pGraph - Returns newly created graph"]
    #[doc = " \\param flags   - Graph creation flags, must be 0"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphAddChildGraphNode,"]
    #[doc = " ::cudaGraphAddEmptyNode,"]
    #[doc = " ::cudaGraphAddKernelNode,"]
    #[doc = " ::cudaGraphAddHostNode,"]
    #[doc = " ::cudaGraphAddMemcpyNode,"]
    #[doc = " ::cudaGraphAddMemsetNode,"]
    #[doc = " ::cudaGraphInstantiate,"]
    #[doc = " ::cudaGraphDestroy,"]
    #[doc = " ::cudaGraphGetNodes,"]
    #[doc = " ::cudaGraphGetRootNodes,"]
    #[doc = " ::cudaGraphGetEdges,"]
    #[doc = " ::cudaGraphClone"]
    pub fn cudaGraphCreate(pGraph: *mut cudaGraph_t, flags: ::libc::c_uint) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Creates a kernel execution node and adds it to a graph"]
    #[doc = ""]
    #[doc = " Creates a new kernel execution node and adds it to \\p graph with \\p numDependencies"]
    #[doc = " dependencies specified via \\p pDependencies and arguments specified in \\p pNodeParams."]
    #[doc = " It is possible for \\p numDependencies to be 0, in which case the node will be placed"]
    #[doc = " at the root of the graph. \\p pDependencies may not have any duplicate entries."]
    #[doc = " A handle to the new node will be returned in \\p pGraphNode."]
    #[doc = ""]
    #[doc = " The cudaKernelNodeParams structure is defined as:"]
    #[doc = ""]
    #[doc = " \\code"]
    #[doc = "  struct cudaKernelNodeParams"]
    #[doc = "  {"]
    #[doc = "      void* func;"]
    #[doc = "      dim3 gridDim;"]
    #[doc = "      dim3 blockDim;"]
    #[doc = "      unsigned int sharedMemBytes;"]
    #[doc = "      void **kernelParams;"]
    #[doc = "      void **extra;"]
    #[doc = "  };"]
    #[doc = " \\endcode"]
    #[doc = ""]
    #[doc = " When the graph is launched, the node will invoke kernel \\p func on a (\\p gridDim.x x"]
    #[doc = " \\p gridDim.y x \\p gridDim.z) grid of blocks. Each block contains"]
    #[doc = " (\\p blockDim.x x \\p blockDim.y x \\p blockDim.z) threads."]
    #[doc = ""]
    #[doc = " \\p sharedMem sets the amount of dynamic shared memory that will be"]
    #[doc = " available to each thread block."]
    #[doc = ""]
    #[doc = " Kernel parameters to \\p func can be specified in one of two ways:"]
    #[doc = ""]
    #[doc = " 1) Kernel parameters can be specified via \\p kernelParams. If the kernel has N"]
    #[doc = " parameters, then \\p kernelParams needs to be an array of N pointers. Each pointer,"]
    #[doc = " from \\p kernelParams[0] to \\p kernelParams[N-1], points to the region of memory from which the actual"]
    #[doc = " parameter will be copied. The number of kernel parameters and their offsets and sizes do not need"]
    #[doc = " to be specified as that information is retrieved directly from the kernel's image."]
    #[doc = ""]
    #[doc = " 2) Kernel parameters can also be packaged by the application into a single buffer that is passed in"]
    #[doc = " via \\p extra. This places the burden on the application of knowing each kernel"]
    #[doc = " parameter's size and alignment/padding within the buffer. The \\p extra parameter exists"]
    #[doc = " to allow this function to take additional less commonly used arguments. \\p extra specifies"]
    #[doc = " a list of names of extra settings and their corresponding values. Each extra setting name is"]
    #[doc = " immediately followed by the corresponding value. The list must be terminated with either NULL or"]
    #[doc = " CU_LAUNCH_PARAM_END."]
    #[doc = ""]
    #[doc = " - ::CU_LAUNCH_PARAM_END, which indicates the end of the \\p extra"]
    #[doc = "   array;"]
    #[doc = " - ::CU_LAUNCH_PARAM_BUFFER_POINTER, which specifies that the next"]
    #[doc = "   value in \\p extra will be a pointer to a buffer"]
    #[doc = "   containing all the kernel parameters for launching kernel"]
    #[doc = "   \\p func;"]
    #[doc = " - ::CU_LAUNCH_PARAM_BUFFER_SIZE, which specifies that the next"]
    #[doc = "   value in \\p extra will be a pointer to a size_t"]
    #[doc = "   containing the size of the buffer specified with"]
    #[doc = "   ::CU_LAUNCH_PARAM_BUFFER_POINTER;"]
    #[doc = ""]
    #[doc = " The error ::cudaErrorInvalidValue will be returned if kernel parameters are specified with both"]
    #[doc = " \\p kernelParams and \\p extra (i.e. both \\p kernelParams and"]
    #[doc = " \\p extra are non-NULL)."]
    #[doc = ""]
    #[doc = " The \\p kernelParams or \\p extra array, as well as the argument values it points to,"]
    #[doc = " are copied during this call."]
    #[doc = ""]
    #[doc = " \\note Kernels launched using graphs must not use texture and surface references. Reading or"]
    #[doc = "       writing through any texture or surface reference is undefined behavior."]
    #[doc = "       This restriction does not apply to texture and surface objects."]
    #[doc = ""]
    #[doc = " \\param pGraphNode     - Returns newly created node"]
    #[doc = " \\param graph          - Graph to which to add the node"]
    #[doc = " \\param pDependencies    - Dependencies of the node"]
    #[doc = " \\param numDependencies - Number of dependencies"]
    #[doc = " \\param pNodeParams      - Parameters for the GPU execution node"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaLaunchKernel,"]
    #[doc = " ::cudaGraphKernelNodeGetParams,"]
    #[doc = " ::cudaGraphKernelNodeSetParams,"]
    #[doc = " ::cudaGraphCreate,"]
    #[doc = " ::cudaGraphDestroyNode,"]
    #[doc = " ::cudaGraphAddChildGraphNode,"]
    #[doc = " ::cudaGraphAddEmptyNode,"]
    #[doc = " ::cudaGraphAddHostNode,"]
    #[doc = " ::cudaGraphAddMemcpyNode,"]
    #[doc = " ::cudaGraphAddMemsetNode"]
    pub fn cudaGraphAddKernelNode(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        pNodeParams: *const cudaKernelNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a kernel node's parameters"]
    #[doc = ""]
    #[doc = " Returns the parameters of kernel node \\p node in \\p pNodeParams."]
    #[doc = " The \\p kernelParams or \\p extra array returned in \\p pNodeParams,"]
    #[doc = " as well as the argument values it points to, are owned by the node."]
    #[doc = " This memory remains valid until the node is destroyed or its"]
    #[doc = " parameters are modified, and should not be modified"]
    #[doc = " directly. Use ::cudaGraphKernelNodeSetParams to update the"]
    #[doc = " parameters of this node."]
    #[doc = ""]
    #[doc = " The params will contain either \\p kernelParams or \\p extra,"]
    #[doc = " according to which of these was most recently set on the node."]
    #[doc = ""]
    #[doc = " \\param node        - Node to get the parameters for"]
    #[doc = " \\param pNodeParams - Pointer to return the parameters"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidDeviceFunction"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaLaunchKernel,"]
    #[doc = " ::cudaGraphAddKernelNode,"]
    #[doc = " ::cudaGraphKernelNodeSetParams"]
    pub fn cudaGraphKernelNodeGetParams(
        node: cudaGraphNode_t,
        pNodeParams: *mut cudaKernelNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets a kernel node's parameters"]
    #[doc = ""]
    #[doc = " Sets the parameters of kernel node \\p node to \\p pNodeParams."]
    #[doc = ""]
    #[doc = " \\param node        - Node to set the parameters for"]
    #[doc = " \\param pNodeParams - Parameters to copy"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaLaunchKernel,"]
    #[doc = " ::cudaGraphAddKernelNode,"]
    #[doc = " ::cudaGraphKernelNodeGetParams"]
    pub fn cudaGraphKernelNodeSetParams(
        node: cudaGraphNode_t,
        pNodeParams: *const cudaKernelNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Copies attributes from source node to destination node."]
    #[doc = ""]
    #[doc = " Copies attributes from source node \\p src to destination node \\p dst."]
    #[doc = " Both node must have the same context."]
    #[doc = ""]
    #[doc = " \\param[out] dst Destination node"]
    #[doc = " \\param[in] src Source node"]
    #[doc = " For list of attributes see ::cudaKernelNodeAttrID"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidContext"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaAccessPolicyWindow"]
    pub fn cudaGraphKernelNodeCopyAttributes(
        hSrc: cudaGraphNode_t,
        hDst: cudaGraphNode_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Queries node attribute."]
    #[doc = ""]
    #[doc = " Queries attribute \\p attr from node \\p hNode and stores it in corresponding"]
    #[doc = " member of \\p value_out."]
    #[doc = ""]
    #[doc = " \\param[in] hNode"]
    #[doc = " \\param[in] attr"]
    #[doc = " \\param[out] value_out"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaAccessPolicyWindow"]
    pub fn cudaGraphKernelNodeGetAttribute(
        hNode: cudaGraphNode_t,
        attr: cudaKernelNodeAttrID,
        value_out: *mut cudaKernelNodeAttrValue,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets node attribute."]
    #[doc = ""]
    #[doc = " Sets attribute \\p attr on node \\p hNode from corresponding attribute of"]
    #[doc = " \\p value."]
    #[doc = ""]
    #[doc = " \\param[out] hNode"]
    #[doc = " \\param[in] attr"]
    #[doc = " \\param[out] value"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidResourceHandle"]
    #[doc = " \\notefnerr"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaAccessPolicyWindow"]
    pub fn cudaGraphKernelNodeSetAttribute(
        hNode: cudaGraphNode_t,
        attr: cudaKernelNodeAttrID,
        value: *const cudaKernelNodeAttrValue,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Creates a memcpy node and adds it to a graph"]
    #[doc = ""]
    #[doc = " Creates a new memcpy node and adds it to \\p graph with \\p numDependencies"]
    #[doc = " dependencies specified via \\p pDependencies."]
    #[doc = " It is possible for \\p numDependencies to be 0, in which case the node will be placed"]
    #[doc = " at the root of the graph. \\p pDependencies may not have any duplicate entries."]
    #[doc = " A handle to the new node will be returned in \\p pGraphNode."]
    #[doc = ""]
    #[doc = " When the graph is launched, the node will perform the memcpy described by \\p pCopyParams."]
    #[doc = " See ::cudaMemcpy3D() for a description of the structure and its restrictions."]
    #[doc = ""]
    #[doc = " Memcpy nodes have some additional restrictions with regards to managed memory, if the"]
    #[doc = " system contains at least one device which has a zero value for the device attribute"]
    #[doc = " ::cudaDevAttrConcurrentManagedAccess."]
    #[doc = ""]
    #[doc = " \\param pGraphNode     - Returns newly created node"]
    #[doc = " \\param graph          - Graph to which to add the node"]
    #[doc = " \\param pDependencies    - Dependencies of the node"]
    #[doc = " \\param numDependencies - Number of dependencies"]
    #[doc = " \\param pCopyParams      - Parameters for the memory copy"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaMemcpy3D,"]
    #[doc = " ::cudaGraphAddMemcpyNodeToSymbol,"]
    #[doc = " ::cudaGraphAddMemcpyNodeFromSymbol,"]
    #[doc = " ::cudaGraphAddMemcpyNode1D,"]
    #[doc = " ::cudaGraphMemcpyNodeGetParams,"]
    #[doc = " ::cudaGraphMemcpyNodeSetParams,"]
    #[doc = " ::cudaGraphCreate,"]
    #[doc = " ::cudaGraphDestroyNode,"]
    #[doc = " ::cudaGraphAddChildGraphNode,"]
    #[doc = " ::cudaGraphAddEmptyNode,"]
    #[doc = " ::cudaGraphAddKernelNode,"]
    #[doc = " ::cudaGraphAddHostNode,"]
    #[doc = " ::cudaGraphAddMemsetNode"]
    pub fn cudaGraphAddMemcpyNode(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        pCopyParams: *const cudaMemcpy3DParms,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphAddMemcpyNodeToSymbol(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        symbol: *const ::libc::c_void,
        src: *const ::libc::c_void,
        count: usize,
        offset: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphAddMemcpyNodeFromSymbol(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        dst: *mut ::libc::c_void,
        symbol: *const ::libc::c_void,
        count: usize,
        offset: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphAddMemcpyNode1D(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        dst: *mut ::libc::c_void,
        src: *const ::libc::c_void,
        count: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a memcpy node's parameters"]
    #[doc = ""]
    #[doc = " Returns the parameters of memcpy node \\p node in \\p pNodeParams."]
    #[doc = ""]
    #[doc = " \\param node        - Node to get the parameters for"]
    #[doc = " \\param pNodeParams - Pointer to return the parameters"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaMemcpy3D,"]
    #[doc = " ::cudaGraphAddMemcpyNode,"]
    #[doc = " ::cudaGraphMemcpyNodeSetParams"]
    pub fn cudaGraphMemcpyNodeGetParams(
        node: cudaGraphNode_t,
        pNodeParams: *mut cudaMemcpy3DParms,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets a memcpy node's parameters"]
    #[doc = ""]
    #[doc = " Sets the parameters of memcpy node \\p node to \\p pNodeParams."]
    #[doc = ""]
    #[doc = " \\param node        - Node to set the parameters for"]
    #[doc = " \\param pNodeParams - Parameters to copy"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaMemcpy3D,"]
    #[doc = " ::cudaGraphMemcpyNodeSetParamsToSymbol,"]
    #[doc = " ::cudaGraphMemcpyNodeSetParamsFromSymbol,"]
    #[doc = " ::cudaGraphMemcpyNodeSetParams1D,"]
    #[doc = " ::cudaGraphAddMemcpyNode,"]
    #[doc = " ::cudaGraphMemcpyNodeGetParams"]
    pub fn cudaGraphMemcpyNodeSetParams(
        node: cudaGraphNode_t,
        pNodeParams: *const cudaMemcpy3DParms,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphMemcpyNodeSetParamsToSymbol(
        node: cudaGraphNode_t,
        symbol: *const ::libc::c_void,
        src: *const ::libc::c_void,
        count: usize,
        offset: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphMemcpyNodeSetParamsFromSymbol(
        node: cudaGraphNode_t,
        dst: *mut ::libc::c_void,
        symbol: *const ::libc::c_void,
        count: usize,
        offset: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphMemcpyNodeSetParams1D(
        node: cudaGraphNode_t,
        dst: *mut ::libc::c_void,
        src: *const ::libc::c_void,
        count: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Creates a memset node and adds it to a graph"]
    #[doc = ""]
    #[doc = " Creates a new memset node and adds it to \\p graph with \\p numDependencies"]
    #[doc = " dependencies specified via \\p pDependencies."]
    #[doc = " It is possible for \\p numDependencies to be 0, in which case the node will be placed"]
    #[doc = " at the root of the graph. \\p pDependencies may not have any duplicate entries."]
    #[doc = " A handle to the new node will be returned in \\p pGraphNode."]
    #[doc = ""]
    #[doc = " The element size must be 1, 2, or 4 bytes."]
    #[doc = " When the graph is launched, the node will perform the memset described by \\p pMemsetParams."]
    #[doc = ""]
    #[doc = " \\param pGraphNode     - Returns newly created node"]
    #[doc = " \\param graph          - Graph to which to add the node"]
    #[doc = " \\param pDependencies    - Dependencies of the node"]
    #[doc = " \\param numDependencies - Number of dependencies"]
    #[doc = " \\param pMemsetParams    - Parameters for the memory set"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorInvalidDevice"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaMemset2D,"]
    #[doc = " ::cudaGraphMemsetNodeGetParams,"]
    #[doc = " ::cudaGraphMemsetNodeSetParams,"]
    #[doc = " ::cudaGraphCreate,"]
    #[doc = " ::cudaGraphDestroyNode,"]
    #[doc = " ::cudaGraphAddChildGraphNode,"]
    #[doc = " ::cudaGraphAddEmptyNode,"]
    #[doc = " ::cudaGraphAddKernelNode,"]
    #[doc = " ::cudaGraphAddHostNode,"]
    #[doc = " ::cudaGraphAddMemcpyNode"]
    pub fn cudaGraphAddMemsetNode(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        pMemsetParams: *const cudaMemsetParams,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a memset node's parameters"]
    #[doc = ""]
    #[doc = " Returns the parameters of memset node \\p node in \\p pNodeParams."]
    #[doc = ""]
    #[doc = " \\param node        - Node to get the parameters for"]
    #[doc = " \\param pNodeParams - Pointer to return the parameters"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaMemset2D,"]
    #[doc = " ::cudaGraphAddMemsetNode,"]
    #[doc = " ::cudaGraphMemsetNodeSetParams"]
    pub fn cudaGraphMemsetNodeGetParams(
        node: cudaGraphNode_t,
        pNodeParams: *mut cudaMemsetParams,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets a memset node's parameters"]
    #[doc = ""]
    #[doc = " Sets the parameters of memset node \\p node to \\p pNodeParams."]
    #[doc = ""]
    #[doc = " \\param node        - Node to set the parameters for"]
    #[doc = " \\param pNodeParams - Parameters to copy"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaMemset2D,"]
    #[doc = " ::cudaGraphAddMemsetNode,"]
    #[doc = " ::cudaGraphMemsetNodeGetParams"]
    pub fn cudaGraphMemsetNodeSetParams(
        node: cudaGraphNode_t,
        pNodeParams: *const cudaMemsetParams,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Creates a host execution node and adds it to a graph"]
    #[doc = ""]
    #[doc = " Creates a new CPU execution node and adds it to \\p graph with \\p numDependencies"]
    #[doc = " dependencies specified via \\p pDependencies and arguments specified in \\p pNodeParams."]
    #[doc = " It is possible for \\p numDependencies to be 0, in which case the node will be placed"]
    #[doc = " at the root of the graph. \\p pDependencies may not have any duplicate entries."]
    #[doc = " A handle to the new node will be returned in \\p pGraphNode."]
    #[doc = ""]
    #[doc = " When the graph is launched, the node will invoke the specified CPU function."]
    #[doc = " Host nodes are not supported under MPS with pre-Volta GPUs."]
    #[doc = ""]
    #[doc = " \\param pGraphNode     - Returns newly created node"]
    #[doc = " \\param graph          - Graph to which to add the node"]
    #[doc = " \\param pDependencies    - Dependencies of the node"]
    #[doc = " \\param numDependencies - Number of dependencies"]
    #[doc = " \\param pNodeParams      - Parameters for the host node"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorNotSupported,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaLaunchHostFunc,"]
    #[doc = " ::cudaGraphHostNodeGetParams,"]
    #[doc = " ::cudaGraphHostNodeSetParams,"]
    #[doc = " ::cudaGraphCreate,"]
    #[doc = " ::cudaGraphDestroyNode,"]
    #[doc = " ::cudaGraphAddChildGraphNode,"]
    #[doc = " ::cudaGraphAddEmptyNode,"]
    #[doc = " ::cudaGraphAddKernelNode,"]
    #[doc = " ::cudaGraphAddMemcpyNode,"]
    #[doc = " ::cudaGraphAddMemsetNode"]
    pub fn cudaGraphAddHostNode(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        pNodeParams: *const cudaHostNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a host node's parameters"]
    #[doc = ""]
    #[doc = " Returns the parameters of host node \\p node in \\p pNodeParams."]
    #[doc = ""]
    #[doc = " \\param node        - Node to get the parameters for"]
    #[doc = " \\param pNodeParams - Pointer to return the parameters"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaLaunchHostFunc,"]
    #[doc = " ::cudaGraphAddHostNode,"]
    #[doc = " ::cudaGraphHostNodeSetParams"]
    pub fn cudaGraphHostNodeGetParams(
        node: cudaGraphNode_t,
        pNodeParams: *mut cudaHostNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets a host node's parameters"]
    #[doc = ""]
    #[doc = " Sets the parameters of host node \\p node to \\p nodeParams."]
    #[doc = ""]
    #[doc = " \\param node        - Node to set the parameters for"]
    #[doc = " \\param pNodeParams - Parameters to copy"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaLaunchHostFunc,"]
    #[doc = " ::cudaGraphAddHostNode,"]
    #[doc = " ::cudaGraphHostNodeGetParams"]
    pub fn cudaGraphHostNodeSetParams(
        node: cudaGraphNode_t,
        pNodeParams: *const cudaHostNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Creates a child graph node and adds it to a graph"]
    #[doc = ""]
    #[doc = " Creates a new node which executes an embedded graph, and adds it to \\p graph with"]
    #[doc = " \\p numDependencies dependencies specified via \\p pDependencies."]
    #[doc = " It is possible for \\p numDependencies to be 0, in which case the node will be placed"]
    #[doc = " at the root of the graph. \\p pDependencies may not have any duplicate entries."]
    #[doc = " A handle to the new node will be returned in \\p pGraphNode."]
    #[doc = ""]
    #[doc = " If \\p hGraph contains allocation or free nodes, this call will return an error."]
    #[doc = ""]
    #[doc = " The node executes an embedded child graph. The child graph is cloned in this call."]
    #[doc = ""]
    #[doc = " \\param pGraphNode     - Returns newly created node"]
    #[doc = " \\param graph          - Graph to which to add the node"]
    #[doc = " \\param pDependencies    - Dependencies of the node"]
    #[doc = " \\param numDependencies - Number of dependencies"]
    #[doc = " \\param childGraph      - The graph to clone into this node"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphChildGraphNodeGetGraph,"]
    #[doc = " ::cudaGraphCreate,"]
    #[doc = " ::cudaGraphDestroyNode,"]
    #[doc = " ::cudaGraphAddEmptyNode,"]
    #[doc = " ::cudaGraphAddKernelNode,"]
    #[doc = " ::cudaGraphAddHostNode,"]
    #[doc = " ::cudaGraphAddMemcpyNode,"]
    #[doc = " ::cudaGraphAddMemsetNode,"]
    #[doc = " ::cudaGraphClone"]
    pub fn cudaGraphAddChildGraphNode(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        childGraph: cudaGraph_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Gets a handle to the embedded graph of a child graph node"]
    #[doc = ""]
    #[doc = " Gets a handle to the embedded graph in a child graph node. This call"]
    #[doc = " does not clone the graph. Changes to the graph will be reflected in"]
    #[doc = " the node, and the node retains ownership of the graph."]
    #[doc = ""]
    #[doc = " Allocation and free nodes cannot be added to the returned graph."]
    #[doc = " Attempting to do so will return an error."]
    #[doc = ""]
    #[doc = " \\param node   - Node to get the embedded graph for"]
    #[doc = " \\param pGraph - Location to store a handle to the graph"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphAddChildGraphNode,"]
    #[doc = " ::cudaGraphNodeFindInClone"]
    pub fn cudaGraphChildGraphNodeGetGraph(
        node: cudaGraphNode_t,
        pGraph: *mut cudaGraph_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Creates an empty node and adds it to a graph"]
    #[doc = ""]
    #[doc = " Creates a new node which performs no operation, and adds it to \\p graph with"]
    #[doc = " \\p numDependencies dependencies specified via \\p pDependencies."]
    #[doc = " It is possible for \\p numDependencies to be 0, in which case the node will be placed"]
    #[doc = " at the root of the graph. \\p pDependencies may not have any duplicate entries."]
    #[doc = " A handle to the new node will be returned in \\p pGraphNode."]
    #[doc = ""]
    #[doc = " An empty node performs no operation during execution, but can be used for"]
    #[doc = " transitive ordering. For example, a phased execution graph with 2 groups of n"]
    #[doc = " nodes with a barrier between them can be represented using an empty node and"]
    #[doc = " 2*n dependency edges, rather than no empty node and n^2 dependency edges."]
    #[doc = ""]
    #[doc = " \\param pGraphNode     - Returns newly created node"]
    #[doc = " \\param graph          - Graph to which to add the node"]
    #[doc = " \\param pDependencies    - Dependencies of the node"]
    #[doc = " \\param numDependencies - Number of dependencies"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphCreate,"]
    #[doc = " ::cudaGraphDestroyNode,"]
    #[doc = " ::cudaGraphAddChildGraphNode,"]
    #[doc = " ::cudaGraphAddKernelNode,"]
    #[doc = " ::cudaGraphAddHostNode,"]
    #[doc = " ::cudaGraphAddMemcpyNode,"]
    #[doc = " ::cudaGraphAddMemsetNode"]
    pub fn cudaGraphAddEmptyNode(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphAddEventRecordNode(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        event: cudaEvent_t,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphEventRecordNodeGetEvent(
        node: cudaGraphNode_t,
        event_out: *mut cudaEvent_t,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphEventRecordNodeSetEvent(
        node: cudaGraphNode_t,
        event: cudaEvent_t,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphAddEventWaitNode(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        event: cudaEvent_t,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphEventWaitNodeGetEvent(
        node: cudaGraphNode_t,
        event_out: *mut cudaEvent_t,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphEventWaitNodeSetEvent(node: cudaGraphNode_t, event: cudaEvent_t)
        -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphAddExternalSemaphoresSignalNode(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        nodeParams: *const cudaExternalSemaphoreSignalNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphExternalSemaphoresSignalNodeGetParams(
        hNode: cudaGraphNode_t,
        params_out: *mut cudaExternalSemaphoreSignalNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphExternalSemaphoresSignalNodeSetParams(
        hNode: cudaGraphNode_t,
        nodeParams: *const cudaExternalSemaphoreSignalNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphAddExternalSemaphoresWaitNode(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        nodeParams: *const cudaExternalSemaphoreWaitNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphExternalSemaphoresWaitNodeGetParams(
        hNode: cudaGraphNode_t,
        params_out: *mut cudaExternalSemaphoreWaitNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphExternalSemaphoresWaitNodeSetParams(
        hNode: cudaGraphNode_t,
        nodeParams: *const cudaExternalSemaphoreWaitNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphAddMemAllocNode(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        nodeParams: *mut cudaMemAllocNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphMemAllocNodeGetParams(
        node: cudaGraphNode_t,
        params_out: *mut cudaMemAllocNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphAddMemFreeNode(
        pGraphNode: *mut cudaGraphNode_t,
        graph: cudaGraph_t,
        pDependencies: *const cudaGraphNode_t,
        numDependencies: usize,
        dptr: *mut ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphMemFreeNodeGetParams(
        node: cudaGraphNode_t,
        dptr_out: *mut ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaDeviceGraphMemTrim(device: ::libc::c_int) -> cudaError_t;
}
extern "C" {
    pub fn cudaDeviceGetGraphMemAttribute(
        device: ::libc::c_int,
        attr: cudaGraphMemAttributeType,
        value: *mut ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaDeviceSetGraphMemAttribute(
        device: ::libc::c_int,
        attr: cudaGraphMemAttributeType,
        value: *mut ::libc::c_void,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Clones a graph"]
    #[doc = ""]
    #[doc = " This function creates a copy of \\p originalGraph and returns it in \\p pGraphClone."]
    #[doc = " All parameters are copied into the cloned graph. The original graph may be modified"]
    #[doc = " after this call without affecting the clone."]
    #[doc = ""]
    #[doc = " Child graph nodes in the original graph are recursively copied into the clone."]
    #[doc = ""]
    #[doc = " \\param pGraphClone  - Returns newly created cloned graph"]
    #[doc = " \\param originalGraph - Graph to clone"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorMemoryAllocation"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphCreate,"]
    #[doc = " ::cudaGraphNodeFindInClone"]
    pub fn cudaGraphClone(pGraphClone: *mut cudaGraph_t, originalGraph: cudaGraph_t)
        -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Finds a cloned version of a node"]
    #[doc = ""]
    #[doc = " This function returns the node in \\p clonedGraph corresponding to \\p originalNode"]
    #[doc = " in the original graph."]
    #[doc = ""]
    #[doc = " \\p clonedGraph must have been cloned from \\p originalGraph via ::cudaGraphClone."]
    #[doc = " \\p originalNode must have been in \\p originalGraph at the time of the call to"]
    #[doc = " ::cudaGraphClone, and the corresponding cloned node in \\p clonedGraph must not have"]
    #[doc = " been removed. The cloned node is then returned via \\p pClonedNode."]
    #[doc = ""]
    #[doc = " \\param pNode  - Returns handle to the cloned node"]
    #[doc = " \\param originalNode - Handle to the original node"]
    #[doc = " \\param clonedGraph - Cloned graph to query"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphClone"]
    pub fn cudaGraphNodeFindInClone(
        pNode: *mut cudaGraphNode_t,
        originalNode: cudaGraphNode_t,
        clonedGraph: cudaGraph_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a node's type"]
    #[doc = ""]
    #[doc = " Returns the node type of \\p node in \\p pType."]
    #[doc = ""]
    #[doc = " \\param node - Node to query"]
    #[doc = " \\param pType  - Pointer to return the node type"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphGetNodes,"]
    #[doc = " ::cudaGraphGetRootNodes,"]
    #[doc = " ::cudaGraphChildGraphNodeGetGraph,"]
    #[doc = " ::cudaGraphKernelNodeGetParams,"]
    #[doc = " ::cudaGraphKernelNodeSetParams,"]
    #[doc = " ::cudaGraphHostNodeGetParams,"]
    #[doc = " ::cudaGraphHostNodeSetParams,"]
    #[doc = " ::cudaGraphMemcpyNodeGetParams,"]
    #[doc = " ::cudaGraphMemcpyNodeSetParams,"]
    #[doc = " ::cudaGraphMemsetNodeGetParams,"]
    #[doc = " ::cudaGraphMemsetNodeSetParams"]
    pub fn cudaGraphNodeGetType(
        node: cudaGraphNode_t,
        pType: *mut cudaGraphNodeType,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a graph's nodes"]
    #[doc = ""]
    #[doc = " Returns a list of \\p graph's nodes. \\p nodes may be NULL, in which case this"]
    #[doc = " function will return the number of nodes in \\p numNodes. Otherwise,"]
    #[doc = " \\p numNodes entries will be filled in. If \\p numNodes is higher than the actual"]
    #[doc = " number of nodes, the remaining entries in \\p nodes will be set to NULL, and the"]
    #[doc = " number of nodes actually obtained will be returned in \\p numNodes."]
    #[doc = ""]
    #[doc = " \\param graph    - Graph to query"]
    #[doc = " \\param nodes    - Pointer to return the nodes"]
    #[doc = " \\param numNodes - See description"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphCreate,"]
    #[doc = " ::cudaGraphGetRootNodes,"]
    #[doc = " ::cudaGraphGetEdges,"]
    #[doc = " ::cudaGraphNodeGetType,"]
    #[doc = " ::cudaGraphNodeGetDependencies,"]
    #[doc = " ::cudaGraphNodeGetDependentNodes"]
    pub fn cudaGraphGetNodes(
        graph: cudaGraph_t,
        nodes: *mut cudaGraphNode_t,
        numNodes: *mut usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a graph's root nodes"]
    #[doc = ""]
    #[doc = " Returns a list of \\p graph's root nodes. \\p pRootNodes may be NULL, in which case this"]
    #[doc = " function will return the number of root nodes in \\p pNumRootNodes. Otherwise,"]
    #[doc = " \\p pNumRootNodes entries will be filled in. If \\p pNumRootNodes is higher than the actual"]
    #[doc = " number of root nodes, the remaining entries in \\p pRootNodes will be set to NULL, and the"]
    #[doc = " number of nodes actually obtained will be returned in \\p pNumRootNodes."]
    #[doc = ""]
    #[doc = " \\param graph       - Graph to query"]
    #[doc = " \\param pRootNodes    - Pointer to return the root nodes"]
    #[doc = " \\param pNumRootNodes - See description"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphCreate,"]
    #[doc = " ::cudaGraphGetNodes,"]
    #[doc = " ::cudaGraphGetEdges,"]
    #[doc = " ::cudaGraphNodeGetType,"]
    #[doc = " ::cudaGraphNodeGetDependencies,"]
    #[doc = " ::cudaGraphNodeGetDependentNodes"]
    pub fn cudaGraphGetRootNodes(
        graph: cudaGraph_t,
        pRootNodes: *mut cudaGraphNode_t,
        pNumRootNodes: *mut usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a graph's dependency edges"]
    #[doc = ""]
    #[doc = " Returns a list of \\p graph's dependency edges. Edges are returned via corresponding"]
    #[doc = " indices in \\p from and \\p to; that is, the node in \\p to[i] has a dependency on the"]
    #[doc = " node in \\p from[i]. \\p from and \\p to may both be NULL, in which"]
    #[doc = " case this function only returns the number of edges in \\p numEdges. Otherwise,"]
    #[doc = " \\p numEdges entries will be filled in. If \\p numEdges is higher than the actual"]
    #[doc = " number of edges, the remaining entries in \\p from and \\p to will be set to NULL, and"]
    #[doc = " the number of edges actually returned will be written to \\p numEdges."]
    #[doc = ""]
    #[doc = " \\param graph    - Graph to get the edges from"]
    #[doc = " \\param from     - Location to return edge endpoints"]
    #[doc = " \\param to       - Location to return edge endpoints"]
    #[doc = " \\param numEdges - See description"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphGetNodes,"]
    #[doc = " ::cudaGraphGetRootNodes,"]
    #[doc = " ::cudaGraphAddDependencies,"]
    #[doc = " ::cudaGraphRemoveDependencies,"]
    #[doc = " ::cudaGraphNodeGetDependencies,"]
    #[doc = " ::cudaGraphNodeGetDependentNodes"]
    pub fn cudaGraphGetEdges(
        graph: cudaGraph_t,
        from: *mut cudaGraphNode_t,
        to: *mut cudaGraphNode_t,
        numEdges: *mut usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a node's dependencies"]
    #[doc = ""]
    #[doc = " Returns a list of \\p node's dependencies. \\p pDependencies may be NULL, in which case this"]
    #[doc = " function will return the number of dependencies in \\p pNumDependencies. Otherwise,"]
    #[doc = " \\p pNumDependencies entries will be filled in. If \\p pNumDependencies is higher than the actual"]
    #[doc = " number of dependencies, the remaining entries in \\p pDependencies will be set to NULL, and the"]
    #[doc = " number of nodes actually obtained will be returned in \\p pNumDependencies."]
    #[doc = ""]
    #[doc = " \\param node           - Node to query"]
    #[doc = " \\param pDependencies    - Pointer to return the dependencies"]
    #[doc = " \\param pNumDependencies - See description"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphNodeGetDependentNodes,"]
    #[doc = " ::cudaGraphGetNodes,"]
    #[doc = " ::cudaGraphGetRootNodes,"]
    #[doc = " ::cudaGraphGetEdges,"]
    #[doc = " ::cudaGraphAddDependencies,"]
    #[doc = " ::cudaGraphRemoveDependencies"]
    pub fn cudaGraphNodeGetDependencies(
        node: cudaGraphNode_t,
        pDependencies: *mut cudaGraphNode_t,
        pNumDependencies: *mut usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns a node's dependent nodes"]
    #[doc = ""]
    #[doc = " Returns a list of \\p node's dependent nodes. \\p pDependentNodes may be NULL, in which"]
    #[doc = " case this function will return the number of dependent nodes in \\p pNumDependentNodes."]
    #[doc = " Otherwise, \\p pNumDependentNodes entries will be filled in. If \\p pNumDependentNodes is"]
    #[doc = " higher than the actual number of dependent nodes, the remaining entries in"]
    #[doc = " \\p pDependentNodes will be set to NULL, and the number of nodes actually obtained will"]
    #[doc = " be returned in \\p pNumDependentNodes."]
    #[doc = ""]
    #[doc = " \\param node             - Node to query"]
    #[doc = " \\param pDependentNodes    - Pointer to return the dependent nodes"]
    #[doc = " \\param pNumDependentNodes - See description"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphNodeGetDependencies,"]
    #[doc = " ::cudaGraphGetNodes,"]
    #[doc = " ::cudaGraphGetRootNodes,"]
    #[doc = " ::cudaGraphGetEdges,"]
    #[doc = " ::cudaGraphAddDependencies,"]
    #[doc = " ::cudaGraphRemoveDependencies"]
    pub fn cudaGraphNodeGetDependentNodes(
        node: cudaGraphNode_t,
        pDependentNodes: *mut cudaGraphNode_t,
        pNumDependentNodes: *mut usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Adds dependency edges to a graph."]
    #[doc = ""]
    #[doc = " The number of dependencies to be added is defined by \\p numDependencies"]
    #[doc = " Elements in \\p pFrom and \\p pTo at corresponding indices define a dependency."]
    #[doc = " Each node in \\p pFrom and \\p pTo must belong to \\p graph."]
    #[doc = ""]
    #[doc = " If \\p numDependencies is 0, elements in \\p pFrom and \\p pTo will be ignored."]
    #[doc = " Specifying an existing dependency will return an error."]
    #[doc = ""]
    #[doc = " \\param graph - Graph to which dependencies are added"]
    #[doc = " \\param from - Array of nodes that provide the dependencies"]
    #[doc = " \\param to - Array of dependent nodes"]
    #[doc = " \\param numDependencies - Number of dependencies to be added"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphRemoveDependencies,"]
    #[doc = " ::cudaGraphGetEdges,"]
    #[doc = " ::cudaGraphNodeGetDependencies,"]
    #[doc = " ::cudaGraphNodeGetDependentNodes"]
    pub fn cudaGraphAddDependencies(
        graph: cudaGraph_t,
        from: *const cudaGraphNode_t,
        to: *const cudaGraphNode_t,
        numDependencies: usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Removes dependency edges from a graph."]
    #[doc = ""]
    #[doc = " The number of \\p pDependencies to be removed is defined by \\p numDependencies."]
    #[doc = " Elements in \\p pFrom and \\p pTo at corresponding indices define a dependency."]
    #[doc = " Each node in \\p pFrom and \\p pTo must belong to \\p graph."]
    #[doc = ""]
    #[doc = " If \\p numDependencies is 0, elements in \\p pFrom and \\p pTo will be ignored."]
    #[doc = " Specifying a non-existing dependency will return an error."]
    #[doc = ""]
    #[doc = " \\param graph - Graph from which to remove dependencies"]
    #[doc = " \\param from - Array of nodes that provide the dependencies"]
    #[doc = " \\param to - Array of dependent nodes"]
    #[doc = " \\param numDependencies - Number of dependencies to be removed"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphAddDependencies,"]
    #[doc = " ::cudaGraphGetEdges,"]
    #[doc = " ::cudaGraphNodeGetDependencies,"]
    #[doc = " ::cudaGraphNodeGetDependentNodes"]
    pub fn cudaGraphRemoveDependencies(
        graph: cudaGraph_t,
        from: *const cudaGraphNode_t,
        to: *const cudaGraphNode_t,
        numDependencies: usize,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Remove a node from the graph"]
    #[doc = ""]
    #[doc = " Removes \\p node from its graph. This operation also severs any dependencies of other nodes"]
    #[doc = " on \\p node and vice versa."]
    #[doc = ""]
    #[doc = " Dependencies cannot be removed from graphs which contain allocation or free nodes."]
    #[doc = " Any attempt to do so will return an error."]
    #[doc = ""]
    #[doc = " \\param node  - Node to remove"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_destroy_ub"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphAddChildGraphNode,"]
    #[doc = " ::cudaGraphAddEmptyNode,"]
    #[doc = " ::cudaGraphAddKernelNode,"]
    #[doc = " ::cudaGraphAddHostNode,"]
    #[doc = " ::cudaGraphAddMemcpyNode,"]
    #[doc = " ::cudaGraphAddMemsetNode"]
    pub fn cudaGraphDestroyNode(node: cudaGraphNode_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Creates an executable graph from a graph"]
    #[doc = ""]
    #[doc = " Instantiates \\p graph as an executable graph. The graph is validated for any"]
    #[doc = " structural constraints or intra-node constraints which were not previously"]
    #[doc = " validated. If instantiation is successful, a handle to the instantiated graph"]
    #[doc = " is returned in \\p pGraphExec."]
    #[doc = ""]
    #[doc = " If there are any errors, diagnostic information may be returned in \\p pErrorNode and"]
    #[doc = " \\p pLogBuffer. This is the primary way to inspect instantiation errors. The output"]
    #[doc = " will be null terminated unless the diagnostics overflow"]
    #[doc = " the buffer. In this case, they will be truncated, and the last byte can be"]
    #[doc = " inspected to determine if truncation occurred."]
    #[doc = ""]
    #[doc = " \\param pGraphExec - Returns instantiated graph"]
    #[doc = " \\param graph      - Graph to instantiate"]
    #[doc = " \\param pErrorNode - In case of an instantiation error, this may be modified to"]
    #[doc = "                      indicate a node contributing to the error"]
    #[doc = " \\param pLogBuffer   - A character buffer to store diagnostic messages"]
    #[doc = " \\param bufferSize  - Size of the log buffer in bytes"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphInstantiateWithFlags,"]
    #[doc = " ::cudaGraphCreate,"]
    #[doc = " ::cudaGraphUpload,"]
    #[doc = " ::cudaGraphLaunch,"]
    #[doc = " ::cudaGraphExecDestroy"]
    pub fn cudaGraphInstantiate(
        pGraphExec: *mut cudaGraphExec_t,
        graph: cudaGraph_t,
        pErrorNode: *mut cudaGraphNode_t,
        pLogBuffer: *mut ::libc::c_char,
        bufferSize: usize,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphInstantiateWithFlags(
        pGraphExec: *mut cudaGraphExec_t,
        graph: cudaGraph_t,
        flags: ::libc::c_ulonglong,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets the parameters for a kernel node in the given graphExec"]
    #[doc = ""]
    #[doc = " Sets the parameters of a kernel node in an executable graph \\p hGraphExec."]
    #[doc = " The node is identified by the corresponding node \\p node in the"]
    #[doc = " non-executable graph, from which the executable graph was instantiated."]
    #[doc = ""]
    #[doc = " \\p node must not have been removed from the original graph. The \\p func field"]
    #[doc = " of \\p nodeParams cannot be modified and must match the original value."]
    #[doc = " All other values can be modified."]
    #[doc = ""]
    #[doc = " The modifications only affect future launches of \\p hGraphExec. Already"]
    #[doc = " enqueued or running launches of \\p hGraphExec are not affected by this call."]
    #[doc = " \\p node is also not modified by this call."]
    #[doc = ""]
    #[doc = " \\param hGraphExec  - The executable graph in which to set the specified node"]
    #[doc = " \\param node        - kernel node from the graph from which graphExec was instantiated"]
    #[doc = " \\param pNodeParams - Updated Parameters to set"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphAddKernelNode,"]
    #[doc = " ::cudaGraphKernelNodeSetParams,"]
    #[doc = " ::cudaGraphExecMemcpyNodeSetParams,"]
    #[doc = " ::cudaGraphExecMemsetNodeSetParams,"]
    #[doc = " ::cudaGraphExecHostNodeSetParams,"]
    #[doc = " ::cudaGraphExecChildGraphNodeSetParams,"]
    #[doc = " ::cudaGraphExecEventRecordNodeSetEvent,"]
    #[doc = " ::cudaGraphExecEventWaitNodeSetEvent,"]
    #[doc = " ::cudaGraphExecExternalSemaphoresSignalNodeSetParams,"]
    #[doc = " ::cudaGraphExecExternalSemaphoresWaitNodeSetParams,"]
    #[doc = " ::cudaGraphExecUpdate,"]
    #[doc = " ::cudaGraphInstantiate"]
    pub fn cudaGraphExecKernelNodeSetParams(
        hGraphExec: cudaGraphExec_t,
        node: cudaGraphNode_t,
        pNodeParams: *const cudaKernelNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets the parameters for a memcpy node in the given graphExec."]
    #[doc = ""]
    #[doc = " Updates the work represented by \\p node in \\p hGraphExec as though \\p node had"]
    #[doc = " contained \\p pNodeParams at instantiation.  \\p node must remain in the graph which was"]
    #[doc = " used to instantiate \\p hGraphExec.  Changed edges to and from \\p node are ignored."]
    #[doc = ""]
    #[doc = " The source and destination memory in \\p pNodeParams must be allocated from the same"]
    #[doc = " contexts as the original source and destination memory.  Both the instantiation-time"]
    #[doc = " memory operands and the memory operands in \\p pNodeParams must be 1-dimensional."]
    #[doc = " Zero-length operations are not supported."]
    #[doc = ""]
    #[doc = " The modifications only affect future launches of \\p hGraphExec.  Already enqueued"]
    #[doc = " or running launches of \\p hGraphExec are not affected by this call.  \\p node is also"]
    #[doc = " not modified by this call."]
    #[doc = ""]
    #[doc = " Returns ::cudaErrorInvalidValue if the memory operands' mappings changed or"]
    #[doc = " either the original or new memory operands are multidimensional."]
    #[doc = ""]
    #[doc = " \\param hGraphExec  - The executable graph in which to set the specified node"]
    #[doc = " \\param node        - Memcpy node from the graph which was used to instantiate graphExec"]
    #[doc = " \\param pNodeParams - Updated Parameters to set"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphAddMemcpyNode,"]
    #[doc = " ::cudaGraphMemcpyNodeSetParams,"]
    #[doc = " ::cudaGraphExecMemcpyNodeSetParamsToSymbol,"]
    #[doc = " ::cudaGraphExecMemcpyNodeSetParamsFromSymbol,"]
    #[doc = " ::cudaGraphExecMemcpyNodeSetParams1D,"]
    #[doc = " ::cudaGraphExecKernelNodeSetParams,"]
    #[doc = " ::cudaGraphExecMemsetNodeSetParams,"]
    #[doc = " ::cudaGraphExecHostNodeSetParams,"]
    #[doc = " ::cudaGraphExecChildGraphNodeSetParams,"]
    #[doc = " ::cudaGraphExecEventRecordNodeSetEvent,"]
    #[doc = " ::cudaGraphExecEventWaitNodeSetEvent,"]
    #[doc = " ::cudaGraphExecExternalSemaphoresSignalNodeSetParams,"]
    #[doc = " ::cudaGraphExecExternalSemaphoresWaitNodeSetParams,"]
    #[doc = " ::cudaGraphExecUpdate,"]
    #[doc = " ::cudaGraphInstantiate"]
    pub fn cudaGraphExecMemcpyNodeSetParams(
        hGraphExec: cudaGraphExec_t,
        node: cudaGraphNode_t,
        pNodeParams: *const cudaMemcpy3DParms,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphExecMemcpyNodeSetParamsToSymbol(
        hGraphExec: cudaGraphExec_t,
        node: cudaGraphNode_t,
        symbol: *const ::libc::c_void,
        src: *const ::libc::c_void,
        count: usize,
        offset: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphExecMemcpyNodeSetParamsFromSymbol(
        hGraphExec: cudaGraphExec_t,
        node: cudaGraphNode_t,
        dst: *mut ::libc::c_void,
        symbol: *const ::libc::c_void,
        count: usize,
        offset: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphExecMemcpyNodeSetParams1D(
        hGraphExec: cudaGraphExec_t,
        node: cudaGraphNode_t,
        dst: *mut ::libc::c_void,
        src: *const ::libc::c_void,
        count: usize,
        kind: cudaMemcpyKind,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets the parameters for a memset node in the given graphExec."]
    #[doc = ""]
    #[doc = " Updates the work represented by \\p node in \\p hGraphExec as though \\p node had"]
    #[doc = " contained \\p pNodeParams at instantiation.  \\p node must remain in the graph which was"]
    #[doc = " used to instantiate \\p hGraphExec.  Changed edges to and from \\p node are ignored."]
    #[doc = ""]
    #[doc = " The destination memory in \\p pNodeParams must be allocated from the same"]
    #[doc = " context as the original destination memory.  Both the instantiation-time"]
    #[doc = " memory operand and the memory operand in \\p pNodeParams must be 1-dimensional."]
    #[doc = " Zero-length operations are not supported."]
    #[doc = ""]
    #[doc = " The modifications only affect future launches of \\p hGraphExec.  Already enqueued"]
    #[doc = " or running launches of \\p hGraphExec are not affected by this call.  \\p node is also"]
    #[doc = " not modified by this call."]
    #[doc = ""]
    #[doc = " Returns cudaErrorInvalidValue if the memory operand's mappings changed or"]
    #[doc = " either the original or new memory operand are multidimensional."]
    #[doc = ""]
    #[doc = " \\param hGraphExec  - The executable graph in which to set the specified node"]
    #[doc = " \\param node        - Memset node from the graph which was used to instantiate graphExec"]
    #[doc = " \\param pNodeParams - Updated Parameters to set"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphAddMemsetNode,"]
    #[doc = " ::cudaGraphMemsetNodeSetParams,"]
    #[doc = " ::cudaGraphExecKernelNodeSetParams,"]
    #[doc = " ::cudaGraphExecMemcpyNodeSetParams,"]
    #[doc = " ::cudaGraphExecHostNodeSetParams,"]
    #[doc = " ::cudaGraphExecChildGraphNodeSetParams,"]
    #[doc = " ::cudaGraphExecEventRecordNodeSetEvent,"]
    #[doc = " ::cudaGraphExecEventWaitNodeSetEvent,"]
    #[doc = " ::cudaGraphExecExternalSemaphoresSignalNodeSetParams,"]
    #[doc = " ::cudaGraphExecExternalSemaphoresWaitNodeSetParams,"]
    #[doc = " ::cudaGraphExecUpdate,"]
    #[doc = " ::cudaGraphInstantiate"]
    pub fn cudaGraphExecMemsetNodeSetParams(
        hGraphExec: cudaGraphExec_t,
        node: cudaGraphNode_t,
        pNodeParams: *const cudaMemsetParams,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Sets the parameters for a host node in the given graphExec."]
    #[doc = ""]
    #[doc = " Updates the work represented by \\p node in \\p hGraphExec as though \\p node had"]
    #[doc = " contained \\p pNodeParams at instantiation.  \\p node must remain in the graph which was"]
    #[doc = " used to instantiate \\p hGraphExec.  Changed edges to and from \\p node are ignored."]
    #[doc = ""]
    #[doc = " The modifications only affect future launches of \\p hGraphExec.  Already enqueued"]
    #[doc = " or running launches of \\p hGraphExec are not affected by this call.  \\p node is also"]
    #[doc = " not modified by this call."]
    #[doc = ""]
    #[doc = " \\param hGraphExec  - The executable graph in which to set the specified node"]
    #[doc = " \\param node        - Host node from the graph which was used to instantiate graphExec"]
    #[doc = " \\param pNodeParams - Updated Parameters to set"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphAddHostNode,"]
    #[doc = " ::cudaGraphHostNodeSetParams,"]
    #[doc = " ::cudaGraphExecKernelNodeSetParams,"]
    #[doc = " ::cudaGraphExecMemcpyNodeSetParams,"]
    #[doc = " ::cudaGraphExecMemsetNodeSetParams,"]
    #[doc = " ::cudaGraphExecChildGraphNodeSetParams,"]
    #[doc = " ::cudaGraphExecEventRecordNodeSetEvent,"]
    #[doc = " ::cudaGraphExecEventWaitNodeSetEvent,"]
    #[doc = " ::cudaGraphExecExternalSemaphoresSignalNodeSetParams,"]
    #[doc = " ::cudaGraphExecExternalSemaphoresWaitNodeSetParams,"]
    #[doc = " ::cudaGraphExecUpdate,"]
    #[doc = " ::cudaGraphInstantiate"]
    pub fn cudaGraphExecHostNodeSetParams(
        hGraphExec: cudaGraphExec_t,
        node: cudaGraphNode_t,
        pNodeParams: *const cudaHostNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphExecChildGraphNodeSetParams(
        hGraphExec: cudaGraphExec_t,
        node: cudaGraphNode_t,
        childGraph: cudaGraph_t,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphExecEventRecordNodeSetEvent(
        hGraphExec: cudaGraphExec_t,
        hNode: cudaGraphNode_t,
        event: cudaEvent_t,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphExecEventWaitNodeSetEvent(
        hGraphExec: cudaGraphExec_t,
        hNode: cudaGraphNode_t,
        event: cudaEvent_t,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphExecExternalSemaphoresSignalNodeSetParams(
        hGraphExec: cudaGraphExec_t,
        hNode: cudaGraphNode_t,
        nodeParams: *const cudaExternalSemaphoreSignalNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphExecExternalSemaphoresWaitNodeSetParams(
        hGraphExec: cudaGraphExec_t,
        hNode: cudaGraphNode_t,
        nodeParams: *const cudaExternalSemaphoreWaitNodeParams,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Check whether an executable graph can be updated with a graph and perform the update if possible"]
    #[doc = ""]
    #[doc = " Updates the node parameters in the instantiated graph specified by \\p hGraphExec with the"]
    #[doc = " node parameters in a topologically identical graph specified by \\p hGraph."]
    #[doc = ""]
    #[doc = " Limitations:"]
    #[doc = ""]
    #[doc = " - Kernel nodes:"]
    #[doc = "   - The owning context of the function cannot change."]
    #[doc = "   - A node whose function originally did not use CUDA dynamic parallelism cannot be updated"]
    #[doc = "     to a function which uses CDP"]
    #[doc = " - Memset and memcpy nodes:"]
    #[doc = "   - The CUDA device(s) to which the operand(s) was allocated/mapped cannot change."]
    #[doc = "   - The source/destination memory must be allocated from the same contexts as the original"]
    #[doc = "     source/destination memory."]
    #[doc = "   - Only 1D memsets can be changed."]
    #[doc = " - Additional memcpy node restrictions:"]
    #[doc = "   - Changing either the source or destination memory type(i.e. CU_MEMORYTYPE_DEVICE,"]
    #[doc = "     CU_MEMORYTYPE_ARRAY, etc.) is not supported."]
    #[doc = ""]
    #[doc = " Note:  The API may add further restrictions in future releases.  The return code should always be checked."]
    #[doc = ""]
    #[doc = " cudaGraphExecUpdate sets \\p updateResult_out to cudaGraphExecUpdateErrorTopologyChanged under"]
    #[doc = " the following conditions:"]
    #[doc = ""]
    #[doc = " - The count of nodes directly in \\p hGraphExec and \\p hGraph differ, in which case \\p hErrorNode_out"]
    #[doc = "   is NULL."]
    #[doc = " - A node is deleted in \\p hGraph but not not its pair from \\p hGraphExec, in which case \\p hErrorNode_out"]
    #[doc = "   is NULL."]
    #[doc = " - A node is deleted in \\p hGraphExec but not its pair from \\p hGraph, in which case \\p hErrorNode_out is"]
    #[doc = "   the pairless node from \\p hGraph."]
    #[doc = " - The dependent nodes of a pair differ, in which case \\p hErrorNode_out is the node from \\p hGraph."]
    #[doc = ""]
    #[doc = " cudaGraphExecUpdate sets \\p updateResult_out to:"]
    #[doc = " - cudaGraphExecUpdateError if passed an invalid value."]
    #[doc = " - cudaGraphExecUpdateErrorTopologyChanged if the graph topology changed"]
    #[doc = " - cudaGraphExecUpdateErrorNodeTypeChanged if the type of a node changed, in which case"]
    #[doc = "   \\p hErrorNode_out is set to the node from \\p hGraph."]
    #[doc = " - cudaGraphExecUpdateErrorFunctionChanged if the function of a kernel node changed (CUDA driver < 11.2)"]
    #[doc = " - cudaGraphExecUpdateErrorUnsupportedFunctionChange if the func field of a kernel changed in an"]
    #[doc = "   unsupported way(see note above), in which case \\p hErrorNode_out is set to the node from \\p hGraph"]
    #[doc = " - cudaGraphExecUpdateErrorParametersChanged if any parameters to a node changed in a way"]
    #[doc = "   that is not supported, in which case \\p hErrorNode_out is set to the node from \\p hGraph"]
    #[doc = " - cudaGraphExecUpdateErrorNotSupported if something about a node is unsupported, like"]
    #[doc = "   the node's type or configuration, in which case \\p hErrorNode_out is set to the node from \\p hGraph"]
    #[doc = ""]
    #[doc = " If \\p updateResult_out isn't set in one of the situations described above, the update check passes"]
    #[doc = " and cudaGraphExecUpdate updates \\p hGraphExec to match the contents of \\p hGraph.  If an error happens"]
    #[doc = " during the update, \\p updateResult_out will be set to cudaGraphExecUpdateError; otherwise,"]
    #[doc = " \\p updateResult_out is set to cudaGraphExecUpdateSuccess."]
    #[doc = ""]
    #[doc = " cudaGraphExecUpdate returns cudaSuccess when the updated was performed successfully.  It returns"]
    #[doc = " cudaErrorGraphExecUpdateFailure if the graph update was not performed because it included"]
    #[doc = " changes which violated constraints specific to instantiated graph update."]
    #[doc = ""]
    #[doc = " \\param hGraphExec The instantiated graph to be updated"]
    #[doc = " \\param hGraph The graph containing the updated parameters"]
    #[doc = " \\param hErrorNode_out The node which caused the permissibility check to forbid the update, if any"]
    #[doc = " \\param updateResult_out Whether the graph update was permitted.  If was forbidden, the reason why"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorGraphExecUpdateFailure,"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphInstantiate,"]
    pub fn cudaGraphExecUpdate(
        hGraphExec: cudaGraphExec_t,
        hGraph: cudaGraph_t,
        hErrorNode_out: *mut cudaGraphNode_t,
        updateResult_out: *mut cudaGraphExecUpdateResult,
    ) -> cudaError_t;
}
extern "C" {
    pub fn cudaGraphUpload(graphExec: cudaGraphExec_t, stream: cudaStream_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Launches an executable graph in a stream"]
    #[doc = ""]
    #[doc = " Executes \\p graphExec in \\p stream. Only one instance of \\p graphExec may be executing"]
    #[doc = " at a time. Each launch is ordered behind both any previous work in \\p stream"]
    #[doc = " and any previous launches of \\p graphExec. To execute a graph concurrently, it must be"]
    #[doc = " instantiated multiple times into multiple executable graphs."]
    #[doc = ""]
    #[doc = " If any allocations created by \\p graphExec remain unfreed (from a previous launch) and"]
    #[doc = " \\p graphExec was not instantiated with ::cudaGraphInstantiateFlagAutoFreeOnLaunch,"]
    #[doc = " the launch will fail with ::cudaErrorInvalidValue."]
    #[doc = ""]
    #[doc = " \\param graphExec - Executable graph to launch"]
    #[doc = " \\param stream    - Stream in which to launch the graph"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphInstantiate,"]
    #[doc = " ::cudaGraphUpload,"]
    #[doc = " ::cudaGraphExecDestroy"]
    pub fn cudaGraphLaunch(graphExec: cudaGraphExec_t, stream: cudaStream_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Destroys an executable graph"]
    #[doc = ""]
    #[doc = " Destroys the executable graph specified by \\p graphExec."]
    #[doc = ""]
    #[doc = " \\param graphExec - Executable graph to destroy"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_destroy_ub"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphInstantiate,"]
    #[doc = " ::cudaGraphUpload,"]
    #[doc = " ::cudaGraphLaunch"]
    pub fn cudaGraphExecDestroy(graphExec: cudaGraphExec_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Destroys a graph"]
    #[doc = ""]
    #[doc = " Destroys the graph specified by \\p graph, as well as all of its nodes."]
    #[doc = ""]
    #[doc = " \\param graph - Graph to destroy"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = " \\note_graph_thread_safety"]
    #[doc = " \\notefnerr"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = " \\note_destroy_ub"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaGraphCreate"]
    pub fn cudaGraphDestroy(graph: cudaGraph_t) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Write a DOT file describing graph structure"]
    #[doc = ""]
    #[doc = " Using the provided \\p graph, write to \\p path a DOT formatted description of the graph."]
    #[doc = " By default this includes the graph topology, node types, node id, kernel names and memcpy direction."]
    #[doc = " \\p flags can be specified to write more detailed information about each node type such as"]
    #[doc = " parameter values, kernel attributes, node and function handles."]
    #[doc = ""]
    #[doc = " \\param graph - The graph to create a DOT file from"]
    #[doc = " \\param path  - The path to write the DOT file to"]
    #[doc = " \\param flags - Flags from cudaGraphDebugDotFlags for specifying which additional node information to write"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorOperatingSystem"]
    pub fn cudaGraphDebugDotPrint(
        graph: cudaGraph_t,
        path: *const ::libc::c_char,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Create a user object"]
    #[doc = ""]
    #[doc = " Create a user object with the specified destructor callback and initial reference count. The"]
    #[doc = " initial references are owned by the caller."]
    #[doc = ""]
    #[doc = " Destructor callbacks cannot make CUDA API calls and should avoid blocking behavior, as they"]
    #[doc = " are executed by a shared internal thread. Another thread may be signaled to perform such"]
    #[doc = " actions, if it does not block forward progress of tasks scheduled through CUDA."]
    #[doc = ""]
    #[doc = " See CUDA User Objects in the CUDA C++ Programming Guide for more information on user objects."]
    #[doc = ""]
    #[doc = " \\param object_out      - Location to return the user object handle"]
    #[doc = " \\param ptr             - The pointer to pass to the destroy function"]
    #[doc = " \\param destroy         - Callback to free the user object when it is no longer in use"]
    #[doc = " \\param initialRefcount - The initial refcount to create the object with, typically 1. The"]
    #[doc = "                          initial references are owned by the calling thread."]
    #[doc = " \\param flags           - Currently it is required to pass ::cudaUserObjectNoDestructorSync,"]
    #[doc = "                          which is the only defined flag. This indicates that the destroy"]
    #[doc = "                          callback cannot be waited on by any CUDA API. Users requiring"]
    #[doc = "                          synchronization of the callback should signal its completion"]
    #[doc = "                          manually."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaUserObjectRetain,"]
    #[doc = " ::cudaUserObjectRelease,"]
    #[doc = " ::cudaGraphRetainUserObject,"]
    #[doc = " ::cudaGraphReleaseUserObject,"]
    #[doc = " ::cudaGraphCreate"]
    pub fn cudaUserObjectCreate(
        object_out: *mut cudaUserObject_t,
        ptr: *mut ::libc::c_void,
        destroy: cudaHostFn_t,
        initialRefcount: ::libc::c_uint,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Retain a reference to a user object"]
    #[doc = ""]
    #[doc = " Retains new references to a user object. The new references are owned by the caller."]
    #[doc = ""]
    #[doc = " See CUDA User Objects in the CUDA C++ Programming Guide for more information on user objects."]
    #[doc = ""]
    #[doc = " \\param object - The object to retain"]
    #[doc = " \\param count  - The number of references to retain, typically 1. Must be nonzero"]
    #[doc = "                 and not larger than INT_MAX."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaUserObjectCreate,"]
    #[doc = " ::cudaUserObjectRelease,"]
    #[doc = " ::cudaGraphRetainUserObject,"]
    #[doc = " ::cudaGraphReleaseUserObject,"]
    #[doc = " ::cudaGraphCreate"]
    pub fn cudaUserObjectRetain(object: cudaUserObject_t, count: ::libc::c_uint) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Release a reference to a user object"]
    #[doc = ""]
    #[doc = " Releases user object references owned by the caller. The object's destructor is invoked if"]
    #[doc = " the reference count reaches zero."]
    #[doc = ""]
    #[doc = " It is undefined behavior to release references not owned by the caller, or to use a user"]
    #[doc = " object handle after all references are released."]
    #[doc = ""]
    #[doc = " See CUDA User Objects in the CUDA C++ Programming Guide for more information on user objects."]
    #[doc = ""]
    #[doc = " \\param object - The object to release"]
    #[doc = " \\param count  - The number of references to release, typically 1. Must be nonzero"]
    #[doc = "                 and not larger than INT_MAX."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaUserObjectCreate,"]
    #[doc = " ::cudaUserObjectRetain,"]
    #[doc = " ::cudaGraphRetainUserObject,"]
    #[doc = " ::cudaGraphReleaseUserObject,"]
    #[doc = " ::cudaGraphCreate"]
    pub fn cudaUserObjectRelease(object: cudaUserObject_t, count: ::libc::c_uint) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Retain a reference to a user object from a graph"]
    #[doc = ""]
    #[doc = " Creates or moves user object references that will be owned by a CUDA graph."]
    #[doc = ""]
    #[doc = " See CUDA User Objects in the CUDA C++ Programming Guide for more information on user objects."]
    #[doc = ""]
    #[doc = " \\param graph  - The graph to associate the reference with"]
    #[doc = " \\param object - The user object to retain a reference for"]
    #[doc = " \\param count  - The number of references to add to the graph, typically 1. Must be"]
    #[doc = "                 nonzero and not larger than INT_MAX."]
    #[doc = " \\param flags  - The optional flag ::cudaGraphUserObjectMove transfers references"]
    #[doc = "                 from the calling thread, rather than create new references. Pass 0"]
    #[doc = "                 to create new references."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaUserObjectCreate"]
    #[doc = " ::cudaUserObjectRetain,"]
    #[doc = " ::cudaUserObjectRelease,"]
    #[doc = " ::cudaGraphReleaseUserObject,"]
    #[doc = " ::cudaGraphCreate"]
    pub fn cudaGraphRetainUserObject(
        graph: cudaGraph_t,
        object: cudaUserObject_t,
        count: ::libc::c_uint,
        flags: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Release a user object reference from a graph"]
    #[doc = ""]
    #[doc = " Releases user object references owned by a graph."]
    #[doc = ""]
    #[doc = " See CUDA User Objects in the CUDA C++ Programming Guide for more information on user objects."]
    #[doc = ""]
    #[doc = " \\param graph  - The graph that will release the reference"]
    #[doc = " \\param object - The user object to release a reference for"]
    #[doc = " \\param count  - The number of references to release, typically 1. Must be nonzero"]
    #[doc = "                 and not larger than INT_MAX."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cudaUserObjectCreate"]
    #[doc = " ::cudaUserObjectRetain,"]
    #[doc = " ::cudaUserObjectRelease,"]
    #[doc = " ::cudaGraphRetainUserObject,"]
    #[doc = " ::cudaGraphCreate"]
    pub fn cudaGraphReleaseUserObject(
        graph: cudaGraph_t,
        object: cudaUserObject_t,
        count: ::libc::c_uint,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Returns the requested driver API function pointer"]
    #[doc = ""]
    #[doc = " Returns in \\p **funcPtr the address of the CUDA driver function for the requested flags."]
    #[doc = ""]
    #[doc = " For a requested driver symbol, if the CUDA version in which the driver symbol was"]
    #[doc = " introduced is less than or equal to the CUDA runtime version, the API will return"]
    #[doc = " the function pointer to the corresponding versioned driver function."]
    #[doc = ""]
    #[doc = " The pointer returned by the API should be cast to a function pointer matching the"]
    #[doc = " requested driver function's definition in the API header file. The function pointer"]
    #[doc = " typedef can be picked up from the corresponding typedefs header file. For example,"]
    #[doc = " cudaTypedefs.h consists of function pointer typedefs for driver APIs defined in cuda.h."]
    #[doc = ""]
    #[doc = " The API will return ::cudaErrorSymbolNotFound if the requested driver function is not"]
    #[doc = " supported on the platform, no ABI compatible driver function exists for the CUDA runtime"]
    #[doc = " version or if the driver symbol is invalid."]
    #[doc = ""]
    #[doc = " The requested flags can be:"]
    #[doc = " - ::cudaEnableDefault: This is the default mode. This is equivalent to"]
    #[doc = "   ::cudaEnablePerThreadDefaultStream if the code is compiled with"]
    #[doc = "   --default-stream per-thread compilation flag or the macro CUDA_API_PER_THREAD_DEFAULT_STREAM"]
    #[doc = "   is defined; ::cudaEnableLegacyStream otherwise."]
    #[doc = " - ::cudaEnableLegacyStream: This will enable the search for all driver symbols"]
    #[doc = "   that match the requested driver symbol name except the corresponding per-thread versions."]
    #[doc = " - ::cudaEnablePerThreadDefaultStream: This will enable the search for all"]
    #[doc = "   driver symbols that match the requested driver symbol name including the per-thread"]
    #[doc = "   versions. If a per-thread version is not found, the API will return the legacy version"]
    #[doc = "   of the driver function."]
    #[doc = ""]
    #[doc = " \\param symbol - The base name of the driver API function to look for. As an example,"]
    #[doc = "                 for the driver API ::cuMemAlloc_v2, \\p symbol would be cuMemAlloc."]
    #[doc = "                 Note that the API will use the CUDA runtime version to return the"]
    #[doc = "                 address to the most recent ABI compatible driver symbol, ::cuMemAlloc"]
    #[doc = "                 or ::cuMemAlloc_v2."]
    #[doc = " \\param funcPtr - Location to return the function pointer to the requested driver function"]
    #[doc = " \\param flags -  Flags to specify search options."]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess,"]
    #[doc = " ::cudaErrorInvalidValue,"]
    #[doc = " ::cudaErrorNotSupported,"]
    #[doc = " ::cudaErrorSymbolNotFound"]
    #[doc = " \\note_version_mixing"]
    #[doc = " \\note_init_rt"]
    #[doc = " \\note_callback"]
    #[doc = ""]
    #[doc = " \\sa"]
    #[doc = " ::cuGetProcAddress"]
    pub fn cudaGetDriverEntryPoint(
        symbol: *const ::libc::c_char,
        funcPtr: *mut *mut ::libc::c_void,
        flags: ::libc::c_ulonglong,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\cond impl_private"]
    pub fn cudaGetExportTable(
        ppExportTable: *mut *const ::libc::c_void,
        pExportTableId: *const cudaUUID_t,
    ) -> cudaError_t;
}
extern "C" {
    #[doc = " \\brief Get pointer to device entry function that matches entry function \\p symbolPtr"]
    #[doc = ""]
    #[doc = " Returns in \\p functionPtr the device entry function corresponding to the symbol \\p symbolPtr."]
    #[doc = ""]
    #[doc = " \\param functionPtr     - Returns the device entry function"]
    #[doc = " \\param symbolPtr       - Pointer to device entry function to search for"]
    #[doc = ""]
    #[doc = " \\return"]
    #[doc = " ::cudaSuccess"]
    #[doc = ""]
    pub fn cudaGetFuncBySymbol(
        functionPtr: *mut cudaFunction_t,
        symbolPtr: *const ::libc::c_void,
    ) -> cudaError_t;
}
pub type __int32_t = ::libc::c_int;
pub type __uint32_t = ::libc::c_uint;
pub type __int64_t = ::libc::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnContext {
    _unused: [u8; 0],
}
pub type cudnnHandle_t = *mut cudnnContext;
extern "C" {
    pub fn cudnnGetVersion() -> usize;
}
extern "C" {
    pub fn cudnnGetCudartVersion() -> usize;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnStatus_t {
    CUDNN_STATUS_SUCCESS = 0,
    CUDNN_STATUS_NOT_INITIALIZED = 1,
    CUDNN_STATUS_ALLOC_FAILED = 2,
    CUDNN_STATUS_BAD_PARAM = 3,
    CUDNN_STATUS_INTERNAL_ERROR = 4,
    CUDNN_STATUS_INVALID_VALUE = 5,
    CUDNN_STATUS_ARCH_MISMATCH = 6,
    CUDNN_STATUS_MAPPING_ERROR = 7,
    CUDNN_STATUS_EXECUTION_FAILED = 8,
    CUDNN_STATUS_NOT_SUPPORTED = 9,
    CUDNN_STATUS_LICENSE_ERROR = 10,
    CUDNN_STATUS_RUNTIME_PREREQUISITE_MISSING = 11,
    CUDNN_STATUS_RUNTIME_IN_PROGRESS = 12,
    CUDNN_STATUS_RUNTIME_FP_OVERFLOW = 13,
    CUDNN_STATUS_VERSION_MISMATCH = 14,
}
extern "C" {
    pub fn cudnnGetErrorString(status: cudnnStatus_t) -> *const ::libc::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnRuntimeTag_t {
    _unused: [u8; 0],
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnErrQueryMode_t {
    CUDNN_ERRQUERY_RAWCODE = 0,
    CUDNN_ERRQUERY_NONBLOCKING = 1,
    CUDNN_ERRQUERY_BLOCKING = 2,
}
extern "C" {
    pub fn cudnnQueryRuntimeError(
        handle: cudnnHandle_t,
        rstatus: *mut cudnnStatus_t,
        mode: cudnnErrQueryMode_t,
        tag: *mut cudnnRuntimeTag_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetProperty(type_: libraryPropertyType, value: *mut ::libc::c_int)
        -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreate(handle: *mut cudnnHandle_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroy(handle: cudnnHandle_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetStream(handle: cudnnHandle_t, streamId: cudaStream_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetStream(handle: cudnnHandle_t, streamId: *mut cudaStream_t) -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnTensorStruct {
    _unused: [u8; 0],
}
pub type cudnnTensorDescriptor_t = *mut cudnnTensorStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnPoolingStruct {
    _unused: [u8; 0],
}
pub type cudnnPoolingDescriptor_t = *mut cudnnPoolingStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnFilterStruct {
    _unused: [u8; 0],
}
pub type cudnnFilterDescriptor_t = *mut cudnnFilterStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnLRNStruct {
    _unused: [u8; 0],
}
pub type cudnnLRNDescriptor_t = *mut cudnnLRNStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnActivationStruct {
    _unused: [u8; 0],
}
pub type cudnnActivationDescriptor_t = *mut cudnnActivationStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnSpatialTransformerStruct {
    _unused: [u8; 0],
}
pub type cudnnSpatialTransformerDescriptor_t = *mut cudnnSpatialTransformerStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnOpTensorStruct {
    _unused: [u8; 0],
}
pub type cudnnOpTensorDescriptor_t = *mut cudnnOpTensorStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnReduceTensorStruct {
    _unused: [u8; 0],
}
pub type cudnnReduceTensorDescriptor_t = *mut cudnnReduceTensorStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnCTCLossStruct {
    _unused: [u8; 0],
}
pub type cudnnCTCLossDescriptor_t = *mut cudnnCTCLossStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnTensorTransformStruct {
    _unused: [u8; 0],
}
pub type cudnnTensorTransformDescriptor_t = *mut cudnnTensorTransformStruct;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnDataType_t {
    CUDNN_DATA_FLOAT = 0,
    CUDNN_DATA_DOUBLE = 1,
    CUDNN_DATA_HALF = 2,
    CUDNN_DATA_INT8 = 3,
    CUDNN_DATA_INT32 = 4,
    CUDNN_DATA_INT8x4 = 5,
    CUDNN_DATA_UINT8 = 6,
    CUDNN_DATA_UINT8x4 = 7,
    CUDNN_DATA_INT8x32 = 8,
    CUDNN_DATA_BFLOAT16 = 9,
    CUDNN_DATA_INT64 = 10,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnMathType_t {
    CUDNN_DEFAULT_MATH = 0,
    CUDNN_TENSOR_OP_MATH = 1,
    CUDNN_TENSOR_OP_MATH_ALLOW_CONVERSION = 2,
    CUDNN_FMA_MATH = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnNanPropagation_t {
    CUDNN_NOT_PROPAGATE_NAN = 0,
    CUDNN_PROPAGATE_NAN = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnDeterminism_t {
    CUDNN_NON_DETERMINISTIC = 0,
    CUDNN_DETERMINISTIC = 1,
}
extern "C" {
    pub fn cudnnCreateTensorDescriptor(tensorDesc: *mut cudnnTensorDescriptor_t) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnTensorFormat_t {
    CUDNN_TENSOR_NCHW = 0,
    CUDNN_TENSOR_NHWC = 1,
    CUDNN_TENSOR_NCHW_VECT_C = 2,
}
extern "C" {
    pub fn cudnnSetTensor4dDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        format: cudnnTensorFormat_t,
        dataType: cudnnDataType_t,
        n: ::libc::c_int,
        c: ::libc::c_int,
        h: ::libc::c_int,
        w: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetTensor4dDescriptorEx(
        tensorDesc: cudnnTensorDescriptor_t,
        dataType: cudnnDataType_t,
        n: ::libc::c_int,
        c: ::libc::c_int,
        h: ::libc::c_int,
        w: ::libc::c_int,
        nStride: ::libc::c_int,
        cStride: ::libc::c_int,
        hStride: ::libc::c_int,
        wStride: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetTensor4dDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        dataType: *mut cudnnDataType_t,
        n: *mut ::libc::c_int,
        c: *mut ::libc::c_int,
        h: *mut ::libc::c_int,
        w: *mut ::libc::c_int,
        nStride: *mut ::libc::c_int,
        cStride: *mut ::libc::c_int,
        hStride: *mut ::libc::c_int,
        wStride: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetTensorNdDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        dataType: cudnnDataType_t,
        nbDims: ::libc::c_int,
        dimA: *const ::libc::c_int,
        strideA: *const ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetTensorNdDescriptorEx(
        tensorDesc: cudnnTensorDescriptor_t,
        format: cudnnTensorFormat_t,
        dataType: cudnnDataType_t,
        nbDims: ::libc::c_int,
        dimA: *const ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetTensorNdDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        nbDimsRequested: ::libc::c_int,
        dataType: *mut cudnnDataType_t,
        nbDims: *mut ::libc::c_int,
        dimA: *mut ::libc::c_int,
        strideA: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetTensorSizeInBytes(
        tensorDesc: cudnnTensorDescriptor_t,
        size: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyTensorDescriptor(tensorDesc: cudnnTensorDescriptor_t) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnFoldingDirection_t {
    CUDNN_TRANSFORM_FOLD = 0,
    CUDNN_TRANSFORM_UNFOLD = 1,
}
extern "C" {
    #[doc = " Create a destination descriptor for cudnnTransformTensor"]
    pub fn cudnnInitTransformDest(
        transformDesc: cudnnTensorTransformDescriptor_t,
        srcDesc: cudnnTensorDescriptor_t,
        destDesc: cudnnTensorDescriptor_t,
        destSizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    #[doc = " Create an empty tensor transform descriptor"]
    pub fn cudnnCreateTensorTransformDescriptor(
        transformDesc: *mut cudnnTensorTransformDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    #[doc = " Initialize a previously created tensor transform descriptor."]
    pub fn cudnnSetTensorTransformDescriptor(
        transformDesc: cudnnTensorTransformDescriptor_t,
        nbDims: u32,
        destFormat: cudnnTensorFormat_t,
        padBeforeA: *const i32,
        padAfterA: *const i32,
        foldA: *const u32,
        direction: cudnnFoldingDirection_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    #[doc = " Retrieves the values stored in a previously initialized tensor transform"]
    #[doc = " descriptor."]
    pub fn cudnnGetTensorTransformDescriptor(
        transformDesc: cudnnTensorTransformDescriptor_t,
        nbDimsRequested: u32,
        destFormat: *mut cudnnTensorFormat_t,
        padBeforeA: *mut i32,
        padAfterA: *mut i32,
        foldA: *mut u32,
        direction: *mut cudnnFoldingDirection_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    #[doc = " Destroys a previously created tensor transform descriptor."]
    pub fn cudnnDestroyTensorTransformDescriptor(
        transformDesc: cudnnTensorTransformDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnTransformTensor(
        handle: cudnnHandle_t,
        alpha: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnTransformTensorEx(
        handle: cudnnHandle_t,
        transDesc: cudnnTensorTransformDescriptor_t,
        alpha: *const ::libc::c_void,
        srcDesc: cudnnTensorDescriptor_t,
        srcData: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        destDesc: cudnnTensorDescriptor_t,
        destData: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnAddTensor(
        handle: cudnnHandle_t,
        alpha: *const ::libc::c_void,
        aDesc: cudnnTensorDescriptor_t,
        A: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        cDesc: cudnnTensorDescriptor_t,
        C: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnOpTensorOp_t {
    CUDNN_OP_TENSOR_ADD = 0,
    CUDNN_OP_TENSOR_MUL = 1,
    CUDNN_OP_TENSOR_MIN = 2,
    CUDNN_OP_TENSOR_MAX = 3,
    CUDNN_OP_TENSOR_SQRT = 4,
    CUDNN_OP_TENSOR_NOT = 5,
}
extern "C" {
    pub fn cudnnCreateOpTensorDescriptor(
        opTensorDesc: *mut cudnnOpTensorDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetOpTensorDescriptor(
        opTensorDesc: cudnnOpTensorDescriptor_t,
        opTensorOp: cudnnOpTensorOp_t,
        opTensorCompType: cudnnDataType_t,
        opTensorNanOpt: cudnnNanPropagation_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetOpTensorDescriptor(
        opTensorDesc: cudnnOpTensorDescriptor_t,
        opTensorOp: *mut cudnnOpTensorOp_t,
        opTensorCompType: *mut cudnnDataType_t,
        opTensorNanOpt: *mut cudnnNanPropagation_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyOpTensorDescriptor(opTensorDesc: cudnnOpTensorDescriptor_t)
        -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnOpTensor(
        handle: cudnnHandle_t,
        opTensorDesc: cudnnOpTensorDescriptor_t,
        alpha1: *const ::libc::c_void,
        aDesc: cudnnTensorDescriptor_t,
        A: *const ::libc::c_void,
        alpha2: *const ::libc::c_void,
        bDesc: cudnnTensorDescriptor_t,
        B: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        cDesc: cudnnTensorDescriptor_t,
        C: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnReduceTensorOp_t {
    CUDNN_REDUCE_TENSOR_ADD = 0,
    CUDNN_REDUCE_TENSOR_MUL = 1,
    CUDNN_REDUCE_TENSOR_MIN = 2,
    CUDNN_REDUCE_TENSOR_MAX = 3,
    CUDNN_REDUCE_TENSOR_AMAX = 4,
    CUDNN_REDUCE_TENSOR_AVG = 5,
    CUDNN_REDUCE_TENSOR_NORM1 = 6,
    CUDNN_REDUCE_TENSOR_NORM2 = 7,
    CUDNN_REDUCE_TENSOR_MUL_NO_ZEROS = 8,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnReduceTensorIndices_t {
    CUDNN_REDUCE_TENSOR_NO_INDICES = 0,
    CUDNN_REDUCE_TENSOR_FLATTENED_INDICES = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnIndicesType_t {
    CUDNN_32BIT_INDICES = 0,
    CUDNN_64BIT_INDICES = 1,
    CUDNN_16BIT_INDICES = 2,
    CUDNN_8BIT_INDICES = 3,
}
extern "C" {
    pub fn cudnnCreateReduceTensorDescriptor(
        reduceTensorDesc: *mut cudnnReduceTensorDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetReduceTensorDescriptor(
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        reduceTensorOp: cudnnReduceTensorOp_t,
        reduceTensorCompType: cudnnDataType_t,
        reduceTensorNanOpt: cudnnNanPropagation_t,
        reduceTensorIndices: cudnnReduceTensorIndices_t,
        reduceTensorIndicesType: cudnnIndicesType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetReduceTensorDescriptor(
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        reduceTensorOp: *mut cudnnReduceTensorOp_t,
        reduceTensorCompType: *mut cudnnDataType_t,
        reduceTensorNanOpt: *mut cudnnNanPropagation_t,
        reduceTensorIndices: *mut cudnnReduceTensorIndices_t,
        reduceTensorIndicesType: *mut cudnnIndicesType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyReduceTensorDescriptor(
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetReductionIndicesSize(
        handle: cudnnHandle_t,
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        aDesc: cudnnTensorDescriptor_t,
        cDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetReductionWorkspaceSize(
        handle: cudnnHandle_t,
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        aDesc: cudnnTensorDescriptor_t,
        cDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnReduceTensor(
        handle: cudnnHandle_t,
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        indices: *mut ::libc::c_void,
        indicesSizeInBytes: usize,
        workspace: *mut ::libc::c_void,
        workspaceSizeInBytes: usize,
        alpha: *const ::libc::c_void,
        aDesc: cudnnTensorDescriptor_t,
        A: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        cDesc: cudnnTensorDescriptor_t,
        C: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetTensor(
        handle: cudnnHandle_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
        valuePtr: *const ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnScaleTensor(
        handle: cudnnHandle_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
        alpha: *const ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateFilterDescriptor(filterDesc: *mut cudnnFilterDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetFilter4dDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        dataType: cudnnDataType_t,
        format: cudnnTensorFormat_t,
        k: ::libc::c_int,
        c: ::libc::c_int,
        h: ::libc::c_int,
        w: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetFilter4dDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        dataType: *mut cudnnDataType_t,
        format: *mut cudnnTensorFormat_t,
        k: *mut ::libc::c_int,
        c: *mut ::libc::c_int,
        h: *mut ::libc::c_int,
        w: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetFilterNdDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        dataType: cudnnDataType_t,
        format: cudnnTensorFormat_t,
        nbDims: ::libc::c_int,
        filterDimA: *const ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetFilterNdDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        nbDimsRequested: ::libc::c_int,
        dataType: *mut cudnnDataType_t,
        format: *mut cudnnTensorFormat_t,
        nbDims: *mut ::libc::c_int,
        filterDimA: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetFilterSizeInBytes(
        filterDesc: cudnnFilterDescriptor_t,
        size: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnTransformFilter(
        handle: cudnnHandle_t,
        transDesc: cudnnTensorTransformDescriptor_t,
        alpha: *const ::libc::c_void,
        srcDesc: cudnnFilterDescriptor_t,
        srcData: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        destDesc: cudnnFilterDescriptor_t,
        destData: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyFilterDescriptor(filterDesc: cudnnFilterDescriptor_t) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnSoftmaxAlgorithm_t {
    CUDNN_SOFTMAX_FAST = 0,
    CUDNN_SOFTMAX_ACCURATE = 1,
    CUDNN_SOFTMAX_LOG = 2,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnSoftmaxMode_t {
    CUDNN_SOFTMAX_MODE_INSTANCE = 0,
    CUDNN_SOFTMAX_MODE_CHANNEL = 1,
}
extern "C" {
    pub fn cudnnSoftmaxForward(
        handle: cudnnHandle_t,
        algo: cudnnSoftmaxAlgorithm_t,
        mode: cudnnSoftmaxMode_t,
        alpha: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnPoolingMode_t {
    CUDNN_POOLING_MAX = 0,
    CUDNN_POOLING_AVERAGE_COUNT_INCLUDE_PADDING = 1,
    CUDNN_POOLING_AVERAGE_COUNT_EXCLUDE_PADDING = 2,
    CUDNN_POOLING_MAX_DETERMINISTIC = 3,
}
extern "C" {
    pub fn cudnnCreatePoolingDescriptor(
        poolingDesc: *mut cudnnPoolingDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetPooling2dDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        mode: cudnnPoolingMode_t,
        maxpoolingNanOpt: cudnnNanPropagation_t,
        windowHeight: ::libc::c_int,
        windowWidth: ::libc::c_int,
        verticalPadding: ::libc::c_int,
        horizontalPadding: ::libc::c_int,
        verticalStride: ::libc::c_int,
        horizontalStride: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetPooling2dDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        mode: *mut cudnnPoolingMode_t,
        maxpoolingNanOpt: *mut cudnnNanPropagation_t,
        windowHeight: *mut ::libc::c_int,
        windowWidth: *mut ::libc::c_int,
        verticalPadding: *mut ::libc::c_int,
        horizontalPadding: *mut ::libc::c_int,
        verticalStride: *mut ::libc::c_int,
        horizontalStride: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetPoolingNdDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        mode: cudnnPoolingMode_t,
        maxpoolingNanOpt: cudnnNanPropagation_t,
        nbDims: ::libc::c_int,
        windowDimA: *const ::libc::c_int,
        paddingA: *const ::libc::c_int,
        strideA: *const ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetPoolingNdDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        nbDimsRequested: ::libc::c_int,
        mode: *mut cudnnPoolingMode_t,
        maxpoolingNanOpt: *mut cudnnNanPropagation_t,
        nbDims: *mut ::libc::c_int,
        windowDimA: *mut ::libc::c_int,
        paddingA: *mut ::libc::c_int,
        strideA: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetPoolingNdForwardOutputDim(
        poolingDesc: cudnnPoolingDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        nbDims: ::libc::c_int,
        outputTensorDimA: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetPooling2dForwardOutputDim(
        poolingDesc: cudnnPoolingDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        n: *mut ::libc::c_int,
        c: *mut ::libc::c_int,
        h: *mut ::libc::c_int,
        w: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyPoolingDescriptor(poolingDesc: cudnnPoolingDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnPoolingForward(
        handle: cudnnHandle_t,
        poolingDesc: cudnnPoolingDescriptor_t,
        alpha: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnActivationMode_t {
    CUDNN_ACTIVATION_SIGMOID = 0,
    CUDNN_ACTIVATION_RELU = 1,
    CUDNN_ACTIVATION_TANH = 2,
    CUDNN_ACTIVATION_CLIPPED_RELU = 3,
    CUDNN_ACTIVATION_ELU = 4,
    CUDNN_ACTIVATION_IDENTITY = 5,
    CUDNN_ACTIVATION_SWISH = 6,
}
extern "C" {
    pub fn cudnnCreateActivationDescriptor(
        activationDesc: *mut cudnnActivationDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetActivationDescriptor(
        activationDesc: cudnnActivationDescriptor_t,
        mode: cudnnActivationMode_t,
        reluNanOpt: cudnnNanPropagation_t,
        coef: f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetActivationDescriptor(
        activationDesc: cudnnActivationDescriptor_t,
        mode: *mut cudnnActivationMode_t,
        reluNanOpt: *mut cudnnNanPropagation_t,
        coef: *mut f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetActivationDescriptorSwishBeta(
        activationDesc: cudnnActivationDescriptor_t,
        swish_beta: f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetActivationDescriptorSwishBeta(
        activationDesc: cudnnActivationDescriptor_t,
        swish_beta: *mut f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyActivationDescriptor(
        activationDesc: cudnnActivationDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnActivationForward(
        handle: cudnnHandle_t,
        activationDesc: cudnnActivationDescriptor_t,
        alpha: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateLRNDescriptor(normDesc: *mut cudnnLRNDescriptor_t) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnLRNMode_t {
    CUDNN_LRN_CROSS_CHANNEL_DIM1 = 0,
}
extern "C" {
    pub fn cudnnSetLRNDescriptor(
        normDesc: cudnnLRNDescriptor_t,
        lrnN: ::libc::c_uint,
        lrnAlpha: f64,
        lrnBeta: f64,
        lrnK: f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetLRNDescriptor(
        normDesc: cudnnLRNDescriptor_t,
        lrnN: *mut ::libc::c_uint,
        lrnAlpha: *mut f64,
        lrnBeta: *mut f64,
        lrnK: *mut f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyLRNDescriptor(lrnDesc: cudnnLRNDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnLRNCrossChannelForward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        lrnMode: cudnnLRNMode_t,
        alpha: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnDivNormMode_t {
    CUDNN_DIVNORM_PRECOMPUTED_MEANS = 0,
}
extern "C" {
    pub fn cudnnDivisiveNormalizationForward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        mode: cudnnDivNormMode_t,
        alpha: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        means: *const ::libc::c_void,
        temp: *mut ::libc::c_void,
        temp2: *mut ::libc::c_void,
        beta: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnBatchNormMode_t {
    CUDNN_BATCHNORM_PER_ACTIVATION = 0,
    CUDNN_BATCHNORM_SPATIAL = 1,
    CUDNN_BATCHNORM_SPATIAL_PERSISTENT = 2,
}
extern "C" {
    pub fn cudnnDeriveBNTensorDescriptor(
        derivedBnDesc: cudnnTensorDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        mode: cudnnBatchNormMode_t,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnBatchNormOps_t {
    CUDNN_BATCHNORM_OPS_BN = 0,
    CUDNN_BATCHNORM_OPS_BN_ACTIVATION = 1,
    CUDNN_BATCHNORM_OPS_BN_ADD_ACTIVATION = 2,
}
extern "C" {
    pub fn cudnnBatchNormalizationForwardInference(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        alpha: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::libc::c_void,
        bnBias: *const ::libc::c_void,
        estimatedMean: *const ::libc::c_void,
        estimatedVariance: *const ::libc::c_void,
        epsilon: f64,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnNormMode_t {
    CUDNN_NORM_PER_ACTIVATION = 0,
    CUDNN_NORM_PER_CHANNEL = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnNormAlgo_t {
    CUDNN_NORM_ALGO_STANDARD = 0,
    CUDNN_NORM_ALGO_PERSIST = 1,
}
extern "C" {
    pub fn cudnnDeriveNormTensorDescriptor(
        derivedNormScaleBiasDesc: cudnnTensorDescriptor_t,
        derivedNormMeanVarDesc: cudnnTensorDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        mode: cudnnNormMode_t,
        groupCnt: ::libc::c_int,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnNormOps_t {
    CUDNN_NORM_OPS_NORM = 0,
    CUDNN_NORM_OPS_NORM_ACTIVATION = 1,
    CUDNN_NORM_OPS_NORM_ADD_ACTIVATION = 2,
}
extern "C" {
    pub fn cudnnNormalizationForwardInference(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        alpha: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        normScaleBiasDesc: cudnnTensorDescriptor_t,
        normScale: *const ::libc::c_void,
        normBias: *const ::libc::c_void,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        estimatedMean: *const ::libc::c_void,
        estimatedVariance: *const ::libc::c_void,
        zDesc: cudnnTensorDescriptor_t,
        z: *const ::libc::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
        epsilon: f64,
        groupCnt: ::libc::c_int,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnSamplerType_t {
    CUDNN_SAMPLER_BILINEAR = 0,
}
extern "C" {
    pub fn cudnnCreateSpatialTransformerDescriptor(
        stDesc: *mut cudnnSpatialTransformerDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetSpatialTransformerNdDescriptor(
        stDesc: cudnnSpatialTransformerDescriptor_t,
        samplerType: cudnnSamplerType_t,
        dataType: cudnnDataType_t,
        nbDims: ::libc::c_int,
        dimA: *const ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroySpatialTransformerDescriptor(
        stDesc: cudnnSpatialTransformerDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSpatialTfGridGeneratorForward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        theta: *const ::libc::c_void,
        grid: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSpatialTfSamplerForward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        alpha: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        grid: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnDropoutStruct {
    _unused: [u8; 0],
}
pub type cudnnDropoutDescriptor_t = *mut cudnnDropoutStruct;
extern "C" {
    pub fn cudnnCreateDropoutDescriptor(
        dropoutDesc: *mut cudnnDropoutDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyDropoutDescriptor(dropoutDesc: cudnnDropoutDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDropoutGetStatesSize(
        handle: cudnnHandle_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDropoutGetReserveSpaceSize(
        xdesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
        handle: cudnnHandle_t,
        dropout: f32,
        states: *mut ::libc::c_void,
        stateSizeInBytes: usize,
        seed: ::libc::c_ulonglong,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRestoreDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
        handle: cudnnHandle_t,
        dropout: f32,
        states: *mut ::libc::c_void,
        stateSizeInBytes: usize,
        seed: ::libc::c_ulonglong,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
        handle: cudnnHandle_t,
        dropout: *mut f32,
        states: *mut *mut ::libc::c_void,
        seed: *mut ::libc::c_ulonglong,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDropoutForward(
        handle: cudnnHandle_t,
        dropoutDesc: cudnnDropoutDescriptor_t,
        xdesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        ydesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnAlgorithmStruct {
    _unused: [u8; 0],
}
pub type cudnnAlgorithmDescriptor_t = *mut cudnnAlgorithmStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnAlgorithmPerformanceStruct {
    _unused: [u8; 0],
}
pub type cudnnAlgorithmPerformance_t = *mut cudnnAlgorithmPerformanceStruct;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnConvolutionFwdAlgo_t {
    CUDNN_CONVOLUTION_FWD_ALGO_IMPLICIT_GEMM = 0,
    CUDNN_CONVOLUTION_FWD_ALGO_IMPLICIT_PRECOMP_GEMM = 1,
    CUDNN_CONVOLUTION_FWD_ALGO_GEMM = 2,
    CUDNN_CONVOLUTION_FWD_ALGO_DIRECT = 3,
    CUDNN_CONVOLUTION_FWD_ALGO_FFT = 4,
    CUDNN_CONVOLUTION_FWD_ALGO_FFT_TILING = 5,
    CUDNN_CONVOLUTION_FWD_ALGO_WINOGRAD = 6,
    CUDNN_CONVOLUTION_FWD_ALGO_WINOGRAD_NONFUSED = 7,
    CUDNN_CONVOLUTION_FWD_ALGO_COUNT = 8,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnConvolutionBwdFilterAlgo_t {
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_0 = 0,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_1 = 1,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_FFT = 2,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_3 = 3,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_WINOGRAD = 4,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_WINOGRAD_NONFUSED = 5,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_FFT_TILING = 6,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_COUNT = 7,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnConvolutionBwdDataAlgo_t {
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_0 = 0,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_1 = 1,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_FFT = 2,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_FFT_TILING = 3,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_WINOGRAD = 4,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_WINOGRAD_NONFUSED = 5,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_COUNT = 6,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnRNNAlgo_t {
    CUDNN_RNN_ALGO_STANDARD = 0,
    CUDNN_RNN_ALGO_PERSIST_STATIC = 1,
    CUDNN_RNN_ALGO_PERSIST_DYNAMIC = 2,
    CUDNN_RNN_ALGO_PERSIST_STATIC_SMALL_H = 3,
    CUDNN_RNN_ALGO_COUNT = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnCTCLossAlgo_t {
    CUDNN_CTC_LOSS_ALGO_DETERMINISTIC = 0,
    CUDNN_CTC_LOSS_ALGO_NON_DETERMINISTIC = 1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudnnAlgorithmUnionStruct {
    pub algo: cudnnAlgorithmUnionStruct_Algorithm,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cudnnAlgorithmUnionStruct_Algorithm {
    pub convFwdAlgo: cudnnConvolutionFwdAlgo_t,
    pub convBwdFilterAlgo: cudnnConvolutionBwdFilterAlgo_t,
    pub convBwdDataAlgo: cudnnConvolutionBwdDataAlgo_t,
    pub RNNAlgo: cudnnRNNAlgo_t,
    pub CTCLossAlgo: cudnnCTCLossAlgo_t,
}
#[test]
fn bindgen_test_layout_cudnnAlgorithmUnionStruct_Algorithm() {
    assert_eq!(
        ::std::mem::size_of::<cudnnAlgorithmUnionStruct_Algorithm>(),
        4usize,
        concat!("Size of: ", stringify!(cudnnAlgorithmUnionStruct_Algorithm))
    );
    assert_eq!(
        ::std::mem::align_of::<cudnnAlgorithmUnionStruct_Algorithm>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(cudnnAlgorithmUnionStruct_Algorithm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnAlgorithmUnionStruct_Algorithm>())).convFwdAlgo as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnAlgorithmUnionStruct_Algorithm),
            "::",
            stringify!(convFwdAlgo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnAlgorithmUnionStruct_Algorithm>())).convBwdFilterAlgo
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnAlgorithmUnionStruct_Algorithm),
            "::",
            stringify!(convBwdFilterAlgo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnAlgorithmUnionStruct_Algorithm>())).convBwdDataAlgo
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnAlgorithmUnionStruct_Algorithm),
            "::",
            stringify!(convBwdDataAlgo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnAlgorithmUnionStruct_Algorithm>())).RNNAlgo as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnAlgorithmUnionStruct_Algorithm),
            "::",
            stringify!(RNNAlgo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnAlgorithmUnionStruct_Algorithm>())).CTCLossAlgo as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnAlgorithmUnionStruct_Algorithm),
            "::",
            stringify!(CTCLossAlgo)
        )
    );
}
#[test]
fn bindgen_test_layout_cudnnAlgorithmUnionStruct() {
    assert_eq!(
        ::std::mem::size_of::<cudnnAlgorithmUnionStruct>(),
        4usize,
        concat!("Size of: ", stringify!(cudnnAlgorithmUnionStruct))
    );
    assert_eq!(
        ::std::mem::align_of::<cudnnAlgorithmUnionStruct>(),
        4usize,
        concat!("Alignment of ", stringify!(cudnnAlgorithmUnionStruct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudnnAlgorithmUnionStruct>())).algo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnAlgorithmUnionStruct),
            "::",
            stringify!(algo)
        )
    );
}
pub type cudnnAlgorithm_t = cudnnAlgorithmUnionStruct;
extern "C" {
    pub fn cudnnCreateAlgorithmDescriptor(
        algoDesc: *mut cudnnAlgorithmDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetAlgorithmDescriptor(
        algoDesc: cudnnAlgorithmDescriptor_t,
        algorithm: cudnnAlgorithm_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetAlgorithmDescriptor(
        algoDesc: cudnnAlgorithmDescriptor_t,
        algorithm: *mut cudnnAlgorithm_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCopyAlgorithmDescriptor(
        src: cudnnAlgorithmDescriptor_t,
        dest: cudnnAlgorithmDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyAlgorithmDescriptor(algoDesc: cudnnAlgorithmDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateAlgorithmPerformance(
        algoPerf: *mut cudnnAlgorithmPerformance_t,
        numberToCreate: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetAlgorithmPerformance(
        algoPerf: cudnnAlgorithmPerformance_t,
        algoDesc: cudnnAlgorithmDescriptor_t,
        status: cudnnStatus_t,
        time: f32,
        memory: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetAlgorithmPerformance(
        algoPerf: cudnnAlgorithmPerformance_t,
        algoDesc: *mut cudnnAlgorithmDescriptor_t,
        status: *mut cudnnStatus_t,
        time: *mut f32,
        memory: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyAlgorithmPerformance(
        algoPerf: *mut cudnnAlgorithmPerformance_t,
        numberToDestroy: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetAlgorithmSpaceSize(
        handle: cudnnHandle_t,
        algoDesc: cudnnAlgorithmDescriptor_t,
        algoSpaceSizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSaveAlgorithm(
        handle: cudnnHandle_t,
        algoDesc: cudnnAlgorithmDescriptor_t,
        algoSpace: *mut ::libc::c_void,
        algoSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRestoreAlgorithm(
        handle: cudnnHandle_t,
        algoSpace: *mut ::libc::c_void,
        algoSpaceSizeInBytes: usize,
        algoDesc: cudnnAlgorithmDescriptor_t,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnSeverity_t {
    CUDNN_SEV_FATAL = 0,
    CUDNN_SEV_ERROR = 1,
    CUDNN_SEV_WARNING = 2,
    CUDNN_SEV_INFO = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnDebugStruct {
    pub cudnn_version: ::libc::c_uint,
    pub cudnnStatus: cudnnStatus_t,
    pub time_sec: ::libc::c_uint,
    pub time_usec: ::libc::c_uint,
    pub time_delta: ::libc::c_uint,
    pub handle: cudnnHandle_t,
    pub stream: cudaStream_t,
    pub pid: ::libc::c_ulonglong,
    pub tid: ::libc::c_ulonglong,
    pub cudaDeviceId: ::libc::c_int,
    pub reserved: [::libc::c_int; 15usize],
}
#[test]
fn bindgen_test_layout_cudnnDebugStruct() {
    assert_eq!(
        ::std::mem::size_of::<cudnnDebugStruct>(),
        120usize,
        concat!("Size of: ", stringify!(cudnnDebugStruct))
    );
    assert_eq!(
        ::std::mem::align_of::<cudnnDebugStruct>(),
        8usize,
        concat!("Alignment of ", stringify!(cudnnDebugStruct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudnnDebugStruct>())).cudnn_version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(cudnn_version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudnnDebugStruct>())).cudnnStatus as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(cudnnStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudnnDebugStruct>())).time_sec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(time_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudnnDebugStruct>())).time_usec as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(time_usec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudnnDebugStruct>())).time_delta as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(time_delta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudnnDebugStruct>())).handle as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudnnDebugStruct>())).stream as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(stream)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudnnDebugStruct>())).pid as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudnnDebugStruct>())).tid as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudnnDebugStruct>())).cudaDeviceId as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(cudaDeviceId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cudnnDebugStruct>())).reserved as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(reserved)
        )
    );
}
pub type cudnnDebug_t = cudnnDebugStruct;
pub type cudnnCallback_t = ::std::option::Option<
    unsafe extern "C" fn(
        sev: cudnnSeverity_t,
        udata: *mut ::libc::c_void,
        dbg: *const cudnnDebug_t,
        msg: *const ::libc::c_char,
    ),
>;
extern "C" {
    pub fn cudnnSetCallback(
        mask: ::libc::c_uint,
        udata: *mut ::libc::c_void,
        fptr: cudnnCallback_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetCallback(
        mask: *mut ::libc::c_uint,
        udata: *mut *mut ::libc::c_void,
        fptr: *mut cudnnCallback_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnOpsInferVersionCheck() -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSoftmaxBackward(
        handle: cudnnHandle_t,
        algo: cudnnSoftmaxAlgorithm_t,
        mode: cudnnSoftmaxMode_t,
        alpha: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnPoolingBackward(
        handle: cudnnHandle_t,
        poolingDesc: cudnnPoolingDescriptor_t,
        alpha: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnActivationBackward(
        handle: cudnnHandle_t,
        activationDesc: cudnnActivationDescriptor_t,
        alpha: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnLRNCrossChannelBackward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        lrnMode: cudnnLRNMode_t,
        alpha: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDivisiveNormalizationBackward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        mode: cudnnDivNormMode_t,
        alpha: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        means: *const ::libc::c_void,
        dy: *const ::libc::c_void,
        temp: *mut ::libc::c_void,
        temp2: *mut ::libc::c_void,
        beta: *const ::libc::c_void,
        dXdMeansDesc: cudnnTensorDescriptor_t,
        dx: *mut ::libc::c_void,
        dMeans: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        xDesc: cudnnTensorDescriptor_t,
        zDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetBatchNormalizationBackwardExWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        xDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        dzDesc: cudnnTensorDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        dBnScaleBiasDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetBatchNormalizationTrainingExReserveSpaceSize(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        activationDesc: cudnnActivationDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBatchNormalizationForwardTraining(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        alpha: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::libc::c_void,
        bnBias: *const ::libc::c_void,
        exponentialAverageFactor: f64,
        resultRunningMean: *mut ::libc::c_void,
        resultRunningVariance: *mut ::libc::c_void,
        epsilon: f64,
        resultSaveMean: *mut ::libc::c_void,
        resultSaveInvVariance: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBatchNormalizationForwardTrainingEx(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        alpha: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::libc::c_void,
        zDesc: cudnnTensorDescriptor_t,
        zData: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *mut ::libc::c_void,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::libc::c_void,
        bnBias: *const ::libc::c_void,
        exponentialAverageFactor: f64,
        resultRunningMean: *mut ::libc::c_void,
        resultRunningVariance: *mut ::libc::c_void,
        epsilon: f64,
        resultSaveMean: *mut ::libc::c_void,
        resultSaveInvVariance: *mut ::libc::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        workspace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBatchNormalizationBackward(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        alphaDataDiff: *const ::libc::c_void,
        betaDataDiff: *const ::libc::c_void,
        alphaParamDiff: *const ::libc::c_void,
        betaParamDiff: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::libc::c_void,
        dBnScaleBiasDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::libc::c_void,
        dBnScaleResult: *mut ::libc::c_void,
        dBnBiasResult: *mut ::libc::c_void,
        epsilon: f64,
        savedMean: *const ::libc::c_void,
        savedInvVariance: *const ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBatchNormalizationBackwardEx(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        alphaDataDiff: *const ::libc::c_void,
        betaDataDiff: *const ::libc::c_void,
        alphaParamDiff: *const ::libc::c_void,
        betaParamDiff: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dyData: *const ::libc::c_void,
        dzDesc: cudnnTensorDescriptor_t,
        dzData: *mut ::libc::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dxData: *mut ::libc::c_void,
        dBnScaleBiasDesc: cudnnTensorDescriptor_t,
        bnScaleData: *const ::libc::c_void,
        bnBiasData: *const ::libc::c_void,
        dBnScaleData: *mut ::libc::c_void,
        dBnBiasData: *mut ::libc::c_void,
        epsilon: f64,
        savedMean: *const ::libc::c_void,
        savedInvVariance: *const ::libc::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetNormalizationForwardTrainingWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        xDesc: cudnnTensorDescriptor_t,
        zDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        normScaleBiasDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        groupCnt: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetNormalizationBackwardWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        xDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        dzDesc: cudnnTensorDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        dNormScaleBiasDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        groupCnt: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetNormalizationTrainingReserveSpaceSize(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        activationDesc: cudnnActivationDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        groupCnt: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnNormalizationForwardTraining(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        alpha: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::libc::c_void,
        normScaleBiasDesc: cudnnTensorDescriptor_t,
        normScale: *const ::libc::c_void,
        normBias: *const ::libc::c_void,
        exponentialAverageFactor: f64,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        resultRunningMean: *mut ::libc::c_void,
        resultRunningVariance: *mut ::libc::c_void,
        epsilon: f64,
        resultSaveMean: *mut ::libc::c_void,
        resultSaveInvVariance: *mut ::libc::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        zDesc: cudnnTensorDescriptor_t,
        zData: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *mut ::libc::c_void,
        workspace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
        groupCnt: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnNormalizationBackward(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        alphaDataDiff: *const ::libc::c_void,
        betaDataDiff: *const ::libc::c_void,
        alphaParamDiff: *const ::libc::c_void,
        betaParamDiff: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dyData: *const ::libc::c_void,
        dzDesc: cudnnTensorDescriptor_t,
        dzData: *mut ::libc::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dxData: *mut ::libc::c_void,
        dNormScaleBiasDesc: cudnnTensorDescriptor_t,
        normScaleData: *const ::libc::c_void,
        normBiasData: *const ::libc::c_void,
        dNormScaleData: *mut ::libc::c_void,
        dNormBiasData: *mut ::libc::c_void,
        epsilon: f64,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        savedMean: *const ::libc::c_void,
        savedInvVariance: *const ::libc::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
        groupCnt: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSpatialTfGridGeneratorBackward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        dgrid: *const ::libc::c_void,
        dtheta: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSpatialTfSamplerBackward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        alpha: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::libc::c_void,
        alphaDgrid: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        grid: *const ::libc::c_void,
        betaDgrid: *const ::libc::c_void,
        dgrid: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDropoutBackward(
        handle: cudnnHandle_t,
        dropoutDesc: cudnnDropoutDescriptor_t,
        dydesc: cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        dxdesc: cudnnTensorDescriptor_t,
        dx: *mut ::libc::c_void,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnOpsTrainVersionCheck() -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnForwardMode_t {
    CUDNN_FWD_MODE_INFERENCE = 0,
    CUDNN_FWD_MODE_TRAINING = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnRNNMode_t {
    CUDNN_RNN_RELU = 0,
    CUDNN_RNN_TANH = 1,
    CUDNN_LSTM = 2,
    CUDNN_GRU = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnRNNBiasMode_t {
    CUDNN_RNN_NO_BIAS = 0,
    CUDNN_RNN_SINGLE_INP_BIAS = 1,
    CUDNN_RNN_DOUBLE_BIAS = 2,
    CUDNN_RNN_SINGLE_REC_BIAS = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnDirectionMode_t {
    CUDNN_UNIDIRECTIONAL = 0,
    CUDNN_BIDIRECTIONAL = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnRNNInputMode_t {
    CUDNN_LINEAR_INPUT = 0,
    CUDNN_SKIP_INPUT = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnRNNClipMode_t {
    CUDNN_RNN_CLIP_NONE = 0,
    CUDNN_RNN_CLIP_MINMAX = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnRNNDataLayout_t {
    CUDNN_RNN_DATA_LAYOUT_SEQ_MAJOR_UNPACKED = 0,
    CUDNN_RNN_DATA_LAYOUT_SEQ_MAJOR_PACKED = 1,
    CUDNN_RNN_DATA_LAYOUT_BATCH_MAJOR_UNPACKED = 2,
}
pub type cudnnRNNPaddingMode_t = ::libc::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnRNNStruct {
    _unused: [u8; 0],
}
pub type cudnnRNNDescriptor_t = *mut cudnnRNNStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnPersistentRNNPlan {
    _unused: [u8; 0],
}
pub type cudnnPersistentRNNPlan_t = *mut cudnnPersistentRNNPlan;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnRNNDataStruct {
    _unused: [u8; 0],
}
pub type cudnnRNNDataDescriptor_t = *mut cudnnRNNDataStruct;
extern "C" {
    pub fn cudnnCreateRNNDescriptor(rnnDesc: *mut cudnnRNNDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyRNNDescriptor(rnnDesc: cudnnRNNDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNDescriptor_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        algo: cudnnRNNAlgo_t,
        cellMode: cudnnRNNMode_t,
        biasMode: cudnnRNNBiasMode_t,
        dirMode: cudnnDirectionMode_t,
        inputMode: cudnnRNNInputMode_t,
        dataType: cudnnDataType_t,
        mathPrec: cudnnDataType_t,
        mathType: cudnnMathType_t,
        inputSize: i32,
        hiddenSize: i32,
        projSize: i32,
        numLayers: i32,
        dropoutDesc: cudnnDropoutDescriptor_t,
        auxFlags: u32,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNDescriptor_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        algo: *mut cudnnRNNAlgo_t,
        cellMode: *mut cudnnRNNMode_t,
        biasMode: *mut cudnnRNNBiasMode_t,
        dirMode: *mut cudnnDirectionMode_t,
        inputMode: *mut cudnnRNNInputMode_t,
        dataType: *mut cudnnDataType_t,
        mathPrec: *mut cudnnDataType_t,
        mathType: *mut cudnnMathType_t,
        inputSize: *mut i32,
        hiddenSize: *mut i32,
        projSize: *mut i32,
        numLayers: *mut i32,
        dropoutDesc: *mut cudnnDropoutDescriptor_t,
        auxFlags: *mut u32,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNDescriptor_v6(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        hiddenSize: ::libc::c_int,
        numLayers: ::libc::c_int,
        dropoutDesc: cudnnDropoutDescriptor_t,
        inputMode: cudnnRNNInputMode_t,
        direction: cudnnDirectionMode_t,
        cellMode: cudnnRNNMode_t,
        algo: cudnnRNNAlgo_t,
        mathPrec: cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNDescriptor_v6(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        hiddenSize: *mut ::libc::c_int,
        numLayers: *mut ::libc::c_int,
        dropoutDesc: *mut cudnnDropoutDescriptor_t,
        inputMode: *mut cudnnRNNInputMode_t,
        direction: *mut cudnnDirectionMode_t,
        cellMode: *mut cudnnRNNMode_t,
        algo: *mut cudnnRNNAlgo_t,
        mathPrec: *mut cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNMatrixMathType(
        rnnDesc: cudnnRNNDescriptor_t,
        mType: cudnnMathType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNMatrixMathType(
        rnnDesc: cudnnRNNDescriptor_t,
        mType: *mut cudnnMathType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNBiasMode(
        rnnDesc: cudnnRNNDescriptor_t,
        biasMode: cudnnRNNBiasMode_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNBiasMode(
        rnnDesc: cudnnRNNDescriptor_t,
        biasMode: *mut cudnnRNNBiasMode_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNSetClip_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: cudnnRNNClipMode_t,
        clipNanOpt: cudnnNanPropagation_t,
        lclip: f64,
        rclip: f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNGetClip_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: *mut cudnnRNNClipMode_t,
        clipNanOpt: *mut cudnnNanPropagation_t,
        lclip: *mut f64,
        rclip: *mut f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNSetClip(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: cudnnRNNClipMode_t,
        clipNanOpt: cudnnNanPropagation_t,
        lclip: f64,
        rclip: f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNGetClip(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: *mut cudnnRNNClipMode_t,
        clipNanOpt: *mut cudnnNanPropagation_t,
        lclip: *mut f64,
        rclip: *mut f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNProjectionLayers(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        recProjSize: ::libc::c_int,
        outProjSize: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNProjectionLayers(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        recProjSize: *mut ::libc::c_int,
        outProjSize: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreatePersistentRNNPlan(
        rnnDesc: cudnnRNNDescriptor_t,
        minibatch: ::libc::c_int,
        dataType: cudnnDataType_t,
        plan: *mut cudnnPersistentRNNPlan_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyPersistentRNNPlan(plan: cudnnPersistentRNNPlan_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetPersistentRNNPlan(
        rnnDesc: cudnnRNNDescriptor_t,
        plan: cudnnPersistentRNNPlan_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBuildRNNDynamic(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        miniBatch: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNWorkspaceSize(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::libc::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNTrainingReserveSize(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::libc::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNTempSpaceSizes(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        fMode: cudnnForwardMode_t,
        xDesc: cudnnRNNDataDescriptor_t,
        workSpaceSize: *mut usize,
        reserveSpaceSize: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNParamsSize(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        dataType: cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNWeightSpaceSize(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        weightSpaceSize: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNLinLayerMatrixParams(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        pseudoLayer: ::libc::c_int,
        xDesc: cudnnTensorDescriptor_t,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        linLayerID: ::libc::c_int,
        linLayerMatDesc: cudnnFilterDescriptor_t,
        linLayerMat: *mut *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNLinLayerBiasParams(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        pseudoLayer: ::libc::c_int,
        xDesc: cudnnTensorDescriptor_t,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        linLayerID: ::libc::c_int,
        linLayerBiasDesc: cudnnFilterDescriptor_t,
        linLayerBias: *mut *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNWeightParams(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        pseudoLayer: i32,
        weightSpaceSize: usize,
        weightSpace: *const ::libc::c_void,
        linLayerID: i32,
        mDesc: cudnnTensorDescriptor_t,
        mAddr: *mut *mut ::libc::c_void,
        bDesc: cudnnTensorDescriptor_t,
        bAddr: *mut *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNForwardInference(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::libc::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
        hyDesc: cudnnTensorDescriptor_t,
        hy: *mut ::libc::c_void,
        cyDesc: cudnnTensorDescriptor_t,
        cy: *mut ::libc::c_void,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNPaddingMode(
        rnnDesc: cudnnRNNDescriptor_t,
        paddingMode: ::libc::c_uint,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNPaddingMode(
        rnnDesc: cudnnRNNDescriptor_t,
        paddingMode: *mut ::libc::c_uint,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateRNNDataDescriptor(
        rnnDataDesc: *mut cudnnRNNDataDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyRNNDataDescriptor(rnnDataDesc: cudnnRNNDataDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNDataDescriptor(
        rnnDataDesc: cudnnRNNDataDescriptor_t,
        dataType: cudnnDataType_t,
        layout: cudnnRNNDataLayout_t,
        maxSeqLength: ::libc::c_int,
        batchSize: ::libc::c_int,
        vectorSize: ::libc::c_int,
        seqLengthArray: *const ::libc::c_int,
        paddingFill: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNDataDescriptor(
        rnnDataDesc: cudnnRNNDataDescriptor_t,
        dataType: *mut cudnnDataType_t,
        layout: *mut cudnnRNNDataLayout_t,
        maxSeqLength: *mut ::libc::c_int,
        batchSize: *mut ::libc::c_int,
        vectorSize: *mut ::libc::c_int,
        arrayLengthRequested: ::libc::c_int,
        seqLengthArray: *mut ::libc::c_int,
        paddingFill: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNForwardInferenceEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::libc::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *mut ::libc::c_void,
        hyDesc: cudnnTensorDescriptor_t,
        hy: *mut ::libc::c_void,
        cyDesc: cudnnTensorDescriptor_t,
        cy: *mut ::libc::c_void,
        kDesc: cudnnRNNDataDescriptor_t,
        keys: *const ::libc::c_void,
        cDesc: cudnnRNNDataDescriptor_t,
        cAttn: *mut ::libc::c_void,
        iDesc: cudnnRNNDataDescriptor_t,
        iAttn: *mut ::libc::c_void,
        qDesc: cudnnRNNDataDescriptor_t,
        queries: *mut ::libc::c_void,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNForward(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        fwdMode: cudnnForwardMode_t,
        devSeqLengths: *const i32,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::libc::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *mut ::libc::c_void,
        hDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        hy: *mut ::libc::c_void,
        cDesc: cudnnTensorDescriptor_t,
        cx: *const ::libc::c_void,
        cy: *mut ::libc::c_void,
        weightSpaceSize: usize,
        weightSpace: *const ::libc::c_void,
        workSpaceSize: usize,
        workSpace: *mut ::libc::c_void,
        reserveSpaceSize: usize,
        reserveSpace: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNAlgorithmDescriptor(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        algoDesc: cudnnAlgorithmDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNForwardInferenceAlgorithmMaxCount(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        count: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindRNNForwardInferenceAlgorithmEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::libc::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
        hyDesc: cudnnTensorDescriptor_t,
        hy: *mut ::libc::c_void,
        cyDesc: cudnnTensorDescriptor_t,
        cy: *mut ::libc::c_void,
        findIntensity: f32,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnAlgorithmPerformance_t,
        workspace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnSeqDataAxis_t {
    CUDNN_SEQDATA_TIME_DIM = 0,
    CUDNN_SEQDATA_BATCH_DIM = 1,
    CUDNN_SEQDATA_BEAM_DIM = 2,
    CUDNN_SEQDATA_VECT_DIM = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnSeqDataStruct {
    _unused: [u8; 0],
}
pub type cudnnSeqDataDescriptor_t = *mut cudnnSeqDataStruct;
extern "C" {
    pub fn cudnnCreateSeqDataDescriptor(
        seqDataDesc: *mut cudnnSeqDataDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroySeqDataDescriptor(seqDataDesc: cudnnSeqDataDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetSeqDataDescriptor(
        seqDataDesc: cudnnSeqDataDescriptor_t,
        dataType: cudnnDataType_t,
        nbDims: ::libc::c_int,
        dimA: *const ::libc::c_int,
        axes: *const cudnnSeqDataAxis_t,
        seqLengthArraySize: usize,
        seqLengthArray: *const ::libc::c_int,
        paddingFill: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetSeqDataDescriptor(
        seqDataDesc: cudnnSeqDataDescriptor_t,
        dataType: *mut cudnnDataType_t,
        nbDims: *mut ::libc::c_int,
        nbDimsRequested: ::libc::c_int,
        dimA: *mut ::libc::c_int,
        axes: *mut cudnnSeqDataAxis_t,
        seqLengthArraySize: *mut usize,
        seqLengthSizeRequested: usize,
        seqLengthArray: *mut ::libc::c_int,
        paddingFill: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
pub type cudnnAttnQueryMap_t = ::libc::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnAttnStruct {
    _unused: [u8; 0],
}
pub type cudnnAttnDescriptor_t = *mut cudnnAttnStruct;
extern "C" {
    pub fn cudnnCreateAttnDescriptor(attnDesc: *mut cudnnAttnDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyAttnDescriptor(attnDesc: cudnnAttnDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetAttnDescriptor(
        attnDesc: cudnnAttnDescriptor_t,
        attnMode: ::libc::c_uint,
        nHeads: ::libc::c_int,
        smScaler: f64,
        dataType: cudnnDataType_t,
        computePrec: cudnnDataType_t,
        mathType: cudnnMathType_t,
        attnDropoutDesc: cudnnDropoutDescriptor_t,
        postDropoutDesc: cudnnDropoutDescriptor_t,
        qSize: ::libc::c_int,
        kSize: ::libc::c_int,
        vSize: ::libc::c_int,
        qProjSize: ::libc::c_int,
        kProjSize: ::libc::c_int,
        vProjSize: ::libc::c_int,
        oProjSize: ::libc::c_int,
        qoMaxSeqLength: ::libc::c_int,
        kvMaxSeqLength: ::libc::c_int,
        maxBatchSize: ::libc::c_int,
        maxBeamSize: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetAttnDescriptor(
        attnDesc: cudnnAttnDescriptor_t,
        attnMode: *mut ::libc::c_uint,
        nHeads: *mut ::libc::c_int,
        smScaler: *mut f64,
        dataType: *mut cudnnDataType_t,
        computePrec: *mut cudnnDataType_t,
        mathType: *mut cudnnMathType_t,
        attnDropoutDesc: *mut cudnnDropoutDescriptor_t,
        postDropoutDesc: *mut cudnnDropoutDescriptor_t,
        qSize: *mut ::libc::c_int,
        kSize: *mut ::libc::c_int,
        vSize: *mut ::libc::c_int,
        qProjSize: *mut ::libc::c_int,
        kProjSize: *mut ::libc::c_int,
        vProjSize: *mut ::libc::c_int,
        oProjSize: *mut ::libc::c_int,
        qoMaxSeqLength: *mut ::libc::c_int,
        kvMaxSeqLength: *mut ::libc::c_int,
        maxBatchSize: *mut ::libc::c_int,
        maxBeamSize: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetMultiHeadAttnBuffers(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        weightSizeInBytes: *mut usize,
        workSpaceSizeInBytes: *mut usize,
        reserveSpaceSizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnMultiHeadAttnWeightKind_t {
    CUDNN_MH_ATTN_Q_WEIGHTS = 0,
    CUDNN_MH_ATTN_K_WEIGHTS = 1,
    CUDNN_MH_ATTN_V_WEIGHTS = 2,
    CUDNN_MH_ATTN_O_WEIGHTS = 3,
    CUDNN_MH_ATTN_Q_BIASES = 4,
    CUDNN_MH_ATTN_K_BIASES = 5,
    CUDNN_MH_ATTN_V_BIASES = 6,
    CUDNN_MH_ATTN_O_BIASES = 7,
}
extern "C" {
    pub fn cudnnGetMultiHeadAttnWeights(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        wKind: cudnnMultiHeadAttnWeightKind_t,
        weightSizeInBytes: usize,
        weights: *const ::libc::c_void,
        wDesc: cudnnTensorDescriptor_t,
        wAddr: *mut *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnMultiHeadAttnForward(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        currIdx: ::libc::c_int,
        loWinIdx: *const ::libc::c_int,
        hiWinIdx: *const ::libc::c_int,
        devSeqLengthsQO: *const ::libc::c_int,
        devSeqLengthsKV: *const ::libc::c_int,
        qDesc: cudnnSeqDataDescriptor_t,
        queries: *const ::libc::c_void,
        residuals: *const ::libc::c_void,
        kDesc: cudnnSeqDataDescriptor_t,
        keys: *const ::libc::c_void,
        vDesc: cudnnSeqDataDescriptor_t,
        values: *const ::libc::c_void,
        oDesc: cudnnSeqDataDescriptor_t,
        out: *mut ::libc::c_void,
        weightSizeInBytes: usize,
        weights: *const ::libc::c_void,
        workSpaceSizeInBytes: usize,
        workSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnAdvInferVersionCheck() -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnWgradMode_t {
    CUDNN_WGRAD_MODE_ADD = 0,
    CUDNN_WGRAD_MODE_SET = 1,
}
extern "C" {
    pub fn cudnnRNNForwardTraining(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::libc::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
        hyDesc: cudnnTensorDescriptor_t,
        hy: *mut ::libc::c_void,
        cyDesc: cudnnTensorDescriptor_t,
        cy: *mut ::libc::c_void,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNBackwardData(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::libc::c_int,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *const ::libc::c_void,
        dyDesc: *const cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        dhyDesc: cudnnTensorDescriptor_t,
        dhy: *const ::libc::c_void,
        dcyDesc: cudnnTensorDescriptor_t,
        dcy: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::libc::c_void,
        dxDesc: *const cudnnTensorDescriptor_t,
        dx: *mut ::libc::c_void,
        dhxDesc: cudnnTensorDescriptor_t,
        dhx: *mut ::libc::c_void,
        dcxDesc: cudnnTensorDescriptor_t,
        dcx: *mut ::libc::c_void,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNBackwardData_v8(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        devSeqLengths: *const i32,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *const ::libc::c_void,
        dy: *const ::libc::c_void,
        xDesc: cudnnRNNDataDescriptor_t,
        dx: *mut ::libc::c_void,
        hDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        dhy: *const ::libc::c_void,
        dhx: *mut ::libc::c_void,
        cDesc: cudnnTensorDescriptor_t,
        cx: *const ::libc::c_void,
        dcy: *const ::libc::c_void,
        dcx: *mut ::libc::c_void,
        weightSpaceSize: usize,
        weightSpace: *const ::libc::c_void,
        workSpaceSize: usize,
        workSpace: *mut ::libc::c_void,
        reserveSpaceSize: usize,
        reserveSpace: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNBackwardWeights(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::libc::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *const ::libc::c_void,
        workSpace: *const ::libc::c_void,
        workSpaceSizeInBytes: usize,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::libc::c_void,
        reserveSpace: *const ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNBackwardWeights_v8(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        addGrad: cudnnWgradMode_t,
        devSeqLengths: *const i32,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::libc::c_void,
        hDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *const ::libc::c_void,
        weightSpaceSize: usize,
        dweightSpace: *mut ::libc::c_void,
        workSpaceSize: usize,
        workSpace: *mut ::libc::c_void,
        reserveSpaceSize: usize,
        reserveSpace: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNForwardTrainingEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::libc::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *mut ::libc::c_void,
        hyDesc: cudnnTensorDescriptor_t,
        hy: *mut ::libc::c_void,
        cyDesc: cudnnTensorDescriptor_t,
        cy: *mut ::libc::c_void,
        kDesc: cudnnRNNDataDescriptor_t,
        keys: *const ::libc::c_void,
        cDesc: cudnnRNNDataDescriptor_t,
        cAttn: *mut ::libc::c_void,
        iDesc: cudnnRNNDataDescriptor_t,
        iAttn: *mut ::libc::c_void,
        qDesc: cudnnRNNDataDescriptor_t,
        queries: *mut ::libc::c_void,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNBackwardDataEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *const ::libc::c_void,
        dyDesc: cudnnRNNDataDescriptor_t,
        dy: *const ::libc::c_void,
        dcDesc: cudnnRNNDataDescriptor_t,
        dcAttn: *const ::libc::c_void,
        dhyDesc: cudnnTensorDescriptor_t,
        dhy: *const ::libc::c_void,
        dcyDesc: cudnnTensorDescriptor_t,
        dcy: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::libc::c_void,
        dxDesc: cudnnRNNDataDescriptor_t,
        dx: *mut ::libc::c_void,
        dhxDesc: cudnnTensorDescriptor_t,
        dhx: *mut ::libc::c_void,
        dcxDesc: cudnnTensorDescriptor_t,
        dcx: *mut ::libc::c_void,
        dkDesc: cudnnRNNDataDescriptor_t,
        dkeys: *mut ::libc::c_void,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNBackwardWeightsEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::libc::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *const ::libc::c_void,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::libc::c_void,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNForwardTrainingAlgorithmMaxCount(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        count: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindRNNForwardTrainingAlgorithmEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::libc::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
        hyDesc: cudnnTensorDescriptor_t,
        hy: *mut ::libc::c_void,
        cyDesc: cudnnTensorDescriptor_t,
        cy: *mut ::libc::c_void,
        findIntensity: f32,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnAlgorithmPerformance_t,
        workspace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNBackwardDataAlgorithmMaxCount(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        count: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindRNNBackwardDataAlgorithmEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::libc::c_int,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *const ::libc::c_void,
        dyDesc: *const cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        dhyDesc: cudnnTensorDescriptor_t,
        dhy: *const ::libc::c_void,
        dcyDesc: cudnnTensorDescriptor_t,
        dcy: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::libc::c_void,
        dxDesc: *const cudnnTensorDescriptor_t,
        dx: *mut ::libc::c_void,
        dhxDesc: cudnnTensorDescriptor_t,
        dhx: *mut ::libc::c_void,
        dcxDesc: cudnnTensorDescriptor_t,
        dcx: *mut ::libc::c_void,
        findIntensity: f32,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnAlgorithmPerformance_t,
        workspace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNBackwardWeightsAlgorithmMaxCount(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        count: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindRNNBackwardWeightsAlgorithmEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::libc::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::libc::c_void,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *const ::libc::c_void,
        findIntensity: f32,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnAlgorithmPerformance_t,
        workspace: *const ::libc::c_void,
        workSpaceSizeInBytes: usize,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::libc::c_void,
        reserveSpace: *const ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnMultiHeadAttnBackwardData(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        loWinIdx: *const ::libc::c_int,
        hiWinIdx: *const ::libc::c_int,
        devSeqLengthsDQDO: *const ::libc::c_int,
        devSeqLengthsDKDV: *const ::libc::c_int,
        doDesc: cudnnSeqDataDescriptor_t,
        dout: *const ::libc::c_void,
        dqDesc: cudnnSeqDataDescriptor_t,
        dqueries: *mut ::libc::c_void,
        queries: *const ::libc::c_void,
        dkDesc: cudnnSeqDataDescriptor_t,
        dkeys: *mut ::libc::c_void,
        keys: *const ::libc::c_void,
        dvDesc: cudnnSeqDataDescriptor_t,
        dvalues: *mut ::libc::c_void,
        values: *const ::libc::c_void,
        weightSizeInBytes: usize,
        weights: *const ::libc::c_void,
        workSpaceSizeInBytes: usize,
        workSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnMultiHeadAttnBackwardWeights(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        addGrad: cudnnWgradMode_t,
        qDesc: cudnnSeqDataDescriptor_t,
        queries: *const ::libc::c_void,
        kDesc: cudnnSeqDataDescriptor_t,
        keys: *const ::libc::c_void,
        vDesc: cudnnSeqDataDescriptor_t,
        values: *const ::libc::c_void,
        doDesc: cudnnSeqDataDescriptor_t,
        dout: *const ::libc::c_void,
        weightSizeInBytes: usize,
        weights: *const ::libc::c_void,
        dweights: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        workSpace: *mut ::libc::c_void,
        reserveSpaceSizeInBytes: usize,
        reserveSpace: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnLossNormalizationMode_t {
    CUDNN_LOSS_NORMALIZATION_NONE = 0,
    CUDNN_LOSS_NORMALIZATION_SOFTMAX = 1,
}
extern "C" {
    pub fn cudnnCreateCTCLossDescriptor(
        ctcLossDesc: *mut cudnnCTCLossDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetCTCLossDescriptor(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetCTCLossDescriptorEx(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
        normMode: cudnnLossNormalizationMode_t,
        gradMode: cudnnNanPropagation_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetCTCLossDescriptor_v8(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
        normMode: cudnnLossNormalizationMode_t,
        gradMode: cudnnNanPropagation_t,
        maxLabelLength: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetCTCLossDescriptor(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetCTCLossDescriptorEx(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
        normMode: *mut cudnnLossNormalizationMode_t,
        gradMode: *mut cudnnNanPropagation_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetCTCLossDescriptor_v8(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
        normMode: *mut cudnnLossNormalizationMode_t,
        gradMode: *mut cudnnNanPropagation_t,
        maxLabelLength: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyCTCLossDescriptor(ctcLossDesc: cudnnCTCLossDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCTCLoss(
        handle: cudnnHandle_t,
        probsDesc: cudnnTensorDescriptor_t,
        probs: *const ::libc::c_void,
        hostLabels: *const ::libc::c_int,
        hostLabelLengths: *const ::libc::c_int,
        hostInputLengths: *const ::libc::c_int,
        costs: *mut ::libc::c_void,
        gradientsDesc: cudnnTensorDescriptor_t,
        gradients: *mut ::libc::c_void,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        workspace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCTCLoss_v8(
        handle: cudnnHandle_t,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        probsDesc: cudnnTensorDescriptor_t,
        probs: *const ::libc::c_void,
        labels: *const ::libc::c_int,
        labelLengths: *const ::libc::c_int,
        inputLengths: *const ::libc::c_int,
        costs: *mut ::libc::c_void,
        gradientsDesc: cudnnTensorDescriptor_t,
        gradients: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        workspace: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetCTCLossWorkspaceSize(
        handle: cudnnHandle_t,
        probsDesc: cudnnTensorDescriptor_t,
        gradientsDesc: cudnnTensorDescriptor_t,
        labels: *const ::libc::c_int,
        labelLengths: *const ::libc::c_int,
        inputLengths: *const ::libc::c_int,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetCTCLossWorkspaceSize_v8(
        handle: cudnnHandle_t,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        probsDesc: cudnnTensorDescriptor_t,
        gradientsDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnAdvTrainVersionCheck() -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnConvolutionStruct {
    _unused: [u8; 0],
}
pub type cudnnConvolutionDescriptor_t = *mut cudnnConvolutionStruct;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnConvolutionMode_t {
    CUDNN_CONVOLUTION = 0,
    CUDNN_CROSS_CORRELATION = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnReorderType_t {
    CUDNN_DEFAULT_REORDER = 0,
    CUDNN_NO_REORDER = 1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnConvolutionFwdAlgoPerfStruct {
    pub algo: cudnnConvolutionFwdAlgo_t,
    pub status: cudnnStatus_t,
    pub time: f32,
    pub memory: usize,
    pub determinism: cudnnDeterminism_t,
    pub mathType: cudnnMathType_t,
    pub reserved: [::libc::c_int; 3usize],
}
#[test]
fn bindgen_test_layout_cudnnConvolutionFwdAlgoPerfStruct() {
    assert_eq!(
        ::std::mem::size_of::<cudnnConvolutionFwdAlgoPerfStruct>(),
        48usize,
        concat!("Size of: ", stringify!(cudnnConvolutionFwdAlgoPerfStruct))
    );
    assert_eq!(
        ::std::mem::align_of::<cudnnConvolutionFwdAlgoPerfStruct>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).algo as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(algo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).status as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).time as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).memory as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(memory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).determinism as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(determinism)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).mathType as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(mathType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).reserved as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(reserved)
        )
    );
}
pub type cudnnConvolutionFwdAlgoPerf_t = cudnnConvolutionFwdAlgoPerfStruct;
extern "C" {
    pub fn cudnnCreateConvolutionDescriptor(
        convDesc: *mut cudnnConvolutionDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyConvolutionDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetConvolutionMathType(
        convDesc: cudnnConvolutionDescriptor_t,
        mathType: cudnnMathType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionMathType(
        convDesc: cudnnConvolutionDescriptor_t,
        mathType: *mut cudnnMathType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetConvolutionGroupCount(
        convDesc: cudnnConvolutionDescriptor_t,
        groupCount: ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionGroupCount(
        convDesc: cudnnConvolutionDescriptor_t,
        groupCount: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetConvolutionReorderType(
        convDesc: cudnnConvolutionDescriptor_t,
        reorderType: cudnnReorderType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionReorderType(
        convDesc: cudnnConvolutionDescriptor_t,
        reorderType: *mut cudnnReorderType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetConvolution2dDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        pad_h: ::libc::c_int,
        pad_w: ::libc::c_int,
        u: ::libc::c_int,
        v: ::libc::c_int,
        dilation_h: ::libc::c_int,
        dilation_w: ::libc::c_int,
        mode: cudnnConvolutionMode_t,
        computeType: cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolution2dDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        pad_h: *mut ::libc::c_int,
        pad_w: *mut ::libc::c_int,
        u: *mut ::libc::c_int,
        v: *mut ::libc::c_int,
        dilation_h: *mut ::libc::c_int,
        dilation_w: *mut ::libc::c_int,
        mode: *mut cudnnConvolutionMode_t,
        computeType: *mut cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetConvolutionNdDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        arrayLength: ::libc::c_int,
        padA: *const ::libc::c_int,
        filterStrideA: *const ::libc::c_int,
        dilationA: *const ::libc::c_int,
        mode: cudnnConvolutionMode_t,
        computeType: cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionNdDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        arrayLengthRequested: ::libc::c_int,
        arrayLength: *mut ::libc::c_int,
        padA: *mut ::libc::c_int,
        strideA: *mut ::libc::c_int,
        dilationA: *mut ::libc::c_int,
        mode: *mut cudnnConvolutionMode_t,
        computeType: *mut cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolution2dForwardOutputDim(
        convDesc: cudnnConvolutionDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        filterDesc: cudnnFilterDescriptor_t,
        n: *mut ::libc::c_int,
        c: *mut ::libc::c_int,
        h: *mut ::libc::c_int,
        w: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionNdForwardOutputDim(
        convDesc: cudnnConvolutionDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        filterDesc: cudnnFilterDescriptor_t,
        nbDims: ::libc::c_int,
        tensorOuputDimA: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionForwardAlgorithmMaxCount(
        handle: cudnnHandle_t,
        count: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionForwardAlgorithm_v7(
        handle: cudnnHandle_t,
        srcDesc: cudnnTensorDescriptor_t,
        filterDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        destDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindConvolutionForwardAlgorithm(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        wDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindConvolutionForwardAlgorithmEx(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnIm2Col(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        colBuffer: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnReorderFilterAndBias(
        handle: cudnnHandle_t,
        filterDesc: cudnnFilterDescriptor_t,
        reorderType: cudnnReorderType_t,
        filterData: *const ::libc::c_void,
        reorderedFilterData: *mut ::libc::c_void,
        reorderBias: ::libc::c_int,
        biasData: *const ::libc::c_void,
        reorderedBiasData: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionForwardWorkspaceSize(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        wDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        algo: cudnnConvolutionFwdAlgo_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnConvolutionForward(
        handle: cudnnHandle_t,
        alpha: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionFwdAlgo_t,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        beta: *const ::libc::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnConvolutionBiasActivationForward(
        handle: cudnnHandle_t,
        alpha1: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionFwdAlgo_t,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        alpha2: *const ::libc::c_void,
        zDesc: cudnnTensorDescriptor_t,
        z: *const ::libc::c_void,
        biasDesc: cudnnTensorDescriptor_t,
        bias: *const ::libc::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnConvolutionBwdDataAlgoPerfStruct {
    pub algo: cudnnConvolutionBwdDataAlgo_t,
    pub status: cudnnStatus_t,
    pub time: f32,
    pub memory: usize,
    pub determinism: cudnnDeterminism_t,
    pub mathType: cudnnMathType_t,
    pub reserved: [::libc::c_int; 3usize],
}
#[test]
fn bindgen_test_layout_cudnnConvolutionBwdDataAlgoPerfStruct() {
    assert_eq!(
        ::std::mem::size_of::<cudnnConvolutionBwdDataAlgoPerfStruct>(),
        48usize,
        concat!(
            "Size of: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudnnConvolutionBwdDataAlgoPerfStruct>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).algo as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(algo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).status as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).time as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).memory as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(memory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).determinism
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(determinism)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).mathType as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(mathType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).reserved as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(reserved)
        )
    );
}
pub type cudnnConvolutionBwdDataAlgoPerf_t = cudnnConvolutionBwdDataAlgoPerfStruct;
extern "C" {
    pub fn cudnnGetConvolutionBackwardDataAlgorithmMaxCount(
        handle: cudnnHandle_t,
        count: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindConvolutionBackwardDataAlgorithm(
        handle: cudnnHandle_t,
        wDesc: cudnnFilterDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindConvolutionBackwardDataAlgorithmEx(
        handle: cudnnHandle_t,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::libc::c_void,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionBackwardDataAlgorithm_v7(
        handle: cudnnHandle_t,
        filterDesc: cudnnFilterDescriptor_t,
        diffDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionBackwardDataWorkspaceSize(
        handle: cudnnHandle_t,
        wDesc: cudnnFilterDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        algo: cudnnConvolutionBwdDataAlgo_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnConvolutionBackwardData(
        handle: cudnnHandle_t,
        alpha: *const ::libc::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionBwdDataAlgo_t,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        beta: *const ::libc::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetFoldedConvBackwardDataDescriptors(
        handle: cudnnHandle_t,
        filterDesc: cudnnFilterDescriptor_t,
        diffDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnTensorDescriptor_t,
        transformFormat: cudnnTensorFormat_t,
        foldedFilterDesc: cudnnFilterDescriptor_t,
        paddedDiffDesc: cudnnTensorDescriptor_t,
        foldedConvDesc: cudnnConvolutionDescriptor_t,
        foldedGradDesc: cudnnTensorDescriptor_t,
        filterFoldTransDesc: cudnnTensorTransformDescriptor_t,
        diffPadTransDesc: cudnnTensorTransformDescriptor_t,
        gradFoldTransDesc: cudnnTensorTransformDescriptor_t,
        gradUnfoldTransDesc: cudnnTensorTransformDescriptor_t,
    ) -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnFusedOpsConstParamStruct {
    _unused: [u8; 0],
}
pub type cudnnFusedOpsConstParamPack_t = *mut cudnnFusedOpsConstParamStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnFusedOpsVariantParamStruct {
    _unused: [u8; 0],
}
pub type cudnnFusedOpsVariantParamPack_t = *mut cudnnFusedOpsVariantParamStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnFusedOpsPlanStruct {
    _unused: [u8; 0],
}
pub type cudnnFusedOpsPlan_t = *mut cudnnFusedOpsPlanStruct;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnFusedOps_t {
    CUDNN_FUSED_SCALE_BIAS_ACTIVATION_CONV_BNSTATS = 0,
    CUDNN_FUSED_SCALE_BIAS_ACTIVATION_WGRAD = 1,
    CUDNN_FUSED_BN_FINALIZE_STATISTICS_TRAINING = 2,
    CUDNN_FUSED_BN_FINALIZE_STATISTICS_INFERENCE = 3,
    CUDNN_FUSED_CONV_SCALE_BIAS_ADD_ACTIVATION = 4,
    CUDNN_FUSED_SCALE_BIAS_ADD_ACTIVATION_GEN_BITMASK = 5,
    CUDNN_FUSED_DACTIVATION_FORK_DBATCHNORM = 6,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnFusedOpsConstParamLabel_t {
    CUDNN_PARAM_XDESC = 0,
    CUDNN_PARAM_XDATA_PLACEHOLDER = 1,
    CUDNN_PARAM_BN_MODE = 2,
    CUDNN_PARAM_BN_EQSCALEBIAS_DESC = 3,
    CUDNN_PARAM_BN_EQSCALE_PLACEHOLDER = 4,
    CUDNN_PARAM_BN_EQBIAS_PLACEHOLDER = 5,
    CUDNN_PARAM_ACTIVATION_DESC = 6,
    CUDNN_PARAM_CONV_DESC = 7,
    CUDNN_PARAM_WDESC = 8,
    CUDNN_PARAM_WDATA_PLACEHOLDER = 9,
    CUDNN_PARAM_DWDESC = 10,
    CUDNN_PARAM_DWDATA_PLACEHOLDER = 11,
    CUDNN_PARAM_YDESC = 12,
    CUDNN_PARAM_YDATA_PLACEHOLDER = 13,
    CUDNN_PARAM_DYDESC = 14,
    CUDNN_PARAM_DYDATA_PLACEHOLDER = 15,
    CUDNN_PARAM_YSTATS_DESC = 16,
    CUDNN_PARAM_YSUM_PLACEHOLDER = 17,
    CUDNN_PARAM_YSQSUM_PLACEHOLDER = 18,
    CUDNN_PARAM_BN_SCALEBIAS_MEANVAR_DESC = 19,
    CUDNN_PARAM_BN_SCALE_PLACEHOLDER = 20,
    CUDNN_PARAM_BN_BIAS_PLACEHOLDER = 21,
    CUDNN_PARAM_BN_SAVED_MEAN_PLACEHOLDER = 22,
    CUDNN_PARAM_BN_SAVED_INVSTD_PLACEHOLDER = 23,
    CUDNN_PARAM_BN_RUNNING_MEAN_PLACEHOLDER = 24,
    CUDNN_PARAM_BN_RUNNING_VAR_PLACEHOLDER = 25,
    CUDNN_PARAM_ZDESC = 26,
    CUDNN_PARAM_ZDATA_PLACEHOLDER = 27,
    CUDNN_PARAM_BN_Z_EQSCALEBIAS_DESC = 28,
    CUDNN_PARAM_BN_Z_EQSCALE_PLACEHOLDER = 29,
    CUDNN_PARAM_BN_Z_EQBIAS_PLACEHOLDER = 30,
    CUDNN_PARAM_ACTIVATION_BITMASK_DESC = 31,
    CUDNN_PARAM_ACTIVATION_BITMASK_PLACEHOLDER = 32,
    CUDNN_PARAM_DXDESC = 33,
    CUDNN_PARAM_DXDATA_PLACEHOLDER = 34,
    CUDNN_PARAM_DZDESC = 35,
    CUDNN_PARAM_DZDATA_PLACEHOLDER = 36,
    CUDNN_PARAM_BN_DSCALE_PLACEHOLDER = 37,
    CUDNN_PARAM_BN_DBIAS_PLACEHOLDER = 38,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnFusedOpsPointerPlaceHolder_t {
    CUDNN_PTR_NULL = 0,
    CUDNN_PTR_ELEM_ALIGNED = 1,
    CUDNN_PTR_16B_ALIGNED = 2,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnFusedOpsVariantParamLabel_t {
    CUDNN_PTR_XDATA = 0,
    CUDNN_PTR_BN_EQSCALE = 1,
    CUDNN_PTR_BN_EQBIAS = 2,
    CUDNN_PTR_WDATA = 3,
    CUDNN_PTR_DWDATA = 4,
    CUDNN_PTR_YDATA = 5,
    CUDNN_PTR_DYDATA = 6,
    CUDNN_PTR_YSUM = 7,
    CUDNN_PTR_YSQSUM = 8,
    CUDNN_PTR_WORKSPACE = 9,
    CUDNN_PTR_BN_SCALE = 10,
    CUDNN_PTR_BN_BIAS = 11,
    CUDNN_PTR_BN_SAVED_MEAN = 12,
    CUDNN_PTR_BN_SAVED_INVSTD = 13,
    CUDNN_PTR_BN_RUNNING_MEAN = 14,
    CUDNN_PTR_BN_RUNNING_VAR = 15,
    CUDNN_PTR_ZDATA = 16,
    CUDNN_PTR_BN_Z_EQSCALE = 17,
    CUDNN_PTR_BN_Z_EQBIAS = 18,
    CUDNN_PTR_ACTIVATION_BITMASK = 19,
    CUDNN_PTR_DXDATA = 20,
    CUDNN_PTR_DZDATA = 21,
    CUDNN_PTR_BN_DSCALE = 22,
    CUDNN_PTR_BN_DBIAS = 23,
    CUDNN_SCALAR_SIZE_T_WORKSPACE_SIZE_IN_BYTES = 100,
    CUDNN_SCALAR_INT64_T_BN_ACCUMULATION_COUNT = 101,
    CUDNN_SCALAR_DOUBLE_BN_EXP_AVG_FACTOR = 102,
    CUDNN_SCALAR_DOUBLE_BN_EPSILON = 103,
}
extern "C" {
    pub fn cudnnCnnInferVersionCheck() -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnConvolutionBwdFilterAlgoPerfStruct {
    pub algo: cudnnConvolutionBwdFilterAlgo_t,
    pub status: cudnnStatus_t,
    pub time: f32,
    pub memory: usize,
    pub determinism: cudnnDeterminism_t,
    pub mathType: cudnnMathType_t,
    pub reserved: [::libc::c_int; 3usize],
}
#[test]
fn bindgen_test_layout_cudnnConvolutionBwdFilterAlgoPerfStruct() {
    assert_eq!(
        ::std::mem::size_of::<cudnnConvolutionBwdFilterAlgoPerfStruct>(),
        48usize,
        concat!(
            "Size of: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cudnnConvolutionBwdFilterAlgoPerfStruct>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).algo as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(algo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).status as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).time as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).memory as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(memory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).determinism
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(determinism)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).mathType as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(mathType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).reserved as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(reserved)
        )
    );
}
pub type cudnnConvolutionBwdFilterAlgoPerf_t = cudnnConvolutionBwdFilterAlgoPerfStruct;
extern "C" {
    pub fn cudnnGetConvolutionBackwardFilterAlgorithmMaxCount(
        handle: cudnnHandle_t,
        count: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindConvolutionBackwardFilterAlgorithm(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        dwDesc: cudnnFilterDescriptor_t,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindConvolutionBackwardFilterAlgorithmEx(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        y: *const ::libc::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::libc::c_void,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionBackwardFilterAlgorithm_v7(
        handle: cudnnHandle_t,
        srcDesc: cudnnTensorDescriptor_t,
        diffDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnFilterDescriptor_t,
        requestedAlgoCount: ::libc::c_int,
        returnedAlgoCount: *mut ::libc::c_int,
        perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionBackwardFilterWorkspaceSize(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnFilterDescriptor_t,
        algo: cudnnConvolutionBwdFilterAlgo_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnConvolutionBackwardFilter(
        handle: cudnnHandle_t,
        alpha: *const ::libc::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionBwdFilterAlgo_t,
        workSpace: *mut ::libc::c_void,
        workSpaceSizeInBytes: usize,
        beta: *const ::libc::c_void,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnConvolutionBackwardBias(
        handle: cudnnHandle_t,
        alpha: *const ::libc::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::libc::c_void,
        beta: *const ::libc::c_void,
        dbDesc: cudnnTensorDescriptor_t,
        db: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateFusedOpsConstParamPack(
        constPack: *mut cudnnFusedOpsConstParamPack_t,
        ops: cudnnFusedOps_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyFusedOpsConstParamPack(
        constPack: cudnnFusedOpsConstParamPack_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetFusedOpsConstParamPackAttribute(
        constPack: cudnnFusedOpsConstParamPack_t,
        paramLabel: cudnnFusedOpsConstParamLabel_t,
        param: *const ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetFusedOpsConstParamPackAttribute(
        constPack: cudnnFusedOpsConstParamPack_t,
        paramLabel: cudnnFusedOpsConstParamLabel_t,
        param: *mut ::libc::c_void,
        isNULL: *mut ::libc::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateFusedOpsVariantParamPack(
        varPack: *mut cudnnFusedOpsVariantParamPack_t,
        ops: cudnnFusedOps_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyFusedOpsVariantParamPack(
        varPack: cudnnFusedOpsVariantParamPack_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetFusedOpsVariantParamPackAttribute(
        varPack: cudnnFusedOpsVariantParamPack_t,
        paramLabel: cudnnFusedOpsVariantParamLabel_t,
        ptr: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetFusedOpsVariantParamPackAttribute(
        varPack: cudnnFusedOpsVariantParamPack_t,
        paramLabel: cudnnFusedOpsVariantParamLabel_t,
        ptr: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateFusedOpsPlan(
        plan: *mut cudnnFusedOpsPlan_t,
        ops: cudnnFusedOps_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyFusedOpsPlan(plan: cudnnFusedOpsPlan_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnMakeFusedOpsPlan(
        handle: cudnnHandle_t,
        plan: cudnnFusedOpsPlan_t,
        constPack: cudnnFusedOpsConstParamPack_t,
        workspaceSizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFusedOpsExecute(
        handle: cudnnHandle_t,
        plan: cudnnFusedOpsPlan_t,
        varPack: cudnnFusedOpsVariantParamPack_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCnnTrainVersionCheck() -> cudnnStatus_t;
}
pub type cudnnBackendDescriptor_t = *mut ::libc::c_void;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnPointwiseMode_t {
    CUDNN_POINTWISE_ADD = 0,
    CUDNN_POINTWISE_MUL = 1,
    CUDNN_POINTWISE_MIN = 2,
    CUDNN_POINTWISE_MAX = 3,
    CUDNN_POINTWISE_SQRT = 4,
    CUDNN_POINTWISE_RELU_FWD = 100,
    CUDNN_POINTWISE_TANH_FWD = 101,
    CUDNN_POINTWISE_SIGMOID_FWD = 102,
    CUDNN_POINTWISE_ELU_FWD = 103,
    CUDNN_POINTWISE_GELU_FWD = 104,
    CUDNN_POINTWISE_SOFTPLUS_FWD = 105,
    CUDNN_POINTWISE_SWISH_FWD = 106,
    CUDNN_POINTWISE_RELU_BWD = 200,
    CUDNN_POINTWISE_TANH_BWD = 201,
    CUDNN_POINTWISE_SIGMOID_BWD = 202,
    CUDNN_POINTWISE_ELU_BWD = 203,
    CUDNN_POINTWISE_GELU_BWD = 204,
    CUDNN_POINTWISE_SOFTPLUS_BWD = 205,
    CUDNN_POINTWISE_SWISH_BWD = 206,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnGenStatsMode_t {
    CUDNN_GENSTATS_SUM_SQSUM = 0,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnBnFinalizeStatsMode_t {
    CUDNN_BN_FINALIZE_STATISTICS_TRAINING = 0,
    CUDNN_BN_FINALIZE_STATISTICS_INFERENCE = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnBackendAttributeName_t {
    CUDNN_ATTR_POINTWISE_MODE = 0,
    CUDNN_ATTR_POINTWISE_MATH_PREC = 1,
    CUDNN_ATTR_POINTWISE_NAN_PROPAGATION = 2,
    CUDNN_ATTR_POINTWISE_RELU_LOWER_CLIP = 3,
    CUDNN_ATTR_POINTWISE_RELU_UPPER_CLIP = 4,
    CUDNN_ATTR_POINTWISE_RELU_LOWER_CLIP_SLOPE = 5,
    CUDNN_ATTR_POINTWISE_ELU_ALPHA = 6,
    CUDNN_ATTR_POINTWISE_SOFTPLUS_BETA = 7,
    CUDNN_ATTR_POINTWISE_SWISH_BETA = 8,
    CUDNN_ATTR_CONVOLUTION_COMP_TYPE = 100,
    CUDNN_ATTR_CONVOLUTION_CONV_MODE = 101,
    CUDNN_ATTR_CONVOLUTION_DILATIONS = 102,
    CUDNN_ATTR_CONVOLUTION_FILTER_STRIDES = 103,
    CUDNN_ATTR_CONVOLUTION_POST_PADDINGS = 104,
    CUDNN_ATTR_CONVOLUTION_PRE_PADDINGS = 105,
    CUDNN_ATTR_CONVOLUTION_SPATIAL_DIMS = 106,
    CUDNN_ATTR_ENGINEHEUR_MODE = 200,
    CUDNN_ATTR_ENGINEHEUR_OPERATION_GRAPH = 201,
    CUDNN_ATTR_ENGINEHEUR_RESULTS = 202,
    CUDNN_ATTR_ENGINECFG_ENGINE = 300,
    CUDNN_ATTR_ENGINECFG_INTERMEDIATE_INFO = 301,
    CUDNN_ATTR_ENGINECFG_KNOB_CHOICES = 302,
    CUDNN_ATTR_EXECUTION_PLAN_HANDLE = 400,
    CUDNN_ATTR_EXECUTION_PLAN_ENGINE_CONFIG = 401,
    CUDNN_ATTR_EXECUTION_PLAN_WORKSPACE_SIZE = 402,
    CUDNN_ATTR_EXECUTION_PLAN_COMPUTED_INTERMEDIATE_UIDS = 403,
    CUDNN_ATTR_EXECUTION_PLAN_RUN_ONLY_INTERMEDIATE_UIDS = 404,
    CUDNN_ATTR_INTERMEDIATE_INFO_UNIQUE_ID = 500,
    CUDNN_ATTR_INTERMEDIATE_INFO_SIZE = 501,
    CUDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_DATA_UIDS = 502,
    CUDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_ATTRIBUTES = 503,
    CUDNN_ATTR_KNOB_CHOICE_KNOB_TYPE = 600,
    CUDNN_ATTR_KNOB_CHOICE_KNOB_VALUE = 601,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_ALPHA = 700,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_BETA = 701,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_CONV_DESC = 702,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_W = 703,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_X = 704,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_Y = 705,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_ALPHA = 706,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_BETA = 707,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_CONV_DESC = 708,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_W = 709,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_DX = 710,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_DY = 711,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_ALPHA = 712,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_BETA = 713,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_CONV_DESC = 714,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_DW = 715,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_X = 716,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_DY = 717,
    CUDNN_ATTR_OPERATION_POINTWISE_PW_DESCRIPTOR = 750,
    CUDNN_ATTR_OPERATION_POINTWISE_XDESC = 751,
    CUDNN_ATTR_OPERATION_POINTWISE_BDESC = 752,
    CUDNN_ATTR_OPERATION_POINTWISE_YDESC = 753,
    CUDNN_ATTR_OPERATION_POINTWISE_ALPHA1 = 754,
    CUDNN_ATTR_OPERATION_POINTWISE_ALPHA2 = 755,
    CUDNN_ATTR_OPERATION_POINTWISE_DXDESC = 756,
    CUDNN_ATTR_OPERATION_POINTWISE_DYDESC = 757,
    CUDNN_ATTR_OPERATION_GENSTATS_MODE = 770,
    CUDNN_ATTR_OPERATION_GENSTATS_MATH_PREC = 771,
    CUDNN_ATTR_OPERATION_GENSTATS_XDESC = 772,
    CUDNN_ATTR_OPERATION_GENSTATS_SUMDESC = 773,
    CUDNN_ATTR_OPERATION_GENSTATS_SQSUMDESC = 774,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_STATS_MODE = 780,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_MATH_PREC = 781,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_Y_SUM_DESC = 782,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_Y_SQ_SUM_DESC = 783,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_SCALE_DESC = 784,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_BIAS_DESC = 785,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_PREV_RUNNING_MEAN_DESC = 786,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_PREV_RUNNING_VAR_DESC = 787,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_UPDATED_RUNNING_MEAN_DESC = 788,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_UPDATED_RUNNING_VAR_DESC = 789,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_SAVED_MEAN_DESC = 790,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_SAVED_INV_STD_DESC = 791,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EQ_SCALE_DESC = 792,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EQ_BIAS_DESC = 793,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_ACCUM_COUNT_DESC = 794,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EPSILON_DESC = 795,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EXP_AVERATE_FACTOR_DESC = 796,
    CUDNN_ATTR_OPERATIONGRAPH_HANDLE = 800,
    CUDNN_ATTR_OPERATIONGRAPH_OPS = 801,
    CUDNN_ATTR_OPERATIONGRAPH_ENGINE_GLOBAL_COUNT = 802,
    CUDNN_ATTR_TENSOR_BYTE_ALIGNMENT = 900,
    CUDNN_ATTR_TENSOR_DATA_TYPE = 901,
    CUDNN_ATTR_TENSOR_DIMENSIONS = 902,
    CUDNN_ATTR_TENSOR_STRIDES = 903,
    CUDNN_ATTR_TENSOR_VECTOR_COUNT = 904,
    CUDNN_ATTR_TENSOR_VECTORIZED_DIMENSION = 905,
    CUDNN_ATTR_TENSOR_UNIQUE_ID = 906,
    CUDNN_ATTR_TENSOR_IS_VIRTUAL = 907,
    CUDNN_ATTR_TENSOR_IS_BY_VALUE = 908,
    CUDNN_ATTR_VARIANT_PACK_UNIQUE_IDS = 1000,
    CUDNN_ATTR_VARIANT_PACK_DATA_POINTERS = 1001,
    CUDNN_ATTR_VARIANT_PACK_INTERMEDIATES = 1002,
    CUDNN_ATTR_VARIANT_PACK_WORKSPACE = 1003,
    CUDNN_ATTR_LAYOUT_INFO_TENSOR_UID = 1100,
    CUDNN_ATTR_LAYOUT_INFO_TYPES = 1101,
    CUDNN_ATTR_KNOB_INFO_TYPE = 1200,
    CUDNN_ATTR_KNOB_INFO_MAXIMUM_VALUE = 1201,
    CUDNN_ATTR_KNOB_INFO_MINIMUM_VALUE = 1202,
    CUDNN_ATTR_KNOB_INFO_STRIDE = 1203,
    CUDNN_ATTR_ENGINE_OPERATION_GRAPH = 1300,
    CUDNN_ATTR_ENGINE_GLOBAL_INDEX = 1301,
    CUDNN_ATTR_ENGINE_KNOB_INFO = 1302,
    CUDNN_ATTR_ENGINE_NUMERICAL_NOTE = 1303,
    CUDNN_ATTR_ENGINE_LAYOUT_INFO = 1304,
    CUDNN_ATTR_ENGINE_BEHAVIOR_NOTE = 1305,
    CUDNN_ATTR_MATMUL_COMP_TYPE = 1500,
    CUDNN_ATTR_OPERATION_MATMUL_ADESC = 1520,
    CUDNN_ATTR_OPERATION_MATMUL_BDESC = 1521,
    CUDNN_ATTR_OPERATION_MATMUL_CDESC = 1522,
    CUDNN_ATTR_OPERATION_MATMUL_DESC = 1523,
    CUDNN_ATTR_OPERATION_MATMUL_IRREGULARLY_STRIDED_BATCH_COUNT = 1524,
    CUDNN_ATTR_REDUCTION_OPERATOR = 1600,
    CUDNN_ATTR_REDUCTION_COMP_TYPE = 1601,
    CUDNN_ATTR_OPERATION_REDUCTION_XDESC = 1610,
    CUDNN_ATTR_OPERATION_REDUCTION_YDESC = 1611,
    CUDNN_ATTR_OPERATION_REDUCTION_DESC = 1612,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_MATH_PREC = 1620,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_MEAN_DESC = 1621,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_INVSTD_DESC = 1622,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_BN_SCALE_DESC = 1623,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_X_DESC = 1624,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_DY_DESC = 1625,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_DBN_SCALE_DESC = 1626,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_DBN_BIAS_DESC = 1627,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_EQ_DY_SCALE_DESC = 1628,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_EQ_X_SCALE_DESC = 1629,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_EQ_BIAS = 1630,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnBackendAttributeType_t {
    CUDNN_TYPE_HANDLE = 0,
    CUDNN_TYPE_DATA_TYPE = 1,
    CUDNN_TYPE_BOOLEAN = 2,
    CUDNN_TYPE_INT64 = 3,
    CUDNN_TYPE_FLOAT = 4,
    CUDNN_TYPE_DOUBLE = 5,
    CUDNN_TYPE_VOID_PTR = 6,
    CUDNN_TYPE_CONVOLUTION_MODE = 7,
    CUDNN_TYPE_HEUR_MODE = 8,
    CUDNN_TYPE_KNOB_TYPE = 9,
    CUDNN_TYPE_NAN_PROPOGATION = 10,
    CUDNN_TYPE_NUMERICAL_NOTE = 11,
    CUDNN_TYPE_LAYOUT_TYPE = 12,
    CUDNN_TYPE_ATTRIB_NAME = 13,
    CUDNN_TYPE_POINTWISE_MODE = 14,
    CUDNN_TYPE_BACKEND_DESCRIPTOR = 15,
    CUDNN_TYPE_GENSTATS_MODE = 16,
    CUDNN_TYPE_BN_FINALIZE_STATS_MODE = 17,
    CUDNN_TYPE_REDUCTION_OPERATOR_TYPE = 18,
    CUDNN_TYPE_BEHAVIOR_NOTE = 19,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnBackendDescriptorType_t {
    CUDNN_BACKEND_POINTWISE_DESCRIPTOR = 0,
    CUDNN_BACKEND_CONVOLUTION_DESCRIPTOR = 1,
    CUDNN_BACKEND_ENGINE_DESCRIPTOR = 2,
    CUDNN_BACKEND_ENGINECFG_DESCRIPTOR = 3,
    CUDNN_BACKEND_ENGINEHEUR_DESCRIPTOR = 4,
    CUDNN_BACKEND_EXECUTION_PLAN_DESCRIPTOR = 5,
    CUDNN_BACKEND_INTERMEDIATE_INFO_DESCRIPTOR = 6,
    CUDNN_BACKEND_KNOB_CHOICE_DESCRIPTOR = 7,
    CUDNN_BACKEND_KNOB_INFO_DESCRIPTOR = 8,
    CUDNN_BACKEND_LAYOUT_INFO_DESCRIPTOR = 9,
    CUDNN_BACKEND_OPERATION_CONVOLUTION_FORWARD_DESCRIPTOR = 10,
    CUDNN_BACKEND_OPERATION_CONVOLUTION_BACKWARD_FILTER_DESCRIPTOR = 11,
    CUDNN_BACKEND_OPERATION_CONVOLUTION_BACKWARD_DATA_DESCRIPTOR = 12,
    CUDNN_BACKEND_OPERATION_POINTWISE_DESCRIPTOR = 13,
    CUDNN_BACKEND_OPERATION_GEN_STATS_DESCRIPTOR = 14,
    CUDNN_BACKEND_OPERATIONGRAPH_DESCRIPTOR = 15,
    CUDNN_BACKEND_VARIANT_PACK_DESCRIPTOR = 16,
    CUDNN_BACKEND_TENSOR_DESCRIPTOR = 17,
    CUDNN_BACKEND_MATMUL_DESCRIPTOR = 18,
    CUDNN_BACKEND_OPERATION_MATMUL_DESCRIPTOR = 19,
    CUDNN_BACKEND_OPERATION_BN_FINALIZE_STATISTICS_DESCRIPTOR = 20,
    CUDNN_BACKEND_REDUCTION_DESCRIPTOR = 21,
    CUDNN_BACKEND_OPERATION_REDUCTION_DESCRIPTOR = 22,
    CUDNN_BACKEND_OPERATION_BN_BWD_WEIGHTS_DESCRIPTOR = 23,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnBackendNumericalNote_t {
    CUDNN_NUMERICAL_NOTE_TENSOR_CORE = 0,
    CUDNN_NUMERICAL_NOTE_DOWN_CONVERT_INPUTS = 1,
    CUDNN_NUMERICAL_NOTE_REDUCED_PRECISION_REDUCTION = 2,
    CUDNN_NUMERICAL_NOTE_FFT = 3,
    CUDNN_NUMERICAL_NOTE_NONDETERMINISTIC = 4,
    CUDNN_NUMERICAL_NOTE_WINOGRAD = 5,
    CUDNN_NUMERICAL_NOTE_TYPE_COUNT = 6,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnBackendBehaviorNote_t {
    CUDNN_BEHAVIOR_NOTE_RUNTIME_COMPILATION = 0,
    CUDNN_BEHAVIOR_NOTE_TYPE_COUNT = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnBackendKnobType_t {
    CUDNN_KNOB_TYPE_SPLIT_K = 0,
    CUDNN_KNOB_TYPE_SWIZZLE = 1,
    CUDNN_KNOB_TYPE_TILE_SIZE = 2,
    CUDNN_KNOB_TYPE_USE_TEX = 3,
    CUDNN_KNOB_TYPE_EDGE = 4,
    CUDNN_KNOB_TYPE_KBLOCK = 5,
    CUDNN_KNOB_TYPE_LDGA = 6,
    CUDNN_KNOB_TYPE_LDGB = 7,
    CUDNN_KNOB_TYPE_CHUNK_K = 8,
    CUDNN_KNOB_TYPE_SPLIT_H = 9,
    CUDNN_KNOB_TYPE_WINO_TILE = 10,
    CUDNN_KNOB_TYPE_MULTIPLY = 11,
    CUDNN_KNOB_TYPE_SPLIT_K_BUF = 12,
    CUDNN_KNOB_TYPE_TILEK = 13,
    CUDNN_KNOB_TYPE_STAGES = 14,
    CUDNN_KNOB_TYPE_REDUCTION_MODE = 15,
    CUDNN_KNOB_TYPE_CTA_SPLIT_K_MODE = 16,
    CUDNN_KNOB_TYPE_SPLIT_K_SLC = 17,
    CUDNN_KNOB_TYPE_IDX_MODE = 18,
    CUDNN_KNOB_TYPE_SLICED = 19,
    CUDNN_KNOB_TYPE_SPLIT_RS = 20,
    CUDNN_KNOB_TYPE_SINGLEBUFFER = 21,
    CUDNN_KNOB_TYPE_LDGC = 22,
    CUDNN_KNOB_TYPE_SPECFILT = 23,
    CUDNN_KNOB_TYPE_KERNEL_CFG = 24,
    CUDNN_KNOB_TYPE_COUNTS = 25,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnBackendLayoutType_t {
    CUDNN_LAYOUT_TYPE_PREFERRED_NCHW = 0,
    CUDNN_LAYOUT_TYPE_PREFERRED_NHWC = 1,
    CUDNN_LAYOUT_TYPE_PREFERRED_PAD4CK = 2,
    CUDNN_LAYOUT_TYPE_PREFERRED_PAD8CK = 3,
    CUDNN_LAYOUT_TYPE_COUNT = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cudnnBackendHeurMode_t {
    CUDNN_HEUR_MODE_INSTANT = 0,
    CUDNN_HEUR_MODE_B = 1,
    CUDNN_HEUR_MODES_COUNT = 2,
}
extern "C" {
    pub fn cudnnBackendCreateDescriptor(
        descriptorType: cudnnBackendDescriptorType_t,
        descriptor: *mut cudnnBackendDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBackendDestroyDescriptor(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBackendInitialize(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBackendFinalize(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBackendSetAttribute(
        descriptor: cudnnBackendDescriptor_t,
        attributeName: cudnnBackendAttributeName_t,
        attributeType: cudnnBackendAttributeType_t,
        elementCount: i64,
        arrayOfElements: *const ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBackendGetAttribute(
        descriptor: cudnnBackendDescriptor_t,
        attributeName: cudnnBackendAttributeName_t,
        attributeType: cudnnBackendAttributeType_t,
        requestedElementCount: i64,
        elementCount: *mut i64,
        arrayOfElements: *mut ::libc::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBackendExecute(
        handle: cudnnHandle_t,
        executionPlan: cudnnBackendDescriptor_t,
        variantPack: cudnnBackendDescriptor_t,
    ) -> cudnnStatus_t;
}
