#![warn(missing_docs)]

/*!
This crate provides shared, reference-counted, resizable buffers with copy-on-write behavior:

- [`RcVec<T>`] is analogous to `Rc<Vec<T>>`
- [`RcString`] is analogous to `Rc<String>`
- [`ArcString`] is analogous to `Arc<String>`

These structures are meant to fill a niche not covered by other containers:
- Unlike `Vec<T>` and `String`, they do not allocate a new buffer for every clone.
- Unlike `Rc<[T]>`,`Arc<[T]>`, `Rc<str>`, and `Arc<str>`, they can be mutated.
- Unlike `Rc<Vec<T>>`,`Arc<Vec<T>>`, `Rc<String>`, and `Arc<String>`, they only contain a single level of pointer indirection.

Mutability is enabled by copying the underlying buffer on mutable operations if there is
more than 1 reference to it. If there is not enough capacity for push operations, the buffer
is reallocated with a larger capacity. If there is only 1 reference, the buffer is then
mutated in place.
*/

mod arc_string;
mod rc_string;
mod rc_vec;
#[cfg(test)]
mod test;

pub use {arc_string::ArcString, rc_string::RcString, rc_vec::RcVec};
