// This file is automatically @generated.
#![allow(clippy::approx_constant, clippy::unreadable_literal)]
use crate::reflection_types::*;
use rbx_dom_weak::{
    BrickColor, ColorSequence, ColorSequenceKeypoint, NumberSequence, NumberSequenceKeypoint,
    RbxValue, RbxValueType, Rect,
};
use std::{borrow::Cow, collections::HashMap};
fn generate_ab_test_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ABTestService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_accessory() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Accessory"),
        superclass: Some(Cow::Borrowed("Accoutrement")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("AttachmentForward"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, -1.0],
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentPoint"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentPos"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentRight"),
                RbxValue::Vector3 {
                    value: [1.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentUp"),
                RbxValue::Vector3 {
                    value: [0.0, 1.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Accessory"),
                },
            );
            map
        },
    };
}
fn generate_accoutrement() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Accoutrement"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("AttachmentForward"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AttachmentForward"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentPoint"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AttachmentPoint"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentPos"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AttachmentPos"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentRight"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AttachmentRight"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentUp"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AttachmentUp"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("AttachmentForward"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, -1.0],
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentPoint"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentPos"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentRight"),
                RbxValue::Vector3 {
                    value: [1.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentUp"),
                RbxValue::Vector3 {
                    value: [0.0, 1.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Accoutrement"),
                },
            );
            map
        },
    };
}
fn generate_actor() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Actor"),
        superclass: Some(Cow::Borrowed("Model")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(Cow::Borrowed("LevelOfDetail"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Actor"),
                },
            );
            map.insert(Cow::Borrowed("PrimaryPart"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("WorldPivot"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map
        },
    };
}
fn generate_ad_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AdService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("AdService"),
                },
            );
            map
        },
    };
}
fn generate_advanced_dragger() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AdvancedDragger"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("AdvancedDragger"),
                },
            );
            map
        },
    };
}
fn generate_align_orientation() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AlignOrientation"),
        superclass: Some(Cow::Borrowed("Constraint")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(7);
            map.insert(
                Cow::Borrowed("AlignType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AlignType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("AlignType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxAngularVelocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxAngularVelocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxTorque"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxTorque"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PrimaryAxisOnly"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PrimaryAxisOnly"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ReactionTorqueEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ReactionTorqueEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Responsiveness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Responsiveness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RigidityEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RigidityEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(13);
            map.insert(Cow::Borrowed("AlignType"), RbxValue::Enum { value: 0 });
            map.insert(Cow::Borrowed("Attachment0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Attachment1"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("MaxAngularVelocity"),
                RbxValue::Float32 {
                    value: 1000000000.0,
                },
            );
            map.insert(
                Cow::Borrowed("MaxTorque"),
                RbxValue::Float32 { value: 10000.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("AlignOrientation"),
                },
            );
            map.insert(
                Cow::Borrowed("PrimaryAxisOnly"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("ReactionTorqueEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("Responsiveness"),
                RbxValue::Float32 { value: 10.0 },
            );
            map.insert(
                Cow::Borrowed("RigidityEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: false });
            map
        },
    };
}
fn generate_align_position() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AlignPosition"),
        superclass: Some(Cow::Borrowed("Constraint")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("ApplyAtCenterOfMass"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ApplyAtCenterOfMass"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxForce"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxForce"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxVelocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxVelocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ReactionForceEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ReactionForceEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Responsiveness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Responsiveness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RigidityEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RigidityEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(12);
            map.insert(
                Cow::Borrowed("ApplyAtCenterOfMass"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("Attachment0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Attachment1"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(194).unwrap(),
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("MaxForce"),
                RbxValue::Float32 { value: 10000.0 },
            );
            map.insert(
                Cow::Borrowed("MaxVelocity"),
                RbxValue::Float32 {
                    value: 1000000000.0,
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("AlignPosition"),
                },
            );
            map.insert(
                Cow::Borrowed("ReactionForceEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("Responsiveness"),
                RbxValue::Float32 { value: 10.0 },
            );
            map.insert(
                Cow::Borrowed("RigidityEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: false });
            map
        },
    };
}
fn generate_analystics_settings() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AnalysticsSettings"),
        superclass: Some(Cow::Borrowed("GenericSettings")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_analytics_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AnalyticsService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("ApiKey"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ApiKey"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::DEPRECATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("AnalyticsService"),
                },
            );
            map
        },
    };
}
fn generate_angular_velocity() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AngularVelocity"),
        superclass: Some(Cow::Borrowed("Constraint")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("AngularVelocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngularVelocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxTorque"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxTorque"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ReactionTorqueEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ReactionTorqueEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RelativeTo"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RelativeTo"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "ActuatorRelativeTo",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(10);
            map.insert(
                Cow::Borrowed("AngularVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("Attachment0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Attachment1"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("MaxTorque"), RbxValue::Float32 { value: 0.0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("AngularVelocity"),
                },
            );
            map.insert(
                Cow::Borrowed("ReactionTorqueEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("RelativeTo"), RbxValue::Enum { value: 2 });
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: false });
            map
        },
    };
}
fn generate_animation() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Animation"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("AnimationId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AnimationId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("AnimationId"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Animation"),
                },
            );
            map
        },
    };
}
fn generate_animation_controller() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AnimationController"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("AnimationController"),
                },
            );
            map
        },
    };
}
fn generate_animation_track() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AnimationTrack"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(9);
            map.insert(
                Cow::Borrowed("Animation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Animation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("IsPlaying"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsPlaying"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Length"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Length"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Looped"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Looped"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Priority"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Priority"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("AnimationPriority")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Speed"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Speed"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("TimePosition"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TimePosition"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("WeightCurrent"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WeightCurrent"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("WeightTarget"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WeightTarget"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_animator() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Animator"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Animator"),
                },
            );
            map
        },
    };
}
fn generate_app_storage_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AppStorageService"),
        superclass: Some(Cow::Borrowed("LocalStorageService")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_app_update_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AppUpdateService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_arc_handles() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ArcHandles"),
        superclass: Some(Cow::Borrowed("HandlesBase")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Axes"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Axes"),
                    value_type: RbxPropertyTypeDescriptor::UnimplementedType(Cow::Borrowed("Axes")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(Cow::Borrowed("Adornee"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("Color3"),
                RbxValue::Color3 {
                    value: [0.050980397, 0.41176474, 0.6745098],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ArcHandles"),
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map
        },
    };
}
fn generate_asset_counter_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AssetCounterService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_asset_delivery_proxy() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AssetDeliveryProxy"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_asset_manager_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AssetManagerService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_asset_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AssetService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("AssetService"),
                },
            );
            map
        },
    };
}
fn generate_atmosphere() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Atmosphere"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("Color"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Color"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Decay"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Decay"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Density"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Density"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Glare"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Glare"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Haze"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Haze"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Offset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Offset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(7);
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::Color3 {
                    value: [0.7843, 0.6667, 0.4235],
                },
            );
            map.insert(
                Cow::Borrowed("Decay"),
                RbxValue::Color3 {
                    value: [0.3608, 0.2353, 0.0549],
                },
            );
            map.insert(Cow::Borrowed("Density"), RbxValue::Float32 { value: 0.395 });
            map.insert(Cow::Borrowed("Glare"), RbxValue::Float32 { value: 0.0 });
            map.insert(Cow::Borrowed("Haze"), RbxValue::Float32 { value: 0.0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Atmosphere"),
                },
            );
            map.insert(Cow::Borrowed("Offset"), RbxValue::Float32 { value: 0.0 });
            map
        },
    };
}
fn generate_attachment() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Attachment"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(13);
            map.insert(
                Cow::Borrowed("Axis"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Axis"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CFrame"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Orientation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Position"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Rotation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("SecondaryAxis"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SecondaryAxis"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Visible"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Visible"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("WorldAxis"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WorldAxis"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("WorldCFrame"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WorldCFrame"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("WorldOrientation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WorldOrientation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("WorldPosition"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WorldPosition"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("WorldRotation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WorldRotation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("WorldSecondaryAxis"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WorldSecondaryAxis"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(13);
            map.insert(
                Cow::Borrowed("Axis"),
                RbxValue::Vector3 {
                    value: [1.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Attachment"),
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("SecondaryAxis"),
                RbxValue::Vector3 {
                    value: [0.0, 1.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("WorldAxis"),
                RbxValue::Vector3 {
                    value: [1.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("WorldCFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("WorldOrientation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("WorldPosition"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("WorldSecondaryAxis"),
                RbxValue::Vector3 {
                    value: [0.0, 1.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_avatar_editor_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AvatarEditorService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("AvatarEditorService"),
                },
            );
            map
        },
    };
}
fn generate_avatar_import_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("AvatarImportService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_backpack() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Backpack"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Backpack"),
                },
            );
            map
        },
    };
}
fn generate_backpack_item() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BackpackItem"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("TextureId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TextureId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_badge_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BadgeService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("BadgeService"),
                },
            );
            map
        },
    };
}
fn generate_ball_socket_constraint() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BallSocketConstraint"),
        superclass: Some(Cow::Borrowed("Constraint")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(8);
            map.insert(
                Cow::Borrowed("LimitsEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LimitsEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxFrictionTorque"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxFrictionTorque"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Radius"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Radius"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Restitution"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Restitution"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TwistLimitsEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TwistLimitsEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TwistLowerAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TwistLowerAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TwistUpperAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TwistUpperAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("UpperAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UpperAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(14);
            map.insert(Cow::Borrowed("Attachment0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Attachment1"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(1009).unwrap(),
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("LimitsEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("MaxFrictionTorque"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("BallSocketConstraint"),
                },
            );
            map.insert(Cow::Borrowed("Radius"), RbxValue::Float32 { value: 0.15 });
            map.insert(
                Cow::Borrowed("Restitution"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("TwistLimitsEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("TwistLowerAngle"),
                RbxValue::Float32 { value: -45.0 },
            );
            map.insert(
                Cow::Borrowed("TwistUpperAngle"),
                RbxValue::Float32 { value: 45.0 },
            );
            map.insert(
                Cow::Borrowed("UpperAngle"),
                RbxValue::Float32 { value: 45.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: false });
            map
        },
    };
}
fn generate_base_part() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BasePart"),
        superclass: Some(Cow::Borrowed("PVInstance")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(64);
            map.insert(
                Cow::Borrowed("Anchored"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Anchored"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AssemblyAngularVelocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AssemblyAngularVelocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AssemblyCenterOfMass"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AssemblyCenterOfMass"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AssemblyLinearVelocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AssemblyLinearVelocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AssemblyMass"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AssemblyMass"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AssemblyRootPart"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AssemblyRootPart"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("BackParamA"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BackParamA"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BackParamB"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BackParamB"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BackSurface"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BackSurface"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("SurfaceType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BackSurfaceInput"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BackSurfaceInput"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("InputType")),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BottomParamA"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BottomParamA"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BottomParamB"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BottomParamB"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BottomSurface"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BottomSurface"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("SurfaceType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BottomSurfaceInput"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BottomSurfaceInput"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("InputType")),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BrickColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BrickColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Color")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CFrame"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CanCollide"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CanCollide"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CanTouch"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CanTouch"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CastShadow"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CastShadow"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CenterOfMass"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CenterOfMass"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("CollisionGroupId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CollisionGroupId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CollisionGroups"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CollisionGroups"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Custom,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Color"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: Some(Cow::Borrowed("Color3uint8")),
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Color3uint8"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Color3uint8"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3uint8),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Color")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("CustomPhysicalProperties"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CustomPhysicalProperties"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::PhysicalProperties),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Elasticity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Elasticity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Friction"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Friction"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("FrontParamA"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FrontParamA"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FrontParamB"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FrontParamB"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FrontSurface"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FrontSurface"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("SurfaceType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FrontSurfaceInput"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FrontSurfaceInput"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("InputType")),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LeftParamA"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftParamA"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LeftParamB"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftParamB"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LeftSurface"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftSurface"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("SurfaceType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LeftSurfaceInput"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftSurfaceInput"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("InputType")),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LocalTransparencyModifier"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LocalTransparencyModifier"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Locked"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Locked"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Mass"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Mass"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Massless"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Massless"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Material"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Material"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("Material")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Orientation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PivotOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PivotOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Position"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ReceiveAge"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ReceiveAge"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Reflectance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Reflectance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ResizeIncrement"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ResizeIncrement"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ResizeableFaces"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ResizeableFaces"),
                    value_type: RbxPropertyTypeDescriptor::UnimplementedType(Cow::Borrowed(
                        "Faces",
                    )),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RightParamA"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightParamA"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RightParamB"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightParamB"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RightSurface"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightSurface"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("SurfaceType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RightSurfaceInput"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightSurfaceInput"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("InputType")),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RootPriority"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RootPriority"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RotVelocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RotVelocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Rotation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Size"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: Some(Cow::Borrowed("size")),
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SpecificGravity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SpecificGravity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("TopParamA"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TopParamA"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TopParamB"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TopParamB"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TopSurface"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TopSurface"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("SurfaceType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TopSurfaceInput"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TopSurfaceInput"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("InputType")),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Transparency"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Velocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Velocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("brickColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("brickColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Color")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("size"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("size"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Size")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_base_player_gui() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BasePlayerGui"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_base_script() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BaseScript"),
        superclass: Some(Cow::Borrowed("LuaSourceContainer")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Disabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Disabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LinkedSource"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LinkedSource"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_base_wrap() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BaseWrap"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("CageMeshId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CageMeshId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CageOrigin"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CageOrigin"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CageOriginWorld"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CageOriginWorld"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ImportOrigin"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ImportOrigin"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ImportOriginWorld"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ImportOriginWorld"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_beam() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Beam"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(18);
            map.insert(
                Cow::Borrowed("Attachment0"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Attachment0"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Attachment1"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Attachment1"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Color"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::ColorSequence),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CurveSize0"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CurveSize0"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CurveSize1"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CurveSize1"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FaceCamera"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FaceCamera"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LightEmission"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LightEmission"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LightInfluence"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LightInfluence"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Segments"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Segments"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Texture"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Texture"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TextureLength"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TextureLength"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TextureMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TextureMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("TextureMode")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TextureSpeed"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TextureSpeed"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Transparency"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::NumberSequence),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Width0"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Width0"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Width1"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Width1"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ZOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ZOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(19);
            map.insert(Cow::Borrowed("Attachment0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Attachment1"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::ColorSequence {
                    value: ColorSequence {
                        keypoints: vec![
                            ColorSequenceKeypoint {
                                time: 0.0,
                                color: [1.0, 1.0, 1.0],
                            },
                            ColorSequenceKeypoint {
                                time: 1.0,
                                color: [1.0, 1.0, 1.0],
                            },
                        ],
                    },
                },
            );
            map.insert(
                Cow::Borrowed("CurveSize0"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("CurveSize1"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("FaceCamera"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("LightEmission"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("LightInfluence"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Beam"),
                },
            );
            map.insert(Cow::Borrowed("Segments"), RbxValue::Int32 { value: 10 });
            map.insert(
                Cow::Borrowed("Texture"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("TextureLength"),
                RbxValue::Float32 { value: 1.0 },
            );
            map.insert(Cow::Borrowed("TextureMode"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("TextureSpeed"),
                RbxValue::Float32 { value: 1.0 },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::NumberSequence {
                    value: NumberSequence {
                        keypoints: vec![
                            NumberSequenceKeypoint {
                                time: 0.0,
                                value: 0.5,
                                envelope: 0.0,
                            },
                            NumberSequenceKeypoint {
                                time: 1.0,
                                value: 0.5,
                                envelope: 0.0,
                            },
                        ],
                    },
                },
            );
            map.insert(Cow::Borrowed("Width0"), RbxValue::Float32 { value: 1.0 });
            map.insert(Cow::Borrowed("Width1"), RbxValue::Float32 { value: 1.0 });
            map.insert(Cow::Borrowed("ZOffset"), RbxValue::Float32 { value: 0.0 });
            map
        },
    };
}
fn generate_bevel_mesh() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BevelMesh"),
        superclass: Some(Cow::Borrowed("DataModelMesh")),
        tags: RbxInstanceTags::DEPRECATED
            | RbxInstanceTags::NOT_BROWSABLE
            | RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_billboard_gui() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BillboardGui"),
        superclass: Some(Cow::Borrowed("LayerCollector")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(18);
            map.insert(
                Cow::Borrowed("Active"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Active"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Adornee"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Adornee"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AlwaysOnTop"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AlwaysOnTop"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Brightness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Brightness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ClipsDescendants"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ClipsDescendants"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CurrentDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CurrentDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("DistanceLowerLimit"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DistanceLowerLimit"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DistanceStep"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DistanceStep"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DistanceUpperLimit"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DistanceUpperLimit"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ExtentsOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ExtentsOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ExtentsOffsetWorldSpace"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ExtentsOffsetWorldSpace"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LightInfluence"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LightInfluence"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PlayerToHideFrom"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PlayerToHideFrom"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Size"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::UDim2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SizeOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SizeOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("StudsOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("StudsOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("StudsOffsetWorldSpace"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("StudsOffsetWorldSpace"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(24);
            map.insert(Cow::Borrowed("Active"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Adornee"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("AlwaysOnTop"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("AutoLocalize"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("Brightness"),
                RbxValue::Float32 { value: 1.0 },
            );
            map.insert(
                Cow::Borrowed("ClipsDescendants"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("DistanceLowerLimit"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("DistanceStep"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("DistanceUpperLimit"),
                RbxValue::Float32 { value: -1.0 },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("ExtentsOffset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("ExtentsOffsetWorldSpace"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("LightInfluence"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Localize"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("MaxDistance"),
                RbxValue::Float32 {
                    value: 1000000000.0,
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("BillboardGui"),
                },
            );
            map.insert(
                Cow::Borrowed("PlayerToHideFrom"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("ResetOnSpawn"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("RootLocalizationTable"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::UDim2 {
                    value: (0.0, 0, 0.0, 0),
                },
            );
            map.insert(
                Cow::Borrowed("SizeOffset"),
                RbxValue::Vector2 { value: [0.0, 0.0] },
            );
            map.insert(
                Cow::Borrowed("StudsOffset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("StudsOffsetWorldSpace"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("ZIndexBehavior"), RbxValue::Enum { value: 0 });
            map
        },
    };
}
fn generate_binary_string_value() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BinaryStringValue"),
        superclass: Some(Cow::Borrowed("ValueBase")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Value"),
                },
            );
            map
        },
    };
}
fn generate_bindable_event() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BindableEvent"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Event"),
                },
            );
            map
        },
    };
}
fn generate_bindable_function() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BindableFunction"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Function"),
                },
            );
            map
        },
    };
}
fn generate_block_mesh() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BlockMesh"),
        superclass: Some(Cow::Borrowed("BevelMesh")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Mesh"),
                },
            );
            map.insert(
                Cow::Borrowed("Offset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Scale"),
                RbxValue::Vector3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("VertexColor"),
                RbxValue::Vector3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map
        },
    };
}
fn generate_bloom_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BloomEffect"),
        superclass: Some(Cow::Borrowed("PostEffect")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("Intensity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Intensity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Size"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Threshold"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Threshold"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("Intensity"), RbxValue::Float32 { value: 0.4 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Bloom"),
                },
            );
            map.insert(Cow::Borrowed("Size"), RbxValue::Float32 { value: 24.0 });
            map.insert(
                Cow::Borrowed("Threshold"),
                RbxValue::Float32 { value: 0.95 },
            );
            map
        },
    };
}
fn generate_blur_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BlurEffect"),
        superclass: Some(Cow::Borrowed("PostEffect")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Size"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Size"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Blur"),
                },
            );
            map.insert(Cow::Borrowed("Size"), RbxValue::Float32 { value: 24.0 });
            map
        },
    };
}
fn generate_body_angular_velocity() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BodyAngularVelocity"),
        superclass: Some(Cow::Borrowed("BodyMover")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("AngularVelocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngularVelocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxTorque"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxTorque"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("P"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("P"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("angularvelocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("angularvelocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("AngularVelocity")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("maxTorque"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("maxTorque"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("MaxTorque")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("AngularVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 2.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("MaxTorque"),
                RbxValue::Vector3 {
                    value: [4000.0, 4000.0, 4000.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("BodyAngularVelocity"),
                },
            );
            map.insert(Cow::Borrowed("P"), RbxValue::Float32 { value: 1250.0 });
            map
        },
    };
}
fn generate_body_colors() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BodyColors"),
        superclass: Some(Cow::Borrowed("CharacterAppearance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(12);
            map.insert(
                Cow::Borrowed("HeadColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HeadColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("HeadColor3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HeadColor3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LeftArmColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftArmColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("LeftArmColor3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftArmColor3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LeftLegColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftLegColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("LeftLegColor3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftLegColor3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RightArmColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightArmColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RightArmColor3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightArmColor3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RightLegColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightLegColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RightLegColor3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightLegColor3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TorsoColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TorsoColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("TorsoColor3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TorsoColor3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(13);
            map.insert(
                Cow::Borrowed("HeadColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(226).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("HeadColor3"),
                RbxValue::Color3 {
                    value: [0.9921569, 0.9176471, 0.5529412],
                },
            );
            map.insert(
                Cow::Borrowed("LeftArmColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(226).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("LeftArmColor3"),
                RbxValue::Color3 {
                    value: [0.9921569, 0.9176471, 0.5529412],
                },
            );
            map.insert(
                Cow::Borrowed("LeftLegColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("LeftLegColor3"),
                RbxValue::Color3 {
                    value: [0.050980397, 0.41176474, 0.6745098],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Body Colors"),
                },
            );
            map.insert(
                Cow::Borrowed("RightArmColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(226).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("RightArmColor3"),
                RbxValue::Color3 {
                    value: [0.9921569, 0.9176471, 0.5529412],
                },
            );
            map.insert(
                Cow::Borrowed("RightLegColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("RightLegColor3"),
                RbxValue::Color3 {
                    value: [0.050980397, 0.41176474, 0.6745098],
                },
            );
            map.insert(
                Cow::Borrowed("TorsoColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(28).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("TorsoColor3"),
                RbxValue::Color3 {
                    value: [0.15686275, 0.49803925, 0.2784314],
                },
            );
            map
        },
    };
}
fn generate_body_force() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BodyForce"),
        superclass: Some(Cow::Borrowed("BodyMover")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Force"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Force"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("force"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("force"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Force")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Force"),
                RbxValue::Vector3 {
                    value: [0.0, 1.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("BodyForce"),
                },
            );
            map
        },
    };
}
fn generate_body_gyro() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BodyGyro"),
        superclass: Some(Cow::Borrowed("BodyMover")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CFrame"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("D"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("D"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxTorque"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxTorque"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("P"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("P"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("cframe"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("cframe"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("CFrame")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("maxTorque"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("maxTorque"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("MaxTorque")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("D"), RbxValue::Float32 { value: 500.0 });
            map.insert(
                Cow::Borrowed("MaxTorque"),
                RbxValue::Vector3 {
                    value: [400000.0, 0.0, 400000.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("BodyGyro"),
                },
            );
            map.insert(Cow::Borrowed("P"), RbxValue::Float32 { value: 3000.0 });
            map
        },
    };
}
fn generate_body_mover() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BodyMover"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_body_position() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BodyPosition"),
        superclass: Some(Cow::Borrowed("BodyMover")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("D"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("D"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxForce"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxForce"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("P"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("P"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Position"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("maxForce"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("maxForce"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("MaxForce")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("position"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("position"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Position")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(Cow::Borrowed("D"), RbxValue::Float32 { value: 1250.0 });
            map.insert(
                Cow::Borrowed("MaxForce"),
                RbxValue::Vector3 {
                    value: [4000.0, 4000.0, 4000.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("BodyPosition"),
                },
            );
            map.insert(Cow::Borrowed("P"), RbxValue::Float32 { value: 10000.0 });
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::Vector3 {
                    value: [0.0, 50.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_body_thrust() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BodyThrust"),
        superclass: Some(Cow::Borrowed("BodyMover")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("Force"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Force"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Location"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Location"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("force"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("force"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Force")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("location"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("location"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Location")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("Force"),
                RbxValue::Vector3 {
                    value: [0.0, 1.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Location"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("BodyThrust"),
                },
            );
            map
        },
    };
}
fn generate_body_velocity() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BodyVelocity"),
        superclass: Some(Cow::Borrowed("BodyMover")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("MaxForce"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxForce"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("P"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("P"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Velocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Velocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("maxForce"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("maxForce"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("MaxForce")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("velocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("velocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Velocity")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("MaxForce"),
                RbxValue::Vector3 {
                    value: [4000.0, 4000.0, 4000.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("BodyVelocity"),
                },
            );
            map.insert(Cow::Borrowed("P"), RbxValue::Float32 { value: 1250.0 });
            map.insert(
                Cow::Borrowed("Velocity"),
                RbxValue::Vector3 {
                    value: [0.0, 2.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_bone() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Bone"),
        superclass: Some(Cow::Borrowed("Attachment")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("Transform"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Transform"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("TransformedCFrame"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TransformedCFrame"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("TransformedWorldCFrame"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TransformedWorldCFrame"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(14);
            map.insert(
                Cow::Borrowed("Axis"),
                RbxValue::Vector3 {
                    value: [1.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Bone"),
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("SecondaryAxis"),
                RbxValue::Vector3 {
                    value: [0.0, 1.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Transform"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("WorldAxis"),
                RbxValue::Vector3 {
                    value: [1.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("WorldCFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("WorldOrientation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("WorldPosition"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("WorldSecondaryAxis"),
                RbxValue::Vector3 {
                    value: [0.0, 1.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_bool_value() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BoolValue"),
        superclass: Some(Cow::Borrowed("ValueBase")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Value"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Value"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Value"),
                },
            );
            map.insert(Cow::Borrowed("Value"), RbxValue::Bool { value: false });
            map
        },
    };
}
fn generate_box_handle_adornment() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BoxHandleAdornment"),
        superclass: Some(Cow::Borrowed("HandleAdornment")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Size"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Size"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(12);
            map.insert(
                Cow::Borrowed("AdornCullingMode"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("Adornee"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("AlwaysOnTop"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("Color3"),
                RbxValue::Color3 {
                    value: [0.050980397, 0.41176474, 0.6745098],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("BoxHandleAdornment"),
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::Vector3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("SizeRelativeOffset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("ZIndex"), RbxValue::Int32 { value: -1 });
            map
        },
    };
}
fn generate_brick_color_value() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BrickColorValue"),
        superclass: Some(Cow::Borrowed("ValueBase")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Value"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Value"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Value"),
                },
            );
            map.insert(
                Cow::Borrowed("Value"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(194).unwrap(),
                },
            );
            map
        },
    };
}
fn generate_browser_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BrowserService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_bulk_import_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("BulkImportService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_c_frame_value() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CFrameValue"),
        superclass: Some(Cow::Borrowed("ValueBase")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Value"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Value"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Value"),
                },
            );
            map.insert(
                Cow::Borrowed("Value"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map
        },
    };
}
fn generate_csg_dictionary_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CSGDictionaryService"),
        superclass: Some(Cow::Borrowed("FlyweightService")),
        tags: RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_cacheable_content_provider() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CacheableContentProvider"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_callout_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CalloutService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_camera() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Camera"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(14);
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CFrame"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CameraSubject"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CameraSubject"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CameraType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CameraType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("CameraType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CoordinateFrame"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CoordinateFrame"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("CFrame")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("DiagonalFieldOfView"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DiagonalFieldOfView"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("FieldOfView"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FieldOfView"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FieldOfViewMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FieldOfViewMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("FieldOfViewMode")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Focus"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Focus"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HeadLocked"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HeadLocked"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HeadScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HeadScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxAxisFieldOfView"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxAxisFieldOfView"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("NearPlaneZ"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("NearPlaneZ"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ViewportSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ViewportSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("focus"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("focus"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Focus")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(11);
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [
                        0.0, 20.0, 20.0, 1.0, 0.0, 0.0, 0.0, 0.7071068, 0.7071068, 0.0, -0.7071068,
                        0.7071068,
                    ],
                },
            );
            map.insert(
                Cow::Borrowed("CameraSubject"),
                RbxValue::Ref { value: None },
            );
            map.insert(Cow::Borrowed("CameraType"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("DiagonalFieldOfView"),
                RbxValue::Float32 { value: 88.87653 },
            );
            map.insert(
                Cow::Borrowed("FieldOfView"),
                RbxValue::Float32 { value: 70.0 },
            );
            map.insert(
                Cow::Borrowed("FieldOfViewMode"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Focus"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, -5.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("HeadLocked"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("HeadScale"), RbxValue::Float32 { value: 1.0 });
            map.insert(
                Cow::Borrowed("MaxAxisFieldOfView"),
                RbxValue::Float32 { value: 70.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Camera"),
                },
            );
            map
        },
    };
}
fn generate_catalog_pages() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CatalogPages"),
        superclass: Some(Cow::Borrowed("Pages")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_change_history_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ChangeHistoryService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ChangeHistoryService"),
                },
            );
            map
        },
    };
}
fn generate_character_appearance() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CharacterAppearance"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_character_mesh() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CharacterMesh"),
        superclass: Some(Cow::Borrowed("CharacterAppearance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("BaseTextureId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BaseTextureId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BodyPart"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BodyPart"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("BodyPart")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MeshId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MeshId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("OverlayTextureId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("OverlayTextureId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(Cow::Borrowed("BaseTextureId"), RbxValue::Int64 { value: 0 });
            map.insert(Cow::Borrowed("BodyPart"), RbxValue::Enum { value: 0 });
            map.insert(Cow::Borrowed("MeshId"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("CharacterMesh"),
                },
            );
            map.insert(
                Cow::Borrowed("OverlayTextureId"),
                RbxValue::Int64 { value: 0 },
            );
            map
        },
    };
}
fn generate_chat() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Chat"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("BubbleChatEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BubbleChatEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LoadDefaultChat"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LoadDefaultChat"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("BubbleChatEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("LoadDefaultChat"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Chat"),
                },
            );
            map
        },
    };
}
fn generate_chorus_sound_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ChorusSoundEffect"),
        superclass: Some(Cow::Borrowed("SoundEffect")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("Depth"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Depth"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Mix"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Mix"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Rate"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Rate"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(Cow::Borrowed("Depth"), RbxValue::Float32 { value: 0.15 });
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("Mix"), RbxValue::Float32 { value: 0.5 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ChorusSoundEffect"),
                },
            );
            map.insert(Cow::Borrowed("Priority"), RbxValue::Int32 { value: 0 });
            map.insert(Cow::Borrowed("Rate"), RbxValue::Float32 { value: 0.5 });
            map
        },
    };
}
fn generate_click_detector() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ClickDetector"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("CursorIcon"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CursorIcon"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxActivationDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxActivationDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("CursorIcon"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("MaxActivationDistance"),
                RbxValue::Float32 { value: 32.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ClickDetector"),
                },
            );
            map
        },
    };
}
fn generate_client_replicator() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ClientReplicator"),
        superclass: Some(Cow::Borrowed("NetworkReplicator")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_clothing() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Clothing"),
        superclass: Some(Cow::Borrowed("CharacterAppearance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Color3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Color3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_clouds() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Clouds"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Cover"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Cover"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Density"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Density"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(Cow::Borrowed("Cover"), RbxValue::Float32 { value: 0.5 });
            map.insert(Cow::Borrowed("Density"), RbxValue::Float32 { value: 0.7 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Clouds"),
                },
            );
            map
        },
    };
}
fn generate_cluster_packet_cache() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ClusterPacketCache"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_collection_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CollectionService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("CollectionService"),
                },
            );
            map
        },
    };
}
fn generate_color3_value() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Color3Value"),
        superclass: Some(Cow::Borrowed("ValueBase")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Value"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Value"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Value"),
                },
            );
            map.insert(
                Cow::Borrowed("Value"),
                RbxValue::Color3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_color_correction_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ColorCorrectionEffect"),
        superclass: Some(Cow::Borrowed("PostEffect")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("Brightness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Brightness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Contrast"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Contrast"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Saturation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Saturation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TintColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TintColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("Brightness"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Contrast"), RbxValue::Float32 { value: 0.0 });
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ColorCorrection"),
                },
            );
            map.insert(
                Cow::Borrowed("Saturation"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("TintColor"),
                RbxValue::Color3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map
        },
    };
}
fn generate_compressor_sound_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CompressorSoundEffect"),
        superclass: Some(Cow::Borrowed("SoundEffect")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("Attack"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Attack"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("GainMakeup"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GainMakeup"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Ratio"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Ratio"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Release"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Release"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SideChain"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SideChain"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Threshold"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Threshold"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(9);
            map.insert(Cow::Borrowed("Attack"), RbxValue::Float32 { value: 0.1 });
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("GainMakeup"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("CompressorSoundEffect"),
                },
            );
            map.insert(Cow::Borrowed("Priority"), RbxValue::Int32 { value: 0 });
            map.insert(Cow::Borrowed("Ratio"), RbxValue::Float32 { value: 40.0 });
            map.insert(Cow::Borrowed("Release"), RbxValue::Float32 { value: 0.1 });
            map.insert(Cow::Borrowed("SideChain"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Threshold"),
                RbxValue::Float32 { value: -40.0 },
            );
            map
        },
    };
}
fn generate_cone_handle_adornment() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ConeHandleAdornment"),
        superclass: Some(Cow::Borrowed("HandleAdornment")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Height"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Height"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Radius"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Radius"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(13);
            map.insert(
                Cow::Borrowed("AdornCullingMode"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("Adornee"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("AlwaysOnTop"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("Color3"),
                RbxValue::Color3 {
                    value: [0.050980397, 0.41176474, 0.6745098],
                },
            );
            map.insert(Cow::Borrowed("Height"), RbxValue::Float32 { value: 2.0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ConeHandleAdornment"),
                },
            );
            map.insert(Cow::Borrowed("Radius"), RbxValue::Float32 { value: 0.5 });
            map.insert(
                Cow::Borrowed("SizeRelativeOffset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("ZIndex"), RbxValue::Int32 { value: -1 });
            map
        },
    };
}
fn generate_configuration() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Configuration"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Configuration"),
                },
            );
            map
        },
    };
}
fn generate_constraint() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Constraint"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("Active"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Active"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Attachment0"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Attachment0"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Attachment1"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Attachment1"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Color"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Visible"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Visible"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_content_provider() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ContentProvider"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("BaseUrl"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BaseUrl"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RequestQueueSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RequestQueueSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ContentProvider"),
                },
            );
            map
        },
    };
}
fn generate_context_action_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ContextActionService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ContextActionService"),
                },
            );
            map
        },
    };
}
fn generate_controller() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Controller"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_controller_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ControllerService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_cookies_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CookiesService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("CookiesService"),
                },
            );
            map
        },
    };
}
fn generate_core_gui() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CoreGui"),
        superclass: Some(Cow::Borrowed("BasePlayerGui")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("SelectionImageObject"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SelectionImageObject"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Version"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Version"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("CoreGui"),
                },
            );
            map
        },
    };
}
fn generate_core_packages() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CorePackages"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_core_script() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CoreScript"),
        superclass: Some(Cow::Borrowed("BaseScript")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_core_script_sync_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CoreScriptSyncService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_corner_wedge_part() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CornerWedgePart"),
        superclass: Some(Cow::Borrowed("BasePart")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(51);
            map.insert(Cow::Borrowed("Anchored"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("AssemblyAngularVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AssemblyLinearVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("BackParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BackParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BackSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BackSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("BottomParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BottomParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BottomSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BottomSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("CanCollide"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CanTouch"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CastShadow"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("CollisionGroupId"),
                RbxValue::Int32 { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::Color3 {
                    value: [0.6392157, 0.63529414, 0.64705884],
                },
            );
            map.insert(
                Cow::Borrowed("CustomPhysicalProperties"),
                RbxValue::PhysicalProperties { value: None },
            );
            map.insert(
                Cow::Borrowed("Elasticity"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("Friction"), RbxValue::Float32 { value: 0.3 });
            map.insert(
                Cow::Borrowed("FrontParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("FrontParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("FrontSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("FrontSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LeftParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("LeftParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("LeftSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("LeftSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LocalTransparencyModifier"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Locked"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Massless"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Material"), RbxValue::Enum { value: 256 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("CornerWedge"),
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("PivotOffset"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Reflectance"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("RightParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("RightParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("RightSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("RightSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("RootPriority"), RbxValue::Int32 { value: 0 });
            map.insert(
                Cow::Borrowed("RotVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::Vector3 {
                    value: [2.0, 2.0, 2.0],
                },
            );
            map.insert(
                Cow::Borrowed("TopParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(Cow::Borrowed("TopParamB"), RbxValue::Float32 { value: 0.5 });
            map.insert(Cow::Borrowed("TopSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("TopSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Velocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_custom_event() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CustomEvent"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("CustomEvent"),
                },
            );
            map
        },
    };
}
fn generate_custom_event_receiver() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CustomEventReceiver"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Source"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Source"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("CustomEventReceiver"),
                },
            );
            map.insert(Cow::Borrowed("Source"), RbxValue::Ref { value: None });
            map
        },
    };
}
fn generate_cylinder_handle_adornment() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CylinderHandleAdornment"),
        superclass: Some(Cow::Borrowed("HandleAdornment")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("Angle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Angle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Height"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Height"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("InnerRadius"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("InnerRadius"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Radius"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Radius"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(15);
            map.insert(
                Cow::Borrowed("AdornCullingMode"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("Adornee"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("AlwaysOnTop"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("Angle"), RbxValue::Float32 { value: 360.0 });
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("Color3"),
                RbxValue::Color3 {
                    value: [0.050980397, 0.41176474, 0.6745098],
                },
            );
            map.insert(Cow::Borrowed("Height"), RbxValue::Float32 { value: 1.0 });
            map.insert(
                Cow::Borrowed("InnerRadius"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("CylinderHandleAdornment"),
                },
            );
            map.insert(Cow::Borrowed("Radius"), RbxValue::Float32 { value: 1.0 });
            map.insert(
                Cow::Borrowed("SizeRelativeOffset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("ZIndex"), RbxValue::Int32 { value: -1 });
            map
        },
    };
}
fn generate_cylinder_mesh() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CylinderMesh"),
        superclass: Some(Cow::Borrowed("BevelMesh")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Mesh"),
                },
            );
            map.insert(
                Cow::Borrowed("Offset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Scale"),
                RbxValue::Vector3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("VertexColor"),
                RbxValue::Vector3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map
        },
    };
}
fn generate_cylindrical_constraint() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("CylindricalConstraint"),
        superclass: Some(Cow::Borrowed("SlidingBallConstraint")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(16);
            map.insert(
                Cow::Borrowed("AngularActuatorType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngularActuatorType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ActuatorType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AngularLimitsEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngularLimitsEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AngularResponsiveness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngularResponsiveness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AngularRestitution"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngularRestitution"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AngularSpeed"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngularSpeed"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AngularVelocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngularVelocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CurrentAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CurrentAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("InclinationAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("InclinationAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LowerAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LowerAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MotorMaxAngularAcceleration"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MotorMaxAngularAcceleration"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MotorMaxTorque"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MotorMaxTorque"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RotationAxisVisible"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RotationAxisVisible"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ServoMaxTorque"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ServoMaxTorque"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TargetAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TargetAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("UpperAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UpperAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("WorldRotationAxis"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WorldRotationAxis"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(33);
            map.insert(Cow::Borrowed("ActuatorType"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("AngularActuatorType"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("AngularLimitsEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("AngularResponsiveness"),
                RbxValue::Float32 { value: 45.0 },
            );
            map.insert(
                Cow::Borrowed("AngularRestitution"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("AngularSpeed"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("AngularVelocity"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Attachment0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Attachment1"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(1009).unwrap(),
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("InclinationAngle"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("LimitsEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("LinearResponsiveness"),
                RbxValue::Float32 { value: 45.0 },
            );
            map.insert(
                Cow::Borrowed("LowerAngle"),
                RbxValue::Float32 { value: -45.0 },
            );
            map.insert(
                Cow::Borrowed("LowerLimit"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("MotorMaxAcceleration"),
                RbxValue::Float32 {
                    value: 1000000000.0,
                },
            );
            map.insert(
                Cow::Borrowed("MotorMaxAngularAcceleration"),
                RbxValue::Float32 {
                    value: 1000000000.0,
                },
            );
            map.insert(
                Cow::Borrowed("MotorMaxForce"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("MotorMaxTorque"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("CylindricalConstraint"),
                },
            );
            map.insert(
                Cow::Borrowed("Restitution"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("RotationAxisVisible"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("ServoMaxForce"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("ServoMaxTorque"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Size"), RbxValue::Float32 { value: 0.15 });
            map.insert(Cow::Borrowed("Speed"), RbxValue::Float32 { value: 0.0 });
            map.insert(
                Cow::Borrowed("TargetAngle"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("TargetPosition"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("UpperAngle"),
                RbxValue::Float32 { value: 45.0 },
            );
            map.insert(
                Cow::Borrowed("UpperLimit"),
                RbxValue::Float32 { value: 5.0 },
            );
            map.insert(Cow::Borrowed("Velocity"), RbxValue::Float32 { value: 0.0 });
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: false });
            map
        },
    };
}
fn generate_data_model() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataModel"),
        superclass: Some(Cow::Borrowed("ServiceProvider")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(16);
            map.insert(
                Cow::Borrowed("CreatorId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CreatorId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("CreatorType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CreatorType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("CreatorType")),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("GameId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GameId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("GearGenreSetting"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GearGenreSetting"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("GearGenreSetting")),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Genre"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Genre"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("Genre")),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("IsSFFlagsLoaded"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsSFFlagsLoaded"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("JobId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("JobId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PlaceId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PlaceId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PlaceVersion"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PlaceVersion"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PrivateServerId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PrivateServerId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PrivateServerOwnerId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PrivateServerOwnerId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("VIPServerId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("VIPServerId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("VIPServerOwnerId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("VIPServerOwnerId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Workspace"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Workspace"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("lighting"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("lighting"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("workspace"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("workspace"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_data_model_mesh() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataModelMesh"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("Offset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Offset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Scale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Scale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("VertexColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("VertexColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_data_model_session() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataModelSession"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("CurrentDataModelType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CurrentDataModelType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "StudioDataModelType",
                    )),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("SessionId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SessionId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_data_store() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataStore"),
        superclass: Some(Cow::Borrowed("GlobalDataStore")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_data_store_enumeration_pages() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataStoreEnumerationPages"),
        superclass: Some(Cow::Borrowed("Pages")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_data_store_increment_options() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataStoreIncrementOptions"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_data_store_info() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataStoreInfo"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("CreatedTime"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CreatedTime"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("DataStoreName"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DataStoreName"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("UpdatedTime"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UpdatedTime"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_data_store_key_info() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataStoreKeyInfo"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("KeyName"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("KeyName"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_data_store_key_pages() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataStoreKeyPages"),
        superclass: Some(Cow::Borrowed("Pages")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_data_store_key_version_info() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataStoreKeyVersionInfo"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("CreatedTime"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CreatedTime"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("UpdatedTime"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UpdatedTime"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Version"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Version"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_data_store_pages() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataStorePages"),
        superclass: Some(Cow::Borrowed("Pages")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_data_store_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataStoreService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("AutomaticRetry"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutomaticRetry"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LegacyNamingScheme"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LegacyNamingScheme"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("DataStoreService"),
                },
            );
            map
        },
    };
}
fn generate_data_store_set_options() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataStoreSetOptions"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_data_store_version_pages() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DataStoreVersionPages"),
        superclass: Some(Cow::Borrowed("Pages")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_debris() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Debris"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("MaxItems"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxItems"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::DEPRECATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(Cow::Borrowed("MaxItems"), RbxValue::Int32 { value: 1000 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Debris"),
                },
            );
            map
        },
    };
}
fn generate_debug_settings() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DebugSettings"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE
            | RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::SETTINGS,
        properties: {
            let mut map = HashMap::with_capacity(8);
            map.insert(
                Cow::Borrowed("DataModel"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DataModel"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("InstanceCount"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("InstanceCount"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("IsScriptStackTracingEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsScriptStackTracingEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("JobCount"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("JobCount"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PlayerCount"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PlayerCount"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ReportSoundWarnings"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ReportSoundWarnings"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RobloxVersion"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RobloxVersion"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("TickCountPreciseOverride"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TickCountPreciseOverride"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "TickCountSampleMethod",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_debugger_breakpoint() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DebuggerBreakpoint"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("Condition"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Condition"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("IsEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Line"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Line"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("isContextDependentBreakpoint"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("isContextDependentBreakpoint"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_debugger_manager() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DebuggerManager"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("DebuggingEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DebuggingEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_debugger_watch() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DebuggerWatch"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Expression"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Expression"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_decal() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Decal"),
        superclass: Some(Cow::Borrowed("FaceInstance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("Color3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Color3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LocalTransparencyModifier"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LocalTransparencyModifier"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Shiny"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Shiny"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Specular"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Specular"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Texture"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Texture"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Transparency"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(8);
            map.insert(
                Cow::Borrowed("Color3"),
                RbxValue::Color3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("Face"), RbxValue::Enum { value: 5 });
            map.insert(
                Cow::Borrowed("LocalTransparencyModifier"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Decal"),
                },
            );
            map.insert(Cow::Borrowed("Shiny"), RbxValue::Float32 { value: 20.0 });
            map.insert(Cow::Borrowed("Specular"), RbxValue::Float32 { value: 0.0 });
            map.insert(
                Cow::Borrowed("Texture"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map
        },
    };
}
fn generate_depth_of_field_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DepthOfFieldEffect"),
        superclass: Some(Cow::Borrowed("PostEffect")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("FarIntensity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FarIntensity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FocusDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FocusDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("InFocusRadius"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("InFocusRadius"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("NearIntensity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("NearIntensity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("FarIntensity"),
                RbxValue::Float32 { value: 0.75 },
            );
            map.insert(
                Cow::Borrowed("FocusDistance"),
                RbxValue::Float32 { value: 0.05 },
            );
            map.insert(
                Cow::Borrowed("InFocusRadius"),
                RbxValue::Float32 { value: 10.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("DepthOfField"),
                },
            );
            map.insert(
                Cow::Borrowed("NearIntensity"),
                RbxValue::Float32 { value: 0.75 },
            );
            map
        },
    };
}
fn generate_dialog() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Dialog"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(10);
            map.insert(
                Cow::Borrowed("BehaviorType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BehaviorType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "DialogBehaviorType",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ConversationDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ConversationDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("GoodbyeChoiceActive"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GoodbyeChoiceActive"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("GoodbyeDialog"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GoodbyeDialog"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("InUse"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("InUse"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("InitialPrompt"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("InitialPrompt"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Purpose"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Purpose"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("DialogPurpose")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Tone"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Tone"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("DialogTone")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TriggerDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TriggerDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TriggerOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TriggerOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(11);
            map.insert(Cow::Borrowed("BehaviorType"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("ConversationDistance"),
                RbxValue::Float32 { value: 25.0 },
            );
            map.insert(
                Cow::Borrowed("GoodbyeChoiceActive"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("GoodbyeDialog"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("InUse"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("InitialPrompt"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Dialog"),
                },
            );
            map.insert(Cow::Borrowed("Purpose"), RbxValue::Enum { value: 1 });
            map.insert(Cow::Borrowed("Tone"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("TriggerDistance"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("TriggerOffset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_dialog_choice() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DialogChoice"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("GoodbyeChoiceActive"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GoodbyeChoiceActive"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("GoodbyeDialog"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GoodbyeDialog"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ResponseDialog"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ResponseDialog"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("UserDialog"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UserDialog"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("GoodbyeChoiceActive"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("GoodbyeDialog"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("DialogChoice"),
                },
            );
            map.insert(
                Cow::Borrowed("ResponseDialog"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("UserDialog"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_distortion_sound_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DistortionSoundEffect"),
        superclass: Some(Cow::Borrowed("SoundEffect")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Level"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Level"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("Level"), RbxValue::Float32 { value: 0.75 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("DistortionSoundEffect"),
                },
            );
            map.insert(Cow::Borrowed("Priority"), RbxValue::Int32 { value: 0 });
            map
        },
    };
}
fn generate_dock_widget_plugin_gui() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DockWidgetPluginGui"),
        superclass: Some(Cow::Borrowed("PluginGui")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("HostWidgetWasRestored"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HostWidgetWasRestored"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_double_constrained_value() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DoubleConstrainedValue"),
        superclass: Some(Cow::Borrowed("ValueBase")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("ConstrainedValue"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ConstrainedValue"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float64),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("MaxValue"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxValue"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MinValue"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MinValue"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Value"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Value"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float64),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("ConstrainedValue"),
                RbxValue::Float64 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("MaxValue"), RbxValue::Float64 { value: 1.0 });
            map.insert(Cow::Borrowed("MinValue"), RbxValue::Float64 { value: 0.0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Value"),
                },
            );
            map.insert(Cow::Borrowed("Value"), RbxValue::Float64 { value: 0.0 });
            map
        },
    };
}
fn generate_drafts_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DraftsService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("DraftsService"),
                },
            );
            map
        },
    };
}
fn generate_dragger() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Dragger"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Dragger"),
                },
            );
            map
        },
    };
}
fn generate_dragger_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DraggerService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(16);
            map.insert(
                Cow::Borrowed("AlignDraggedObjects"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AlignDraggedObjects"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AngleSnapEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngleSnapEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AngleSnapIncrement"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngleSnapIncrement"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AnimateHover"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AnimateHover"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("CollisionsEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CollisionsEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("DraggerCoordinateSpace"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DraggerCoordinateSpace"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "DraggerCoordinateSpace",
                    )),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("DraggerMovementMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DraggerMovementMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "DraggerMovementMode",
                    )),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("GeometrySnapColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GeometrySnapColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("HoverAnimateFrequency"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HoverAnimateFrequency"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("HoverThickness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HoverThickness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("JointsEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("JointsEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("LinearSnapEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LinearSnapEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("LinearSnapIncrement"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LinearSnapIncrement"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PivotSnapToGeometry"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PivotSnapToGeometry"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ShowHover"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ShowHover"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ShowPivotIndicator"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ShowPivotIndicator"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("DraggerService"),
                },
            );
            map.insert(
                Cow::Borrowed("ShowPivotIndicator"),
                RbxValue::Bool { value: false },
            );
            map
        },
    };
}
fn generate_dynamic_rotate() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("DynamicRotate"),
        superclass: Some(Cow::Borrowed("JointInstance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("BaseAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BaseAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_echo_sound_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("EchoSoundEffect"),
        superclass: Some(Cow::Borrowed("SoundEffect")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("Delay"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Delay"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DryLevel"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DryLevel"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Feedback"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Feedback"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("WetLevel"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WetLevel"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(7);
            map.insert(Cow::Borrowed("Delay"), RbxValue::Float32 { value: 1.0 });
            map.insert(Cow::Borrowed("DryLevel"), RbxValue::Float32 { value: 0.0 });
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("Feedback"), RbxValue::Float32 { value: 0.5 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("EchoSoundEffect"),
                },
            );
            map.insert(Cow::Borrowed("Priority"), RbxValue::Int32 { value: 0 });
            map.insert(Cow::Borrowed("WetLevel"), RbxValue::Float32 { value: 0.0 });
            map
        },
    };
}
fn generate_emotes_pages() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("EmotesPages"),
        superclass: Some(Cow::Borrowed("InventoryPages")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_equalizer_sound_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("EqualizerSoundEffect"),
        superclass: Some(Cow::Borrowed("SoundEffect")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("HighGain"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HighGain"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LowGain"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LowGain"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MidGain"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MidGain"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("HighGain"), RbxValue::Float32 { value: 0.0 });
            map.insert(Cow::Borrowed("LowGain"), RbxValue::Float32 { value: -20.0 });
            map.insert(Cow::Borrowed("MidGain"), RbxValue::Float32 { value: -10.0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("EqualizerSoundEffect"),
                },
            );
            map.insert(Cow::Borrowed("Priority"), RbxValue::Int32 { value: 0 });
            map
        },
    };
}
fn generate_event_ingest_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("EventIngestService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_explosion() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Explosion"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("BlastPressure"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BlastPressure"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BlastRadius"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BlastRadius"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DestroyJointRadiusPercent"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DestroyJointRadiusPercent"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ExplosionType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ExplosionType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ExplosionType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Position"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Visible"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Visible"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(7);
            map.insert(
                Cow::Borrowed("BlastPressure"),
                RbxValue::Float32 { value: 500000.0 },
            );
            map.insert(
                Cow::Borrowed("BlastRadius"),
                RbxValue::Float32 { value: 4.0 },
            );
            map.insert(
                Cow::Borrowed("DestroyJointRadiusPercent"),
                RbxValue::Float32 { value: 1.0 },
            );
            map.insert(Cow::Borrowed("ExplosionType"), RbxValue::Enum { value: 1 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Explosion"),
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map
        },
    };
}
fn generate_face_instance() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("FaceInstance"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Face"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Face"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("NormalId")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_feature() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Feature"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("FaceId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FaceId"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("NormalId")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("InOut"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("InOut"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("InOut")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LeftRight"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftRight"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("LeftRight")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TopBottom"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TopBottom"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("TopBottom")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_file() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("File"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("FileName"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FileName"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("FileSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FileSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Size"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_file_mesh() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("FileMesh"),
        superclass: Some(Cow::Borrowed("DataModelMesh")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("MeshId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MeshId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TextureId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TextureId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("MeshId"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Mesh"),
                },
            );
            map.insert(
                Cow::Borrowed("Offset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Scale"),
                RbxValue::Vector3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("TextureId"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("VertexColor"),
                RbxValue::Vector3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map
        },
    };
}
fn generate_fire() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Fire"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(8);
            map.insert(
                Cow::Borrowed("Color"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Color"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Heat"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Heat"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: Some(Cow::Borrowed("heat_xml")),
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SecondaryColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SecondaryColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Size"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: Some(Cow::Borrowed("size_xml")),
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("heat_xml"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("heat_xml"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Heat")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("size"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("size"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Size")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("size_xml"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("size_xml"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Size")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::Color3 {
                    value: [0.92549026, 0.54509807, 0.27450982],
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("Heat"), RbxValue::Float32 { value: 9.0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Fire"),
                },
            );
            map.insert(
                Cow::Borrowed("SecondaryColor"),
                RbxValue::Color3 {
                    value: [0.54509807, 0.3137255, 0.21568629],
                },
            );
            map.insert(Cow::Borrowed("Size"), RbxValue::Float32 { value: 5.0 });
            map
        },
    };
}
fn generate_flag() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Flag"),
        superclass: Some(Cow::Borrowed("Tool")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("TeamColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TeamColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(13);
            map.insert(
                Cow::Borrowed("CanBeDropped"),
                RbxValue::Bool { value: true },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Grip"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("GripForward"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, -1.0],
                },
            );
            map.insert(
                Cow::Borrowed("GripPos"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("GripRight"),
                RbxValue::Vector3 {
                    value: [1.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("GripUp"),
                RbxValue::Vector3 {
                    value: [0.0, 1.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("ManualActivationOnly"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Flag"),
                },
            );
            map.insert(
                Cow::Borrowed("RequiresHandle"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("TeamColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(194).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("TextureId"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("ToolTip"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_flag_stand() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("FlagStand"),
        superclass: Some(Cow::Borrowed("Part")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("TeamColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TeamColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(54);
            map.insert(Cow::Borrowed("Anchored"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("AssemblyAngularVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AssemblyLinearVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("BackParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BackParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BackSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BackSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("BottomParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BottomParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BottomSurface"), RbxValue::Enum { value: 4 });
            map.insert(
                Cow::Borrowed("BottomSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("CanCollide"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CanTouch"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CastShadow"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("CollisionGroupId"),
                RbxValue::Int32 { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::Color3 {
                    value: [0.6392157, 0.63529414, 0.64705884],
                },
            );
            map.insert(
                Cow::Borrowed("CustomPhysicalProperties"),
                RbxValue::PhysicalProperties { value: None },
            );
            map.insert(
                Cow::Borrowed("Elasticity"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("FormFactor"), RbxValue::Enum { value: 1 });
            map.insert(Cow::Borrowed("Friction"), RbxValue::Float32 { value: 0.3 });
            map.insert(
                Cow::Borrowed("FrontParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("FrontParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("FrontSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("FrontSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LeftParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("LeftParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("LeftSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("LeftSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LocalTransparencyModifier"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Locked"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Massless"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Material"), RbxValue::Enum { value: 256 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("FlagStand"),
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("PivotOffset"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Reflectance"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("RightParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("RightParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("RightSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("RightSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("RootPriority"), RbxValue::Int32 { value: 0 });
            map.insert(
                Cow::Borrowed("RotVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("Shape"), RbxValue::Enum { value: 1 });
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::Vector3 {
                    value: [4.0, 1.2, 2.0],
                },
            );
            map.insert(
                Cow::Borrowed("TeamColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(194).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("TopParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(Cow::Borrowed("TopParamB"), RbxValue::Float32 { value: 0.5 });
            map.insert(Cow::Borrowed("TopSurface"), RbxValue::Enum { value: 3 });
            map.insert(
                Cow::Borrowed("TopSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Velocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_flag_stand_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("FlagStandService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_flange_sound_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("FlangeSoundEffect"),
        superclass: Some(Cow::Borrowed("SoundEffect")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("Depth"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Depth"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Mix"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Mix"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Rate"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Rate"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(Cow::Borrowed("Depth"), RbxValue::Float32 { value: 0.45 });
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("Mix"), RbxValue::Float32 { value: 0.85 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("FlangeSoundEffect"),
                },
            );
            map.insert(Cow::Borrowed("Priority"), RbxValue::Int32 { value: 0 });
            map.insert(Cow::Borrowed("Rate"), RbxValue::Float32 { value: 5.0 });
            map
        },
    };
}
fn generate_floor_wire() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("FloorWire"),
        superclass: Some(Cow::Borrowed("GuiBase3d")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: {
            let mut map = HashMap::with_capacity(8);
            map.insert(
                Cow::Borrowed("CycleOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CycleOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("From"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("From"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("StudsBetweenTextures"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("StudsBetweenTextures"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Texture"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Texture"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TextureSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TextureSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("To"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("To"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Velocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Velocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("WireRadius"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WireRadius"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(13);
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("Color3"),
                RbxValue::Color3 {
                    value: [0.050980397, 0.41176474, 0.6745098],
                },
            );
            map.insert(
                Cow::Borrowed("CycleOffset"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("From"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("FloorWire"),
                },
            );
            map.insert(
                Cow::Borrowed("StudsBetweenTextures"),
                RbxValue::Float32 { value: 4.0 },
            );
            map.insert(
                Cow::Borrowed("Texture"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("TextureSize"),
                RbxValue::Vector2 { value: [1.0, 1.0] },
            );
            map.insert(Cow::Borrowed("To"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Velocity"), RbxValue::Float32 { value: 2.0 });
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("WireRadius"),
                RbxValue::Float32 { value: 0.0625 },
            );
            map
        },
    };
}
fn generate_flyweight_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("FlyweightService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_folder() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Folder"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Folder"),
                },
            );
            map
        },
    };
}
fn generate_force_field() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ForceField"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Visible"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Visible"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ForceField"),
                },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map
        },
    };
}
fn generate_form_factor_part() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("FormFactorPart"),
        superclass: Some(Cow::Borrowed("BasePart")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("FormFactor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FormFactor"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("FormFactor")),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: Some(Cow::Borrowed("formFactorRaw")),
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("formFactor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("formFactor"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("FormFactor")),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("FormFactor")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("formFactorRaw"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("formFactorRaw"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("FormFactor")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("FormFactor")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_frame() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Frame"),
        superclass: Some(Cow::Borrowed("GuiObject")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Style"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Style"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("FrameStyle")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(31);
            map.insert(Cow::Borrowed("Active"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("AnchorPoint"),
                RbxValue::Vector2 { value: [0.0, 0.0] },
            );
            map.insert(
                Cow::Borrowed("AutoLocalize"),
                RbxValue::Bool { value: true },
            );
            map.insert(Cow::Borrowed("AutomaticSize"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BackgroundColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(194).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("BackgroundColor3"),
                RbxValue::Color3 {
                    value: [0.6392157, 0.63529414, 0.64705884],
                },
            );
            map.insert(
                Cow::Borrowed("BackgroundTransparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("BorderColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(26).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("BorderColor3"),
                RbxValue::Color3 {
                    value: [0.10588236, 0.16470589, 0.20784315],
                },
            );
            map.insert(Cow::Borrowed("BorderMode"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BorderSizePixel"),
                RbxValue::Int32 { value: 1 },
            );
            map.insert(
                Cow::Borrowed("ClipsDescendants"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("Draggable"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("LayoutOrder"), RbxValue::Int32 { value: 0 });
            map.insert(Cow::Borrowed("Localize"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Frame"),
                },
            );
            map.insert(
                Cow::Borrowed("NextSelectionDown"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("NextSelectionLeft"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("NextSelectionRight"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("NextSelectionUp"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::UDim2 {
                    value: (0.0, 0, 0.0, 0),
                },
            );
            map.insert(
                Cow::Borrowed("RootLocalizationTable"),
                RbxValue::Ref { value: None },
            );
            map.insert(Cow::Borrowed("Rotation"), RbxValue::Float32 { value: 0.0 });
            map.insert(Cow::Borrowed("Selectable"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("SelectionImageObject"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::UDim2 {
                    value: (0.0, 0, 0.0, 0),
                },
            );
            map.insert(Cow::Borrowed("SizeConstraint"), RbxValue::Enum { value: 0 });
            map.insert(Cow::Borrowed("Style"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("ZIndex"), RbxValue::Int32 { value: 1 });
            map
        },
    };
}
fn generate_friend_pages() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("FriendPages"),
        superclass: Some(Cow::Borrowed("Pages")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_friend_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("FriendService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("FriendService"),
                },
            );
            map
        },
    };
}
fn generate_functional_test() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("FunctionalTest"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Description"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Description"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Description"),
                RbxValue::String {
                    value: String::from("?"),
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_game_pass_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GamePassService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("GamePassService"),
                },
            );
            map
        },
    };
}
fn generate_game_settings() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GameSettings"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE
            | RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::SETTINGS,
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("AdditionalCoreIncludeDirs"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AdditionalCoreIncludeDirs"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("OverrideStarterScript"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("OverrideStarterScript"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("VideoCaptureEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("VideoCaptureEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("VideoRecording"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("VideoRecording"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_gamepad_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GamepadService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("GamepadCursorEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GamepadCursorEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("GamepadService"),
                },
            );
            map
        },
    };
}
fn generate_generic_settings() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GenericSettings"),
        superclass: Some(Cow::Borrowed("ServiceProvider")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_geometry() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Geometry"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Geometry"),
                },
            );
            map
        },
    };
}
fn generate_get_data_store_options() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GetDataStoreOptions"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("AllScopes"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AllScopes"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(Cow::Borrowed("AllScopes"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_global_data_store() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GlobalDataStore"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_global_settings() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GlobalSettings"),
        superclass: Some(Cow::Borrowed("GenericSettings")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_glue() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Glue"),
        superclass: Some(Cow::Borrowed("JointInstance")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("F0"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("F0"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("F1"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("F1"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("F2"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("F2"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("F3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("F3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(10);
            map.insert(
                Cow::Borrowed("C0"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("C1"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("F0"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("F1"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("F2"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("F3"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Glue"),
                },
            );
            map.insert(Cow::Borrowed("Part0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Part1"), RbxValue::Ref { value: None });
            map
        },
    };
}
fn generate_google_analytics_configuration() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GoogleAnalyticsConfiguration"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_group_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GroupService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("GroupService"),
                },
            );
            map
        },
    };
}
fn generate_gui_base() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GuiBase"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_gui_base2d() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GuiBase2d"),
        superclass: Some(Cow::Borrowed("GuiBase")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(10);
            map.insert(
                Cow::Borrowed("AbsolutePosition"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AbsolutePosition"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AbsoluteRotation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AbsoluteRotation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AbsoluteSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AbsoluteSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AutoLocalize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutoLocalize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ClippedRect"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ClippedRect"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Rect),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("IsNotOccluded"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsNotOccluded"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Localize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Localize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RawRect2D"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RawRect2D"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Rect),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RootLocalizationTable"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RootLocalizationTable"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TotalGroupScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TotalGroupScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_gui_base3d() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GuiBase3d"),
        superclass: Some(Cow::Borrowed("GuiBase")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("Color"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Color"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Color3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Color3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Transparency"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Visible"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Visible"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_gui_button() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GuiButton"),
        superclass: Some(Cow::Borrowed("GuiObject")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("AutoButtonColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutoButtonColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Modal"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Modal"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Selected"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Selected"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Style"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Style"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ButtonStyle")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_gui_label() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GuiLabel"),
        superclass: Some(Cow::Borrowed("GuiObject")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_gui_main() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GuiMain"),
        superclass: Some(Cow::Borrowed("ScreenGui")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(9);
            map.insert(
                Cow::Borrowed("AutoLocalize"),
                RbxValue::Bool { value: true },
            );
            map.insert(Cow::Borrowed("DisplayOrder"), RbxValue::Int32 { value: 0 });
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("IgnoreGuiInset"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("Localize"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("GuiMain"),
                },
            );
            map.insert(
                Cow::Borrowed("ResetOnSpawn"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("RootLocalizationTable"),
                RbxValue::Ref { value: None },
            );
            map.insert(Cow::Borrowed("ZIndexBehavior"), RbxValue::Enum { value: 0 });
            map
        },
    };
}
fn generate_gui_object() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GuiObject"),
        superclass: Some(Cow::Borrowed("GuiBase2d")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(26);
            map.insert(
                Cow::Borrowed("Active"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Active"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AnchorPoint"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AnchorPoint"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AutomaticSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutomaticSize"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("AutomaticSize")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BackgroundColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BackgroundColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("BackgroundColor3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BackgroundColor3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BackgroundTransparency"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BackgroundTransparency"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BorderColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BorderColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("BorderColor3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BorderColor3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BorderMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BorderMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("BorderMode")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BorderSizePixel"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BorderSizePixel"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ClipsDescendants"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ClipsDescendants"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Draggable"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Draggable"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::DEPRECATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LayoutOrder"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LayoutOrder"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("NextSelectionDown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("NextSelectionDown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("NextSelectionLeft"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("NextSelectionLeft"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("NextSelectionRight"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("NextSelectionRight"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("NextSelectionUp"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("NextSelectionUp"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Position"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::UDim2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Rotation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Selectable"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Selectable"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SelectionImageObject"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SelectionImageObject"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Size"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::UDim2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SizeConstraint"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SizeConstraint"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("SizeConstraint")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Transparency"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Visible"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Visible"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ZIndex"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ZIndex"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_gui_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GuiService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(10);
            map.insert(
                Cow::Borrowed("AutoSelectGuiEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutoSelectGuiEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CoreEffectFolder"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CoreEffectFolder"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("CoreGuiFolder"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CoreGuiFolder"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("CoreGuiNavigationEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CoreGuiNavigationEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("GuiNavigationEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GuiNavigationEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("IsModalDialog"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsModalDialog"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("IsWindows"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsWindows"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("MenuIsOpen"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MenuIsOpen"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("SelectedCoreObject"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SelectedCoreObject"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("SelectedObject"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SelectedObject"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("AutoSelectGuiEnabled"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("CoreGuiNavigationEnabled"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("GuiNavigationEnabled"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("GuiService"),
                },
            );
            map.insert(
                Cow::Borrowed("SelectedObject"),
                RbxValue::Ref { value: None },
            );
            map
        },
    };
}
fn generate_guid_registry_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("GuidRegistryService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_handle_adornment() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("HandleAdornment"),
        superclass: Some(Cow::Borrowed("PVAdornment")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("AdornCullingMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AdornCullingMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("AdornCullingMode")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AlwaysOnTop"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AlwaysOnTop"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CFrame"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SizeRelativeOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SizeRelativeOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ZIndex"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ZIndex"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_handles() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Handles"),
        superclass: Some(Cow::Borrowed("HandlesBase")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Faces"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Faces"),
                    value_type: RbxPropertyTypeDescriptor::UnimplementedType(Cow::Borrowed(
                        "Faces",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Style"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Style"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("HandlesStyle")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(7);
            map.insert(Cow::Borrowed("Adornee"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("Color3"),
                RbxValue::Color3 {
                    value: [0.050980397, 0.41176474, 0.6745098],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Handles"),
                },
            );
            map.insert(Cow::Borrowed("Style"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map
        },
    };
}
fn generate_handles_base() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("HandlesBase"),
        superclass: Some(Cow::Borrowed("PartAdornment")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_haptic_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("HapticService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("HapticService"),
                },
            );
            map
        },
    };
}
fn generate_hat() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Hat"),
        superclass: Some(Cow::Borrowed("Accoutrement")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("AttachmentForward"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, -1.0],
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentPoint"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentPos"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentRight"),
                RbxValue::Vector3 {
                    value: [1.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AttachmentUp"),
                RbxValue::Vector3 {
                    value: [0.0, 1.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Hat"),
                },
            );
            map
        },
    };
}
fn generate_heightmap_importer_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("HeightmapImporterService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_REPLICATED | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("HeightmapImporterService"),
                },
            );
            map
        },
    };
}
fn generate_hinge_constraint() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("HingeConstraint"),
        superclass: Some(Cow::Borrowed("Constraint")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(14);
            map.insert(
                Cow::Borrowed("ActuatorType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ActuatorType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ActuatorType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AngularResponsiveness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngularResponsiveness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AngularSpeed"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngularSpeed"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AngularVelocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AngularVelocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CurrentAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CurrentAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("LimitsEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LimitsEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LowerAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LowerAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MotorMaxAcceleration"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MotorMaxAcceleration"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MotorMaxTorque"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MotorMaxTorque"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Radius"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Radius"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Restitution"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Restitution"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ServoMaxTorque"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ServoMaxTorque"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TargetAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TargetAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("UpperAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UpperAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(19);
            map.insert(Cow::Borrowed("ActuatorType"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("AngularResponsiveness"),
                RbxValue::Float32 { value: 45.0 },
            );
            map.insert(
                Cow::Borrowed("AngularSpeed"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("AngularVelocity"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Attachment0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Attachment1"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(1009).unwrap(),
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("LimitsEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("LowerAngle"),
                RbxValue::Float32 { value: -45.0 },
            );
            map.insert(
                Cow::Borrowed("MotorMaxAcceleration"),
                RbxValue::Float32 {
                    value: 1000000000.0,
                },
            );
            map.insert(
                Cow::Borrowed("MotorMaxTorque"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("HingeConstraint"),
                },
            );
            map.insert(Cow::Borrowed("Radius"), RbxValue::Float32 { value: 0.15 });
            map.insert(
                Cow::Borrowed("Restitution"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("ServoMaxTorque"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("TargetAngle"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("UpperAngle"),
                RbxValue::Float32 { value: 45.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: false });
            map
        },
    };
}
fn generate_hint() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Hint"),
        superclass: Some(Cow::Borrowed("Message")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Message"),
                },
            );
            map.insert(
                Cow::Borrowed("Text"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_hole() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Hole"),
        superclass: Some(Cow::Borrowed("Feature")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(Cow::Borrowed("FaceId"), RbxValue::Enum { value: 0 });
            map.insert(Cow::Borrowed("InOut"), RbxValue::Enum { value: 2 });
            map.insert(Cow::Borrowed("LeftRight"), RbxValue::Enum { value: 1 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Hole"),
                },
            );
            map.insert(Cow::Borrowed("TopBottom"), RbxValue::Enum { value: 1 });
            map
        },
    };
}
fn generate_hopper() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Hopper"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::DEPRECATED
            | RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_hopper_bin() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("HopperBin"),
        superclass: Some(Cow::Borrowed("BackpackItem")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Active"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Active"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BinType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BinType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("BinType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(Cow::Borrowed("Active"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("BinType"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("HopperBin"),
                },
            );
            map.insert(
                Cow::Borrowed("TextureId"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_http_rbx_api_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("HttpRbxApiService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("HttpRbxApiService"),
                },
            );
            map
        },
    };
}
fn generate_http_request() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("HttpRequest"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_http_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("HttpService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("HttpEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HttpEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("HttpService"),
                },
            );
            map
        },
    };
}
fn generate_humanoid() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Humanoid"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(36);
            map.insert(
                Cow::Borrowed("AutoJumpEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutoJumpEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AutoRotate"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutoRotate"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AutomaticScalingEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutomaticScalingEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BreakJointsOnDeath"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BreakJointsOnDeath"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CameraOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CameraOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("CollisionType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CollisionType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "HumanoidCollisionType",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DisplayDistanceType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DisplayDistanceType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "HumanoidDisplayDistanceType",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DisplayName"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DisplayName"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FloorMaterial"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FloorMaterial"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("Material")),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Health"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Health"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("HealthDisplayDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HealthDisplayDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HealthDisplayType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HealthDisplayType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "HumanoidHealthDisplayType",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HipHeight"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HipHeight"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Jump"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Jump"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("JumpHeight"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("JumpHeight"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("JumpPower"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("JumpPower"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LeftLeg"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftLeg"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("MaxHealth"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxHealth"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxSlopeAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxSlopeAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MoveDirection"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MoveDirection"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("NameDisplayDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("NameDisplayDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("NameOcclusion"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("NameOcclusion"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("NameOcclusion")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PlatformStand"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PlatformStand"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RequiresNeck"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RequiresNeck"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RigType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RigType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("HumanoidRigType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RightLeg"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightLeg"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RootPart"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RootPart"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("SeatPart"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SeatPart"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Sit"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Sit"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("TargetPoint"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TargetPoint"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Torso"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Torso"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("UseJumpPower"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UseJumpPower"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("WalkSpeed"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WalkSpeed"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("WalkToPart"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WalkToPart"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("WalkToPoint"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WalkToPoint"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("maxHealth"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("maxHealth"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(33);
            map.insert(
                Cow::Borrowed("AutoJumpEnabled"),
                RbxValue::Bool { value: true },
            );
            map.insert(Cow::Borrowed("AutoRotate"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("AutomaticScalingEnabled"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("BreakJointsOnDeath"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("CameraOffset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("CollisionType"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("DisplayDistanceType"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("DisplayName"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("Health"), RbxValue::Float32 { value: 100.0 });
            map.insert(
                Cow::Borrowed("HealthDisplayDistance"),
                RbxValue::Float32 { value: 100.0 },
            );
            map.insert(
                Cow::Borrowed("HealthDisplayType"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("HipHeight"), RbxValue::Float32 { value: 0.0 });
            map.insert(Cow::Borrowed("Jump"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("JumpHeight"),
                RbxValue::Float32 { value: 7.2 },
            );
            map.insert(
                Cow::Borrowed("JumpPower"),
                RbxValue::Float32 { value: 50.0 },
            );
            map.insert(Cow::Borrowed("LeftLeg"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("MaxHealth"),
                RbxValue::Float32 { value: 100.0 },
            );
            map.insert(
                Cow::Borrowed("MaxSlopeAngle"),
                RbxValue::Float32 { value: 89.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Humanoid"),
                },
            );
            map.insert(
                Cow::Borrowed("NameDisplayDistance"),
                RbxValue::Float32 { value: 100.0 },
            );
            map.insert(Cow::Borrowed("NameOcclusion"), RbxValue::Enum { value: 2 });
            map.insert(
                Cow::Borrowed("PlatformStand"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("RequiresNeck"),
                RbxValue::Bool { value: true },
            );
            map.insert(Cow::Borrowed("RigType"), RbxValue::Enum { value: 0 });
            map.insert(Cow::Borrowed("RightLeg"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Sit"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("TargetPoint"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("Torso"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("UseJumpPower"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("WalkSpeed"),
                RbxValue::Float32 { value: 16.0 },
            );
            map.insert(Cow::Borrowed("WalkToPart"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("WalkToPoint"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("maxHealth"),
                RbxValue::Float32 { value: 100.0 },
            );
            map
        },
    };
}
fn generate_humanoid_controller() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("HumanoidController"),
        superclass: Some(Cow::Borrowed("Controller")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_humanoid_description() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("HumanoidDescription"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(39);
            map.insert(
                Cow::Borrowed("AccessoryBlob"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AccessoryBlob"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_SCRIPTABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BackAccessory"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BackAccessory"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BodyTypeScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BodyTypeScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ClimbAnimation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ClimbAnimation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DepthScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DepthScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Face"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Face"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FaceAccessory"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FaceAccessory"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FallAnimation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FallAnimation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FrontAccessory"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FrontAccessory"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("GraphicTShirt"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GraphicTShirt"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HairAccessory"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HairAccessory"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HatAccessory"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HatAccessory"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Head"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Head"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HeadColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HeadColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HeadScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HeadScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HeightScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HeightScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("IdleAnimation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IdleAnimation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("JumpAnimation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("JumpAnimation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LeftArm"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftArm"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LeftArmColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftArmColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LeftLeg"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftLeg"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LeftLegColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LeftLegColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("NeckAccessory"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("NeckAccessory"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("NumberEmotesLoaded"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("NumberEmotesLoaded"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Pants"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Pants"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ProportionScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ProportionScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RightArm"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightArm"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RightArmColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightArmColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RightLeg"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightLeg"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RightLegColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RightLegColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RunAnimation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RunAnimation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Shirt"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Shirt"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ShouldersAccessory"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ShouldersAccessory"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SwimAnimation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SwimAnimation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Torso"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Torso"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TorsoColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TorsoColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("WaistAccessory"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WaistAccessory"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("WalkAnimation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WalkAnimation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("WidthScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WidthScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(38);
            map.insert(
                Cow::Borrowed("BackAccessory"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("BodyTypeScale"),
                RbxValue::Float32 { value: 0.3 },
            );
            map.insert(
                Cow::Borrowed("ClimbAnimation"),
                RbxValue::Int64 { value: 0 },
            );
            map.insert(
                Cow::Borrowed("DepthScale"),
                RbxValue::Float32 { value: 1.0 },
            );
            map.insert(Cow::Borrowed("Face"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("FaceAccessory"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("FallAnimation"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("FrontAccessory"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("GraphicTShirt"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("HairAccessory"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("HatAccessory"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("Head"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("HeadColor"),
                RbxValue::Color3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("HeadScale"), RbxValue::Float32 { value: 1.0 });
            map.insert(
                Cow::Borrowed("HeightScale"),
                RbxValue::Float32 { value: 1.0 },
            );
            map.insert(Cow::Borrowed("IdleAnimation"), RbxValue::Int64 { value: 0 });
            map.insert(Cow::Borrowed("JumpAnimation"), RbxValue::Int64 { value: 0 });
            map.insert(Cow::Borrowed("LeftArm"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("LeftArmColor"),
                RbxValue::Color3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("LeftLeg"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("LeftLegColor"),
                RbxValue::Color3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("HumanoidDescription"),
                },
            );
            map.insert(
                Cow::Borrowed("NeckAccessory"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("Pants"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("ProportionScale"),
                RbxValue::Float32 { value: 1.0 },
            );
            map.insert(Cow::Borrowed("RightArm"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("RightArmColor"),
                RbxValue::Color3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("RightLeg"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("RightLegColor"),
                RbxValue::Color3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("RunAnimation"), RbxValue::Int64 { value: 0 });
            map.insert(Cow::Borrowed("Shirt"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("ShouldersAccessory"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("SwimAnimation"), RbxValue::Int64 { value: 0 });
            map.insert(Cow::Borrowed("Torso"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("TorsoColor"),
                RbxValue::Color3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("WaistAccessory"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("WalkAnimation"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("WidthScale"),
                RbxValue::Float32 { value: 1.0 },
            );
            map
        },
    };
}
fn generate_i_legacy_studio_bridge() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ILegacyStudioBridge"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_ixp_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("IXPService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_image_button() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ImageButton"),
        superclass: Some(Cow::Borrowed("GuiButton")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(12);
            map.insert(
                Cow::Borrowed("HoverImage"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HoverImage"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Image"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Image"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ImageColor3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ImageColor3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ImageRectOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ImageRectOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ImageRectSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ImageRectSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ImageTransparency"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ImageTransparency"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("IsLoaded"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsLoaded"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PressedImage"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PressedImage"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ScaleType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ScaleType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ScaleType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SliceCenter"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SliceCenter"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Rect),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SliceScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SliceScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TileSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TileSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::UDim2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(45);
            map.insert(Cow::Borrowed("Active"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("AnchorPoint"),
                RbxValue::Vector2 { value: [0.0, 0.0] },
            );
            map.insert(
                Cow::Borrowed("AutoButtonColor"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("AutoLocalize"),
                RbxValue::Bool { value: true },
            );
            map.insert(Cow::Borrowed("AutomaticSize"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BackgroundColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(194).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("BackgroundColor3"),
                RbxValue::Color3 {
                    value: [0.6392157, 0.63529414, 0.64705884],
                },
            );
            map.insert(
                Cow::Borrowed("BackgroundTransparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("BorderColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(26).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("BorderColor3"),
                RbxValue::Color3 {
                    value: [0.10588236, 0.16470589, 0.20784315],
                },
            );
            map.insert(Cow::Borrowed("BorderMode"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BorderSizePixel"),
                RbxValue::Int32 { value: 1 },
            );
            map.insert(
                Cow::Borrowed("ClipsDescendants"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("Draggable"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("HoverImage"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("Image"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("ImageColor3"),
                RbxValue::Color3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("ImageRectOffset"),
                RbxValue::Vector2 { value: [0.0, 0.0] },
            );
            map.insert(
                Cow::Borrowed("ImageRectSize"),
                RbxValue::Vector2 { value: [0.0, 0.0] },
            );
            map.insert(
                Cow::Borrowed("ImageTransparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("LayoutOrder"), RbxValue::Int32 { value: 0 });
            map.insert(Cow::Borrowed("Localize"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("Modal"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ImageButton"),
                },
            );
            map.insert(
                Cow::Borrowed("NextSelectionDown"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("NextSelectionLeft"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("NextSelectionRight"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("NextSelectionUp"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::UDim2 {
                    value: (0.0, 0, 0.0, 0),
                },
            );
            map.insert(
                Cow::Borrowed("PressedImage"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("RootLocalizationTable"),
                RbxValue::Ref { value: None },
            );
            map.insert(Cow::Borrowed("Rotation"), RbxValue::Float32 { value: 0.0 });
            map.insert(Cow::Borrowed("ScaleType"), RbxValue::Enum { value: 0 });
            map.insert(Cow::Borrowed("Selectable"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("Selected"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("SelectionImageObject"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::UDim2 {
                    value: (0.0, 0, 0.0, 0),
                },
            );
            map.insert(Cow::Borrowed("SizeConstraint"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("SliceCenter"),
                RbxValue::Rect {
                    value: Rect {
                        min: (0.0, 0.0),
                        max: (0.0, 0.0),
                    },
                },
            );
            map.insert(
                Cow::Borrowed("SliceScale"),
                RbxValue::Float32 { value: 1.0 },
            );
            map.insert(Cow::Borrowed("Style"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("TileSize"),
                RbxValue::UDim2 {
                    value: (1.0, 0, 1.0, 0),
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("ZIndex"), RbxValue::Int32 { value: 1 });
            map
        },
    };
}
fn generate_image_handle_adornment() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ImageHandleAdornment"),
        superclass: Some(Cow::Borrowed("HandleAdornment")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Image"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Image"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Size"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(13);
            map.insert(
                Cow::Borrowed("AdornCullingMode"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("Adornee"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("AlwaysOnTop"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(1).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("Color3"),
                RbxValue::Color3 {
                    value: [0.9490197, 0.95294124, 0.95294124],
                },
            );
            map.insert(
                Cow::Borrowed("Image"),
                RbxValue::Content {
                    value: String::from("rbxasset://textures/SurfacesDefault.png"),
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ImageHandleAdornment"),
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::Vector2 { value: [1.0, 1.0] },
            );
            map.insert(
                Cow::Borrowed("SizeRelativeOffset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("ZIndex"), RbxValue::Int32 { value: -1 });
            map
        },
    };
}
fn generate_image_label() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ImageLabel"),
        superclass: Some(Cow::Borrowed("GuiLabel")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(10);
            map.insert(
                Cow::Borrowed("Image"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Image"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ImageColor3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ImageColor3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ImageRectOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ImageRectOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ImageRectSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ImageRectSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ImageTransparency"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ImageTransparency"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("IsLoaded"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsLoaded"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ScaleType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ScaleType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ScaleType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SliceCenter"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SliceCenter"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Rect),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SliceScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SliceScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TileSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TileSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::UDim2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(39);
            map.insert(Cow::Borrowed("Active"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("AnchorPoint"),
                RbxValue::Vector2 { value: [0.0, 0.0] },
            );
            map.insert(
                Cow::Borrowed("AutoLocalize"),
                RbxValue::Bool { value: true },
            );
            map.insert(Cow::Borrowed("AutomaticSize"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BackgroundColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(194).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("BackgroundColor3"),
                RbxValue::Color3 {
                    value: [0.6392157, 0.63529414, 0.64705884],
                },
            );
            map.insert(
                Cow::Borrowed("BackgroundTransparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("BorderColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(26).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("BorderColor3"),
                RbxValue::Color3 {
                    value: [0.10588236, 0.16470589, 0.20784315],
                },
            );
            map.insert(Cow::Borrowed("BorderMode"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BorderSizePixel"),
                RbxValue::Int32 { value: 1 },
            );
            map.insert(
                Cow::Borrowed("ClipsDescendants"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("Draggable"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Image"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("ImageColor3"),
                RbxValue::Color3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("ImageRectOffset"),
                RbxValue::Vector2 { value: [0.0, 0.0] },
            );
            map.insert(
                Cow::Borrowed("ImageRectSize"),
                RbxValue::Vector2 { value: [0.0, 0.0] },
            );
            map.insert(
                Cow::Borrowed("ImageTransparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("LayoutOrder"), RbxValue::Int32 { value: 0 });
            map.insert(Cow::Borrowed("Localize"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ImageLabel"),
                },
            );
            map.insert(
                Cow::Borrowed("NextSelectionDown"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("NextSelectionLeft"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("NextSelectionRight"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("NextSelectionUp"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::UDim2 {
                    value: (0.0, 0, 0.0, 0),
                },
            );
            map.insert(
                Cow::Borrowed("RootLocalizationTable"),
                RbxValue::Ref { value: None },
            );
            map.insert(Cow::Borrowed("Rotation"), RbxValue::Float32 { value: 0.0 });
            map.insert(Cow::Borrowed("ScaleType"), RbxValue::Enum { value: 0 });
            map.insert(Cow::Borrowed("Selectable"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("SelectionImageObject"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::UDim2 {
                    value: (0.0, 0, 0.0, 0),
                },
            );
            map.insert(Cow::Borrowed("SizeConstraint"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("SliceCenter"),
                RbxValue::Rect {
                    value: Rect {
                        min: (0.0, 0.0),
                        max: (0.0, 0.0),
                    },
                },
            );
            map.insert(
                Cow::Borrowed("SliceScale"),
                RbxValue::Float32 { value: 1.0 },
            );
            map.insert(
                Cow::Borrowed("TileSize"),
                RbxValue::UDim2 {
                    value: (1.0, 0, 1.0, 0),
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("ZIndex"), RbxValue::Int32 { value: 1 });
            map
        },
    };
}
fn generate_incremental_patch_builder() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("IncrementalPatchBuilder"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_input_object() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("InputObject"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("Delta"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Delta"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("KeyCode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("KeyCode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("KeyCode")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Position"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("UserInputState"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UserInputState"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("UserInputState")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("UserInputType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UserInputType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("UserInputType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_insert_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("InsertService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("AllowClientInsertModels"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AllowClientInsertModels"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_SCRIPTABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AllowInsertFreeModels"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AllowInsertFreeModels"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::NOT_BROWSABLE
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("AllowInsertFreeModels"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("InsertService"),
                },
            );
            map
        },
    };
}
fn generate_instance() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Instance"),
        superclass: None,
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(10);
            map.insert(
                Cow::Borrowed("Archivable"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Archivable"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: Some(Cow::Borrowed("archivable")),
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ClassName"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ClassName"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("DataCost"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DataCost"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Name"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Parent"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Parent"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RobloxLocked"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RobloxLocked"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("SourceAssetId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SourceAssetId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Tags"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Tags"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BinaryString),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Custom,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("archivable"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("archivable"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Archivable")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("className"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("className"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("ClassName")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_instance_adornment() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("InstanceAdornment"),
        superclass: Some(Cow::Borrowed("GuiBase3d")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Adornee"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Adornee"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_int_constrained_value() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("IntConstrainedValue"),
        superclass: Some(Cow::Borrowed("ValueBase")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("ConstrainedValue"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ConstrainedValue"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("MaxValue"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxValue"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MinValue"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MinValue"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Value"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Value"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("ConstrainedValue"),
                RbxValue::Int64 { value: 0 },
            );
            map.insert(Cow::Borrowed("MaxValue"), RbxValue::Int64 { value: 10 });
            map.insert(Cow::Borrowed("MinValue"), RbxValue::Int64 { value: 0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Value"),
                },
            );
            map.insert(Cow::Borrowed("Value"), RbxValue::Int64 { value: 0 });
            map
        },
    };
}
fn generate_int_value() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("IntValue"),
        superclass: Some(Cow::Borrowed("ValueBase")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Value"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Value"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Value"),
                },
            );
            map.insert(Cow::Borrowed("Value"), RbxValue::Int64 { value: 0 });
            map
        },
    };
}
fn generate_internal_container() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("InternalContainer"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_inventory_pages() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("InventoryPages"),
        superclass: Some(Cow::Borrowed("Pages")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_joint_instance() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("JointInstance"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(7);
            map.insert(
                Cow::Borrowed("Active"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Active"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("C0"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("C0"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("C1"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("C1"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Part0"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Part0"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Part1"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Part1"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("part1"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("part1"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Part1")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_joints_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("JointsService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::DEPRECATED
            | RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("JointsService"),
                },
            );
            map
        },
    };
}
fn generate_keyboard_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("KeyboardService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_keyframe() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Keyframe"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Time"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Time"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Keyframe"),
                },
            );
            map.insert(Cow::Borrowed("Time"), RbxValue::Float32 { value: 0.0 });
            map
        },
    };
}
fn generate_keyframe_marker() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("KeyframeMarker"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Value"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Value"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("KeyframeMarker"),
                },
            );
            map.insert(
                Cow::Borrowed("Value"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_keyframe_sequence() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("KeyframeSequence"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("AuthoredHipHeight"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AuthoredHipHeight"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Loop"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Loop"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Priority"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Priority"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("AnimationPriority")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("AuthoredHipHeight"),
                RbxValue::Float32 { value: 2.0 },
            );
            map.insert(Cow::Borrowed("Loop"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("KeyframeSequence"),
                },
            );
            map.insert(Cow::Borrowed("Priority"), RbxValue::Enum { value: 2 });
            map
        },
    };
}
fn generate_keyframe_sequence_provider() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("KeyframeSequenceProvider"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_language_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LanguageService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("LanguageService"),
                },
            );
            map
        },
    };
}
fn generate_layer_collector() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LayerCollector"),
        superclass: Some(Cow::Borrowed("GuiBase2d")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ResetOnSpawn"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ResetOnSpawn"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ZIndexBehavior"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ZIndexBehavior"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ZIndexBehavior")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_legacy_studio_bridge() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LegacyStudioBridge"),
        superclass: Some(Cow::Borrowed("ILegacyStudioBridge")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_light() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Light"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("Brightness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Brightness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Color"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Shadows"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Shadows"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_lighting() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Lighting"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(19);
            map.insert(
                Cow::Borrowed("Ambient"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Ambient"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Brightness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Brightness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ClockTime"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ClockTime"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ColorShift_Bottom"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ColorShift_Bottom"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ColorShift_Top"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ColorShift_Top"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("EnvironmentDiffuseScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EnvironmentDiffuseScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("EnvironmentSpecularScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EnvironmentSpecularScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ExposureCompensation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ExposureCompensation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FogColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FogColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FogEnd"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FogEnd"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FogStart"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FogStart"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("GeographicLatitude"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GeographicLatitude"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("GlobalShadows"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GlobalShadows"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("OutdoorAmbient"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("OutdoorAmbient"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Outlines"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Outlines"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::DEPRECATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ShadowColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ShadowColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ShadowSoftness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ShadowSoftness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Technology"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Technology"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("Technology")),
                    tags: RbxPropertyTags::NOT_SCRIPTABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TimeOfDay"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TimeOfDay"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(19);
            map.insert(
                Cow::Borrowed("Ambient"),
                RbxValue::Color3 {
                    value: [0.5, 0.5, 0.5],
                },
            );
            map.insert(
                Cow::Borrowed("Brightness"),
                RbxValue::Float32 { value: 1.0 },
            );
            map.insert(
                Cow::Borrowed("ClockTime"),
                RbxValue::Float32 { value: 14.0 },
            );
            map.insert(
                Cow::Borrowed("ColorShift_Bottom"),
                RbxValue::Color3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("ColorShift_Top"),
                RbxValue::Color3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("EnvironmentDiffuseScale"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("EnvironmentSpecularScale"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("ExposureCompensation"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("FogColor"),
                RbxValue::Color3 {
                    value: [0.75, 0.75, 0.75],
                },
            );
            map.insert(
                Cow::Borrowed("FogEnd"),
                RbxValue::Float32 { value: 100000.0 },
            );
            map.insert(Cow::Borrowed("FogStart"), RbxValue::Float32 { value: 0.0 });
            map.insert(
                Cow::Borrowed("GeographicLatitude"),
                RbxValue::Float32 { value: 41.7333 },
            );
            map.insert(
                Cow::Borrowed("GlobalShadows"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Lighting"),
                },
            );
            map.insert(
                Cow::Borrowed("OutdoorAmbient"),
                RbxValue::Color3 {
                    value: [0.5, 0.5, 0.5],
                },
            );
            map.insert(Cow::Borrowed("Outlines"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("ShadowColor"),
                RbxValue::Color3 {
                    value: [0.7, 0.7, 0.72],
                },
            );
            map.insert(
                Cow::Borrowed("ShadowSoftness"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(
                Cow::Borrowed("TimeOfDay"),
                RbxValue::String {
                    value: String::from("14:00:00"),
                },
            );
            map
        },
    };
}
fn generate_line_force() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LineForce"),
        superclass: Some(Cow::Borrowed("Constraint")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("ApplyAtCenterOfMass"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ApplyAtCenterOfMass"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("InverseSquareLaw"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("InverseSquareLaw"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Magnitude"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Magnitude"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxForce"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxForce"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ReactionForceEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ReactionForceEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(11);
            map.insert(
                Cow::Borrowed("ApplyAtCenterOfMass"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("Attachment0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Attachment1"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("InverseSquareLaw"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("Magnitude"),
                RbxValue::Float32 { value: 1000.0 },
            );
            map.insert(
                Cow::Borrowed("MaxForce"),
                RbxValue::Float32 {
                    value: 1000000000.0,
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("LineForce"),
                },
            );
            map.insert(
                Cow::Borrowed("ReactionForceEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: false });
            map
        },
    };
}
fn generate_line_handle_adornment() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LineHandleAdornment"),
        superclass: Some(Cow::Borrowed("HandleAdornment")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Length"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Length"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Thickness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Thickness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(13);
            map.insert(
                Cow::Borrowed("AdornCullingMode"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("Adornee"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("AlwaysOnTop"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("Color3"),
                RbxValue::Color3 {
                    value: [0.050980397, 0.41176474, 0.6745098],
                },
            );
            map.insert(Cow::Borrowed("Length"), RbxValue::Float32 { value: 5.0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("LineHandleAdornment"),
                },
            );
            map.insert(
                Cow::Borrowed("SizeRelativeOffset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("Thickness"), RbxValue::Float32 { value: 1.0 });
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("ZIndex"), RbxValue::Int32 { value: -1 });
            map
        },
    };
}
fn generate_local_script() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LocalScript"),
        superclass: Some(Cow::Borrowed("Script")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(Cow::Borrowed("Disabled"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("LinkedSource"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("LocalScript"),
                },
            );
            map.insert(
                Cow::Borrowed("Source"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_local_storage_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LocalStorageService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_localization_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LocalizationService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(7);
            map.insert(
                Cow::Borrowed("ForcePlayModeGameLocaleId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ForcePlayModeGameLocaleId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ForcePlayModeRobloxLocaleId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ForcePlayModeRobloxLocaleId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("IsTextScraperRunning"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsTextScraperRunning"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RobloxForcePlayModeGameLocaleId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RobloxForcePlayModeGameLocaleId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RobloxForcePlayModeRobloxLocaleId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RobloxForcePlayModeRobloxLocaleId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RobloxLocaleId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RobloxLocaleId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("SystemLocaleId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SystemLocaleId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("LocalizationService"),
                },
            );
            map
        },
    };
}
fn generate_localization_table() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LocalizationTable"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("Contents"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Contents"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Custom,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DevelopmentLanguage"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DevelopmentLanguage"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Root"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Root"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("SourceLocaleId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SourceLocaleId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("DevelopmentLanguage"),
                RbxValue::String {
                    value: String::from("en-us"),
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("LocalizationTable"),
                },
            );
            map.insert(Cow::Borrowed("Root"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("SourceLocaleId"),
                RbxValue::String {
                    value: String::from("en-us"),
                },
            );
            map
        },
    };
}
fn generate_log_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LogService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("LogService"),
                },
            );
            map
        },
    };
}
fn generate_login_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LoginService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_lua_settings() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LuaSettings"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SETTINGS,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_lua_source_container() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LuaSourceContainer"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("CurrentEditor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CurrentEditor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::NOT_SCRIPTABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_lua_web_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("LuaWebService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_manual_glue() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ManualGlue"),
        superclass: Some(Cow::Borrowed("ManualSurfaceJointInstance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("C0"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("C1"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ManualGlue"),
                },
            );
            map.insert(Cow::Borrowed("Part0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Part1"), RbxValue::Ref { value: None });
            map
        },
    };
}
fn generate_manual_surface_joint_instance() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ManualSurfaceJointInstance"),
        superclass: Some(Cow::Borrowed("JointInstance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_manual_weld() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ManualWeld"),
        superclass: Some(Cow::Borrowed("ManualSurfaceJointInstance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("C0"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("C1"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ManualWeld"),
                },
            );
            map.insert(Cow::Borrowed("Part0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Part1"), RbxValue::Ref { value: None });
            map
        },
    };
}
fn generate_marketplace_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("MarketplaceService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("MarketplaceService"),
                },
            );
            map
        },
    };
}
fn generate_mem_storage_connection() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("MemStorageConnection"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_mem_storage_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("MemStorageService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("MemStorageService"),
                },
            );
            map
        },
    };
}
fn generate_memory_store_queue() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("MemoryStoreQueue"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_memory_store_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("MemoryStoreService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("MemoryStoreService"),
                },
            );
            map
        },
    };
}
fn generate_memory_store_sorted_map() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("MemoryStoreSortedMap"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_mesh_content_provider() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("MeshContentProvider"),
        superclass: Some(Cow::Borrowed("CacheableContentProvider")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("MeshContentProvider"),
                },
            );
            map
        },
    };
}
fn generate_mesh_part() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("MeshPart"),
        superclass: Some(Cow::Borrowed("TriangleMeshPart")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(9);
            map.insert(
                Cow::Borrowed("DoubleSided"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DoubleSided"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HasJointOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HasJointOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HasSkinnedMesh"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HasSkinnedMesh"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("JointOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("JointOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MeshID"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MeshID"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_SCRIPTABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MeshId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MeshId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MeshSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MeshSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RenderFidelity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RenderFidelity"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("RenderFidelity")),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TextureID"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TextureID"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(59);
            map.insert(Cow::Borrowed("Anchored"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("AssemblyAngularVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AssemblyLinearVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("BackParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BackParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BackSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BackSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("BottomParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BottomParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BottomSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BottomSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("CanCollide"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CanTouch"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CastShadow"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("CollisionFidelity"),
                RbxValue::Enum { value: 2 },
            );
            map.insert(
                Cow::Borrowed("CollisionGroupId"),
                RbxValue::Int32 { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::Color3 {
                    value: [0.6392157, 0.63529414, 0.64705884],
                },
            );
            map.insert(
                Cow::Borrowed("CustomPhysicalProperties"),
                RbxValue::PhysicalProperties { value: None },
            );
            map.insert(
                Cow::Borrowed("DoubleSided"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("Elasticity"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("Friction"), RbxValue::Float32 { value: 0.3 });
            map.insert(
                Cow::Borrowed("FrontParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("FrontParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("FrontSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("FrontSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("HasJointOffset"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("HasSkinnedMesh"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("JointOffset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("LeftParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("LeftParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("LeftSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("LeftSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LocalTransparencyModifier"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Locked"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Massless"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Material"), RbxValue::Enum { value: 256 });
            map.insert(
                Cow::Borrowed("MeshId"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("MeshPart"),
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("PivotOffset"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Reflectance"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("RenderFidelity"), RbxValue::Enum { value: 1 });
            map.insert(
                Cow::Borrowed("RightParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("RightParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("RightSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("RightSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("RootPriority"), RbxValue::Int32 { value: 0 });
            map.insert(
                Cow::Borrowed("RotVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::Vector3 {
                    value: [4.0, 1.2, 2.0],
                },
            );
            map.insert(
                Cow::Borrowed("TextureID"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("TopParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(Cow::Borrowed("TopParamB"), RbxValue::Float32 { value: 0.5 });
            map.insert(Cow::Borrowed("TopSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("TopSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Velocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_message() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Message"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Text"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Text"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Message"),
                },
            );
            map.insert(
                Cow::Borrowed("Text"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_messaging_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("MessagingService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("MessagingService"),
                },
            );
            map
        },
    };
}
fn generate_model() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Model"),
        superclass: Some(Cow::Borrowed("PVInstance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("LevelOfDetail"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LevelOfDetail"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "ModelLevelOfDetail",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PrimaryPart"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PrimaryPart"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("World Pivot Orientation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("World Pivot Orientation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::NOT_SCRIPTABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("World Pivot Position"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("World Pivot Position"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::NOT_SCRIPTABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("WorldPivot"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WorldPivot"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(Cow::Borrowed("LevelOfDetail"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Model"),
                },
            );
            map.insert(Cow::Borrowed("PrimaryPart"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("WorldPivot"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map
        },
    };
}
fn generate_module_script() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ModuleScript"),
        superclass: Some(Cow::Borrowed("LuaSourceContainer")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("LinkedSource"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LinkedSource"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Source"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Source"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("LinkedSource"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ModuleScript"),
                },
            );
            map.insert(
                Cow::Borrowed("Source"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_motor() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Motor"),
        superclass: Some(Cow::Borrowed("JointInstance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("CurrentAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CurrentAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("DesiredAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DesiredAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxVelocity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxVelocity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(9);
            map.insert(
                Cow::Borrowed("C0"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("C1"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("CurrentAngle"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("DesiredAngle"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("MaxVelocity"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Motor"),
                },
            );
            map.insert(Cow::Borrowed("Part0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Part1"), RbxValue::Ref { value: None });
            map
        },
    };
}
fn generate_motor6_d() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Motor6D"),
        superclass: Some(Cow::Borrowed("Motor")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("ChildName"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ChildName"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::NOT_SCRIPTABLE
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ParentName"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ParentName"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::NOT_SCRIPTABLE
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Transform"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Transform"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(10);
            map.insert(
                Cow::Borrowed("C0"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("C1"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("CurrentAngle"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("DesiredAngle"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("MaxVelocity"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Motor6D"),
                },
            );
            map.insert(Cow::Borrowed("Part0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Part1"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Transform"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map
        },
    };
}
fn generate_motor_feature() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("MotorFeature"),
        superclass: Some(Cow::Borrowed("Feature")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(Cow::Borrowed("FaceId"), RbxValue::Enum { value: 0 });
            map.insert(Cow::Borrowed("InOut"), RbxValue::Enum { value: 2 });
            map.insert(Cow::Borrowed("LeftRight"), RbxValue::Enum { value: 1 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("MotorFeature"),
                },
            );
            map.insert(Cow::Borrowed("TopBottom"), RbxValue::Enum { value: 1 });
            map
        },
    };
}
fn generate_mouse() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Mouse"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(13);
            map.insert(
                Cow::Borrowed("Hit"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Hit"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Icon"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Icon"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Origin"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Origin"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Target"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Target"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("TargetFilter"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TargetFilter"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TargetSurface"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TargetSurface"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("NormalId")),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("UnitRay"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UnitRay"),
                    value_type: RbxPropertyTypeDescriptor::UnimplementedType(Cow::Borrowed("Ray")),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ViewSizeX"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ViewSizeX"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ViewSizeY"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ViewSizeY"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("X"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("X"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Y"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Y"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("hit"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("hit"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("target"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("target"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_mouse_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("MouseService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_multiple_document_interface_instance() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("MultipleDocumentInterfaceInstance"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("FocusedDataModelSession"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FocusedDataModelSession"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_negate_operation() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("NegateOperation"),
        superclass: Some(Cow::Borrowed("PartOperation")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(55);
            map.insert(Cow::Borrowed("Anchored"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("AssemblyAngularVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AssemblyLinearVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("BackParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BackParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BackSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BackSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("BottomParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BottomParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BottomSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BottomSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("CanCollide"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("CanTouch"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CastShadow"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("CollisionFidelity"),
                RbxValue::Enum { value: 2 },
            );
            map.insert(
                Cow::Borrowed("CollisionGroupId"),
                RbxValue::Int32 { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::Color3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("CustomPhysicalProperties"),
                RbxValue::PhysicalProperties { value: None },
            );
            map.insert(
                Cow::Borrowed("Elasticity"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("Friction"), RbxValue::Float32 { value: 0.3 });
            map.insert(
                Cow::Borrowed("FrontParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("FrontParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("FrontSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("FrontSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LeftParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("LeftParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("LeftSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("LeftSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LocalTransparencyModifier"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Locked"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Massless"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Material"), RbxValue::Enum { value: 256 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("NegativePart"),
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("PivotOffset"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Reflectance"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("RenderFidelity"), RbxValue::Enum { value: 1 });
            map.insert(
                Cow::Borrowed("RightParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("RightParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("RightSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("RightSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("RootPriority"), RbxValue::Int32 { value: 0 });
            map.insert(
                Cow::Borrowed("RotVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::Vector3 {
                    value: [4.0, 1.2, 2.0],
                },
            );
            map.insert(
                Cow::Borrowed("SmoothingAngle"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("TopParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(Cow::Borrowed("TopParamB"), RbxValue::Float32 { value: 0.5 });
            map.insert(Cow::Borrowed("TopSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("TopSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.1 },
            );
            map.insert(
                Cow::Borrowed("UsePartColor"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("Velocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_network_client() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("NetworkClient"),
        superclass: Some(Cow::Borrowed("NetworkPeer")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_network_marker() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("NetworkMarker"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_network_peer() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("NetworkPeer"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_network_replicator() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("NetworkReplicator"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_network_server() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("NetworkServer"),
        superclass: Some(Cow::Borrowed("NetworkPeer")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_network_settings() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("NetworkSettings"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE
            | RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(13);
            map.insert(
                Cow::Borrowed("EmulatedTotalMemoryInMB"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EmulatedTotalMemoryInMB"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("FreeMemoryMBytes"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FreeMemoryMBytes"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("HttpProxyEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HttpProxyEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HttpProxyURL"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HttpProxyURL"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("IncomingReplicationLag"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IncomingReplicationLag"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PrintJoinSizeBreakdown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PrintJoinSizeBreakdown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PrintPhysicsErrors"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PrintPhysicsErrors"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PrintStreamInstanceQuota"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PrintStreamInstanceQuota"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RandomizeJoinInstanceOrder"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RandomizeJoinInstanceOrder"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RenderStreamedRegions"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RenderStreamedRegions"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ShowActiveAnimationAsset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ShowActiveAnimationAsset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TrackDataTypes"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TrackDataTypes"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TrackPhysicsDetails"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TrackPhysicsDetails"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_no_collision_constraint() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("NoCollisionConstraint"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Part0"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Part0"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Part1"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Part1"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("NoCollisionConstraint"),
                },
            );
            map.insert(Cow::Borrowed("Part0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Part1"), RbxValue::Ref { value: None });
            map
        },
    };
}
fn generate_non_replicated_csg_dictionary_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("NonReplicatedCSGDictionaryService"),
        superclass: Some(Cow::Borrowed("FlyweightService")),
        tags: RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_notification_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("NotificationService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("IsLuaChatEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsLuaChatEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("IsLuaGameDetailsEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsLuaGameDetailsEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("SelectedTheme"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SelectedTheme"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("NotificationService"),
                },
            );
            map
        },
    };
}
fn generate_number_pose() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("NumberPose"),
        superclass: Some(Cow::Borrowed("PoseBase")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Value"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Value"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("EasingDirection"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("EasingStyle"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Pose"),
                },
            );
            map.insert(Cow::Borrowed("Value"), RbxValue::Float64 { value: 0.0 });
            map.insert(Cow::Borrowed("Weight"), RbxValue::Float32 { value: 1.0 });
            map
        },
    };
}
fn generate_number_value() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("NumberValue"),
        superclass: Some(Cow::Borrowed("ValueBase")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Value"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Value"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Value"),
                },
            );
            map.insert(Cow::Borrowed("Value"), RbxValue::Float64 { value: 0.0 });
            map
        },
    };
}
fn generate_object_value() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ObjectValue"),
        superclass: Some(Cow::Borrowed("ValueBase")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Value"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Value"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Value"),
                },
            );
            map.insert(Cow::Borrowed("Value"), RbxValue::Ref { value: None });
            map
        },
    };
}
fn generate_object_version_info() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ObjectVersionInfo"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("CreatedTime"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CreatedTime"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("IsDeleted"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsDeleted"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Version"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Version"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_ordered_data_store() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("OrderedDataStore"),
        superclass: Some(Cow::Borrowed("GlobalDataStore")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_outfit_pages() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("OutfitPages"),
        superclass: Some(Cow::Borrowed("Pages")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_pv_adornment() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PVAdornment"),
        superclass: Some(Cow::Borrowed("GuiBase3d")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Adornee"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Adornee"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_pv_instance() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PVInstance"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("Origin Orientation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Origin Orientation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::NOT_SCRIPTABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Origin Position"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Origin Position"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::NOT_SCRIPTABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Pivot Offset Orientation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Pivot Offset Orientation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::NOT_SCRIPTABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Pivot Offset Position"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Pivot Offset Position"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::NOT_SCRIPTABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_package_link() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PackageLink"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(7);
            map.insert(
                Cow::Borrowed("AutoUpdate"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutoUpdate"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_SCRIPTABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Creator"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Creator"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::NOT_SCRIPTABLE
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PackageAssetName"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PackageAssetName"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::NOT_SCRIPTABLE
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PackageId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PackageId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PermissionLevel"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PermissionLevel"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("PackagePermission")),
                    tags: RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::NOT_SCRIPTABLE
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Status"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Status"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("VersionNumber"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("VersionNumber"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_package_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PackageService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_pages() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Pages"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("IsFinished"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsFinished"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_pants() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Pants"),
        superclass: Some(Cow::Borrowed("Clothing")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("PantsTemplate"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PantsTemplate"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("Color3"),
                RbxValue::Color3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Clothing"),
                },
            );
            map.insert(
                Cow::Borrowed("PantsTemplate"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_parabola_adornment() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ParabolaAdornment"),
        superclass: Some(Cow::Borrowed("PVAdornment")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("A"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("A"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("B"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("B"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("C"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("C"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Range"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Range"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Thickness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Thickness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_part() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Part"),
        superclass: Some(Cow::Borrowed("FormFactorPart")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Shape"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Shape"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("PartType")),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: Some(Cow::Borrowed("shape")),
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("shape"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("shape"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("PartType")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("Shape")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(53);
            map.insert(Cow::Borrowed("Anchored"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("AssemblyAngularVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AssemblyLinearVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("BackParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BackParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BackSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BackSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("BottomParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BottomParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BottomSurface"), RbxValue::Enum { value: 4 });
            map.insert(
                Cow::Borrowed("BottomSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("CanCollide"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CanTouch"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CastShadow"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("CollisionGroupId"),
                RbxValue::Int32 { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::Color3 {
                    value: [0.6392157, 0.63529414, 0.64705884],
                },
            );
            map.insert(
                Cow::Borrowed("CustomPhysicalProperties"),
                RbxValue::PhysicalProperties { value: None },
            );
            map.insert(
                Cow::Borrowed("Elasticity"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("FormFactor"), RbxValue::Enum { value: 1 });
            map.insert(Cow::Borrowed("Friction"), RbxValue::Float32 { value: 0.3 });
            map.insert(
                Cow::Borrowed("FrontParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("FrontParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("FrontSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("FrontSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LeftParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("LeftParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("LeftSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("LeftSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LocalTransparencyModifier"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Locked"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Massless"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Material"), RbxValue::Enum { value: 256 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Part"),
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("PivotOffset"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Reflectance"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("RightParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("RightParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("RightSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("RightSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("RootPriority"), RbxValue::Int32 { value: 0 });
            map.insert(
                Cow::Borrowed("RotVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("Shape"), RbxValue::Enum { value: 1 });
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::Vector3 {
                    value: [4.0, 1.2, 2.0],
                },
            );
            map.insert(
                Cow::Borrowed("TopParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(Cow::Borrowed("TopParamB"), RbxValue::Float32 { value: 0.5 });
            map.insert(Cow::Borrowed("TopSurface"), RbxValue::Enum { value: 3 });
            map.insert(
                Cow::Borrowed("TopSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Velocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_part_adornment() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PartAdornment"),
        superclass: Some(Cow::Borrowed("GuiBase3d")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Adornee"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Adornee"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_part_operation() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PartOperation"),
        superclass: Some(Cow::Borrowed("TriangleMeshPart")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("RenderFidelity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RenderFidelity"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("RenderFidelity")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SmoothingAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SmoothingAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TriangleCount"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TriangleCount"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("UsePartColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UsePartColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(55);
            map.insert(Cow::Borrowed("Anchored"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("AssemblyAngularVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AssemblyLinearVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("BackParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BackParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BackSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BackSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("BottomParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BottomParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BottomSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BottomSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("CanCollide"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CanTouch"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CastShadow"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("CollisionFidelity"),
                RbxValue::Enum { value: 2 },
            );
            map.insert(
                Cow::Borrowed("CollisionGroupId"),
                RbxValue::Int32 { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::Color3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("CustomPhysicalProperties"),
                RbxValue::PhysicalProperties { value: None },
            );
            map.insert(
                Cow::Borrowed("Elasticity"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("Friction"), RbxValue::Float32 { value: 0.3 });
            map.insert(
                Cow::Borrowed("FrontParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("FrontParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("FrontSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("FrontSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LeftParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("LeftParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("LeftSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("LeftSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LocalTransparencyModifier"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Locked"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Massless"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Material"), RbxValue::Enum { value: 256 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("PartOperation"),
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("PivotOffset"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Reflectance"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("RenderFidelity"), RbxValue::Enum { value: 1 });
            map.insert(
                Cow::Borrowed("RightParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("RightParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("RightSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("RightSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("RootPriority"), RbxValue::Int32 { value: 0 });
            map.insert(
                Cow::Borrowed("RotVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::Vector3 {
                    value: [4.0, 1.2, 2.0],
                },
            );
            map.insert(
                Cow::Borrowed("SmoothingAngle"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("TopParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(Cow::Borrowed("TopParamB"), RbxValue::Float32 { value: 0.5 });
            map.insert(Cow::Borrowed("TopSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("TopSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("UsePartColor"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("Velocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_part_operation_asset() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PartOperationAsset"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_particle_emitter() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ParticleEmitter"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(22);
            map.insert(
                Cow::Borrowed("Acceleration"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Acceleration"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Color"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::ColorSequence),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Drag"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Drag"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("EmissionDirection"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EmissionDirection"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("NormalId")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Lifetime"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Lifetime"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::NumberRange),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LightEmission"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LightEmission"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LightInfluence"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LightInfluence"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LockedToPart"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LockedToPart"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Orientation"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "ParticleOrientation",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Rate"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Rate"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RotSpeed"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RotSpeed"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::NumberRange),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Rotation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::NumberRange),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Size"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::NumberSequence),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Speed"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Speed"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::NumberRange),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SpreadAngle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SpreadAngle"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Texture"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Texture"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TimeScale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TimeScale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Transparency"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::NumberSequence),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("VelocityInheritance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("VelocityInheritance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("VelocitySpread"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("VelocitySpread"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ZOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ZOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(23);
            map.insert(
                Cow::Borrowed("Acceleration"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::ColorSequence {
                    value: ColorSequence {
                        keypoints: vec![
                            ColorSequenceKeypoint {
                                time: 0.0,
                                color: [1.0, 1.0, 1.0],
                            },
                            ColorSequenceKeypoint {
                                time: 1.0,
                                color: [1.0, 1.0, 1.0],
                            },
                        ],
                    },
                },
            );
            map.insert(Cow::Borrowed("Drag"), RbxValue::Float32 { value: 0.0 });
            map.insert(
                Cow::Borrowed("EmissionDirection"),
                RbxValue::Enum { value: 1 },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Lifetime"),
                RbxValue::NumberRange { value: (5.0, 10.0) },
            );
            map.insert(
                Cow::Borrowed("LightEmission"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("LightInfluence"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("LockedToPart"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ParticleEmitter"),
                },
            );
            map.insert(Cow::Borrowed("Orientation"), RbxValue::Enum { value: 0 });
            map.insert(Cow::Borrowed("Rate"), RbxValue::Float32 { value: 20.0 });
            map.insert(
                Cow::Borrowed("RotSpeed"),
                RbxValue::NumberRange { value: (0.0, 0.0) },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxValue::NumberRange { value: (0.0, 0.0) },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::NumberSequence {
                    value: NumberSequence {
                        keypoints: vec![
                            NumberSequenceKeypoint {
                                time: 0.0,
                                value: 1.0,
                                envelope: 0.0,
                            },
                            NumberSequenceKeypoint {
                                time: 1.0,
                                value: 1.0,
                                envelope: 0.0,
                            },
                        ],
                    },
                },
            );
            map.insert(
                Cow::Borrowed("Speed"),
                RbxValue::NumberRange { value: (5.0, 5.0) },
            );
            map.insert(
                Cow::Borrowed("SpreadAngle"),
                RbxValue::Vector2 { value: [0.0, 0.0] },
            );
            map.insert(
                Cow::Borrowed("Texture"),
                RbxValue::Content {
                    value: String::from("rbxasset://textures/particles/sparkles_main.dds"),
                },
            );
            map.insert(Cow::Borrowed("TimeScale"), RbxValue::Float32 { value: 1.0 });
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::NumberSequence {
                    value: NumberSequence {
                        keypoints: vec![
                            NumberSequenceKeypoint {
                                time: 0.0,
                                value: 0.0,
                                envelope: 0.0,
                            },
                            NumberSequenceKeypoint {
                                time: 1.0,
                                value: 0.0,
                                envelope: 0.0,
                            },
                        ],
                    },
                },
            );
            map.insert(
                Cow::Borrowed("VelocityInheritance"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("VelocitySpread"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("ZOffset"), RbxValue::Float32 { value: 0.0 });
            map
        },
    };
}
fn generate_path() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Path"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Status"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Status"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("PathStatus")),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_pathfinding_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PathfindingService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("EmptyCutoff"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EmptyCutoff"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("EmptyCutoff"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_permissions_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PermissionsService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("PermissionsService"),
                },
            );
            map
        },
    };
}
fn generate_physics_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PhysicsService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("PhysicsService"),
                },
            );
            map
        },
    };
}
fn generate_physics_settings() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PhysicsSettings"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SETTINGS,
        properties: {
            let mut map = HashMap::with_capacity(26);
            map.insert(
                Cow::Borrowed("AllowSleep"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AllowSleep"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreAnchorsShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreAnchorsShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreAssembliesShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreAssembliesShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreAwakePartsHighlighted"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreAwakePartsHighlighted"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreBodyTypesShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreBodyTypesShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreContactIslandsShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreContactIslandsShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreContactPointsShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreContactPointsShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreJointCoordinatesShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreJointCoordinatesShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreMechanismsShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreMechanismsShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreModelCoordsShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreModelCoordsShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreOwnersShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreOwnersShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ArePartCoordsShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ArePartCoordsShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreRegionsShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreRegionsShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreTerrainReplicationRegionsShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreTerrainReplicationRegionsShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreTimestepsShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreTimestepsShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreUnalignedPartsShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreUnalignedPartsShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AreWorldCoordsShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AreWorldCoordsShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DisableCSGv2"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DisableCSGv2"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ForceCSGv2"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ForceCSGv2"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("IsInterpolationThrottleShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsInterpolationThrottleShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("IsReceiveAgeShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsReceiveAgeShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("IsTreeShown"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsTreeShown"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PhysicsEnvironmentalThrottle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PhysicsEnvironmentalThrottle"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "EnviromentalPhysicsThrottle",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ShowDecompositionGeometry"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ShowDecompositionGeometry"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ThrottleAdjustTime"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ThrottleAdjustTime"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("UseCSGv2"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UseCSGv2"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_pitch_shift_sound_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PitchShiftSoundEffect"),
        superclass: Some(Cow::Borrowed("SoundEffect")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Octave"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Octave"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("PitchShiftSoundEffect"),
                },
            );
            map.insert(Cow::Borrowed("Octave"), RbxValue::Float32 { value: 1.25 });
            map.insert(Cow::Borrowed("Priority"), RbxValue::Int32 { value: 0 });
            map
        },
    };
}
fn generate_platform() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Platform"),
        superclass: Some(Cow::Borrowed("Part")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_player() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Player"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(42);
            map.insert(
                Cow::Borrowed("AccountAge"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AccountAge"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AppearanceDidLoad"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AppearanceDidLoad"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AutoJumpEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutoJumpEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CameraMaxZoomDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CameraMaxZoomDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CameraMinZoomDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CameraMinZoomDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CameraMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CameraMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("CameraMode")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CanLoadCharacterAppearance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CanLoadCharacterAppearance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Character"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Character"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CharacterAppearance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CharacterAppearance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_BROWSABLE,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CharacterAppearanceId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CharacterAppearanceId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ChatMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ChatMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ChatMode")),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("DataComplexity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DataComplexity"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("DataComplexityLimit"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DataComplexityLimit"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("DataReady"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DataReady"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("DevCameraOcclusionMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DevCameraOcclusionMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "DevCameraOcclusionMode",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DevComputerCameraMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DevComputerCameraMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "DevComputerCameraMovementMode",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DevComputerMovementMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DevComputerMovementMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "DevComputerMovementMode",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DevEnableMouseLock"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DevEnableMouseLock"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DevTouchCameraMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DevTouchCameraMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "DevTouchCameraMovementMode",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DevTouchMovementMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DevTouchMovementMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "DevTouchMovementMode",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DisplayName"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DisplayName"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("FollowUserId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FollowUserId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("GameplayPaused"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GameplayPaused"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Guest"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Guest"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("HealthDisplayDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HealthDisplayDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LocaleId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LocaleId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("MaximumSimulationRadius"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaximumSimulationRadius"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("MembershipType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MembershipType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("MembershipType")),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("NameDisplayDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("NameDisplayDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Neutral"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Neutral"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("OsPlatform"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("OsPlatform"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PlatformName"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PlatformName"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ReplicationFocus"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ReplicationFocus"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RespawnLocation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RespawnLocation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SimulationRadius"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SimulationRadius"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Team"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Team"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TeamColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TeamColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Teleported"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Teleported"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("TeleportedIn"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TeleportedIn"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("UserId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UserId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("VRDevice"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("VRDevice"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("userId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("userId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int64),
                    tags: RbxPropertyTags::DEPRECATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_player_emulator_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PlayerEmulatorService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(7);
            map.insert(
                Cow::Borrowed("DEPRECATED_SerializedEmulatedPolicyInfo"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DEPRECATED_SerializedEmulatedPolicyInfo"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("EmulatedCountryCode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EmulatedCountryCode"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("EmulatedGameLocale"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EmulatedGameLocale"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PlayerEmulationEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PlayerEmulationEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PlayerEmulationEnabled_deprecated"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PlayerEmulationEnabled_deprecated"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("SerializedEmulatedPolicyInfo"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SerializedEmulatedPolicyInfo"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BinaryString),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("StudioEmulatedCountryRegionCode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("StudioEmulatedCountryRegionCode"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_player_gui() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PlayerGui"),
        superclass: Some(Cow::Borrowed("BasePlayerGui")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::PLAYER_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("CurrentScreenOrientation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CurrentScreenOrientation"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ScreenOrientation")),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ScreenOrientation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ScreenOrientation"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ScreenOrientation")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SelectionImageObject"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SelectionImageObject"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_player_mouse() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PlayerMouse"),
        superclass: Some(Cow::Borrowed("Mouse")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_player_scripts() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PlayerScripts"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_players() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Players"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(12);
            map.insert(
                Cow::Borrowed("BubbleChat"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BubbleChat"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("CharacterAutoLoads"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CharacterAutoLoads"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ClassicChat"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ClassicChat"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("LocalPlayer"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LocalPlayer"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("MaxPlayers"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxPlayers"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: Some(Cow::Borrowed("MaxPlayersInternal")),
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxPlayersInternal"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxPlayersInternal"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("MaxPlayers")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("NumPlayers"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("NumPlayers"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("PreferredPlayers"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PreferredPlayers"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: Some(Cow::Borrowed("PreferredPlayersInternal")),
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PreferredPlayersInternal"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PreferredPlayersInternal"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: false,
                    canonical_name: Some(Cow::Borrowed("PreferredPlayers")),
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("RespawnTime"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RespawnTime"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("localPlayer"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("localPlayer"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("numPlayers"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("numPlayers"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("CharacterAutoLoads"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Players"),
                },
            );
            map.insert(
                Cow::Borrowed("RespawnTime"),
                RbxValue::Float32 { value: 5.0 },
            );
            map
        },
    };
}
fn generate_plugin() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Plugin"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("CollisionEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CollisionEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("GridSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GridSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("HostDataModelType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HostDataModelType"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "StudioDataModelType",
                    )),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("HostDataModelTypeIsCurrent"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HostDataModelTypeIsCurrent"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("MultipleDocumentInterfaceInstance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MultipleDocumentInterfaceInstance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("UsesAssetInsertionDrag"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UsesAssetInsertionDrag"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_plugin_action() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PluginAction"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(7);
            map.insert(
                Cow::Borrowed("ActionId"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ActionId"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AllowBinding"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AllowBinding"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Checked"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Checked"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("DefaultShortcut"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DefaultShortcut"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("StatusTip"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("StatusTip"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Text"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Text"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_plugin_debug_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PluginDebugService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("PluginDebugService"),
                },
            );
            map
        },
    };
}
fn generate_plugin_drag_event() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PluginDragEvent"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("Data"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Data"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("MimeType"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MimeType"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Position"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Sender"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Sender"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_plugin_gui() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PluginGui"),
        superclass: Some(Cow::Borrowed("LayerCollector")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Title"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Title"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_plugin_gui_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PluginGuiService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("PluginGuiService"),
                },
            );
            map
        },
    };
}
fn generate_plugin_manager() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PluginManager"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_plugin_manager_interface() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PluginManagerInterface"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_plugin_menu() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PluginMenu"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Icon"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Icon"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Title"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Title"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_plugin_mouse() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PluginMouse"),
        superclass: Some(Cow::Borrowed("Mouse")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_plugin_policy_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PluginPolicyService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_plugin_toolbar() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PluginToolbar"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_plugin_toolbar_button() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PluginToolbarButton"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("ClickableWhenViewportHidden"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ClickableWhenViewportHidden"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Icon"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Icon"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_point_light() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PointLight"),
        superclass: Some(Cow::Borrowed("Light")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Range"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Range"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("Brightness"),
                RbxValue::Float32 { value: 1.0 },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::Color3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("PointLight"),
                },
            );
            map.insert(Cow::Borrowed("Range"), RbxValue::Float32 { value: 8.0 });
            map.insert(Cow::Borrowed("Shadows"), RbxValue::Bool { value: false });
            map
        },
    };
}
fn generate_points_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PointsService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::DEPRECATED
            | RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("PointsService"),
                },
            );
            map
        },
    };
}
fn generate_policy_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PolicyService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("IsLuobuServer"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsLuobuServer"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("TriStateBoolean")),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LuobuWhitelisted"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LuobuWhitelisted"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("TriStateBoolean")),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("PolicyService"),
                },
            );
            map
        },
    };
}
fn generate_pose() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Pose"),
        superclass: Some(Cow::Borrowed("PoseBase")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CFrame"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaskWeight"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaskWeight"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::DEPRECATED | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("EasingDirection"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("EasingStyle"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("MaskWeight"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Pose"),
                },
            );
            map.insert(Cow::Borrowed("Weight"), RbxValue::Float32 { value: 1.0 });
            map
        },
    };
}
fn generate_pose_base() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PoseBase"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("EasingDirection"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EasingDirection"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "PoseEasingDirection",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("EasingStyle"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EasingStyle"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("PoseEasingStyle")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Weight"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Weight"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_post_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PostEffect"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_prismatic_constraint() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PrismaticConstraint"),
        superclass: Some(Cow::Borrowed("SlidingBallConstraint")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(19);
            map.insert(Cow::Borrowed("ActuatorType"), RbxValue::Enum { value: 0 });
            map.insert(Cow::Borrowed("Attachment0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Attachment1"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(1009).unwrap(),
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("LimitsEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("LinearResponsiveness"),
                RbxValue::Float32 { value: 45.0 },
            );
            map.insert(
                Cow::Borrowed("LowerLimit"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("MotorMaxAcceleration"),
                RbxValue::Float32 {
                    value: 1000000000.0,
                },
            );
            map.insert(
                Cow::Borrowed("MotorMaxForce"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("PrismaticConstraint"),
                },
            );
            map.insert(
                Cow::Borrowed("Restitution"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("ServoMaxForce"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Size"), RbxValue::Float32 { value: 0.15 });
            map.insert(Cow::Borrowed("Speed"), RbxValue::Float32 { value: 0.0 });
            map.insert(
                Cow::Borrowed("TargetPosition"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("UpperLimit"),
                RbxValue::Float32 { value: 5.0 },
            );
            map.insert(Cow::Borrowed("Velocity"), RbxValue::Float32 { value: 0.0 });
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: false });
            map
        },
    };
}
fn generate_proximity_prompt() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ProximityPrompt"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(14);
            map.insert(
                Cow::Borrowed("ActionText"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ActionText"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("AutoLocalize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutoLocalize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ClickablePrompt"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ClickablePrompt"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Exclusivity"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Exclusivity"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "ProximityPromptExclusivity",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("GamepadKeyCode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GamepadKeyCode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("KeyCode")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HoldDuration"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HoldDuration"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("KeyboardKeyCode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("KeyboardKeyCode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("KeyCode")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxActivationDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxActivationDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ObjectText"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ObjectText"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RequiresLineOfSight"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RequiresLineOfSight"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RootLocalizationTable"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RootLocalizationTable"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Style"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Style"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "ProximityPromptStyle",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("UIOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UIOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(15);
            map.insert(
                Cow::Borrowed("ActionText"),
                RbxValue::String {
                    value: String::from("Interact"),
                },
            );
            map.insert(
                Cow::Borrowed("AutoLocalize"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("ClickablePrompt"),
                RbxValue::Bool { value: true },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("Exclusivity"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("GamepadKeyCode"),
                RbxValue::Enum { value: 1000 },
            );
            map.insert(
                Cow::Borrowed("HoldDuration"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("KeyboardKeyCode"),
                RbxValue::Enum { value: 101 },
            );
            map.insert(
                Cow::Borrowed("MaxActivationDistance"),
                RbxValue::Float32 { value: 10.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ProximityPrompt"),
                },
            );
            map.insert(
                Cow::Borrowed("ObjectText"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("RequiresLineOfSight"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("RootLocalizationTable"),
                RbxValue::Ref { value: None },
            );
            map.insert(Cow::Borrowed("Style"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("UIOffset"),
                RbxValue::Vector2 { value: [0.0, 0.0] },
            );
            map
        },
    };
}
fn generate_proximity_prompt_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ProximityPromptService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Enabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Enabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxPromptsVisible"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxPromptsVisible"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("MaxPromptsVisible"),
                RbxValue::Int32 { value: 16 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ProximityPromptService"),
                },
            );
            map
        },
    };
}
fn generate_publish_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("PublishService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_q_widget_plugin_gui() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("QWidgetPluginGui"),
        superclass: Some(Cow::Borrowed("PluginGui")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::NOT_REPLICATED,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_ray_value() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RayValue"),
        superclass: Some(Cow::Borrowed("ValueBase")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Value"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Value"),
                    value_type: RbxPropertyTypeDescriptor::UnimplementedType(Cow::Borrowed("Ray")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Value"),
                },
            );
            map
        },
    };
}
fn generate_rbx_analytics_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RbxAnalyticsService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_reflection_metadata() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadata"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_reflection_metadata_callbacks() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadataCallbacks"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_reflection_metadata_class() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadataClass"),
        superclass: Some(Cow::Borrowed("ReflectionMetadataItem")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("ExplorerImageIndex"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ExplorerImageIndex"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ExplorerOrder"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ExplorerOrder"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Insertable"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Insertable"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PreferredParent"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PreferredParent"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(19);
            map.insert(Cow::Borrowed("Browsable"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("ClassCategory"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("ClientOnly"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Constraint"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("Deprecated"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("EditingDisabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("ExplorerImageIndex"),
                RbxValue::Int32 { value: 0 },
            );
            map.insert(
                Cow::Borrowed("ExplorerOrder"),
                RbxValue::Int32 { value: 2147483647 },
            );
            map.insert(Cow::Borrowed("Insertable"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("IsBackend"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map.insert(
                Cow::Borrowed("PreferredParent"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("PropertyOrder"),
                RbxValue::Int32 { value: 5000 },
            );
            map.insert(
                Cow::Borrowed("ScriptContext"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("ServerOnly"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("UIMaximum"), RbxValue::Float64 { value: 0.0 });
            map.insert(Cow::Borrowed("UIMinimum"), RbxValue::Float64 { value: 0.0 });
            map.insert(
                Cow::Borrowed("UINumTicks"),
                RbxValue::Float64 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("summary"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_reflection_metadata_classes() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadataClasses"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_reflection_metadata_enum() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadataEnum"),
        superclass: Some(Cow::Borrowed("ReflectionMetadataItem")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(15);
            map.insert(Cow::Borrowed("Browsable"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("ClassCategory"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("ClientOnly"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Constraint"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("Deprecated"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("EditingDisabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("IsBackend"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map.insert(
                Cow::Borrowed("PropertyOrder"),
                RbxValue::Int32 { value: 5000 },
            );
            map.insert(
                Cow::Borrowed("ScriptContext"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("ServerOnly"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("UIMaximum"), RbxValue::Float64 { value: 0.0 });
            map.insert(Cow::Borrowed("UIMinimum"), RbxValue::Float64 { value: 0.0 });
            map.insert(
                Cow::Borrowed("UINumTicks"),
                RbxValue::Float64 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("summary"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_reflection_metadata_enum_item() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadataEnumItem"),
        superclass: Some(Cow::Borrowed("ReflectionMetadataItem")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(15);
            map.insert(Cow::Borrowed("Browsable"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("ClassCategory"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("ClientOnly"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Constraint"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("Deprecated"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("EditingDisabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("IsBackend"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map.insert(
                Cow::Borrowed("PropertyOrder"),
                RbxValue::Int32 { value: 5000 },
            );
            map.insert(
                Cow::Borrowed("ScriptContext"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("ServerOnly"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("UIMaximum"), RbxValue::Float64 { value: 0.0 });
            map.insert(Cow::Borrowed("UIMinimum"), RbxValue::Float64 { value: 0.0 });
            map.insert(
                Cow::Borrowed("UINumTicks"),
                RbxValue::Float64 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("summary"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_reflection_metadata_enums() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadataEnums"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_reflection_metadata_events() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadataEvents"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_reflection_metadata_functions() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadataFunctions"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_reflection_metadata_item() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadataItem"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(14);
            map.insert(
                Cow::Borrowed("Browsable"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Browsable"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ClassCategory"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ClassCategory"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ClientOnly"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ClientOnly"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Constraint"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Constraint"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Deprecated"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Deprecated"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("EditingDisabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EditingDisabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("IsBackend"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsBackend"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("PropertyOrder"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("PropertyOrder"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ScriptContext"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ScriptContext"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ServerOnly"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ServerOnly"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("UIMaximum"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UIMaximum"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("UIMinimum"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UIMinimum"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("UINumTicks"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("UINumTicks"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float64),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("summary"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("summary"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_reflection_metadata_member() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadataMember"),
        superclass: Some(Cow::Borrowed("ReflectionMetadataItem")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(15);
            map.insert(Cow::Borrowed("Browsable"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("ClassCategory"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("ClientOnly"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Constraint"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("Deprecated"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("EditingDisabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("IsBackend"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map.insert(
                Cow::Borrowed("PropertyOrder"),
                RbxValue::Int32 { value: 5000 },
            );
            map.insert(
                Cow::Borrowed("ScriptContext"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(Cow::Borrowed("ServerOnly"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("UIMaximum"), RbxValue::Float64 { value: 0.0 });
            map.insert(Cow::Borrowed("UIMinimum"), RbxValue::Float64 { value: 0.0 });
            map.insert(
                Cow::Borrowed("UINumTicks"),
                RbxValue::Float64 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("summary"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_reflection_metadata_properties() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadataProperties"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_reflection_metadata_yield_functions() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReflectionMetadataYieldFunctions"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_remote_event() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RemoteEvent"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("RemoteEvent"),
                },
            );
            map
        },
    };
}
fn generate_remote_function() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RemoteFunction"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("RemoteFunction"),
                },
            );
            map
        },
    };
}
fn generate_render_settings() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RenderSettings"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE
            | RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(13);
            map.insert(
                Cow::Borrowed("AutoFRMLevel"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutoFRMLevel"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("EagerBulkExecution"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EagerBulkExecution"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("EditQualityLevel"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EditQualityLevel"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("QualityLevel")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("EnableFRM"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("EnableFRM"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("ExportMergeByMaterial"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ExportMergeByMaterial"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FrameRateManager"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FrameRateManager"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "FramerateManagerMode",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("GraphicsMode"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("GraphicsMode"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("GraphicsMode")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MeshCacheSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MeshCacheSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MeshPartDetailLevel"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MeshPartDetailLevel"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "MeshPartDetailLevel",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("QualityLevel"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("QualityLevel"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("QualityLevel")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ReloadAssets"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ReloadAssets"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("RenderCSGTrianglesDebug"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("RenderCSGTrianglesDebug"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ShowBoundingBoxes"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ShowBoundingBoxes"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_rendering_test() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RenderingTest"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(11);
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CFrame"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::CFrame),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ComparisonDiffThreshold"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ComparisonDiffThreshold"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ComparisonMethod"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ComparisonMethod"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "RenderingTestComparisonMethod",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ComparisonPsnrThreshold"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ComparisonPsnrThreshold"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Description"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Description"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("FieldOfView"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("FieldOfView"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Orientation"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Position"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("QualityLevel"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("QualityLevel"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ShouldSkip"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ShouldSkip"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Ticket"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Ticket"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(12);
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("ComparisonDiffThreshold"),
                RbxValue::Int32 { value: 10 },
            );
            map.insert(
                Cow::Borrowed("ComparisonMethod"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("ComparisonPsnrThreshold"),
                RbxValue::Float32 { value: 50.0 },
            );
            map.insert(
                Cow::Borrowed("Description"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("FieldOfView"),
                RbxValue::Float32 { value: 70.0 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("RenderingTest"),
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("QualityLevel"), RbxValue::Int32 { value: 21 });
            map.insert(Cow::Borrowed("ShouldSkip"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Ticket"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_replicated_first() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReplicatedFirst"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ReplicatedFirst"),
                },
            );
            map
        },
    };
}
fn generate_replicated_script_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReplicatedScriptService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ReplicatedScriptService"),
                },
            );
            map
        },
    };
}
fn generate_replicated_storage() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReplicatedStorage"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ReplicatedStorage"),
                },
            );
            map
        },
    };
}
fn generate_reverb_sound_effect() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ReverbSoundEffect"),
        superclass: Some(Cow::Borrowed("SoundEffect")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(5);
            map.insert(
                Cow::Borrowed("DecayTime"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DecayTime"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Density"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Density"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Diffusion"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Diffusion"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("DryLevel"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DryLevel"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("WetLevel"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("WetLevel"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(8);
            map.insert(Cow::Borrowed("DecayTime"), RbxValue::Float32 { value: 1.5 });
            map.insert(Cow::Borrowed("Density"), RbxValue::Float32 { value: 1.0 });
            map.insert(Cow::Borrowed("Diffusion"), RbxValue::Float32 { value: 1.0 });
            map.insert(Cow::Borrowed("DryLevel"), RbxValue::Float32 { value: -6.0 });
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ReverbSoundEffect"),
                },
            );
            map.insert(Cow::Borrowed("Priority"), RbxValue::Int32 { value: 0 });
            map.insert(Cow::Borrowed("WetLevel"), RbxValue::Float32 { value: 0.0 });
            map
        },
    };
}
fn generate_roblox_plugin_gui_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RobloxPluginGuiService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_roblox_replicated_storage() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RobloxReplicatedStorage"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_BROWSABLE
            | RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_rocket_propulsion() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RocketPropulsion"),
        superclass: Some(Cow::Borrowed("BodyMover")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(11);
            map.insert(
                Cow::Borrowed("CartoonFactor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CartoonFactor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxSpeed"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxSpeed"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxThrust"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxThrust"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxTorque"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxTorque"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Target"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Target"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TargetOffset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TargetOffset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TargetRadius"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TargetRadius"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ThrustD"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ThrustD"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ThrustP"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ThrustP"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TurnD"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TurnD"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TurnP"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TurnP"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(12);
            map.insert(
                Cow::Borrowed("CartoonFactor"),
                RbxValue::Float32 { value: 0.7 },
            );
            map.insert(Cow::Borrowed("MaxSpeed"), RbxValue::Float32 { value: 30.0 });
            map.insert(
                Cow::Borrowed("MaxThrust"),
                RbxValue::Float32 { value: 4000.0 },
            );
            map.insert(
                Cow::Borrowed("MaxTorque"),
                RbxValue::Vector3 {
                    value: [400000.0, 400000.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("RocketPropulsion"),
                },
            );
            map.insert(Cow::Borrowed("Target"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("TargetOffset"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("TargetRadius"),
                RbxValue::Float32 { value: 4.0 },
            );
            map.insert(Cow::Borrowed("ThrustD"), RbxValue::Float32 { value: 0.001 });
            map.insert(Cow::Borrowed("ThrustP"), RbxValue::Float32 { value: 5.0 });
            map.insert(Cow::Borrowed("TurnD"), RbxValue::Float32 { value: 500.0 });
            map.insert(Cow::Borrowed("TurnP"), RbxValue::Float32 { value: 3000.0 });
            map
        },
    };
}
fn generate_rod_constraint() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RodConstraint"),
        superclass: Some(Cow::Borrowed("Constraint")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("CurrentDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CurrentDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Length"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Length"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LimitAngle0"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LimitAngle0"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LimitAngle1"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LimitAngle1"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("LimitsEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LimitsEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Thickness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Thickness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(11);
            map.insert(Cow::Borrowed("Attachment0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Attachment1"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(26).unwrap(),
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("Length"), RbxValue::Float32 { value: 5.0 });
            map.insert(
                Cow::Borrowed("LimitAngle0"),
                RbxValue::Float32 { value: 90.0 },
            );
            map.insert(
                Cow::Borrowed("LimitAngle1"),
                RbxValue::Float32 { value: 90.0 },
            );
            map.insert(
                Cow::Borrowed("LimitsEnabled"),
                RbxValue::Bool { value: false },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("RodConstraint"),
                },
            );
            map.insert(Cow::Borrowed("Thickness"), RbxValue::Float32 { value: 0.1 });
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: false });
            map
        },
    };
}
fn generate_rope_constraint() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RopeConstraint"),
        superclass: Some(Cow::Borrowed("Constraint")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("CurrentDistance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CurrentDistance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Length"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Length"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Restitution"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Restitution"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Thickness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Thickness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(9);
            map.insert(Cow::Borrowed("Attachment0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Attachment1"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(25).unwrap(),
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("Length"), RbxValue::Float32 { value: 5.0 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("RopeConstraint"),
                },
            );
            map.insert(
                Cow::Borrowed("Restitution"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Thickness"), RbxValue::Float32 { value: 0.1 });
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: false });
            map
        },
    };
}
fn generate_rotate() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Rotate"),
        superclass: Some(Cow::Borrowed("JointInstance")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(6);
            map.insert(
                Cow::Borrowed("C0"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("C1"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Rotate"),
                },
            );
            map.insert(Cow::Borrowed("Part0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Part1"), RbxValue::Ref { value: None });
            map
        },
    };
}
fn generate_rotate_p() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RotateP"),
        superclass: Some(Cow::Borrowed("DynamicRotate")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(7);
            map.insert(Cow::Borrowed("BaseAngle"), RbxValue::Float32 { value: 0.0 });
            map.insert(
                Cow::Borrowed("C0"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("C1"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("RotateP"),
                },
            );
            map.insert(Cow::Borrowed("Part0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Part1"), RbxValue::Ref { value: None });
            map
        },
    };
}
fn generate_rotate_v() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RotateV"),
        superclass: Some(Cow::Borrowed("DynamicRotate")),
        tags: RbxInstanceTags::empty(),
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(7);
            map.insert(Cow::Borrowed("BaseAngle"), RbxValue::Float32 { value: 0.0 });
            map.insert(
                Cow::Borrowed("C0"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("C1"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("RotateV"),
                },
            );
            map.insert(Cow::Borrowed("Part0"), RbxValue::Ref { value: None });
            map.insert(Cow::Borrowed("Part1"), RbxValue::Ref { value: None });
            map
        },
    };
}
fn generate_run_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RunService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Run Service"),
                },
            );
            map
        },
    };
}
fn generate_running_average_item_double() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RunningAverageItemDouble"),
        superclass: Some(Cow::Borrowed("StatsItem")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_running_average_item_int() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RunningAverageItemInt"),
        superclass: Some(Cow::Borrowed("StatsItem")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_running_average_time_interval_item() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RunningAverageTimeIntervalItem"),
        superclass: Some(Cow::Borrowed("StatsItem")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_runtime_script_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("RuntimeScriptService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: HashMap::new(),
    };
}
fn generate_screen_gui() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ScreenGui"),
        superclass: Some(Cow::Borrowed("LayerCollector")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(3);
            map.insert(
                Cow::Borrowed("DisplayOrder"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("DisplayOrder"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("IgnoreGuiInset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IgnoreGuiInset"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("OnTopOfCoreBlur"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("OnTopOfCoreBlur"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(9);
            map.insert(
                Cow::Borrowed("AutoLocalize"),
                RbxValue::Bool { value: true },
            );
            map.insert(Cow::Borrowed("DisplayOrder"), RbxValue::Int32 { value: 0 });
            map.insert(Cow::Borrowed("Enabled"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("IgnoreGuiInset"),
                RbxValue::Bool { value: false },
            );
            map.insert(Cow::Borrowed("Localize"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ScreenGui"),
                },
            );
            map.insert(
                Cow::Borrowed("ResetOnSpawn"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("RootLocalizationTable"),
                RbxValue::Ref { value: None },
            );
            map.insert(Cow::Borrowed("ZIndexBehavior"), RbxValue::Enum { value: 0 });
            map
        },
    };
}
fn generate_script() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Script"),
        superclass: Some(Cow::Borrowed("BaseScript")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Source"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Source"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::String),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(Cow::Borrowed("Disabled"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("LinkedSource"),
                RbxValue::Content {
                    value: String::from(""),
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Script"),
                },
            );
            map.insert(
                Cow::Borrowed("Source"),
                RbxValue::String {
                    value: String::from(""),
                },
            );
            map
        },
    };
}
fn generate_script_context() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ScriptContext"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE
            | RbxInstanceTags::NOT_REPLICATED
            | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("ScriptsDisabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ScriptsDisabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::HIDDEN,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::None,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Script Context"),
                },
            );
            map
        },
    };
}
fn generate_script_debugger() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ScriptDebugger"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("CurrentLine"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CurrentLine"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("IsDebugging"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsDebugging"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("IsPaused"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("IsPaused"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("Script"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Script"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_script_service() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ScriptService"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: HashMap::new(),
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Instance"),
                },
            );
            map
        },
    };
}
fn generate_scrolling_frame() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("ScrollingFrame"),
        superclass: Some(Cow::Borrowed("GuiObject")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(20);
            map.insert(
                Cow::Borrowed("AbsoluteCanvasSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AbsoluteCanvasSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AbsoluteWindowSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AbsoluteWindowSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("AutomaticCanvasSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("AutomaticCanvasSize"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("AutomaticSize")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("BottomImage"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("BottomImage"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CanvasPosition"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CanvasPosition"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("CanvasSize"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("CanvasSize"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::UDim2),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ElasticBehavior"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ElasticBehavior"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ElasticBehavior")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("HorizontalBarRect"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HorizontalBarRect"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Rect),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("HorizontalScrollBarInset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("HorizontalScrollBarInset"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ScrollBarInset")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("MaxCanvasPosition"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MaxCanvasPosition"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Vector2),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("MidImage"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("MidImage"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ScrollBarImageColor3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ScrollBarImageColor3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ScrollBarImageTransparency"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ScrollBarImageTransparency"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ScrollBarThickness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ScrollBarThickness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Int32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ScrollingDirection"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ScrollingDirection"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "ScrollingDirection",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("ScrollingEnabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ScrollingEnabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("TopImage"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("TopImage"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Content),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("VerticalBarRect"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("VerticalBarRect"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Rect),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("VerticalScrollBarInset"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("VerticalScrollBarInset"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed("ScrollBarInset")),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("VerticalScrollBarPosition"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("VerticalScrollBarPosition"),
                    value_type: RbxPropertyTypeDescriptor::Enum(Cow::Borrowed(
                        "VerticalScrollBarPosition",
                    )),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(45);
            map.insert(Cow::Borrowed("Active"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("AnchorPoint"),
                RbxValue::Vector2 { value: [0.0, 0.0] },
            );
            map.insert(
                Cow::Borrowed("AutoLocalize"),
                RbxValue::Bool { value: true },
            );
            map.insert(
                Cow::Borrowed("AutomaticCanvasSize"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("AutomaticSize"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BackgroundColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(194).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("BackgroundColor3"),
                RbxValue::Color3 {
                    value: [0.6392157, 0.63529414, 0.64705884],
                },
            );
            map.insert(
                Cow::Borrowed("BackgroundTransparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("BorderColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(26).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("BorderColor3"),
                RbxValue::Color3 {
                    value: [0.10588236, 0.16470589, 0.20784315],
                },
            );
            map.insert(Cow::Borrowed("BorderMode"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BorderSizePixel"),
                RbxValue::Int32 { value: 1 },
            );
            map.insert(
                Cow::Borrowed("BottomImage"),
                RbxValue::Content {
                    value: String::from("rbxasset://textures/ui/Scroll/scroll-bottom.png"),
                },
            );
            map.insert(
                Cow::Borrowed("CanvasPosition"),
                RbxValue::Vector2 { value: [0.0, 0.0] },
            );
            map.insert(
                Cow::Borrowed("CanvasSize"),
                RbxValue::UDim2 {
                    value: (0.0, 0, 2.0, 0),
                },
            );
            map.insert(
                Cow::Borrowed("ClipsDescendants"),
                RbxValue::Bool { value: true },
            );
            map.insert(Cow::Borrowed("Draggable"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("ElasticBehavior"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("HorizontalScrollBarInset"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("LayoutOrder"), RbxValue::Int32 { value: 0 });
            map.insert(Cow::Borrowed("Localize"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("MidImage"),
                RbxValue::Content {
                    value: String::from("rbxasset://textures/ui/Scroll/scroll-middle.png"),
                },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("ScrollingFrame"),
                },
            );
            map.insert(
                Cow::Borrowed("NextSelectionDown"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("NextSelectionLeft"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("NextSelectionRight"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("NextSelectionUp"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::UDim2 {
                    value: (0.0, 0, 0.0, 0),
                },
            );
            map.insert(
                Cow::Borrowed("RootLocalizationTable"),
                RbxValue::Ref { value: None },
            );
            map.insert(Cow::Borrowed("Rotation"), RbxValue::Float32 { value: 0.0 });
            map.insert(
                Cow::Borrowed("ScrollBarImageColor3"),
                RbxValue::Color3 {
                    value: [1.0, 1.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("ScrollBarImageTransparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("ScrollBarThickness"),
                RbxValue::Int32 { value: 12 },
            );
            map.insert(
                Cow::Borrowed("ScrollingDirection"),
                RbxValue::Enum { value: 4 },
            );
            map.insert(
                Cow::Borrowed("ScrollingEnabled"),
                RbxValue::Bool { value: true },
            );
            map.insert(Cow::Borrowed("Selectable"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("SelectionImageObject"),
                RbxValue::Ref { value: None },
            );
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::UDim2 {
                    value: (0.0, 0, 0.0, 0),
                },
            );
            map.insert(Cow::Borrowed("SizeConstraint"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("TopImage"),
                RbxValue::Content {
                    value: String::from("rbxasset://textures/ui/Scroll/scroll-top.png"),
                },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("VerticalScrollBarInset"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("VerticalScrollBarPosition"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("ZIndex"), RbxValue::Int32 { value: 1 });
            map
        },
    };
}
fn generate_seat() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Seat"),
        superclass: Some(Cow::Borrowed("Part")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(2);
            map.insert(
                Cow::Borrowed("Disabled"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Disabled"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Bool),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("Occupant"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Occupant"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::NOT_REPLICATED | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(54);
            map.insert(Cow::Borrowed("Anchored"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("AssemblyAngularVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("AssemblyLinearVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("BackParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BackParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BackSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("BackSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("BottomParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("BottomParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("BottomSurface"), RbxValue::Enum { value: 4 });
            map.insert(
                Cow::Borrowed("BottomSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("CFrame"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(Cow::Borrowed("CanCollide"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CanTouch"), RbxValue::Bool { value: true });
            map.insert(Cow::Borrowed("CastShadow"), RbxValue::Bool { value: true });
            map.insert(
                Cow::Borrowed("CollisionGroupId"),
                RbxValue::Int32 { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::Color3 {
                    value: [0.6392157, 0.63529414, 0.64705884],
                },
            );
            map.insert(
                Cow::Borrowed("CustomPhysicalProperties"),
                RbxValue::PhysicalProperties { value: None },
            );
            map.insert(Cow::Borrowed("Disabled"), RbxValue::Bool { value: false });
            map.insert(
                Cow::Borrowed("Elasticity"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("FormFactor"), RbxValue::Enum { value: 1 });
            map.insert(Cow::Borrowed("Friction"), RbxValue::Float32 { value: 0.3 });
            map.insert(
                Cow::Borrowed("FrontParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("FrontParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("FrontSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("FrontSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LeftParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("LeftParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("LeftSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("LeftSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("LocalTransparencyModifier"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Locked"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Massless"), RbxValue::Bool { value: false });
            map.insert(Cow::Borrowed("Material"), RbxValue::Enum { value: 256 });
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Seat"),
                },
            );
            map.insert(
                Cow::Borrowed("Orientation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("PivotOffset"),
                RbxValue::CFrame {
                    value: [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0],
                },
            );
            map.insert(
                Cow::Borrowed("Position"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Reflectance"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("RightParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(
                Cow::Borrowed("RightParamB"),
                RbxValue::Float32 { value: 0.5 },
            );
            map.insert(Cow::Borrowed("RightSurface"), RbxValue::Enum { value: 0 });
            map.insert(
                Cow::Borrowed("RightSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(Cow::Borrowed("RootPriority"), RbxValue::Int32 { value: 0 });
            map.insert(
                Cow::Borrowed("RotVelocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(
                Cow::Borrowed("Rotation"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map.insert(Cow::Borrowed("Shape"), RbxValue::Enum { value: 1 });
            map.insert(
                Cow::Borrowed("Size"),
                RbxValue::Vector3 {
                    value: [4.0, 1.2, 2.0],
                },
            );
            map.insert(
                Cow::Borrowed("TopParamA"),
                RbxValue::Float32 { value: -0.5 },
            );
            map.insert(Cow::Borrowed("TopParamB"), RbxValue::Float32 { value: 0.5 });
            map.insert(Cow::Borrowed("TopSurface"), RbxValue::Enum { value: 3 });
            map.insert(
                Cow::Borrowed("TopSurfaceInput"),
                RbxValue::Enum { value: 0 },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(
                Cow::Borrowed("Velocity"),
                RbxValue::Vector3 {
                    value: [0.0, 0.0, 0.0],
                },
            );
            map
        },
    };
}
fn generate_selection() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("Selection"),
        superclass: Some(Cow::Borrowed("Instance")),
        tags: RbxInstanceTags::NOT_CREATABLE | RbxInstanceTags::SERVICE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("ActiveInstance"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("ActiveInstance"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED
                        | RbxPropertyTags::READ_ONLY,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::Read,
                    serializes: false,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("Selection"),
                },
            );
            map
        },
    };
}
fn generate_selection_box() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("SelectionBox"),
        superclass: Some(Cow::Borrowed("InstanceAdornment")),
        tags: RbxInstanceTags::empty(),
        properties: {
            let mut map = HashMap::with_capacity(4);
            map.insert(
                Cow::Borrowed("LineThickness"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("LineThickness"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SurfaceColor"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SurfaceColor"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::BrickColor),
                    tags: RbxPropertyTags::DEPRECATED
                        | RbxPropertyTags::HIDDEN
                        | RbxPropertyTags::NOT_REPLICATED,
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: false,
                },
            );
            map.insert(
                Cow::Borrowed("SurfaceColor3"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SurfaceColor3"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Color3),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map.insert(
                Cow::Borrowed("SurfaceTransparency"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("SurfaceTransparency"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Float32),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: {
            let mut map = HashMap::with_capacity(10);
            map.insert(Cow::Borrowed("Adornee"), RbxValue::Ref { value: None });
            map.insert(
                Cow::Borrowed("Color"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("Color3"),
                RbxValue::Color3 {
                    value: [0.050980397, 0.41176474, 0.6745098],
                },
            );
            map.insert(
                Cow::Borrowed("LineThickness"),
                RbxValue::Float32 { value: 0.15 },
            );
            map.insert(
                Cow::Borrowed("Name"),
                RbxValue::String {
                    value: String::from("SelectionBox"),
                },
            );
            map.insert(
                Cow::Borrowed("SurfaceColor"),
                RbxValue::BrickColor {
                    value: BrickColor::from_number(23).unwrap(),
                },
            );
            map.insert(
                Cow::Borrowed("SurfaceColor3"),
                RbxValue::Color3 {
                    value: [0.050980397, 0.41176474, 0.6745098],
                },
            );
            map.insert(
                Cow::Borrowed("SurfaceTransparency"),
                RbxValue::Float32 { value: 1.0 },
            );
            map.insert(
                Cow::Borrowed("Transparency"),
                RbxValue::Float32 { value: 0.0 },
            );
            map.insert(Cow::Borrowed("Visible"), RbxValue::Bool { value: true });
            map
        },
    };
}
fn generate_selection_lasso() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("SelectionLasso"),
        superclass: Some(Cow::Borrowed("GuiBase3d")),
        tags: RbxInstanceTags::NOT_CREATABLE,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Borrowed("Humanoid"),
                RbxPropertyDescriptor {
                    name: Cow::Borrowed("Humanoid"),
                    value_type: RbxPropertyTypeDescriptor::Data(RbxValueType::Ref),
                    tags: RbxPropertyTags::empty(),
                    is_canonical: true,
                    canonical_name: None,
                    serialized_name: None,
                    scriptability: RbxPropertyScriptability::ReadWrite,
                    serializes: true,
                },
            );
            map
        },
        default_properties: HashMap::new(),
    };
}
fn generate_selection_part_lasso() -> RbxClassDescriptor {
    return RbxClassDescriptor {
        name: Cow::Borrowed("SelectionPartLasso"),
        superclass: Some(Cow::Borrowed("SelectionLasso")),
        tags: RbxInstanceTags::DEPRECATED,
        properties: {
            let mut map = HashMap::with_capacity(1);
            map.insert(
                Cow::Bo