extern crate rbspy;

fn main() {
    let output_filename = "flamegraph.svg";
    let output_path = std::path::PathBuf::from(output_filename);
    let mut output = match std::fs::File::create(output_path) {
        Ok(file) => file,
        Err(e) => {
            eprintln!(
                "Failed to create output file '{}': {:?}",
                output_filename, e
            );
            return;
        }
    };
    match rbspy::report(
        rbspy::OutputFormat::flamegraph,
        &mut sample_trace().as_slice(),
        &mut output,
    ) {
        Ok(()) => println!("Report written to {}", output_filename),
        Err(e) => println!("Failed to create report: {:?}", e),
    }
}

fn sample_trace() -> Vec<u8> {
    // Trace generated by `rbspy record --raw-file raw.txt -- ruby ci/ruby-programs/short_program.rb`
    vec![
        0x1F, 0x8B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xED, 0xDC, 0xDD, 0x6A, 0xDB,
        0x30, 0x14, 0x07, 0xF0, 0xFB, 0x3D, 0x45, 0xD1, 0xD5, 0x06, 0x5E, 0x7C, 0x64, 0x2B, 0xFA,
        0x08, 0x63, 0x6F, 0xB1, 0xAB, 0x52, 0x8C, 0xEC, 0x6A, 0x8B, 0x3B, 0x47, 0x36, 0xB2, 0xD3,
        0x51, 0x4A, 0xDE, 0x7D, 0x4A, 0xD7, 0x8E, 0xB0, 0x15, 0x5A, 0x38, 0xB9, 0xC8, 0xC5, 0x9F,
        0x40, 0xC0, 0x96, 0x7C, 0x74, 0x6C, 0xF8, 0x61, 0x49, 0x96, 0x9D, 0xDA, 0x79, 0x7A, 0xA0,
        0xEA, 0xC3, 0xA3, 0x98, 0xFD, 0x6E, 0x1A, 0x42, 0x93, 0xFC, 0x12, 0xC4, 0x46, 0x12, 0x15,
        0x22, 0x1D, 0xCB, 0x9A, 0xFB, 0x90, 0xE6, 0x7E, 0x8C, 0x62, 0x23, 0x68, 0x65, 0x56, 0x24,
        0x0A, 0x31, 0x2F, 0x3E, 0x2D, 0xCD, 0xD2, 0xEF, 0x72, 0xC5, 0x7C, 0x5C, 0xE8, 0xE6, 0x66,
        0xEE, 0x63, 0x17, 0x9A, 0x30, 0x8D, 0xDD, 0x36, 0x1F, 0xAC, 0x2B, 0x4D, 0xB5, 0xCA, 0xBF,
        0x42, 0x44, 0x1F, 0xC7, 0x7F, 0x8A, 0x0D, 0x19, 0x69, 0x2A, 0x22, 0x3A, 0x1C, 0x72, 0xB3,
        0x4B, 0xF2, 0x5D, 0x8E, 0x73, 0xFD, 0x98, 0xAB, 0x1E, 0x03, 0x8A, 0x79, 0x08, 0x61, 0xBA,
        0xBA, 0xEE, 0xAE, 0xBE, 0xEF, 0x63, 0xB7, 0xE4, 0x96, 0x6F, 0x72, 0x93, 0x29, 0x0C, 0x7E,
        0xE9, 0xEF, 0x43, 0x33, 0xF9, 0x25, 0x87, 0x10, 0x1F, 0xF7, 0xF1, 0x67, 0x1C, 0x7F, 0xC5,
        0x4F, 0xB9, 0xCC, 0xB7, 0xF3, 0x38, 0xEC, 0x97, 0x97, 0xB2, 0xB8, 0x1F, 0x86, 0x42, 0x0C,
        0x7D, 0x0C, 0x71, 0x14, 0x1B, 0x3A, 0x14, 0x7F, 0x23, 0x7B, 0xEF, 0x5F, 0x09, 0xD5, 0xF5,
        0x65, 0xDA, 0xB7, 0x0F, 0x9F, 0xA7, 0x34, 0xFE, 0x48, 0x7E, 0x37, 0x97, 0xF3, 0x76, 0xCC,
        0xA7, 0xF7, 0xBC, 0xB9, 0x4A, 0xED, 0xFF, 0x4D, 0x88, 0xF2, 0xDB, 0x9C, 0xAF, 0x4A, 0xE9,
        0xBB, 0xBB, 0x32, 0xD7, 0xBB, 0x2B, 0x9F, 0xAE, 0xD4, 0xF3, 0xFF, 0x7B, 0xE2, 0xBD, 0x64,
        0x57, 0x9F, 0x64, 0xD7, 0xB6, 0xED, 0x85, 0x65, 0x67, 0x4E, 0xB2, 0xEB, 0xBA, 0xEE, 0xC2,
        0xB2, 0x93, 0xF2, 0x24, 0xBD, 0x2F, 0x3B, 0xDF, 0xC7, 0xAF, 0x97, 0x96, 0x61, 0x7D, 0xB8,
        0x29, 0xC4, 0xD4, 0xDF, 0x8A, 0x8D, 0x95, 0xD6, 0x56, 0x85, 0x58, 0xB6, 0x29, 0xF8, 0xDB,
        0xE6, 0xB8, 0x47, 0x19, 0x67, 0x89, 0x94, 0xA9, 0x75, 0xDE, 0xFD, 0x36, 0x25, 0xF5, 0x2A,
        0xA5, 0x4A, 0x5A, 0xA7, 0x1D, 0x28, 0x81, 0x12, 0x28, 0x71, 0x29, 0xD5, 0xE4, 0x8C, 0x02,
        0x25, 0x50, 0x02, 0x25, 0x36, 0x25, 0x57, 0xA9, 0x35, 0x28, 0x81, 0x12, 0x28, 0x71, 0x29,
        0x29, 0xA7, 0x14, 0xC6, 0x4A, 0xA0, 0x04, 0x4A, 0x6C, 0x4A, 0x9A, 0xA4, 0xC2, 0x58, 0x09,
        0x94, 0x40, 0x89, 0x4D, 0xC9, 0x48, 0x55, 0x5B, 0x50, 0x02, 0x25, 0x50, 0x62, 0x53, 0x72,
        0x52, 0x13, 0x28, 0x81, 0x12, 0x28, 0x71, 0x29, 0x65, 0x49, 0x16, 0xD3, 0x0E, 0xA0, 0x04,
        0x4A, 0x5C, 0x4A, 0x35, 0xD1, 0xDA, 0x80, 0x12, 0x28, 0x81, 0x12, 0x9B, 0x92, 0x94, 0x35,
        0x1E, 0xD1, 0x82, 0x12, 0x28, 0xF1, 0x29, 0x55, 0x52, 0x2A, 0x8C, 0x95, 0x40, 0x09, 0x94,
        0xF8, 0x94, 0x9C, 0xAC, 0xD0, 0xC1, 0x03, 0x25, 0x50, 0x62, 0x53, 0x52, 0x52, 0x55, 0x58,
        0x38, 0x04, 0x4A, 0xA0, 0xC4, 0xA6, 0xB4, 0x26, 0x5B, 0xA1, 0x83, 0x07, 0x4A, 0xA0, 0xC4,
        0xA7, 0xE4, 0x9C, 0x43, 0x07, 0x0F, 0x94, 0x40, 0x89, 0x4D, 0x49, 0x3B, 0x43, 0x98, 0xC1,
        0x03, 0x25, 0x50, 0x62, 0x53, 0xB2, 0xA4, 0x0D, 0x16, 0x0E, 0x81, 0x12, 0x28, 0xB1, 0x29,
        0x39, 0xD2, 0x78, 0xAE, 0x04, 0x4A, 0xA0, 0x74, 0x06, 0x4A, 0xAE, 0xD2, 0x06, 0x94, 0x40,
        0x09, 0x94, 0x98, 0x94, 0x94, 0x24, 0x8D, 0xC9, 0x70, 0x50, 0x02, 0xA5, 0x33, 0x50, 0x72,
        0x1A, 0x6F, 0xD1, 0x82, 0x12, 0x28, 0xF1, 0x29, 0xD5, 0x92, 0x2C, 0xEE, 0x4A, 0xA0, 0x04,
        0x4A, 0x7C, 0x4A, 0xEE, 0xCF, 0x22, 0x3C, 0x50, 0x02, 0x25, 0x50, 0x62, 0x51, 0x52, 0xCE,
        0xD8, 0x1A, 0x94, 0x40, 0x09, 0x94, 0xB8, 0x94, 0x34, 0x29, 0x4C, 0x86, 0x83, 0x12, 0x28,
        0xF1, 0x29, 0x19, 0x92, 0x56, 0x83, 0x12, 0x28, 0x81, 0x12, 0x97, 0x92, 0x95, 0xF8, 0x78,
        0x17, 0x28, 0x81, 0xD2, 0x19, 0x28, 0x39, 0x7A, 0x7A, 0xF3, 0xEF, 0x48, 0xE9, 0x37, 0x56,
        0xED, 0xBB, 0x8A, 0xB3, 0x5C, 0x00, 0x00,
    ]
}
