#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    storage: Storage,
    align: [Align; 0],
}

impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }

    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());

        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];

        let bit_index = index % 8;
        let mask = 1 << bit_index;

        byte & mask == mask
    }

    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());

        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];

        let bit_index = index % 8;
        let mask = 1 << bit_index;

        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }

    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());

        let mut val = 0;

        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                val |= 1 << i;
            }
        }

        val
    }

    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());

        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            self.set_bit(i + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [usize; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type pthread_t = usize;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: pthread_mutex_t___pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 5usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_mutex_t___pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t___pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t___pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t___pthread_mutex_s>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(pthread_mutex_t___pthread_mutex_s)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__lock as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__count as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__owner as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__nusers as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__kind as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__spins as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__elision as *const _
                as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__list as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
impl ::std::fmt::Debug for pthread_mutex_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "pthread_mutex_t {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: pthread_cond_t__bindgen_ty_1,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
    _bindgen_union_align: [u64; 6usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_cond_t__bindgen_ty_1 {
    pub __lock: ::std::os::raw::c_int,
    pub __futex: ::std::os::raw::c_uint,
    pub __total_seq: ::std::os::raw::c_ulonglong,
    pub __wakeup_seq: ::std::os::raw::c_ulonglong,
    pub __woken_seq: ::std::os::raw::c_ulonglong,
    pub __mutex: *mut ::std::os::raw::c_void,
    pub __nwaiters: ::std::os::raw::c_uint,
    pub __broadcast_seq: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_cond_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__lock as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__futex as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__futex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__total_seq as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__total_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__wakeup_seq as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__wakeup_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__woken_seq as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__woken_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__mutex as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__mutex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__nwaiters as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__nwaiters)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__broadcast_seq as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__broadcast_seq)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
impl ::std::fmt::Debug for pthread_cond_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "pthread_cond_t {{ union }}")
    }
}
pub type VALUE = usize;
pub type ID = usize;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RBasic {
    pub flags: VALUE,
    pub klass: VALUE,
}
#[test]
fn bindgen_test_layout_RBasic() {
    assert_eq!(
        ::std::mem::size_of::<RBasic>(),
        16usize,
        concat!("Size of: ", stringify!(RBasic))
    );
    assert_eq!(
        ::std::mem::align_of::<RBasic>(),
        8usize,
        concat!("Alignment of ", stringify!(RBasic))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBasic>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RBasic),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBasic>())).klass as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RBasic),
            "::",
            stringify!(klass)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RString {
    pub basic: RBasic,
    pub as_: RString__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RString__bindgen_ty_1 {
    pub heap: RString__bindgen_ty_1__bindgen_ty_1,
    pub ary: [::std::os::raw::c_char; 24usize],
    _bindgen_union_align: [u64; 3usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RString__bindgen_ty_1__bindgen_ty_1 {
    pub len: ::std::os::raw::c_long,
    pub ptr: *mut ::std::os::raw::c_char,
    pub aux: RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    pub capa: ::std::os::raw::c_long,
    pub shared: VALUE,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>())).capa
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(capa)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>())).shared
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(shared)
        )
    );
}
impl ::std::fmt::Debug for RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(
            f,
            "RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {{ union }}"
        )
    }
}
#[test]
fn bindgen_test_layout_RString__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RString__bindgen_ty_1__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(RString__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<RString__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RString__bindgen_ty_1__bindgen_ty_1>())).len as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RString__bindgen_ty_1__bindgen_ty_1>())).ptr as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ptr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RString__bindgen_ty_1__bindgen_ty_1>())).aux as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(aux)
        )
    );
}
impl ::std::fmt::Debug for RString__bindgen_ty_1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(
            f,
            "RString__bindgen_ty_1__bindgen_ty_1 {{ len: {:?}, ptr: {:?}, aux: {:?} }}",
            self.len, self.ptr, self.aux
        )
    }
}
#[test]
fn bindgen_test_layout_RString__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RString__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(RString__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<RString__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(RString__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RString__bindgen_ty_1>())).heap as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1),
            "::",
            stringify!(heap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RString__bindgen_ty_1>())).ary as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1),
            "::",
            stringify!(ary)
        )
    );
}
impl ::std::fmt::Debug for RString__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "RString__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_RString() {
    assert_eq!(
        ::std::mem::size_of::<RString>(),
        40usize,
        concat!("Size of: ", stringify!(RString))
    );
    assert_eq!(
        ::std::mem::align_of::<RString>(),
        8usize,
        concat!("Alignment of ", stringify!(RString))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RString>())).basic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RString),
            "::",
            stringify!(basic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RString>())).as_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RString),
            "::",
            stringify!(as_)
        )
    );
}
impl ::std::fmt::Debug for RString {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(
            f,
            "RString {{ basic: {:?}, as: {:?} }}",
            self.basic, self.as_
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RArray {
    pub basic: RBasic,
    pub as_: RArray__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RArray__bindgen_ty_1 {
    pub heap: RArray__bindgen_ty_1__bindgen_ty_1,
    pub ary: [VALUE; 3usize],
    _bindgen_union_align: [u64; 3usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RArray__bindgen_ty_1__bindgen_ty_1 {
    pub len: ::std::os::raw::c_long,
    pub aux: RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
    pub ptr: *mut VALUE,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    pub capa: ::std::os::raw::c_long,
    pub shared: VALUE,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>())).capa
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(capa)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>())).shared
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(shared)
        )
    );
}
impl ::std::fmt::Debug for RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(
            f,
            "RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {{ union }}"
        )
    }
}
#[test]
fn bindgen_test_layout_RArray__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RArray__bindgen_ty_1__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(RArray__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<RArray__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RArray__bindgen_ty_1__bindgen_ty_1>())).len as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RArray__bindgen_ty_1__bindgen_ty_1>())).aux as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(aux)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RArray__bindgen_ty_1__bindgen_ty_1>())).ptr as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ptr)
        )
    );
}
impl ::std::fmt::Debug for RArray__bindgen_ty_1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(
            f,
            "RArray__bindgen_ty_1__bindgen_ty_1 {{ len: {:?}, aux: {:?}, ptr: {:?} }}",
            self.len, self.aux, self.ptr
        )
    }
}
#[test]
fn bindgen_test_layout_RArray__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RArray__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(RArray__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<RArray__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(RArray__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RArray__bindgen_ty_1>())).heap as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1),
            "::",
            stringify!(heap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RArray__bindgen_ty_1>())).ary as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1),
            "::",
            stringify!(ary)
        )
    );
}
impl ::std::fmt::Debug for RArray__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "RArray__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_RArray() {
    assert_eq!(
        ::std::mem::size_of::<RArray>(),
        40usize,
        concat!("Size of: ", stringify!(RArray))
    );
    assert_eq!(
        ::std::mem::align_of::<RArray>(),
        8usize,
        concat!("Alignment of ", stringify!(RArray))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RArray>())).basic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray),
            "::",
            stringify!(basic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RArray>())).as_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray),
            "::",
            stringify!(as_)
        )
    );
}
impl ::std::fmt::Debug for RArray {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(
            f,
            "RArray {{ basic: {:?}, as: {:?} }}",
            self.basic, self.as_
        )
    }
}
pub type st_data_t = usize;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_hash_type {
    pub compare: ::std::option::Option<unsafe extern "C" fn() -> ::std::os::raw::c_int>,
    pub hash: ::std::option::Option<unsafe extern "C" fn() -> ::std::os::raw::c_int>,
}
#[test]
fn bindgen_test_layout_st_hash_type() {
    assert_eq!(
        ::std::mem::size_of::<st_hash_type>(),
        16usize,
        concat!("Size of: ", stringify!(st_hash_type))
    );
    assert_eq!(
        ::std::mem::align_of::<st_hash_type>(),
        8usize,
        concat!("Alignment of ", stringify!(st_hash_type))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_hash_type>())).compare as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(st_hash_type),
            "::",
            stringify!(compare)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_hash_type>())).hash as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(st_hash_type),
            "::",
            stringify!(hash)
        )
    );
}
pub type st_index_t = st_data_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_table {
    pub type_: *const st_hash_type,
    pub num_bins: st_index_t,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize], u64>,
    pub bins: *mut *mut st_table_entry,
    pub head: *mut st_table_entry,
}
#[test]
fn bindgen_test_layout_st_table() {
    assert_eq!(
        ::std::mem::size_of::<st_table>(),
        40usize,
        concat!("Size of: ", stringify!(st_table))
    );
    assert_eq!(
        ::std::mem::align_of::<st_table>(),
        8usize,
        concat!("Alignment of ", stringify!(st_table))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).num_bins as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(num_bins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).bins as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(bins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).head as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(head)
        )
    );
}
impl st_table {
    #[inline]
    pub fn entries_packed(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_entries_packed(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn num_entries(&self) -> st_index_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 63u8) as usize) }
    }
    #[inline]
    pub fn set_num_entries(&mut self, val: st_index_t) {
        unsafe {
            let val: usize = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 63u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        entries_packed: ::std::os::raw::c_uint,
        num_entries: st_index_t,
    ) -> __BindgenBitfieldUnit<[u8; 8usize], u64> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize], u64> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let entries_packed: u32 = unsafe { ::std::mem::transmute(entries_packed) };
            entries_packed as u64
        });
        __bindgen_bitfield_unit.set(1usize, 63u8, {
            let num_entries: usize = unsafe { ::std::mem::transmute(num_entries) };
            num_entries as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type rb_unblock_function_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
pub type rb_event_flag_t = ::std::os::raw::c_uint;
pub type rb_event_hook_func_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: rb_event_flag_t, data: VALUE, arg2: VALUE, arg3: ID, klass: VALUE),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_event_hook_struct {
    pub flag: rb_event_flag_t,
    pub func: rb_event_hook_func_t,
    pub data: VALUE,
    pub next: *mut rb_event_hook_struct,
}
#[test]
fn bindgen_test_layout_rb_event_hook_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_event_hook_struct>(),
        32usize,
        concat!("Size of: ", stringify!(rb_event_hook_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_event_hook_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_event_hook_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_event_hook_struct>())).flag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_event_hook_struct),
            "::",
            stringify!(flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_event_hook_struct>())).func as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_event_hook_struct),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_event_hook_struct>())).data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_event_hook_struct),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_event_hook_struct>())).next as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_event_hook_struct),
            "::",
            stringify!(next)
        )
    );
}
pub type rb_event_hook_t = rb_event_hook_struct;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RNode {
    pub flags: ::std::os::raw::c_ulong,
    pub nd_file: *mut ::std::os::raw::c_char,
    pub u1: RNode__bindgen_ty_1,
    pub u2: RNode__bindgen_ty_2,
    pub u3: RNode__bindgen_ty_3,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RNode__bindgen_ty_1 {
    pub node: *mut RNode,
    pub id: ID,
    pub value: VALUE,
    pub cfunc: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
    pub tbl: *mut ID,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_RNode__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RNode__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(RNode__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<RNode__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(RNode__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_1>())).node as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_1>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_1),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_1>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_1>())).cfunc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_1),
            "::",
            stringify!(cfunc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_1>())).tbl as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_1),
            "::",
            stringify!(tbl)
        )
    );
}
impl ::std::fmt::Debug for RNode__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "RNode__bindgen_ty_1 {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RNode__bindgen_ty_2 {
    pub node: *mut RNode,
    pub id: ID,
    pub argc: ::std::os::raw::c_long,
    pub value: VALUE,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_RNode__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<RNode__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(RNode__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<RNode__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(RNode__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_2>())).node as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_2),
            "::",
            stringify!(node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_2>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_2),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_2>())).argc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_2),
            "::",
            stringify!(argc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_2>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_2),
            "::",
            stringify!(value)
        )
    );
}
impl ::std::fmt::Debug for RNode__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "RNode__bindgen_ty_2 {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RNode__bindgen_ty_3 {
    pub node: *mut RNode,
    pub id: ID,
    pub state: ::std::os::raw::c_long,
    pub entry: *mut global_entry,
    pub cnt: ::std::os::raw::c_long,
    pub value: VALUE,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_RNode__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<RNode__bindgen_ty_3>(),
        8usize,
        concat!("Size of: ", stringify!(RNode__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<RNode__bindgen_ty_3>(),
        8usize,
        concat!("Alignment of ", stringify!(RNode__bindgen_ty_3))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_3>())).node as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_3),
            "::",
            stringify!(node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_3>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_3),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_3>())).state as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_3),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_3>())).entry as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_3),
            "::",
            stringify!(entry)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_3>())).cnt as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_3),
            "::",
            stringify!(cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode__bindgen_ty_3>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode__bindgen_ty_3),
            "::",
            stringify!(value)
        )
    );
}
impl ::std::fmt::Debug for RNode__bindgen_ty_3 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "RNode__bindgen_ty_3 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_RNode() {
    assert_eq!(
        ::std::mem::size_of::<RNode>(),
        40usize,
        concat!("Size of: ", stringify!(RNode))
    );
    assert_eq!(
        ::std::mem::align_of::<RNode>(),
        8usize,
        concat!("Alignment of ", stringify!(RNode))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode>())).nd_file as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RNode),
            "::",
            stringify!(nd_file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode>())).u1 as *const _ as usize },
        16usize,
        concat!("Offset of field: ", stringify!(RNode), "::", stringify!(u1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode>())).u2 as *const _ as usize },
        24usize,
        concat!("Offset of field: ", stringify!(RNode), "::", stringify!(u2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RNode>())).u3 as *const _ as usize },
        32usize,
        concat!("Offset of field: ", stringify!(RNode), "::", stringify!(u3))
    );
}
impl ::std::fmt::Debug for RNode {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(
            f,
            "RNode {{ flags: {:?}, nd_file: {:?}, u1: {:?}, u2: {:?}, u3: {:?} }}",
            self.flags, self.nd_file, self.u1, self.u2, self.u3
        )
    }
}
pub type NODE = RNode;
pub type __jmp_buf = [::std::os::raw::c_long; 8usize];
pub type rb_thread_id_t = pthread_t;
pub type rb_thread_lock_t = pthread_mutex_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct native_thread_data_struct {
    pub signal_thread_list: *mut ::std::os::raw::c_void,
    pub sleep_cond: pthread_cond_t,
}
#[test]
fn bindgen_test_layout_native_thread_data_struct() {
    assert_eq!(
        ::std::mem::size_of::<native_thread_data_struct>(),
        56usize,
        concat!("Size of: ", stringify!(native_thread_data_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<native_thread_data_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(native_thread_data_struct))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<native_thread_data_struct>())).signal_thread_list as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(native_thread_data_struct),
            "::",
            stringify!(signal_thread_list)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<native_thread_data_struct>())).sleep_cond as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(native_thread_data_struct),
            "::",
            stringify!(sleep_cond)
        )
    );
}
impl ::std::fmt::Debug for native_thread_data_struct {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(
            f,
            "native_thread_data_struct {{ signal_thread_list: {:?}, sleep_cond: {:?} }}",
            self.signal_thread_list, self.sleep_cond
        )
    }
}
pub type native_thread_data_t = native_thread_data_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __jmp_buf_tag {
    pub __jmpbuf: __jmp_buf,
    pub __mask_was_saved: ::std::os::raw::c_int,
    pub __saved_mask: __sigset_t,
}
#[test]
fn bindgen_test_layout___jmp_buf_tag() {
    assert_eq!(
        ::std::mem::size_of::<__jmp_buf_tag>(),
        200usize,
        concat!("Size of: ", stringify!(__jmp_buf_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__jmp_buf_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__jmp_buf_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__jmp_buf_tag>())).__jmpbuf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__jmpbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__jmp_buf_tag>())).__mask_was_saved as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__mask_was_saved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__jmp_buf_tag>())).__saved_mask as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__saved_mask)
        )
    );
}
pub type jmp_buf = [__jmp_buf_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_compile_data_ensure_node_stack {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_compile_option_struct {
    pub inline_const_cache: ::std::os::raw::c_int,
    pub peephole_optimization: ::std::os::raw::c_int,
    pub tailcall_optimization: ::std::os::raw::c_int,
    pub specialized_instruction: ::std::os::raw::c_int,
    pub operands_unification: ::std::os::raw::c_int,
    pub instructions_unification: ::std::os::raw::c_int,
    pub stack_caching: ::std::os::raw::c_int,
    pub trace_instruction: ::std::os::raw::c_int,
    pub debug_level: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_rb_compile_option_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_compile_option_struct>(),
        36usize,
        concat!("Size of: ", stringify!(rb_compile_option_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_compile_option_struct>(),
        4usize,
        concat!("Alignment of ", stringify!(rb_compile_option_struct))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_compile_option_struct>())).inline_const_cache as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_compile_option_struct),
            "::",
            stringify!(inline_const_cache)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_compile_option_struct>())).peephole_optimization as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_compile_option_struct),
            "::",
            stringify!(peephole_optimization)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_compile_option_struct>())).tailcall_optimization as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_compile_option_struct),
            "::",
            stringify!(tailcall_optimization)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_compile_option_struct>())).specialized_instruction as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_compile_option_struct),
            "::",
            stringify!(specialized_instruction)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_compile_option_struct>())).operands_unification as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_compile_option_struct),
            "::",
            stringify!(operands_unification)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_compile_option_struct>())).instructions_unification
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_compile_option_struct),
            "::",
            stringify!(instructions_unification)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_compile_option_struct>())).stack_caching as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_compile_option_struct),
            "::",
            stringify!(stack_caching)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_compile_option_struct>())).trace_instruction as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_compile_option_struct),
            "::",
            stringify!(trace_instruction)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_compile_option_struct>())).debug_level as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_compile_option_struct),
            "::",
            stringify!(debug_level)
        )
    );
}
pub type rb_compile_option_t = rb_compile_option_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_iseq_struct {
    pub type_: VALUE,
    pub name: VALUE,
    pub filename: VALUE,
    pub iseq: *mut VALUE,
    pub iseq_encoded: *mut VALUE,
    pub iseq_size: ::std::os::raw::c_ulong,
    pub mark_ary: VALUE,
    pub coverage: VALUE,
    pub insn_info_table: *mut iseq_insn_info_entry,
    pub insn_info_size: ::std::os::raw::c_ulong,
    pub local_table: *mut ID,
    pub local_table_size: ::std::os::raw::c_int,
    pub local_size: ::std::os::raw::c_int,
    pub argc: ::std::os::raw::c_int,
    pub arg_simple: ::std::os::raw::c_int,
    pub arg_rest: ::std::os::raw::c_int,
    pub arg_block: ::std::os::raw::c_int,
    pub arg_opts: ::std::os::raw::c_int,
    pub arg_post_len: ::std::os::raw::c_int,
    pub arg_post_start: ::std::os::raw::c_int,
    pub arg_size: ::std::os::raw::c_int,
    pub arg_opt_table: *mut VALUE,
    pub stack_max: ::std::os::raw::c_int,
    pub catch_table: *mut iseq_catch_table_entry,
    pub catch_table_size: ::std::os::raw::c_int,
    pub parent_iseq: *mut rb_iseq_struct,
    pub local_iseq: *mut rb_iseq_struct,
    pub self_: VALUE,
    pub orig: VALUE,
    pub cref_stack: *mut NODE,
    pub klass: VALUE,
    pub defined_method_id: ID,
    pub compile_data: *mut iseq_compile_data,
}
#[test]
fn bindgen_test_layout_rb_iseq_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_iseq_struct>(),
        224usize,
        concat!("Size of: ", stringify!(rb_iseq_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_iseq_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_iseq_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).filename as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(filename)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).iseq as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(iseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).iseq_encoded as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(iseq_encoded)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).iseq_size as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(iseq_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).mark_ary as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(mark_ary)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).coverage as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(coverage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).insn_info_table as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(insn_info_table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).insn_info_size as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(insn_info_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).local_table as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(local_table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).local_table_size as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(local_table_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).local_size as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(local_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).argc as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(argc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).arg_simple as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(arg_simple)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).arg_rest as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(arg_rest)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).arg_block as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(arg_block)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).arg_opts as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(arg_opts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).arg_post_len as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(arg_post_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).arg_post_start as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(arg_post_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).arg_size as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(arg_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).arg_opt_table as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(arg_opt_table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).stack_max as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(stack_max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).catch_table as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(catch_table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).catch_table_size as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(catch_table_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).parent_iseq as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(parent_iseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).local_iseq as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(local_iseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).self_ as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(self_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).orig as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(orig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).cref_stack as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(cref_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).klass as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(klass)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_struct>())).defined_method_id as *const _ as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(defined_method_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).compile_data as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(compile_data)
        )
    );
}
pub type rb_iseq_t = rb_iseq_struct;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rb_vm_struct {
    pub self_: VALUE,
    pub global_vm_lock: rb_thread_lock_t,
    pub main_thread: *mut rb_thread_struct,
    pub running_thread: *mut rb_thread_struct,
    pub living_threads: *mut st_table,
    pub thgroup_default: VALUE,
    pub running: ::std::os::raw::c_int,
    pub thread_abort_on_exception: ::std::os::raw::c_int,
    pub trace_flag: ::std::os::raw::c_ulong,
    pub sleeper: ::std::os::raw::c_int,
    pub mark_object_ary: VALUE,
    pub special_exceptions: [VALUE; 3usize],
    pub top_self: VALUE,
    pub load_path: VALUE,
    pub loaded_features: VALUE,
    pub loading_table: *mut st_table,
    pub trap_list: [rb_vm_struct__bindgen_ty_1; 65usize],
    pub event_hooks: *mut rb_event_hook_t,
    pub src_encoding_index: ::std::os::raw::c_int,
    pub verbose: VALUE,
    pub debug: VALUE,
    pub progname: VALUE,
    pub coverages: VALUE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_vm_struct__bindgen_ty_1 {
    pub cmd: VALUE,
    pub safe: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_rb_vm_struct__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<rb_vm_struct__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(rb_vm_struct__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_vm_struct__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_vm_struct__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct__bindgen_ty_1>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct__bindgen_ty_1),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct__bindgen_ty_1>())).safe as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct__bindgen_ty_1),
            "::",
            stringify!(safe)
        )
    );
}
#[test]
fn bindgen_test_layout_rb_vm_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_vm_struct>(),
        1256usize,
        concat!("Size of: ", stringify!(rb_vm_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_vm_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_vm_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).self_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(self_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).global_vm_lock as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(global_vm_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).main_thread as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(main_thread)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).running_thread as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(running_thread)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).living_threads as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(living_threads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).thgroup_default as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(thgroup_default)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).running as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(running)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct>())).thread_abort_on_exception as *const _ as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(thread_abort_on_exception)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).trace_flag as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(trace_flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).sleeper as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(sleeper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).mark_object_ary as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(mark_object_ary)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).special_exceptions as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(special_exceptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).top_self as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(top_self)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).load_path as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(load_path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).loaded_features as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(loaded_features)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).loading_table as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(loading_table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).trap_list as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(trap_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).event_hooks as *const _ as usize },
        1208usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(event_hooks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).src_encoding_index as *const _ as usize },
        1216usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(src_encoding_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).verbose as *const _ as usize },
        1224usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(verbose)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).debug as *const _ as usize },
        1232usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(debug)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).progname as *const _ as usize },
        1240usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(progname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).coverages as *const _ as usize },
        1248usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(coverages)
        )
    );
}
impl ::std::fmt::Debug for rb_vm_struct {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write ! ( f , "rb_vm_struct {{ self: {:?}, global_vm_lock: {:?}, main_thread: {:?}, running_thread: {:?}, living_threads: {:?}, thgroup_default: {:?}, running: {:?}, thread_abort_on_exception: {:?}, trace_flag: {:?}, sleeper: {:?}, mark_object_ary: {:?}, special_exceptions: {:?}, top_self: {:?}, load_path: {:?}, loaded_features: {:?}, loading_table: {:?}, trap_list: [{}], event_hooks: {:?}, src_encoding_index: {:?}, verbose: {:?}, debug: {:?}, progname: {:?}, coverages: {:?} }}" , self . self_ , self . global_vm_lock , self . main_thread , self . running_thread , self . living_threads , self . thgroup_default , self . running , self . thread_abort_on_exception , self . trace_flag , self . sleeper , self . mark_object_ary , self . special_exceptions , self . top_self , self . load_path , self . loaded_features , self . loading_table , self . trap_list . iter ( ) . enumerate ( ) . map ( | ( i , v ) | format ! ( "{}{:?}" , if i > 0 { ", " } else { "" } , v ) ) . collect :: < String > ( ) , self . event_hooks , self . src_encoding_index , self . verbose , self . debug , self . progname , self . coverages )
    }
}
pub type rb_vm_t = rb_vm_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_control_frame_t {
    pub pc: *mut VALUE,
    pub sp: *mut VALUE,
    pub bp: *mut VALUE,
    pub iseq: *mut rb_iseq_t,
    pub flag: VALUE,
    pub self_: VALUE,
    pub lfp: *mut VALUE,
    pub dfp: *mut VALUE,
    pub block_iseq: *mut rb_iseq_t,
    pub proc_: VALUE,
    pub method_id: ID,
    pub method_class: VALUE,
}
#[test]
fn bindgen_test_layout_rb_control_frame_t() {
    assert_eq!(
        ::std::mem::size_of::<rb_control_frame_t>(),
        96usize,
        concat!("Size of: ", stringify!(rb_control_frame_t))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_control_frame_t>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_control_frame_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_t>())).pc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_t),
            "::",
            stringify!(pc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_t>())).sp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_t),
            "::",
            stringify!(sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_t>())).bp as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_t),
            "::",
            stringify!(bp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_t>())).iseq as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_t),
            "::",
            stringify!(iseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_t>())).flag as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_t),
            "::",
            stringify!(flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_t>())).self_ as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_t),
            "::",
            stringify!(self_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_t>())).lfp as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_t),
            "::",
            stringify!(lfp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_t>())).dfp as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_t),
            "::",
            stringify!(dfp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_t>())).block_iseq as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_t),
            "::",
            stringify!(block_iseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_t>())).proc_ as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_t),
            "::",
            stringify!(proc_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_t>())).method_id as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_t),
            "::",
            stringify!(method_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_t>())).method_class as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_t),
            "::",
            stringify!(method_class)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_block_struct {
    pub self_: VALUE,
    pub lfp: *mut VALUE,
    pub dfp: *mut VALUE,
    pub iseq: *mut rb_iseq_t,
    pub proc_: VALUE,
}
#[test]
fn bindgen_test_layout_rb_block_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_block_struct>(),
        40usize,
        concat!("Size of: ", stringify!(rb_block_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_block_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_block_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_block_struct>())).self_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_block_struct),
            "::",
            stringify!(self_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_block_struct>())).lfp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_block_struct),
            "::",
            stringify!(lfp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_block_struct>())).dfp as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_block_struct),
            "::",
            stringify!(dfp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_block_struct>())).iseq as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_block_struct),
            "::",
            stringify!(iseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_block_struct>())).proc_ as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_block_struct),
            "::",
            stringify!(proc_)
        )
    );
}
pub type rb_block_t = rb_block_struct;
pub const rb_thread_status_THREAD_TO_KILL: rb_thread_status = 0;
pub const rb_thread_status_THREAD_RUNNABLE: rb_thread_status = 1;
pub const rb_thread_status_THREAD_STOPPED: rb_thread_status = 2;
pub const rb_thread_status_THREAD_STOPPED_FOREVER: rb_thread_status = 3;
pub const rb_thread_status_THREAD_KILLED: rb_thread_status = 4;
pub type rb_thread_status = ::std::os::raw::c_uint;
pub type rb_jmpbuf_t = jmp_buf;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_vm_tag {
    pub buf: rb_jmpbuf_t,
    pub tag: VALUE,
    pub retval: VALUE,
    pub prev: *mut rb_vm_tag,
}
#[test]
fn bindgen_test_layout_rb_vm_tag() {
    assert_eq!(
        ::std::mem::size_of::<rb_vm_tag>(),
        224usize,
        concat!("Size of: ", stringify!(rb_vm_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_vm_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_vm_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_tag>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_tag),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_tag>())).tag as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_tag),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_tag>())).retval as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_tag),
            "::",
            stringify!(retval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_tag>())).prev as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_tag),
            "::",
            stringify!(prev)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_vm_trap_tag {
    pub prev: *mut rb_vm_trap_tag,
}
#[test]
fn bindgen_test_layout_rb_vm_trap_tag() {
    assert_eq!(
        ::std::mem::size_of::<rb_vm_trap_tag>(),
        8usize,
        concat!("Size of: ", stringify!(rb_vm_trap_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_vm_trap_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_vm_trap_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_trap_tag>())).prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_trap_tag),
            "::",
            stringify!(prev)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_unblock_callback {
    pub func: rb_unblock_function_t,
    pub arg: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_rb_unblock_callback() {
    assert_eq!(
        ::std::mem::size_of::<rb_unblock_callback>(),
        16usize,
        concat!("Size of: ", stringify!(rb_unblock_callback))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_unblock_callback>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_unblock_callback))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_unblock_callback>())).func as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_unblock_callback),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_unblock_callback>())).arg as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_unblock_callback),
            "::",
            stringify!(arg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_mutex_struct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rb_thread_struct {
    pub self_: VALUE,
    pub vm: *mut rb_vm_t,
    pub stack: *mut VALUE,
    pub stack_size: ::std::os::raw::c_ulong,
    pub cfp: *mut rb_control_frame_t,
    pub safe_level: ::std::os::raw::c_int,
    pub raised_flag: ::std::os::raw::c_int,
    pub last_status: VALUE,
    pub state: ::std::os::raw::c_int,
    pub passed_block: *mut rb_block_t,
    pub top_self: VALUE,
    pub top_wrapper: VALUE,
    pub base_block: *mut rb_block_t,
    pub local_lfp: *mut VALUE,
    pub local_svar: VALUE,
    pub thread_id: rb_thread_id_t,
    pub status: rb_thread_status,
    pub priority: ::std::os::raw::c_int,
    pub slice: ::std::os::raw::c_int,
    pub native_thread_data: native_thread_data_t,
    pub blocking_region_buffer: *mut ::std::os::raw::c_void,
    pub thgroup: VALUE,
    pub value: VALUE,
    pub errinfo: VALUE,
    pub thrown_errinfo: VALUE,
    pub exec_signal: ::std::os::raw::c_int,
    pub interrupt_flag: ::std::os::raw::c_int,
    pub interrupt_lock: rb_thread_lock_t,
    pub unblock: rb_unblock_callback,
    pub locking_mutex: VALUE,
    pub keeping_mutexes: *mut rb_mutex_struct,
    pub transition_for_lock: ::std::os::raw::c_int,
    pub tag: *mut rb_vm_tag,
    pub trap_tag: *mut rb_vm_trap_tag,
    pub parse_in_eval: ::std::os::raw::c_int,
    pub mild_compile_error: ::std::os::raw::c_int,
    pub local_storage: *mut st_table,
    pub join_list_next: *mut rb_thread_struct,
    pub join_list_head: *mut rb_thread_struct,
    pub first_proc: VALUE,
    pub first_args: VALUE,
    pub first_func: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
    pub machine_stack_start: *mut VALUE,
    pub machine_stack_end: *mut VALUE,
    pub machine_stack_maxsize: usize,
    pub machine_regs: jmp_buf,
    pub mark_stack_len: ::std::os::raw::c_int,
    pub stat_insn_usage: VALUE,
    pub event_hooks: *mut rb_event_hook_t,
    pub event_flags: rb_event_flag_t,
    pub tracing: ::std::os::raw::c_int,
    pub fiber: VALUE,
    pub root_fiber: VALUE,
    pub root_jmpbuf: rb_jmpbuf_t,
    pub method_missing_reason: ::std::os::raw::c_int,
    pub abort_on_exception: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_rb_thread_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_thread_struct>(),
        872usize,
        concat!("Size of: ", stringify!(rb_thread_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_thread_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_thread_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).self_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(self_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).vm as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(vm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).stack as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).stack_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(stack_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).cfp as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(cfp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).safe_level as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(safe_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).raised_flag as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(raised_flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).last_status as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(last_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).state as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).passed_block as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(passed_block)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).top_self as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(top_self)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).top_wrapper as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(top_wrapper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).base_block as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(base_block)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).local_lfp as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(local_lfp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).local_svar as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(local_svar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).thread_id as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(thread_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).status as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).priority as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(priority)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).slice as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(slice)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).native_thread_data as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(native_thread_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).blocking_region_buffer as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(blocking_region_buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).thgroup as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(thgroup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).value as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).errinfo as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(errinfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).thrown_errinfo as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(thrown_errinfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).exec_signal as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(exec_signal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).interrupt_flag as *const _ as usize },
        236usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(interrupt_flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).interrupt_lock as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(interrupt_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).unblock as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(unblock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).locking_mutex as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(locking_mutex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).keeping_mutexes as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(keeping_mutexes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).transition_for_lock as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(transition_for_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).tag as *const _ as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).trap_tag as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(trap_tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).parse_in_eval as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(parse_in_eval)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).mild_compile_error as *const _ as usize
        },
        340usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(mild_compile_error)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).local_storage as *const _ as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(local_storage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).join_list_next as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(join_list_next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).join_list_head as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(join_list_head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).first_proc as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(first_proc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).first_args as *const _ as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(first_args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).first_func as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(first_func)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).machine_stack_start as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(machine_stack_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).machine_stack_end as *const _ as usize
        },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(machine_stack_end)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).machine_stack_maxsize as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(machine_stack_maxsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).machine_regs as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(machine_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).mark_stack_len as *const _ as usize },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(mark_stack_len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).stat_insn_usage as *const _ as usize
        },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(stat_insn_usage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).event_hooks as *const _ as usize },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(event_hooks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).event_flags as *const _ as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(event_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).tracing as *const _ as usize },
        644usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(tracing)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).fiber as *const _ as usize },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(fiber)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).root_fiber as *const _ as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(root_fiber)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).root_jmpbuf as *const _ as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(root_jmpbuf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).method_missing_reason as *const _ as usize
        },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(method_missing_reason)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).abort_on_exception as *const _ as usize
        },
        868usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(abort_on_exception)
        )
    );
}
impl ::std::fmt::Debug for rb_thread_struct {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write ! ( f , "rb_thread_struct {{ self: {:?}, vm: {:?}, stack: {:?}, stack_size: {:?}, cfp: {:?}, safe_level: {:?}, raised_flag: {:?}, last_status: {:?}, state: {:?}, passed_block: {:?}, top_self: {:?}, top_wrapper: {:?}, base_block: {:?}, local_lfp: {:?}, local_svar: {:?}, thread_id: {:?}, status: {:?}, priority: {:?}, slice: {:?}, native_thread_data: {:?}, blocking_region_buffer: {:?}, thgroup: {:?}, value: {:?}, errinfo: {:?}, thrown_errinfo: {:?}, exec_signal: {:?}, interrupt_flag: {:?}, interrupt_lock: {:?}, unblock: {:?}, locking_mutex: {:?}, keeping_mutexes: {:?}, transition_for_lock: {:?}, tag: {:?}, trap_tag: {:?}, parse_in_eval: {:?}, mild_compile_error: {:?}, local_storage: {:?}, join_list_next: {:?}, join_list_head: {:?}, first_proc: {:?}, first_args: {:?}, first_func: {:?}, machine_stack_start: {:?}, machine_stack_end: {:?}, machine_stack_maxsize: {:?}, machine_regs: {:?}, mark_stack_len: {:?}, stat_insn_usage: {:?}, event_hooks: {:?}, event_flags: {:?}, tracing: {:?}, fiber: {:?}, root_fiber: {:?}, root_jmpbuf: {:?}, method_missing_reason: {:?}, abort_on_exception: {:?} }}" , self . self_ , self . vm , self . stack , self . stack_size , self . cfp , self . safe_level , self . raised_flag , self . last_status , self . state , self . passed_block , self . top_self , self . top_wrapper , self . base_block , self . local_lfp , self . local_svar , self . thread_id , self . status , self . priority , self . slice , self . native_thread_data , self . blocking_region_buffer , self . thgroup , self . value , self . errinfo , self . thrown_errinfo , self . exec_signal , self . interrupt_flag , self . interrupt_lock , self . unblock , self . locking_mutex , self . keeping_mutexes , self . transition_for_lock , self . tag , self . trap_tag , self . parse_in_eval , self . mild_compile_error , self . local_storage , self . join_list_next , self . join_list_head , self . first_proc , self . first_args , self . first_func , self . machine_stack_start , self . machine_stack_end , self . machine_stack_maxsize , self . machine_regs , self . mark_stack_len , self . stat_insn_usage , self . event_hooks , self . event_flags , self . tracing , self . fiber , self . root_fiber , self . root_jmpbuf , self . method_missing_reason , self . abort_on_exception )
    }
}
pub type rb_thread_t = rb_thread_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct global_entry {
    pub var: *mut global_variable,
    pub id: ID,
}
#[test]
fn bindgen_test_layout_global_entry() {
    assert_eq!(
        ::std::mem::size_of::<global_entry>(),
        16usize,
        concat!("Size of: ", stringify!(global_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<global_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(global_entry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<global_entry>())).var as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(global_entry),
            "::",
            stringify!(var)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<global_entry>())).id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(global_entry),
            "::",
            stringify!(id)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_insn_info_entry {
    pub position: ::std::os::raw::c_ushort,
    pub line_no: ::std::os::raw::c_ushort,
    pub sp: ::std::os::raw::c_ushort,
}
#[test]
fn bindgen_test_layout_iseq_insn_info_entry() {
    assert_eq!(
        ::std::mem::size_of::<iseq_insn_info_entry>(),
        6usize,
        concat!("Size of: ", stringify!(iseq_insn_info_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_insn_info_entry>(),
        2usize,
        concat!("Alignment of ", stringify!(iseq_insn_info_entry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_insn_info_entry>())).position as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_insn_info_entry),
            "::",
            stringify!(position)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_insn_info_entry>())).line_no as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_insn_info_entry),
            "::",
            stringify!(line_no)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_insn_info_entry>())).sp as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_insn_info_entry),
            "::",
            stringify!(sp)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_catch_table_entry {
    pub type_: VALUE,
    pub iseq: VALUE,
    pub start: ::std::os::raw::c_ulong,
    pub end: ::std::os::raw::c_ulong,
    pub cont: ::std::os::raw::c_ulong,
    pub sp: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_iseq_catch_table_entry() {
    assert_eq!(
        ::std::mem::size_of::<iseq_catch_table_entry>(),
        48usize,
        concat!("Size of: ", stringify!(iseq_catch_table_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_catch_table_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(iseq_catch_table_entry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table_entry>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table_entry),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table_entry>())).iseq as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table_entry),
            "::",
            stringify!(iseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table_entry>())).start as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table_entry),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table_entry>())).end as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table_entry),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table_entry>())).cont as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table_entry),
            "::",
            stringify!(cont)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table_entry>())).sp as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table_entry),
            "::",
            stringify!(sp)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_compile_data_storage {
    pub next: *mut iseq_compile_data_storage,
    pub pos: ::std::os::raw::c_ulong,
    pub size: ::std::os::raw::c_ulong,
    pub buff: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_iseq_compile_data_storage() {
    assert_eq!(
        ::std::mem::size_of::<iseq_compile_data_storage>(),
        32usize,
        concat!("Size of: ", stringify!(iseq_compile_data_storage))
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_compile_data_storage>(),
        8usize,
        concat!("Alignment of ", stringify!(iseq_compile_data_storage))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data_storage>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data_storage),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data_storage>())).pos as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data_storage),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data_storage>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data_storage),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data_storage>())).buff as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data_storage),
            "::",
            stringify!(buff)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_compile_data {
    pub err_info: VALUE,
    pub mark_ary: VALUE,
    pub catch_table_ary: VALUE,
    pub start_label: *mut iseq_label_data,
    pub end_label: *mut iseq_label_data,
    pub redo_label: *mut iseq_label_data,
    pub current_block: VALUE,
    pub loopval_popped: VALUE,
    pub ensure_node: VALUE,
    pub for_iseq: VALUE,
    pub ensure_node_stack: *mut iseq_compile_data_ensure_node_stack,
    pub cached_const: ::std::os::raw::c_int,
    pub storage_head: *mut iseq_compile_data_storage,
    pub storage_current: *mut iseq_compile_data_storage,
    pub last_line: ::std::os::raw::c_int,
    pub flip_cnt: ::std::os::raw::c_int,
    pub label_no: ::std::os::raw::c_int,
    pub node_level: ::std::os::raw::c_int,
    pub option: *const rb_compile_option_t,
}
#[test]
fn bindgen_test_layout_iseq_compile_data() {
    assert_eq!(
        ::std::mem::size_of::<iseq_compile_data>(),
        136usize,
        concat!("Size of: ", stringify!(iseq_compile_data))
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_compile_data>(),
        8usize,
        concat!("Alignment of ", stringify!(iseq_compile_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).err_info as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(err_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).mark_ary as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(mark_ary)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_compile_data>())).catch_table_ary as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(catch_table_ary)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).start_label as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(start_label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).end_label as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(end_label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).redo_label as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(redo_label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).current_block as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(current_block)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_compile_data>())).loopval_popped as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(loopval_popped)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).ensure_node as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(ensure_node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).for_iseq as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(for_iseq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_compile_data>())).ensure_node_stack as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(ensure_node_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).cached_const as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(cached_const)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).storage_head as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(storage_head)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_compile_data>())).storage_current as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(storage_current)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).last_line as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(last_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).flip_cnt as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(flip_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).label_no as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(label_no)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).node_level as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(node_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).option as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(option)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_table_entry {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct global_variable {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_label_data {
    pub _address: u8,
}
