#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
/* automatically generated by rust-bindgen 0.58.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub type size_t = usize;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __clockid_t = ::std::os::raw::c_int;
pub type clockid_t = __clockid_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [usize; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_mutex_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__lock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__owner as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__nusers as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__kind as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__spins as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__elision as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__list as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __bindgen_anon_1: __pthread_cond_s__bindgen_ty_1,
    pub __bindgen_anon_2: __pthread_cond_s__bindgen_ty_2,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_1 {
    pub __wseq: ::std::os::raw::c_ulonglong,
    pub __wseq32: __pthread_cond_s__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_1__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>())).__low
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>())).__high
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq32 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq32)
        )
    );
}
impl ::std::fmt::Debug for __pthread_cond_s__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "__pthread_cond_s__bindgen_ty_1 {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_2 {
    pub __g1_start: ::std::os::raw::c_ulonglong,
    pub __g1_start32: __pthread_cond_s__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_2__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>())).__low
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>())).__high
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>())).__g1_start as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>())).__g1_start32 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start32)
        )
    );
}
impl ::std::fmt::Debug for __pthread_cond_s__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "__pthread_cond_s__bindgen_ty_2 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout___pthread_cond_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s>(),
        48usize,
        concat!("Size of: ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_refs as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g1_orig_size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g1_orig_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__wrefs as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__wrefs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_signals as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_signals)
        )
    );
}
impl ::std::fmt::Debug for __pthread_cond_s {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "__pthread_cond_s {{ __bindgen_anon_1: {:?}, __bindgen_anon_2: {:?}, __g_refs: {:?}, __g_size: {:?}, __g1_orig_size: {:?}, __wrefs: {:?}, __g_signals: {:?} }}" , self . __bindgen_anon_1 , self . __bindgen_anon_2 , self . __g_refs , self . __g_size , self . __g1_orig_size , self . __wrefs , self . __g_signals)
    }
}
pub type pthread_t = usize;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
impl ::std::fmt::Debug for pthread_mutex_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_mutex_t {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
impl ::std::fmt::Debug for pthread_cond_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_cond_t {{ union }}")
    }
}
pub type VALUE = usize;
pub type ID = usize;
pub const ruby_fl_type_RUBY_FL_WB_PROTECTED: ruby_fl_type = 32;
pub const ruby_fl_type_RUBY_FL_PROMOTED0: ruby_fl_type = 32;
pub const ruby_fl_type_RUBY_FL_PROMOTED1: ruby_fl_type = 64;
pub const ruby_fl_type_RUBY_FL_PROMOTED: ruby_fl_type = 96;
pub const ruby_fl_type_RUBY_FL_FINALIZE: ruby_fl_type = 128;
pub const ruby_fl_type_RUBY_FL_TAINT: ruby_fl_type = 256;
pub const ruby_fl_type_RUBY_FL_UNTRUSTED: ruby_fl_type = 256;
pub const ruby_fl_type_RUBY_FL_EXIVAR: ruby_fl_type = 1024;
pub const ruby_fl_type_RUBY_FL_FREEZE: ruby_fl_type = 2048;
pub const ruby_fl_type_RUBY_FL_USHIFT: ruby_fl_type = 12;
pub const ruby_fl_type_RUBY_FL_USER0: ruby_fl_type = 4096;
pub const ruby_fl_type_RUBY_FL_USER1: ruby_fl_type = 8192;
pub const ruby_fl_type_RUBY_FL_USER2: ruby_fl_type = 16384;
pub const ruby_fl_type_RUBY_FL_USER3: ruby_fl_type = 32768;
pub const ruby_fl_type_RUBY_FL_USER4: ruby_fl_type = 65536;
pub const ruby_fl_type_RUBY_FL_USER5: ruby_fl_type = 131072;
pub const ruby_fl_type_RUBY_FL_USER6: ruby_fl_type = 262144;
pub const ruby_fl_type_RUBY_FL_USER7: ruby_fl_type = 524288;
pub const ruby_fl_type_RUBY_FL_USER8: ruby_fl_type = 1048576;
pub const ruby_fl_type_RUBY_FL_USER9: ruby_fl_type = 2097152;
pub const ruby_fl_type_RUBY_FL_USER10: ruby_fl_type = 4194304;
pub const ruby_fl_type_RUBY_FL_USER11: ruby_fl_type = 8388608;
pub const ruby_fl_type_RUBY_FL_USER12: ruby_fl_type = 16777216;
pub const ruby_fl_type_RUBY_FL_USER13: ruby_fl_type = 33554432;
pub const ruby_fl_type_RUBY_FL_USER14: ruby_fl_type = 67108864;
pub const ruby_fl_type_RUBY_FL_USER15: ruby_fl_type = 134217728;
pub const ruby_fl_type_RUBY_FL_USER16: ruby_fl_type = 268435456;
pub const ruby_fl_type_RUBY_FL_USER17: ruby_fl_type = 536870912;
pub const ruby_fl_type_RUBY_FL_USER18: ruby_fl_type = 1073741824;
pub const ruby_fl_type_RUBY_FL_USER19: ruby_fl_type = -2147483648;
pub const ruby_fl_type_RUBY_ELTS_SHARED: ruby_fl_type = 16384;
pub const ruby_fl_type_RUBY_FL_DUPPED: ruby_fl_type = 1311;
pub const ruby_fl_type_RUBY_FL_SINGLETON: ruby_fl_type = 4096;
pub type ruby_fl_type = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RBasic {
    pub flags: VALUE,
    pub klass: VALUE,
}
#[test]
fn bindgen_test_layout_RBasic() {
    assert_eq!(
        ::std::mem::size_of::<RBasic>(),
        16usize,
        concat!("Size of: ", stringify!(RBasic))
    );
    assert_eq!(
        ::std::mem::align_of::<RBasic>(),
        8usize,
        concat!("Alignment of ", stringify!(RBasic))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBasic>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RBasic),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RBasic>())).klass as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RBasic),
            "::",
            stringify!(klass)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RString {
    pub basic: RBasic,
    pub as_: RString__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RString__bindgen_ty_1 {
    pub heap: RString__bindgen_ty_1__bindgen_ty_1,
    pub ary: [::std::os::raw::c_char; 24usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RString__bindgen_ty_1__bindgen_ty_1 {
    pub len: ::std::os::raw::c_long,
    pub ptr: *mut ::std::os::raw::c_char,
    pub aux: RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    pub capa: ::std::os::raw::c_long,
    pub shared: VALUE,
}
#[test]
fn bindgen_test_layout_RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>())).capa
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(capa)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>())).shared
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(shared)
        )
    );
}
impl ::std::fmt::Debug for RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {{ union }}"
        )
    }
}
#[test]
fn bindgen_test_layout_RString__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RString__bindgen_ty_1__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(RString__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<RString__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RString__bindgen_ty_1__bindgen_ty_1>())).len as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RString__bindgen_ty_1__bindgen_ty_1>())).ptr as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ptr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RString__bindgen_ty_1__bindgen_ty_1>())).aux as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(aux)
        )
    );
}
impl ::std::fmt::Debug for RString__bindgen_ty_1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "RString__bindgen_ty_1__bindgen_ty_1 {{ len: {:?}, ptr: {:?}, aux: {:?} }}",
            self.len, self.ptr, self.aux
        )
    }
}
#[test]
fn bindgen_test_layout_RString__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RString__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(RString__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<RString__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(RString__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RString__bindgen_ty_1>())).heap as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1),
            "::",
            stringify!(heap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RString__bindgen_ty_1>())).ary as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RString__bindgen_ty_1),
            "::",
            stringify!(ary)
        )
    );
}
impl ::std::fmt::Debug for RString__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "RString__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_RString() {
    assert_eq!(
        ::std::mem::size_of::<RString>(),
        40usize,
        concat!("Size of: ", stringify!(RString))
    );
    assert_eq!(
        ::std::mem::align_of::<RString>(),
        8usize,
        concat!("Alignment of ", stringify!(RString))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RString>())).basic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RString),
            "::",
            stringify!(basic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RString>())).as_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RString),
            "::",
            stringify!(as_)
        )
    );
}
impl ::std::fmt::Debug for RString {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "RString {{ basic: {:?}, as: {:?} }}",
            self.basic, self.as_
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RArray {
    pub basic: RBasic,
    pub as_: RArray__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RArray__bindgen_ty_1 {
    pub heap: RArray__bindgen_ty_1__bindgen_ty_1,
    pub ary: [VALUE; 3usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RArray__bindgen_ty_1__bindgen_ty_1 {
    pub len: ::std::os::raw::c_long,
    pub aux: RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
    pub ptr: *const VALUE,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    pub capa: ::std::os::raw::c_long,
    pub shared: VALUE,
}
#[test]
fn bindgen_test_layout_RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>())).capa
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(capa)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>())).shared
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(shared)
        )
    );
}
impl ::std::fmt::Debug for RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {{ union }}"
        )
    }
}
#[test]
fn bindgen_test_layout_RArray__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RArray__bindgen_ty_1__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(RArray__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<RArray__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RArray__bindgen_ty_1__bindgen_ty_1>())).len as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RArray__bindgen_ty_1__bindgen_ty_1>())).aux as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(aux)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RArray__bindgen_ty_1__bindgen_ty_1>())).ptr as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ptr)
        )
    );
}
impl ::std::fmt::Debug for RArray__bindgen_ty_1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "RArray__bindgen_ty_1__bindgen_ty_1 {{ len: {:?}, aux: {:?}, ptr: {:?} }}",
            self.len, self.aux, self.ptr
        )
    }
}
#[test]
fn bindgen_test_layout_RArray__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<RArray__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(RArray__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<RArray__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(RArray__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RArray__bindgen_ty_1>())).heap as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1),
            "::",
            stringify!(heap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RArray__bindgen_ty_1>())).ary as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray__bindgen_ty_1),
            "::",
            stringify!(ary)
        )
    );
}
impl ::std::fmt::Debug for RArray__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "RArray__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_RArray() {
    assert_eq!(
        ::std::mem::size_of::<RArray>(),
        40usize,
        concat!("Size of: ", stringify!(RArray))
    );
    assert_eq!(
        ::std::mem::align_of::<RArray>(),
        8usize,
        concat!("Alignment of ", stringify!(RArray))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RArray>())).basic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray),
            "::",
            stringify!(basic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RArray>())).as_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RArray),
            "::",
            stringify!(as_)
        )
    );
}
impl ::std::fmt::Debug for RArray {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "RArray {{ basic: {:?}, as: {:?} }}",
            self.basic, self.as_
        )
    }
}
pub type st_data_t = usize;
pub type st_index_t = st_data_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_hash_type {
    pub compare: ::std::option::Option<unsafe extern "C" fn() -> ::std::os::raw::c_int>,
    pub hash: ::std::option::Option<unsafe extern "C" fn() -> st_index_t>,
}
#[test]
fn bindgen_test_layout_st_hash_type() {
    assert_eq!(
        ::std::mem::size_of::<st_hash_type>(),
        16usize,
        concat!("Size of: ", stringify!(st_hash_type))
    );
    assert_eq!(
        ::std::mem::align_of::<st_hash_type>(),
        8usize,
        concat!("Alignment of ", stringify!(st_hash_type))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_hash_type>())).compare as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(st_hash_type),
            "::",
            stringify!(compare)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_hash_type>())).hash as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(st_hash_type),
            "::",
            stringify!(hash)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_table_entry {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_table {
    pub entry_power: ::std::os::raw::c_uchar,
    pub bin_power: ::std::os::raw::c_uchar,
    pub size_ind: ::std::os::raw::c_uchar,
    pub rebuilds_num: ::std::os::raw::c_uint,
    pub type_: *const st_hash_type,
    pub num_entries: st_index_t,
    pub bins: *mut st_index_t,
    pub entries_start: st_index_t,
    pub entries_bound: st_index_t,
    pub entries: *mut st_table_entry,
}
#[test]
fn bindgen_test_layout_st_table() {
    assert_eq!(
        ::std::mem::size_of::<st_table>(),
        56usize,
        concat!("Size of: ", stringify!(st_table))
    );
    assert_eq!(
        ::std::mem::align_of::<st_table>(),
        8usize,
        concat!("Alignment of ", stringify!(st_table))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).entry_power as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(entry_power)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).bin_power as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(bin_power)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).size_ind as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(size_ind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).rebuilds_num as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(rebuilds_num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).num_entries as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(num_entries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).bins as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(bins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).entries_start as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(entries_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).entries_bound as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(entries_bound)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<st_table>())).entries as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(st_table),
            "::",
            stringify!(entries)
        )
    );
}
pub type rb_unblock_function_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
pub type rb_event_flag_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_code_location_struct {
    pub lineno: ::std::os::raw::c_int,
    pub column: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_rb_code_location_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_code_location_struct>(),
        8usize,
        concat!("Size of: ", stringify!(rb_code_location_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_code_location_struct>(),
        4usize,
        concat!("Alignment of ", stringify!(rb_code_location_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_code_location_struct>())).lineno as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_code_location_struct),
            "::",
            stringify!(lineno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_code_location_struct>())).column as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_code_location_struct),
            "::",
            stringify!(column)
        )
    );
}
pub type rb_code_location_t = rb_code_location_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_code_range_struct {
    pub first_loc: rb_code_location_t,
    pub last_loc: rb_code_location_t,
}
#[test]
fn bindgen_test_layout_rb_code_range_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_code_range_struct>(),
        16usize,
        concat!("Size of: ", stringify!(rb_code_range_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_code_range_struct>(),
        4usize,
        concat!("Alignment of ", stringify!(rb_code_range_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_code_range_struct>())).first_loc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_code_range_struct),
            "::",
            stringify!(first_loc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_code_range_struct>())).last_loc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_code_range_struct),
            "::",
            stringify!(last_loc)
        )
    );
}
pub type rb_code_range_t = rb_code_range_struct;
pub const ruby_id_types_RUBY_ID_STATIC_SYM: ruby_id_types = 1;
pub const ruby_id_types_RUBY_ID_LOCAL: ruby_id_types = 0;
pub const ruby_id_types_RUBY_ID_INSTANCE: ruby_id_types = 2;
pub const ruby_id_types_RUBY_ID_GLOBAL: ruby_id_types = 6;
pub const ruby_id_types_RUBY_ID_ATTRSET: ruby_id_types = 8;
pub const ruby_id_types_RUBY_ID_CONST: ruby_id_types = 10;
pub const ruby_id_types_RUBY_ID_CLASS: ruby_id_types = 12;
pub const ruby_id_types_RUBY_ID_JUNK: ruby_id_types = 14;
pub const ruby_id_types_RUBY_ID_INTERNAL: ruby_id_types = 14;
pub const ruby_id_types_RUBY_ID_SCOPE_SHIFT: ruby_id_types = 4;
pub const ruby_id_types_RUBY_ID_SCOPE_MASK: ruby_id_types = 14;
pub type ruby_id_types = ::std::os::raw::c_uint;
pub const ruby_method_ids_idDot2: ruby_method_ids = 128;
pub const ruby_method_ids_idDot3: ruby_method_ids = 129;
pub const ruby_method_ids_idUPlus: ruby_method_ids = 130;
pub const ruby_method_ids_idUMinus: ruby_method_ids = 131;
pub const ruby_method_ids_idPow: ruby_method_ids = 132;
pub const ruby_method_ids_idCmp: ruby_method_ids = 133;
pub const ruby_method_ids_idPLUS: ruby_method_ids = 43;
pub const ruby_method_ids_idMINUS: ruby_method_ids = 45;
pub const ruby_method_ids_idMULT: ruby_method_ids = 42;
pub const ruby_method_ids_idDIV: ruby_method_ids = 47;
pub const ruby_method_ids_idMOD: ruby_method_ids = 37;
pub const ruby_method_ids_idLTLT: ruby_method_ids = 134;
pub const ruby_method_ids_idGTGT: ruby_method_ids = 135;
pub const ruby_method_ids_idLT: ruby_method_ids = 60;
pub const ruby_method_ids_idLE: ruby_method_ids = 136;
pub const ruby_method_ids_idGT: ruby_method_ids = 62;
pub const ruby_method_ids_idGE: ruby_method_ids = 137;
pub const ruby_method_ids_idEq: ruby_method_ids = 138;
pub const ruby_method_ids_idEqq: ruby_method_ids = 139;
pub const ruby_method_ids_idNeq: ruby_method_ids = 140;
pub const ruby_method_ids_idNot: ruby_method_ids = 33;
pub const ruby_method_ids_idBackquote: ruby_method_ids = 96;
pub const ruby_method_ids_idEqTilde: ruby_method_ids = 141;
pub const ruby_method_ids_idNeqTilde: ruby_method_ids = 142;
pub const ruby_method_ids_idAREF: ruby_method_ids = 143;
pub const ruby_method_ids_idASET: ruby_method_ids = 144;
pub const ruby_method_ids_idCOLON2: ruby_method_ids = 145;
pub const ruby_method_ids_idANDOP: ruby_method_ids = 146;
pub const ruby_method_ids_idOROP: ruby_method_ids = 147;
pub const ruby_method_ids_idANDDOT: ruby_method_ids = 148;
pub const ruby_method_ids_tPRESERVED_ID_BEGIN: ruby_method_ids = 148;
pub const ruby_method_ids_idNULL: ruby_method_ids = 149;
pub const ruby_method_ids_idEmptyP: ruby_method_ids = 150;
pub const ruby_method_ids_idEqlP: ruby_method_ids = 151;
pub const ruby_method_ids_idRespond_to: ruby_method_ids = 152;
pub const ruby_method_ids_idRespond_to_missing: ruby_method_ids = 153;
pub const ruby_method_ids_idIFUNC: ruby_method_ids = 154;
pub const ruby_method_ids_idCFUNC: ruby_method_ids = 155;
pub const ruby_method_ids_id_core_set_method_alias: ruby_method_ids = 156;
pub const ruby_method_ids_id_core_set_variable_alias: ruby_method_ids = 157;
pub const ruby_method_ids_id_core_undef_method: ruby_method_ids = 158;
pub const ruby_method_ids_id_core_define_method: ruby_method_ids = 159;
pub const ruby_method_ids_id_core_define_singleton_method: ruby_method_ids = 160;
pub const ruby_method_ids_id_core_set_postexe: ruby_method_ids = 161;
pub const ruby_method_ids_id_core_hash_from_ary: ruby_method_ids = 162;
pub const ruby_method_ids_id_core_hash_merge_ary: ruby_method_ids = 163;
pub const ruby_method_ids_id_core_hash_merge_ptr: ruby_method_ids = 164;
pub const ruby_method_ids_id_core_hash_merge_kwd: ruby_method_ids = 165;
pub const ruby_method_ids_id_debug_created_info: ruby_method_ids = 166;
pub const ruby_method_ids_tPRESERVED_ID_END: ruby_method_ids = 167;
pub const ruby_method_ids_tTOKEN_LOCAL_BEGIN: ruby_method_ids = 166;
pub const ruby_method_ids_tMax: ruby_method_ids = 167;
pub const ruby_method_ids_tMin: ruby_method_ids = 168;
pub const ruby_method_ids_tFreeze: ruby_method_ids = 169;
pub const ruby_method_ids_tInspect: ruby_method_ids = 170;
pub const ruby_method_ids_tIntern: ruby_method_ids = 171;
pub const ruby_method_ids_tObject_id: ruby_method_ids = 172;
pub const ruby_method_ids_tConst_missing: ruby_method_ids = 173;
pub const ruby_method_ids_tMethodMissing: ruby_method_ids = 174;
pub const ruby_method_ids_tMethod_added: ruby_method_ids = 175;
pub const ruby_method_ids_tSingleton_method_added: ruby_method_ids = 176;
pub const ruby_method_ids_tMethod_removed: ruby_method_ids = 177;
pub const ruby_method_ids_tSingleton_method_removed: ruby_method_ids = 178;
pub const ruby_method_ids_tMethod_undefined: ruby_method_ids = 179;
pub const ruby_method_ids_tSingleton_method_undefined: ruby_method_ids = 180;
pub const ruby_method_ids_tLength: ruby_method_ids = 181;
pub const ruby_method_ids_tSize: ruby_method_ids = 182;
pub const ruby_method_ids_tGets: ruby_method_ids = 183;
pub const ruby_method_ids_tSucc: ruby_method_ids = 184;
pub const ruby_method_ids_tEach: ruby_method_ids = 185;
pub const ruby_method_ids_tProc: ruby_method_ids = 186;
pub const ruby_method_ids_tLambda: ruby_method_ids = 187;
pub const ruby_method_ids_tSend: ruby_method_ids = 188;
pub const ruby_method_ids_t__send__: ruby_method_ids = 189;
pub const ruby_method_ids_t__attached__: ruby_method_ids = 190;
pub const ruby_method_ids_tInitialize: ruby_method_ids = 191;
pub const ruby_method_ids_tInitialize_copy: ruby_method_ids = 192;
pub const ruby_method_ids_tInitialize_clone: ruby_method_ids = 193;
pub const ruby_method_ids_tInitialize_dup: ruby_method_ids = 194;
pub const ruby_method_ids_tTo_int: ruby_method_ids = 195;
pub const ruby_method_ids_tTo_ary: ruby_method_ids = 196;
pub const ruby_method_ids_tTo_str: ruby_method_ids = 197;
pub const ruby_method_ids_tTo_sym: ruby_method_ids = 198;
pub const ruby_method_ids_tTo_hash: ruby_method_ids = 199;
pub const ruby_method_ids_tTo_proc: ruby_method_ids = 200;
pub const ruby_method_ids_tTo_io: ruby_method_ids = 201;
pub const ruby_method_ids_tTo_a: ruby_method_ids = 202;
pub const ruby_method_ids_tTo_s: ruby_method_ids = 203;
pub const ruby_method_ids_tTo_i: ruby_method_ids = 204;
pub const ruby_method_ids_tTo_r: ruby_method_ids = 205;
pub const ruby_method_ids_tBt: ruby_method_ids = 206;
pub const ruby_method_ids_tBt_locations: ruby_method_ids = 207;
pub const ruby_method_ids_tCall: ruby_method_ids = 208;
pub const ruby_method_ids_tMesg: ruby_method_ids = 209;
pub const ruby_method_ids_tException: ruby_method_ids = 210;
pub const ruby_method_ids_tNOT: ruby_method_ids = 211;
pub const ruby_method_ids_tAND: ruby_method_ids = 212;
pub const ruby_method_ids_tOR: ruby_method_ids = 213;
pub const ruby_method_ids_tUScore: ruby_method_ids = 214;
pub const ruby_method_ids_tTOKEN_LOCAL_END: ruby_method_ids = 215;
pub const ruby_method_ids_tTOKEN_INSTANCE_BEGIN: ruby_method_ids = 214;
pub const ruby_method_ids_tTOKEN_INSTANCE_END: ruby_method_ids = 215;
pub const ruby_method_ids_tTOKEN_GLOBAL_BEGIN: ruby_method_ids = 214;
pub const ruby_method_ids_tLASTLINE: ruby_method_ids = 215;
pub const ruby_method_ids_tBACKREF: ruby_method_ids = 216;
pub const ruby_method_ids_tTOKEN_GLOBAL_END: ruby_method_ids = 217;
pub const ruby_method_ids_tTOKEN_CONST_BEGIN: ruby_method_ids = 216;
pub const ruby_method_ids_tTOKEN_CONST_END: ruby_method_ids = 217;
pub const ruby_method_ids_tTOKEN_CLASS_BEGIN: ruby_method_ids = 216;
pub const ruby_method_ids_tTOKEN_CLASS_END: ruby_method_ids = 217;
pub const ruby_method_ids_tTOKEN_ATTRSET_BEGIN: ruby_method_ids = 216;
pub const ruby_method_ids_tTOKEN_ATTRSET_END: ruby_method_ids = 217;
pub const ruby_method_ids_tNEXT_ID: ruby_method_ids = 217;
pub const ruby_method_ids_idMax: ruby_method_ids = 2673;
pub const ruby_method_ids_idMin: ruby_method_ids = 2689;
pub const ruby_method_ids_idFreeze: ruby_method_ids = 2705;
pub const ruby_method_ids_idInspect: ruby_method_ids = 2721;
pub const ruby_method_ids_idIntern: ruby_method_ids = 2737;
pub const ruby_method_ids_idObject_id: ruby_method_ids = 2753;
pub const ruby_method_ids_idConst_missing: ruby_method_ids = 2769;
pub const ruby_method_ids_idMethodMissing: ruby_method_ids = 2785;
pub const ruby_method_ids_idMethod_added: ruby_method_ids = 2801;
pub const ruby_method_ids_idSingleton_method_added: ruby_method_ids = 2817;
pub const ruby_method_ids_idMethod_removed: ruby_method_ids = 2833;
pub const ruby_method_ids_idSingleton_method_removed: ruby_method_ids = 2849;
pub const ruby_method_ids_idMethod_undefined: ruby_method_ids = 2865;
pub const ruby_method_ids_idSingleton_method_undefined: ruby_method_ids = 2881;
pub const ruby_method_ids_idLength: ruby_method_ids = 2897;
pub const ruby_method_ids_idSize: ruby_method_ids = 2913;
pub const ruby_method_ids_idGets: ruby_method_ids = 2929;
pub const ruby_method_ids_idSucc: ruby_method_ids = 2945;
pub const ruby_method_ids_idEach: ruby_method_ids = 2961;
pub const ruby_method_ids_idProc: ruby_method_ids = 2977;
pub const ruby_method_ids_idLambda: ruby_method_ids = 2993;
pub const ruby_method_ids_idSend: ruby_method_ids = 3009;
pub const ruby_method_ids_id__send__: ruby_method_ids = 3025;
pub const ruby_method_ids_id__attached__: ruby_method_ids = 3041;
pub const ruby_method_ids_idInitialize: ruby_method_ids = 3057;
pub const ruby_method_ids_idInitialize_copy: ruby_method_ids = 3073;
pub const ruby_method_ids_idInitialize_clone: ruby_method_ids = 3089;
pub const ruby_method_ids_idInitialize_dup: ruby_method_ids = 3105;
pub const ruby_method_ids_idTo_int: ruby_method_ids = 3121;
pub const ruby_method_ids_idTo_ary: ruby_method_ids = 3137;
pub const ruby_method_ids_idTo_str: ruby_method_ids = 3153;
pub const ruby_method_ids_idTo_sym: ruby_method_ids = 3169;
pub const ruby_method_ids_idTo_hash: ruby_method_ids = 3185;
pub const ruby_method_ids_idTo_proc: ruby_method_ids = 3201;
pub const ruby_method_ids_idTo_io: ruby_method_ids = 3217;
pub const ruby_method_ids_idTo_a: ruby_method_ids = 3233;
pub const ruby_method_ids_idTo_s: ruby_method_ids = 3249;
pub const ruby_method_ids_idTo_i: ruby_method_ids = 3265;
pub const ruby_method_ids_idTo_r: ruby_method_ids = 3281;
pub const ruby_method_ids_idBt: ruby_method_ids = 3297;
pub const ruby_method_ids_idBt_locations: ruby_method_ids = 3313;
pub const ruby_method_ids_idCall: ruby_method_ids = 3329;
pub const ruby_method_ids_idMesg: ruby_method_ids = 3345;
pub const ruby_method_ids_idException: ruby_method_ids = 3361;
pub const ruby_method_ids_idNOT: ruby_method_ids = 3377;
pub const ruby_method_ids_idAND: ruby_method_ids = 3393;
pub const ruby_method_ids_idOR: ruby_method_ids = 3409;
pub const ruby_method_ids_idUScore: ruby_method_ids = 3425;
pub const ruby_method_ids_idLASTLINE: ruby_method_ids = 3447;
pub const ruby_method_ids_idBACKREF: ruby_method_ids = 3463;
pub const ruby_method_ids_tLAST_OP_ID: ruby_method_ids = 166;
pub const ruby_method_ids_idLAST_OP_ID: ruby_method_ids = 10;
pub type ruby_method_ids = ::std::os::raw::c_uint;
pub type rb_serial_t = ::std::os::raw::c_ulonglong;
pub const imemo_type_imemo_env: imemo_type = 0;
pub const imemo_type_imemo_cref: imemo_type = 1;
pub const imemo_type_imemo_svar: imemo_type = 2;
pub const imemo_type_imemo_throw_data: imemo_type = 3;
pub const imemo_type_imemo_ifunc: imemo_type = 4;
pub const imemo_type_imemo_memo: imemo_type = 5;
pub const imemo_type_imemo_ment: imemo_type = 6;
pub const imemo_type_imemo_iseq: imemo_type = 7;
pub const imemo_type_imemo_alloc: imemo_type = 8;
pub const imemo_type_imemo_ast: imemo_type = 9;
pub const imemo_type_imemo_parser_strterm: imemo_type = 10;
pub type imemo_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_svar {
    pub flags: VALUE,
    pub cref_or_me: VALUE,
    pub lastline: VALUE,
    pub backref: VALUE,
    pub others: VALUE,
}
#[test]
fn bindgen_test_layout_vm_svar() {
    assert_eq!(
        ::std::mem::size_of::<vm_svar>(),
        40usize,
        concat!("Size of: ", stringify!(vm_svar))
    );
    assert_eq!(
        ::std::mem::align_of::<vm_svar>(),
        8usize,
        concat!("Alignment of ", stringify!(vm_svar))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vm_svar>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_svar),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vm_svar>())).cref_or_me as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_svar),
            "::",
            stringify!(cref_or_me)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vm_svar>())).lastline as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_svar),
            "::",
            stringify!(lastline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vm_svar>())).backref as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_svar),
            "::",
            stringify!(backref)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vm_svar>())).others as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_svar),
            "::",
            stringify!(others)
        )
    );
}
pub const rb_method_visibility_t_METHOD_VISI_UNDEF: rb_method_visibility_t = 0;
pub const rb_method_visibility_t_METHOD_VISI_PUBLIC: rb_method_visibility_t = 1;
pub const rb_method_visibility_t_METHOD_VISI_PRIVATE: rb_method_visibility_t = 2;
pub const rb_method_visibility_t_METHOD_VISI_PROTECTED: rb_method_visibility_t = 3;
pub const rb_method_visibility_t_METHOD_VISI_MASK: rb_method_visibility_t = 3;
pub type rb_method_visibility_t = ::std::os::raw::c_uint;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct rb_scope_visi_struct {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_rb_scope_visi_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_scope_visi_struct>(),
        4usize,
        concat!("Size of: ", stringify!(rb_scope_visi_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_scope_visi_struct>(),
        4usize,
        concat!("Alignment of ", stringify!(rb_scope_visi_struct))
    );
}
impl rb_scope_visi_struct {
    #[inline]
    pub fn method_visi(&self) -> rb_method_visibility_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_method_visi(&mut self, val: rb_method_visibility_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn module_func(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_module_func(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        method_visi: rb_method_visibility_t,
        module_func: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let method_visi: u32 = unsafe { ::std::mem::transmute(method_visi) };
            method_visi as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let module_func: u32 = unsafe { ::std::mem::transmute(module_func) };
            module_func as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type rb_scope_visibility_t = rb_scope_visi_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_cref_struct {
    pub flags: VALUE,
    pub refinements: VALUE,
    pub klass: VALUE,
    pub next: *mut rb_cref_struct,
    pub scope_visi: rb_scope_visibility_t,
}
#[test]
fn bindgen_test_layout_rb_cref_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_cref_struct>(),
        40usize,
        concat!("Size of: ", stringify!(rb_cref_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_cref_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_cref_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_cref_struct>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_cref_struct),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_cref_struct>())).refinements as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_cref_struct),
            "::",
            stringify!(refinements)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_cref_struct>())).klass as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_cref_struct),
            "::",
            stringify!(klass)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_cref_struct>())).next as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_cref_struct),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_cref_struct>())).scope_visi as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_cref_struct),
            "::",
            stringify!(scope_visi)
        )
    );
}
pub type rb_cref_t = rb_cref_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_method_entry_struct {
    pub flags: VALUE,
    pub defined_class: VALUE,
    pub def: *mut rb_method_definition_struct,
    pub called_id: ID,
    pub owner: VALUE,
}
#[test]
fn bindgen_test_layout_rb_method_entry_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_method_entry_struct>(),
        40usize,
        concat!("Size of: ", stringify!(rb_method_entry_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_method_entry_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_method_entry_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_method_entry_struct>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_entry_struct),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_entry_struct>())).defined_class as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_entry_struct),
            "::",
            stringify!(defined_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_method_entry_struct>())).def as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_entry_struct),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_entry_struct>())).called_id as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_entry_struct),
            "::",
            stringify!(called_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_method_entry_struct>())).owner as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_entry_struct),
            "::",
            stringify!(owner)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_callable_method_entry_struct {
    pub flags: VALUE,
    pub defined_class: VALUE,
    pub def: *mut rb_method_definition_struct,
    pub called_id: ID,
    pub owner: VALUE,
}
#[test]
fn bindgen_test_layout_rb_callable_method_entry_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_callable_method_entry_struct>(),
        40usize,
        concat!("Size of: ", stringify!(rb_callable_method_entry_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_callable_method_entry_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_callable_method_entry_struct))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_callable_method_entry_struct>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_callable_method_entry_struct),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_callable_method_entry_struct>())).defined_class as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_callable_method_entry_struct),
            "::",
            stringify!(defined_class)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_callable_method_entry_struct>())).def as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_callable_method_entry_struct),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_callable_method_entry_struct>())).called_id as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_callable_method_entry_struct),
            "::",
            stringify!(called_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_callable_method_entry_struct>())).owner as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_callable_method_entry_struct),
            "::",
            stringify!(owner)
        )
    );
}
pub type rb_callable_method_entry_t = rb_callable_method_entry_struct;
pub type rb_iseq_t = rb_iseq_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_method_iseq_struct {
    pub iseqptr: *const rb_iseq_t,
    pub cref: *mut rb_cref_t,
}
#[test]
fn bindgen_test_layout_rb_method_iseq_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_method_iseq_struct>(),
        16usize,
        concat!("Size of: ", stringify!(rb_method_iseq_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_method_iseq_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_method_iseq_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_method_iseq_struct>())).iseqptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_iseq_struct),
            "::",
            stringify!(iseqptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_method_iseq_struct>())).cref as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_iseq_struct),
            "::",
            stringify!(cref)
        )
    );
}
pub type rb_method_iseq_t = rb_method_iseq_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_method_cfunc_struct {
    pub func: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
    pub invoker: ::std::option::Option<
        unsafe extern "C" fn(
            func: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
            recv: VALUE,
            argc: ::std::os::raw::c_int,
            argv: *const VALUE,
        ) -> VALUE,
    >,
    pub argc: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_rb_method_cfunc_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_method_cfunc_struct>(),
        24usize,
        concat!("Size of: ", stringify!(rb_method_cfunc_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_method_cfunc_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_method_cfunc_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_method_cfunc_struct>())).func as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_cfunc_struct),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_method_cfunc_struct>())).invoker as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_cfunc_struct),
            "::",
            stringify!(invoker)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_method_cfunc_struct>())).argc as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_cfunc_struct),
            "::",
            stringify!(argc)
        )
    );
}
pub type rb_method_cfunc_t = rb_method_cfunc_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_method_attr_struct {
    pub id: ID,
    pub location: VALUE,
}
#[test]
fn bindgen_test_layout_rb_method_attr_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_method_attr_struct>(),
        16usize,
        concat!("Size of: ", stringify!(rb_method_attr_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_method_attr_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_method_attr_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_method_attr_struct>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_attr_struct),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_method_attr_struct>())).location as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_attr_struct),
            "::",
            stringify!(location)
        )
    );
}
pub type rb_method_attr_t = rb_method_attr_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_method_alias_struct {
    pub original_me: *const rb_method_entry_struct,
}
#[test]
fn bindgen_test_layout_rb_method_alias_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_method_alias_struct>(),
        8usize,
        concat!("Size of: ", stringify!(rb_method_alias_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_method_alias_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_method_alias_struct))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_alias_struct>())).original_me as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_alias_struct),
            "::",
            stringify!(original_me)
        )
    );
}
pub type rb_method_alias_t = rb_method_alias_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_method_refined_struct {
    pub orig_me: *const rb_method_entry_struct,
    pub owner: VALUE,
}
#[test]
fn bindgen_test_layout_rb_method_refined_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_method_refined_struct>(),
        16usize,
        concat!("Size of: ", stringify!(rb_method_refined_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_method_refined_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_method_refined_struct))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_refined_struct>())).orig_me as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_refined_struct),
            "::",
            stringify!(orig_me)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_method_refined_struct>())).owner as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_refined_struct),
            "::",
            stringify!(owner)
        )
    );
}
pub type rb_method_refined_t = rb_method_refined_struct;
pub const method_optimized_type_OPTIMIZED_METHOD_TYPE_SEND: method_optimized_type = 0;
pub const method_optimized_type_OPTIMIZED_METHOD_TYPE_CALL: method_optimized_type = 1;
pub const method_optimized_type_OPTIMIZED_METHOD_TYPE__MAX: method_optimized_type = 2;
pub type method_optimized_type = ::std::os::raw::c_uint;
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct rb_method_definition_struct {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
    pub body: rb_method_definition_struct__bindgen_ty_1,
    pub original_id: ID,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union rb_method_definition_struct__bindgen_ty_1 {
    pub iseq: rb_method_iseq_t,
    pub cfunc: rb_method_cfunc_t,
    pub attr: rb_method_attr_t,
    pub alias: rb_method_alias_t,
    pub refined: rb_method_refined_t,
    pub proc_: VALUE,
    pub optimize_type: method_optimized_type,
}
#[test]
fn bindgen_test_layout_rb_method_definition_struct__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<rb_method_definition_struct__bindgen_ty_1>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(rb_method_definition_struct__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<rb_method_definition_struct__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(rb_method_definition_struct__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_definition_struct__bindgen_ty_1>())).iseq as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_definition_struct__bindgen_ty_1),
            "::",
            stringify!(iseq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_definition_struct__bindgen_ty_1>())).cfunc as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_definition_struct__bindgen_ty_1),
            "::",
            stringify!(cfunc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_definition_struct__bindgen_ty_1>())).attr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_definition_struct__bindgen_ty_1),
            "::",
            stringify!(attr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_definition_struct__bindgen_ty_1>())).alias as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_definition_struct__bindgen_ty_1),
            "::",
            stringify!(alias)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_definition_struct__bindgen_ty_1>())).refined
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_definition_struct__bindgen_ty_1),
            "::",
            stringify!(refined)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_definition_struct__bindgen_ty_1>())).proc_ as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_definition_struct__bindgen_ty_1),
            "::",
            stringify!(proc_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_definition_struct__bindgen_ty_1>())).optimize_type
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_definition_struct__bindgen_ty_1),
            "::",
            stringify!(optimize_type)
        )
    );
}
impl ::std::fmt::Debug for rb_method_definition_struct__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "rb_method_definition_struct__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_rb_method_definition_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_method_definition_struct>(),
        40usize,
        concat!("Size of: ", stringify!(rb_method_definition_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_method_definition_struct>(),
        1usize,
        concat!("Alignment of ", stringify!(rb_method_definition_struct))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_definition_struct>())).body as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_definition_struct),
            "::",
            stringify!(body)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_method_definition_struct>())).original_id as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_method_definition_struct),
            "::",
            stringify!(original_id)
        )
    );
}
impl ::std::fmt::Debug for rb_method_definition_struct {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "rb_method_definition_struct {{ type : {:?}, alias_count : {:?}, complemented_count : {:?}, body: {:?}, original_id: {:?} }}" , self . type_ () , self . alias_count () , self . complemented_count () , self . body , self . original_id)
    }
}
impl rb_method_definition_struct {
    #[inline]
    pub fn type_(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn alias_count(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 28u8) as u32) }
    }
    #[inline]
    pub fn set_alias_count(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 28u8, val as u64)
        }
    }
    #[inline]
    pub fn complemented_count(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 28u8) as u32) }
    }
    #[inline]
    pub fn set_complemented_count(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 28u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: ::std::os::raw::c_uint,
        alias_count: ::std::os::raw::c_int,
        complemented_count: ::std::os::raw::c_int,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit.set(4usize, 28u8, {
            let alias_count: u32 = unsafe { ::std::mem::transmute(alias_count) };
            alias_count as u64
        });
        __bindgen_bitfield_unit.set(32usize, 28u8, {
            let complemented_count: u32 = unsafe { ::std::mem::transmute(complemented_count) };
            complemented_count as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type rb_atomic_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct list_node {
    pub next: *mut list_node,
    pub prev: *mut list_node,
}
#[test]
fn bindgen_test_layout_list_node() {
    assert_eq!(
        ::std::mem::size_of::<list_node>(),
        16usize,
        concat!("Size of: ", stringify!(list_node))
    );
    assert_eq!(
        ::std::mem::align_of::<list_node>(),
        8usize,
        concat!("Alignment of ", stringify!(list_node))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<list_node>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(list_node),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<list_node>())).prev as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(list_node),
            "::",
            stringify!(prev)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct list_head {
    pub n: list_node,
}
#[test]
fn bindgen_test_layout_list_head() {
    assert_eq!(
        ::std::mem::size_of::<list_head>(),
        16usize,
        concat!("Size of: ", stringify!(list_head))
    );
    assert_eq!(
        ::std::mem::align_of::<list_head>(),
        8usize,
        concat!("Alignment of ", stringify!(list_head))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<list_head>())).n as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(list_head),
            "::",
            stringify!(n)
        )
    );
}
pub type __jmp_buf = [::std::os::raw::c_long; 8usize];
pub type rb_nativethread_id_t = pthread_t;
pub type rb_nativethread_lock_t = pthread_mutex_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rb_thread_cond_struct {
    pub cond: pthread_cond_t,
    pub clockid: clockid_t,
}
#[test]
fn bindgen_test_layout_rb_thread_cond_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_thread_cond_struct>(),
        56usize,
        concat!("Size of: ", stringify!(rb_thread_cond_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_thread_cond_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_thread_cond_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_cond_struct>())).cond as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_cond_struct),
            "::",
            stringify!(cond)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_cond_struct>())).clockid as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_cond_struct),
            "::",
            stringify!(clockid)
        )
    );
}
impl ::std::fmt::Debug for rb_thread_cond_struct {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "rb_thread_cond_struct {{ cond: {:?}, clockid: {:?} }}",
            self.cond, self.clockid
        )
    }
}
pub type rb_nativethread_cond_t = rb_thread_cond_struct;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct native_thread_data_struct {
    pub ubf_list: list_node,
    pub sleep_cond: rb_nativethread_cond_t,
}
#[test]
fn bindgen_test_layout_native_thread_data_struct() {
    assert_eq!(
        ::std::mem::size_of::<native_thread_data_struct>(),
        72usize,
        concat!("Size of: ", stringify!(native_thread_data_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<native_thread_data_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(native_thread_data_struct))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<native_thread_data_struct>())).ubf_list as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(native_thread_data_struct),
            "::",
            stringify!(ubf_list)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<native_thread_data_struct>())).sleep_cond as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(native_thread_data_struct),
            "::",
            stringify!(sleep_cond)
        )
    );
}
impl ::std::fmt::Debug for native_thread_data_struct {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "native_thread_data_struct {{ ubf_list: {:?}, sleep_cond: {:?} }}",
            self.ubf_list, self.sleep_cond
        )
    }
}
pub type native_thread_data_t = native_thread_data_struct;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rb_global_vm_lock_struct {
    pub acquired: ::std::os::raw::c_ulong,
    pub lock: rb_nativethread_lock_t,
    pub waiting: ::std::os::raw::c_ulong,
    pub cond: rb_nativethread_cond_t,
    pub switch_cond: rb_nativethread_cond_t,
    pub switch_wait_cond: rb_nativethread_cond_t,
    pub need_yield: ::std::os::raw::c_int,
    pub wait_yield: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_rb_global_vm_lock_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_global_vm_lock_struct>(),
        232usize,
        concat!("Size of: ", stringify!(rb_global_vm_lock_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_global_vm_lock_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_global_vm_lock_struct))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_global_vm_lock_struct>())).acquired as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_global_vm_lock_struct),
            "::",
            stringify!(acquired)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_global_vm_lock_struct>())).lock as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_global_vm_lock_struct),
            "::",
            stringify!(lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_global_vm_lock_struct>())).waiting as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_global_vm_lock_struct),
            "::",
            stringify!(waiting)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_global_vm_lock_struct>())).cond as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_global_vm_lock_struct),
            "::",
            stringify!(cond)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_global_vm_lock_struct>())).switch_cond as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_global_vm_lock_struct),
            "::",
            stringify!(switch_cond)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_global_vm_lock_struct>())).switch_wait_cond as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_global_vm_lock_struct),
            "::",
            stringify!(switch_wait_cond)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_global_vm_lock_struct>())).need_yield as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_global_vm_lock_struct),
            "::",
            stringify!(need_yield)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_global_vm_lock_struct>())).wait_yield as *const _ as usize
        },
        228usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_global_vm_lock_struct),
            "::",
            stringify!(wait_yield)
        )
    );
}
impl ::std::fmt::Debug for rb_global_vm_lock_struct {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "rb_global_vm_lock_struct {{ acquired: {:?}, lock: {:?}, waiting: {:?}, cond: {:?}, switch_cond: {:?}, switch_wait_cond: {:?}, need_yield: {:?}, wait_yield: {:?} }}" , self . acquired , self . lock , self . waiting , self . cond , self . switch_cond , self . switch_wait_cond , self . need_yield , self . wait_yield)
    }
}
pub type rb_global_vm_lock_t = rb_global_vm_lock_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __jmp_buf_tag {
    pub __jmpbuf: __jmp_buf,
    pub __mask_was_saved: ::std::os::raw::c_int,
    pub __saved_mask: __sigset_t,
}
#[test]
fn bindgen_test_layout___jmp_buf_tag() {
    assert_eq!(
        ::std::mem::size_of::<__jmp_buf_tag>(),
        200usize,
        concat!("Size of: ", stringify!(__jmp_buf_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__jmp_buf_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__jmp_buf_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__jmp_buf_tag>())).__jmpbuf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__jmpbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__jmp_buf_tag>())).__mask_was_saved as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__mask_was_saved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__jmp_buf_tag>())).__saved_mask as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__saved_mask)
        )
    );
}
pub type jmp_buf = [__jmp_buf_tag; 1usize];
pub type sigjmp_buf = [__jmp_buf_tag; 1usize];
pub const ruby_tag_type_RUBY_TAG_NONE: ruby_tag_type = 0;
pub const ruby_tag_type_RUBY_TAG_RETURN: ruby_tag_type = 1;
pub const ruby_tag_type_RUBY_TAG_BREAK: ruby_tag_type = 2;
pub const ruby_tag_type_RUBY_TAG_NEXT: ruby_tag_type = 3;
pub const ruby_tag_type_RUBY_TAG_RETRY: ruby_tag_type = 4;
pub const ruby_tag_type_RUBY_TAG_REDO: ruby_tag_type = 5;
pub const ruby_tag_type_RUBY_TAG_RAISE: ruby_tag_type = 6;
pub const ruby_tag_type_RUBY_TAG_THROW: ruby_tag_type = 7;
pub const ruby_tag_type_RUBY_TAG_FATAL: ruby_tag_type = 8;
pub const ruby_tag_type_RUBY_TAG_MASK: ruby_tag_type = 15;
pub type ruby_tag_type = ::std::os::raw::c_uint;
pub type rb_compile_option_t = rb_compile_option_struct;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct iseq_inline_cache_entry {
    pub ic_serial: rb_serial_t,
    pub ic_cref: *const rb_cref_t,
    pub ic_value: iseq_inline_cache_entry__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union iseq_inline_cache_entry__bindgen_ty_1 {
    pub index: size_t,
    pub value: VALUE,
}
#[test]
fn bindgen_test_layout_iseq_inline_cache_entry__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<iseq_inline_cache_entry__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(iseq_inline_cache_entry__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_inline_cache_entry__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(iseq_inline_cache_entry__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_inline_cache_entry__bindgen_ty_1>())).index as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_inline_cache_entry__bindgen_ty_1),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_inline_cache_entry__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_inline_cache_entry__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
impl ::std::fmt::Debug for iseq_inline_cache_entry__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "iseq_inline_cache_entry__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_iseq_inline_cache_entry() {
    assert_eq!(
        ::std::mem::size_of::<iseq_inline_cache_entry>(),
        24usize,
        concat!("Size of: ", stringify!(iseq_inline_cache_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_inline_cache_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(iseq_inline_cache_entry))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_inline_cache_entry>())).ic_serial as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_inline_cache_entry),
            "::",
            stringify!(ic_serial)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_inline_cache_entry>())).ic_cref as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_inline_cache_entry),
            "::",
            stringify!(ic_cref)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_inline_cache_entry>())).ic_value as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_inline_cache_entry),
            "::",
            stringify!(ic_value)
        )
    );
}
impl ::std::fmt::Debug for iseq_inline_cache_entry {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "iseq_inline_cache_entry {{ ic_serial: {:?}, ic_cref: {:?}, ic_value: {:?} }}",
            self.ic_serial, self.ic_cref, self.ic_value
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union iseq_inline_storage_entry {
    pub once: iseq_inline_storage_entry__bindgen_ty_1,
    pub cache: iseq_inline_cache_entry,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_inline_storage_entry__bindgen_ty_1 {
    pub running_thread: *mut rb_thread_struct,
    pub value: VALUE,
}
#[test]
fn bindgen_test_layout_iseq_inline_storage_entry__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<iseq_inline_storage_entry__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(iseq_inline_storage_entry__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_inline_storage_entry__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(iseq_inline_storage_entry__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_inline_storage_entry__bindgen_ty_1>())).running_thread
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_inline_storage_entry__bindgen_ty_1),
            "::",
            stringify!(running_thread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_inline_storage_entry__bindgen_ty_1>())).value as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_inline_storage_entry__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout_iseq_inline_storage_entry() {
    assert_eq!(
        ::std::mem::size_of::<iseq_inline_storage_entry>(),
        24usize,
        concat!("Size of: ", stringify!(iseq_inline_storage_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_inline_storage_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(iseq_inline_storage_entry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_inline_storage_entry>())).once as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_inline_storage_entry),
            "::",
            stringify!(once)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_inline_storage_entry>())).cache as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_inline_storage_entry),
            "::",
            stringify!(cache)
        )
    );
}
impl ::std::fmt::Debug for iseq_inline_storage_entry {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "iseq_inline_storage_entry {{ union }}")
    }
}
pub const method_missing_reason_MISSING_NOENTRY: method_missing_reason = 0;
pub const method_missing_reason_MISSING_PRIVATE: method_missing_reason = 1;
pub const method_missing_reason_MISSING_PROTECTED: method_missing_reason = 2;
pub const method_missing_reason_MISSING_FCALL: method_missing_reason = 4;
pub const method_missing_reason_MISSING_VCALL: method_missing_reason = 8;
pub const method_missing_reason_MISSING_SUPER: method_missing_reason = 16;
pub const method_missing_reason_MISSING_MISSING: method_missing_reason = 32;
pub const method_missing_reason_MISSING_NONE: method_missing_reason = 64;
pub type method_missing_reason = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_call_info {
    pub mid: ID,
    pub flag: ::std::os::raw::c_uint,
    pub orig_argc: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_rb_call_info() {
    assert_eq!(
        ::std::mem::size_of::<rb_call_info>(),
        16usize,
        concat!("Size of: ", stringify!(rb_call_info))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_call_info>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_call_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_call_info>())).mid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_call_info),
            "::",
            stringify!(mid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_call_info>())).flag as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_call_info),
            "::",
            stringify!(flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_call_info>())).orig_argc as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_call_info),
            "::",
            stringify!(orig_argc)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_calling_info {
    pub block_handler: VALUE,
    pub recv: VALUE,
    pub argc: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_rb_calling_info() {
    assert_eq!(
        ::std::mem::size_of::<rb_calling_info>(),
        24usize,
        concat!("Size of: ", stringify!(rb_calling_info))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_calling_info>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_calling_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_calling_info>())).block_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_calling_info),
            "::",
            stringify!(block_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_calling_info>())).recv as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_calling_info),
            "::",
            stringify!(recv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_calling_info>())).argc as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_calling_info),
            "::",
            stringify!(argc)
        )
    );
}
pub type vm_call_handler = ::std::option::Option<
    unsafe extern "C" fn(
        ec: *mut rb_execution_context_struct,
        cfp: *mut rb_control_frame_struct,
        calling: *mut rb_calling_info,
        ci: *const rb_call_info,
        cc: *mut rb_call_cache,
    ) -> VALUE,
>;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rb_call_cache {
    pub method_state: rb_serial_t,
    pub class_serial: rb_serial_t,
    pub me: *const rb_callable_method_entry_t,
    pub call: vm_call_handler,
    pub aux: rb_call_cache__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union rb_call_cache__bindgen_ty_1 {
    pub index: ::std::os::raw::c_uint,
    pub method_missing_reason: method_missing_reason,
    pub inc_sp: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_rb_call_cache__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<rb_call_cache__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(rb_call_cache__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_call_cache__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(rb_call_cache__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_call_cache__bindgen_ty_1>())).index as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_call_cache__bindgen_ty_1),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_call_cache__bindgen_ty_1>())).method_missing_reason
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_call_cache__bindgen_ty_1),
            "::",
            stringify!(method_missing_reason)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_call_cache__bindgen_ty_1>())).inc_sp as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_call_cache__bindgen_ty_1),
            "::",
            stringify!(inc_sp)
        )
    );
}
impl ::std::fmt::Debug for rb_call_cache__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "rb_call_cache__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_rb_call_cache() {
    assert_eq!(
        ::std::mem::size_of::<rb_call_cache>(),
        40usize,
        concat!("Size of: ", stringify!(rb_call_cache))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_call_cache>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_call_cache))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_call_cache>())).method_state as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_call_cache),
            "::",
            stringify!(method_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_call_cache>())).class_serial as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_call_cache),
            "::",
            stringify!(class_serial)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_call_cache>())).me as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_call_cache),
            "::",
            stringify!(me)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_call_cache>())).call as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_call_cache),
            "::",
            stringify!(call)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_call_cache>())).aux as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_call_cache),
            "::",
            stringify!(aux)
        )
    );
}
impl ::std::fmt::Debug for rb_call_cache {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "rb_call_cache {{ method_state: {:?}, class_serial: {:?}, me: {:?}, call: {:?}, aux: {:?} }}" , self . method_state , self . class_serial , self . me , self . call , self . aux)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_iseq_location_struct {
    pub pathobj: VALUE,
    pub base_label: VALUE,
    pub label: VALUE,
    pub first_lineno: VALUE,
    pub code_range: rb_code_range_t,
}
#[test]
fn bindgen_test_layout_rb_iseq_location_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_iseq_location_struct>(),
        48usize,
        concat!("Size of: ", stringify!(rb_iseq_location_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_iseq_location_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_iseq_location_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_location_struct>())).pathobj as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_location_struct),
            "::",
            stringify!(pathobj)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_location_struct>())).base_label as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_location_struct),
            "::",
            stringify!(base_label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_location_struct>())).label as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_location_struct),
            "::",
            stringify!(label)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_location_struct>())).first_lineno as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_location_struct),
            "::",
            stringify!(first_lineno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_location_struct>())).code_range as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_location_struct),
            "::",
            stringify!(code_range)
        )
    );
}
pub type rb_iseq_location_t = rb_iseq_location_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_iseq_constant_body {
    pub type_: rb_iseq_constant_body_iseq_type,
    pub iseq_size: ::std::os::raw::c_uint,
    pub iseq_encoded: *const VALUE,
    pub param: rb_iseq_constant_body__bindgen_ty_1,
    pub location: rb_iseq_location_t,
    pub insns_info: *const iseq_insn_info_entry,
    pub local_table: *const ID,
    pub catch_table: *const iseq_catch_table,
    pub parent_iseq: *const rb_iseq_struct,
    pub local_iseq: *mut rb_iseq_struct,
    pub is_entries: *mut iseq_inline_storage_entry,
    pub ci_entries: *mut rb_call_info,
    pub cc_entries: *mut rb_call_cache,
    pub mark_ary: VALUE,
    pub local_table_size: ::std::os::raw::c_uint,
    pub is_size: ::std::os::raw::c_uint,
    pub ci_size: ::std::os::raw::c_uint,
    pub ci_kw_size: ::std::os::raw::c_uint,
    pub insns_info_size: ::std::os::raw::c_uint,
    pub stack_max: ::std::os::raw::c_uint,
}
pub const rb_iseq_constant_body_iseq_type_ISEQ_TYPE_TOP: rb_iseq_constant_body_iseq_type = 0;
pub const rb_iseq_constant_body_iseq_type_ISEQ_TYPE_METHOD: rb_iseq_constant_body_iseq_type = 1;
pub const rb_iseq_constant_body_iseq_type_ISEQ_TYPE_BLOCK: rb_iseq_constant_body_iseq_type = 2;
pub const rb_iseq_constant_body_iseq_type_ISEQ_TYPE_CLASS: rb_iseq_constant_body_iseq_type = 3;
pub const rb_iseq_constant_body_iseq_type_ISEQ_TYPE_RESCUE: rb_iseq_constant_body_iseq_type = 4;
pub const rb_iseq_constant_body_iseq_type_ISEQ_TYPE_ENSURE: rb_iseq_constant_body_iseq_type = 5;
pub const rb_iseq_constant_body_iseq_type_ISEQ_TYPE_EVAL: rb_iseq_constant_body_iseq_type = 6;
pub const rb_iseq_constant_body_iseq_type_ISEQ_TYPE_MAIN: rb_iseq_constant_body_iseq_type = 7;
pub const rb_iseq_constant_body_iseq_type_ISEQ_TYPE_DEFINED_GUARD: rb_iseq_constant_body_iseq_type =
    8;
pub type rb_iseq_constant_body_iseq_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_iseq_constant_body__bindgen_ty_1 {
    pub flags: rb_iseq_constant_body__bindgen_ty_1__bindgen_ty_1,
    pub size: ::std::os::raw::c_uint,
    pub lead_num: ::std::os::raw::c_int,
    pub opt_num: ::std::os::raw::c_int,
    pub rest_start: ::std::os::raw::c_int,
    pub post_start: ::std::os::raw::c_int,
    pub post_num: ::std::os::raw::c_int,
    pub block_start: ::std::os::raw::c_int,
    pub opt_table: *const VALUE,
    pub keyword: *const rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct rb_iseq_constant_body__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_rb_iseq_constant_body__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<rb_iseq_constant_body__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<rb_iseq_constant_body__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl rb_iseq_constant_body__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn has_lead(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_lead(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has_opt(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_opt(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has_rest(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_rest(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has_post(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_post(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has_kw(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_kw(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has_kwrest(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_kwrest(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has_block(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_block(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ambiguous_param0(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ambiguous_param0(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        has_lead: ::std::os::raw::c_uint,
        has_opt: ::std::os::raw::c_uint,
        has_rest: ::std::os::raw::c_uint,
        has_post: ::std::os::raw::c_uint,
        has_kw: ::std::os::raw::c_uint,
        has_kwrest: ::std::os::raw::c_uint,
        has_block: ::std::os::raw::c_uint,
        ambiguous_param0: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let has_lead: u32 = unsafe { ::std::mem::transmute(has_lead) };
            has_lead as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let has_opt: u32 = unsafe { ::std::mem::transmute(has_opt) };
            has_opt as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let has_rest: u32 = unsafe { ::std::mem::transmute(has_rest) };
            has_rest as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let has_post: u32 = unsafe { ::std::mem::transmute(has_post) };
            has_post as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let has_kw: u32 = unsafe { ::std::mem::transmute(has_kw) };
            has_kw as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let has_kwrest: u32 = unsafe { ::std::mem::transmute(has_kwrest) };
            has_kwrest as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let has_block: u32 = unsafe { ::std::mem::transmute(has_block) };
            has_block as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let ambiguous_param0: u32 = unsafe { ::std::mem::transmute(ambiguous_param0) };
            ambiguous_param0 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword {
    pub num: ::std::os::raw::c_int,
    pub required_num: ::std::os::raw::c_int,
    pub bits_start: ::std::os::raw::c_int,
    pub rest_start: ::std::os::raw::c_int,
    pub table: *const ID,
    pub default_values: *const VALUE,
}
#[test]
fn bindgen_test_layout_rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword() {
    assert_eq!(
        ::std::mem::size_of::<rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword>()))
                .num as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword>()))
                .required_num as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword),
            "::",
            stringify!(required_num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword>()))
                .bits_start as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword),
            "::",
            stringify!(bits_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword>()))
                .rest_start as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword),
            "::",
            stringify!(rest_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword>()))
                .table as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword>()))
                .default_values as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword),
            "::",
            stringify!(default_values)
        )
    );
}
#[test]
fn bindgen_test_layout_rb_iseq_constant_body__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<rb_iseq_constant_body__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(rb_iseq_constant_body__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_iseq_constant_body__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1>())).flags as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1>())).size as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1>())).lead_num as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1),
            "::",
            stringify!(lead_num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1>())).opt_num as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1),
            "::",
            stringify!(opt_num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1>())).rest_start as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1),
            "::",
            stringify!(rest_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1>())).post_start as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1),
            "::",
            stringify!(post_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1>())).post_num as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1),
            "::",
            stringify!(post_num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1>())).block_start as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1),
            "::",
            stringify!(block_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1>())).opt_table as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1),
            "::",
            stringify!(opt_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body__bindgen_ty_1>())).keyword as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body__bindgen_ty_1),
            "::",
            stringify!(keyword)
        )
    );
}
#[test]
fn bindgen_test_layout_rb_iseq_constant_body() {
    assert_eq!(
        ::std::mem::size_of::<rb_iseq_constant_body>(),
        208usize,
        concat!("Size of: ", stringify!(rb_iseq_constant_body))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_iseq_constant_body>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_iseq_constant_body))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_constant_body>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_constant_body>())).iseq_size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(iseq_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body>())).iseq_encoded as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(iseq_encoded)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_constant_body>())).param as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(param)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_constant_body>())).location as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(location)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body>())).insns_info as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(insns_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body>())).local_table as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(local_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body>())).catch_table as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(catch_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body>())).parent_iseq as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(parent_iseq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body>())).local_iseq as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(local_iseq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body>())).is_entries as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(is_entries)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body>())).ci_entries as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(ci_entries)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body>())).cc_entries as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(cc_entries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_constant_body>())).mark_ary as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(mark_ary)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body>())).local_table_size as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(local_table_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_constant_body>())).is_size as *const _ as usize },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(is_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_constant_body>())).ci_size as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(ci_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body>())).ci_kw_size as *const _ as usize
        },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(ci_kw_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_constant_body>())).insns_info_size as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(insns_info_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_constant_body>())).stack_max as *const _ as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_constant_body),
            "::",
            stringify!(stack_max)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rb_iseq_struct {
    pub flags: VALUE,
    pub reserved1: VALUE,
    pub body: *mut rb_iseq_constant_body,
    pub aux: rb_iseq_struct__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union rb_iseq_struct__bindgen_ty_1 {
    pub compile_data: *mut iseq_compile_data,
    pub loader: rb_iseq_struct__bindgen_ty_1__bindgen_ty_1,
    pub trace_events: rb_event_flag_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_iseq_struct__bindgen_ty_1__bindgen_ty_1 {
    pub obj: VALUE,
    pub index: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_rb_iseq_struct__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<rb_iseq_struct__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(rb_iseq_struct__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<rb_iseq_struct__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(rb_iseq_struct__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_struct__bindgen_ty_1__bindgen_ty_1>())).obj as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(obj)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_struct__bindgen_ty_1__bindgen_ty_1>())).index as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(index)
        )
    );
}
#[test]
fn bindgen_test_layout_rb_iseq_struct__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<rb_iseq_struct__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(rb_iseq_struct__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_iseq_struct__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_iseq_struct__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_struct__bindgen_ty_1>())).compile_data as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct__bindgen_ty_1),
            "::",
            stringify!(compile_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_struct__bindgen_ty_1>())).loader as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct__bindgen_ty_1),
            "::",
            stringify!(loader)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_iseq_struct__bindgen_ty_1>())).trace_events as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct__bindgen_ty_1),
            "::",
            stringify!(trace_events)
        )
    );
}
impl ::std::fmt::Debug for rb_iseq_struct__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "rb_iseq_struct__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_rb_iseq_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_iseq_struct>(),
        40usize,
        concat!("Size of: ", stringify!(rb_iseq_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_iseq_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_iseq_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).reserved1 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).body as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(body)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_iseq_struct>())).aux as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_iseq_struct),
            "::",
            stringify!(aux)
        )
    );
}
impl ::std::fmt::Debug for rb_iseq_struct {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "rb_iseq_struct {{ flags: {:?}, reserved1: {:?}, body: {:?}, aux: {:?} }}",
            self.flags, self.reserved1, self.body, self.aux
        )
    }
}
pub type rb_vm_at_exit_func = ::std::option::Option<unsafe extern "C" fn(arg1: *mut rb_vm_struct)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_at_exit_list {
    pub func: rb_vm_at_exit_func,
    pub next: *mut rb_at_exit_list,
}
#[test]
fn bindgen_test_layout_rb_at_exit_list() {
    assert_eq!(
        ::std::mem::size_of::<rb_at_exit_list>(),
        16usize,
        concat!("Size of: ", stringify!(rb_at_exit_list))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_at_exit_list>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_at_exit_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_at_exit_list>())).func as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_at_exit_list),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_at_exit_list>())).next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_at_exit_list),
            "::",
            stringify!(next)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_objspace {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_hook_list_struct {
    pub hooks: *mut rb_event_hook_struct,
    pub events: rb_event_flag_t,
    pub need_clean: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_rb_hook_list_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_hook_list_struct>(),
        16usize,
        concat!("Size of: ", stringify!(rb_hook_list_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_hook_list_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_hook_list_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_hook_list_struct>())).hooks as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_hook_list_struct),
            "::",
            stringify!(hooks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_hook_list_struct>())).events as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_hook_list_struct),
            "::",
            stringify!(events)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_hook_list_struct>())).need_clean as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_hook_list_struct),
            "::",
            stringify!(need_clean)
        )
    );
}
pub type rb_hook_list_t = rb_hook_list_struct;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rb_vm_struct {
    pub self_: VALUE,
    pub gvl: rb_global_vm_lock_t,
    pub thread_destruct_lock: rb_nativethread_lock_t,
    pub main_thread: *mut rb_thread_struct,
    pub running_thread: *mut rb_thread_struct,
    pub waiting_fds: list_head,
    pub living_threads: list_head,
    pub living_thread_num: size_t,
    pub thgroup_default: VALUE,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub trace_running: ::std::os::raw::c_int,
    pub sleeper: ::std::os::raw::c_int,
    pub mark_object_ary: VALUE,
    pub special_exceptions: [VALUE; 5usize],
    pub top_self: VALUE,
    pub load_path: VALUE,
    pub load_path_snapshot: VALUE,
    pub load_path_check_cache: VALUE,
    pub expanded_load_path: VALUE,
    pub loaded_features: VALUE,
    pub loaded_features_snapshot: VALUE,
    pub loaded_features_index: *mut st_table,
    pub loading_table: *mut st_table,
    pub trap_list: rb_vm_struct__bindgen_ty_1,
    pub event_hooks: rb_hook_list_t,
    pub ensure_rollback_table: *mut st_table,
    pub postponed_job_buffer: *mut rb_postponed_job_struct,
    pub postponed_job_index: ::std::os::raw::c_int,
    pub src_encoding_index: ::std::os::raw::c_int,
    pub verbose: VALUE,
    pub debug: VALUE,
    pub orig_progname: VALUE,
    pub progname: VALUE,
    pub coverages: VALUE,
    pub coverage_mode: ::std::os::raw::c_int,
    pub defined_module_hash: VALUE,
    pub objspace: *mut rb_objspace,
    pub at_exit: *mut rb_at_exit_list,
    pub defined_strings: *mut VALUE,
    pub frozen_strings: *mut st_table,
    pub default_params: rb_vm_struct__bindgen_ty_2,
    pub redefined_flag: [::std::os::raw::c_short; 25usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rb_vm_struct__bindgen_ty_1 {
    pub cmd: [VALUE; 65usize],
    pub safe: [::std::os::raw::c_uchar; 65usize],
}
#[test]
fn bindgen_test_layout_rb_vm_struct__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<rb_vm_struct__bindgen_ty_1>(),
        592usize,
        concat!("Size of: ", stringify!(rb_vm_struct__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_vm_struct__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_vm_struct__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct__bindgen_ty_1>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct__bindgen_ty_1),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct__bindgen_ty_1>())).safe as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct__bindgen_ty_1),
            "::",
            stringify!(safe)
        )
    );
}
impl ::std::fmt::Debug for rb_vm_struct__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "rb_vm_struct__bindgen_ty_1 {{ cmd: [{}], safe: [{}] }}",
            self.cmd
                .iter()
                .enumerate()
                .map(|(i, v)| format!("{}{:?}", if i > 0 { ", " } else { "" }, v))
                .collect::<String>(),
            self.safe
                .iter()
                .enumerate()
                .map(|(i, v)| format!("{}{:?}", if i > 0 { ", " } else { "" }, v))
                .collect::<String>()
        )
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_vm_struct__bindgen_ty_2 {
    pub thread_vm_stack_size: size_t,
    pub thread_machine_stack_size: size_t,
    pub fiber_vm_stack_size: size_t,
    pub fiber_machine_stack_size: size_t,
}
#[test]
fn bindgen_test_layout_rb_vm_struct__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<rb_vm_struct__bindgen_ty_2>(),
        32usize,
        concat!("Size of: ", stringify!(rb_vm_struct__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_vm_struct__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_vm_struct__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct__bindgen_ty_2>())).thread_vm_stack_size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct__bindgen_ty_2),
            "::",
            stringify!(thread_vm_stack_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct__bindgen_ty_2>())).thread_machine_stack_size
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct__bindgen_ty_2),
            "::",
            stringify!(thread_machine_stack_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct__bindgen_ty_2>())).fiber_vm_stack_size as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct__bindgen_ty_2),
            "::",
            stringify!(fiber_vm_stack_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct__bindgen_ty_2>())).fiber_machine_stack_size
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct__bindgen_ty_2),
            "::",
            stringify!(fiber_machine_stack_size)
        )
    );
}
#[test]
fn bindgen_test_layout_rb_vm_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_vm_struct>(),
        1288usize,
        concat!("Size of: ", stringify!(rb_vm_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_vm_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_vm_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).self_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(self_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).gvl as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(gvl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct>())).thread_destruct_lock as *const _ as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(thread_destruct_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).main_thread as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(main_thread)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).running_thread as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(running_thread)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).waiting_fds as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(waiting_fds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).living_threads as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(living_threads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).living_thread_num as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(living_thread_num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).thgroup_default as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(thgroup_default)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).trace_running as *const _ as usize },
        348usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(trace_running)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).sleeper as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(sleeper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).mark_object_ary as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(mark_object_ary)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).special_exceptions as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(special_exceptions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).top_self as *const _ as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(top_self)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).load_path as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(load_path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).load_path_snapshot as *const _ as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(load_path_snapshot)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct>())).load_path_check_cache as *const _ as usize
        },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(load_path_check_cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).expanded_load_path as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(expanded_load_path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).loaded_features as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(loaded_features)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct>())).loaded_features_snapshot as *const _ as usize
        },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(loaded_features_snapshot)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct>())).loaded_features_index as *const _ as usize
        },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(loaded_features_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).loading_table as *const _ as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(loading_table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).trap_list as *const _ as usize },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(trap_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).event_hooks as *const _ as usize },
        1072usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(event_hooks)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct>())).ensure_rollback_table as *const _ as usize
        },
        1088usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(ensure_rollback_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct>())).postponed_job_buffer as *const _ as usize
        },
        1096usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(postponed_job_buffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct>())).postponed_job_index as *const _ as usize
        },
        1104usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(postponed_job_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).src_encoding_index as *const _ as usize },
        1108usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(src_encoding_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).verbose as *const _ as usize },
        1112usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(verbose)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).debug as *const _ as usize },
        1120usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(debug)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).orig_progname as *const _ as usize },
        1128usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(orig_progname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).progname as *const _ as usize },
        1136usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(progname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).coverages as *const _ as usize },
        1144usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(coverages)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).coverage_mode as *const _ as usize },
        1152usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(coverage_mode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_vm_struct>())).defined_module_hash as *const _ as usize
        },
        1160usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(defined_module_hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).objspace as *const _ as usize },
        1168usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(objspace)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).at_exit as *const _ as usize },
        1176usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(at_exit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).defined_strings as *const _ as usize },
        1184usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(defined_strings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).frozen_strings as *const _ as usize },
        1192usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(frozen_strings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).default_params as *const _ as usize },
        1200usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(default_params)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_struct>())).redefined_flag as *const _ as usize },
        1232usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_struct),
            "::",
            stringify!(redefined_flag)
        )
    );
}
impl ::std::fmt::Debug for rb_vm_struct {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "rb_vm_struct {{ self: {:?}, gvl: {:?}, thread_destruct_lock: {:?}, main_thread: {:?}, running_thread: {:?}, waiting_fds: {:?}, living_threads: {:?}, living_thread_num: {:?}, thgroup_default: {:?}, running : {:?}, thread_abort_on_exception : {:?}, thread_report_on_exception : {:?}, trace_running: {:?}, sleeper: {:?}, mark_object_ary: {:?}, special_exceptions: {:?}, top_self: {:?}, load_path: {:?}, load_path_snapshot: {:?}, load_path_check_cache: {:?}, expanded_load_path: {:?}, loaded_features: {:?}, loaded_features_snapshot: {:?}, loaded_features_index: {:?}, loading_table: {:?}, trap_list: {:?}, event_hooks: {:?}, ensure_rollback_table: {:?}, postponed_job_buffer: {:?}, postponed_job_index: {:?}, src_encoding_index: {:?}, verbose: {:?}, debug: {:?}, orig_progname: {:?}, progname: {:?}, coverages: {:?}, coverage_mode: {:?}, defined_module_hash: {:?}, objspace: {:?}, at_exit: {:?}, defined_strings: {:?}, frozen_strings: {:?}, default_params: {:?}, redefined_flag: {:?} }}" , self . self_ , self . gvl , self . thread_destruct_lock , self . main_thread , self . running_thread , self . waiting_fds , self . living_threads , self . living_thread_num , self . thgroup_default , self . running () , self . thread_abort_on_exception () , self . thread_report_on_exception () , self . trace_running , self . sleeper , self . mark_object_ary , self . special_exceptions , self . top_self , self . load_path , self . load_path_snapshot , self . load_path_check_cache , self . expanded_load_path , self . loaded_features , self . loaded_features_snapshot , self . loaded_features_index , self . loading_table , self . trap_list , self . event_hooks , self . ensure_rollback_table , self . postponed_job_buffer , self . postponed_job_index , self . src_encoding_index , self . verbose , self . debug , self . orig_progname , self . progname , self . coverages , self . coverage_mode , self . defined_module_hash , self . objspace , self . at_exit , self . defined_strings , self . frozen_strings , self . default_params , self . redefined_flag)
    }
}
impl rb_vm_struct {
    #[inline]
    pub fn running(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_running(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn thread_abort_on_exception(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_thread_abort_on_exception(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn thread_report_on_exception(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_thread_report_on_exception(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        running: ::std::os::raw::c_uint,
        thread_abort_on_exception: ::std::os::raw::c_uint,
        thread_report_on_exception: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let running: u32 = unsafe { ::std::mem::transmute(running) };
            running as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let thread_abort_on_exception: u32 =
                unsafe { ::std::mem::transmute(thread_abort_on_exception) };
            thread_abort_on_exception as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let thread_report_on_exception: u32 =
                unsafe { ::std::mem::transmute(thread_report_on_exception) };
            thread_report_on_exception as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type rb_vm_t = rb_vm_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_control_frame_struct {
    pub pc: *const VALUE,
    pub sp: *mut VALUE,
    pub iseq: *const rb_iseq_t,
    pub self_: VALUE,
    pub ep: *const VALUE,
    pub block_code: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_rb_control_frame_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_control_frame_struct>(),
        48usize,
        concat!("Size of: ", stringify!(rb_control_frame_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_control_frame_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_control_frame_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_struct>())).pc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_struct),
            "::",
            stringify!(pc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_struct>())).sp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_struct),
            "::",
            stringify!(sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_struct>())).iseq as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_struct),
            "::",
            stringify!(iseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_struct>())).self_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_struct),
            "::",
            stringify!(self_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_control_frame_struct>())).ep as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_struct),
            "::",
            stringify!(ep)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_control_frame_struct>())).block_code as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_control_frame_struct),
            "::",
            stringify!(block_code)
        )
    );
}
pub type rb_control_frame_t = rb_control_frame_struct;
pub const rb_thread_status_THREAD_RUNNABLE: rb_thread_status = 0;
pub const rb_thread_status_THREAD_STOPPED: rb_thread_status = 1;
pub const rb_thread_status_THREAD_STOPPED_FOREVER: rb_thread_status = 2;
pub const rb_thread_status_THREAD_KILLED: rb_thread_status = 3;
pub type rb_thread_status = ::std::os::raw::c_uint;
pub type rb_jmpbuf_t = sigjmp_buf;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_vm_tag {
    pub tag: VALUE,
    pub retval: VALUE,
    pub buf: rb_jmpbuf_t,
    pub prev: *mut rb_vm_tag,
    pub state: ruby_tag_type,
}
#[test]
fn bindgen_test_layout_rb_vm_tag() {
    assert_eq!(
        ::std::mem::size_of::<rb_vm_tag>(),
        232usize,
        concat!("Size of: ", stringify!(rb_vm_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_vm_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_vm_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_tag>())).tag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_tag),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_tag>())).retval as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_tag),
            "::",
            stringify!(retval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_tag>())).buf as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_tag),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_tag>())).prev as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_tag),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_tag>())).state as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_tag),
            "::",
            stringify!(state)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_vm_protect_tag {
    pub prev: *mut rb_vm_protect_tag,
}
#[test]
fn bindgen_test_layout_rb_vm_protect_tag() {
    assert_eq!(
        ::std::mem::size_of::<rb_vm_protect_tag>(),
        8usize,
        concat!("Size of: ", stringify!(rb_vm_protect_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_vm_protect_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_vm_protect_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_vm_protect_tag>())).prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_vm_protect_tag),
            "::",
            stringify!(prev)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_unblock_callback {
    pub func: rb_unblock_function_t,
    pub arg: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_rb_unblock_callback() {
    assert_eq!(
        ::std::mem::size_of::<rb_unblock_callback>(),
        16usize,
        concat!("Size of: ", stringify!(rb_unblock_callback))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_unblock_callback>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_unblock_callback))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_unblock_callback>())).func as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_unblock_callback),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_unblock_callback>())).arg as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_unblock_callback),
            "::",
            stringify!(arg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_mutex_struct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_thread_list_struct {
    pub next: *mut rb_thread_list_struct,
    pub th: *mut rb_thread_struct,
}
#[test]
fn bindgen_test_layout_rb_thread_list_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_thread_list_struct>(),
        16usize,
        concat!("Size of: ", stringify!(rb_thread_list_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_thread_list_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_thread_list_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_list_struct>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_list_struct),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_list_struct>())).th as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_list_struct),
            "::",
            stringify!(th)
        )
    );
}
pub type rb_thread_list_t = rb_thread_list_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_ensure_entry {
    pub marker: VALUE,
    pub e_proc: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
    pub data2: VALUE,
}
#[test]
fn bindgen_test_layout_rb_ensure_entry() {
    assert_eq!(
        ::std::mem::size_of::<rb_ensure_entry>(),
        24usize,
        concat!("Size of: ", stringify!(rb_ensure_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_ensure_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_ensure_entry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_ensure_entry>())).marker as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_ensure_entry),
            "::",
            stringify!(marker)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_ensure_entry>())).e_proc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_ensure_entry),
            "::",
            stringify!(e_proc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_ensure_entry>())).data2 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_ensure_entry),
            "::",
            stringify!(data2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_ensure_list {
    pub next: *mut rb_ensure_list,
    pub entry: rb_ensure_entry,
}
#[test]
fn bindgen_test_layout_rb_ensure_list() {
    assert_eq!(
        ::std::mem::size_of::<rb_ensure_list>(),
        32usize,
        concat!("Size of: ", stringify!(rb_ensure_list))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_ensure_list>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_ensure_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_ensure_list>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_ensure_list),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_ensure_list>())).entry as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_ensure_list),
            "::",
            stringify!(entry)
        )
    );
}
pub type rb_ensure_list_t = rb_ensure_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_fiber_struct {
    _unused: [u8; 0],
}
pub type rb_fiber_t = rb_fiber_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_execution_context_struct {
    pub vm_stack: *mut VALUE,
    pub vm_stack_size: size_t,
    pub cfp: *mut rb_control_frame_t,
    pub tag: *mut rb_vm_tag,
    pub protect_tag: *mut rb_vm_protect_tag,
    pub safe_level: ::std::os::raw::c_int,
    pub raised_flag: ::std::os::raw::c_int,
    pub interrupt_flag: rb_atomic_t,
    pub interrupt_mask: ::std::os::raw::c_ulong,
    pub fiber_ptr: *mut rb_fiber_t,
    pub thread_ptr: *mut rb_thread_struct,
    pub local_storage: *mut st_table,
    pub local_storage_recursive_hash: VALUE,
    pub local_storage_recursive_hash_for_trace: VALUE,
    pub root_lep: *const VALUE,
    pub root_svar: VALUE,
    pub ensure_list: *mut rb_ensure_list_t,
    pub trace_arg: *mut rb_trace_arg_struct,
    pub errinfo: VALUE,
    pub passed_block_handler: VALUE,
    pub passed_bmethod_me: *const rb_callable_method_entry_t,
    pub method_missing_reason: method_missing_reason,
    pub machine: rb_execution_context_struct__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_execution_context_struct__bindgen_ty_1 {
    pub stack_start: *mut VALUE,
    pub stack_end: *mut VALUE,
    pub stack_maxsize: size_t,
    pub regs: jmp_buf,
}
#[test]
fn bindgen_test_layout_rb_execution_context_struct__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<rb_execution_context_struct__bindgen_ty_1>(),
        224usize,
        concat!(
            "Size of: ",
            stringify!(rb_execution_context_struct__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<rb_execution_context_struct__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(rb_execution_context_struct__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct__bindgen_ty_1>())).stack_start
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct__bindgen_ty_1),
            "::",
            stringify!(stack_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct__bindgen_ty_1>())).stack_end
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct__bindgen_ty_1),
            "::",
            stringify!(stack_end)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct__bindgen_ty_1>())).stack_maxsize
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct__bindgen_ty_1),
            "::",
            stringify!(stack_maxsize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct__bindgen_ty_1>())).regs as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct__bindgen_ty_1),
            "::",
            stringify!(regs)
        )
    );
}
#[test]
fn bindgen_test_layout_rb_execution_context_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_execution_context_struct>(),
        392usize,
        concat!("Size of: ", stringify!(rb_execution_context_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_execution_context_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_execution_context_struct))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).vm_stack as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(vm_stack)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).vm_stack_size as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(vm_stack_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_execution_context_struct>())).cfp as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(cfp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_execution_context_struct>())).tag as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).protect_tag as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(protect_tag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).safe_level as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(safe_level)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).raised_flag as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(raised_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).interrupt_flag as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(interrupt_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).interrupt_mask as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(interrupt_mask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).fiber_ptr as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(fiber_ptr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).thread_ptr as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(thread_ptr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).local_storage as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(local_storage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).local_storage_recursive_hash
                as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(local_storage_recursive_hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>()))
                .local_storage_recursive_hash_for_trace as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(local_storage_recursive_hash_for_trace)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).root_lep as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(root_lep)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).root_svar as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(root_svar)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).ensure_list as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(ensure_list)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).trace_arg as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(trace_arg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).errinfo as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(errinfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).passed_block_handler as *const _
                as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(passed_block_handler)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).passed_bmethod_me as *const _
                as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(passed_bmethod_me)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).method_missing_reason
                as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(method_missing_reason)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_execution_context_struct>())).machine as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_execution_context_struct),
            "::",
            stringify!(machine)
        )
    );
}
pub type rb_execution_context_t = rb_execution_context_struct;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rb_thread_struct {
    pub vmlt_node: list_node,
    pub self_: VALUE,
    pub vm: *mut rb_vm_t,
    pub ec: *mut rb_execution_context_t,
    pub last_status: VALUE,
    pub calling: *mut rb_calling_info,
    pub top_self: VALUE,
    pub top_wrapper: VALUE,
    pub thread_id: rb_nativethread_id_t,
    pub status: rb_thread_status,
    pub to_kill: ::std::os::raw::c_int,
    pub priority: ::std::os::raw::c_int,
    pub native_thread_data: native_thread_data_t,
    pub blocking_region_buffer: *mut ::std::os::raw::c_void,
    pub thgroup: VALUE,
    pub value: VALUE,
    pub pending_interrupt_queue: VALUE,
    pub pending_interrupt_mask_stack: VALUE,
    pub pending_interrupt_queue_checked: ::std::os::raw::c_int,
    pub interrupt_lock: rb_nativethread_lock_t,
    pub unblock: rb_unblock_callback,
    pub locking_mutex: VALUE,
    pub keeping_mutexes: *mut rb_mutex_struct,
    pub join_list: *mut rb_thread_list_t,
    pub first_proc: VALUE,
    pub first_args: VALUE,
    pub first_func: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
    pub stat_insn_usage: VALUE,
    pub root_fiber: *mut rb_fiber_t,
    pub root_jmpbuf: rb_jmpbuf_t,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub altstack: *mut ::std::os::raw::c_void,
    pub running_time_us: u32,
    pub name: VALUE,
}
#[test]
fn bindgen_test_layout_rb_thread_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_thread_struct>(),
        568usize,
        concat!("Size of: ", stringify!(rb_thread_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_thread_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_thread_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).vmlt_node as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(vmlt_node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).self_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(self_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).vm as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(vm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).ec as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(ec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).last_status as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(last_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).calling as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(calling)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).top_self as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(top_self)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).top_wrapper as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(top_wrapper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).thread_id as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(thread_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).status as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).to_kill as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(to_kill)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).priority as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(priority)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).native_thread_data as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(native_thread_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).blocking_region_buffer as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(blocking_region_buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).thgroup as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(thgroup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).value as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).pending_interrupt_queue as *const _
                as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(pending_interrupt_queue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).pending_interrupt_mask_stack as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(pending_interrupt_mask_stack)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).pending_interrupt_queue_checked as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(pending_interrupt_queue_checked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).interrupt_lock as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(interrupt_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).unblock as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(unblock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).locking_mutex as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(locking_mutex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).keeping_mutexes as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(keeping_mutexes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).join_list as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(join_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).first_proc as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(first_proc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).first_args as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(first_args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).first_func as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(first_func)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).stat_insn_usage as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(stat_insn_usage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).root_fiber as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(root_fiber)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).root_jmpbuf as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(root_jmpbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).altstack as *const _ as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(altstack)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_thread_struct>())).running_time_us as *const _ as usize
        },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(running_time_us)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_thread_struct>())).name as *const _ as usize },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_thread_struct),
            "::",
            stringify!(name)
        )
    );
}
impl ::std::fmt::Debug for rb_thread_struct {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "rb_thread_struct {{ vmlt_node: {:?}, self: {:?}, vm: {:?}, ec: {:?}, last_status: {:?}, calling: {:?}, top_self: {:?}, top_wrapper: {:?}, thread_id: {:?}, status: {:?}, to_kill: {:?}, priority: {:?}, native_thread_data: {:?}, blocking_region_buffer: {:?}, thgroup: {:?}, value: {:?}, pending_interrupt_queue: {:?}, pending_interrupt_mask_stack: {:?}, pending_interrupt_queue_checked: {:?}, interrupt_lock: {:?}, unblock: {:?}, locking_mutex: {:?}, keeping_mutexes: {:?}, join_list: {:?}, first_proc: {:?}, first_args: {:?}, first_func: {:?}, stat_insn_usage: {:?}, root_fiber: {:?}, root_jmpbuf: {:?}, abort_on_exception : {:?}, report_on_exception : {:?}, altstack: {:?}, running_time_us: {:?}, name: {:?} }}" , self . vmlt_node , self . self_ , self . vm , self . ec , self . last_status , self . calling , self . top_self , self . top_wrapper , self . thread_id , self . status , self . to_kill , self . priority , self . native_thread_data , self . blocking_region_buffer , self . thgroup , self . value , self . pending_interrupt_queue , self . pending_interrupt_mask_stack , self . pending_interrupt_queue_checked , self . interrupt_lock , self . unblock , self . locking_mutex , self . keeping_mutexes , self . join_list , self . first_proc , self . first_args , self . first_func , self . stat_insn_usage , self . root_fiber , self . root_jmpbuf , self . abort_on_exception () , self . report_on_exception () , self . altstack , self . running_time_us , self . name)
    }
}
impl rb_thread_struct {
    #[inline]
    pub fn abort_on_exception(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_abort_on_exception(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn report_on_exception(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_report_on_exception(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        abort_on_exception: ::std::os::raw::c_uint,
        report_on_exception: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let abort_on_exception: u32 = unsafe { ::std::mem::transmute(abort_on_exception) };
            abort_on_exception as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let report_on_exception: u32 = unsafe { ::std::mem::transmute(report_on_exception) };
            report_on_exception as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type rb_thread_t = rb_thread_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_trace_arg_struct {
    pub event: rb_event_flag_t,
    pub ec: *mut rb_execution_context_t,
    pub cfp: *const rb_control_frame_t,
    pub self_: VALUE,
    pub id: ID,
    pub called_id: ID,
    pub klass: VALUE,
    pub data: VALUE,
    pub klass_solved: ::std::os::raw::c_int,
    pub lineno: ::std::os::raw::c_int,
    pub path: VALUE,
}
#[test]
fn bindgen_test_layout_rb_trace_arg_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_trace_arg_struct>(),
        80usize,
        concat!("Size of: ", stringify!(rb_trace_arg_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_trace_arg_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(rb_trace_arg_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_trace_arg_struct>())).event as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_trace_arg_struct),
            "::",
            stringify!(event)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_trace_arg_struct>())).ec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_trace_arg_struct),
            "::",
            stringify!(ec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_trace_arg_struct>())).cfp as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_trace_arg_struct),
            "::",
            stringify!(cfp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_trace_arg_struct>())).self_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_trace_arg_struct),
            "::",
            stringify!(self_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_trace_arg_struct>())).id as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_trace_arg_struct),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_trace_arg_struct>())).called_id as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_trace_arg_struct),
            "::",
            stringify!(called_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_trace_arg_struct>())).klass as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_trace_arg_struct),
            "::",
            stringify!(klass)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_trace_arg_struct>())).data as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_trace_arg_struct),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_trace_arg_struct>())).klass_solved as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_trace_arg_struct),
            "::",
            stringify!(klass_solved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_trace_arg_struct>())).lineno as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_trace_arg_struct),
            "::",
            stringify!(lineno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rb_trace_arg_struct>())).path as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_trace_arg_struct),
            "::",
            stringify!(path)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_compile_data {
    pub err_info: VALUE,
    pub mark_ary: VALUE,
    pub catch_table_ary: VALUE,
    pub start_label: *mut iseq_label_data,
    pub end_label: *mut iseq_label_data,
    pub redo_label: *mut iseq_label_data,
    pub current_block: *const rb_iseq_t,
    pub ensure_node: VALUE,
    pub for_iseq: VALUE,
    pub ensure_node_stack: *mut iseq_compile_data_ensure_node_stack,
    pub loopval_popped: ::std::os::raw::c_int,
    pub cached_const: ::std::os::raw::c_int,
    pub storage_head: *mut iseq_compile_data_storage,
    pub storage_current: *mut iseq_compile_data_storage,
    pub last_line: ::std::os::raw::c_int,
    pub label_no: ::std::os::raw::c_int,
    pub node_level: ::std::os::raw::c_int,
    pub ci_index: ::std::os::raw::c_uint,
    pub ci_kw_index: ::std::os::raw::c_uint,
    pub option: *const rb_compile_option_t,
    pub ivar_cache_table: *mut rb_id_table,
}
#[test]
fn bindgen_test_layout_iseq_compile_data() {
    assert_eq!(
        ::std::mem::size_of::<iseq_compile_data>(),
        144usize,
        concat!("Size of: ", stringify!(iseq_compile_data))
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_compile_data>(),
        8usize,
        concat!("Alignment of ", stringify!(iseq_compile_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).err_info as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(err_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).mark_ary as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(mark_ary)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_compile_data>())).catch_table_ary as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(catch_table_ary)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).start_label as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(start_label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).end_label as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(end_label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).redo_label as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(redo_label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).current_block as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(current_block)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).ensure_node as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(ensure_node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).for_iseq as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(for_iseq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_compile_data>())).ensure_node_stack as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(ensure_node_stack)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_compile_data>())).loopval_popped as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(loopval_popped)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).cached_const as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(cached_const)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).storage_head as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(storage_head)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_compile_data>())).storage_current as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(storage_current)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).last_line as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(last_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).label_no as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(label_no)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).node_level as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(node_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).ci_index as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(ci_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).ci_kw_index as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(ci_kw_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data>())).option as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(option)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iseq_compile_data>())).ivar_cache_table as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data),
            "::",
            stringify!(ivar_cache_table)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_compile_option_struct {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub debug_level: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_rb_compile_option_struct() {
    assert_eq!(
        ::std::mem::size_of::<rb_compile_option_struct>(),
        8usize,
        concat!("Size of: ", stringify!(rb_compile_option_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<rb_compile_option_struct>(),
        4usize,
        concat!("Alignment of ", stringify!(rb_compile_option_struct))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rb_compile_option_struct>())).debug_level as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rb_compile_option_struct),
            "::",
            stringify!(debug_level)
        )
    );
}
impl rb_compile_option_struct {
    #[inline]
    pub fn inline_const_cache(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_inline_const_cache(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn peephole_optimization(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_peephole_optimization(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tailcall_optimization(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tailcall_optimization(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn specialized_instruction(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_specialized_instruction(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn operands_unification(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_operands_unification(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn instructions_unification(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_instructions_unification(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn stack_caching(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_stack_caching(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frozen_string_literal(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frozen_string_literal(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn debug_frozen_string_literal(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_debug_frozen_string_literal(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn coverage_enabled(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_coverage_enabled(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        inline_const_cache: ::std::os::raw::c_uint,
        peephole_optimization: ::std::os::raw::c_uint,
        tailcall_optimization: ::std::os::raw::c_uint,
        specialized_instruction: ::std::os::raw::c_uint,
        operands_unification: ::std::os::raw::c_uint,
        instructions_unification: ::std::os::raw::c_uint,
        stack_caching: ::std::os::raw::c_uint,
        frozen_string_literal: ::std::os::raw::c_uint,
        debug_frozen_string_literal: ::std::os::raw::c_uint,
        coverage_enabled: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let inline_const_cache: u32 = unsafe { ::std::mem::transmute(inline_const_cache) };
            inline_const_cache as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let peephole_optimization: u32 =
                unsafe { ::std::mem::transmute(peephole_optimization) };
            peephole_optimization as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let tailcall_optimization: u32 =
                unsafe { ::std::mem::transmute(tailcall_optimization) };
            tailcall_optimization as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let specialized_instruction: u32 =
                unsafe { ::std::mem::transmute(specialized_instruction) };
            specialized_instruction as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let operands_unification: u32 = unsafe { ::std::mem::transmute(operands_unification) };
            operands_unification as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let instructions_unification: u32 =
                unsafe { ::std::mem::transmute(instructions_unification) };
            instructions_unification as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let stack_caching: u32 = unsafe { ::std::mem::transmute(stack_caching) };
            stack_caching as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let frozen_string_literal: u32 =
                unsafe { ::std::mem::transmute(frozen_string_literal) };
            frozen_string_literal as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let debug_frozen_string_literal: u32 =
                unsafe { ::std::mem::transmute(debug_frozen_string_literal) };
            debug_frozen_string_literal as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let coverage_enabled: u32 = unsafe { ::std::mem::transmute(coverage_enabled) };
            coverage_enabled as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_insn_info_entry {
    pub position: ::std::os::raw::c_uint,
    pub line_no: ::std::os::raw::c_int,
    pub events: rb_event_flag_t,
}
#[test]
fn bindgen_test_layout_iseq_insn_info_entry() {
    assert_eq!(
        ::std::mem::size_of::<iseq_insn_info_entry>(),
        12usize,
        concat!("Size of: ", stringify!(iseq_insn_info_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_insn_info_entry>(),
        4usize,
        concat!("Alignment of ", stringify!(iseq_insn_info_entry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_insn_info_entry>())).position as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_insn_info_entry),
            "::",
            stringify!(position)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_insn_info_entry>())).line_no as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_insn_info_entry),
            "::",
            stringify!(line_no)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_insn_info_entry>())).events as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_insn_info_entry),
            "::",
            stringify!(events)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_catch_table_entry {
    pub type_: iseq_catch_table_entry_catch_type,
    pub iseq: *const rb_iseq_t,
    pub start: ::std::os::raw::c_uint,
    pub end: ::std::os::raw::c_uint,
    pub cont: ::std::os::raw::c_uint,
    pub sp: ::std::os::raw::c_uint,
}
pub const iseq_catch_table_entry_catch_type_CATCH_TYPE_RESCUE: iseq_catch_table_entry_catch_type =
    3;
pub const iseq_catch_table_entry_catch_type_CATCH_TYPE_ENSURE: iseq_catch_table_entry_catch_type =
    5;
pub const iseq_catch_table_entry_catch_type_CATCH_TYPE_RETRY: iseq_catch_table_entry_catch_type = 7;
pub const iseq_catch_table_entry_catch_type_CATCH_TYPE_BREAK: iseq_catch_table_entry_catch_type = 9;
pub const iseq_catch_table_entry_catch_type_CATCH_TYPE_REDO: iseq_catch_table_entry_catch_type = 11;
pub const iseq_catch_table_entry_catch_type_CATCH_TYPE_NEXT: iseq_catch_table_entry_catch_type = 13;
pub type iseq_catch_table_entry_catch_type = ::std::os::raw::c_uint;
#[test]
fn bindgen_test_layout_iseq_catch_table_entry() {
    assert_eq!(
        ::std::mem::size_of::<iseq_catch_table_entry>(),
        32usize,
        concat!("Size of: ", stringify!(iseq_catch_table_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_catch_table_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(iseq_catch_table_entry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table_entry>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table_entry),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table_entry>())).iseq as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table_entry),
            "::",
            stringify!(iseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table_entry>())).start as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table_entry),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table_entry>())).end as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table_entry),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table_entry>())).cont as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table_entry),
            "::",
            stringify!(cont)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table_entry>())).sp as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table_entry),
            "::",
            stringify!(sp)
        )
    );
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_catch_table {
    pub size: ::std::os::raw::c_uint,
    pub entries: [iseq_catch_table_entry; 1usize],
}
#[test]
fn bindgen_test_layout_iseq_catch_table() {
    assert_eq!(
        ::std::mem::size_of::<iseq_catch_table>(),
        36usize,
        concat!("Size of: ", stringify!(iseq_catch_table))
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_catch_table>(),
        1usize,
        concat!("Alignment of ", stringify!(iseq_catch_table))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_catch_table>())).entries as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_catch_table),
            "::",
            stringify!(entries)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_compile_data_storage {
    pub next: *mut iseq_compile_data_storage,
    pub pos: ::std::os::raw::c_uint,
    pub size: ::std::os::raw::c_uint,
    pub buff: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout_iseq_compile_data_storage() {
    assert_eq!(
        ::std::mem::size_of::<iseq_compile_data_storage>(),
        24usize,
        concat!("Size of: ", stringify!(iseq_compile_data_storage))
    );
    assert_eq!(
        ::std::mem::align_of::<iseq_compile_data_storage>(),
        8usize,
        concat!("Alignment of ", stringify!(iseq_compile_data_storage))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data_storage>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data_storage),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data_storage>())).pos as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data_storage),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data_storage>())).size as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data_storage),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iseq_compile_data_storage>())).buff as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(iseq_compile_data_storage),
            "::",
            stringify!(buff)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_id_table {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_event_hook_struct {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_postponed_job_struct {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_label_data {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_compile_data_ensure_node_stack {
    pub _address: u8,
}
