pub mod byte;
pub mod json;

pub trait DateStringCheck {
    fn check(&mut self);
}

impl DateStringCheck for String {
    #[inline]
    fn check(&mut self) {
        //56 ns/iter
        //*self=self.replacen(" ","T",1);
        //10 ns/iter
        if self.len() >= 10 {
            let mut c = self.remove(10);
            if c == ' ' {
                c = 'T';
            }
            self.insert(10, c);
        }
    }
}

impl DateStringCheck for Vec<String> {
    #[inline]
    fn check(&mut self) {
        //2020-07-28 08:34:40
        for x in self {
            x.check();
        }
    }
}