use serde_json::Value;
use serde::Serialize;

/// bytes
#[derive(Eq, PartialEq, Clone, Debug, serde::Serialize, serde::Deserialize)]
pub struct RbJson {
    pub rb_json: serde_json::Value,
}


impl RbJson {
    pub fn from<T>(v: T) -> Result<RbJson, serde_json::error::Error> where T: Serialize {
        let j = serde_json::to_value(v)?;
        return Ok(RbJson {
            rb_json: j
        });
    }
}

impl From<serde_json::Value> for RbJson {
    fn from(arg: Value) -> Self {
        Self {
            rb_json: arg
        }
    }
}