use serde::{Serialize, Deserialize, Serializer, Deserializer};
use std::convert::TryFrom;
use serde::de::{Error, Visitor};
use std::fmt;
use std::ops::{Deref, DerefMut};
use serde_json::Value;

/// bytes
#[derive(Eq,PartialEq,Clone,Debug, serde::Serialize, serde::Deserialize)]
pub struct RbBytes {
    pub rb_bytes: Vec<u8>,
}

impl RbBytes {
    pub fn new() -> Self {
        Self {
            rb_bytes: Vec::new()
        }
    }
}

impl From<serde_json::Value> for RbBytes {
    #[inline]
    fn from(arg: Value) -> Self {
        return match arg {
            Value::Array(arr) => {
                let mut bytes = Vec::with_capacity(arr.len());
                for x in arr {
                    bytes.push(x.as_u64().unwrap_or_default() as u8)
                }
                Self {
                    rb_bytes: bytes
                }
            }
            _ => {
                Self {
                    rb_bytes: vec![]
                }
            }
        }
    }
}

impl Deref for RbBytes {
    type Target = Vec<u8>;

    fn deref(&self) -> &Self::Target {
        &self.rb_bytes
    }
}

impl DerefMut for RbBytes{
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.rb_bytes
    }
}

#[cfg(test)]
mod test {
    #[test]
    pub fn test_encode() {
        let b = "ssss".as_bytes().to_owned();
        let v = serde_json::to_string(&b).unwrap_or_default();
        println!("{}", v);
    }
}