/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

use crate::base::ARGB;

use super::System;

const ERR_OUTSIDE_SCREEN: &str = "outside screen";

impl System {
	/// Draw a single pixel with alpha channel
	#[inline]
	pub fn draw_pixel(&mut self, x: i32, y: i32, color: ARGB) -> Result<(), String> {
		if (x >= 0) && (y >= 0) && (x < self.width) && (y < self.height) {
			let buf = &mut self.buffer;
		    let offs = ((y * self.width + x) << 2) as usize;
			let a = color.a as u32;
			let na = 0x100 - a;
		    buf[offs + 0] = (((color.b as u32) * a + (buf[offs + 0] as u32) * na) >> 8) as u8;
		    buf[offs + 1] = (((color.g as u32) * a + (buf[offs + 1] as u32) * na) >> 8) as u8;
		    buf[offs + 2] = (((color.r as u32) * a + (buf[offs + 2] as u32) * na) >> 8) as u8;
			Ok(())
		} else {
			Err(String::from(ERR_OUTSIDE_SCREEN))
		}
	}
	// "Now we can make DOOM". But DOOM has been made already, long ago...

}
