/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

use super::System;

use super::input::Key;
use super::input::Button;

impl System {
    pub fn mouse_dx(&self) -> i32 {
        self.input.mouse_dx()
    }

    pub fn mouse_dy(&self) -> i32 {
        self.input.mouse_dy()
    }

    pub fn mouse_dw(&self) -> i32 {
        self.input.mouse_dw()
    }

    pub fn test_key(&self, key: Key) -> bool {
        self.input.test_key(key)
    }

    pub fn test_keys(&self, keys: &[Key]) -> bool {
        self.input.test_keys(keys)
    }

    pub fn test_modkeys(&self) -> bool {
        self.input.test_modkeys()
    }

    pub fn poll_key(&mut self, key: Key) -> bool {
        self.input.poll_key(key)
    }

    pub fn poll_keys(&mut self, keys: &[Key]) -> bool {
        self.input.poll_keys(keys)
    }

    pub fn get_poll_char(&mut self) -> Option<char> {
        self.input.get_poll_char()
    }

    pub fn test_btn(&self, btn: Button) -> bool {
        self.input.test_btn(btn)
    }

    pub fn poll_btn(&mut self, btn: Button) -> bool {
        self.input.poll_btn(btn)
    }

}
