/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

use super::System;

use super::audio::{
    Music,
    Sound
};

impl System {
    pub fn load_music<'a>(&self, filepath: impl ToString) -> Option<Music<'a>> {
        let filepath = filepath.to_string();
        self.audio.load_music(filepath)
    }

    pub fn play_music(&self, music: Option<&Music>) -> Result<(), String> {
        self.audio.play_music(music)
    }

    pub fn load_sound(&self, filepath: impl ToString) -> Option<Sound> {
        let filepath = filepath.to_string();
        self.audio.load_sound(filepath)
    }

    pub fn play_sound(&self, sound: Option<&Sound>, repeats: i32) -> Result<(), String> {
        self.audio.play_sound(sound, repeats)
    }

    pub fn play_sound_once(&self, sound: Option<&Sound>) -> Result<(), String> {
        self.play_sound(sound, 0)
    }

    pub fn play_sound_ever(&self, sound: Option<&Sound>) -> Result<(), String> {
        self.play_sound(sound, -1)
    }

    pub fn load_speech(&self, filepath: impl ToString) -> Option<Sound> {
        self.audio.load_speech(filepath)
    }

    pub fn play_speech(&self, speech: Option<&Sound>) -> Result<(), String> {
        self.audio.play_speech(speech)
    }

    pub fn pause_audio(&self) {
        self.audio.pause();
    }

    pub fn resume_audio(&self) {
        self.audio.resume();
    }

    pub fn halt_audio(&self) {
        self.audio.halt();
    }

}
