/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

extern crate sdl2;

use sdl2::keyboard::Scancode;

#[derive(Clone, Copy, Hash, Eq, PartialEq, Debug)] // for HashSet
pub enum Key { // From SDL, Scancode enum...
    Escape,
    Enter, KpEnter,
    Space,
    Right, Up, Left, Down,
    Num0, Num1, Num2, Num3, Num4, Num5, Num6, Num7, Num8, Num9,
    Kp0, Kp1, Kp2, Kp3, Kp4, Kp5, Kp6, Kp7, Kp8, Kp9,
    KpDivide, KpMultiply, KpMinus, KpPlus, KpPeriod,
    A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y, Z,
    F1, F2, F3, F4, F5, F6, F7, F8, F9, F10, F11, F12,
    Home, End, PageUp, PageDown,
    Insert, Delete, Backspace, Tab,
    LShift, RShift, LAlt, RAlt, LCtrl, RCtrl,
    Minus, Equals, LeftBracket, RightBracket, Backslash, Semicolon, Apostrophe, Grave,
    Comma, Period, Slash
}

// "There and back again"... TODO: avoid duplications

pub fn to_sdl(k: Option<Key>) -> Option<Scancode> {
    use Key::*;
    match k {
        Some(k) => Some(match k {
            Escape => Scancode::Escape,
            Enter => Scancode::Return,
            KpEnter => Scancode::KpEnter,
            Space => Scancode::Space,

            Right => Scancode::Right,
            Up => Scancode::Up,
            Left => Scancode::Left,
            Down => Scancode::Down,

            Num0 => Scancode::Num0,
            Num1 => Scancode::Num1,
            Num2 => Scancode::Num2,
            Num3 => Scancode::Num3,
            Num4 => Scancode::Num4,
            Num5 => Scancode::Num5,
            Num6 => Scancode::Num6,
            Num7 => Scancode::Num7,
            Num8 => Scancode::Num8,
            Num9 => Scancode::Num9,

            Kp0 => Scancode::Kp0,
            Kp1 => Scancode::Kp1,
            Kp2 => Scancode::Kp2,
            Kp3 => Scancode::Kp3,
            Kp4 => Scancode::Kp4,
            Kp5 => Scancode::Kp5,
            Kp6 => Scancode::Kp6,
            Kp7 => Scancode::Kp7,
            Kp8 => Scancode::Kp8,
            Kp9 => Scancode::Kp9,

            KpDivide => Scancode::KpDivide,
            KpMultiply => Scancode::KpDivide,
            KpMinus => Scancode::KpMinus,
            KpPlus => Scancode::KpPlus,
            KpPeriod => Scancode::KpPeriod,

            A => Scancode::A,
            B => Scancode::B,
            C => Scancode::C,
            D => Scancode::D,
            E => Scancode::E,
            F => Scancode::F,
            G => Scancode::G,
            H => Scancode::H,
            I => Scancode::I,
            J => Scancode::J,
            K => Scancode::K,
            L => Scancode::L,
            M => Scancode::M,
            N => Scancode::N,
            O => Scancode::O,
            P => Scancode::P,
            Q => Scancode::Q,
            R => Scancode::R,
            S => Scancode::S,
            T => Scancode::T,
            U => Scancode::U,
            V => Scancode::V,
            W => Scancode::W,
            X => Scancode::X,
            Y => Scancode::Y,
            Z => Scancode::Z,

            F1 => Scancode::F1,
            F2 => Scancode::F2,
            F3 => Scancode::F3,
            F4 => Scancode::F4,
            F5 => Scancode::F5,
            F6 => Scancode::F6,
            F7 => Scancode::F7,
            F8 => Scancode::F8,
            F9 => Scancode::F9,
            F10 => Scancode::F10,
            F11 => Scancode::F11,
            F12 => Scancode::F12,

            Home => Scancode::Home,
            End => Scancode::End,
            PageUp => Scancode::PageUp,
            PageDown => Scancode::PageDown,

            Insert => Scancode::Insert,
            Delete => Scancode::Delete,
            Backspace => Scancode::Backspace,
            Tab => Scancode::Tab,

            LShift => Scancode::LShift,
            RShift => Scancode::RShift,
            LAlt => Scancode::LAlt,
            RAlt => Scancode::RAlt,
            LCtrl => Scancode::LCtrl,
            RCtrl => Scancode::RCtrl,

            Minus => Scancode::Minus,
            Equals => Scancode::Equals,
            LeftBracket => Scancode::LeftBracket,
            RightBracket => Scancode::RightBracket,
            Backslash => Scancode::Backslash,
            Semicolon => Scancode::Semicolon,
            Apostrophe => Scancode::Apostrophe,
            Grave => Scancode::Grave,
            Comma => Scancode::Comma,
            Period => Scancode::Period,
            Slash => Scancode::Slash

        }),
        None => None
    }
}

pub fn from_sdl(s: Option<Scancode>) -> Option<Key> {
    use Key::*;
    match s {
        Some(s) => Some(match s {
            Scancode::Escape => Escape,
            Scancode::Return => Enter,
            Scancode::KpEnter => Enter,
            Scancode::Space => Space,

            Scancode::Right => Right,
            Scancode::Up => Up,
            Scancode::Left => Left,
            Scancode::Down => Down,

            Scancode::Num0 => Num0,
            Scancode::Num1 => Num1,
            Scancode::Num2 => Num2,
            Scancode::Num3 => Num3,
            Scancode::Num4 => Num4,
            Scancode::Num5 => Num5,
            Scancode::Num6 => Num6,
            Scancode::Num7 => Num7,
            Scancode::Num8 => Num8,
            Scancode::Num9 => Num9,

            Scancode::Kp0 => Kp0,
            Scancode::Kp1 => Kp1,
            Scancode::Kp2 => Kp2,
            Scancode::Kp3 => Kp3,
            Scancode::Kp4 => Kp4,
            Scancode::Kp5 => Kp5,
            Scancode::Kp6 => Kp6,
            Scancode::Kp7 => Kp7,
            Scancode::Kp8 => Kp8,
            Scancode::Kp9 => Kp9,

            Scancode::KpDivide => KpDivide,
            Scancode::KpMultiply => KpMultiply,
            Scancode::KpMinus => KpMinus,
            Scancode::KpPlus => KpPlus,
            Scancode::KpPeriod => KpPeriod,

            Scancode::A => A,
            Scancode::B => B,
            Scancode::C => C,
            Scancode::D => D,
            Scancode::E => E,
            Scancode::F => F,
            Scancode::G => G,
            Scancode::H => H,
            Scancode::I => I,
            Scancode::J => J,
            Scancode::K => K,
            Scancode::L => L,
            Scancode::M => M,
            Scancode::N => N,
            Scancode::O => O,
            Scancode::P => P,
            Scancode::Q => Q,
            Scancode::R => R,
            Scancode::S => S,
            Scancode::T => T,
            Scancode::U => U,
            Scancode::V => V,
            Scancode::W => W,
            Scancode::X => X,
            Scancode::Y => Y,
            Scancode::Z => Z,

            Scancode::F1 => F1,
            Scancode::F2 => F2,
            Scancode::F3 => F3,
            Scancode::F4 => F4,
            Scancode::F5 => F5,
            Scancode::F6 => F6,
            Scancode::F7 => F7,
            Scancode::F8 => F8,
            Scancode::F9 => F9,
            Scancode::F10 => F10,
            Scancode::F11 => F11,
            Scancode::F12 => F12,

            Scancode::Home => Home,
            Scancode::End => End,
            Scancode::PageUp => PageUp,
            Scancode::PageDown => PageDown,

            Scancode::Insert => Insert,
            Scancode::Delete => Delete,
            Scancode::Backspace => Backspace,
            Scancode::Tab => Tab,

            Scancode::LShift => LShift,
            Scancode::RShift => RShift,
            Scancode::LAlt => LAlt,
            Scancode::RAlt => RAlt,
            Scancode::LCtrl => LCtrl,
            Scancode::RCtrl => RCtrl,

            Scancode::Minus => Minus,
            Scancode::Equals => Equals,
            Scancode::LeftBracket => LeftBracket,
            Scancode::RightBracket => RightBracket,
            Scancode::Backslash =>Backslash,
            Scancode::Semicolon => Semicolon,
            Scancode::Apostrophe => Apostrophe,
            Scancode::Grave => Grave,
            Scancode::Comma => Comma,
            Scancode::Period => Period,
            Scancode::Slash => Slash,

            _ => {
                return None;
            }
        }),
        None => None
    }
}
