/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

extern crate sdl2;

use sdl2::mouse::MouseButton;

#[derive(Clone, Copy, Hash, Eq, PartialEq, Debug)] // for HashSet
pub enum Button {
    Left,
    Middle,
    Right
}

// "There and back again"... TODO: avoid duplications

pub fn to_sdl(b: Option<Button>) -> Option<MouseButton> {
    use Button::*;
    match b {
        Some(b) => match b {
            Left => Some(MouseButton::Left),
            Middle => Some(MouseButton::Middle),
            Right => Some(MouseButton::Right)
        },
        None => None
    }
}

pub fn from_sdl(b: Option<MouseButton>) -> Option<Button> {
    use Button::*;
    match b {
        Some(b) => match b {
            MouseButton::Left => Some(Left),
            MouseButton::Middle => Some(Middle),
            MouseButton::Right => Some(Right),

            _ => None
        },
        None => None
    }
}
