/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

extern crate serde;
extern crate serde_json;

use std::fs;

use serde::Deserialize;

use crate::base::{
    JEXT,
    PrependErrorString
};

use super::{
    CpuCountMode,
    WindowMode
};

const CONFIG_FILEPATH_NOEXT: &str = "config";

#[derive(Deserialize)]
pub struct Config {
    window_name: String,
    window_mode: WindowMode,
    width: i32,
    height: i32,
    field_of_view: i32, // in degrees
    vsync: bool,
    texture_smooth: bool,
    antialiasing_4x: bool,
    frame_rate: i32,
    cpu_count_mode: CpuCountMode,
    mouse_sensitivity: i32,
    left_hand: bool,
    mute: bool,
    vol_sound: i32,
    vol_music: i32,
    vol_speech: i32,
    lang: String
}

impl Config {
    pub fn load() -> Result<Config, String> {
        let filepath = format!("{}.{}", CONFIG_FILEPATH_NOEXT, JEXT);
        let b = fs::read(&filepath).pre_err("cannot read config file")?;
        let c: Config = serde_json::from_slice(&b).pre_err("cannot parse config json")?;
        Ok(c)
    }

    pub fn window_name(&self) -> String {
        self.window_name.clone()
    }

    pub fn window_mode(&self) -> WindowMode {
        self.window_mode
    }

    #[inline]
    pub fn width(&self) -> i32 {
        self.width
    }

    pub fn set_width(&mut self, w: i32) {
        self.width = w;
    }

    pub fn field_of_view(&self) -> i32 {
        self.field_of_view
    }

    #[inline]
    pub fn height(&self) -> i32 {
        self.height
    }

    pub fn set_height(&mut self, h: i32) {
        self.height = h;
    }

    pub fn vsync(&self) -> bool {
        self.vsync
    }

    pub fn texture_smooth(&self) -> bool {
        self.texture_smooth
    }

    pub fn antialiasing_4x(&self) -> bool {
        self.antialiasing_4x
    }

    pub fn frame_rate(&self) -> i32 {
        self.frame_rate
    }

    pub fn cpu_count_mode(&self) -> CpuCountMode {
        self.cpu_count_mode
    }

    pub fn mouse_sensitivity(&self) -> i32 {
        self.mouse_sensitivity
    }

    pub fn left_hand(&self) -> bool {
        self.left_hand
    }

    pub fn mute(&self) -> bool {
        self.mute
    }

    pub fn vol_sound(&self) -> i32 {
        self.vol_sound
    }

    pub fn vol_music(&self) -> i32 {
        self.vol_music
    }

    pub fn vol_speech(&self) -> i32 {
        self.vol_speech
    }

    pub fn lang(&self) -> String {
        self.lang.clone()
    }
}
