/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

use crate::{
	master::{
		ERR_ALREADY_SET,
		ERR_NOT_SET_CANNOT_RUN,
		Context,
		Master,
		Mode
	},
	sys::Button
};

const MID: &str = "Plate";

const PLATE_REACH_DIST: i64 = 5000 << 0x10;

pub enum MPlate {
	Unset,
	Set {
		i_plate: usize
	}
}

impl MPlate {
	pub fn new() -> Box<Self> {
		Box::new(Self::Unset)
	}
}

impl Master for MPlate {
	fn id(&self) -> String {
		String::from(MID)
	}

	fn start(&mut self, Context{lingua, cosm, state, ..}: &mut Context) -> Result<(), String> {
		match *self {
			Self::Unset => {
				lingua.load(&["violet_plate"])?;
				let i_plate = cosm.entity_ind("violet-plate")?;
				*self = Self::Set{i_plate};
				cosm.entities[i_plate].visible = !state.plate_taken;
				Ok(())
			},
			Self::Set{..} => Err(format!("{} {}", MID, ERR_ALREADY_SET))
		}
	}

    fn run(&mut self, Context{sys, cosm, state, ether, ..}: &mut Context) -> Result<(), String> {
		match *self {
			Self::Set{i_plate} => {
				let entities = &mut cosm.entities;

				// Plate
				let ent = &mut entities[i_plate];
				if ent.visible && ether.sync_reach(&state.plr_att.pos, &ent.att.pos, PLATE_REACH_DIST, ent.id()) {
					if (ether.mode == Mode::Fly) && ether.sel_reachable.eq(ent.id()) {
						if sys.poll_btn(Button::Right) {
							ether.describe("violet-plate");
						} else if sys.poll_btn(Button::Left) {
							match state.sel_item.as_str() {
								"" => { // take
									ent.visible = false;
									ether.sel_reachable.clear();
									state.plate_taken = true;
									state.add_and_sel_item("plate")?;
								},
								_ => ether.describe("_ + violet-plate")
							};
						}
					}
				}

				Ok(())
			},
			Self::Unset => Err(format!("{} {}", MID, ERR_NOT_SET_CANNOT_RUN))
		}
    }

}
