/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

use crate::{
	base::{
		ARGB,
		RGB
	},
	cosm::CFont,
	master::{
		ERR_ALREADY_SET,
		ERR_NOT_SET_CANNOT_RUN,
		Context,
		Master
	},
	sys::{
		Image,
		System
	}
};

const MID: &str = "Draw-stuff";

pub enum MDrawStuff {
	Unset,
	Set {
		mx: i32,
		my: i32,
		img1: Option<Image>,
		img2: Option<Image>,
		text1_image: Option<Image>
	}
}

impl MDrawStuff {
//	#[allow(dead_code)]
	pub fn new() -> Box<Self> {
		Box::new(Self::Unset)
	}
}

impl Master for MDrawStuff {
	fn id(&self) -> String {
		String::from(MID)
	}

	fn start(&mut self, Context{fonts, ..}: &mut Context) -> Result<(), String> {
		match *self {
			Self::Unset => {
				let img1: Option<Image> = Image::load("images/picture_appal.png").ok();
				let img2 = Image::load("images/picture_houses.png").ok().and_then(|img| Some(img.scaled(0.61524)));
				let text1_image = System::make_text_image(fonts.get(CFont::Descript), "Another one bites the oblivion and disappears into something that we never, ever should describe, or the eternal gloom will embrace our hearts, which have become sombre on their own, and what is all this but the futile attempt to lessen the burden that increasingly impacts everything under the sun; oh, the sun itself has become dull lately... А чи відображається текст на інших мовах, і якщо так, то наскільки швидко це відбувається? Чомусь видається, що повільно; відчутно повільніше, ніж для латинського тексту, і це вимагає пояснень! А також треба змінити підхід до відображення такого тексту, не візуалізуючи його кожного разу, а тільки коли він змінюється, інакше частота кадрів стане недопустимо низькою.", 500, RGB{r: 0x80, g: 0x80, b: 0xFF}).ok();

				*self = Self::Set{mx: 0, my: 0, img1, img2, text1_image};
				Ok(())
			},
			Self::Set{..} => Err(format!("{} {}", MID, ERR_ALREADY_SET))
		}
	}

    fn run(&mut self, Context{sys, ref fonts, ..}: &mut Context) -> Result<(), String> {
		match *self {
			Self::Set{ref mut mx, ref mut my, ref img1, ref img2, ref text1_image} => {
				{
					let (mx, my) = (*mx, *my); // immutable in this block

					if let Some(img) = img1 {
						let _ = sys.draw_image(img, mx - (img.width() >> 1), my - (img.height() >> 1));
					}

					if let Some(img) = img2 {
						let _ = sys.draw_image(img, -mx - (img.width() >> 1), -my - (img.height() >> 1));
					}

					let _ = sys.draw_rect(0, 0, -2 * mx, -2 * my, ARGB{a: 0x80, r: 0xFF, g: 0, b: 0xFF}, false);
					let _ = sys.draw_rect(0, 0, 2 * mx, 2 * my, ARGB{a: 0x80, r: 0xFF, g: 0, b: 0xFF}, true);

					let _ = sys.draw_line(0, 0, mx, my, ARGB{a: 0x80, r: 0, g: 0, b: 0xFF});

			        let _ = sys.draw_pixel(mx, my, ARGB{a: 0xFF, r: 0xFF, g: 0xFF, b: 0xFF});

					if let Some(txt_img) = text1_image {
						let _ = sys.draw_text_image(txt_img, 0xC0, 1, mx, my);
					}
					let _ = sys.draw_text(fonts.get(CFont::System), "...and multicoloured sprites!", 0, RGB{r: 0xFF, g: 0, b: 0}, 0x80, 2, -mx, -my);

					let _ = sys.draw_frame(mx, my, 200, 100, ARGB{a: 0x80, r: 0x80, g: 0x20, b: 0x20}, ARGB{a: 0xFF, r: 0xA0, g: 0xA0, b: 0xE0}, 3);
				}

				*mx = (*mx + sys.mouse_dx()).max(-sys.width()>>1).min((sys.width()>>1)-1);
				*my = (*my + sys.mouse_dy()).max(-sys.height()>>1).min((sys.height()>>1)-1);

				Ok(())
			},
			Self::Unset => Err(format!("{} {}", MID, ERR_NOT_SET_CANNOT_RUN))
		}
    }

}
