/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

use crate::{
	master::{
	   ERR_ALREADY_SET,
	   ERR_NOT_SET_CANNOT_RUN,
	   Context,
	   Master,
	   Mode
	},
	sys::{
		Key,
		Music,
		Sound
	}
};

const MID: &str = "Ambient-Dawn";

pub enum MAmbient<'a> {
	Unset,
	Set {
		mus1: Option<Music<'a>>,
		mus2: Option<Music<'a>>,
		snd1: Option<Sound>,
		snd2: Option<Sound>
	}
}

impl MAmbient<'_> {
	pub fn new() -> Box<Self> {
		Box::new(Self::Unset)
	}
}

impl Master for MAmbient<'_> {
	fn id(&self) -> String {
		String::from(MID)
	}

	fn start(&mut self, Context{sys, ether, ..}: &mut Context) -> Result<(), String> {
		match *self {
			Self::Unset => {
				let mus1 = sys.load_music("CA_MMOL.ogg");
				let mus2 = sys.load_music("B_A.ogg");
			    let snd1 = sys.load_sound("AON_IOD.ogg");
			    let snd2 = sys.load_sound("VD_TB.ogg");

				let _ = sys.play_music(mus1.as_ref());
				ether.music_id = String::from("melinda");

				*self = Self::Set{mus1, mus2, snd1, snd2};

				Ok(())
			},
			Self::Set{..} => Err(format!("{} {}", MID, ERR_ALREADY_SET))
		}
	}

    fn run(&mut self, Context{sys, cosm, state, ether, ..}: &mut Context) -> Result<(), String> {
		match *self {
			Self::Set{ref mus1, ref mus2, ref snd1, ref snd2} => {
				if cosm.chambers[state.plr_i_chamber].id().starts_with("stack-room") {
					if ether.music_id != "amazonas" {
						let _ = sys.play_music(mus2.as_ref());
						ether.music_id = String::from("amazonas");
					}
				} else {
					if ether.music_id != "melinda" {
						let _ = sys.play_music(mus1.as_ref());
						ether.music_id = String::from("melinda");
					}
				}

				if ether.mode == Mode::Fly {
					if sys.poll_key(Key::Num1) {
						let _ = sys.play_sound_once(snd1.as_ref());
					}
					if sys.poll_key(Key::Num2) {
						let _ = sys.play_sound_ever(snd2.as_ref());
					}
				}

				Ok(())
			},
			Self::Unset => Err(format!("{} {}", MID, ERR_NOT_SET_CANNOT_RUN))
		}
    }

}
