/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

use std::f64::consts::PI;

use crate::cosm::{
	Ball,
	Cosmos,
	Entity,
};

pub fn make(cosm: &mut Cosmos) -> Result<(), String> {
	// Make some loaded entity visible
	let i = cosm.entity_ind("violet-plate")?;
	let ent = &mut cosm.entities[i];
	ent.visible = true;

	let mut entity = Entity::new("blue-helix", 5000, 5000, 1000, 0.0, 0.0, 0.0);
	for i in 0..50 {
		let p = (i as f64) / 50.0;
		let ball = Ball::new(format!("b-{}", 1+i),
			(2000.0 * (8.0 * p * PI).cos()) as i64, (3000.0 * (8.0 * p * PI).sin()) as i64, -15000 + 600 * i,
			1000,
			[0xFF, (p * 255.0) as u8, 0, 0]);
		entity.add_ball(ball)?;
	}
	entity.visible = true;
	cosm.add_entity(entity)?;

	let i = cosm.entity_ind("blue-helix")?;
	let ent = &mut cosm.entities[i];
	// Duplicated, moved, scaled, rotated and with different color
	let mut ent = ent.dup("green-helix");
	ent.scale(0.5);
	ent.att.pos.x += 20000 << 0x10;
	ent.att.pos.y += 20000 << 0x10;
	ent.att.ori.pitch = 0.25 * PI;
	for b in &mut ent.balls {
		b.color = [0, b.color[1], 0, 0]
	}
	ent.visible = true;
	cosm.add_entity(ent)?;

	let mut entity = Entity::new("yellow-helix", -5000, 5000, 2000, 0.0, 0.0, 0.0);
	for i in 0..60 {
		let p = (i as f64) / 60.0;
		let ball = Ball::new(format!("b-{}", 1+i),
			-15000 + 500 * i, (2000.0 * (8.0 * p * PI).cos()) as i64, (3000.0 * (8.0 * p * PI).sin()) as i64,
			900,
			[0, (p * 255.0) as u8, (p * 255.0) as u8, 0]);
		entity.add_ball(ball)?;
	}
	entity.visible = true;
	cosm.add_entity(entity)?;

	Ok(())
}
