/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

use crate::cosm::Cosmos;

pub fn make(cosm: &mut Cosmos) -> Result<(), String> {
	// Few chambers, next on top of previous
	for i in 0..30 {
		cosm.add_chamber(format!("stack-room-{}", i+1), -6000 - 2000 * (i as i64), -12000 - 2000 * (i as i64), 10000 + (i as i64) * 5000, 12000 + 4000 * (i as i64), 25000 + 4000 * (i as i64), 5000, &["grey-wall", "grey-wall", "various-ceiling", "bright-floor", "grey-wall", "grey-wall"])?;
	}

	for i in 0..16 {
		cosm.add_chamber(format!("floor-hollow-{}", i+1), -15000 + 1000 * (i as i64), -25000 + 1000 * (i as i64), -14000, 1000, 1000, 4000, &["grey-wall", "grey-wall", "bright-floor", "various-ceiling", "grey-wall", "grey-wall"])?;
	}

	Ok(())
}
