/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

use std::f64::consts::PI;

use crate::{
	base::{
		Orientation,
		Position,
		PrependErrorString
	},
	master::{
		Context,
		Mastermind
	},
	state::Verse,
	sys::Key
};

mod chambers;
mod entities;
mod masters;
mod trajectories;

use masters::{
	MAmbient,
	MDrawStuff,
	MEnter,
	MHelices,
	MPlate
};

pub fn play(ctx: &mut Context) -> Result<(), String> {
	ctx.lingua.load(&["zones"])?; // DEBUG

	ctx.cosm.load("textures-dawn", "supra_textures-dawn", "chambers-dawn", "entities", "trajectories").pre_err("cannot load cosmos")?;

	chambers::make(ctx.cosm).pre_err("cannot make chambers")?;
	ctx.cosm.verify_connect_chambers().pre_err("verification and connection of chambers failed")?;

	entities::make(ctx.cosm).pre_err("cannot make entities")?;
	trajectories::make(ctx.cosm).pre_err("cannot make trajectories")?;

	let mut mastermind = Mastermind::new();

	mastermind.add_common_pre();
	mastermind.add(vec![
//		MDrawStuff::new(),
		MEnter::new(),
		MHelices::new(),
		MPlate::new(),
		MAmbient::new()
	]);
	mastermind.add_common_post();

    if ctx.state.transversed {
		match ctx.state.prev_verse {
			Verse::Dusk => {
				ctx.state.plr_att.pos = Position::new(0, 0, 0);
				ctx.state.plr_i_chamber = ctx.cosm.chamber_ind("big hall")?;
			},
			_ => ()
		}
		// TODO: set player attitude using previous verse and transition point
		ctx.state.transversed = false;
	}

	mastermind.start(ctx)?;

	while (!ctx.ether.quit) && (!ctx.ether.replay) && (!ctx.state.transversed) {

		mastermind.run(ctx)?;

		// Input handling... after sync

		if !ctx.ether.meta {
			// Menu
			if ctx.sys.poll_key(Key::Escape) {
				ctx.ether.meta = true;
			}

			// Transition to another verse
			if ctx.sys.poll_key(Key::Tab) {
				ctx.state.transverse(Verse::Dusk, "");
			}

			if ctx.sys.poll_key(Key::Kp8) {
				ctx.state.plr_att.ori = Orientation::new(0.0, 0.5 * PI, 0.0);
			}
			if ctx.sys.poll_key(Key::Kp2) {
				ctx.state.plr_att.ori = Orientation::new(0.0, -0.5 * PI, 0.0);
			}
			if ctx.sys.poll_key(Key::Kp4) {
				ctx.state.plr_att.ori = Orientation::new(0.25 * PI, 0.0, 0.0);
			}
			if ctx.sys.poll_key(Key::Kp6) {
				ctx.state.plr_att.ori = Orientation::new(-0.25 * PI, 0.0, 0.0);
			}
		}

        // More or less?..

    }

	mastermind.finish(ctx)?;

    Ok(())
}
