/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

//! Main play loops,
//! verse-specific initializers and masters

extern crate sdl2;

mod dawn;
mod dusk;

use crate::base::PrependErrorString;
use crate::sys::System;
use crate::cosm::{
	Cosmos,
	Fontset,
	Lingua
};
use crate::state::{
	AUTOSAVE_FILEPATH,
	State,
	Verse
};
use crate::master::{
	Context,
	Ether
};

pub fn play(sys: &mut System) -> Result<(), String> {
	let font_ctx = sys.font_context_rclone();
	let fonts = Fontset::load_fonts(&font_ctx).pre_err("cannot load fonts")?;

	if !State::savesdir_exists_or_made() {
		return Err(String::from("saves dir does not exist and cannot be created"));
	}

	let mut state = match State::savefile_exists(AUTOSAVE_FILEPATH) {
		false => State::new(),
		true => State::load(AUTOSAVE_FILEPATH).pre_err("cannot load state from autosave")?
	};

	loop {
		let mut lingua = Lingua::new(sys);
		let mut cosm = Cosmos::new();
		let mut ether = Ether::new(sys);

		let verse = state.verse;

		let mut ctx = Context{sys, fonts: &fonts, lingua: &mut lingua, cosm: &mut cosm, state: &mut state, ether: &mut ether};

		match verse {
			Verse::Dawn => dawn::play(&mut ctx).pre_err("cannot play Dawn verse"),
			Verse::Dusk => dusk::play(&mut ctx).pre_err("cannot play Dusk verse"),
		}?;

		state.save(AUTOSAVE_FILEPATH).pre_err("cannot save state to autosave")?;

		if ether.quit {
			break;
		}
	}

    Ok(())
}
