/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

use super::{
	ERR_ALREADY_SET,
	ERR_NOT_SET_CANNOT_RUN,
	Context,
	Master
};

const MID: &str = "Antialiasing-4x";

pub enum MAntialias {
	Unset,
	Set
}

impl MAntialias {
	pub fn new() -> Box<Self> {
		Box::new(Self::Unset)
	}
}

impl Master for MAntialias {
	fn id(&self) -> String {
		String::from(MID)
	}

	fn start(&mut self, _ctx: &mut Context) -> Result<(), String> {
		match *self {
			Self::Unset => {
				*self = Self::Set;
				Ok(())
			},
			Self::Set => Err(format!("{} {}", MID, ERR_ALREADY_SET))
		}
	}

    fn run(&mut self, Context{sys, ..}: &mut Context) -> Result<(), String> {
		match *self {
			Self::Set => {
		        if sys.antialiasing_4x() {
		            sys.quarterize();
		        }
				Ok(())
			},

			Self::Unset => Err(format!("{} {}", MID, ERR_NOT_SET_CANNOT_RUN))
		}
    }

}
