/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

/*!
# Rayngin

3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls.

Uses SDL2. Includes music and sound, inventory management, item usage, branched dialogues, saving and loading, has multilanguage support.

Please see the project homepage [sunkware.org/rayngin](https://sunkware.org/rayngin/index.php) that contains demo video.

**Warning 0**: use at your own risk.

**Warning 1**: compiled binary (or link to it) should be placed into a dir with demo data and then launched. Download the data from [sunkware.org/rayngin/download](https://sunkware.org/rayngin/download.php).

**Warning 2**: build with the `release` profile to optimize performance.

![9-screenshots-poster](https://sunkware.org/rayngin/img/rayngin_9scr_poster_crates.io.png)
*/

use std::process;

mod base;
mod sys;
mod cosm;
mod state;
mod master;
mod play;

use base::PrependErrorString;

fn run () -> Result<(), String> {
	let mut sys = sys::System::init().pre_err("cannot init system")?;
	play::play(&mut sys).pre_err("cannot play")?;
    sys.shut().pre_err("cannot shut system")?;
	Ok(())
}

fn main() {
	process::exit(match run() {
		Ok(_) => 0,
		Err(s) => {
			eprintln!("Error: {}", s);
			1
		}
	});
}
