/*
 * Rayngin - 3D 6DF framework/engine for approach&click quests in rectangular chambers with objects consisting of balls
 * Copyright (c) 2021 Sunkware
 * PubKey FP: 6B6D C8E9 3438 6E9C 3D97  56E5 2CE9 A476 99EF 28F6
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * [ WWW: sunkware.org ]                         [ E-MAIL: sunkware@gmail.com ]
 */

extern crate serde;
extern crate serde_json;

use std::fs;

use serde::Deserialize;

use crate::base::{
    BASE_DIR,
	JEXT,
    PrependErrorString
};

use super::Cosmos;

use super::entity::{
    Ball,
    Entity
};

#[derive(Deserialize)]
struct BallDesc {
	id: String,
	x: i64, y: i64, z: i64,
	rad: i64,
	color: [u8; 4]
}

#[derive(Deserialize)]
struct EntityDesc {
    id: String,

    x: i64,
    y: i64,
    z: i64,
    yaw: f64,
    pitch: f64,
    roll: f64,

	balls: Vec<BallDesc>,
}


impl Cosmos {
    pub fn add_entity(&mut self, entity: Entity) -> Result<(), String> {
        match self.entity_hmap.insert(entity.id().clone(), self.entities.len()) {
            Some(_) => Err(format!("cannot add entity '{}': already exists", entity.id())),
            None => {
                self.entities.push(entity);
                Ok(())
            }
        }
    }

	pub fn load_entities(&mut self, base_filepath_noext: impl ToString) -> Result<(), String> {
		let filepath = format!("{}/{}.{}", BASE_DIR, base_filepath_noext.to_string(), JEXT);
		let b = fs::read(&filepath).pre_err("cannot read entities file")?;
		let esd: Vec<EntityDesc> = serde_json::from_slice(&b).pre_err("cannot parse entities json")?;

		for ed in &esd {
			let mut ent = Entity::new(ed.id.clone(), ed.x, ed.y, ed.z, ed.yaw, ed.pitch, ed.roll);
			for bd in &ed.balls {
				let b = Ball::new(bd.id.clone(), bd.x, bd.y, bd.z, bd.rad, bd.color);
				ent.add_ball(b)?;
			}
			self.add_entity(ent)?;
		}

		Ok(())
	}

	pub fn entity_ind(&self, id: impl ToString) -> Result<usize, String> {
		let id = id.to_string();
		match self.entity_hmap.get(&id) {
			Some(&i) => Ok(i),
			None => Err(format!("cannot find '{}' entity", &id))
		}
    }

}
