/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const RAYGUI_VERSION: &'static [u8; 8usize] = b"2.6-dev\0";
pub const __GNUC_VA_LIST: u32 = 1;
pub const PI: f64 = 3.141592653589793;
pub const DEG2RAD: f64 = 0.017453292519943295;
pub const RAD2DEG: f64 = 57.29577951308232;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const __API_TO_BE_DEPRECATED: u32 = 100000;
pub const __MAC_10_0: u32 = 1000;
pub const __MAC_10_1: u32 = 1010;
pub const __MAC_10_2: u32 = 1020;
pub const __MAC_10_3: u32 = 1030;
pub const __MAC_10_4: u32 = 1040;
pub const __MAC_10_5: u32 = 1050;
pub const __MAC_10_6: u32 = 1060;
pub const __MAC_10_7: u32 = 1070;
pub const __MAC_10_8: u32 = 1080;
pub const __MAC_10_9: u32 = 1090;
pub const __MAC_10_10: u32 = 101000;
pub const __MAC_10_10_2: u32 = 101002;
pub const __MAC_10_10_3: u32 = 101003;
pub const __MAC_10_11: u32 = 101100;
pub const __MAC_10_11_2: u32 = 101102;
pub const __MAC_10_11_3: u32 = 101103;
pub const __MAC_10_11_4: u32 = 101104;
pub const __MAC_10_12: u32 = 101200;
pub const __MAC_10_12_1: u32 = 101201;
pub const __MAC_10_12_2: u32 = 101202;
pub const __MAC_10_12_4: u32 = 101204;
pub const __MAC_10_13: u32 = 101300;
pub const __MAC_10_13_1: u32 = 101301;
pub const __MAC_10_13_2: u32 = 101302;
pub const __MAC_10_13_4: u32 = 101304;
pub const __MAC_10_14: u32 = 101400;
pub const __MAC_10_14_1: u32 = 101401;
pub const __MAC_10_14_4: u32 = 101404;
pub const __MAC_10_15: u32 = 101500;
pub const __MAC_10_15_1: u32 = 101501;
pub const __MAC_10_15_4: u32 = 101504;
pub const __IPHONE_2_0: u32 = 20000;
pub const __IPHONE_2_1: u32 = 20100;
pub const __IPHONE_2_2: u32 = 20200;
pub const __IPHONE_3_0: u32 = 30000;
pub const __IPHONE_3_1: u32 = 30100;
pub const __IPHONE_3_2: u32 = 30200;
pub const __IPHONE_4_0: u32 = 40000;
pub const __IPHONE_4_1: u32 = 40100;
pub const __IPHONE_4_2: u32 = 40200;
pub const __IPHONE_4_3: u32 = 40300;
pub const __IPHONE_5_0: u32 = 50000;
pub const __IPHONE_5_1: u32 = 50100;
pub const __IPHONE_6_0: u32 = 60000;
pub const __IPHONE_6_1: u32 = 60100;
pub const __IPHONE_7_0: u32 = 70000;
pub const __IPHONE_7_1: u32 = 70100;
pub const __IPHONE_8_0: u32 = 80000;
pub const __IPHONE_8_1: u32 = 80100;
pub const __IPHONE_8_2: u32 = 80200;
pub const __IPHONE_8_3: u32 = 80300;
pub const __IPHONE_8_4: u32 = 80400;
pub const __IPHONE_9_0: u32 = 90000;
pub const __IPHONE_9_1: u32 = 90100;
pub const __IPHONE_9_2: u32 = 90200;
pub const __IPHONE_9_3: u32 = 90300;
pub const __IPHONE_10_0: u32 = 100000;
pub const __IPHONE_10_1: u32 = 100100;
pub const __IPHONE_10_2: u32 = 100200;
pub const __IPHONE_10_3: u32 = 100300;
pub const __IPHONE_11_0: u32 = 110000;
pub const __IPHONE_11_1: u32 = 110100;
pub const __IPHONE_11_2: u32 = 110200;
pub const __IPHONE_11_3: u32 = 110300;
pub const __IPHONE_11_4: u32 = 110400;
pub const __IPHONE_12_0: u32 = 120000;
pub const __IPHONE_12_1: u32 = 120100;
pub const __IPHONE_12_2: u32 = 120200;
pub const __IPHONE_12_3: u32 = 120300;
pub const __IPHONE_13_0: u32 = 130000;
pub const __IPHONE_13_1: u32 = 130100;
pub const __IPHONE_13_2: u32 = 130200;
pub const __IPHONE_13_3: u32 = 130300;
pub const __IPHONE_13_4: u32 = 130400;
pub const __IPHONE_13_5: u32 = 130500;
pub const __IPHONE_13_6: u32 = 130600;
pub const __TVOS_9_0: u32 = 90000;
pub const __TVOS_9_1: u32 = 90100;
pub const __TVOS_9_2: u32 = 90200;
pub const __TVOS_10_0: u32 = 100000;
pub const __TVOS_10_0_1: u32 = 100001;
pub const __TVOS_10_1: u32 = 100100;
pub const __TVOS_10_2: u32 = 100200;
pub const __TVOS_11_0: u32 = 110000;
pub const __TVOS_11_1: u32 = 110100;
pub const __TVOS_11_2: u32 = 110200;
pub const __TVOS_11_3: u32 = 110300;
pub const __TVOS_11_4: u32 = 110400;
pub const __TVOS_12_0: u32 = 120000;
pub const __TVOS_12_1: u32 = 120100;
pub const __TVOS_12_2: u32 = 120200;
pub const __TVOS_12_3: u32 = 120300;
pub const __TVOS_13_0: u32 = 130000;
pub const __TVOS_13_2: u32 = 130200;
pub const __TVOS_13_3: u32 = 130300;
pub const __TVOS_13_4: u32 = 130400;
pub const __WATCHOS_1_0: u32 = 10000;
pub const __WATCHOS_2_0: u32 = 20000;
pub const __WATCHOS_2_1: u32 = 20100;
pub const __WATCHOS_2_2: u32 = 20200;
pub const __WATCHOS_3_0: u32 = 30000;
pub const __WATCHOS_3_1: u32 = 30100;
pub const __WATCHOS_3_1_1: u32 = 30101;
pub const __WATCHOS_3_2: u32 = 30200;
pub const __WATCHOS_4_0: u32 = 40000;
pub const __WATCHOS_4_1: u32 = 40100;
pub const __WATCHOS_4_2: u32 = 40200;
pub const __WATCHOS_4_3: u32 = 40300;
pub const __WATCHOS_5_0: u32 = 50000;
pub const __WATCHOS_5_1: u32 = 50100;
pub const __WATCHOS_5_2: u32 = 50200;
pub const __WATCHOS_6_0: u32 = 60000;
pub const __WATCHOS_6_1: u32 = 60100;
pub const __WATCHOS_6_2: u32 = 60200;
pub const __DRIVERKIT_19_0: u32 = 190000;
pub const __MAC_OS_X_VERSION_MAX_ALLOWED: u32 = 101500;
pub const __ENABLE_LEGACY_MAC_AVAILABILITY: u32 = 1;
pub const __DARWIN_ONLY_64_BIT_INO_T: u32 = 0;
pub const __DARWIN_ONLY_VERS_1050: u32 = 0;
pub const __DARWIN_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const __DARWIN_UNIX03: u32 = 1;
pub const __DARWIN_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_VERS_1050: u32 = 1;
pub const __DARWIN_NON_CANCELABLE: u32 = 0;
pub const __DARWIN_SUF_64_BIT_INO_T: &'static [u8; 9usize] = b"$INODE64\0";
pub const __DARWIN_SUF_1050: &'static [u8; 6usize] = b"$1050\0";
pub const __DARWIN_SUF_EXTSN: &'static [u8; 14usize] = b"$DARWIN_EXTSN\0";
pub const __DARWIN_C_ANSI: u32 = 4096;
pub const __DARWIN_C_FULL: u32 = 900000;
pub const __DARWIN_C_LEVEL: u32 = 900000;
pub const __DARWIN_NO_LONG_LONG: u32 = 0;
pub const _DARWIN_FEATURE_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const _DARWIN_FEATURE_UNIX_CONFORMANCE: u32 = 3;
pub const __PTHREAD_SIZE__: u32 = 8176;
pub const __PTHREAD_ATTR_SIZE__: u32 = 56;
pub const __PTHREAD_MUTEXATTR_SIZE__: u32 = 8;
pub const __PTHREAD_MUTEX_SIZE__: u32 = 56;
pub const __PTHREAD_CONDATTR_SIZE__: u32 = 8;
pub const __PTHREAD_COND_SIZE__: u32 = 40;
pub const __PTHREAD_ONCE_SIZE__: u32 = 8;
pub const __PTHREAD_RWLOCK_SIZE__: u32 = 192;
pub const __PTHREAD_RWLOCKATTR_SIZE__: u32 = 16;
pub const __DARWIN_WCHAR_MIN: i32 = -2147483648;
pub const _FORTIFY_SOURCE: u32 = 2;
pub const __DARWIN_NSIG: u32 = 32;
pub const NSIG: u32 = 32;
pub const _I386_SIGNAL_H_: u32 = 1;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGEMT: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGIO: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGINFO: u32 = 29;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const FP_PREC_24B: u32 = 0;
pub const FP_PREC_53B: u32 = 2;
pub const FP_PREC_64B: u32 = 3;
pub const FP_RND_NEAR: u32 = 0;
pub const FP_RND_DOWN: u32 = 1;
pub const FP_RND_UP: u32 = 2;
pub const FP_CHOP: u32 = 3;
pub const FP_STATE_BYTES: u32 = 512;
pub const SIGEV_NONE: u32 = 0;
pub const SIGEV_SIGNAL: u32 = 1;
pub const SIGEV_THREAD: u32 = 3;
pub const ILL_NOOP: u32 = 0;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLTRP: u32 = 2;
pub const ILL_PRVOPC: u32 = 3;
pub const ILL_ILLOPN: u32 = 4;
pub const ILL_ILLADR: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const FPE_NOOP: u32 = 0;
pub const FPE_FLTDIV: u32 = 1;
pub const FPE_FLTOVF: u32 = 2;
pub const FPE_FLTUND: u32 = 3;
pub const FPE_FLTRES: u32 = 4;
pub const FPE_FLTINV: u32 = 5;
pub const FPE_FLTSUB: u32 = 6;
pub const FPE_INTDIV: u32 = 7;
pub const FPE_INTOVF: u32 = 8;
pub const SEGV_NOOP: u32 = 0;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const BUS_NOOP: u32 = 0;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const CLD_NOOP: u32 = 0;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SA_ONSTACK: u32 = 1;
pub const SA_RESTART: u32 = 2;
pub const SA_RESETHAND: u32 = 4;
pub const SA_NOCLDSTOP: u32 = 8;
pub const SA_NODEFER: u32 = 16;
pub const SA_NOCLDWAIT: u32 = 32;
pub const SA_SIGINFO: u32 = 64;
pub const SA_USERTRAMP: u32 = 256;
pub const SA_64REGSET: u32 = 512;
pub const SA_USERSPACE_MASK: u32 = 127;
pub const SIG_BLOCK: u32 = 1;
pub const SIG_UNBLOCK: u32 = 2;
pub const SIG_SETMASK: u32 = 3;
pub const SI_USER: u32 = 65537;
pub const SI_QUEUE: u32 = 65538;
pub const SI_TIMER: u32 = 65539;
pub const SI_ASYNCIO: u32 = 65540;
pub const SI_MESGQ: u32 = 65541;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 4;
pub const MINSIGSTKSZ: u32 = 32768;
pub const SIGSTKSZ: u32 = 131072;
pub const SV_ONSTACK: u32 = 1;
pub const SV_INTERRUPT: u32 = 2;
pub const SV_RESETHAND: u32 = 4;
pub const SV_NODEFER: u32 = 16;
pub const SV_NOCLDSTOP: u32 = 8;
pub const SV_SIGINFO: u32 = 64;
pub const __WORDSIZE: u32 = 64;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const INT64_MAX: u64 = 9223372036854775807;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT64_MIN: i64 = -9223372036854775808;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT64_MAX: i32 = -1;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST64_MIN: i64 = -9223372036854775808;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_LEAST64_MAX: u64 = 9223372036854775807;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_LEAST64_MAX: i32 = -1;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i32 = -32768;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST64_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u32 = 32767;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const INT_FAST64_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: u32 = 65535;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const UINT_FAST64_MAX: i32 = -1;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const UINTPTR_MAX: i32 = -1;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const PRIO_PROCESS: u32 = 0;
pub const PRIO_PGRP: u32 = 1;
pub const PRIO_USER: u32 = 2;
pub const PRIO_DARWIN_THREAD: u32 = 3;
pub const PRIO_DARWIN_PROCESS: u32 = 4;
pub const PRIO_MIN: i32 = -20;
pub const PRIO_MAX: u32 = 20;
pub const PRIO_DARWIN_BG: u32 = 4096;
pub const PRIO_DARWIN_NONUI: u32 = 4097;
pub const RUSAGE_SELF: u32 = 0;
pub const RUSAGE_CHILDREN: i32 = -1;
pub const RUSAGE_INFO_V0: u32 = 0;
pub const RUSAGE_INFO_V1: u32 = 1;
pub const RUSAGE_INFO_V2: u32 = 2;
pub const RUSAGE_INFO_V3: u32 = 3;
pub const RUSAGE_INFO_V4: u32 = 4;
pub const RUSAGE_INFO_CURRENT: u32 = 4;
pub const RLIMIT_CPU: u32 = 0;
pub const RLIMIT_FSIZE: u32 = 1;
pub const RLIMIT_DATA: u32 = 2;
pub const RLIMIT_STACK: u32 = 3;
pub const RLIMIT_CORE: u32 = 4;
pub const RLIMIT_AS: u32 = 5;
pub const RLIMIT_RSS: u32 = 5;
pub const RLIMIT_MEMLOCK: u32 = 6;
pub const RLIMIT_NPROC: u32 = 7;
pub const RLIMIT_NOFILE: u32 = 8;
pub const RLIM_NLIMITS: u32 = 9;
pub const _RLIMIT_POSIX_FLAG: u32 = 4096;
pub const RLIMIT_WAKEUPS_MONITOR: u32 = 1;
pub const RLIMIT_CPU_USAGE_MONITOR: u32 = 2;
pub const RLIMIT_THREAD_CPULIMITS: u32 = 3;
pub const RLIMIT_FOOTPRINT_INTERVAL: u32 = 4;
pub const WAKEMON_ENABLE: u32 = 1;
pub const WAKEMON_DISABLE: u32 = 2;
pub const WAKEMON_GET_PARAMS: u32 = 4;
pub const WAKEMON_SET_DEFAULTS: u32 = 8;
pub const WAKEMON_MAKE_FATAL: u32 = 16;
pub const CPUMON_MAKE_FATAL: u32 = 4096;
pub const FOOTPRINT_INTERVAL_RESET: u32 = 1;
pub const IOPOL_TYPE_DISK: u32 = 0;
pub const IOPOL_TYPE_VFS_ATIME_UPDATES: u32 = 2;
pub const IOPOL_TYPE_VFS_MATERIALIZE_DATALESS_FILES: u32 = 3;
pub const IOPOL_TYPE_VFS_STATFS_NO_DATA_VOLUME: u32 = 4;
pub const IOPOL_SCOPE_PROCESS: u32 = 0;
pub const IOPOL_SCOPE_THREAD: u32 = 1;
pub const IOPOL_SCOPE_DARWIN_BG: u32 = 2;
pub const IOPOL_DEFAULT: u32 = 0;
pub const IOPOL_IMPORTANT: u32 = 1;
pub const IOPOL_PASSIVE: u32 = 2;
pub const IOPOL_THROTTLE: u32 = 3;
pub const IOPOL_UTILITY: u32 = 4;
pub const IOPOL_STANDARD: u32 = 5;
pub const IOPOL_APPLICATION: u32 = 5;
pub const IOPOL_NORMAL: u32 = 1;
pub const IOPOL_ATIME_UPDATES_DEFAULT: u32 = 0;
pub const IOPOL_ATIME_UPDATES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_DEFAULT: u32 = 0;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_ON: u32 = 2;
pub const IOPOL_VFS_STATFS_NO_DATA_VOLUME_DEFAULT: u32 = 0;
pub const IOPOL_VFS_STATFS_FORCE_NO_DATA_VOLUME: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WCOREFLAG: u32 = 128;
pub const _WSTOPPED: u32 = 127;
pub const WEXITED: u32 = 4;
pub const WSTOPPED: u32 = 8;
pub const WCONTINUED: u32 = 16;
pub const WNOWAIT: u32 = 32;
pub const WAIT_ANY: i32 = -1;
pub const WAIT_MYPGRP: u32 = 0;
pub const _QUAD_HIGHWORD: u32 = 1;
pub const _QUAD_LOWWORD: u32 = 0;
pub const __DARWIN_LITTLE_ENDIAN: u32 = 1234;
pub const __DARWIN_BIG_ENDIAN: u32 = 4321;
pub const __DARWIN_PDP_ENDIAN: u32 = 3412;
pub const __DARWIN_BYTE_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const RAND_MAX: u32 = 2147483647;
pub const NUM_CONTROLS: u32 = 16;
pub const NUM_PROPS_DEFAULT: u32 = 16;
pub const NUM_PROPS_EXTENDED: u32 = 8;
pub const TEXTEDIT_CURSOR_BLINK_FRAMES: u32 = 20;
pub const RICON_MAX_ICONS: u32 = 256;
pub const RICON_SIZE: u32 = 16;
pub const RICON_MAX_NAME_LENGTH: u32 = 32;
pub const RICON_DATA_ELEMENTS: u32 = 8;
pub const RENAME_SECLUDE: u32 = 1;
pub const RENAME_SWAP: u32 = 2;
pub const RENAME_EXCL: u32 = 4;
pub const __SLBF: u32 = 1;
pub const __SNBF: u32 = 2;
pub const __SRD: u32 = 4;
pub const __SWR: u32 = 8;
pub const __SRW: u32 = 16;
pub const __SEOF: u32 = 32;
pub const __SERR: u32 = 64;
pub const __SMBF: u32 = 128;
pub const __SAPP: u32 = 256;
pub const __SSTR: u32 = 512;
pub const __SOPT: u32 = 1024;
pub const __SNPT: u32 = 2048;
pub const __SOFF: u32 = 4096;
pub const __SMOD: u32 = 8192;
pub const __SALC: u32 = 16384;
pub const __SIGN: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 1024;
pub const EOF: i32 = -1;
pub const FOPEN_MAX: u32 = 20;
pub const FILENAME_MAX: u32 = 1024;
pub const P_tmpdir: &'static [u8; 10usize] = b"/var/tmp/\0";
pub const L_tmpnam: u32 = 1024;
pub const TMP_MAX: u32 = 308915776;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const L_ctermid: u32 = 1024;
pub const _USE_FORTIFY_LEVEL: u32 = 2;
pub const __HAS_FIXED_CHK_PROTOTYPES: u32 = 1;
pub const FP_NAN: u32 = 1;
pub const FP_INFINITE: u32 = 2;
pub const FP_ZERO: u32 = 3;
pub const FP_NORMAL: u32 = 4;
pub const FP_SUBNORMAL: u32 = 5;
pub const FP_SUPERNORMAL: u32 = 6;
pub const FP_ILOGB0: i32 = -2147483648;
pub const FP_ILOGBNAN: i32 = -2147483648;
pub const MATH_ERRNO: u32 = 1;
pub const MATH_ERREXCEPT: u32 = 2;
pub const M_E: f64 = 2.718281828459045;
pub const M_LOG2E: f64 = 1.4426950408889634;
pub const M_LOG10E: f64 = 0.4342944819032518;
pub const M_LN2: f64 = 0.6931471805599453;
pub const M_LN10: f64 = 2.302585092994046;
pub const M_PI: f64 = 3.141592653589793;
pub const M_PI_2: f64 = 1.5707963267948966;
pub const M_PI_4: f64 = 0.7853981633974483;
pub const M_1_PI: f64 = 0.3183098861837907;
pub const M_2_PI: f64 = 0.6366197723675814;
pub const M_2_SQRTPI: f64 = 1.1283791670955126;
pub const M_SQRT2: f64 = 1.4142135623730951;
pub const M_SQRT1_2: f64 = 0.7071067811865476;
pub const FP_SNAN: u32 = 1;
pub const FP_QNAN: u32 = 1;
pub const DOMAIN: u32 = 1;
pub const SING: u32 = 2;
pub const OVERFLOW: u32 = 3;
pub const UNDERFLOW: u32 = 4;
pub const TLOSS: u32 = 5;
pub const PLOSS: u32 = 6;
pub const WINDOW_STATUSBAR_HEIGHT: u32 = 22;
pub const GROUPBOX_LINE_THICK: u32 = 1;
pub const GROUPBOX_TEXT_PADDING: u32 = 10;
pub const LINE_TEXT_PADDING: u32 = 10;
pub const PANEL_BORDER_WIDTH: u32 = 1;
pub const TOGGLEGROUP_MAX_ELEMENTS: u32 = 32;
pub const VALUEBOX_MAX_CHARS: u32 = 32;
pub const COLORBARALPHA_CHECKED_SIZE: u32 = 10;
pub const MESSAGEBOX_BUTTON_HEIGHT: u32 = 24;
pub const MESSAGEBOX_BUTTON_PADDING: u32 = 10;
pub const TEXTINPUTBOX_BUTTON_HEIGHT: u32 = 24;
pub const TEXTINPUTBOX_BUTTON_PADDING: u32 = 10;
pub const TEXTINPUTBOX_HEIGHT: u32 = 30;
pub const TEXTINPUTBOX_MAX_TEXT_LENGTH: u32 = 256;
pub const GRID_COLOR_ALPHA: f64 = 0.15;
pub const ICON_TEXT_PADDING: u32 = 4;
pub const TEXTSPLIT_MAX_TEXT_LENGTH: u32 = 1024;
pub const TEXTSPLIT_MAX_TEXT_ELEMENTS: u32 = 128;
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Vector2 {
    pub x: f32,
    pub y: f32,
}
#[test]
fn bindgen_test_layout_Vector2() {
    assert_eq!(
        ::std::mem::size_of::<Vector2>(),
        8usize,
        concat!("Size of: ", stringify!(Vector2))
    );
    assert_eq!(
        ::std::mem::align_of::<Vector2>(),
        4usize,
        concat!("Alignment of ", stringify!(Vector2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Vector2>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Vector2),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Vector2>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(Vector2),
            "::",
            stringify!(y)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Vector3 {
    pub x: f32,
    pub y: f32,
    pub z: f32,
}
#[test]
fn bindgen_test_layout_Vector3() {
    assert_eq!(
        ::std::mem::size_of::<Vector3>(),
        12usize,
        concat!("Size of: ", stringify!(Vector3))
    );
    assert_eq!(
        ::std::mem::align_of::<Vector3>(),
        4usize,
        concat!("Alignment of ", stringify!(Vector3))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Vector3>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Vector3),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Vector3>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(Vector3),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Vector3>())).z as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Vector3),
            "::",
            stringify!(z)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Vector4 {
    pub x: f32,
    pub y: f32,
    pub z: f32,
    pub w: f32,
}
#[test]
fn bindgen_test_layout_Vector4() {
    assert_eq!(
        ::std::mem::size_of::<Vector4>(),
        16usize,
        concat!("Size of: ", stringify!(Vector4))
    );
    assert_eq!(
        ::std::mem::align_of::<Vector4>(),
        4usize,
        concat!("Alignment of ", stringify!(Vector4))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Vector4>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Vector4),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Vector4>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(Vector4),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Vector4>())).z as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Vector4),
            "::",
            stringify!(z)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Vector4>())).w as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(Vector4),
            "::",
            stringify!(w)
        )
    );
}
pub type Quaternion = Vector4;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Matrix {
    pub m0: f32,
    pub m4: f32,
    pub m8: f32,
    pub m12: f32,
    pub m1: f32,
    pub m5: f32,
    pub m9: f32,
    pub m13: f32,
    pub m2: f32,
    pub m6: f32,
    pub m10: f32,
    pub m14: f32,
    pub m3: f32,
    pub m7: f32,
    pub m11: f32,
    pub m15: f32,
}
#[test]
fn bindgen_test_layout_Matrix() {
    assert_eq!(
        ::std::mem::size_of::<Matrix>(),
        64usize,
        concat!("Size of: ", stringify!(Matrix))
    );
    assert_eq!(
        ::std::mem::align_of::<Matrix>(),
        4usize,
        concat!("Alignment of ", stringify!(Matrix))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m0 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m4 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m8 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m12 as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m12)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m1 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m5 as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m9 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m9)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m13 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m13)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m2 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m6 as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m10 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m10)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m14 as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m14)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m3 as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m7 as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m11 as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m11)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Matrix>())).m15 as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(Matrix),
            "::",
            stringify!(m15)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Color {
    pub r: ::std::os::raw::c_uchar,
    pub g: ::std::os::raw::c_uchar,
    pub b: ::std::os::raw::c_uchar,
    pub a: ::std::os::raw::c_uchar,
}
#[test]
fn bindgen_test_layout_Color() {
    assert_eq!(
        ::std::mem::size_of::<Color>(),
        4usize,
        concat!("Size of: ", stringify!(Color))
    );
    assert_eq!(
        ::std::mem::align_of::<Color>(),
        1usize,
        concat!("Alignment of ", stringify!(Color))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Color>())).r as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(Color), "::", stringify!(r))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Color>())).g as *const _ as usize },
        1usize,
        concat!("Offset of field: ", stringify!(Color), "::", stringify!(g))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Color>())).b as *const _ as usize },
        2usize,
        concat!("Offset of field: ", stringify!(Color), "::", stringify!(b))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Color>())).a as *const _ as usize },
        3usize,
        concat!("Offset of field: ", stringify!(Color), "::", stringify!(a))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Rectangle {
    pub x: f32,
    pub y: f32,
    pub width: f32,
    pub height: f32,
}
#[test]
fn bindgen_test_layout_Rectangle() {
    assert_eq!(
        ::std::mem::size_of::<Rectangle>(),
        16usize,
        concat!("Size of: ", stringify!(Rectangle))
    );
    assert_eq!(
        ::std::mem::align_of::<Rectangle>(),
        4usize,
        concat!("Alignment of ", stringify!(Rectangle))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Rectangle>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Rectangle),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Rectangle>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(Rectangle),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Rectangle>())).width as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Rectangle),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Rectangle>())).height as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(Rectangle),
            "::",
            stringify!(height)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Image {
    pub data: *mut ::std::os::raw::c_void,
    pub width: ::std::os::raw::c_int,
    pub height: ::std::os::raw::c_int,
    pub mipmaps: ::std::os::raw::c_int,
    pub format: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_Image() {
    assert_eq!(
        ::std::mem::size_of::<Image>(),
        24usize,
        concat!("Size of: ", stringify!(Image))
    );
    assert_eq!(
        ::std::mem::align_of::<Image>(),
        8usize,
        concat!("Alignment of ", stringify!(Image))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Image>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Image),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Image>())).width as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Image),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Image>())).height as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(Image),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Image>())).mipmaps as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(Image),
            "::",
            stringify!(mipmaps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Image>())).format as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(Image),
            "::",
            stringify!(format)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Texture {
    pub id: ::std::os::raw::c_uint,
    pub width: ::std::os::raw::c_int,
    pub height: ::std::os::raw::c_int,
    pub mipmaps: ::std::os::raw::c_int,
    pub format: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_Texture() {
    assert_eq!(
        ::std::mem::size_of::<Texture>(),
        20usize,
        concat!("Size of: ", stringify!(Texture))
    );
    assert_eq!(
        ::std::mem::align_of::<Texture>(),
        4usize,
        concat!("Alignment of ", stringify!(Texture))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Texture>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Texture),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Texture>())).width as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(Texture),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Texture>())).height as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Texture),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Texture>())).mipmaps as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(Texture),
            "::",
            stringify!(mipmaps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Texture>())).format as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(Texture),
            "::",
            stringify!(format)
        )
    );
}
pub type Texture2D = Texture;
pub type TextureCubemap = Texture;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RenderTexture {
    pub id: ::std::os::raw::c_uint,
    pub texture: Texture,
    pub depth: Texture,
}
#[test]
fn bindgen_test_layout_RenderTexture() {
    assert_eq!(
        ::std::mem::size_of::<RenderTexture>(),
        44usize,
        concat!("Size of: ", stringify!(RenderTexture))
    );
    assert_eq!(
        ::std::mem::align_of::<RenderTexture>(),
        4usize,
        concat!("Alignment of ", stringify!(RenderTexture))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RenderTexture>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RenderTexture),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RenderTexture>())).texture as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RenderTexture),
            "::",
            stringify!(texture)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RenderTexture>())).depth as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RenderTexture),
            "::",
            stringify!(depth)
        )
    );
}
pub type RenderTexture2D = RenderTexture;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NPatchInfo {
    pub source: Rectangle,
    pub left: ::std::os::raw::c_int,
    pub top: ::std::os::raw::c_int,
    pub right: ::std::os::raw::c_int,
    pub bottom: ::std::os::raw::c_int,
    pub layout: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_NPatchInfo() {
    assert_eq!(
        ::std::mem::size_of::<NPatchInfo>(),
        36usize,
        concat!("Size of: ", stringify!(NPatchInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<NPatchInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(NPatchInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NPatchInfo>())).source as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(NPatchInfo),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NPatchInfo>())).left as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(NPatchInfo),
            "::",
            stringify!(left)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NPatchInfo>())).top as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(NPatchInfo),
            "::",
            stringify!(top)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NPatchInfo>())).right as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(NPatchInfo),
            "::",
            stringify!(right)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NPatchInfo>())).bottom as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(NPatchInfo),
            "::",
            stringify!(bottom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NPatchInfo>())).layout as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(NPatchInfo),
            "::",
            stringify!(layout)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CharInfo {
    pub value: ::std::os::raw::c_int,
    pub offsetX: ::std::os::raw::c_int,
    pub offsetY: ::std::os::raw::c_int,
    pub advanceX: ::std::os::raw::c_int,
    pub image: Image,
}
#[test]
fn bindgen_test_layout_CharInfo() {
    assert_eq!(
        ::std::mem::size_of::<CharInfo>(),
        40usize,
        concat!("Size of: ", stringify!(CharInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<CharInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(CharInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CharInfo>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CharInfo),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CharInfo>())).offsetX as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(CharInfo),
            "::",
            stringify!(offsetX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CharInfo>())).offsetY as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CharInfo),
            "::",
            stringify!(offsetY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CharInfo>())).advanceX as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(CharInfo),
            "::",
            stringify!(advanceX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CharInfo>())).image as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(CharInfo),
            "::",
            stringify!(image)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Font {
    pub baseSize: ::std::os::raw::c_int,
    pub charsCount: ::std::os::raw::c_int,
    pub charsPadding: ::std::os::raw::c_int,
    pub texture: Texture2D,
    pub recs: *mut Rectangle,
    pub chars: *mut CharInfo,
}
#[test]
fn bindgen_test_layout_Font() {
    assert_eq!(
        ::std::mem::size_of::<Font>(),
        48usize,
        concat!("Size of: ", stringify!(Font))
    );
    assert_eq!(
        ::std::mem::align_of::<Font>(),
        8usize,
        concat!("Alignment of ", stringify!(Font))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Font>())).baseSize as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Font),
            "::",
            stringify!(baseSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Font>())).charsCount as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(Font),
            "::",
            stringify!(charsCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Font>())).charsPadding as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Font),
            "::",
            stringify!(charsPadding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Font>())).texture as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(Font),
            "::",
            stringify!(texture)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Font>())).recs as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(Font),
            "::",
            stringify!(recs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Font>())).chars as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(Font),
            "::",
            stringify!(chars)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Camera3D {
    pub position: Vector3,
    pub target: Vector3,
    pub up: Vector3,
    pub fovy: f32,
    pub projection: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_Camera3D() {
    assert_eq!(
        ::std::mem::size_of::<Camera3D>(),
        44usize,
        concat!("Size of: ", stringify!(Camera3D))
    );
    assert_eq!(
        ::std::mem::align_of::<Camera3D>(),
        4usize,
        concat!("Alignment of ", stringify!(Camera3D))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Camera3D>())).position as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Camera3D),
            "::",
            stringify!(position)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Camera3D>())).target as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(Camera3D),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Camera3D>())).up as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(Camera3D),
            "::",
            stringify!(up)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Camera3D>())).fovy as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(Camera3D),
            "::",
            stringify!(fovy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Camera3D>())).projection as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(Camera3D),
            "::",
            stringify!(projection)
        )
    );
}
pub type Camera = Camera3D;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Camera2D {
    pub offset: Vector2,
    pub target: Vector2,
    pub rotation: f32,
    pub zoom: f32,
}
#[test]
fn bindgen_test_layout_Camera2D() {
    assert_eq!(
        ::std::mem::size_of::<Camera2D>(),
        24usize,
        concat!("Size of: ", stringify!(Camera2D))
    );
    assert_eq!(
        ::std::mem::align_of::<Camera2D>(),
        4usize,
        concat!("Alignment of ", stringify!(Camera2D))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Camera2D>())).offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Camera2D),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Camera2D>())).target as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Camera2D),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Camera2D>())).rotation as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(Camera2D),
            "::",
            stringify!(rotation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Camera2D>())).zoom as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(Camera2D),
            "::",
            stringify!(zoom)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Mesh {
    pub vertexCount: ::std::os::raw::c_int,
    pub triangleCount: ::std::os::raw::c_int,
    pub vertices: *mut f32,
    pub texcoords: *mut f32,
    pub texcoords2: *mut f32,
    pub normals: *mut f32,
    pub tangents: *mut f32,
    pub colors: *mut ::std::os::raw::c_uchar,
    pub indices: *mut ::std::os::raw::c_ushort,
    pub animVertices: *mut f32,
    pub animNormals: *mut f32,
    pub boneIds: *mut ::std::os::raw::c_int,
    pub boneWeights: *mut f32,
    pub vaoId: ::std::os::raw::c_uint,
    pub vboId: *mut ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_Mesh() {
    assert_eq!(
        ::std::mem::size_of::<Mesh>(),
        112usize,
        concat!("Size of: ", stringify!(Mesh))
    );
    assert_eq!(
        ::std::mem::align_of::<Mesh>(),
        8usize,
        concat!("Alignment of ", stringify!(Mesh))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).vertexCount as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(vertexCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).triangleCount as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(triangleCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).vertices as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(vertices)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).texcoords as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(texcoords)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).texcoords2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(texcoords2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).normals as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(normals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).tangents as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(tangents)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).colors as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(colors)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).indices as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(indices)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).animVertices as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(animVertices)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).animNormals as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(animNormals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).boneIds as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(boneIds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).boneWeights as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(boneWeights)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).vaoId as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(vaoId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Mesh>())).vboId as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(Mesh),
            "::",
            stringify!(vboId)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Shader {
    pub id: ::std::os::raw::c_uint,
    pub locs: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_Shader() {
    assert_eq!(
        ::std::mem::size_of::<Shader>(),
        16usize,
        concat!("Size of: ", stringify!(Shader))
    );
    assert_eq!(
        ::std::mem::align_of::<Shader>(),
        8usize,
        concat!("Alignment of ", stringify!(Shader))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Shader>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Shader),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Shader>())).locs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Shader),
            "::",
            stringify!(locs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MaterialMap {
    pub texture: Texture2D,
    pub color: Color,
    pub value: f32,
}
#[test]
fn bindgen_test_layout_MaterialMap() {
    assert_eq!(
        ::std::mem::size_of::<MaterialMap>(),
        28usize,
        concat!("Size of: ", stringify!(MaterialMap))
    );
    assert_eq!(
        ::std::mem::align_of::<MaterialMap>(),
        4usize,
        concat!("Alignment of ", stringify!(MaterialMap))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<MaterialMap>())).texture as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MaterialMap),
            "::",
            stringify!(texture)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<MaterialMap>())).color as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(MaterialMap),
            "::",
            stringify!(color)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<MaterialMap>())).value as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(MaterialMap),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Material {
    pub shader: Shader,
    pub maps: *mut MaterialMap,
    pub params: [f32; 4usize],
}
#[test]
fn bindgen_test_layout_Material() {
    assert_eq!(
        ::std::mem::size_of::<Material>(),
        40usize,
        concat!("Size of: ", stringify!(Material))
    );
    assert_eq!(
        ::std::mem::align_of::<Material>(),
        8usize,
        concat!("Alignment of ", stringify!(Material))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Material>())).shader as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Material),
            "::",
            stringify!(shader)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Material>())).maps as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(Material),
            "::",
            stringify!(maps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Material>())).params as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(Material),
            "::",
            stringify!(params)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Transform {
    pub translation: Vector3,
    pub rotation: Quaternion,
    pub scale: Vector3,
}
#[test]
fn bindgen_test_layout_Transform() {
    assert_eq!(
        ::std::mem::size_of::<Transform>(),
        40usize,
        concat!("Size of: ", stringify!(Transform))
    );
    assert_eq!(
        ::std::mem::align_of::<Transform>(),
        4usize,
        concat!("Alignment of ", stringify!(Transform))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Transform>())).translation as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Transform),
            "::",
            stringify!(translation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Transform>())).rotation as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(Transform),
            "::",
            stringify!(rotation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Transform>())).scale as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(Transform),
            "::",
            stringify!(scale)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BoneInfo {
    pub name: [::std::os::raw::c_char; 32usize],
    pub parent: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_BoneInfo() {
    assert_eq!(
        ::std::mem::size_of::<BoneInfo>(),
        36usize,
        concat!("Size of: ", stringify!(BoneInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<BoneInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(BoneInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BoneInfo>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BoneInfo),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BoneInfo>())).parent as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(BoneInfo),
            "::",
            stringify!(parent)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Model {
    pub transform: Matrix,
    pub meshCount: ::std::os::raw::c_int,
    pub materialCount: ::std::os::raw::c_int,
    pub meshes: *mut Mesh,
    pub materials: *mut Material,
    pub meshMaterial: *mut ::std::os::raw::c_int,
    pub boneCount: ::std::os::raw::c_int,
    pub bones: *mut BoneInfo,
    pub bindPose: *mut Transform,
}
#[test]
fn bindgen_test_layout_Model() {
    assert_eq!(
        ::std::mem::size_of::<Model>(),
        120usize,
        concat!("Size of: ", stringify!(Model))
    );
    assert_eq!(
        ::std::mem::align_of::<Model>(),
        8usize,
        concat!("Alignment of ", stringify!(Model))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Model>())).transform as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Model),
            "::",
            stringify!(transform)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Model>())).meshCount as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(Model),
            "::",
            stringify!(meshCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Model>())).materialCount as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(Model),
            "::",
            stringify!(materialCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Model>())).meshes as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(Model),
            "::",
            stringify!(meshes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Model>())).materials as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(Model),
            "::",
            stringify!(materials)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Model>())).meshMaterial as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(Model),
            "::",
            stringify!(meshMaterial)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Model>())).boneCount as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(Model),
            "::",
            stringify!(boneCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Model>())).bones as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(Model),
            "::",
            stringify!(bones)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Model>())).bindPose as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(Model),
            "::",
            stringify!(bindPose)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModelAnimation {
    pub boneCount: ::std::os::raw::c_int,
    pub frameCount: ::std::os::raw::c_int,
    pub bones: *mut BoneInfo,
    pub framePoses: *mut *mut Transform,
}
#[test]
fn bindgen_test_layout_ModelAnimation() {
    assert_eq!(
        ::std::mem::size_of::<ModelAnimation>(),
        24usize,
        concat!("Size of: ", stringify!(ModelAnimation))
    );
    assert_eq!(
        ::std::mem::align_of::<ModelAnimation>(),
        8usize,
        concat!("Alignment of ", stringify!(ModelAnimation))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ModelAnimation>())).boneCount as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ModelAnimation),
            "::",
            stringify!(boneCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ModelAnimation>())).frameCount as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ModelAnimation),
            "::",
            stringify!(frameCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ModelAnimation>())).bones as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ModelAnimation),
            "::",
            stringify!(bones)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ModelAnimation>())).framePoses as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ModelAnimation),
            "::",
            stringify!(framePoses)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Ray {
    pub position: Vector3,
    pub direction: Vector3,
}
#[test]
fn bindgen_test_layout_Ray() {
    assert_eq!(
        ::std::mem::size_of::<Ray>(),
        24usize,
        concat!("Size of: ", stringify!(Ray))
    );
    assert_eq!(
        ::std::mem::align_of::<Ray>(),
        4usize,
        concat!("Alignment of ", stringify!(Ray))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Ray>())).position as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Ray),
            "::",
            stringify!(position)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Ray>())).direction as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(Ray),
            "::",
            stringify!(direction)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RayHitInfo {
    pub hit: bool,
    pub distance: f32,
    pub position: Vector3,
    pub normal: Vector3,
}
#[test]
fn bindgen_test_layout_RayHitInfo() {
    assert_eq!(
        ::std::mem::size_of::<RayHitInfo>(),
        32usize,
        concat!("Size of: ", stringify!(RayHitInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<RayHitInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(RayHitInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RayHitInfo>())).hit as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RayHitInfo),
            "::",
            stringify!(hit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RayHitInfo>())).distance as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RayHitInfo),
            "::",
            stringify!(distance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RayHitInfo>())).position as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RayHitInfo),
            "::",
            stringify!(position)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RayHitInfo>())).normal as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(RayHitInfo),
            "::",
            stringify!(normal)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BoundingBox {
    pub min: Vector3,
    pub max: Vector3,
}
#[test]
fn bindgen_test_layout_BoundingBox() {
    assert_eq!(
        ::std::mem::size_of::<BoundingBox>(),
        24usize,
        concat!("Size of: ", stringify!(BoundingBox))
    );
    assert_eq!(
        ::std::mem::align_of::<BoundingBox>(),
        4usize,
        concat!("Alignment of ", stringify!(BoundingBox))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BoundingBox>())).min as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BoundingBox),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BoundingBox>())).max as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(BoundingBox),
            "::",
            stringify!(max)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Wave {
    pub sampleCount: ::std::os::raw::c_uint,
    pub sampleRate: ::std::os::raw::c_uint,
    pub sampleSize: ::std::os::raw::c_uint,
    pub channels: ::std::os::raw::c_uint,
    pub data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_Wave() {
    assert_eq!(
        ::std::mem::size_of::<Wave>(),
        24usize,
        concat!("Size of: ", stringify!(Wave))
    );
    assert_eq!(
        ::std::mem::align_of::<Wave>(),
        8usize,
        concat!("Alignment of ", stringify!(Wave))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Wave>())).sampleCount as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Wave),
            "::",
            stringify!(sampleCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Wave>())).sampleRate as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(Wave),
            "::",
            stringify!(sampleRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Wave>())).sampleSize as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Wave),
            "::",
            stringify!(sampleSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Wave>())).channels as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(Wave),
            "::",
            stringify!(channels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Wave>())).data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(Wave),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rAudioBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AudioStream {
    pub buffer: *mut rAudioBuffer,
    pub sampleRate: ::std::os::raw::c_uint,
    pub sampleSize: ::std::os::raw::c_uint,
    pub channels: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_AudioStream() {
    assert_eq!(
        ::std::mem::size_of::<AudioStream>(),
        24usize,
        concat!("Size of: ", stringify!(AudioStream))
    );
    assert_eq!(
        ::std::mem::align_of::<AudioStream>(),
        8usize,
        concat!("Alignment of ", stringify!(AudioStream))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AudioStream>())).buffer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AudioStream),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AudioStream>())).sampleRate as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AudioStream),
            "::",
            stringify!(sampleRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AudioStream>())).sampleSize as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AudioStream),
            "::",
            stringify!(sampleSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AudioStream>())).channels as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AudioStream),
            "::",
            stringify!(channels)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sound {
    pub stream: AudioStream,
    pub sampleCount: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_Sound() {
    assert_eq!(
        ::std::mem::size_of::<Sound>(),
        32usize,
        concat!("Size of: ", stringify!(Sound))
    );
    assert_eq!(
        ::std::mem::align_of::<Sound>(),
        8usize,
        concat!("Alignment of ", stringify!(Sound))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Sound>())).stream as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Sound),
            "::",
            stringify!(stream)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Sound>())).sampleCount as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(Sound),
            "::",
            stringify!(sampleCount)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Music {
    pub stream: AudioStream,
    pub sampleCount: ::std::os::raw::c_uint,
    pub looping: bool,
    pub ctxType: ::std::os::raw::c_int,
    pub ctxData: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_Music() {
    assert_eq!(
        ::std::mem::size_of::<Music>(),
        48usize,
        concat!("Size of: ", stringify!(Music))
    );
    assert_eq!(
        ::std::mem::align_of::<Music>(),
        8usize,
        concat!("Alignment of ", stringify!(Music))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Music>())).stream as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Music),
            "::",
            stringify!(stream)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Music>())).sampleCount as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(Music),
            "::",
            stringify!(sampleCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Music>())).looping as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(Music),
            "::",
            stringify!(looping)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Music>())).ctxType as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(Music),
            "::",
            stringify!(ctxType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Music>())).ctxData as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(Music),
            "::",
            stringify!(ctxData)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VrDeviceInfo {
    pub hResolution: ::std::os::raw::c_int,
    pub vResolution: ::std::os::raw::c_int,
    pub hScreenSize: f32,
    pub vScreenSize: f32,
    pub vScreenCenter: f32,
    pub eyeToScreenDistance: f32,
    pub lensSeparationDistance: f32,
    pub interpupillaryDistance: f32,
    pub lensDistortionValues: [f32; 4usize],
    pub chromaAbCorrection: [f32; 4usize],
}
#[test]
fn bindgen_test_layout_VrDeviceInfo() {
    assert_eq!(
        ::std::mem::size_of::<VrDeviceInfo>(),
        64usize,
        concat!("Size of: ", stringify!(VrDeviceInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VrDeviceInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(VrDeviceInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrDeviceInfo>())).hResolution as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VrDeviceInfo),
            "::",
            stringify!(hResolution)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrDeviceInfo>())).vResolution as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VrDeviceInfo),
            "::",
            stringify!(vResolution)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrDeviceInfo>())).hScreenSize as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VrDeviceInfo),
            "::",
            stringify!(hScreenSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrDeviceInfo>())).vScreenSize as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VrDeviceInfo),
            "::",
            stringify!(vScreenSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrDeviceInfo>())).vScreenCenter as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VrDeviceInfo),
            "::",
            stringify!(vScreenCenter)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VrDeviceInfo>())).eyeToScreenDistance as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VrDeviceInfo),
            "::",
            stringify!(eyeToScreenDistance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VrDeviceInfo>())).lensSeparationDistance as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VrDeviceInfo),
            "::",
            stringify!(lensSeparationDistance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VrDeviceInfo>())).interpupillaryDistance as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VrDeviceInfo),
            "::",
            stringify!(interpupillaryDistance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VrDeviceInfo>())).lensDistortionValues as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VrDeviceInfo),
            "::",
            stringify!(lensDistortionValues)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrDeviceInfo>())).chromaAbCorrection as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VrDeviceInfo),
            "::",
            stringify!(chromaAbCorrection)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VrStereoConfig {
    pub projection: [Matrix; 2usize],
    pub viewOffset: [Matrix; 2usize],
    pub leftLensCenter: [f32; 2usize],
    pub rightLensCenter: [f32; 2usize],
    pub leftScreenCenter: [f32; 2usize],
    pub rightScreenCenter: [f32; 2usize],
    pub scale: [f32; 2usize],
    pub scaleIn: [f32; 2usize],
}
#[test]
fn bindgen_test_layout_VrStereoConfig() {
    assert_eq!(
        ::std::mem::size_of::<VrStereoConfig>(),
        304usize,
        concat!("Size of: ", stringify!(VrStereoConfig))
    );
    assert_eq!(
        ::std::mem::align_of::<VrStereoConfig>(),
        4usize,
        concat!("Alignment of ", stringify!(VrStereoConfig))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrStereoConfig>())).projection as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VrStereoConfig),
            "::",
            stringify!(projection)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrStereoConfig>())).viewOffset as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(VrStereoConfig),
            "::",
            stringify!(viewOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrStereoConfig>())).leftLensCenter as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(VrStereoConfig),
            "::",
            stringify!(leftLensCenter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrStereoConfig>())).rightLensCenter as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(VrStereoConfig),
            "::",
            stringify!(rightLensCenter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrStereoConfig>())).leftScreenCenter as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(VrStereoConfig),
            "::",
            stringify!(leftScreenCenter)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VrStereoConfig>())).rightScreenCenter as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(VrStereoConfig),
            "::",
            stringify!(rightScreenCenter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrStereoConfig>())).scale as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(VrStereoConfig),
            "::",
            stringify!(scale)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VrStereoConfig>())).scaleIn as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(VrStereoConfig),
            "::",
            stringify!(scaleIn)
        )
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ConfigFlags {
    FLAG_VSYNC_HINT = 64,
    FLAG_FULLSCREEN_MODE = 2,
    FLAG_WINDOW_RESIZABLE = 4,
    FLAG_WINDOW_UNDECORATED = 8,
    FLAG_WINDOW_HIDDEN = 128,
    FLAG_WINDOW_MINIMIZED = 512,
    FLAG_WINDOW_MAXIMIZED = 1024,
    FLAG_WINDOW_UNFOCUSED = 2048,
    FLAG_WINDOW_TOPMOST = 4096,
    FLAG_WINDOW_ALWAYS_RUN = 256,
    FLAG_WINDOW_TRANSPARENT = 16,
    FLAG_WINDOW_HIGHDPI = 8192,
    FLAG_MSAA_4X_HINT = 32,
    FLAG_INTERLACED_HINT = 65536,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum TraceLogLevel {
    LOG_ALL = 0,
    LOG_TRACE = 1,
    LOG_DEBUG = 2,
    LOG_INFO = 3,
    LOG_WARNING = 4,
    LOG_ERROR = 5,
    LOG_FATAL = 6,
    LOG_NONE = 7,
}
impl KeyboardKey {
    pub const KEY_MENU: KeyboardKey = KeyboardKey::KEY_R;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum KeyboardKey {
    KEY_NULL = 0,
    KEY_APOSTROPHE = 39,
    KEY_COMMA = 44,
    KEY_MINUS = 45,
    KEY_PERIOD = 46,
    KEY_SLASH = 47,
    KEY_ZERO = 48,
    KEY_ONE = 49,
    KEY_TWO = 50,
    KEY_THREE = 51,
    KEY_FOUR = 52,
    KEY_FIVE = 53,
    KEY_SIX = 54,
    KEY_SEVEN = 55,
    KEY_EIGHT = 56,
    KEY_NINE = 57,
    KEY_SEMICOLON = 59,
    KEY_EQUAL = 61,
    KEY_A = 65,
    KEY_B = 66,
    KEY_C = 67,
    KEY_D = 68,
    KEY_E = 69,
    KEY_F = 70,
    KEY_G = 71,
    KEY_H = 72,
    KEY_I = 73,
    KEY_J = 74,
    KEY_K = 75,
    KEY_L = 76,
    KEY_M = 77,
    KEY_N = 78,
    KEY_O = 79,
    KEY_P = 80,
    KEY_Q = 81,
    KEY_R = 82,
    KEY_S = 83,
    KEY_T = 84,
    KEY_U = 85,
    KEY_V = 86,
    KEY_W = 87,
    KEY_X = 88,
    KEY_Y = 89,
    KEY_Z = 90,
    KEY_SPACE = 32,
    KEY_ESCAPE = 256,
    KEY_ENTER = 257,
    KEY_TAB = 258,
    KEY_BACKSPACE = 259,
    KEY_INSERT = 260,
    KEY_DELETE = 261,
    KEY_RIGHT = 262,
    KEY_LEFT = 263,
    KEY_DOWN = 264,
    KEY_UP = 265,
    KEY_PAGE_UP = 266,
    KEY_PAGE_DOWN = 267,
    KEY_HOME = 268,
    KEY_END = 269,
    KEY_CAPS_LOCK = 280,
    KEY_SCROLL_LOCK = 281,
    KEY_NUM_LOCK = 282,
    KEY_PRINT_SCREEN = 283,
    KEY_PAUSE = 284,
    KEY_F1 = 290,
    KEY_F2 = 291,
    KEY_F3 = 292,
    KEY_F4 = 293,
    KEY_F5 = 294,
    KEY_F6 = 295,
    KEY_F7 = 296,
    KEY_F8 = 297,
    KEY_F9 = 298,
    KEY_F10 = 299,
    KEY_F11 = 300,
    KEY_F12 = 301,
    KEY_LEFT_SHIFT = 340,
    KEY_LEFT_CONTROL = 341,
    KEY_LEFT_ALT = 342,
    KEY_LEFT_SUPER = 343,
    KEY_RIGHT_SHIFT = 344,
    KEY_RIGHT_CONTROL = 345,
    KEY_RIGHT_ALT = 346,
    KEY_RIGHT_SUPER = 347,
    KEY_KB_MENU = 348,
    KEY_LEFT_BRACKET = 91,
    KEY_BACKSLASH = 92,
    KEY_RIGHT_BRACKET = 93,
    KEY_GRAVE = 96,
    KEY_KP_0 = 320,
    KEY_KP_1 = 321,
    KEY_KP_2 = 322,
    KEY_KP_3 = 323,
    KEY_KP_4 = 324,
    KEY_KP_5 = 325,
    KEY_KP_6 = 326,
    KEY_KP_7 = 327,
    KEY_KP_8 = 328,
    KEY_KP_9 = 329,
    KEY_KP_DECIMAL = 330,
    KEY_KP_DIVIDE = 331,
    KEY_KP_MULTIPLY = 332,
    KEY_KP_SUBTRACT = 333,
    KEY_KP_ADD = 334,
    KEY_KP_ENTER = 335,
    KEY_KP_EQUAL = 336,
    KEY_BACK = 4,
    KEY_VOLUME_UP = 24,
    KEY_VOLUME_DOWN = 25,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MouseButton {
    MOUSE_LEFT_BUTTON = 0,
    MOUSE_RIGHT_BUTTON = 1,
    MOUSE_MIDDLE_BUTTON = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MouseCursor {
    MOUSE_CURSOR_DEFAULT = 0,
    MOUSE_CURSOR_ARROW = 1,
    MOUSE_CURSOR_IBEAM = 2,
    MOUSE_CURSOR_CROSSHAIR = 3,
    MOUSE_CURSOR_POINTING_HAND = 4,
    MOUSE_CURSOR_RESIZE_EW = 5,
    MOUSE_CURSOR_RESIZE_NS = 6,
    MOUSE_CURSOR_RESIZE_NWSE = 7,
    MOUSE_CURSOR_RESIZE_NESW = 8,
    MOUSE_CURSOR_RESIZE_ALL = 9,
    MOUSE_CURSOR_NOT_ALLOWED = 10,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GamepadButton {
    GAMEPAD_BUTTON_UNKNOWN = 0,
    GAMEPAD_BUTTON_LEFT_FACE_UP = 1,
    GAMEPAD_BUTTON_LEFT_FACE_RIGHT = 2,
    GAMEPAD_BUTTON_LEFT_FACE_DOWN = 3,
    GAMEPAD_BUTTON_LEFT_FACE_LEFT = 4,
    GAMEPAD_BUTTON_RIGHT_FACE_UP = 5,
    GAMEPAD_BUTTON_RIGHT_FACE_RIGHT = 6,
    GAMEPAD_BUTTON_RIGHT_FACE_DOWN = 7,
    GAMEPAD_BUTTON_RIGHT_FACE_LEFT = 8,
    GAMEPAD_BUTTON_LEFT_TRIGGER_1 = 9,
    GAMEPAD_BUTTON_LEFT_TRIGGER_2 = 10,
    GAMEPAD_BUTTON_RIGHT_TRIGGER_1 = 11,
    GAMEPAD_BUTTON_RIGHT_TRIGGER_2 = 12,
    GAMEPAD_BUTTON_MIDDLE_LEFT = 13,
    GAMEPAD_BUTTON_MIDDLE = 14,
    GAMEPAD_BUTTON_MIDDLE_RIGHT = 15,
    GAMEPAD_BUTTON_LEFT_THUMB = 16,
    GAMEPAD_BUTTON_RIGHT_THUMB = 17,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GamepadAxis {
    GAMEPAD_AXIS_LEFT_X = 0,
    GAMEPAD_AXIS_LEFT_Y = 1,
    GAMEPAD_AXIS_RIGHT_X = 2,
    GAMEPAD_AXIS_RIGHT_Y = 3,
    GAMEPAD_AXIS_LEFT_TRIGGER = 4,
    GAMEPAD_AXIS_RIGHT_TRIGGER = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MaterialMapIndex {
    MATERIAL_MAP_ALBEDO = 0,
    MATERIAL_MAP_METALNESS = 1,
    MATERIAL_MAP_NORMAL = 2,
    MATERIAL_MAP_ROUGHNESS = 3,
    MATERIAL_MAP_OCCLUSION = 4,
    MATERIAL_MAP_EMISSION = 5,
    MATERIAL_MAP_HEIGHT = 6,
    MATERIAL_MAP_BRDG = 7,
    MATERIAL_MAP_CUBEMAP = 8,
    MATERIAL_MAP_IRRADIANCE = 9,
    MATERIAL_MAP_PREFILTER = 10,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ShaderLocationIndex {
    SHADER_LOC_VERTEX_POSITION = 0,
    SHADER_LOC_VERTEX_TEXCOORD01 = 1,
    SHADER_LOC_VERTEX_TEXCOORD02 = 2,
    SHADER_LOC_VERTEX_NORMAL = 3,
    SHADER_LOC_VERTEX_TANGENT = 4,
    SHADER_LOC_VERTEX_COLOR = 5,
    SHADER_LOC_MATRIX_MVP = 6,
    SHADER_LOC_MATRIX_VIEW = 7,
    SHADER_LOC_MATRIX_PROJECTION = 8,
    SHADER_LOC_MATRIX_MODEL = 9,
    SHADER_LOC_MATRIX_NORMAL = 10,
    SHADER_LOC_VECTOR_VIEW = 11,
    SHADER_LOC_COLOR_DIFFUSE = 12,
    SHADER_LOC_COLOR_SPECULAR = 13,
    SHADER_LOC_COLOR_AMBIENT = 14,
    SHADER_LOC_MAP_ALBEDO = 15,
    SHADER_LOC_MAP_METALNESS = 16,
    SHADER_LOC_MAP_NORMAL = 17,
    SHADER_LOC_MAP_ROUGHNESS = 18,
    SHADER_LOC_MAP_OCCLUSION = 19,
    SHADER_LOC_MAP_EMISSION = 20,
    SHADER_LOC_MAP_HEIGHT = 21,
    SHADER_LOC_MAP_CUBEMAP = 22,
    SHADER_LOC_MAP_IRRADIANCE = 23,
    SHADER_LOC_MAP_PREFILTER = 24,
    SHADER_LOC_MAP_BRDF = 25,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ShaderUniformDataType {
    SHADER_UNIFORM_FLOAT = 0,
    SHADER_UNIFORM_VEC2 = 1,
    SHADER_UNIFORM_VEC3 = 2,
    SHADER_UNIFORM_VEC4 = 3,
    SHADER_UNIFORM_INT = 4,
    SHADER_UNIFORM_IVEC2 = 5,
    SHADER_UNIFORM_IVEC3 = 6,
    SHADER_UNIFORM_IVEC4 = 7,
    SHADER_UNIFORM_SAMPLER2D = 8,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum PixelFormat {
    PIXELFORMAT_UNCOMPRESSED_GRAYSCALE = 1,
    PIXELFORMAT_UNCOMPRESSED_GRAY_ALPHA = 2,
    PIXELFORMAT_UNCOMPRESSED_R5G6B5 = 3,
    PIXELFORMAT_UNCOMPRESSED_R8G8B8 = 4,
    PIXELFORMAT_UNCOMPRESSED_R5G5B5A1 = 5,
    PIXELFORMAT_UNCOMPRESSED_R4G4B4A4 = 6,
    PIXELFORMAT_PIXELFORMAT_UNCOMPRESSED_R8G8B8A8 = 7,
    PIXELFORMAT_UNCOMPRESSED_R32 = 8,
    PIXELFORMAT_UNCOMPRESSED_R32G32B32 = 9,
    PIXELFORMAT_UNCOMPRESSED_R32G32B32A32 = 10,
    PIXELFORMAT_COMPRESSED_DXT1_RGB = 11,
    PIXELFORMAT_COMPRESSED_DXT1_RGBA = 12,
    PIXELFORMAT_COMPRESSED_DXT3_RGBA = 13,
    PIXELFORMAT_COMPRESSED_DXT5_RGBA = 14,
    PIXELFORMAT_COMPRESSED_ETC1_RGB = 15,
    PIXELFORMAT_COMPRESSED_ETC2_RGB = 16,
    PIXELFORMAT_COMPRESSED_ETC2_EAC_RGBA = 17,
    PIXELFORMAT_COMPRESSED_PVRT_RGB = 18,
    PIXELFORMAT_COMPRESSED_PVRT_RGBA = 19,
    PIXELFORMAT_COMPRESSED_ASTC_4x4_RGBA = 20,
    PIXELFORMAT_COMPRESSED_ASTC_8x8_RGBA = 21,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum TextureFilter {
    TEXTURE_FILTER_POINT = 0,
    TEXTURE_FILTER_BILINEAR = 1,
    TEXTURE_FILTER_TRILINEAR = 2,
    TEXTURE_FILTER_ANISOTROPIC_4X = 3,
    TEXTURE_FILTER_ANISOTROPIC_8X = 4,
    TEXTURE_FILTER_ANISOTROPIC_16X = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum TextureWrap {
    TEXTURE_WRAP_REPEAT = 0,
    TEXTURE_WRAP_CLAMP = 1,
    TEXTURE_WRAP_MIRROR_REPEAT = 2,
    TEXTURE_WRAP_MIRROR_CLAMP = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum CubemapLayout {
    CUBEMAP_LAYOUT_AUTO_DETECT = 0,
    CUBEMAP_LAYOUT_LINE_VERTICAL = 1,
    CUBEMAP_LAYOUT_LINE_HORIZONTAL = 2,
    CUBEMAP_LAYOUT_CROSS_THREE_BY_FOUR = 3,
    CUBEMAP_LAYOUT_CROSS_FOUR_BY_THREE = 4,
    CUBEMAP_LAYOUT_PANORAMA = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum FontType {
    FONT_DEFAULT = 0,
    FONT_BITMAP = 1,
    FONT_SDF = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum BlendMode {
    BLEND_ALPHA = 0,
    BLEND_ADDITIVE = 1,
    BLEND_MULTIPLIED = 2,
    BLEND_ADD_COLORS = 3,
    BLEND_SUBTRACT_COLORS = 4,
    BLEND_CUSTOM = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Gestures {
    GESTURE_NONE = 0,
    GESTURE_TAP = 1,
    GESTURE_DOUBLETAP = 2,
    GESTURE_HOLD = 4,
    GESTURE_DRAG = 8,
    GESTURE_SWIPE_RIGHT = 16,
    GESTURE_SWIPE_LEFT = 32,
    GESTURE_SWIPE_UP = 64,
    GESTURE_SWIPE_DOWN = 128,
    GESTURE_PINCH_IN = 256,
    GESTURE_PINCH_OUT = 512,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum CameraMode {
    CAMERA_CUSTOM = 0,
    CAMERA_FREE = 1,
    CAMERA_ORBITAL = 2,
    CAMERA_FIRST_PERSON = 3,
    CAMERA_THIRD_PERSON = 4,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum CameraProjection {
    CAMERA_PERSPECTIVE = 0,
    CAMERA_ORTHOGRAPHIC = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum NPatchLayout {
    NPATCH_NINE_PATCH = 0,
    NPATCH_THREE_PATCH_VERTICAL = 1,
    NPATCH_THREE_PATCH_HORIZONTAL = 2,
}
pub type TraceLogCallback = ::std::option::Option<
    unsafe extern "C" fn(
        logLevel: ::std::os::raw::c_int,
        text: *const ::std::os::raw::c_char,
        args: *mut __va_list_tag,
    ),
>;
pub type LoadFileDataCallback = ::std::option::Option<
    unsafe extern "C" fn(
        fileName: *const ::std::os::raw::c_char,
        bytesRead: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_uchar,
>;
pub type SaveFileDataCallback = ::std::option::Option<
    unsafe extern "C" fn(
        fileName: *const ::std::os::raw::c_char,
        data: *mut ::std::os::raw::c_void,
        bytesToWrite: ::std::os::raw::c_uint,
    ) -> bool,
>;
pub type LoadFileTextCallback = ::std::option::Option<
    unsafe extern "C" fn(fileName: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char,
>;
pub type SaveFileTextCallback = ::std::option::Option<
    unsafe extern "C" fn(
        fileName: *const ::std::os::raw::c_char,
        text: *mut ::std::os::raw::c_char,
    ) -> bool,
>;
extern "C" {
    pub fn InitWindow(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        title: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn WindowShouldClose() -> bool;
}
extern "C" {
    pub fn CloseWindow();
}
extern "C" {
    pub fn IsWindowReady() -> bool;
}
extern "C" {
    pub fn IsWindowFullscreen() -> bool;
}
extern "C" {
    pub fn IsWindowHidden() -> bool;
}
extern "C" {
    pub fn IsWindowMinimized() -> bool;
}
extern "C" {
    pub fn IsWindowMaximized() -> bool;
}
extern "C" {
    pub fn IsWindowFocused() -> bool;
}
extern "C" {
    pub fn IsWindowResized() -> bool;
}
extern "C" {
    pub fn IsWindowState(flag: ::std::os::raw::c_uint) -> bool;
}
extern "C" {
    pub fn SetWindowState(flags: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn ClearWindowState(flags: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn ToggleFullscreen();
}
extern "C" {
    pub fn MaximizeWindow();
}
extern "C" {
    pub fn MinimizeWindow();
}
extern "C" {
    pub fn RestoreWindow();
}
extern "C" {
    pub fn SetWindowIcon(image: Image);
}
extern "C" {
    pub fn SetWindowTitle(title: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn SetWindowPosition(x: ::std::os::raw::c_int, y: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SetWindowMonitor(monitor: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SetWindowMinSize(width: ::std::os::raw::c_int, height: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SetWindowSize(width: ::std::os::raw::c_int, height: ::std::os::raw::c_int);
}
extern "C" {
    pub fn GetWindowHandle() -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn GetScreenWidth() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetScreenHeight() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetMonitorCount() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetCurrentMonitor() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetMonitorPosition(monitor: ::std::os::raw::c_int) -> Vector2;
}
extern "C" {
    pub fn GetMonitorWidth(monitor: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetMonitorHeight(monitor: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetMonitorPhysicalWidth(monitor: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetMonitorPhysicalHeight(monitor: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetMonitorRefreshRate(monitor: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetWindowPosition() -> Vector2;
}
extern "C" {
    pub fn GetWindowScaleDPI() -> Vector2;
}
extern "C" {
    pub fn GetMonitorName(monitor: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SetClipboardText(text: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn GetClipboardText() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn ShowCursor();
}
extern "C" {
    pub fn HideCursor();
}
extern "C" {
    pub fn IsCursorHidden() -> bool;
}
extern "C" {
    pub fn EnableCursor();
}
extern "C" {
    pub fn DisableCursor();
}
extern "C" {
    pub fn IsCursorOnScreen() -> bool;
}
extern "C" {
    pub fn ClearBackground(color: Color);
}
extern "C" {
    pub fn BeginDrawing();
}
extern "C" {
    pub fn EndDrawing();
}
extern "C" {
    pub fn BeginMode2D(camera: Camera2D);
}
extern "C" {
    pub fn EndMode2D();
}
extern "C" {
    pub fn BeginMode3D(camera: Camera3D);
}
extern "C" {
    pub fn EndMode3D();
}
extern "C" {
    pub fn BeginTextureMode(target: RenderTexture2D);
}
extern "C" {
    pub fn EndTextureMode();
}
extern "C" {
    pub fn BeginShaderMode(shader: Shader);
}
extern "C" {
    pub fn EndShaderMode();
}
extern "C" {
    pub fn BeginBlendMode(mode: ::std::os::raw::c_int);
}
extern "C" {
    pub fn EndBlendMode();
}
extern "C" {
    pub fn BeginScissorMode(
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn EndScissorMode();
}
extern "C" {
    pub fn BeginVrStereoMode(config: VrStereoConfig);
}
extern "C" {
    pub fn EndVrStereoMode();
}
extern "C" {
    pub fn LoadVrStereoConfig(device: VrDeviceInfo) -> VrStereoConfig;
}
extern "C" {
    pub fn UnloadVrStereoConfig(config: VrStereoConfig);
}
extern "C" {
    pub fn LoadShader(
        vsFileName: *const ::std::os::raw::c_char,
        fsFileName: *const ::std::os::raw::c_char,
    ) -> Shader;
}
extern "C" {
    pub fn LoadShaderFromMemory(
        vsCode: *const ::std::os::raw::c_char,
        fsCode: *const ::std::os::raw::c_char,
    ) -> Shader;
}
extern "C" {
    pub fn GetShaderLocation(
        shader: Shader,
        uniformName: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetShaderLocationAttrib(
        shader: Shader,
        attribName: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SetShaderValue(
        shader: Shader,
        locIndex: ::std::os::raw::c_int,
        value: *const ::std::os::raw::c_void,
        uniformType: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SetShaderValueV(
        shader: Shader,
        locIndex: ::std::os::raw::c_int,
        value: *const ::std::os::raw::c_void,
        uniformType: ::std::os::raw::c_int,
        count: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SetShaderValueMatrix(shader: Shader, locIndex: ::std::os::raw::c_int, mat: Matrix);
}
extern "C" {
    pub fn SetShaderValueTexture(
        shader: Shader,
        locIndex: ::std::os::raw::c_int,
        texture: Texture2D,
    );
}
extern "C" {
    pub fn UnloadShader(shader: Shader);
}
extern "C" {
    pub fn GetMouseRay(mousePosition: Vector2, camera: Camera) -> Ray;
}
extern "C" {
    pub fn GetCameraMatrix(camera: Camera) -> Matrix;
}
extern "C" {
    pub fn GetCameraMatrix2D(camera: Camera2D) -> Matrix;
}
extern "C" {
    pub fn GetWorldToScreen(position: Vector3, camera: Camera) -> Vector2;
}
extern "C" {
    pub fn GetWorldToScreenEx(
        position: Vector3,
        camera: Camera,
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
    ) -> Vector2;
}
extern "C" {
    pub fn GetWorldToScreen2D(position: Vector2, camera: Camera2D) -> Vector2;
}
extern "C" {
    pub fn GetScreenToWorld2D(position: Vector2, camera: Camera2D) -> Vector2;
}
extern "C" {
    pub fn SetTargetFPS(fps: ::std::os::raw::c_int);
}
extern "C" {
    pub fn GetFPS() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetFrameTime() -> f32;
}
extern "C" {
    pub fn GetTime() -> f64;
}
extern "C" {
    pub fn GetRandomValue(
        min: ::std::os::raw::c_int,
        max: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn TakeScreenshot(fileName: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn SetConfigFlags(flags: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn TraceLog(logLevel: ::std::os::raw::c_int, text: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn SetTraceLogLevel(logLevel: ::std::os::raw::c_int);
}
extern "C" {
    pub fn MemAlloc(size: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn MemRealloc(
        ptr: *mut ::std::os::raw::c_void,
        size: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn MemFree(ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn SetTraceLogCallback(callback: TraceLogCallback);
}
extern "C" {
    pub fn SetLoadFileDataCallback(callback: LoadFileDataCallback);
}
extern "C" {
    pub fn SetSaveFileDataCallback(callback: SaveFileDataCallback);
}
extern "C" {
    pub fn SetLoadFileTextCallback(callback: LoadFileTextCallback);
}
extern "C" {
    pub fn SetSaveFileTextCallback(callback: SaveFileTextCallback);
}
extern "C" {
    pub fn LoadFileData(
        fileName: *const ::std::os::raw::c_char,
        bytesRead: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn UnloadFileData(data: *mut ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn SaveFileData(
        fileName: *const ::std::os::raw::c_char,
        data: *mut ::std::os::raw::c_void,
        bytesToWrite: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn LoadFileText(fileName: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn UnloadFileText(text: *mut ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn SaveFileText(
        fileName: *const ::std::os::raw::c_char,
        text: *mut ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn FileExists(fileName: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn DirectoryExists(dirPath: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn IsFileExtension(
        fileName: *const ::std::os::raw::c_char,
        ext: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn GetFileExtension(
        fileName: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn GetFileName(filePath: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn GetFileNameWithoutExt(
        filePath: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn GetDirectoryPath(
        filePath: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn GetPrevDirectoryPath(
        dirPath: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn GetWorkingDirectory() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn GetDirectoryFiles(
        dirPath: *const ::std::os::raw::c_char,
        count: *mut ::std::os::raw::c_int,
    ) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ClearDirectoryFiles();
}
extern "C" {
    pub fn ChangeDirectory(dir: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn IsFileDropped() -> bool;
}
extern "C" {
    pub fn GetDroppedFiles(count: *mut ::std::os::raw::c_int) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ClearDroppedFiles();
}
extern "C" {
    pub fn GetFileModTime(fileName: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn CompressData(
        data: *mut ::std::os::raw::c_uchar,
        dataLength: ::std::os::raw::c_int,
        compDataLength: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn DecompressData(
        compData: *mut ::std::os::raw::c_uchar,
        compDataLength: ::std::os::raw::c_int,
        dataLength: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn SaveStorageValue(position: ::std::os::raw::c_uint, value: ::std::os::raw::c_int)
        -> bool;
}
extern "C" {
    pub fn LoadStorageValue(position: ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn OpenURL(url: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn IsKeyPressed(key: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn IsKeyDown(key: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn IsKeyReleased(key: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn IsKeyUp(key: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn SetExitKey(key: ::std::os::raw::c_int);
}
extern "C" {
    pub fn GetKeyPressed() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetCharPressed() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn IsGamepadAvailable(gamepad: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn IsGamepadName(
        gamepad: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn GetGamepadName(gamepad: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn IsGamepadButtonPressed(
        gamepad: ::std::os::raw::c_int,
        button: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn IsGamepadButtonDown(
        gamepad: ::std::os::raw::c_int,
        button: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn IsGamepadButtonReleased(
        gamepad: ::std::os::raw::c_int,
        button: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn IsGamepadButtonUp(gamepad: ::std::os::raw::c_int, button: ::std::os::raw::c_int)
        -> bool;
}
extern "C" {
    pub fn GetGamepadButtonPressed() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetGamepadAxisCount(gamepad: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetGamepadAxisMovement(
        gamepad: ::std::os::raw::c_int,
        axis: ::std::os::raw::c_int,
    ) -> f32;
}
extern "C" {
    pub fn SetGamepadMappings(mappings: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn IsMouseButtonPressed(button: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn IsMouseButtonDown(button: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn IsMouseButtonReleased(button: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn IsMouseButtonUp(button: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn GetMouseX() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetMouseY() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetMousePosition() -> Vector2;
}
extern "C" {
    pub fn SetMousePosition(x: ::std::os::raw::c_int, y: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SetMouseOffset(offsetX: ::std::os::raw::c_int, offsetY: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SetMouseScale(scaleX: f32, scaleY: f32);
}
extern "C" {
    pub fn GetMouseWheelMove() -> f32;
}
extern "C" {
    pub fn SetMouseCursor(cursor: ::std::os::raw::c_int);
}
extern "C" {
    pub fn GetTouchX() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetTouchY() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetTouchPosition(index: ::std::os::raw::c_int) -> Vector2;
}
extern "C" {
    pub fn SetGesturesEnabled(flags: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn IsGestureDetected(gesture: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    pub fn GetGestureDetected() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetTouchPointsCount() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetGestureHoldDuration() -> f32;
}
extern "C" {
    pub fn GetGestureDragVector() -> Vector2;
}
extern "C" {
    pub fn GetGestureDragAngle() -> f32;
}
extern "C" {
    pub fn GetGesturePinchVector() -> Vector2;
}
extern "C" {
    pub fn GetGesturePinchAngle() -> f32;
}
extern "C" {
    pub fn SetCameraMode(camera: Camera, mode: ::std::os::raw::c_int);
}
extern "C" {
    pub fn UpdateCamera(camera: *mut Camera);
}
extern "C" {
    pub fn SetCameraPanControl(keyPan: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SetCameraAltControl(keyAlt: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SetCameraSmoothZoomControl(keySmoothZoom: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SetCameraMoveControls(
        keyFront: ::std::os::raw::c_int,
        keyBack: ::std::os::raw::c_int,
        keyRight: ::std::os::raw::c_int,
        keyLeft: ::std::os::raw::c_int,
        keyUp: ::std::os::raw::c_int,
        keyDown: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SetShapesTexture(texture: Texture2D, source: Rectangle);
}
extern "C" {
    pub fn DrawPixel(posX: ::std::os::raw::c_int, posY: ::std::os::raw::c_int, color: Color);
}
extern "C" {
    pub fn DrawPixelV(position: Vector2, color: Color);
}
extern "C" {
    pub fn DrawLine(
        startPosX: ::std::os::raw::c_int,
        startPosY: ::std::os::raw::c_int,
        endPosX: ::std::os::raw::c_int,
        endPosY: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawLineV(startPos: Vector2, endPos: Vector2, color: Color);
}
extern "C" {
    pub fn DrawLineEx(startPos: Vector2, endPos: Vector2, thick: f32, color: Color);
}
extern "C" {
    pub fn DrawLineBezier(startPos: Vector2, endPos: Vector2, thick: f32, color: Color);
}
extern "C" {
    pub fn DrawLineBezierQuad(
        startPos: Vector2,
        endPos: Vector2,
        controlPos: Vector2,
        thick: f32,
        color: Color,
    );
}
extern "C" {
    pub fn DrawLineStrip(points: *mut Vector2, pointsCount: ::std::os::raw::c_int, color: Color);
}
extern "C" {
    pub fn DrawCircle(
        centerX: ::std::os::raw::c_int,
        centerY: ::std::os::raw::c_int,
        radius: f32,
        color: Color,
    );
}
extern "C" {
    pub fn DrawCircleSector(
        center: Vector2,
        radius: f32,
        startAngle: f32,
        endAngle: f32,
        segments: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawCircleSectorLines(
        center: Vector2,
        radius: f32,
        startAngle: f32,
        endAngle: f32,
        segments: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawCircleGradient(
        centerX: ::std::os::raw::c_int,
        centerY: ::std::os::raw::c_int,
        radius: f32,
        color1: Color,
        color2: Color,
    );
}
extern "C" {
    pub fn DrawCircleV(center: Vector2, radius: f32, color: Color);
}
extern "C" {
    pub fn DrawCircleLines(
        centerX: ::std::os::raw::c_int,
        centerY: ::std::os::raw::c_int,
        radius: f32,
        color: Color,
    );
}
extern "C" {
    pub fn DrawEllipse(
        centerX: ::std::os::raw::c_int,
        centerY: ::std::os::raw::c_int,
        radiusH: f32,
        radiusV: f32,
        color: Color,
    );
}
extern "C" {
    pub fn DrawEllipseLines(
        centerX: ::std::os::raw::c_int,
        centerY: ::std::os::raw::c_int,
        radiusH: f32,
        radiusV: f32,
        color: Color,
    );
}
extern "C" {
    pub fn DrawRing(
        center: Vector2,
        innerRadius: f32,
        outerRadius: f32,
        startAngle: f32,
        endAngle: f32,
        segments: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawRingLines(
        center: Vector2,
        innerRadius: f32,
        outerRadius: f32,
        startAngle: f32,
        endAngle: f32,
        segments: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawRectangle(
        posX: ::std::os::raw::c_int,
        posY: ::std::os::raw::c_int,
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawRectangleV(position: Vector2, size: Vector2, color: Color);
}
extern "C" {
    pub fn DrawRectangleRec(rec: Rectangle, color: Color);
}
extern "C" {
    pub fn DrawRectanglePro(rec: Rectangle, origin: Vector2, rotation: f32, color: Color);
}
extern "C" {
    pub fn DrawRectangleGradientV(
        posX: ::std::os::raw::c_int,
        posY: ::std::os::raw::c_int,
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        color1: Color,
        color2: Color,
    );
}
extern "C" {
    pub fn DrawRectangleGradientH(
        posX: ::std::os::raw::c_int,
        posY: ::std::os::raw::c_int,
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        color1: Color,
        color2: Color,
    );
}
extern "C" {
    pub fn DrawRectangleGradientEx(
        rec: Rectangle,
        col1: Color,
        col2: Color,
        col3: Color,
        col4: Color,
    );
}
extern "C" {
    pub fn DrawRectangleLines(
        posX: ::std::os::raw::c_int,
        posY: ::std::os::raw::c_int,
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawRectangleLinesEx(rec: Rectangle, lineThick: ::std::os::raw::c_int, color: Color);
}
extern "C" {
    pub fn DrawRectangleRounded(
        rec: Rectangle,
        roundness: f32,
        segments: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawRectangleRoundedLines(
        rec: Rectangle,
        roundness: f32,
        segments: ::std::os::raw::c_int,
        lineThick: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawTriangle(v1: Vector2, v2: Vector2, v3: Vector2, color: Color);
}
extern "C" {
    pub fn DrawTriangleLines(v1: Vector2, v2: Vector2, v3: Vector2, color: Color);
}
extern "C" {
    pub fn DrawTriangleFan(points: *mut Vector2, pointsCount: ::std::os::raw::c_int, color: Color);
}
extern "C" {
    pub fn DrawTriangleStrip(
        points: *mut Vector2,
        pointsCount: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawPoly(
        center: Vector2,
        sides: ::std::os::raw::c_int,
        radius: f32,
        rotation: f32,
        color: Color,
    );
}
extern "C" {
    pub fn DrawPolyLines(
        center: Vector2,
        sides: ::std::os::raw::c_int,
        radius: f32,
        rotation: f32,
        color: Color,
    );
}
extern "C" {
    pub fn CheckCollisionRecs(rec1: Rectangle, rec2: Rectangle) -> bool;
}
extern "C" {
    pub fn CheckCollisionCircles(
        center1: Vector2,
        radius1: f32,
        center2: Vector2,
        radius2: f32,
    ) -> bool;
}
extern "C" {
    pub fn CheckCollisionCircleRec(center: Vector2, radius: f32, rec: Rectangle) -> bool;
}
extern "C" {
    pub fn CheckCollisionPointRec(point: Vector2, rec: Rectangle) -> bool;
}
extern "C" {
    pub fn CheckCollisionPointCircle(point: Vector2, center: Vector2, radius: f32) -> bool;
}
extern "C" {
    pub fn CheckCollisionPointTriangle(
        point: Vector2,
        p1: Vector2,
        p2: Vector2,
        p3: Vector2,
    ) -> bool;
}
extern "C" {
    pub fn CheckCollisionLines(
        startPos1: Vector2,
        endPos1: Vector2,
        startPos2: Vector2,
        endPos2: Vector2,
        collisionPoint: *mut Vector2,
    ) -> bool;
}
extern "C" {
    pub fn GetCollisionRec(rec1: Rectangle, rec2: Rectangle) -> Rectangle;
}
extern "C" {
    pub fn LoadImage(fileName: *const ::std::os::raw::c_char) -> Image;
}
extern "C" {
    pub fn LoadImageRaw(
        fileName: *const ::std::os::raw::c_char,
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        format: ::std::os::raw::c_int,
        headerSize: ::std::os::raw::c_int,
    ) -> Image;
}
extern "C" {
    pub fn LoadImageAnim(
        fileName: *const ::std::os::raw::c_char,
        frames: *mut ::std::os::raw::c_int,
    ) -> Image;
}
extern "C" {
    pub fn LoadImageFromMemory(
        fileType: *const ::std::os::raw::c_char,
        fileData: *const ::std::os::raw::c_uchar,
        dataSize: ::std::os::raw::c_int,
    ) -> Image;
}
extern "C" {
    pub fn UnloadImage(image: Image);
}
extern "C" {
    pub fn ExportImage(image: Image, fileName: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn ExportImageAsCode(image: Image, fileName: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn GenImageColor(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        color: Color,
    ) -> Image;
}
extern "C" {
    pub fn GenImageGradientV(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        top: Color,
        bottom: Color,
    ) -> Image;
}
extern "C" {
    pub fn GenImageGradientH(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        left: Color,
        right: Color,
    ) -> Image;
}
extern "C" {
    pub fn GenImageGradientRadial(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        density: f32,
        inner: Color,
        outer: Color,
    ) -> Image;
}
extern "C" {
    pub fn GenImageChecked(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        checksX: ::std::os::raw::c_int,
        checksY: ::std::os::raw::c_int,
        col1: Color,
        col2: Color,
    ) -> Image;
}
extern "C" {
    pub fn GenImageWhiteNoise(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        factor: f32,
    ) -> Image;
}
extern "C" {
    pub fn GenImagePerlinNoise(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        offsetX: ::std::os::raw::c_int,
        offsetY: ::std::os::raw::c_int,
        scale: f32,
    ) -> Image;
}
extern "C" {
    pub fn GenImageCellular(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        tileSize: ::std::os::raw::c_int,
    ) -> Image;
}
extern "C" {
    pub fn ImageCopy(image: Image) -> Image;
}
extern "C" {
    pub fn ImageFromImage(image: Image, rec: Rectangle) -> Image;
}
extern "C" {
    pub fn ImageText(
        text: *const ::std::os::raw::c_char,
        fontSize: ::std::os::raw::c_int,
        color: Color,
    ) -> Image;
}
extern "C" {
    pub fn ImageTextEx(
        font: Font,
        text: *const ::std::os::raw::c_char,
        fontSize: f32,
        spacing: f32,
        tint: Color,
    ) -> Image;
}
extern "C" {
    pub fn ImageFormat(image: *mut Image, newFormat: ::std::os::raw::c_int);
}
extern "C" {
    pub fn ImageToPOT(image: *mut Image, fill: Color);
}
extern "C" {
    pub fn ImageCrop(image: *mut Image, crop: Rectangle);
}
extern "C" {
    pub fn ImageAlphaCrop(image: *mut Image, threshold: f32);
}
extern "C" {
    pub fn ImageAlphaClear(image: *mut Image, color: Color, threshold: f32);
}
extern "C" {
    pub fn ImageAlphaMask(image: *mut Image, alphaMask: Image);
}
extern "C" {
    pub fn ImageAlphaPremultiply(image: *mut Image);
}
extern "C" {
    pub fn ImageResize(
        image: *mut Image,
        newWidth: ::std::os::raw::c_int,
        newHeight: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn ImageResizeNN(
        image: *mut Image,
        newWidth: ::std::os::raw::c_int,
        newHeight: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn ImageResizeCanvas(
        image: *mut Image,
        newWidth: ::std::os::raw::c_int,
        newHeight: ::std::os::raw::c_int,
        offsetX: ::std::os::raw::c_int,
        offsetY: ::std::os::raw::c_int,
        fill: Color,
    );
}
extern "C" {
    pub fn ImageMipmaps(image: *mut Image);
}
extern "C" {
    pub fn ImageDither(
        image: *mut Image,
        rBpp: ::std::os::raw::c_int,
        gBpp: ::std::os::raw::c_int,
        bBpp: ::std::os::raw::c_int,
        aBpp: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn ImageFlipVertical(image: *mut Image);
}
extern "C" {
    pub fn ImageFlipHorizontal(image: *mut Image);
}
extern "C" {
    pub fn ImageRotateCW(image: *mut Image);
}
extern "C" {
    pub fn ImageRotateCCW(image: *mut Image);
}
extern "C" {
    pub fn ImageColorTint(image: *mut Image, color: Color);
}
extern "C" {
    pub fn ImageColorInvert(image: *mut Image);
}
extern "C" {
    pub fn ImageColorGrayscale(image: *mut Image);
}
extern "C" {
    pub fn ImageColorContrast(image: *mut Image, contrast: f32);
}
extern "C" {
    pub fn ImageColorBrightness(image: *mut Image, brightness: ::std::os::raw::c_int);
}
extern "C" {
    pub fn ImageColorReplace(image: *mut Image, color: Color, replace: Color);
}
extern "C" {
    pub fn LoadImageColors(image: Image) -> *mut Color;
}
extern "C" {
    pub fn LoadImagePalette(
        image: Image,
        maxPaletteSize: ::std::os::raw::c_int,
        colorsCount: *mut ::std::os::raw::c_int,
    ) -> *mut Color;
}
extern "C" {
    pub fn UnloadImageColors(colors: *mut Color);
}
extern "C" {
    pub fn UnloadImagePalette(colors: *mut Color);
}
extern "C" {
    pub fn GetImageAlphaBorder(image: Image, threshold: f32) -> Rectangle;
}
extern "C" {
    pub fn ImageClearBackground(dst: *mut Image, color: Color);
}
extern "C" {
    pub fn ImageDrawPixel(
        dst: *mut Image,
        posX: ::std::os::raw::c_int,
        posY: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn ImageDrawPixelV(dst: *mut Image, position: Vector2, color: Color);
}
extern "C" {
    pub fn ImageDrawLine(
        dst: *mut Image,
        startPosX: ::std::os::raw::c_int,
        startPosY: ::std::os::raw::c_int,
        endPosX: ::std::os::raw::c_int,
        endPosY: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn ImageDrawLineV(dst: *mut Image, start: Vector2, end: Vector2, color: Color);
}
extern "C" {
    pub fn ImageDrawCircle(
        dst: *mut Image,
        centerX: ::std::os::raw::c_int,
        centerY: ::std::os::raw::c_int,
        radius: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn ImageDrawCircleV(
        dst: *mut Image,
        center: Vector2,
        radius: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn ImageDrawRectangle(
        dst: *mut Image,
        posX: ::std::os::raw::c_int,
        posY: ::std::os::raw::c_int,
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn ImageDrawRectangleV(dst: *mut Image, position: Vector2, size: Vector2, color: Color);
}
extern "C" {
    pub fn ImageDrawRectangleRec(dst: *mut Image, rec: Rectangle, color: Color);
}
extern "C" {
    pub fn ImageDrawRectangleLines(
        dst: *mut Image,
        rec: Rectangle,
        thick: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn ImageDraw(
        dst: *mut Image,
        src: Image,
        srcRec: Rectangle,
        dstRec: Rectangle,
        tint: Color,
    );
}
extern "C" {
    pub fn ImageDrawText(
        dst: *mut Image,
        text: *const ::std::os::raw::c_char,
        posX: ::std::os::raw::c_int,
        posY: ::std::os::raw::c_int,
        fontSize: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn ImageDrawTextEx(
        dst: *mut Image,
        font: Font,
        text: *const ::std::os::raw::c_char,
        position: Vector2,
        fontSize: f32,
        spacing: f32,
        tint: Color,
    );
}
extern "C" {
    pub fn LoadTexture(fileName: *const ::std::os::raw::c_char) -> Texture2D;
}
extern "C" {
    pub fn LoadTextureFromImage(image: Image) -> Texture2D;
}
extern "C" {
    pub fn LoadTextureCubemap(image: Image, layout: ::std::os::raw::c_int) -> TextureCubemap;
}
extern "C" {
    pub fn LoadRenderTexture(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
    ) -> RenderTexture2D;
}
extern "C" {
    pub fn UnloadTexture(texture: Texture2D);
}
extern "C" {
    pub fn UnloadRenderTexture(target: RenderTexture2D);
}
extern "C" {
    pub fn UpdateTexture(texture: Texture2D, pixels: *const ::std::os::raw::c_void);
}
extern "C" {
    pub fn UpdateTextureRec(
        texture: Texture2D,
        rec: Rectangle,
        pixels: *const ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn GetTextureData(texture: Texture2D) -> Image;
}
extern "C" {
    pub fn GetScreenData() -> Image;
}
extern "C" {
    pub fn GenTextureMipmaps(texture: *mut Texture2D);
}
extern "C" {
    pub fn SetTextureFilter(texture: Texture2D, filter: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SetTextureWrap(texture: Texture2D, wrap: ::std::os::raw::c_int);
}
extern "C" {
    pub fn DrawTexture(
        texture: Texture2D,
        posX: ::std::os::raw::c_int,
        posY: ::std::os::raw::c_int,
        tint: Color,
    );
}
extern "C" {
    pub fn DrawTextureV(texture: Texture2D, position: Vector2, tint: Color);
}
extern "C" {
    pub fn DrawTextureEx(
        texture: Texture2D,
        position: Vector2,
        rotation: f32,
        scale: f32,
        tint: Color,
    );
}
extern "C" {
    pub fn DrawTextureRec(texture: Texture2D, source: Rectangle, position: Vector2, tint: Color);
}
extern "C" {
    pub fn DrawTextureQuad(
        texture: Texture2D,
        tiling: Vector2,
        offset: Vector2,
        quad: Rectangle,
        tint: Color,
    );
}
extern "C" {
    pub fn DrawTextureTiled(
        texture: Texture2D,
        source: Rectangle,
        dest: Rectangle,
        origin: Vector2,
        rotation: f32,
        scale: f32,
        tint: Color,
    );
}
extern "C" {
    pub fn DrawTexturePro(
        texture: Texture2D,
        source: Rectangle,
        dest: Rectangle,
        origin: Vector2,
        rotation: f32,
        tint: Color,
    );
}
extern "C" {
    pub fn DrawTextureNPatch(
        texture: Texture2D,
        nPatchInfo: NPatchInfo,
        dest: Rectangle,
        origin: Vector2,
        rotation: f32,
        tint: Color,
    );
}
extern "C" {
    pub fn DrawTexturePoly(
        texture: Texture2D,
        center: Vector2,
        points: *mut Vector2,
        texcoords: *mut Vector2,
        pointsCount: ::std::os::raw::c_int,
        tint: Color,
    );
}
extern "C" {
    pub fn Fade(color: Color, alpha: f32) -> Color;
}
extern "C" {
    pub fn ColorToInt(color: Color) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ColorNormalize(color: Color) -> Vector4;
}
extern "C" {
    pub fn ColorFromNormalized(normalized: Vector4) -> Color;
}
extern "C" {
    pub fn ColorToHSV(color: Color) -> Vector3;
}
extern "C" {
    pub fn ColorFromHSV(hue: f32, saturation: f32, value: f32) -> Color;
}
extern "C" {
    pub fn ColorAlpha(color: Color, alpha: f32) -> Color;
}
extern "C" {
    pub fn ColorAlphaBlend(dst: Color, src: Color, tint: Color) -> Color;
}
extern "C" {
    pub fn GetColor(hexValue: ::std::os::raw::c_int) -> Color;
}
extern "C" {
    pub fn GetPixelColor(
        srcPtr: *mut ::std::os::raw::c_void,
        format: ::std::os::raw::c_int,
    ) -> Color;
}
extern "C" {
    pub fn SetPixelColor(
        dstPtr: *mut ::std::os::raw::c_void,
        color: Color,
        format: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn GetPixelDataSize(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        format: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetFontDefault() -> Font;
}
extern "C" {
    pub fn LoadFont(fileName: *const ::std::os::raw::c_char) -> Font;
}
extern "C" {
    pub fn LoadFontEx(
        fileName: *const ::std::os::raw::c_char,
        fontSize: ::std::os::raw::c_int,
        fontChars: *mut ::std::os::raw::c_int,
        charsCount: ::std::os::raw::c_int,
    ) -> Font;
}
extern "C" {
    pub fn LoadFontFromImage(image: Image, key: Color, firstChar: ::std::os::raw::c_int) -> Font;
}
extern "C" {
    pub fn LoadFontFromMemory(
        fileType: *const ::std::os::raw::c_char,
        fileData: *const ::std::os::raw::c_uchar,
        dataSize: ::std::os::raw::c_int,
        fontSize: ::std::os::raw::c_int,
        fontChars: *mut ::std::os::raw::c_int,
        charsCount: ::std::os::raw::c_int,
    ) -> Font;
}
extern "C" {
    pub fn LoadFontData(
        fileData: *const ::std::os::raw::c_uchar,
        dataSize: ::std::os::raw::c_int,
        fontSize: ::std::os::raw::c_int,
        fontChars: *mut ::std::os::raw::c_int,
        charsCount: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> *mut CharInfo;
}
extern "C" {
    pub fn GenImageFontAtlas(
        chars: *const CharInfo,
        recs: *mut *mut Rectangle,
        charsCount: ::std::os::raw::c_int,
        fontSize: ::std::os::raw::c_int,
        padding: ::std::os::raw::c_int,
        packMethod: ::std::os::raw::c_int,
    ) -> Image;
}
extern "C" {
    pub fn UnloadFontData(chars: *mut CharInfo, charsCount: ::std::os::raw::c_int);
}
extern "C" {
    pub fn UnloadFont(font: Font);
}
extern "C" {
    pub fn DrawFPS(posX: ::std::os::raw::c_int, posY: ::std::os::raw::c_int);
}
extern "C" {
    pub fn DrawText(
        text: *const ::std::os::raw::c_char,
        posX: ::std::os::raw::c_int,
        posY: ::std::os::raw::c_int,
        fontSize: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawTextEx(
        font: Font,
        text: *const ::std::os::raw::c_char,
        position: Vector2,
        fontSize: f32,
        spacing: f32,
        tint: Color,
    );
}
extern "C" {
    pub fn DrawTextRec(
        font: Font,
        text: *const ::std::os::raw::c_char,
        rec: Rectangle,
        fontSize: f32,
        spacing: f32,
        wordWrap: bool,
        tint: Color,
    );
}
extern "C" {
    pub fn DrawTextRecEx(
        font: Font,
        text: *const ::std::os::raw::c_char,
        rec: Rectangle,
        fontSize: f32,
        spacing: f32,
        wordWrap: bool,
        tint: Color,
        selectStart: ::std::os::raw::c_int,
        selectLength: ::std::os::raw::c_int,
        selectTint: Color,
        selectBackTint: Color,
    );
}
extern "C" {
    pub fn DrawTextCodepoint(
        font: Font,
        codepoint: ::std::os::raw::c_int,
        position: Vector2,
        fontSize: f32,
        tint: Color,
    );
}
extern "C" {
    pub fn MeasureText(
        text: *const ::std::os::raw::c_char,
        fontSize: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn MeasureTextEx(
        font: Font,
        text: *const ::std::os::raw::c_char,
        fontSize: f32,
        spacing: f32,
    ) -> Vector2;
}
extern "C" {
    pub fn GetGlyphIndex(font: Font, codepoint: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn TextCopy(
        dst: *mut ::std::os::raw::c_char,
        src: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn TextIsEqual(
        text1: *const ::std::os::raw::c_char,
        text2: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn TextLength(text: *const ::std::os::raw::c_char) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn TextFormat(text: *const ::std::os::raw::c_char, ...) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn TextSubtext(
        text: *const ::std::os::raw::c_char,
        position: ::std::os::raw::c_int,
        length: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn TextReplace(
        text: *mut ::std::os::raw::c_char,
        replace: *const ::std::os::raw::c_char,
        by: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn TextInsert(
        text: *const ::std::os::raw::c_char,
        insert: *const ::std::os::raw::c_char,
        position: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn TextJoin(
        textList: *mut *const ::std::os::raw::c_char,
        count: ::std::os::raw::c_int,
        delimiter: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn TextSplit(
        text: *const ::std::os::raw::c_char,
        delimiter: ::std::os::raw::c_char,
        count: *mut ::std::os::raw::c_int,
    ) -> *mut *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn TextAppend(
        text: *mut ::std::os::raw::c_char,
        append: *const ::std::os::raw::c_char,
        position: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn TextFindIndex(
        text: *const ::std::os::raw::c_char,
        find: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn TextToUpper(text: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn TextToLower(text: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn TextToPascal(text: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn TextToInteger(text: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn TextToUtf8(
        codepoints: *mut ::std::os::raw::c_int,
        length: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn GetCodepoints(
        text: *const ::std::os::raw::c_char,
        count: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetCodepointsCount(text: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GetNextCodepoint(
        text: *const ::std::os::raw::c_char,
        bytesProcessed: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn CodepointToUtf8(
        codepoint: ::std::os::raw::c_int,
        byteLength: *mut ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn DrawLine3D(startPos: Vector3, endPos: Vector3, color: Color);
}
extern "C" {
    pub fn DrawPoint3D(position: Vector3, color: Color);
}
extern "C" {
    pub fn DrawCircle3D(
        center: Vector3,
        radius: f32,
        rotationAxis: Vector3,
        rotationAngle: f32,
        color: Color,
    );
}
extern "C" {
    pub fn DrawTriangle3D(v1: Vector3, v2: Vector3, v3: Vector3, color: Color);
}
extern "C" {
    pub fn DrawTriangleStrip3D(
        points: *mut Vector3,
        pointsCount: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawCube(position: Vector3, width: f32, height: f32, length: f32, color: Color);
}
extern "C" {
    pub fn DrawCubeV(position: Vector3, size: Vector3, color: Color);
}
extern "C" {
    pub fn DrawCubeWires(position: Vector3, width: f32, height: f32, length: f32, color: Color);
}
extern "C" {
    pub fn DrawCubeWiresV(position: Vector3, size: Vector3, color: Color);
}
extern "C" {
    pub fn DrawCubeTexture(
        texture: Texture2D,
        position: Vector3,
        width: f32,
        height: f32,
        length: f32,
        color: Color,
    );
}
extern "C" {
    pub fn DrawSphere(centerPos: Vector3, radius: f32, color: Color);
}
extern "C" {
    pub fn DrawSphereEx(
        centerPos: Vector3,
        radius: f32,
        rings: ::std::os::raw::c_int,
        slices: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawSphereWires(
        centerPos: Vector3,
        radius: f32,
        rings: ::std::os::raw::c_int,
        slices: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawCylinder(
        position: Vector3,
        radiusTop: f32,
        radiusBottom: f32,
        height: f32,
        slices: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawCylinderWires(
        position: Vector3,
        radiusTop: f32,
        radiusBottom: f32,
        height: f32,
        slices: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn DrawPlane(centerPos: Vector3, size: Vector2, color: Color);
}
extern "C" {
    pub fn DrawRay(ray: Ray, color: Color);
}
extern "C" {
    pub fn DrawGrid(slices: ::std::os::raw::c_int, spacing: f32);
}
extern "C" {
    pub fn LoadModel(fileName: *const ::std::os::raw::c_char) -> Model;
}
extern "C" {
    pub fn LoadModelFromMesh(mesh: Mesh) -> Model;
}
extern "C" {
    pub fn UnloadModel(model: Model);
}
extern "C" {
    pub fn UnloadModelKeepMeshes(model: Model);
}
extern "C" {
    pub fn UploadMesh(mesh: *mut Mesh, dynamic: bool);
}
extern "C" {
    pub fn UpdateMeshBuffer(
        mesh: Mesh,
        index: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        dataSize: ::std::os::raw::c_int,
        offset: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn DrawMesh(mesh: Mesh, material: Material, transform: Matrix);
}
extern "C" {
    pub fn DrawMeshInstanced(
        mesh: Mesh,
        material: Material,
        transforms: *mut Matrix,
        instances: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn UnloadMesh(mesh: Mesh);
}
extern "C" {
    pub fn ExportMesh(mesh: Mesh, fileName: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn LoadMaterials(
        fileName: *const ::std::os::raw::c_char,
        materialCount: *mut ::std::os::raw::c_int,
    ) -> *mut Material;
}
extern "C" {
    pub fn LoadMaterialDefault() -> Material;
}
extern "C" {
    pub fn UnloadMaterial(material: Material);
}
extern "C" {
    pub fn SetMaterialTexture(
        material: *mut Material,
        mapType: ::std::os::raw::c_int,
        texture: Texture2D,
    );
}
extern "C" {
    pub fn SetModelMeshMaterial(
        model: *mut Model,
        meshId: ::std::os::raw::c_int,
        materialId: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn LoadModelAnimations(
        fileName: *const ::std::os::raw::c_char,
        animsCount: *mut ::std::os::raw::c_int,
    ) -> *mut ModelAnimation;
}
extern "C" {
    pub fn UpdateModelAnimation(model: Model, anim: ModelAnimation, frame: ::std::os::raw::c_int);
}
extern "C" {
    pub fn UnloadModelAnimation(anim: ModelAnimation);
}
extern "C" {
    pub fn UnloadModelAnimations(animations: *mut ModelAnimation, count: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn IsModelAnimationValid(model: Model, anim: ModelAnimation) -> bool;
}
extern "C" {
    pub fn GenMeshPoly(sides: ::std::os::raw::c_int, radius: f32) -> Mesh;
}
extern "C" {
    pub fn GenMeshPlane(
        width: f32,
        length: f32,
        resX: ::std::os::raw::c_int,
        resZ: ::std::os::raw::c_int,
    ) -> Mesh;
}
extern "C" {
    pub fn GenMeshCube(width: f32, height: f32, length: f32) -> Mesh;
}
extern "C" {
    pub fn GenMeshSphere(
        radius: f32,
        rings: ::std::os::raw::c_int,
        slices: ::std::os::raw::c_int,
    ) -> Mesh;
}
extern "C" {
    pub fn GenMeshHemiSphere(
        radius: f32,
        rings: ::std::os::raw::c_int,
        slices: ::std::os::raw::c_int,
    ) -> Mesh;
}
extern "C" {
    pub fn GenMeshCylinder(radius: f32, height: f32, slices: ::std::os::raw::c_int) -> Mesh;
}
extern "C" {
    pub fn GenMeshTorus(
        radius: f32,
        size: f32,
        radSeg: ::std::os::raw::c_int,
        sides: ::std::os::raw::c_int,
    ) -> Mesh;
}
extern "C" {
    pub fn GenMeshKnot(
        radius: f32,
        size: f32,
        radSeg: ::std::os::raw::c_int,
        sides: ::std::os::raw::c_int,
    ) -> Mesh;
}
extern "C" {
    pub fn GenMeshHeightmap(heightmap: Image, size: Vector3) -> Mesh;
}
extern "C" {
    pub fn GenMeshCubicmap(cubicmap: Image, cubeSize: Vector3) -> Mesh;
}
extern "C" {
    pub fn MeshBoundingBox(mesh: Mesh) -> BoundingBox;
}
extern "C" {
    pub fn MeshTangents(mesh: *mut Mesh);
}
extern "C" {
    pub fn MeshBinormals(mesh: *mut Mesh);
}
extern "C" {
    pub fn DrawModel(model: Model, position: Vector3, scale: f32, tint: Color);
}
extern "C" {
    pub fn DrawModelEx(
        model: Model,
        position: Vector3,
        rotationAxis: Vector3,
        rotationAngle: f32,
        scale: Vector3,
        tint: Color,
    );
}
extern "C" {
    pub fn DrawModelWires(model: Model, position: Vector3, scale: f32, tint: Color);
}
extern "C" {
    pub fn DrawModelWiresEx(
        model: Model,
        position: Vector3,
        rotationAxis: Vector3,
        rotationAngle: f32,
        scale: Vector3,
        tint: Color,
    );
}
extern "C" {
    pub fn DrawBoundingBox(box_: BoundingBox, color: Color);
}
extern "C" {
    pub fn DrawBillboard(
        camera: Camera,
        texture: Texture2D,
        center: Vector3,
        size: f32,
        tint: Color,
    );
}
extern "C" {
    pub fn DrawBillboardRec(
        camera: Camera,
        texture: Texture2D,
        source: Rectangle,
        center: Vector3,
        size: f32,
        tint: Color,
    );
}
extern "C" {
    pub fn CheckCollisionSpheres(
        center1: Vector3,
        radius1: f32,
        center2: Vector3,
        radius2: f32,
    ) -> bool;
}
extern "C" {
    pub fn CheckCollisionBoxes(box1: BoundingBox, box2: BoundingBox) -> bool;
}
extern "C" {
    pub fn CheckCollisionBoxSphere(box_: BoundingBox, center: Vector3, radius: f32) -> bool;
}
extern "C" {
    pub fn CheckCollisionRaySphere(ray: Ray, center: Vector3, radius: f32) -> bool;
}
extern "C" {
    pub fn CheckCollisionRaySphereEx(
        ray: Ray,
        center: Vector3,
        radius: f32,
        collisionPoint: *mut Vector3,
    ) -> bool;
}
extern "C" {
    pub fn CheckCollisionRayBox(ray: Ray, box_: BoundingBox) -> bool;
}
extern "C" {
    pub fn GetCollisionRayMesh(ray: Ray, mesh: Mesh, transform: Matrix) -> RayHitInfo;
}
extern "C" {
    pub fn GetCollisionRayModel(ray: Ray, model: Model) -> RayHitInfo;
}
extern "C" {
    pub fn GetCollisionRayTriangle(ray: Ray, p1: Vector3, p2: Vector3, p3: Vector3) -> RayHitInfo;
}
extern "C" {
    pub fn GetCollisionRayGround(ray: Ray, groundHeight: f32) -> RayHitInfo;
}
extern "C" {
    pub fn InitAudioDevice();
}
extern "C" {
    pub fn CloseAudioDevice();
}
extern "C" {
    pub fn IsAudioDeviceReady() -> bool;
}
extern "C" {
    pub fn SetMasterVolume(volume: f32);
}
extern "C" {
    pub fn LoadWave(fileName: *const ::std::os::raw::c_char) -> Wave;
}
extern "C" {
    pub fn LoadWaveFromMemory(
        fileType: *const ::std::os::raw::c_char,
        fileData: *const ::std::os::raw::c_uchar,
        dataSize: ::std::os::raw::c_int,
    ) -> Wave;
}
extern "C" {
    pub fn LoadSound(fileName: *const ::std::os::raw::c_char) -> Sound;
}
extern "C" {
    pub fn LoadSoundFromWave(wave: Wave) -> Sound;
}
extern "C" {
    pub fn UpdateSound(
        sound: Sound,
        data: *const ::std::os::raw::c_void,
        samplesCount: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn UnloadWave(wave: Wave);
}
extern "C" {
    pub fn UnloadSound(sound: Sound);
}
extern "C" {
    pub fn ExportWave(wave: Wave, fileName: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn ExportWaveAsCode(wave: Wave, fileName: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn PlaySound(sound: Sound);
}
extern "C" {
    pub fn StopSound(sound: Sound);
}
extern "C" {
    pub fn PauseSound(sound: Sound);
}
extern "C" {
    pub fn ResumeSound(sound: Sound);
}
extern "C" {
    pub fn PlaySoundMulti(sound: Sound);
}
extern "C" {
    pub fn StopSoundMulti();
}
extern "C" {
    pub fn GetSoundsPlaying() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn IsSoundPlaying(sound: Sound) -> bool;
}
extern "C" {
    pub fn SetSoundVolume(sound: Sound, volume: f32);
}
extern "C" {
    pub fn SetSoundPitch(sound: Sound, pitch: f32);
}
extern "C" {
    pub fn WaveFormat(
        wave: *mut Wave,
        sampleRate: ::std::os::raw::c_int,
        sampleSize: ::std::os::raw::c_int,
        channels: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn WaveCopy(wave: Wave) -> Wave;
}
extern "C" {
    pub fn WaveCrop(
        wave: *mut Wave,
        initSample: ::std::os::raw::c_int,
        finalSample: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn LoadWaveSamples(wave: Wave) -> *mut f32;
}
extern "C" {
    pub fn UnloadWaveSamples(samples: *mut f32);
}
extern "C" {
    pub fn LoadMusicStream(fileName: *const ::std::os::raw::c_char) -> Music;
}
extern "C" {
    pub fn LoadMusicStreamFromMemory(
        fileType: *const ::std::os::raw::c_char,
        data: *mut ::std::os::raw::c_uchar,
        dataSize: ::std::os::raw::c_int,
    ) -> Music;
}
extern "C" {
    pub fn UnloadMusicStream(music: Music);
}
extern "C" {
    pub fn PlayMusicStream(music: Music);
}
extern "C" {
    pub fn IsMusicPlaying(music: Music) -> bool;
}
extern "C" {
    pub fn UpdateMusicStream(music: Music);
}
extern "C" {
    pub fn StopMusicStream(music: Music);
}
extern "C" {
    pub fn PauseMusicStream(music: Music);
}
extern "C" {
    pub fn ResumeMusicStream(music: Music);
}
extern "C" {
    pub fn SetMusicVolume(music: Music, volume: f32);
}
extern "C" {
    pub fn SetMusicPitch(music: Music, pitch: f32);
}
extern "C" {
    pub fn GetMusicTimeLength(music: Music) -> f32;
}
extern "C" {
    pub fn GetMusicTimePlayed(music: Music) -> f32;
}
extern "C" {
    pub fn InitAudioStream(
        sampleRate: ::std::os::raw::c_uint,
        sampleSize: ::std::os::raw::c_uint,
        channels: ::std::os::raw::c_uint,
    ) -> AudioStream;
}
extern "C" {
    pub fn UpdateAudioStream(
        stream: AudioStream,
        data: *const ::std::os::raw::c_void,
        samplesCount: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn CloseAudioStream(stream: AudioStream);
}
extern "C" {
    pub fn IsAudioStreamProcessed(stream: AudioStream) -> bool;
}
extern "C" {
    pub fn PlayAudioStream(stream: AudioStream);
}
extern "C" {
    pub fn PauseAudioStream(stream: AudioStream);
}
extern "C" {
    pub fn ResumeAudioStream(stream: AudioStream);
}
extern "C" {
    pub fn IsAudioStreamPlaying(stream: AudioStream) -> bool;
}
extern "C" {
    pub fn StopAudioStream(stream: AudioStream);
}
extern "C" {
    pub fn SetAudioStreamVolume(stream: AudioStream, volume: f32);
}
extern "C" {
    pub fn SetAudioStreamPitch(stream: AudioStream, pitch: f32);
}
extern "C" {
    pub fn SetAudioStreamBufferSizeDefault(size: ::std::os::raw::c_int);
}
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __darwin_intptr_t = ::std::os::raw::c_long;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_ct_rune_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstate8: [::std::os::raw::c_char; 128usize],
    pub _mbstateL: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        128usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__mbstate8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__mbstate8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>()))._mbstateL as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(_mbstateL)
        )
    );
}
pub type __darwin_mbstate_t = __mbstate_t;
pub type __darwin_ptrdiff_t = ::std::os::raw::c_long;
pub type __darwin_size_t = ::std::os::raw::c_ulong;
pub type __darwin_va_list = __builtin_va_list;
pub type __darwin_wchar_t = ::std::os::raw::c_int;
pub type __darwin_rune_t = __darwin_wchar_t;
pub type __darwin_wint_t = ::std::os::raw::c_int;
pub type __darwin_clock_t = ::std::os::raw::c_ulong;
pub type __darwin_socklen_t = __uint32_t;
pub type __darwin_ssize_t = ::std::os::raw::c_long;
pub type __darwin_time_t = ::std::os::raw::c_long;
pub type __darwin_blkcnt_t = __int64_t;
pub type __darwin_blksize_t = __int32_t;
pub type __darwin_dev_t = __int32_t;
pub type __darwin_fsblkcnt_t = ::std::os::raw::c_uint;
pub type __darwin_fsfilcnt_t = ::std::os::raw::c_uint;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_id_t = __uint32_t;
pub type __darwin_ino64_t = __uint64_t;
pub type __darwin_ino_t = __darwin_ino64_t;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_mode_t = __uint16_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_pid_t = __int32_t;
pub type __darwin_sigset_t = __uint32_t;
pub type __darwin_suseconds_t = __int32_t;
pub type __darwin_uid_t = __uint32_t;
pub type __darwin_useconds_t = __uint32_t;
pub type __darwin_uuid_t = [::std::os::raw::c_uchar; 16usize];
pub type __darwin_uuid_string_t = [::std::os::raw::c_char; 37usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_pthread_handler_rec {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __next: *mut __darwin_pthread_handler_rec,
}
#[test]
fn bindgen_test_layout___darwin_pthread_handler_rec() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_pthread_handler_rec>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_pthread_handler_rec>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__routine as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__routine)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__arg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__arg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__next)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_attr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_attr_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_cond_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 40usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_condattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_condattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_condattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutex_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutex_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutexattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutexattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutexattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_once_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_once_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_once_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_once_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlock_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 192usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlock_t>(),
        200usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlockattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlockattr_t>(),
        24usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_t {
    pub __sig: ::std::os::raw::c_long,
    pub __cleanup_stack: *mut __darwin_pthread_handler_rec,
    pub __opaque: [::std::os::raw::c_char; 8176usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_t>(),
        8192usize,
        concat!("Size of: ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_t>())).__cleanup_stack as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__cleanup_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__opaque as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__opaque)
        )
    );
}
pub type __darwin_pthread_attr_t = _opaque_pthread_attr_t;
pub type __darwin_pthread_cond_t = _opaque_pthread_cond_t;
pub type __darwin_pthread_condattr_t = _opaque_pthread_condattr_t;
pub type __darwin_pthread_key_t = ::std::os::raw::c_ulong;
pub type __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
pub type __darwin_pthread_mutexattr_t = _opaque_pthread_mutexattr_t;
pub type __darwin_pthread_once_t = _opaque_pthread_once_t;
pub type __darwin_pthread_rwlock_t = _opaque_pthread_rwlock_t;
pub type __darwin_pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t;
pub type __darwin_pthread_t = *mut _opaque_pthread_t;
pub type __darwin_nl_item = ::std::os::raw::c_int;
pub type __darwin_wctrans_t = ::std::os::raw::c_int;
pub type __darwin_wctype_t = __uint32_t;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum idtype_t {
    P_ALL = 0,
    P_PID = 1,
    P_PGID = 2,
}
pub type pid_t = __darwin_pid_t;
pub type id_t = __darwin_id_t;
pub type sig_atomic_t = ::std::os::raw::c_int;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulonglong;
pub type register_t = i64;
pub type user_addr_t = u_int64_t;
pub type user_size_t = u_int64_t;
pub type user_ssize_t = i64;
pub type user_long_t = i64;
pub type user_ulong_t = u_int64_t;
pub type user_time_t = i64;
pub type user_off_t = i64;
pub type syscall_arg_t = u_int64_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_thread_state {
    pub __eax: ::std::os::raw::c_uint,
    pub __ebx: ::std::os::raw::c_uint,
    pub __ecx: ::std::os::raw::c_uint,
    pub __edx: ::std::os::raw::c_uint,
    pub __edi: ::std::os::raw::c_uint,
    pub __esi: ::std::os::raw::c_uint,
    pub __ebp: ::std::os::raw::c_uint,
    pub __esp: ::std::os::raw::c_uint,
    pub __ss: ::std::os::raw::c_uint,
    pub __eflags: ::std::os::raw::c_uint,
    pub __eip: ::std::os::raw::c_uint,
    pub __cs: ::std::os::raw::c_uint,
    pub __ds: ::std::os::raw::c_uint,
    pub __es: ::std::os::raw::c_uint,
    pub __fs: ::std::os::raw::c_uint,
    pub __gs: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_i386_thread_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_thread_state>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_thread_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ebx as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ecx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ecx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__edx as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__edi as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__esi as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ebp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__esp as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ss as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eflags as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eip as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__cs as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ds as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__es as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__fs as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__gs as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_control {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout___darwin_fp_control() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_control>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_control))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_control>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_control))
    );
}
impl __darwin_fp_control {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __pc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___pc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn __rc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___rc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __pc: ::std::os::raw::c_ushort,
        __rc: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let __pc: u16 = unsafe { ::std::mem::transmute(__pc) };
            __pc as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let __rc: u16 = unsafe { ::std::mem::transmute(__rc) };
            __rc as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_control_t = __darwin_fp_control;
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_status {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout___darwin_fp_status() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_status>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_status))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_status>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_status))
    );
}
impl __darwin_fp_status {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __stkflt(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___stkflt(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __errsumm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___errsumm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c0(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c0(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c1(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c1(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c2(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c2(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __tos(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 3u8) as u16) }
    }
    #[inline]
    pub fn set___tos(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn __c3(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c3(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __busy(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___busy(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __stkflt: ::std::os::raw::c_ushort,
        __errsumm: ::std::os::raw::c_ushort,
        __c0: ::std::os::raw::c_ushort,
        __c1: ::std::os::raw::c_ushort,
        __c2: ::std::os::raw::c_ushort,
        __tos: ::std::os::raw::c_ushort,
        __c3: ::std::os::raw::c_ushort,
        __busy: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let __stkflt: u16 = unsafe { ::std::mem::transmute(__stkflt) };
            __stkflt as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __errsumm: u16 = unsafe { ::std::mem::transmute(__errsumm) };
            __errsumm as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let __c0: u16 = unsafe { ::std::mem::transmute(__c0) };
            __c0 as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let __c1: u16 = unsafe { ::std::mem::transmute(__c1) };
            __c1 as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let __c2: u16 = unsafe { ::std::mem::transmute(__c2) };
            __c2 as u64
        });
        __bindgen_bitfield_unit.set(11usize, 3u8, {
            let __tos: u16 = unsafe { ::std::mem::transmute(__tos) };
            __tos as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let __c3: u16 = unsafe { ::std::mem::transmute(__c3) };
            __c3 as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let __busy: u16 = unsafe { ::std::mem::transmute(__busy) };
            __busy as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_status_t = __darwin_fp_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mmst_reg {
    pub __mmst_reg: [::std::os::raw::c_char; 10usize],
    pub __mmst_rsrv: [::std::os::raw::c_char; 6usize],
}
#[test]
fn bindgen_test_layout___darwin_mmst_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mmst_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mmst_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mmst_reg>())).__mmst_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mmst_reg>())).__mmst_rsrv as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_rsrv)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_xmm_reg {
    pub __xmm_reg: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_xmm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_xmm_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_xmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_xmm_reg>())).__xmm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_xmm_reg),
            "::",
            stringify!(__xmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ymm_reg {
    pub __ymm_reg: [::std::os::raw::c_char; 32usize],
}
#[test]
fn bindgen_test_layout___darwin_ymm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ymm_reg>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ymm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ymm_reg>())).__ymm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ymm_reg),
            "::",
            stringify!(__ymm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_zmm_reg {
    pub __zmm_reg: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout___darwin_zmm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_zmm_reg>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_zmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_zmm_reg>())).__zmm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_zmm_reg),
            "::",
            stringify!(__zmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_opmask_reg {
    pub __opmask_reg: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout___darwin_opmask_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_opmask_reg>(),
        8usize,
        concat!("Size of: ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_opmask_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_opmask_reg>())).__opmask_reg as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_opmask_reg),
            "::",
            stringify!(__opmask_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_float_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_i386_float_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_float_state>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_float_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx_state>(),
        716usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_mxcsrmask as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_reserved1 as *const _ as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__avx_reserved1 as *const _ as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx512_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx512_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx512_state>(),
        1036usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx512_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k0 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k1 as *const _ as usize
        },
        724usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k2 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k3 as *const _ as usize
        },
        740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k4 as *const _ as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k5 as *const _ as usize
        },
        756usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k6 as *const _ as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k7 as *const _ as usize
        },
        772usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh0 as *const _ as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh1 as *const _ as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh2 as *const _ as usize
        },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh3 as *const _ as usize
        },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh4 as *const _ as usize
        },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh5 as *const _ as usize
        },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh6 as *const _ as usize
        },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh7 as *const _ as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_exception_state {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_i386_exception_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_exception_state>(),
        12usize,
        concat!("Size of: ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_exception_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__trapno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__cpu as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__err as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__faultvaddr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state32 {
    pub __dr0: ::std::os::raw::c_uint,
    pub __dr1: ::std::os::raw::c_uint,
    pub __dr2: ::std::os::raw::c_uint,
    pub __dr3: ::std::os::raw::c_uint,
    pub __dr4: ::std::os::raw::c_uint,
    pub __dr5: ::std::os::raw::c_uint,
    pub __dr6: ::std::os::raw::c_uint,
    pub __dr7: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state32>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr0 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr1 as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr2 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr3 as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr4 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr5 as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr6 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr7 as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_pagein_state {
    pub __pagein_error: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___x86_pagein_state() {
    assert_eq!(
        ::std::mem::size_of::<__x86_pagein_state>(),
        4usize,
        concat!("Size of: ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__x86_pagein_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_pagein_state>())).__pagein_error as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_pagein_state),
            "::",
            stringify!(__pagein_error)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_state64 {
    pub __rax: __uint64_t,
    pub __rbx: __uint64_t,
    pub __rcx: __uint64_t,
    pub __rdx: __uint64_t,
    pub __rdi: __uint64_t,
    pub __rsi: __uint64_t,
    pub __rbp: __uint64_t,
    pub __rsp: __uint64_t,
    pub __r8: __uint64_t,
    pub __r9: __uint64_t,
    pub __r10: __uint64_t,
    pub __r11: __uint64_t,
    pub __r12: __uint64_t,
    pub __r13: __uint64_t,
    pub __r14: __uint64_t,
    pub __r15: __uint64_t,
    pub __rip: __uint64_t,
    pub __rflags: __uint64_t,
    pub __cs: __uint64_t,
    pub __fs: __uint64_t,
    pub __gs: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_state64>(),
        168usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rcx as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rcx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdx as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdi as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsi as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbp as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsp as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r8 as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r9 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r10 as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r11 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r12 as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r13 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r14 as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r15 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rip as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rflags as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__cs as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__fs as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__gs as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_full_state64 {
    pub __ss64: __darwin_x86_thread_state64,
    pub __ds: __uint64_t,
    pub __es: __uint64_t,
    pub __ss: __uint64_t,
    pub __gsbase: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_full_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_full_state64>(),
        200usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_full_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_full_state64>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_x86_thread_full_state64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ss64 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ds as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__es as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ss as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__gsbase as *const _
                as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__gsbase)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_float_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_x86_float_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_float_state64>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_float_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx_state64>(),
        844usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh8 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh9 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh10 as *const _ as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh11 as *const _ as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh12 as *const _ as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh13 as *const _ as usize
        },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh14 as *const _ as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh15 as *const _ as usize
        },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx512_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
    pub __fpu_zmmh8: __darwin_ymm_reg,
    pub __fpu_zmmh9: __darwin_ymm_reg,
    pub __fpu_zmmh10: __darwin_ymm_reg,
    pub __fpu_zmmh11: __darwin_ymm_reg,
    pub __fpu_zmmh12: __darwin_ymm_reg,
    pub __fpu_zmmh13: __darwin_ymm_reg,
    pub __fpu_zmmh14: __darwin_ymm_reg,
    pub __fpu_zmmh15: __darwin_ymm_reg,
    pub __fpu_zmm16: __darwin_zmm_reg,
    pub __fpu_zmm17: __darwin_zmm_reg,
    pub __fpu_zmm18: __darwin_zmm_reg,
    pub __fpu_zmm19: __darwin_zmm_reg,
    pub __fpu_zmm20: __darwin_zmm_reg,
    pub __fpu_zmm21: __darwin_zmm_reg,
    pub __fpu_zmm22: __darwin_zmm_reg,
    pub __fpu_zmm23: __darwin_zmm_reg,
    pub __fpu_zmm24: __darwin_zmm_reg,
    pub __fpu_zmm25: __darwin_zmm_reg,
    pub __fpu_zmm26: __darwin_zmm_reg,
    pub __fpu_zmm27: __darwin_zmm_reg,
    pub __fpu_zmm28: __darwin_zmm_reg,
    pub __fpu_zmm29: __darwin_zmm_reg,
    pub __fpu_zmm30: __darwin_zmm_reg,
    pub __fpu_zmm31: __darwin_zmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx512_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx512_state64>(),
        2444usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx512_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh8 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh9 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh10 as *const _
                as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh11 as *const _
                as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh12 as *const _
                as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh13 as *const _
                as usize
        },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh14 as *const _
                as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh15 as *const _
                as usize
        },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k0 as *const _ as usize
        },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k1 as *const _ as usize
        },
        852usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k2 as *const _ as usize
        },
        860usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k3 as *const _ as usize
        },
        868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k4 as *const _ as usize
        },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k5 as *const _ as usize
        },
        884usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k6 as *const _ as usize
        },
        892usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k7 as *const _ as usize
        },
        900usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh0 as *const _ as usize
        },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh1 as *const _ as usize
        },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh2 as *const _ as usize
        },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh3 as *const _ as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh4 as *const _ as usize
        },
        1036usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh5 as *const _ as usize
        },
        1068usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh6 as *const _ as usize
        },
        1100usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh7 as *const _ as usize
        },
        1132usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh8 as *const _ as usize
        },
        1164usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh9 as *const _ as usize
        },
        1196usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh10 as *const _
                as usize
        },
        1228usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh11 as *const _
                as usize
        },
        1260usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh12 as *const _
                as usize
        },
        1292usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh13 as *const _
                as usize
        },
        1324usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh14 as *const _
                as usize
        },
        1356usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh15 as *const _
                as usize
        },
        1388usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm16 as *const _ as usize
        },
        1420usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm17 as *const _ as usize
        },
        1484usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm17)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm18 as *const _ as usize
        },
        1548usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm18)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm19 as *const _ as usize
        },
        1612usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm19)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm20 as *const _ as usize
        },
        1676usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm20)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm21 as *const _ as usize
        },
        1740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm21)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm22 as *const _ as usize
        },
        1804usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm22)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm23 as *const _ as usize
        },
        1868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm23)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm24 as *const _ as usize
        },
        1932usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm24)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm25 as *const _ as usize
        },
        1996usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm25)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm26 as *const _ as usize
        },
        2060usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm26)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm27 as *const _ as usize
        },
        2124usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm27)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm28 as *const _ as usize
        },
        2188usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm28)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm29 as *const _ as usize
        },
        2252usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm29)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm30 as *const _ as usize
        },
        2316usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm30)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm31 as *const _ as usize
        },
        2380usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm31)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_exception_state64 {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_exception_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_exception_state64>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_exception_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__trapno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__cpu as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__err as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__faultvaddr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state64 {
    pub __dr0: __uint64_t,
    pub __dr1: __uint64_t,
    pub __dr2: __uint64_t,
    pub __dr3: __uint64_t,
    pub __dr4: __uint64_t,
    pub __dr5: __uint64_t,
    pub __dr6: __uint64_t,
    pub __dr7: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state64>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr0 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr1 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr3 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr4 as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr5 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr6 as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr7 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_cpmu_state64 {
    pub __ctrs: [__uint64_t; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_x86_cpmu_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_cpmu_state64>(),
        128usize,
        concat!("Size of: ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_cpmu_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_cpmu_state64>())).__ctrs as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_cpmu_state64),
            "::",
            stringify!(__ctrs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_float_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext32>(),
        600usize,
        concat!("Size of: ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__fs as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx32>(),
        792usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__fs as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx512_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_32>(),
        1112usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__ss as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__fs as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64>(),
        712usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64_full>(),
        744usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__fs as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64>(),
        1032usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64_full>(),
        1064usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__fs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64>(),
        2632usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__fs as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64_full>(),
        2664usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64_full>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_mcontext_avx512_64_full)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__fs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__fs)
        )
    );
}
pub type mcontext_t = *mut __darwin_mcontext64;
pub type pthread_attr_t = __darwin_pthread_attr_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: __darwin_size_t,
    pub ss_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_sigaltstack() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_sigaltstack>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_sigaltstack>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_flags)
        )
    );
}
pub type stack_t = __darwin_sigaltstack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ucontext {
    pub uc_onstack: ::std::os::raw::c_int,
    pub uc_sigmask: __darwin_sigset_t,
    pub uc_stack: __darwin_sigaltstack,
    pub uc_link: *mut __darwin_ucontext,
    pub uc_mcsize: __darwin_size_t,
    pub uc_mcontext: *mut __darwin_mcontext64,
}
#[test]
fn bindgen_test_layout___darwin_ucontext() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ucontext>(),
        56usize,
        concat!("Size of: ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_onstack as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_onstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_sigmask as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_sigmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_stack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_link as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcsize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcontext as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcontext)
        )
    );
}
pub type ucontext_t = __darwin_ucontext;
pub type sigset_t = __darwin_sigset_t;
pub type size_t = __darwin_size_t;
pub type uid_t = __darwin_uid_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_sigval() {
    assert_eq!(
        ::std::mem::size_of::<sigval>(),
        8usize,
        concat!("Size of: ", stringify!(sigval))
    );
    assert_eq!(
        ::std::mem::align_of::<sigval>(),
        8usize,
        concat!("Alignment of ", stringify!(sigval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_int as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_int)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_ptr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_value: sigval,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut pthread_attr_t,
}
#[test]
fn bindgen_test_layout_sigevent() {
    assert_eq!(
        ::std::mem::size_of::<sigevent>(),
        32usize,
        concat!("Size of: ", stringify!(sigevent))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_signo as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify_function as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_function)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent>())).sigev_notify_attributes as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_attributes)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __siginfo {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub si_pid: pid_t,
    pub si_uid: uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_value: sigval,
    pub si_band: ::std::os::raw::c_long,
    pub __pad: [::std::os::raw::c_ulong; 7usize],
}
#[test]
fn bindgen_test_layout___siginfo() {
    assert_eq!(
        ::std::mem::size_of::<__siginfo>(),
        104usize,
        concat!("Size of: ", stringify!(__siginfo))
    );
    assert_eq!(
        ::std::mem::align_of::<__siginfo>(),
        8usize,
        concat!("Alignment of ", stringify!(__siginfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_signo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_errno as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_errno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_pid as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_status as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_addr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_value as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_band as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_band)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).__pad as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(__pad)
        )
    );
}
pub type siginfo_t = __siginfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sigaction_u {
    pub __sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub __sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut __siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout___sigaction_u() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction_u>(),
        8usize,
        concat!("Size of: ", stringify!(__sigaction_u))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction_u>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction_u))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_sigaction as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_sigaction)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_tramp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: *mut siginfo_t,
            arg5: *mut ::std::os::raw::c_void,
        ),
    >,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sigaction() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction>(),
        24usize,
        concat!("Size of: ", stringify!(__sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_tramp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_tramp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_mask as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_flags as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigaction() {
    assert_eq!(
        ::std::mem::size_of::<sigaction>(),
        16usize,
        concat!("Size of: ", stringify!(sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigvec {
    pub sv_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub sv_mask: ::std::os::raw::c_int,
    pub sv_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigvec() {
    assert_eq!(
        ::std::mem::size_of::<sigvec>(),
        16usize,
        concat!("Size of: ", stringify!(sigvec))
    );
    assert_eq!(
        ::std::mem::align_of::<sigvec>(),
        8usize,
        concat!("Alignment of ", stringify!(sigvec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_char,
    pub ss_onstack: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigstack() {
    assert_eq!(
        ::std::mem::size_of::<sigstack>(),
        16usize,
        concat!("Size of: ", stringify!(sigstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigstack>(),
        8usize,
        concat!("Alignment of ", stringify!(sigstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_onstack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_onstack)
        )
    );
}
extern "C" {
    pub fn signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type int_fast16_t = i16;
pub type int_fast32_t = i32;
pub type int_fast64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast16_t = u16;
pub type uint_fast32_t = u32;
pub type uint_fast64_t = u64;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __darwin_time_t,
    pub tv_usec: __darwin_suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
pub type rlim_t = __uint64_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage {
    pub ru_utime: timeval,
    pub ru_stime: timeval,
    pub ru_maxrss: ::std::os::raw::c_long,
    pub ru_ixrss: ::std::os::raw::c_long,
    pub ru_idrss: ::std::os::raw::c_long,
    pub ru_isrss: ::std::os::raw::c_long,
    pub ru_minflt: ::std::os::raw::c_long,
    pub ru_majflt: ::std::os::raw::c_long,
    pub ru_nswap: ::std::os::raw::c_long,
    pub ru_inblock: ::std::os::raw::c_long,
    pub ru_oublock: ::std::os::raw::c_long,
    pub ru_msgsnd: ::std::os::raw::c_long,
    pub ru_msgrcv: ::std::os::raw::c_long,
    pub ru_nsignals: ::std::os::raw::c_long,
    pub ru_nvcsw: ::std::os::raw::c_long,
    pub ru_nivcsw: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_rusage() {
    assert_eq!(
        ::std::mem::size_of::<rusage>(),
        144usize,
        concat!("Size of: ", stringify!(rusage))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_utime as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_utime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_stime as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_stime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_maxrss as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_maxrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_ixrss as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_ixrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_idrss as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_idrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_isrss as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_isrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_minflt as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_minflt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_majflt as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_majflt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nswap as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nswap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_inblock as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_inblock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_oublock as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_oublock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_msgsnd as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_msgsnd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_msgrcv as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_msgrcv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nsignals as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nsignals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nvcsw as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nvcsw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nivcsw as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nivcsw)
        )
    );
}
pub type rusage_info_t = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v0 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v0() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v0>(),
        96usize,
        concat!("Size of: ", stringify!(rusage_info_v0))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v0>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v0))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v1 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v1() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v1>(),
        144usize,
        concat!("Size of: ", stringify!(rusage_info_v1))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v1>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v2 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v2() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v2>(),
        160usize,
        concat!("Size of: ", stringify!(rusage_info_v2))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v3 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v3() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v3>(),
        232usize,
        concat!("Size of: ", stringify!(rusage_info_v3))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v3>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v3))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v4 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v4() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v4>(),
        296usize,
        concat!("Size of: ", stringify!(rusage_info_v4))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v4>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v4))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_logical_writes as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_logical_writes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_lifetime_max_phys_footprint as *const _
                as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_lifetime_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_instructions as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_instructions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_cycles as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cycles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_billed_energy as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_billed_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_serviced_energy as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_serviced_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_interval_max_phys_footprint as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_interval_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_runnable_time as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_runnable_time)
        )
    );
}
pub type rusage_info_current = rusage_info_v4;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rlimit {
    pub rlim_cur: rlim_t,
    pub rlim_max: rlim_t,
}
#[test]
fn bindgen_test_layout_rlimit() {
    assert_eq!(
        ::std::mem::size_of::<rlimit>(),
        16usize,
        concat!("Size of: ", stringify!(rlimit))
    );
    assert_eq!(
        ::std::mem::align_of::<rlimit>(),
        8usize,
        concat!("Alignment of ", stringify!(rlimit))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rlimit>())).rlim_cur as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rlimit),
            "::",
            stringify!(rlim_cur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rlimit>())).rlim_max as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rlimit),
            "::",
            stringify!(rlim_max)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc_rlimit_control_wakeupmon {
    pub wm_flags: u32,
    pub wm_rate: i32,
}
#[test]
fn bindgen_test_layout_proc_rlimit_control_wakeupmon() {
    assert_eq!(
        ::std::mem::size_of::<proc_rlimit_control_wakeupmon>(),
        8usize,
        concat!("Size of: ", stringify!(proc_rlimit_control_wakeupmon))
    );
    assert_eq!(
        ::std::mem::align_of::<proc_rlimit_control_wakeupmon>(),
        4usize,
        concat!("Alignment of ", stringify!(proc_rlimit_control_wakeupmon))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<proc_rlimit_control_wakeupmon>())).wm_flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(proc_rlimit_control_wakeupmon),
            "::",
            stringify!(wm_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<proc_rlimit_control_wakeupmon>())).wm_rate as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(proc_rlimit_control_wakeupmon),
            "::",
            stringify!(wm_rate)
        )
    );
}
extern "C" {
    pub fn getpriority(arg1: ::std::os::raw::c_int, arg2: id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getiopolicy_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getrlimit(arg1: ::std::os::raw::c_int, arg2: *mut rlimit) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getrusage(arg1: ::std::os::raw::c_int, arg2: *mut rusage) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setpriority(
        arg1: ::std::os::raw::c_int,
        arg2: id_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setiopolicy_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setrlimit(arg1: ::std::os::raw::c_int, arg2: *const rlimit) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union wait {
    pub w_status: ::std::os::raw::c_int,
    pub w_T: wait__bindgen_ty_1,
    pub w_S: wait__bindgen_ty_2,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_1))
    );
}
impl wait__bindgen_ty_1 {
    #[inline]
    pub fn w_Termsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_w_Termsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Coredump(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_w_Coredump(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Retcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Retcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Termsig: ::std::os::raw::c_uint,
        w_Coredump: ::std::os::raw::c_uint,
        w_Retcode: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let w_Termsig: u32 = unsafe { ::std::mem::transmute(w_Termsig) };
            w_Termsig as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let w_Coredump: u32 = unsafe { ::std::mem::transmute(w_Coredump) };
            w_Coredump as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Retcode: u32 = unsafe { ::std::mem::transmute(w_Retcode) };
            w_Retcode as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_2 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_2))
    );
}
impl wait__bindgen_ty_2 {
    #[inline]
    pub fn w_Stopval(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopval(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Stopsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Stopval: ::std::os::raw::c_uint,
        w_Stopsig: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let w_Stopval: u32 = unsafe { ::std::mem::transmute(w_Stopval) };
            w_Stopval as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Stopsig: u32 = unsafe { ::std::mem::transmute(w_Stopsig) };
            w_Stopsig as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_wait() {
    assert_eq!(
        ::std::mem::size_of::<wait>(),
        4usize,
        concat!("Size of: ", stringify!(wait))
    );
    assert_eq!(
        ::std::mem::align_of::<wait>(),
        4usize,
        concat!("Alignment of ", stringify!(wait))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(w_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_T as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait), "::", stringify!(w_T))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_S as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait), "::", stringify!(w_S))
    );
}
extern "C" {
    pub fn wait(arg1: *mut ::std::os::raw::c_int) -> pid_t;
}
extern "C" {
    pub fn waitpid(
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> pid_t;
}
extern "C" {
    pub fn waitid(
        arg1: idtype_t,
        arg2: id_t,
        arg3: *mut siginfo_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wait3(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: *mut rusage,
    ) -> pid_t;
}
extern "C" {
    pub fn wait4(
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut rusage,
    ) -> pid_t;
}
extern "C" {
    pub fn alloca(arg1: size_t) -> *mut ::std::os::raw::c_void;
}
pub type ct_rune_t = __darwin_ct_rune_t;
pub type rune_t = __darwin_rune_t;
pub type wchar_t = __darwin_wchar_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub static mut __mb_cur_max: ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __count: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(arg1: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(arg1: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn aligned_alloc(__alignment: size_t, __size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: size_t,
        __size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn abs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atexit(arg1: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atof(arg1: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn div(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn labs(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn ldiv(arg1: ::std::os::raw::c_long, arg2: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn llabs(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn lldiv(arg1: ::std::os::raw::c_longlong, arg2: ::std::os::raw::c_longlong) -> lldiv_t;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn mbtowc(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(arg1: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn strtod(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtol(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtold(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
extern "C" {
    pub fn strtoll(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoul(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoull(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn system(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcstombs(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const wchar_t,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn wctomb(arg1: *mut ::std::os::raw::c_char, arg2: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _Exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn a64l(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn ecvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn erand48(arg1: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn fcvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getsubopt(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn grantpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate(
        arg1: ::std::os::raw::c_uint,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn jrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn l64a(arg1: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn lcong48(arg1: *mut ::std::os::raw::c_ushort);
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mktemp(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn posix_openpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ptsname(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ptsname_r(
        fildes: ::std::os::raw::c_int,
        buffer: *mut ::std::os::raw::c_char,
        buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putenv(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rand_r(arg1: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_realpath$DARWIN_EXTSN"]
    pub fn realpath(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn seed48(arg1: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __overwrite: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setkey(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn setstate(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn srand48(arg1: ::std::os::raw::c_long);
}
extern "C" {
    pub fn srandom(arg1: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn unlockpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
pub type dev_t = __darwin_dev_t;
pub type mode_t = __darwin_mode_t;
extern "C" {
    pub fn arc4random() -> u32;
}
extern "C" {
    pub fn arc4random_addrandom(arg1: *mut ::std::os::raw::c_uchar, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn arc4random_buf(__buf: *mut ::std::os::raw::c_void, __nbytes: size_t);
}
extern "C" {
    pub fn arc4random_stir();
}
extern "C" {
    pub fn arc4random_uniform(__upper_bound: u32) -> u32;
}
extern "C" {
    pub fn atexit_b(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bsearch_b(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn cgetcap(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn cgetclose() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetent(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetfirst(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetmatch(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetnext(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetnum(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetset(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetstr(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetustr(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_daemon$1050"]
    pub fn daemon(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn devname(arg1: dev_t, arg2: mode_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn devname_r(
        arg1: dev_t,
        arg2: mode_t,
        buf: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getbsize(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_long,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getloadavg(arg1: *mut f64, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getprogname() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn setprogname(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn heapsort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn heapsort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mergesort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mergesort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn psort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn psort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn psort_r(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn qsort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn qsort_r(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn radixsort(
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rpmatch(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sradixsort(
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sranddev();
}
extern "C" {
    pub fn srandomdev();
}
extern "C" {
    pub fn reallocf(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strtoq(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub static mut suboptarg: *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GuiStyleProp {
    pub controlId: ::std::os::raw::c_ushort,
    pub propertyId: ::std::os::raw::c_ushort,
    pub propertyValue: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_GuiStyleProp() {
    assert_eq!(
        ::std::mem::size_of::<GuiStyleProp>(),
        8usize,
        concat!("Size of: ", stringify!(GuiStyleProp))
    );
    assert_eq!(
        ::std::mem::align_of::<GuiStyleProp>(),
        4usize,
        concat!("Alignment of ", stringify!(GuiStyleProp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GuiStyleProp>())).controlId as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GuiStyleProp),
            "::",
            stringify!(controlId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GuiStyleProp>())).propertyId as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(GuiStyleProp),
            "::",
            stringify!(propertyId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GuiStyleProp>())).propertyValue as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GuiStyleProp),
            "::",
            stringify!(propertyValue)
        )
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiControlState {
    GUI_STATE_NORMAL = 0,
    GUI_STATE_FOCUSED = 1,
    GUI_STATE_PRESSED = 2,
    GUI_STATE_DISABLED = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiTextAlignment {
    GUI_TEXT_ALIGN_LEFT = 0,
    GUI_TEXT_ALIGN_CENTER = 1,
    GUI_TEXT_ALIGN_RIGHT = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiControl {
    DEFAULT = 0,
    LABEL = 1,
    BUTTON = 2,
    TOGGLE = 3,
    SLIDER = 4,
    PROGRESSBAR = 5,
    CHECKBOX = 6,
    COMBOBOX = 7,
    DROPDOWNBOX = 8,
    TEXTBOX = 9,
    VALUEBOX = 10,
    SPINNER = 11,
    LISTVIEW = 12,
    COLORPICKER = 13,
    SCROLLBAR = 14,
    STATUSBAR = 15,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiControlProperty {
    BORDER_COLOR_NORMAL = 0,
    BASE_COLOR_NORMAL = 1,
    TEXT_COLOR_NORMAL = 2,
    BORDER_COLOR_FOCUSED = 3,
    BASE_COLOR_FOCUSED = 4,
    TEXT_COLOR_FOCUSED = 5,
    BORDER_COLOR_PRESSED = 6,
    BASE_COLOR_PRESSED = 7,
    TEXT_COLOR_PRESSED = 8,
    BORDER_COLOR_DISABLED = 9,
    BASE_COLOR_DISABLED = 10,
    TEXT_COLOR_DISABLED = 11,
    BORDER_WIDTH = 12,
    TEXT_PADDING = 13,
    TEXT_ALIGNMENT = 14,
    RESERVED = 15,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiDefaultProperty {
    TEXT_SIZE = 16,
    TEXT_SPACING = 17,
    LINE_COLOR = 18,
    BACKGROUND_COLOR = 19,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiToggleProperty {
    GROUP_PADDING = 16,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiSliderProperty {
    SLIDER_WIDTH = 16,
    SLIDER_PADDING = 17,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiProgressBarProperty {
    PROGRESS_PADDING = 16,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiCheckBoxProperty {
    CHECK_PADDING = 16,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiComboBoxProperty {
    COMBO_BUTTON_WIDTH = 16,
    COMBO_BUTTON_PADDING = 17,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiDropdownBoxProperty {
    ARROW_PADDING = 16,
    DROPDOWN_ITEMS_PADDING = 17,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiTextBoxProperty {
    TEXT_INNER_PADDING = 16,
    TEXT_LINES_PADDING = 17,
    COLOR_SELECTED_FG = 18,
    COLOR_SELECTED_BG = 19,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiSpinnerProperty {
    SPIN_BUTTON_WIDTH = 16,
    SPIN_BUTTON_PADDING = 17,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiScrollBarProperty {
    ARROWS_SIZE = 16,
    ARROWS_VISIBLE = 17,
    SCROLL_SLIDER_PADDING = 18,
    SCROLL_SLIDER_SIZE = 19,
    SCROLL_PADDING = 20,
    SCROLL_SPEED = 21,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiScrollBarSide {
    SCROLLBAR_LEFT_SIDE = 0,
    SCROLLBAR_RIGHT_SIDE = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiListViewProperty {
    LIST_ITEMS_HEIGHT = 16,
    LIST_ITEMS_PADDING = 17,
    SCROLLBAR_WIDTH = 18,
    SCROLLBAR_SIDE = 19,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiColorPickerProperty {
    COLOR_SELECTOR_SIZE = 16,
    HUEBAR_WIDTH = 17,
    HUEBAR_PADDING = 18,
    HUEBAR_SELECTOR_HEIGHT = 19,
    HUEBAR_SELECTOR_OVERFLOW = 20,
}
extern "C" {
    pub fn GuiEnable();
}
extern "C" {
    pub fn GuiDisable();
}
extern "C" {
    pub fn GuiLock();
}
extern "C" {
    pub fn GuiUnlock();
}
extern "C" {
    pub fn GuiFade(alpha: f32);
}
extern "C" {
    pub fn GuiSetState(state: ::std::os::raw::c_int);
}
extern "C" {
    pub fn GuiGetState() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GuiSetFont(font: Font);
}
extern "C" {
    pub fn GuiGetFont() -> Font;
}
extern "C" {
    pub fn GuiSetStyle(
        control: ::std::os::raw::c_int,
        property: ::std::os::raw::c_int,
        value: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn GuiGetStyle(
        control: ::std::os::raw::c_int,
        property: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GuiEnableTooltip();
}
extern "C" {
    pub fn GuiDisableTooltip();
}
extern "C" {
    pub fn GuiSetTooltip(tooltip: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn GuiClearTooltip();
}
extern "C" {
    pub fn GuiWindowBox(bounds: Rectangle, title: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn GuiGroupBox(bounds: Rectangle, text: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn GuiLine(bounds: Rectangle, text: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn GuiPanel(bounds: Rectangle);
}
extern "C" {
    pub fn GuiScrollPanel(bounds: Rectangle, content: Rectangle, scroll: *mut Vector2)
        -> Rectangle;
}
extern "C" {
    pub fn GuiLabel(bounds: Rectangle, text: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn GuiButton(bounds: Rectangle, text: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn GuiLabelButton(bounds: Rectangle, text: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn GuiImageButton(
        bounds: Rectangle,
        text: *const ::std::os::raw::c_char,
        texture: Texture2D,
    ) -> bool;
}
extern "C" {
    pub fn GuiImageButtonEx(
        bounds: Rectangle,
        text: *const ::std::os::raw::c_char,
        texture: Texture2D,
        texSource: Rectangle,
    ) -> bool;
}
extern "C" {
    pub fn GuiToggle(bounds: Rectangle, text: *const ::std::os::raw::c_char, active: bool) -> bool;
}
extern "C" {
    pub fn GuiToggleGroup(
        bounds: Rectangle,
        text: *const ::std::os::raw::c_char,
        active: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GuiCheckBox(
        bounds: Rectangle,
        text: *const ::std::os::raw::c_char,
        checked: bool,
    ) -> bool;
}
extern "C" {
    pub fn GuiComboBox(
        bounds: Rectangle,
        text: *const ::std::os::raw::c_char,
        active: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GuiDropdownBox(
        bounds: Rectangle,
        text: *const ::std::os::raw::c_char,
        active: *mut ::std::os::raw::c_int,
        editMode: bool,
    ) -> bool;
}
extern "C" {
    pub fn GuiSpinner(
        bounds: Rectangle,
        text: *const ::std::os::raw::c_char,
        value: *mut ::std::os::raw::c_int,
        minValue: ::std::os::raw::c_int,
        maxValue: ::std::os::raw::c_int,
        editMode: bool,
    ) -> bool;
}
extern "C" {
    pub fn GuiValueBox(
        bounds: Rectangle,
        text: *const ::std::os::raw::c_char,
        value: *mut ::std::os::raw::c_int,
        minValue: ::std::os::raw::c_int,
        maxValue: ::std::os::raw::c_int,
        editMode: bool,
    ) -> bool;
}
extern "C" {
    pub fn GuiTextBox(
        bounds: Rectangle,
        text: *mut ::std::os::raw::c_char,
        textSize: ::std::os::raw::c_int,
        editMode: bool,
    ) -> bool;
}
extern "C" {
    pub fn GuiTextBoxMulti(
        bounds: Rectangle,
        text: *mut ::std::os::raw::c_char,
        textSize: ::std::os::raw::c_int,
        editMode: bool,
    ) -> bool;
}
extern "C" {
    pub fn GuiSlider(
        bounds: Rectangle,
        textLeft: *const ::std::os::raw::c_char,
        textRight: *const ::std::os::raw::c_char,
        value: f32,
        minValue: f32,
        maxValue: f32,
    ) -> f32;
}
extern "C" {
    pub fn GuiSliderBar(
        bounds: Rectangle,
        textLeft: *const ::std::os::raw::c_char,
        textRight: *const ::std::os::raw::c_char,
        value: f32,
        minValue: f32,
        maxValue: f32,
    ) -> f32;
}
extern "C" {
    pub fn GuiProgressBar(
        bounds: Rectangle,
        textLeft: *const ::std::os::raw::c_char,
        textRight: *const ::std::os::raw::c_char,
        value: f32,
        minValue: f32,
        maxValue: f32,
    ) -> f32;
}
extern "C" {
    pub fn GuiStatusBar(bounds: Rectangle, text: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn GuiDummyRec(bounds: Rectangle, text: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn GuiScrollBar(
        bounds: Rectangle,
        value: ::std::os::raw::c_int,
        minValue: ::std::os::raw::c_int,
        maxValue: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GuiGrid(bounds: Rectangle, spacing: f32, subdivs: ::std::os::raw::c_int) -> Vector2;
}
extern "C" {
    pub fn GuiListView(
        bounds: Rectangle,
        text: *const ::std::os::raw::c_char,
        scrollIndex: *mut ::std::os::raw::c_int,
        active: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GuiListViewEx(
        bounds: Rectangle,
        text: *mut *const ::std::os::raw::c_char,
        count: ::std::os::raw::c_int,
        focus: *mut ::std::os::raw::c_int,
        scrollIndex: *mut ::std::os::raw::c_int,
        active: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GuiMessageBox(
        bounds: Rectangle,
        title: *const ::std::os::raw::c_char,
        message: *const ::std::os::raw::c_char,
        buttons: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GuiTextInputBox(
        bounds: Rectangle,
        title: *const ::std::os::raw::c_char,
        message: *const ::std::os::raw::c_char,
        buttons: *const ::std::os::raw::c_char,
        text: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GuiColorPicker(bounds: Rectangle, color: Color) -> Color;
}
extern "C" {
    pub fn GuiColorPanel(bounds: Rectangle, color: Color) -> Color;
}
extern "C" {
    pub fn GuiColorBarAlpha(bounds: Rectangle, alpha: f32) -> f32;
}
extern "C" {
    pub fn GuiColorBarHue(bounds: Rectangle, value: f32) -> f32;
}
extern "C" {
    pub fn GuiLoadStyle(fileName: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn GuiLoadStyleDefault();
}
extern "C" {
    pub fn GuiIconText(
        iconId: ::std::os::raw::c_int,
        text: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn GuiDrawIcon(
        iconId: ::std::os::raw::c_int,
        position: Vector2,
        pixelSize: ::std::os::raw::c_int,
        color: Color,
    );
}
extern "C" {
    pub fn GuiGetIcons() -> *mut ::std::os::raw::c_uint;
}
extern "C" {
    pub fn GuiGetIconData(iconId: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_uint;
}
extern "C" {
    pub fn GuiSetIconData(iconId: ::std::os::raw::c_int, data: *mut ::std::os::raw::c_uint);
}
extern "C" {
    pub fn GuiSetIconPixel(
        iconId: ::std::os::raw::c_int,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn GuiClearIconPixel(
        iconId: ::std::os::raw::c_int,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn GuiCheckIconPixel(
        iconId: ::std::os::raw::c_int,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
    ) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum guiIconName {
    RICON_NONE = 0,
    RICON_FOLDER_FILE_OPEN = 1,
    RICON_FILE_SAVE_CLASSIC = 2,
    RICON_FOLDER_OPEN = 3,
    RICON_FOLDER_SAVE = 4,
    RICON_FILE_OPEN = 5,
    RICON_FILE_SAVE = 6,
    RICON_FILE_EXPORT = 7,
    RICON_FILE_NEW = 8,
    RICON_FILE_DELETE = 9,
    RICON_FILETYPE_TEXT = 10,
    RICON_FILETYPE_AUDIO = 11,
    RICON_FILETYPE_IMAGE = 12,
    RICON_FILETYPE_PLAY = 13,
    RICON_FILETYPE_VIDEO = 14,
    RICON_FILETYPE_INFO = 15,
    RICON_FILE_COPY = 16,
    RICON_FILE_CUT = 17,
    RICON_FILE_PASTE = 18,
    RICON_CURSOR_HAND = 19,
    RICON_CURSOR_POINTER = 20,
    RICON_CURSOR_CLASSIC = 21,
    RICON_PENCIL = 22,
    RICON_PENCIL_BIG = 23,
    RICON_BRUSH_CLASSIC = 24,
    RICON_BRUSH_PAINTER = 25,
    RICON_WATER_DROP = 26,
    RICON_COLOR_PICKER = 27,
    RICON_RUBBER = 28,
    RICON_COLOR_BUCKET = 29,
    RICON_TEXT_T = 30,
    RICON_TEXT_A = 31,
    RICON_SCALE = 32,
    RICON_RESIZE = 33,
    RICON_FILTER_POINT = 34,
    RICON_FILTER_BILINEAR = 35,
    RICON_CROP = 36,
    RICON_CROP_ALPHA = 37,
    RICON_SQUARE_TOGGLE = 38,
    RICON_SYMMETRY = 39,
    RICON_SYMMETRY_HORIZONTAL = 40,
    RICON_SYMMETRY_VERTICAL = 41,
    RICON_LENS = 42,
    RICON_LENS_BIG = 43,
    RICON_EYE_ON = 44,
    RICON_EYE_OFF = 45,
    RICON_FILTER_TOP = 46,
    RICON_FILTER = 47,
    RICON_TARGET_POINT = 48,
    RICON_TARGET_SMALL = 49,
    RICON_TARGET_BIG = 50,
    RICON_TARGET_MOVE = 51,
    RICON_CURSOR_MOVE = 52,
    RICON_CURSOR_SCALE = 53,
    RICON_CURSOR_SCALE_RIGHT = 54,
    RICON_CURSOR_SCALE_LEFT = 55,
    RICON_UNDO = 56,
    RICON_REDO = 57,
    RICON_REREDO = 58,
    RICON_MUTATE = 59,
    RICON_ROTATE = 60,
    RICON_REPEAT = 61,
    RICON_SHUFFLE = 62,
    RICON_EMPTYBOX = 63,
    RICON_TARGET = 64,
    RICON_TARGET_SMALL_FILL = 65,
    RICON_TARGET_BIG_FILL = 66,
    RICON_TARGET_MOVE_FILL = 67,
    RICON_CURSOR_MOVE_FILL = 68,
    RICON_CURSOR_SCALE_FILL = 69,
    RICON_CURSOR_SCALE_RIGHT_FILL = 70,
    RICON_CURSOR_SCALE_LEFT_FILL = 71,
    RICON_UNDO_FILL = 72,
    RICON_REDO_FILL = 73,
    RICON_REREDO_FILL = 74,
    RICON_MUTATE_FILL = 75,
    RICON_ROTATE_FILL = 76,
    RICON_REPEAT_FILL = 77,
    RICON_SHUFFLE_FILL = 78,
    RICON_EMPTYBOX_SMALL = 79,
    RICON_BOX = 80,
    RICON_BOX_TOP = 81,
    RICON_BOX_TOP_RIGHT = 82,
    RICON_BOX_RIGHT = 83,
    RICON_BOX_BOTTOM_RIGHT = 84,
    RICON_BOX_BOTTOM = 85,
    RICON_BOX_BOTTOM_LEFT = 86,
    RICON_BOX_LEFT = 87,
    RICON_BOX_TOP_LEFT = 88,
    RICON_BOX_CENTER = 89,
    RICON_BOX_CIRCLE_MASK = 90,
    RICON_POT = 91,
    RICON_ALPHA_MULTIPLY = 92,
    RICON_ALPHA_CLEAR = 93,
    RICON_DITHERING = 94,
    RICON_MIPMAPS = 95,
    RICON_BOX_GRID = 96,
    RICON_GRID = 97,
    RICON_BOX_CORNERS_SMALL = 98,
    RICON_BOX_CORNERS_BIG = 99,
    RICON_FOUR_BOXES = 100,
    RICON_GRID_FILL = 101,
    RICON_BOX_MULTISIZE = 102,
    RICON_ZOOM_SMALL = 103,
    RICON_ZOOM_MEDIUM = 104,
    RICON_ZOOM_BIG = 105,
    RICON_ZOOM_ALL = 106,
    RICON_ZOOM_CENTER = 107,
    RICON_BOX_DOTS_SMALL = 108,
    RICON_BOX_DOTS_BIG = 109,
    RICON_BOX_CONCENTRIC = 110,
    RICON_BOX_GRID_BIG = 111,
    RICON_OK_TICK = 112,
    RICON_CROSS = 113,
    RICON_ARROW_LEFT = 114,
    RICON_ARROW_RIGHT = 115,
    RICON_ARROW_BOTTOM = 116,
    RICON_ARROW_TOP = 117,
    RICON_ARROW_LEFT_FILL = 118,
    RICON_ARROW_RIGHT_FILL = 119,
    RICON_ARROW_BOTTOM_FILL = 120,
    RICON_ARROW_TOP_FILL = 121,
    RICON_AUDIO = 122,
    RICON_FX = 123,
    RICON_WAVE = 124,
    RICON_WAVE_SINUS = 125,
    RICON_WAVE_SQUARE = 126,
    RICON_WAVE_TRIANGULAR = 127,
    RICON_CROSS_SMALL = 128,
    RICON_PLAYER_PREVIOUS = 129,
    RICON_PLAYER_PLAY_BACK = 130,
    RICON_PLAYER_PLAY = 131,
    RICON_PLAYER_PAUSE = 132,
    RICON_PLAYER_STOP = 133,
    RICON_PLAYER_NEXT = 134,
    RICON_PLAYER_RECORD = 135,
    RICON_MAGNET = 136,
    RICON_LOCK_CLOSE = 137,
    RICON_LOCK_OPEN = 138,
    RICON_CLOCK = 139,
    RICON_TOOLS = 140,
    RICON_GEAR = 141,
    RICON_GEAR_BIG = 142,
    RICON_BIN = 143,
    RICON_HAND_POINTER = 144,
    RICON_LASER = 145,
    RICON_COIN = 146,
    RICON_EXPLOSION = 147,
    RICON_1UP = 148,
    RICON_PLAYER = 149,
    RICON_PLAYER_JUMP = 150,
    RICON_KEY = 151,
    RICON_DEMON = 152,
    RICON_TEXT_POPUP = 153,
    RICON_GEAR_EX = 154,
    RICON_CRACK = 155,
    RICON_CRACK_POINTS = 156,
    RICON_STAR = 157,
    RICON_DOOR = 158,
    RICON_EXIT = 159,
    RICON_MODE_2D = 160,
    RICON_MODE_3D = 161,
    RICON_CUBE = 162,
    RICON_CUBE_FACE_TOP = 163,
    RICON_CUBE_FACE_LEFT = 164,
    RICON_CUBE_FACE_FRONT = 165,
    RICON_CUBE_FACE_BOTTOM = 166,
    RICON_CUBE_FACE_RIGHT = 167,
    RICON_CUBE_FACE_BACK = 168,
    RICON_CAMERA = 169,
    RICON_SPECIAL = 170,
    RICON_LINK_NET = 171,
    RICON_LINK_BOXES = 172,
    RICON_LINK_MULTI = 173,
    RICON_LINK = 174,
    RICON_LINK_BROKE = 175,
    RICON_TEXT_NOTES = 176,
    RICON_NOTEBOOK = 177,
    RICON_SUITCASE = 178,
    RICON_SUITCASE_ZIP = 179,
    RICON_MAILBOX = 180,
    RICON_MONITOR = 181,
    RICON_PRINTER = 182,
    RICON_PHOTO_CAMERA = 183,
    RICON_PHOTO_CAMERA_FLASH = 184,
    RICON_HOUSE = 185,
    RICON_HEART = 186,
    RICON_CORNER = 187,
    RICON_VERTICAL_BARS = 188,
    RICON_VERTICAL_BARS_FILL = 189,
    RICON_LIFE_BARS = 190,
    RICON_INFO = 191,
    RICON_CROSSLINE = 192,
    RICON_HELP = 193,
    RICON_FILETYPE_ALPHA = 194,
    RICON_FILETYPE_HOME = 195,
    RICON_LAYERS_VISIBLE = 196,
    RICON_LAYERS = 197,
    RICON_WINDOW = 198,
    RICON_HIDPI = 199,
    RICON_200 = 200,
    RICON_201 = 201,
    RICON_202 = 202,
    RICON_203 = 203,
    RICON_204 = 204,
    RICON_205 = 205,
    RICON_206 = 206,
    RICON_207 = 207,
    RICON_208 = 208,
    RICON_209 = 209,
    RICON_210 = 210,
    RICON_211 = 211,
    RICON_212 = 212,
    RICON_213 = 213,
    RICON_214 = 214,
    RICON_215 = 215,
    RICON_216 = 216,
    RICON_217 = 217,
    RICON_218 = 218,
    RICON_219 = 219,
    RICON_220 = 220,
    RICON_221 = 221,
    RICON_222 = 222,
    RICON_223 = 223,
    RICON_224 = 224,
    RICON_225 = 225,
    RICON_226 = 226,
    RICON_227 = 227,
    RICON_228 = 228,
    RICON_229 = 229,
    RICON_230 = 230,
    RICON_231 = 231,
    RICON_232 = 232,
    RICON_233 = 233,
    RICON_234 = 234,
    RICON_235 = 235,
    RICON_236 = 236,
    RICON_237 = 237,
    RICON_238 = 238,
    RICON_239 = 239,
    RICON_240 = 240,
    RICON_241 = 241,
    RICON_242 = 242,
    RICON_243 = 243,
    RICON_244 = 244,
    RICON_245 = 245,
    RICON_246 = 246,
    RICON_247 = 247,
    RICON_248 = 248,
    RICON_249 = 249,
    RICON_250 = 250,
    RICON_251 = 251,
    RICON_252 = 252,
    RICON_253 = 253,
    RICON_254 = 254,
    RICON_255 = 255,
}
extern "C" {
    pub static mut guiIcons: [::std::os::raw::c_uint; 2048usize];
}
extern "C" {
    pub fn renameat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renamex_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameatx_np(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
pub type fpos_t = __darwin_off_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sbuf {
    pub _base: *mut ::std::os::raw::c_uchar,
    pub _size: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sbuf() {
    assert_eq!(
        ::std::mem::size_of::<__sbuf>(),
        16usize,
        concat!("Size of: ", stringify!(__sbuf))
    );
    assert_eq!(
        ::std::mem::align_of::<__sbuf>(),
        8usize,
        concat!("Alignment of ", stringify!(__sbuf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sbuf>()))._base as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sbuf),
            "::",
            stringify!(_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sbuf>()))._size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sbuf),
            "::",
            stringify!(_size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sFILEX {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sFILE {
    pub _p: *mut ::std::os::raw::c_uchar,
    pub _r: ::std::os::raw::c_int,
    pub _w: ::std::os::raw::c_int,
    pub _flags: ::std::os::raw::c_short,
    pub _file: ::std::os::raw::c_short,
    pub _bf: __sbuf,
    pub _lbfsize: ::std::os::raw::c_int,
    pub _cookie: *mut ::std::os::raw::c_void,
    pub _close: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub _read: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub _seek: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: fpos_t,
            arg3: ::std::os::raw::c_int,
        ) -> fpos_t,
    >,
    pub _write: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub _ub: __sbuf,
    pub _extra: *mut __sFILEX,
    pub _ur: ::std::os::raw::c_int,
    pub _ubuf: [::std::os::raw::c_uchar; 3usize],
    pub _nbuf: [::std::os::raw::c_uchar; 1usize],
    pub _lb: __sbuf,
    pub _blksize: ::std::os::raw::c_int,
    pub _offset: fpos_t,
}
#[test]
fn bindgen_test_layout___sFILE() {
    assert_eq!(
        ::std::mem::size_of::<__sFILE>(),
        152usize,
        concat!("Size of: ", stringify!(__sFILE))
    );
    assert_eq!(
        ::std::mem::align_of::<__sFILE>(),
        8usize,
        concat!("Alignment of ", stringify!(__sFILE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._r as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_r)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._w as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._file as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._bf as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_bf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._lbfsize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_lbfsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._cookie as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_cookie)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._close as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._read as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._seek as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._write as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._ub as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_ub)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._extra as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_extra)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._ur as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_ur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._ubuf as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_ubuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._nbuf as *const _ as usize },
        119usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_nbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._lb as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_lb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._blksize as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._offset as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_offset)
        )
    );
}
pub type FILE = __sFILE;
extern "C" {
    pub static mut __stdinp: *mut FILE;
}
extern "C" {
    pub static mut __stdoutp: *mut FILE;
}
extern "C" {
    pub static mut __stderrp: *mut FILE;
}
extern "C" {
    pub fn clearerr(arg1: *mut FILE);
}
extern "C" {
    pub fn fclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn feof(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetpos(arg1: *mut FILE, arg2: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputs(arg1: *const ::std::os::raw::c_char, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __nitems: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn freopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fscanf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fseek(
        arg1: *mut FILE,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(arg1: *mut FILE, arg2: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(arg1: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __nitems: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn getc(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gets(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn perror(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn printf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn remove(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rewind(arg1: *mut FILE);
}
extern "C" {
    pub fn scanf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuf(arg1: *mut FILE, arg2: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        arg1: *mut FILE,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ungetc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fdopen(arg1: ::std::os::raw::c_int, arg2: *const ::std::os::raw::c_char) -> *mut FILE;
}
extern "C" {
    pub fn fileno(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn __srget(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __svfscanf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __swbuf(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flockfile(arg1: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(arg1: *mut FILE);
}
extern "C" {
    pub fn getc_unlocked(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __prefix: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type off_t = __darwin_off_t;
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __offset: off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> off_t;
}
extern "C" {
    pub fn snprintf(
        __str: *mut ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __str: *mut ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __str: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
pub type ssize_t = __darwin_ssize_t;
extern "C" {
    pub fn dprintf(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdelim(
        __linep: *mut *mut ::std::os::raw::c_char,
        __linecapp: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> ssize_t;
}
extern "C" {
    pub fn getline(
        __linep: *mut *mut ::std::os::raw::c_char,
        __linecapp: *mut size_t,
        __stream: *mut FILE,
    ) -> ssize_t;
}
extern "C" {
    pub fn fmemopen(
        __buf: *mut ::std::os::raw::c_void,
        __size: size_t,
        __mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufp: *mut *mut ::std::os::raw::c_char,
        __sizep: *mut size_t,
    ) -> *mut FILE;
}
extern "C" {
    pub static sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn asprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid_r(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fgetln(arg1: *mut FILE, arg2: *mut size_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fmtcheck(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn fpurge(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(
        arg1: *mut FILE,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn setlinebuf(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vasprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn zopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> *mut FILE;
}
extern "C" {
    pub fn funopen(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: fpos_t,
                arg3: ::std::os::raw::c_int,
            ) -> fpos_t,
        >,
        arg5: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
        >,
    ) -> *mut FILE;
}
extern "C" {
    pub fn __sprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: size_t,
        arg4: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __snprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
        arg5: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __vsprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: size_t,
        arg4: *const ::std::os::raw::c_char,
        arg5: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __vsnprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
        arg5: *const ::std::os::raw::c_char,
        arg6: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memcpy(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __len: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        __b: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __len: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcat(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strerror(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlen(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strncat(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strstr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        __str: *mut ::std::os::raw::c_char,
        __sep: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strxfrm(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtok_r(
        __str: *mut ::std::os::raw::c_char,
        __sep: *const ::std::os::raw::c_char,
        __lasts: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __strerrbuf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strdup(__s1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn memccpy(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn stpcpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(__s1: *const ::std::os::raw::c_char, __n: size_t)
        -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strnlen(__s1: *const ::std::os::raw::c_char, __n: size_t) -> size_t;
}
extern "C" {
    pub fn strsignal(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn memmem(
        __big: *const ::std::os::raw::c_void,
        __big_len: size_t,
        __little: *const ::std::os::raw::c_void,
        __little_len: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset_pattern4(
        __b: *mut ::std::os::raw::c_void,
        __pattern4: *const ::std::os::raw::c_void,
        __len: size_t,
    );
}
extern "C" {
    pub fn memset_pattern8(
        __b: *mut ::std::os::raw::c_void,
        __pattern8: *const ::std::os::raw::c_void,
        __len: size_t,
    );
}
extern "C" {
    pub fn memset_pattern16(
        __b: *mut ::std::os::raw::c_void,
        __pattern16: *const ::std::os::raw::c_void,
        __len: size_t,
    );
}
extern "C" {
    pub fn strcasestr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strnstr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
        __len: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlcat(
        __dst: *mut ::std::os::raw::c_char,
        __source: *const ::std::os::raw::c_char,
        __size: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn strlcpy(
        __dst: *mut ::std::os::raw::c_char,
        __source: *const ::std::os::raw::c_char,
        __size: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn strmode(__mode: ::std::os::raw::c_int, __bp: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn swab(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ssize_t,
    );
}
extern "C" {
    pub fn timingsafe_bcmp(
        __b1: *const ::std::os::raw::c_void,
        __b2: *const ::std::os::raw::c_void,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcmp(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcopy(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    );
}
extern "C" {
    pub fn bzero(arg1: *mut ::std::os::raw::c_void, arg2: size_t);
}
extern "C" {
    pub fn index(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsl(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsll(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fls(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flsl(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flsll(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
pub type float_t = f32;
pub type double_t = f64;
extern "C" {
    pub fn __math_errhandling() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __fpclassifyf(arg1: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __fpclassifyd(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __fpclassifyl(arg1: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acosf(arg1: f32) -> f32;
}
extern "C" {
    pub fn acos(arg1: f64) -> f64;
}
extern "C" {
    pub fn acosl(arg1: u128) -> u128;
}
extern "C" {
    pub fn asinf(arg1: f32) -> f32;
}
extern "C" {
    pub fn asin(arg1: f64) -> f64;
}
extern "C" {
    pub fn asinl(arg1: u128) -> u128;
}
extern "C" {
    pub fn atanf(arg1: f32) -> f32;
}
extern "C" {
    pub fn atan(arg1: f64) -> f64;
}
extern "C" {
    pub fn atanl(arg1: u128) -> u128;
}
extern "C" {
    pub fn atan2f(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn atan2(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn atan2l(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn cosf(arg1: f32) -> f32;
}
extern "C" {
    pub fn cos(arg1: f64) -> f64;
}
extern "C" {
    pub fn cosl(arg1: u128) -> u128;
}
extern "C" {
    pub fn sinf(arg1: f32) -> f32;
}
extern "C" {
    pub fn sin(arg1: f64) -> f64;
}
extern "C" {
    pub fn sinl(arg1: u128) -> u128;
}
extern "C" {
    pub fn tanf(arg1: f32) -> f32;
}
extern "C" {
    pub fn tan(arg1: f64) -> f64;
}
extern "C" {
    pub fn tanl(arg1: u128) -> u128;
}
extern "C" {
    pub fn acoshf(arg1: f32) -> f32;
}
extern "C" {
    pub fn acosh(arg1: f64) -> f64;
}
extern "C" {
    pub fn acoshl(arg1: u128) -> u128;
}
extern "C" {
    pub fn asinhf(arg1: f32) -> f32;
}
extern "C" {
    pub fn asinh(arg1: f64) -> f64;
}
extern "C" {
    pub fn asinhl(arg1: u128) -> u128;
}
extern "C" {
    pub fn atanhf(arg1: f32) -> f32;
}
extern "C" {
    pub fn atanh(arg1: f64) -> f64;
}
extern "C" {
    pub fn atanhl(arg1: u128) -> u128;
}
extern "C" {
    pub fn coshf(arg1: f32) -> f32;
}
extern "C" {
    pub fn cosh(arg1: f64) -> f64;
}
extern "C" {
    pub fn coshl(arg1: u128) -> u128;
}
extern "C" {
    pub fn sinhf(arg1: f32) -> f32;
}
extern "C" {
    pub fn sinh(arg1: f64) -> f64;
}
extern "C" {
    pub fn sinhl(arg1: u128) -> u128;
}
extern "C" {
    pub fn tanhf(arg1: f32) -> f32;
}
extern "C" {
    pub fn tanh(arg1: f64) -> f64;
}
extern "C" {
    pub fn tanhl(arg1: u128) -> u128;
}
extern "C" {
    pub fn expf(arg1: f32) -> f32;
}
extern "C" {
    pub fn exp(arg1: f64) -> f64;
}
extern "C" {
    pub fn expl(arg1: u128) -> u128;
}
extern "C" {
    pub fn exp2f(arg1: f32) -> f32;
}
extern "C" {
    pub fn exp2(arg1: f64) -> f64;
}
extern "C" {
    pub fn exp2l(arg1: u128) -> u128;
}
extern "C" {
    pub fn expm1f(arg1: f32) -> f32;
}
extern "C" {
    pub fn expm1(arg1: f64) -> f64;
}
extern "C" {
    pub fn expm1l(arg1: u128) -> u128;
}
extern "C" {
    pub fn logf(arg1: f32) -> f32;
}
extern "C" {
    pub fn log(arg1: f64) -> f64;
}
extern "C" {
    pub fn logl(arg1: u128) -> u128;
}
extern "C" {
    pub fn log10f(arg1: f32) -> f32;
}
extern "C" {
    pub fn log10(arg1: f64) -> f64;
}
extern "C" {
    pub fn log10l(arg1: u128) -> u128;
}
extern "C" {
    pub fn log2f(arg1: f32) -> f32;
}
extern "C" {
    pub fn log2(arg1: f64) -> f64;
}
extern "C" {
    pub fn log2l(arg1: u128) -> u128;
}
extern "C" {
    pub fn log1pf(arg1: f32) -> f32;
}
extern "C" {
    pub fn log1p(arg1: f64) -> f64;
}
extern "C" {
    pub fn log1pl(arg1: u128) -> u128;
}
extern "C" {
    pub fn logbf(arg1: f32) -> f32;
}
extern "C" {
    pub fn logb(arg1: f64) -> f64;
}
extern "C" {
    pub fn logbl(arg1: u128) -> u128;
}
extern "C" {
    pub fn modff(arg1: f32, arg2: *mut f32) -> f32;
}
extern "C" {
    pub fn modf(arg1: f64, arg2: *mut f64) -> f64;
}
extern "C" {
    pub fn modfl(arg1: u128, arg2: *mut u128) -> u128;
}
extern "C" {
    pub fn ldexpf(arg1: f32, arg2: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn ldexp(arg1: f64, arg2: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn ldexpl(arg1: u128, arg2: ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn frexpf(arg1: f32, arg2: *mut ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn frexp(arg1: f64, arg2: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn frexpl(arg1: u128, arg2: *mut ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn ilogbf(arg1: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ilogb(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ilogbl(arg1: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scalbnf(arg1: f32, arg2: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn scalbn(arg1: f64, arg2: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn scalbnl(arg1: u128, arg2: ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn scalblnf(arg1: f32, arg2: ::std::os::raw::c_long) -> f32;
}
extern "C" {
    pub fn scalbln(arg1: f64, arg2: ::std::os::raw::c_long) -> f64;
}
extern "C" {
    pub fn scalblnl(arg1: u128, arg2: ::std::os::raw::c_long) -> u128;
}
extern "C" {
    pub fn fabsf(arg1: f32) -> f32;
}
extern "C" {
    pub fn fabs(arg1: f64) -> f64;
}
extern "C" {
    pub fn fabsl(arg1: u128) -> u128;
}
extern "C" {
    pub fn cbrtf(arg1: f32) -> f32;
}
extern "C" {
    pub fn cbrt(arg1: f64) -> f64;
}
extern "C" {
    pub fn cbrtl(arg1: u128) -> u128;
}
extern "C" {
    pub fn hypotf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn hypot(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn hypotl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn powf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn pow(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn powl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn sqrtf(arg1: f32) -> f32;
}
extern "C" {
    pub fn sqrt(arg1: f64) -> f64;
}
extern "C" {
    pub fn sqrtl(arg1: u128) -> u128;
}
extern "C" {
    pub fn erff(arg1: f32) -> f32;
}
extern "C" {
    pub fn erf(arg1: f64) -> f64;
}
extern "C" {
    pub fn erfl(arg1: u128) -> u128;
}
extern "C" {
    pub fn erfcf(arg1: f32) -> f32;
}
extern "C" {
    pub fn erfc(arg1: f64) -> f64;
}
extern "C" {
    pub fn erfcl(arg1: u128) -> u128;
}
extern "C" {
    pub fn lgammaf(arg1: f32) -> f32;
}
extern "C" {
    pub fn lgamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn lgammal(arg1: u128) -> u128;
}
extern "C" {
    pub fn tgammaf(arg1: f32) -> f32;
}
extern "C" {
    pub fn tgamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn tgammal(arg1: u128) -> u128;
}
extern "C" {
    pub fn ceilf(arg1: f32) -> f32;
}
extern "C" {
    pub fn ceil(arg1: f64) -> f64;
}
extern "C" {
    pub fn ceill(arg1: u128) -> u128;
}
extern "C" {
    pub fn floorf(arg1: f32) -> f32;
}
extern "C" {
    pub fn floor(arg1: f64) -> f64;
}
extern "C" {
    pub fn floorl(arg1: u128) -> u128;
}
extern "C" {
    pub fn nearbyintf(arg1: f32) -> f32;
}
extern "C" {
    pub fn nearbyint(arg1: f64) -> f64;
}
extern "C" {
    pub fn nearbyintl(arg1: u128) -> u128;
}
extern "C" {
    pub fn rintf(arg1: f32) -> f32;
}
extern "C" {
    pub fn rint(arg1: f64) -> f64;
}
extern "C" {
    pub fn rintl(arg1: u128) -> u128;
}
extern "C" {
    pub fn lrintf(arg1: f32) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lrint(arg1: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lrintl(arg1: u128) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn roundf(arg1: f32) -> f32;
}
extern "C" {
    pub fn round(arg1: f64) -> f64;
}
extern "C" {
    pub fn roundl(arg1: u128) -> u128;
}
extern "C" {
    pub fn lroundf(arg1: f32) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lround(arg1: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lroundl(arg1: u128) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llrintf(arg1: f32) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llrint(arg1: f64) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llrintl(arg1: u128) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llroundf(arg1: f32) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llround(arg1: f64) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llroundl(arg1: u128) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn truncf(arg1: f32) -> f32;
}
extern "C" {
    pub fn trunc(arg1: f64) -> f64;
}
extern "C" {
    pub fn truncl(arg1: u128) -> u128;
}
extern "C" {
    pub fn fmodf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn fmod(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn fmodl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn remainderf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn remainder(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn remainderl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn remquof(arg1: f32, arg2: f32, arg3: *mut ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn remquo(arg1: f64, arg2: f64, arg3: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn remquol(arg1: u128, arg2: u128, arg3: *mut ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn copysignf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn copysign(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn copysignl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn nanf(arg1: *const ::std::os::raw::c_char) -> f32;
}
extern "C" {
    pub fn nan(arg1: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn nanl(arg1: *const ::std::os::raw::c_char) -> u128;
}
extern "C" {
    pub fn nextafterf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn nextafter(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn nextafterl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn nexttoward(arg1: f64, arg2: u128) -> f64;
}
extern "C" {
    pub fn nexttowardf(arg1: f32, arg2: u128) -> f32;
}
extern "C" {
    pub fn nexttowardl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn fdimf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn fdim(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn fdiml(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn fmaxf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn fmax(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn fmaxl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn fminf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn fmin(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn fminl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn fmaf(arg1: f32, arg2: f32, arg3: f32) -> f32;
}
extern "C" {
    pub fn fma(arg1: f64, arg2: f64, arg3: f64) -> f64;
}
extern "C" {
    pub fn fmal(arg1: u128, arg2: u128, arg3: u128) -> u128;
}
extern "C" {
    pub fn __inff() -> f32;
}
extern "C" {
    pub fn __inf() -> f64;
}
extern "C" {
    pub fn __infl() -> u128;
}
extern "C" {
    pub fn __nan() -> f32;
}
extern "C" {
    pub fn __exp10f(arg1: f32) -> f32;
}
extern "C" {
    pub fn __exp10(arg1: f64) -> f64;
}
extern "C" {
    pub fn __cospif(arg1: f32) -> f32;
}
extern "C" {
    pub fn __cospi(arg1: f64) -> f64;
}
extern "C" {
    pub fn __sinpif(arg1: f32) -> f32;
}
extern "C" {
    pub fn __sinpi(arg1: f64) -> f64;
}
extern "C" {
    pub fn __tanpif(arg1: f32) -> f32;
}
extern "C" {
    pub fn __tanpi(arg1: f64) -> f64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __float2 {
    pub __sinval: f32,
    pub __cosval: f32,
}
#[test]
fn bindgen_test_layout___float2() {
    assert_eq!(
        ::std::mem::size_of::<__float2>(),
        8usize,
        concat!("Size of: ", stringify!(__float2))
    );
    assert_eq!(
        ::std::mem::align_of::<__float2>(),
        4usize,
        concat!("Alignment of ", stringify!(__float2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__float2>())).__sinval as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__float2),
            "::",
            stringify!(__sinval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__float2>())).__cosval as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__float2),
            "::",
            stringify!(__cosval)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __double2 {
    pub __sinval: f64,
    pub __cosval: f64,
}
#[test]
fn bindgen_test_layout___double2() {
    assert_eq!(
        ::std::mem::size_of::<__double2>(),
        16usize,
        concat!("Size of: ", stringify!(__double2))
    );
    assert_eq!(
        ::std::mem::align_of::<__double2>(),
        8usize,
        concat!("Alignment of ", stringify!(__double2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__double2>())).__sinval as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__double2),
            "::",
            stringify!(__sinval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__double2>())).__cosval as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__double2),
            "::",
            stringify!(__cosval)
        )
    );
}
extern "C" {
    pub fn __sincosf_stret(arg1: f32) -> __float2;
}
extern "C" {
    pub fn __sincos_stret(arg1: f64) -> __double2;
}
extern "C" {
    pub fn __sincospif_stret(arg1: f32) -> __float2;
}
extern "C" {
    pub fn __sincospi_stret(arg1: f64) -> __double2;
}
extern "C" {
    pub fn j0(arg1: f64) -> f64;
}
extern "C" {
    pub fn j1(arg1: f64) -> f64;
}
extern "C" {
    pub fn jn(arg1: ::std::os::raw::c_int, arg2: f64) -> f64;
}
extern "C" {
    pub fn y0(arg1: f64) -> f64;
}
extern "C" {
    pub fn y1(arg1: f64) -> f64;
}
extern "C" {
    pub fn yn(arg1: ::std::os::raw::c_int, arg2: f64) -> f64;
}
extern "C" {
    pub fn scalb(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub static mut signgam: ::std::os::raw::c_int;
}
extern "C" {
    pub fn rinttol(arg1: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn roundtol(arg1: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn drem(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn finite(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn significand(arg1: f64) -> f64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct exception {
    pub type_: ::std::os::raw::c_int,
    pub name: *mut ::std::os::raw::c_char,
    pub arg1: f64,
    pub arg2: f64,
    pub retval: f64,
}
#[test]
fn bindgen_test_layout_exception() {
    assert_eq!(
        ::std::mem::size_of::<exception>(),
        40usize,
        concat!("Size of: ", stringify!(exception))
    );
    assert_eq!(
        ::std::mem::align_of::<exception>(),
        8usize,
        concat!("Alignment of ", stringify!(exception))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<exception>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(exception),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<exception>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(exception),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<exception>())).arg1 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(exception),
            "::",
            stringify!(arg1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<exception>())).arg2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(exception),
            "::",
            stringify!(arg2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<exception>())).retval as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(exception),
            "::",
            stringify!(retval)
        )
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GuiPropertyElement {
    BORDER = 0,
    BASE = 1,
    TEXT = 2,
    OTHER = 3,
}
extern "C" {
    pub static mut guiState: GuiControlState;
}
extern "C" {
    pub static mut guiFont: Font;
}
pub const guiLocked: bool = false;
pub const guiAlpha: f32 = 1.0;
extern "C" {
    pub static mut guiStyle: [::std::os::raw::c_uint; 384usize];
}
pub const guiStyleLoaded: bool = false;
extern "C" {
    pub static mut guiTooltip: *const ::std::os::raw::c_char;
}
pub const guiTooltipEnabled: bool = true;
extern "C" {
    pub fn GuiSliderPro(
        bounds: Rectangle,
        textLeft: *const ::std::os::raw::c_char,
        textRight: *const ::std::os::raw::c_char,
        value: f32,
        minValue: f32,
        maxValue: f32,
        sliderWidth: ::std::os::raw::c_int,
    ) -> f32;
}
extern "C" {
    pub fn GuiColorPanelEx(bounds: Rectangle, color: Color, hue: f32) -> Color;
}
extern "C" {
    pub fn GuiLoadIcons(
        fileName: *const ::std::os::raw::c_char,
        loadIconsName: bool,
    ) -> *mut *mut ::std::os::raw::c_char;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        concat!("Size of: ", stringify!(__va_list_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).gp_offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(gp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).fp_offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).overflow_arg_area as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(overflow_arg_area)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).reg_save_area as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(reg_save_area)
        )
    );
}
