use rasn::prelude::*;
use rasn_kerberos::*;

use pretty_assertions::assert_eq;

const _: () = assert!(AsReq::TAG.const_eq(&Tag::new(Class::Application, 10)));

#[test]
fn as_req() {
    let as_req = AsReq(KdcReq {
        pvno: Integer::from(5),
        msg_type: Integer::from(10),
        padata: Some(vec![PaData {
            r#type: 128,
            value: OctetString::from_static(&[0x30, 0x05, 0xa0, 0x03, 0x01, 0x01, 0xff]),
        }]),
        req_body: KdcReqBody {
            kdc_options: KdcOptions(KerberosFlags::from_slice(&[0x40, 0x81, 0x00, 0x10])),
            cname: Some(PrincipalName {
                r#type: 1,
                string: vec![KerberosString::new(String::from("user"))],
            }),
            realm: KerberosString::new("COMPANY.INT".to_string()),
            sname: Some(PrincipalName {
                r#type: 2,
                string: vec![
                    KerberosString::new(String::from("krbtgt")),
                    KerberosString::new(String::from("COMPANY.INT")),
                ],
            }),
            from: None,
            till: KerberosTime(
                GeneralizedTime::parse_from_rfc3339("1970-01-01T00:00:00Z").unwrap(),
            ),
            rtime: Some(KerberosTime(
                GeneralizedTime::parse_from_rfc3339("2052-03-04T11:11:11Z").unwrap(),
            )),
            nonce: 12345678,
            etype: vec![18, 23, -133, -128, 24, -135],
            addresses: Some(vec![HostAddress {
                addr_type: 20,
                address: OctetString::from("CLIENT01        "),
            }]),
            enc_authorization_data: None,
            additional_tickets: None,
        },
    });

    let data: &[u8] = &[
        0x6a, 0x81, 0xdc, 0x30, 0x81, 0xd9, 0xa1, 0x03, 0x02, 0x01, 0x05, 0xa2, 0x03, 0x02, 0x01,
        0x0a, 0xa3, 0x15, 0x30, 0x13, 0x30, 0x11, 0xa1, 0x04, 0x02, 0x02, 0x00, 0x80, 0xa2, 0x09,
        0x04, 0x07, 0x30, 0x05, 0xa0, 0x03, 0x01, 0x01, 0xff, 0xa4, 0x81, 0xb5, 0x30, 0x81, 0xb2,
        0xa0, 0x07, 0x03, 0x05, 0x00, 0x40, 0x81, 0x00, 0x10, 0xa1, 0x11, 0x30, 0x0f, 0xa0, 0x03,
        0x02, 0x01, 0x01, 0xa1, 0x08, 0x30, 0x06, 0x1b, 0x04, 0x75, 0x73, 0x65, 0x72, 0xa2, 0x0d,
        0x1b, 0x0b, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x4e, 0x59, 0x2e, 0x49, 0x4e, 0x54, 0xa3, 0x20,
        0x30, 0x1e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0xa1, 0x17, 0x30, 0x15, 0x1b, 0x06, 0x6b, 0x72,
        0x62, 0x74, 0x67, 0x74, 0x1b, 0x0b, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x4e, 0x59, 0x2e, 0x49,
        0x4e, 0x54, 0xa5, 0x11, 0x18, 0x0f, 0x31, 0x39, 0x37, 0x30, 0x30, 0x31, 0x30, 0x31, 0x30,
        0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0xa6, 0x11, 0x18, 0x0f, 0x32, 0x30, 0x35, 0x32, 0x30,
        0x33, 0x30, 0x34, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x5a, 0xa7, 0x06, 0x02, 0x04, 0x00,
        0xbc, 0x61, 0x4e, 0xa8, 0x16, 0x30, 0x14, 0x02, 0x01, 0x12, 0x02, 0x01, 0x17, 0x02, 0x02,
        0xff, 0x7b, 0x02, 0x01, 0x80, 0x02, 0x01, 0x18, 0x02, 0x02, 0xff, 0x79, 0xa9, 0x1d, 0x30,
        0x1b, 0x30, 0x19, 0xa0, 0x03, 0x02, 0x01, 0x14, 0xa1, 0x12, 0x04, 0x10, 0x43, 0x4c, 0x49,
        0x45, 0x4e, 0x54, 0x30, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    ];

    let enc = rasn::der::encode(&as_req).unwrap();
    assert_eq!(data, enc);
    assert_eq!(as_req, rasn::der::decode(&enc).unwrap());
}
