extern crate alloc;
mod scanner;
pub mod token;
pub use scanner::*;

#[cfg(test)]
mod tests {
    use crate::scanner;
    use std::vec;

    #[test]
    fn tokens() {
        use crate::token::Token;
        let input: String = "( ) { } , . - + ; * ! < > / = <= >= != ==".into();
        let mut scanner = scanner::Scanner::from(&input);
        let result = scanner.scan_all();
        let expected_result = vec![
            Token::LeftParen,
            Token::RightParen,
            Token::LeftBrace,
            Token::RightBrace,
            Token::Comma,
            Token::Dot,
            Token::Minus,
            Token::Plus,
            Token::Semicolon,
            Token::Star,
            Token::Bang,
            Token::Less,
            Token::Greater,
            Token::Slash,
            Token::Equal,
            Token::LessEqual,
            Token::GreaterEqual,
            Token::BangEqual,
            Token::EqualEqual,
        ];
        assert!(result.unwrap() == expected_result);
    }

    #[test]
    fn keywords() {
        use crate::token::Token;
        let input: String =
            "and class else false fun for if nil or print return super this true var while".into();
        let mut scanner = scanner::Scanner::from(&input);
        let result = scanner.scan_all();
        let expected_result = vec![
            Token::And,
            Token::Class,
            Token::Else,
            Token::False,
            Token::Fun,
            Token::For,
            Token::If,
            Token::Nil,
            Token::Or,
            Token::Print,
            Token::Return,
            Token::Super,
            Token::This,
            Token::True,
            Token::Var,
            Token::While,
        ];
        assert!(result.unwrap() == expected_result);
    }
}
