# Example:

```rust
let mut args = ArgParser::new("rargsxd_example");
args.info("A test example for rargsxd")
	.author("BubbyRoosh")
	.version("0.1.0")
	.copyright("Copyright (C) 2021 BubbyRoosh")
	.args(
	vec!(
		Arg::bool("uwu", false)
			.short('u')
			.help("UwU"),
		Arg::str("owo", "monke")
			.short('o')
			.help("OwO"),
	)
).parse();
println!("{}", args.get_str("owo"));
println!("{}", args.get_bool("uwu"));
println!("{:?}", args.extra);
```

Assuming the args passed are: -ou word another word

It would output:
```
word
true
["another", "word"]
```
