pub(self) use ball_position_constraint::{BallPositionConstraint, BallPositionGroundConstraint};
#[cfg(feature = "simd-is-enabled")]
pub(self) use ball_position_constraint_wide::{
    WBallPositionConstraint, WBallPositionGroundConstraint,
};
pub(self) use ball_velocity_constraint::{BallVelocityConstraint, BallVelocityGroundConstraint};
#[cfg(feature = "simd-is-enabled")]
pub(self) use ball_velocity_constraint_wide::{
    WBallVelocityConstraint, WBallVelocityGroundConstraint,
};
pub(self) use fixed_position_constraint::{FixedPositionConstraint, FixedPositionGroundConstraint};
#[cfg(feature = "simd-is-enabled")]
pub(self) use fixed_position_constraint_wide::{
    WFixedPositionConstraint, WFixedPositionGroundConstraint,
};
pub(self) use fixed_velocity_constraint::{FixedVelocityConstraint, FixedVelocityGroundConstraint};
#[cfg(feature = "simd-is-enabled")]
pub(self) use fixed_velocity_constraint_wide::{
    WFixedVelocityConstraint, WFixedVelocityGroundConstraint,
};
// pub(self) use generic_position_constraint::{
//     GenericPositionConstraint, GenericPositionGroundConstraint,
// };
// #[cfg(feature = "simd-is-enabled")]
// pub(self) use generic_position_constraint_wide::{
//     WGenericPositionConstraint, WGenericPositionGroundConstraint,
// };
// pub(self) use generic_velocity_constraint::{
//     GenericVelocityConstraint, GenericVelocityGroundConstraint,
// };
// #[cfg(feature = "simd-is-enabled")]
// pub(self) use generic_velocity_constraint_wide::{
//     WGenericVelocityConstraint, WGenericVelocityGroundConstraint,
// };

pub(crate) use joint_constraint::AnyJointVelocityConstraint;
pub(crate) use joint_position_constraint::AnyJointPositionConstraint;
pub(self) use prismatic_position_constraint::{
    PrismaticPositionConstraint, PrismaticPositionGroundConstraint,
};
#[cfg(feature = "simd-is-enabled")]
pub(self) use prismatic_position_constraint_wide::{
    WPrismaticPositionConstraint, WPrismaticPositionGroundConstraint,
};
pub(self) use prismatic_velocity_constraint::{
    PrismaticVelocityConstraint, PrismaticVelocityGroundConstraint,
};
#[cfg(feature = "simd-is-enabled")]
pub(self) use prismatic_velocity_constraint_wide::{
    WPrismaticVelocityConstraint, WPrismaticVelocityGroundConstraint,
};
#[cfg(feature = "dim3")]
pub(self) use revolute_position_constraint::{
    RevolutePositionConstraint, RevolutePositionGroundConstraint,
};
#[cfg(all(feature = "dim3", feature = "simd-is-enabled"))]
pub(self) use revolute_position_constraint_wide::{
    WRevolutePositionConstraint, WRevolutePositionGroundConstraint,
};
#[cfg(feature = "dim3")]
pub(self) use revolute_velocity_constraint::{
    RevoluteVelocityConstraint, RevoluteVelocityGroundConstraint,
};
#[cfg(all(feature = "dim3", feature = "simd-is-enabled"))]
pub(self) use revolute_velocity_constraint_wide::{
    WRevoluteVelocityConstraint, WRevoluteVelocityGroundConstraint,
};

mod ball_position_constraint;
#[cfg(feature = "simd-is-enabled")]
mod ball_position_constraint_wide;
mod ball_velocity_constraint;
#[cfg(feature = "simd-is-enabled")]
mod ball_velocity_constraint_wide;
mod fixed_position_constraint;
#[cfg(feature = "simd-is-enabled")]
mod fixed_position_constraint_wide;
mod fixed_velocity_constraint;
#[cfg(feature = "simd-is-enabled")]
mod fixed_velocity_constraint_wide;
// mod generic_position_constraint;
// #[cfg(feature = "simd-is-enabled")]
// mod generic_position_constraint_wide;
// mod generic_velocity_constraint;
// #[cfg(feature = "simd-is-enabled")]
// mod generic_velocity_constraint_wide;
mod joint_constraint;
mod joint_position_constraint;
mod prismatic_position_constraint;
#[cfg(feature = "simd-is-enabled")]
mod prismatic_position_constraint_wide;
mod prismatic_velocity_constraint;
#[cfg(feature = "simd-is-enabled")]
mod prismatic_velocity_constraint_wide;
#[cfg(feature = "dim3")]
mod revolute_position_constraint;
#[cfg(all(feature = "dim3", feature = "simd-is-enabled"))]
mod revolute_position_constraint_wide;
#[cfg(feature = "dim3")]
mod revolute_velocity_constraint;
#[cfg(all(feature = "dim3", feature = "simd-is-enabled"))]
mod revolute_velocity_constraint_wide;
